<?php
/**
 * Kkart Admin Import Template Class
 *
 * @package Kkart\Admin
 */

defined( 'ABSPATH' ) || exit;

/**
 * KKART_Admin_Import_Template.
 */
class KKART_Admin_Import_Template {

	/**
	 * Initialize the webhooks admin actions.
	 */
	public function __construct() {
		
	}
	
	public static function import_template_view(){
		global $pagelayer;
		
		$fields = json_decode(self::get_conf(), true);
		$content = self::get_content();
		
		if ( isset( $_REQUEST['import_template'] ) ) {
			
			$error = kkart_import_pages_default_content($fields, $content, $_POST);
			
			$message = (!empty($error) ? '<div class="error">'.implode($error, ',').'</div>' : '<div class="updated">Templates/Pages Imported Successfully</div>');
		}
		
		// Hide the save button.
		$GLOBALS['hide_save_button'] = true;
		
		echo '<script type="text/javascript">
			jQuery(function(){

				// add multiple select / deselect functionality
				jQuery(".kkart_checkall").click(function () {
					  jQuery(".kkart_check").attr("checked", this.checked);
				});

				// if all checkbox are selected, check the selectall checkbox
				// and viceversa
				jQuery(".kkart_check").click(function(){

					if(jQuery(".kkart_check").length == $(".kkart_check:checked").length) {
						jQuery(".kkart_checkall").attr("checked", "checked");
					} else {
						jQuery(".kkart_checkall").removeAttr("checked");
					}

				});
			});
		</script>
		<form id="import_template_form" method="post" action="'.esc_url( admin_url( 'admin.php?page=kkart-settings&tab=advanced&section=import_template' ) ).'">
		<table class="form-table">
			<tbody>
				<tr class="" valign="top">
					<td colspan="2">'.$message.'</td>
				</tr>
				<tr class="" valign="top">
					<th scope="row" class="titledesc">'. __('Select / Deselect All') .'</th>
					<td class="forminp forminp-checkbox">
						<fieldset>
							<label>
								<input type="checkbox" class="kkart_checkall" checked="checked">
							</label>
						</fieldset>
					</td>
				</tr>';
			if(!empty($fields)){
				foreach($fields as $fk => $fv){
					echo '<tr class="" valign="top">
					<th scope="row" class="titledesc">'.$fv['title'].'</th>
					<td class="forminp forminp-checkbox">
						<fieldset>
							<label for="'.$fk.'">
								<input type="checkbox" name="'.$fk.'" class="kkart_check" checked="checked">
							</label>
						</fieldset>
					</td>
				</tr>';
			}
		}
		echo '</tbody>
		</table>
		<button name="import_template" class="button-primary kkart-save-button" type="submit" value="Import Template">Import Template</button>
		</form>';
	}
	
	public static function get_conf(){
		global $pagelayer;
		
		$conf = '{
			"single-template": {
				"post_type": "'.$pagelayer->builder['name'].'",
				"type": "single",
				"title": "Single Product",
				"conditions": [
					{
						"type": "include",
						"template": "singular",
						"sub_template": "product",
						"id": ""
					}
				]
			},
			"archive-template": {
				"post_type": "'.$pagelayer->builder['name'].'",
				"type": "archive",
				"title": "Product Archive",
				"conditions": [
					{
						"type": "include",
						"template": "archives",
						"sub_template": "product",
						"id": ""
					}
				]
			},
			"cart": {
				"post_type": "page",
				"title": "Cart"
			},
			"checkout": {
				"post_type": "page",
				"title": "Checkout"
			},
			"myaccount": {
				"post_type": "page",
				"title": "My account"
			},
			"order_pay": {
				"post_type": "page",
				"title": "Order Pay",
				"parent": "checkout"
			},
			"order_received": {
				"post_type": "page",
				"title": "Order Received",
				"parent": "checkout"
			}
		}';
		
		return $conf;
	}
	
	public static function get_content(){
		
		$content['cart'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"TeNMIn3gRsvsyDZj"} -->
<!-- sp:pagelayer/pl_col {"overlay_hover_delay":"400","col":"12","pagelayer-id":"qyP2XV3ClSd9cEWM"} -->
<!-- sp:pagelayer/pl_post_title {"title_color":"","typo":",35,,700,,,solid,,,,","align":"center","pagelayer-id":"nNt87422AXwZoBQg"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->
<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"afr9334"} -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","col_width":"66.49","pagelayer-id":"a2f7572"} -->
<!-- sp:pagelayer/pl_kkart_cart_items {"pagelayer-id":"pbi6002"} -->
<!-- sp:pagelayer/pl_inner_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"lun6536"} -->
<!-- sp:pagelayer/pl_inner_col {"widget_space":"15","overlay_hover_delay":"400","col_width":"23.79","col_width_mobile":"35.86","pagelayer-id":"rd63503"} -->
<!-- sp:pagelayer/pl_kkart_archive_thumb {"arrows_bg":"#6a6969","arraow_color":"#ffffff","arraow_bg_size":"20","arraow_bg_shape":"20","pagelayer-id":"nyp2009"} /-->
<!-- /sp:pagelayer/pl_inner_col -->
<!-- sp:pagelayer/pl_inner_col {"widget_space":"9","overlay_hover_delay":"400","col_width":"76.21","col_width_mobile":"64.14","pagelayer-id":"chd6589"} -->
<!-- sp:pagelayer/pl_kkart_title {"color":"#0986c0","typo":",20,,700,,,Solid,,,,","color_hover":"#0986c0","pagelayer-id":"smy2668"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"price_type":"product_sub_total","title":"Price","title_hide":"true","pagelayer-id":"uw76904"} /-->
<!-- sp:pagelayer/pl_kkart_cart_item_quantity {"button_width":"25","quantity_border_color":"#efefef","pagelayer-id":"ds24850"} /-->
<!-- sp:pagelayer/pl_kkart_cart_update {"text":"Update Cart","ele_custom_pos":"true","ele_width":"initial","pagelayer-id":"pg69982"} /-->
<!-- sp:pagelayer/pl_kkart_cart_item_remove {"icon":"fas fa-trash-alt","ele_custom_pos":"true","ele_width":"initial","pagelayer-id":"zvr5717"} /-->
<!-- /sp:pagelayer/pl_inner_col -->
<!-- /sp:pagelayer/pl_inner_row -->
<!-- /sp:pagelayer/pl_kkart_cart_items -->
<!-- /sp:pagelayer/pl_col -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","col_width":"33.51","col_width_mobile":"100","pagelayer-id":"fe41283"} -->
<!-- sp:pagelayer/pl_kkart_cart_price_holder {"checkout_btn_width":"100","ele_align":"margin","ele_height":"auto","ele_sticky_on":"desktop,tablet","ele_sticky_in_col":"true","pagelayer-id":"ihq654"} -->
<!-- sp:pagelayer/pl_kkart_cart_price {"price_type":"sub_total","title":"Sub Total","pagelayer-id":"lg87178"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"price_type":"all_items_total","title":"Items Total","pagelayer-id":"edz4897"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"price_type":"delivery_charges","title":"Delivery Charges","pagelayer-id":"gik491"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"price_type":"discount","title":"Discount","pagelayer-id":"knr4123"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"price_type":"grand_total","title":"Grand Total","pagelayer-id":"tj9745"} /-->
<!-- /sp:pagelayer/pl_kkart_cart_price_holder -->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->';
			
		$content['checkout'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"TeNMIn3gRsvsyDZj"} -->
<!-- sp:pagelayer/pl_col {"overlay_hover_delay":"400","pagelayer-id":"qyP2XV3ClSd9cEWM"} -->
<!-- sp:pagelayer/pl_post_title {"title_color":"","typo":",35,,700,,,solid,,,,","align":"center","pagelayer-id":"nNt87422AXwZoBQg"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->
<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"mag4348"} -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","col_width":"70.02","pagelayer-id":"6n8151"} -->
<!-- sp:pagelayer/pl_kkart_checkout_form {"active_tab_bgcolor":"#000000","active_tab_text":"#FFFFFF","inactive_tab":"#cccccc","inactive_tab_text":"#000000","billing_here":"Use This","billing_edit":"Edit","billing_delete":"Delete","add_addre_text":"+ Add New Address","add_font_weight":"normal","save_addre_text":"Save","cancel_addre_text":"Cancel","pagelayer-id":"mnu7810"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","col_width":"29.98","pagelayer-id":"tcx8358"} -->
<!-- sp:pagelayer/pl_kkart_cart_price_holder {"checkout_btn_width":"100","hide_checkout":"true","pagelayer-id":"gcs6413"} -->
<!-- sp:pagelayer/pl_kkart_cart_price {"title":"Sub Total","price_type":"sub_total","pagelayer-id":"m625039"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"title":"Items Total","price_type":"all_items_total","pagelayer-id":"hwf463"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"title":"Delivery Charges","price_type":"delivery_charges","pagelayer-id":"21s3036"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"title":"Discount","price_type":"discount","pagelayer-id":"nsp484"} /-->
<!-- sp:pagelayer/pl_kkart_cart_price {"title":"Grand Total","price_type":"grand_total","pagelayer-id":"bad7154"} /-->
<!-- /sp:pagelayer/pl_kkart_cart_price_holder -->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->';
			
		$content['myaccount'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","ele_margin":"80px,0px,80px,0px","pagelayer-id":"TeNMIn3gRsvsyDZj"} -->
<!-- sp:pagelayer/pl_col {"overlay_hover_delay":"400","pagelayer-id":"qyP2XV3ClSd9cEWM"} -->
<!-- sp:pagelayer/pl_kkart_myaccount_tabs {"vertical":"true","tabs_holder_bg_color":"#f1f1f1","tabs_border_type":"solid","tabs_holder_align":"left","tabs_color":"#888888ff","tabs_bg_color":"#ffffffff","tabs_active_color":"#222222ff","tabs_active_bg_color":"#f9f9f9ff","tabs_icon_align":"left","tabs_icon_spacing":"10","tabs_content_color":"#333333ff","tabs_content_bg_color":"#f9f9f9ff","tab_padding":"35","vertical_width":"21","tabs_border_color":"#eeeeeeff","tabs_holder_border_width":"1,1,1,0","tabs_holder_border_radius":"1,1,1,1","tabs_content_border_width":"1,1,1,1","myaccount_border_type":"solid","myaccount_border_color":"#eeeeeeff","myaccount_border_width":"0,0,0,0","myaccount_border_radius":"0,0,0,0","tab_title_typo":"Roboto Condensed,14,,400,,,Solid,,Uppercase,,","tabs_content_typo":"Roboto,14,Normal,normal,Normal,,Solid,,,,","vertical_width_mobile":"30","tab_title_typo_mobile":",12,,,,,Solid,,,,","tabs_content_typo_mobile":",12,,,,,Solid,,,,","tabs_content_typo_tablet":",12,,,,,Solid,,,,","tab_title_typo_tablet":",12,,,,,Solid,,,,","vertical_width_tablet":"30","pagelayer-id":"bvu392"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->';
		
		$content['order_pay'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"k3e287"} -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","pagelayer-id":"v063219"} -->
<!-- sp:pagelayer/pl_kkart_order_pay {"pay_btn_color":"#ffffffff","pay_btn_bgcolor":"#000000ff","pay_btn_border_type":"solid","pay_btn_border_width":"0,0,0,0","pay_btn_padding":"10,10,10,10","pagelayer-id":"6pw622"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->';
		
		$content['order_received'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"t0t1711"} -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","pagelayer-id":"zqb3491"} -->
<!-- sp:pagelayer/pl_kkart_order_info {"info_text":"\u003cp\u003e\u003cstrong\u003eThank you. Your order has been received.\u003c/strong\u003e\u003c/p\u003e\r\n\t\t\t\t\u003cp\u003eOrder number : \u003cstrong\u003e$order_number\u003c/strong\u003e\u003c/p\u003e\r\n\t\t\t\t\u003cp\u003eDate : \u003cstrong\u003e$order_date\u003c/strong\u003e\u003c/p\u003e\r\n\t\t\t\t\u003cp\u003eEmail : \u003cstrong\u003e$billing_email\u003c/strong\u003e\u003c/p\u003e\r\n\t\t\t\t\u003cp\u003eTotal : \u003cstrong\u003e$order_total\u003c/strong\u003e\u003c/p\u003e\r\n\t\t\t\t\u003cp if=\u0022$payment_method\u0022\u003ePayment method : \u003cstrong\u003e$payment_method\u003c/strong\u003e\u003c/p\u003e","align":"left","failed_text":"\u003cp\u003eUnfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.\u003c/p\u003e","order_not_found_txt":"Unfortunately your order is not found. Please attempt your purchase again.","typography":",,,,,,Solid,2,,,","editor_view":"not_found","failed_btn_bgcolor":"#060606ff","failed_btn_color":"#ffffffff","failed_btn_space":"10","pagelayer-id":"15u6161"} /-->
<!-- sp:pagelayer/pl_kkart_order_details {"order_title":"\u003ch2\u003eOrder details\u003c/h2\u003e","download_title":"\u003ch2\u003eDownloads\u003c/h2\u003e","pagelayer-id":"b8c9125"} /-->
<!-- sp:pagelayer/pl_kkart_order_address {"billing_title":"\u003ch2\u003eBilling Address\u003c/h2\u003e","shipping_title":"\u003ch2\u003eShipping Address\u003c/h2\u003e","pagelayer-id":"d6b9760"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->';
			
		$content['single-template'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","ele_margin":"40px,0px,40px,0px","pagelayer-id":"duGtpLrwHkOWbE0m"} -->
<!-- sp:pagelayer/pl_col {"overlay_hover_delay":"400","col_width":"41.85","pagelayer-id":"ad58IjV6dHjcRBmV"} -->
<!-- sp:pagelayer/pl_kkart_img_gallery {"size":"thumbnail","galign":"left","gposition":"bottom","gcolumns":"5","palign":"center","pagelayer-id":"85s5727"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","col_width":"58.15","pagelayer-id":"e0a9210"} -->
<!-- sp:pagelayer/pl_kkart_title {"color":"#0986c0","typo":",25,,700,,,solid,,,,","color_hover":"#0986c0","pagelayer-id":"wkh7273"} /-->
<!-- sp:pagelayer/pl_kkart_product_rating {"show_rating":"true","show_review_count":"true","show_review_brackets":"true","count_text":"customer review","pagelayer-id":"vwd9752"} /-->
<!-- sp:pagelayer/pl_kkart_price {"prices":"regular","rp_color":"#d2d2d2ff","sp_color":"#f2401fff","space":"5","pagelayer-id":"pku3026"} /-->
<!-- sp:pagelayer/pl_post_content {"pagelayer-id":"k7g6641"} /-->
<!-- sp:pagelayer/pl_kkart_add_to_cart {"cart_text":"Add To Cart","cart_icon_position":"kkart-cart-btn-icon-left","cart_icon_spacing":"5","show_quantity":"true","quantity_border_color":"#efefef","cart_type":"pagelayer-btn-default","cart_size":"pagelayer-btn-mini","btn_hover_delay":"400","quantity_layout":"inline-block","input_background_color":"#fff","input_text_color":"#000","button_width":"25","button_background_color":"#fff","button_text_color":"#000","btn_border_type":"solid","btn_border_color":"#42414f","btn_border_width":"0,0,0,0","ele_custom_pos":"true","ele_align":"margin","ele_height":"auto","ele_width":"initial","pagelayer-id":"4qi3429"} /-->
<!-- sp:pagelayer/pl_kkart_buy_now {"buy_now_text":"Buy Now","align":"left","type":"pagelayer-btn-default","btn_custom_size":"19","btn_bg_color":"#818a91","btn_color":"#ffffff","btn_hover_delay":"400","icon_spacing":"5","ele_custom_pos":"true","ele_align":"margin","ele_height":"auto","ele_width":"initial","size":"","btn_typo":",,,,,,Solid,1,,,","ele_margin":"1px,0px,0px,5px","btn_border_type":"solid","btn_border_color":"","btn_border_radius":"4,4,4,4","btn_border_width":"0,0,0,0","pagelayer-id":"y444690"} /-->
<!-- sp:pagelayer/pl_kkart_meta {"sku_label":"SKU","pagelayer-id":"ttq7148"} /-->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->';
			
		$content['archive-template'] = '<!-- sp:pagelayer/pl_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"mrw2904"} -->
<!-- sp:pagelayer/pl_col {"widget_space":"15","overlay_hover_delay":"400","pagelayer-id":"acu9557"} -->
<!-- sp:pagelayer/pl_archive_title {"align":"left","typo":",,,,,,Solid,,,,","ele_margin":"0px,0px,18px,0px","font_size":"28","pagelayer-id":"a6sL2H8c5FJDwHmL"} /-->
<!-- sp:pagelayer/pl_kkart_product_archives {"allow_order":"true","show_result":"true","no_found":"Products not found.","pagelayer-id":"jbo9446"} -->
<!-- sp:pagelayer/pl_kkart_archive_item {"pagelayer-id":"osi7561"} -->
<!-- sp:pagelayer/pl_inner_row {"stretch":"auto","col_gap":"10","width_content":"auto","row_height":"default","overlay_hover_delay":"400","row_shape_top_color":"#227bc3","row_shape_top_width":"100","row_shape_top_height":"100","row_shape_bottom_color":"#e44993","row_shape_bottom_width":"100","row_shape_bottom_height":"100","pagelayer-id":"7tp1765"} -->
<!-- sp:pagelayer/pl_inner_col {"widget_space":"15","overlay_hover_delay":"400","col":"12","pagelayer-id":"ute5229"} -->
<!-- sp:pagelayer/pl_kkart_sale {"show_discount":"true","sale_text":"off","sale_type":"kkart-onsale-circle","spacing":"2","sale_position":"right","pagelayer-id":"r4w7700"} /-->
<!-- sp:pagelayer/pl_kkart_archive_thumb {"arrows_bg":"#6a6969","arraow_color":"#ffffff","arraow_bg_size":"20","arraow_bg_shape":"20","box_heihgt":"13em","pagelayer-id":"vmf9323"} /-->
<!-- sp:pagelayer/pl_kkart_title {"color":"#0986c0","typo":",25,,700,,,solid,,,,","color_hover":"#0986c0","pagelayer-id":"a1c6643"} /-->
<!-- sp:pagelayer/pl_kkart_price {"prices":"regular","pagelayer-id":"1mc3860"} /-->
<!-- sp:pagelayer/pl_kkart_product_rating {"show_rating":"true","show_review_count":"true","show_review_brackets":"true","count_text":"customer review","pagelayer-id":"rqw4545"} /-->
<!-- sp:pagelayer/pl_kkart_archive_crt_btn {"archive_crt_btn_text":"Add To Cart","size":"pagelayer-btn-custom","btn_type":"pagelayer-btn-default","btn_hover_delay":"400","view_crt_btn_text":"View Cart","view_custom_size":"10","view_btn_hover_delay":"400","custom_size":"10","ele_margin":"5px,5px,0,0","ele_custom_pos":"true","ele_width":"initial","pagelayer-id":"5ws7362"} /-->
<!-- sp:pagelayer/pl_kkart_buy_now {"buy_now_text":"Buy Now","align":"left","type":"pagelayer-btn-default","btn_custom_size":"10","btn_bg_color":"#818a91","btn_color":"#ffffff","btn_hover_delay":"400","icon_spacing":"5","ele_margin":"5px,5px,0,0","ele_custom_pos":"true","ele_width":"initial","pagelayer-id":"yy96721"} /-->
<!-- /sp:pagelayer/pl_inner_col -->
<!-- /sp:pagelayer/pl_inner_row -->
<!-- /sp:pagelayer/pl_kkart_archive_item -->
<!-- /sp:pagelayer/pl_kkart_product_archives -->
<!-- /sp:pagelayer/pl_col -->
<!-- /sp:pagelayer/pl_row -->';
		
		return $content;
	}
}

return new KKART_Admin_Import_Template();