/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { KKART_BLOCKS_ASSET_URL } from '@kkart/block-settings';
import PropTypes from 'prop-types';

const BlockError = ( {
	imageUrl = `${ KKART_BLOCKS_ASSET_URL }img/block-error.svg`,
	header = __( 'Oops!', 'kkart' ),
	text = __(
		'There was an error loading the content.',
		'kkart'
	),
	errorMessage,
	errorMessagePrefix = __( 'Error:', 'kkart' ),
} ) => {
	return (
		<div className="kkart-block-error kkart-block-components-error">
			{ imageUrl && (
				<img
					className="kkart-block-error__image kkart-block-components-error__image"
					src={ imageUrl }
					alt=""
				/>
			) }
			<div className="kkart-block-error__content kkart-block-components-error__content">
				{ header && (
					<p className="kkart-block-error__header kkart-block-components-error__header">
						{ header }
					</p>
				) }
				{ text && (
					<p className="kkart-block-error__text kkart-block-components-error__text">
						{ text }
					</p>
				) }
				{ errorMessage && (
					<p className="kkart-block-error__message kkart-block-components-error__message">
						{ errorMessagePrefix ? errorMessagePrefix + ' ' : '' }
						{ errorMessage }
					</p>
				) }
			</div>
		</div>
	);
};

BlockError.propTypes = {
	/**
	 * Error message to display below the content.
	 */
	errorMessage: PropTypes.node,
	/**
	 * Text to display as the heading of the error block.
	 * If it's `null` or an empty string, no header will be displayed.
	 * If it's not defined, the default header will be used.
	 */
	header: PropTypes.string,
	/**
	 * URL of the image to display.
	 * If it's `null` or an empty string, no image will be displayed.
	 * If it's not defined, the default image will be used.
	 */
	imageUrl: PropTypes.string,
	/**
	 * Text to display in the error block below the header.
	 * If it's `null` or an empty string, nothing will be displayed.
	 * If it's not defined, the default text will be used.
	 */
	text: PropTypes.node,
	/**
	 * Text preceeding the error message.
	 */
	errorMessagePrefix: PropTypes.string,
};

export default BlockError;
