<?php
/**
 * Admin View: Notice - Untested extensions.
 *
 * @package Kkart\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$untested_plugins_msg = sprintf(
	/* translators: %s: version number */
	__( 'The following active plugin(s) have not declared compatibility with Kkart %s yet and should be updated and examined further before you proceed:', 'kkart' ),
	$new_version
);

?>
<div id="kkart_untested_extensions_modal">
	<div class="kkart_untested_extensions_modal--content">
		<h1><?php esc_html_e( "This is a major update, are you sure you're ready?", 'kkart' ); ?></h1>
		<div class="kkart_plugin_upgrade_notice extensions_warning">
			<p><?php echo esc_html( $untested_plugins_msg ); ?></p>

			<div class="plugin-details-table-container">
				<table class="plugin-details-table" cellspacing="0">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Plugin', 'kkart' ); ?></th>
							<th><?php esc_html_e( 'Tested up to Kkart version', 'kkart' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $plugins as $plugin ) : ?>
							<tr>
								<td><?php echo esc_html( $plugin['Name'] ); ?></td>
								<td><?php echo esc_html( $plugin['KKART tested up to'] ); ?></td>
							</tr>
						<?php endforeach ?>
					</tbody>
				</table>
			</div>

			<p><?php esc_html_e( 'As this is a major update, we strongly recommend creating a backup of your site before updating.', 'kkart' ); ?> <a href="https://kkart.com/2017/05/create-use-backups-kkart/" target="_blank"><?php esc_html_e( 'Learn more', 'kkart' ); ?></a></p>

			<?php if ( current_user_can( 'update_plugins' ) ) : ?>
				<div class="actions">
					<a href="#" class="button button-secondary cancel"><?php esc_html_e( 'Cancel', 'kkart' ); ?></a>
					<a class="button button-primary accept" href="#"><?php esc_html_e( 'Update now', 'kkart' ); ?></a>
				</div>
			<?php endif ?>
		</div>
	</div>
</div>
