<?php
/**
 * Kkart Admin Updates
 *
 * Functions for updating data, used by the background updater.
 *
 * @package Kkart\Admin
 */

use \Automattic\Kkart\Admin\Install as Installer;
use \Automattic\Kkart\Admin\Notes\Notes;
use \Automattic\Kkart\Admin\Notes\DeactivatePlugin;

/**
 * Update order stats `status` index length.
 * See: https://github.com/kkart/kkart-admin/issues/2969.
 */
function kkart_admin_update_0201_order_status_index() {
	global $wpdb;

	// Max DB index length. See wp_get_db_schema().
	$max_index_length = 191;

	$index = $wpdb->get_row( "SHOW INDEX FROM {$wpdb->prefix}kkart_order_stats WHERE key_name = 'status'" );

	if ( property_exists( $index, 'Sub_part' ) ) {
		// The index was created with the right length. Time to bail.
		if ( $max_index_length === $index->Sub_part ) { // phpcs:ignore WordPress.NamingConventions.ValidVariableName
			return;
		}

		// We need to drop the index so it can be recreated.
		$wpdb->query( "DROP INDEX `status` ON {$wpdb->prefix}kkart_order_stats" );
	}

	// Recreate the status index with a max length.
	$wpdb->query( $wpdb->prepare( "ALTER TABLE {$wpdb->prefix}kkart_order_stats ADD INDEX status (status(%d))", $max_index_length ) );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_0201_db_version() {
	Installer::update_db_version( '0.20.1' );
}

/**
 * Rename "gross_total" to "total_sales".
 * See: https://github.com/kkart/kkart-admin/issues/3175
 */
function kkart_admin_update_0230_rename_gross_total() {
	global $wpdb;

	// We first need to drop the new `total_sales` column, since dbDelta() will have created it.
	$wpdb->query( "ALTER TABLE {$wpdb->prefix}kkart_order_stats DROP COLUMN `total_sales`" );
	// Then we can rename the existing `gross_total` column.
	$wpdb->query( "ALTER TABLE {$wpdb->prefix}kkart_order_stats CHANGE COLUMN `gross_total` `total_sales` double DEFAULT 0 NOT NULL" );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_0230_db_version() {
	Installer::update_db_version( '0.23.0' );
}

/**
 * Remove the note unsnoozing scheduled action.
 */
function kkart_admin_update_0251_remove_unsnooze_action() {
	as_unschedule_action( Notes::UNSNOOZE_HOOK, null, 'kkart-admin-data' );
	as_unschedule_action( Notes::UNSNOOZE_HOOK, null, 'kkart-admin-notes' );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_0251_db_version() {
	Installer::update_db_version( '0.25.1' );
}

/**
 * Remove Facebook Extension note.
 */
function kkart_admin_update_110_remove_facebook_note() {
	Notes::delete_notes_with_name( 'kkart-admin-facebook-extension' );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_110_db_version() {
	Installer::update_db_version( '1.1.0' );
}

/**
 * Remove Dismiss action from tracking opt-in admin note.
 */
function kkart_admin_update_130_remove_dismiss_action_from_tracking_opt_in_note() {
	global $wpdb;

	$wpdb->query( "DELETE actions FROM {$wpdb->prefix}kkart_admin_note_actions actions INNER JOIN {$wpdb->prefix}kkart_admin_notes notes USING (note_id) WHERE actions.name = 'tracking-dismiss' AND notes.name = 'kkart-admin-usage-tracking-opt-in'" );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_130_db_version() {
	Installer::update_db_version( '1.3.0' );
}

/**
 * Change the deactivate plugin note type to 'info'.
 */
function kkart_admin_update_140_change_deactivate_plugin_note_type() {
	global $wpdb;

	$wpdb->query( $wpdb->prepare( "UPDATE {$wpdb->prefix}kkart_admin_notes SET type = 'info' WHERE name = %s", DeactivatePlugin::NOTE_NAME ) );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_140_db_version() {
	Installer::update_db_version( '1.4.0' );
}

/**
 * Remove Facebook Experts note.
 */
function kkart_admin_update_160_remove_facebook_note() {
	Notes::delete_notes_with_name( 'kkart-admin-facebook-marketing-expert' );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_160_db_version() {
	Installer::update_db_version( '1.6.0' );
}

/**
 * Set "two column" homescreen layout as default for existing stores.
 */
function kkart_admin_update_170_homescreen_layout() {
	add_option( 'kkart_default_homepage_layout', 'two_columns', '', 'no' );
}

/**
 * Update DB Version.
 */
function kkart_admin_update_170_db_version() {
	Installer::update_db_version( '1.7.0' );
}
