<?php
/**
 * Kkart Admin Navigation Feature Feedback Follow Up.
 */

namespace Automattic\Kkart\Admin\Notes;

use Automattic\Kkart\Admin\Loader;

defined( 'ABSPATH' ) || exit;

/**
 * NavigationFeedbackFollowUp
 */
class NavigationFeedbackFollowUp {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-navigation-feedback-follow-up';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		if ( ! Loader::is_feature_enabled( 'navigation' ) ) {
			return;
		}

		// Check that the first note was created.
		$data_store = \KKART_Data_Store::load( 'admin-note' );
		$note_ids   = $data_store->get_notes_with_name( 'kkart-admin-navigation-feedback' );
		if ( empty( $note_ids ) ) {
			return;
		}

		// Check that first note is at least 5 days old.
		$note      = Notes::get_note( $note_ids[0] );
		$timestamp = strtotime( $note->get_date_created() );
		if ( ( time() - $timestamp ) < DAY_IN_SECONDS * 5 ) {
			return;
		}

		$content = __( "We recently introduced the new navigation for a more intuitive and improved user experience. Now that you've had some time to give it a try, let us know how this will impact your store.", 'kkart' );

		$note = new Note();
		$note->set_title( __( 'Share your thoughts on the new Kkart navigation', 'kkart' ) );
		$note->set_content( $content );
		$note->set_content_data( (object) array() );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_INFORMATIONAL );
		$note->set_name( self::NOTE_NAME );
		$note->set_source( 'kkart-admin' );
		$note->add_action( 'share-feedback', __( 'Share feedback', 'kkart' ), 'https://automattic.survey.fm/new-navigation' );
		return $note;
	}
}
