/**
 * External dependencies
 */
import PropTypes from 'prop-types';
import { __ } from '@wordpress/i18n';
import classnames from 'classnames';
import Label from '@kkart/base-components/label';
import {
	useInnerBlockLayoutContext,
	useProductDataContext,
} from '@kkart/shared-context';
import { withProductDataContext } from '@kkart/shared-hocs';

/**
 * Internal dependencies
 */
import './style.scss';

/**
 * Product Sale Badge Block Component.
 *
 * @param {Object} props             Incoming props.
 * @param {string} [props.className] CSS Class name for the component.
 * @param {string} [props.align]     Alignment of the badge.
 * @return {*} The component.
 */
const Block = ( { className, align } ) => {
	const { parentClassName } = useInnerBlockLayoutContext();
	const { product } = useProductDataContext();

	if ( ! product.id || ! product.on_sale ) {
		return null;
	}

	const alignClass =
		typeof align === 'string'
			? `kkart-block-components-product-sale-badge--align-${ align }`
			: '';

	return (
		<div
			className={ classnames(
				'kkart-block-components-product-sale-badge',
				className,
				alignClass,
				{
					[ `${ parentClassName }__product-onsale` ]: parentClassName,
				}
			) }
		>
			<Label
				label={ __( 'Sale', 'kkart' ) }
				screenReaderLabel={ __(
					'Product on sale',
					'kkart'
				) }
			/>
		</div>
	);
};

Block.propTypes = {
	className: PropTypes.string,
	align: PropTypes.string,
};

export default withProductDataContext( Block );
