/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { useInnerBlockLayoutContext } from '@kkart/shared-context';
import { Icon, search } from '@kkart/icons';

const NoMatchingProducts = ( { resetCallback = () => {} } ) => {
	const { parentClassName } = useInnerBlockLayoutContext();
	return (
		<div className={ `${ parentClassName }__no-products` }>
			<Icon
				className={ `${ parentClassName }__no-products-image` }
				alt=""
				srcElement={ search }
				size={ 100 }
			/>
			<strong className={ `${ parentClassName }__no-products-title` }>
				{ __( 'No products found', 'kkart' ) }
			</strong>
			<p className={ `${ parentClassName }__no-products-description` }>
				{ __(
					'We were unable to find any results based on your search.',
					'kkart'
				) }
			</p>
			<button onClick={ resetCallback }>
				{ __( 'Reset Search', 'kkart' ) }
			</button>
		</div>
	);
};

export default NoMatchingProducts;
