/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import PropTypes from 'prop-types';
import SortSelect from '@kkart/base-components/sort-select';

/**
 * Internal dependencies
 */
import './style.scss';

const ProductSortSelect = ( { defaultValue, onChange, readOnly, value } ) => {
	return (
		<SortSelect
			className="kkart-block-product-sort-select kkart-block-components-product-sort-select"
			defaultValue={ defaultValue }
			name="orderby"
			onChange={ onChange }
			options={ [
				{
					key: 'menu_order',
					label: __(
						'Default sorting',
						'kkart'
					),
				},
				{
					key: 'popularity',
					label: __( 'Popularity', 'kkart' ),
				},
				{
					key: 'rating',
					label: __(
						'Average rating',
						'kkart'
					),
				},
				{
					key: 'date',
					label: __( 'Latest', 'kkart' ),
				},
				{
					key: 'price',
					label: __(
						'Price: low to high',
						'kkart'
					),
				},
				{
					key: 'price-desc',
					label: __(
						'Price: high to low',
						'kkart'
					),
				},
			] }
			readOnly={ readOnly }
			screenReaderLabel={ __(
				'Order products by',
				'kkart'
			) }
			value={ value }
		/>
	);
};

ProductSortSelect.propTypes = {
	defaultValue: PropTypes.oneOf( [
		'menu_order',
		'popularity',
		'rating',
		'date',
		'price',
		'price-desc',
	] ),
	onChange: PropTypes.func,
	readOnly: PropTypes.bool,
	value: PropTypes.oneOf( [
		'menu_order',
		'popularity',
		'rating',
		'date',
		'price',
		'price-desc',
	] ),
};

export default ProductSortSelect;
