/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { FormStep } from '@kkart/base-components/cart-checkout';
import { DebouncedValidatedTextInput } from '@kkart/base-components/text-input';
import { useCheckoutContext } from '@kkart/base-context';
import {
	CHECKOUT_ALLOWS_GUEST,
	CHECKOUT_ALLOWS_SIGNUP,
} from '@kkart/block-settings';
import CheckboxControl from '@kkart/base-components/checkbox-control';

/**
 * Internal dependencies
 */
import LoginPrompt from './login-prompt';
const ContactFieldsStep = ( {
	emailValue,
	onChangeEmail,
	allowCreateAccount,
} ) => {
	const {
		isProcessing: checkoutIsProcessing,
		customerId,
		shouldCreateAccount,
		setShouldCreateAccount,
	} = useCheckoutContext();

	const createAccountUI = ! customerId &&
		allowCreateAccount &&
		CHECKOUT_ALLOWS_GUEST &&
		CHECKOUT_ALLOWS_SIGNUP && (
			<CheckboxControl
				className="kkart-block-checkout__create-account"
				label={ __(
					'Create an account?',
					'kkart'
				) }
				checked={ shouldCreateAccount }
				onChange={ ( value ) => setShouldCreateAccount( value ) }
			/>
		);
	return (
		<FormStep
			id="contact-fields"
			disabled={ checkoutIsProcessing }
			className="kkart-block-checkout__contact-fields"
			title={ __(
				'Contact information',
				'kkart'
			) }
			description={ __(
				"We'll use this email to send you details and updates about your order.",
				'kkart'
			) }
			stepHeadingContent={ () => <LoginPrompt /> }
		>
			<DebouncedValidatedTextInput
				id="email"
				type="email"
				label={ __( 'Email address', 'kkart' ) }
				value={ emailValue }
				autoComplete="email"
				onChange={ onChangeEmail }
				required={ true }
			/>
			{ createAccountUI }
		</FormStep>
	);
};

export default ContactFieldsStep;
