/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { FormStep } from '@kkart/base-components/cart-checkout';
import CheckboxControl from '@kkart/base-components/checkbox-control';
import { useCheckoutContext } from '@kkart/base-context';
import PropTypes from 'prop-types';

const ShippingFieldsStep = ( {
	shippingAsBilling,
	setShippingAsBilling,
	children,
} ) => {
	const { isProcessing: checkoutIsProcessing } = useCheckoutContext();

	return (
		<FormStep
			id="shipping-fields"
			disabled={ checkoutIsProcessing }
			className="kkart-block-checkout__shipping-fields"
			title={ __( 'Shipping address', 'kkart' ) }
			description={ __(
				'Enter the physical address where you want us to deliver your order.',
				'kkart'
			) }
		>
			{ children }
			<CheckboxControl
				className="kkart-block-checkout__use-address-for-billing"
				label={ __(
					'Use same address for billing',
					'kkart'
				) }
				checked={ shippingAsBilling }
				onChange={ ( isChecked ) => setShippingAsBilling( isChecked ) }
			/>
		</FormStep>
	);
};

ShippingFieldsStep.propTypes = {
	shippingAsBilling: PropTypes.bool.isRequired,
	setShippingAsBilling: PropTypes.func.isRequired,
	children: PropTypes.node.isRequired,
};

export default ShippingFieldsStep;
