<?php
/**
 * Add payment method form form
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/form-add-payment-method.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 4.3.0
 */

defined( 'ABSPATH' ) || exit;

$available_gateways = KKART()->payment_gateways->get_available_payment_gateways();

if ( $available_gateways ) : ?>
	<form id="add_payment_method" method="post">
		<div id="payment" class="kkart-Payment">
			<ul class="kkart-PaymentMethods payment_methods methods">
				<?php
				// Chosen Method.
				if ( count( $available_gateways ) ) {
					current( $available_gateways )->set_current();
				}

				foreach ( $available_gateways as $gateway ) {
					?>
					<li class="kkart-PaymentMethod kkart-PaymentMethod--<?php echo esc_attr( $gateway->id ); ?> payment_method_<?php echo esc_attr( $gateway->id ); ?>">
						<input id="payment_method_<?php echo esc_attr( $gateway->id ); ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?> />
						<label for="payment_method_<?php echo esc_attr( $gateway->id ); ?>"><?php echo wp_kses_post( $gateway->get_title() ); ?> <?php echo wp_kses_post( $gateway->get_icon() ); ?></label>
						<?php
						if ( $gateway->has_fields() || $gateway->get_description() ) {
							echo '<div class="kkart-PaymentBox kkart-PaymentBox--' . esc_attr( $gateway->id ) . ' payment_box payment_method_' . esc_attr( $gateway->id ) . '" style="display: none;">';
							$gateway->payment_fields();
							echo '</div>';
						}
						?>
					</li>
					<?php
				}
				?>
			</ul>

			<?php do_action( 'kkart_add_payment_method_form_bottom' ); ?>

			<div class="form-row">
				<?php wp_nonce_field( 'kkart-add-payment-method', 'kkart-add-payment-method-nonce' ); ?>
				<button type="submit" class="kkart-Button kkart-Button--alt button alt" id="place_order" value="<?php esc_attr_e( 'Add payment method', 'kkart' ); ?>"><?php esc_html_e( 'Add payment method', 'kkart' ); ?></button>
				<input type="hidden" name="kkart_add_payment_method" id="kkart_add_payment_method" value="1" />
			</div>
		</div>
	</form>
<?php else : ?>
	<p class="kkart-notice kkart-notice--info kkart-info"><?php esc_html_e( 'New payment methods can only be added during checkout. Please contact us if you require assistance.', 'kkart' ); ?></p>
<?php endif; ?>
