<?php
/**
 * Lost password reset form.
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/form-reset-password.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 3.5.5
 */

defined( 'ABSPATH' ) || exit;

do_action( 'kkart_before_reset_password_form' );
?>

<form method="post" class="kkart-ResetPassword lost_reset_password">

	<p><?php echo apply_filters( 'kkart_reset_password_message', esc_html__( 'Enter a new password below.', 'kkart' ) ); ?></p><?php // @codingStandardsIgnoreLine ?>

	<p class="kkart-form-row kkart-form-row--first form-row form-row-first">
		<label for="password_1"><?php esc_html_e( 'New password', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="password" class="kkart-Input kkart-Input--text input-text" name="password_1" id="password_1" autocomplete="new-password" />
	</p>
	<p class="kkart-form-row kkart-form-row--last form-row form-row-last">
		<label for="password_2"><?php esc_html_e( 'Re-enter new password', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="password" class="kkart-Input kkart-Input--text input-text" name="password_2" id="password_2" autocomplete="new-password" />
	</p>

	<input type="hidden" name="reset_key" value="<?php echo esc_attr( $args['key'] ); ?>" />
	<input type="hidden" name="reset_login" value="<?php echo esc_attr( $args['login'] ); ?>" />

	<div class="clear"></div>

	<?php do_action( 'kkart_resetpassword_form' ); ?>

	<p class="kkart-form-row form-row">
		<input type="hidden" name="kkart_reset_password" value="true" />
		<button type="submit" class="kkart-Button button" value="<?php esc_attr_e( 'Save', 'kkart' ); ?>"><?php esc_html_e( 'Save', 'kkart' ); ?></button>
	</p>

	<?php wp_nonce_field( 'reset_password', 'kkart-reset-password-nonce' ); ?>

</form>
<?php
do_action( 'kkart_after_reset_password_form' );

