<?php
/**
 * Order details
 *
 * This template can be overridden by copying it to yourtheme/kkart/order/order-details.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 4.6.0
 */

defined( 'ABSPATH' ) || exit;

$order = kkart_get_order( $order_id ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited

if ( ! $order ) {
	return;
}

$order_items           = $order->get_items( apply_filters( 'kkart_purchase_order_item_types', 'line_item' ) );
$show_purchase_note    = $order->has_status( apply_filters( 'kkart_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
$show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();
$downloads             = $order->get_downloadable_items();
$show_downloads        = $order->has_downloadable_item() && $order->is_download_permitted();

if ( $show_downloads ) {
	kkart_get_template(
		'order/order-downloads.php',
		array(
			'downloads'  => $downloads,
			'show_title' => true,
		)
	);
}
?>
<section class="kkart-order-details">
	<?php do_action( 'kkart_order_details_before_order_table', $order ); ?>

	<h2 class="kkart-order-details__title"><?php esc_html_e( 'Order details', 'kkart' ); ?></h2>

	<table class="kkart-table kkart-table--order-details shop_table order_details">

		<thead>
			<tr>
				<th class="kkart-table__product-name product-name"><?php esc_html_e( 'Product', 'kkart' ); ?></th>
				<th class="kkart-table__product-table product-total"><?php esc_html_e( 'Total', 'kkart' ); ?></th>
			</tr>
		</thead>

		<tbody>
			<?php
			do_action( 'kkart_order_details_before_order_table_items', $order );

			foreach ( $order_items as $item_id => $item ) {
				$product = $item->get_product();

				kkart_get_template(
					'order/order-details-item.php',
					array(
						'order'              => $order,
						'item_id'            => $item_id,
						'item'               => $item,
						'show_purchase_note' => $show_purchase_note,
						'purchase_note'      => $product ? $product->get_purchase_note() : '',
						'product'            => $product,
					)
				);
			}

			do_action( 'kkart_order_details_after_order_table_items', $order );
			?>
		</tbody>

		<tfoot>
			<?php
			foreach ( $order->get_order_item_totals() as $key => $total ) {
				?>
					<tr>
						<th scope="row"><?php echo esc_html( $total['label'] ); ?></th>
						<td><?php echo ( 'payment_method' === $key ) ? esc_html( $total['value'] ) : wp_kses_post( $total['value'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>
					</tr>
					<?php
			}
			?>
			<?php if ( $order->get_customer_note() ) : ?>
				<tr>
					<th><?php esc_html_e( 'Note:', 'kkart' ); ?></th>
					<td><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
				</tr>
			<?php endif; ?>
		</tfoot>
	</table>

	<?php do_action( 'kkart_order_details_after_order_table', $order ); ?>
</section>

<?php
/**
 * Action hook fired after the order details.
 *
 * @since 4.4.0
 * @param KKART_Order $order Order data.
 */
do_action( 'kkart_after_order_details', $order );

if ( $show_customer_details ) {
	kkart_get_template( 'order/order-details-customer.php', array( 'order' => $order ) );
}
