<?php
/**
 * Kkart Admin Edit products on the move note.
 *
 * Adds a note to download the mobile app.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

/**
 * Edit_Products_On_The_Move
 */
class EditProductsOnTheMove {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-edit-products-on-the-move';

	/**
	 * Get the note.
	 *
	 * @return Note
	 */
	public static function get_note() {
		// Only add this note if this store is at least a year old.
		$year_in_seconds = 365 * DAY_IN_SECONDS;
		if ( ! self::kkart_admin_active_for( $year_in_seconds ) ) {
			return;
		}

		// Check that the previous mobile app notes have not been actioned.
		if ( MobileApp::has_note_been_actioned() ) {
			return;
		}
		if ( RealTimeOrderAlerts::has_note_been_actioned() ) {
			return;
		}
		if ( ManageOrdersOnTheGo::has_note_been_actioned() ) {
			return;
		}
		if ( PerformanceOnMobile::has_note_been_actioned() ) {
			return;
		}

		$note = new Note();

		$note->set_title( __( 'Edit products on the move', 'kkart' ) );
		$note->set_content( __( 'Edit and create new products from your mobile devices with the Woo app', 'kkart' ) );
		$note->set_content_data( (object) array() );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_INFORMATIONAL );
		$note->set_name( self::NOTE_NAME );
		$note->set_source( 'kkart-admin' );
		$note->add_action(
			'learn-more',
			__( 'Learn more', 'kkart' ),
			'https://kkart.com/mobile/?utm_source=inbox'
		);

		return $note;
	}
}
