/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { useCheckoutSubmit } from '@kkart/base-hooks';
import { Icon, done } from '@kkart/icons';
import Button from '@kkart/base-components/button';

const PlaceOrderButton = () => {
	const {
		submitButtonText,
		onSubmit,
		isCalculating,
		waitingForProcessing,
		waitingForRedirect,
	} = useCheckoutSubmit();

	return (
		<Button
			className="kkart-block-components-checkout-place-order-button"
			onClick={ onSubmit }
			disabled={
				isCalculating || waitingForProcessing || waitingForRedirect
			}
			showSpinner={ waitingForProcessing }
		>
			{ waitingForRedirect ? (
				<Icon
					srcElement={ done }
					alt={ __( 'Done', 'kkart' ) }
				/>
			) : (
				submitButtonText
			) }
		</Button>
	);
};

export default PlaceOrderButton;
