/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { ToggleControl, SelectControl } from '@wordpress/components';

/**
 * Internal dependencies
 */
import './editor.scss';

export const getSharedContentControls = ( attributes, setAttributes ) => {
	const { contentVisibility } = attributes;
	return (
		<ToggleControl
			label={ __(
				'Show Sorting Dropdown',
				'kkart'
			) }
			checked={ contentVisibility.orderBy }
			onChange={ () =>
				setAttributes( {
					contentVisibility: {
						...contentVisibility,
						orderBy: ! contentVisibility.orderBy,
					},
				} )
			}
		/>
	);
};

export const getSharedListControls = ( attributes, setAttributes ) => {
	return (
		<SelectControl
			label={ __( 'Order Products By', 'kkart' ) }
			value={ attributes.orderby }
			options={ [
				{
					label: __(
						'Default sorting (menu order)',
						'kkart'
					),
					value: 'menu_order',
				},
				{
					label: __( 'Popularity', 'kkart' ),
					value: 'popularity',
				},
				{
					label: __(
						'Average rating',
						'kkart'
					),
					value: 'rating',
				},
				{
					label: __( 'Latest', 'kkart' ),
					value: 'date',
				},
				{
					label: __(
						'Price: low to high',
						'kkart'
					),
					value: 'price',
				},
				{
					label: __(
						'Price: high to low',
						'kkart'
					),
					value: 'price-desc',
				},
			] }
			onChange={ ( orderby ) => setAttributes( { orderby } ) }
		/>
	);
};
