<?php

return [
    'acl' => [
        'leads'           => 'Clientes potenciales',
        'lead'            => 'Cliente potencial',
        'quotes'          => 'Cotizaciones',
        'mail'            => 'Correo',
        'inbox'           => 'Bandeja de entrada',
        'draft'           => 'Borradores',
        'outbox'          => 'Bandeja de salida',
        'sent'            => 'Enviados',
        'trash'           => 'Papelera',
        'activities'      => 'Actividades',
        'webhook'         => 'Webhook',
        'contacts'        => 'Contactos',
        'persons'         => 'Personas',
        'organizations'   => 'Organizaciones',
        'products'        => 'Productos',
        'settings'        => 'Configuraciones',
        'groups'          => 'Grupos',
        'roles'           => 'Roles',
        'users'           => 'Usuarios',
        'user'            => 'Usuario',
        'automation'      => 'Automatización',
        'attributes'      => 'Atributos',
        'pipelines'       => 'Canales',
        'sources'         => 'Fuentes',
        'types'           => 'Tipos',
        'email-templates' => 'Plantillas de correo electrónico',
        'workflows'       => 'Flujos de trabajo',
        'other-settings'  => 'Otras configuraciones',
        'tags'            => 'Etiquetas',
        'configuration'   => 'Configuración',
        'create'          => 'Crear',
        'edit'            => 'Editar',
        'view'            => 'Ver',
        'print'           => 'Imprimir',
        'delete'          => 'Eliminar',
        'export'          => 'Exportar',
        'mass-delete'     => 'Eliminar en masa',
        'data-transfer'   => 'Transferencia de Datos',
        'imports'         => 'Importaciones',
        'import'          => 'Importar',
        'event'           => 'Evento',
        'campaigns'       => 'Campañas',
    ],
    'users' => [
        'activate-warning' => 'Tu cuenta aún no está activada. Por favor, contacta al administrador.',
        'login-error'      => 'Las credenciales no coinciden con nuestros registros.',
        'not-permission'   => 'No tienes permiso para acceder al panel de administración.',
        'login'            => [
            'email'                => 'Dirección de correo electrónico',
            'forget-password-link' => '¿Olvidaste tu contraseña?',
            'password'             => 'Contraseña',
            'submit-btn'           => 'Iniciar sesión',
            'title'                => 'Iniciar sesión',
        ],
        'forget-password' => [
            'create' => [
                'email'           => 'Correo electrónico registrado',
                'email-not-exist' => 'El correo electrónico no existe',
                'page-title'      => 'Olvidé mi contraseña',
                'reset-link-sent' => 'Enlace para restablecer la contraseña enviado',
                'sign-in-link'    => '¿Volver a iniciar sesión?',
                'submit-btn'      => 'Restablecer',
                'title'           => 'Recuperar contraseña',
            ],
        ],
        'reset-password' => [
            'back-link-title'  => '¿Volver a iniciar sesión?',
            'confirm-password' => 'Confirmar contraseña',
            'email'            => 'Correo electrónico registrado',
            'password'         => 'Contraseña',
            'submit-btn'       => 'Restablecer contraseña',
            'title'            => 'Restablecer contraseña',
        ],
    ],
    'account' => [
        'edit' => [
            'back-btn'          => 'Regresar',
            'change-password'   => 'Cambiar contraseña',
            'confirm-password'  => 'Confirmar contraseña',
            'current-password'  => 'Contraseña actual',
            'email'             => 'Correo electrónico',
            'general'           => 'General',
            'invalid-password'  => 'La contraseña actual que ingresaste es incorrecta.',
            'name'              => 'Nombre',
            'password'          => 'Contraseña',
            'profile-image'     => 'Imagen de perfil',
            'save-btn'          => 'Guardar cuenta',
            'title'             => 'Mi cuenta',
            'update-success'    => 'Cuenta actualizada con éxito',
            'upload-image-info' => 'Sube una imagen de perfil (110 px × 110 px) en formato PNG o JPG',
        ],
    ],
    'components' => [
        'activities' => [
            'actions' => [
                'mail' => [
                    'btn'          => 'Correo',
                    'title'        => 'Redactar correo',
                    'to'           => 'Para',
                    'enter-emails' => 'Presiona Enter para agregar direcciones de correo electrónico',
                    'cc'           => 'CC',
                    'bcc'          => 'CCO',
                    'subject'      => 'Asunto',
                    'send-btn'     => 'Enviar',
                    'message'      => 'Mensaje',
                ],
                'file' => [
                    'btn'           => 'Archivo',
                    'title'         => 'Agregar archivo',
                    'title-control' => 'Título',
                    'name'          => 'Nombre',
                    'description'   => 'Descripción',
                    'file'          => 'Archivo',
                    'save-btn'      => 'Guardar archivo',
                ],
                'note' => [
                    'btn'      => 'Nota',
                    'title'    => 'Agregar nota',
                    'comment'  => 'Comentario',
                    'save-btn' => 'Guardar nota',
                ],
                'activity' => [
                    'btn'           => 'Actividad',
                    'title'         => 'Agregar actividad',
                    'title-control' => 'Título',
                    'description'   => 'Descripción',
                    'schedule-from' => 'Programar desde',
                    'schedule-to'   => 'Programar hasta',
                    'location'      => 'Ubicación',
                    'call'          => 'Llamada',
                    'meeting'       => 'Reunión',
                    'lunch'         => 'Almuerzo',
                    'save-btn'      => 'Guardar actividad',
                    'participants'  => [
                        'title'       => 'Participantes',
                        'placeholder' => 'Escribe para buscar participantes',
                        'users'       => 'Usuarios',
                        'persons'     => 'Personas',
                        'no-results'  => 'No se encontraron resultados...',
                    ],
                ],
            ],
            'index' => [
                'all'                => 'Todo',
                'bcc'                => 'CCO',
                'by-user'            => 'Por :user',
                'calls'              => 'Llamadas',
                'cc'                 => 'CC',
                'change-log'         => 'Registros de cambios',
                'delete'             => 'Eliminar',
                'edit'               => 'Editar',
                'emails'             => 'Correos electrónicos',
                'empty'              => 'Vacío',
                'files'              => 'Archivos',
                'from'               => 'De',
                'location'           => 'Ubicación',
                'lunches'            => 'Almuerzos',
                'mark-as-done'       => 'Marcar como hecho',
                'meetings'           => 'Reuniones',
                'notes'              => 'Notas',
                'participants'       => 'Participantes',
                'planned'            => 'Planificado',
                'quotes'             => 'Cotizaciones',
                'scheduled-on'       => 'Programado en',
                'system'             => 'Sistema',
                'to'                 => 'A',
                'unlink'             => 'Desvincular',
                'view'               => 'Ver',
                'empty-placeholders' => [
                    'all' => [
                        'title'       => 'No se encontraron actividades',
                        'description' => 'No se encontraron actividades para esto. Puedes agregar actividades haciendo clic en el botón Actividad en el panel izquierdo.',
                    ],
                    'planned' => [
                        'title'       => 'No se encontraron actividades planificadas',
                        'description' => 'No se encontraron actividades planificadas para esto. Puedes agregarlas haciendo clic en el botón Actividad en el panel izquierdo.',
                    ],
                    'notes' => [
                        'title'       => 'No se encontraron notas',
                        'description' => 'No se encontraron notas para esto. Puedes agregarlas haciendo clic en el botón Nota en el panel izquierdo.',
                    ],
                    'calls' => [
                        'title'       => 'No se encontraron llamadas',
                        'description' => 'No se encontraron llamadas para esto. Puedes agregarlas haciendo clic en el botón Actividad en el panel izquierdo y seleccionando el tipo Llamada.',
                    ],
                    'meetings' => [
                        'title'       => 'No se encontraron reuniones',
                        'description' => 'No se encontraron reuniones para esto. Puedes agregarlas haciendo clic en el botón Actividad en el panel izquierdo y seleccionando el tipo Reunión.',
                    ],
                    'lunches' => [
                        'title'       => 'No se encontraron almuerzos',
                        'description' => 'No se encontraron almuerzos para esto. Puedes agregarlos haciendo clic en el botón Actividad en el panel izquierdo y seleccionando el tipo Almuerzo.',
                    ],
                    'files' => [
                        'title'       => 'No se encontraron archivos',
                        'description' => 'No se encontraron archivos para esto. Puedes agregarlos haciendo clic en el botón Archivo en el panel izquierdo.',
                    ],
                    'emails' => [
                        'title'       => 'No se encontraron correos electrónicos',
                        'description' => 'No se encontraron correos electrónicos para esto. Puedes agregarlos haciendo clic en el botón Correo en el panel izquierdo.',
                    ],
                    'system' => [
                        'title'       => 'No se encontraron registros de cambios',
                        'description' => 'No se encontraron registros de cambios para esto.',
                    ],
                ],
            ],
        ],
        'media' => [
            'images' => [
                'add-image-btn'     => 'Agregar imagen',
                'ai-add-image-btn'  => 'Inteligencia artificial mágica',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Solo se aceptan archivos de imagen (.jpeg, .jpg, .png, ..)',
                'placeholders'      => [
                    'front'     => 'Frontal',
                    'next'      => 'Siguiente',
                    'size'      => 'Tamaño',
                    'use-cases' => 'Casos de uso',
                    'zoom'      => 'Acercar',
                ],
            ],
            'videos' => [
                'add-video-btn'     => 'Agregar video',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Solo se aceptan archivos de video (.mp4, .mov, .ogg ..)',
            ],
        ],
        'datagrid' => [
            'index' => [
                'no-records-selected'              => 'No se han seleccionado registros.',
                'must-select-a-mass-action-option' => 'Debes seleccionar una opción de acción en masa.',
                'must-select-a-mass-action'        => 'Debes seleccionar una acción en masa.',
            ],
            'toolbar' => [
                'length-of'    => ':length de',
                'of'           => 'de',
                'per-page'     => 'Por Página',
                'results'      => ':total Resultados',
                'delete'       => 'Eliminar',
                'selected'     => ':total Elementos Seleccionados',
                'mass-actions' => [
                    'submit'        => 'Enviar',
                    'select-option' => 'Seleccionar Opción',
                    'select-action' => 'Seleccionar Acción',
                ],
                'filter' => [
                    'apply-filters-btn' => 'Aplicar Filtros',
                    'back-btn'          => 'Regresar',
                    'create-new-filter' => 'Crear Nuevo Filtro',
                    'custom-filters'    => 'Filtros Personalizados',
                    'delete-error'      => 'Hubo un error al eliminar el filtro, por favor intente de nuevo.',
                    'delete-success'    => 'Filtro eliminado con éxito.',
                    'empty-description' => 'No hay filtros seleccionados disponibles para guardar. Por favor, seleccione filtros para guardar.',
                    'empty-title'       => 'Agregar Filtros para Guardar',
                    'name'              => 'Nombre',
                    'quick-filters'     => 'Filtros Rápidos',
                    'save-btn'          => 'Guardar',
                    'save-filter'       => 'Guardar Filtro',
                    'saved-success'     => 'Filtro guardado con éxito.',
                    'selected-filters'  => 'Filtros Seleccionados',
                    'title'             => 'Filtro',
                    'update'            => 'Actualizar',
                    'update-filter'     => 'Actualizar Filtro',
                    'updated-success'   => 'Filtro actualizado con éxito.',
                ],
                'search' => [
                    'title' => 'Buscar',
                ],
            ],
            'filters' => [
                'select'   => 'Seleccionar',
                'title'    => 'Filtros',
                'dropdown' => [
                    'searchable' => [
                        'at-least-two-chars' => 'Escribe al menos 2 caracteres...',
                        'no-results'         => 'No se encontraron resultados...',
                    ],
                ],
                'custom-filters' => [
                    'clear-all' => 'Borrar Todo',
                    'title'     => 'Filtros Personalizados',
                ],
                'boolean-options' => [
                    'false' => 'Falso',
                    'true'  => 'Verdadero',
                ],
                'date-options' => [
                    'last-month'        => 'Mes Pasado',
                    'last-six-months'   => 'Últimos 6 Meses',
                    'last-three-months' => 'Últimos 3 Meses',
                    'this-month'        => 'Este Mes',
                    'this-week'         => 'Esta Semana',
                    'this-year'         => 'Este Año',
                    'today'             => 'Hoy',
                    'yesterday'         => 'Ayer',
                ],
            ],
            'table' => [
                'actions'              => 'Acciones',
                'no-records-available' => 'No hay Registros Disponibles.',
            ],
        ],
        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Aceptar',
                'disagree-btn' => 'Rechazar',
                'message'      => '¿Estás seguro de que quieres realizar esta acción?',
                'title'        => '¿Estás seguro?',
            ],
        ],
        'tags' => [
            'index' => [
                'title'          => 'Etiquetas',
                'added-tags'     => 'Etiquetas Agregadas',
                'save-btn'       => 'Guardar Etiqueta',
                'placeholder'    => 'Escribe para buscar etiquetas',
                'add-tag'        => 'Agregar \\":term\\"...',
                'aquarelle-red'  => 'Rojo Aquarelle',
                'crushed-cashew' => 'Anacardo Triturado',
                'beeswax'        => 'Cera de Abejas',
                'lemon-chiffon'  => 'Chiffon de Limón',
                'snow-flurry'    => 'Tormenta de Nieve',
                'honeydew'       => 'Melón',
            ],
        ],
        'layouts' => [
            'powered-by' => [
                'description' => 'Desarrollado por :krayin, un proyecto de código abierto de :webkul.',
            ],
            'header' => [
                'mega-search' => [
                    'title' => 'Búsqueda Mega',
                    'tabs'  => [
                        'leads'    => 'Oportunidades',
                        'quotes'   => 'Cotizaciones',
                        'persons'  => 'Personas',
                        'products' => 'Productos',
                    ],
                    'explore-all-products'          => 'Explorar todos los Productos',
                    'explore-all-leads'             => 'Explorar todas las Oportunidades',
                    'explore-all-contacts'          => 'Explorar todos los Contactos',
                    'explore-all-quotes'            => 'Explorar todas las Cotizaciones',
                    'explore-all-matching-products' => 'Explorar todos los productos que coinciden con ":query" (:count)',
                    'explore-all-matching-leads'    => 'Explorar todas las oportunidades que coinciden con ":query" (:count)',
                    'explore-all-matching-contacts' => 'Explorar todos los contactos que coinciden con ":query" (:count)',
                    'explore-all-matching-quotes'   => 'Explorar todas las cotizaciones que coinciden con ":query" (:count)',
                ],
            ],
        ],
        'attributes' => [
            'edit' => [
                'delete' => 'Eliminar',
            ],
            'lookup' => [
                'click-to-add'    => 'Haz clic para agregar',
                'search'          => 'Buscar...',
                'no-result-found' => 'No se encontraron resultados',
            ],
        ],
        'lookup' => [
            'click-to-add' => 'Haz clic para agregar',
            'no-results'   => 'No se encontraron resultados',
            'add-as-new'   => 'Agregar como nuevo',
            'search'       => 'Buscar...',
        ],
        'flash-group' => [
            'success' => 'Éxito',
            'error'   => 'Error',
            'warning' => 'Advertencia',
            'info'    => 'Información',
        ],
        'tiny-mce' => [
            'http-error'    => 'Error HTTP',
            'invalid-json'  => 'Respuesta JSON no válida del servidor.',
            'upload-failed' => 'Error al subir el archivo. Por favor, inténtelo de nuevo.',
        ],
    ],
    'quotes' => [
        'index' => [
            'title'          => 'Cotizaciones',
            'create-btn'     => 'Crear Cotización',
            'create-success' => 'Cotización creada con éxito.',
            'update-success' => 'Cotización actualizada con éxito.',
            'delete-success' => 'Cotización eliminada con éxito.',
            'delete-failed'  => 'No se puede eliminar la cotización.',
            'datagrid'       => [
                'subject'      => 'Asunto',
                'sales-person' => 'Vendedor',
                'expired-at'   => 'Vence en',
                'created-at'   => 'Creado en',
                'person'       => 'Persona',
                'subtotal'     => 'Subtotal',
                'discount'     => 'Descuento',
                'tax'          => 'Impuesto',
                'adjustment'   => 'Ajuste',
                'grand-total'  => 'Total General',
                'edit'         => 'Editar',
                'delete'       => 'Eliminar',
                'print'        => 'Imprimir',
            ],
            'pdf' => [
                'adjustment'       => 'Ajuste',
                'amount'           => 'Monto',
                'billing-address'  => 'Dirección de Facturación',
                'date'             => 'Fecha',
                'discount'         => 'Descuento',
                'expired-at'       => 'Vence en',
                'grand-total'      => 'Total General',
                'person'           => 'Persona',
                'price'            => 'Precio',
                'product-name'     => 'Nombre del Producto',
                'quantity'         => 'Cantidad',
                'quote-id'         => 'ID de Cotización',
                'sales-person'     => 'Vendedor',
                'shipping-address' => 'Dirección de Envío',
                'sku'              => 'SKU',
                'sub-total'        => 'Subtotal',
                'subject'          => 'Asunto',
                'tax'              => 'Impuesto',
                'title'            => 'Cotización',
            ],
        ],
        'create' => [
            'title'             => 'Crear Cotización',
            'save-btn'          => 'Guardar Cotización',
            'quote-info'        => 'Información de la Cotización',
            'quote-info-info'   => 'Introduce la información básica de la cotización.',
            'address-info'      => 'Información de la Dirección',
            'address-info-info' => 'Información sobre la dirección relacionada con la cotización.',
            'quote-items'       => 'Artículos de la Cotización',
            'search-products'   => 'Buscar Productos',
            'link-to-lead'      => 'Vincular a cliente potencial',
            'quote-item-info'   => 'Agregar Solicitud de Producto para esta cotización.',
            'quote-name'        => 'Nombre de la Cotización',
            'quantity'          => 'Cantidad',
            'price'             => 'Precio',
            'discount'          => 'Descuento',
            'tax'               => 'Impuesto',
            'total'             => 'Total',
            'amount'            => 'Monto',
            'add-item'          => '+ Agregar Artículo',
            'sub-total'         => 'Subtotal (:symbol)',
            'total-discount'    => 'Descuento (:symbol)',
            'total-tax'         => 'Impuesto (:symbol)',
            'total-adjustment'  => 'Ajuste (:symbol)',
            'grand-total'       => 'Total General (:symbol)',
            'discount-amount'   => 'Monto del Descuento',
            'tax-amount'        => 'Monto del Impuesto',
            'adjustment-amount' => 'Monto del Ajuste',
            'product-name'      => 'Nombre del Producto',
            'action'            => 'Acción',
        ],
        'edit' => [
            'title'             => 'Editar Cotización',
            'save-btn'          => 'Guardar Cotización',
            'quote-info'        => 'Información de la Cotización',
            'quote-info-info'   => 'Introduce la información básica de la cotización.',
            'address-info'      => 'Información de la Dirección',
            'address-info-info' => 'Información sobre la dirección relacionada con la cotización.',
            'quote-items'       => 'Artículos de la Cotización',
            'link-to-lead'      => 'Vincular a cliente potencial',
            'quote-item-info'   => 'Agregar Solicitud de Producto para esta cotización.',
            'quote-name'        => 'Nombre de la Cotización',
            'quantity'          => 'Cantidad',
            'price'             => 'Precio',
            'search-products'   => 'Buscar Productos',
            'discount'          => 'Descuento',
            'tax'               => 'Impuesto',
            'total'             => 'Total',
            'amount'            => 'Monto',
            'add-item'          => '+ Agregar Artículo',
            'sub-total'         => 'Subtotal (:symbol)',
            'total-discount'    => 'Descuento (:symbol)',
            'total-tax'         => 'Impuesto (:symbol)',
            'total-adjustment'  => 'Ajuste (:symbol)',
            'grand-total'       => 'Total General (:symbol)',
            'discount-amount'   => 'Monto del Descuento',
            'tax-amount'        => 'Monto del Impuesto',
            'adjustment-amount' => 'Monto del Ajuste',
            'product-name'      => 'Nombre del Producto',
            'action'            => 'Acción',
        ],
    ],
    'contacts' => [
        'persons' => [
            'index' => [
                'title'                  => 'Personas',
                'create-btn'             => 'Crear Persona',
                'create-success'         => 'Persona creada con éxito.',
                'update-success'         => 'Persona actualizada con éxito.',
                'all-delete-success'     => 'Todas las personas seleccionadas fueron eliminadas exitosamente.',
                'partial-delete-warning' => 'Algunas personas fueron eliminadas con éxito. Otras no se pudieron eliminar porque están vinculadas a clientes potenciales.',
                'none-delete-warning'    => 'Ninguna de las personas seleccionadas pudo ser eliminada porque están vinculadas a clientes potenciales.',
                'no-selection'           => 'No se seleccionaron personas para eliminar.',
                'delete-failed'          => 'No se pudieron eliminar las personas seleccionadas.',
                'datagrid'               => [
                    'contact-numbers'   => 'Números de Contacto',
                    'delete'            => 'Eliminar',
                    'edit'              => 'Editar',
                    'emails'            => 'Correos Electrónicos',
                    'id'                => 'ID',
                    'view'              => 'Ver',
                    'name'              => 'Nombre',
                    'organization-name' => 'Nombre de la Organización',
                ],
            ],
            'view' => [
                'title'              => ':name',
                'about-person'       => 'Sobre la Persona',
                'about-organization' => 'Acerca de la organización',
                'activities'         => [
                    'index' => [
                        'all'          => 'Todos',
                        'calls'        => 'Llamadas',
                        'meetings'     => 'Reuniones',
                        'lunches'      => 'Almuerzos',
                        'files'        => 'Archivos',
                        'quotes'       => 'Cotizaciones',
                        'notes'        => 'Notas',
                        'emails'       => 'Correos Electrónicos',
                        'by-user'      => 'Por :user',
                        'scheduled-on' => 'Programado para',
                        'location'     => 'Ubicación',
                        'participants' => 'Participantes',
                        'mark-as-done' => 'Marcar como Hecho',
                        'delete'       => 'Eliminar',
                        'edit'         => 'Editar',
                    ],
                    'actions' => [
                        'mail' => [
                            'btn'      => 'Correo',
                            'title'    => 'Redactar Correo',
                            'to'       => 'Para',
                            'cc'       => 'CC',
                            'bcc'      => 'CCO',
                            'subject'  => 'Asunto',
                            'send-btn' => 'Enviar',
                            'message'  => 'Mensaje',
                        ],
                        'file' => [
                            'btn'           => 'Archivo',
                            'title'         => 'Agregar Archivo',
                            'title-control' => 'Título',
                            'name'          => 'Nombre del Archivo',
                            'description'   => 'Descripción',
                            'file'          => 'Archivo',
                            'save-btn'      => 'Guardar Archivo',
                        ],
                        'note' => [
                            'btn'      => 'Nota',
                            'title'    => 'Agregar Nota',
                            'comment'  => 'Comentario',
                            'save-btn' => 'Guardar Nota',
                        ],
                        'activity' => [
                            'btn'           => 'Actividad',
                            'title'         => 'Agregar Actividad',
                            'title-control' => 'Título',
                            'description'   => 'Descripción',
                            'schedule-from' => 'Programar Desde',
                            'schedule-to'   => 'Programar Hasta',
                            'location'      => 'Ubicación',
                            'call'          => 'Llamada',
                            'meeting'       => 'Reunión',
                            'lunch'         => 'Almuerzo',
                            'save-btn'      => 'Guardar Actividad',
                        ],
                    ],
                ],
                'tags' => [
                    'create-success'  => 'Etiqueta creada con éxito.',
                    'destroy-success' => 'Etiqueta eliminada con éxito.',
                ],
            ],
            'create' => [
                'title'    => 'Crear Persona',
                'save-btn' => 'Guardar Persona',
            ],
            'edit' => [
                'title'    => 'Editar Persona',
                'save-btn' => 'Guardar Persona',
            ],
        ],
        'organizations' => [
            'index' => [
                'title'          => 'Organizaciones',
                'create-btn'     => 'Crear Organización',
                'create-success' => 'Organización creada con éxito.',
                'update-success' => 'Organización actualizada con éxito.',
                'delete-success' => 'Organización eliminada con éxito.',
                'delete-failed'  => 'No se puede eliminar la organización.',
                'datagrid'       => [
                    'delete'        => 'Eliminar',
                    'edit'          => 'Editar',
                    'id'            => 'ID',
                    'name'          => 'Nombre',
                    'persons-count' => 'Número de Personas',
                ],
            ],
            'create' => [
                'title'    => 'Crear Organización',
                'save-btn' => 'Guardar Organización',
            ],
            'edit' => [
                'title'    => 'Editar Organización',
                'save-btn' => 'Guardar Organización',
            ],
        ],
    ],
    'products' => [
        'index' => [
            'title'          => 'Productos',
            'create-btn'     => 'Crear Producto',
            'create-success' => 'Producto creado con éxito.',
            'update-success' => 'Producto actualizado con éxito.',
            'delete-success' => 'Producto eliminado con éxito.',
            'delete-failed'  => 'No se puede eliminar el producto.',
            'datagrid'       => [
                'allocated' => 'Asignado',
                'delete'    => 'Eliminar',
                'edit'      => 'Editar',
                'id'        => 'ID',
                'in-stock'  => 'En Stock',
                'name'      => 'Nombre',
                'on-hand'   => 'Disponible',
                'tag-name'  => 'Nombre de etiqueta',
                'price'     => 'Precio',
                'sku'       => 'SKU',
                'view'      => 'Ver',
            ],
        ],
        'create' => [
            'save-btn' => 'Guardar Productos',
            'title'    => 'Crear Productos',
            'general'  => 'General',
            'price'    => 'Precio',
        ],
        'edit' => [
            'title'    => 'Editar Productos',
            'save-btn' => 'Guardar Productos',
            'general'  => 'General',
            'price'    => 'Precio',
        ],
        'view' => [
            'sku'         => 'SKU',
            'all'         => 'Todos',
            'notes'       => 'Notas',
            'files'       => 'Archivos',
            'inventories' => 'Inventario',
            'change-logs' => 'Registros de Cambios',
            'attributes'  => [
                'about-product' => 'Sobre el Producto',
            ],
            'inventory' => [
                'source'     => 'Fuente',
                'in-stock'   => 'En Stock',
                'allocated'  => 'Asignado',
                'on-hand'    => 'Disponible',
                'actions'    => 'Acciones',
                'assign'     => 'Asignar',
                'add-source' => 'Agregar Fuente',
                'location'   => 'Ubicación',
                'add-more'   => 'Agregar Más',
                'save'       => 'Guardar',
            ],
        ],
    ],
    'settings' => [
        'title'  => 'Configuraciones',
        'groups' => [
            'index' => [
                'create-btn'                     => 'Crear Grupo',
                'title'                          => 'Grupos',
                'create-success'                 => 'Grupo creado con éxito.',
                'update-success'                 => 'Grupo actualizado con éxito.',
                'destroy-success'                => 'Grupo eliminado con éxito.',
                'delete-failed'                  => 'No se puede eliminar el grupo.',
                'delete-failed-associated-users' => 'No se puede eliminar el grupo, ya que está siendo utilizado por usuarios.',
                'datagrid'                       => [
                    'delete'      => 'Eliminar',
                    'description' => 'Descripción',
                    'edit'        => 'Editar',
                    'id'          => 'ID',
                    'name'        => 'Nombre',
                ],
                'edit' => [
                    'title' => 'Editar Grupo',
                ],
                'create' => [
                    'name'        => 'Nombre',
                    'title'       => 'Crear Grupo',
                    'description' => 'Descripción',
                    'save-btn'    => 'Guardar Grupo',
                ],
            ],
        ],
        'roles' => [
            'index' => [
                'being-used'                => 'El rol no se puede eliminar, ya que está siendo utilizado por un usuario administrador.',
                'create-btn'                => 'Crear Roles',
                'create-success'            => 'Rol creado con éxito.',
                'current-role-delete-error' => 'No se puede eliminar el rol asignado al usuario actual.',
                'delete-failed'             => 'No se puede eliminar el rol.',
                'delete-success'            => 'Rol eliminado con éxito.',
                'last-delete-error'         => 'Se requiere al menos un rol.',
                'settings'                  => 'Configuraciones',
                'title'                     => 'Roles',
                'update-success'            => 'Rol actualizado con éxito.',
                'user-define-error'         => 'No se puede eliminar el rol del sistema.',
                'datagrid'                  => [
                    'all'             => 'Todos',
                    'custom'          => 'Personalizado',
                    'delete'          => 'Eliminar',
                    'description'     => 'Descripción',
                    'edit'            => 'Editar',
                    'id'              => 'ID',
                    'name'            => 'Nombre',
                    'permission-type' => 'Tipo de Permiso',
                ],
            ],
            'create' => [
                'access-control' => 'Control de Acceso',
                'all'            => 'Todos',
                'back-btn'       => 'Volver',
                'custom'         => 'Personalizado',
                'description'    => 'Descripción',
                'general'        => 'General',
                'name'           => 'Nombre',
                'permissions'    => 'Permisos',
                'save-btn'       => 'Guardar Rol',
                'title'          => 'Crear Rol',
            ],
            'edit' => [
                'access-control' => 'Control de Acceso',
                'all'            => 'Todos',
                'back-btn'       => 'Volver',
                'custom'         => 'Personalizado',
                'description'    => 'Descripción',
                'general'        => 'General',
                'name'           => 'Nombre',
                'permissions'    => 'Permisos',
                'save-btn'       => 'Guardar Rol',
                'title'          => 'Editar Rol',
            ],
        ],
        'types' => [
            'index' => [
                'create-btn'     => 'Crear Tipo',
                'create-success' => 'Tipo creado con éxito.',
                'delete-failed'  => 'No se puede eliminar el tipo.',
                'delete-success' => 'Tipo eliminado con éxito.',
                'title'          => 'Tipos',
                'update-success' => 'Tipo actualizado con éxito.',
                'datagrid'       => [
                    'delete'      => 'Eliminar',
                    'description' => 'Descripción',
                    'edit'        => 'Editar',
                    'id'          => 'ID',
                    'name'        => 'Nombre',
                ],
                'create' => [
                    'name'     => 'Nombre',
                    'save-btn' => 'Guardar Tipo',
                    'title'    => 'Crear Tipo',
                ],
                'edit' => [
                    'title' => 'Editar Tipo',
                ],
            ],
        ],
        'sources' => [
            'index' => [
                'title'                          => 'Fuentes',
                'create-btn'                     => 'Crear Fuente',
                'create-success'                 => 'Fuente creada con éxito.',
                'delete-failed'                  => 'No se puede eliminar la fuente.',
                'delete-success'                 => 'Fuente eliminada con éxito.',
                'update-success'                 => 'Fuente actualizada con éxito.',
                'delete-failed-associated-leads' => 'No se puede eliminar la fuente porque está asociada a clientes potenciales existentes. Por favor, desvincúlelos o actualícelos antes de eliminar.',
                'datagrid'                       => [
                    'delete' => 'Eliminar',
                    'edit'   => 'Editar',
                    'id'     => 'ID',
                    'name'   => 'Nombre',
                ],
                'create' => [
                    'name'     => 'Nombre',
                    'save-btn' => 'Guardar fuente',
                    'title'    => 'Crear fuente',
                ],
                'edit' => [
                    'title' => 'Editar fuente',
                ],
            ],
        ],
        'workflows' => [
            'index' => [
                'title'          => 'Flujos de Trabajo',
                'create-btn'     => 'Crear Flujo de Trabajo',
                'create-success' => 'Flujo de trabajo creado con éxito.',
                'update-success' => 'Flujo de trabajo actualizado con éxito.',
                'delete-success' => 'Flujo de trabajo eliminado con éxito.',
                'delete-failed'  => 'No se puede eliminar el flujo de trabajo.',
                'datagrid'       => [
                    'delete'      => 'Eliminar',
                    'description' => 'Descripción',
                    'edit'        => 'Editar',
                    'id'          => 'ID',
                    'name'        => 'Nombre',
                ],
            ],
            'helpers' => [
                'update-related-leads'       => 'Actualizar leads relacionados',
                'send-email-to-sales-owner'  => 'Enviar correo al propietario de ventas',
                'send-email-to-participants' => 'Enviar correo a los participantes',
                'add-webhook'                => 'Agregar Webhook',
                'update-lead'                => 'Actualizar Lead',
                'update-person'              => 'Actualizar Persona',
                'send-email-to-person'       => 'Enviar correo a la persona',
                'add-tag'                    => 'Agregar Etiqueta',
                'add-note-as-activity'       => 'Agregar Nota como Actividad',
                'update-quote'               => 'Actualizar cotización',
            ],
            'create' => [
                'title'                  => 'Crear Flujo de Trabajo',
                'event'                  => 'Evento',
                'back-btn'               => 'Volver',
                'save-btn'               => 'Guardar Flujo de Trabajo',
                'name'                   => 'Nombre',
                'basic-details'          => 'Detalles Básicos',
                'description'            => 'Descripción',
                'actions'                => 'Acciones',
                'basic-details-info'     => 'Coloque la información básica del flujo de trabajo.',
                'event-info'             => 'Un evento desencadena, verifica, condiciones y realiza acciones predefinidas.',
                'conditions'             => 'Condiciones',
                'conditions-info'        => 'Las condiciones son reglas que verifican escenarios, desencadenadas en ocasiones específicas.',
                'actions-info'           => 'Una acción no solo reduce la carga de trabajo, sino que también facilita la automatización de CRM.',
                'value'                  => 'Valor',
                'condition-type'         => 'Tipo de Condición',
                'all-condition-are-true' => 'Todas las condiciones son verdaderas',
                'any-condition-are-true' => 'Cualquiera de las condiciones es verdadera',
                'add-condition'          => 'Agregar Condición',
                'add-action'             => 'Agregar Acción',
                'yes'                    => 'Sí',
                'no'                     => 'No',
                'email'                  => 'Correo Electrónico',
                'is-equal-to'            => 'Es igual a',
                'is-not-equal-to'        => 'No es igual a',
                'equals-or-greater-than' => 'Es igual o mayor que',
                'equals-or-less-than'    => 'Es igual o menor que',
                'greater-than'           => 'Mayor que',
                'less-than'              => 'Menor que',
                'type'                   => 'Tipo',
                'contain'                => 'Contiene',
                'contains'               => 'Contiene',
                'does-not-contain'       => 'No contiene',
            ],
            'edit' => [
                'title'                  => 'Editar Flujo de Trabajo',
                'event'                  => 'Evento',
                'back-btn'               => 'Volver',
                'save-btn'               => 'Guardar Flujo de Trabajo',
                'name'                   => 'Nombre',
                'basic-details'          => 'Detalles Básicos',
                'description'            => 'Descripción',
                'actions'                => 'Acciones',
                'type'                   => 'Tipo',
                'basic-details-info'     => 'Coloque la información básica del flujo de trabajo.',
                'event-info'             => 'Un evento desencadena, verifica, condiciones y realiza acciones predefinidas.',
                'conditions'             => 'Condiciones',
                'conditions-info'        => 'Las condiciones son reglas que verifican escenarios, desencadenadas en ocasiones específicas.',
                'actions-info'           => 'Una acción no solo reduce la carga de trabajo, sino que también facilita la automatización de CRM.',
                'value'                  => 'Valor',
                'condition-type'         => 'Tipo de Condición',
                'all-condition-are-true' => 'Todas las condiciones son verdaderas',
                'any-condition-are-true' => 'Cualquiera de las condiciones es verdadera',
                'add-condition'          => 'Agregar Condición',
                'add-action'             => 'Agregar Acción',
                'yes'                    => 'Sí',
                'no'                     => 'No',
                'email'                  => 'Correo Electrónico',
                'is-equal-to'            => 'Es igual a',
                'is-not-equal-to'        => 'No es igual a',
                'equals-or-greater-than' => 'Es igual o mayor que',
                'equals-or-less-than'    => 'Es igual o menor que',
                'greater-than'           => 'Mayor que',
                'less-than'              => 'Menor que',
                'contain'                => 'Contiene',
                'contains'               => 'Contiene',
                'does-not-contain'       => 'No contiene',
            ],
        ],
        'webforms' => [
            'index' => [
                'title'          => 'Webforms',
                'create-btn'     => 'Crear Webform',
                'create-success' => 'Webform creado con éxito.',
                'update-success' => 'Webform actualizado con éxito.',
                'delete-success' => 'Webform eliminado con éxito.',
                'delete-failed'  => 'No se puede eliminar el Webform.',
                'datagrid'       => [
                    'id'     => 'ID',
                    'title'  => 'Título',
                    'edit'   => 'Editar',
                    'delete' => 'Eliminar',
                ],
            ],
            'create' => [
                'title'                    => 'Crear formulario web',
                'add-attribute-btn'        => 'Agregar Botón de Atributo',
                'attribute-label-color'    => 'Color de Etiqueta del Atributo',
                'attributes'               => 'Atributos',
                'attributes-info'          => 'Agregue atributos personalizados al formulario.',
                'background-color'         => 'Color de Fondo',
                'create-lead'              => 'Crear Lead',
                'customize-webform'        => 'Personalizar Webform',
                'customize-webform-info'   => 'Personalice su formulario web con los colores de los elementos de su elección.',
                'description'              => 'Descripción',
                'display-custom-message'   => 'Mostrar mensaje personalizado',
                'form-background-color'    => 'Color de Fondo del Formulario',
                'form-submit-btn-color'    => 'Color del Botón de Enviar del Formulario',
                'form-submit-button-color' => 'Color del Botón de Enviar del Formulario',
                'form-title-color'         => 'Color del Título del Formulario',
                'general'                  => 'General',
                'leads'                    => 'Leads',
                'person'                   => 'Persona',
                'save-btn'                 => 'Guardar Webform',
                'submit-button-label'      => 'Etiqueta del Botón de Enviar',
                'submit-success-action'    => 'Acción en caso de éxito de envío',
                'redirect-to-url'          => 'Redirigir a la URL',
                'choose-value'             => 'Elige un valor',
                'select-file'              => 'Seleccionar archivo',
                'select-image'             => 'Seleccionar imagen',
                'enter-value'              => 'Introducir valor',
            ],
            'edit' => [
                'add-attribute-btn'        => 'Agregar Botón de Atributo',
                'attribute-label-color'    => 'Color de Etiqueta del Atributo',
                'attributes'               => 'Atributos',
                'attributes-info'          => 'Agregue atributos personalizados al formulario.',
                'background-color'         => 'Color de Fondo',
                'choose-value'             => 'Elige un valor',
                'code-snippet'             => 'Fragmento de Código',
                'copied'                   => 'Copiado',
                'copy'                     => 'Copiar',
                'create-lead'              => 'Crear Lead',
                'customize-webform'        => 'Personalizar Webform',
                'customize-webform-info'   => 'Personalice su formulario web con los colores de los elementos de su elección.',
                'description'              => 'Descripción',
                'display-custom-message'   => 'Mostrar mensaje personalizado',
                'embed'                    => 'Incrustar',
                'enter-value'              => 'Introducir valor',
                'form-background-color'    => 'Color de Fondo del Formulario',
                'form-submit-btn-color'    => 'Color del Botón de Enviar del Formulario',
                'form-submit-button-color' => 'Color del Botón de Enviar del Formulario',
                'form-title-color'         => 'Color del Título del Formulario',
                'general'                  => 'General',
                'leads'                    => 'Leads',
                'person'                   => 'Persona',
                'preview'                  => 'Vista Previa',
                'public-url'               => 'URL Pública',
                'redirect-to-url'          => 'Redirigir a la URL',
                'save-btn'                 => 'Guardar Webform',
                'select-file'              => 'Seleccionar archivo',
                'select-image'             => 'Seleccionar imagen',
                'submit-button-label'      => 'Etiqueta del Botón de Enviar',
                'submit-success-action'    => 'Acción en caso de éxito de envío',
                'title'                    => 'Editar formulario web',
            ],
        ],
        'email-template' => [
            'index' => [
                'create-btn'     => 'Crear Plantilla de Correo Electrónico',
                'title'          => 'Plantillas de Correo Electrónico',
                'create-success' => 'Plantilla de Correo Electrónico creada exitosamente.',
                'update-success' => 'Plantilla de Correo Electrónico actualizada exitosamente.',
                'delete-success' => 'Plantilla de Correo Electrónico eliminada exitosamente.',
                'delete-failed'  => 'No se puede eliminar la Plantilla de Correo Electrónico.',
                'datagrid'       => [
                    'delete'  => 'Eliminar',
                    'edit'    => 'Editar',
                    'id'      => 'ID',
                    'name'    => 'Nombre',
                    'subject' => 'Asunto',
                ],
            ],
            'create' => [
                'title'                => 'Crear Plantilla de Correo Electrónico',
                'save-btn'             => 'Guardar Plantilla de Correo Electrónico',
                'email-template'       => 'Plantilla de Correo Electrónico',
                'subject'              => 'Asunto',
                'content'              => 'Contenido',
                'subject-placeholders' => 'Marcadores de Posición del Asunto',
                'general'              => 'General',
                'name'                 => 'Nombre',
            ],
            'edit' => [
                'title'                => 'Editar Plantilla de Correo Electrónico',
                'save-btn'             => 'Guardar Plantilla de Correo Electrónico',
                'email-template'       => 'Plantilla de Correo Electrónico',
                'subject'              => 'Asunto',
                'content'              => 'Contenido',
                'subject-placeholders' => 'Marcadores de Posición del Asunto',
                'general'              => 'General',
                'name'                 => 'Nombre',
            ],
        ],
        'marketing' => [
            'events' => [
                'index' => [
                    'create-btn'          => 'Crear Evento',
                    'title'               => 'Eventos',
                    'create-success'      => 'Evento creado con éxito.',
                    'update-success'      => 'Evento actualizado con éxito.',
                    'delete-success'      => 'Evento eliminado con éxito.',
                    'delete-failed'       => 'No se puede eliminar el evento.',
                    'mass-delete-success' => 'Eventos eliminados con éxito',
                    'datagrid'            => [
                        'delete'      => 'Eliminar',
                        'edit'        => 'Editar',
                        'id'          => 'ID',
                        'name'        => 'Nombre',
                        'description' => 'Descripción',
                        'date'        => 'Fecha',
                    ],
                    'create' => [
                        'title'       => 'Crear Evento',
                        'name'        => 'Nombre',
                        'date'        => 'Fecha',
                        'description' => 'Descripción',
                        'save-btn'    => 'Guardar Evento',
                    ],
                    'edit' => [
                        'title' => 'Editar Evento',
                    ],
                ],
            ],
            'campaigns' => [
                'index' => [
                    'create-btn'          => 'Crear Campaña',
                    'title'               => 'Campañas',
                    'create-success'      => 'Campaña creada con éxito.',
                    'update-success'      => 'Campaña actualizada con éxito.',
                    'delete-success'      => 'Campaña eliminada con éxito.',
                    'delete-failed'       => 'No se puede eliminar la campaña.',
                    'mass-delete-success' => 'Campañas eliminadas con éxito.',
                    'datagrid'            => [
                        'id'       => 'ID',
                        'name'     => 'Nombre',
                        'subject'  => 'Asunto',
                        'status'   => 'Estado',
                        'active'   => 'Activo',
                        'inactive' => 'Inactivo',
                        'edit'     => 'Editar',
                        'delete'   => 'Eliminar',
                    ],
                    'create' => [
                        'title'          => 'Crear Campaña',
                        'name'           => 'Nombre',
                        'type'           => 'Tipo',
                        'subject'        => 'Asunto',
                        'event'          => 'Evento',
                        'email-template' => 'Plantilla de Correo',
                        'status'         => 'Estado',
                    ],
                    'edit' => [
                        'title' => 'Editar Campaña',
                    ],
                ],
            ],
        ],
        'tags' => [
            'index' => [
                'create-btn'     => 'Crear Etiqueta',
                'title'          => 'Etiquetas',
                'create-success' => 'Etiqueta creada exitosamente.',
                'update-success' => 'Etiqueta actualizada exitosamente.',
                'delete-success' => 'Etiqueta eliminada exitosamente.',
                'delete-failed'  => 'No se puede eliminar la Etiqueta.',
                'datagrid'       => [
                    'delete'     => 'Eliminar',
                    'edit'       => 'Editar',
                    'id'         => 'ID',
                    'name'       => 'Nombre',
                    'users'      => 'Usuarios',
                    'created-at' => 'Creado En',
                ],
                'create' => [
                    'name'     => 'Nombre',
                    'save-btn' => 'Guardar Etiqueta',
                    'title'    => 'Crear Etiqueta',
                    'color'    => 'Color',
                ],
                'edit' => [
                    'title' => 'Editar Etiqueta',
                ],
            ],
        ],
        'users' => [
            'index' => [
                'create-btn'          => 'Crear Usuario',
                'create-success'      => 'Usuario creado exitosamente.',
                'delete-failed'       => 'No se puede eliminar el Usuario.',
                'delete-success'      => 'Usuario eliminado exitosamente.',
                'last-delete-error'   => 'Se requiere al menos un usuario.',
                'mass-delete-failed'  => 'No se pueden eliminar los Usuarios.',
                'mass-delete-success' => 'Usuarios eliminados exitosamente.',
                'mass-update-failed'  => 'No se pueden actualizar los Usuarios.',
                'mass-update-success' => 'Usuarios actualizados exitosamente.',
                'title'               => 'Usuarios',
                'update-success'      => 'Usuario actualizado exitosamente.',
                'user-define-error'   => 'No se puede eliminar el usuario del sistema.',
                'active'              => 'Activo',
                'inactive'            => 'Inactivo',
                'datagrid'            => [
                    'active'        => 'Activo',
                    'created-at'    => 'Creado En',
                    'delete'        => 'Eliminar',
                    'edit'          => 'Editar',
                    'email'         => 'Correo Electrónico',
                    'id'            => 'ID',
                    'inactive'      => 'Inactivo',
                    'name'          => 'Nombre',
                    'status'        => 'Estado',
                    'update-status' => 'Actualizar Estado',
                    'users'         => 'Usuarios',
                ],
                'create' => [
                    'confirm-password'         => 'Confirmar Contraseña',
                    'email'                    => 'Correo Electrónico',
                    'general'                  => 'General',
                    'global'                   => 'Global',
                    'group'                    => 'Grupo',
                    'individual'               => 'Individual',
                    'name'                     => 'Nombre',
                    'password'                 => 'Contraseña',
                    'permission'               => 'Permiso',
                    'role'                     => 'Rol',
                    'save-btn'                 => 'Guardar Usuario',
                    'status'                   => 'Estado',
                    'title'                    => 'Crear Usuario',
                    'view-permission'          => 'Ver Permiso',
                    'select-at-lest-one-group' => 'Select at least one group',
                ],
                'edit' => [
                    'title' => 'Editar Usuario',
                ],
            ],
        ],
        'pipelines' => [
            'index' => [
                'title'                => 'Canales',
                'create-btn'           => 'Crear Canal',
                'create-success'       => 'Canal creado exitosamente.',
                'update-success'       => 'Canal actualizado exitosamente.',
                'default-required'     => 'Se requiere al menos una canalización predeterminada.',
                'delete-success'       => 'Canal eliminado exitosamente.',
                'delete-failed'        => 'No se puede eliminar el Canal.',
                'default-delete-error' => 'No se puede eliminar el canal predeterminado.',
                'datagrid'             => [
                    'delete'      => 'Eliminar',
                    'edit'        => 'Editar',
                    'id'          => 'ID',
                    'is-default'  => 'Es Predeterminado',
                    'name'        => 'Nombre',
                    'no'          => 'No',
                    'rotten-days' => 'Días de Pudrición',
                    'yes'         => 'Sí',
                ],
            ],
            'create' => [
                'title'                => 'Crear Canal',
                'save-btn'             => 'Guardar Canal',
                'name'                 => 'Nombre',
                'rotten-days'          => 'Días de Pudrición',
                'mark-as-default'      => 'Marcar como Predeterminado',
                'general'              => 'General',
                'probability'          => 'Probabilidad (%)',
                'new-stage'            => 'Nuevo',
                'won-stage'            => 'Ganado',
                'lost-stage'           => 'Perdido',
                'stage-btn'            => 'Añadir Etapa',
                'stages'               => 'Etapas',
                'duplicate-name'       => 'El campo "Nombre" no puede ser duplicado',
                'delete-stage'         => 'Eliminar Etapa',
                'add-new-stages'       => 'Añadir Nuevas Etapas',
                'add-stage-info'       => 'Añadir nueva etapa para tu Canal',
                'newly-added'          => 'Añadido Recientemente',
                'stage-delete-success' => 'Etapa Eliminada Exitosamente',
            ],
            'edit' => [
                'title'                => 'Editar Canal',
                'save-btn'             => 'Guardar Canal',
                'name'                 => 'Nombre',
                'rotten-days'          => 'Días de Pudrición',
                'mark-as-default'      => 'Marcar como Predeterminado',
                'general'              => 'General',
                'probability'          => 'Probabilidad (%)',
                'new-stage'            => 'Nuevo',
                'won-stage'            => 'Ganado',
                'lost-stage'           => 'Perdido',
                'stage-btn'            => 'Añadir Etapa',
                'stages'               => 'Etapas',
                'duplicate-name'       => 'El campo "Nombre" no puede ser duplicado',
                'delete-stage'         => 'Eliminar Etapa',
                'add-new-stages'       => 'Añadir Nuevas Etapas',
                'add-stage-info'       => 'Añadir nueva etapa para tu Canal',
                'stage-delete-success' => 'Etapa Eliminada Exitosamente',
            ],
        ],
        'webhooks' => [
            'index' => [
                'title'          => 'Webhooks',
                'create-btn'     => 'Crear Webhook',
                'create-success' => 'Webhook creado exitosamente.',
                'update-success' => 'Webhook actualizado exitosamente.',
                'delete-success' => 'Webhook eliminado exitosamente.',
                'delete-failed'  => 'No se puede eliminar el Webhook.',
                'datagrid'       => [
                    'id'          => 'ID',
                    'delete'      => 'Eliminar',
                    'edit'        => 'Editar',
                    'name'        => 'Nombre',
                    'entity-type' => 'Tipo de Entidad',
                    'end-point'   => 'Punto Final',
                ],
            ],
            'create' => [
                'title'                 => 'Crear Webhook',
                'save-btn'              => 'Guardar Webhook',
                'info'                  => 'Ingrese los detalles del webhook',
                'url-and-parameters'    => 'URL Y Parámetros',
                'method'                => 'Método',
                'post'                  => 'Post',
                'put'                   => 'Put',
                'url-endpoint'          => 'Punto Final de URL',
                'parameters'            => 'Parámetros',
                'add-new-parameter'     => 'Añadir Nuevo Parámetro',
                'url-preview'           => 'Vista Previa de URL:',
                'headers'               => 'Encabezados',
                'add-new-header'        => 'Añadir Nuevo Encabezado',
                'body'                  => 'Cuerpo',
                'default'               => 'Predeterminado',
                'x-www-form-urlencoded' => 'x-www-form-urlencoded',
                'key-and-value'         => 'Clave y Valor',
                'add-new-payload'       => 'Añadir nueva carga',
                'raw'                   => 'Crudo',
                'general'               => 'General',
                'name'                  => 'Nombre',
                'entity-type'           => 'Tipo de Entidad',
                'insert-placeholder'    => 'Insertar Marcador de Posición',
                'description'           => 'Descripción',
                'json'                  => 'Json',
                'text'                  => 'Texto',
            ],
            'edit' => [
                'title'                 => 'Editar Webhook',
                'edit-btn'              => 'Guardar Webhook',
                'save-btn'              => 'Guardar Webhook',
                'info'                  => 'Ingrese los detalles del webhook',
                'url-and-parameters'    => 'URL Y Parámetros',
                'method'                => 'Método',
                'post'                  => 'Post',
                'put'                   => 'Put',
                'url-endpoint'          => 'Punto Final de URL',
                'parameters'            => 'Parámetros',
                'add-new-parameter'     => 'Añadir Nuevo Parámetro',
                'url-preview'           => 'Vista Previa de URL:',
                'headers'               => 'Encabezados',
                'add-new-header'        => 'Añadir Nuevo Encabezado',
                'body'                  => 'Cuerpo',
                'default'               => 'Predeterminado',
                'x-www-form-urlencoded' => 'x-www-form-urlencoded',
                'key-and-value'         => 'Clave y Valor',
                'add-new-payload'       => 'Añadir nueva carga',
                'raw'                   => 'Crudo',
                'general'               => 'General',
                'name'                  => 'Nombre',
                'entity-type'           => 'Tipo de Entidad',
                'insert-placeholder'    => 'Insertar Marcador de Posición',
                'description'           => 'Descripción',
                'json'                  => 'Json',
                'text'                  => 'Texto',
            ],
        ],
        'warehouses' => [
            'index' => [
                'title'          => 'Almacenes',
                'create-btn'     => 'Crear Almacén',
                'create-success' => 'Almacén creado con éxito.',
                'name-exists'    => 'El nombre del almacén ya existe.',
                'update-success' => 'Almacén actualizado con éxito.',
                'delete-success' => 'Almacén eliminado con éxito.',
                'delete-failed'  => 'No se puede eliminar el almacén.',
                'datagrid'       => [
                    'id'              => 'ID',
                    'name'            => 'Nombre',
                    'contact-name'    => 'Nombre del Contacto',
                    'delete'          => 'Eliminar',
                    'edit'            => 'Editar',
                    'view'            => 'Ver',
                    'created-at'      => 'Creado En',
                    'products'        => 'Productos',
                    'contact-emails'  => 'Correos Electrónicos de Contacto',
                    'contact-numbers' => 'Números de Teléfono de Contacto',
                ],
            ],
            'create' => [
                'title'        => 'Crear Almacén',
                'save-btn'     => 'Guardar Almacén',
                'contact-info' => 'Información de Contacto',
            ],
            'edit' => [
                'title'        => 'Editar Almacén',
                'save-btn'     => 'Guardar Almacén',
                'contact-info' => 'Información de Contacto',
            ],
            'view' => [
                'all'         => 'Todos',
                'notes'       => 'Notas',
                'files'       => 'Archivos',
                'location'    => 'Ubicación',
                'change-logs' => 'Registros de Cambios',
                'locations'   => [
                    'action'         => 'Acción',
                    'add-location'   => 'Agregar Ubicación',
                    'create-success' => 'Ubicación creada con éxito.',
                    'delete'         => 'Eliminar',
                    'delete-failed'  => 'No se puede eliminar la ubicación.',
                    'delete-success' => 'Ubicación eliminada con éxito.',
                    'name'           => 'Nombre',
                    'save-btn'       => 'Guardar',
                ],
                'general-information' => [
                    'title' => 'Información General',
                ],
                'contact-information' => [
                    'title' => 'Información de Contacto',
                ],
            ],
        ],
        'attributes' => [
            'index' => [
                'title'              => 'Atributos',
                'create-btn'         => 'Crear Atributo',
                'create-success'     => 'Atributo creados con éxito.',
                'update-success'     => 'Atributo actualizados con éxito.',
                'delete-success'     => 'Atributo eliminados con éxito.',
                'delete-failed'      => 'No se pueden eliminar los atributo.',
                'user-define-error'  => 'No se puede eliminar el atributo del sistema.',
                'mass-delete-failed' => 'No se pueden eliminar los atributos del sistema.',
                'datagrid'           => [
                    'yes'          => 'Sí',
                    'no'           => 'No',
                    'id'           => 'ID',
                    'code'         => 'Código',
                    'name'         => 'Nombre',
                    'entity-type'  => 'Tipo de Entidad',
                    'type'         => 'Tipo',
                    'is-default'   => 'Es Predeterminado',
                    'edit'         => 'Editar',
                    'delete'       => 'Eliminar',
                    'entity-types' => [
                        'leads'         => 'Clientes potenciales',
                        'organizations' => 'Organizaciones',
                        'persons'       => 'Personas',
                        'products'      => 'Productos',
                        'quotes'        => 'Cotizaciones',
                        'warehouses'    => 'Almacenes',
                    ],
                    'types' => [
                        'text'        => 'Texto',
                        'textarea'    => 'Área de texto',
                        'price'       => 'Precio',
                        'boolean'     => 'Booleano',
                        'select'      => 'Seleccionar',
                        'multiselect' => 'Selección múltiple',
                        'checkbox'    => 'Casilla de verificación',
                        'email'       => 'Correo electrónico',
                        'address'     => 'Dirección',
                        'phone'       => 'Teléfono',
                        'lookup'      => 'Búsqueda',
                        'datetime'    => 'Fecha y hora',
                        'date'        => 'Fecha',
                        'image'       => 'Imagen',
                        'file'        => 'Archivo',
                    ],
                ],
            ],
            'create' => [
                'title'                 => 'Crear Atributo',
                'save-btn'              => 'Guardar Atributo',
                'code'                  => 'Código',
                'name'                  => 'Nombre',
                'entity-type'           => 'Tipo de Entidad',
                'type'                  => 'Tipo',
                'validations'           => 'Validaciones',
                'is-required'           => 'Es Requerido',
                'input-validation'      => 'Validación de Entrada',
                'is-unique'             => 'Es Único',
                'labels'                => 'Etiquetas',
                'general'               => 'General',
                'numeric'               => 'Numérico',
                'decimal'               => 'Decimal',
                'url'                   => 'Url',
                'options'               => 'Opciones',
                'option-type'           => 'Tipo de Opción',
                'lookup-type'           => 'Tipo de Búsqueda',
                'add-option'            => 'Agregar Opción',
                'save-option'           => 'Guardar Opción',
                'option-name'           => 'Nombre de Opción',
                'add-attribute-options' => 'Agregar Opciones de Atributo',
                'text'                  => 'Texto',
                'textarea'              => 'Área de Texto',
                'price'                 => 'Precio',
                'boolean'               => 'Booleano',
                'select'                => 'Seleccionar',
                'multiselect'           => 'Selección Múltiple',
                'email'                 => 'Correo Electrónico',
                'address'               => 'Dirección',
                'phone'                 => 'Teléfono',
                'datetime'              => 'Fecha y Hora',
                'date'                  => 'Fecha',
                'image'                 => 'Imagen',
                'file'                  => 'Archivo',
                'lookup'                => 'Búsqueda',
                'entity_type'           => 'Tipo de Entidad',
                'checkbox'              => 'Casilla de Verificación',
                'is_required'           => 'Es Requerido',
                'is_unique'             => 'Es Único',
                'actions'               => 'Acciones',
            ],
            'edit' => [
                'actions'               => 'Acciones',
                'add-attribute-options' => 'Agregar Opciones de Atributo',
                'add-option'            => 'Agregar Opción',
                'address'               => 'Dirección',
                'boolean'               => 'Booleano',
                'checkbox'              => 'Casilla de Verificación',
                'code'                  => 'Código',
                'date'                  => 'Fecha',
                'datetime'              => 'Fecha y Hora',
                'decimal'               => 'Decimal',
                'email'                 => 'Correo Electrónico',
                'entity-type'           => 'Tipo de Entidad',
                'entity_type'           => 'Tipo de Entidad',
                'file'                  => 'Archivo',
                'general'               => 'General',
                'image'                 => 'Imagen',
                'input-validation'      => 'Validación de Entrada',
                'is-required'           => 'Es Requerido',
                'is-unique'             => 'Es Único',
                'is_required'           => 'Es Requerido',
                'is_unique'             => 'Es Único',
                'labels'                => 'Etiquetas',
                'lookup'                => 'Búsqueda',
                'lookup-type'           => 'Tipo de Búsqueda',
                'multiselect'           => 'Selección Múltiple',
                'name'                  => 'Nombre',
                'numeric'               => 'Numérico',
                'option-deleted'        => 'Attribute Option is deleted successfully',
                'option-name'           => 'Nombre de Opción',
                'option-type'           => 'Tipo de Opción',
                'options'               => 'Opciones',
                'phone'                 => 'Teléfono',
                'price'                 => 'Precio',
                'save-btn'              => 'Guardar Atributo',
                'save-option'           => 'Guardar Opción',
                'select'                => 'Seleccionar',
                'text'                  => 'Texto',
                'textarea'              => 'Área de Texto',
                'title'                 => 'Editar Atributo',
                'type'                  => 'Tipo',
                'url'                   => 'Url',
                'validations'           => 'Validaciones',
            ],
        ],
        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Acción',
                    'allowed-errors'      => 'Errores Permitidos',
                    'back-btn'            => 'Atrás',
                    'create-update'       => 'Crear/Actualizar',
                    'delete'              => 'Eliminar',
                    'download-sample'     => 'Descargar Muestra',
                    'field-separator'     => 'Separador de Campos',
                    'file'                => 'Archivo',
                    'general'             => 'General',
                    'images-directory'    => 'Ruta del Directorio de Imágenes',
                    'process-in-queue'    => 'Procesar en Cola',
                    'results'             => 'Resultados',
                    'save-btn'            => 'Guardar Importación',
                    'settings'            => 'Configuraciones',
                    'skip-errors'         => 'Omitir Errores',
                    'stop-on-errors'      => 'Detener en Errores',
                    'title'               => 'Crear Importación',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Estrategia de Validación',
                ],
                'edit' => [
                    'action'              => 'Acción',
                    'allowed-errors'      => 'Errores Permitidos',
                    'back-btn'            => 'Atrás',
                    'create-update'       => 'Crear/Actualizar',
                    'delete'              => 'Eliminar',
                    'download-sample'     => 'Descargar Muestra',
                    'field-separator'     => 'Separador de Campos',
                    'file'                => 'Archivo',
                    'general'             => 'General',
                    'images-directory'    => 'Ruta del Directorio de Imágenes',
                    'process-in-queue'    => 'Procesar en Cola',
                    'results'             => 'Resultados',
                    'save-btn'            => 'Guardar Importación',
                    'settings'            => 'Configuraciones',
                    'skip-errors'         => 'Omitir Errores',
                    'stop-on-errors'      => 'Detener en Errores',
                    'title'               => 'Editar Importación',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Estrategia de Validación',
                ],
                'index' => [
                    'button-title' => 'Crear Importación',
                    'title'        => 'Importaciones',
                    'datagrid'     => [
                        'actions'       => 'Acciones',
                        'completed-at'  => 'Completado en',
                        'created'       => 'Creado',
                        'delete'        => 'Eliminar',
                        'deleted'       => 'Eliminado',
                        'edit'          => 'Editar',
                        'error-file'    => 'Archivo de Errores',
                        'id'            => 'ID',
                        'started-at'    => 'Iniciado en',
                        'state'         => 'Estado',
                        'summary'       => 'Resumen',
                        'type'          => 'Tipo',
                        'updated'       => 'Actualizado',
                        'uploaded-file' => 'Archivo Subido',
                    ],
                ],
                'import' => [
                    'back-btn'                => 'Atrás',
                    'completed-batches'       => 'Total de Lotes Completados:',
                    'download-error-report'   => 'Descargar Informe Completo',
                    'edit-btn'                => 'Editar',
                    'imported-info'           => '¡Felicidades! Tu importación fue exitosa.',
                    'importing-info'          => 'Importación en Proceso',
                    'indexing-info'           => 'Indexación de Recursos (Precios, Inventario y Elastic Search) en Progreso',
                    'linking-info'            => 'Vinculación de Recursos en Progreso',
                    'progress'                => 'Progreso:',
                    'title'                   => 'Importación',
                    'total-batches'           => 'Total de Lotes:',
                    'total-created'           => 'Total de Registros Creados:',
                    'total-deleted'           => 'Total de Registros Eliminados:',
                    'total-errors'            => 'Total de Errores:',
                    'total-invalid-rows'      => 'Total de Filas Inválidas:',
                    'total-rows-processed'    => 'Total de Filas Procesadas:',
                    'total-updated'           => 'Total de Registros Actualizados:',
                    'validate'                => 'Validar',
                    'validate-info'           => 'Haz clic en Validar Datos para comprobar tu importación.',
                    'validating-info'         => 'La lectura y validación de los datos ha comenzado',
                    'validation-failed-info'  => 'Tu importación no es válida. Por favor, corrige los siguientes errores e intenta de nuevo.',
                    'validation-success-info' => 'Tu importación es válida. Haz clic en Importar para iniciar el proceso de importación.',
                ],
                'create-success'    => 'Importación creada exitosamente.',
                'delete-failed'     => 'La eliminación de la importación falló inesperadamente.',
                'delete-success'    => 'Importación eliminada exitosamente.',
                'not-valid'         => 'La importación no es válida',
                'nothing-to-import' => 'No hay recursos para importar.',
                'setup-queue-error' => 'Por favor, cambia tu controlador de cola a "database" o "redis" para iniciar el proceso de importación.',
                'update-success'    => 'Importación actualizada exitosamente.',
            ],
        ],
    ],
    'activities' => [
        'index' => [
            'title'    => 'Actividades',
            'datagrid' => [
                'comment'       => 'Comentario',
                'created_at'    => 'Creado En',
                'created_by'    => 'Creado Por',
                'edit'          => 'Editar',
                'id'            => 'ID',
                'done'          => 'Completado',
                'not-done'      => 'No Completado',
                'lead'          => 'Oportunidad',
                'mass-delete'   => 'Eliminación Masiva',
                'mass-update'   => 'Actualización Masiva',
                'schedule-from' => 'Programar Desde',
                'schedule-to'   => 'Programar Hasta',
                'schedule_from' => 'Programar Desde',
                'schedule_to'   => 'Programar Hasta',
                'title'         => 'Título',
                'is_done'       => 'Completado',
                'type'          => 'Tipo',
                'update'        => 'Actualizar',
                'call'          => 'Llamada',
                'meeting'       => 'Reunión',
                'lunch'         => 'Almuerzo',
            ],
        ],
        'edit' => [
            'title'           => 'Editar Actividad',
            'back-btn'        => 'Volver',
            'save-btn'        => 'Guardar Actividad',
            'type'            => 'Tipo de Actividad',
            'call'            => 'Llamada',
            'meeting'         => 'Reunión',
            'lunch'           => 'Almuerzo',
            'schedule_to'     => 'Programar Hasta',
            'schedule_from'   => 'Programar Desde',
            'location'        => 'Ubicación',
            'comment'         => 'Comentario',
            'lead'            => 'Oportunidad',
            'participants'    => 'Participantes',
            'general'         => 'General',
            'persons'         => 'Personas',
            'no-result-found' => 'No se encontraron registros.',
            'users'           => 'Usuarios',
        ],
        'updated'              => 'Actualizado :attribute',
        'created'              => 'Creado',
        'duration-overlapping' => 'Los participantes tienen otra reunión en este momento. ¿Deseas continuar?',
        'create-success'       => 'Actividad creada con éxito.',
        'update-success'       => 'Actividad actualizada con éxito.',
        'overlapping-error'    => 'Los participantes tienen otra reunión en este momento.',
        'destroy-success'      => 'Actividad eliminada con éxito.',
        'delete-failed'        => 'No se puede eliminar la actividad.',
        'mass-update-success'  => 'Actividades actualizadas con éxito.',
        'mass-destroy-success' => 'Actividades eliminadas con éxito.',
        'mass-delete-failed'   => 'No se pueden eliminar las actividades.',
    ],
    'mail' => [
        'index' => [
            'compose'          => 'Redactar',
            'draft'            => 'Borrador',
            'inbox'            => 'Bandeja de entrada',
            'outbox'           => 'Bandeja de salida',
            'sent'             => 'Enviados',
            'trash'            => 'Papelera',
            'compose-mail-btn' => 'Redactar Correo',
            'btn'              => 'Correo',
            'mail'             => [
                'title'        => 'Redactar Correo',
                'to'           => 'Para',
                'enter-emails' => 'Presiona enter para añadir correos',
                'cc'           => 'CC',
                'bcc'          => 'BCC',
                'subject'      => 'Asunto',
                'send-btn'     => 'Enviar',
                'message'      => 'Mensaje',
                'draft'        => 'Borrador',
            ],
            'datagrid' => [
                'id'            => 'ID',
                'from'          => 'De',
                'to'            => 'Para',
                'subject'       => 'Asunto',
                'tags'          => 'Etiquetas',
                'content'       => 'Contenido',
                'attachments'   => 'Archivos adjuntos',
                'date'          => 'Fecha',
                'move-to-inbox' => 'Mover a la bandeja de entrada',
                'move-to-trash' => 'Movido a la papelera',
                'edit'          => 'Editar',
                'view'          => 'Ver',
                'delete'        => 'Eliminar',
            ],
        ],
        'create-success'      => 'Correo enviado con éxito.',
        'update-success'      => 'Correo actualizado con éxito.',
        'mass-update-success' => 'Correos actualizados con éxito.',
        'delete-success'      => 'Correo eliminado con éxito.',
        'delete-failed'       => 'No se puede eliminar el correo.',
        'view'                => [
            'title'                      => 'Correos',
            'subject'                    => ':subject',
            'link-mail'                  => 'Enlace de Correo',
            'to'                         => 'Para',
            'cc'                         => 'CC',
            'bcc'                        => 'BCC',
            'reply'                      => 'Responder',
            'reply-all'                  => 'Responder a Todos',
            'forward'                    => 'Reenviar',
            'delete'                     => 'Eliminar',
            'enter-mails'                => 'Ingresar id de correo',
            'rotten-days'                => 'El lead está en estado crítico por :days días',
            'search-an-existing-lead'    => 'Buscar un lead existente',
            'search-an-existing-contact' => 'Buscar un contacto existente',
            'message'                    => 'Mensaje',
            'add-attachments'            => 'Añadir Archivos Adjuntos',
            'discard'                    => 'Descartar',
            'send'                       => 'Enviar',
            'no-result-found'            => 'No se encontraron resultados',
            'add-new-contact'            => 'Añadir Nuevo Contacto',
            'description'                => 'Descripción',
            'search'                     => 'Buscar...',
            'add-new-lead'               => 'Añadir Nuevo Lead',
            'create-new-contact'         => 'Crear Nuevo Contacto',
            'save-contact'               => 'Guardar Contacto',
            'create-lead'                => 'Crear Lead',
            'linked-contact'             => 'Contacto Vinculado',
            'link-to-contact'            => 'Vincular a Contacto',
            'link-to-lead'               => 'Vincular a Lead',
            'linked-lead'                => 'Lead Vinculado',
            'lead-details'               => 'Detalles del Lead',
            'contact-person'             => 'Persona de Contacto',
            'product'                    => 'Producto',
            'tags'                       => [
                'create-success'  => 'Etiqueta creada con éxito.',
                'destroy-success' => 'Etiqueta eliminada con éxito.',
            ],
        ],
    ],
    'common' => [
        'custom-attributes' => [
            'add-more'             => 'Añadir Más',
            'address'              => 'Dirección',
            'city'                 => 'Ciudad',
            'contact'              => 'Números de Contacto',
            'country'              => 'País',
            'email'                => 'Correo Electrónico',
            'home'                 => 'Hogar',
            'postcode'             => 'Código Postal',
            'save'                 => 'Guardar',
            'select'               => 'Seleccionar',
            'select-country'       => 'Seleccionar País',
            'select-state'         => 'Seleccionar Estado',
            'state'                => 'Estado',
            'update-contact-title' => 'Actualizar Números de Contacto',
            'update-emails-title'  => 'Actualizar Correos Electrónicos de Contacto',
            'work'                 => 'Trabajo',
        ],
    ],
    'leads' => [
        'create-success'  => 'Lead creado exitosamente.',
        'update-success'  => 'Lead actualizado exitosamente.',
        'update-failed'   => 'No se pueden eliminar los clientes potenciales.',
        'destroy-success' => 'Lead eliminado exitosamente.',
        'destroy-failed'  => 'No se puede eliminar el lead.',
        'file'            => [
            'data-not-found'         => 'Datos no encontrados.',
            'empty-content'          => 'El contenido del PDF está vacío o no se pudo extraer.',
            'failed-extract'         => 'No se pudo extraer el texto del archivo.',
            'insufficient-info'      => 'Debido a datos insuficientes, no podemos procesar su solicitud en este momento.',
            'invalid-base64'         => 'Formato base64 inválido.',
            'invalid-format'         => 'Formato JSON inválido.',
            'invalid-response'       => 'Formato de respuesta de IA inválido.',
            'missing-api-key'        => 'Falta la clave API o la configuración del modelo.',
            'not-found'              => 'Archivo no encontrado.',
            'recursive-call'         => 'Se detectó una llamada recursiva.',
            'text-generation-failed' => 'La extracción de texto falló. El archivo podría estar vacío o ilegible.',
        ],
        'index' => [
            'title'      => 'Leads',
            'create-btn' => 'Crear Lead',
            'datagrid'   => [
                'id'             => 'ID',
                'sales-person'   => 'Persona de Ventas',
                'subject'        => 'Asunto',
                'source'         => 'Fuente',
                'lead-value'     => 'Valor del Lead',
                'lead-type'      => 'Tipo de cliente potencial',
                'tag-name'       => 'Nombre de la etiqueta',
                'contact-person' => 'Persona de Contacto',
                'stage'          => 'Etapa',
                'rotten-lead'    => 'Lead Podrido',
                'date-to'        => 'Fecha Hasta',
                'created-at'     => 'Creado En',
                'no'             => 'No',
                'yes'            => 'Sí',
                'delete'         => 'Eliminar',
                'mass-delete'    => 'Eliminar en Masa',
                'mass-update'    => 'Actualizar en Masa',
            ],
            'kanban' => [
                'rotten-days'            => 'El lead está podrido desde hace :days días',
                'empty-list'             => 'Tu lista de leads está vacía',
                'empty-list-description' => 'Crea un lead para organizar tus objetivos.',
                'create-lead-btn'        => 'Crear Lead',
                'columns'                => [
                    'contact-person'      => 'Persona de Contacto',
                    'id'                  => 'ID',
                    'lead-type'           => 'Tipo de Lead',
                    'lead-value'          => 'Valor del Lead',
                    'sales-person'        => 'Persona de Ventas',
                    'source'              => 'Fuente',
                    'title'               => 'Título',
                    'tags'                => 'Etiquetas',
                    'expected-close-date' => 'Fecha de Cierre Esperada',
                    'created-at'          => 'Creado En',
                ],
                'toolbar' => [
                    'search' => [
                        'title' => 'Buscar por título',
                    ],
                    'filters' => [
                        'apply-filters' => 'Aplicar Filtros',
                        'clear-all'     => 'Limpiar Todo',
                        'filter'        => 'Filtrar',
                        'filters'       => 'Filtros',
                        'from'          => 'De',
                        'select'        => 'Seleccionar',
                        'to'            => 'A',
                    ],
                ],
            ],
            'view-switcher' => [
                'all-pipelines'       => 'Todos los Canales',
                'create-new-pipeline' => 'Crear Nuevo Canal',
            ],
            'upload' => [
                'create-lead'   => 'Crear Lead Usando IA',
                'file'          => 'Carga de archivo',
                'file-info'     => 'Solo se aceptan archivos en formato pdf, bmp, jpg, jpeg, png.',
                'file-required' => 'Por favor, selecciona al menos un archivo válido para continuar.',
                'save-btn'      => 'Guardar',
                'upload-file'   => 'Subir archivo',
            ],
        ],
        'create' => [
            'title'          => 'Crear Lead',
            'save-btn'       => 'Guardar',
            'details'        => 'Detalles',
            'details-info'   => 'Introduce la Información Básica del Lead',
            'contact-person' => 'Persona de Contacto',
            'contact-info'   => 'Información Sobre la Persona de Contacto',
            'products'       => 'Productos',
            'products-info'  => 'Información Sobre los Productos',
        ],
        'edit' => [
            'title'          => 'Editar Lead',
            'save-btn'       => 'Guardar',
            'details'        => 'Detalles',
            'details-info'   => 'Introduce la Información Básica del Lead',
            'contact-person' => 'Persona de Contacto',
            'contact-info'   => 'Información Sobre la Persona de Contacto',
            'products'       => 'Productos',
            'products-info'  => 'Información Sobre los Productos',
        ],
        'common' => [
            'contact' => [
                'name'           => 'Nombre',
                'email'          => 'Correo Electrónico',
                'contact-number' => 'Número de Contacto',
                'organization'   => 'Organización',
            ],
            'products' => [
                'product-name' => 'Nombre del Producto',
                'quantity'     => 'Cantidad',
                'price'        => 'Precio',
                'amount'       => 'Monto',
                'action'       => 'Acción',
                'add-more'     => 'Agregar Más',
                'total'        => 'Total',
            ],
        ],
        'view' => [
            'title'       => 'Lead: :title',
            'rotten-days' => ':days Días',
            'tabs'        => [
                'description' => 'Descripción',
                'products'    => 'Productos',
                'quotes'      => 'Cotizaciones',
            ],
            'attributes' => [
                'title' => 'Sobre el Lead',
            ],
            'quotes' => [
                'subject'         => 'Asunto',
                'expired-at'      => 'Expirado En',
                'sub-total'       => 'Subtotal',
                'discount'        => 'Descuento',
                'tax'             => 'Impuesto',
                'adjustment'      => 'Ajuste',
                'grand-total'     => 'Total General',
                'delete'          => 'Eliminar',
                'edit'            => 'Editar',
                'download'        => 'Descargar',
                'destroy-success' => 'Cotización eliminada exitosamente.',
                'empty-title'     => 'No se Encontraron Cotizaciones',
                'empty-info'      => 'No se Encontraron Cotizaciones para este Lead',
                'add-btn'         => 'Agregar Cotización',
            ],
            'products' => [
                'product-name' => 'Nombre del Producto',
                'quantity'     => 'Cantidad',
                'price'        => 'Precio',
                'amount'       => 'Monto',
                'action'       => 'Acción',
                'add-more'     => 'Agregar Más',
                'total'        => 'Total',
                'empty-title'  => 'No se Encontraron Productos',
                'empty-info'   => 'No se Encontraron Productos para este Lead',
                'add-product'  => 'Agregar Producto',
            ],
            'persons' => [
                'title'     => 'Sobre las Personas',
                'job-title' => ':job_title en :organization',
            ],
            'stages' => [
                'won-lost'       => 'Ganado/Perdido',
                'won'            => 'Ganado',
                'lost'           => 'Perdido',
                'need-more-info' => 'Necesita Más Información',
                'closed-at'      => 'Cerrado En',
                'won-value'      => 'Valor Ganado',
                'lost-reason'    => 'Razón de la Pérdida',
                'save-btn'       => 'Guardar',
            ],
            'tags' => [
                'create-success'  => 'Etiqueta creada con éxito.',
                'destroy-success' => 'Etiqueta eliminada con éxito.',
            ],
        ],
    ],
    'configuration' => [
        'index' => [
            'back'           => 'Regresar',
            'delete'         => 'Eliminar',
            'save-btn'       => 'Guardar Configuración',
            'save-success'   => 'Configuración Guardada Exitosamente.',
            'search'         => 'Buscar',
            'select-country' => 'Seleccionar País',
            'select-state'   => 'Seleccionar Estado',
            'title'          => 'Configuración',
            'general'        => [
                'title'   => 'General',
                'info'    => 'Configuración General',
                'general' => [
                    'title'           => 'General',
                    'info'            => 'Actualiza tus configuraciones generales aquí.',
                    'locale-settings' => [
                        'title'      => 'Configuraciones de Idioma',
                        'title-info' => 'Define el idioma utilizado en la interfaz de usuario, como Árabe (ar), Inglés (en), Español (es), Persa (fa) y Turco (tr).',
                    ],
                    'admin-logo' => [
                        'logo-image' => 'Imagen del Logo',
                        'title'      => 'Logo del Administrador',
                        'title-info' => 'Configura la imagen del logo para tu panel de administración.',
                    ],
                ],
                'settings' => [
                    'title'  => 'Configuraciones',
                    'info'   => 'Actualiza tus configuraciones aquí.',
                    'footer' => [
                        'info'       => 'Podemos configurar la sección de powered by aquí.',
                        'powered-by' => 'Editor de texto impulsado por',
                        'title'      => 'Configuraciones de la Sección Powered by',
                    ],
                    'menu' => [
                        'activities'    => 'Actividades',
                        'configuration' => 'Configuración',
                        'contacts'      => 'Contactos',
                        'dashboard'     => 'Tablero',
                        'draft'         => 'Borrador',
                        'inbox'         => 'Bandeja de Entrada',
                        'info'          => 'Podemos configurar los nombres de los elementos del menú aquí.',
                        'leads'         => 'Leads',
                        'mail'          => 'Correo',
                        'organizations' => 'Organizaciones',
                        'outbox'        => 'Bandeja de Salida',
                        'persons'       => 'Personas',
                        'products'      => 'Productos',
                        'quotes'        => 'Cotizaciones',
                        'sent'          => 'Enviados',
                        'settings'      => 'Configuraciones',
                        'title'         => 'Configuraciones de Elementos del Menú',
                        'trash'         => 'Papelera',
                    ],
                    'menu-color' => [
                        'brand-color' => 'Brand Color',
                        'info'        => 'Podemos cambiar los colores de los elementos del menú aquí.',
                        'title'       => 'Configuraciones de Color de Elementos del Menú',
                    ],
                ],
            ],
            'email' => [
                'title' => 'Configuración de Correo Electrónico',
                'info'  => 'Configuración de correo electrónico para la aplicación.',
                'imap'  => [
                    'title'   => 'Configuración IMAP',
                    'info'    => 'Configuración de correo electrónico IMAP para recibir correos electrónicos.',
                    'account' => [
                        'title'         => 'Cuenta IMAP',
                        'title-info'    => 'Configura los ajustes de tu cuenta IMAP aquí.',
                        'host'          => 'Host',
                        'port'          => 'Puerto',
                        'encryption'    => 'Tipo de Cifrado',
                        'validate-cert' => 'Validar Certificado SSL',
                        'username'      => 'Nombre de Usuario IMAP',
                        'password'      => 'Contraseña IMAP',
                    ],
                ],
            ],
            'magic-ai' => [
                'title'    => 'Magic AI',
                'info'     => 'Configuración de Magic AI para la aplicación.',
                'settings' => [
                    'api-key'             => 'Clave API',
                    'api-key-info'        => 'Recuerda usar una clave API de OpenRouter para cada modelo. Es un paso simple para mejorar la seguridad y el rendimiento.',
                    'enable'              => 'Habilitar',
                    'info'                => 'Mejora tu experiencia con Magic AI con tu clave API de OpenRouter. ¡Intégrala ahora para una aventura de IA personalizada y sin problemas, hecha a tu medida! Personaliza la configuración sin esfuerzo y toma el control de tu viaje de IA.',
                    'other'               => 'Otro Modelo',
                    'other-model'         => 'Para otros modelos, usa el ID del Modelo de OpenRouter.',
                    'doc-generation'      => 'Generación de DOC',
                    'doc-generation-info' => 'Habilita la función de generación de DOC para extraer automáticamente datos de archivos DOC y convertirlos a formato de texto. Mejora tu productividad y eficiencia habilitando esta función para agilizar tu flujo de trabajo.',
                    'title'               => 'Configuraciones Generales',
                    'models'              => [
                        'deepseek-r1'           => 'Deepseek R1 Distill-llama-8b',
                        'gemini-2-0-flash-001'  => 'Gemini 2.0 flash-001',
                        'gpt-4o'                => 'GPT-4.0',
                        'gpt-4o-mini'           => 'GPT-4.0 mini',
                        'grok-2-1212'           => 'Grok 2.12',
                        'llama-3-2-3b-instruct' => 'Llama 3.2 3b Instruct',
                        'title'                 => 'Modelos',
                    ],
                ],
            ],
        ],
    ],
    'dashboard' => [
        'index' => [
            'title'   => 'Tablero',
            'revenue' => [
                'lost-revenue' => 'Ingresos Perdidos',
                'won-revenue'  => 'Ingresos Ganados',
            ],
            'over-all' => [
                'average-lead-value'    => 'Valor Promedio de Lead',
                'total-leads'           => 'Total de Leads',
                'average-leads-per-day' => 'Leads Promedio por Día',
                'total-quotations'      => 'Total de Cotizaciones',
                'total-persons'         => 'Total de Personas',
                'total-organizations'   => 'Total de Organizaciones',
            ],
            'total-leads' => [
                'title' => 'Leads',
                'total' => 'Total de Leads',
                'won'   => 'Leads Ganados',
                'lost'  => 'Leads Perdidos',
            ],
            'revenue-by-sources' => [
                'title'       => 'Ingresos por Fuentes',
                'empty-title' => 'No Hay Datos Disponibles',
                'empty-info'  => 'No hay datos disponibles para el intervalo seleccionado',
            ],
            'revenue-by-types' => [
                'title'       => 'Ingresos por Tipos',
                'empty-title' => 'No Hay Datos Disponibles',
                'empty-info'  => 'No hay datos disponibles para el intervalo seleccionado',
            ],
            'top-selling-products' => [
                'title'       => 'Productos Más Vendidos',
                'empty-title' => 'No Se Encontraron Productos',
                'empty-info'  => 'No hay productos disponibles para el intervalo seleccionado',
            ],
            'top-persons' => [
                'title'       => 'Personas Más Destacadas',
                'empty-title' => 'No Se Encontraron Personas',
                'empty-info'  => 'No hay personas disponibles para el intervalo seleccionado',
            ],
            'open-leads-by-states' => [
                'title'       => 'Leads Abiertos por Etapas',
                'empty-title' => 'No Hay Datos Disponibles',
                'empty-info'  => 'No hay datos disponibles para el intervalo seleccionado',
            ],
        ],
    ],
    'layouts' => [
        'app-version' => 'Versión: :version',
        'dashboard'   => 'Tablero',
        'leads'       => 'Leads',
        'quotes'      => 'Cotizaciones',
        'quote'       => 'Cotización',
        'mail'        => [
            'title'   => 'Correo',
            'compose' => 'Redactar',
            'inbox'   => 'Bandeja de Entrada',
            'draft'   => 'Borradores',
            'outbox'  => 'Enviados',
            'sent'    => 'Enviados',
            'trash'   => 'Papelera',
            'setting' => 'Configuración',
        ],
        'activities'           => 'Actividades',
        'contacts'             => 'Contactos',
        'persons'              => 'Personas',
        'person'               => 'Persona',
        'organizations'        => 'Organizaciones',
        'organization'         => 'Organización',
        'products'             => 'Productos',
        'product'              => 'Producto',
        'settings'             => 'Configuraciones',
        'user'                 => 'Usuario',
        'user-info'            => 'Administra todos tus usuarios y sus permisos en el CRM, lo que están autorizados a hacer.',
        'groups'               => 'Grupos',
        'groups-info'          => 'Agregar, editar o eliminar grupos del CRM',
        'roles'                => 'Roles',
        'role'                 => 'Rol',
        'roles-info'           => 'Agregar, editar o eliminar roles del CRM',
        'users'                => 'Usuarios',
        'users-info'           => 'Agregar, editar o eliminar usuarios del CRM',
        'lead'                 => 'Lead',
        'lead-info'            => 'Administra todas las configuraciones relacionadas con los leads en el CRM',
        'pipelines'            => 'Pipelines',
        'pipelines-info'       => 'Agregar, editar o eliminar pipelines del CRM',
        'sources'              => 'Fuentes',
        'sources-info'         => 'Agregar, editar o eliminar fuentes del CRM',
        'types'                => 'Tipos',
        'types-info'           => 'Agregar, editar o eliminar tipos del CRM',
        'automation'           => 'Automatización',
        'automation-info'      => 'Administra todas las configuraciones relacionadas con la automatización en el CRM',
        'attributes'           => 'Atributos',
        'attribute'            => 'Atributo',
        'attributes-info'      => 'Agregar, editar o eliminar atributos del CRM',
        'email-templates'      => 'Plantillas de Correo',
        'email'                => 'Correo',
        'email-templates-info' => 'Agregar, editar o eliminar plantillas de correo del CRM',
        'events'               => 'Eventos',
        'events-info'          => 'Agregar, editar o eliminar eventos del CRM',
        'campaigns'            => 'Campañas',
        'campaigns-info'       => 'Agregar, editar o eliminar campañas del CRM',
        'workflows'            => 'Flujos de Trabajo',
        'workflows-info'       => 'Agregar, editar o eliminar flujos de trabajo del CRM',
        'webhooks'             => 'Webhooks',
        'webhooks-info'        => 'Agregar, editar o eliminar webhooks desde CRM',
        'other-settings'       => 'Otras Configuraciones',
        'other-settings-info'  => 'Administra todas tus configuraciones adicionales en el CRM',
        'tags'                 => 'Etiquetas',
        'tags-info'            => 'Agregar, editar o eliminar etiquetas del CRM',
        'my-account'           => 'Mi Cuenta',
        'sign-out'             => 'Cerrar Sesión',
        'back'                 => 'Volver',
        'name'                 => 'Nombre',
        'configuration'        => 'Configuración',
        'howdy'                => '¡Hola!',
        'warehouses'           => 'Almacenes',
        'warehouse'            => 'Almacén',
        'warehouses-info'      => 'Agregar, editar o eliminar almacenes del CRM',
        'data_transfer'        => 'Transferencia de Datos',
        'data_transfer_info'   => 'Gestionar la configuración relacionada con la transferencia de datos de personas, productos y clientes potenciales en el CRM',
    ],
    'user' => [
        'account' => [
            'name'                 => 'Nombre',
            'email'                => 'Correo Electrónico',
            'password'             => 'Contraseña',
            'my_account'           => 'Mi cuenta',
            'update_details'       => 'Actualizar Detalles',
            'current_password'     => 'Contraseña Actual',
            'confirm_password'     => 'Confirmar Contraseña',
            'password-match'       => 'La contraseña actual no coincide.',
            'account-save'         => 'Cambios en la cuenta guardados exitosamente.',
            'permission-denied'    => 'Permiso Denegado',
            'remove-image'         => 'Eliminar Imagen',
            'upload_image_pix'     => 'Sube una Imagen de Perfil (100px x 100px)',
            'upload_image_format'  => 'en formato PNG o JPG',
            'image_upload_message' => 'Solo se permiten imágenes (.jpeg, .jpg, .png, ..).',
        ],
    ],
    'emails' => [
        'common' => [
            'dear'   => 'Estimado/a :name',
            'cheers' => 'Saludos,</br>Equipo :app_name',
            'user'   => [
                'dear'            => 'Estimado/a :username',
                'create-subject'  => 'Has sido agregado como miembro.',
                'create-body'     => '¡Felicidades! Ahora eres miembro de nuestro equipo.',
                'forget-password' => [
                    'subject'        => 'Restablecimiento de Contraseña del Cliente',
                    'dear'           => 'Estimado/a :username',
                    'reset-password' => 'Restablecer Contraseña',
                    'info'           => 'Estás recibiendo este correo porque recibimos una solicitud de restablecimiento de contraseña para tu cuenta',
                    'final-summary'  => 'Si no solicitaste el restablecimiento de contraseña, no se requiere ninguna acción adicional',
                    'thanks'         => '¡Gracias!',
                ],
            ],
        ],
    ],
    'validations' => [
        'message' => [
            'decimal' => 'El :attribute debe ser un número decimal.',
        ],
    ],
    'errors' => [
        'dashboard'   => 'Tablero',
        'go-back'     => 'Volver',
        'support'     => 'Si el problema persiste, contáctanos en <a href=":link" class=":class">:email</a> para obtener ayuda.',
        '404'         => [
            'description' => '¡Ups! La página que estás buscando está de vacaciones. Parece que no pudimos encontrar lo que estabas buscando.',
            'title'       => '404 Página No Encontrada',
        ],
        '401' => [
            'description' => '¡Ups! Parece que no tienes permiso para acceder a esta página. Parece que te faltan las credenciales necesarias.',
            'title'       => '401 No Autorizado',
        ],
        '403' => [
            'description' => '¡Ups! Esta página está fuera de límites. Parece que no tienes los permisos necesarios para ver este contenido.',
            'title'       => '403 Prohibido',
        ],
        '500' => [
            'description' => '¡Ups! Algo salió mal. Parece que tenemos problemas para cargar la página que estás buscando.',
            'title'       => '500 Error Interno del Servidor',
        ],
        '503' => [
            'description' => '¡Ups! Parece que estamos temporalmente fuera de servicio por mantenimiento. Vuelve a intentarlo en un rato.',
            'title'       => '503 Servicio No Disponible',
        ],
    ],
    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Descargar',
        'export'     => 'Exportar',
        'no-records' => 'No se encontraron registros.',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],
];
