<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Ελληνικά (Greek)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Kostas Malavazos
* Evangelos Emmanouilidis
* Angelos Diakoumakos (https://arbitrans.gr)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Ελληνικά';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Greek';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Απαντήστε πάνω από αυτή τη γραμμή ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Νέο αίτημα: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Αίτημα παραλήφθηκε: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Αίτημα ανατέθηκε: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Νέα απάντηση σε: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Νέα απάντηση σε: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Αίτημα μετακινήθηκε: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Προστέθηκε σημέιωση στο: %%SUBJECT%%';
$hesklang['new_pm']='Νέο ιδιωτικό μήνυμα: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Λίστα των αιτημάτων υποστήριξή σας';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Δεν μπορεί να γίνει σύνδεση με την βάση δεδομένων!';
$hesklang['invalid_action']='Ακυρη ενέργεια';
$hesklang['select_username']='Παρακαλώ είσαγετε το όνομα χρήστη';
$hesklang['enter_pass']='Παρακαλώ εισάγετε τον κωδικό πρόσβασης';
$hesklang['cant_sql']='Δεν μπορεί να εκτελεστεί SQL';
$hesklang['contact_webmsater']='Παρακαλώ ενημερώστε τον webmaster στο';
$hesklang['mysql_said']='MySQL είπε';
$hesklang['wrong_pass']='Λάθος κωδικός πρόσβασης.';
$hesklang['session_expired']='Η σύνοδός σας έχει λήξει, μπορείτε να συνδεθείτε χρησιμοποιώντας την παρακάτω φόρμα.';
$hesklang['attempt']='Ακυρη προσπάθεια!';
$hesklang['not_authorized_tickets']='Δεν έχετε δικαίωμα να δείτε τα αιτήματα μέσα σ\' αυτή την κατηγορία!';
$hesklang['must_be_admin']='Δεν έχετε δικαίωμα να δείτε αυτή την σελίδα! Για να δείτε αυτή την σελίδα πρέπει να εισέλθετε σαν διαχειριστής.';
$hesklang['no_session']='Δεν μπορείτε να ξεκινήσετε καινούργια σύνοδο!';
$hesklang['error']='Λάθος';
$hesklang['int_error']='Εσωτερικό λάθος στο script';
$hesklang['no_trackID']='Δεν υπάρχει ID Παρακολούθησης';
$hesklang['status_not_valid']='Η κατάσταση δεν είναι έγκυρη';
$hesklang['trackID_not_found']='Το ID Παρακολούθησης δεν βρέθηκε';
$hesklang['enter_message']='Παρακαλώ εισάγετε το μήνυμά σας';
$hesklang['select_priority']='Παρακαλώ επιλέξτε προτεραιότητα';
$hesklang['ticket_not_found']='Το Αίτημα δεν βρέθηκε! Παρακαλώ επιβεβαιώστε ότι εισάγατε το σωστό ID παρακολούθησης!';
$hesklang['no_selected']='Δεν επιλέχτηκαν αιτήματα, δεν θα γίνει καμία αλλαγή';
$hesklang['id_not_valid']='Αυτό δεν είναι έγκυρο ID';
$hesklang['enter_id']='Παρακαλώ εισάγετε ID παρακολούθησης';
$hesklang['enter_name']='Παρακαλώ εισάγετε όνομα πελάτη';
$hesklang['enter_date']='Παρακαλώ εισάγετε την ημερομηνία που θέλετε να αναζητήσετε';
$hesklang['date_not_valid']='Δεν είναι σωστή η ημερομηνία. Παρακαλώ εισάγετε ημερομηνία σε μορφή<b>ΜΜ-ΗΗ-ΕΕΕΕ</b>.';
$hesklang['enter_subject']='Παρακαλώ εισάγετε θέμα στο αίτημα';
$hesklang['invalid_search']='Ακυρη ενέργεια αναζήτησης';
$hesklang['choose_cat_ren']='Παρακαλώ επιλέξτε μια κατηγορία για να μετονομαστεί';
$hesklang['cat_ren_name']='Παρακαλώ γράψτε νέο όνομα κατηγορίας';
$hesklang['cat_not_found']='Η κατηγορία δεν βρέθηκε';
$hesklang['enter_cat_name']='Παρακαλώ εισάγετε όνομα κατηγορίας';
$hesklang['no_cat_id']='Δεν υπάρχει το ID Κατηγορίας';
$hesklang['cant_del_default_cat']='Δεν μπορείτε να διαγράψετε την προεπιλεγμένη κατηγορία, μπορείτε μόνο να την μετονομάσετε';
$hesklang['no_valid_id']='Δεν ισχύει το ID χρήστη';
$hesklang['user_not_found']='Ο χρήστης δεν βρέθηκε';
$hesklang['enter_real_name']='Παρακαλώ εισάγετε το πραγματικό όνομα του χρήστη';
$hesklang['enter_valid_email']='Παρακαλώ εισάγετε μια έγκυρη email διεύθυνση';
$hesklang['enter_username']='Παρακαλώ εισάγετε όνομα χρήστη (login)';
$hesklang['asign_one_cat']='Παρακαλώ να ορίσετε το χρήστη σε τουλάχιστον μία κατηγορία!';
$hesklang['signature_long']='Η υπογραφή του χρήστη είναι πολύ μεγάλη! Παρακαλώ περιορίστε την υπογραφή σε 255 χαρακτήρες';
$hesklang['confirm_user_pass']='Παρακαλώ επιβεβαιώστε τον κωδικό πρόσβασης';
$hesklang['passwords_not_same']='Οι δύο κωδικοί πρόσβασης δεν είναι ίδιοι!';
$hesklang['cant_del_admin']='Δεν μπορείτε να διαγράψετε τον προεπιλεγμένο διαχειριστή!';
$hesklang['cant_del_own']='Δεν μπορείτε να διαγράψετε το προφίλ με το οποίο έχετε εισέλθει!';
$hesklang['enter_your_name']='Παρακαλώ εισάγετε το ονοματεπώνυμό σας';
$hesklang['sel_app_cat']='Παρακαλώ επιλέξτε την κατάλληλη κατηγορία';
$hesklang['sel_app_priority']='Παρακαλώ επιλέξτε την κατάλληλη προτεραιότητα';
$hesklang['enter_ticket_subject']='Παρακαλώ εισάγετε το θέμα του αιτήματος';
$hesklang['user_not_found_nothing_edit']='Ο χρήστης δεν βρέθηκε ή δεν υπάρχει κάτι να αλλάξει';

// ADMIN PANEL
$hesklang['administrator']='Διαχειριστής';
$hesklang['login']='Σύνδεση';
$hesklang['user']='Χρήστης';
$hesklang['username']='Όνομα Χρήστη';
$hesklang['pass']='Κωδικός Πρόσβασης';
$hesklang['confirm_pass']='Επιβεβαίωση Κωδικού Πρόσβασης';
$hesklang['logged_out']='Αποσυνδεθείτε';
$hesklang['logout']='Αποσύνδεση';
$hesklang['logout_success']='Έχετε αποσυνδεθεί επιτυχώς!';
$hesklang['click_login']='Κλικ για σύνδεση';
$hesklang['back']='Πάτε πίσω';
$hesklang['displaying_pages']='Προβολή <b>%d</b> Αιτημάτων. Σελίδες:';
$hesklang['trackID']='ID Παρακολούθησης';
$hesklang['timestamp']='Χρονοσφραγίδα';
$hesklang['name']='Όνομα';
$hesklang['subject']='Θέμα';
$hesklang['status']='Κατάσταση';
$hesklang['priority']='Προτεραιότητα';
$hesklang['open']='Νέο';
$hesklang['open_action']='Ανοιγμα Αιτήματος'; // Open ACTION
$hesklang['close']='Κλειστό'; // Closed ticket STATUS
$hesklang['any_status']='Οποιαδήποτε κατάσταση';
$hesklang['high']='Υψηλή';
$hesklang['medium']='Μεσαία';
$hesklang['low']='Χαμηλή';
$hesklang['del_selected']='Διαγραφή επιλεγμένων αιτημάτων';
$hesklang['manage_cat']='Διαχείριση κατηγοριών';
$hesklang['profile']='Το προφίλ σας';
$hesklang['show_tickets']='Προβολή Αιτημάτων';
$hesklang['sort_by']='Ταξινόμηση κατά';
$hesklang['date_posted']='Ημερομηνία καταχώρησης';
$hesklang['category']='Κατηγορία';
$hesklang['any_cat']='Οποιαδήποτε κατηγορία';
$hesklang['order']='Ταξινόμηση';
$hesklang['ascending']='αύξουσα';
$hesklang['descending']='φθίνουσα';
$hesklang['display']='Προβολή';
$hesklang['tickets_page']='αιτήματα ανά σελίδα';
$hesklang['find_ticket']='Εύρεση αιτήματος';
$hesklang['yyyy_mm_dd']='ΕΕΕΕ-ΜΜ-ΗΗ';
$hesklang['results_page']='αποτελέσματα ανά σελίδα';
$hesklang['opened']='άνοιξε'; // The ticket has been OPENED
$hesklang['closed']='Επιλυμένο'; // Ticket has been RESOLVED
$hesklang['ticket']='Αίτημα';
$hesklang['tickets']='Αιτήματα';
$hesklang['ticket_been']='Αυτό το αίτημα έχει';
$hesklang['view_ticket']='Δείτε το αίτημα';
$hesklang['open_tickets']='Ανοικτά αιτήματα';
$hesklang['remove_statement']='Αφαίρεση της αναφοράς &quot;Powered by&quot;';
$hesklang['click_info']='Πάτησε εδώ για περισσότερες πληροφορίες';
$hesklang['reply_added']='Η απάντηση προστέθηκε';
$hesklang['reply_submitted']='Η απάντηση υποβλήθηκε';
$hesklang['ticket_marked']='Το αίτημα έχει σημειωθεί';
$hesklang['ticket_status']='Κατάσταση αιτήματος';
$hesklang['replies']='Απαντήσεις';
$hesklang['date']='Ημερομηνία';
$hesklang['email']='Email';
$hesklang['ip']='IP';
$hesklang['message']='Μήνυμα';
$hesklang['add_reply']='Προσθήκη απάντησης';
$hesklang['close_this_ticket']='Κλείσιμο αυτού του αιτήματος';
$hesklang['change_priority']='Αλλαγή προτεραιότητας σε';
$hesklang['attach_sign']='Επισύναψη υπογραφής';
$hesklang['profile_settings']='Ρυθμίσεις προφίλ';
$hesklang['submit_reply']='Υποβολή απάντησης';
$hesklang['support_panel']='Πίνακας Υποστήριξης';
$hesklang['ticket_trackID']='ID Παρακολούθησης Αιτήματος';
$hesklang['c2c']='Κλικ για να συνεχίσετε';
$hesklang['tickets_deleted']='Τα αιτήματα διαγράφηκαν';
$hesklang['num_tickets_deleted']='<b>%d</b> αιτήματα έχουν ήδη διαγραφεί';
$hesklang['confirm_del_cat']='Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή την κατηγορία;?';
$hesklang['cat_intro']='Εδώ μπορείτε να διαχειριστείτε τις κατηγορίες. Οι κατηγορίες είναι χρήσιμες
για κατηγοριοποίηση των αιτημάτων βάση συνάφειας (για παράδειγμα &quot;Πωλήσεις&quot;,
&quot;Προβλήματα Hardware&quot;, &quot;PHP/MySQL προβήματα&quot; etc) και για να αντιστοιχήσετε χρήστες με τις κατηγορίες
(για παράδειγμα ο υπεύθυνος για τις πωλήσεις μπορεί να βλέπει αιτήματα που δημοσιεύονται στην κατηγορία &quot;Πωλήσεις&quot;)';
$hesklang['cat_name']='Όνομα κατηγορίας';
$hesklang['remove']='Διαγραφή';
$hesklang['add_cat']='Προσθήκη νέας κατηγορίας';
$hesklang['max_chars']='μέγ. 40 χαρακτήρες';
$hesklang['create_cat']='Δημιουργία νέας κατηγορίας';
$hesklang['ren_cat']='Μετονομασία κατηγορίας';
$hesklang['to']='προς';
$hesklang['cat_added']='Η κατηγορίας προστέθηκε';
$hesklang['cat_name_added']='Η κατηγορία %s έχει προστεθεί  με επιτυχία';
$hesklang['cat_renamed']='Η κατηγορία μετονομάστηκε';
$hesklang['cat_renamed_to']='Η επιλεγμένη κατηγορία έχει μετονομαστεί με επιτυχία σε ';
$hesklang['cat_removed']='Η κατηγορία διαγράφηκε';
$hesklang['cat_removed_db']='Η επιλεγμένη κατηγορίας αφαιρέθηκε επιτυχώς από τη βάση δεδομένων';
$hesklang['sure_remove_user']='Είσαι σίγουρος ότι θέλεις να αφαιρέσεις αυτόν τον χρήστη;';
$hesklang['manage_users']='Διαχείριση χρηστών';
$hesklang['users_intro']='Εδώ μπορείτε να διαχειριστείτε τους χρήστε που μπορούν να εισέλθουν στη σελίδα διαχείρισης και να 
απαντούν αιτήματα. Οι διαχειριστές μπορούν να βλέπουν και να επεξεργάζονται τα αιτήματα σε οποιαδήποτε κατηγορία και να έχουν πρόσβαση
σε όλες τις λειτουργίες της σελίδας διαχείρισης (διαχείριση χρηστών, διαχείριση χρηστών, διαχείριση κατηγοριών, ...) ενώ 
οι υπόλοιποι χρήστες μπορούν να βλέπουν και να απαντούν μόνο τα αιτήματα που ανήκουν στις κατηγορίες τους.';
$hesklang['yes']='ΝΑΙ';
$hesklang['no']='ΟΧΙ';
$hesklang['edit']='Επεξεργασία';
$hesklang['add_user']='Προσθήκη νέου χρήστη';
$hesklang['req_marked_with']='Τα υποχρεωτικά πεδία σημειώνονται με';
$hesklang['real_name']='Ονοματεπώνυμο';
$hesklang['signature_max']='Υπογραφή (μέγιστο 255 χαρακτήρες)';
$hesklang['sign_extra']='HTML κώδικας δεν επιτρέπεται. Ωστόσο οι σύνδεσμοι θα κλικάρονται.';
$hesklang['create_user']='Δημιουργία χρήστη';
$hesklang['editing_user']='Επεξεργασία χρήστη';
$hesklang['user_added']='Ο χρήστης προστέθηκε';
$hesklang['user_added_success']='Νέος χρήστης %s με κωδικός πρόσβασης %s έχει προστεθεί επιτυχώς';
$hesklang['profile_updated']='Το προφίλ ενημερώθηκε';
$hesklang['profile_updated_success']='Το προφίλ σας ενημερώθηκε επιτυχώς';
$hesklang['user_removed']='Ο χρήστης διαγράφηκε';
$hesklang['sel_user_removed']='Ο επιλεγμένος χρήστης διαγράφηκε επιτυχώς από την βάση δεδομένων';
$hesklang['profile_for']='Προφίλ για';
$hesklang['new_pass']='Νέος κωδικός πρόσβασης';
$hesklang['update_profile']='Ενημέρωση προφίλ';
$hesklang['notify_new_posts']='Ειδοποίηση για νέα αιτήματα και αναρτήσεις στις κατηγορίες μου';
$hesklang['view_profile']='Προβολή προφίλ';
$hesklang['new_ticket_submitted']='Νέο αίτημα καταχωρήθηκε';
$hesklang['user_profile_updated_success']='Το προφίλ του χρήστη ενημερώθηκε επιτυχώς';
$hesklang['printer_friendly']='Εκδοση φιλική για εκτύπωση';
$hesklang['end_ticket']='--- Τέλος αιτήματος ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Το αίτημα σας έχει';
$hesklang['view_your_ticket']='Δείτε το αίτημα σας';
$hesklang['submit_ticket']='Καταχώρηση αιτήματος';
$hesklang['sub_ticket']='Καταχώρηση αιτήματος';
$hesklang['before_submit']='Πριν από την υποβολή βεβαιωθείτε για τα ακόλουθα';
$hesklang['all_info_in']='Όλες οι απαραίτητες πληροφορίες έχουν συμπληρωθεί';
$hesklang['all_error_free']='Όλες οι πληροφορίες είναι σωστές και χωρίς λάθη';
$hesklang['we_have']='Έχουμε';
$hesklang['recorded_ip']='καταγράψει την IP διεύθυνσή σας';
$hesklang['recorded_time']='καταγράψει τον χρόνο υποβολής';
$hesklang['save_changes']='Αποθήκευση αλλαγών';
$hesklang['reply_submitted_success']='Η απάντησή σας σε αυτό το αίτημα έχει υποβληθεί επιτυχώς';
$hesklang['ticket_submitted']='Το αίτημα υποβλήθηκε';
$hesklang['ticket_submitted_success']='Το αίτημα σας υποβλήθηκε επιτυχώς! ID Παρακολούθησης';
$hesklang['your_ticket']='Το αίτημα σας';

// Added in version 0.94
$hesklang['check_updates']='Βεβαιωθείτε ότι έχετε εγκαταστήσει την τελευταία έκδοση του HESK!';
$hesklang['check4updates']='Έλεγχος για ενημερώσεις';
$hesklang['wait_reply']='Αναμονή απάντησης';
$hesklang['replied']='Απαντημένο';
$hesklang['last_replier']='Τελευταίος που απάντησε';
$hesklang['staff']='Προσωπικό';
$hesklang['customer']='Πελάτης';
$hesklang['close_selected']='Σημείωσε τα επιλεγμένα αιτήματα ως Επιλυμένα';
$hesklang['execute']='Εκτέλεση';
$hesklang['saved_replies']='Έτοιμες Απαντήσεις';
$hesklang['manage_saved']='Έτοιμες απαντήσεις';
$hesklang['manage_intro']='Εδώ μπορείτε να προσθέσετε και να διαχειριστείτε έτοιμες απαντήσεις. Αυτές είναι απαντήσεις που χρησιμοποιούνται συνήθως και είναι λίγο-πολύ οι ίδιες για κάθε πελάτη. Θα πρέπει να χρησιμοποιείτε έτοιμες απαντήσεις για να αποφύγετε να πληκτρολογείτε την ίδια απάντηση σε διαφορετικούς πελάτες πολλές φορές.';
$hesklang['saved_title']='Τίτλος';
$hesklang['no_saved']='Δεν υπάρχουν έτοιμες απαντήσεις';
$hesklang['delete_saved']='Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή την έτοιμη απάντηση;';
$hesklang['new_saved']='Προσθήκη ή Επεξεργασία έτοιμης απάντησης';
$hesklang['canned_add']='Δημιουργία νέας έτοιμης απάντησης';
$hesklang['canned_edit']='Επεξεργασία επιλεγμένης έτοιμης απάντησης';
$hesklang['save_reply']='Αποθήκευση απάντησης';
$hesklang['saved']='Η απάντηση αποθηκεύτηκε';
$hesklang['your_saved']='Η έτοιμη απάντηση αποθηκεύτηκε για μελλοντική χρήση';
$hesklang['ent_saved_title']='Παρακαλώ εισάγετε τίτλο απάντησης';
$hesklang['ent_saved_msg']='Παρακαλώ εισάγετε μήνυμα απάντησης';
$hesklang['saved_removed']='Η έτοιμη απάντηση διαγράφηκε';
$hesklang['saved_rem_full']='Η επιλεγμένη έτοιμη απάντηση διαγράφηκε από την βάση δεδομένων';
$hesklang['clip_alt']='Αυτή η ανάρτηση έχει συνημμένα αρχεία';
$hesklang['attachments']='Συνημμένα';
$hesklang['fill_all']='Λείπει απαιτούμενο πεδίο';
$hesklang['file_too_large']='Το αρχείο σας %s είναι πολύ μεγάλο';
$hesklang['cannot_move_tmp']='Δεν μπορείτε να μετακινήσετε το αρχείο στο φάκελο συνημμένα';
$hesklang['created_on']='Δημιουργήθηκε στις';
$hesklang['tickets_closed']='Αιτήματα Κλειστά';
$hesklang['num_tickets_closed']='<b>%d</b> αιτήματα έχουν κλείσει';
$hesklang['select_saved']='Διαλέξτε μια έτοιμη απάντηση';
$hesklang['select_empty']='Επιλογή / Κενό';
$hesklang['insert_special']='Εισάγετε ειδική ετικέτα (θα αντικατασταθεί με πληροφορίες του πελάτη)';
$hesklang['move_to_catgory']='Μετακίνηση αιτήματος σε';
$hesklang['move']='Μετακίνηση';
$hesklang['moved']='Το αίτημα μετακινήθηκε';
$hesklang['moved_to']='Το αίτημα έχει μετακινηθεί σε νέα κατηγορία';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Όλα εκτός από τα κλειστά';
$hesklang['chg_all']='Αλλαγή όλων';
$hesklang['settings']='Ρυθμίσεις';
$hesklang['settings_intro']='Χρησιμοποιήστε αυτό το εργαλείο για να διαμορφώσετε το help desk. Για περισσότερες πληροφορίες σχετικά με όλες τις ρυθμίσεις και τις επιλογές κάντε κλικ στο σύμβολο βοήθειας ή ανατρέξτε στο αρχείο README.html.';
$hesklang['all_req']='Όλα τα πεδία (εκτός από τα απενεργοποιημένα) είναι υποχρεωτικά!';
$hesklang['wbst_title']='Τίτλους του Website';
$hesklang['wbst_url']='Website URL';
$hesklang['email_wm']='Webmaster email';
$hesklang['max_listings']='Καταχωρήσεις ανά σελίδα';
$hesklang['print_size']='Μέγεθος φόντου εκτύπωσης';
$hesklang['debug_mode']='Κατάσταση αποσφαλμάτωσης (Debug mode)';
$hesklang['on']='ON';
$hesklang['off']='OFF';
$hesklang['use_secimg']='Χρήση εικόνας anti-SPAM';
$hesklang['secimg_no']='Δεν είναι διαθέσιμο';
$hesklang['attach_use']='Χρήση συνημμένων αρχείων';
$hesklang['attach_num']='Πλήθος ανά δημοσίευση';
$hesklang['attach_type']='Επιτρεπτοί τύποι αρχείων';
$hesklang['place_after']='Μετά το μήνυμα';
$hesklang['place_before']='Πριν το μήνυμα';
$hesklang['custom_f']='Προσαρμοσμένο πεδίο';
$hesklang['custom_u']='Χρησιμοποιήστε αυτό το πεδίο';
$hesklang['custom_n']='Όνομα πεδίου';
$hesklang['custom_l']='Μέγιστο μήκος (χαρακτήρες)';
$hesklang['db_host']='Database host';
$hesklang['db_name']='Database name';
$hesklang['db_user']='Database username';
$hesklang['db_pass']='Database password';
$hesklang['err_sname']='Παρακαλώ εισάγετε τίτλο για το website σας';
$hesklang['err_surl']='Εισαγάγετε τη διεύθυνση URL του ιστότοπού σας. Βεβαιωθείτε ότι είναι έγκυρη διεύθυνση URL (ξεκινά με http:// ή https://)';
$hesklang['err_wmmail']='Παρακαλώ εισάγετε ένα έγκυρο email του webmaster';
$hesklang['err_nomail']='Please enter a valid noreply email';
$hesklang['err_htitle']='Παρακαλώ εισάγετε τον τίτλο του γραφείου υποστήριξης';
$hesklang['err_hurl']='Παρακαλώ εισάγετε τη διεύθυνση URL του φακέλου Hesk. Βεβαιωθείτε ότι είναι έγκυρη διεύθυνση URL (ξεκινά με http:// ή https://)';
$hesklang['err_lang']='Παρακαλώ επιλέξτε την γλώσσα του Hesk';
$hesklang['err_nolang']='Το αρχείο γλώσσας που επιλέξατα δεν υπάρχει στον φάκελο γλωσσών! Βεβαιωθείτε ότι το αρχείο έχει μεταφορτωθεί πριν αλλάξετε τη ρύθμιση γλώσσας.';
$hesklang['err_max']='Παρακαλώ εισάγετε τις μέγιστες καταχωρήσεις που θα εμφανίζονται ανά σελίδα';
$hesklang['err_psize']='Παρακαλώ εισάγετε το μέγεθος της γραμματοσειράς εκτύπωσης';
$hesklang['err_dbhost']='Παρακαλώ εισάγετε τον MySQL database host';
$hesklang['err_dbname']='Παρακαλώ εισάγετε το MySQL database name';
$hesklang['err_dbuser']='Παρακαλώ εισάγετε το MySQL database username';
$hesklang['err_dbpass']='Παρακαλώ εισάγετε το MySQL database password';
$hesklang['err_dbconn']='Δεν ήταν δυνατή η σύνδεση με τη βάση δεδομένων MySQL χρησιμοποιώντας τις πληροφορίες που παρέχονται!';
$hesklang['err_dbsele']='Δεν ήταν δυνατή η επιλογή της βάσης δεδομένων MySQL, ελέγξτε ξανά τη βάση δεδομένων NAME';
$hesklang['err_custname']='Παρακαλώ εισάγετε όνομα/ονόματα για τα επιλεγμένα προαιρετικά πεδία';
$hesklang['err_openset']='Δεν είναι δυνατό το άνοιγμα του αρχείου <b>hesk_settings.inc.php</b> για εγγραφή. Παρακαλώ κάντε CHMOD σε αυτό το αρχείο με εντολή 666 (rw-rw-rw-)';
$hesklang['set_saved']='Οι ρυθμίσεις αποθηκεύτηκαν';
$hesklang['set_were_saved']='Οι ρυθμίσεις αποθηκεύτηκαν επιτυχώς';
$hesklang['sec_img']='Εικόνα Ασφαλείας';
$hesklang['sec_miss']='Παρακαλώ εισάγετε τον αριθμό ασφαλείας';
$hesklang['sec_wrng']='Λάθος αριθμός ασφαλείας';
$hesklang['submit_problems']='Παρακαλώ επιστρέψτε πίσω και διορθώστε τα ακόλουθα προβλήματα';
$hesklang['cat_order']='Σειρά Κατηγοριών';
$hesklang['reply_order']='Σειρά έτοιμων απαντήσεων';
$hesklang['move_up']='Μετακίνηση πάνω';
$hesklang['move_dn']='Μετακίνηση κάτω';
$hesklang['cat_move_id']='Λείπει το ID κατηγορίας';
$hesklang['reply_move_id']='Λείπει το ID έτοιμης απάντησης';
$hesklang['forgot_tid']='Ξεχάσατε το ID παρακολούθησης;';
$hesklang['tid_send']='Στείλε μου το ID παρακολούθησης';
$hesklang['tid_not_found']='Δεν βρέθηκαν αιτήματα με αυτή την email διεύθυνση';
$hesklang['tid_sent']='Το ID παρακολούθησης στάλθηκε';
$hesklang['tid_sent2']='Ένα email με λεπτομέρειες σχετικά με τα αιτήματα σας στάλθηκε στο email σας';
$hesklang['check_spambox']='Επίσης να ελέγξετε για το email μέσα στον φάκελο SPAM/Ανεπιθύμητη αλληλογραφία!';
$hesklang['reply_not_found']='Η έτοιμη απάντηση δεν βρέθηκε';
$hesklang['exists']='Υπάρχει';
$hesklang['no_exists']='Δεν υπάρχει';
$hesklang['writable']='Εγγράψιμο';
$hesklang['not_writable']='Μη εγγράψιμο';
$hesklang['disabled']='απενεργοποιημένο';
$hesklang['e_settings']='Δεν θα μπορείτε να αποθηκεύσετε τις ρυθμίσεις σας έως ότου αυτό το αρχείο είναι εγγράψιμο από αυτό το script. Παρακαλούμε ανατρέξτε στο αρχείο readme για περεταίρω οδηγίες!';
$hesklang['e_attdir']='Δεν θα μπορείτε να αρχειοθετήσετε τις επισυνάψεις εώς ότου αυτό υπάρχει και είναι εγγράψιμο από αυτό το script. Παρακαλούμε ανατρέξτε στο αρχείο readme για περεταίρω οδηγίες!';
$hesklang['e_save_settings']='Αποτυχία αποθήκευσης των ρυθμίσεών σας επειδή το αρχείο <b>hesk_settings.inc.php</b> δεν είναι εγγράψιμο από αυτό το script.';
$hesklang['e_attach']='Απενεργοποιημένο επειδή ο φάκελος <b>attachments</b> δεν είναι εγγράψιμος από αυτό το script.';
$hesklang['go']='Εκτέλεση';

// Added in version 2.0
$hesklang['v']='HESK έκδοση';
$hesklang['check_status']='Έλεγχος κατάστασης';
$hesklang['sub_support']='Υποβολή αιτήματος';
$hesklang['open_ticket']='Υποβάλλετε ένα νέο θέμα σε ένα τμήμα';
$hesklang['view_existing']='Προβολή υπάρχοντος αιτήματος';
$hesklang['vet']='Προβολή αιτημάτων που υποβάλλατε στο παρελθόν';
$hesklang['enter_user']='Παρακαλώ εισάγετε το όνομα χρήστη';
$hesklang['remember_user']='Να θυμάσαι το όνομα χρήστη';
$hesklang['wrong_user']='Λάθος όνομα χρήστη';
$hesklang['no_permission']='Δεν έχετε άδεια για να εκτελέσετε αυτήν την εργασία, συνδεθείτε με έναν λογαριασμό που έχει.';
$hesklang['tickets_on_pages']='Αριθμός αιτημάτων: %d | Αριθμός σελίδων: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Μετάβασε στη σελίδα:';
$hesklang['no_tickets_open']='Δεν βρέθηκαν ανεπίλυτα αιτήματα';
$hesklang['no_tickets_crit']='Δεν βρέθηκαν αιτήματα που να ταιριάζουν στα κριτήρια σας';
$hesklang['confirm_execute']='Έίστε σίγουροι ότι θέλετε να συνεχίσετε;';
$hesklang['legend']='Legend';
$hesklang['main_page']='Αρχή';
$hesklang['menu_users']='Χρήστες';
$hesklang['menu_cat']='Κατηγορίες';
$hesklang['menu_profile']='Προφίλ';
$hesklang['menu_kb']='Βάση γνώσεων'; // Admin MENU item
$hesklang['kb_text']='Βάση γνώσεων'; // Item visible to customers
$hesklang['viewkb']='Προβολή όλης της βάσης γνώσεων';
$hesklang['kb']='Διαχείριση βάσης γνώσεων';
$hesklang['kb_intro']='Η βάση γνώσεων είναι μια συλλογή από απαντήσεις σε συχνές ερωτήσεις (FAQ) και άρθρα τα οποία παρέχουν πόρους αυτοβοήθειας στους πελάτες σας.
Μια περιεκτική και καλογραμμένη βάση γνώσεων μπορεί να μειώσει δραστικά τον αριθμό των αιτημάτων υποστήριξης που λαμβάνετε και να σώσει πολύ χρόνο σας. Μπορείτε να τακτοποιήσετε άρθρα σε κατηγορίες
και υποκατηγορίες.'; // Description in ADMIN panel
$hesklang['kb_is']='Η βάση γνώσεων είναι κατηγοριοποιημένη συλλογή από απαντήσεις σε συχνές ερωτήσεις (FAQ) και άρθρα. Μπορείτε να διαβάσετε άρθρα σε αυτή την κατηγορία ή επιλέξτε μια υποκατηγορία που σας ενδιαφέρει.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Νέο άρθρο βάσης γνώσεων';
$hesklang['kb_cat']='Κατηγορία';
$hesklang['kb_subject']='Θέμα';
$hesklang['kb_content']='Περιεχόμενα';
$hesklang['kb_type']='Τύπος';
$hesklang['kb_published']='Δημοσιευμένο';
$hesklang['kb_published2']='Το άρθρο αυτό είναι ορατό σε όλους στην βάση γνώσεων.';
$hesklang['kb_private']='Ιδιωτικό';
$hesklang['kb_private2']='Τα ιδιωτικά άρθρα μπορούν να διαβάζονται μόνο από το προσωπικό.';
$hesklang['kb_draft']='Πρόχειρο';
$hesklang['kb_draft2']='Το άρθρο αποθηκεύτηκε αλλά δεν δημοσιεύτηκε ακόμα. Μπορεί να διαβαστεί μόνο από το προσωπικό<br /> που έχει δικαώματα διαχείρισης σε άρθρα της βάσης γνώσεων.';
$hesklang['kb_links']='<i><span class="notice"><b>Προσοχή!</b></span><br />Εισάγετε έγκυρο κώδικα χωρίς &lt;head&gt; και &lt;body&gt; ετικέτες, μόνο περιεχόμενο!</i>';
$hesklang['kb_ehtml']='Αυτό είναι κώδικας HTML (Θα εισάγω έγκυρο κώδικα (X)HTML)';
$hesklang['kb_dhtml']='Αυτό είναι απλό κείμενο (οι σύνδεσμοι θα κλικάρονται)';
$hesklang['kb_save']='Αποθήκευση άρθρου';
$hesklang['kb_e_subj']='Εισάγετε το θέμα του άρθρου!';
$hesklang['kb_e_cont']='Γράψτε τα περιέχομενα του άρθρου!';
$hesklang['kb_art_added']='Το άρθρο προστέθηκε';
$hesklang['your_kb_added']='Ένα νέο άρθρο προστέθηκε επιτυχώς στην βάση γνώσεων';
$hesklang['kb_art_deleted']='Το άρθρο διαγράφηκε';
$hesklang['your_kb_deleted']='Το επιλεγμένο άρθρο διαγράφηκε επιτυχώς από την βάση γνώσεων';
$hesklang['kb_art_mod']='Το άρθρο τροποποιήθηκε';
$hesklang['your_kb_mod']='Οι αλλαγές στο επιλεγμένο άρθρο αποθηκεύτηκαν επιτυχώς';
$hesklang['kb_cat_new']='Νέα κατηγορία βάσης γνώσεων';
$hesklang['kb_cat_parent']='Μητρική κατηγορία';
$hesklang['kb_cat_sub']='Υποκατηγορίες';
$hesklang['kb_cat_title']='Τίτλος κατηγορίας';
$hesklang['kb_cat_published']='Η κατηγορία είναι ορατή σε όλους στην βάση γνώσεων.';
$hesklang['kb_cat_private']='Η κατηγορία μπορεί να διαβαστεί μόνο από το προσωπικό.';
$hesklang['kb_cat_add']='Προσθήκη κατηγορίας';
$hesklang['kb_cat_e_title']='Εισάγετε τίτλο κατηγορίας!';
$hesklang['kb_cat_added']='Η κατηγορία προστέθηκε';
$hesklang['kb_cat_added2']='Μια νέα κατηγορία προστέθηκε επιτυχώς στην βάση γνώσεων';
$hesklang['kb_cat_man']='Διαχείριση κατηγορίας βάσης δεδομένων';
$hesklang['kb_cat_edit']='Επεξεργασία λεπτομερειών κατηγορίας';
$hesklang['kb_cat_inv']='Ακυρη κατηγορία';
$hesklang['kb_cat_art']='Αρθρα σ αυτήν την κατηγορία';
$hesklang['kb_p_art']='+ Αρθρο';
$hesklang['kb_p_art2']='προσθήκη νέου άρθρου στην επιλεγμένη κατηγορία.';
$hesklang['kb_add_art']='Προσθήκη άρθρου';
$hesklang['kb_p_cat']='+ Κατηγορία';
$hesklang['kb_p_cat2']='δημιουργία νέας υποκατηγορίας μέσα στην επιλεγμένη κατηγορία.';
$hesklang['kb_add_cat']='Προσθήκη κατηγορίας';
$hesklang['kb_p_man']='Διαχείριση';
$hesklang['kb_p_man2']='διαχείριση επιλεγμένης κατηγορίας (επεξεργασία, διαγραφή, διαχείριση άρθρων).';
$hesklang['kb_main']='Η κύρια κατηγορία της βάσης γνώσεων δεν μπορεί να διαγραφεί ή να μετακινηθεί.';
$hesklang['kb_no_art']='Δεν υπάρχουν άρθρα μέσα σ αυτήν την κατηγορία.';
$hesklang['author']='Συγγραφέας';
$hesklang['views']='Προβολές';
$hesklang['delete']='Διαγραφή';
$hesklang['rating']='Αξιολόγηση';
$hesklang['votes']='Ψήφοι';
$hesklang['kb_rated']='Το άρθρο αξιολογήθηκε %s/5.0';
$hesklang['kb_not_rated']='Το άρθρο δεν αξιολογήθηκε ακόμα';
$hesklang['del_art']='Είστε σίγουροι ότι θέλετε να διαγράψετε το επιλεγμένο άρθρο;';
$hesklang['kb_art_id']='Το ID του άρθρου δεν υπάρχει ή είναι άκυρο!';
$hesklang['kb_art_edit']='Επεξεργασία άρθρου';
$hesklang['revhist']='Ιστορικό εκδόσεων';
$hesklang['revision1']='<li class="smaller">%s | υποβλήθηκε από %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | τροποποιήθηκε από %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Σειρά';
$hesklang['kb_delcat']='Είστε σίγουροι ότι θέλετε να διαγράψετε την επιλεγμένη κατηγορία;';
$hesklang['kb_cat_mod']='Η κατηγορία τροποποιήθηκε';
$hesklang['your_cat_mod']='Οι αλλαγές σας στην επιλεγμένη κατηγορία αποθηκεύτηκαν επιτυχώς';
$hesklang['kb_cat_del']='Η κατηγορία της βάσης γνώσεων διαγράφηκε';
$hesklang['kb_cat_dlt']='Η επιλεγμένη κατηγορία της βάσης γνώσεων έχει διαγραφεί';
$hesklang['allowed_cat']='Κατηγορίες';
$hesklang['allow_feat']='Χαρακτηριστικά';
$hesklang['can_view_tickets']='Προβολή αιτημάτων';
$hesklang['can_reply_tickets']='Απάντηση σε αιτήματα';
$hesklang['can_assign_tickets']='Ανάθεση αιτημάτων';
$hesklang['can_del_tickets']='Διαγραφή αιτημάτων';
$hesklang['can_edit_tickets']='Επεξεργασία απαντήσεων αιτήματος';
$hesklang['can_change_cat']='Αλλαγή κατηγορίας αιτήματος';
$hesklang['can_man_kb']='Διαχείριση βάσης γνώσεων';
$hesklang['can_man_users']='Διαχείριση χρηστών';
$hesklang['can_man_cat']='Διαχείριση κατηγοριών';
$hesklang['can_man_canned']='Διαχείριση έτοιμων απαντήσεων';
$hesklang['can_man_settings']='Διαχείριση ρυθμίσεων help desk';
$hesklang['can_del_notes']='Διαγραφή σημειώσεων αιτήματος';
$hesklang['dan']='οι χρήστες μπορούν να διαγράψουν τις σημειώσεις τους στο αίτημα, επιλέξτε αυτό μόνο αν επιθυμείτε ο χρήστης να μπορεί να διαγράφει σημειώσεις από άλλους χρήστες';
$hesklang['in_all_cat']='στις επιτρεπτές κατηγορίες μόνο';
$hesklang['admin_can']='(πρόσβαση σε όλα τα χαρακτηριστικά και κατηγορίες)';
$hesklang['staff_can']='(μπορείτε να περιορίσετε τα χαρακτηριστικά και τις κατηγορίες)';
$hesklang['asign_one_feat']='Παρακαλώ αναθέστε τουλάχιστον ένα χαρακτηριστικό σ αυτόν τον χρήστη!';
$hesklang['na_view_tickets']='Δεν είστε εξουσιοδοτημένος να βλέπετε αιτήματα';
$hesklang['support_notice']='Λυπούμαστε, αυτή η ενότητα μπορεί να κρυφτεί μόνο όταν αγοράσετε μια άδεια HESK!';
$hesklang['rart']='Βοήθησε αυτό το άρθρο;';
$hesklang['r']='Βοήθησε αυτή η απάντηση;';
$hesklang['tyr']='Ευχαριστούμε για την αξιολόγησή σας';
$hesklang['cw']='Κλείσιμο παραθύρου';
$hesklang['cw2']='Κλείσιμο παραθύρου και υποβολή αιτήματος';
$hesklang['rh']='Αξιολόγηση ως <i>χρήσιμο (βοήθησε πολύ)</i>';
$hesklang['rnh']='Αξιολόγηση ως <i>άχρηστο (δεν βοήθησε)</i>';
$hesklang['ar']='Ήδη αξιολογήθηκε';
$hesklang['rated']='Αξιολόγηση χρήστη %s/5.0 (%s ψήφων)';
$hesklang['not_rated']='Ο χρήστης δεν αξιολογήθηκε ακόμα';
$hesklang['rdis']='Η αξιολόγηση είναι απενεργοποιημένη';
$hesklang['kbdis']='Η βάση γνώσεων είναι απενεργοποιημένη';
$hesklang['kbpart']='Συγνώμη, αλλά δεν έχετε πρόσβαση σ αυτό το άρθρο';
$hesklang['popart']='Κορυφαία άρθρα Βάσης Γνώσεων:';
$hesklang['latart']='Πρόσφατα άρθρα Βάσης Γνώσεων:';
$hesklang['m']='Περισσότερα θέματα';
$hesklang['ac']='Αρθρα σ αυτήν την κατηγορία:';
$hesklang['noa']='Δεν υπάρχουν άρθρα ακόμα';
$hesklang['noac']='Δεν υπάρχουν άρθρα ακόμα σ αυτήν την κατηγορία';
$hesklang['dta']='Ημερομηνία που προστέθηκε';
$hesklang['ad']='Λεπτομέρειες άρθρου';
$hesklang['aid']='ID Αρθρου';
$hesklang['as']='Λύση';
$hesklang['search']='Αναζήτηση';
$hesklang['sr']='Αποτελέσματα αναζήτησης';
$hesklang['nosr']='Δεν βρέθηκαν άρθρα. Περιηγηθείτε στην Βάση Γνώσεων ή υποβάλλετε νέο αίτημα υποστήριξης.';
$hesklang['rv']='Μηδενισμός θεάσων';
$hesklang['rr']='Μηδενισμός ψήφων (αξιολογήσεων)';
$hesklang['opt']='Επιλογές';
$hesklang['delcat']='Διαγραφή κατηγορίας';
$hesklang['move1']='Μετακίνηση άρθρων στη γονική κατηγορία';
$hesklang['move2']='Διαγραφή άρθρων σ αυτήν την κατηγορία';
$hesklang['sc']='Προτεινόμενα άρθρα Βάσης Γνώσεων';
$hesklang['not']='Αιτήματα'; // Number of all tickets in category
$hesklang['graph']='Γράφημα';
$hesklang['lu']='Λίστα χρηστών';
$hesklang['aclose']='Αυτόματο κλείσιμο αιτημάτων';
$hesklang['aclose2']='ημέρες μετά την τελευταία απάντηση από το προσωπικό';
$hesklang['s_ucrt']='Ανοιγμα ξανά αιτημάτων';
$hesklang['urate']='Απαντήση αξιολογήσεων';
$hesklang['hesk_url']='Help desk URL';
$hesklang['hesk_title']='Τίτλος Help desk';
$hesklang['cid']='ID παρακολούθησης υπόθεσης';
$hesklang['tfor']='Μορφή ώρας';
$hesklang['prefix']='Table prefix';
$hesklang['s_ekb']='Βάση Γνώσεων (ΒΓ)';
$hesklang['s_kbs']='Ενεργοποίηση αναζήτησης σε Βάση Γνώσεων';
$hesklang['s_kbr']='Ενεργοποίηση αξιολόγησης Βάσης Γνώσεων';
$hesklang['s_maxsr']='Μέγιστος αριθμός αποτελεσμάτων αναζήτησης';
$hesklang['s_suggest']='Πρότεινε άρθρα ΒΓ';
$hesklang['s_spop']='Δείξε δημοφιλή άρθρα';
$hesklang['s_slat']='Δείξε πρόσφατα άρθρα';
$hesklang['s_onin']='στη σελίδα <a href="../" target="_blank">ευρετηρίου help desk</a>';
$hesklang['s_onkb']='στη σελίδα <a href="../knowledgebase.php" target="_blank">ευρετηρίου βάσης γνώσεων</a>';
$hesklang['s_scol']='Κατηγορίες σε σειρά';
$hesklang['s_ptxt']='Μήκος προθέασης άρθρου';
$hesklang['s_psubart']='Αρθρα υποκατηγορίας';
$hesklang['enable']='Ενεργό';
$hesklang['s_type']='Τύπος';
$hesklang['custom_r']='Απαιτείται';
$hesklang['custom_place']='Θέση';
$hesklang['custom_use']='Προσαρμοσμένα πεδία';
$hesklang['stf']='Πεδίο Κειμένου';
$hesklang['stb']='Μεγάλο πλαίσιο κειμένου';
$hesklang['srb']='Κουμπί Radio';
$hesklang['ssb']='Πλαίσιο Επιλογής';
$hesklang['db']='Βάση δεδομένων';
$hesklang['hd']='Help desk ρυθμίσεις';
$hesklang['gs']='Γενικές ρυθμίσεις';
$hesklang['cwin']='Κλείσιμο παραθύρου';
$hesklang['defw']='Προεπιλεγμένη τιμή';
$hesklang['ok']='OK';
$hesklang['ns']='Αυτές είναι οι διαθέσιμες επιλογές για αυτό το προσαρμοσμένο πεδίο. Για να αποθηκεύσετε τις αλλαγές, κάντε κλικ στο κουμπί <b>OK</b> και <b>Αποθήκευση αλλαγών</b> στη σελίδα ρυθμίσεων διαχειριστή!';
$hesklang['rows']='Γραμμές (ύψος)';
$hesklang['cols']='Στήλες (πλάτος)';
$hesklang['opt2']='Επιλογές για αυτό το κουμπί επιλογής, εισαγάγετε μία επιλογή ανά γραμμή (κάθε γραμμή θα δημιουργήσει μια νέα τιμή κουμπιού επιλογής από την οποία μπορείτε να επιλέξετε). Πρέπει να εισαγάγετε τουλάχιστον δύο επιλογές!';
$hesklang['opt3']='Επιλογές για αυτό το πλαίσιο επιλογής, εισαγάγετε μία επιλογή ανά γραμμή (κάθε γραμμή θα είναι μια επιλογή από την οποία μπορούν να επιλέξουν οι πελάτες σας). Πρέπει να εισαγάγετε τουλάχιστον δύο επιλογές!';
$hesklang['atl2']='Εισάγετε τουλάχιστον δύο επιλογές (μία σε κάθε γραμμή)!';
$hesklang['notes']='Σημειώσεις';
$hesklang['addnote']='+ Προσθήκη σημείωσης';
$hesklang['noteby']='Σημείωση από';
$hesklang['delnote']='Διαγραφή σημείωσης';
$hesklang['noteerr']='Η σημείωση ήδη διαγράφηκε ή έχει λάθος παραμέτρους';
$hesklang['s']='Υποβολή';
$hesklang['nhid']='Οι σημειώσεις είναι κρυφές από τους πελάτες!';
$hesklang['delt']='Διαγράφη αυτής της ανάρτησης';
$hesklang['edtt']='Επεξεργασία ανάρτησης';
$hesklang['edt1']='Η ανάρτηση τροποποιήθηκε';
$hesklang['edt2']='Οι αλλαγές στην επιλεγμένη ανάρτηση αποθηκεύτηκαν';
$hesklang['dele']='Διαγραφή αυτού του αιτήματος';
$hesklang['repd']='Η ανάρτηση διαγράφηκε';
$hesklang['repl']='Η επιλεγμένη ανάρτηση έχει διαγραφεί';
$hesklang['tickets_found']='Αποτελέσματα αναζήτησης';
$hesklang['al']='Admin link';
$hesklang['ap']='Προώθηση στον Πίνακα Διαχείρισης';
$hesklang['dap']='Προβολή ενός συνδέσμου στον πίνακα διαχείρισης από <a href="../" target="_blank">ευρετήριο help desk</a>';
$hesklang['q_miss']='Παρακαλώ απαντήστε στην ερώτηση ασφαλείας (anti-SPAM)';
$hesklang['use_q']='Χρήση ερώτησης ασφαλείας (anti-SPAM)';
$hesklang['q_q']='-&gt; Ερώτηση (HTML code is <font class="success">επιτρέπεται</font>)';
$hesklang['q_a']='-&gt; Απάντηση';
$hesklang['err_qask']='Εισάγετε μια ερώτηση ασφαλείας (anti-SPAM)';
$hesklang['err_qans']='Εισάγετε απάντηση για την ερώτηση ασφαλείας (anti-SPAM)';
$hesklang['genq']='Δημιουργήστε μια τυχαία ερώτηση';

// Added in version 2.1
$hesklang['amo']='Προσθήκη περισσοτέρων';
$hesklang['delatt']='Διαγραφή επιλεγμένου συνημμένου;';
$hesklang['kb_att_rem']='Tο επιλεγμένο συνημμένο έχει διαγραφεί';
$hesklang['inv_att_id']='Ακυρο ID συνημμένου!';
$hesklang['scb']='Checkbox';
$hesklang['opt4']='Επιλογές για αυτό το πλαίσιο ελέγχου, εισαγάγετε μία επιλογή ανά γραμμή. Κάθε γραμμή θα είναι μια επιλογή από την οποία μπορούν να επιλέξουν οι πελάτες σας. Είναι δυνατές πολλαπλές επιλογές. Πρέπει να εισαγάγετε τουλάχιστον δύο επιλογές!';
$hesklang['autologin']='Σύνδεση αυτόματα με κάθε επίσκεψή μου';
$hesklang['just_user']='Θυμήσου μόνο το όνομα χρήστη μου';
$hesklang['nothx']='Όχι, ευχαριστώ';
$hesklang['pinfo']='Πληροφορίες προφίλ';
$hesklang['sig']='Υπογραφή';
$hesklang['pref']='Προτιμήσεις';
$hesklang['aftrep']='Μετά την απάντηση σ ένα αίτημα';
$hesklang['showtic']='Δείξε το αίτημα που μόλις απάντησα';
$hesklang['gomain']='Επιστροφή στην κεντρική σελίδα διαχείρισης';
$hesklang['shownext']='Ανοιξε το επόμενο αίτημα που χρειάζεται να απαντήσω (αν δεν υπάρχει πάνε στην σελίδα διαχείρισης)';
$hesklang['rssn']='Εμφάνιση επόμενου αιτήματος που χρειάζεται την προσοχή σας';
$hesklang['mrep']='Αντικατάσταση υπάρχοντος μηνύματος';
$hesklang['madd']='Προσθήκη στο τέλος';
$hesklang['priv']='Ιδιωτικές κατηγορίες και άρθρα που εμφανίζονται μόνο στο προσωπικό είναι σημειωμένα με *';
$hesklang['inve']='Ακυρο αρχείο email';
$hesklang['emfm']='Λείπει το αρχείο email';
$hesklang['hesk_lang']='Προεπιλεγμένη γλώσσα';
$hesklang['s_mlang']='Πολλαπλές γλώσσες';
$hesklang['s_mlange']='Ενεργοποιήστε εφόσον παρέχετε υποστήριξη σε όλες τις εγκατεστημένες γλώσσες!';
$hesklang['s_inl']='Δοκιμή φακέλου που περιέχει τις γλώσσες';
$hesklang['s_inle']='Δοκιμές στο φάκελο της γλώσσας για την έγκυρη γλώσσα. Μόνο γλώσσες που έχουν περάσει όλες τις δοκιμές εγκαθίστανται σωστά.';
$hesklang['ta']='Δοκιμή ξανά';
$hesklang['alo']='Επιτρέπεται αυτόματη σύνδεση';
$hesklang['chol']='Προτιμώμενη γλώσσα';
$hesklang['mmdl']='Κάνε αυτή την προτιμώμενη γλώσσα';
$hesklang['warn']='ΠΡΟΣΟΧΗ';
$hesklang['dmod']='Η λειτουργία εντοπισμού σφαλμάτων είναι ενεργοποιημένη. Βεβαιωθείτε ότι έχετε απενεργοποιήσει τη λειτουργία εντοπισμού σφαλμάτων στις ρυθμίσεις μόλις το HESK εγκατασταθεί και λειτουργήσει σωστά.';
$hesklang['kb_spar']='Η κατηγορία δεν μπορεί να είναι η δική της γονική κατηγορία!';
$hesklang['mysql_root']='Ο κωδικός πρόσβασης MySQL είναι κενός. Είστε βέβαιοι ότι θέλετε να συνδεθείτε με root user; Αυτός είναι ένας σημαντικός κίνδυνος ασφαλείας!';
$hesklang['chg']='Αλλαγή';
$hesklang['chpri']='Η προτεραιότητα άλλαξε';
$hesklang['chpri2']='Η προτεραιότητα του αιτήματος έχει αλλάξει σε %s';
$hesklang['selcan']='Διαλέξτε την έτοιμη απάντηση που θέλετε να επεξεργαστείτε';
$hesklang['q_wrng']='Λάθος απάντηση ασφαλείας (anti-SPAM)';
$hesklang['cndupl']='Έχετε ήδη κατηγορία με αυτό τ όνομα. Διαλέξτε ένα μοναδικό όνομα για κάθε κατηγορία.';
$hesklang['wsel']='Επιλέξτε το πεδίο βάση του οποίου θέλετε να αναζητήσετε';

// Added in version 2.2
$hesklang['eto']='΄Μη έγκυρο αίτημα';
$hesklang['id']='ID';
$hesklang['geco']='Δημιουργία άμεσου συνδέσμου';
$hesklang['genl']='Άμεσος σύνδεσμος κατηγορίας';
$hesklang['genl2']='Χρησιμοποιήστε αυτή τη σύνδεση για προεπιλέξετε κατηγορία στην φόρμα &quot;Υποβολής Αιτήματος&quot;.';
$hesklang['ask']='Αναζήτηση βοήθειας:';
$hesklang['exa']='Παραδείγματα';
$hesklang['small']='Μικρό Κουτί';
$hesklang['large']='Μεγάλο Κουτί';
$hesklang['cpri']='Προτεραιότητα πελάτη';
$hesklang['owner']='Υπεύθυνος';
$hesklang['unas']='Μη ανατεθειμένο';
$hesklang['assi']='Ανάθεση';
$hesklang['asst']='Ανάθεση σε';
$hesklang['asst2']='Ανάθεση του αιτήματος σε';
$hesklang['asss']='Ανάθεση σε μένα';
$hesklang['asss2']='Ανάθεση του αιτήματος σε μένα';
$hesklang['can_assign_self']='Μπορεί να αναθέτει αιτήματα σε μένα';
$hesklang['can_assign_others']='Μπορεί να αναθέτει αιτήματα σε άλλους';
$hesklang['can_run_reports']='Μπορεί να τρέξει εκθέσεις (δική σας)';
$hesklang['can_view_ass_others']='Μπορεί να βλέπει αιτήματα που έχουν ανατεθεί σε άλλους';
$hesklang['unoa']='Ο επιλεγμένος χρήστης δεν έχει πρόσβαση σ αυτήν την κατηγορία';
$hesklang['tasi']='Υπεύθυνος ανατέθηκε';
$hesklang['tasy']='Αυτό το αίτημα ανατέθηκε σε σένα';
$hesklang['taso']='Αυτό το αίτημα ανατέθηκε στον επιλεγμένο χρήστη';
$hesklang['tasy2']='Ανατεθειμένα σε μένα';
$hesklang['taso2']='Ανατεθειμένα στο υπόλοιπο προσωπικό';
$hesklang['nose']='Επιλέξτε τον νέο υπεύθυνο';
$hesklang['onasc']='Αυτός ο υπεύθυνος δεν έχει πρόσβαση σ αυτήν την κατηγορία.';
$hesklang['tunasi']='Το Ticket δεν έχει εκχωρηθεί';
$hesklang['tunasi2']='Το αίτημα είναι χωρίς υπεύθυνο και έτοιμο να ανατεθεί ξανά';
$hesklang['note']='Σημείωση';
$hesklang['success']='Επιτυχία';
$hesklang['nyt']='Αυτό το αίτημα ανατέθηκε σε';
$hesklang['noch']='Δεν έχουν γίνει αλλαγές';
$hesklang['orch']='Η σειρά προβολής τροποποιήθηκε';
$hesklang['rfm']='Απαιτούμενες πληροφορίες λείπουν:';
$hesklang['repl0']='Ανεπαρκή δικαιώματα για την εκτέλεση αυτής της εργασίας';
$hesklang['repl1']='Αυτή η ανάρτηση δεν υπάρχει';
$hesklang['reports']='Αναφορές';
$hesklang['reports_intro']='Η ενότητα αναφορών σάς επιτρέπει να εκτελείτε πολλές αναφορές και να βλέπετε στατιστικά στοιχεία δελτίων σε ένα επιλεγμένο εύρος ημερομηνιών.';
$hesklang['refi']='Καθαρισμός φόρμας';
$hesklang['dich']='Απόρριψη Αλλαγών';
$hesklang['dire']='Προβολή Αναφοράς';
$hesklang['m1']='Ιανουάριος';
$hesklang['m2']='Φεβρουάριος';
$hesklang['m3']='Μάρτιος';
$hesklang['m4']='Απρίλιος';
$hesklang['m5']='Μάιος';
$hesklang['m6']='Ιούνιος';
$hesklang['m7']='Ιούλιος';
$hesklang['m8']='Αύγουστος';
$hesklang['m9']='Σεπτέμβριους';
$hesklang['m10']='Οκτώβριος';
$hesklang['m11']='Νοέμβριος';
$hesklang['m12']='Δεκέμβριος';
$hesklang['d1']='Δευτέρα';
$hesklang['d2']='Τρίτη';
$hesklang['d3']='Τετάρτη';
$hesklang['d4']='Πέμπτη';
$hesklang['d5']='Παρασκευή';
$hesklang['d6']='Σάββατο';
$hesklang['d0']='Κυριακή';
$hesklang['mo']='Δε';
$hesklang['tu']='Τρ';
$hesklang['we']='Τε';
$hesklang['th']='Πε';
$hesklang['fr']='Πα';
$hesklang['sa']='Σα';
$hesklang['su']='Κυ';
$hesklang['from']='Από';
$hesklang['cinv']='Μη αποδεκτή ημερομηνία';
$hesklang['cinv2']='Αποδεκτή ημερομηνία είναι μμ/ηη/εεεε';
$hesklang['cinm']='Ακυρη τιμή μήνα';
$hesklang['cinm2']='Allowed range is';
$hesklang['cind']='Ακυρη τιμή ημέρας του μήνα';
$hesklang['cind2']='Allowed range for selected month is';
$hesklang['month']='Μήνας';
$hesklang['ocal']='Ανοιγμα Ημερολογίου';
$hesklang['ca01']='Προηγούμενο Έτος';
$hesklang['ca02']='Προηγούμενος Μήνας';
$hesklang['ca03']='Επόμενος Μήνας';
$hesklang['ca04']='Επόμενο Έτος';
$hesklang['ca05']='Κλείσιμο Ημερολογίου';
$hesklang['cdr']='Επιλέξτε εύρος ημερομηνιών:';
$hesklang['crt']='Αναφορά τύπου';
$hesklang['r1']='Σήμερα';
$hesklang['r2']='Χθες';
$hesklang['r3']='Τρέχον μήνα';
$hesklang['r4']='Προηγούμενο μήνα';
$hesklang['r5']='Τελευταίες 30 ημέρες';
$hesklang['r6']='Τρέχουσα εβδομάδα (Δευ-Κυρ)';
$hesklang['r7']='Προηγούμενη εβδομάδα (Δευ-Κυρ)';
$hesklang['r8']='Τρέχουσα εργάσιμη εβδομάδα (Δευ-Παρ)';
$hesklang['r9']='Προηγούμενη εργάσιμη εβδομάδα (Δευ-Παρ)';
$hesklang['r10']='Τρέχον έτος';
$hesklang['r11']='Προηγούμενο έτος';
$hesklang['r12']='Όλα';
$hesklang['datetofrom']='&quot;Η Ημερομηνία Από&quot; δεν μπορεί να είναι μεγαλύτερη από την &quot;Ημερομηνία Έως&quot;. Οι Ημερομηνίες αντιστράφηκαν.';
$hesklang['t1']='Αιτήματα ανά ημέρα';
$hesklang['t2']='Αιτήματα ανά μήνα';
$hesklang['t3']='Αιτήματα ανά χρήστη';
$hesklang['t4']='Αιτήματα ανά κατηγορία';
$hesklang['ticass']='Ανατεθειμένα αιτήματα';
$hesklang['ticall']='Απαντήσεις σε αιτήματα';
$hesklang['totals']='Σύνολα';
$hesklang['all']='Όλα';
$hesklang['atik']='Νέα αιτήματα';
$hesklang['kbca']='Εχετε ήδη μια κατηγορία βάσης γνώσεων με αυτό το όνομα.';
$hesklang['menu_msg']='Μήνυμα';
$hesklang['menu_can']='Τυποποιημένα μηνύματα';
$hesklang['m_from']='Από:'; // Mail "from" address
$hesklang['m_to']='Προς:'; // Mail "to" address
$hesklang['m_sub']='Θέμα:'; // Mail subject
$hesklang['m_re']='Από:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Πρθ:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Ιδιωτικά μηνύματα';
$hesklang['m_intro']='Χρησιμοποιήστε τα ιδιωτικά μηνύματα για να στέλνετε γρήγορα μηνύματα στα υπόλοιπα μέλη του προσωπικού μέσα από εδώ.';
$hesklang['e_udel']='(Ο χρήστης διαγράφηκε)';
$hesklang['new_mail']='Νέο ιδιωτικό μήνυμα';
$hesklang['m_send']='Αποστολή μηνύματος';
$hesklang['m_rec']='Επιλέξτε τον παραλήπτη του μηνύματος';
$hesklang['m_inr']='Ακυρος παραλήπτης μηνύματος';
$hesklang['m_esu']='Εισάγετε το θέμα του ιδιωτικού μηνύματος';
$hesklang['m_pms']='Το ιδιωτικό σας μήνυμα έχει σταλθεί';
$hesklang['inbox']='ΕΙΣΕΡΧΟΜΕΝΑ';
$hesklang['outbox']='ΕΞΕΡΧΟΜΕΝΑ';
$hesklang['m_new']='ΝΕΟ ΜΗΝΥΜΑ';
$hesklang['pg']='Προβολή σελίδας';
$hesklang['npm']='Δεν υπάρχουν ιδιωτικά μηνύματα σ αυτόν τον φάκελο.';
$hesklang['m_ena']='Δεν έχετε δικαίωμα να διαβάσετε αυτό το μήνυμα.';
$hesklang['mau']='Σημείωση ως αδιάβαστο';
$hesklang['mo1']='Σημείωση επιλεγμένων μηνυμάτων ως αναγνωσμένα';
$hesklang['mo2']='Σημείωσε επιλεγμένω μηνυμάτων ως αδιάβαστα';
$hesklang['mo3']='Διαγραφή επιλεγμένων μηνυμάτων';
$hesklang['delm']='Διαγραφή του μηνύματος';
$hesklang['e_tid']='Σφάλμα δημιουργίας μοναδικού ID, παρακαλώ δοκιμάστε να υποβάλλετε την φόρμα ξανά αργότερα.';
$hesklang['smmr']='Τα επιλεγμένα μηνύματα έχουν σημειωθεί ως αναγνωσμένα';
$hesklang['smmu']='Τα επιλεγμένα μηνύματα έχουν σημειωθεί ως αδιάβαστα';
$hesklang['smdl']='Τα επιλεγμένα μηνύματα έχουν διαγραφεί';
$hesklang['show']='Προβολή';
$hesklang['s_my']='Ανατεθειμένα σε μένα';
$hesklang['s_ot']='Ανατεθειμένα σε άλλους';
$hesklang['s_un']='Μη ανατεθειμένα αιτήματα';
$hesklang['s_for']='Αναζήτηση για';
$hesklang['s_in']='Αναζήτηση σε';
$hesklang['s_incl']='Αναζήτηση μέσα';
$hesklang['find_ticket_by']='Αναζήτηση αιτημάτων';
$hesklang['e_nose']='Δεν επιλέχθηκε κατάσταση ανάθεσης, προβολή όλων των αιτημάτων.';
$hesklang['fsq']='Εισάγετε το ερώτημα αναζήτησης';
$hesklang['topen']='Open';
$hesklang['nms']='Δεν έχουν επιλεχθεί μηνύματα, δεν έχει γίνει καμία αλλαγή';
$hesklang['tlo']='Κλείδωμα αιτήματος';
$hesklang['tul']='Ξεκλείδωμα αιτήματος';
$hesklang['loc']='Κλειδωμένο';
$hesklang['isloc']='Οι πελάτες δεν μπορούν να απαντήσουν ή να ξαναανοίξουν κλειδωμένα αιτήματα. Όταν κλειδώνεται ένα αίτημα σημειώνεται ως επιλυμένο.';
$hesklang['tlock']='Το αίτημα έχει κλειδωθεί';
$hesklang['tunlock']='Το αίτημα έχει ξεκλειδωθεί';
$hesklang['tislock']='Το αίτημα έχει κλειδωθεί, ο πελάτης δεν θα μπορεί να απαντήσει.';
$hesklang['tislock2']='Το αίτημα έχει κλειδωθεί, δεν μπορείτε να απαντήσετε.';
$hesklang['nsfo']='Δεν βρέθηκα σχετικά άρθρα.';
$hesklang['thist1']='<li class="smaller">%s | μετακινήθηκε στην κατηγορία %s by %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | ανατέθηκε σε %s by %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | έκλεισε από %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | ανοίχθηκε από %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | κλειδώθηκε από %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | ξεκλειδώθηκε από %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | το ticket δημιουργήθηκε από %s</li>'; // %s = date, user making change
$hesklang['elocked']='Αυτό το αίτημα κλειδώθηκε ή διαγράφηκε.';
$hesklang['nti2']='Εισαγωγή νέου αιτήματος';
$hesklang['nti3']='Χρησιμοποίηστε αυτή την φόρμα για να δημιουργήσετε ένα νεο άιτημα στο όνομα ενός πελάτη. Εισάγετε τις πληροφορίες του πελάτη στη φόρμα (όνομα πελάτη, email κ.α.) και όχι το όνομά σας! Το αίτημα θα δημιουργηθεί σαν να το υπόβαλε ο πελάτης.';
$hesklang['addop']='Επιλογές';
$hesklang['seno']='Στείλε email ειδοποίηση στον πελάτη';
$hesklang['otas']='Δείξε το αίτημα μετά την υποβολή';
$hesklang['notn']='Ειδοποιήσεις';
$hesklang['nomw']='Το Help desk θα στείλει email ειδοποιήσεις όταν:';
$hesklang['nwts']='Ένα νέο αίτημα υποβλήθηκε με υπεύθυνο:';
$hesklang['ncrt']='Ο πελάτης ανταποκρίθηκε στο αίτημα με υπεύθυνο:';
$hesklang['ntam']='Ένα αίτημα ανατέθηκε σε μένα';
$hesklang['npms']='Ένα ιδιωτικό μήνυμα στάλθηκε σε μένα';
$hesklang['support_remove']='Πολύς χρόνος και προσπάθεια αφιερώθηκε στην ανάπτυξη του HESK. Υποστηρίξτε το HESK, αγοράστε μια άδεια χρήσης που θα αφαιρέσει επίσης τους συνδέσμους πίστωσης <i>Με την υποστήριξη του Help Desk Software HESK</i> από το helpdesk σας.';
$hesklang['ycvtao']='Δεν επιτρέπεται να δείτε αιτήματα που έχουν ανατεθεί σε άλλους';
$hesklang['password_not_valid']='Ο κωδικός πρόσβασης πρέπει να έχει τουλάχιστον 5 χαρακτήρες';
$hesklang['lkbs']='Φόρτωση προτάσεων γνωσιακής βάσης...';
$hesklang['auto']='(αυτόματα)';

// Added in version 2.3
$hesklang['unknown']='Αγνωστο';
$hesklang['pcer']='Παρακαλώ διορθώστε τα παρακάτω λάθη:';
$hesklang['seqid']='Αριθμός αιτήματος';
$hesklang['close_action']='Σημείωση ως επιλυμένο'; // Close ACTION
$hesklang['archived']='Αρχειοθετημένο';
$hesklang['archived2']='Αρχειοθετημένο αίτημα';
$hesklang['add_archive']='Αρχειοθετήστε αυτό το αίτημα';
$hesklang['add_archive_quick']='Αρχειοθετήστε τα επιλεγμένα αιτήματα';
$hesklang['remove_archive']='Απο-αρχειοθετήστε αυτό το αίτημα';
$hesklang['remove_archive_quick']='Απο-αρχειοθετήστε τα επιλεγμένα αιτήματα';
$hesklang['added_archive']='Το αίτημα αρχειοθετήθηκε';
$hesklang['removed_archive']='Το αίτημα απο-αρχειοθετήθηκε';
$hesklang['added2archive']='Το αίτημα έχει αρχειοθετηθεί';
$hesklang['removedfromarchive']='Το αίτημα έχειο απο-αρχειοθετηθεί';
$hesklang['num_tickets_tag']='<b>%d</b> αιτήματα έχουν αρχειοθετηθεί';
$hesklang['num_tickets_untag']='<b>%d</b> αιτήματα έχουν απο-αρχειοθετηθεί';
$hesklang['can_add_archive']='Μπορείτε να προσθέσετε ετικέτα (tag) στα αιτήματα';
$hesklang['disp_only_archived']='Μόνο τα αιτήματα με ετικέτες (αρχειοθετημένα)';
$hesklang['search_only_archived']='Μόνο τα αιτήματα με ετικέτες (αρχειοθετημένα)';
$hesklang['critical']=' * Κρίσιμο * ';
$hesklang['thist8']='<li class="smaller">%s | η προτεραιότητα άλλαξε σε %s by %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | η κατάσταση άλλαξε σε %s by %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | ανατέθηκε αυτόματα σε %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | υποβλήθηκε μέσω ηλεκτρονικού ταχυδρομείου</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='ετ';
$hesklang['abbr']['month']='μη';
$hesklang['abbr']['week']='εβδ';
$hesklang['abbr']['day']='ημ';
$hesklang['abbr']['hour']='ω';
$hesklang['abbr']['minute']='λ';
$hesklang['abbr']['second']='δ';
// END abberviations
$hesklang['cnsm']='Δεν μπορώ να στείλω μήνυμα σε:';
$hesklang['yhbb']='Έχετε κλειδωθεί από το σύστημα για %s λεπτά γιατί έχετε πολλές αποτυχημένες προσπάθειες εισόδου.';
$hesklang['pwdst']='Ισχύς κωδικού πρόσβασης';
$hesklang['tid_mail']='Μην ανησυχείτε! Εισάγετε την <b>Email διεύθυνσή</b> σας και θα σας στείλουμε το ID παρακολούθησης αμέσως:';
$hesklang['rem_email']='Να θυμάσαι την email διεύθυνσή μου';
$hesklang['eytid']='Εισάγετε το ID παρακολούθησης του αιτήματος';
$hesklang['enmdb']='Το email που εισάγατε δεν αντιστοιχεί με αυτό στην βάση δεδομένων για το συγκεκριμένο ID παρακολούθησης.';
$hesklang['confemail']='Επιβεβαίωση Email';
$hesklang['confemail2']='Παρακαλώ επιβεβεβαιώστε το Email σας';
$hesklang['confemaile']='Τα δύο emails δεν είναι ίδια';
$hesklang['taso3']='Ανατέθηκε σε:';
$hesklang['sec_enter']='Πληκτρολογήστε τον αριθμό που βλέπετε στην παρακάτω εικόνα.';
$hesklang['reload']='Επαναφόρτωση εικόνας';
$hesklang['verify_q']='Πρόληψη SPAM:'; // For anti-spam question
$hesklang['verify_i']='Πρόληψη SPAM:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Σύνδεση Προσωπικού';
$hesklang['vrfy']='Η δοκιμή πέτυχε';
$hesklang['last_update']='Ενημερώθηκε';
$hesklang['cot']='Να μην τοποθετούνται τα κρίσιμα δελτία στην κορυφή';
$hesklang['def']='Κάνε αυτή την προβολή εξ\' ορισμού';
$hesklang['gbou']='Αυτά τα αιτήματα δεν είναι <b>Ανατεθειμένα</b>:';
$hesklang['gbom']='Τα αιτήματα ανατέθηκαν σε <b>μένα</b>:';
$hesklang['gboo']='Τα αιτήματα ανατέθηκαν σε <b>%s</b>:';
$hesklang['select']=' - - Κλικ για επιλογή - - ';
$hesklang['chngstatus']='Αλλαγή κατάστασης σε';
$hesklang['perat']='%s απ όλα τα αιτήματα'; // Will change to "23% of all tickets"
$hesklang['viewart']='Προβολή του άρθρου';
$hesklang['chdp']='Παρακαλώ αλλάξτε τον προεπιλεγμένο κωδικό πρόσβασης στην σελίδα του <a href="profile.php">Προφίλ</a> σας!';
$hesklang['chdp2']='Αλλάξτε τον κωδικό πρόσβασης, χρησιμοποιείτε τον προεπιλεγμένο!';
$hesklang['security']='Ασφάλεια';
$hesklang['kb_i_art']='Νέο άρθρο';
$hesklang['kb_i_art2']='Εισάγετε ένα άρθρο';
$hesklang['kb_i_cat']='Νέα κατηγορία';
$hesklang['kb_i_cat2']='Εισάγετε μια κατηγορία';
$hesklang['gopr']='Προβολή Βάσης Γνώσεων';
$hesklang['kbstruct']='Δομή Βάσης Γνώσεων';
$hesklang['cancel']='Ακυρο';
$hesklang['sh']='Κρύψε το μήνυμα';
$hesklang['goodkb']='Πως να γράψετε σωστά άρθρα για την βάση γνώσεων';
$hesklang['catset']='Ρυθμίσεις Κατηγορίας';
$hesklang['inpr']='Επιλέξτε νέα προτεραιότητα';
$hesklang['incat']='Επιλέξτε τη νέα κατηγορία';
$hesklang['instat']='Επιλέξτε νέα κατάσταση';
$hesklang['tsst']='Η κατάσταση του αιτήματος ορίστηκε σε %s';
$hesklang['aass']='Αυτόματη ανάθεση';
$hesklang['aaon']='Αυτόματη ανάθεση των αιτημάτων ενεργοποιημένη (κλικ για απενεργοποίηση)';
$hesklang['aaoff']='Αυτόματη ανάθεση των αιτημάτων απενεργοποιημένη (κλικ για ενεργοποίηση)';
$hesklang['uaaon']='Η αυτόματη ανάθεση έχει ενεργοποιηθεί για τον επιλεγμένο χρήστη';
$hesklang['uaaoff']='Auto-assign has been disabled for selected user';
$hesklang['taasy']='Αυτό το αίτημα έχει ανατεθεί αυτόματα σε σένα';
$hesklang['can_view_unassigned']='Μπορεί να βλέπει μη ανατεθειμένα αιτήματα';
$hesklang['ycovtay']='Μπορείτε να βλέπετε μόνο αιτήματα που είναι ανατεθειμένα σε εσάς';
$hesklang['in_progress']='Σε Πρόοδο';
$hesklang['on_hold']='Σε Αναμονή';
$hesklang['import_kb']='Εισαγωγή αυτού του αιτήματος σε άρθρο της Βάσης Γνώσεων';
$hesklang['import']='Εισάγετε ένα <i>ιδιωτικό αίτημα</i> μέσα σε ένα <i>δημόσιο άρθρο</i>.<br /><br />Σιγουρευτείτε να διαγράψετε οποιαδήποτε ιδιωτική ή ευαίσθητη πληροφορία από το θέμα του άρθρου ή από το μήνυμα!';
$hesklang['tab_1']='Γενικά';
$hesklang['tab_2']='Help Desk';
$hesklang['tab_3']='Βάση Γνώσεων';
$hesklang['tab_4']='Προσαρμοσμένα πεδία';
$hesklang['tab_5']='Διάφορα';
$hesklang['disable']='Ανενεργό';
$hesklang['dat']='Ημερομηνία &amp; Ώρα';
$hesklang['lgs']='Γλώσσα';
$hesklang['onc']='ON - Πελάτες';
$hesklang['ons']='ON - Όλοι';
$hesklang['viewvtic']='Προβολή αιτημάτων';
$hesklang['reqetv']='Απαιτείται email για προβολή αιτήματος';
$hesklang['banlim']='Όριο προσπαθειών σύνδεσης (login)';
$hesklang['banmin']='Ban time (minutes)';
$hesklang['subnot']='Υποβολή σημείωσης';
$hesklang['subnot2']='Προβολή σημείωσης σε πελάτες που υποβάλλουν αιτήματα';
$hesklang['eseqid']='Διαδοχικά IDs';
$hesklang['sconfe']='Επιβεβαίωση email';
$hesklang['saass']='Αυτόματη ανάθεση αιτημάτων';
$hesklang['swyse']='WYSIWYG Επεξεργαστής';
$hesklang['hrts']='Αξιολογήστε το HESK';
$hesklang['hrts2']='Εμφάνιση συνδέσμου αξιολόγησης αυτού του σεναρίου στον πίνακα διαχειριστή';
$hesklang['emlpipe']='Email piping';
$hesklang['emlsend2']='Αποστολή emails χρησιμοποιώντας';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Server';
$hesklang['smtph']='SMTP Host';
$hesklang['smtpp']='SMTP Port';
$hesklang['smtpu']='SMTP Username';
$hesklang['smtpw']='SMTP Password';
$hesklang['smtpt']='SMTP Timeout';
$hesklang['other']='Άλλα';
$hesklang['features']='Χαρακτηριστικά';
$hesklang['can_view_online']='Μπορεί να βλέπει τα online μέλη του προσωπικού';
$hesklang['online']='Σε Σύνδεση';
$hesklang['offline']='Εκτός Σύνδεσης';
$hesklang['onlinep']='Χρήστες Online'; // For display in footer
$hesklang['sonline']='Χρήστες Online'; // For settings page
$hesklang['sonline2']='Προβολή online χρηστών. Όριο (λεπτά):'; // For settings page
$hesklang['gb']='Ομαδοποίηση κατά';
$hesklang['dg']='Χωρίς ομαδοποίηση';
$hesklang['err_dpi']='Η βάση δεδομένων %s δεν περιέχει όλους τους πίνακες HESK με πρόθεμα %s, δεν έχουν αποθηκευτεί αλλαγές.';
$hesklang['err_dpi2']='Οι Πίνακες δεν βρέθηκαν:';
$hesklang['sme']='Σφάλμα SMTP';
$hesklang['scl']='Log Σύνδεσης SMTP';
$hesklang['dnl']='Κατέβασμα';
$hesklang['dela']='Διαγράφη αυτού του συνημμένου';
$hesklang['pda']='Θέλετε να διαγράψετε μόνιμα αυτό το συνημμένο;';
$hesklang['thist12']='<li class="smaller">%s | το συνημμένο %s διαγράφηκε από %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Περισσότερες επιλογές';
$hesklang['lopt']='Λιγότερες επιλογές';
$hesklang['meml']='Πολλαπλά Emails';
$hesklang['meml2']='Επιτρέπεται στους πελάτες να εισάγουν πολλαπλά emails.';

// Added in version 2.4
$hesklang['catd']='(Η κατηγορία διαγράφηκε)';
$hesklang['noopen']='Δεν έχουν βρεθεί ανοικτά αιτήματα για αυτή τη διεύθυνση email.';
$hesklang['maxopen']='Έχετε φτάσει στον μέγιστο αριθμό ανοικτών αιτημάτων  (%d of %d). Παρακαλούμε περιμένετε μέχρι τα τρέχοντα αιτήματά σας επιληθούν πριν ανοίξετε νέα αιτήματα.';
$hesklang['ntnote']='Κάποιος πρόσθεσε μία σημείωση σε ένα αίτημα που έχει ανατεθεί σε μένα.';
$hesklang['cat_public']='Αυτή η κατηγορία είναι ΔΗΜΟΣΙΑ (πατήστε εδώ για να την κάνετε ιδιωτική)';
$hesklang['cat_private']='Αυτή η κατηγορία είναι ΙΔΙΩΤΙΚΗ (πατήστε εδώ για να την κάνετε δημόσια)';
$hesklang['cat_aa']='Αυτόματη ανάθεση  αιτημάτων σ\' αυτή την κατηγορία.';
$hesklang['cat_type']='Κάντε αυτή την κατηγορία ιδιωτική (μόνο το προσωπικό μπορεί να την επιλέξει).';
$hesklang['caaon']='Η αυτόματη ανάθεση έχει ενεργοποιηθεί για την επιλεγμένη κατηγορία';
$hesklang['caaoff']='Η αυτόματη ανάθεση έχει απενεργοποιηθεί για την επιλεγμένη κατηγορία';
$hesklang['cpub']='Ο τύπος της κατηγορίας έχει αλλαχθεί σε ΔΗΜΟΣΙΑ';
$hesklang['cpriv']='Ο τύπος της κατηγορίας έχει αλλαχθεί σε ΙΔΙΩΤΙΚΗ';
$hesklang['cpric']='Οι πελάτες δεν μπορούν να επιλέξουν ιδιωτικές κατηγορίες, μόνο το προσωπικό μπορεί!';
$hesklang['user_aa']='Αυτόματη ανάθεση αιτημάτων σ\' αυτόν τον χρήστη.';
$hesklang['attach_size']='Μέγιστο μέγεθος αρχείου';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='Πρωτόκολλο SSL';
$hesklang['smtptls']='Πρωτόκολλο TLS';
$hesklang['oo']='Μόνο ανοικτά';
$hesklang['ool']='Εμφάνισε μόνο ανοικτά αιτήματα σε &quot;Forgot tracking ID&quot; email';
$hesklang['mop']='Μέγιστος αριθμός ανοικτών αιτημάτων';
$hesklang['rord']='Σειρά απάντησης';
$hesklang['newbot']='Η πιο πρόσφατη απάντηση στο τέλος';
$hesklang['newtop']='Η πιο πρόσφατη απάντηση στην κορυφή';
$hesklang['ford']='Φόρμα απάντησης';
$hesklang['formbot']='Εμφάνιση της φόρμας στο κάτω μέρος';
$hesklang['formtop']='Εμφάνιση της φόρμας στην κορυφή';
$hesklang['mysqlv']='Έκδοση MySQL';
$hesklang['phpv']='Έκδοση PHP';
$hesklang['csrt']='Τρέχουσα ώρα HESK:';
$hesklang['listp']='Λίστα ιδιωτικών άρθρων';
$hesklang['listd']='Λίστα ημιτελών άρθρων';
$hesklang['artp']='Ιδιωτικά άρθρα';
$hesklang['artd']='Ημιτελή άρθρα';
$hesklang['kb_no_part']='Δεν υπάρχουν ιδιωτικά άρθρα στη γνωσιακή βάση.';
$hesklang['kb_no_dart']='Δεν υπάρχουν ημιτελή άρθρα στη γνωσιακή βάση.';
$hesklang['attpri']='Δεν έχετε πρόσβαση σ\' αυτή την επισύναψη.';
$hesklang['can_merge_tickets']='Συγχώνευση αιτημάτων';
$hesklang['mer_selected']='Συγχώνευση επιλεγμένων αιτημάτων';
$hesklang['merged']='Τα επιλεγμένα αιτήματα έχουν συγχωνευθεί σε ένα.';
$hesklang['merge_err']='Υπήρξε ένα πρόβλημα κατά την συγκώνευση των δελτίων:';
$hesklang['merr1']='επιλέξτε δύο τουλάχιστον αιτήματα.';
$hesklang['merr2']='Το τελικό αίτημα δεν βρέθηκε.';
$hesklang['merr3']='αίτημα σε μια κατηγορία που δεν έχετε πρόσβαση.';
$hesklang['tme']='Το αίτημα %s έχει συγχωνευθεί με αυτό το αίτημα(%s).';
$hesklang['tme1']='Το αίτημα %s έχει συγχωνευτεί με το αίτημα %s';
$hesklang['tme2']='Για να αποκτήσετε πρόσβαση στο αίτημα %s εισάγετε την αντιστοιχησμένη email διεύθυνση.';
$hesklang['eyou']='Χρησιμοποιήστε την σελίδα του προφίλ για να επεξεργαστείτε τις ρυθμίσεις σας.';
$hesklang['npea']='Δεν έχετε δικαίωμα να επεξεργαστείτε αυτό το χρήστη.';
$hesklang['duplicate_user']='Ο χρήστης μ\'αυτό το όνομα υπάρχει ήδη, επιλέξτε ένα διαφορετικό όνομα χρήστη.';
$hesklang['kw']='Λέξεις κλειδιά';
$hesklang['kw1']='(προαιρετικό - διαχωρίστε με κενό, κόμμα ή νέα γραμμή)';
$hesklang['type_not_allowed']='Τα αρχεία με κατάληξη <b>%s</b> δεν είναι αποδεκτά (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Ο πελάτης δεν έχει διαβάσει την απάντηση ακόμα.';
$hesklang['sticky']='Κάντε αυτό το άρθρο &quot;Sticky&quot;';
$hesklang['stickyon']='Αλλάξτε αυτό το άρθρο σε &quot;Sticky&quot;';
$hesklang['stickyoff']='Αλλάξτε το άρθρο σε &quot;Normal&quot;';
$hesklang['ason']='Το άρθρο έχει σημειωθεί ως &quot;Sticky&quot;';
$hesklang['asoff']='Το άρθρο έχει σημειωθεί ως &quot;Normal&quot;';
$hesklang['ts']='Χρόνος απασχόλησης';
$hesklang['start']='Έναρξη / Στάμτημα';
$hesklang['reset']='Επαναφορά';
$hesklang['save']='Αποθήκευση';
$hesklang['hh']='Ώρες';
$hesklang['mm']='Λεπτά';
$hesklang['ss']='Δευτερόλεπτα';
$hesklang['thist']='Ιστορικό αιτήματος';
$hesklang['thist13']='<li class="smaller">%s | συννενόθηκε με το ticket %s by %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | η ώρα εργασίας ενημερώθηκε σε %s by %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | υποβλήθηκε από %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | υποβλήθηκε μέσω POP3 fetching</li>';
$hesklang['twu']='Ο χρόνος απασχόλησης στο αίτημα έχει ενημερωθεί.';
$hesklang['autoss']='Αυτόματα ξεκίνα το χρονομετρητή όταν ανοίγω το αίτημα';
$hesklang['ful']='Όρια μεταφόρτωσης αρχείου';
$hesklang['ufl']='Μπορείτε να μεταφορτώσετε αρχεία που έχουν κατάληξη σε:';
$hesklang['nat']='Μέγιστος αριθμός επισυνάψεων:';
$hesklang['mfs']='Μέγιστο μέγεθος ανά επισύναψη:';
$hesklang['lps']='Η προτίμηση γλώσσας έχει αποθηκευτεί';
$hesklang['sav']='Εμφάνιση προβολών άρθρου';
$hesklang['sad']='Εμφάνιση ημερομηνίας άρθρου';
$hesklang['emp']='Η PHP σας δεν έχει ενεργοποιημένη την υποστήριξη MySQL (απαιτείται επέκταση mysqli)';
$hesklang['epd']='[HESK] Η ΔΙΟΧΕΤΕΥΣΗ ΗΛΕΚΤΡΟΝΙΚΟΥ ΤΑΧΥΔΡΟΜΕΙΟΥ ΕΙΝΑΙ ΑΠΕΝΕΡΓΟΠΟΙΗΜΕΝΗ ΣΤΙ';
$hesklang['pfd']='[HESK] ΤΟ POP3 FETCHING ΕΙΝΑΙ ΑΠΕΝΕΡΓΟΠΟΙΗΜΕΝΗ ΣΤΙΣ ΡΥΘΜΙΣΕΙΣ';
$hesklang['pem']='[Piped email]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Πελάτης]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='Email';
$hesklang['pop3']='POP3 Fetching';
$hesklang['pop3h']='POP3 Host';
$hesklang['pop3p']='POP3 Port';
$hesklang['pop3tls']='Πρωτόκολλο TLS';
$hesklang['pop3u']='POP3 Username';
$hesklang['pop3w']='POP3 Password';
$hesklang['pop3e']='POP3 error';
$hesklang['pop3log']='Log Σύνδεσης POP3';
$hesklang['mysqltest']='Δοκιμή Σύνδεσης MySQL';
$hesklang['smtptest']='Δοκιμή Σύνδεσης SMTP';
$hesklang['pop3test']='Δοκιμή Σύνδεσης POP3';
$hesklang['contest']='Δοκιμή σύνδεσης, αυτό μπορεί να διαρκέσει λίγο...';
$hesklang['conok']='Σύνδεση Επιτυχής!';
$hesklang['conokn']='Ωστόσο, αν ο εξυπηρετητής απαιτεί όνομα και κωδικό το email δεν θα σταλεί!';
$hesklang['saving']='Αποθήκευση ρυθμίσεων, παρακαλώ περιμένετε...';
$hesklang['sns']='Οι ρυθμίσεις αποθηκεύτηκαν, αλλά ορισμένες λειτουργίες έχουν απενεργοποιηθεί λόγω αποτυχημένων δοκιμών.';
$hesklang['looph']='Μέχιστα Hits';
$hesklang['loopt']='Χρονικό πλαίσιο';
$hesklang['didum']='Εννοείτε %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Ναι, φτιάξτε το';
$hesklang['nole']='Όχι αφήστε το';
$hesklang['sconfe2']='Προβάλετε ένα &quot;Επιβεβαίωση email&quot; πεδίο σε μία φόρμα υποβολλής αιτήματος';
$hesklang['oln']='Παλιό όνομα:';
$hesklang['nen']='Νέο όνομα:';
$hesklang['use_form_below']='<i>Χρησιμοποιήστε την παρακάτω φόρμα για να υποβάλλετε ένα αίτημα υποστήριξης.</br>Τα υποχρεωτικά πεδία είναι σημειωμένα με</i>';
$hesklang['esf']='Δεν μπορώ να στείλω ειδοποιήσεις μέσω email.';
$hesklang['qrr']='(οι παραθέσεις της απάντησης έχουν αφαιρεθεί)';
$hesklang['remqr']='Αφαιρέστε τις παραθέσεις απάντησης';
$hesklang['remqr2']='Διαγράψτε τις παραθέσεις απάντησης από τα emails των πελατών';
$hesklang['suge']='Ανίχνευσε λάθη στις email διευθύνσεις';
$hesklang['epro']='Πάροχοι email';
$hesklang['email_noreply']='&quot;Από:&quot; email';
$hesklang['email_name']='&quot;Από:&quot; όνομα';
$hesklang['vscl']='Ρυθμίσεις ορίων εξυπηρετητή';
$hesklang['fnuscphp']='Η μεταφόρτωση το αρχείου απέτυχε, προσπαθήστε με μικρότερο μέγεθος ή χωρίς επισύναψη.';
$hesklang['redv']='επαναφορά εξ\' όρισμού προβολής';
$hesklang['fatte1']='Οι ρυθμίσεις επισυνάψεων &quot;Αριθμός ανά δημοσίευση&quot; είναι μεγαλύτερη απ\' αυτή που επιτρέπει ο εξυπηρετητής!';
$hesklang['fatte2']='Το μέγιστο μέγεθος του συνημμένου αρχείου σας είναι μεγαλύτερο από αυτό που επιτρέπει ο διακομιστής σας!';
$hesklang['fatte3']='Ο εξυπηρεητής δεν επιτρέπει μεγάλες δημοσιεύσεις, προσπαθήστε να μειώσετε τον αριθμό των επισυνάψεων ή το επιτρεπώμενο μέγεθος αρχείου!';
$hesklang['embed']='Ενσωματομένα αρχεία';
$hesklang['embed2']='Αποθηκεύστε τα ενσωματομένα αρχεία ως επισυνάψεις';
$hesklang['emrem']='(η εικόνα αφαιρέθηκε)';
$hesklang['hdemo']='(ΚΡΥΦΗ ΣΤΗΝ ΔΟΚΙΜΑΣΤΙΚΗ ΕΚΔΟΣΗ)';
$hesklang['ddemo']='Συγνώμη, αλλά αυτή η λειτουργία έχει απενεργοποιηθεί στην δοκιμαστική έκδοση!';
$hesklang['sdemo']='Η αποθήκευση των αλλαγών έχουν απενεργοποιηθεί στην δοκιμαστική έκδοση';
$hesklang['hud']='Το HESK είναι ενημερωμένο';
$hesklang['hnw']='Διαθέσιμη ενημέρωση';
$hesklang['getup']='Ενημερώστε το HESK';
$hesklang['updates']='Ενημερώσεις';
$hesklang['updates2']='Αυτόματος έλεγχος για ενημερώσεις.';

// Added in version 2.5.0
$hesklang['attdel']='Αυτό το αρχείο έχει διαγραφεί από το διακομιστή και δεν είναι πλέον διαθέσιμο για κατέβασμα';
$hesklang['dsen']='Αυτοματοποιημένο μήνυμα, μην απαντήσετε σε αυτό';
$hesklang['attrem']='* Ορισμένα συνημμένα αρχεία έχουν αφαιρεθεί *';
$hesklang['attnum']='Ανώτατος αριθμός που έφθασε: %s'; // %s will show attachment name
$hesklang['attsiz']='Το αρχείο είναι πολύ μεγάλο: %s'; // %s will show attachment name
$hesklang['atttyp']='Δεν επιτρέπεται ο τύπος: %s'; // %s will show attachment name
$hesklang['adf']='Φάκελος διαχειριστή';
$hesklang['atf']='Φάκελος συννημένων';
$hesklang['err_adf']='Ο επιλεγμένος φάκελος διαχειριστή (%s) δεν υπάρχει!'; // %s will show folder name
$hesklang['err_atf']='Ο επιλεγμένος φάκελος συννημένων (%s) δεν υπάρχει!'; // %s will show folder name
$hesklang['err_atr']='Ο επιλεγμένος φάκελος συννημένων (%s) δεν είναι εγγράψιμος!'; // %s will show folder name
$hesklang['fatt']='Τα αρχεία που συνδέονται με αυτό το μήνυμα:';
$hesklang['wrepo']='Παρακαλώ γράψτε μια απάντηση, μετά το εκ νέου άνοιγμα του ticket.';
$hesklang['ktool']='&raquo; Γνωσιακά εργαλεία';
$hesklang['uac']='Επιβεβαίωση και επικαιροποίηση μετρητή κατηγορίας άρθρου';
$hesklang['acv']='Το πλήθος του άρθρου έχει επαληθευτεί';
$hesklang['xyz']='αριθμός των δημόσιων, ιδιωτικών και των σχεδίων των άρθρων στην κατηγορία.';
$hesklang['reports_tab']='Εκτελέστε αναφορές'; // Tab title
$hesklang['can_run_reports_full']='Μπορεί να τρέξει εκθέσεις (όλων)';
$hesklang['can_export']='Μπορεί να εξάγει τα tickets βλαβών';
$hesklang['roo']='<i>(Στην έκθεση περιλαμβάνονται μόνο τα tickets που σας έχουν ανατεθεί)</i>';
$hesklang['shu']='Σύντομα links';
$hesklang['export']='Εξαγόμενα tickets βλαβών'; // Tab title
$hesklang['export_btn']='Εξαγόμενα tickets βλαβών'; // Button title
$hesklang['export_intro']='Αυτό το εργαλείο σας επιτρέπει να εξάγετε τα tickets βλαβών σε ένα υπολογιστικό φύλλο XML που μπορεί να ανοίξει στο Excel.';
$hesklang['stte']='Επιλέξτε τα tickets βλαβών για την εξαγωγή';
$hesklang['dtrg']='Εύρος ημερομηνιών';
$hesklang['sequentially']='διαδοχικά'; // Order tickets: Sequentially
$hesklang['ede']='Δεν είναι δυνατή η δημιουργία του καταλόγου των εξαγωγών, παρακαλούμε να δημιουργήσετε ένα φάκελο με το όνομα <b>του εξαγόμενου αρχείου </b> στον οποίο θα μπουν τα αρχεία σας και βεβαιωθείτε ότι είναι εγγράψιμος με την PHP (on Linux CHMOD it to 777 - rwxrwxrwx).';
$hesklang['eef']='Δεν είναι δυνατή η δημιουργία του εξαγόμενου αρχείου,  δεν επιτρέπετε να γράψετε μέσα στον κατάλογο των εξαγωγών.';
$hesklang['inite']='Προετοιμασία εξαγόμενων αρχείων';
$hesklang['gXML']='Δημιουργία XML file';
$hesklang['nrow']='Αριθμός εξαγόμενων γραμμών: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Συμπιεση αρχείων σε ένα αρχείο zip';
$hesklang['eZIP']='Σφάλμα κατά τη δημιουργία του αρχείου Zip';
$hesklang['fZIP']='Ολοκληρώθηκε η συμπίεση του αρχείου';
$hesklang['pmem']='Κορυφαία χρήση μνήμης: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; Πατήστε εδώ για να κατεβάσετε το εξαγόμενο αρχείο &laquo;';
$hesklang['n2ex']='Δεν βρέθηκαν tickets βλάβών που να ανταποκρίνονται στα κριτήρια, δεν εξάγετε τίποτα!';
$hesklang['sp']='SPAM πρόληψη '; // For settings page
$hesklang['sit']='-&gt; Τύπος Εικόνας';
$hesklang['sis']='Απλή εικόνα ';
$hesklang['rcpb']='Δημόσιο κλειδί';
$hesklang['rcpv']='Ιδιωτικό κλειδί';
$hesklang['pop3keep']='Κράτα ένα αντίγραφο ';
$hesklang['beta']='(Δοκιμαστική Έκδοση)';
$hesklang['maxpost']='Υποβάλλατε περισσότερα δεδομένα από όσα μπορεί να δεχθεί ο διακομιστής.<br /><br />Δοκιμάστε να υποβάλετε ξανά τη φόρμα με μικρότερα ή καθόλου συνημμένα.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Ανακριβής SPAM Απάντηση Πρόληψης, παρακαλώ προσπαθήστε ξανά.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Το δελτίο έκλεισε/απαντήθηκε';
$hesklang['ms01']='Ιαν';
$hesklang['ms02']='Φεβ';
$hesklang['ms03']='Μαρ';
$hesklang['ms04']='Απρ';
$hesklang['ms05']='Μάι';
$hesklang['ms06']='Ιον';
$hesklang['ms07']='Ιολ';
$hesklang['ms08']='Αυγ';
$hesklang['ms09']='Σεπ';
$hesklang['ms10']='Οκτ';
$hesklang['ms11']='Νοε';
$hesklang['ms12']='Δεκ';
$hesklang['sdf']='Μορφοποίηση ημερομηνίας υποβολής';
$hesklang['lcf']='Μορφοποίηση ημερομηνίας ενημέρωσης';
$hesklang['lcf0']='Σύντομη περιγραφή';
$hesklang['lcf1']='Ημερομηνία και ώρα';
$hesklang['lcf2']='HESK στιλ';
$hesklang['ticket_tpl']='Πρότυπα δελτίων';
$hesklang['can_man_ticket_tpl']='Διαχείριση προτύπων δελτίων'; // Permission title
$hesklang['ticket_tpl_man']='Διαχείριση προτύπων δελτίων'; // Page and link title
$hesklang['ticket_tpl_intro']='Δημιουργία και επεξεργασία προτύπων δελτίων τα οποία μπορείτε να χρησιμοποιείσετε για να εισάγετε γρήγορα νέα δελτία από τη σελίδα διαχείρισης.';
$hesklang['no_ticket_tpl']='Κανένα πρότυπο δελτίων';
$hesklang['ticket_tpl_title']='Τίτλος';
$hesklang['delete_tpl']='Είστε σίγουρος/η ότι θέλετε να διαγράψετε αυτό το πρότυπο;';
$hesklang['new_ticket_tpl']='Προσθήκη ή επεξεργασία ενός προτύπου δελτίου';
$hesklang['ticket_tpl_add']='Δημιουργία ένος νέου προτύπου δελτίου';
$hesklang['ticket_tpl_edit']='Επεξεργασία επιλεγμένου πρότυπου δελτίου';
$hesklang['save_ticket_tpl']='Αποθήκευση πρότυπου δελτίου';
$hesklang['ticket_tpl_saved']='Το πρότυπο δελτίο αποθηκεύτηκε για μελλοντική χρήση';
$hesklang['ticket_tpl_removed']='Το επιλεγμένο πρότυπο δελτίο έχει αφαιρεθεί από τη Βάση Δεδομένων';
$hesklang['ticket_tpl_not_found']='Το πρότυπο δελτίο δεν βρέθηκε';
$hesklang['sel_ticket_tpl']='Επιλέξτε το πρότυπο δελτίο που θέλετε να επεξεργαστείτε';
$hesklang['ent_ticket_tpl_title']='Παρακαλώ δώστε έναν τίτλο στο πρότυπο δελτίο';
$hesklang['ent_ticket_tpl_msg']='Παρακαλώ δώστε το μήνυμα του πρότυπου δελτίου';
$hesklang['ticket_tpl_id']='Λείπειτο ID του πρότυπου δελτίου';
$hesklang['select_ticket_tpl']='Επιλέξτε ένα πρότυπο δελτίο';
$hesklang['list_tickets_cat']='Λίστα όλων των αιτημάτων ανά κατηγορία';
$hesklang['def_msg']='[Χωρίς Μήνυμα]';
$hesklang['emlreqmsg']='Απαιτεί μήνυμα';
$hesklang['emlreqmsg2']='Αγνόησε piped/fetched emails χωρίς μήνυμα';
$hesklang['relart']='Σχετικά άρθρα'; // Title of related articles box
$hesklang['s_relart']='Σχετικά άρθρα'; // On settings page
$hesklang['tab_7']='Λίστα αιτήματος';
$hesklang['fitl']='Πεδία στη λίστα αιτημάτων';
$hesklang['submitted']='Υποβλήθηκε';
$hesklang['clickemail']='Προβολή';
$hesklang['set_pri_to']='Όρισε προτεραιότητα σε:'; // Action below the ticket list
$hesklang['pri_set_to']='Η προτεραιότητα έχει οριστεί σε:';
$hesklang['cat_pri']='Η προτεραιότητα της κατηγορίας θα χρησιμοποιηθεί όταν δε επιτρέπεται στους πελάτες να επιλέξουν προτεραιότητα.';
$hesklang['cat_pri_info']='Οι πελάτες επιτρέπεται να επιλέξουν προτεραιότητα, οπότε η επιλογή προτεραιότητας θα αγνοηθεί.<br /><br />Για να χρησιμοποιήσετε την επιλογή προτεραιότητας, απενεργοποιήστε την επόμενη επιλογή στο HESK:';
$hesklang['def_pri']='Προτεραιότητα κατηγορίας:';
$hesklang['ch_cat_pri']='Ορίστε προτεραιότητα κατηγορίας';
$hesklang['cat_pri_ch']='Η προτεραιότητα κατηγορίας ορίστηκε σε:';
$hesklang['err_dbversion']='Πολύ παλία MySQL έκδοση:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Επεξεργασία μηνύματος σημείωσης';
$hesklang['ednote2']='Το μήνυμα της σημείωσης αποθηκεύτηκε';
$hesklang['perm_deny']='Απαγορεύεται η πρόσβαση';
$hesklang['mis_note']='Απουσιάζει το ID της σημείωσης';
$hesklang['no_note']='Η σημείωση με αυτό το ID απουσιάζει';
$hesklang['sacl']='Αποθηκεύστε και συνεχίστε αργότερα';
$hesklang['reply_saved']='Το μήνυμα της απάντησης έχει αποθηκευτεί για αργότερα.';
$hesklang['submit_as']='Υποβολή ως:';
$hesklang['sasc']='Υποβολή απάντησης ως Πελάτης';
$hesklang['creb']='Η απάντηση του πελάτη υποβλήθηκε ως:';
$hesklang['show_select']='Εμφάνιση &quot;Κάνε κλικ για να επιλέξεις&quot; ως προεπιλεγμένη επιλογή';
// Settings
$hesklang['mms']='Λειτουργία συντήρησης';
$hesklang['mmd']='Να επιτρέπεται η λειτουργία σηντήρησης';
// Customer notice
$hesklang['mm1']='Συντήρηση σε εξέλιξη';
$hesklang['mm2']='Η υπηρεσία δεν λειτουργεί για λόγους συντήρησης.';
$hesklang['mm3']='Λυπούμαστε για την ενόχληση, παρακαλώ δοκιμάστε ξανά σε λίγο.';
// Staff notice
$hesklang['mma1']='Η λειτουργία συντήρησης είναι ενεργοποιημένη';
$hesklang['mma2']='Οι πελάτες δεν μπορούν να χρησιμοποιούν το help desk.';
$hesklang['tools']='Εργαλεία';
$hesklang['banemail']='Ban emails';
$hesklang['banemail_intro']='Απέτρεψε από συγκεκριμένες διευθύνσεις email από το να υποβάλλουν αιτήματα στο help desk.';
$hesklang['no_banemails']='<i>Κανένα email δεν έχει γίνει ban.</i>';
$hesklang['eperm']='Email που είναι μόνιμα ban:';
$hesklang['bananemail']='Διευθύνσεις email για ban';
$hesklang['savebanemail']='Κάνε ban αυτό το email';
$hesklang['enterbanemail']='Δώστε διεύθυνση email για ban.';
$hesklang['validbanemail']='Δώστε μια έγκυρη διεύθυνση email (<i>john.doe@example.com</i>) ή ένα domain (<i>@example.com</i>)';
$hesklang['email_banned']='Η διεύθυνση email address <i>%s</i> έχει γίνει ban και η εφαρμογή HESK δε θα δέχεται πλέο αιτήματα από αυτή τη διεύθυνση.'; // %s will be replaced with email
$hesklang['emailbanexists']='Η διεύθυνση email <i>%s</i> έχει γίνει ban.'; // %s will be replaced with email
$hesklang['email_unbanned']='Διαγράφηκε ο αποκλεισμός του Email';
$hesklang['banby']='Έγινε ban από';
$hesklang['delban']='Διεγράψτε το ban';
$hesklang['delban_confirm']='Να διαγραφεί το ban;';
$hesklang['baned_e']='Σας έχει απαγορευτεί να υποβάλλετε νέο αίτημα.';
$hesklang['baned_ip']='Έχετε γίνει ban από το help desk';
$hesklang['can_ban_emails']='Μπορεί να κάνει ban τα emails';
$hesklang['can_unban_emails']='Μπορεί να κάνει unban τα emails (Ενεργοποιεί το Μπορεί να κάνει ban τα emails)';
$hesklang['eisban']='Αυτή η διεύθυνση email έχει γίνει ban.';
$hesklang['click_unban']='Κλικ εδώ για να απορρίψετε το ban.';
$hesklang['banip']='Ban IPs';
$hesklang['banip_intro']='Επισκέπτες από διευθύνσης IP που είναι ban δεν μπορούν να βλέπουν ή να υποβάλλουν αιτήματα και να συνδέονται στο the help desk.';
$hesklang['ipperm']='Διευθύνσεις IP που είναι ban:';
$hesklang['iptemp']='Αποκλεισμός λόγω αποτυχία σύνδεσης:';
$hesklang['savebanip']='Κάνε ban αυτή την IP';
$hesklang['no_banips']='<i>Καμία IP δεν έχει γίνει ban.</i>';
$hesklang['bananip']='Διευθύνσεις IP για να γίνουν ban';
$hesklang['banex']='Παραδείγματα:';
$hesklang['iprange']='Εύρος IP';
$hesklang['ippermban']='Κάνε οριστικά ban αυτήν την IP';
$hesklang['enterbanip']='Δώστε εύρος ή ακριβής διεύθυνση IP που επιθυμείς να γίνει ban.';
$hesklang['validbanip']='Δώστε μια έγκυρη διεύθυνση ή ένα εύρος IP';
$hesklang['ip_banned']='Η διεύθυνση IP <i>%s</i> έχει γίνει ban και η εφαρμογή δε θα δέχεται αιτήματα από αυτή τη διεύθυνση IP.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Αυτό το εύρος διεύθυνσης IP <i>%s</i> έχει γίνει ban και η εφαρμογή δε θα δέχεται αιτήματα από αυτή τη διεύθυνση IP.'; // %s will be replaced with IP
$hesklang['ipbanexists']='Αυτή η διεύθυνση IP <i>%s</i> έχει γίνει ban.'; // %s will be replaced with IP
$hesklang['iprbanexists']='Αυτό το εύρος IP <i>%s</i> έχει γίνει ban.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='Η διεύθυνση IP με ban διαγράφηκε';
$hesklang['ip_tempun']='Προσωρινή διεύθυνση IP με ban διαγράφηκε';
$hesklang['can_ban_ips']='Μπορεί να κάνει ban τις ips';
$hesklang['can_unban_ips']='Μπορεί να καταργήσει το ban τις ips (Ενεργοποιεί το Μπορεί να κάνει ban τις ips)';
$hesklang['ipisban']='Αυτή η διεύθυνση IP έχει γίνει ban.';
$hesklang['m2e']='Λήγει σε (λεπτά)';
$hesklang['info']='Πληροφορίες';
$hesklang['sm_title']='Υπηρεσία μηνυμάτων';
$hesklang['sm_intro']='Εφαρμόστε μια υπηρεσία μηνυμάτων στην περιοχή των πολιτών, για παράδειγμα να τους ενημερώσετε για ζητήματα και για σημαντικές ειδήσεις.';
$hesklang['can_service_msg']='Επεξεργασία υπηρεσίας μηνυμάτων';
$hesklang['new_sm']='Νέα υπηρεσία μηνυμάτων';
$hesklang['edit_sm']='Επεξεργασία υπηρεσίας μηνυμάτων';
$hesklang['ex_sm']='Υπάρχοντες υπηρεσίες μηνυμάτων';
$hesklang['sm_author']='Συγγραφέας';
$hesklang['sm_type']='Τύπος';
$hesklang['sm_published']='Δημοσιεύθηκε';
$hesklang['sm_draft']='Προσχέδιο';
$hesklang['sm_style']='Στυλ';
$hesklang['sm_none']='Κανένα';
$hesklang['sm_success']='Επιτυχία';
$hesklang['sm_info']='Πληροφορία';
$hesklang['sm_notice']='Σημείωση';
$hesklang['sm_error']='Σφάλμα';
$hesklang['sm_save']='Αποθήκευση υπηρεσία μηνύματος';
$hesklang['sm_preview']='Προβολή υπηρεσίες μηνυμάτων';
$hesklang['sm_mtitle']='Τίτλος';
$hesklang['sm_msg']='Μήνυμα';
$hesklang['sm_e_title']='Εισαγωγή τίτλου υπηρεσίας μηνυμάτων';
$hesklang['sm_e_msg']='Εισαγωγή υπηρεσίας μηνύματος';
$hesklang['sm_e_id']='Απώλεια ID μηνύματος';
$hesklang['sm_added']='Μια νέα υπηρεσία μηνύματος έχει προστεθεί';
$hesklang['sm_deleted']='Η υπηρεσία μηνύματος διαγράφηκε';
$hesklang['sm_not_found']='Αυτή η υπηρεσία μηνύματος δεν υπάρχει';
$hesklang['no_sm']='Καμία υπηρεσία μηνυμάτων';
$hesklang['del_sm']='Διαγραφή της υπηρεσίας μηνύματος;';
$hesklang['sm_mdf']='Η υπηρεσία μηνύματος έχει αποθηκευθεί';
$hesklang['sska']='Προβολή προτεινόμενων άρθρων';
$hesklang['taws']='Αυτά είναι τα προτεινόμενα άρθρα:';
$hesklang['defaults']='Προεπιλεγμάτα';
$hesklang['pncn']='Επιλέξτε επιλογές ενημέρωσης του πελάτη στη φόρμα νέου αιτήματος';
$hesklang['pncr']='Επιλέξτε επιλογές ενημέρωσης του πελάτη στη φόρμα απάντησης νέου αιτήματος';
$hesklang['pssy']='Προβολή βάσης δεδομέων άρθρων που προτείνονται στους πελάτες';
$hesklang['ccct']='Επίλυση πελάτη';
$hesklang['custnot']='Ενημέρωση πολιτών όταν';
$hesklang['notnew']='Έχει υποβληθεί ένα νέο αίτημα';
$hesklang['notclo']='Ένα αίτημα επιλέχθηκε ως Επιλημένο';
$hesklang['enn']='Περίληψη για αιτήματα μέσω email εάν περιέχεται θέμα στο email:';
$hesklang['spamn']='Ειδοποίηση SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>Κανένα email επιβεβαίωσης;</b><br />Αποστέλλουμε ένα μήνυμα επιβεβαίωσης στη διεύθυνση email. Εάν δεν λάβετε μήνυμα σε μερικά λεπτά, παρακαλώ ελέξτε τα ανεπιθύμητα μηνύματα. Σημειώστε το μήνυμα ως <b>μη ανεπιθύμητο</b> για να αποφύγετε μελλοντικά προβλήματα επικοινωνίας μας.</span>';
$hesklang['ekb_n']='<b>ΟΧΙ</b>, απόρριψη βάσης δεδομένων';
$hesklang['ekb_y']='<b>ΝΑΙ</b>, ενεργοποίηση βάσης δεδομένων';
$hesklang['ekb_o']='<b>ΝΑΙ</b>, χρησιμοποιήστε την εφαρμογή μόνο ως βάση δεδομένων (<i>απορρίπτει το help desk</i>)';
$hesklang['kb_set']='Λειτουργίες βάσης δεδομένων';
$hesklang['kbo1']='Λειτουργία μόνο της βάσης δεδομένων';
$hesklang['kbo2']='<br /><br />Οι επισκέπτες δεν μπορούν να υποβάλλουν νέα αιτήματα και κατευθύνονται απαυθείας στη βάση δεδομένων.';
$hesklang['fpass']='Ξέχασες τον κωδικό σου;';
$hesklang['passr']='Επαναφορά κωδικού';
$hesklang['passa']='Να επιτρέπεται οι χρήστες να επαναφέρουν τον κωδικό τους μέσω email';
$hesklang['passe']='Δώσε τη διεύθυνση email';
$hesklang['passs']='Στείλτε μου σύνδεσμο επαναφοράς κωδικού';
$hesklang['noace']='Δεν βρέθηκε λογαριασμός με αυτή τη διεύθυνση email';
$hesklang['pemls']='Σας αποστέλλουμε ένα email με οδηγίες για το πως θα επαναφέρετε τον κωδικό σας';
$hesklang['reset_password']='Επαναφέρατε τον κωδικό της εφαρμογής'; // Email subject
$hesklang['ehash']='Σύνδεσμος για λανθασμένο ή μη ενεργό κωδικό';
$hesklang['ehaip']='Λάθος διεύθυνση IP. Οι κωδικοί μπορούν να επανέρθουν μόνο από την διεύθυνση IP που ζητά την επαναφορά τους.';
$hesklang['resim']='<b>Ρύθμιστε τον νέο σας κωδικό από την επόμενη φόρμα!</b>';
$hesklang['permissions']='Δικαιώματα';
$hesklang['atype']='Τύπος λογαριασμού';
$hesklang['astaff']='Προσωπικό';
$hesklang['oon1']='Να μου αποστέλλονται μόνο ανοιχτά αιτήματα';
$hesklang['oon2']='Να μου αποστέλλονται όλα τα αιτήματα';
$hesklang['anyown']='Όλοι οι ιδιοκτήτες';
$hesklang['pfr']='Άλλη POP3 διεργασία είναι σε λειτουργία.';
$hesklang['pjt']='Λήξη διεργασίας';
$hesklang['pjt2']='λεπτά μετά την έναρξη';
$hesklang['nkba']='Η αναζήτηση στη βάση δεδομένων απαιτεί μοναδικά άρθρα για να λειτουργήσει σωστά.<br /><br />Να ληφθεί υπόψη ότι η προσθήκη περισσότερων άρθρων στη βάση δεδομώνων για να αναβαθμιστούν οι προτάσεις αποτελεσμέτων αναζήτησης.';
$hesklang['saa']='Τα Sticky άρθρα εμφανίζονται στην αρχή της λίστας άρθρων';
$hesklang['yhbr']='Έχετε κλειδωθεί έξω από το σύστημα για %s λεπτά εξαιτίας των πολλών απαντήσεων σε ένα αίτημα.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='en';

// Added in version 2.7.0
$hesklang['imap']='IMAP Fetching';
$hesklang['imaph']='IMAP Host';
$hesklang['imapp']='IMAP Port';
$hesklang['enc']='Encryption';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='None';
$hesklang['imapu']='IMAP Username';
$hesklang['imapw']='IMAP Password';
$hesklang['imaptest']='Test IMAP connection';
$hesklang['ifd']='[HESK] ΤΟ IMAP  ΕΙΝΑΙ ΑΠΕΝΕΡΓΟΠΟΙΗΜΕΝΗ ΣΤΙΣ ΡΥΘΜΙΣΕΙΣ';
$hesklang['iei']='[HESK] Η επέκταση PHP IMAP δεν είναι εγκατεστημένη.';
$hesklang['ifr']='Μια άλλη εργασία IMAP fetching βρίσκεται ακόμη σε εξέλιξη.';
$hesklang['arp']='Αυτόματο φόρτωμα σελίδας';
$hesklang['arpp']='Να φορτώνει αυτόματα η σελίδα με τη λίστα αιτημάτων κάθε:';
$hesklang['seconds']='δευτερόλεπτα';
$hesklang['minutes']='λεπτά';
$hesklang['atbr']='Αυτό το αίτημα χρειάζεται να ανατεθεί πριν απαντήσουμε.';
$hesklang['attm']='Να ανατεθεί το αίτημα σε εμένα';
$hesklang['owneed']='Απαιτείται ιδιοκτήτης';
$hesklang['taat']='Αυτό το αίτημα έχει ήδη ανατεθεί σε <b>%s</b>.';
$hesklang['scoy']='>Είστε σίγουρος ότι θέλετε να το αναθέσετε σε εσάς;';
$hesklang['scot']='Είστε σίγουρος ότι θέλετε να το αναθέσετε σε %s?';
$hesklang['ycto']='ΝΑΙ, άλλαξε τον ιδιοκτήτη';
$hesklang['ncto']='ΟΧΙ, να διατηρηθεί ο τωρινός ιδιοκτήτης';
$hesklang['fass']='Απαιτείται ιδιοκτήτης';
$hesklang['req_sub']='Απαιτείται θέμα';
$hesklang['req_msg']='Απαιτείται μήνυμα';
$hesklang['req_email']='Απαιτείται λογαριασμός email';
$hesklang['default_subject']='Αίτημα από %s';
$hesklang['off-hide']='Απόκρυψη στην φόρμα του πελάτη';
$hesklang['not_valid_email']='Δώστε μια έγκυρη διεύθυνση email ή αφήστε αυτό το πεδίο κενό';
$hesklang['write_down']='<span style="color:red">Σας συνιστούμε να σημειώσετε το ID του αιτήματος για μελλοντική χρήση.</span>';
$hesklang['re_confirm1']='Καταργώντας το, θα καταργηθεί και το "Απαιτείται λογαριασμός email για την προβολή αιτήματος" στην "Ασφάλεια". Να προχωρήσουμε;';
$hesklang['re_confirm2']='Ενεργοποιώντας το, θα ενεργοποιηθεί και το "Απαιτείται λογαριασμός" under "Χαρακτηριστικά". Να προχωρήσουμε;';
$hesklang['can_email_tpl']='Επεξεργασία του προτύπου email';
$hesklang['et_title']='Πρότυπα email';
$hesklang['et_intro']='Επεξεργασία των emails που αποστέλλονται στο προσωπικό και στους πελάτες';
$hesklang['file']='Αρχείο';
$hesklang['efile']='Επεξεργασία αρχείου';
$hesklang['rdesc']='(Παραλήπτης) Περιγραφή';
$hesklang['desc_forgot_ticket_id']='(Πελάτης) Απώλεια ID αιτήματος';
$hesklang['desc_new_reply_by_staff']='(Πελάτης) Απάντηση νέου προσωπικού';
$hesklang['desc_new_ticket']='(Πελάτης) Ληφθέντα αιτήματα';
$hesklang['desc_ticket_closed']='(Πελάτης) Επιλυμένο/Κλειστό αίτημα';
$hesklang['desc_category_moved']='(Προσωπικό) Το αίτημα μεταφέρθηκε σε νέα κατηγορία';
$hesklang['desc_new_reply_by_customer']='(Προσωπικό) Νέα απάντηση πελάτη';
$hesklang['desc_new_ticket_staff']='(Προσωπικό) Υποβλήθηκε νέο αίτημα';
$hesklang['desc_ticket_assigned_to_you']='(Προσωπικό) Ένα νέο αίτημα υποβλήθηκε σε εσάς';
$hesklang['desc_new_pm']='(Προσωπικό) Νέο προσωπικό μήνυμα';
$hesklang['desc_new_note']='(Προσωπικό) Νέα σημείωση αιτήματος που έχει υποβληθεί σε εσάς';
$hesklang['desc_reset_password']='(Προσωπικό) Επαναφορά του κωδικού σας';
$hesklang['etfm']='Λείπουν ένα ή περισσότερα πρότυπα email.<br /><br />Βεβαιωθείτε ότι ανεβάσατε όλα τα πρότυπα email στον φάκελο <i>/language/%s/emails</i>.';
$hesklang['etfw']='Μερικά πρότυπα email δεν είναι επαναγράψημα.<br /><br />
                    Βεβαιωθείτε ότι η PHP έχει δικαιώματα εγγραφής σε όλα τα αρχεία στον φάκελο <i>/language/%s/emails</i>.<br /><br />
                    Στους Unix servers μπορεί να χρειάζεστε CHMOD τα πρότυπα email στο 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Απώλεια προτύπου ID';
$hesklang['et_fm']='Αυτό το αρχείο πρότυπου email λείπει';
$hesklang['et_fw']='Το αρχείο του πρότυπου email δεν είναι επαναγράψημο';
$hesklang['et_save']='Αποθήκευση προτύπου email';
$hesklang['updated_on']='Ανανέωση σε';
$hesklang['ticket_url']='URL αιτήματος';
$hesklang['pm_url']='URL ιδιωτικού μηνύματος';
$hesklang['et_num']='Αριθμός αιτημάτων';
$hesklang['et_list']='Λίστα υποστηριζόμενων αιτημάτων';
$hesklang['et_empty']='Το πρότυπο email δεν μπορεί να είναι άδειο';
$hesklang['et_saved']='Το πρότυπο του email αποθηκέυτηκε';
$hesklang['source']='Πηγή';
$hesklang['select_category']='Επιλέξτε μία κατηγορία';
$hesklang['select_category_text']='Πώς μπορούμε να σας βοηθήσουμε;';
$hesklang['select_category_staff']='Επιλογή κατηγορίας αιτήματος';
$hesklang['scat']='Επιλογή ορίου κατηγορίας';
$hesklang['scat2']='(εάν ο μετρητής της κατηγορίας είναι μεγαλύτερος, θα εμφανιστεί ένα πλαίσιο επιλογής)';
$hesklang['new_cf']='Πεδίο νέου πελάτη';
$hesklang['cf_intro']='Επιλέξτε αυτή τη λειτουργία για να προσθέσετε ένα προσαρμοσμένο πεδίο στην υποβολή αιτήματος, για τη συλλογή επιπλέον δεδομένων από τον πελάτη.';
$hesklang['cf_public']='Δημόσιο';
$hesklang['cf_private']='Μόνο για προσωπικό';
$hesklang['cf_cust']='Για τους πελάτες';
$hesklang['cf_all']='Όλα';
$hesklang['cf_cat']='Επιλεγμένα';
$hesklang['cf_ctrl']='Βοήθεια: κρατήστε πατημένο το πλήκτρο CTRL για να επιλέξετε περισσότερες κατηγορίες';
$hesklang['visibility']='Ορατότητα';
$hesklang['cf_save']='Αποθήκευση προσαρμοσμένου πεδίου';
$hesklang['ex_cf']='Ενεργοποίηση προσαρμοσμένων πεδίων';
$hesklang['no_cf']='Κανένα προσαρμοσμένο πεδίο δεν είναι ενεργό';
$hesklang['del_cf']='Διαγραφή του προσαρμοσμένου πεδίου; Με αυτό θα διαγραφούν και όλα τα αποθηκευμένα προσαρμοσμένα πεδία από τη βάση δεδομένων!';
$hesklang['cf_e_id']='Λάθος ID';
$hesklang['edit_cf']='Επεξεργασία προσαρμοσμένου πεδίου';
$hesklang['cf_deleted']='Το προσαρμοσμένο πεδίο έχει διαγραφεί';
$hesklang['cf_not_found']='Αυτό το προσαρμοσμένο πεδίο δεν υπάρχει';
$hesklang['cf_added']='Έχει προστεθεί ένα νέο προσαρμοσμένο πεδίο';
$hesklang['cf_nocat']='Επιλέξτε τουλάχιστον μία κατηγορία για αυτό το προσαρμοσμένο πεδίο';
$hesklang['cf_mdf']='Το προσαρμοσμένο πεδίο έχει αποθηκευθεί';
$hesklang['atl1']='Εισάγετε τουλάχιστον μία επιλογή.';
$hesklang['sch']='Κρυφό';
$hesklang['meml3']='Να επιτρέπεται η πολλαπλή εισαγωγή λογαριασμών email';
$hesklang['dmin']='Ελάχιστη επιτρεπτή ημερομηνία';
$hesklang['dmax']='Μέγιστη επιτρεπτή ημερομηνία';
$hesklang['d_day']='ημέρα(ες)';
$hesklang['d_week']='εβδομάδα(ες)';
$hesklang['d_month']='μήνας(ες)';
$hesklang['d_year']='έτος(η)';
$hesklang['d_any']='Κάθε ημερομηνία';
$hesklang['d_fixed']='Προσαρμοσμένη ημερομηνία';
$hesklang['d_relative']='Σχετική ημερομηνία';
$hesklang['d_mm']='Η ελάχιστη ημερομηνία δεν μπορεί να είναι μεγαλύτερη από τη μέγιστη ημερομηνία';
$hesklang['d_emin']='Η ελάχιστη ημερομηνία για <i>%s</i> είναι %s';
$hesklang['d_emax']='Η μέγιστη ημερομηνία για <i>%s</i> είναι %s';
$hesklang['d_format']='Μορφή προβαλόμενης ημερομηνίας';
$hesklang['d_custom']='Προσαρμοσμένη μορφή';
$hesklang['d_ci']='ΓΙΑ ΠΡΟΧΩΡΗΜΕΝΟΥΣ ΧΤΗΣΤΕΣ ΜΟΝΟ: μια PHP έγκυρη μορφή ημερομηνία, δείτε τον οδηγό της PHP.';
$hesklang['cf_noe']='Δώστε μια έγκυρη διεύθυνση email στο <i>%s</i>';
$hesklang['cf_noem']='Δώστε μία ή περισσότερες έγκυρες διευθύνσεις email στο <i>%s</i>';
$hesklang['can_resolve']='Μπορεί να επιλύει αιτήματα';
$hesklang['can_change_own_cat']='Αλλαγή κατηγορίας αιτήματος (να επιτρέπεται)';
$hesklang['can_submit_any_cat']='Μπορούν να υποβληθούν σε κάθε κατηγορία';
$hesklang['noauth_submit']='Δεν είστε εξουσιοδοτημένος να υποβάλλετε αιτήματα σε αυτή την κατηγορία!';
$hesklang['noauth_move']='Δεν είστε εξουσιοδοτημένος να μεταφέρετε αιτήματα σε αυτή την κατηγορία!';
$hesklang['noauth_resolve']='Δεν είστε εξουσιοδοτημένος να αναλλαμβάνετε αιτήματα!';
$hesklang['force_ssl']='Force SSL connections';
$hesklang['d_ssl']='<i>μη ενεργοποιημένο</i> - ανοίξτε τη σελίδα με https:// για να διαχειρηστείτε αυτή την επιλογή';
$hesklang['scno']='Αυτή η κατάσταση δεν μπορεί να αλλάξει';
$hesklang['statuses']='Καταστάσεις';
$hesklang['statuses_intro']='Χρησιμοποιήστε αυτό το εργαλείο για να προσθέσετε ένα προσαρμοσμένο πεδίο καταστάσεων στην εφαρμογή';
$hesklang['color']='Χρώμα';
$hesklang['csscl']='Κλάση CSS ή Χρώμα';
$hesklang['clr_view']='Προεπισκόπηση χρώματος σε κείμενο';
$hesklang['cbc']='Διαχειρίσιμα από τους πελάτες';
$hesklang['ccc']='Μπορούν οι πελάτες να αλλάξουν την κατάστασή τους;';
$hesklang['del_status']='Διαγραφή της κατάστασης;';
$hesklang['ex_status']='Υπάρχουσες καταστάσεις';
$hesklang['status_hesk']='Δημιουργημένες καταστάσεις (δεν μπορούν να τροποποιηθούν εδώ)';
$hesklang['status_custom']='Τροποποιημένες καταστάσεις';
$hesklang['status_custom_none']='Καμία τροποποιημένη κατάσταση. Μπορείτε να την προσθέσετε χρησιμοποιώντας την παρακάτω φόρμα.';
$hesklang['status_save']='Αποθήκευση κατάστασης';
$hesklang['list_tkt_status']='Λίστα όλων των αιτημάτων με αυτή την κατάσταση';
$hesklang['new_status']='Νέα τροποποιημένη κατάσταση';
$hesklang['edit_status']='Επεξεργασία τροποποιημένης κατάστασης';
$hesklang['err_status']='Δώστε το όνομα της κατάστασης';
$hesklang['status_added']='Μια νέα τροποποιημένη κατάσταση έχει προστεθεί';
$hesklang['status_e_id']='Λαθασμένο ID';
$hesklang['status_mdf']='Η τροποποιημένη κατάσταση έχει αποθηκευθεί';
$hesklang['status_deleted']='Η τροποποιημένη κατάσταση έχει διαγραφεί';
$hesklang['status_not_found']='Αυτή η τροποποιημένη κατάσταση δεν υπάρχει';
$hesklang['status_not_empty']='Αυτή η κατάσταση δεν μπορεί να αφαιρεθεί επειδή υπάρχουν ακόμα αιτήμα σε αυτήν';
$hesklang['status_limit']='Έχετε 100 τροποποιημένες καταστάσεις, δεν μπορεί να δημιουργηθεί νέα.';
$hesklang['public_link']='Δημόσιο link';
$hesklang['frames']='Frames';
$hesklang['frames2']='Αποτροπή φόρτωσης HESK σε πλαίσια σε τομείς τρίτων';
$hesklang['numsub']='Υποβληθέντα αιτήματα';
$hesklang['hidf']='Οι κρυφές εγγραφές δεν είναι εμφανές στους πελάτες στην φόρμα υποβολής αιτήματος (η τιμή θα εξακολουθεί να είναι εμφανής στη σελίδα λεπτομερειών, αν είναι δημόσια). Θα συμπεριφέρονται ως πεδία κειμένου στο προσωπικό.';
$hesklang['rcheck']='Μην επιλέξετε μια προεπιλεγμένη επιλογή';
$hesklang['refresh_page']='Ανανεώστε τη σελίδα';
$hesklang['del_kba']='Διαγραφή του άρθρου';
$hesklang['del_kbaa']='Μόνιμη διαγραφή του άρθρου';
$hesklang['hni1']='Ηεφαρμογή HESK δεν έχει εγκατασταθεί ακόμα;';
$hesklang['hni2']='Είναι πιθανό η εγκατάσταση και ρύθμιση της εφαρμογής help desk να μην έχει γίνει σωστά ακόμα.';
$hesklang['hni3']='Για την εγκατάσταση της εφαρμογής HESK, ακολουθήστε <a href="docs/">τις οδηγίες</a>';
$hesklang['cf']='Cache folder';
$hesklang['e_cdir']='Το Hesk δεν θα είναι σε θέση να αναλύσει μηνύματα ηλεκτρονικού ταχυδρομείου ή να αποθηκεύσει αποτελέσματα προσωρινής αποθήκευσης, εκτός εάν ο φάκελος προσωρινής αποθήκευσης υπάρχει και είναι εγγράψιμος.';
$hesklang['step1']='Βήμα 1';
$hesklang['step2']='Βήμα 2';
$hesklang['dffs']='Όταν η λήψη ολοκληρωθεί, διαγράψτε το αρχείο από τον server';
$hesklang['fd']='Το αρχείο εξαγωγής έχει διαγραφεί από τον server';

// Added in version 2.8.0
$hesklang['TZ']='Ζώνη ώρας';
$hesklang['thist17']='<li class="smaller">%s | υποβλήθηκε από IMAP fetching</li>';
$hesklang['sir3']='Μη ορατό reCAPTCHA';
$hesklang['invisible']='αόρατο';
$hesklang['imap_not']='Η PHP δεν μεταγλωττίστηκε με υποστήριξη IMAP';
$hesklang['imap_warning']='ο χρήστης %1$s έχει την ίδια διεύθυνση ηλεκτρονικού ταχυδρομείου με τη διεύθυνση ηλεκτρονικού ταχυδρομείου ανάκτησης IMAP: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='ο χρήστης %1$s έχει την ίδια διεύθυνση ηλεκτρονικού ταχυδρομείου με τη διεύθυνση ηλεκτρονικού ταχυδρομείου ανάκτησης POP3: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Αυτό θα μπορούσε να οδηγήσει σε έναν βρόχο ηλεκτρονικού ταχυδρομείου όπου δημιουργούνται νέα tickets από ειδοποιήσεις ηλεκτρονικού ταχυδρομείου χρηστών. Η διεύθυνση ηλεκτρονικού ταχυδρομείου που λαμβάνετε θα πρέπει να είναι μοναδική και να μην χρησιμοποιείται από κανέναν άλλο.';
$hesklang['can_view_ass_by']='Μπορεί να παρακολουθεί αιτήματα που έχουν ανατεθεί σε άλλους';
$hesklang['can_privacy']='Μπορεί να κάνει τα αιτήματα ανώνυμα';
$hesklang['confirm_anony']='Κάνε ανώνυμο το αίτημα';
$hesklang['anon_selected']='Κάνε ανώνυμα τα επιλεσμένα αιτήματα';
$hesklang['privacy_anon_info']='Διέγραψε τα προσωπικά δεδομένα των αιτημάτων (όνομα, email, μήνυμα, συνημμένα, IP...), αλλά διατήρησε τα αιτήματα στη βάση δεδομένων για στατηστικούς λόγους.';
$hesklang['success_anon']='Το αίτημα έγινε ανώνυμο επιτυχώς';
$hesklang['num_tickets_anon']='Αριθμός των αιτημάτων που έγιναν ανώνυμα: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Πελάτης]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Θέμα]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Μήνυμα]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | έγινε ανώνυμο από %s</li>';
$hesklang['print_selected']='Εκτύπωση των επιλεγμένων αιτημάτων';
$hesklang['with_selected']='Με επιλεγμένα:';
$hesklang['assign_selected']='Ανάθεση επιλεγμένων σε:';
$hesklang['assign_no']='Δεν έχει επιλεχθεί ιδιοκτήτης, δεν έγινε καμία αλλαγή';
$hesklang['assign_1']='Τα επιλεγμένα αιτήματα έχουν γίνει Μη ανατεθημένα.';
$hesklang['assign_2']='Το αίτημα με ID %1$s έγινε Μη ανατεθημένο'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s σφάλμα: έχει ήδη ανατεθεί σε %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s ανατλεθηκε σε %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s σφάλαμα: %2$s δεν έχει πρόσβαση στην κατηγορία του αιτήματος'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Αποτέλεσμα μαζικής ανάθεσης ticket:<br /><br />Ανατέθημένα: %1$s<br />Σφάλματα: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP address';
$hesklang['moret']='Περισσότερες επιλογές'; // More options button title
$hesklang['btn_more']='Περισσότερα'; // More options button text
$hesklang['btn_print']='Εκτύπωση';
$hesklang['btn_edit']='Επεξεργασία';
$hesklang['btn_lock']='Κλειδωμένο αίτημα';
$hesklang['btn_unlock']='Ξεκλείδωτο αίτημα';
$hesklang['btn_tag']='Tag ticket';
$hesklang['btn_resend']='Ξαναστείλε ενημέρωση με email';
$hesklang['btn_untag']='Ticket χωρός Ετικέτα';
$hesklang['btn_import_kb']='Εισαγωγή στη βάση δεδομένων';
$hesklang['btn_anony']='Ανώνυμα αιτήματα';
$hesklang['btn_delt']='Διαγραφή αιτήματος';
$hesklang['btn_delr']='Διαγραφή απάντησης';
$hesklang['ernf']='Η απάντηση δεν βράθηκε';
$hesklang['tns']='Οι ειδοποιήσεις του αιτήματος ξαναστάλθηκαν';
$hesklang['rns']='Οι ειδοποιήσεις της απάντησης ξαναστάλθηκαν';
$hesklang['fname']='Όνομα';
$hesklang['export_selected']='Εξαγωγή επιλεγμένων αιτημάτων';
$hesklang['btn_export']='Εξαγωγή σε XML για το Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Απαντήσεις';
$hesklang['team']='Ομάδα';
$hesklang['sm_content']='Περιεχόμενο';
$hesklang['sm_settings']='Ρυθμίσεις';
$hesklang['wizard_back']='Πίσω'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Επόμενο'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Πηγαίνετε στις Ρυθμίσεις';
$hesklang['sm_return_to_editing']='Επιστροφή στην Επεξεργασία';
$hesklang['email_tpl_title']='Τίτλος';
$hesklang['edit_email_template']='Επεξεργασία πρότυπου email';
$hesklang['err_no_settings_section']='Δεν παρέχεται ενότητα ρυθμίσεων.';
$hesklang['this_field_is_required']='Αυτό το πεδίο απαιτείται';
$hesklang['reset_your_password']='Επαναφορά του κωδικού σας';
$hesklang['reset_password_instructions']='Παρακαλούμε συμπληρώστε την παρακάτω φόρμα. Θα σας στείλουμε ένα σύνδεσμο με τον οποίο θα μπορέσετε να αλλάξετε τον κωδικό σας.';
$hesklang['enter_email']='Εισαγωγή email';
$hesklang['password_reset_check_your_email']='Ελέγξετε το email';
$hesklang['password_reset_link_sent']='Στείλαμε ένα σύνδεσμο για να επαναφέρετε τον κωδικό σας.';
$hesklang['back_to_login']='Πίσω στην είσοδο';
$hesklang['pager_first']='Πρώτη';
$hesklang['pager_previous']='Προηγούμενη';
$hesklang['pager_next']='Επόμενη';
$hesklang['pager_last']='Τελευταία';
$hesklang['new_team_member']='Νέο μέλος ομάδας';
$hesklang['role']='Ρόλος';
$hesklang['optional']='Προαιρετικό';
$hesklang['edit_profile']='Επεξεργασία προφίλ';
$hesklang['assigned_to']='Ανατίθεται σε';
$hesklang['contact']='Επαφή';
$hesklang['unban_email']='Unban αυτό το email';
$hesklang['unban_ip']='Unban αυτή την IP';
$hesklang['show_previous_replies']='Δείξε τις προηγούμενες απαντήσεις';
$hesklang['type_your_message']='Τυπώστε το μήνυμά σας'; // Used when there are no canned responses
$hesklang['close_button_text']='Κλείσιμο';
$hesklang['create_new_ticket']='Δημιουργία νέου αιτήματος';
$hesklang['delete_article']='Διαγραφή άρθρου';
$hesklang['view_existing_tickets']='Προβολή υπαρχόντων αιτημάτων';
$hesklang['how_can_we_help']='Γεια σας, πώς μπορούμε να σας βοηθήσουμε;';
$hesklang['search_for_articles']='Αναζήτηση για άρθρα';
$hesklang['submit_a_support_request']='Υποβολή ενός αιτήματος υποστήριξης';
$hesklang['verify_header']='Πρόληψη SPAM';
$hesklang['ticket_details']='Λεπτομέρειες Αιτήματος';
$hesklang['yes_title_case']='Ναι';
$hesklang['no_title_case']='Όχι';
$hesklang['no_results_found']='Δεν βρέθηκαν αποτελέσματα';
$hesklang['site_theme']='Θέμα ιστότοπου';
$hesklang['test_theme_folder']='Φάκελος δοκιμαστικού θέματος';
$hesklang['test_theme_folder_description']='Δοκιμή του φακέλου θεμάτων για έγκυρα θέματα. Μόνο τα θέματα τα οποία περνάνε όλα τα τεστ εγκαθίστανται.';
$hesklang['err_site_theme']='Παρακαλούμε επιλέξτε το θέμα του Hesk';
$hesklang['confirm']='Επιβεβαίωση';
$hesklang['confirm_deletion']='Επιβεβαίωση Διαγραφής';
$hesklang['confirm_delete_status']='Είστε σίγουροι ότι θέλετε να διαγράψετε αυτή τη προσαρμοσμένη κατάσταση;';
$hesklang['help_desk']='Help Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.en.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Εμφάνιση ώρας';
$hesklang['tdisd']='Ημερομηνία και ώρα';
$hesklang['tdisa']='Πριν από λίγη ώρα (παράδειγμα: πριν από 5 ώρες)';
$hesklang['nav_templates']='Πρότυπα'; // Admin panel navigation item
$hesklang['hide_replies']='Απόκρυψη απαντήσεων για Tickets';
$hesklang['hide_replies_no']='Μην κρύβεται, να εμφανίζεται πάντα όλες οι απαντήσεις';
$hesklang['hide_replies_yes']='Απόκρυψη όλων των απαντήσεων εκτός από την τελευταία:';
$hesklang['hide_replies_def']='Εμφάνιση της τελευταίας απάντησης του προσωπικού και τυχόν επόμενων απαντήσεων πελατών';
$hesklang['reply_by']='Απάντηση από'; // Reply by NAME
$hesklang['btt']='Επιστροφή στην κορυφή';
$hesklang['lwidth']='Περιορισμός πλάτους ticket';
$hesklang['lwidtall']='Χρησιμοποιήστε το πλήρες διαθέσιμο πλάτος';
$hesklang['lwidtpx']='Μέγιστο πλάτος σε pixel:';
// 3-letter days of the week
$hesklang['mon']='Δευ';
$hesklang['tue']='Τρι';
$hesklang['wed']='Τετ';
$hesklang['thu']='Πεμ';
$hesklang['fri']='Παρ';
$hesklang['sat']='Σαβ';
$hesklang['sun']='Κυρ';
$hesklang['clear']='Καθαρισμός'; // delete field value
$hesklang['first_day_of_week']='0'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Πρέπει να είναι ενεργοποιημένο τουλάχιστον ένα μέτρο πρόληψης SPAM!';
$hesklang['modules']='Ενότητες';
$hesklang['modules_demo']='Αυτή η ενότητα είναι προς το παρόν διαθέσιμη μόνο σε %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Δοκιμάστε την ζωντανή επίδειξη εδώ: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Στατιστικά';
$hesklang['statistics']['intro']='Αυτή η αναφορά θα σας δώσει μια εικόνα για τη χρήση του γραφείου υποστήριξης και την απόδοση του προσωπικού σας.';
$hesklang['statistics']['ntsp']='Δεν υπάρχουν tickets στην επιλεγμένη χρονική περίοδο.';
$hesklang['statistics']['pie_title_ro']='Ανοιχτά Tickets vs Επιλυμένων';
$hesklang['statistics']['open']='Ανοιτό';
$hesklang['statistics']['resolved']='Επιλυμένο';
$hesklang['statistics']['pie_title_as']='Ανοιχτά tickets: Ανατεθειμένα vs Μη ανατεθειμένα';
$hesklang['statistics']['ass']='Ανατεθιμένα';
$hesklang['statistics']['unas']='Μη Ανατεθιμένα';
$hesklang['statistics']['pie_title_au']='Ανοιχτά tickets: Απαντημένα vs Αναπάντητα';
$hesklang['statistics']['answered']='Απαντημένα';
$hesklang['statistics']['unanswered']='Αναπάντητα';
$hesklang['statistics']['pie_title_so']='Κατάσταση ανοιχτών tickets';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets ανά ημέρα του μήνα';
$hesklang['statistics']['chart_title_wd']='Tickets ανά ημέρα εβδομάδος';
$hesklang['statistics']['chart_title_hd']='Tickets ανά ώρα';
$hesklang['statistics']['chart_title_tfr']='Ώρα για την πρώτη απάντηση του προσωπικού';
$hesklang['statistics']['chart_title_tfrc']='Tickets που απαντήθηκαν εντός χρονικού πλαισίου';
$hesklang['statistics']['chart_title_ttr']='Χρόνος από την υποβολή έως την επίλυση ενός Αιτήματος';
$hesklang['statistics']['chart_title_ttrc']='Tickets που επιλύθηκαν εντός χρονικού πλαισίου';
$hesklang['statistics']['chart_title_sr']='Απαντήσεις προσωπικού';
$hesklang['statistics']['chart_title_srt']='Απαντήσεις προσωπικού ανά ticket';
$hesklang['statistics']['chart_title_srtr']='Απαντήσεις προσωπικού ανά ticket (μόνο επιλυμένα tickets)';
$hesklang['statistics']['chart_title_srt1']='Απαντήσεις προσωπικού ανά ticket (tickets με τουλάχιστον 1 απάντηση)';
$hesklang['statistics']['ct_30']='30 λεπτά';
$hesklang['statistics']['ct_1h']='1 ώρα';
$hesklang['statistics']['ct_2h']='2 ώρες';
$hesklang['statistics']['ct_4h']='4 ώρες';
$hesklang['statistics']['ct_1d']='1 ημέρα';
$hesklang['statistics']['ct_2d']='2 ημέρες';
$hesklang['statistics']['ct_3d']='3 ημέρες';
$hesklang['statistics']['ct_1w']='1 εβδομάδα';
$hesklang['statistics']['ct_wp']='> 1 εβδομάδα';
$hesklang['statistics']['ct_1m']='1 μήνα';
$hesklang['statistics']['ct_mp']='> 1 μήνα';
$hesklang['statistics']['axis1']='% από τα tickets tickets απαντήθηκαν';
$hesklang['statistics']['axis2']='% από τα tickets επιλύθηκαν';
$hesklang['statistics']['axis3']='% από τα tickets';
$hesklang['statistics']['axis4']='Ώρα για την πρώτη απάντηση';
$hesklang['statistics']['axis5']='Ώρα για επίλυση';
$hesklang['statistics']['axis6']='Αριθμός απαντήσεων';
$hesklang['statistics']['axis7']='Αριθμός tickets';
$hesklang['statistics']['axis8']='Ημέρα Εβδομάδος';
$hesklang['statistics']['axis9']='Ώρα';
$hesklang['statistics']['axis10']='Μέρα του Μήνα';
$hesklang['statistics']['tr_0']='Χωρός Απάντηση';
$hesklang['statistics']['tr_1']='1 απάντηση';
$hesklang['statistics']['tr_2']='2 απαντήσεις';
$hesklang['statistics']['tr_5']='3-5 απαντήσεις';
$hesklang['statistics']['tr_10']='6-10 απαντήσεις';
$hesklang['statistics']['tr_99']='> 10 απαντήσεις';
$hesklang['statistics']['average']='Μέσος Όρος';
$hesklang['statistics']['atfr']='Μέσος όρος ωρών και λεπτών έως την πρώτη απάντηση του προσωπικού:';
$hesklang['statistics']['attr']='Μέσες ώρες και λεπτά για την επίλυση ενός αιτήματος:';
$hesklang['statistics']['about']='περίπου %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Σύνολο απαντήσεων προσωπικού εισιτηρίων:';
$hesklang['statistics']['trnr']='Σύνολο αιτημάτων που επιλύθηκαν χωρίς απάντηση προσωπικού:';
$hesklang['statistics']['tsr']='Σύνολο αιτημάτων που επιλύθηκαν χωρίς απάντηση προσωπικού:';
$hesklang['statistics']['tsrt']='Μέσος όρος απαντήσεων προσωπικού ανά ticket:';
$hesklang['statistics']['tsro']='Μέσος όρος απαντήσεων προσωπικού ανά ticket (ticket με τουλάχιστον 1 απάντηση προσωπικού):';
$hesklang['statistics']['tsrc']='Μέσος όρος απαντήσεων προσωπικού που απαιτούνται για την επίλυση ενός αιτήματος:';
$hesklang['statistics']['tsrr']='Μέσος όρος απαντήσεων προσωπικού που απαιτούνται για την επίλυση ενός αιτήματος (αιτήματα με τουλάχιστον 1 απάντηση προσωπικού):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='και πολλά ακόμη...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Εκπρόθεσμο Ticket';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ΚΛΙΜΑΚΩΜΕΝΟ: %%SUBJECT%%';
$hesklang['escalate']['tab']='Κλιμάκωση'; // Menu link
$hesklang['escalate']['page_title']='Κλιμακωμένα Tickets'; // Page H2 title
$hesklang['escalate']['intro']='Αυτή η ενότητα θα σας βοηθήσει να κλιμακώσετε την αντιμετώπιση αιτημάτων που δεν έχουν αντιμετωπιστεί εγκαίρως.';
$hesklang['escalate']['feat1']='Τα αιτήματα δεν εκχωρήθηκαν, δεν απαντήθηκαν ή δεν επιλύθηκαν εντός χρονικού πλαισίου';
$hesklang['escalate']['feat2']='tickets που πλησιάζουν στην ημερομηνία λήξης και tickets που έχουν εκπνεύσει';
$hesklang['escalate']['feat3']='αυτόματη αλλαγή προτεραιότητας ticket, εκ νέου ανάθεση ticket, αποστολή ειδοποίησης μέσω email';
$hesklang['escalate']['feat4']='εφαρμογή κανόνων με βάση την κατηγορία ticket, τον κάτοχο, την κατάσταση';
$hesklang['escalate']['prefix']='Κλιμακωμένο:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Ενεργοί Κανόνες';
$hesklang['escalate']['new']='Νέος κανόνας κλιμάκωσης';
$hesklang['escalate']['no_rules']='Δεν έχετε κανόνες κλιμάκωσης. Δημιουργήστε έναν κάνοντας κλικ στο κουμπί &quot;Νέος κανόνας κλιμάκωσης&quot;';
$hesklang['escalate']['title']='Τίτλος Κανόνα';
$hesklang['escalate']['titlet']='Ένας περιγραφικός τίτλος, για παράδειγμα: Επαναανάθεση εισιτηρίων που δεν απαντήθηκαν εντός μίας ημέρας';
$hesklang['escalate']['default_title']='Κανόνας από %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Ενεργοποίηση κανόνα';
$hesklang['escalate']['trigt']='Ορίστε τη συνθήκη που θα ενεργοποιήσει (θα εκτελέσει) αυτόν τον κανόνα.';
$hesklang['escalate']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Συνθήκη'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Ενέργεια'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Εφαρμογή σε'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Διαγραφή αυτού του κανόνα?';
$hesklang['escalate']['edit']='Επεξεργασία ID κανόνα κλιμάκωσης %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Ένα Ticket υποστήριξης είναι:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='δεν απαντήθηκε από το προσωπικό';
$hesklang['escalate']['nrepc']='δεν απαντήθηκε από τον πελάτη';
$hesklang['escalate']['nass']='δεν έχει ανατεθεί';
$hesklang['escalate']['nres']='δεν έχει επιλυθεί';
$hesklang['escalate']['ndue']='πλησιάζει η ημερομηνία λήξης';
$hesklang['escalate']['odue']='εκπρόθεσμο';
$hesklang['escalate']['within']='Εντός:';
$hesklang['escalate']['minutes']='λεπτά';
$hesklang['escalate']['hours']='ώρες';
$hesklang['escalate']['days']='ημέρες';
$hesklang['escalate']['weeks']='εβδομάδες';
$hesklang['escalate']['months']='μήνες';
$hesklang['escalate']['years']='χρόνια';
$hesklang['escalate']['ofs']='από την υποβολή';
$hesklang['escalate']['resend']='Επανάληψη αποστολής ειδοποιήσεων μέσω email:';
$hesklang['escalate']['force']='Να στέλνεται πάντα, αγνοήστε τις ρυθμίσεις προσωπικού';
$hesklang['escalate']['noforce']='Σεβαστείτε τις ρυθμίσεις ειδοποιήσεων προσωπικού';
$hesklang['escalate']['setpri']='Ορισμός προτεραιότητας σε:';
$hesklang['escalate']['setsta']='Ορισμός κατάστασης σε:';
$hesklang['escalate']['assto']='Ορισμός ticket σε:';
$hesklang['escalate']['asm']='Ένα άλλο μέλος του προσωπικού';
$hesklang['escalate']['notify']='Ενημερώστε τα μέλη του προσωπικού...';
$hesklang['escalate']['ato']='Εφαρμογή σε:';
$hesklang['escalate']['tic']='Tickets στην κατηγορία:';
$hesklang['escalate']['tat']='Tickets που ανατέθηκαν σε:';
$hesklang['escalate']['tws']='Tickets με κατάσταση:';
$hesklang['escalate']['tall']='Εφαρμογή αυτού του κανόνα σε υπάρχοντα και μελλοντικά tickets';
$hesklang['escalate']['tfn']='Εφαρμόστε αυτόν τον κανόνα μόνο σε μελλοντικά tickets, αγνοήστε τα υπάρχοντα tickets';
$hesklang['escalate']['tfi']='Εφαρμόστε αυτόν τον κανόνα μόνο σε tickets με ID μεγαλύτερο από:';
$hesklang['escalate']['save']='Αποθήκευση Κανόνα';
$hesklang['escalate']['e_tt']='Ο χρόνος πρέπει να είναι μεταξύ 1 και 10000';
$hesklang['escalate']['e_a']='Επιλέξτε τουλάχιστον μία ενέργεια για εκτέλεση σε αντίστοιχα tickets';
$hesklang['escalate']['nocat']='Επιλέξτε τουλάχιστον μία κατηγορία';
$hesklang['escalate']['nouser']='Επιλέξτε τουλάχιστον έναν χρήστη';
$hesklang['escalate']['nostatus']='Επιλέξτε τουλάχιστον μία κατάσταση';
$hesklang['escalate']['nocata']='%1$s δεν έχει πρόσβαση σε αυτές τις κατηγορίες:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Δημιουργήθηκε νέος κανόνας';
$hesklang['escalate']['mdf']='Οι ρυθμίσεις κανόνα έχουν αποθηκευτεί';
$hesklang['escalate']['e_id']='Δεν βρέθηκε κανόνας με αυτό το ID';
$hesklang['escalate']['deleted']='Ο επιλεγμένος κανόνας έχει διαγραφεί';
$hesklang['escalate']['edit_notice']='Η αλλαγή της ενεργοποίησης κανόνα δεν θα έχει καμία επίδραση σε κανένα ticket που έχει ήδη κλιμακωθεί από αυτόν τον κανόνα (εκτός εάν επαναφέρετε τον κανόνα).';
$hesklang['escalate']['reset']='Επαναφορά αυτού του κανόνα';
$hesklang['escalate']['reset2']='Είστε σίγουροι ότι θέλετε να επαναφέρετε αυτόν τον κανόνα;<br><br>Τα Hits στον κανόνα θα επιστρέψουν στο 0 και οποιοδήποτε ticket που ταιριάζει με αυτόν τον κανόνα θα κλιμακωθεί ξανά.';
$hesklang['escalate']['reset3']='Ο επιλεγμένος κανόνας επαναφέρθηκε';
$hesklang['escalate']['log_title']='Κανόνας #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | κλιμακώθηκε από %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - ορισμός προτεραιότητας σε %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - ανατέθηκε σε %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - αποστολή ειδοποίησης προσωπικού</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - αποστολή ειδοποίησης προσωπικού (επιβολή)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - σφάλμα: %2$s δεν έχει πρόσβαση στην κατηγορία ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - σφάλμα: %2$s δεν έχει άδεια προβολής ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - σφάλμα: κανένας άλλος χρήστης δεν μπορεί να δει αυτό το ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - ειδοποίηση: προτεραιότητα που έχει ήδη οριστεί σε %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - ειδοποίηση: έχει ήδη ανατεθεί σε %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - ειδοποίηση: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - ορισμός κατάστασης σε%2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - ειδοποίηση: η κατάσταση έχει ήδη οριστεί σε%2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Ενεργός'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Ενεργοποίηση αυτού του κανόνα (έναρξη χρήσης του)';
$hesklang['escalate']['activated']='Ο επιλεγμένος κανόνας έχει ενεργοποιηθεί'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Απενεργοποίηση αυτού του κανόνα (διακοπή χρήσης του)';
$hesklang['escalate']['deactivated']='Ο επιλεγμένος κανόνας έχει απενεργοποιηθεί'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Δεν υπάρχουν ενεργοί κανόνες κλιμάκωσης';
$hesklang['escalate']['matched']='Αριθμός αντίστοιχων εισιτηρίων που βρέθηκαν: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Εργαλεία';
$hesklang['escalate']['test']='Προσομοίωση αυτού του κανόνα';
$hesklang['escalate']['testa']='Προσομοίωση όλων των κανόνων';
$hesklang['escalate']['testaa']='Προσομοίωση όλων των ενεργών κανόνων';
$hesklang['escalate']['testr']='Αποτελέσματα προσομοίωσης';
$hesklang['escalate']['rsim']='Επανάληψη προσομοίωσης';
$hesklang['escalate']['tbef']='Πριν δημοσιευτεί ένας κανόνας, πρέπει να τον ενεργοποιήσετε κάνοντας κλικ στο πλαίσιο ελέγχου στη στήλη &quot;ΕΝΕΡΓΟΣ&quot;.<br><br>
                               Σας συνιστούμε ανεπιφύλακτα να <strong>προσομοιώσετε</strong> κάθε κανόνα κάνοντας κλικ στο εικονίδιο %1$s (Προσομοίωση αυτού του κανόνα) στον πίνακα κανόνων
							   για να δείτε πώς θα επηρεάσει τα υπάρχοντα εισιτήριά σας πριν τα ενεργοποιήσετε.<br><br>
                               <strong>Οι ενεργοί κανόνες υποβάλλονται σε επεξεργασία κάθε %2$s λεπτά. Ένα αίτημα μπορεί να κλιμακωθεί μόνο μία φορά από κάθε κανόνα.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='ΛΕΙΤΟΥΡΓΙΑ ΠΡΟΣΟΜΟΙΩΣΗΣ, καμία αλλαγή στη βάση δεδομένων';
$hesklang['escalate']['sic']='Η ΠΡΟΣΟΜΟΙΩΣΗ ΟΛΟΚΛΗΡΩΘΗΚΕ';
$hesklang['escalate']['r']='[ΚΑΝΟΝΑΣ]';
$hesklang['escalate']['i']='[ΠΛΗΡΟΦΟΡΙΕΣ]';
$hesklang['multopt']='Συμβουλή: κρατήστε πατημένο το πλήκτρο CTRL για να επιλέξετε πολλές επιλογές';
$hesklang['desc_ticket_escalated']='(Προσωπικό) Το αίτημα έχει κλιμακωθεί'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Μορφοποίηση αιτημάτων (Προσωπικό)';
$hesklang['ticket_formatting_plaintext']='Απλό κείμενο';
$hesklang['ticket_formatting_rich_text']='Εμπλουτισμένο κείμενο (HTML)';
$hesklang['due_date']='Ημερομηνία λήξης';
$hesklang['invalid_due_date']='Εισήχθη μη έγκυρη ημερομηνία λήξης.';
$hesklang['thist19']='<li class="smaller">%s | Η ημερομηνία λήξης ενημερώθηκε σε %s από %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | Η ημερομηνία λήξης αφαιρέθηκε από %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Η ημερομηνία λήξης των εισιτηρίων έχει ενημερωθεί.';
$hesklang['menu_kb_manage']='Διαχείριση'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Προβολή'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Επιλογή Όλων';
$hesklang['a_deselect']='Απαλοιφή Όλων';
$hesklang['a_toggle']='Εμφάνιση Όλών';
$hesklang['ql_all']='Όλα τα tickets';
$hesklang['ql_alo']='Όλα τα Ανοιχτά tickets';
$hesklang['ql_fit']='Φιλτραρισμένα tickets';
$hesklang['ql_a2m']='Μου ανατέθηκαν';
$hesklang['ql_a2o']='Ανατέθηκαν σε άλλους';
$hesklang['ql_una']='Μη ανατεθειμένα';
$hesklang['ql_due']='Λήγουν Σύντομα';
$hesklang['ql_ovr']='Εκπρόθεσμα';
$hesklang['set_ds']='Εμφάνιση ως &quot;λήγει σύντομα&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='ημέρες πριν από την ημερομηνία λήξης';
$hesklang['not_aos']='Ορισμένα ανοιχτά tickets στα οποία έχετε πρόσβαση δεν εμφανίζονται λόγω των φίλτρων σας.';
$hesklang['ntoverdue']='Ένα ticket έχει εκπρόθεσμη ημερομηνία παράδοσης στον κάτοχο:';
$hesklang['ovdcron']='για να λειτουργήσουν οι ειδοποιήσεις εκπρόθεσμης λήξης, ο διαχειριστής σας πρέπει να ενεργοποιήσει μια εργασία cron.';
$hesklang['instructions']='Οδηγίες';
$hesklang['desc_overdue_ticket']='(Προσωπικό) Εκπρόθεσμο Ticket';
$hesklang['overdue_starting']='Έναρξη διαδικασίας ειδοποίησης για εκπρόθεσμα tickets';
$hesklang['overdue_sim']='Η αποστολή email και η ενημέρωση αιτημάτων είναι απενεργοποιημένη στη λειτουργία ΠΡΟΣΟΜΟΙΩΣΗΣ.';
$hesklang['overdue_ticket_count']='Βρέθηκαν %s tickets που έχουν εκπρόθεσμη ημερομηνία λήξης.'; // %s = Number of tickets
$hesklang['overdue_finished']='Ολοκληρώθηκαν τα εκπρόθεσμα αιτήματα. Στάλθηκαν %s email. Η αποστολή %s email απέτυχε.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Φόρτωση ενός επιπλέον αρχείου προσαρμοσμένου στυλ για τον πίνακα διαχείρισης';
$hesklang['noval_cert']='Μην επικυρώσεις τα πιστοποιητικά διακομιστή';
$hesklang['chg_cat']='Κάντε κλικ για να αλλάξετε κατηγορία ticket';
$hesklang['tlan']='Γλώσσα Ticket';
$hesklang['uue']='Δύο ή περισσότερα μέλη του προσωπικού έχουν την ίδια διεύθυνση ηλεκτρονικού ταχυδρομείου. Συνιστούμε να ορίσετε μια μοναδική διεύθυνση ηλεκτρονικού ταχυδρομείου για κάθε χρήστη.';
$hesklang['flood']='Όριο υπερχείλισης';
$hesklang['e_flood']='Ωχ, υποβάλατε ήδη μια απάντηση μόλις πρόσφατα. Διακόψαμε αυτό το αίτημα για να αποτρέψουμε την υπερχείλιση απαντήσεων.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='URL Access Key'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Δημιουργία ενός τυχαίου URL Access Key';
$hesklang['ukeym']='Σφάλμα: για να εκτελέσετε αυτό το αρχείο μέσω HTTP, πρέπει να συμπεριλάβετε το κλειδί πρόσβασης URL στο αίτημα. Παράδειγμα:';
$hesklang['ukeyw']='Σφάλμα: λάθος URL Access Key';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Λήφθηκε Ticket: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% είναι ο κωδικός επαλήθευσής σας';
$hesklang['follow_up_email']='Να είσαστε ειλικρινείς - Πώς τα πήγαμε;';
$hesklang['mfa']='Πολυπαραγοντικός Έλεγχος Αυθεντικοποίησης (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='Ενεργοποιημένο MFA;';
$hesklang['mfa_required']='Απαιτείται έλεγχος ταυτότητας πολλαπλών παραγόντων';
$hesklang['mfa_manage_profile']='Διαχείριση MFA';
$hesklang['mfa_disabled']='Ο έλεγχος ταυτότητας πολλαπλών παραγόντων είναι απενεργοποιημένος';
$hesklang['mfa_enabled']='Ο έλεγχος ταυτότητας πολλαπλών παραγόντων είναι ενεργοποιημένος (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Τίποτα';
$hesklang['mfa_method_none_subtext']='Καταργήστε τον έλεγχο ταυτότητας πολλαπλών παραγόντων στον λογαριασμό σας.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='Το helpdesk θα στείλει ένα email με έναν τυχαίο κωδικό εισόδου στο <strong>%s</strong> κατά τη σύνδεση.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Εφαρμογή Επαλήθευσης';
$hesklang['mfa_method_auth_app_short']='Εφαρμογή';
$hesklang['mfa_method_auth_app_subtext']='Χρησιμοποιήστε μια εφαρμογή σε smartphone, όπως το Authy ή το Google Authenticator, για να δημιουργήσετε έναν τυχαίο κωδικό εισόδου κατά τη σύνδεση.';
$hesklang['mfa_step_method']='Μέθοδος';
$hesklang['mfa_step_verification']='Επαλήθευση';
$hesklang['mfa_step_complete']='Ολοκληρώθηκε';
$hesklang['mfa_introduction']='Η πολυπαραγοντική επαλήθευση βελτιώνει την ασφάλεια του λογαριασμού απαιτώντας να επιβεβαιώσετε τη σύνδεσή σας με μια επιπλέον μέθοδο επαλήθευσης, όπως email ή εφαρμογή επαλήθευσης (π.χ. Authy ή Google Authenticator).';
$hesklang['mfa_reset_warning']='Έχετε ήδη ενεργοποιήσει πολυπαραγοντική επαλήθευση. Η ολοκλήρωση ξανά θα επαναφέρει τη συσκευή επαλήθευσης (εάν έχει ενεργοποιηθεί).';
$hesklang['mfa_select_method_colon']='Επιλέξτε μέθοδο επαλήθευσης:';
$hesklang['mfa_verification_header']='Επαλήθευση - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Ένα email έχει σταλεί στο <strong>%s</strong> με έναν εξαψήφιο κωδικό επαλήθευσης. Εισάγετε τον κωδικό που λάβατε μέσω email παρακάτω για να συνεχίσετε.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Βήμα 1: Σαρώστε την παρακάτω εικόνα με την εφαρμογή πολυπαραγοντικής επαλήθευσης στη συσκευή σας.';
$hesklang['mfa_verification_auth_app_cant_scan']='Δεν μπορείτε να σαρώσετε την εικόνα; Εισάγετε χειροκίνητα αυτόν τον κωδικό στη συσκευή σας: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Βήμα 2: Εισάγετε τον εξαψήφιο κωδικό που εμφανίζεται στην εφαρμογή σας για να επαληθεύσετε τη συσκευή σας.';
$hesklang['mfa_verify']='Επαλήθευση';
$hesklang['mfa_invalid_method']='Λήφθηκε μη έγκυρη μέθοδος πολυπαραγοντικής επαλήθευσης.';
$hesklang['mfa_invalid_verification_code']='Ο κωδικός που εισήχθη είναι λανθασμένος ή έληξε.';
$hesklang['mfa_configured']='Η πολυπαραγοντική επαλήθευση έχει ενεργοποιηθεί για τον λογαριασμό σας!';
$hesklang['mfa_removed']='Η πολυπαραγοντική επαλήθευση έχει απενεργοποιηθεί για τον λογαριασμό σας!';
$hesklang['mfa_verification_needed']='Η πολυπαραγοντική επαλήθευση είναι ενεργή για αυτόν τον λογαριασμό.';
$hesklang['mfa_verification_needed_email']='Παρακαλώ εισάγετε τον κωδικό επαλήθευσης που εστάλη στη διεύθυνση email σας.';
$hesklang['mfa_verification_needed_auth_app']='Παρακαλώ εισάγετε τον κωδικό που εμφανίζεται στην εφαρμογή επαλήθευσης.';
$hesklang['mfa_verification_code']='Κωδικός επαλήθευσης';
$hesklang['mfa_server_time_issue']='Η ώρα του server σας φαίνεται να είναι ανακριβής: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Επαναφορά πολυπαραγοντικής επαλήθευσης';
$hesklang['mfa_reset_confirm']='Είστε βέβαιοι ότι θέλετε να επαναφέρετε την MFA για αυτόν τον χρήστη;';
$hesklang['mfa_reset_yes']='Επαναφορά';
$hesklang['mfa_reset']='Η πολυπαραγοντική επαλήθευση έχει επαναφερθεί για τον χρήστη';
$hesklang['desc_mfa_verification']='(Προσωπικό) Κωδικός πολυπαραγοντικής επαλήθευσης';
$hesklang['mfa_code']='Κωδικός:';
$hesklang['mfa_backup_codes_header']='ΑΠΟΘΗΚΕΥΣΤΕ ΤΟΥΣ ΕΦΕΔΡΙΚΟΥΣ ΣΑΣ ΚΩΔΙΚΟΥΣ!';
$hesklang['mfa_backup_codes_description']='Κρατήστε αυτούς τους εφεδρικούς κωδικούς κάπου ασφαλή αλλά προσβάσιμα. Σε περίπτωση που χάσετε την πρόσβαση στη συσκευή MFA ή στο email σας, μπορείτε να εισάγετε έναν από τους παρακάτω εφεδρικούς κωδικούς για να συνδεθείτε.<br><br><strong>Σιγουρευτείτε ότι θα χειρίζεστε αυτούς τους εφεδρικούς κωδικούς σαν κωδικούς πρόσβασης. Δεν θα μπορείτε να τους δείτε ξανά!</strong>';
$hesklang['mfa_verify_another_way']='Επαληθεύστε τον λογαριασμό σας με άλλο τρόπο'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Λάβετε έναν κωδικό επαλήθευσης στο %s';
$hesklang['mfa_verify_another_way_code']='Εισάγετε έναν από τους εφεδρικούς κωδικούς 8 χαρακτήρων';
$hesklang['mfa_verify_another_way_admin']='Επικοινωνήστε με τον διαχειριστή του helpdesk για βοήθεια';
$hesklang['mfa_verify_another_way_reset']='Επαναφέρετε την πολυπαραγοντική επαλήθευση ανεβάζοντας ένα αρχείο στον server';
$hesklang['mfa_send_another_email']='Αποστολή άλλου email';
$hesklang['mfa_sent']='Ένα email με νέο κωδικό επαλήθευσης στάλθηκε στη διεύθυνση email σας';
$hesklang['mfa_backup_code']='Εφεδρικός κωδικός';
$hesklang['mfa_backup_codes']='Εφεδρικοί κωδικοί';
$hesklang['mfa_backup_codes_info']='Κωδικοί μιας χρήσης για την ολοκλήρωση πολυπαραγοντικής επαλήθευσης όταν δεν έχετε πρόσβαση στο email ή στην εφαρμογή επαλήθευσης. Μόλις χρησιμοποιήσετε έναν εφεδρικό κωδικό για να συνδεθείτε, αυτός γίνεται ανενεργός.';
$hesklang['mfa_backup_codes_num']='Μπορείτε να λάβετε νέο σετ 10 εφεδρικών κωδικών όποτε θέλετε. Όταν δημιουργήσετε νέο σετ, το παλιό σετ γίνεται αυτόματα ανενεργό.';
$hesklang['mfa_backup_codes_num2']='Αριθμός ενεργών κωδικών σας: %s';
$hesklang['mfa_invalid_backup_code']='Ο εφεδρικός κωδικός που εισήχθη είναι λανθασμένος ή έχει ήδη χρησιμοποιηθεί.';
$hesklang['mfa_del_codes']='Διαγραφή των εφεδρικών μου κωδικών';
$hesklang['mfa_del_codes2']='Όλοι οι εφεδρικοί σας κωδικοί έχουν διαγραφεί.';
$hesklang['mfa_new_codes']='Δημιουργία νέων εφεδρικών κωδικών';
$hesklang['mfa_new_codes2']='Δημιουργήθηκαν νέοι εφεδρικοί κωδικοί';
$hesklang['old_php_version']='Σφάλμα: Μη υποστηριζόμενη έκδοση PHP';
$hesklang['category_default_due_date']='Προεπιλεγμένη ημερομηνία λήξης';
$hesklang['category_change_default_due_date']='Ορισμός προεπιλεγμένης ημερομηνίας λήξης';
$hesklang['category_leave_blank_for_no_default_due_date']='(αφήστε κενό για καμία προεπιλεγμένη ημερομηνία λήξης)';
$hesklang['category_default_due_date_updated']='Η προεπιλεγμένη ημερομηνία λήξης ενημερώθηκε.';
$hesklang['email_formatting']='Μορφοποίηση email';
$hesklang['email_formatting_html_and_plaintext']='HTML με εναλλακτικό απλό κείμενο από πρότυπο απλού κειμένου (προεπιλογή)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML με εναλλακτικό απλό κείμενο που δημιουργείται από το πρότυπο HTML';
$hesklang['email_formatting_html']='Μόνο HTML';
$hesklang['email_formatting_plaintext']='Μόνο απλό κείμενο';
$hesklang['email_formatting_note']='Η επιλογή σας στο %1$s &gt; %2$s &gt; %3$s είναι ρυθμισμένη σε: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Αυτό σημαίνει ότι το Hesk θα αγνοήσει τα πρότυπα HTML εδώ.';
$hesklang['email_formatting_note1']='Αυτό σημαίνει ότι το Hesk θα αγνοήσει τα πρότυπα απλού κειμένου εδώ.';
$hesklang['email_formatting_note2']='Αυτό σημαίνει ότι το Hesk θα δημιουργήσει έκδοση απλού κειμένου από τα πρότυπα HTML και θα αγνοήσει τα πρότυπα απλού κειμένου εδώ.';
$hesklang['etnu']='Αυτό το πρότυπο email δεν χρησιμοποιείται από το Hesk βάσει της επιλογής σας στο %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Επεξεργασία κατηγορίας';
$hesklang['create_category']='Δημιουργία κατηγορίας';
$hesklang['one_user_included']='1 χρήστης συμπεριλαμβάνεται';
$hesklang['one_user_excluded']='1 χρήστης εξαιρείται';
$hesklang['x_users_included']='%s χρήστες συμπεριλαμβάνονται'; // %s = Number of users
$hesklang['x_users_excluded']='%s χρήστες εξαιρούνται'; // %s = Number of users
$hesklang['aa_cat']='Αυτόματη ανάθεση tickets σε αυτήν την κατηγορία';
$hesklang['modify_autoassign_settings']='Τροποποίηση ρυθμίσεων αυτόματης ανάθεσης';
$hesklang['autoassign_on_all_users']='Ναι, σε οποιονδήποτε χρήστη με πρόσβαση σε αυτήν την κατηγορία';
$hesklang['autoassign_on_select_users']='Ναι, σε συγκεκριμένους χρήστες';
$hesklang['autoassign_off']='Όχι, τα tickets να υποβάλλονται ως μη ανατεθειμένα';
$hesklang['autoassign_users']='Χρήστες προς συμπερίληψη/εξαίρεση στην αυτόματη ανάθεση';
$hesklang['autoassign_selected_include']='Οι επιλεγμένοι χρήστες θα πρέπει να <strong>συμπεριλαμβάνονται</strong> κατά την αυτόματη ανάθεση tickets σε αυτήν την κατηγορία';
$hesklang['autoassign_selected_exclude']='Οι επιλεγμένοι χρήστες θα πρέπει να <strong>εξαιρούνται</strong> κατά την αυτόματη ανάθεση tickets σε αυτήν την κατηγορία';
$hesklang['cat_edited']='Η κατηγορία %s επεξεργάστηκε με επιτυχία';
$hesklang['search_for_user']='Αναζήτηση χρήστη';
$hesklang['email_sending']='Αποστολή emails';
$hesklang['email_to_ticket']='Email σε ticket';
$hesklang['email_to_ticket_info']='Η μετατροπή emails σε tickets απαιτεί ρυθμίσεις από τον server. Για λεπτομέρειες, δείτε <a href="%s" target="_blank">αυτόν τον οδηγό knowledgebase</a>.'; // %s = link to article
$hesklang['from_warning2']='Το Hesk χρησιμοποιεί SMTP server για να στείλει ειδοποιήσεις email. Το <strong>%1$s</strong> πρέπει να έχει οριστεί σε <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Λείπει η κατάληξη αρχείου';
$hesklang['block_ignore']='Email σε ticket - Αγνόηση emails και αποτροπή βρόχων';
$hesklang['block_noreply']='Μην απαντάτε';
$hesklang['block_noreply2']='Αγνόηση emails από διευθύνσεις "do not reply"';
$hesklang['block_returned']='Επιστραφέντα';
$hesklang['block_returned2']='Αγνόηση επιστραφέντων emails, όπως ειδοποιήσεις παράδοσης ή αυτόματες απαντήσεις';
$hesklang['block_duplicate']='Διπλότυπα';
$hesklang['block_duplicate2']='Αγνόηση emails με το ίδιο μήνυμα που εστάλη μέσα σε &quot;%s&quot; δευτερόλεπτα'; // %s = "Timeframe"
$hesklang['loop_info']='emails που λήφθηκαν από την ίδια διεύθυνση μέσα σε &quot;%s&quot; δευτερόλεπτα';
$hesklang['thist21']='<li class="smaller">%s | ειδοποίηση email για καθυστέρηση στάλθηκε</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | στάλθηκε email παρακολούθησης</li>'; // %s = date
$hesklang['elevator_header']='Είσοδος σε ασφαλή περιοχή';
$hesklang['elevator_intro']='Πρόκειται να εισέλθετε σε ασφαλή περιοχή.';
$hesklang['elevator_enter_password']='Παρακαλώ εισάγετε τον κωδικό πρόσβασής σας για να συνεχίσετε.';
$hesklang['elevator_duration_setting_title']='Διάρκεια ασφαλούς περιοχής';
$hesklang['desc_survey']='(Πελάτης) Email παρακολούθησης (έρευνα)'; // Email description
$hesklang['satisfaction']['tab']='Ικανοποίηση';
$hesklang['satisfaction']['title']='Έρευνα Ικανοποίησης Πελατών';
$hesklang['satisfaction']['intro']='Στείλτε στους πελάτες σας μια έρευνα ικανοποίησης για να συλλέξετε σχόλια σχετικά με την εμπειρία τους με το helpdesk.';
$hesklang['satisfaction']['tab1']='Ρυθμίσεις';
$hesklang['satisfaction']['tab2']='Απενεργοποίηση';
$hesklang['satisfaction']['enable']='Ενεργοποίηση emails παρακολούθησης:';
$hesklang['satisfaction']['enabled']='Οι Έρευνες Ικανοποίησης Πελατών είναι ενεργές.';
$hesklang['satisfaction']['disabled']='Οι Έρευνες Ικανοποίησης Πελατών είναι απενεργοποιημένες.';
$hesklang['satisfaction']['url']='Διεύθυνση URL έρευνας:';
$hesklang['satisfaction']['send']='Καθυστέρηση email παρακολούθησης:';
$hesklang['satisfaction']['at_least']='Περιμένετε τουλάχιστον';
$hesklang['satisfaction']['after']='μετά την επίλυση του ticket πριν σταλεί το email';
$hesklang['satisfaction']['h1']='Πώς να χρησιμοποιήσετε αυτό το εργαλείο;';
$hesklang['satisfaction']['h2']='Πρώτα, δημιουργήστε μια έρευνα ικανοποίησης πελατών στο αγαπημένο σας εργαλείο ερευνών. Αν δεν ξέρετε τι εργαλείο να χρησιμοποιήσετε ή τι ερωτήσεις να κάνετε, έχουμε έναν <a href="%s" target="_blank">οδηγό εδώ</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Όταν η έρευνα είναι έτοιμη, ενεργοποιήστε τα emails παρακολούθησης παρακάτω. Το Hesk θα επεξεργάζεται επιλυμένα tickets με τουλάχιστον μία απάντηση προσωπικού μία φορά την ώρα και θα στέλνει το link της έρευνας στους πελάτες σας.';
$hesklang['satisfaction']['e_url']='Εισάγετε μια έγκυρη διεύθυνση URL έρευνας. Αυτή είναι η διεύθυνση στην οποία θα σταλούν οι πελάτες σας.';
$hesklang['satisfaction']['as']='Εισάγετε μια έγκυρη διεύθυνση URL έρευνας. Αυτή είναι η διεύθυνση στην οποία θα σταλούν οι πελάτες σας.';
$hesklang['satisfaction']['oo1']='Αυτή η σελίδα εμφανίζει τις διευθύνσεις email στις οποίες ΔΕΝ θα σταλούν emails παρακολούθησης.';
$hesklang['satisfaction']['oo2']='Οι πελάτες σας μπορούν να εξαιρεθούν από τα emails ερευνών κάνοντας κλικ σε ένα link στο email. Εναλλακτικά, μπορείτε να προσθέσετε χειροκίνητα διευθύνσεις εδώ.';
$hesklang['satisfaction']['ooe']='Διεύθυνση email για εξαίρεση';
$hesklang['satisfaction']['ooe2']='Εισάγετε τη διεύθυνση email που θέλετε να εξαιρεθεί από τα emails ερευνών.';
$hesklang['satisfaction']['ooe3']='Αυτή η διεύθυνση email <i>%s</i> έχει ήδη εξαιρεθεί από τα emails ερευνών.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Εξαίρεση αυτής της διεύθυνσης';
$hesklang['satisfaction']['oob']='Εξαιρέθηκε από';
$hesklang['satisfaction']['no_oo']='Κανένας πελάτης δεν έχει εξαιρεθεί από τα emails ερευνών.';
$hesklang['satisfaction']['oor']='Αφαίρεση';
$hesklang['satisfaction']['oor2']='Η διεύθυνση email αφαιρέθηκε από την εξαίρεση';
$hesklang['satisfaction']['oor3']='Επιβεβαίωση αφαίρεσης';
$hesklang['satisfaction']['oor4']='Με την αφαίρεση από την εξαίρεση, αυτός ο χρήστης θα λαμβάνει ξανά emails παρακολούθησης.';
$hesklang['satisfaction']['optedout']='Η διεύθυνση email <i>%s</i> εξαιρέθηκε από τα emails ερευνών.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Λείπει ή μη έγκυρο ID έρευνας';
$hesklang['satisfaction']['starting']='Έναρξη διαδικασίας ειδοποιήσεων έρευνας ικανοποίησης πελατών';
$hesklang['satisfaction']['tc']='Βρέθηκαν %s κλειστά tickets που δεν είχαν λάβει email έρευνας.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Ολοκληρώθηκε η Έρευνα Ικανοποίησης Πελατών. Emails που στάλθηκαν: %1$s. Emails που απέτυχαν: %2$s. Tickets χωρίς email: %3$s. Tickets με εξαίρεση: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Παράλειψη, ο πελάτης δεν θέλει να λαμβάνει emails ερευνών.';
$hesklang['satisfaction']['ne']='Παράλειψη, αυτό το ticket δεν έχει διεύθυνση email';
$hesklang['satisfaction']['feat1']='Δημιουργήστε την έρευνα με οποιοδήποτε εργαλείο τρίτου, όπως Google Forms';
$hesklang['satisfaction']['feat2']='Ρυθμίστε το URL έρευνας, προτιμήσεις και περιορισμούς μέσα σε αυτό το module';
$hesklang['satisfaction']['feat3']='Όταν λύνετε ένα ticket, το Hesk θα στέλνει στον πελάτη σας το link της έρευνας';
$hesklang['dfor']='Μορφή ημερομηνίας';
$hesklang['dtfor']='Ημερομηνία και ώρα';
$hesklang['cdfor']='Μορφή επιλογής ημερομηνίας';
$hesklang['custom']='Προσαρμοσμένο';
$hesklang['jsc_notice']='Η επιλογή ημερομηνίας δεν υποστηρίζει PHP-style μορφοποίηση. Επιλέξτε μία από τις προεπιλογές ή κάντε κλικ στο εικονίδιο %s παρακάτω για να δείτε διαθέσιμες επιλογές.'; // %s = replaced by icon
$hesklang['lcf3']='Μόνο ημερομηνία'; // Display: "Date only"
$hesklang['epdd']='Σφάλμα ανάλυσης παραμέτρου due_date:';
$hesklang['edit_pass']='Επεξεργασία κωδικού';
$hesklang['save_pass']='Αποθήκευση κωδικού';
$hesklang['cur_pass']='Τρέχων κωδικός';
$hesklang['cur_pass2']='Πρέπει να εισάγετε τον τρέχοντα κωδικό σας για να τον αλλάξετε.';
$hesklang['cur_pass3']='Μετά την επιτυχή αλλαγή κωδικού, θα μεταφερθείτε στη σελίδα σύνδεσης, όπου θα συνδεθείτε με τον νέο κωδικό σας.';
$hesklang['e_new_pass']='Παρακαλώ εισάγετε τον νέο σας κωδικό';
$hesklang['pass_len']='Ο κωδικός δεν πρέπει να υπερβαίνει τους 64 χαρακτήρες';
$hesklang['pass_login']='Παρακαλώ συνδεθείτε ξανά μετά την αλλαγή του κωδικού';
$hesklang['bf_int']='Έχετε αποσυνδεθεί λόγω πολλών αποτυχημένων προσπαθειών επαλήθευσης';
$hesklang['tst_cnt']='Αριθμός emails που θα στείλει ο mail server σας στο Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='Έχετε πολλά μη αναγνωσμένα emails στο γραμματοκιβώτιό σας (%1$s). Το Hesk θα μετατρέψει όλα αυτά τα emails σε tickets.<br><br>Ίσως θελήσετε να τα σημειώσετε ως αναγνωσμένα πριν ενεργοποιήσετε το %2$s ή να χρησιμοποιήσετε νέο λογαριασμό email για το Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Έχετε πολλά emails στο γραμματοκιβώτιό σας (%1$s). Το Hesk θα μετατρέψει όλα αυτά τα emails σε tickets.<br><br>Ίσως θελήσετε να διαγράψετε υπάρχοντα emails πριν ενεργοποιήσετε το %2$s ή να χρησιμοποιήσετε νέο λογαριασμό email για το Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Λήγει στις'; // Due on (date)
$hesklang['search_due_date_range']='Λήγει σε'; // Due in (X days)
$hesklang['attachment_add_files']='Προσθήκη αρχείου';
$hesklang['attachment_max_exceeded']='Αυτό το αρχείο δεν θα ανέβει γιατί έχετε ήδη ανεβάσει τον μέγιστο αριθμό αρχείων.';
$hesklang['attachment_viewer_message']='Σύρετε τα αρχεία εδώ ή κάντε κλικ στο κουμπί \'Προσθήκη αρχείου\' παρακάτω για να επιλέξετε αρχεία προς ανέβασμα.';
$hesklang['attachment_invalid_type_message']='Λυπούμαστε, αλλά ο τύπος αρχείου που προσπαθήσατε να ανεβάσετε δεν επιτρέπεται.';
$hesklang['attachment_upload_error']='Παρουσιάστηκε σφάλμα κατά το ανέβασμα. Παρακαλώ δοκιμάστε ξανά αργότερα.';
$hesklang['attachment_too_large']='Αυτό το συνημμένο είναι μεγαλύτερο από το μέγιστο επιτρεπόμενο μέγεθος.';
$hesklang['attachment_cancel']='Ακύρωση';
$hesklang['attachment_confirm_cancel']='Είστε σίγουροι ότι θέλετε να ακυρώσετε αυτό το ανέβασμα;';
$hesklang['attachment_remove']='Αφαίρεση συνημμένου';
$hesklang['attachment_too_many_uploads']='Έχουν ανέβει πάρα πολλά συνημμένα από την τοποθεσία σας σε σύντομο χρονικό διάστημα. Παρακαλώ δοκιμάστε ξανά αργότερα.';
$hesklang['sub_note']='Υποβολή σημείωσης';
$hesklang['can_view_users']='Προβολή όλων των χρηστών (όχι διαχείριση)';
$hesklang['welcome1']='Γεια σας, φαίνεται ότι είστε νέοι εδώ. Καλώς ήρθατε!';
$hesklang['welcome2']='Για να ξεκινήσετε, δείτε το %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Οδηγός Γρήγορης Εκκίνησης Hesk';
$hesklang['tmce1']='Χρησιμοποιήστε Ctrl+Δεξί κλικ για να έχετε πρόσβαση στον ορθογράφο';
$hesklang['tmce2']='Κρατήστε πατημένο το πλήκτρο Control (Ctrl) και κάντε δεξί κλικ στη λανθασμένη λέξη για να έχετε πρόσβαση στον ορθογράφο.';
$hesklang['desc_new_ticket_by_staff']='(Πελάτης) Νέο ticket από προσωπικό';
$hesklang['mod_et_h']='Μπορείτε να τροποποιήσετε τα πρότυπα email από %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Ορισμός γλώσσας σε';
$hesklang['ouwa']='Μόνο χρήστες με πρόσβαση σε αυτήν την κατηγορία εμφανίζονται παρακάτω. Για να προσθέσετε μέλη προσωπικού, επεξεργαστείτε τα δικαιώματά τους στη σελίδα %s'; // %s = Team
$hesklang['previous_tickets']='Προηγούμενα tickets';
$hesklang['no_previous']='Δεν υπάρχουν προηγούμενα tickets από %s'; // %s = email address
$hesklang['all_previous']='Λίστα όλων των προηγούμενων tickets';
$hesklang['confirm_delete_ticket']='Είστε βέβαιοι ότι θέλετε να διαγράψετε μόνιμα αυτό το ticket;';
$hesklang['confirm_delete_reply']='Είστε βέβαιοι ότι θέλετε να διαγράψετε μόνιμα αυτήν την απάντηση;';
$hesklang['select_new_category']='Αριθμός tickets σε αυτήν την κατηγορία: %s<br><br>Παρακαλώ επιλέξτε νέα κατηγορία για μεταφορά αυτών των tickets:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Αριθμός tickets που έχουν ανατεθεί σε αυτόν τον χρήστη: %1$s<br>Αριθμός <b>ανοιχτών</b> tickets που έχουν ανατεθεί: %2$s<br><br>Τα <b>ανοιχτά</b> tickets θα μείνουν <b>μη ανατεθειμένα</b> μετά τη διαγραφή αυτού του χρήστη.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Άδεια HESK';
$hesklang['hlic_free']='ΔΩΡΕΑΝ';
$hesklang['hlic_buyl']='Αγορά Άδειας';
$hesklang['hlic_paid']='Με άδεια χρήσης';
$hesklang['antdemo']='Submitting tickets from the admin panel has been disabled in the demo mode.<br><br>Please use the <a href="%s" target="_blank">public side</a> to submit a test ticket.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Μέθοδος ελέγχου ταυτότητας';
$hesklang['email_authentication_method_username_password']='Βασική (Όνομα χρήστη / Κωδικός πρόσβασης)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Δεν έχουν ρυθμιστεί επαληθευμένοι πάροχοι OAuth.';
$hesklang['email_authentication_method_oauth_link']='Διαχείριση παρόχων OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL τελικού σημείου εξουσιοδότησης';
$hesklang['email_oauth_token_url']='URL τελικού σημείου token';
$hesklang['email_oauth_client_id']='Client ID';
$hesklang['email_oauth_client_secret']='Client Secret';
$hesklang['email_oauth_scope']='Scope (πεδίο εφαρμογής)';
$hesklang['oauth_error_invalid_state']='Το OAuth state δεν ταιριάζει με το state που στάλθηκε στον πάροχο OAuth.';
$hesklang['oauth_error_unknown']='Παρουσιάστηκε άγνωστο σφάλμα κατά την προσπάθεια αποθήκευσης των OAuth tokens.';
$hesklang['oauth_error_no_token']='Λείπει το access token από την απάντηση JSON.';
$hesklang['oauth_error_retrieve']='Δεν ήταν δυνατή η λήψη access token. Επιβεβαιώστε τις ρυθμίσεις του παρόχου OAuth και αποθηκεύστε τις ξανά για να αποκτήσετε νέο token.';
$hesklang['email_oauth_provider']='Πάροχος OAuth';
$hesklang['email_oauth_providers']='Πάροχοι OAuth';
$hesklang['email_oauth_provider_guide']='Πριν χρησιμοποιήσετε το OAuth, πρέπει να καταχωρίσετε έναν πάροχο OAuth. Για λεπτομέρειες, δείτε <a href="%s" target="_blank">αυτόν τον οδηγό knowledgebase</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Το OAuth Redirect URI σας για το Hesk είναι:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Χρησιμοποιήστε αυτό το εργαλείο για να προσθέσετε παρόχους OAuth στο help desk σας';
$hesklang['email_oauth_provider_name']='Όνομα'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Νέος πάροχος';
$hesklang['email_oauth_edit_provider']='Επεξεργασία παρόχου';
$hesklang['email_oauth_provider_being_used_for']='Χρησιμοποιείται για';
$hesklang['email_oauth_providers_none']='Δεν έχουν αποθηκευτεί πάροχοι OAuth. Μπορείτε να τους προσθέσετε κάνοντας κλικ στο «Νέος πάροχος» παραπάνω.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Αυτός ο πάροχος δεν μπορεί να αφαιρεθεί επειδή χρησιμοποιείται από το help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτόν τον πάροχο OAuth;';
$hesklang['oauth_provider_saved']='Ο πάροχος OAuth αποθηκεύτηκε';
$hesklang['oauth_provider_use']='Μπορείτε τώρα να επιλέξετε αυτόν τον πάροχο στο %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Εισάγετε το όνομα παρόχου';
$hesklang['oauth_provider_err_auth_url']='Εισάγετε έγκυρο URL εξουσιοδότησης';
$hesklang['oauth_provider_err_token_url']='Εισάγετε έγκυρο URL token';
$hesklang['oauth_provider_err_client_id']='Εισάγετε το client ID';
$hesklang['oauth_provider_err_client_secret']='Εισάγετε το client secret';
$hesklang['oauth_provider_err_scope']='Εισάγετε το scope (πεδίο εφαρμογής)';
$hesklang['oauth_provider_deleted']='Ο πάροχος OAuth διαγράφηκε';
$hesklang['oauth_provider_not_found']='Αυτός ο πάροχος OAuth δεν υπάρχει';
$hesklang['oauth_provider_verified']='Επαληθευμένο';
$hesklang['oauth_provider_click_to_verify']='Κάντε κλικ για επαλήθευση';
$hesklang['can_due_date']='Μπορεί να ορίσει ημερομηνία λήξης'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Δεν έχετε δικαίωμα να ορίζετε ημερομηνίες λήξης';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Επαληθεύστε την εγγραφή σας';
$hesklang['customer_verify_new_email']='Επαληθεύστε τη νέα σας διεύθυνση email';
$hesklang['customer_reset_password']='Επαναφέρετε τον κωδικό πρόσβασης του help desk σας';
$hesklang['customer_approved']='Ο λογαριασμός εγκρίθηκε';
$hesklang['customer_rejected']='Ο λογαριασμός απορρίφθηκε';
$hesklang['email_rejected']='Απαιτείται λογαριασμός για υποβολή support tickets';
$hesklang['require_curl']='Αυτή η λειτουργία απαιτεί ενεργοποιημένη υποστήριξη <strong>cURL</strong> για PHP στον server σας. Ζητήστε από τον πάροχό σας να ενεργοποιήσει το cURL για PHP.';
$hesklang['customer_accounts_heading']='Λογαριασμοί πελατών';
$hesklang['customer_accounts']='Λογαριασμοί πελατών';
$hesklang['customer_accounts_off']='<strong>Απενεργοποιημένο</strong>';
$hesklang['customer_accounts_allowed']='<strong>Ενεργό - Προαιρετικό</strong> (οι πελάτες μπορούν να υποβάλουν support tickets χωρίς εγγραφή ή σύνδεση)';
$hesklang['customer_accounts_required_to_submit']='<strong>Ενεργό - Απαιτείται για tickets</strong> (μόνο συνδεδεμένοι πελάτες μπορούν να υποβάλουν support tickets)';
$hesklang['customer_accounts_required']='<strong>Ενεργό - Απαιτείται για πρόσβαση</strong> (μόνο συνδεδεμένοι πελάτες έχουν πρόσβαση στο help desk και στο knowledgebase)';
$hesklang['customer_accounts_reg']='Εγγραφή λογαριασμού';
$hesklang['customer_accounts_reg_customer']='Οι πελάτες μπορούν να εγγράφουν λογαριασμούς';
$hesklang['customer_accounts_reg_approve']='Οι πελάτες μπορούν να εγγράφουν λογαριασμό, το προσωπικό πρέπει να εγκρίνει νέες εγγραφές';
$hesklang['customer_accounts_reg_staff']='Μόνο το προσωπικό μπορεί να εγγράφει λογαριασμούς πελατών';
$hesklang['customer_accounts_allow_email_changes']='Να επιτρέπεται στους πελάτες να αλλάζουν τη διεύθυνση email';
$hesklang['customer_accounts_allow_email_resends']='Χρόνος μέχρι να μπορούν οι πελάτες να ζητήσουν νέο email επαλήθευσης';
$hesklang['customer_login']='Σύνδεση';
$hesklang['customer_logout']='Αποσύνδεση';
$hesklang['customer_register']='Εγγραφή';
$hesklang['customer_accounts_disabled']='Οι συνδέσεις και εγγραφές πελατών είναι απενεργοποιημένες.';
$hesklang['customer_accounts_registration_disabled']='Οι εγγραφές πελατών είναι απενεργοποιημένες.';
$hesklang['customer_forgot_password']='Ξεχάσατε τον κωδικό;';
$hesklang['customer_email']='Διεύθυνση email';
$hesklang['customer_accounts_email_banned']='Έχετε αποκλειστεί από τη χρήση αυτού του helpdesk.';
$hesklang['customer_registration_successful']='Εγγραφή επιτυχής!';
$hesklang['customer_registration_email_exists_no_reset_link']='Υπάρχει ήδη λογαριασμός με email %s.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Υπάρχει ήδη λογαριασμός με email %s. <a href="login.php">Θέλετε να συνδεθείτε αντί για αυτό</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Υπάρχει ήδη λογαριασμός με email %s και εκκρεμεί επαλήθευση email.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Υπάρχει ήδη λογαριασμός με email %s και εκκρεμεί έγκριση από το προσωπικό.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Ελέγξτε το email σας!';
$hesklang['customer_registration_check_your_email_content']='Πρέπει να επαληθεύσετε τη διεύθυνση email σας πριν μπορέσετε να συνδεθείτε.<br><br>Αν δεν το λάβετε μέσα σε λίγα λεπτά, ελέγξτε τους φακέλους Ανεπιθύμητα/Junk/Spam. Σημειώστε το μήνυμα ως <b>Not SPAM</b> για να αποφύγετε προβλήματα παραλαβής αλληλογραφίας στο μέλλον.';
$hesklang['customer_login_not_verified']='Πρέπει να επαληθεύσετε τη διεύθυνση email σας πριν μπορέσετε να συνδεθείτε.';
$hesklang['customer_login_not_verified2']='Αν δεν λάβατε email επαλήθευσης, ελέγξτε τους φακέλους Ανεπιθύμητα/Junk/Spam. Σημειώστε το μήνυμα ως <b>Not SPAM</b> για να αποφύγετε προβλήματα στο μέλλον.';
$hesklang['customer_login_resend_verification_email']='Επαναποστολή email επαλήθευσης';
$hesklang['customer_login_resend_verification_email_none']='Δεν υπάρχουν εκκρεμή emails επαλήθευσης προς αποστολή.';
$hesklang['customer_login_resend_verification_email_too_early']='Δεν μπορείτε να ζητήσετε νέο email επαλήθευσης αυτή τη στιγμή, δοκιμάστε αργότερα.';
$hesklang['customer_login_not_approved']='Ένα μέλος του προσωπικού πρέπει να εγκρίνει τον λογαριασμό σας πριν μπορέσετε να συνδεθείτε. Μόλις εγκριθεί, θα ειδοποιηθείτε μέσω email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Επαλήθευση εγγραφής';
$hesklang['customer_registration_verify_success']='Το email σας επαληθεύτηκε και τώρα μπορείτε να συνδεθείτε χρησιμοποιώντας την παρακάτω φόρμα.';
$hesklang['customer_registration_verify_approval_needed']='Το email σας επαληθεύτηκε. Ωστόσο, απαιτείται έγκριση από μέλος του προσωπικού πριν μπορέσετε να συνδεθείτε. Μόλις εγκριθεί, θα ειδοποιηθείτε μέσω email.';
$hesklang['customer_registration_verify_failure']='Δεν ήταν δυνατή η επαλήθευση του email σας. Είτε ο σύνδεσμος έχει ήδη χρησιμοποιηθεί είτε έχει λήξει.';
$hesklang['emails_to_customers']='&raquo; Emails που στάλθηκαν σε πελάτες';
$hesklang['emails_to_staff']='&raquo; Emails που στάλθηκαν στο προσωπικό';
$hesklang['emails_to_everyone']='&raquo; Emails που στάλθηκαν σε προσωπικό ή πελάτες';
$hesklang['new_customer_approval']='Έχετε λογαριασμούς πελατών προς έγκριση'; // Email subject
$hesklang['desc_new_customer_approval']='(Προσωπικό) Λογαριασμοί πελατών προς έγκριση';
$hesklang['n_cust_app']='Υπάρχουν εκκρεμείς εγκρίσεις πελατών'; // Notify me when...
$hesklang['et_num_customers']='Αριθμός εκκρεμών εγκρίσεων';
$hesklang['et_link_customers']='Σύνδεσμος στη σελίδα Διαχείρισης πελατών';
$hesklang['et_link_verify']='Σύνδεσμος επαλήθευσης';
$hesklang['et_cust_login']='URL σύνδεσης πελάτη';
$hesklang['submit_ticket_customer_email_exists']='Υπάρχει ήδη πελάτης με αυτό το email. Παρακαλώ <a href="login.php?email=%s">συνδεθείτε</a> για να υποβάλετε ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Παρακαλώ εισάγετε έγκυρη διεύθυνση email.';
$hesklang['customer_login_password_required']='Παρακαλώ εισάγετε τον κωδικό πρόσβασής σας.';
$hesklang['customer_login_remember_just_email']='Να θυμάσαι μόνο το email μου';
$hesklang['customer_login_remember_email']='Να θυμάσαι το email μου';
$hesklang['customer_wrong_user']='Η διεύθυνση email %s δεν είναι καταχωρισμένη σε εμάς.<br><br>Θέλετε να <a href="register.php">δημιουργήσετε λογαριασμό</a>;'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Η διεύθυνση email και ο κωδικός δεν ταιριάζουν με τα στοιχεία μας.<br><br>Θέλετε να <a href="login.php?submittedForgot=1">επαναφέρετε τον κωδικό</a>;';
$hesklang['customer_must_be_logged_in_to_view']='Παρακαλώ συνδεθείτε για να συνεχίσετε.';
$hesklang['customer_register_here']='Αν δεν έχετε λογαριασμό, μπορείτε να <a href="register.php">εγγραφείτε εδώ</a>.';
$hesklang['create_account']='Δημιουργία λογαριασμού';
$hesklang['customer_my_tickets_heading']='My tickets';
$hesklang['customer_my_tickets_description']='Προβολή όλων των προηγούμενων tickets σας';
$hesklang['customer_my_tickets_search_for_tickets']='Αναζήτηση tickets';
$hesklang['customer_password_reset_successful']='Ο νέος κωδικός σας αποθηκεύτηκε. Μπορείτε τώρα να συνδεθείτε.';
$hesklang['customer_profile']='Προφίλ';
$hesklang['customer_edit_profile']='Επεξεργασία προφίλ';
$hesklang['customer_edit_pass']='Επεξεργασία κωδικού';
$hesklang['customer_edit_pass_same']='Ο νέος κωδικός δεν πρέπει να είναι ίδιος με τον τρέχοντα.';
$hesklang['customer_change_email']='Αλλαγή email';
$hesklang['customer_change_email_banned']='Το email που εισάγατε είναι αποκλεισμένο.';
$hesklang['customer_change_email_pending']='Υπάρχει αίτημα αλλαγής της διεύθυνσης email σας σε: <b>%s</b><br><br>Στείλαμε email σε αυτή τη διεύθυνση. Κάντε κλικ στον σύνδεσμο μέσα στο email για να επιβεβαιώσετε την αλλαγή.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Επαναποστολή email επιβεβαίωσης</a>';
$hesklang['customer_change_email_submitted']='Κάντε κλικ στον σύνδεσμο επαλήθευσης που στάλθηκε στο <b>%s</b> για να επαληθεύσετε το νέο σας email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Η νέα σας διεύθυνση email επαληθεύτηκε και το προφίλ σας ενημερώθηκε.';
$hesklang['customer_change_email_disabled']='Η δυνατότητα αλλαγής email είναι απενεργοποιημένη. Επικοινωνήστε μαζί μας αν θέλετε να αλλάξετε email.';
$hesklang['customer_profile_saved']='Το προφίλ σας αποθηκεύτηκε.';
$hesklang['customers']='Πελάτες';
$hesklang['customers_intro']='Οι λογαριασμοί πελατών επιτρέπουν στους πελάτες να βλέπουν όλα τα tickets τους σε ένα κεντρικό σημείο.';
$hesklang['sure_remove_customer']='Είστε βέβαιοι ότι θέλετε να αφαιρέσετε αυτόν τον πελάτη;';
$hesklang['sure_remove_customer_additional_note']='Η διαγραφή πελάτη είναι οριστική. Μετά τη διαγραφή, δεν μπορεί να ανακτηθεί!';
$hesklang['new_customer']='Νέος πελάτης';
$hesklang['new_follower']='Νέος ακόλουθος';
$hesklang['add_customer']='+ Προσθήκη πελάτη'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Προσθήκη ακόλουθου'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='Ο πελάτης που δώσατε δεν υπάρχει ακόμη. Κάντε «Αποθήκευση» αν θέλετε να δημιουργήσετε αυτόν τον πελάτη.';
$hesklang['followers']='Ακόλουθοι';
$hesklang['no_customers']='Δεν υπάρχουν αυτή τη στιγμή πελάτες στη βάση δεδομένων.';
$hesklang['no_customers_disabled']='Θα αρχίσετε να βλέπετε πελάτες εδώ όταν υποβάλλουν support tickets.';
$hesklang['no_customers_enabled']='Θα αρχίσετε να βλέπετε πελάτες εδώ όταν εγγράφονται ή υποβάλλουν support tickets.';
$hesklang['no_customers_enabled2']='Εναλλακτικά, τα κουμπιά πάνω από αυτό το μήνυμα σάς επιτρέπουν να δημιουργήσετε χειροκίνητα λογαριασμούς ή να εισαγάγετε υπάρχοντες πελάτες στο help desk.';
$hesklang['import_customers']='Εισαγωγή πελατών';
$hesklang['import_customers_tip']='Χρησιμοποιήστε ένα αρχείο CSV για να εισαγάγετε πολλούς πελάτες ταυτόχρονα.';
$hesklang['customer_not_found']='Δεν βρέθηκε πελάτης για το ticket!';
$hesklang['search_by_name_or_email']='Αναζήτηση με όνομα ή email...';
$hesklang['search_by_pattern']='Αναζήτηση με μοτίβο...';
$hesklang['is_searchable']='Αναζητήσιμο';
$hesklang['custom_is_searchable']='Αναζητήσιμο';
$hesklang['yes_via_autocomplete']='ΝΑΙ (αναζήτηση μέσω autocomplete)';
$hesklang['customer_required']='Πρέπει να επιλέξετε πελάτη';
$hesklang['customer_email_exists']='Υπάρχει ήδη πελάτης με αυτό το email.';
$hesklang['customer_name_with_no_email_exists']='Υπάρχει ήδη πελάτης με αυτό το όνομα και χωρίς email.';
$hesklang['an_error_occurred_validating_email']='Προέκυψε σφάλμα κατά την προσπάθεια επαλήθευσης της καταχωρημένης διεύθυνσης email.';
$hesklang['customer_count_x_more']='+%s ακόμη'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Καταχωρισμένος';
$hesklang['customer_account_verified']='Επαληθευμένος';
$hesklang['customer_account_verified_help']='Οι πελάτες πρέπει να επαληθεύσουν τον λογαριασμό τους μέσω συνδέσμου ενεργοποίησης που αποστέλλεται στο email τους πριν συνδεθούν.';
$hesklang['customer_account_setting_password_will_verify_user']='Ο ορισμός κωδικού για αυτόν τον πελάτη θα επαληθεύσει αυτόματα τον λογαριασμό του.';
$hesklang['deleting_customer_with_tickets']='Αυτός ο πελάτης έχει %1$s ticket(s) <b>(%2$s ανοιχτά)</b> που έχουν επίσης συσχετιστεί με άλλους πελάτες.<br>Τι πρέπει να γίνει με αυτά τα tickets;'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Απαιτείται έγκυρη διεύθυνση email για επαναποστολή email επαλήθευσης.';
$hesklang['customer_resend_verification_email_not_found']='Δεν υπάρχει λογαριασμός με αυτή τη διεύθυνση email ή ο λογαριασμός έχει ήδη επαληθευτεί.';
$hesklang['customer_resend_verification_email_sent']='Στάλθηκε email επαλήθευσης στη διεύθυνση email σας.<br><br>Αν δεν το λάβετε μέσα σε λίγα λεπτά, ελέγξτε τους φακέλους Ανεπιθύμητα/Junk/Spam. Σημειώστε το μήνυμα ως <b>Not SPAM</b> για να αποφύγετε προβλήματα στο μέλλον.';
$hesklang['customer_permission_denied']='Δεν έχετε δικαίωμα να τροποποιήσετε πελάτες.';
$hesklang['customer_manage_approvals']='Λογαριασμοί πελατών προς έγκριση: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Έγκριση πελάτη';
$hesklang['customer_manage_bulk_approve']='Έγκριση επιλεγμένων πελατών';
$hesklang['customer_manage_bulk_approve_complete']='Πελάτες που εγκρίθηκαν: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Απόρριψη πελάτη';
$hesklang['customer_manage_bulk_reject']='Απόρριψη επιλεγμένων πελατών';
$hesklang['customer_manage_bulk_reject_complete']='Πελάτες που απορρίφθηκαν: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Διαγραφή πελάτη';
$hesklang['customer_manage_bulk_delete']='Διαγραφή επιλεγμένων πελατών';
$hesklang['customer_manage_bulk_delete_complete']='Πελάτες που διαγράφηκαν: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Επεξεργασία πελάτη';
$hesklang['customer_manage_verification_email_sent']='Στάλθηκε email επαλήθευσης στο %s'; // %s = customer's email
$hesklang['can_man_customers']='Διαχείριση πελατών';
$hesklang['can_view_customers']='Προβολή όλων των πελατών (όχι διαχείριση)';
$hesklang['import_customer_select_file']='Επιλογή αρχείου';
$hesklang['import_customer_step1_instructions']='Για να εισαγάγετε πελάτες, προετοιμάστε ένα αρχείο CSV (Comma-Separated Values).';
$hesklang['import_customer_step1_note']='Επιλέξτε το αρχείο CSV σας';
$hesklang['import_customer_step1_separator']='Οι στήλες στο CSV αρχείο μου χωρίζονται με';
$hesklang['import_customer_sample']='&raquo; Δείγματα αρχείων CSV';
$hesklang['import_customer_sample_1']='CSV αρχείο αμερικανικού τύπου με στήλες χωρισμένες με ,';
$hesklang['import_customer_sample_2']='CSV αρχείο ευρωπαϊκού τύπου με στήλες χωρισμένες με ;';
$hesklang['import_customer_upload_requirements_1']='Το αρχείο CSV σας πρέπει να περιλαμβάνει τουλάχιστον στήλη ονόματος ή email. Η στήλη κωδικού είναι προαιρετική.';
$hesklang['import_customer_upload_requirements_2']='Η πρώτη γραμμή του αρχείου πρέπει να περιέχει επικεφαλίδες στηλών.';
$hesklang['import_customer_upload_requirements_3']='Το αρχείο σας πρέπει να είναι σε κωδικοποίηση UTF-8.';
$hesklang['import_customer_select_columns']='Επιλογή στηλών';
$hesklang['import_customer_upload_customers']='Μεταφόρτωση πελατών';
$hesklang['import_customer_column_name']='Στήλη ονόματος';
$hesklang['import_customer_column_email']='Στήλη email';
$hesklang['import_customer_column_pass']='Στήλη κωδικού';
$hesklang['import_customer_step2_note']='Επιλέξτε το σωστό όνομα στήλης από το αρχείο CSV στα dropdowns και μετά κάντε «Επόμενο».';
$hesklang['import_customer_name_or_email_required']='Απαιτείται όνομα ή email';
$hesklang['import_customer_step3_note']='Οι πελάτες σας εισάγονται. Μην αφήσετε αυτή τη σελίδα!';
$hesklang['import_customer_step3_pending']='Εκκρεμεί';
$hesklang['import_customer_step3_successful_imports']='Επιτυχημένες εισαγωγές';
$hesklang['import_customer_step3_failed_imports']='Αποτυχημένες εισαγωγές';
$hesklang['import_customer_step3_progress']='Πρόοδος';
$hesklang['import_customer_step3_complete_some_failed']='Η διαδικασία εισαγωγής ολοκληρώθηκε, ωστόσο <b>%s</b> πελάτες απέτυχαν να εισαχθούν. Ελέγξτε τον παρακάτω πίνακα για περισσότερες πληροφορίες.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='Η διαδικασία εισαγωγής ολοκληρώθηκε!';
$hesklang['import_customer_step3_importing']='Γίνεται εισαγωγή';
$hesklang['staff_deleted']='[Διαγράφηκε μέλος προσωπικού]';
$hesklang['customer_account_approved']='Εγκρίθηκε η εγγραφή πελάτη';
$hesklang['customer_account_rejected']='Απορρίφθηκε η εγγραφή πελάτη';
$hesklang['customer_account_deleted']='Διαγράφηκε η εγγραφή πελάτη';
$hesklang['ticket_followers']='Ακόλουθοι ticket';
$hesklang['ticket_followers2']='Να επιτρέπεται τα tickets να έχουν πολλούς πελάτες';
$hesklang['add_cc']='Προσθήκη Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Χωρίστε κάθε email με κόμμα.';
$hesklang['search_customers']='Αναζήτηση πελατών';
$hesklang['page_size']='Μέγεθος σελίδας';
$hesklang['customers_on_pages']='Αριθμός πελατών: %d | Αριθμός σελίδων: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Πελάτης) Επαναφορά κωδικού';
$hesklang['desc_customer_verify_registration']='(Πελάτης) Επαλήθευση εγγραφής';
$hesklang['desc_customer_verify_new_email']='(Πελάτης) Επαλήθευση νέου email';
$hesklang['desc_customer_approved']='(Πελάτης) Ο λογαριασμός εγκρίθηκε';
$hesklang['desc_customer_rejected']='(Πελάτης) Ο λογαριασμός απορρίφθηκε';
$hesklang['desc_email_rejected_can_self_register']='(Πελάτης) Ticket μέσω email απορρίφθηκε· ο πελάτης μπορεί να εγγραφεί μόνος του';
$hesklang['desc_email_rejected_cannot_self_register']='(Πελάτης) Ticket μέσω email απορρίφθηκε· ο πελάτης δεν μπορεί να εγγραφεί μόνος του';
$hesklang['user_added_success_no_pass']='Ο νέος χρήστης %s προστέθηκε με επιτυχία';
$hesklang['email_tag_requester']='Αιτών (From)';
$hesklang['email_tag_requester_name']='Όνομα αιτούντος (From)';
$hesklang['email_tag_requester_first_name']='Μικρό όνομα αιτούντος (From)';
$hesklang['email_tag_requester_email']='Email αιτούντος (From)';
$hesklang['email_tag_followers']='Ακόλουθοι (Cc)';
$hesklang['email_tag_follower_names']='Ονόματα ακολούθων (Cc)';
$hesklang['email_tag_follower_emails']='Emails ακολούθων (Cc)';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Εμφάνιση barcode στα εκτυπωμένα tickets';
$hesklang['barcode_staff_only']='Απόκρυψη του barcode από τους πελάτες';
$hesklang['barcode_type']='Τύπος barcode';
$hesklang['barcode_format']='Μορφή';
$hesklang['barcode_width']='Πλάτος';
$hesklang['barcode_height']='Ύψος';
$hesklang['barcode_color']='Χρώμα';
$hesklang['barcode_bg']='Φόντο';
$hesklang['copy_link']='Αντιγραφή συνδέσμου ticket';
$hesklang['copy_link_title']='Αντιγραφή δημόσιου συνδέσμου για αυτό το ticket';
$hesklang['copy_link_exp']='Ο αντιγραμμένος σύνδεσμος είναι ο απευθείας σύνδεσμος για τον πελάτη ώστε να δει αυτό το ticket';
$hesklang['copy_value']='Αντιγραφή αυτής της τιμής';
$hesklang['download_class']='Αυτή η λειτουργία απαιτεί την κλάση ZipArchive. Ζητήστε από τον πάροχό σας να κάνει compile την PHP με υποστήριξη zip.';
$hesklang['download_all']='Λήψη όλων';
$hesklang['download_prep']='Προετοιμασία λήψης...';
$hesklang['download_tma']='Πάρα πολλά συνημμένα';
$hesklang['download_nva']='Μη έγκυρα συνημμένα';
$hesklang['download_ntd']='Δεν υπάρχει τίποτα για λήψη';
$hesklang['resolved_at']='Επιλύθηκε στις';
$hesklang['disable_GSSAPI']='Απενεργοποίηση ελεγκτή GSSAPI (λύση για σφάλμα Kerberos)';
$hesklang['ex_history']='Συμπερίληψη ιστορικού ticket στην εξαγωγή';
$hesklang['sm_location']='Θέση'; // Location (page) of a service message
$hesklang['loc_sm']='Εμφάνιση αυτού του μηνύματος υπηρεσίας σε:';
$hesklang['loc_all']='Κάθε σελίδα πελάτη';
$hesklang['loc_norec']='(δεν συνιστάται)';
$hesklang['loc_home']='Αρχική σελίδα help desk';
$hesklang['loc_selected']='Σε επιλεγμένες σελίδες';
$hesklang['loc_selerr']='Επιλέξτε τουλάχιστον μία σελίδα για εμφάνιση του μηνύματος';
$hesklang['loc_t_cat']='Submit a ticket - επιλογή κατηγορίας';
$hesklang['loc_t_add']='Submit a ticket - φόρμα υποβολής ticket';
$hesklang['loc_t_ok']='Submit a ticket - επιβεβαίωση ticket';
$hesklang['loc_t_view']='Προβολή ticket';
$hesklang['loc_t_form']='Προβολή φόρμας ticket';
$hesklang['loc_kb_main']='Αρχική σελίδα knowledgebase';
$hesklang['loc_kb_sub']='Σελίδες υποκατηγοριών knowledgebase';
$hesklang['loc_kb_art']='Άρθρα knowledgebase';
$hesklang['loc_login']='Σελίδα σύνδεσης πελάτη';
$hesklang['loc_register']='Σελίδα εγγραφής πελάτη';
$hesklang['loc_register_ok']='Επιτυχής εγγραφή πελάτη';
$hesklang['loc_acc']='Σελίδα πελάτη &quot;My tickets&quot;';
$hesklang['loc_profile']='Σελίδα πελάτη &quot;Profile&quot;';
$hesklang['sending_show']='Εμφάνιση ειδοποίησης &quot;Υποβολή&quot;';
$hesklang['sending_wait']='Γίνεται υποβολή, παρακαλώ περιμένετε...';
$hesklang['e_c_email']='Εισάγετε το σωστό email για να δείτε αυτό το ticket';
$hesklang['only_verified_cc']='Ακόλουθοι χωρίς επαληθευμένο λογαριασμό θα αγνοηθούν.';
$hesklang['followers_removed']='Αυτές οι διευθύνσεις email αφαιρέθηκαν από το ticket επειδή δεν έχουν επαληθευμένο λογαριασμό:';
$hesklang['novace']='Δεν βρέθηκαν καταχωρισμένοι και επαληθευμένοι λογαριασμοί με αυτή τη διεύθυνση email.';
$hesklang['max_recipients']='Μέγιστος αριθμός παραληπτών';
$hesklang['max_recipients2']='σε ένα μόνο email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Φόρτωση επιπλέον προσαρμοσμένου αρχείου Javascript για τον πίνακα διαχείρισης';
$hesklang['cf_limit_all']='Φτάσατε το όριο προσαρμοσμένων πεδίων και δεν μπορείτε να δημιουργήσετε νέα.';
$hesklang['remind_assigned']='Υπενθύμιση στο ανατεθειμένο μέλος προσωπικού';
$hesklang['remind_sent']='Στάλθηκε email υπενθύμισης στο ανατεθειμένο μέλος';
$hesklang['thist23']='<li class="smaller">%s | στάλθηκε υπενθύμιση στο %s από %s</li>';
$hesklang['ql_bookmarks']='Σελιδοδείκτες';
$hesklang['bookmark']='Ο σελιδοδείκτης μου';
$hesklang['bookmarks_add']='Προσθήκη στους σελιδοδείκτες';
$hesklang['bookmarks_added']='Αυτό το ticket προστέθηκε στους σελιδοδείκτες σας';
$hesklang['bookmarks_remove']='Αφαίρεση από τους σελιδοδείκτες';
$hesklang['bookmarks_removed']='Αυτό το ticket αφαιρέθηκε από τους σελιδοδείκτες σας';
$hesklang['genl_not_copied']='Σφάλμα: Η αντιγραφή στο πρόχειρο δεν υποστηρίζεται σε αυτή τη συσκευή/φυλλομετρητή.';
$hesklang['profile_duplicate_email']='Υπάρχει ήδη χρήστης με email <b>%s</b>.'; // %s: new email
$hesklang['seq_id_numeric']='Η αναζήτηση αριθμού ticket πρέπει να περιέχει μόνο αριθμούς';
$hesklang['confirm_new_pass']='Επιβεβαίωση νέου κωδικού';
$hesklang['piping_notify_rejected_customers1']='Emails απόρριψης πελατών';
$hesklang['piping_notify_rejected_customers2']='Αποστολή email απόρριψης στους πελάτες όταν το ticket τους απορρίπτεται';
$hesklang['piping_notify_rejected_customers3']='Χρόνος μεταξύ emails απόρριψης';
$hesklang['register_url']='URL εγγραφής';
$hesklang['email_subject']='Θέμα email';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Συνεργασία στο ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Το προσωπικό απάντησε στο: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Προστέθηκε σημείωση στο: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Εκπρόθεσμο ticket: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Το ticket επιλύθηκε: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Ημερομηνία διακοπής emails παρακολούθησης:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Να μην αποστέλλονται emails σε tickets που επιλύθηκαν πριν από'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ημέρες (πρέπει να είναι μεγαλύτερο διάστημα από "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='Η περίοδος διακοπής emails πρέπει να είναι μεγαλύτερη από την καθυστέρηση του email παρακολούθησης';
$hesklang['available_language']='Διαθέσιμες γλώσσες';
$hesklang['click_to_show_available_language']='Κάντε κλικ για εμφάνιση διαθέσιμων γλωσσών';
$hesklang['install_lan']='Εγκατάσταση';
$hesklang['remove_lan']='Αφαίρεση';
$hesklang['title_lan']='Τίτλος';
$hesklang['description_lan']='Περιγραφή';
$hesklang['completed_lan']='Ολοκληρωμένο';
$hesklang['no_language_availble']='Δεν υπάρχουν διαθέσιμες γλώσσες';
$hesklang['success_install_lan_txt']='η γλώσσα προστέθηκε με επιτυχία';
$hesklang['error_install_lan_txt']='η γλώσσα δεν προστέθηκε';
$hesklang['success_remove_lan_txt']='η γλώσσα αφαιρέθηκε με επιτυχία';
$hesklang['error_remove_lan_txt']='η γλώσσα δεν αφαιρέθηκε';
$hesklang['remove_default_language_error']='Η προεπιλεγμένη γλώσσα πρέπει να παραμένει ενεργή και δεν μπορεί να αφαιρεθεί';
$hesklang['click_for_manual_step']='Κάντε κλικ για χειροκίνητη εγκατάσταση';
$hesklang['upgrade_lan']='Ενημέρωση';
$hesklang['success_upgrade_lan_txt']='η γλώσσα ενημερώθηκε με επιτυχία';
$hesklang['error_upgrade_lan_txt']='η γλώσσα δεν ενημερώθηκε';
$hesklang['please_wait']='Παρακαλώ περιμένετε...';
$hesklang['add_a_note']='Προσθήκη σημείωσης';
$hesklang['add_a_reply']='Προσθήκη απάντησης';
$hesklang['customer_id']='Customer ID';
$hesklang['deleting_customer_tickets']='Tickets που άνοιξε ο πελάτης: <b>%1$s</b><br>Τι να κάνουμε με αυτά τα tickets;'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets όπου ο πελάτης είναι σε αντιγραφή: <b>%1$s</b><br>Αυτά θα χάσουν τον πελάτη ως ακόλουθο· τα tickets παραμένουν αμετάβλητα.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Οριστική διαγραφή tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Ανώνυμα tickets (αφαίρεση μηνυμάτων και προσωπικών δεδομένων)';
$hesklang['deleting_customer_retain_tickets2']='Διατήρηση tickets (όλα τα δεδομένα ανέπαφα)';
$hesklang['for_staff']='για προσωπικό help desk'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='για πελάτες'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Ρυθμίσεις συνημμένων email';
$hesklang['link_to_attachments_in_emails']='Σύνδεσμος προς συνημμένα στα emails';
$hesklang['add_attachments_directly_to_emails']='Άμεση προσθήκη συνημμένων στα emails';
$hesklang['directly_attach_file_smaller_than']='Άμεση προσθήκη μόνο αρχείων μικρότερων από';
$hesklang['directly_attach_file_of_any_size']='Άμεση προσθήκη αρχείων οποιουδήποτε μεγέθους';
$hesklang['directly_attach_only_first_x_attachments']='Άμεση προσθήκη μόνο των πρώτων';
$hesklang['directly_attach_all_attachments']='Άμεση προσθήκη όλων των συνημμένων';
$hesklang['directly_attach_size']='Μέγεθος συνημμένου';
$hesklang['directly_attach_no_of_files']='Αριθμός αρχείων';
$hesklang['notice_about_directly_attach_files']='Η προσθήκη πολλών ή μεγάλων αρχείων στα emails μπορεί να προκαλέσει καθυστερήσεις στην επικοινωνία με τον SMTP server σας';
$hesklang['fatt_2']='Επιπλέον αρχεία που επισυνάπτονται σε αυτό το μήνυμα:';
$hesklang['no_collaborators']='Κανένας';
$hesklang['collaborate']='Συνεργασία σε αυτό το ticket';
$hesklang['collaborators']='Συνεργάτες';
$hesklang['ql_cbm']='Συνεργάτης';
$hesklang['collaborating']='Τώρα συνεργάζεστε σε αυτό το ticket';
$hesklang['not_collaborating']='Δεν συνεργάζεστε πλέον σε αυτό το ticket';
$hesklang['add_collaborator']='Προσθήκη συνεργάτη';
$hesklang['user_collaborator_added']='Ο χρήστης προστέθηκε ως συνεργάτης σε αυτό το ticket';
$hesklang['remove_collaborator']='Αφαίρεση συνεργάτη';
$hesklang['staff_name']='Όνομα μέλους προσωπικού';
$hesklang['user_collaborator_removed']='Ο χρήστης αφαιρέθηκε ως συνεργάτης από αυτό το ticket';
$hesklang['desc_collaborator_added']='(Προσωπικό) Συνεργάζεστε σε νέο ticket';
$hesklang['desc_collaborator_staff_reply']='(Προσωπικό) Μέλος προσωπικού απάντησε σε συνεργατικό ticket';
$hesklang['desc_collaborator_note']='(Προσωπικό) Προστέθηκε νέα σημείωση σε συνεργατικό ticket';
$hesklang['desc_collaborator_resolved']='(Προσωπικό) Συνεργατικό ticket επιλύθηκε';
$hesklang['desc_collaborator_overdue']='(Προσωπικό) Συνεργατικό ticket είναι εκπρόθεσμο';
$hesklang['notify_collaborator_added']='Προστέθηκα ως συνεργάτης σε ticket';
$hesklang['notify_collaborator_customer_reply']='Πελάτης απαντά σε συνεργατικό ticket';
$hesklang['notify_collaborator_staff_reply']='Προσωπικό απαντά σε συνεργατικό ticket';
$hesklang['notify_collaborator_note']='Το προσωπικό προσθέτει σημείωση σε συνεργατικό ticket';
$hesklang['notify_collaborator_resolved']='Το προσωπικό επιλύει συνεργατικό ticket';
$hesklang['notify_collaborator_overdue']='Συνεργατικό ticket είναι εκπρόθεσμο';
$hesklang['recurring_tickets']['tab']='Recurring Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Recurring Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Αυτοματοποιήστε τις επαναλαμβανόμενες εργασίες· αφήστε το Hesk να ανοίγει ρουτινικά tickets ακριβώς όταν τα χρειάζεστε.';
$hesklang['recurring_tickets']['active_rules']='Ενεργοί κανόνες';
$hesklang['recurring_tickets']['new']='Νέος κανόνας recurring ticket';
$hesklang['recurring_tickets']['no_rules']='Δεν έχετε κανόνες recurring ticket. Δημιουργήστε έναν κάνοντας κλικ στο κουμπί &quot;Νέος κανόνας recurring ticket&quot; παραπάνω.';
$hesklang['recurring_tickets']['title']='Τίτλος κανόνα';
$hesklang['recurring_tickets']['titlet']='Περιγραφικός τίτλος, π.χ.: Επαναανάθεση tickets χωρίς απάντηση μέσα σε μία μέρα';
$hesklang['recurring_tickets']['default_title']='Κανόνας από %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Ενεργοποιητής κανόνα';
$hesklang['recurring_tickets']['trigt']='Ορίστε τη συνθήκη που θα ενεργοποιεί (τρέχει) αυτόν τον κανόνα.';
$hesklang['recurring_tickets']['hits']='Επιτυχίες'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Χρόνος δημιουργίας'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Γενικές ρυθμίσεις'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Προσαρμοσμένα πεδία'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Περιεχόμενο'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Διαγραφή αυτού του κανόνα;';
$hesklang['recurring_tickets']['edit']='Επεξεργασία κανόνα recurring ticket ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Εντός:';
$hesklang['recurring_tickets']['minutes']='λεπτών';
$hesklang['recurring_tickets']['hours']='ωρών';
$hesklang['recurring_tickets']['days']='ημερών';
$hesklang['recurring_tickets']['weeks']='εβδομάδων';
$hesklang['recurring_tickets']['months']='μηνών';
$hesklang['recurring_tickets']['years']='ετών';
$hesklang['recurring_tickets']['setpri']='Ορισμός προτεραιότητας σε:';
$hesklang['recurring_tickets']['setsta']='Ορισμός κατάστασης σε:';
$hesklang['recurring_tickets']['assto']='Ανάθεση ticket σε:';
$hesklang['recurring_tickets']['asm']='Άλλο μέλος προσωπικού';
$hesklang['recurring_tickets']['notify']='Ειδοποίηση μελών προσωπικού...';
$hesklang['recurring_tickets']['ato']='Εφαρμογή σε:';
$hesklang['recurring_tickets']['save']='Αποθήκευση κανόνα';
$hesklang['recurring_tickets']['e_tt']='Ο χρόνος πρέπει να είναι μεταξύ 1 και 10000';
$hesklang['recurring_tickets']['nocat']='Επιλέξτε τουλάχιστον μία κατηγορία';
$hesklang['recurring_tickets']['nouser']='Επιλέξτε τουλάχιστον έναν χρήστη';
$hesklang['recurring_tickets']['nostatus']='Επιλέξτε τουλάχιστον μία κατάσταση';
$hesklang['recurring_tickets']['nocata']='Ο/Η %1$s δεν έχει πρόσβαση σε αυτές τις κατηγορίες:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Δημιουργήθηκε νέος κανόνας';
$hesklang['recurring_tickets']['mdf']='Οι ρυθμίσεις του κανόνα αποθηκεύτηκαν';
$hesklang['recurring_tickets']['e_id']='Δεν βρέθηκε κανόνας με αυτό το ID';
$hesklang['recurring_tickets']['deleted']='Ο επιλεγμένος κανόνας διαγράφηκε';
$hesklang['recurring_tickets']['log_title']='Κανόνας #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Ενεργός'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Ενεργοποίηση αυτού του κανόνα (έναρξη χρήσης)';
$hesklang['recurring_tickets']['activated']='Ο επιλεγμένος κανόνας ενεργοποιήθηκε'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Απενεργοποίηση αυτού του κανόνα (διακοπή χρήσης)';
$hesklang['recurring_tickets']['deactivated']='Ο επιλεγμένος κανόνας απενεργοποιήθηκε'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Δεν υπάρχουν ενεργοί κανόνες recurring ticket';
$hesklang['recurring_tickets']['tools']='Εργαλεία';
$hesklang['recurring_tickets']['tbef']='Πριν τεθεί ένας κανόνας σε λειτουργία, πρέπει να τον ενεργοποιήσετε κάνοντας κλικ στο checkbox στη στήλη &quot;ACTIVE&quot;.<br><br>
                               <strong>Οι ενεργοί κανόνες επεξεργάζονται κάθε %2$s λεπτά.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Κανόνας #%s';
$hesklang['recurring_tickets']['r3']='Κανόνας #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Αριθμός tickets που έχουν ήδη δημιουργηθεί σήμερα: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Επαναφορά αυτού του κανόνα';
$hesklang['recurring_tickets']['reset2']='Είστε βέβαιοι ότι θέλετε να επαναφέρετε αυτόν τον κανόνα;<br><br>Οι επιτυχίες θα μηδενιστούν και τυχόν tickets που δημιουργήθηκαν ήδη σήμερα μπορεί να ξαναδημιουργηθούν στο επόμενο cron.';
$hesklang['recurring_tickets']['reset3']='Ο επιλεγμένος κανόνας επαναφέρθηκε';
$hesklang['recurring_tickets']['test']='Προσομοίωση αυτού του κανόνα';
$hesklang['recurring_tickets']['testa']='Προσομοίωση όλων των κανόνων';
$hesklang['recurring_tickets']['testaa']='Προσομοίωση όλων των ενεργών κανόνων';
$hesklang['recurring_tickets']['testr']='Αποτελέσματα προσομοίωσης';
$hesklang['recurring_tickets']['rsim']='Επανάληψη προσομοίωσης';
$hesklang['recurring_tickets']['sim']='ΛΕΙΤΟΥΡΓΙΑ ΠΡΟΣΟΜΟΙΩΣΗΣ, χωρίς αλλαγές στη βάση δεδομένων';
$hesklang['recurring_tickets']['sic']='Η ΠΡΟΣΟΜΟΙΩΣΗ ΟΛΟΚΛΗΡΩΘΗΚΕ';
$hesklang['recurring_tickets']['rrule_type_required']='Παρακαλώ επιλέξτε έγκυρο trigger επαναλαμβανόμενου κανόνα.';
$hesklang['recurring_tickets']['rrule_string_required']='Παρακαλώ επιλέξτε όλες τις απαιτούμενες επιλογές του trigger.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Εισάγετε τιμή διαστήματος 1 ή μεγαλύτερη για το "Κάθε".';
$hesklang['recurring_tickets']['disable_note']='*Αν αλλάξουν κρίσιμες ρυθμίσεις του hesk μετά τη δημιουργία ενός κανόνα, θα απενεργοποιηθεί στο επόμενο run και θα χρειαστεί επεξεργασία για νέους ελέγχους.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | υποβλήθηκε από τον κανόνα Recurring Tickets "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | ανατέθηκε στον/στην %2$s από τον κανόνα Recurring Tickets "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | έκλεισε αυτόματα από τον κανόνα Recurring Tickets "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | η κατάσταση άλλαξε σε %2$s από τον κανόνα Recurring Tickets "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | ανατέθηκε αυτόματα στον/στην %2$s από τον κανόνα Recurring Tickets "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Ο κανόνας απενεργοποιήθηκε λόγω σφαλμάτων επικύρωσης. Δείτε παρακάτω.';
$hesklang['recurring_tickets']['errors_title']='Ένας ή περισσότεροι κανόνες παρήγαγαν σφάλματα όταν προσπάθησαν να εκτελεστούν και απενεργοποιήθηκαν.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Σφάλματα κανόνα #%s:';
$hesklang['recurring_tickets']['create_customers']='Δεν υπάρχουν πελάτες — δημιουργήστε τους <a href="%s" target="_blank">εδώ</a>.';
$hesklang['recurring_tickets']['exec_dates']='Ημερομηνίες εκτέλεσης κανόνα';
$hesklang['recurring_tickets']['show_exec_dates']='[Εμφάνιση τρεχουσών ημερομηνιών εκτέλεσης κανόνα]';
$hesklang['recurring_tickets']['no_exec_dates']='Επιλέξτε έγκυρα triggers κανόνα για να δείτε ημερομηνίες εκτέλεσης.';
$hesklang['recurring_tickets']['invalid_disabled']='άκυρες ρυθμίσεις Rrule - ο κανόνας απενεργοποιήθηκε.';
$hesklang['recurring_tickets']['next_occ']='Επόμενες %s εμφανίσεις κανόνα:';
$hesklang['recurring_tickets']['occ_on']='στις %s';
$hesklang['recurring_tickets']['not_firing_today']='δεν χρειάζεται εκτέλεση σήμερα.';
$hesklang['recurring_tickets']['rules_fulfilled']='ικανοποιήθηκαν οι recurring κανόνες - ticket δημιουργήθηκε σήμερα!';
$hesklang['recurring_tickets']['validation_failed']='η επικύρωση απέτυχε - ο κανόνας απενεργοποιήθηκε. Λεπτομέρειες παρακάτω:';
$hesklang['recurring_tickets']['validation_error']='Σφάλμα επικύρωσης:';
$hesklang['recurring_tickets']['processed']='επεξεργάστηκε.';
$hesklang['recurring_tickets']['created_ticket']='δημιουργήθηκε ticket id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='σχετική με την ημερομηνία δημιουργίας του ticket';
$hesklang['priorities']='Προτεραιότητες';
$hesklang['priority_intro']='Χρησιμοποιήστε αυτό το εργαλείο για να διαχειριστείτε τις προτεραιότητες ticket για το help desk σας';
$hesklang['new_priority']='Νέα προτεραιότητα';
$hesklang['edit_priority']='Επεξεργασία προτεραιότητας';
$hesklang['priority_title']='Τίτλος';
$hesklang['can_customers_select_it']='Μπορούν οι πελάτες να επιλέξουν αυτήν την προτεραιότητα;';
$hesklang['selected_by_customer']='Επιλέξιμη από πελάτες';
$hesklang['err_priority']='Εισάγετε τον τίτλο προτεραιότητας';
$hesklang['priority_added']='Προστέθηκε νέα προτεραιότητα';
$hesklang['priority_e_id']='Μη έγκυρο ID προτεραιότητας';
$hesklang['priority_mdf']='Η προτεραιότητα αποθηκεύτηκε';
$hesklang['priority_deleted']='Η προτεραιότητα διαγράφηκε';
$hesklang['priority_not_found']='Αυτή η προτεραιότητα δεν υπάρχει';
$hesklang['priority_not_empty']='Αυτή η προτεραιότητα δεν μπορεί να διαγραφεί επειδή υπάρχουν tickets με αυτήν την προτεραιότητα';
$hesklang['click_to_enable_drag_drop']='Κάντε κλικ για να ενεργοποιήσετε το drag-and-drop για τη γραμμή και μετά σύρετέ την πάνω/κάτω για αναδιάταξη προτεραιοτήτων.';
$hesklang['confirm_delete_priority']='Είστε βέβαιοι ότι θέλετε να διαγράψετε αυτήν την προτεραιότητα;';
$hesklang['reordered_message']='Η σειρά της λίστας προτεραιοτήτων αποθηκεύτηκε.';
$hesklang['list_tkt_priority']='Λίστα όλων των tickets με αυτήν την προτεραιότητα';
$hesklang['deletion_priority_restricted']='Αυτή είναι ειδική προτεραιότητα και δεν μπορεί να διαγραφεί';
$hesklang['priority_limit']='Δεν μπορείτε να δημιουργήσετε νέες προτεραιότητες';
$hesklang['skip_to_main_content']='Μετάβαση στο κύριο περιεχόμενο';
$hesklang['opens_dialog']='Ανοίγει ένα παράθυρο διαλόγου';
$hesklang['create_a_ticket']='Δημιουργία ticket';
$hesklang['toggle_navigation']='Εναλλαγή πλοήγησης';
$hesklang['add_a_ticket_reply']='Προσθήκη απάντησης σε ticket';
$hesklang['linked_tickets']='Συνδεδεμένα tickets';
$hesklang['no_linked_tickets']='Δεν υπάρχουν συνδεδεμένα tickets';
$hesklang['link_ticket']='Σύνδεση ticket';
$hesklang['can_link_tickets_e']='Δεν έχετε δικαίωμα σύνδεσης/αποσύνδεσης αυτού του ticket';
$hesklang['link_ticket_success']='Το ticket συνδέθηκε με επιτυχία';
$hesklang['link_ticket_required_error']='Για να συνδέσετε ticket, δώστε έγκυρο Tracking ID';
$hesklang['link_ticket_itself_error']='Ένα ticket δεν μπορεί να συνδεθεί με τον εαυτό του. Εισάγετε διαφορετικό Tracking ID';
$hesklang['already_linked_error']='Το ticket έχει ήδη συνδεθεί';
$hesklang['unlink_success']='Το ticket αποσυνδέθηκε με επιτυχία';
$hesklang['unlink_error']='Δεν υπάρχει συνδεδεμένη εγγραφή';
$hesklang['link_history']='<li class="smaller">%s | %s ticket συνδέθηκε από τον/την %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket αποσυνδέθηκε από τον/την %s</li>';
$hesklang['can_link_tickets']='Μπορεί να συνδέει ticket';
$hesklang['link_a_ticket']='Σύνδεση ticket';
$hesklang['mfa_curl']='Αδυναμία δημιουργίας εικόνας QR για σάρωση επειδή η υποστήριξη <strong>cURL</strong> δεν είναι ενεργή στον server σας.';
$hesklang['require_xml']='Το PHP-XML πρέπει να είναι ενεργό για μηνύματα Rich Text (HTML). Ζητήστε από τον πάροχό σας να ενεργοποιήσει το XML για PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | ο/η %2$s προστέθηκε ως συνεργάτης από τον/την %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | ο/η %2$s αφαιρέθηκε ως συνεργάτης από τον/την %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Ιδανικό για εργασίες προληπτικής συντήρησης, μηνιαίους ελέγχους πρόσβασης, επαναλαμβανόμενα check-ins πελατών και πολλά άλλα.';
$hesklang['recurring_tickets']['feat1']='<strong>Προγραμματίστε και ξεχάστε.</strong> Καθημερινά, κάθε Δευτέρα, κάθε Μάρτιο, στις 15 κάθε μήνα ή οποιαδήποτε μελλοντική ημερομηνία';
$hesklang['recurring_tickets']['feat2']='<strong>Έρχονται προσυμπληρωμένα και ανατεθειμένα.</strong> Επιλέξτε κατηγορία, προτεραιότητα, agent και έως 100 τιμές προσαρμοσμένων πεδίων';
$hesklang['recurring_tickets']['feat3']='<strong>Προεπισκόπηση ημερομηνιών και Προσομοίωση.</strong> Δείτε κάθε ticket που θα δημιουργήσει το Hesk πριν ενεργοποιήσετε τον κανόνα, ώστε να μην υπάρχουν εκπλήξεις.';
$hesklang['unlink_btn']='Αποσύνδεση';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');