<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Português Brasileiro (Brazilian Portuguese)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Felipe Amorim (http://www.felipeamorim.eti.br)
* Fernando Souza
* Murilo Zoratti
* Fabio Bmed (http://www.fabiobmed.com.br)
* Bruno Andrade da Silva
* Felipe Rozelio
* Luka Sabino
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Português Brasileiro';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Brazilian Portuguese';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Responda acima desta linha ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Novo chamado: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Chamado recebido: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Chamado atribuído: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nova resposta a: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nova resposta a: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Chamado movido: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Observação adicionada a: %%SUBJECT%%';
$hesklang['new_pm']='Nova mensagem privada: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Lista de seus chamados';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Não é possível conectar-se ao banco de dados!';
$hesklang['invalid_action']='Ação inválida';
$hesklang['select_username']='Por favor selecione seu usuário';
$hesklang['enter_pass']='Por favor digite sua senha';
$hesklang['cant_sql']='Não é possível executar o SQL';
$hesklang['contact_webmsater']='Por favor notifique o administrador em';
$hesklang['mysql_said']='MySQL disse';
$hesklang['wrong_pass']='Senha incorreta.';
$hesklang['session_expired']='Sua sessão expirou, por favor entre usando o formulário abaixo.';
$hesklang['attempt']='Tentativa inválida!';
$hesklang['not_authorized_tickets']='Você não está autorizado a ver chamados dentro desta categoria!';
$hesklang['must_be_admin']='Você não está autorizado a ver esta página! Para ver esta página você deve estar logado como administrador.';
$hesklang['no_session']='Não é possível iniciar uma nova sessão!';
$hesklang['error']='Erro';
$hesklang['int_error']='Erro de script interno';
$hesklang['no_trackID']='Sem código de identificação';
$hesklang['status_not_valid']='Status inválido';
$hesklang['trackID_not_found']='Código de identificação não encontrado';
$hesklang['enter_message']='Por favor digite sua mensagem';
$hesklang['select_priority']='Por favor selecione a prioridade';
$hesklang['ticket_not_found']='Chamado não encontrado! Por favor certifique-se de ter digitado o código de identificação correto!';
$hesklang['no_selected']='Nenhum chamado selecionado, nada a alterar';
$hesklang['id_not_valid']='Esta não é uma identificação válida';
$hesklang['enter_id']='Por favor digite o código de identificação';
$hesklang['enter_name']='Por favor digite o nome do cliente';
$hesklang['enter_date']='Por favor digite a data em que você deseja pesquisar';
$hesklang['date_not_valid']='Esta não é uma data válida. Por favor digite a data no formato <b>YYYY-MM-DD</b>.';
$hesklang['enter_subject']='Por favor digite o assunto do chamado';
$hesklang['invalid_search']='Ação de pesquisa inválida';
$hesklang['choose_cat_ren']='Por favor escolha uma categoria a ser renomeada';
$hesklang['cat_ren_name']='Por favor digite o novo nome da categoria';
$hesklang['cat_not_found']='Categoria não encontrada';
$hesklang['enter_cat_name']='Por favor digite o nome da categoria';
$hesklang['no_cat_id']='Nenhuma identificação da categoria';
$hesklang['cant_del_default_cat']='Vocẽ não pode remover a categoria padrão, você pode apenas renomeá-la';
$hesklang['no_valid_id']='Nenhuma identificação de usuário válida';
$hesklang['user_not_found']='Usuário não encontrado';
$hesklang['enter_real_name']='Por favor digite o nome real do usuário';
$hesklang['enter_valid_email']='Por favor digite um endereço de e-mail válido';
$hesklang['enter_username']='Por favor digite o usuário (login)';
$hesklang['asign_one_cat']='Por favor atribua o usuário a pelo menos uma categoria!';
$hesklang['signature_long']='A assinatura do usuário é muito grande! Por favor, limite a assinatura em 1000 caracteres';
$hesklang['confirm_user_pass']='Por favor confirme a senha';
$hesklang['passwords_not_same']='As duas senhas digitadas não são as mesmas!';
$hesklang['cant_del_admin']='Você não pode remover o administrador padrão!';
$hesklang['cant_del_own']='Você não pode remover o perfil no qual está logado!';
$hesklang['enter_your_name']='Por favor digite seu nome';
$hesklang['sel_app_cat']='Por favor selecione a categoria adequada';
$hesklang['sel_app_priority']='Por favor selecione a prioridade adequada';
$hesklang['enter_ticket_subject']='Por favor digite o assunto do seu chamado';
$hesklang['user_not_found_nothing_edit']='Usuário não encontrado ou nada a alterar';

// ADMIN PANEL
$hesklang['administrator']='Administrador';
$hesklang['login']='Entrar';
$hesklang['user']='Usuário';
$hesklang['username']='Usuário';
$hesklang['pass']='Senha';
$hesklang['confirm_pass']='Confirmar senha';
$hesklang['logged_out']='Desconectado';
$hesklang['logout']='Sair';
$hesklang['logout_success']='Você se desconectou com sucesso!';
$hesklang['click_login']='Clique aqui para entrar';
$hesklang['back']='Voltar';
$hesklang['displaying_pages']='Exibindo <b>%d</b> chamados. Páginas:';
$hesklang['trackID']='Código de identificação';
$hesklang['timestamp']='Registro de hora';
$hesklang['name']='Nome';
$hesklang['subject']='Assunto';
$hesklang['status']='Status';
$hesklang['priority']='Prioridade';
$hesklang['open']='Novo';
$hesklang['open_action']='Abrir chamado'; // Open ACTION
$hesklang['close']='Fechado'; // Closed ticket STATUS
$hesklang['any_status']='Qualquer status';
$hesklang['high']='Alta';
$hesklang['medium']='Média';
$hesklang['low']='Baixa';
$hesklang['del_selected']='Remover chamados selecionados';
$hesklang['manage_cat']='Gerenciar categorias';
$hesklang['profile']='Seu perfil';
$hesklang['show_tickets']='Exibir chamados';
$hesklang['sort_by']='Classificar por';
$hesklang['date_posted']='Data de publicação';
$hesklang['category']='Categoria';
$hesklang['any_cat']='Qualquer categoria';
$hesklang['order']='Ordem';
$hesklang['ascending']='Ascendente';
$hesklang['descending']='Descendente';
$hesklang['display']='Exibir';
$hesklang['tickets_page']='Chamados por página';
$hesklang['find_ticket']='Procurar chamado';
$hesklang['yyyy_mm_dd']='AAAA-MM-DD';
$hesklang['results_page']='resultados por página';
$hesklang['opened']='Aberto'; // The ticket has been OPENED
$hesklang['closed']='Resolvido'; // Ticket has been RESOLVED
$hesklang['ticket']='Chamado';
$hesklang['tickets']='Chamados';
$hesklang['ticket_been']='Este chamado foi';
$hesklang['view_ticket']='Ver chamado';
$hesklang['open_tickets']='Abrir chamados';
$hesklang['remove_statement']='Remover declaração &quot;Powered by&quot;';
$hesklang['click_info']='Clique aqui para mais informações';
$hesklang['reply_added']='Resposta adicionada';
$hesklang['reply_submitted']='Resposta enviada';
$hesklang['ticket_marked']='Este chamado foi marcado';
$hesklang['ticket_status']='Status do chamado';
$hesklang['replies']='Respostas';
$hesklang['date']='Data';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Mensagem';
$hesklang['add_reply']='Adicionar resposta';
$hesklang['close_this_ticket']='Marcar este chamado como Resolvido';
$hesklang['change_priority']='Alterar prioridade para';
$hesklang['attach_sign']='Anexar assinatura';
$hesklang['profile_settings']='Configurações de perfil';
$hesklang['submit_reply']='Enviar resposta';
$hesklang['support_panel']='Painel de suporte';
$hesklang['ticket_trackID']='Código de identificação do chamado';
$hesklang['c2c']='Clique para continuar';
$hesklang['tickets_deleted']='Chamados removidos';
$hesklang['num_tickets_deleted']='<b>%d</b> chamados foram removidos';
$hesklang['confirm_del_cat']='Tem certeza de que deseja remover esta categoria?';
$hesklang['cat_intro']='Aqui você pode gerenciar as categorias. Categorias são úteis
para categorizar chamados por relevância (por exemplo &quot;Vendas&quot;,
&quot;Problemas de hardware&quot;, &quot;Problemas de PHP/MySQL&quot; etc) e para
atribuir usuários a categorias (por exemplo, o seu vendedor pode ver somente
chamados enviados para a categoria &quot;Vendas&quot;)';
$hesklang['cat_name']='Nome da categoria';
$hesklang['remove']='Remover';
$hesklang['add_cat']='Adicionar nova categoria';
$hesklang['max_chars']='máximo de 40 caracteres';
$hesklang['create_cat']='Criar categoria';
$hesklang['ren_cat']='Renomear categoria';
$hesklang['to']='para';
$hesklang['cat_added']='Categoria adicionada';
$hesklang['cat_name_added']='A categoria %s foi adicionada com sucesso';
$hesklang['cat_renamed']='Categoria renomeada';
$hesklang['cat_renamed_to']='A categoria selecionada foi renomeada com sucesso para';
$hesklang['cat_removed']='Categoria removida';
$hesklang['cat_removed_db']='A categoria selecionada foi removida com sucesso do banco de dados';
$hesklang['sure_remove_user']='Você tem certeza de que deseja remover este usuário?';
$hesklang['manage_users']='Gerenciar usuários';
$hesklang['users_intro']='Aqui você pode gerenciar usuários que podem entrar no painel administrativo e
responder chamados. Administradores podem ver/editar chamados em qualquer categoria e tem acesso
a todos os recursos do painel administrativo (gerenciar usuários, gerenciar categorias, ...) enquanto
outros usuários podem apenas ver e responder aos chamados dentro de suas categorias.';
$hesklang['yes']='SIM';
$hesklang['no']='NÃO';
$hesklang['edit']='Editar';
$hesklang['add_user']='Adicionar novo usuário';
$hesklang['req_marked_with']='Campos obrigatórios estão marcados com';
$hesklang['real_name']='Nome real';
$hesklang['signature_max']='Assinatura (máximo de 1000 caracteres)';
$hesklang['sign_extra']='Código HTML não é permitido. Links serão clicáveis.';
$hesklang['create_user']='Criar usuário';
$hesklang['editing_user']='Editando usuário';
$hesklang['user_added']='Usuário adicionado';
$hesklang['user_added_success']='O novo usuário %s com a senha %s foi adicionado com sucesso';
$hesklang['profile_updated']='Perfil atualizado';
$hesklang['profile_updated_success']='Este perfil foi atualizado com sucesso';
$hesklang['user_removed']='Usuário removido';
$hesklang['sel_user_removed']='O usuário selecionado foi removido com sucesso do banco de dados';
$hesklang['profile_for']='Perfil para';
$hesklang['new_pass']='Nova senha';
$hesklang['update_profile']='Atualizar perfil';
$hesklang['notify_new_posts']='Me notifique de novos chamados e postagens em minhas categorias';
$hesklang['view_profile']='Ver perfil';
$hesklang['new_ticket_submitted']='Novo chamado enviado';
$hesklang['user_profile_updated_success']='Este perfil de usuário foi atualizado com sucesso';
$hesklang['printer_friendly']='Imprimir';
$hesklang['end_ticket']='--- Fim do chamado ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Seu chamado foi';
$hesklang['view_your_ticket']='Ver seu chamado';
$hesklang['submit_ticket']='Enviar um chamado';
$hesklang['sub_ticket']='Enviar chamado';
$hesklang['before_submit']='Antes de enviar, por favor, certifique de que';
$hesklang['all_info_in']='Todas as informações necessárias foram preenchidas';
$hesklang['all_error_free']='Todas as informações estão corretas e sem erros';
$hesklang['we_have']='Nós temos';
$hesklang['recorded_ip']='registrado seu endereço IP';
$hesklang['recorded_time']='registrado a hora de seu envio';
$hesklang['save_changes']='Salvar alterações';
$hesklang['reply_submitted_success']='Sua resposta a este chamado foi enviado com sucesso';
$hesklang['ticket_submitted']='Chamado enviado';
$hesklang['ticket_submitted_success']='Seu chamado foi enviado com sucesso! Identificação do chamado';
$hesklang['your_ticket']='Seu chamado';

// Added in version 0.94
$hesklang['check_updates']='Certifique-se de ter sempre a última versão do HESK instalada!';
$hesklang['check4updates']='Procurar por atualizações';
$hesklang['wait_reply']='Aguardando resposta';
$hesklang['replied']='Respondido';
$hesklang['last_replier']='Último a responder';
$hesklang['staff']='Equipe';
$hesklang['customer']='Cliente';
$hesklang['close_selected']='Marcar os chamados selecionados como Resolvidos';
$hesklang['execute']='Executar';
$hesklang['saved_replies']='Respostas automáticas';
$hesklang['manage_saved']='Respostas automáticas';
$hesklang['manage_intro']='Aqui você pode adicionar e gerenciar respostas automáticas. Estas são respostas comumente usadas que são mais ou menos a mesma para cada cliente. Você deve usar respostas automáticas para evitar digitar a mesma resposta para diferentes clientes diversas vezes.';
$hesklang['saved_title']='Título';
$hesklang['no_saved']='Nenhuma resposta automática';
$hesklang['delete_saved']='Você tem certeza de que deseja remover esta resposta automática?';
$hesklang['new_saved']='Adicionar ou editar uma resposta automática';
$hesklang['canned_add']='Criar uma nova resposta automática';
$hesklang['canned_edit']='Editar resposta automática selecionada';
$hesklang['save_reply']='Salvar resposta';
$hesklang['saved']='Resposta salva';
$hesklang['your_saved']='Sua resposta automática foi salva para uso futuro';
$hesklang['ent_saved_title']='Por favor digite o título da resposta';
$hesklang['ent_saved_msg']='Por favor digite a mensagem da resposta';
$hesklang['saved_removed']='Resposta automática removida';
$hesklang['saved_rem_full']='A resposta automática selecionada foi removido do banco de dados';
$hesklang['clip_alt']='Esta postagem contém anexos';
$hesklang['attachments']='Anexos';
$hesklang['fill_all']='Campo obrigatório não preenchido';
$hesklang['file_too_large']='Seu arquivo %s é muito grande';
$hesklang['cannot_move_tmp']='Não foi possível mover o arquivo para a padta de anexos';
$hesklang['created_on']='Criado';
$hesklang['tickets_closed']='Chamados fechados';
$hesklang['num_tickets_closed']='<b>%d</b> chamados foram fechados';
$hesklang['select_saved']='Selecionar uma resposta automática';
$hesklang['select_empty']='Selecionar / Vazio';
$hesklang['insert_special']='Inserir tag especial (será substituída com informações do cliente)';
$hesklang['move_to_catgory']='Mover chamado para';
$hesklang['move']='Mover';
$hesklang['moved']='Chamado movido';
$hesklang['moved_to']='Este chamado foi movido para a nova categoria';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Todos exceto fechados';
$hesklang['chg_all']='Alterar todos';
$hesklang['settings']='Configurações';
$hesklang['settings_intro']='Utilize esta ferramenta para configurar sua central de suporte. Para obter mais informações sobre todas as configurações e opções clique no símbolo de ajuda ou verifique o arquivo readme.html.';
$hesklang['all_req']='Todos os campos (esceto os desabilitados) são obrigatórios!';
$hesklang['wbst_title']='Título do site';
$hesklang['wbst_url']='URL do site';
$hesklang['email_wm']='E-mail do administrador';
$hesklang['max_listings']='Listagens por página';
$hesklang['print_size']='Tamanho da fonte de impressão';
$hesklang['debug_mode']='Mode de depuração';
$hesklang['on']='LIGADO';
$hesklang['off']='DESLIGADO';
$hesklang['use_secimg']='Usar imagem anti-SPAM';
$hesklang['secimg_no']='Não disponível';
$hesklang['attach_use']='Usar anexos';
$hesklang['attach_num']='Número por post';
$hesklang['attach_type']='Tipos de arquivo permitidos';
$hesklang['place_after']='Após a mensagem';
$hesklang['place_before']='Antes da mensagem';
$hesklang['custom_f']='Campo personalizado';
$hesklang['custom_u']='Usar este campo';
$hesklang['custom_n']='Nome do campo';
$hesklang['custom_l']='Comprimento máximo (caracteres)';
$hesklang['db_host']='Servidor do banco de dados';
$hesklang['db_name']='Nome do banco de dados';
$hesklang['db_user']='Usuário do banco de dados';
$hesklang['db_pass']='Senha do banco de dados';
$hesklang['err_sname']='Por favor digite o título do seu site';
$hesklang['err_surl']='Por favor digite a URL do seu site. Certifique-se de que seja uma URL válida (iniciando com http:// ou https://)';
$hesklang['err_wmmail']='Por favor digite um e-mail de administrador válido';
$hesklang['err_nomail']='Por favor digite um e-mail não-responda válido';
$hesklang['err_htitle']='Por favor digite o título de sua central de suporte';
$hesklang['err_hurl']='Por favor digite a url da pasta do seu HESK. Certifique-se de que seja uma URL válida (iniciando com http:// ou https://)';
$hesklang['err_lang']='Por favor selecione o idioma do HESK';
$hesklang['err_nolang']='O arquivo de idioma especificado não existe na pasta de idiomas! Certifique-se de que o arquivo foi enviado antes de alterar as configurações de idioma.';
$hesklang['err_max']='Por favor digite digite a quantidade máxima listada por página';
$hesklang['err_psize']='Por favor digite o tamanho da fonte de impressão';
$hesklang['err_dbhost']='Por favor digite o seu endereço do servidor do banco de dados MySQL';
$hesklang['err_dbname']='Por favor digite o seu nome do banco de dados MySQL';
$hesklang['err_dbuser']='Por favor digite o seu usuário do banco de dados MySQL';
$hesklang['err_dbpass']='Por favor digite a sua senha do banco de dados MySQL';
$hesklang['err_dbconn']='Não foi possível se conectar ao banco de dados MySQL usando as informações fornecidas!';
$hesklang['err_dbsele']='Não foi possível selecionar o banco de dados MySQL, por favor verifique o NOME do banco de dados';
$hesklang['err_custname']='Digite o nome do campo personalizado';
$hesklang['err_openset']='Não foi possível abrir o arquivo <b>hesk_settings.inc.php</b> para gravação. Por favor, altere o CHMOD deste arquivo para 666 (rw-rw-rw-)';
$hesklang['set_saved']='Configurações salvas';
$hesklang['set_were_saved']='Suas configurações foram salvas com sucesso';
$hesklang['sec_img']='Imagem de segurança';
$hesklang['sec_miss']='Por favor digite o número de segurança';
$hesklang['sec_wrng']='Número de segurança errado';
$hesklang['submit_problems']='Por favor volte e corrija os seguintes problemas';
$hesklang['cat_order']='Ordem da categoria';
$hesklang['reply_order']='Ordem da resposta automática';
$hesklang['move_up']='Mover para cima';
$hesklang['move_dn']='Mover para baixo';
$hesklang['cat_move_id']='Identificação da categoria faltando';
$hesklang['reply_move_id']='Identificação da resposta automática faltando';
$hesklang['forgot_tid']='Esqueceu o código de identificação?';
$hesklang['tid_send']='Me envie meu código de identificação';
$hesklang['tid_not_found']='Nenhum chamado com seu endereço de e-mail foi encontrado';
$hesklang['tid_sent']='Código de identificação enviado';
$hesklang['tid_sent2']='Um e-mail com detalhes sobre seus chamados foi enviado para o seu endereço';
$hesklang['check_spambox']='Certifique-se de verificar pelo e-mail em sua caixa de SPAM/Lixo eletrônico!';
$hesklang['reply_not_found']='Resposta automática não encontrada';
$hesklang['exists']='Existe';
$hesklang['no_exists']='Não existe';
$hesklang['writable']='Gravável';
$hesklang['not_writable']='Não gravável';
$hesklang['disabled']='desabilitado';
$hesklang['e_settings']='Você não será capaz de salvar suas configurações a menos que este arquivo seja gravável pelo script. Por favor consulte o arquivo readme.html para obter mais instruções!';
$hesklang['e_attdir']='Você não será capaz de usar anexos a menos que a pasta de anexos exista e seja gravável pelo script.';
$hesklang['e_save_settings']='Não é possível salvar suas configurações porque o arquivo <b>hesk_settings.inc.php</b> não é gravável pelo script.';
$hesklang['e_attach']='Desabilitado porque o seu diretório <b>attachments</b> não é gravável pelo script.';
$hesklang['go']='Go';

// Added in version 2.0
$hesklang['v']='Versão do HESK';
$hesklang['check_status']='Verificando status';
$hesklang['sub_support']='Enviar um chamado';
$hesklang['open_ticket']='Enviar um novo chamado para um departamento';
$hesklang['view_existing']='Ver chamado existente';
$hesklang['vet']='Ver chamados que você enviou no passado';
$hesklang['enter_user']='Por favor digite seu usuário';
$hesklang['remember_user']='Lembrar meu usuário';
$hesklang['wrong_user']='Usuário incorreto';
$hesklang['no_permission']='Você não tem permissão para executar esta tarefa, por favor entre com uma conta que possua.';
$hesklang['tickets_on_pages']='Número de chamados: %d | Número de páginas: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='Ir para a página:';
$hesklang['no_tickets_open']='Nenhum chamado não resolvido encontrado';
$hesklang['no_tickets_crit']='Nenhum chamado encontrado correspondendo aos seus critérios';
$hesklang['confirm_execute']='Vocẽ tem certeza de que deseja continuar?';
$hesklang['legend']='Legenda';
$hesklang['main_page']='Início';
$hesklang['menu_users']='Usuários';
$hesklang['menu_cat']='Categorias';
$hesklang['menu_profile']='Perfil';
$hesklang['menu_kb']='Base de conhecimento'; // Admin MENU item
$hesklang['kb_text']='Base de conhecimento'; // Item visible to customers
$hesklang['viewkb']='Ver toda a base de conhecimento';
$hesklang['kb']='Gerenciar a base de conhecimento';
$hesklang['kb_intro']='A base de conhecimento é uma coleção de respostas as perguntas mais frequentes (FAQ) e artigos que fornecem recurso de auto-ajuda aos seus clientes.
Uma base de conhecimento abrangente e bem escrita pode diminuir drasticamente o número de chamados que você recebe e economizar muito seu tempo. Você pode organizar artigos em categorias
e sub-categorias.'; // Description in ADMIN panel
$hesklang['kb_is']='A base de conhecimento é uma coleção categorizada de respostas as perguntas mais frequentes (FAQ) e artigos. Você pode ler artigos nesta categoria ou selecionar uma sub-categoria em que esteja interessado.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Novo artigo na base de conhecimento';
$hesklang['kb_cat']='Categoria';
$hesklang['kb_subject']='Assunto';
$hesklang['kb_content']='Conteúdo';
$hesklang['kb_type']='Tipo';
$hesklang['kb_published']='Publicado';
$hesklang['kb_published2']='O artigo está visível para todos na base de conhecimento.';
$hesklang['kb_private']='Privado';
$hesklang['kb_private2']='Artigos privados podem ser lidos apenas pela equipe.';
$hesklang['kb_draft']='Rascunho';
$hesklang['kb_draft2']='O artigo é salvo mas ainda não é publicado. Só pode ser lido pela equipe<br /> que possui permissão para gerenciar artigos da base de conhecimento.';
$hesklang['kb_links']='<i><span class="notice"><b>Atenção!</b></span><br />Digite um código válido sem as tags &lt;head&gt; e &lt;body&gt;, apenas o conteúdo!</i>';
$hesklang['kb_ehtml']='Isto é um código HTML (eu vou digitar código (X)HTML válido)';
$hesklang['kb_dhtml']='Isto é texto plano (links serão clicáveis)';
$hesklang['kb_save']='Salvar artigo';
$hesklang['kb_e_subj']='Digite o assunto do artigo!';
$hesklang['kb_e_cont']='Digite o conteúdo do artigo!';
$hesklang['kb_art_added']='Artigo adicionado';
$hesklang['your_kb_added']='Um novo artigo da base de conhecimento foi adicionado com sucesso';
$hesklang['kb_art_deleted']='Artigo removido';
$hesklang['your_kb_deleted']='O artigo da base de conhecimento selecionado foi removido com sucesso';
$hesklang['kb_art_mod']='Artigo alterado';
$hesklang['your_kb_mod']='Suas alterações no artigo selecionado foram salvas com sucesso';
$hesklang['kb_cat_new']='Nova categoria na base de conhecimento';
$hesklang['kb_cat_parent']='Categoria pai';
$hesklang['kb_cat_sub']='Sub-categorias';
$hesklang['kb_cat_title']='Título da categoria';
$hesklang['kb_cat_published']='A categoria é visível para todas na base de conhecimento.';
$hesklang['kb_cat_private']='A categoria só pode ser lida pela equipe.';
$hesklang['kb_cat_add']='Adicionar categoria';
$hesklang['kb_cat_e_title']='Digite o título da categoria!';
$hesklang['kb_cat_added']='Categoria adicionada';
$hesklang['kb_cat_added2']='Uma nova categoria foi adiciona com sucesso na base de conhecimento';
$hesklang['kb_cat_man']='Gerenciar categorias da base de conhecimento';
$hesklang['kb_cat_edit']='Editar detalhes da categoria';
$hesklang['kb_cat_inv']='Categoria inválida';
$hesklang['kb_cat_art']='Artigos nesta categoria';
$hesklang['kb_p_art']='+ Artigo';
$hesklang['kb_p_art2']='adicionar um novo artigo na categoria selecionada.';
$hesklang['kb_add_art']='Adicionar Artigo';
$hesklang['kb_p_cat']='+ Categoria';
$hesklang['kb_p_cat2']='criar uma nova sub-categoria dentro da categoria selecionada.';
$hesklang['kb_add_cat']='Adicionar Categoria';
$hesklang['kb_p_man']='Gerenciar';
$hesklang['kb_p_man2']='gerenciar a categoria selecionada (editar, remover, gerenciar artigos).';
$hesklang['kb_main']='A categoria principal da base de conhecimento não pode ser removida ou movida.';
$hesklang['kb_no_art']='Não há artigos nesta categoria.';
$hesklang['author']='Autor';
$hesklang['views']='Visualizações';
$hesklang['delete']='Remover';
$hesklang['rating']='Avaliação';
$hesklang['votes']='Votos';
$hesklang['kb_rated']='Avaliação do artigo %s/5.0';
$hesklang['kb_not_rated']='Artigo ainda não avaliado';
$hesklang['del_art']='Você tem certeza de que deseja remover o artigo selecionado?';
$hesklang['kb_art_id']='Identificação do artigo não encontrada ou inválida!';
$hesklang['kb_art_edit']='Editar artigo';
$hesklang['revhist']='Histórico de revisão';
$hesklang['revision1']='<li class="smaller">%s | enviado por %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modificado por %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Ordem';
$hesklang['kb_delcat']='Você tem certeza de que deseja remover esta categoria?';
$hesklang['kb_cat_mod']='Categoria modificada';
$hesklang['your_cat_mod']='Suas alterações na categoria selecionada foram salvas com sucesso';
$hesklang['kb_cat_del']='Categoria da base de conhecimento removida';
$hesklang['kb_cat_dlt']='A categoria da base de conhecimento selecionada foi removida.';
$hesklang['allowed_cat']='Categorias';
$hesklang['allow_feat']='Recursos';
$hesklang['can_view_tickets']='Ver chamados';
$hesklang['can_reply_tickets']='Responder a chamados';
$hesklang['can_assign_tickets']='Atribuir chamados';
$hesklang['can_del_tickets']='Remover chamados';
$hesklang['can_edit_tickets']='Editar respostas a chamados';
$hesklang['can_change_cat']='Pode alterar a categoria do chamado (para qualquer uma)';
$hesklang['can_man_kb']='Gereciar base de conhecimento';
$hesklang['can_man_users']='Gerenciar usuários';
$hesklang['can_man_cat']='Gerenciar categorias';
$hesklang['can_man_canned']='Gerenciar respostas automáticas';
$hesklang['can_man_settings']='Gerenciar configurações da central de suporte';
$hesklang['can_del_notes']='Remover qualquer observação de chamado';
$hesklang['dan']='usuários podem remover suas próprias observações em chamados, selecione isto apenas se você desejar permitir a este usuário a também poder remover observações de outros usuários';
$hesklang['in_all_cat']='somente em categorias permitidas';
$hesklang['admin_can']='(acesso a todos os recursos e categorias)';
$hesklang['staff_can']='(você pode limitar recursos e categorias)';
$hesklang['asign_one_feat']='Por favor, atribua pelo menos um recurso a este usuário!';
$hesklang['na_view_tickets']='Você não está autorizado a ver chamados';
$hesklang['support_notice']='Desculpe, esta seção só pode ser ocultada quando você comprar uma licença do HESK!';
$hesklang['rart']='Este artigo foi útil?';
$hesklang['r']='Esta resposta foi útil?';
$hesklang['tyr']='Obrigado por sua avaliação';
$hesklang['cw']='Fechar janela';
$hesklang['cw2']='Fechar janela e enviar chamado';
$hesklang['rh']='Avaliado como <i>útil</i>';
$hesklang['rnh']='Avaliado como <i>não foi útil</i>';
$hesklang['ar']='Já avaliado';
$hesklang['rated']='Avaliação do usuário %s/5.0 (%s votos)';
$hesklang['not_rated']='Usuário ainda não avaliou';
$hesklang['rdis']='As avaliações foram desabilitadas';
$hesklang['kbdis']='A base de conhecimento está desabilitada';
$hesklang['kbpart']='Desculpe, você não tem permissão para acesar este artigo';
$hesklang['popart']='Artigos mais visualizados da base de conhecimento:';
$hesklang['latart']='Últimos artigos da base de conhecimento:';
$hesklang['m']='Mais tópicos';
$hesklang['ac']='Artigos nesta categoria:';
$hesklang['noa']='Ainda não há artigos';
$hesklang['noac']='Ainda não há artigos nesta categoria';
$hesklang['dta']='Data de publicação';
$hesklang['ad']='Detalhes do artigo';
$hesklang['aid']='Identificação do artigo';
$hesklang['as']='Solução';
$hesklang['search']='Pesquisa';
$hesklang['sr']='Resultados da pesquisa';
$hesklang['nosr']='Não foram encontrados artigos correspondentes. Tente navegar na base de conhecimento ou enviar um novo chamado.';
$hesklang['rv']='Reiniciar visualizações';
$hesklang['rr']='Reiniciar votos (avaliações)';
$hesklang['opt']='Opções';
$hesklang['delcat']='Remover categoria';
$hesklang['move1']='Mover artigos para a categoria pai';
$hesklang['move2']='Remover artigos nesta categoria';
$hesklang['sc']='Artigos sugeridos da base de conhecimento';
$hesklang['not']='Chamados'; // Number of all tickets in category
$hesklang['graph']='Gráfico';
$hesklang['lu']='Listar usuários';
$hesklang['aclose']='Fechar chamados automaticamente';
$hesklang['aclose2']='dias após a última resposta da equipe';
$hesklang['s_ucrt']='Reabrir chamados';
$hesklang['urate']='Responder avaliações';
$hesklang['hesk_url']='URL da central de suporte';
$hesklang['hesk_title']='Título da central de suporte';
$hesklang['cid']='Código de identificação do caso';
$hesklang['tfor']='Formato da hora';
$hesklang['prefix']='Prefixo da tabela';
$hesklang['s_ekb']='Habilitar base de conhecimento';
$hesklang['s_kbs']='Habilitar pesquisa na BC';
$hesklang['s_kbr']='Habilitar avaliações na BC';
$hesklang['s_maxsr']='Máximo de resultados na pesquisa';
$hesklang['s_suggest']='Sugerir artigos da BC';
$hesklang['s_spop']='Exibir artigos populares';
$hesklang['s_slat']='Exibir últimos artigos';
$hesklang['s_onin']='na página principal da <a href="../" target="_blank">central de suporte</a>';
$hesklang['s_onkb']='na página principal da <a href="../knowledgebase.php" target="_blank">base de conhecimento</a>';
$hesklang['s_scol']='Categorias em linha';
$hesklang['s_ptxt']='Tamanho da visualização do artigo';
$hesklang['s_psubart']='Artigos da subcategoria';
$hesklang['enable']='Habilitar';
$hesklang['s_type']='Tipo';
$hesklang['custom_r']='Obrigatório';
$hesklang['custom_place']='Local';
$hesklang['custom_use']='Campos personalizados';
$hesklang['stf']='Campo de texto';
$hesklang['stb']='Campo de texto grande';
$hesklang['srb']='Botão de opção';
$hesklang['ssb']='Caixa de combinação';
$hesklang['db']='Banco de dados';
$hesklang['hd']='Configurações da central de suporte';
$hesklang['gs']='Configurações gerais';
$hesklang['cwin']='Fechar janela';
$hesklang['defw']='Valor padrão';
$hesklang['ok']='OK';
$hesklang['ns']='Essas são as opções disponíveis para este campo personalizado. Para salvar alterações clique em <b>OK</b> e no botão <b>Salvar alterações</b> na página de configurações do administrador!';
$hesklang['rows']='Linhas (altura)';
$hesklang['cols']='Colunas (largura)';
$hesklang['opt2']='Opções para este botão de opção, digite uma opção por linha (cada linha criará uma nova opção de escolha no botão de opção). Você precisa digitar pelo menos duas opções!';
$hesklang['opt3']='Opções para esta caixa de combinação, digite uma opção por linha (cada linha será uma opção que seus clientes podem escolher). Você precisa digitar pelo menos duas opções!';
$hesklang['atl2']='Digite pelo menos duas opções (uma por linha)!';
$hesklang['notes']='Observações';
$hesklang['addnote']='+ Adicionar observação';
$hesklang['noteby']='Observação por';
$hesklang['delnote']='Remover observação';
$hesklang['noteerr']='Observação já removida ou parâmetros errados';
$hesklang['s']='Enviar';
$hesklang['nhid']='As observações não são exibidas aos clientes!';
$hesklang['delt']='Remover este post';
$hesklang['edtt']='Editar post';
$hesklang['edt1']='Post modifcado';
$hesklang['edt2']='As alterações no post selecionado foram salvas';
$hesklang['dele']='Remover este chamado';
$hesklang['repd']='Post removido';
$hesklang['repl']='O post selecionado foi removido';
$hesklang['tickets_found']='Resultados da pesquisa';
$hesklang['al']='Link do admin';
$hesklang['ap']='Ir ao painel administrativo';
$hesklang['dap']='Exibir um link para o painel administrativo na <a href="../" target="_blank">página principal da central de suporte</a>';
$hesklang['q_miss']='Por favor, responda a pergunta anti-SPAM';
$hesklang['use_q']='Usar pergunta anti-SPAM';
$hesklang['q_q']='-&gt; Pergunta (código HTML é <font class="success">permitido</font>)';
$hesklang['q_a']='-&gt; Resposta';
$hesklang['err_qask']='Digite uma pergunta anti-SPAM';
$hesklang['err_qans']='Digite uma resposta para a pergunta anti-SPAM';
$hesklang['genq']='Gerar uma pergunta aleatória';

// Added in version 2.1
$hesklang['amo']='Adicionar mais';
$hesklang['delatt']='Remover anexo selecionado?';
$hesklang['kb_att_rem']='O anexo selecionado foi removido';
$hesklang['inv_att_id']='Identificação do anexo inválida!';
$hesklang['scb']='Caixa de seleção';
$hesklang['opt4']='Opções para esta caixa de seleção, digite uma opção por linha. Cada linha será uma opção que seus clientes podem selecionar, múltiplas escolhas são possíveis.';
$hesklang['autologin']='Permanecer conectado automaticamente a cada visita';
$hesklang['just_user']='Lembrar apenas meu usuário';
$hesklang['nothx']='Não, obrigado';
$hesklang['pinfo']='Informação do perfil';
$hesklang['sig']='Assinatura';
$hesklang['pref']='Preferências';
$hesklang['aftrep']='Após responder a um chamado';
$hesklang['showtic']='Exibir o chamado que eu acabei de responder';
$hesklang['gomain']='Retornar a página principal da administração';
$hesklang['shownext']='Abrir o próximo chamado que precisa de minha resposta';
$hesklang['rssn']='Exibindo o próximo chamado que precisa de sua atenção';
$hesklang['mrep']='Substituir mensagem';
$hesklang['madd']='Adicionar a parte inferior';
$hesklang['priv']='Categorias e artigos privados visíveis apenas pela equipe são marcados com *';
$hesklang['inve']='Arquivo de e-mail inválido';
$hesklang['emfm']='Arquivo de e-mail não encontrado';
$hesklang['hesk_lang']='Idioma padrão';
$hesklang['s_mlang']='Múltiplos idiomas';
$hesklang['s_mlange']='Habilite apenas se você fornece suporte em todos os idiomas instalados!';
$hesklang['s_inl']='Testar pasta de idioma';
$hesklang['s_inle']='Testando a pasta de idioma por idiomas válidos. Apenas idiomas que passem todos os testes são devidamente instalados.';
$hesklang['ta']='Testar novamente';
$hesklang['alo']='Permitir login automático';
$hesklang['chol']='Idioma preferencial';
$hesklang['mmdl']='Defina este idioma o meu preferencial';
$hesklang['warn']='ATENÇÃO';
$hesklang['dmod']='Modo de depuração está habilitado. Certifique-se de desabilitar o modo de depuração assim que o HESK estiver instalado e funcionando adequadamente.';
$hesklang['kb_spar']='A categoria não pode ser sua própria categoria pai!';
$hesklang['mysql_root']='Sua senha do MySQL está vazia, você tem certeza de que deseja entrar com o usuário root? Isto é um risco de segurança significativo!';
$hesklang['chg']='Alterar';
$hesklang['chpri']='Prioridade alterada';
$hesklang['chpri2']='A prioridade do chamado foi alterada para %s';
$hesklang['selcan']='Selecione a resposta automática que deseja editar';
$hesklang['q_wrng']='Resposta anti-SPAM errada';
$hesklang['cndupl']='Você já possui uma categoria com este nome. Escolha um nome único para cada categoria.';
$hesklang['wsel']='Selecione o campo pelo qual você deseja pesquisar';

// Added in version 2.2
$hesklang['eto']='Requisição inválida';
$hesklang['id']='Identificação';
$hesklang['geco']='Gerar link direto';
$hesklang['genl']='Link direto da categoria';
$hesklang['genl2']='Usar este link para pré-selecionar a categoria no formulário &quot;Enviar um chamado&quot;.';
$hesklang['ask']='Pesquisar na ajuda:';
$hesklang['exa']='Exemplos';
$hesklang['small']='Caixa pequena';
$hesklang['large']='Caixa grande';
$hesklang['cpri']='Prioridade do cliente';
$hesklang['owner']='Responsável';
$hesklang['unas']='Não atribuído';
$hesklang['assi']='Atribuir';
$hesklang['asst']='Atribuir a';
$hesklang['asst2']='Atribuir este chamado a';
$hesklang['asss']='Atribuir a si próprio';
$hesklang['asss2']='Atribuir este chamado a si próprio';
$hesklang['can_assign_self']='Pode atribuir chamados a si próprio';
$hesklang['can_assign_others']='Pode atribuir chamados a outros';
$hesklang['can_run_reports']='Pode executar relatórios (próprios)';
$hesklang['can_view_ass_others']='Pode ver chamados atribuídos a outros';
$hesklang['unoa']='O usuário selecionado não possui acesso a esta categoria';
$hesklang['tasi']='Responsável atribuído';
$hesklang['tasy']='Este chamado foi atribuído a você';
$hesklang['taso']='Este chamado foi atribuído ao usuário selecionado';
$hesklang['tasy2']='Atribuído a mim';
$hesklang['taso2']='Atribuído a outro membro da equipe';
$hesklang['nose']='Selecione o novo responsável';
$hesklang['onasc']='Este responsável não possui acesso a categoria selecionada.';
$hesklang['tunasi']='Chamado não atribuído';
$hesklang['tunasi2']='O chamado está sem um responsável e pronto para ser atribuído novamente';
$hesklang['note']='Observação';
$hesklang['success']='Sucesso';
$hesklang['nyt']='Este chamado está atribuído a';
$hesklang['noch']='Nenhuma alteração foi feita';
$hesklang['orch']='A ordem de exibição foi alterada';
$hesklang['rfm']='Informação obrigatória faltando:';
$hesklang['repl0']='Permissões insuficientes para executar esta tarefa';
$hesklang['repl1']='Este post não existe';
$hesklang['reports']='Relatórios';
$hesklang['reports_intro']='A seção de relatórios lhe permite executar vários relatórios e ver estatísticas de chamados em um período de datas selecionado.';
$hesklang['refi']='Redefinir dados do formulário';
$hesklang['dich']='Descartar alterações';
$hesklang['dire']='Exibir relatório';
$hesklang['m1']='Janeiro';
$hesklang['m2']='Fevereiro';
$hesklang['m3']='Março';
$hesklang['m4']='Abril';
$hesklang['m5']='Maio';
$hesklang['m6']='Junho';
$hesklang['m7']='Julho';
$hesklang['m8']='Agosto';
$hesklang['m9']='Setembro';
$hesklang['m10']='Outubro';
$hesklang['m11']='Novembro';
$hesklang['m12']='Dezembro';
$hesklang['d1']='Segunda-feira';
$hesklang['d2']='Terça-feira';
$hesklang['d3']='Quarta-feira';
$hesklang['d4']='Quinta-feira';
$hesklang['d5']='Sexta-feira';
$hesklang['d6']='Sábado';
$hesklang['d0']='Domingo';
$hesklang['mo']='Seg';
$hesklang['tu']='Ter';
$hesklang['we']='Qua';
$hesklang['th']='Qui';
$hesklang['fr']='Sex';
$hesklang['sa']='Sáb';
$hesklang['su']='Dom';
$hesklang['from']='De';
$hesklang['cinv']='Data inválida';
$hesklang['cinv2']='O formato aceito é mm/dd/aaaa';
$hesklang['cinm']='Valor do mês inválido';
$hesklang['cinm2']='Intervalo permitido é';
$hesklang['cind']='Valor do dia do mês inválido';
$hesklang['cind2']='Intervalo permitido para o mês selecionado é';
$hesklang['month']='Mẽs';
$hesklang['ocal']='Abrir calendário';
$hesklang['ca01']='Ano anterior';
$hesklang['ca02']='Mês anterior';
$hesklang['ca03']='Próximo mês';
$hesklang['ca04']='Próximo ano';
$hesklang['ca05']='Fechar calendário';
$hesklang['cdr']='Escolher intervalo de data:';
$hesklang['crt']='Tipo de relatório';
$hesklang['r1']='Hoje';
$hesklang['r2']='Ontem';
$hesklang['r3']='Este mês';
$hesklang['r4']='Último mês';
$hesklang['r5']='Últimos 30 dias';
$hesklang['r6']='Esta semana (Seg-Dom)';
$hesklang['r7']='Última semana (Seg-Dom)';
$hesklang['r8']='Esta semana de trabalho (Seg-Sex)';
$hesklang['r9']='Última semana de trabalho (Seg-Sex)';
$hesklang['r10']='Este ano';
$hesklang['r11']='Último ano';
$hesklang['r12']='Desde o início';
$hesklang['datetofrom']='&quot;Data de&quot; não pode ser maior que &quot;Data até&quot;. As datas foram invertidas.';
$hesklang['t1']='Chamados por dia';
$hesklang['t2']='Chamados por mês';
$hesklang['t3']='Chamados por usuário';
$hesklang['t4']='Chamados por categoria';
$hesklang['ticass']='Chamados atribuídos';
$hesklang['ticall']='Respondeu aos chamados';
$hesklang['totals']='Totais';
$hesklang['all']='Todos';
$hesklang['atik']='Novos chamados';
$hesklang['kbca']='Você já possui uma categoria na base de conhecimento com este nome.';
$hesklang['menu_msg']='Mensagens';
$hesklang['menu_can']='Respostas automáticas';
$hesklang['m_from']='De:'; // Mail "from" address
$hesklang['m_to']='Para:'; // Mail "to" address
$hesklang['m_sub']='Assunto:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Enc:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Mensagens privadas';
$hesklang['m_intro']='Use as mensagens privadas para enviar mensagens rápidas para outros membros da equipe dentro do HESK.';
$hesklang['e_udel']='(Usuário removido)';
$hesklang['new_mail']='Nova mensagem privada';
$hesklang['m_send']='Enviar mensagem';
$hesklang['m_rec']='Selecionar o destinatário da mensagem';
$hesklang['m_inr']='Destinatário da mensagem inválido';
$hesklang['m_esu']='Digite o assunto da mensagem privada';
$hesklang['m_pms']='Sua mensagem privada foi enviada';
$hesklang['inbox']='CAIXA DE ENTRADA';
$hesklang['outbox']='CAIXA DE SAÍDA';
$hesklang['m_new']='NOVA MENSAGEM';
$hesklang['pg']='Exibir página';
$hesklang['npm']='Nenhuma mensagem privada nesta pasta.';
$hesklang['m_ena']='Você não tem permissão para ler esta mensagem.';
$hesklang['mau']='Marcar como não lida';
$hesklang['mo1']='Marcar mensagens selecionadas como lidas';
$hesklang['mo2']='Marcar mensagens selecionadas como não lidas';
$hesklang['mo3']='Remover mensagens selecionadas';
$hesklang['delm']='Remover esta mensagem';
$hesklang['e_tid']='Erro ao gerar um código de identificação único para o chamado, por favor tente enviar o formulário novamente mais tarde.';
$hesklang['smmr']='As mensagens selecionadas foram marcadas como lidas';
$hesklang['smmu']='As mensagens selecionadas foram marcadas como não lidas';
$hesklang['smdl']='As mensagens selecionadas foram removidas';
$hesklang['show']='Exibir';
$hesklang['s_my']='Atribuído a mim';
$hesklang['s_ot']='Atribuído a outros';
$hesklang['s_un']='Chamados não atribuídos';
$hesklang['s_for']='Pesquisar por';
$hesklang['s_in']='Pesquisar em';
$hesklang['s_incl']='Pesquisar dentro';
$hesklang['find_ticket_by']='Encontrar um chamado';
$hesklang['e_nose']='Nenhum status de atribuição selecionado, exibindo todos os chamados.';
$hesklang['fsq']='Digite seu termo de pesquisa';
$hesklang['topen']='Aberto';
$hesklang['nms']='Nenhuma mensagem selecionada, nada a alterar';
$hesklang['tlo']='Bloquear chamado';
$hesklang['tul']='Desbloquear chamado';
$hesklang['loc']='Bloqueado';
$hesklang['isloc']='Os clientes não podem responder ou reabrir chamados bloqueados. Quando bloqueado o chamado é marcada como resolvido.';
$hesklang['tlock']='O chamado foi bloqueado';
$hesklang['tunlock']='O chamado foi desbloqueado';
$hesklang['tislock']='Este chamado foi bloqueado, o cliente não poderá postar uma resposta.';
$hesklang['tislock2']='Este chamado foi bloqueado, você não pode postar uma resposta.';
$hesklang['nsfo']='Nenhum artigo relevante encontrado.';
$hesklang['thist1']='<li class="smaller">%s | movido para a categoria %s por %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | atribuído a %s por %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | fechado por %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | aberto por %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | bloqueado por %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | desbloqueado por %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | chamado criado por %s</li>'; // %s = date, user making change
$hesklang['elocked']='Este chamado foi bloqueado ou removido.';
$hesklang['nti2']='Inserir um novo chamado';
$hesklang['nti3']='Use este formulário para criar um novo chamado em nome do cliente. Digite as informações do <i>cliente</i> no formulário (nome do cliente, e-mail do cliente, ...) e NÃO seu nome! O chamado será criado como se o cliente o tivesse enviado.';
$hesklang['addop']='Opções';
$hesklang['seno']='Enviar notificação por e-mail ao cliente';
$hesklang['otas']='Exibir o chamado após o envio';
$hesklang['notn']='Notificações';
$hesklang['nomw']='A central de suporte enviará uma notificação por e-mail quando:';
$hesklang['nwts']='Um novo chamado for enviado com um responsável:';
$hesklang['ncrt']='O cliente responde a um chamado com um responsável:';
$hesklang['ntam']='Um chamado é atribuído a mim';
$hesklang['npms']='Uma mensagem privada é enviada para mim';
$hesklang['support_remove']='Muito tempo e esforço foram gastos no desenvolvimento do HESK. Ajude o HESK comprando uma licença que removerá os links de crédito <i>Powered by Help Desk Software HESK</i> de sua central de suporte';
$hesklang['ycvtao']='Você não possui permissão para ver chamados atribuídos a outros';
$hesklang['password_not_valid']='A senha deve ter pelo menos 5 caracteres de comprimento';
$hesklang['lkbs']='Carregando sugestões da base de conhecimento...';
$hesklang['auto']='(automaticamente)';

// Added in version 2.3
$hesklang['unknown']='Desconhecido';
$hesklang['pcer']='Por favor, corrija os seguintes erros:';
$hesklang['seqid']='Número do chamado';
$hesklang['close_action']='Marcar como resolvido'; // Close ACTION
$hesklang['archived']='Arquivado';
$hesklang['archived2']='Chamado arquivado';
$hesklang['add_archive']='Arquivar este chamado';
$hesklang['add_archive_quick']='Arquivar chamados selecionados';
$hesklang['remove_archive']='Desarquivar este chamado';
$hesklang['remove_archive_quick']='Desarquivar chamados selecionados';
$hesklang['added_archive']='Chamado arquivado';
$hesklang['removed_archive']='Chamado desarquivado';
$hesklang['added2archive']='O chamado foi arquivado';
$hesklang['removedfromarchive']='O chamado foi desarquivado';
$hesklang['num_tickets_tag']='<b>%d</b> chamados foram arquivados';
$hesklang['num_tickets_untag']='<b>%d</b> chamados foram desarquivados';
$hesklang['can_add_archive']='Pode arquivar chamados';
$hesklang['disp_only_archived']='Apenas chamados arquivados';
$hesklang['search_only_archived']='Apenas chamados arquivados';
$hesklang['critical']=' * Crítico * ';
$hesklang['thist8']='<li class="smaller">%s | prioridade alterada para %s por %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | status alterado para %s por %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | atribuído automaticamente a %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | enviado pela fila por e-mail</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='ano';
$hesklang['abbr']['month']='mês';
$hesklang['abbr']['week']='sem';
$hesklang['abbr']['day']='d';
$hesklang['abbr']['hour']='h';
$hesklang['abbr']['minute']='m';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='Não foi possível enviar a mensagem para:';
$hesklang['yhbb']='Você foi bloqueado pelo sistema por %s minutos devido a muitas falhar ao tentar logar.';
$hesklang['pwdst']='Força da senha';
$hesklang['tid_mail']='Não se preocupe! Digite seu <b>endereço de e-mail</b> e lhe enviaremos seu código de identificação imediatamente:';
$hesklang['rem_email']='Lembre meu endereço de e-mail';
$hesklang['eytid']='Digite seu código de identificação do chamado.';
$hesklang['enmdb']='O endereço de e-mail que você digitou não corresponde ao existente em nosso banco de dados para a identificação deste chamado.';
$hesklang['confemail']='Confirmar e-mail';
$hesklang['confemail2']='Por favor, confirme seu endereço de e-mail';
$hesklang['confemaile']='Os dois endereços de e-mail não são idênticos';
$hesklang['taso3']='Atribuído a:';
$hesklang['sec_enter']='Digite o número que você vê na imagem abaixo.';
$hesklang['reload']='Recarregar imagem';
$hesklang['verify_q']='Prevenção de SPAM:'; // For anti-spam question
$hesklang['verify_i']='Prevenção de SPAM:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Login da equipe';
$hesklang['vrfy']='Passou no teste';
$hesklang['last_update']='Atualizado';
$hesklang['cot']='Não forçar chamados críticos no topo';
$hesklang['def']='Defina esta minha visualização padrão';
$hesklang['gbou']='Este chamados estão <b>não atribuídos</b>:';
$hesklang['gbom']='Chamados atribuídos a <b>mim</b>:';
$hesklang['gboo']='Chamados atribuídos a <b>%s</b>:';
$hesklang['select']=' - - Clique para selecionar - - ';
$hesklang['chngstatus']='Alterar status para';
$hesklang['perat']='%s de todos os chamados'; // Will change to "23% of all tickets"
$hesklang['viewart']='Ver este artigo';
$hesklang['chdp']='Por favor, altera a senha padrão em sua página de <a href="profile.php">Perfil</a>!';
$hesklang['chdp2']='Altere sua senha, você está usando a padrão!';
$hesklang['security']='Segurança';
$hesklang['kb_i_art']='Novo artigo';
$hesklang['kb_i_art2']='Inserir um artigo';
$hesklang['kb_i_cat']='Nova categoria';
$hesklang['kb_i_cat2']='Inserir uma categoria';
$hesklang['gopr']='Ver base de conhecimento';
$hesklang['kbstruct']='Estrutura da base de conhecimento';
$hesklang['cancel']='Cancelar';
$hesklang['sh']='Ocultar mensagem';
$hesklang['goodkb']='Como escrever bons artigos para a base de conhecimento?';
$hesklang['catset']='Configurações da categoria';
$hesklang['inpr']='Selecionar a nova prioridade';
$hesklang['incat']='Selecionar a nova categoria';
$hesklang['instat']='Selecione o novo status';
$hesklang['tsst']='O status do chamado foi definido como %s';
$hesklang['aass']='Atribuir automaticamente';
$hesklang['aaon']='Atribuição automática de chamados habilitada (clique para desabilitar)';
$hesklang['aaoff']='Atribuição automática de chamados desabilitada (clique para habilitar)';
$hesklang['uaaon']='A atribuição automática foi habilitada para o usuário selecionado';
$hesklang['uaaoff']='A atribuição automática foi desabilitada para o usuário selecionado';
$hesklang['taasy']='Este chamado foi atribuído automaticamente a você';
$hesklang['can_view_unassigned']='Pode ver chamados não atribuídos';
$hesklang['ycovtay']='Você pode visualizar apenas chamados atribuídos a você';
$hesklang['in_progress']='Em progresso';
$hesklang['on_hold']='Em espera';
$hesklang['import_kb']='Importar este chamado em um artigo da base de conhecimento';
$hesklang['import']='Você está importando um <i>chamado privado</i> em um <i>artigo público</i>.<br /><br />Certifique-se de remover qualquer informação privada ou sensível do assunto ou da mensagem do artigo!';
$hesklang['tab_1']='Geral';
$hesklang['tab_2']='Central de suporte';
$hesklang['tab_3']='Base de conhecimento';
$hesklang['tab_4']='Campos personalizados';
$hesklang['tab_5']='Outros';
$hesklang['disable']='Desativar';
$hesklang['dat']='Data &amp; Hora';
$hesklang['lgs']='Idioma';
$hesklang['onc']='LIGADO - Clientes';
$hesklang['ons']='LIGADO - Todos';
$hesklang['viewvtic']='Visualizar chamados';
$hesklang['reqetv']='Exigir e-mail para visualizar um chamado';
$hesklang['banlim']='Limite de tentativas de login';
$hesklang['banmin']='Tempo de banimento (minutos)';
$hesklang['subnot']='Aviso de envio';
$hesklang['subnot2']='Exibir aviso aos clientes enviando chamados';
$hesklang['eseqid']='Identificações sequenciais';
$hesklang['sconfe']='Confirmar e-mail';
$hesklang['saass']='Atribuir automaticamente chamados';
$hesklang['swyse']='Editor WYSIWYG';
$hesklang['hrts']='Avaliar o HESK';
$hesklang['hrts2']='Exibir o link Avalie este script no painel administrativo';
$hesklang['emlpipe']='Filar por e-mail';
$hesklang['emlsend2']='Enviar e-mail usando';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='Servidor SMTP';
$hesklang['smtph']='Endereço SMTP';
$hesklang['smtpp']='Porta SMTP';
$hesklang['smtpu']='Usuário SMTP';
$hesklang['smtpw']='Senha SMTP';
$hesklang['smtpt']='Tempo de espera do SMTP';
$hesklang['other']='Outro';
$hesklang['features']='Recursos';
$hesklang['can_view_online']='Pode ver membros da equipe on-line';
$hesklang['online']='On-line';
$hesklang['offline']='Off-line';
$hesklang['onlinep']='Usuários on-line'; // For display in footer
$hesklang['sonline']='Usuários on-line'; // For settings page
$hesklang['sonline2']='Exibir usuários on-line. Limite (minutos):'; // For settings page
$hesklang['gb']='Agrupar por';
$hesklang['dg']='Não agrupar';
$hesklang['err_dpi']='O banco de dados %s não contém todas as tabelas do HESK com o prefixo %s, nenhuma alteração salva.';
$hesklang['err_dpi2']='Tabelas não encontradas:';
$hesklang['sme']='Erro no SMTP';
$hesklang['scl']='Registro de conexão do SMTP';
$hesklang['dnl']='Baixar';
$hesklang['dela']='Remover este anexo';
$hesklang['pda']='Você deseja remover permanentemente este anexo?';
$hesklang['thist12']='<li class="smaller">%s | anexo %s removido por %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Mais opções';
$hesklang['lopt']='Menos opções';
$hesklang['meml']='Múltiplos e-mails';
$hesklang['meml2']='Permitir aos clientes digitar múltiplos e-mails de contato';

// Added in version 2.4
$hesklang['catd']='(categoria removida)';
$hesklang['noopen']='Nenhum chamado aberto encontrado para este endereço de e-mail.';
$hesklang['maxopen']='Você atingiu o máximo de chamados abertos (%d de %d). Por favor, aguarde até que seus chamados existentes sejam resolvidos antes de abrir novos chamados.';
$hesklang['ntnote']='Alguém adiciona uma observação a um chamado atribuído a mim';
$hesklang['cat_public']='Esta categoria é PÚBLICA (clique para tornar privada)';
$hesklang['cat_private']='Esta categoria é PRIVADA (cliaud para tornar pública)';
$hesklang['cat_aa']='Atribuir automaticamente chamados nesta categoria.';
$hesklang['cat_type']='Tornar esta categoria privada (apenas a equipe pode selecioná-la).';
$hesklang['caaon']='A atribuição automática foi habilitada para a categoria selecionada';
$hesklang['caaoff']='A atribuição automática foi desabilitada para a categoria selecionada';
$hesklang['cpub']='Tipo da categoria alterado para PÚBLICA';
$hesklang['cpriv']='Tipo da categoria alterado para PRIVADA';
$hesklang['cpric']='Os clientes não podem selecionar categorias privadas, apenas a equipe pode!';
$hesklang['user_aa']='Atribuir automaticamente chamados a este usuário.';
$hesklang['attach_size']='Tamanho máximo do arquivo';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='Protocolo SSL';
$hesklang['smtptls']='Protocolo TLS';
$hesklang['oo']='Apenas abertos';
$hesklang['ool']='Listar apenas chamados aberto no e-mail &quot;Esqueceu seu código de identificação&quot;';
$hesklang['mop']='Máximo de chamados abertos';
$hesklang['rord']='Ordem das respostas';
$hesklang['newbot']='Resposta mais recente no final';
$hesklang['newtop']='Resposta mais recente no topo';
$hesklang['ford']='Formulário de resposta';
$hesklang['formbot']='Exibir formulário na parte inferior';
$hesklang['formtop']='Exibir formulário no topo';
$hesklang['mysqlv']='Versão do MySQL';
$hesklang['phpv']='Versão do PHP';
$hesklang['csrt']='Hora atual do HESK:';
$hesklang['listp']='Listar artigos privados';
$hesklang['listd']='Listar rascunhos de artigos';
$hesklang['artp']='Artigos privados';
$hesklang['artd']='Rascunhos de artigos';
$hesklang['kb_no_part']='Nenhum artigo privado na base de conhecimento.';
$hesklang['kb_no_dart']='Nenhum rascunho de artigo na base de conhecimento.';
$hesklang['attpri']='Você não tem acesso a este anexo.';
$hesklang['can_merge_tickets']='Unificar chamados';
$hesklang['mer_selected']='Unificar chamados selecionados';
$hesklang['merged']='Os chamados selecionados foram unificados em um.';
$hesklang['merge_err']='Houve um problema ao unificar os chamados:';
$hesklang['merr1']='selecione pelo menos dois chamados.';
$hesklang['merr2']='chamado alvo não encontrado.';
$hesklang['merr3']='chamado em uma categoria que você não possui acesso.';
$hesklang['tme']='O chamado %s foi unificado com este chamado (%s).';
$hesklang['tme1']='O chamado %s foi unificado com o chamado %s';
$hesklang['tme2']='Para acessar o chamado %s dihite o endereço de e-mail associado.';
$hesklang['eyou']='Use a página de ṕerfil para editar suas configurações.';
$hesklang['npea']='Você não tem permissão para editar este usuário.';
$hesklang['duplicate_user']='Um usuário com este nome já existe, escolha um nome diferente.';
$hesklang['kw']='Palavras-chave';
$hesklang['kw1']='(opcional - separado por espaço, vírgula ou uma nova linha)';
$hesklang['type_not_allowed']='Arquivos terminando com <b>%s</b> não são aceitos (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='O cliente ainda não leu esta resposta.';
$hesklang['sticky']='Definir este artigo como &quot;Relevante&quot;';
$hesklang['stickyon']='Alterar artigo para &quot;Relevante&quot;';
$hesklang['stickyoff']='Alterar artigo para &quot;Normal&quot;';
$hesklang['ason']='Artigo marcado como &quot;Relevante&quot;';
$hesklang['asoff']='Artigo marcado como &quot;Normal&quot;';
$hesklang['ts']='Tempo dedicado';
$hesklang['start']='Iniciar / Parar';
$hesklang['reset']='Reiniciar';
$hesklang['save']='Salvar';
$hesklang['hh']='Horas';
$hesklang['mm']='Minutos';
$hesklang['ss']='Segundos';
$hesklang['thist']='Histórico do chamado';
$hesklang['thist13']='<li class="smaller">%s | unido com chamado %s por %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | tempo dedicado atualizado para %s por %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | enviado por %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | enviado por busca em POP3</li>';
$hesklang['twu']='O tempo dedicado ao chamado foi atualizado.';
$hesklang['autoss']='Iniciar automaticamente o contador quando eu abrir um chamado';
$hesklang['ful']='Limites de envio de arquivo';
$hesklang['ufl']='Você pode enviar arquivos que terminem em:';
$hesklang['nat']='Número máximo de anexos:';
$hesklang['mfs']='Tamanho máximo por anexo:';
$hesklang['lps']='Sua preferência de idioma foi salva';
$hesklang['sav']='Exibir visualizações do artigo';
$hesklang['sad']='Exibir data do artigo';
$hesklang['emp']='Seu PHP não possui suporte ao MySQL habilitado (necessário a extensão mysqli)';
$hesklang['epd']='[HESK] FILA POR E-MAIL ESTÁ DESABILITADA NAS CONFIGURAÇÕES';
$hesklang['pfd']='[HESK] BUSCA EM POP3 ESTÁ DESABILITADA NAS CONFIGURAÇÕES';
$hesklang['pem']='[Fila por e-mail]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Cliente]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-mail';
$hesklang['pop3']='Busca em POP3';
$hesklang['pop3h']='Servidor POP3';
$hesklang['pop3p']='Porta POP3';
$hesklang['pop3tls']='Protocolo TLS';
$hesklang['pop3u']='Usuário POP3';
$hesklang['pop3w']='Senha POP3';
$hesklang['pop3e']='Erro no POP3';
$hesklang['pop3log']='Registro de conexão do POP3';
$hesklang['mysqltest']='Testar conexão MySQL';
$hesklang['smtptest']='Testar conexão SMTP';
$hesklang['pop3test']='Testar conexão POP3';
$hesklang['contest']='Testando conexão, isto pode levar um tempo...';
$hesklang['conok']='Conectado com sucesso!';
$hesklang['conokn']='Entretanto, se seu servidor exigir usuário e senha o e-mail não será enviado!';
$hesklang['saving']='Salvando configurações, por favor aguarde...';
$hesklang['sns']='As configurações foram salvas, mas algumas funções foram desabilitadas devido a falhas nos testes.';
$hesklang['looph']='Máximo de envios';
$hesklang['loopt']='Intervalo de tempo';
$hesklang['didum']='Você quis dizer %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Sim, corrija';
$hesklang['nole']='Não, deixe assim';
$hesklang['sconfe2']='Exibir um campo &quot;Confirmar e-mail&quot; no formulário de envio de chamado';
$hesklang['oln']='Nome antigo:';
$hesklang['nen']='Novo nome:';
$hesklang['use_form_below']='<i>Use este formulário para enviar um pedido de suporte. Campos obrigatórios estão marcados com</i>';
$hesklang['esf']='Não foi possível enviar notificações por e-mail.';
$hesklang['qrr']='(resposta citada removida)';
$hesklang['remqr']='Remover citações nas respostas';
$hesklang['remqr2']='Remover citações nas respostas dos e-mails dos clientes';
$hesklang['suge']='Detectar erros de e-mail';
$hesklang['epro']='Provedores de e-mail';
$hesklang['email_noreply']='&quot;De:&quot; e-mail';
$hesklang['email_name']='&quot;De:&quot; nome';
$hesklang['vscl']='Limites de configuração do servidor';
$hesklang['fnuscphp']='Envio do arquivo falhou, tente com um arquivo menor ou sem nenhum anexo.';
$hesklang['redv']='restaurar visualização padrão';
$hesklang['fatte1']='Sua configuração de anexos &quot;Número por post&quot; é maior que o permitido pelo seu servidor!';
$hesklang['fatte2']='Seu tamanho máximo de arquivo de arquivo anexado é maior que o permitido pelo seu servidor!';
$hesklang['fatte3']='Seu servidor não permite posts longos o suficiente, tente reduzir o número de anexos ou o tamanho máximo permitido!';
$hesklang['embed']='Arquivos incorporados';
$hesklang['embed2']='Salvar arquivos incorporados como anexos';
$hesklang['emrem']='(imagem removida)';
$hesklang['hdemo']='(OCULTO NA DEMONSTRAÇÃO)';
$hesklang['ddemo']='Desculpe, esta função está desabilitada no mode de DEMONSTRAÇÃO!';
$hesklang['sdemo']='Salvar alterações foi desabilitado no modo de DEMONSTRAÇÃO';
$hesklang['hud']='HESK está atualizado';
$hesklang['hnw']='Atualização disponível';
$hesklang['getup']='Atualizar HESK';
$hesklang['updates']='Atualizações';
$hesklang['updates2']='Verificar automaticamente atualizações do HESK.';

// Added in version 2.5.0
$hesklang['attdel']='Este arquivo foi removido do servidor e não está mais disponível para ser baixado';
$hesklang['dsen']='Não enviar notificação por e-mail desta resposta ao cliente';
$hesklang['attrem']='* Alguns arquivos anexados foram removidos *';
$hesklang['attnum']='Número máximo atingido: %s'; // %s will show attachment name
$hesklang['attsiz']='Arquivo muito grande: %s'; // %s will show attachment name
$hesklang['atttyp']='Tipo não permitido: %s'; // %s will show attachment name
$hesklang['adf']='Pasta de administração';
$hesklang['atf']='Pasta de anexos';
$hesklang['err_adf']='A pasta de administração selecionada (%s) não existe!'; // %s will show folder name
$hesklang['err_atf']='A pasta de anexos selecionada (%s) não existe!'; // %s will show folder name
$hesklang['err_atr']='A pasta de anexos selecionada (%s) não é gravável!'; // %s will show folder name
$hesklang['fatt']='Arquivos anexados a esta mensagem:';
$hesklang['wrepo']='Por favor, escreva uma resposta após reabrir o chamado.';
$hesklang['ktool']='&raquo; Ferramentas da base de conhecimento';
$hesklang['uac']='Verificar e atualizar contagem de artigos da categoria';
$hesklang['acv']='A contagem de artigos foi verificada';
$hesklang['xyz']='número de artigos públicos, privados e rascunhos na categoria.';
$hesklang['reports_tab']='Executar relatórios'; // Tab title
$hesklang['can_run_reports_full']='Pode executar relatórios (todos)';
$hesklang['can_export']='Pode exportar chamados';
$hesklang['roo']='<i>(apenas chamados atribuídos a você estão incluídos no relatório)</i>';
$hesklang['shu']='Links curtos';
$hesklang['export']='Exportar chamados'; // Tab title
$hesklang['export_btn']='Exportar chamados'; // Button title
$hesklang['export_intro']='Esta ferramenta permite a você exportar os chamados em uma planilha XML que pode ser aberta no Excel.';
$hesklang['stte']='Selecionar chamados para exportar';
$hesklang['dtrg']='Intervalo de data';
$hesklang['sequentially']='Sequencialmente'; // Order tickets: Sequentially
$hesklang['ede']='Não foi possível criar o diretório de exportação, por favor crie manualmente um diretório nomeado <b>export</b> dentro de sua pasta de anexos e certifique-se de que ele seja gravável pelo PHP (no Linux use o CHMOD nele para 777 - rwxrwxrwx).';
$hesklang['eef']='Não foi possível criar o arquivo de exportação, não há permissões de gravação dentro do diretório de exportação.';
$hesklang['inite']='Inicializando exportação';
$hesklang['gXML']='Gerando arquivo XML';
$hesklang['nrow']='Número de linhas exportadas: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Compactando o arquivo em um Zip';
$hesklang['eZIP']='Erro ao criar o arquivo Zip';
$hesklang['fZIP']='Término da compactação do arquivo';
$hesklang['pmem']='Pico do uso de memória: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; CLIQUE AQUI PARA BAIXAR O ARQUIVO DE EXPORTAÇÃO &laquo;';
$hesklang['n2ex']='Nenhum chamado encontrado correspondendo ao seu critério, nada a exportar!';
$hesklang['sp']='Prevenção de SPAM'; // For settings page
$hesklang['sit']='-&gt; Tipo de imagem';
$hesklang['sis']='Imagem simples';
$hesklang['rcpb']='Chave do site (Chave pública)';
$hesklang['rcpv']='Chave secreta (Chave privada)';
$hesklang['pop3keep']='Manter uma cópia';
$hesklang['beta']='(VERSÃO DE TESTES)';
$hesklang['maxpost']='Você provavelmente tentou enviar mais dados do que este servidor aceita.<br /><br />Por favor, tente enviar o formulário novamente com anexos menores ou sem nenhum.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Resposta a prevenção de SPAM incorreta, por favor tente novamente.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Chamado fechado/resolvido';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Fev';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Abr';
$hesklang['ms05']='Mai';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Ago';
$hesklang['ms09']='Set';
$hesklang['ms10']='Out';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dez';
$hesklang['sdf']='Formato de data enviado';
$hesklang['lcf']='Formato de data atualizado';
$hesklang['lcf0']='Breve descritivo';
$hesklang['lcf1']='Data e hora';
$hesklang['lcf2']='Padrão HESK';
$hesklang['ticket_tpl']='Modelos de chamados';
$hesklang['can_man_ticket_tpl']='Gerenciar modelos de chamados'; // Permission title
$hesklang['ticket_tpl_man']='Gerenciar modelos de chamados'; // Page and link title
$hesklang['ticket_tpl_intro']='Crie e edite modelos de chamados que você pode usar para rapidamente enviar novos chamados da interface administrativa.';
$hesklang['no_ticket_tpl']='Nenhum modelo de chamado';
$hesklang['ticket_tpl_title']='Título';
$hesklang['delete_tpl']='Você tem certeza de que deseja remover este modelo?';
$hesklang['new_ticket_tpl']='Adicionar ou editar um modelo de chamado';
$hesklang['ticket_tpl_add']='Criar um novo modelo de chamado';
$hesklang['ticket_tpl_edit']='Editar o modelo de chamado selecionado';
$hesklang['save_ticket_tpl']='Salvar modelo de chamado';
$hesklang['ticket_tpl_saved']='Seu modelo de chamado foi salvo para uso futuro';
$hesklang['ticket_tpl_removed']='O modelo de chamado selecionado foi removido do banco de dados';
$hesklang['ticket_tpl_not_found']='Modelo de chamado não encontrado';
$hesklang['sel_ticket_tpl']='Selecione o modelo de chamado que você deseja editar';
$hesklang['ent_ticket_tpl_title']='Por favor, digite o título do modelo';
$hesklang['ent_ticket_tpl_msg']='Por favor, digite a mensagem do modelo';
$hesklang['ticket_tpl_id']='Identificação do modelo de chamado não encontrada';
$hesklang['select_ticket_tpl']='Selecionar um modelo de chamado';
$hesklang['list_tickets_cat']='Listar todos os chamados nesta categoria';
$hesklang['def_msg']='[Sem mensagem]';
$hesklang['emlreqmsg']='Exigir mensagem';
$hesklang['emlreqmsg2']='Ignorar e-mails da fila/buscados no servidor sem mensagem';
$hesklang['relart']='Artigos relacionados'; // Title of related articles box
$hesklang['s_relart']='Artigos relacionados'; // On settings page
$hesklang['tab_7']='Lista de chamados';
$hesklang['fitl']='Campos na lista de chamados';
$hesklang['submitted']='Enviado';
$hesklang['clickemail']='Visualizar';
$hesklang['set_pri_to']='Definir prioridade para:'; // Action below the ticket list
$hesklang['pri_set_to']='A prioridade foi definida para:';
$hesklang['cat_pri']='A prioridade da categoria será usando quando os clientes não puderem selecionar a prioridade e um chamado for enviado pela interface do cliente.';
$hesklang['cat_pri_info']='Seus clientes podem selecionar a prioridade, então a prioridade da categoria será ignorada.<br /><br />Para ao invés disso usar a prioridade da categoria, desative o seguinte recurso nas configurações do HESK:';
$hesklang['def_pri']='Prioridade da categoria:';
$hesklang['ch_cat_pri']='Definir prioridade da categoria';
$hesklang['cat_pri_ch']='A prioridade da categoria foi definida para:';
$hesklang['err_dbversion']='Versão do MySQL muito antiga:';
$hesklang['ip_whois']='whois do IP';
$hesklang['ednote']='Editar mensagem da observação';
$hesklang['ednote2']='Mensagem da observação salva';
$hesklang['perm_deny']='Permissão negada';
$hesklang['mis_note']='Identificação da observação não encontrada';
$hesklang['no_note']='Observação com esta identificação não encontrada';
$hesklang['sacl']='Salvar e continuar depois';
$hesklang['reply_saved']='Sua mensagem de resposta foi salva para depois.';
$hesklang['submit_as']='Enviar como:';
$hesklang['sasc']='Enviar como resposta do cliente';
$hesklang['creb']='Resposta do cliente inserida por:';
$hesklang['show_select']='Exibir &quot;Clique para selecionar&quot; como opção padrão';
// Settings
$hesklang['mms']='Modo de manutenção';
$hesklang['mmd']='Habilitar modo de manutenção';
// Customer notice
$hesklang['mm1']='Manutenção em progresso';
$hesklang['mm2']='Para realizar uma manutenção programada a nossa central de suporte foi desativada temporariamente.';
$hesklang['mm3']='Pedimos desculpas pelo inconveniente e pedimos que tente novamente mais tarde.';
// Staff notice
$hesklang['mma1']='O modo de manutenção está ativo!';
$hesklang['mma2']='Os clientes não podem usar a central de suporte.';
$hesklang['tools']='Ferramentas';
$hesklang['banemail']='Banir e-mails';
$hesklang['banemail_intro']='Impedir que certos endereços de e-mail enviem chamados a sua central de suporte.';
$hesklang['no_banemails']='<i>Nenhum e-mail está sendo banido.</i>';
$hesklang['eperm']='E-mails banidos permanentemente:';
$hesklang['bananemail']='Endereço do e-mail a banir';
$hesklang['savebanemail']='Banir este e-mail';
$hesklang['enterbanemail']='Digite o endereço de e-mail que deseja banir.';
$hesklang['validbanemail']='Digite um endereço de e-mail válido (<i>joao.silva@exemplo.com.br</i>) ou um domínio de e-mail (<i>@exemplo.com.br</i>)';
$hesklang['email_banned']='O endereço de e-mail <i>%s</i> foi banido e o HESK não irá mais aceitar chamados deste endereço.'; // %s will be replaced with email
$hesklang['emailbanexists']='O endereço de e-mail <i>%s</i> já está banido.'; // %s will be replaced with email
$hesklang['email_unbanned']='Banimento de e-mail removido';
$hesklang['banby']='Banido por';
$hesklang['delban']='Remover banimento';
$hesklang['delban_confirm']='Remover este banimento?';
$hesklang['baned_e']='Você foi proibido de enviar novos chamados.';
$hesklang['baned_ip']='Você foi banido desta central de suporte';
$hesklang['can_ban_emails']='Pode banir e-mails';
$hesklang['can_unban_emails']='Pode desbanir e-mails (habilita Pode banir e-mails)';
$hesklang['eisban']='Este endereço de e-mail está banido.';
$hesklang['click_unban']='Clique aqui para desbanir.';
$hesklang['banip']='Banir IPs';
$hesklang['banip_intro']='Visitantes dos endereços de IP banidos não poderão ver ou enviar chamados e entrar na central de suporte.';
$hesklang['ipperm']='Banimentos de IP permanentes:';
$hesklang['iptemp']='Banimentos por falha no login:';
$hesklang['savebanip']='Banir este IP';
$hesklang['no_banips']='<i>Nenhum IP está sendo banido.</i>';
$hesklang['bananip']='Endereço IP para banir';
$hesklang['banex']='Exemplos:';
$hesklang['iprange']='Intervalo do IP';
$hesklang['ippermban']='Banir este IP permanentemente';
$hesklang['enterbanip']='Digite o endereço IP ou o intervalo que deseja banir.';
$hesklang['validbanip']='Digite um endereço IP ou intervalo de IP válido';
$hesklang['ip_banned']='O endereço IP <i>%s</i> foi banido e o HESK não aceitará mais chamados deste endereço IP.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='O intervalo IP <i>%s</i> foi banido e o HESK não aceitará mais chamados deste intervalo IP.'; // %s will be replaced with IP
$hesklang['ipbanexists']='O endereço IP <i>%s</i> já está banido.'; // %s will be replaced with IP
$hesklang['iprbanexists']='O intervalo IP <i>%s</i> já está banido.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='Banimento de IP removido';
$hesklang['ip_tempun']='Banimento de IP temporário removido';
$hesklang['can_ban_ips']='Pode banir IPs';
$hesklang['can_unban_ips']='Pode desbanir IPs (habilita Pode banir IPs)';
$hesklang['ipisban']='Este endereço IP está banido.';
$hesklang['m2e']='Expira em (minuros)';
$hesklang['info']='Informação';
$hesklang['sm_title']='Mensagens de serviço';
$hesklang['sm_intro']='Exibe uma mensagem de serviço na área do cliente, por exemplo para notificá-los sobre problemas conhecidos e notícias importantes.';
$hesklang['can_service_msg']='Editar mensagens de serviço';
$hesklang['new_sm']='Nova mensagem de serviço';
$hesklang['edit_sm']='Editar mensagem de serviço';
$hesklang['ex_sm']='Mensagens de serviço existentes';
$hesklang['sm_author']='Autor';
$hesklang['sm_type']='Tipo';
$hesklang['sm_published']='Publicada';
$hesklang['sm_draft']='rascunho';
$hesklang['sm_style']='Estilo';
$hesklang['sm_none']='Nenhum';
$hesklang['sm_success']='Sucesso';
$hesklang['sm_info']='Informação';
$hesklang['sm_notice']='Comunicado';
$hesklang['sm_error']='Erro';
$hesklang['sm_save']='Salvar mensagem de serviço';
$hesklang['sm_preview']='Visualizar mensagem de serviço';
$hesklang['sm_mtitle']='Título';
$hesklang['sm_msg']='Mensagem';
$hesklang['sm_e_title']='Digite o título da mensagem de serviço';
$hesklang['sm_e_msg']='Digite a mensagem de serviço';
$hesklang['sm_e_id']='Identificação da mensagem não encontrada';
$hesklang['sm_added']='Uma nova mensagem de serviço foi adicionada';
$hesklang['sm_deleted']='Mensagem de serviço removida';
$hesklang['sm_not_found']='Esta mensagem de serviço não existe';
$hesklang['no_sm']='Nenhuma mensagem de serviço';
$hesklang['del_sm']='Remover esta mensagem de serviço?';
$hesklang['sm_mdf']='A mensagem de serviço foi salva';
$hesklang['sska']='Exibir artigos sugeridos';
$hesklang['taws']='Estes artigos foram sugeridos:';
$hesklang['defaults']='Padrões';
$hesklang['pncn']='Selecione a opção notificar cliente no formulário de novo chamado';
$hesklang['pncr']='Selecione a opção notificar cliente no formulário de resposta ao chamado';
$hesklang['pssy']='Exibir quais artigos da base de conhecimento foram sugeridos aos clientes';
$hesklang['ccct']='Resolvido pelo cliente';
$hesklang['custnot']='Notificar clientes quando';
$hesklang['notnew']='Um novo chamado for enviado';
$hesklang['notclo']='Um chamado é marcado como Resolvido';
$hesklang['enn']='Exceto para chamados de e-mails se o assunto do e-mail possuir:';
$hesklang['spamn']='Aviso de SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>Nenhum e-mail de confirmação?</b><br />Enviamos uma mensagem de confirmação para seu endereço de e-mail. Se você não a receber dentro de alguns minutos, por favor verifique suas pasta de Lixo eletrônico, Lixeira ou Spam. Marque a mensagem como <b>Não é SPAM</b> para evitar problemas recebendo nossas correspondências no futuro.</span>';
$hesklang['ekb_n']='<b>NÃO</b>, desabilitar a base de conhecimento';
$hesklang['ekb_y']='<b>SIM</b>, habilitar a base de conhecimento';
$hesklang['ekb_o']='<b>SIM</b>, usar o HESK somente como uma base de conhecimento (<i>desabilita a central de suporte</i>)';
$hesklang['kb_set']='Configurações da base de conhecimento';
$hesklang['kbo1']='Modo somente base de conhecimento';
$hesklang['kbo2']='<br /><br />Os visitantes não podem enviar novos chamados e são encaminhados diretamente para a base de conhecimento.';
$hesklang['fpass']='Esqueceu sua senha?';
$hesklang['passr']='Redefinir senha';
$hesklang['passa']='Permitir aos usuários redefinir a senha esquecida pelo e-mail';
$hesklang['passe']='Digite seu endereço de e-mail';
$hesklang['passs']='Me envie o link para redefinição de senha';
$hesklang['noace']='Nenhuma conta com este endereço de e-mail foi encontrada';
$hesklang['pemls']='Enviamos a você um e-mail com instruções sobre como redefinir sua senha';
$hesklang['reset_password']='Redefinir sua senha da central de suporte'; // Email subject
$hesklang['ehash']='Link de redefinição de senha inválido ou expirado';
$hesklang['ehaip']='Endereço IP incorreto. As senhas só podem ser redefinidas do endereço IP que requisitou a redefinição de senha.';
$hesklang['resim']='<b>Configure sua nova senha no formulário abaixo!</b>';
$hesklang['permissions']='Permissões';
$hesklang['atype']='Tipo de conta';
$hesklang['astaff']='Equipe';
$hesklang['oon1']='Me envie apenas chamados abertos';
$hesklang['oon2']='me envie todos os meus chamados';
$hesklang['anyown']='Qualquer responsável';
$hesklang['pfr']='Outra tarefa de busca em POP3 ainda está em andamento.';
$hesklang['pjt']='Tempo limite da tarefa';
$hesklang['pjt2']='minutos após o início';
$hesklang['nkba']='A pesquisa da base de conhecimento precisa de artigos únicos suficientes para funcionar adequadamente.<br /><br />Considere adicionar mais artigos na base de conhecimento para melhorar os resultados da pesquisa e das sugestões de artigos.';
$hesklang['saa']='Artigos relevantes são exibidos no topo da lista de artigos';
$hesklang['yhbr']='Você foi bloqueado do sistema por %s minutos devido a muitas resposta a um chamado.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='pt-BR';

// Added in version 2.7.0
$hesklang['imap']='Busca em IMAP';
$hesklang['imaph']='Servidor IMAP';
$hesklang['imapp']='Porta IMAP';
$hesklang['enc']='Criptografia';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Nenhuma';
$hesklang['imapu']='Usuário IMAP';
$hesklang['imapw']='Senha IMAP';
$hesklang['imaptest']='Testar conexão IMAP';
$hesklang['ifd']='[HESK] BUSCA EM IMAP ESTÁ DESABILITADA NAS CONFIGURAÇÕES';
$hesklang['iei']='[HESK] Extensão IMAP do PHP não está instalada.';
$hesklang['ifr']='Outra tarefa de busca em IMAP ainda está em andamento.';
$hesklang['arp']='Recarregar página automaticamente';
$hesklang['arpp']='Recarregar página automaticamente com a lista de chamados a cada:';
$hesklang['seconds']='segundos';
$hesklang['minutes']='minutos';
$hesklang['atbr']='Este chamado precisa ser atribuído antes de poder ser respondido.';
$hesklang['attm']='Atribuir este chamado a mim';
$hesklang['owneed']='Responsável necessário';
$hesklang['taat']='Este chamado já está atribuído a <b>%s</b>.';
$hesklang['scoy']='Você tem certeza de que deseja atribuí-lo a si mesmo?';
$hesklang['scot']='Você tem certeza de que deseja atribuí-lo a %s?';
$hesklang['ycto']='SIM, alterar o responsável';
$hesklang['ncto']='NÃO, manter o responsáel atual';
$hesklang['fass']='Exigir responsável';
$hesklang['req_sub']='Exigir assunto';
$hesklang['req_msg']='Exigir mensagem';
$hesklang['req_email']='Exigir e-mail';
$hesklang['default_subject']='Chamado de %s';
$hesklang['off-hide']='Ocultar no formulário do cliente';
$hesklang['not_valid_email']='Digite um endereço de e-mail válido ou deixe este campo em branco';
$hesklang['write_down']='<span style="color:red">Recomendamos que você anote o código de identificação de seu chamado para futuras referências.</span>';
$hesklang['re_confirm1']='Desabilitar isto também desabilitará "Exigir e-mail para ver chamados" em "Segurança". Prosseguir?';
$hesklang['re_confirm2']='Habilitar isto também habilitará "Exigir e-mail" em "Recursos". Prosseguir?';
$hesklang['can_email_tpl']='Editar modelos de e-mail';
$hesklang['et_title']='Modelos de e-mail';
$hesklang['et_intro']='Modificar e-mails que são enviados a sua equipe e clientes';
$hesklang['file']='Arquivo';
$hesklang['efile']='Editando arquivo';
$hesklang['rdesc']='(Destinatário) Descrição';
$hesklang['desc_forgot_ticket_id']='(Cliente) Esqueceu o código de identificação do chamado';
$hesklang['desc_new_reply_by_staff']='(Cliente) Nova resposta da equipe';
$hesklang['desc_new_ticket']='(Cliente) Chamado recebido';
$hesklang['desc_ticket_closed']='(Cliente) Chamado fechado/resolvido';
$hesklang['desc_category_moved']='(Equipe) Chamado movido para uma nova categoria';
$hesklang['desc_new_reply_by_customer']='(Equipe) Nova resposta do cliente';
$hesklang['desc_new_ticket_staff']='(Equipe) Novo chamado enviado';
$hesklang['desc_ticket_assigned_to_you']='(Equipe) Um chamado foi atribuído a você';
$hesklang['desc_new_pm']='(Equipe) Nova mensagem privada';
$hesklang['desc_new_note']='(Equipe) Nova observação em um chamado atribuído a você';
$hesklang['desc_reset_password']='(Equipe) Redefinir sua senha';
$hesklang['etfm']='Um ou mais modelos de e-mail estão faltando.<br /><br />Certifique-se de ter enviado todos os arquivos de modelo de e-mails de dentro da sua pasta <i>/language/%s/emails</i>.';
$hesklang['etfw']='Alguns modelos de e-mail não são graváveis.<br /><br />
                    Certifique-se de que o PHP possui permissão de gravação em todos os arquivos dentro de sua pasta <i>/language/%s/emails</i>.<br /><br />
                    Em servidores Unix você pode precisar aplicar o CHMOD 666 (rw-rw-rw-) nos modelos de e-mail';
$hesklang['et_e_id']='Identificação do modelo não encontrada';
$hesklang['et_fm']='Este arquivo de modelo de e-mail não foi encontrado';
$hesklang['et_fw']='Este arquivo de modelo de e-mail não é gravável';
$hesklang['et_save']='Salvar modelo de e-mail';
$hesklang['updated_on']='Atualizado em';
$hesklang['ticket_url']='URL do chamado';
$hesklang['pm_url']='URL da mensagem privada';
$hesklang['et_num']='Número de chamados';
$hesklang['et_list']='Lista de chamados';
$hesklang['et_empty']='O modelo de e=mail não podem ficar em branco';
$hesklang['et_saved']='Modelo de e-mail salvo';
$hesklang['source']='Fonte';
$hesklang['select_category']='Selecione uma categoria';
$hesklang['select_category_text']='Em que podemos ajudar?';
$hesklang['select_category_staff']='Selecione a categoria do chamado';
$hesklang['scat']='Limite de seleção de categoria';
$hesklang['scat2']='(uma caixa de combinação exibirá se o contador da categoria for maior)';
$hesklang['new_cf']='Novo campo personalizado';
$hesklang['cf_intro']='Use este recurso para adicionar campos personalizados ao formulário Envie um chamado, assim você pode coletar dados adicionais dos clientes.';
$hesklang['cf_public']='Público';
$hesklang['cf_private']='Somente equipe';
$hesklang['cf_cust']='Para clientes';
$hesklang['cf_all']='Todos';
$hesklang['cf_cat']='Selecionado';
$hesklang['cf_ctrl']='Dica: pressione a tecla CTRL para selecionar múltiplas categorias';
$hesklang['visibility']='Visibilidade';
$hesklang['cf_save']='Salvar campo personalizado';
$hesklang['ex_cf']='Campos personalizados ativos';
$hesklang['no_cf']='Nenhum campo personalizado ativo';
$hesklang['del_cf']='Remover este campo personalizado? Isto também removerá todos os dados do campo personalizado do banco de dados!';
$hesklang['cf_e_id']='Identificação inválida';
$hesklang['edit_cf']='Editar campo personalizado';
$hesklang['cf_deleted']='Campo personalizado removido';
$hesklang['cf_not_found']='Este campo personalizado não existe';
$hesklang['cf_added']='Um novo campo personalizado foi adicionado';
$hesklang['cf_nocat']='Selecione pelo menos uma categoria para este campo personalizado';
$hesklang['cf_mdf']='O campo personalizado foi salvo';
$hesklang['atl1']='Digite pelo menos uma opção.';
$hesklang['sch']='Oculto';
$hesklang['meml3']='Permitir que vários e-mails sejam digitados';
$hesklang['dmin']='Data mínima aceita';
$hesklang['dmax']='Data máxima aceita';
$hesklang['d_day']='dia(s)';
$hesklang['d_week']='semana(s)';
$hesklang['d_month']='mês(es)';
$hesklang['d_year']='ano(s)';
$hesklang['d_any']='Qualquer data';
$hesklang['d_fixed']='Data fixa';
$hesklang['d_relative']='Data relativa';
$hesklang['d_mm']='A data mínima não pode ser maior que a data máxima';
$hesklang['d_emin']='A data mínima para <i>%s</i> é %s';
$hesklang['d_emax']='A data máxima para <i>%s</i> é %s';
$hesklang['d_format']='Formato de exibição da data';
$hesklang['d_custom']='Formato personalizado';
$hesklang['d_ci']='SOMENTE USUÁRIOS AVANÇADOS: um formato válido de data do PHP, veja o manual do PHP.';
$hesklang['cf_noe']='Digite um endereço de e-mail válido em <i>%s</i>';
$hesklang['cf_noem']='Digite um ou mais endereços de e-mail válidos em <i>%s</i>';
$hesklang['can_resolve']='Pode resolver chamados';
$hesklang['can_change_own_cat']='Pode alterar categoria do chamado (para permitidas)';
$hesklang['can_submit_any_cat']='Pode enviar chamados para qualquer categoria';
$hesklang['noauth_submit']='Você não está autorizado a enviar chamados para esta categoria!';
$hesklang['noauth_move']='Você não está autorizado a mover chamados para esta categoria!';
$hesklang['noauth_resolve']='Você não está autorizado a resolver chamados!';
$hesklang['force_ssl']='Forçar conexões SSL';
$hesklang['d_ssl']='<i>desabilitado</i> - abra esta página usando https:// para gerenciar esta opção';
$hesklang['scno']='Este status não pode ser alterado';
$hesklang['statuses']='Status';
$hesklang['statuses_intro']='Use esta ferramenta para adicionar status de chamado personalizados a sua central de suporte';
$hesklang['color']='Cor';
$hesklang['csscl']='Classe CSS ou cor';
$hesklang['clr_view']='Visualização de cor no texto';
$hesklang['cbc']='Modificável pelos clientes';
$hesklang['ccc']='Os clientes podem alterar este status?';
$hesklang['del_status']='Remover este status?';
$hesklang['ex_status']='Status existentes';
$hesklang['status_hesk']='Status padrões (não pode ser alterados aqui)';
$hesklang['status_custom']='Status personalizados';
$hesklang['status_custom_none']='Nenhum status personalizado. Você pode adicioná-los usando o formulário acima.';
$hesklang['status_save']='Salvar status';
$hesklang['list_tkt_status']='Listar todos os chamados com este status';
$hesklang['new_status']='Novo status personalizado';
$hesklang['edit_status']='Editar status personalizado';
$hesklang['err_status']='Digite o nome do status';
$hesklang['status_added']='Um novo status foi adicionado';
$hesklang['status_e_id']='Identificação inválida';
$hesklang['status_mdf']='O status personalizado foi salvo';
$hesklang['status_deleted']='Status personalizado removido';
$hesklang['status_not_found']='Este status personalizado não existe';
$hesklang['status_not_empty']='Este status personalizado não pode ser removido pois existem chamados com este status';
$hesklang['status_limit']='Você possui 100 status personalizados, nenhum novo pode ser criado.';
$hesklang['public_link']='Link público';
$hesklang['frames']='Frames';
$hesklang['frames2']='Impedir o HESK de carregar em frames em domínios de terceiros';
$hesklang['numsub']='Chamados enviados';
$hesklang['hidf']='Campos ocultos não são visíveis aos clientes no formulário Enviar um chamado (o valor ainda será visível na página de detalhes do chamado se eles forem definidos como públicos). Eles funcionam como campos de texto comuns para membros da equipe.';
$hesklang['rcheck']='Não selecione uma opção padrão';
$hesklang['refresh_page']='Recarregar esta página';
$hesklang['del_kba']='Remover este artigo';
$hesklang['del_kbaa']='Remover permanentemente este artigo';
$hesklang['hni1']='HESK ainda não instalado?';
$hesklang['hni2']='Aparentemente esta central de suporte ainda não foi devidamente instalada e configurada.';
$hesklang['hni3']='Para instalar o HESK siga as <a href="docs/">instruções na documentação</a>';
$hesklang['cf']='Pasta de cache';
$hesklang['e_cdir']='O HESK não poderá analisar e-mails ou fazer cache dos resultados a menos que a pasta de cache exista e seja gravável.';
$hesklang['step1']='Passo 1';
$hesklang['step2']='Passo 2';
$hesklang['dffs']='Quando o download for concluído, remova o arquivo do servidor';
$hesklang['fd']='Exportar arquivo removido do servidor';

// Added in version 2.8.0
$hesklang['TZ']='Timezone';
$hesklang['thist17']='<li class="smaller">%s | enviado pelo buscador IMAP</li>';
$hesklang['sir3']='reCAPTCHA Invisível';
$hesklang['invisible']='invisível';
$hesklang['imap_not']='O PHP não foi compilado com suporte a IMAP';
$hesklang['imap_warning']='usuário %1$s tem o mesmo endereço de e-mail que o seu buscador IMAP: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='usúario %1$s tem o mesmo endereço de e-mail que o seu buscador POP3: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Isso pode resultar em um loop de e-mail, onde novos tickets são criados pelas notificações de e-mail do usuário. Seu endereço de e-mail do buscador deve ser único e não deve ser usado por mais ninguém.';
$hesklang['can_view_ass_by']='Pode visualizar tickets que ele/elaa associou a outros';
$hesklang['can_privacy']='Pode anonimizar tickets';
$hesklang['confirm_anony']='Anonimizar esse ticket';
$hesklang['anon_selected']='Anonimizar tickets selecionados';
$hesklang['privacy_anon_info']='Remover todas as informações que podem identificar pessoalmente o remetente de tickets (nome, e-mail, mensagem, anexos, IP...), mas conservar tickets na base de dados para estatísticas (para serem esquecidos).';
$hesklang['success_anon']='Ticket anonimizado com sucesso';
$hesklang['num_tickets_anon']='Número de tickets anonimizados: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Cliente]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Assunto]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Mensagem]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonimizado por %s</li>';
$hesklang['print_selected']='Imprimir os tickets selecionados';
$hesklang['with_selected']='Com a seleção:';
$hesklang['assign_selected']='Associar selecionados para:';
$hesklang['assign_no']='Sem proprietário selecionado, não foram feitas alterações';
$hesklang['assign_1']='Os tickets selecionados foram alterados para Desassociados.';
$hesklang['assign_2']='Ticket ID %1$s alterado para Desassociado'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s erro: já está associado para %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s associado para %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s erro: %2$s não tem acesso à categoria do ticket'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultado de associação em massa de tickets::<br /><br />Associado: %1$s<br />Erros: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='Endereço IP';
$hesklang['moret']='Mais opções'; // More options button title
$hesklang['btn_more']='Mais'; // More options button text
$hesklang['btn_print']='Imprimir';
$hesklang['btn_edit']='Editar';
$hesklang['btn_lock']='Trancar ticket';
$hesklang['btn_unlock']='Destrancar ticket';
$hesklang['btn_tag']='Marcar ticket';
$hesklang['btn_resend']='Reenviar notificação de e-mail';
$hesklang['btn_untag']='Desmarcar ticket';
$hesklang['btn_import_kb']='Importar para a Base de Conhecimento';
$hesklang['btn_anony']='Anonimizar ticket';
$hesklang['btn_delt']='Excluir ticket';
$hesklang['btn_delr']='Excluir resposta';
$hesklang['ernf']='Resposta não encontrada';
$hesklang['tns']='Notificações do ticket foram reenviadas';
$hesklang['rns']='Notificações de resposta foram reenviadas';
$hesklang['fname']='Primeiro nome';
$hesklang['export_selected']='Exportar tickets selecionados';
$hesklang['btn_export']='Exportar para XML (Excel)';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='respostas';
$hesklang['team']='Equipe';
$hesklang['sm_content']='Conteúdo';
$hesklang['sm_settings']='Configurações';
$hesklang['wizard_back']='Voltar'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Próximo'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Voltar para as Configurações';
$hesklang['sm_return_to_editing']='Retornar para Edição';
$hesklang['email_tpl_title']='Título';
$hesklang['edit_email_template']='Editar Modelo de E-mail';
$hesklang['err_no_settings_section']='Nenhuma seção de configurações foi fornecida.';
$hesklang['this_field_is_required']='Este campo é requerido.';
$hesklang['reset_your_password']='Redefina sua senha';
$hesklang['reset_password_instructions']='Por favor, preencha o formulário abaixo. Enviaremos um link para você redefinir sua senha.';
$hesklang['enter_email']='Digite um e-mail';
$hesklang['password_reset_check_your_email']='Verifique seu e-mail';
$hesklang['password_reset_link_sent']='Enviamos um link para redefinir sua senha.';
$hesklang['back_to_login']='Voltar para página de login';
$hesklang['pager_first']='Primeira';
$hesklang['pager_previous']='Anterior';
$hesklang['pager_next']='Próxima';
$hesklang['pager_last']='Última';
$hesklang['new_team_member']='Novo Membro da Equipe';
$hesklang['role']='Função';
$hesklang['optional']='Opcional';
$hesklang['edit_profile']='Editar Perfil';
$hesklang['assigned_to']='Atribuído a';
$hesklang['contact']='Contato';
$hesklang['unban_email']='Desbanir este e-mail';
$hesklang['unban_ip']='Desbanir este IP';
$hesklang['show_previous_replies']='Mostrar respostas anteriores';
$hesklang['type_your_message']='Digite sua mensagem'; // Used when there are no canned responses
$hesklang['close_button_text']='Fechar';
$hesklang['create_new_ticket']='Criar Novo Chamado';
$hesklang['delete_article']='Deletar artigo';
$hesklang['view_existing_tickets']='Visualizar chamados existentes';
$hesklang['how_can_we_help']='Olá, como podemos lhe ajudar?';
$hesklang['search_for_articles']='Pesquisar por artigos';
$hesklang['submit_a_support_request']='Enviar um Chamado';
$hesklang['verify_header']='Prevenção de SPAM';
$hesklang['ticket_details']='Detalhes do Chamado';
$hesklang['yes_title_case']='Sim';
$hesklang['no_title_case']='Não';
$hesklang['no_results_found']='Nenhum Resultado Encontrado';
$hesklang['site_theme']='Tema do Site';
$hesklang['test_theme_folder']='Testar Pasta de Temas';
$hesklang['test_theme_folder_description']='Testar o diretório de temas para temas válidos. Somente temas que passem  por todos os testes são instalados corretamente.';
$hesklang['err_site_theme']='Por favor, selecione um Tema do Hesk';
$hesklang['confirm']='Confirmar';
$hesklang['confirm_deletion']='Confirmar Remoção';
$hesklang['confirm_delete_status']='Você tem certeza que deseja excluir esse status customizado?';
$hesklang['help_desk']='Sistema de Chamados'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.pt-br.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Exibição de hora';
$hesklang['tdisd']='Data e hora';
$hesklang['tdisa']='Horas atrás (exemplo: há 5 horas)';
$hesklang['nav_templates']='Templates'; // Admin panel navigation item
$hesklang['hide_replies']='Esconder respostas do ticket';
$hesklang['hide_replies_no']='Nunca, sempre mostrar todas as respostas';
$hesklang['hide_replies_yes']='Esconder todas as respostas, exceto a última';
$hesklang['hide_replies_def']='Mostrar apenas a última resposta da equipe e qualquer resposta subsequente do cliente';
$hesklang['reply_by']='Respondido por'; // Reply by NAME
$hesklang['btt']='Voltar ao topo';
$hesklang['lwidth']='Limitar largura do ticket';
$hesklang['lwidtall']='Usar o maior largura disponível';
$hesklang['lwidtpx']='Largura máxima em pixels:';
// 3-letter days of the week
$hesklang['mon']='Seg';
$hesklang['tue']='Ter';
$hesklang['wed']='Qua';
$hesklang['thu']='Qui';
$hesklang['fri']='Sex';
$hesklang['sat']='Sab';
$hesklang['sun']='Dom';
$hesklang['clear']='Limpar'; // delete field value
$hesklang['first_day_of_week']='0'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Pelo menos uma medida de prevenção de SPAM deve estar habilitada!';
$hesklang['modules']='Módulos';
$hesklang['modules_demo']='Este módulo somente está disponível em %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Teste o live demo aqui: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Estatísticas';
$hesklang['statistics']['intro']='Este relatório te dará informações sobre o uso do helpdesk e sobre a performance da equipe.';
$hesklang['statistics']['ntsp']='Não há tickets no período selecionado.';
$hesklang['statistics']['pie_title_ro']='Tickets Abertos X Resolvidos';
$hesklang['statistics']['open']='Aberto';
$hesklang['statistics']['resolved']='Resolvido';
$hesklang['statistics']['pie_title_as']='Tickets abertos: Associados X Não associados';
$hesklang['statistics']['ass']='Associado';
$hesklang['statistics']['unas']='Não associado';
$hesklang['statistics']['pie_title_au']='Tickets abertos: Respondidos vs. Sem resposta';
$hesklang['statistics']['answered']='Respondido';
$hesklang['statistics']['unanswered']='Sem resposta';
$hesklang['statistics']['pie_title_so']='Status dos tickets abertos';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets por dia do mês';
$hesklang['statistics']['chart_title_wd']='Tickets por dia da semana';
$hesklang['statistics']['chart_title_hd']='Tickets por hora do dia';
$hesklang['statistics']['chart_title_tfr']='Tempo até a primeira resposta da equipe';
$hesklang['statistics']['chart_title_tfrc']='Tickets respondidos dentro de um intervalo de tempo';
$hesklang['statistics']['chart_title_ttr']='Tempo do envio à solução do ticket';
$hesklang['statistics']['chart_title_ttrc']='Tickets resolvidos dentro de um intervalo de tempo';
$hesklang['statistics']['chart_title_sr']='Respostas da equipe';
$hesklang['statistics']['chart_title_srt']='Respostas da equipe por ticket';
$hesklang['statistics']['chart_title_srtr']='Respostas da equipe por ticket (somente tickets resolvidos)';
$hesklang['statistics']['chart_title_srt1']='Respostas da equipe por ticket (tickets com pelo menos 1 resposta)';
$hesklang['statistics']['ct_30']='30 minutos';
$hesklang['statistics']['ct_1h']='1 hora';
$hesklang['statistics']['ct_2h']='2 horas';
$hesklang['statistics']['ct_4h']='4 horas';
$hesklang['statistics']['ct_1d']='1 dia';
$hesklang['statistics']['ct_2d']='2 dias';
$hesklang['statistics']['ct_3d']='3 dias';
$hesklang['statistics']['ct_1w']='1 semana';
$hesklang['statistics']['ct_wp']='> 1 semana';
$hesklang['statistics']['ct_1m']='1 mês';
$hesklang['statistics']['ct_mp']='> 1 mês';
$hesklang['statistics']['axis1']='% de tickets respondidos';
$hesklang['statistics']['axis2']='% de tickets resolvidos';
$hesklang['statistics']['axis3']='% de tickets';
$hesklang['statistics']['axis4']='Tempo para primeira resposta';
$hesklang['statistics']['axis5']='Tempo para resolvido';
$hesklang['statistics']['axis6']='Numero de respostas';
$hesklang['statistics']['axis7']='Numero de tickets';
$hesklang['statistics']['axis8']='Dia da semana';
$hesklang['statistics']['axis9']='Hora';
$hesklang['statistics']['axis10']='Dia do mês';
$hesklang['statistics']['tr_0']='Sem resposta';
$hesklang['statistics']['tr_1']='1 resposta';
$hesklang['statistics']['tr_2']='2 respostas';
$hesklang['statistics']['tr_5']='3-5 respostas';
$hesklang['statistics']['tr_10']='6-10 respostas';
$hesklang['statistics']['tr_99']='> 10 respostas';
$hesklang['statistics']['average']='Média';
$hesklang['statistics']['atfr']='Média de horas e minutos para primeira resposta da equipe:';
$hesklang['statistics']['attr']='Média de horas e minutos para resolver um ticket:';
$hesklang['statistics']['about']='aproximadamente %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Total de tickets respondidos pela equipe:';
$hesklang['statistics']['trnr']='Total de tickets resolvidos sem uma resposta da equipe:';
$hesklang['statistics']['tsr']='Total de respostas da equipe:';
$hesklang['statistics']['tsrt']='Média de respostas da equipe por ticket:';
$hesklang['statistics']['tsro']='Média de respostas da equipe por ticket (tickets com pelo menos 1 resposta da equipe):';
$hesklang['statistics']['tsrc']='Média de respostas da equipe requeridas para solução de um ticket:';
$hesklang['statistics']['tsrr']='Média de respostas da equipe requeridas para solução de um ticket (tickets com pelo menos 1 resposta da equipe):';
$hesklang['sep_1000']='.'; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='e muito mais...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket vencido';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESCALADO: %%SUBJECT%%';
$hesklang['escalate']['tab']='Escalado'; // Menu link
$hesklang['escalate']['page_title']='Tickets Escalados'; // Page H2 title
$hesklang['escalate']['intro']='Este módulo o ajudará a escalar tickets que não são atendidos a tempo.';
$hesklang['escalate']['feat1']='Tickets não atribuídos, respondidos ou resolvidos dentro de um prazo';
$hesklang['escalate']['feat2']='tickets se aproximando da data de vencimento e tickets vencidos';
$hesklang['escalate']['feat3']='alterar automaticamente a prioridade do ticket, reatribuir um ticket, enviar uma notificação por e-mail';
$hesklang['escalate']['feat4']='aplicar regras com base na categoria do ticket, proprietário, status';
$hesklang['escalate']['prefix']='Escalado'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Regras ativas';
$hesklang['escalate']['new']='Nova regra de escalação';
$hesklang['escalate']['no_rules']='Você não tem regras de escalonamento. Crie uma clicando no botão &quot;Nova regra de escalonamento&quot; botão acima.';
$hesklang['escalate']['title']='Título da regra';
$hesklang['escalate']['titlet']='Um título descritivo, por exemplo: Reatribuir tickets não respondidos em um dia';
$hesklang['escalate']['default_title']='Regra de %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Gatilho de regra';
$hesklang['escalate']['trigt']='Defina a condição que irá acionar (executar) esta regra.';
$hesklang['escalate']['hits']='Êxitos'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condição'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Ação'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Aplicar a'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Deletar esta regra?';
$hesklang['escalate']['edit']='Editando a regra de escalonamento ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Um ticket de suporte é:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='não respondido pela equipe';
$hesklang['escalate']['nrepc']='não respondido pelo cliente';
$hesklang['escalate']['nass']='não atribuído';
$hesklang['escalate']['nres']='não resolvido';
$hesklang['escalate']['ndue']='se aproximando da data de vencimento';
$hesklang['escalate']['odue']='atrasado';
$hesklang['escalate']['within']='Dentro de';
$hesklang['escalate']['minutes']='minutos';
$hesklang['escalate']['hours']='houras';
$hesklang['escalate']['days']='dias';
$hesklang['escalate']['weeks']='semanas';
$hesklang['escalate']['months']='meses';
$hesklang['escalate']['years']='anos';
$hesklang['escalate']['ofs']='de ser submetido';
$hesklang['escalate']['resend']='Reenviar notificações por e-mail:';
$hesklang['escalate']['force']='Sempre envie, desconsidere as configurações da equipe';
$hesklang['escalate']['noforce']='Respeite as configurações de notificação da equipe';
$hesklang['escalate']['setpri']='Defina a prioridade para:';
$hesklang['escalate']['setsta']='Defina o status para:';
$hesklang['escalate']['assto']='Atribuir ticket a:';
$hesklang['escalate']['asm']='Outro membro da equipe';
$hesklang['escalate']['notify']='Notificar membros da equipe ...';
$hesklang['escalate']['ato']='Aplicar a';
$hesklang['escalate']['tic']='Tickets na categoria:';
$hesklang['escalate']['tat']='Tickets atribuídos para:';
$hesklang['escalate']['tws']='Tickets com status:';
$hesklang['escalate']['tall']='Aplique esta regra a tickets existentes e futuros';
$hesklang['escalate']['tfn']='Aplique esta regra apenas a tickets futuros, ignore os tickets existentes';
$hesklang['escalate']['tfi']='Aplique esta regra apenas a tickets com ID superior a:';
$hesklang['escalate']['save']='Salvar regra';
$hesklang['escalate']['e_tt']='O tempo deve estar entre 1 e 10000';
$hesklang['escalate']['e_a']='Selecione pelo menos uma ação para executar em tickets correspondentes';
$hesklang['escalate']['nocat']='Selecione pelo menos uma categoria';
$hesklang['escalate']['nouser']='Selecione pelo menos um usuário';
$hesklang['escalate']['nostatus']='Selecione pelo menos um status';
$hesklang['escalate']['nocata']='%1$s não tem acesso a estas categorias:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Nova regra foi criada';
$hesklang['escalate']['mdf']='As configurações da regra foram salvas';
$hesklang['escalate']['e_id']='Nenhuma regra com este ID encontrada';
$hesklang['escalate']['deleted']='A regra selecionada foi excluída';
$hesklang['escalate']['edit_notice']='alterar o gatilho da regra não terá efeito em nenhum ticket já escalado por esta regra (a menos que você redefina a regra).';
$hesklang['escalate']['reset']='Redefinir esta regra';
$hesklang['escalate']['reset2']='Tem certeza de que deseja redefinir esta regra?<br><br>Os êxitos da regra irão para 0 e qualquer ticket que corresponda a essa regra será escalado novamente.';
$hesklang['escalate']['reset3']='A regra selecionada foi redefinida';
$hesklang['escalate']['log_title']='Regra #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | escalado por %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - definir prioridade para %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - atribuir a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - enviar notificação de equipe</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - enviar notificação de equipe (forçado)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - erro: %2$s não tem acesso à categoria de tickets</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - erro: %2$s não tem permissão para ver os tickets</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - erro: nenhum outro usuário que pode ver este ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - aviso: prioridade já definida para %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - aviso: já atribuído a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notificar: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - definir status para %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - aviso: status já definido para %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Ativa'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Ative esta regra (começar a usá-la)';
$hesklang['escalate']['activated']='A regra selecionada foi ativada'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Desative esta regra (parar de usá-la)';
$hesklang['escalate']['deactivated']='A regra selecionada foi desativada'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Sem regras de escalação ativas';
$hesklang['escalate']['matched']='Número de tickets correspondentes encontrados: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Ferramentas';
$hesklang['escalate']['test']='Simule esta regra';
$hesklang['escalate']['testa']='Simule todas as regras';
$hesklang['escalate']['testaa']='Simule todas as regras ativas';
$hesklang['escalate']['testr']='Resultados simulados';
$hesklang['escalate']['rsim']='Repetir simulação';
$hesklang['escalate']['tbef']='Antes de uma regra ser ativada, você precisa ativá-la clicando na caixa de seleção na coluna &quot;ATIVA&quot;.<br><br>
                               Recomendamos enfaticamente que você <strong>simule</strong> cada regra clicando no %1$s (Simular esta regra) na tabela de regras para ver como 
							   isso afetará seus tickets existentes antes de ativá-la.<br><br>
                               <strong>As regras ativas são processadas a cada %2$s minutos. Um ticket só pode ser escalado uma vez para cada regra</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='MODO DE SIMULAÇÃO, sem alterações no banco de dados';
$hesklang['escalate']['sic']='SIMULAÇÃO COMPLETA';
$hesklang['escalate']['r']='[REGRA]';
$hesklang['escalate']['i']='[INFORMAÇÃO]';
$hesklang['multopt']='Dica: mantenha pressionada a tecla CTRL para selecionar várias opções';
$hesklang['desc_ticket_escalated']='(Equipe) O ticket foi escalado'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Formatação de Tickets (Equipe)';
$hesklang['ticket_formatting_plaintext']='Texto Plano';
$hesklang['ticket_formatting_rich_text']='Rich Text (HTML)';
$hesklang['due_date']='Data de Vencimento';
$hesklang['invalid_due_date']='Uma data de vencimento inválida foi inserida.';
$hesklang['thist19']='<li class="smaller">%s | data de vencimento atualizada para %s em %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | data de vencimento removida em %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='A data de vencimento do ticket foi atualizada.';
$hesklang['menu_kb_manage']='Gerenciar'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Visualizar'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Selecionar todos';
$hesklang['a_deselect']='Desmarcar todos';
$hesklang['a_toggle']='Alternar tudo';
$hesklang['ql_all']='Todos os Tickets';
$hesklang['ql_alo']='Todos os tickets abertos';
$hesklang['ql_fit']='Tickets filtrados';
$hesklang['ql_a2m']='Atribuídos a mim';
$hesklang['ql_a2o']='Atribuídos a outros';
$hesklang['ql_una']='Não atribuídos';
$hesklang['ql_due']='Vencimento em breve';
$hesklang['ql_ovr']='Atrasado';
$hesklang['set_ds']='Mostrar como &quot;vencimento em breve&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='dias antes da data de vencimento';
$hesklang['not_aos']='Alguns tickets abertos aos quais você tem acesso não são exibidos devido aos seus filtros.';
$hesklang['ntoverdue']='Um ticket está vencido com o proprietário:';
$hesklang['ovdcron']='para que as notificações atrasadas funcionem, seu administrador deve habilitar um cron job.';
$hesklang['instructions']='Instruções';
$hesklang['desc_overdue_ticket']='(Equipe) Ticket em atraso';
$hesklang['overdue_starting']='Iniciando processo de notificação de tickets vencidos';
$hesklang['overdue_sim']='O envio de e-mails e a atualização de tickets estão desabilitados no modo SIMULAÇÃO.';
$hesklang['overdue_ticket_count']='Foram encontrados %s tickets vencidos.'; // %s = Number of tickets
$hesklang['overdue_finished']='Tickets Vencidos Concluídos. %s e-mails enviados. %s falha ao enviar e-mails.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Carregue um arquivo de estilo personalizado extra para o painel de administração';
$hesklang['noval_cert']='Não valide os certificados do servidor';
$hesklang['chg_cat']='Clique para alterar a categoria do ticket';
$hesklang['tlan']='Idioma do Ticket';
$hesklang['uue']='Dois ou mais membros da equipe têm o mesmo endereço de e-mail. Recomendamos definir um endereço de e-mail exclusivo para cada usuário.';
$hesklang['flood']='Limite de inundação';
$hesklang['e_flood']='Opa, você já enviou uma resposta recentemente. Interrompemos essa solicitação para evitar inundação de respostas.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='Chave de acesso de URL'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Gerar uma chave de acesso de URL aleatória';
$hesklang['ukeym']='Erro: para executar este arquivo via HTTP, você deve incluir sua chave de acesso de URL na solicitação. Exemplo:';
$hesklang['ukeyw']='Erro: chave de acesso de URL errada';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Chamado recebido: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% é o seu código de verificação';
$hesklang['follow_up_email']='Seja honesto - como faremos?';
$hesklang['mfa']='Autenticação de multifator (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Habilitado?';
$hesklang['mfa_required']='Exigir autenticação multifator';
$hesklang['mfa_manage_profile']='Gerenciar MFA';
$hesklang['mfa_disabled']='Autenticação de multifatores está desabilitada';
$hesklang['mfa_enabled']='Autenticação de multifaotres está habilitada (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Nenhum';
$hesklang['mfa_method_none_subtext']='Remova a autenticação de multifator da sua conta.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='O helpdesk enviará um e-mail com um código de login aleatório para <strong>%s</strong> ao fazer login.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authenticator App';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Use um aplicativo de smartphone, como Authy ou Google Authenticator, para gerar um código de login aleatório ao fazer login.';
$hesklang['mfa_step_method']='Metódo';
$hesklang['mfa_step_verification']='Verificação';
$hesklang['mfa_step_complete']='Completo';
$hesklang['mfa_introduction']='A autenticação multifator melhora a segurança da conta exigindo que você verifique seu login usando um método de verificação adicional, como e-mail ou um aplicativo autenticador (como Authy ou Google Authenticator).';
$hesklang['mfa_reset_warning']='Você já tem a autenticação multifator habilitada. Completar isso novamente irá redefinir seu dispositivo de autenticação multi-facção (se ativado).';
$hesklang['mfa_select_method_colon']='Selecione um metódo de autenticação:';
$hesklang['mfa_verification_header']='Verificação - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Um email acabou de ser enviado para  <strong>%s</strong> contendo um código de verificação de seis digitos. Cole o código que acabou de receber abaixo para continuar.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Passo 1: Escaneie a imagem abaixo com um aplicado de autenticação no seu dispositivo.';
$hesklang['mfa_verification_auth_app_cant_scan']='Não pode escanear a imagem? Insira este código manualamente no seu dispositivo: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Passo 2: Insira o código de seis digitos apresentado no seu aplicativo para verificar seu dipositivo.';
$hesklang['mfa_verify']='Verificado';
$hesklang['mfa_invalid_method']='Foi recebido um metódo de autenticação multifator inválido.';
$hesklang['mfa_invalid_verification_code']='O código inserido está inválido ou expirado.';
$hesklang['mfa_configured']='Autenticação multifator foi habilitado na sua conta!';
$hesklang['mfa_removed']='Autenticação multifator foi desabilitado da sua conta!';
$hesklang['mfa_verification_needed']='Autenticação multifator está habilitado nesta conta.';
$hesklang['mfa_verification_needed_email']='Por favor, insira o código que foi enviado para seu email.';
$hesklang['mfa_verification_needed_auth_app']='Por favor, insira o código mostrado no seu aplicativo de autenticação.';
$hesklang['mfa_verification_code']='Código de verificação';
$hesklang['mfa_server_time_issue']='A hora do seu servidor parece imprecisa: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Redefinir a autenticação multifator';
$hesklang['mfa_reset_confirm']='Você tem certeza que deseja redefiner o MFA para este usuário?';
$hesklang['mfa_reset_yes']='Redefinir';
$hesklang['mfa_reset']='Autenticação multifator foi redefinada para este usuário.';
$hesklang['desc_mfa_verification']='(Equipe) Código de autenticação multifator';
$hesklang['mfa_code']='Código:';
$hesklang['mfa_backup_codes_header']='SALVE SEUS CÓDIGOS DE RECUPERAÇÃO!';
$hesklang['mfa_backup_codes_description']='Mantenha esses códigos de backup em algum lugar seguro, mas acessível. Caso perca o acesso ao seu dispositivo de MFA ou e-mail, você pode inserir um dos seguintes códigos de backup para fazer login.<br><br><strong>Certifique-se de tratar esses códigos de backup como senhas. Você não poderá ver esses códigos novamente!</strong>';
$hesklang['mfa_verify_another_way']='Verifique sua conta de outra maneira'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Receba um código de verificação no %s';
$hesklang['mfa_verify_another_way_code']='Digite um dos seus códigos de backup de 8 caracteres';
$hesklang['mfa_verify_another_way_admin']='Entre em contato com o administrador do suporte técnico para obter ajuda';
$hesklang['mfa_verify_another_way_reset']='Redefina sua autenticação multifator fazendo upload de um arquivo para o servidor';
$hesklang['mfa_send_another_email']='Enviar outro email.';
$hesklang['mfa_sent']='Um email com o novo código de verificação foi enviado para seu endereço de email';
$hesklang['mfa_backup_code']='Código de backup';
$hesklang['mfa_backup_codes']='Códigos de backup';
$hesklang['mfa_backup_codes_info']='Códigos de uso único para passar na verificação multifator quando não conseguir acessar seu e-mail ou aplicativo autenticador. Depois de usar um código de backup para fazer login, esse código fica inativo.';
$hesklang['mfa_backup_codes_num']='Você pode obter um novo conjunto de 10 códigos de backup sempre que quiser. Quando você cria um novo conjunto de códigos, o conjunto antigo fica automaticamente inativo.';
$hesklang['mfa_backup_codes_num2']='Quantidade de códigos ativos: %s';
$hesklang['mfa_invalid_backup_code']='O código de backup inserido está incorreto ou já foi usado.';
$hesklang['mfa_del_codes']='Apague meus códigos de backup';
$hesklang['mfa_del_codes2']='Todos os seus códigos de backup foram excluídos.';
$hesklang['mfa_new_codes']='Gerar novos códigos de backup';
$hesklang['mfa_new_codes2']='Novos códigos de backup foram gerados';
$hesklang['old_php_version']='Erro: versão PHP não suportada';
$hesklang['category_default_due_date']='Data de vencimento padrão';
$hesklang['category_change_default_due_date']='Coloque uma data de vencimento padrão';
$hesklang['category_leave_blank_for_no_default_due_date']='(em branco caso não tenha data de vencimento padrão)';
$hesklang['category_default_due_date_updated']='Data de vencimento padrão foi atualizada.';
$hesklang['email_formatting']='Formato do e-mail';
$hesklang['email_formatting_html_and_plaintext']='HTML com alternativa de texto simples do modelo de texto simples (padrão)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML com alternativa de texto simples gerada a partir do modelo HTML';
$hesklang['email_formatting_html']='Somente HTML';
$hesklang['email_formatting_plaintext']='Somente texto';
$hesklang['email_formatting_note']='Sua seleção em %1$s &gt; %2$s &gt; %3$s está configurado para: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Isso significa que o Hesk irá ignorar os modelos HTML aqui.';
$hesklang['email_formatting_note1']='Isso significa que o Hesk irá ignorar os modelos de texto aqui.';
$hesklang['email_formatting_note2']='Isso significa que o Hesk gerará uma versão em texto simples de e-mails de seus modelos HTML e ignorará os modelos de texto simples aqui.';
$hesklang['etnu']='Este modelo de e-mail atualmente não é usado pela Hesk com base em sua seleção em %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Editar categoria';
$hesklang['create_category']='Criar categoria';
$hesklang['one_user_included']='1 usuário incluído';
$hesklang['one_user_excluded']='1 usuário removido';
$hesklang['x_users_included']='%s usuários incluídos'; // %s = Number of users
$hesklang['x_users_excluded']='%s usuários removidos'; // %s = Number of users
$hesklang['aa_cat']='Atribuir chamados automaticamente nesta categoria';
$hesklang['modify_autoassign_settings']='Modificar configurações de atribuição automática';
$hesklang['autoassign_on_all_users']='Sim, qualquer usuário pode ter acesso a essa categoria';
$hesklang['autoassign_on_select_users']='Sim, para usuários especificos';
$hesklang['autoassign_off']='Não, enviar chamados como não atribuídos';
$hesklang['autoassign_users']='Usuários a serem incluídos/excluídos na atribuição automática';
$hesklang['autoassign_selected_include']='Os usuários selecionados devem ser <strong>incluídos</strong> ao atribuir chamados automaticamente nesta categoria';
$hesklang['autoassign_selected_exclude']='Os usuários selecionados devem ser <strong>excluídos</strong> ao atribuir chamados automaticamente nesta categoria';
$hesklang['cat_edited']='Categoria %s editada com suceso';
$hesklang['search_for_user']='Busca por usuário';
$hesklang['email_sending']='Enviando emails';
$hesklang['email_to_ticket']='Email para chamado';
$hesklang['email_to_ticket_info']='A conversão de emails em tickets requer alguma configuração do lado do servidor. Para obter detalhes, consulte <a href="%s" target="_blank">este guia da base de conhecimento</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk está usando um servidor SMTP para enviar notificações por e-mail. Seu <strong>%1$s</strong> deve ser definido como <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Está faltando extensão do arquivo';
$hesklang['block_ignore']='E-mail para chamado - Ignore e-mails e evite loops';
$hesklang['block_noreply']='Não responda';
$hesklang['block_noreply2']='Ignore emails sent from &quot;do not reply&quot; email addresses';
$hesklang['block_returned']='Retornado';
$hesklang['block_returned2']='Ignore returned emails, such as delivery status notifications and automated replies';
$hesklang['block_duplicate']='Duplicados';
$hesklang['block_duplicate2']='Ignore e-mails com a mesma mensagem enviada em &quot;%s&quot; segundos'; // %s = "Timeframe"
$hesklang['loop_info']='e-mails recebidos do mesmo endereço de e-mail em &quot;%s&quot; segundos';
$hesklang['thist21']='<li class="smaller">%s | notificação de e-mail atrasada enviada</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | e-mail de acompanhamento enviado</li>'; // %s = date
$hesklang['elevator_header']='Entrando na Área Segura';
$hesklang['elevator_intro']='Você está prestes a entrar em uma área segura.';
$hesklang['elevator_enter_password']='Por favor, digite sua senha para continuar.';
$hesklang['elevator_duration_setting_title']='Duração da área segura';
$hesklang['desc_survey']='(Cliente) E-mail de acompanhamento (pesquisa)'; // Email description
$hesklang['satisfaction']['tab']='Satisfação';
$hesklang['satisfaction']['title']='Pesquisa de satisfação do cliente';
$hesklang['satisfaction']['intro']='Envie a seus clientes uma pesquisa de satisfação de acompanhamento para coletar feedback sobre a experiência deles com seu suporte técnico.';
$hesklang['satisfaction']['tab1']='Configurações';
$hesklang['satisfaction']['tab2']='Excluir';
$hesklang['satisfaction']['enable']='Ativar e-mails de acompanhamento:';
$hesklang['satisfaction']['enabled']='As pesquisas de satisfação do cliente estão ativadas.';
$hesklang['satisfaction']['disabled']='As pesquisas de satisfação do cliente estão desativadas no momento.';
$hesklang['satisfaction']['url']='Endereço do URL da pesquisa:';
$hesklang['satisfaction']['send']='Atraso de e-mail de acompanhamento:';
$hesklang['satisfaction']['at_least']='Espere pelo menos';
$hesklang['satisfaction']['after']='após a resolução do chamado antes de enviar o email';
$hesklang['satisfaction']['h1']='Como usar esta ferramenta?';
$hesklang['satisfaction']['h2']='Primeiro, crie uma pesquisa de satisfação do cliente em sua ferramenta de pesquisa favorita. Se você não tiver certeza de qual ferramenta usar ou quais perguntas fazer, temos um <a href="%s" target="_blank">guia disponível aqui</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Quando sua pesquisa estiver pronta, ative os e-mails de acompanhamento usando o formulário abaixo. A Hesk processará os tickets resolvidos com pelo menos uma resposta da equipe uma vez por hora e enviará o link da pesquisa para seus clientes.';
$hesklang['satisfaction']['e_url']='Insira um endereço de URL de pesquisa válido. Este é o URL para o qual seus clientes serão enviados.';
$hesklang['satisfaction']['as']='Insira um endereço de URL de pesquisa válido. Este é o URL para o qual seus clientes serão enviados.';
$hesklang['satisfaction']['oo1']='Esta página lista os endereços de e-mail para os quais os e-mails de acompanhamento <b>não</b> serão enviados.';
$hesklang['satisfaction']['oo2']='Seus clientes podem optar por não receber e-mails de pesquisa clicando em um link no e-mail. Como alternativa, você pode adicionar manualmente endereços de e-mail nesta página.';
$hesklang['satisfaction']['ooe']='Endereço de e-mail para desativação';
$hesklang['satisfaction']['ooe2']='Digite o endereço de e-mail que você deseja cancelar o recebimento de e-mails de pesquisa.';
$hesklang['satisfaction']['ooe3']='Este endereço de e-mail <i>%s</i> já desativou o recebimento de e-mails de pesquisa.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Desativar este e-mail';
$hesklang['satisfaction']['oob']='Desativado por';
$hesklang['satisfaction']['no_oo']='Nenhum cliente optou por não receber e-mails de pesquisa.';
$hesklang['satisfaction']['oor']='Remover';
$hesklang['satisfaction']['oor2']='E-mail removido da desativação';
$hesklang['satisfaction']['oor3']='Confirmar remoção';
$hesklang['satisfaction']['oor4']='Quando removido da desativação, este usuário receberá novamente e-mails de acompanhamento.';
$hesklang['satisfaction']['optedout']='O endereço de e-mail <i>%s</i> foi desativado para não receber e-mails de pesquisa.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='ID de pesquisa ausente ou inválido';
$hesklang['satisfaction']['starting']='Iniciando o processo de notificação da pesquisa de satisfação do cliente';
$hesklang['satisfaction']['tc']='Encontrados %s chamados fechados que não tiveram a pesquisa de satisfação enviada.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Pesquisa de satisfação do cliente finalizada. E-mails enviados: %1$s. Falha ao enviar e-mails: %2$s. Chamados sem e-mail: %3$s. Chamados com e-mail de desativação: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignorando, este cliente não deseja receber e-mails de pesquisa.';
$hesklang['satisfaction']['ne']='Ignorando, este chamado está sem endereço de e-mail';
$hesklang['satisfaction']['feat1']='Crie sua pesquisa usando qualquer ferramenta de terceiros, como o Google Forms';
$hesklang['satisfaction']['feat2']='Configure seu URL de pesquisa, preferências e limitações dentro deste módulo';
$hesklang['satisfaction']['feat3']='quando você resolver um chamado, a Hesk enviará um e-mail ao seu cliente com o link para a pesquisa';
$hesklang['dfor']='Formato da data';
$hesklang['dtfor']='Data e Hora';
$hesklang['cdfor']='Formato de hora selecionado.';
$hesklang['custom']='Personalizado';
$hesklang['jsc_notice']='A seleção de data\'t não suporta formatação de data no estido PHP. Selecione uma das opções pré-configuradas ou clique no ícone %s abaixo para ver as opções de exibição disponíveis.'; // %s = replaced by icon
$hesklang['lcf3']='Somente data'; // Display: "Date only"
$hesklang['epdd']='Erro ao analisar o parâmetro due_date:';
$hesklang['edit_pass']='Editar senha';
$hesklang['save_pass']='Salvar senha';
$hesklang['cur_pass']='Senha atual';
$hesklang['cur_pass2']='Você deve fornecer sua senha atual para alterá-la.';
$hesklang['cur_pass3']='Após uma atualização de senha bem-sucedida, você será redirecionado para a página de login, onde poderá fazer login com sua nova senha.';
$hesklang['e_new_pass']='Por favor, digite sua nova senha';
$hesklang['pass_len']='A senha não deve exceder 64 caracteres';
$hesklang['pass_login']='Faça login novamente após alterar sua senha';
$hesklang['bf_int']='Você foi desconectado devido a muitas tentativas de verificação com falha';
$hesklang['tst_cnt']='Número de e-mails que seu servidor de e-mail enviará para Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='Você tem muitos emails não lidos em sua caixa de correio (%1$s). O Hesk transformará todos esses e-mails em chamados.<br><br>Você pode marcar os e-mails existentes como lidos antes de ativar %2$s ou usar uma nova conta de e-mail para o Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Você tem muitos e-mails em sua caixa de correio (%1$s). O Hesk transformará todos esses e-mails em chamados.<br><br>Você pode excluir os e-mails existentes antes de ativar %2$s ou usar uma nova conta de e-mail para o Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Vence em'; // Due on (date)
$hesklang['search_due_date_range']='Vencimento em'; // Due in (X days)
$hesklang['attachment_add_files']='Adicionar arquivo.';
$hesklang['attachment_max_exceeded']='Este arquivo não será carregado porque você já carregou o número máximo de arquivos permitidos.';
$hesklang['attachment_viewer_message']='Arraste os arquivos para esta área ou clique no botão \'Adicionar arquivo\' abaixo para selecionar arquivos para enviar.';
$hesklang['attachment_invalid_type_message']='Desculpe, mas o tipo de arquivo que você tentou enviar não é permitido.';
$hesklang['attachment_upload_error']='Ocorreu um erro ao tentar fazer o upload. Por favor, tente novamente mais tarde.';
$hesklang['attachment_too_large']='Este anexo é maior que o tamanho máximo de arquivo permitido.';
$hesklang['attachment_cancel']='Cancelar';
$hesklang['attachment_confirm_cancel']='Tem certeza de que deseja cancelar este envio?';
$hesklang['attachment_remove']='Remover anexo';
$hesklang['attachment_too_many_uploads']='Muitos anexos foram enviados de seu local em um curto período de tempo. Por favor, tente novamente mais tarde.';
$hesklang['sub_note']='Enviar nota';
$hesklang['can_view_users']='Ver todos os usuários (mas não gerenciá-los)';
$hesklang['welcome1']='Ei, você parece ser novo aqui. Bem-vindo!';
$hesklang['welcome2']='Para ajudá-lo a começar, confira o %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Guia de início rápido da Hesk';
$hesklang['tmce1']='Use Ctrl com o botão direito para acessar o corretor ortográfico.';
$hesklang['tmce2']='Segure a tecla Control (Ctrl) e clique com o botão direito do mouse na palavra incorreta para acessar o corretor ortográfico.';
$hesklang['desc_new_ticket_by_staff']='(Cliente) Novo chamado enviado pela equipe';
$hesklang['mod_et_h']='Você pode modificar os modelos de e-mail em %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Definir idioma para';
$hesklang['ouwa']='Apenas os usuários com acesso a esta categoria estão listados abaixo. Para adicionar membros da equipe a esta categoria, edite suas permissões na página %s'; // %s = Team
$hesklang['previous_tickets']='Chamados anteriores';
$hesklang['no_previous']='Sem chamados anteriores para %s'; // %s = email address
$hesklang['all_previous']='Listar todos os chamados anteriores';
$hesklang['confirm_delete_ticket']='Tem certeza de que deseja excluir permanentemente este chamado?';
$hesklang['confirm_delete_reply']='Tem certeza de que deseja excluir esta resposta permanentemente?';
$hesklang['select_new_category']='Número de chamados nesta categoria: %s<br><br>Selecione uma nova categoria para transferir esses chamados:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Número de chamados atribuídos a este usuário: %1$s<br>Número de chamados <b>abertos</b> atribuídos a este usuário: %2$s chamados<br><br><b>Aberto</b> será <b>não atribuído</b> após a exclusão deste usuário.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Licença HESK';
$hesklang['hlic_free']='GRATIS';
$hesklang['hlic_buyl']='Compre uma licensa';
$hesklang['hlic_paid']='Licenciado';
$hesklang['antdemo']='O envio de chamados do painel de administração foi desativado no modo de demonstração.<br><br>Use o <a href="%s" target="_blank">lado público</a> para enviar um chamado de teste.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Método de Autenticação';
$hesklang['email_authentication_method_username_password']='Básico (Usuário / Senha)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Nenhum provedor OAuth verificado configurado.';
$hesklang['email_authentication_method_oauth_link']='Gerenciar provedores OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL do endpoint de autorização';
$hesklang['email_oauth_token_url']='URL do Token do Endpoint';
$hesklang['email_oauth_client_id']='ID do Cliente';
$hesklang['email_oauth_client_secret']='Segredo do Cliente';
$hesklang['email_oauth_scope']='Escopo';
$hesklang['oauth_error_invalid_state']='O estado OAuth não corresponde ao estado enviado ao provedor OAuth.';
$hesklang['oauth_error_unknown']='Ocorreu um erro desconhecido ao tentar salvar os tokens OAuth.';
$hesklang['oauth_error_no_token']='Token de acesso ausente na resposta JSON.';
$hesklang['oauth_error_retrieve']='Não é possível recuperar um token de acesso. Confirme as configurações do seu provedor OAuth e salve-as novamente para adquirir um novo token.';
$hesklang['email_oauth_provider']='Provedor OAuth';
$hesklang['email_oauth_providers']='Provedores OAuth';
$hesklang['email_oauth_provider_guide']='Antes de usar o OAuth, você deve registrar um provedor OAuth. Para detalhes, consulte <a href="%s" target="_blank">este guia da base de conhecimento</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Seu URI de redirecionamento OAuth para Hesk é:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Use esta ferramenta para adicionar provedores OAuth ao seu help desk';
$hesklang['email_oauth_provider_name']='Nome'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Novo Provedor';
$hesklang['email_oauth_edit_provider']='Editar Provedor';
$hesklang['email_oauth_provider_being_used_for']='Sendo usado para';
$hesklang['email_oauth_providers_none']='Nenhum provedor OAuth salvo. Você pode adicioná-los clicando em "Novo provedor" acima.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Este provedor não pode ser removido porque está sendo usado pelo help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Tem certeza de que deseja excluir este provedor OAuth?';
$hesklang['oauth_provider_saved']='O provedor OAuth foi salvo';
$hesklang['oauth_provider_use']='Agora você pode selecionar este provedor em %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Insira o nome do provedor';
$hesklang['oauth_provider_err_auth_url']='Insira uma URL de autorização válida';
$hesklang['oauth_provider_err_token_url']='Insira uma URL de Token válida';
$hesklang['oauth_provider_err_client_id']='Insira o ID do Cliente';
$hesklang['oauth_provider_err_client_secret']='Insira o Segredo do Cliente';
$hesklang['oauth_provider_err_scope']='Insira o Escopo';
$hesklang['oauth_provider_deleted']='Provedor OAuth excluído';
$hesklang['oauth_provider_not_found']='Este provedor OAuth não existe';
$hesklang['oauth_provider_verified']='Verificado';
$hesklang['oauth_provider_click_to_verify']='Clique para verificar';
$hesklang['can_due_date']='Pode definir data de vencimento'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Você não tem permissão para definir datas de vencimento';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verifique seu Registro';
$hesklang['customer_verify_new_email']='Verifique seu Novo Endereço de E-mail';
$hesklang['customer_reset_password']='Redefinir sua Senha do Help Desk';
$hesklang['customer_approved']='Conta Aprovada';
$hesklang['customer_rejected']='Conta Rejeitada';
$hesklang['email_rejected']='Conta necessária para enviar tickets de suporte';
$hesklang['require_curl']='Esta funcionalidade requer que o suporte ao <strong>cURL</strong> esteja habilitado no PHP do seu servidor. Peça ao seu host da web para habilitar cURL para PHP.';
$hesklang['customer_accounts_heading']='Contas de Clientes';
$hesklang['customer_accounts']='Contas de clientes';
$hesklang['customer_accounts_off']='<strong>Desabilitado</strong>';
$hesklang['customer_accounts_allowed']='<strong>Habilitado - Opcional</strong> (os clientes podem enviar tickets de suporte sem se registrar ou fazer login)';
$hesklang['customer_accounts_required_to_submit']='<strong>Habilitado - Obrigatório para tickets</strong> (somente clientes logados podem enviar tickets de suporte)';
$hesklang['customer_accounts_required']='<strong>Habilitado - Necessário para acessar</strong> (somente clientes logados podem acessar o help desk e a base de conhecimento)';
$hesklang['customer_accounts_reg']='Registro de conta';
$hesklang['customer_accounts_reg_customer']='Os clientes podem registrar contas';
$hesklang['customer_accounts_reg_approve']='Os clientes podem registrar uma conta, a equipe deve aprovar novos registros';
$hesklang['customer_accounts_reg_staff']='Somente a equipe pode registrar contas de clientes';
$hesklang['customer_accounts_allow_email_changes']='Permitir que os clientes alterem seus endereços de e-mail';
$hesklang['customer_accounts_allow_email_resends']='Tempo até que os clientes possam solicitar um novo e-mail de verificação';
$hesklang['customer_login']='Entrar';
$hesklang['customer_logout']='Sair';
$hesklang['customer_register']='Registrar';
$hesklang['customer_accounts_disabled']='Os logins e registros de clientes estão desabilitados.';
$hesklang['customer_accounts_registration_disabled']='Os registros de clientes estão desativados.';
$hesklang['customer_forgot_password']='Esqueceu a Senha?';
$hesklang['customer_email']='Endereço E-mail';
$hesklang['customer_accounts_email_banned']='Você foi banido do uso deste helpdesk.';
$hesklang['customer_registration_successful']='Registro realizado com sucesso!';
$hesklang['customer_registration_email_exists_no_reset_link']='Uma conta com o e-mail %s já existe.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Uma conta com o e-mail %s já existe. <a href="login.php">Você deseja efetuar login em vez disso</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Uma conta com o e-mail %s já existe e está pendente de verificação de e-mail.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Uma conta com o e-mail %s já existe e está pendente de aprovação da equipe.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Verifique seu E-mail';
$hesklang['customer_registration_check_your_email_content']='Você deve verificar seu endereço de e-mail antes de poder efetuar login.<br><br>Se você não recebê-lo em alguns minutos, verifique suas pastas de Lixo Eletrônico, Lixeira ou Spam. Marque a mensagem como <b>Não é SPAM</b> para evitar problemas no recebimento de nossa correspondência no futuro.';
$hesklang['customer_login_not_verified']='Você deve verificar seu endereço de e-mail antes de poder efetuar login.';
$hesklang['customer_login_not_verified2']='Se você não recebeu o e-mail de verificação, verifique suas pastas de Lixo Eletrônico, Lixeira ou Spam. Marque a mensagem como <b>Não é SPAM</b> para evitar problemas no recebimento de e-mail no futuro.';
$hesklang['customer_login_resend_verification_email']='Reenviar e-mail de verificação';
$hesklang['customer_login_resend_verification_email_none']='Não há verificações de e-mail pendentes para enviar.';
$hesklang['customer_login_resend_verification_email_too_early']='Você não pode solicitar um novo e-mail de verificação neste momento. Tente novamente mais tarde.';
$hesklang['customer_login_not_approved']='Um membro da equipe deve aprovar sua conta antes de poder efetuar login. Após a aprovação, você será notificado por e-mail.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verificar Registro';
$hesklang['customer_registration_verify_success']='Seu e-mail foi verificado e agora você pode fazer login usando o formulário abaixo.';
$hesklang['customer_registration_verify_approval_needed']='Seu e-mail foi verificado. No entanto, um membro da equipe precisa aprovar sua conta antes de poder fazer login. Após a aprovação, você será notificado por e-mail.';
$hesklang['customer_registration_verify_failure']='Seu e-mail não pôde ser verificado. O link já foi usado ou expirou.';
$hesklang['emails_to_customers']='&raquo; E-mails enviados aos clientes';
$hesklang['emails_to_staff']='&raquo; E-mails enviados para a equipe';
$hesklang['emails_to_everyone']='&raquo; E-mails enviados para funcionários ou clientes';
$hesklang['new_customer_approval']='Você tem contas de clientes pendentes de aprovação'; // Email subject
$hesklang['desc_new_customer_approval']='(Equipe) Contas de clientes aguardando aprovação';
$hesklang['n_cust_app']='Há aprovações pendentes do cliente'; // Notify me when...
$hesklang['et_num_customers']='Número de aprovações pendentes';
$hesklang['et_link_customers']='Link para a página Gerenciar clientes';
$hesklang['et_link_verify']='Link de verificação';
$hesklang['et_cust_login']='URL de login do cliente';
$hesklang['submit_ticket_customer_email_exists']='Um cliente com este e-mail já existe. Por favor, <a href="login.php?email=%s">faça login</a> para enviar um ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Por favor, insira um endereço de e-mail válido.';
$hesklang['customer_login_password_required']='Por favor, digite sua senha.';
$hesklang['customer_login_remember_just_email']='Lembre-se apenas do meu e-mail';
$hesklang['customer_login_remember_email']='Lembrar meu e-mail';
$hesklang['customer_wrong_user']='Seu endereço de e-mail %s não está registrado conosco.<br><br>Você deseja <a href="register.php">criar uma conta</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Seu endereço de e-mail e senha não correspondem aos nossos registros.<br><br>Você deseja <a href="login.php?submittedForgot=1">redefinir sua senha</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Por favor, faça login para continuar.';
$hesklang['customer_register_here']='Se você não tem uma conta conosco, você pode <a href="register.php">registrar-se aqui</a>.';
$hesklang['create_account']='Criar uma conta';
$hesklang['customer_my_tickets_heading']='Meus tickets';
$hesklang['customer_my_tickets_description']='Ver todos os seus tickets anteriores';
$hesklang['customer_my_tickets_search_for_tickets']='Pesquisar por tickets';
$hesklang['customer_password_reset_successful']='Sua nova senha foi salva. Agora você pode efetuar login.';
$hesklang['customer_profile']='Perfil';
$hesklang['customer_edit_profile']='Editar Perfil';
$hesklang['customer_edit_pass']='Editar Senha';
$hesklang['customer_edit_pass_same']='Sua nova senha não deve ser igual à atual.';
$hesklang['customer_change_email']='Alterar e-mail';
$hesklang['customer_change_email_banned']='O e-mail que você digitou foi banido.';
$hesklang['customer_change_email_pending']='Há uma solicitação atual para alterar seu endereço de e-mail para: <b>%s</b><br><br>Enviamos um e-mail para este endereço. Clique no link dentro do e-mail para confirmar a alteração.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Reenviar e-mail de confirmação</a>';
$hesklang['customer_change_email_submitted']='Clique no link de verificação que foi enviado para <b>%s</b> para verificar seu novo e-mail.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Seu novo endereço de e-mail foi verificado e seu perfil foi atualizado.';
$hesklang['customer_change_email_disabled']='A capacidade de atualizar seu e-mail está desabilitada. Entre em contato conosco se desejar alterar seu endereço de e-mail.';
$hesklang['customer_profile_saved']='Seu perfil foi salvo.';
$hesklang['customers']='Clientes';
$hesklang['customers_intro']='As contas de clientes permitem que os clientes visualizem todos os seus tickets em um local central.';
$hesklang['sure_remove_customer']='Tem certeza de que deseja remover este cliente?';
$hesklang['sure_remove_customer_additional_note']='A exclusão de um cliente é definitiva. Uma vez excluído, ele não pode ser recuperado!';
$hesklang['new_customer']='Novo Cliente';
$hesklang['new_follower']='Novo Seguidor';
$hesklang['add_customer']='+ Adicionar Cliente'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Adicionar Seguidor'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='O cliente fornecido ainda não existe. Clique em "Salvar" se você quiser criar este cliente.';
$hesklang['followers']='Seguidores';
$hesklang['no_customers']='Atualmente não há clientes no banco de dados.';
$hesklang['no_customers_disabled']='Você começará a ver clientes aqui quando eles enviarem tickets de suporte.';
$hesklang['no_customers_enabled']='Você começará a ver clientes aqui quando eles se registrarem ou enviarem tickets de suporte.';
$hesklang['no_customers_enabled2']='Alternativamente, os botões acima desta mensagem permitem que você crie manualmente contas de clientes ou importe clientes existentes para o help desk.';
$hesklang['import_customers']='Importar Clientes';
$hesklang['import_customers_tip']='Use um arquivo CSV para importar vários clientes de uma só vez.';
$hesklang['customer_not_found']='Cliente não encontrado para o ticket!';
$hesklang['search_by_name_or_email']='Pesquisar por nome ou e-mail...';
$hesklang['search_by_pattern']='Pesquisar por padrão...';
$hesklang['is_searchable']='Pesquisável';
$hesklang['custom_is_searchable']='Pesquisável';
$hesklang['yes_via_autocomplete']='SIM (pesquisar via preenchimento automático)';
$hesklang['customer_required']='Você deve selecionar um cliente';
$hesklang['customer_email_exists']='Já existe um cliente com este e-mail.';
$hesklang['customer_name_with_no_email_exists']='Já existe um cliente com este nome e sem e-mail.';
$hesklang['an_error_occurred_validating_email']='Ocorreu um erro ao tentar verificar o endereço de e-mail inserido.';
$hesklang['customer_count_x_more']='+%s mais'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registrado';
$hesklang['customer_account_verified']='Verificado';
$hesklang['customer_account_verified_help']='Os clientes devem verificar sua conta por meio de um link de ativação enviado para seu endereço de e-mail antes de poderem fazer login em sua conta.';
$hesklang['customer_account_setting_password_will_verify_user']='Definir uma senha para este cliente verificará automaticamente sua conta.';
$hesklang['deleting_customer_with_tickets']='Este cliente tem %1$s ticket(s) <b>(%2$s abertos)</b> que também têm outros clientes associados a eles.<br>O que deve ser feito com esses tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='É necessário um endereço de e-mail válido para reenviar um e-mail de verificação.';
$hesklang['customer_resend_verification_email_not_found']='Não existe nenhuma conta com este endereço de e-mail ou a conta já foi verificada.';
$hesklang['customer_resend_verification_email_sent']='Um e-mail de verificação foi enviado para seu endereço de e-mail.<br><br>Se você não recebê-lo em alguns minutos, verifique suas pastas de Lixo Eletrônico, Lixeira ou Spam. Marque a mensagem como <b>Não é SPAM</b> para evitar problemas no recebimento de e-mail no futuro.';
$hesklang['customer_permission_denied']='Você não tem permissão para modificar clientes.';
$hesklang['customer_manage_approvals']='Contas de clientes pendentes de aprovação: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Aprovar cliente';
$hesklang['customer_manage_bulk_approve']='Aprovar clientes selecionados';
$hesklang['customer_manage_bulk_approve_complete']='Clientes aprovados: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Rejeitar cliente';
$hesklang['customer_manage_bulk_reject']='Rejeitar clientes selecionados';
$hesklang['customer_manage_bulk_reject_complete']='Clientes rejeitados: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Excluir cliente';
$hesklang['customer_manage_bulk_delete']='Excluir clientes selecionados';
$hesklang['customer_manage_bulk_delete_complete']='Clientes excluídos: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Editar cliente';
$hesklang['customer_manage_verification_email_sent']='O e-mail de verificação foi enviado para %s'; // %s = customer's email
$hesklang['can_man_customers']='Gerenciar clientes';
$hesklang['can_view_customers']='Visualizar todos os clientes (mas não gerenciá-los)';
$hesklang['import_customer_select_file']='Selecionar arquivo';
$hesklang['import_customer_step1_instructions']='Para importar clientes, prepare um arquivo CSV (Valores Separados por Vírgula).';
$hesklang['import_customer_step1_note']='Selecione seu arquivo CSV';
$hesklang['import_customer_step1_separator']='As colunas no meu arquivo CSV são separadas por';
$hesklang['import_customer_sample']='&raquo; Arquivos CSV de amostra';
$hesklang['import_customer_sample_1']='Arquivo CSV no estilo dos EUA com colunas separadas por ,';
$hesklang['import_customer_sample_2']='Arquivo CSV estilo UE com colunas separadas por ;';
$hesklang['import_customer_upload_requirements_1']='Seu arquivo CSV deve incluir pelo menos uma coluna de nome ou endereço de e-mail. A coluna de senha é opcional.';
$hesklang['import_customer_upload_requirements_2']='A primeira linha do seu arquivo deve conter cabeçalhos de coluna.';
$hesklang['import_customer_upload_requirements_3']='Seu arquivo deve ser codificado em UTF-8.';
$hesklang['import_customer_select_columns']='Selecionar Colunas';
$hesklang['import_customer_upload_customers']='Carregar clientes';
$hesklang['import_customer_column_name']='Coluna de Nome';
$hesklang['import_customer_column_email']='Coluna de e-mail';
$hesklang['import_customer_column_pass']='Coluna de senha';
$hesklang['import_customer_step2_note']='Selecione o nome correto da coluna do seu arquivo CSV nos menus suspensos e clique em "Avançar".';
$hesklang['import_customer_name_or_email_required']='Nome ou e-mail é obrigatório';
$hesklang['import_customer_step3_note']='Seus clientes estão sendo importados. Não saia desta página!';
$hesklang['import_customer_step3_pending']='Pendente';
$hesklang['import_customer_step3_successful_imports']='Importações bem-sucedidas';
$hesklang['import_customer_step3_failed_imports']='Importações com falha';
$hesklang['import_customer_step3_progress']='Progresso';
$hesklang['import_customer_step3_complete_some_failed']='O processo de importação foi concluído, no entanto, <b>%s</b> clientes falharam na importação. Verifique a tabela abaixo para obter mais informações.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='O processo de importação foi concluído!';
$hesklang['import_customer_step3_importing']='Importando';
$hesklang['staff_deleted']='[Equipe excluída]';
$hesklang['customer_account_approved']='Registro de cliente aprovado';
$hesklang['customer_account_rejected']='Registro de cliente rejeitado';
$hesklang['customer_account_deleted']='Registro de cliente excluído';
$hesklang['ticket_followers']='Seguidores de tickets';
$hesklang['ticket_followers2']='Permitir que os tickets tenham vários clientes';
$hesklang['add_cc']='Adicionar Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separe cada e-mail com uma vírgula.';
$hesklang['search_customers']='Pesquisar clientes';
$hesklang['page_size']='Tamanho da página';
$hesklang['customers_on_pages']='Número de clientes: %d | Número de páginas: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Cliente) Redefinir sua senha';
$hesklang['desc_customer_verify_registration']='(Cliente) Verifique seu registro';
$hesklang['desc_customer_verify_new_email']='(Cliente) Verifique seu novo e-mail';
$hesklang['desc_customer_approved']='(Cliente) Conta aprovada';
$hesklang['desc_customer_rejected']='(Cliente) Conta rejeitada';
$hesklang['desc_email_rejected_can_self_register']='(Cliente) Ticket via e-mail rejeitado; o cliente pode se autocadastrar';
$hesklang['desc_email_rejected_cannot_self_register']='(Cliente) Ticket via e-mail rejeitado; o cliente não consegue se autoregistrar';
$hesklang['user_added_success_no_pass']='Novo usuário %s foi adicionado com sucesso';
$hesklang['email_tag_requester']='Solicitante (De)';
$hesklang['email_tag_requester_name']='Nome do solicitante (de)';
$hesklang['email_tag_requester_first_name']='Primeiro Nome do solicitante (de)';
$hesklang['email_tag_requester_email']='E-mail do solicitante (de)';
$hesklang['email_tag_followers']='Seguidores (Cc)';
$hesklang['email_tag_follower_names']='Seguidor (Cc) Nomes';
$hesklang['email_tag_follower_emails']='Seguidor (Cc) E-mails';
$hesklang['barcode']='Código de barras';
$hesklang['barcode_use']='Exibir um código de barras nos tickets impressos';
$hesklang['barcode_staff_only']='Ocultar o código de barras dos clientes';
$hesklang['barcode_type']='Tipo de código de barras';
$hesklang['barcode_format']='Formato';
$hesklang['barcode_width']='Largura';
$hesklang['barcode_height']='Altura';
$hesklang['barcode_color']='Cor';
$hesklang['barcode_bg']='Fundo';
$hesklang['copy_link']='Copiar link do ticket';
$hesklang['copy_link_title']='Copiar link público para este ticket';
$hesklang['copy_link_exp']='O link copiado é o link direto para o cliente visualizar este ticket';
$hesklang['copy_value']='Copiar este valor';
$hesklang['download_class']='Esta função requer a classe ZipArchive. Peça ao seu host para compilar o PHP com suporte a zip.';
$hesklang['download_all']='Baixar tudo';
$hesklang['download_prep']='Preparando download...';
$hesklang['download_tma']='Muitos anexos';
$hesklang['download_nva']='Nenhum anexo válido';
$hesklang['download_ntd']='Nada para baixar';
$hesklang['resolved_at']='Resolvido em';
$hesklang['disable_GSSAPI']='Desabilitar autenticador GSSAPI (solução alternativa para erro do Kerberos)';
$hesklang['ex_history']='Incluir histórico de tickets na exportação';
$hesklang['sm_location']='Localização'; // Location (page) of a service message
$hesklang['loc_sm']='Mostrar esta mensagem de serviço em:';
$hesklang['loc_all']='Cada página do cliente';
$hesklang['loc_norec']='(não recomendado)';
$hesklang['loc_home']='Página inicial do help desk';
$hesklang['loc_selected']='Em páginas selecionadas';
$hesklang['loc_selerr']='Selecione pelo menos uma página para mostrar a mensagem';
$hesklang['loc_t_cat']='Enviar um ticket - selecione uma categoria';
$hesklang['loc_t_add']='Enviar um ticket - formulário para enviar um ticket';
$hesklang['loc_t_ok']='Enviar um ticket - confirmação do ticket';
$hesklang['loc_t_view']='Ver um ticket';
$hesklang['loc_t_form']='Visualizar um formulário de ticket';
$hesklang['loc_kb_main']='Página inicial da base de conhecimento';
$hesklang['loc_kb_sub']='Páginas de subcategoria da base de conhecimento';
$hesklang['loc_kb_art']='Artigos da base de conhecimento';
$hesklang['loc_login']='Página de login do cliente';
$hesklang['loc_register']='Página de registro do cliente';
$hesklang['loc_register_ok']='Registro de cliente realizado com sucesso';
$hesklang['loc_acc']='Página do cliente &quot;Meus tickets&quot;';
$hesklang['loc_profile']='Página &quot;Perfil&quot; do cliente';
$hesklang['sending_show']='Mostrar notificação &quot;Enviando&quot;';
$hesklang['sending_wait']='Enviando, aguarde...';
$hesklang['e_c_email']='Digite o endereço de e-mail correto para visualizar este ticket';
$hesklang['only_verified_cc']='Seguidores sem uma conta verificada serão ignorados.';
$hesklang['followers_removed']='Esses endereços de e-mail foram removidos do ticket porque não têm uma conta verificada:';
$hesklang['novace']='Não encontramos nenhuma conta registrada e verificada com este endereço de e-mail.';
$hesklang['max_recipients']='Máximo de destinatários';
$hesklang['max_recipients2']='em um único e-mail';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Carregue um arquivo Javascript personalizado extra para o painel de administração';
$hesklang['cf_limit_all']='Você atingiu o limite de campos personalizados e não pode criar novos campos personalizados.';
$hesklang['remind_assigned']='Lembrar equipe designada';
$hesklang['remind_sent']='Lembrete por e-mail enviado ao membro da equipe designado';
$hesklang['thist23']='<li class="smaller">%s | lembrete enviado para %s por %s</li>';
$hesklang['ql_bookmarks']='Marcadores';
$hesklang['bookmark']='Meu Favorito';
$hesklang['bookmarks_add']='Adicionar aos favoritos';
$hesklang['bookmarks_added']='Este bilhete foi adicionado aos seus favoritos';
$hesklang['bookmarks_remove']='Remover dos favoritos';
$hesklang['bookmarks_removed']='Este ticket foi removido dos seus favoritos';
$hesklang['genl_not_copied']='Erro: A cópia para a área de transferência não é suportada neste dispositivo/navegador.';
$hesklang['profile_duplicate_email']='Usuário com e-mail <b>%s</b> já existe.'; // %s: new email
$hesklang['seq_id_numeric']='A pesquisa por número de ticket deve conter apenas números';
$hesklang['confirm_new_pass']='Confirmar nova senha';
$hesklang['piping_notify_rejected_customers1']='E-mails de rejeição de clientes';
$hesklang['piping_notify_rejected_customers2']='Enviar um e-mail de rejeição aos clientes quando o ticket for rejeitado';
$hesklang['piping_notify_rejected_customers3']='Tempo entre e-mails de rejeição';
$hesklang['register_url']='URL de registro';
$hesklang['email_subject']='Assunto do e-mail';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Colaborando no ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] A equipe respondeu a: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Nota adicionada a: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket vencido: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolvido: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Data limite para envio de e-mail de acompanhamento:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Não envie por e-mail tickets resolvidos há mais de'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='atrás (deve ser um período de tempo maior que "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='O prazo final do e-mail deve ser maior que o intervalo do e-mail de follow-up';
$hesklang['available_language']='Idiomas Disponíveis';
$hesklang['click_to_show_available_language']='Clique para ver idiomas disponíveis';
$hesklang['install_lan']='Instalar';
$hesklang['remove_lan']='Remover';
$hesklang['title_lan']='Título';
$hesklang['description_lan']='Descrição';
$hesklang['completed_lan']='Concluído';
$hesklang['no_language_availble']='Nenhum idioma disponível';
$hesklang['success_install_lan_txt']='idioma foi adicionado com sucesso';
$hesklang['error_install_lan_txt']='idioma não foi adicionado';
$hesklang['success_remove_lan_txt']='idioma foi removido com sucesso';
$hesklang['error_remove_lan_txt']='idioma não foi removido';
$hesklang['remove_default_language_error']='O idioma padrão deve permanecer ativo e não pode ser removido';
$hesklang['click_for_manual_step']='Clique para instalação manual';
$hesklang['upgrade_lan']='Atualizar';
$hesklang['success_upgrade_lan_txt']='idioma foi atualizado com sucesso';
$hesklang['error_upgrade_lan_txt']='idioma não foi atualizado';
$hesklang['please_wait']='Aguarde...';
$hesklang['add_a_note']='Adicionar uma nota';
$hesklang['add_a_reply']='Adicionar uma resposta';
$hesklang['customer_id']='ID do cliente';
$hesklang['deleting_customer_tickets']='Tickets abertos pelo cliente: <b>%1$s</b><br>O que devemos fazer com esses tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets onde o cliente está em cópia: <b>%1$s</b><br>Estes perderão este cliente como seguidor; os tickets permanecem inalterados.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Excluir tickets permanentemente';
$hesklang['deleting_customer_anonymize_tickets2']='Anonimizar tickets (remover mensagens e dados pessoais)';
$hesklang['deleting_customer_retain_tickets2']='Manter tickets (deixar todos os dados intactos)';
$hesklang['for_staff']='para equipe de suporte'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='para clientes'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='Caixa de correio IMAP';
$hesklang['file_attachment_options']='Opções de anexo de e-mail';
$hesklang['link_to_attachments_in_emails']='Link para anexos em e-mails';
$hesklang['add_attachments_directly_to_emails']='Adicionar anexos diretamente a e-mails';
$hesklang['directly_attach_file_smaller_than']='Anexar diretamente apenas arquivos menores que';
$hesklang['directly_attach_file_of_any_size']='Anexar diretamente arquivos de qualquer tamanho';
$hesklang['directly_attach_only_first_x_attachments']='Anexar diretamente apenas os primeiros';
$hesklang['directly_attach_all_attachments']='Anexar diretamente todos os anexos';
$hesklang['directly_attach_size']='Tamanho do anexo';
$hesklang['directly_attach_no_of_files']='Número de arquivos';
$hesklang['notice_about_directly_attach_files']='Anexar muitos ou grandes arquivos a e-mails pode causar atrasos na comunicação com seu servidor SMTP';
$hesklang['fatt_2']='Arquivos adicionais anexados a esta mensagem:';
$hesklang['no_collaborators']='Nenhum';
$hesklang['collaborate']='Colaborar neste ticket';
$hesklang['collaborators']='Colaboradores';
$hesklang['ql_cbm']='Colaborador';
$hesklang['collaborating']='Agora você está colaborando neste ticket';
$hesklang['not_collaborating']='Você não está mais colaborando neste ticket';
$hesklang['add_collaborator']='Adicionar um colaborador';
$hesklang['user_collaborator_added']='Usuário adicionado como colaborador neste ticket';
$hesklang['remove_collaborator']='Remover colaborador';
$hesklang['staff_name']='Nome da equipe';
$hesklang['user_collaborator_removed']='Usuário removido como colaborador neste ticket';
$hesklang['desc_collaborator_added']='(Equipe) Você está colaborando em um novo ticket';
$hesklang['desc_collaborator_staff_reply']='(Equipe) Um membro da equipe respondeu a um ticket colaborativo';
$hesklang['desc_collaborator_note']='(Equipe) Nova nota adicionada a um ticket colaborativo';
$hesklang['desc_collaborator_resolved']='(Equipe) Um ticket colaborativo foi resolvido';
$hesklang['desc_collaborator_overdue']='(Equipe) Um ticket colaborativo está atrasado';
$hesklang['notify_collaborator_added']='Fui adicionado como colaborador de ticket';
$hesklang['notify_collaborator_customer_reply']='Cliente responde a um ticket colaborativo';
$hesklang['notify_collaborator_staff_reply']='Equipe responde a um ticket colaborativo';
$hesklang['notify_collaborator_note']='Equipe adiciona uma nota a um ticket colaborativo';
$hesklang['notify_collaborator_resolved']='Equipe resolve um ticket colaborativo';
$hesklang['notify_collaborator_overdue']='Ticket colaborativo está atrasado';
$hesklang['recurring_tickets']['tab']='Tickets Recorrentes'; // Menu link
$hesklang['recurring_tickets']['page_title']='Tickets Recorrentes'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatize o trabalho rotineiro; deixe o Hesk criar tickets rotineiros para você, exatamente quando você precisar.';
$hesklang['recurring_tickets']['active_rules']='Regras ativas';
$hesklang['recurring_tickets']['new']='Nova regra de ticket recorrente';
$hesklang['recurring_tickets']['no_rules']='Você não tem nenhuma regra de ticket recorrente. Crie uma clicando no botão "Nova regra de ticket recorrente" acima.';
$hesklang['recurring_tickets']['title']='Título da regra';
$hesklang['recurring_tickets']['titlet']='Um título descritivo, por exemplo: Reatribuir tickets não respondidos em um dia';
$hesklang['recurring_tickets']['default_title']='Regra por %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Gatilho da regra';
$hesklang['recurring_tickets']['trigt']='Defina a condição que acionará (executará) esta regra.';
$hesklang['recurring_tickets']['hits']='Execuções'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Tempo de Criação'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Configurações Gerais'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Campos Personalizados'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Conteúdo'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Excluir esta regra?';
$hesklang['recurring_tickets']['edit']='Editando regra de ticket recorrente ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Dentro de:';
$hesklang['recurring_tickets']['minutes']='minutos';
$hesklang['recurring_tickets']['hours']='horas';
$hesklang['recurring_tickets']['days']='dias';
$hesklang['recurring_tickets']['weeks']='semanas';
$hesklang['recurring_tickets']['months']='meses';
$hesklang['recurring_tickets']['years']='anos';
$hesklang['recurring_tickets']['setpri']='Definir prioridade para:';
$hesklang['recurring_tickets']['setsta']='Definir status para:';
$hesklang['recurring_tickets']['assto']='Atribuir ticket para:';
$hesklang['recurring_tickets']['asm']='Outro membro da equipe';
$hesklang['recurring_tickets']['notify']='Notificar membros da equipe...';
$hesklang['recurring_tickets']['ato']='Aplicar a:';
$hesklang['recurring_tickets']['save']='Salvar regra';
$hesklang['recurring_tickets']['e_tt']='O tempo deve estar entre 1 e 10000';
$hesklang['recurring_tickets']['nocat']='Selecione pelo menos uma categoria';
$hesklang['recurring_tickets']['nouser']='Selecione pelo menos um usuário';
$hesklang['recurring_tickets']['nostatus']='Selecione pelo menos um status';
$hesklang['recurring_tickets']['nocata']='%1$s não tem acesso a estas categorias:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Nova regra foi criada';
$hesklang['recurring_tickets']['mdf']='Configurações da regra foram salvas';
$hesklang['recurring_tickets']['e_id']='Nenhuma regra com este ID encontrada';
$hesklang['recurring_tickets']['deleted']='A regra selecionada foi excluída';
$hesklang['recurring_tickets']['log_title']='Regra #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Ativo'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Ativar esta regra (começar a usá-la)';
$hesklang['recurring_tickets']['activated']='A regra selecionada foi ativada'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Desativar esta regra (parar de usá-la)';
$hesklang['recurring_tickets']['deactivated']='A regra selecionada foi desativada'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Nenhuma regra de ticket recorrente ativa';
$hesklang['recurring_tickets']['tools']='Ferramentas';
$hesklang['recurring_tickets']['tbef']='Antes de uma regra estar ativa, você precisa ativá-la clicando na caixa de seleção na coluna "ATIVO".<br><br>
                               <strong>Regras ativas são processadas a cada %2$s minutos.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[REGRA]';
$hesklang['recurring_tickets']['r2']='[REGRA] Regra #%s';
$hesklang['recurring_tickets']['r3']='Regra #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Número de tickets já criados hoje: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reiniciar esta regra';
$hesklang['recurring_tickets']['reset2']='Tem certeza de que deseja reiniciar esta regra?<br><br>As execuções da regra voltarão a 0 e quaisquer tickets já gerados para ela hoje podem ser gerados novamente na próxima execução do cron.';
$hesklang['recurring_tickets']['reset3']='A regra selecionada foi reiniciada';
$hesklang['recurring_tickets']['test']='Simular esta regra';
$hesklang['recurring_tickets']['testa']='Simular todas as regras';
$hesklang['recurring_tickets']['testaa']='Simular todas as regras ativas';
$hesklang['recurring_tickets']['testr']='Resultados da simulação';
$hesklang['recurring_tickets']['rsim']='Repetir simulação';
$hesklang['recurring_tickets']['sim']='MODO SIMULAÇÃO, nenhuma alteração no banco de dados';
$hesklang['recurring_tickets']['sic']='SIMULAÇÃO CONCLUÍDA';
$hesklang['recurring_tickets']['rrule_type_required']='Selecione um gatilho de regra recorrente válido.';
$hesklang['recurring_tickets']['rrule_string_required']='Selecione todas as opções de gatilho de regra recorrente necessárias.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Insira um valor de intervalo de 1 ou maior para "A cada".';
$hesklang['recurring_tickets']['disable_note']='*Se alguma configuração crítica do hesk for alterada após a criação de uma regra, ela será desativada na próxima tentativa de execução e precisará ser editada para atender aos novos requisitos de validação.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | enviado pela Regra de Tickets Recorrentes "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | atribuído a %2$s pela Regra de Tickets Recorrentes "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | fechado automaticamente pela Regra de Tickets Recorrentes "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status alterado para %2$s pela Regra de Tickets Recorrentes "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automaticamente atribuído a %2$s pela Regra de Tickets Recorrentes "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='A regra foi desativada devido a erros de validação. Verifique abaixo os detalhes.';
$hesklang['recurring_tickets']['errors_title']='Uma ou mais de suas regras produziram erros ao tentar serem executadas e foram desativadas.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Erros da Regra #%s:';
$hesklang['recurring_tickets']['create_customers']='Não há clientes existentes - crie-os <a href="%s" target="_blank">aqui</a>.';
$hesklang['recurring_tickets']['exec_dates']='Datas de execução da regra';
$hesklang['recurring_tickets']['show_exec_dates']='[Mostrar datas de execução atuais da regra]';
$hesklang['recurring_tickets']['no_exec_dates']='Selecione gatilhos de regra válidos para ver as datas de execução.';
$hesklang['recurring_tickets']['invalid_disabled']='configurações de Rrule inválidas - regra desativada.';
$hesklang['recurring_tickets']['next_occ']='Próximas %s ocorrências da regra:';
$hesklang['recurring_tickets']['occ_on']='em %s';
$hesklang['recurring_tickets']['not_firing_today']='não precisa ser acionada hoje.';
$hesklang['recurring_tickets']['rules_fulfilled']='regras recorrentes cumpridas - ticket criado hoje!';
$hesklang['recurring_tickets']['validation_failed']='validação falhou - regra desativada. Detalhes abaixo:';
$hesklang['recurring_tickets']['validation_error']='Erro de validação:';
$hesklang['recurring_tickets']['processed']='processado.';
$hesklang['recurring_tickets']['created_ticket']='ticket criado id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relativo à data de criação do ticket';
$hesklang['priorities']='Prioridades';
$hesklang['priority_intro']='Use esta ferramenta para gerenciar prioridades de tickets para sua central de ajuda';
$hesklang['new_priority']='Nova prioridade';
$hesklang['edit_priority']='Editar prioridade';
$hesklang['priority_title']='Título';
$hesklang['can_customers_select_it']='Os clientes podem selecionar esta prioridade?';
$hesklang['selected_by_customer']='Selecionável por clientes';
$hesklang['err_priority']='Digite o título da prioridade';
$hesklang['priority_added']='Uma nova prioridade foi adicionada';
$hesklang['priority_e_id']='ID de prioridade inválido';
$hesklang['priority_mdf']='Prioridade foi salva';
$hesklang['priority_deleted']='Prioridade excluída';
$hesklang['priority_not_found']='Esta prioridade não existe';
$hesklang['priority_not_empty']='Esta prioridade não pode ser excluída porque existem tickets com esta prioridade';
$hesklang['click_to_enable_drag_drop']='Clique para ativar arrastar e soltar para a linha, depois arraste a linha para cima ou para baixo para reorganizar as prioridades.';
$hesklang['confirm_delete_priority']='Tem certeza de que deseja excluir esta prioridade?';
$hesklang['reordered_message']='A ordem da sua lista de prioridades foi salva.';
$hesklang['list_tkt_priority']='Listar todos os tickets com esta prioridade';
$hesklang['deletion_priority_restricted']='Esta é uma prioridade especial e não pode ser excluída';
$hesklang['priority_limit']='Você não pode criar novas prioridades';
$hesklang['skip_to_main_content']='Pular para o Conteúdo Principal';
$hesklang['opens_dialog']='Abre uma caixa de diálogo';
$hesklang['create_a_ticket']='Criar um ticket';
$hesklang['toggle_navigation']='Alternar navegação';
$hesklang['add_a_ticket_reply']='Adicionar uma resposta ao ticket';
$hesklang['linked_tickets']='Tickets vinculados';
$hesklang['no_linked_tickets']='Nenhum ticket vinculado';
$hesklang['link_ticket']='Vincular ticket';
$hesklang['can_link_tickets_e']='Você não está autorizado a vincular/desvincular este ticket';
$hesklang['link_ticket_success']='O ticket foi vinculado com sucesso';
$hesklang['link_ticket_required_error']='Para vincular um ticket, forneça um ID de rastreamento válido';
$hesklang['link_ticket_itself_error']='Um ticket não pode ser vinculado a si mesmo. Insira um ID de rastreamento diferente';
$hesklang['already_linked_error']='O ticket já foi vinculado';
$hesklang['unlink_success']='O ticket foi desvinculado com sucesso';
$hesklang['unlink_error']='Nenhum registro vinculado existe';
$hesklang['link_history']='<li class="smaller">%s | %s ticket vinculado por %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket desvinculado por %s</li>';
$hesklang['can_link_tickets']='Pode vincular ticket';
$hesklang['link_a_ticket']='Vincular um ticket';
$hesklang['mfa_curl']='Não é possível gerar uma imagem QR para escanear porque o suporte a <strong>cURL</strong> não está ativado em seu servidor.';
$hesklang['require_xml']='PHP-XML deve estar habilitado para mensagens de Texto Formatado (HTML). Peça ao seu host da web para habilitar XML para PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s adicionado como colaborador por %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removido como colaborador por %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfeito para trabalhos de manutenção preventiva, revisões de acesso mensais, check-ins recorrentes com clientes e muito mais.';
$hesklang['recurring_tickets']['feat1']='<strong>Defina e esqueça os agendamentos.</strong> Diariamente, toda segunda-feira, todo mês de março, todo dia 15 do mês ou qualquer data futura';
$hesklang['recurring_tickets']['feat2']='<strong>Chegam pré-preenchidos e atribuídos.</strong> Escolha categoria, prioridade, agente e até 100 valores de campos personalizados';
$hesklang['recurring_tickets']['feat3']='<strong>Visualize datas e simule.</strong> Veja todos os tickets que o Hesk gerará antes de ativar uma regra, para não haver surpresas.';
$hesklang['unlink_btn']='Desvincular';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');