<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Català (Catalan)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Xavier Bach-Esteve (https://baixemporda.cat)
* Ivan Beà (http://garrotxa.cat)
* Alberto Gimeno Marión (https://www.aliksi.es)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Català';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Catalan';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Respondre sobre aquesta línia ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Nou tiquet: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Tiquet rebut: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Tiquet assignat: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nova resposta per a: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nova resposta per a: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Tiquet mogut: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Nota agregada a: %%SUBJECT%%';
$hesklang['new_pm']='Nou missatge privat: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Llista dels vostres tiquets de suport';

// ERROR MESSAGES
$hesklang['cant_connect_db']='No es pot connectar a la base de dades!';
$hesklang['invalid_action']='Acció no permesa';
$hesklang['select_username']='Si us plau, seleccioneu el vostre nom d\'usuari';
$hesklang['enter_pass']='Si us plau, escriviu la vostra contrasenya';
$hesklang['cant_sql']='No es pot executar SQL';
$hesklang['contact_webmsater']='Si us plau notifiqueu a l\'administrador a';
$hesklang['mysql_said']='MySQL diu';
$hesklang['wrong_pass']='Contrasenya incorrecta.';
$hesklang['session_expired']='La vostra sessió ha caducat, si us plau identifiqueu-vos a través del següent formulari.';
$hesklang['attempt']='Intent no vàlid!';
$hesklang['not_authorized_tickets']='Vostè no està autoritzat per veure els tiquets dins d\'aquesta categoria';
$hesklang['must_be_admin']='Vostè no està autoritzat per veure aquesta pàgina! Per veure aquesta pàgina ha de ser administrador.';
$hesklang['no_session']='No es pot iniciar una nova sessió!';
$hesklang['error']='Error';
$hesklang['int_error']='Error de Script Intern';
$hesklang['no_trackID']='No hi ha ID de seguiment';
$hesklang['status_not_valid']='Estat no és vàlid';
$hesklang['trackID_not_found']='ID de seguiment no trobat';
$hesklang['enter_message']='Si us plau introduïu el vostre missatge';
$hesklang['select_priority']='Si us plau seleccioneu la vostra prioritat';
$hesklang['ticket_not_found']='Tiquet no trobat! Assegureu-vos que heu introduït l\'ID de seguiment correcte!';
$hesklang['no_selected']='No hi ha tiquets seleccionats, res a canviar';
$hesklang['id_not_valid']='Aquest no és un ID vàlid';
$hesklang['enter_id']='Si us plau indiqueu l\'ID de seguiment';
$hesklang['enter_name']='Si us plau indiqueu el nom de client';
$hesklang['enter_date']='Si us plau indiqueu la data que voleu cercar a';
$hesklang['date_not_valid']='Aquesta no és una data vàlida. Introduïu la data en el format següent: <b>YYYY-MM-DD</b>';
$hesklang['enter_subject']='Si us plau indiqueu l\'assumpte del tiquet';
$hesklang['invalid_search']='Acció de cerca invàlida';
$hesklang['choose_cat_ren']='Si us plau seleccioneu categoria a ser reanomenada';
$hesklang['cat_ren_name']='Si us plau escriviu el nou nom de la categoria';
$hesklang['cat_not_found']='Categoria no trobada';
$hesklang['enter_cat_name']='Si us plau indiqueu el nom de la categoria';
$hesklang['no_cat_id']='Cap categoria d\'identificació';
$hesklang['cant_del_default_cat']='No podeu suprimir la categoria per defecte, només podeu reanomenar-la';
$hesklang['no_valid_id']='Usuari d\'identificació no vàlid';
$hesklang['user_not_found']='Usuari no trobat';
$hesklang['enter_real_name']='Si us plau indiqueu el nom real de l\'usuari';
$hesklang['enter_valid_email']='Si us plau indiqueu un correu electrònic vàlid';
$hesklang['enter_username']='Si us plau indiqueu el vostre usuari (login)';
$hesklang['asign_one_cat']='Si us plau, assigneu usuari almenys a una categoria!';
$hesklang['signature_long']='La signatura de l\'usuari és massa llarga! Si us plau, limiteu la signatura a 1000 caràcters';
$hesklang['confirm_user_pass']='Si us plau confirmeu la contrasenya';
$hesklang['passwords_not_same']='Les contrasenyes introduïdes no concorden!';
$hesklang['cant_del_admin']='No podeu suprimir l\'administrador per defecte!';
$hesklang['cant_del_own']='No podeu suprimir el perfil on es troba loguejat!';
$hesklang['enter_your_name']='Si us plau indiqueu el vostre nom';
$hesklang['sel_app_cat']='Si us plau seleccioneu la categoria apropiada';
$hesklang['sel_app_priority']='Si us plau seleccioneu la prioritat apropiada';
$hesklang['enter_ticket_subject']='Si us plau indiqueu l\'assumpte del vostre tiquet';
$hesklang['user_not_found_nothing_edit']='Usuari no trobat o res a canviar';

// ADMIN PANEL
$hesklang['administrator']='Administrador';
$hesklang['login']='Login';
$hesklang['user']='Usuari';
$hesklang['username']='Nom d\'usuari';
$hesklang['pass']='Contrasenya';
$hesklang['confirm_pass']='Confirmeu la contrasenya';
$hesklang['logged_out']='Desconnectat';
$hesklang['logout']='Tancar sessió';
$hesklang['logout_success']='Ha sortit correctament de la sessió!';
$hesklang['click_login']='Feu clic aquí per entrar';
$hesklang['back']='Tornar enrere';
$hesklang['displaying_pages']='Veient <b>%d</b> tiquets. Pàgines:';
$hesklang['trackID']='ID de seguiment';
$hesklang['timestamp']='Data i hora';
$hesklang['name']='Nom';
$hesklang['subject']='Assumpte';
$hesklang['status']='Estat';
$hesklang['priority']='Prioritat';
$hesklang['open']='Nou';
$hesklang['open_action']='Obrir tiquet'; // Open ACTION
$hesklang['close']='Tancat'; // Closed ticket STATUS
$hesklang['any_status']='Qualsevol estat';
$hesklang['high']='Alta';
$hesklang['medium']='Mitjana';
$hesklang['low']='Baixa';
$hesklang['del_selected']='Eliminar els tiquets seleccionats';
$hesklang['manage_cat']='Administrar categories';
$hesklang['profile']='El vostre perfil';
$hesklang['show_tickets']='Mostrar tiquets';
$hesklang['sort_by']='Ordenar per';
$hesklang['date_posted']='Data de publicació';
$hesklang['category']='Categoria';
$hesklang['any_cat']='Qualsevol de les categories';
$hesklang['order']='Ordre';
$hesklang['ascending']='ascendent';
$hesklang['descending']='descendent';
$hesklang['display']='Mostra';
$hesklang['tickets_page']='Tiquets per pàgina';
$hesklang['find_ticket']='Cerca tiquet';
$hesklang['yyyy_mm_dd']='YYYY-MM-DD';
$hesklang['results_page']='Resultats per pàgina';
$hesklang['opened']='Obert'; // The ticket has been OPENED
$hesklang['closed']='Resolt'; // Ticket has been RESOLVED
$hesklang['ticket']='Tiquet';
$hesklang['tickets']='Tiquets';
$hesklang['ticket_been']='Aquest tiquet ha estat';
$hesklang['view_ticket']='Veure tiquet';
$hesklang['open_tickets']='Tiquets oberts';
$hesklang['remove_statement']='Eliminar la declaració &quot;Powered by&quot;';
$hesklang['click_info']='Feu clic aquí per a més informació';
$hesklang['reply_added']='Resposta agregada';
$hesklang['reply_submitted']='Resposta enviada';
$hesklang['ticket_marked']='Aquest tiquet ha estat marcat';
$hesklang['ticket_status']='Estat del tiquet';
$hesklang['replies']='Respostes';
$hesklang['date']='Data';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Missatge';
$hesklang['add_reply']='Afegir resposta';
$hesklang['close_this_ticket']='Marqueu aquest tiquet com a resolt';
$hesklang['change_priority']='Canviar prioritat a';
$hesklang['attach_sign']='Afegeix signatura';
$hesklang['profile_settings']='Configuració del perfil';
$hesklang['submit_reply']='Enviar resposta';
$hesklang['support_panel']='Panel de suport';
$hesklang['ticket_trackID']='Tiquet ID';
$hesklang['c2c']='Click per continuar';
$hesklang['tickets_deleted']='Tiquets suprimits';
$hesklang['num_tickets_deleted']='Nombre de tiquets suprimits: <b>%d</b>';
$hesklang['confirm_del_cat']='Esteu segur d\'esborrar aquesta categoria?';
$hesklang['cat_intro']='Aquí podeu gestionar les categories. Les categories són útils per organitzar els tiquets per rellevància (per exemple &quot;Vendes&quot;, &quot;Problemes de herdware&quot;, &quot;Problemes de PHP/MySQL&quot; etc) i per assignar usuaris a les categories.';
$hesklang['cat_name']='Nom';
$hesklang['remove']='Esborra';
$hesklang['add_cat']='Nova categoria';
$hesklang['max_chars']='40 caràcters màxim';
$hesklang['create_cat']='Desar categoria';
$hesklang['ren_cat']='Reanomenar categoria';
$hesklang['to']='per';
$hesklang['cat_added']='Afegeix categoria';
$hesklang['cat_name_added']='La categoria %s ha estat agregada satisfactòriament';
$hesklang['cat_renamed']='Categoria anomenada';
$hesklang['cat_renamed_to']='La categoria seleccionada s\'ha reanomenat a';
$hesklang['cat_removed']='Categoria eliminada';
$hesklang['cat_removed_db']='La categoria seleccionada ha estat eliminada de la base de dades';
$hesklang['sure_remove_user']='Esteu segur d\'esborrar aquest usuari?';
$hesklang['manage_users']='Administrar usuaris';
$hesklang['users_intro']='Aquí podeu administrar els usuaris que poden accedir al panell d\'administració i respondre tiquets. Els administradors poden veure/editar tiquets en qualsevol categoria i tenen accés a totes les funcions del panell d\'administració (administrar usuaris, administrar categories...) mentre que altres usuaris només poden veure i respondre tiquets que es trobin dins de la seva pròpia categoria ';
$hesklang['yes']='SÍ';
$hesklang['no']='NO';
$hesklang['edit']='Editar';
$hesklang['add_user']='Afegeix un nou usuari';
$hesklang['req_marked_with']='Camps marcats són requerits';
$hesklang['real_name']='Nom real';
$hesklang['signature_max']='Signatura (màxim 1000 caràcters)';
$hesklang['sign_extra']='Codi HTML no està permès. Els enllaços (links) poden ser clickeables.';
$hesklang['create_user']='Crear usuari';
$hesklang['editing_user']='Editar usuari';
$hesklang['user_added']='Usuari agregat';
$hesklang['user_added_success']='Nou usuari %s amb clau %s ha estat agregat satisfactòriament';
$hesklang['profile_updated']='Perfil actualitzat';
$hesklang['profile_updated_success']='El vostre perfil ha estat actualitzat satisfactòriament';
$hesklang['user_removed']='Usuari esborrat';
$hesklang['sel_user_removed']='L\'usuari seleccionat ha estat esborrat satisfactòriament de la base de dades';
$hesklang['profile_for']='Perfil de';
$hesklang['new_pass']='Nova contrasenya';
$hesklang['update_profile']='Actualitzar perfil';
$hesklang['notify_new_posts']='Notificar-me tiquets nous i respostos dins de la meva categoria';
$hesklang['view_profile']='Veure perfil';
$hesklang['new_ticket_submitted']='Nou tiquet de suport ha estat creat';
$hesklang['user_profile_updated_success']='Aquest perfil d\'usuari ha estat actualitzat satisfactòriament';
$hesklang['printer_friendly']='Versió per imprimir';
$hesklang['end_ticket']='--- Fi del tiquet ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='El vostre tiquet ha estat';
$hesklang['view_your_ticket']='Veure el vostre tiquet';
$hesklang['submit_ticket']='Enviar un tiquet';
$hesklang['sub_ticket']='Enviar tiquet';
$hesklang['before_submit']='Abans d\'enviar, si us plau, assegureu-vos del següent';
$hesklang['all_info_in']='Tota la informació necessària ha estat emplenada';
$hesklang['all_error_free']='Tota la informació és correcta i lliure d\'errors';
$hesklang['we_have']='Hem registrat';
$hesklang['recorded_ip']='com la vostra adreça IP';
$hesklang['recorded_time']='registrat el temps d\'enviament';
$hesklang['save_changes']='Desa els canvis';
$hesklang['reply_submitted_success']='La vostra resposta a aquesta entrada s\'ha enviat correctament';
$hesklang['ticket_submitted']='Tiquet enviat';
$hesklang['ticket_submitted_success']='El vostre tiquet ha estat enviat satisfactòriament! Tiquet ID';
$hesklang['your_ticket']='El vostre tiquet';

// Added in version 0.94
$hesklang['check_updates']='Assegureu-vos de tenir sempre instal·lada la darrera versió de Hesk!';
$hesklang['check4updates']='Cerca actualitzacions';
$hesklang['wait_reply']='Esperant resposta';
$hesklang['replied']='Respost';
$hesklang['last_replier']='Última resposta';
$hesklang['staff']='Equip';
$hesklang['customer']='Client';
$hesklang['close_selected']='Marcar tiquets seleccionats com a resolts';
$hesklang['execute']='Executar';
$hesklang['saved_replies']='Respostes predeterminades';
$hesklang['manage_saved']='Respostes predeterminades';
$hesklang['manage_intro']='Aquí podeu afegir i administrar les respostes predeterminades. Aquestes són generalment usades per respondre a la majoria dels clients. Podeu utilitzar les respostes predeterminades per estalviar escriure la mateixa resposta per als diferents usuaris nombroses vegades.';
$hesklang['saved_title']='Títol';
$hesklang['no_saved']='No hi ha resposta predeterminada';
$hesklang['delete_saved']='Esteu segur d\'eliminar aquesta resposta predeterminada?';
$hesklang['new_saved']='Afegeix o suprimeix resposta predeterminada';
$hesklang['canned_add']='Nova resposta predefinida';
$hesklang['canned_edit']='Editar la resposta predeterminada seleccionada';
$hesklang['save_reply']='Desa la resposta';
$hesklang['saved']='Resposta desada';
$hesklang['your_saved']='La vostra resposta predeterminada ha estat guardada per al seu futur ús';
$hesklang['ent_saved_title']='Si us plau introduïu el títol de resposta';
$hesklang['ent_saved_msg']='Si us plau introduïu el missatge de resposta';
$hesklang['saved_removed']='resposta predeterminada esborrada';
$hesklang['saved_rem_full']='resposta predeterminada seleccionada ha estat eliminada de la base de dades';
$hesklang['clip_alt']='Aquest missatge conté adjunts';
$hesklang['attachments']='Adjunts';
$hesklang['fill_all']='Falta camp obligatori';
$hesklang['file_too_large']='El vostre fitxer %s és massa gran';
$hesklang['cannot_move_tmp']='No es pot moure el fitxer a la carpeta de fitxers adjunts';
$hesklang['created_on']='Creat a';
$hesklang['tickets_closed']='Tiquets tancats';
$hesklang['num_tickets_closed']='<b>%d</b> tiquets han estat tancats';
$hesklang['select_saved']='Seleccioneu resposta predeterminada';
$hesklang['select_empty']='Seleccionar / Buit';
$hesklang['insert_special']='Inserir etiqueta especial (serà reemplaçada amb la informació del client)';
$hesklang['move_to_catgory']='Moure tiquet a';
$hesklang['move']='Moure';
$hesklang['moved']='Tiquet mogut';
$hesklang['moved_to']='El tiquet ha estat mogut a la nova categoria';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Tots, excepte tancats';
$hesklang['chg_all']='Canvia-ho tot';
$hesklang['settings']='Configuració';
$hesklang['settings_intro']='Utilitzeu aquesta eina per configurar el vostre help desk. Per a més informació sobre totes les configuracions i opcions feu clic a ajuda o referiu-vos al fitxer readme.html.';
$hesklang['all_req']='Tots els camps (excepte els deshabilitats) són obligatoris!';
$hesklang['wbst_title']='Títol Lloc Web';
$hesklang['wbst_url']='URL del lloc';
$hesklang['email_wm']='Webmaster e-mail';
$hesklang['max_listings']='Llistat per pàgina';
$hesklang['print_size']='Mida font per a Impressió';
$hesklang['debug_mode']='Mode de depuració';
$hesklang['on']='ACTIVAT';
$hesklang['off']='DESACTIVAT';
$hesklang['use_secimg']='Usar imatge anti-SPAM';
$hesklang['secimg_no']='No disponible';
$hesklang['attach_use']='Utilitzeu adjunts';
$hesklang['attach_num']='Nombre per resposta';
$hesklang['attach_type']='Tipus de fitxer permesos';
$hesklang['place_after']='Després del missatge';
$hesklang['place_before']='Abans del missatge';
$hesklang['custom_f']='Camp personalitzat';
$hesklang['custom_u']='Utilitzeu aquest camp';
$hesklang['custom_n']='Nom de camp';
$hesklang['custom_l']='Mida màxima (caràcters)';
$hesklang['db_host']='Servidor base de dades';
$hesklang['db_name']='Nom base de dades';
$hesklang['db_user']='Usuari Base de Dades';
$hesklang['db_pass']='Contrasenya Base de Dades';
$hesklang['err_sname']='Si us plau introduïu el títol del vostre lloc web';
$hesklang['err_surl']='Si us plau introduïu l\'URL del vostre lloc web. Assegureu-vos que sigui una URL vàlida (inicieu amb http:// o https://)';
$hesklang['err_wmmail']='Si us plau introduïu un correu electrònic de webmaster vàlid';
$hesklang['err_nomail']='Si us plau introduïu un correu electrònic de no resposta vàlid';
$hesklang['err_htitle']='Si us plau introduïu el títol per al centre de suport';
$hesklang['err_hurl']='Si us plau introduïu l\'URL per al vostre centre de suport. Assegureu-vos que sigui una URL vàlida (inicieu amb http:// o https://)';
$hesklang['err_lang']='Si us plau seleccioneu l\'idioma per a Hesk';
$hesklang['err_nolang']='El fitxer de llenguatge especificat no existeix a la carpeta de llenguatges! Assegureu-vos que el fitxer s\'ha pujat abans de canviar la configuració del llenguatge.';
$hesklang['err_max']='Si us plau introduïu les llistes màximes que seran desplegades per pàgina';
$hesklang['err_psize']='Si us plau introduïu la mida de la font';
$hesklang['err_dbhost']='Si us plau introduïu el servidor per a la vostra base de dades MySQL';
$hesklang['err_dbname']='Si us plau introduïu el nom per a la vostra base de dades MySQL';
$hesklang['err_dbuser']='Si us plau introduïu l\'usuari per a la vostra base de dades MySQL';
$hesklang['err_dbpass']='Si us plau introduïu la clau per a la vostra base de dades MySQL';
$hesklang['err_dbconn']='No s\'ha pogut connectar a la base de dades MySQL amb la informació proporcionada!';
$hesklang['err_dbsele']='No s\'ha pogut seleccionar la base de dades MySQL, si us plau comproveu el NOM de la base de dades';
$hesklang['err_custname']='Introduïu el nom del camp personalitzat';
$hesklang['err_openset']='No es pot obrir el fitxer <b>hesk_settings.inc.php</b> per a escriptura. Si us plau, canvieu els permisos CHMOD d\'aquest fitxer a 666 (rw-rw-rw-)';
$hesklang['set_saved']='Configuració desada';
$hesklang['set_were_saved']='Les vostres configuracions han estat desades amb èxit';
$hesklang['sec_img']='Imatge de seguretat';
$hesklang['sec_miss']='Si us plau introduïu el número de seguretat';
$hesklang['sec_wrng']='Nombre de seguretat equivocat';
$hesklang['submit_problems']='Si us plau torneu i corregiu els problemes següents';
$hesklang['cat_order']='Ordre Categoria';
$hesklang['reply_order']='Ordre Resposta Predefinida';
$hesklang['move_up']='Moure a dalt';
$hesklang['move_dn']='Moure a baix';
$hesklang['cat_move_id']='Falta l\'ID de categoria';
$hesklang['reply_move_id']='Falta l\'ID de resposta per defecte';
$hesklang['forgot_tid']='Recordeu el vostre ID de seguiment?';
$hesklang['tid_send']='Envia el meu ID de seguiment';
$hesklang['tid_not_found']='No s\'han trobat tiquets amb la vostra adreça e-mail';
$hesklang['tid_sent']='ID de seguiment enviat';
$hesklang['tid_sent2']='Un e-mail amb detalls sobre els vostres tiquets ha estat enviat a la vostra adreça de correu';
$hesklang['check_spambox']='Assegureu-vos comprovar també el correu electrònic rebut dins de la vostra carpeta SPAM o correu no desitjat!';
$hesklang['reply_not_found']='Resposta predeterminada no trobada';
$hesklang['exists']='Existeix';
$hesklang['no_exists']='No existeix';
$hesklang['writable']='Escrivible';
$hesklang['not_writable']='No escrivible';
$hesklang['disabled']='deshabilitat';
$hesklang['e_settings']='Vostè no serà capaç de desar la configuració a no ser que aquest fitxer sigui escrivible per l\'script. Si us plau consulteu el fitxer readme per a més instruccions!';
$hesklang['e_attdir']='Vostè no serà capaç d\'adjuntar fitxers a no ser que existeixi i sigui escrivible per l\'script. Si us plau consulteu el fitxer readme per a més instruccions!';
$hesklang['e_save_settings']='Impossible desar la vostra configuració perquè el fitxer <b>hesk_settings.inc.php</b> no és escrivible per l\'script.';
$hesklang['e_attach']='Deshabilitat perquè la vostra carpeta <b>attachments</b> no és escrivible per l\'script.';
$hesklang['go']='Anar';

// Added in version 2.0
$hesklang['v']='Versió HESK';
$hesklang['check_status']='Comprovar l\'estat';
$hesklang['sub_support']='Enviar un tiquet';
$hesklang['open_ticket']='Enviar un nou tiquet a un departament';
$hesklang['view_existing']='Veure el tiquet existent';
$hesklang['vet']='Veure tiquets enviats en el passat';
$hesklang['enter_user']='Si us plau introduïu el vostre usuari';
$hesklang['remember_user']='Recordar el meu usuari';
$hesklang['wrong_user']='Usuari equivocat';
$hesklang['no_permission']='No teniu permís per realitzar aquesta tasca, si us plau identifiqueu-vos amb un compte que tingueu.';
$hesklang['tickets_on_pages']='Nombre de tiquets: %d Nombre de pàgines: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='Anar a la pàgina:';
$hesklang['no_tickets_open']='No s\'han trobat tiquets sense resoldre';
$hesklang['no_tickets_crit']='No s\'han trobat tiquets que coincideixin amb el vostre criteri';
$hesklang['confirm_execute']='Esteu segur que voleu continuar?';
$hesklang['legend']='Llegenda';
$hesklang['main_page']='Inici';
$hesklang['menu_users']='Usuaris';
$hesklang['menu_cat']='Categories';
$hesklang['menu_profile']='Perfil';
$hesklang['menu_kb']='Base de coneixements'; // Admin MENU item
$hesklang['kb_text']='Base de Coneixements (KB)'; // Item visible to customers
$hesklang['viewkb']='Veure tota la base de coneixements (KB)';
$hesklang['kb']='Administrar la base de coneixement (KB)';
$hesklang['kb_intro']='La base de coneixement és una col·lecció de respostes a preguntes freqüents (FAQ) i articles que proporcionen recursos d\'autoajuda als vostres clients. Una base de coneixement completa i ben escrita pot reduir dràsticament el nombre de tiquets d\'assistència que rebeu i estalviar molt del vostre temps. Podeu organitzar els articles en categories i subcategories.'; // Description in ADMIN panel
$hesklang['kb_is']='La base de coneixement és una col·lecció de respostes per categories a les preguntes més freqüents (FAQ) i articles del vostre interès. Podeu llegir els articles en aquesta categoria o seleccionar una subcategoria en què esteu interessats.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Nou article per a la base de coneixement (KB)';
$hesklang['kb_cat']='Categoria';
$hesklang['kb_subject']='Assumpte';
$hesklang['kb_content']='Continguts';
$hesklang['kb_type']='Tipus';
$hesklang['kb_published']='Publicat';
$hesklang['kb_published2']='L\'article pot ser vist per qualsevol a la base de coneixement. (KB)';
$hesklang['kb_private']='Privat';
$hesklang['kb_private2']='articles privats només poden ser llegits pel personal.';
$hesklang['kb_draft']='Esborrany';
$hesklang['kb_draft2']='L\'article ha estat desat però no s\'ha publicat encara. Aquest només pot ser llegit pel personal <br />que té permís per administrar els articles de la base de coneixements (KB).';
$hesklang['kb_links']='<i><span class="notice"><b>Perill!</b></span><br />Introduïu un codi vàlid sense etiquetes &lt;head&gt; i &lt;body&gt; , només contingut!</i>';
$hesklang['kb_ehtml']='Això és codi HTML (Aquí haureu d\'introduir codi (X)HTML vàlid)';
$hesklang['kb_dhtml']='Això és text pla (enllaços poden ser premuts)';
$hesklang['kb_save']='Desa l\'article';
$hesklang['kb_e_subj']='Introduïu assumpte de l\'article!';
$hesklang['kb_e_cont']='Escriviu el contingut de l\'article!';
$hesklang['kb_art_added']='article agregat';
$hesklang['your_kb_added']='Un nou article per a la base de coneixement (KB) ha estat agregat amb èxit';
$hesklang['kb_art_deleted']='article eliminat';
$hesklang['your_kb_deleted']='article seleccionat a la base de coneixement (KB) ha estat eliminat satisfactòriament';
$hesklang['kb_art_mod']='article modificat';
$hesklang['your_kb_mod']='Els vostres canvis als articles seleccionats han estat desats satisfactòriament';
$hesklang['kb_cat_new']='Nova subcategoria de la base de coneixement (KB)';
$hesklang['kb_cat_parent']='Categoria superior';
$hesklang['kb_cat_sub']='Subcategories';
$hesklang['kb_cat_title']='Títol de categoria';
$hesklang['kb_cat_published']='La categoria és visible per a tothom a la base de coneixement (KB).';
$hesklang['kb_cat_private']='La categoria només pot ser llegida per l\'equip.';
$hesklang['kb_cat_add']='Afegeix categoria';
$hesklang['kb_cat_e_title']='Introduïu títol de categoria!';
$hesklang['kb_cat_added']='Categoria agregada';
$hesklang['kb_cat_added2']='La nova categoria ha estat agregada satisfactòriament a la base de coneixement (KB)';
$hesklang['kb_cat_man']='Administrar categoria de la base de coneixement (KB)';
$hesklang['kb_cat_edit']='Editar detalls de categoria';
$hesklang['kb_cat_inv']='Categoria invàlida';
$hesklang['kb_cat_art']='articles en aquesta categoria';
$hesklang['kb_p_art']='+ article';
$hesklang['kb_p_art2']='afegir nou article a la categoria seleccionada.';
$hesklang['kb_add_art']='Afegeix article';
$hesklang['kb_p_cat']='+ Categoria';
$hesklang['kb_p_cat2']='crear nova subcategoria dins de la categoria seleccionada.';
$hesklang['kb_add_cat']='Afegeix categoria';
$hesklang['kb_p_man']='Administrar';
$hesklang['kb_p_man2']='administrar categoria seleccionada (editar, eliminar, administrar articles).';
$hesklang['kb_main']='La categoria de base de coneixement (KB) principal no pot ser eliminada o moguda.';
$hesklang['kb_no_art']='No hi ha articles en aquesta categoria.';
$hesklang['author']='Autor';
$hesklang['views']='Vistes';
$hesklang['delete']='Esborrar';
$hesklang['rating']='valoració';
$hesklang['votes']='Vots';
$hesklang['kb_rated']='valoració de l\'article %s/5.0';
$hesklang['kb_not_rated']='article no votat';
$hesklang['del_art']='Esteu segur d\'eliminar l\'article seleccionat?';
$hesklang['kb_art_id']='ID d\'article invàlid o no trobat!';
$hesklang['kb_art_edit']='Editar article';
$hesklang['revhist']='Historial';
$hesklang['revision1']='<li class="smaller">%s | enviat per %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modificat per %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Ordre';
$hesklang['kb_delcat']='Esteu segur d\'eliminar aquesta categoria?';
$hesklang['kb_cat_mod']='Categoria modificada';
$hesklang['your_cat_mod']='Els canvis per a la categoria seleccionada s\'han desat satisfactòriament';
$hesklang['kb_cat_del']='Categoria de base de coneixements (KB) ha estat eliminada';
$hesklang['kb_cat_dlt']='La categoria de base de coneixement (KB) seleccionada ha estat eliminada.';
$hesklang['allowed_cat']='Categories';
$hesklang['allow_feat']='Característiques';
$hesklang['can_view_tickets']='Veure tiquets';
$hesklang['can_reply_tickets']='Respondre als tiquets';
$hesklang['can_assign_tickets']='Assignar tiquets';
$hesklang['can_del_tickets']='Eliminar tiquets';
$hesklang['can_edit_tickets']='Editar respostes a tiquet';
$hesklang['can_change_cat']='Canviar la categoria del tiquet (a qualsevol)';
$hesklang['can_man_kb']='Administrar base de coneixement (KB)';
$hesklang['can_man_users']='Administrar usuaris';
$hesklang['can_man_cat']='Administrar categories';
$hesklang['can_man_canned']='Administrar respostes predeterminades';
$hesklang['can_man_settings']='Administrar configuració Centre de Suport';
$hesklang['can_del_notes']='Eliminar qualsevol nota de tiquet';
$hesklang['dan']='els usuaris poden esborrar les seves pròpies notes als tiquets, seleccioneu aquesta opció només si voleu permetre a aquest usuari també esborrar les notes d\'altres usuaris';
$hesklang['in_all_cat']='permès a categories únicament';
$hesklang['admin_can']='(accés a totes les característiques i categories)';
$hesklang['staff_can']='(accés limitat a característiques i categories)';
$hesklang['asign_one_feat']='Si us plau assigneu com a mínim una funció a aquest usuari!';
$hesklang['na_view_tickets']='Vostè no està autoritzat a veure tiquets';
$hesklang['support_notice']='Ho sentim, aquesta secció només es pot amagar quan vostè compra una llicència HESK!';
$hesklang['rart']='Ha estat útil aquest article?';
$hesklang['r']='Aquesta resposta us va ser útil?';
$hesklang['tyr']='Gràcies per la vostra valoració';
$hesklang['cw']='Tancar finestra';
$hesklang['cw2']='Tancar finestra i enviar un tiquet';
$hesklang['rh']='Qualificat com a util';
$hesklang['rnh']='Qualificat com a poc útil';
$hesklang['ar']='Ja qualificat';
$hesklang['rated']='Usuari qualificat %s/5.0 (%s vots)';
$hesklang['not_rated']='Usuari encara no qualificat';
$hesklang['rdis']='Classificació ha estat deshabilitada';
$hesklang['kbdis']='La base de coneixement (KB) ha estat deshabilitada';
$hesklang['kbpart']='Ho sentim, No teniu permisos per accedir a aquest article';
$hesklang['popart']='Articles destacats';
$hesklang['latart']='Últims articles';
$hesklang['m']='Més assumptes';
$hesklang['ac']='Articles d\'aquesta categoria';
$hesklang['noa']='No hi ha articles encara';
$hesklang['noac']='No hi ha articles encara en aquesta categoria';
$hesklang['dta']='Data d\'alta';
$hesklang['ad']='Detalls de l\'article';
$hesklang['aid']='ID d\'article';
$hesklang['as']='Solució';
$hesklang['search']='Cerca';
$hesklang['sr']='Resultats de la cerca';
$hesklang['nosr']='No hi ha articles trobats que coincideixin. Intenta explorar la base de dades o enviar un nou tiquet de suport.';
$hesklang['rv']='Resetejar vistes';
$hesklang['rr']='Resetejar vots (valoracions)';
$hesklang['opt']='Opcions';
$hesklang['delcat']='Eliminar categoria';
$hesklang['move1']='Moure els articles a la categoria superior';
$hesklang['move2']='Elimina articles en aquesta categoria';
$hesklang['sc']='articles suggerits de la base de coneixement (KB)';
$hesklang['not']='Tiquets'; // Number of all tickets in category
$hesklang['graph']='Gràfic';
$hesklang['lu']='Llista usuaris';
$hesklang['aclose']='Autotancar tiquets';
$hesklang['aclose2']='dies després de la darrera resposta del personal';
$hesklang['s_ucrt']='Reobrir tiquets';
$hesklang['urate']='Respon a puntuacions';
$hesklang['hesk_url']='URL Centre de Suport';
$hesklang['hesk_title']='Títol Centre de Suport';
$hesklang['cid']='Cas ID de seguiment';
$hesklang['tfor']='Format d\'Hora';
$hesklang['prefix']='Prefix de les taules';
$hesklang['s_ekb']='Habilitar Base de Coneixement';
$hesklang['s_kbs']='Habilitar cerca KB';
$hesklang['s_kbr']='Habilitar valoració KB';
$hesklang['s_maxsr']='Nombre màxim de resultats per cerca';
$hesklang['s_suggest']='Suggereix articles KB';
$hesklang['s_spop']='Mostra articles populars';
$hesklang['s_slat']='Mostra els darrers articles';
$hesklang['s_onin']='a <a href="../" target="_blank">Centre de Suport </a>(Pàgina Índex)';
$hesklang['s_onkb']='a <a href="../knowledgebase.php" target="_blank">Base de coneixement </a>(Pàgina Índex)';
$hesklang['s_scol']='Categories per fila';
$hesklang['s_ptxt']='Longitud prèvia de l\'article';
$hesklang['s_psubart']='Articles de Subcategoria';
$hesklang['enable']='Habilitat';
$hesklang['s_type']='Tipus de Camp';
$hesklang['custom_r']='Obligatori';
$hesklang['custom_place']='Ubicació';
$hesklang['custom_use']='Camps personalitzats';
$hesklang['stf']='Camp de text';
$hesklang['stb']='Caixa de text gran';
$hesklang['srb']='Botó d\'opció';
$hesklang['ssb']='Caixa de selecció';
$hesklang['db']='Base de dades';
$hesklang['hd']='Configuració Centre de Suport';
$hesklang['gs']='Configuració general';
$hesklang['cwin']='Tancar finestra';
$hesklang['defw']='Valor per defecte';
$hesklang['ok']='OK';
$hesklang['ns']='Aquestes són les opcions disponibles per a aquest camp personalitzat. Per desar els canvis, feu clic al botó <b>D\'acord</b> ia <b>Desa els canvis</b> a la pàgina de configuració principal!';
$hesklang['rows']='Files (alt)';
$hesklang['cols']='Columnes (ample)';
$hesklang['opt2']='Opcions per a aquest botó de ràdio, introduir-ne una per línia (cada línia crearà un nou valor de botó de ràdio a escollir). Heu d\'introduir almenys dues opcions!';
$hesklang['opt3']='Opcions per a aquesta caixa de selecció, introduïu una opció per línia (cada línia serà una opció que els seus clients podran triar). Heu d\'introduir almenys dues opcions!';
$hesklang['atl2']='Introduïu almenys dues opcions (una per línia)';
$hesklang['notes']='Notes';
$hesklang['addnote']='Afegir nota';
$hesklang['noteby']='Nota per';
$hesklang['delnote']='Eliminar nota';
$hesklang['noteerr']='Nota ja ha estat eliminada o paràmetres equivocats';
$hesklang['s']='Envia';
$hesklang['nhid']=' Les notes s\'amaguen als clients!';
$hesklang['delt']='Eliminar aquest missatge';
$hesklang['edtt']='Editar missatge';
$hesklang['edt1']='Missatge modificat';
$hesklang['edt2']='Canvis al missatge seleccionat desats';
$hesklang['dele']='Eliminar aquest tiquet';
$hesklang['repd']='Missatge suprimit';
$hesklang['repl']='Missatge seleccionat ha estat eliminat';
$hesklang['tickets_found']='Resultats de la cerca';
$hesklang['al']='Link admin';
$hesklang['ap']='Anar al panell d\'Administració';
$hesklang['dap']='Mostrar un enllaç al Panell d\'Administració des de <a href="../" target="_blank">pàgina d\'inici HESK</a>';
$hesklang['q_miss']='Si us plau responeu la pregunta anti-SPAM';
$hesklang['use_q']='Utilitzeu una pregunta anti-SPAM';
$hesklang['q_q']='Pregunta (el codi HTML és <span class="success">permès</span>)';
$hesklang['q_a']='Resposta';
$hesklang['err_qask']='Introduïu una pregunta anti-SPAM';
$hesklang['err_qans']='Introduïu resposta per a la pregunta anti-SPAM';
$hesklang['genq']='Generar una pregunta aleatòria';

// Added in version 2.1
$hesklang['amo']='Afegir més';
$hesklang['delatt']='Esborrar l\'adjunt seleccionat?';
$hesklang['kb_att_rem']='Adjunt seleccionat ha estat esborrat';
$hesklang['inv_att_id']='ID d\'adjunt invàlid!';
$hesklang['scb']='Casella de verificació';
$hesklang['opt4']='Opcions per a aquesta casella, introduir una opció per línia. Cada línia serà una opció que els clients poden triar, són possibles múltiples opcions.';
$hesklang['autologin']='Iniciar sessió automàticament a cada visita';
$hesklang['just_user']='Recordar només el meu usuari';
$hesklang['nothx']='No, gràcies';
$hesklang['pinfo']='Informació del perfil';
$hesklang['sig']='Signatura';
$hesklang['pref']='Preferències';
$hesklang['aftrep']='Després de respondre un tiquet';
$hesklang['showtic']='Mostrar el tiquet acabo de respondre';
$hesklang['gomain']='Tornar a la pàgina d\'administració principal';
$hesklang['shownext']='Obrir el següent tiquet que necessita la meva resposta (si no aneu a la pàgina principal d\'administració)';
$hesklang['rssn']='Mostra el següent tiquet que necessita la seva atenció';
$hesklang['mrep']='Reemplaçar missatge existent';
$hesklang['madd']='Afegeix a la part inferior';
$hesklang['priv']='Categories privades i articles visibles per al personal només estan marcats amb el *';
$hesklang['inve']='Fitxer de correu invàlid';
$hesklang['emfm']='Falta el fitxer de correu electrònic';
$hesklang['hesk_lang']='Idioma per defecte';
$hesklang['s_mlang']='Múltiples Idiomes';
$hesklang['s_mlange']='Si s\'habilita, els usuaris podran accedir al centre de suport en qualsevol dels idiomes instal·lats. Habiliteu-lo només si ofereix suport en tots els idiomes instal·lats!';
$hesklang['s_inl']='Proveu carpeta d\'idiomes';
$hesklang['s_inle']='Comprovació de la carpeta d\'idiomes per veure si són vàlids. Només s\'instal·len correctament els idiomes que superen totes les proves.';
$hesklang['ta']='Proveu de nou';
$hesklang['alo']='Permet inici sessió automàtic';
$hesklang['chol']='Llenguatge preferit';
$hesklang['mmdl']='Establiu com el meu idioma preferit';
$hesklang['warn']='ADVERTÈNCIA';
$hesklang['dmod']='El mode de depuració està habilitat. Assegureu-vos de desactivar el mode de depuració a la configuració un cop Hesk estigui instal·lat i funcioni correctament.';
$hesklang['kb_spar']='La categoria no pot ser la vostra categoria superior!';
$hesklang['mysql_root']='La vostra contrasenya de MySQL aquesta buida, esteu segur que voleu accedir amb l\'usuari root? Això representa un risc de seguretat!';
$hesklang['chg']='Canvia';
$hesklang['chpri']='Prioritat canviada';
$hesklang['chpri2']='La prioritat del tiquet ha estat canviada a %s';
$hesklang['selcan']='Seleccioneu la resposta estàndard que us agradaria editar';
$hesklang['q_wrng']='Resposta antiSPAM incorrecta';
$hesklang['cndupl']='Vostè ja té una categoria amb aquest nom. Trieu un nom únic per a cada categoria.';
$hesklang['wsel']='Seleccioneu el camp pel qual voleu cercar';

// Added in version 2.2
$hesklang['eto']='Sol·licitud no vàlida';
$hesklang['id']='ID';
$hesklang['geco']='Generar enllaç directe';
$hesklang['genl']='Enllaç copiat al porta-retalls';
$hesklang['genl2']='Utilitzeu aquest enllaç per preseleccionar la categoria al formulari &quot;Enviar un tiquet&quot;.';
$hesklang['ask']='Cerca ajuda:';
$hesklang['exa']='Exemples';
$hesklang['small']='Caixa petita';
$hesklang['large']='Caixa gran';
$hesklang['cpri']='Prioritat client';
$hesklang['owner']='Propietari';
$hesklang['unas']='No assignada';
$hesklang['assi']='Assignar';
$hesklang['asst']='Assigna';
$hesklang['asst2']='Assignar aquest tiquet a';
$hesklang['asss']='Assignar aleatòriament';
$hesklang['asss2']='Assignar aquest tiquet a mi mateix';
$hesklang['can_assign_self']='Es poden assignar entrades a si mateix';
$hesklang['can_assign_others']='Podeu assignar entrades als altres';
$hesklang['can_run_reports']='Podeu executar informes (propis)';
$hesklang['can_view_ass_others']='Podeu veure els tiquets assignats a altres';
$hesklang['unoa']='L\'usuari seleccionat no té accés a aquesta categoria';
$hesklang['tasi']='Propietari assignat';
$hesklang['tasy']='Aquest tiquet se us ha assignat a vostè';
$hesklang['taso']='Aquest tiquet s\'ha assignat a l\'usuari seleccionat';
$hesklang['tasy2']='Assignat a Vostè';
$hesklang['taso2']='Assignat a altres membres del personal (staff)';
$hesklang['nose']='Cap propietari seleccionat';
$hesklang['onasc']='Aquest propietari no té accés a la categoria seleccionada.';
$hesklang['tunasi']='Tiquet sense assignar';
$hesklang['tunasi2']='Tiquet sense propietari i llest per ser assignat de nou';
$hesklang['note']='Nota';
$hesklang['success']='èxit';
$hesklang['nyt']='Aquest tiquet s\'assigna a';
$hesklang['noch']='No s\'han produït canvis';
$hesklang['orch']='Ordre de visualització s\'ha modificat';
$hesklang['rfm']='La informació necessària que falta:';
$hesklang['repl0']='Permisos insuficients per realitzar aquesta tasca';
$hesklang['repl1']='Aquest article (post) no existeix';
$hesklang['reports']='Informes (Reports)';
$hesklang['reports_intro']='La secció d\'informes us permet executar diversos informes i veure les estadístiques d\'entrades en un rang de dates escollit.';
$hesklang['refi']='Restablir les dades del formulari';
$hesklang['dich']='Descarta els canvis';
$hesklang['dire']='Mostra informe';
$hesklang['m1']='Gener';
$hesklang['m2']='Febrer';
$hesklang['m3']='Març';
$hesklang['m4']='Abril';
$hesklang['m5']='Maig';
$hesklang['m6']='Juny';
$hesklang['m7']='Juliol';
$hesklang['m8']='Agost';
$hesklang['m9']='Setembre';
$hesklang['m10']='Octubre';
$hesklang['m11']='Novembre';
$hesklang['m12']='Desembre';
$hesklang['d1']='Dilluns';
$hesklang['d2']='Dimarts';
$hesklang['d3']='Dimecres';
$hesklang['d4']='Dijous';
$hesklang['d5']='Divendres';
$hesklang['d6']='Dissabte';
$hesklang['d0']='Diumenge';
$hesklang['mo']='Dl';
$hesklang['tu']='Dt';
$hesklang['we']='Dc';
$hesklang['th']='Dj';
$hesklang['fr']='Dv';
$hesklang['sa']='Ds';
$hesklang['su']='Dg';
$hesklang['from']='De';
$hesklang['cinv']='Data incorrecta';
$hesklang['cinv2']='Format acceptat és mm/dd/yyyy';
$hesklang['cinm']='Valor de mes invàlid';
$hesklang['cinm2']='Rang permès és de';
$hesklang['cind']='Dia invàlid de valor de mes';
$hesklang['cind2']='Límit permès per al mes seleccionat';
$hesklang['month']='Mes';
$hesklang['ocal']='Obrir Calendari';
$hesklang['ca01']='Any Anterior';
$hesklang['ca02']='Mes anterior';
$hesklang['ca03']='Següent Mes';
$hesklang['ca04']='Any Següent';
$hesklang['ca05']='Tancar Calendari';
$hesklang['cdr']='Seleccioneu rang de dates:';
$hesklang['crt']='Tipus d\'informe';
$hesklang['r1']='Avui';
$hesklang['r2']='Ahir';
$hesklang['r3']='Aquest mes';
$hesklang['r4']='L\'últim mes';
$hesklang['r5']='Últims 30 dies';
$hesklang['r6']='Aquesta setmana (Dl-Dg)';
$hesklang['r7']='Última setmana (Dl-Dg)';
$hesklang['r8']='Aquesta setmana de treball (Dl-Dv)';
$hesklang['r9']='Setmana passada de treball (Dl-Dv)';
$hesklang['r10']='Aquest any';
$hesklang['r11']='Any passat';
$hesklang['r12']='Tot el temps';
$hesklang['datetofrom']='&quot;Data des de&quot; no pot ser més gran que &quot;Data fins a&quot;. Les dates han estat canviades.';
$hesklang['t1']='Tiquets per dia';
$hesklang['t2']='Tiquets per mes';
$hesklang['t3']='Tiquets per usuari';
$hesklang['t4']='Tiquets per categoria';
$hesklang['ticass']='Tiquets assignats';
$hesklang['ticall']='Tiquets Respostos';
$hesklang['totals']='Totals';
$hesklang['all']='Tots';
$hesklang['atik']='Nous tiquets';
$hesklang['kbca']='Vostè ja té una base de coneixement (KB) de la categoria amb aquest nom.';
$hesklang['menu_msg']='Correu';
$hesklang['menu_can']='Respostes predeterminades';
$hesklang['m_from']='De'; // Mail "from" address
$hesklang['m_to']='A'; // Mail "to" address
$hesklang['m_sub']='Assumpte'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Missatges privats';
$hesklang['m_intro']='Utilitzeu missatges privats per enviar missatges ràpids a altres funcions dins de l\'HESK.';
$hesklang['e_udel']='(Usuari esborrat)';
$hesklang['new_mail']='Nou missatge privat';
$hesklang['m_send']='Enviar missatge';
$hesklang['m_rec']='Seleccioneu destinatari del missatge';
$hesklang['m_inr']='Destinatari de missatge invàlid';
$hesklang['m_esu']='Introduïu l\'assumpte del missatge privat';
$hesklang['m_pms']='El vostre missatge privat ha estat enviat';
$hesklang['inbox']='Safata d\'entrada';
$hesklang['outbox']='Safata de sortida';
$hesklang['m_new']='Nou Missatge';
$hesklang['pg']='Mostra la pàgina';
$hesklang['npm']='No hi ha missatges en aquesta carpeta';
$hesklang['m_ena']='No teniu permís per llegir aquest missatge.';
$hesklang['mau']='Marcar com a no llegit';
$hesklang['mo1']='Marcar els missatges seleccionats com a llegits';
$hesklang['mo2']='Marcar els missatges seleccionats com a no llegits';
$hesklang['mo3']='Eliminar els missatges seleccionats';
$hesklang['delm']='Eliminar aquest missatge';
$hesklang['e_tid']='Error en generar una única ID de tiquet, si us plau, intenteu enviar el formulari de nou més tard.';
$hesklang['smmr']='Els missatges seleccionats s\'han marcat com a llegits';
$hesklang['smmu']='Els missatges seleccionats s\'han marcat com a no llegits';
$hesklang['smdl']='Els missatges seleccionats s\'han suprimit';
$hesklang['show']='Mostra';
$hesklang['s_my']='Assignat a mi';
$hesklang['s_ot']='Assignat als altres';
$hesklang['s_un']='Tiquets sense assignar';
$hesklang['s_for']='Cerca';
$hesklang['s_in']='Cerca a';
$hesklang['s_incl']='Cerca dins';
$hesklang['find_ticket_by']='Cerca un tiquet';
$hesklang['e_nose']='No hi ha estat d\'assignació seleccionada, mostrant tots els tiquets.';
$hesklang['fsq']='Indiqueu la vostra pregunta';
$hesklang['topen']='Obert';
$hesklang['nms']='No hi ha missatges seleccionats, res per canviar';
$hesklang['tlo']='Bloqueja tiquet';
$hesklang['tul']='Desbloquejar tiquet';
$hesklang['loc']='Bloquejat';
$hesklang['isloc']='Els clients no poden respondre ni reobrir tiquets bloquejats quan un tiquet bloquejat es marca com a resolt.';
$hesklang['tlock']='Tiquet s\'ha bloquejat';
$hesklang['tunlock']='Tiquet s\'ha desbloquejat';
$hesklang['tislock']='Aquest tiquet s\'ha bloquejat, el client no pot enviar una resposta.';
$hesklang['tislock2']='Aquest tiquet ha estat bloquejat, no es pot enviar una resposta.';
$hesklang['nsfo']='No hi ha articles rellevants trobats.';
$hesklang['thist1']='<li class="smaller">%s | mogut a la categoria %s per %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | assignat a %s per %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | tancat per %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | obert per %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | bloquejat per %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | desbloquejat per %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | tiquet creat per %s</li>'; // %s = date, user making change
$hesklang['elocked']='Aquest tiquet s\'ha bloquejat o eliminat';
$hesklang['nti2']='Inserir un nou tiquet';
$hesklang['nti3']='Utilitzeu aquest formulari per crear un nou tiquet en un nom del client. Introduïu la informació del <i>client</i> al formulari (nom de client, el correu electrònic, ...) i NO el vostre nom! El Tiquet serà creat com si fos enviat pel propi client.';
$hesklang['addop']='Opcions';
$hesklang['seno']='Enviar noficacions per correu electrònic al client';
$hesklang['otas']='Mostra el tiquet després de l\'enviament';
$hesklang['notn']='Notificacions';
$hesklang['nomw']='El centre de suport us enviarà una notificació per correu electrònic quan:';
$hesklang['nwts']='Nou tiquet amb propietari:';
$hesklang['ncrt']='El client respon a un tiquet amb el propietari:';
$hesklang['ntam']='Un tiquet assignat a mi';
$hesklang['npms']='Un missatge privat per a mi';
$hesklang['support_remove']='Una gran quantitat d\'esforç, temps i diners van ser invertits en el desenvolupament de HESK. Si us plau, recolzeu el projecte HESK per comprar una llicència que eliminarà també els enllaços <i>Powered by Help Desk Software HESK&trade;</i> del vostre servei de suport';
$hesklang['ycvtao']='No està autoritzat per veure els tiquets assignats a altres';
$hesklang['password_not_valid']='La contrasenya ha de tenir almenys 5 caràcters de llargada';
$hesklang['lkbs']='Carregant suggeriments per a base de coneixement (KB)';
$hesklang['auto']='(automàticament)';

// Added in version 2.3
$hesklang['unknown']='Desconegut';
$hesklang['pcer']='Si us plau, corregiu els errors següents:';
$hesklang['seqid']='Tiquet número ';
$hesklang['close_action']='Marcar com a Resolt'; // Close ACTION
$hesklang['archived']='Etiquetat';
$hesklang['archived2']='Tiquet etiquetat';
$hesklang['add_archive']='Etiquetar tiquet';
$hesklang['add_archive_quick']='Etiqueta els tiquets seleccionats';
$hesklang['remove_archive']='Treure etiqueta del tiquet';
$hesklang['remove_archive_quick']='Treure etiqueta dels tiquets seleccionats';
$hesklang['added_archive']='Tiquet etiquetat';
$hesklang['removed_archive']='Tiquet no etiquetat';
$hesklang['added2archive']='Tiquet ha estat etiquetat';
$hesklang['removedfromarchive']='S\'ha tret l\'etiqueta del tiquet';
$hesklang['num_tickets_tag']='<b>%d</b> tiquets han estat etiquetats';
$hesklang['num_tickets_untag']='<b>%d</b> tiquets han estat etiquetats';
$hesklang['can_add_archive']='Podeu etiquetar tiquets';
$hesklang['disp_only_archived']='Només tiquets etiquetats';
$hesklang['search_only_archived']='Només tiquets etiquetats';
$hesklang['critical']='Crítica';
$hesklang['thist8']='<li class="smaller">%s | prioritat canviada a %s per %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | estat canviat a %s per %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | assignat automàticament a %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | enviat per correu electrònic</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='any';
$hesklang['abbr']['month']='mes';
$hesklang['abbr']['week']='set';
$hesklang['abbr']['day']='d';
$hesklang['abbr']['hour']='h';
$hesklang['abbr']['minute']='m';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='No s\'ha pogut enviar missatge a';
$hesklang['yhbb']='Vostè ha estat bloquejat pel sistema durant %s minuts a causa d\'intents d\'accés fallits al sistema.';
$hesklang['pwdst']='Seguretat de la contrasenya';
$hesklang['tid_mail']='No us preocupeu!, introduïu el vostre <b>Email</b> i us enviarem el vostre ID de seguiment immediatament';
$hesklang['rem_email']='Recordar la meva adreça de correu electrònic';
$hesklang['eytid']='Introduïu l\'ID de seguiment del vostre tiquet';
$hesklang['enmdb']='L\'adreça de correu electrònic indicada no coincideix amb la de la nostra base de dades per a aquest ID de seguiment.';
$hesklang['confemail']='Confirmar email';
$hesklang['confemail2']='Si us plau, confirmeu el vostre email';
$hesklang['confemaile']='Els dos correus electrònics no són iguals';
$hesklang['taso3']='Assignat a:';
$hesklang['sec_enter']='Escriviu el número que apareix a la imatge';
$hesklang['reload']='Recarregar imatge';
$hesklang['verify_q']='SPAM Prevenció:'; // For anti-spam question
$hesklang['verify_i']='SPAM Prevenció:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Benvingut! Si us plau, inicieu sessió.';
$hesklang['vrfy']='Test OK';
$hesklang['last_update']='Actualitzat';
$hesklang['cot']='No forçar entrades critiques a la part superior';
$hesklang['def']='Deixeu com "La meva vista per defecte" ';
$hesklang['gbou']='Aquest tiquet està <b>sense assignar</b>:';
$hesklang['gbom']='Tiquet assignat a <b>mi</b>:';
$hesklang['gboo']='Tiquets assignats a <b>%s</b>:';
$hesklang['select']='Feu clic per seleccionar:';
$hesklang['chngstatus']='Canviar estat a';
$hesklang['perat']='%s de tots els tiquets.'; // Will change to "23% of all tickets"
$hesklang['viewart']='Veure aquest article';
$hesklang['chdp']='Si us plau, canvieu la contrasenya per defecte en el vostre <a href="profile.php">Profile</a> perfil!';
$hesklang['chdp2']='Canvieu la vostra clau. Està usant una per defecte';
$hesklang['security']='Seguretat';
$hesklang['kb_i_art']='Nou article';
$hesklang['kb_i_art2']='Inseriu un article';
$hesklang['kb_i_cat']='Nova categoria';
$hesklang['kb_i_cat2']='Inseriu una categoria';
$hesklang['gopr']='Veure base de coneixement (KB)';
$hesklang['kbstruct']='Estructura base de coneixement (KB)';
$hesklang['cancel']='Cancel·lar';
$hesklang['sh']='Missatge ocult';
$hesklang['goodkb']='Com escriure bons articles a la base de coneixement (KB)';
$hesklang['catset']='Paràmetres de categoria';
$hesklang['inpr']='Seleccionar nova prioritat';
$hesklang['incat']='Seleccionar nova categoria';
$hesklang['instat']='Seleccionar nou estat';
$hesklang['tsst']='Estat del tiquet establert a %s';
$hesklang['aass']='Autoassignar';
$hesklang['aaon']='Autoassignar tiquets activats (clic per desactivar)';
$hesklang['aaoff']='Autoassignar tiquets desactivats (clic per activar)';
$hesklang['uaaon']='Autoassignar ha estat activat per als usuaris seleccionats';
$hesklang['uaaoff']='Autoassignar ha estat desactivat per als usuaris seleccionats';
$hesklang['taasy']='Aquest tiquet ha estat autoassignat a';
$hesklang['can_view_unassigned']='Podeu veure tiquets sense assignar';
$hesklang['ycovtay']='Només podeu veure els tiquets assignats a Vostè';
$hesklang['in_progress']='En progrés';
$hesklang['on_hold']='En espera';
$hesklang['import_kb']='Importar aquest tiquet dins la base de coneixement (KB)';
$hesklang['import']='Esteu important un <i>tiquet privat</i> dins <i>un article públic</i>.<br /><br />Assegureu-vos d\'eliminar qualsevol informació privada de l\'assumpte i contingut de l\'article';
$hesklang['tab_1']='Configuració General';
$hesklang['tab_2']='Centre de Suport';
$hesklang['tab_3']='Base de coneixement (KB)';
$hesklang['tab_4']='Camps personalitzats';
$hesklang['tab_5']='Misc';
$hesklang['disable']='Desactivat';
$hesklang['dat']='Data &amp; hora';
$hesklang['lgs']='Idioma';
$hesklang['onc']='ACTIVAT - Usuaris';
$hesklang['ons']='ACTIVAT - Tots';
$hesklang['viewvtic']='Veure tiquets';
$hesklang['reqetv']='Email requerit per veure tiquet';
$hesklang['banlim']='Límit d\'intents de connexió';
$hesklang['banmin']='Temps Bloqueig (minuts)';
$hesklang['subnot']='Enviar avís';
$hesklang['subnot2']='Mostrar avís als clients enviant tiquets';
$hesklang['eseqid']='ID sequencial';
$hesklang['sconfe']='Confirmar correu electrònic';
$hesklang['saass']='Autoassignar tiquets';
$hesklang['swyse']='Editor WYSIWYG';
$hesklang['hrts']='Valorar HESK';
$hesklang['hrts2']='Mostrar la valoració al panell d\'administració';
$hesklang['emlpipe']='Email piping';
$hesklang['emlsend2']='Enviar correu electrònic usant';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='Servidor SMTP';
$hesklang['smtph']='Servidor SMTP';
$hesklang['smtpp']='Port SMTP';
$hesklang['smtpu']='Usuari SMTP';
$hesklang['smtpw']='La vostra contrasenya SMTP';
$hesklang['smtpt']='Temps d\'espera SMTP';
$hesklang['other']='Altres';
$hesklang['features']='Característiques';
$hesklang['can_view_online']='Veure en línia membres de l\'organització';
$hesklang['online']='Connectat';
$hesklang['offline']='Desconnectat';
$hesklang['onlinep']='Usuaris Connectats'; // For display in footer
$hesklang['sonline']='Usuaris Connectats'; // For settings page
$hesklang['sonline2']='Veure usuaris Connectats. límit (minuts):'; // For settings page
$hesklang['gb']='Agrupa';
$hesklang['dg']='No Agrupa';
$hesklang['err_dpi']='Database %s no conté totes les taules HESK amb el prefix %s, canvis no desats.';
$hesklang['err_dpi2']='Taules no trobades:';
$hesklang['sme']='SMTP error';
$hesklang['scl']='SMTP log de connexió';
$hesklang['dnl']='Descàrrega';
$hesklang['dela']='Esborrar aquest adjunt';
$hesklang['pda']='Esborrar permanentment aquest adjunt?';
$hesklang['thist12']='<li class="smaller">%s | fitxer adjunt %s eliminat per %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Més opcions';
$hesklang['lopt']='Menys opcions';
$hesklang['meml']='Múltiples Emails';
$hesklang['meml2']='Permetre als clients introduir múltiples correus electrònics';

// Added in version 2.4
$hesklang['catd']='(categoria eliminada)';
$hesklang['noopen']='No s\'han trobat tiquets oberts per a aquesta adreça de correu electrònic.';
$hesklang['maxopen']='Vostè ha arribat al màxim de tiquets oberts (%d de %d). Espereu fins que els vostres tiquets actuals estiguin resolts abans de l\'obertura de tiquets nous.';
$hesklang['ntnote']='Algú va afegir una nota a un tiquet assignat';
$hesklang['cat_public']='Públic';
$hesklang['cat_private']='Privat';
$hesklang['cat_aa']='Autoassignar tiquets d\'aquesta categoria.';
$hesklang['cat_type']='Tipus';
$hesklang['caaon']='S\'ha habilitat Autoassignar per a la categoria seleccionada';
$hesklang['caaoff']='S\'ha desactivat Autoassignar per a la categoria seleccionada';
$hesklang['cpub']='Tipus de categoria canviat a PÚBLICA';
$hesklang['cpriv']='Tipus de categoria canviat a PRIVAT';
$hesklang['cpric']='Els clients no poden seleccionar les categories privades, només el personal autoritzat!';
$hesklang['user_aa']='Autoassignar tiquets per a aquest usuari.';
$hesklang['attach_size']='Mida màxima del fitxer';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='Protocol SSL';
$hesklang['smtptls']='Protocol TLS';
$hesklang['oo']='Només Oberts';
$hesklang['ool']='Llista només els tiquets oberts al correu &quot;Va oblidar el vostre ID de seguiment&quot;';
$hesklang['mop']='Màxim tiquets oberts';
$hesklang['rord']='Ordre Respostos';
$hesklang['newbot']='Els més nous al final';
$hesklang['newtop']='Els més nous al principi';
$hesklang['ford']='Formulari de resposta';
$hesklang['formbot']='Mostrar el formulari al final';
$hesklang['formtop']='Mostrar el formulari al principi';
$hesklang['mysqlv']='Versió MySQL';
$hesklang['phpv']='Versió PHP';
$hesklang['csrt']='Hora actual del Centre d\'Ajuda:';
$hesklang['listp']='Llistar articles privats';
$hesklang['listd']='Llistar els articles en esborrany';
$hesklang['artp']='Articles privats';
$hesklang['artd']='Articles en esborrany';
$hesklang['kb_no_part']='No hi ha articles privats a la base de coneixements.';
$hesklang['kb_no_dart']='No hi ha articles en esborrany a la base de coneixements.';
$hesklang['attpri']='No teniu accés a aquest fitxer adjunt.';
$hesklang['can_merge_tickets']='Combinar tiquets';
$hesklang['mer_selected']='Combinar tiquets seleccionats';
$hesklang['merged']='Els tiquets seleccionats s\'han combinat en un de sol.';
$hesklang['merge_err']='Hi ha un problema en combinar Els tiquets:';
$hesklang['merr1']='Seleccioneu almenys dos tiquets.';
$hesklang['merr2']='Tiquet de destinació no trobat.';
$hesklang['merr3']='Tiquet en una categoria que no hi té accés.';
$hesklang['tme']='Tiquet %s s\'ha combinat amb aquest tiquet (%s).';
$hesklang['tme1']='Tiquet %s s\'ha combinat amb el tiquet %s';
$hesklang['tme2']='Per accedir al tiquet %s introduïu l\'adreça de correu electrònic associada.';
$hesklang['eyou']='Utilitzeu la pàgina del perfil per editar la configuració.';
$hesklang['npea']='No teniu permís per editar aquest usuari.';
$hesklang['duplicate_user']='L\'usuari amb aquest nom d\'usuari ja existeix, escolliu un nom d\'usuari diferent.';
$hesklang['kw']='Paraules clau';
$hesklang['kw1']='(opcional - separat per un espai, una coma o una nova línia)';
$hesklang['type_not_allowed']='Els fitxers que acaben amb <b>%s</b> no s\'accepten (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='El client encara no ha llegit aquesta resposta.';
$hesklang['sticky']='Fer aquest article &quot;Permanent&quot;';
$hesklang['stickyon']='Canvia aquest article a &quot;Permanent&quot;';
$hesklang['stickyoff']='Canvia aquest article a &quot;Normal&quot;';
$hesklang['ason']='Article marcat com a &quot;Permanent&quot;';
$hesklang['asoff']='Article marcat com a &quot;Normal&quot;';
$hesklang['ts']='Temps Dedicat';
$hesklang['start']='Iniciar / Aturar';
$hesklang['reset']='Restablir';
$hesklang['save']='Desa';
$hesklang['hh']='Hores';
$hesklang['mm']='Minuts';
$hesklang['ss']='Segons';
$hesklang['thist']='Historial de tiquets';
$hesklang['thist13']='<li class="smaller">%s | fusionat amb el tiquet %s per %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | temps treballat actualitzat a %s per %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | Enviat per %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | enviat per correu electrònic POP3</li>';
$hesklang['twu']='Temps dedicat al tiquet actualitzat.';
$hesklang['autoss']='Inici automàtic de temporitzador en obrir un tiquet';
$hesklang['ful']='Límit de càrrega de fitxers';
$hesklang['ufl']='Podeu carregar fitxers que acaben a:';
$hesklang['nat']='El nombre màxim de fitxers adjunts:';
$hesklang['mfs']='La mida màxima del fitxer adjunt:';
$hesklang['lps']='La vostra preferència d\'idioma s\'ha desat';
$hesklang['sav']='Mostrar la vista de l\'article';
$hesklang['sad']='Mostrar la data d\'article';
$hesklang['emp']='El vostre PHP no té habilitat el suport de MySQL (es requereix l\'extensió mysqli)';
$hesklang['epd']='[HESK] EMAIL PIPING AQUESTA DESHABILITAT ALS AJUSTOS';
$hesklang['pfd']='[HESK] POP3 FETCHING ESTÀ DESHABILITAT ALS AJUSTOS';
$hesklang['pem']='[Piped email]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Client]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='Email';
$hesklang['pop3']='POP3 Fetching';
$hesklang['pop3h']='Servidor POP3';
$hesklang['pop3p']='Port POP3';
$hesklang['pop3tls']='Protocol TLS';
$hesklang['pop3u']='Usuari POP3';
$hesklang['pop3w']='Contrasenya POP3';
$hesklang['pop3e']='Error POP3';
$hesklang['pop3log']='Connexió de registre POP3';
$hesklang['mysqltest']='Test de connexió MySQL';
$hesklang['smtptest']='Test de connexió SMTP';
$hesklang['pop3test']='Test de connexió POP3';
$hesklang['contest']='Provant connexió , això pot trigar una mica...';
$hesklang['conok']='Connexió exitosa!';
$hesklang['conokn']='No obstant això, si el vostre servidor requereix nom d\'usuari i contrasenya el correu no s\'enviarà!';
$hesklang['saving']='Desant canvis, espereu...';
$hesklang['sns']='Els canvis es van desar, però algunes funcions es van deshabilitar per proves fallides.';
$hesklang['looph']='Màxim de Correus';
$hesklang['loopt']='Rang de temps';
$hesklang['didum']='Voleu dir %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Sí, canvia\'l';
$hesklang['nole']='No, deixa-ho així';
$hesklang['sconfe2']='Mostrar camp &quot;Confirmar email&quot; al formulari de tiquet';
$hesklang['oln']='Nom anterior:';
$hesklang['nen']='Nom Nou:';
$hesklang['use_form_below']='<i>Utilitzeu aquest formulari per enviar una sol·licitud de suport. Els camps obligatoris estan marcats amb</i>';
$hesklang['esf']='No s\'han pogut enviar notificacions per correu electrònic.';
$hesklang['qrr']='(Resposta citada eliminada)';
$hesklang['remqr']='Eliminar citat en resposta';
$hesklang['remqr2']='Eliminar la resposta citada dels Emails dels clients';
$hesklang['suge']='Detectar errors tipogràfics';
$hesklang['epro']='Proveïdors de correu electrònic';
$hesklang['email_noreply']='&quot;De:&quot; email';
$hesklang['email_name']='&quot;De:&quot; nom';
$hesklang['vscl']='Límits de configuració del servidor';
$hesklang['fnuscphp']='Càrrega de fitxers fallida, prova amb un fitxer adjunt més petit o sense adjunt.';
$hesklang['redv']='restablir la vista predeterminada';
$hesklang['fatte1']='Els paràmetres de fitxers adjunts &quot;Número per missatge&quot; és superior al que el vostre servidor permet!';
$hesklang['fatte2']='Els paràmetres de mida màxima de fitxer adjunts són superiors al que el vostre servidor permet!';
$hesklang['fatte3']='El vostre servidor no permet missatges amb aquesta mida, intenteu reduir el nombre de fitxers adjunts o mida de fitxer permesa!';
$hesklang['embed']='Fitxers incrustats';
$hesklang['embed2']='Desar fitxers incrustats com a fitxers adjunts';
$hesklang['emrem']='(imatge eliminada)';
$hesklang['hdemo']='(OCULT EN DEMO)';
$hesklang['ddemo']='Ho sentim, aquesta funció s\'ha desactivat en mode DEMO!';
$hesklang['sdemo']='L\'opció per desar els canvis s\'ha desactivat en mode DEMO';
$hesklang['hud']='El Centre de Suport està al dia';
$hesklang['hnw']='Actualització disponible';
$hesklang['getup']='Actualitzar el Centre de Suport';
$hesklang['updates']='Actualitzacions';
$hesklang['updates2']='Comprovar automàticament si hi ha actualitzacions.';

// Added in version 2.5.0
$hesklang['attdel']='Aquest fitxer ha estat esborrat del servidor i ja no està disponible per a baixar';
$hesklang['dsen']='No enviar al client notificacions de correu electrònic per a aquesta resposta';
$hesklang['attrem']='* Alguns fitxers adjunts s\'han suprimit *';
$hesklang['attnum']='Nombre màxim assolit: %s'; // %s will show attachment name
$hesklang['attsiz']='El fitxer és massa gran: %s'; // %s will show attachment name
$hesklang['atttyp']='Tipus no permès: %s'; // %s will show attachment name
$hesklang['adf']='Directori administrador';
$hesklang['atf']='Directori Adjunts';
$hesklang['err_adf']='El directori d\'administrador seleccionat (%s) no existeix!'; // %s will show folder name
$hesklang['err_atf']='El directori d\'adjunts seleccionat (%s) no existeix!'; // %s will show folder name
$hesklang['err_atr']='El directori d\'adjunts seleccionat (%s) no és escrivible!'; // %s will show folder name
$hesklang['fatt']='Fitxers adjunts del missatge:';
$hesklang['wrepo']='Si us plau escriviu una resposta després de tornar a obrir el tiquet.';
$hesklang['ktool']='Eines de la base de coneixements';
$hesklang['uac']='Verificar i actualitzar el recompte d\'article a Categoria';
$hesklang['acv']='Recompte d\'article ha estat verificat';
$hesklang['xyz']='nombre d\'articles públics, privats i del projecte a la categoria.';
$hesklang['reports_tab']='Informes d\'execució'; // Tab title
$hesklang['can_run_reports_full']='Podeu executar informes (tots)';
$hesklang['can_export']='Podeu exportar tiquets';
$hesklang['roo']='<i>(només s\'inclouen a l\'informe els tiquets que teniu assignats)</i>';
$hesklang['shu']='Enllaços curts';
$hesklang['export']='Exporta els tiquets'; // Tab title
$hesklang['export_btn']='Exportar tiquets'; // Button title
$hesklang['export_intro']='Aquesta eina us permet exportar tiquets en un full de càlcul XML que es pot obrir a Excel.';
$hesklang['stte']='Seleccioneu tiquets per exportar';
$hesklang['dtrg']='Interval de dates';
$hesklang['sequentially']='Seqüencial'; // Order tickets: Sequentially
$hesklang['ede']='No es pot crear el directori d\'exportació, si us plau, creeu manualment un directori anomenat <b>export</b> dins de la vostra carpeta de fitxers adjunts i assegureu-vos que teniu permisos d\'escriptura per PHP (en Linux CHMOD 777 - rwxrwxrwx).';
$hesklang['eef']='No es pot crear el fitxer d\'exportació, no teniu permís per escriure al directori d\'exportació.';
$hesklang['inite']='Iniciant exportació';
$hesklang['gXML']='Generant fitxers XML';
$hesklang['nrow']='Nombre de files exportades: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Comprimint fitxers a Zip';
$hesklang['eZIP']='Error en crear el fitxer Zip';
$hesklang['fZIP']='La compressió del fitxer ha finalitzat';
$hesklang['pmem']='Màxim ús de la memòria: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; CLICK AQUÍ PER DESCARREGAR L\'ARXIU EXPORTAT &laquo;';
$hesklang['n2ex']='No hi ha entrades que coincideixin amb els seus criteris, res per exportar!';
$hesklang['sp']='Prevenció SPAM'; // For settings page
$hesklang['sit']='Tipus d\'Imatge';
$hesklang['sis']='Imatge simple';
$hesklang['rcpb']='Clau del lloc';
$hesklang['rcpv']='Clau secreta';
$hesklang['pop3keep']='Mantenir una còpia';
$hesklang['beta']='(VERSIÓ DE PROVA)';
$hesklang['maxpost']='Probablement heu intentat enviar més dades de les que aquest servidor accepta.<br /><br />Si us plau, intenteu enviar el formulari de nou amb menys dades o sense.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='No s\'ha pogut validar la protecció reCAPTCHA SPAM.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Tiquet tancat/resolt';
$hesklang['ms01']='Gen';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Abr';
$hesklang['ms05']='Mai';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Ago';
$hesklang['ms09']='Set';
$hesklang['ms10']='Oct';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Des';
$hesklang['sdf']='Format de data Enviat';
$hesklang['lcf']='Format de data actualitzat';
$hesklang['lcf0']='Descriptiu Curt';
$hesklang['lcf1']='Data i Hora';
$hesklang['lcf2']='Estil HESK';
$hesklang['ticket_tpl']='Plantilles de tiquets';
$hesklang['can_man_ticket_tpl']='Administrar plantilles de tiquet'; // Permission title
$hesklang['ticket_tpl_man']='Administrar plantilles de tiquet'; // Page and link title
$hesklang['ticket_tpl_intro']='Crear i editar les plantilles d\'entrades que podeu utilitzar per enviar ràpidament noves entrades des de la interfície d\'administració.';
$hesklang['no_ticket_tpl']='Sense plantilles de tiquet';
$hesklang['ticket_tpl_title']='Títol';
$hesklang['delete_tpl']='Segur que voleu suprimir aquesta plantilla?';
$hesklang['new_ticket_tpl']='Agregar o editar una plantilla de tiquet';
$hesklang['ticket_tpl_add']='Nova plantilla de tiquet';
$hesklang['ticket_tpl_edit']='Editar plantilla del tiquet seleccionat';
$hesklang['save_ticket_tpl']='Desa la plantilla de tiquet';
$hesklang['ticket_tpl_saved']='La vostra plantilla de tiquet s\'ha desat per al seu futur ús';
$hesklang['ticket_tpl_removed']='La plantilla de tiquet seleccionada s\'ha eliminat de la base de dades';
$hesklang['ticket_tpl_not_found']='La plantilla de tiquet no trobada';
$hesklang['sel_ticket_tpl']='Seleccioneu la plantilla de tiquet que us agradaria editar';
$hesklang['ent_ticket_tpl_title']='Si us plau indiqueu títol de la plantilla';
$hesklang['ent_ticket_tpl_msg']='Si us plau indiqueu el missatge de plantilla';
$hesklang['ticket_tpl_id']='Falta l\'ID de la plantilla de tiquet';
$hesklang['select_ticket_tpl']='Seleccioneu una plantilla de tiquet';
$hesklang['list_tickets_cat']='Mostra tots els tiquets d\'aquesta categoria';
$hesklang['def_msg']='[Sense missatge]';
$hesklang['emlreqmsg']='Requerir missatge';
$hesklang['emlreqmsg2']='Ignorar correus canalitzats/obtinguts sense missatge';
$hesklang['relart']='Articles relacionats'; // Title of related articles box
$hesklang['s_relart']='Articles relacionats'; // On settings page
$hesklang['tab_7']='Llista de tiquets';
$hesklang['fitl']='Camps a la Llista de Tiquets';
$hesklang['submitted']='Enviat';
$hesklang['clickemail']='Veure';
$hesklang['set_pri_to']='Establir prioritat a:'; // Action below the ticket list
$hesklang['pri_set_to']='Prioritat s\'ha establert a:';
$hesklang['cat_pri']='La prioritat de categoria s\'utilitzarà quan als clients no se\'ls permet seleccionar la prioritat i un tiquet s\'envia des de la interfície del client.';
$hesklang['cat_pri_info']='Si als seus clients se\'ls permet seleccionar la prioritat, s\'ignorarà la prioritat de categoria.<br /><br />Per utilitzar la prioritat de categoria, deshabiliteu aquesta funció a la configuració de HESK :';
$hesklang['def_pri']='Prioritat de categoria:';
$hesklang['ch_cat_pri']='Establir prioritat de categoria';
$hesklang['cat_pri_ch']='La prioritat de categoria s\'ha establert a:';
$hesklang['err_dbversion']='Versió de MySQL molt antiga:';
$hesklang['ip_whois']='IP WHOIS';
$hesklang['ednote']='Editar nota de missatge';
$hesklang['ednote2']='Nota de missatge desada';
$hesklang['perm_deny']='Permís denegat';
$hesklang['mis_note']='Falta l\'ID de la nota';
$hesklang['no_note']='Nota amb aquesta ID no trobada';
$hesklang['sacl']='Desa i continua després';
$hesklang['reply_saved']='El vostre missatge de resposta s\'ha desat per al vostre ús posterior.';
$hesklang['submit_as']='Envia com:';
$hesklang['sasc']='Envia com: resposta del client';
$hesklang['creb']='Resposta del client introduïda per:';
$hesklang['show_select']='Mostrar &quot;Clik per seleccionar&quot; com a opció per defecte';
// Settings
$hesklang['mms']='Mode manteniment';
$hesklang['mmd']='Habilitar mode de manteniment';
// Customer notice
$hesklang['mm1']='Manteniment en curs';
$hesklang['mm2']='A fi de realitzar tasques de manteniment programades, el nostre centre de suport està deshabilitat temporalment.';
$hesklang['mm3']='Demanem disculpes per les molèsties i demanem que si us plau intenteu de nou més tard.';
// Staff notice
$hesklang['mma1']='El mode de manteniment està actiu!';
$hesklang['mma2']='El servei de suport està deshabilitat per als clients.';
$hesklang['tools']='Eines';
$hesklang['banemail']='Prohibir els correus electrònics';
$hesklang['banemail_intro']='Evitar que certes adreces de correu electrònic enviïn tiquets al servei de suport.';
$hesklang['no_banemails']='<i>No hi ha correus electrònics bloquejats.</i>';
$hesklang['eperm']='Bloqueig d\'emails permanents:';
$hesklang['bananemail']='Adreça de correu electrònic a bloquejar';
$hesklang['savebanemail']='Bloqueja aquesta adreça de correu electrònic';
$hesklang['enterbanemail']='Introduïu l\'adreça de correu electrònic que voleu bloquejar.';
$hesklang['validbanemail']='Introduïu una adreça de correu electrònic vàlida (<i>john.doe@domain.com</i>) o domini d\'adreça de correu electrònic (<i>@domain.com</i >)';
$hesklang['email_banned']='L\'adreça de correu electrònic <i>%s</i> està bloquejada i HESK ja no acceptarà tiquets d\'aquesta adreça.'; // %s will be replaced with email
$hesklang['emailbanexists']='Aquesta adreça de correu electrònic <i>%s</i> ja està bloquejada.'; // %s will be replaced with email
$hesklang['email_unbanned']='Adreça de correu electrònic desbloquejada';
$hesklang['banby']='Bloquejada per';
$hesklang['delban']='Desbloqueja';
$hesklang['delban_confirm']='Desbloquejar?';
$hesklang['baned_e']='Se us ha prohibit enviar noves sol·licituds de suport.';
$hesklang['baned_ip']='Se us ha prohibit utilitzar aquest centre de suport';
$hesklang['can_ban_emails']='Podeu bloquejar adreça de correu electrònic';
$hesklang['can_unban_emails']='Podeu desbloquejar adreça de correu electrònic (habilita el bloqueig d\'Emails)';
$hesklang['eisban']='Aquesta adreça electrònica està bloquejada.';
$hesklang['click_unban']='Feu clic aquí per desbloquejar.';
$hesklang['banip']='Bloqueja IPs';
$hesklang['banip_intro']='Els visitants d\'aquestes adreces IP bloquejades no podran veure o enviar tiquets ni tampoc podran iniciar sessió al Centre de Suport.';
$hesklang['ipperm']='Bloqueig IP permanent:';
$hesklang['iptemp']='Bloqueig d\'inici de sessió fallit:';
$hesklang['savebanip']='Bloqueja aquesta IP';
$hesklang['no_banips']='<i>No hi ha IPs bloquejades.</i>';
$hesklang['bananip']='IP a bloquejar';
$hesklang['banex']='Exemples:';
$hesklang['iprange']='Rang d\'IP';
$hesklang['ippermban']='Bloqueja aquesta IP permanentment';
$hesklang['enterbanip']='Introduïu la IP o rang d\'IP que voleu bloquejar.';
$hesklang['validbanip']='Introduïu una IP vàlida o rang d\'IP';
$hesklang['ip_banned']='La IP <i>%s</i> ha estat bloquejada i HESK ja no acceptarà tiquets d\'aquesta IP.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Aquest rang d\'IP <i>%s</i> ha estat bloquejat i HESK ja no acceptarà tiquets d\'aquest rang d\'IP.'; // %s will be replaced with IP
$hesklang['ipbanexists']='Aquesta IP <i>%s</i> ja està bloquejada .'; // %s will be replaced with IP
$hesklang['iprbanexists']='Aquest rang d\'IP <i>%s</i> ja està bloquejat.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP desbloquejada';
$hesklang['ip_tempun']='IP desbloquejada temporalment';
$hesklang['can_ban_ips']='Bloqueja IPs deshabilitat';
$hesklang['can_unban_ips']='Podeu desbloquejar IPs (habilita bloquejar IPs)';
$hesklang['ipisban']='Aquesta IP està bloquejada.';
$hesklang['m2e']='Expira en (minuts)';
$hesklang['info']='Info';
$hesklang['sm_title']='Missatges de Servei';
$hesklang['sm_intro']='Mostra un missatge a l\'àrea de clients, per exemple, per notificar-los sobre problemes coneguts i notícies importants.';
$hesklang['can_service_msg']='Editar Missatges del Centre de Suport';
$hesklang['new_sm']='Nou Missatge del Centre de Suport';
$hesklang['edit_sm']='Edita Missatge del Centre de Suport';
$hesklang['ex_sm']='Missatges del Centre de Suport Existents';
$hesklang['sm_author']='Autor';
$hesklang['sm_type']='Tipus';
$hesklang['sm_published']='Publicat';
$hesklang['sm_draft']='Esborrany';
$hesklang['sm_style']='Estil';
$hesklang['sm_none']='Cap';
$hesklang['sm_success']='Realitzat';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Notícia';
$hesklang['sm_error']='Error';
$hesklang['sm_save']='Desa';
$hesklang['sm_preview']='Previsualitzar';
$hesklang['sm_mtitle']='Títol';
$hesklang['sm_msg']='Missatge';
$hesklang['sm_e_title']='Introduïu el títol del missatge';
$hesklang['sm_e_msg']='Introduïu el Missatge del Centre de Suport';
$hesklang['sm_e_id']='Falta l\'ID del missatge';
$hesklang['sm_added']='S\'ha afegit un missatge nou del centre de suport';
$hesklang['sm_deleted']='Missatge del Centre de Suport eliminat';
$hesklang['sm_not_found']='Aquest missatge del Centre de Suport no existeix';
$hesklang['no_sm']='No hi ha Missatges del Centre de Suport';
$hesklang['del_sm']='Eliminar aquest Missatge?';
$hesklang['sm_mdf']='El missatge ha estat desat';
$hesklang['sska']='Mostrar articles suggerits';
$hesklang['taws']='Aquests articles estan relacionats:';
$hesklang['defaults']='Predeterminats';
$hesklang['pncn']='Seleccionar opció: notificar al client al formulari de nou tiquet';
$hesklang['pncr']='Seleccionar opció: notificar al client al formulari de resposta';
$hesklang['pssy']='Mostrar els articles de la base de coneixements suggerits als clients';
$hesklang['ccct']='Resol el Client';
$hesklang['custnot']='Notificar al Client quan';
$hesklang['notnew']='S\'ha enviat una sol·licitud d\'ajuda nova';
$hesklang['notclo']='Un tiquet de suport es marca com a Resolt';
$hesklang['enn']='Excepte les entrades dels correus electrònics si l\'assumpte del correu electrònic conté:';
$hesklang['spamn']='Notificació SPAM';
$hesklang['spam_inbox']='<span style="color:xarxa"><b>Sense correu electrònic de confirmació?</b><br />Enviem un missatge de confirmació a la vostra adreça de correu electrònic. Si no el rep en pocs minuts, si us plau reviseu la vostra carpeta de correu no desitjat. Marqueu el missatge com a <b>No SPAM</b> per evitar problemes en el futur en rebre la nostra correspondència.</span>';
$hesklang['ekb_n']='<b>No</b>, Deshabilita Base de Coneixement';
$hesklang['ekb_y']='<b>Sí</b>, habilitar Base de Coneixement';
$hesklang['ekb_o']='<b>Sí</b>, utilitzar HESK com a Base de Coneixement només (<i>Deshabilitar Centre de Suport</i>)';
$hesklang['kb_set']='Configuració Base de Coneixement';
$hesklang['kbo1']='Mode Base de Coneixement només';
$hesklang['kbo2']='<br /><br />Els visitants no poden enviar tiquets de suport i són portats directament a la base de coneixement.';
$hesklang['fpass']='Heu oblidat la vostra contrasenya?';
$hesklang['passr']='Restablir contrasenya';
$hesklang['passa']='Permetre als Clients restablir la contrasenya a través del correu electrònic';
$hesklang['passe']='Introduïu la vostra adreça de correu electrònic';
$hesklang['passs']='Restablir contrasenya';
$hesklang['noace']='No s\'ha trobat un compte amb aquesta adreça de correu electrònic';
$hesklang['pemls']='Li hem enviat un correu electrònic amb instruccions sobre com restablir la contrasenya';
$hesklang['reset_password']='Restablir la contrasenya'; // Email subject
$hesklang['ehash']='Enllaç de restabliment de contrasenya no vàlid o caducat';
$hesklang['ehaip']='Adreça IP incorrecta. Les contrasenyes només es poden restablir a partir de l\'adreça IP que va sol·licitar el restabliment de contrasenya.';
$hesklang['resim']='<b>Introduïu la vostra nova contrasenya al formulari de sota!</b>';
$hesklang['permissions']='Permisos';
$hesklang['atype']='Tipus de compte';
$hesklang['astaff']='Personal';
$hesklang['oon1']='Envia\'m només tiquets oberts';
$hesklang['oon2']='Envia\'m tots els meus tiquets';
$hesklang['anyown']='Qualsevol propietari';
$hesklang['pfr']='Una altra tasca de POP3 fetching encara està en curs.';
$hesklang['pjt']='Temps d\'espera per a les tasques';
$hesklang['pjt2']='minuts després de començar';
$hesklang['nkba']='La cerca a la Base de Coneixements requereix suficients articles únics perquè funcioni correctament.<br /><br />Considereu afegir més articles a la base de coneixements per millorar els resultats de cerca i articles de suggeriments.';
$hesklang['saa']='Els articles rellevants es mostren a la part superior de la llista d\'articles';
$hesklang['yhbr']='Se li ha bloquejat l\'accés al sistema durant %s minuts, a causa de massa respostes a un tiquet.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='ca';

// Added in version 2.7.0
$hesklang['imap']='Obtenció IMAP';
$hesklang['imaph']='Amfitrió d\'IMAP';
$hesklang['imapp']='Port IMAP';
$hesklang['enc']='Xifrat';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Cap';
$hesklang['imapu']='Nom d\'usuari IMAP';
$hesklang['imapw']='Contrasenya IMAP';
$hesklang['imaptest']='Prova de connexió IMAP';
$hesklang['ifd']='[HESK] IMAP FETCHING ESTÀ DESHABILITAT EN CONFIGURACIONS';
$hesklang['iei']='[HESK] L\'extensió PHP IMAP no està instal·lada.';
$hesklang['ifr']='Una altra tasca de cerca IMAP encara està en curs.';
$hesklang['arp']='Recàrrega automàtica de pàgina';
$hesklang['arpp']='Recarregar automàticament la pàgina amb la llista de tiquets cada:';
$hesklang['seconds']='segons';
$hesklang['minutes']='minuts';
$hesklang['atbr']='Aquest tiquet ha de ser assignat abans que pugui ser contestat.';
$hesklang['attm']='Assignar-me aquest tiquet a mi mateix';
$hesklang['owneed']='Propietari necessari';
$hesklang['taat']='Aquest tiquet ja està assignat a<b>%s</b>.';
$hesklang['scoy']='Esteu segur que voleu assignar-lo a vostè mateix?';
$hesklang['scot']='Esteu segur que voleu assignar-lo a %s?';
$hesklang['ycto']='SÍ, canviar el propietari';
$hesklang['ncto']='NO, mantenir el propietari actual';
$hesklang['fass']='Requereix propietari';
$hesklang['req_sub']='Requereix assumpte';
$hesklang['req_msg']='Requereix missatge';
$hesklang['req_email']='Requereix correu electrònic';
$hesklang['default_subject']='Tiquet des de %s';
$hesklang['off-hide']='Ocultar al formulari de client';
$hesklang['not_valid_email']='Introduïu una adreça de correu electrònic vàlida o deixeu aquest camp buit';
$hesklang['write_down']='<span style="color:red">Us recomanem que anoteu el vostre ID de tiquet per a referència futura.</span>';
$hesklang['re_confirm1']='En inhabilitar-lo, també es deshabilitarà "Requerir correu electrònic per veure les entrades" a "Seguretat". Procedir?';
$hesklang['re_confirm2']='Habilitar això també habilitarà "Requerir correu electrònic" a "Funcions". Procedir?';
$hesklang['can_email_tpl']='Editar plantilles de correu electrònic';
$hesklang['et_title']='Plantilles de correu electrònic';
$hesklang['et_intro']='Modifiqueu els correus electrònics que s\'envien al vostre personal i clients';
$hesklang['file']='Fitxer';
$hesklang['efile']='Edició del fitxer';
$hesklang['rdesc']='Descripció';
$hesklang['desc_forgot_ticket_id']='(Client) Heu oblidat l\'ID de seguiment del tiquet';
$hesklang['desc_new_reply_by_staff']='(Client) Nova resposta del personal';
$hesklang['desc_new_ticket']='(Client) Tiquet rebut';
$hesklang['desc_ticket_closed']='(Client) Tiquet tancat/resolt';
$hesklang['desc_category_moved']='(Empleats) El tiquet es trasllat a una nova categoria';
$hesklang['desc_new_reply_by_customer']='(Empleats) Nova resposta de client';
$hesklang['desc_new_ticket_staff']='(Empleats) Nou tiquet enviat';
$hesklang['desc_ticket_assigned_to_you']='(Empleats) Se li va assignar un tiquet';
$hesklang['desc_new_pm']='(Empleats) Nou missatge privat';
$hesklang['desc_new_note']='(Empleats) Nova nota en un tiquet assignat a Vostè';
$hesklang['desc_reset_password']='(Empleats) Restablir la contrasenya';
$hesklang['etfm']='Falten una o més plantilles de correu electrònic.<br><br>Assegureu-vos de pujar tots els fitxers de plantilles de correu electrònic dins d\'aquestes dues carpetes:<br><br><i> /language/%s/emails</i><br><i>/language/%s/html_emails</i>';
$hesklang['etfw']='Algunes plantilles de correu electrònic no són escrivibles.<br><br>
                    Assegureu-vos que PHP té permís per escriure a tots els fitxers dins d\'aquestes dues carpetes:<br><br>
                    <i>/language/%s/emails</i><br>
                    <i>/language/%s/html_emails</i><br><br>
                    Als servidors Unix pot ser necessari CHMOD les plantilles de correu electrònic a 666 (rw-rw-rw-)';
$hesklang['et_e_id']='ID de plantilla absent';
$hesklang['et_fm']='Falta aquest fitxer de plantilla de correu electrònic';
$hesklang['et_fw']='Aquesta plantilla de correu electrònic no es pot escriure';
$hesklang['et_save']='Desa Canvis';
$hesklang['updated_on']='Actualitzat a';
$hesklang['ticket_url']='URL de tiquet';
$hesklang['pm_url']='URL de missatge privat';
$hesklang['et_num']='Nombre de tiquets';
$hesklang['et_list']='Llista de tiquets de suport';
$hesklang['et_empty']='La plantilla de correu electrònic no pot estar buida';
$hesklang['et_saved']='Plantilla de correu electrònic desada';
$hesklang['source']='Font';
$hesklang['select_category']='Seleccioneu una categoria';
$hesklang['select_category_text']='En què us podem ajudar?';
$hesklang['select_category_staff']='Seleccioneu la categoria del tiquet';
$hesklang['scat']='Límit de selecció de categoria';
$hesklang['scat2']='(Un quadre de selecció mostrarà si el recompte de categories és més gran)';
$hesklang['new_cf']='Nou camp personalitzat';
$hesklang['cf_intro']='Utilitzeu aquesta funció per afegir camps personalitzats al formulari Envia un tiquet perquè pugueu recopilar dades addicionals dels clients.';
$hesklang['cf_public']='Públic';
$hesklang['cf_private']='Només Personal';
$hesklang['cf_cust']='Per a clients';
$hesklang['cf_all']='Tot';
$hesklang['cf_cat']='seleccionat';
$hesklang['cf_ctrl']='Suggeriment: manteniu premuda la tecla CTRL per seleccionar diverses categories';
$hesklang['visibility']='Visibilitat';
$hesklang['cf_save']='Desa camp personalitzat';
$hesklang['ex_cf']='Camps personalitzats actius';
$hesklang['no_cf']='No hi ha camps personalitzats actius';
$hesklang['del_cf']='Voleu suprimir aquest camp personalitzat? Això també suprimirà les dades de camp personalitzades desades de la base de dades!';
$hesklang['cf_e_id']='ID no vàlida';
$hesklang['edit_cf']='Editar camp personalitzat';
$hesklang['cf_deleted']='Camp personalitzat eliminat';
$hesklang['cf_not_found']='Aquest camp personalitzat no existeix';
$hesklang['cf_added']='S\'ha afegit un nou camp personalitzat';
$hesklang['cf_nocat']='Seleccioneu almenys una categoria per a aquest camp personalitzat';
$hesklang['cf_mdf']='El camp personalitzat s\'ha desat';
$hesklang['atl1']='Introduïu almenys una opció.';
$hesklang['sch']='Ocult';
$hesklang['meml3']='Permet que s\'introdueixin diversos correus electrònics';
$hesklang['dmin']='Data mínima acceptada';
$hesklang['dmax']='Data màxima acceptada';
$hesklang['d_day']='dia(es)';
$hesklang['d_week']='setmana(es)';
$hesklang['d_month']='mes(s)';
$hesklang['d_year']='any(s)';
$hesklang['d_any']='Qualsevol data';
$hesklang['d_fixed']='Data fixada';
$hesklang['d_relative']='Data relativa';
$hesklang['d_mm']='La data mínima no pot ser superior a la data màxima';
$hesklang['d_emin']='Data mínima per a <i>%s</i> és %s';
$hesklang['d_emax']='Data màxima per a <i>%s</i> és %s';
$hesklang['d_format']='Format de visualització de data';
$hesklang['d_custom']='Format personalitzat';
$hesklang['d_ci']='NOMÉS PER A USUARIS AVANÇATS: Un format de data PHP vàlid, consulteu el manual de PHP.';
$hesklang['cf_noe']='Introduïu una adreça de correu electrònic vàlida a <i>%s</i>';
$hesklang['cf_noem']='Introduïu una o més adreces de correu electrònic vàlides a <i>%s</i>';
$hesklang['can_resolve']='Podeu resoldre tiquets';
$hesklang['can_change_own_cat']='Canviar categoria de tiquet (permès)';
$hesklang['can_submit_any_cat']='Podeu enviar tiquets a qualsevol categoria';
$hesklang['noauth_submit']='No està autoritzat per enviar tiquets a aquesta categoria!';
$hesklang['noauth_move']='No teniu autorització per moure tiquets a aquesta categoria!';
$hesklang['noauth_resolve']='No està autoritzat per resoldre els tiquets!';
$hesklang['force_ssl']='Forçar connexions SSL';
$hesklang['d_ssl']='<i>deshabilitat</i> - Obriu aquesta pàgina amb https:// Per gestionar aquesta opció';
$hesklang['scno']='Aquest estat no es pot canviar';
$hesklang['statuses']='Estats';
$hesklang['statuses_intro']='Utilitzeu aquesta eina per afegir estats personalitzats de tiquets al vostre Centre de Suport';
$hesklang['color']='Color';
$hesklang['csscl']='Classe CSS o color';
$hesklang['clr_view']='Vista prèvia del color al text';
$hesklang['cbc']='Modificable pels clients';
$hesklang['ccc']='Els clients poden canviar aquest estat?';
$hesklang['del_status']='Eliminar aquest estat?';
$hesklang['ex_status']='Estats existents';
$hesklang['status_hesk']='Estats predeterminats (no es pot modificar aquí)';
$hesklang['status_custom']='Estats personalitzats';
$hesklang['status_custom_none']='No hi ha estats personalitzats. Podeu afegir-los fent clic a "Nou estat personalitzat" a dalt.';
$hesklang['status_save']='Desa';
$hesklang['list_tkt_status']='Anoteu totes les entrades amb aquest estat';
$hesklang['new_status']='Nou estat personalització';
$hesklang['edit_status']='Editar estat personalitzat';
$hesklang['err_status']='Introduïu el nom de l\'estat';
$hesklang['status_added']='S\'ha afegit un nou estat personalitzat';
$hesklang['status_e_id']='ID no vàlida';
$hesklang['status_mdf']='L\'estat personalitzat s\'ha desat';
$hesklang['status_deleted']='Estat personalitzat eliminat';
$hesklang['status_not_found']='Aquest estat personalitzat no existeix';
$hesklang['status_not_empty']='No es pot eliminar aquest estat perquè hi ha tiquets amb aquest estat.';
$hesklang['status_limit']='Té 100 estats personalitzats, no es poden crear nous.';
$hesklang['public_link']='Enllaç públic';
$hesklang['frames']='Frames/marcs';
$hesklang['frames2']='Evitar la càrrega de HESK en frames/marcs en dominis de tercers';
$hesklang['numsub']='Tiquets enviats';
$hesklang['hidf']='Les entrades ocultes no són visibles per als clients al formulari Enviar un tiquet (El valor seguirà estant visible a la pàgina de detalls del tiquet si estan configurats com a públics). Es comporten com a camps normals de text per als membres del personal.';
$hesklang['rcheck']='No seleccioneu una opció predeterminada';
$hesklang['refresh_page']='Actualitzar aquesta pàgina';
$hesklang['del_kba']='Elimina aquest article';
$hesklang['del_kbaa']='Eliminar permanentment aquest article';
$hesklang['hni1']='HESK encara no està instal·lat?';
$hesklang['hni2']='Sembla que aquest Centre de Suport no ha estat instal·lat i configurat correctament.';
$hesklang['hni3']='Per instal·lar HESK, seguiu les <a class="link" href="docs/">Instruccions a la documentació</a>';
$hesklang['cf']='Carpeta de memòria cau';
$hesklang['e_cdir']='Hesk no serà capaç d\'analitzar correus electrònics o resultats de memòria cau a no ser que la carpeta de memòria cau existeixi i sigui escrivible.';
$hesklang['step1']='Pas 1';
$hesklang['step2']='Pas 2';
$hesklang['dffs']='Quan acabi la baixada, elimineu el fitxer del servidor';
$hesklang['fd']='arxiu exportat eliminat del servidor';

// Added in version 2.8.0
$hesklang['TZ']='Zona horària';
$hesklang['thist17']='<li class="smaller">%s | enviat per IMAP fetching</li>';
$hesklang['sir3']='reCAPTCHA invisible';
$hesklang['invisible']='invisible';
$hesklang['imap_not']='PHP no està compilat amb suport IMAP';
$hesklang['imap_warning']='l\'usuari %1$s té la mateixa adreça de correu electrònic que l\'adreça de correu electrònic de recuperació IMAP: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='l\'usuari %1$s té la mateixa adreça de correu electrònic que la vostra adreça de correu POP3: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Això podria generar un bucle de correu electrònic on es crearan nous tiquets a partir de les notificacions dels usuaris per correu electrònic. La vostra adreça de correu electrònic ha de ser única i no utilitzada per ningú més.';
$hesklang['can_view_ass_by']='Podeu veure els tiquets que heu assignat a altres';
$hesklang['can_privacy']='Podeu anonimitzar els tiquets';
$hesklang['confirm_anony']='Anonimitzar aquest tiquet';
$hesklang['anon_selected']='Anonimitzar els tiquets seleccionats';
$hesklang['privacy_anon_info']='Eliminar totes les dades d\'identificació personal i el contingut dels tiquets (nom del client, correu electrònic, missatge, fitxers adjunts, IP...), però mantenir els tiquets a la base de dades per a estadístiques (dret a ser oblidat).';
$hesklang['success_anon']='Tiquet exitosament anonimitzat';
$hesklang['num_tickets_anon']='Nombre de tiquets anonimitzats: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Client]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Assumpte]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Missatge]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonimitzat per %s</li>';
$hesklang['print_selected']='Imprimir tiquets seleccionats';
$hesklang['with_selected']='Seleccionat/s:';
$hesklang['assign_selected']='Assignar seleccionat/sa:';
$hesklang['assign_no']='Sense propietari seleccionat, sense canvis realitzats';
$hesklang['assign_1']='Els tiquets seleccionats s\'han configurat com a Sense assignar.';
$hesklang['assign_2']='Tiquet ID %1$s establert a Sense assignar'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s error: ja assignat a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s assignat a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s error: %2$s no té accés a la categoria de tiquet'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultat d\'assignació massiva de tiquets:<br /><br />Assignats: %1$s<br />Errors: %2$s<br /><br />Registre: <br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='Adreça IP';
$hesklang['moret']='Més opcions'; // More options button title
$hesklang['btn_more']='Més'; // More options button text
$hesklang['btn_print']='Imprimeix';
$hesklang['btn_edit']='Editar';
$hesklang['btn_lock']='Bloqueja el tiquet';
$hesklang['btn_unlock']='Desbloqueja el tiquet';
$hesklang['btn_tag']='Etiquetar tiquet';
$hesklang['btn_resend']='Re-enviar notificació de correu electrònic';
$hesklang['btn_untag']='Desetiquetar tiquet';
$hesklang['btn_import_kb']='Importa a la Base de dades';
$hesklang['btn_anony']='Anonimitzar tiquet';
$hesklang['btn_delt']='Eliminar tiquet';
$hesklang['btn_delr']='Eliminar resposta';
$hesklang['ernf']='Resposta no trobada';
$hesklang['tns']='Les notificacions de tiquets van ser enviades de nou';
$hesklang['rns']='Les notificacions de resposta es van tornar a enviar';
$hesklang['fname']='Nom de pila';
$hesklang['export_selected']='Exportar tiquets seleccionats';
$hesklang['btn_export']='Exporta a XML per a Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Respostes';
$hesklang['team']='Equip';
$hesklang['sm_content']='Contingut';
$hesklang['sm_settings']='Configuració';
$hesklang['wizard_back']='Enrere'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Següent'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Anar a Configuració';
$hesklang['sm_return_to_editing']='Tornar a l\'edició';
$hesklang['email_tpl_title']='Títol';
$hesklang['edit_email_template']='Editar la plantilla de correu electrònic';
$hesklang['err_no_settings_section']='No s\'ha subministrat cap secció de configuració.';
$hesklang['this_field_is_required']='Aquest camp és obligatori';
$hesklang['reset_your_password']='Restablir la contrasenya';
$hesklang['reset_password_instructions']='Si us plau, ompliu el següent formulari. Us enviarem un enllaç perquè pugueu restablir la vostra contrasenya.';
$hesklang['enter_email']='Introduïu el correu electrònic';
$hesklang['password_reset_check_your_email']='Comproveu el vostre correu electrònic';
$hesklang['password_reset_link_sent']='Hem enviat un enllaç per restablir la contrasenya.';
$hesklang['back_to_login']='Tornar a l\'inici de sessió';
$hesklang['pager_first']='Primer';
$hesklang['pager_previous']='Anterior';
$hesklang['pager_next']='Següent';
$hesklang['pager_last']='Darrer';
$hesklang['new_team_member']='Nou membre de l\'equip';
$hesklang['role']='Rol';
$hesklang['optional']='Opcional';
$hesklang['edit_profile']='Editar Perfil';
$hesklang['assigned_to']='Assignat a';
$hesklang['contact']='Contacte';
$hesklang['unban_email']='Desbloqueja aquest correu electrònic';
$hesklang['unban_ip']='Desbloqueja aquesta IP';
$hesklang['show_previous_replies']='Mostra respostes anteriors';
$hesklang['type_your_message']='Escriviu el vostre missatge'; // Used when there are no canned responses
$hesklang['close_button_text']='Tancar';
$hesklang['create_new_ticket']='Crear nou tiquet';
$hesklang['delete_article']='Eliminar article';
$hesklang['view_existing_tickets']='Veure tiquets existents';
$hesklang['how_can_we_help']='Hola, com podem ajudar-lo?';
$hesklang['search_for_articles']='Cerca articles';
$hesklang['submit_a_support_request']='Envia una sol·licitud d\'assistència';
$hesklang['verify_header']='Prevenció de l\'SPAM';
$hesklang['ticket_details']='Detalls del tiquet';
$hesklang['yes_title_case']='Sí';
$hesklang['no_title_case']='No';
$hesklang['no_results_found']='No s\'han trobat resultats';
$hesklang['site_theme']='Tema del lloc';
$hesklang['test_theme_folder']='Comprovar la carpeta de temes';
$hesklang['test_theme_folder_description']='Provant la carpeta de temes per veure si els temes són vàlids. Només els temes que passen totes les proves s\'instal·len correctament.';
$hesklang['err_site_theme']='Si us plau, seleccioneu el tema de Hesk';
$hesklang['confirm']='Confirmar';
$hesklang['confirm_deletion']='Confirmar eliminació';
$hesklang['confirm_delete_status']='Esteu segur de voler esborrar aquest estat personalitzat?';
$hesklang['help_desk']='Centre de Suport'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.ca.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Visualització del temps';
$hesklang['tdisd']='Data i hora';
$hesklang['tdisa']='Fa temps (exemple: fa 5 hores)';
$hesklang['nav_templates']='Plantilles'; // Admin panel navigation item
$hesklang['hide_replies']='Ocultar les respostes dels tiquets';
$hesklang['hide_replies_no']='Mai, sempre mostrar totes les respostes';
$hesklang['hide_replies_yes']='Ocultar totes les respostes excepte l\'última:';
$hesklang['hide_replies_def']='Mostrar la darrera resposta del personal i qualsevol resposta posterior del client';
$hesklang['reply_by']='Resposta de'; // Reply by NAME
$hesklang['btt']='Tornar a l\'inici';
$hesklang['lwidth']='Limitar l\'amplada del tiquet';
$hesklang['lwidtall']='Utilitzar tota l\'amplada disponible';
$hesklang['lwidtpx']='Amplada màxima en píxels:';
// 3-letter days of the week
$hesklang['mon']='Dil';
$hesklang['tue']='Dim';
$hesklang['wed']='Dic';
$hesklang['thu']='Dij';
$hesklang['fri']='Div';
$hesklang['sat']='Dis';
$hesklang['sun']='Diu';
$hesklang['clear']='Esborra'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Almenys una mesura de prevenció d\'SPAM ha de ser activada!';
$hesklang['modules']='Mòduls';
$hesklang['modules_demo']='Aquest mòdul està disponible actualment només a %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Prova la demostració en viu aquí: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Estadístiques';
$hesklang['statistics']['intro']='Aquest informe us proporcionarà informació sobre l\'ús del vostre centre de suport i l\'exercici del personal';
$hesklang['statistics']['ntsp']='No hi ha tiquets en el període de temps seleccionat.';
$hesklang['statistics']['pie_title_ro']='Tiquets oberts vs. Resolts';
$hesklang['statistics']['open']='Oberts';
$hesklang['statistics']['resolved']='Resolts';
$hesklang['statistics']['pie_title_as']='Tiquets oberts: Assignats vs. Sense assignar';
$hesklang['statistics']['ass']='Assignats';
$hesklang['statistics']['unas']='No assignades';
$hesklang['statistics']['pie_title_au']='Tiquets oberts: Contestats vs. Sense resposta';
$hesklang['statistics']['answered']='Contestats';
$hesklang['statistics']['unanswered']='Sense resposta';
$hesklang['statistics']['pie_title_so']='Estats dels tiquets oberts';
$hesklang['statistics']['retic']='Tiquets:';
$hesklang['statistics']['chart_title_md']='Tiquets per dia del mes';
$hesklang['statistics']['chart_title_wd']='Tiquets per dia de la setmana';
$hesklang['statistics']['chart_title_hd']='Tiquets per hora del dia';
$hesklang['statistics']['chart_title_tfr']='Temps per a la primera resposta del personal';
$hesklang['statistics']['chart_title_tfrc']='Tiquets contestats dins un marc de temps';
$hesklang['statistics']['chart_title_ttr']='Temps que transcorre entre la sol·licitud i la resolució d\'un tiquet';
$hesklang['statistics']['chart_title_ttrc']='Tiquets resolts dins un marc de temps';
$hesklang['statistics']['chart_title_sr']='Respostes del personal';
$hesklang['statistics']['chart_title_srt']='Respostes del personal per tiquet';
$hesklang['statistics']['chart_title_srtr']='Respostes del personal per tiquet (només tiquets resolts)';
$hesklang['statistics']['chart_title_srt1']='Respostes del personal per tiquet (tiquets amb almenys 1 resposta)';
$hesklang['statistics']['ct_30']='30 minuts';
$hesklang['statistics']['ct_1h']='1 hora';
$hesklang['statistics']['ct_2h']='2 hores';
$hesklang['statistics']['ct_4h']='4 hores';
$hesklang['statistics']['ct_1d']='1 dia';
$hesklang['statistics']['ct_2d']='2 dies';
$hesklang['statistics']['ct_3d']='3 dies';
$hesklang['statistics']['ct_1w']='1 setmana';
$hesklang['statistics']['ct_wp']='> 1 setmana';
$hesklang['statistics']['ct_1m']='1 mes';
$hesklang['statistics']['ct_mp']='> 1 mes';
$hesklang['statistics']['axis1']='% de tiquets contestats';
$hesklang['statistics']['axis2']='% de tiquets resolts';
$hesklang['statistics']['axis3']='% de tiquets';
$hesklang['statistics']['axis4']='Temps per a la primera resposta';
$hesklang['statistics']['axis5']='Temps per resoldre';
$hesklang['statistics']['axis6']='Nombre de respostes';
$hesklang['statistics']['axis7']='Nombre de tiquets';
$hesklang['statistics']['axis8']='Dia de la setmana';
$hesklang['statistics']['axis9']='Hora';
$hesklang['statistics']['axis10']='Dia del mes';
$hesklang['statistics']['tr_0']='Sense resposta';
$hesklang['statistics']['tr_1']='1 resposta';
$hesklang['statistics']['tr_2']='2 respostes';
$hesklang['statistics']['tr_5']='3-5 respostes';
$hesklang['statistics']['tr_10']='6-10 respostes';
$hesklang['statistics']['tr_99']='> 10 respostes';
$hesklang['statistics']['average']='Mitja';
$hesklang['statistics']['atfr']='Mitjana d\'hores i minuts per a la primera resposta del personal:';
$hesklang['statistics']['attr']='Mitjana d\'hores i minuts per resoldre un tiquet:';
$hesklang['statistics']['about']='al voltant de %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/D';
$hesklang['statistics']['trept']='Total de tiquets als quals el personal va respondre:';
$hesklang['statistics']['trnr']='Total de tiquets resolts sense resposta del personal:';
$hesklang['statistics']['tsr']='Total de respostes del personal:';
$hesklang['statistics']['tsrt']='Mitjana de respostes del personal per tiquet:';
$hesklang['statistics']['tsro']='Mitjana de respostes del personal per tiquet (tiquets amb almenys 1 resposta del personal):';
$hesklang['statistics']['tsrc']='Mitjana de respostes del personal necessàries per resoldre un tiquet:';
$hesklang['statistics']['tsrr']='Mitjana de respostes del personal necessàries per resoldre un tiquet (tiquets amb almenys 1 resposta del personal):';
$hesklang['sep_1000']='.'; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='i molt més...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Tiquet endarrerit';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESCALAT: %%SUBJECT%%';
$hesklang['escalate']['tab']='Escalar'; // Menu link
$hesklang['escalate']['page_title']='Escalar Tiquets'; // Page H2 title
$hesklang['escalate']['intro']='Aquest mòdul us ajudarà a escalar els tiquets que no són atesos a temps.';
$hesklang['escalate']['feat1']='Tiquets no assignats, contestats o resolts en termini';
$hesklang['escalate']['feat2']='tiquets que s\'acosten a la data de venciment i tiquets vençuts';
$hesklang['escalate']['feat3']='canviar automàticament la prioritat del tiquet, reassignar un tiquet, enviar una notificació per correu electrònic';
$hesklang['escalate']['feat4']='aplicar regles basades en la categoria del tiquet, propietari, estat';
$hesklang['escalate']['prefix']='Escalament:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Regles actives';
$hesklang['escalate']['new']='Nova regla d\'escalament';
$hesklang['escalate']['no_rules']='No teniu cap regla d\'escalament. Creeu-ne una fent clic al botó &quot;Nova regla d\'escalament&quot; de dalt.';
$hesklang['escalate']['title']='Títol de la regla';
$hesklang['escalate']['titlet']='Un títol descriptiu, per exemple: Reassignar els tiquets que no s\'han respost en un dia';
$hesklang['escalate']['default_title']='Regla per %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Activació de la regla';
$hesklang['escalate']['trigt']='Estableix la condició que activarà (executarà) aquesta regla.';
$hesklang['escalate']['hits']='Activacions'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condició'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Acció'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Aplica'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']=' Suprimiu aquesta regla?';
$hesklang['escalate']['edit']='Edició de la regla d\'escalada ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Un tiquet de suport és:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='no contestat pel personal';
$hesklang['escalate']['nrepc']='no contestat pel client';
$hesklang['escalate']['nass']='no assignat';
$hesklang['escalate']['nres']='sense resoldre';
$hesklang['escalate']['ndue']='s\'acosta la data de venciment';
$hesklang['escalate']['odue']='endarrerit';
$hesklang['escalate']['within']='En:';
$hesklang['escalate']['minutes']='minuts';
$hesklang['escalate']['hours']='hores';
$hesklang['escalate']['days']='dies';
$hesklang['escalate']['weeks']='setmanes';
$hesklang['escalate']['months']='mesos';
$hesklang['escalate']['years']='anys';
$hesklang['escalate']['ofs']='de ser enviat';
$hesklang['escalate']['resend']='Reenviar notificacions per correu electrònic:';
$hesklang['escalate']['force']='Enviar sempre, sense tenir en compte la configuració del personal';
$hesklang['escalate']['noforce']='Respectar la configuració de les notificacions del personal';
$hesklang['escalate']['setpri']='Establir la prioritat a:';
$hesklang['escalate']['setsta']='Posar l\'estat a:';
$hesklang['escalate']['assto']='Assignar tiquet a:';
$hesklang['escalate']['asm']='Un altre membre del personal';
$hesklang['escalate']['notify']='Notificar els membres del personal...';
$hesklang['escalate']['ato']='Aplica a:';
$hesklang['escalate']['tic']='Tiquets a la categoria:';
$hesklang['escalate']['tat']='Tiquets assignats a:';
$hesklang['escalate']['tws']='Tiquets amb estat:';
$hesklang['escalate']['tall']='Aplica aquesta regla als tiquets existents i futurs';
$hesklang['escalate']['tfn']='Aplicar aquesta regla només als futurs tiquets, ignorar els tiquets existents';
$hesklang['escalate']['tfi']='Aplica aquesta regla només a tiquets amb ID més gran a:';
$hesklang['escalate']['save']='Desa regla';
$hesklang['escalate']['e_tt']='El temps ha d\'estar entre 1 i 10000';
$hesklang['escalate']['e_a']='Seleccioneu almenys una acció per realitzar als tiquets coincidents';
$hesklang['escalate']['nocat']='Seleccioneu almenys una categoria';
$hesklang['escalate']['nouser']='Seleccioneu almenys un usuari';
$hesklang['escalate']['nostatus']='Seleccioneu almenys un estat';
$hesklang['escalate']['nocata']='%1$s no té accés a aquestes categories:'; // %1$s = user name
$hesklang['escalate']['rule_added']='S\'ha creat una norma nova';
$hesklang['escalate']['mdf']='S\'han desat els paràmetres de les regles';
$hesklang['escalate']['e_id']='No s\'ha trobat cap regla amb aquest ID';
$hesklang['escalate']['deleted']='La regla seleccionada ha estat eliminada';
$hesklang['escalate']['edit_notice']='El canvi de l\'activador de la regla no tindrà efecte en cap tiquet ja escalat per aquesta regla (llevat que es restableixi la regla).';
$hesklang['escalate']['reset']='Restablir aquesta regla';
$hesklang['escalate']['reset2']='Esteu segur que voleu restablir aquesta regla? <br><br>Les activacions de la regla passaran a ser 0 i qualsevol tiquet que coincideixi amb aquesta regla serà escalat de nou.';
$hesklang['escalate']['reset3']='La regla seleccionada ha estat anul·lada';
$hesklang['escalate']['log_title']='Regla #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | escalat per %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - establir prioritat a %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - assignar a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - enviar notificació al personal</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - enviar notificació al personal (forçat)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - error: %2$s no té accés a la categoria del tiquet</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - error: %2$s no té permís per veure les entrades</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - error: no hi ha cap altre usuari que pugui veure aquest tiquet</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - avís: la prioritat ja està fixada en %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - avís: ja està assignat a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notificar: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - establir l\'estat a %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - avís: l\'estat ja està establert a %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Activa'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Activar aquesta regla (començar a utilitzar-la)';
$hesklang['escalate']['activated']='La regla seleccionada ha estat activada'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Desactivar aquesta regla (deixar de fer-la servir)';
$hesklang['escalate']['deactivated']='La regla seleccionada ha estat desactivada'; // %1$s = rule log title
$hesklang['escalate']['no_active']='No hi ha regles d\'escalament actives';
$hesklang['escalate']['matched']='Nombre de tiquets coincidents trobats: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Eines';
$hesklang['escalate']['test']='Simular aquesta regla';
$hesklang['escalate']['testa']='Simular totes les regles';
$hesklang['escalate']['testaa']='Simular totes les regles actives';
$hesklang['escalate']['testr']='Resultats de la simulació';
$hesklang['escalate']['rsim']='Repeteix simulació';
$hesklang['escalate']['tbef']='Abans que una regla estigui activa, haureu d\'activar-la fent clic a la casella de verificació de la columna &quot;ACTIVAR&quot;.<br><br>\n                              Recomanem encaridament que <strong>simules</strong> cada regla fent clic a la icona %1$s (Simular aquesta regla) a la taula de regles\n                                     per veure com afectarà els vostres tiquets existents abans d\'activar-la.<br><br>\n                                      Les regles actives es processen cada %2$s minuts Un tiquet només pot ser escalat una vegada per cada regla</strong> .'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='MODE SIMULACIÓ, sense canvis a la base de dades';
$hesklang['escalate']['sic']='SIMULACIÓ COMPLETA';
$hesklang['escalate']['r']='[REGLA]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Consell: mantenir premuda la tecla CTRL per seleccionar diverses opcions';
$hesklang['desc_ticket_escalated']='(Personal) El tiquet ha estat escalat'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Format dels tiquets (Personal)';
$hesklang['ticket_formatting_plaintext']='Text pla';
$hesklang['ticket_formatting_rich_text']='Text enriquit (HTML)';
$hesklang['due_date']='Data de venciment';
$hesklang['invalid_due_date']='S\'ha introduït una data de venciment no vàlida.';
$hesklang['thist19']='<li class="smaller">%s | data de venciment actualitzada a %s per %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | data de venciment eliminada per %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='S\'ha actualitzat la data de venciment del tiquet.';
$hesklang['menu_kb_manage']='Gestionar'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Veure'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Seleccionar tot';
$hesklang['a_deselect']='Deseleccionar tot';
$hesklang['a_toggle']='Alternar tot';
$hesklang['ql_all']='Tots els tiquets';
$hesklang['ql_alo']='Tots els tiquets oberts';
$hesklang['ql_fit']='Tiquets filtrats';
$hesklang['ql_a2m']='Assignats a mi';
$hesklang['ql_a2o']='Assignats a altres';
$hesklang['ql_una']='Sense assignar';
$hesklang['ql_due']='Propers a vèncer';
$hesklang['ql_ovr']='Endarrerits';
$hesklang['set_ds']='Mostra com &quot;Pròxim a vèncer&quot'; // Settings page (title of setting)
$hesklang['set_ds2']='dies abans de la data límit';
$hesklang['not_aos']='Alguns tiquets oberts als quals hi ha accés no es mostren a causa dels seus filtres.';
$hesklang['ntoverdue']='Un tiquet està endarrerit amb l\'assumpte:';
$hesklang['ovdcron']='perquè les notificacions de venciment funcionin, el vostre administrador ha d\'habilitar un treball cron.';
$hesklang['instructions']='Instruccions';
$hesklang['desc_overdue_ticket']='(Personal) Tiquet endarrerit';
$hesklang['overdue_starting']='Inici del procés de notificació de tiquets endarrerits';
$hesklang['overdue_sim']='L\'enviament de correus electrònics i l\'actualització de tiquets estan desactivats en el mode SIMULACIÓ.';
$hesklang['overdue_ticket_count']='S\'han trobat %s tiquets endarrerits.'; // %s = Number of tickets
$hesklang['overdue_finished']='Tiquets endarrerits acabats. %s emails enviats.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Carregar un fitxer d\'estil personalitzat addicional per al panell d\'administració';
$hesklang['noval_cert']='No validar els certificats del servidor';
$hesklang['chg_cat']='Click per canviar la categoria del tiquet';
$hesklang['tlan']='Idioma del tiquet';
$hesklang['uue']='Dos o més membres del personal tenen la mateixa adreça electrònica. Es recomana establir una adreça electrònica única per a cada usuari.';
$hesklang['flood']='Límit de desbordament (flood)';
$hesklang['e_flood']='Ooops, ja heu enviat una resposta fa poc. Hem aturat aquesta sol·licitud per evitar la inundació de respostes.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='Clau d\'accés URL'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Generar una clau d\'accés URL aleatòria';
$hesklang['ukeym']='Error: per executar aquest fitxer a través d\'HTTP heu d\'incloure la vostra clau d\'accés a la URL a la sol·licitud. Exemple:';
$hesklang['ukeyw']='Error: clau d\'accés a la URL incorrecta';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Tiquet rebut: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% és el vostre codi de verificació';
$hesklang['follow_up_email']='Honestament - com ho hem fet?';
$hesklang['mfa']='Autenticació multifactor (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Habilitat?';
$hesklang['mfa_required']='Requerir autenticació multifactor';
$hesklang['mfa_manage_profile']='Administrar MFA';
$hesklang['mfa_disabled']='Autenticació multifactor deshabilitada';
$hesklang['mfa_enabled']='Autenticació multifactor habilitada (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Cap';
$hesklang['mfa_method_none_subtext']='Eliminar l\'autenticació multifactor al vostre compte.';
$hesklang['mfa_method_email']='Correu electrònic';
$hesklang['mfa_method_email_subtext']='El servei d\'assistència enviarà un correu electrònic amb un codi d\'inici de sessió aleatori a <strong>%s</strong> en iniciar la sessió.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Aplicació d\'autenticació';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Utilitzeu una aplicació per a telèfons intel·ligents, com Authy o Google Authenticator, per generar un codi d\'accés aleatori en iniciar la sessió.';
$hesklang['mfa_step_method']='Mètode';
$hesklang['mfa_step_verification']='Verificació';
$hesklang['mfa_step_complete']='Completat';
$hesklang['mfa_introduction']='L\'autenticació multifactor millora la seguretat del compte en exigir verificar l\'inici de sessió mitjançant un mètode de verificació addicional, com el correu electrònic o una aplicació d\'autenticació (com Authy o Google Authenticator).';
$hesklang['mfa_reset_warning']='Ja teniu activada l\'autenticació multifactor. En completar-ho de nou, es restablirà el dispositiu d\'autenticació multifactor (si està habilitat).';
$hesklang['mfa_select_method_colon']='Seleccioneu un mètode d\'autenticació:';
$hesklang['mfa_verification_header']='Verificació - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='S\'ha enviat un correu electrònic a <strong>%s</strong> amb un codi de verificació de sis dígits. Introduïu el codi que heu rebut per correu electrònic a continuació per continuar.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Pas 1: Escanegeu la imatge següent amb l\'aplicació d\'autenticació multifactor al dispositiu mòbil.';
$hesklang['mfa_verification_auth_app_cant_scan']='No podeu escanejar la imatge? Introduïu manualment aquest codi al dispositiu: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Pas 2: Introduïu el codi de 6 dígits que apareix a la vostra aplicació per verificar el dispositiu.';
$hesklang['mfa_verify']='Verifiqueu';
$hesklang['mfa_invalid_method']='S\'ha rebut un mètode d\'autenticació multifactor no vàlid.';
$hesklang['mfa_invalid_verification_code']='El codi introduït és incorrecte o ha caducat.';
$hesklang['mfa_configured']='S\'ha activat l\'autenticació multifactor per al vostre compte!';
$hesklang['mfa_removed']='S\'ha desactivat l\'autenticació multifactor per al vostre compte!';
$hesklang['mfa_verification_needed']='L\'autenticació multifactor està activada per a aquest compte.';
$hesklang['mfa_verification_needed_email']='Si us plau, introduïu el codi de verificació que se us ha enviat a la vostra adreça de correu electrònic.';
$hesklang['mfa_verification_needed_auth_app']='Introduïu el codi que apareix a la vostra aplicació d\'autenticació.';
$hesklang['mfa_verification_code']='Codi de verificació';
$hesklang['mfa_server_time_issue']='L\'hora del vostre servidor sembla ser inexacta: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Restablir l\'autenticació multifactor';
$hesklang['mfa_reset_confirm']='Segur que voleu restablir la MFA per a aquest usuari?';
$hesklang['mfa_reset_yes']='Restablir';
$hesklang['mfa_reset']='L\'autenticació multifactor s\'ha restablert per a l\'usuari';
$hesklang['desc_mfa_verification']='(Personal) Codi d\'autenticació multifactor';
$hesklang['mfa_code']='Codi:';
$hesklang['mfa_backup_codes_header']='GUARDEU ELS SEUS CODIS DE SEGURETAT!';
$hesklang['mfa_backup_codes_description']='Deseu aquests codis de seguretat en un lloc segur però accessible. En cas que perdeu l\'accés al dispositiu MFA o al vostre correu electrònic, podeu introduir un dels següents codis de reserva per iniciar la sessió.<br><br><strong>Assegureu-vos de tractar aquests codis de seguretat com a contrasenyes. No podreu tornar a veure aquests codis!</strong>';
$hesklang['mfa_verify_another_way']='Verifiqueu el vostre compte d\'una altra manera'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Obtingueu un codi de verificació a %s';
$hesklang['mfa_verify_another_way_code']='Introduïu un dels vostres codis de seguretat de 8 caràcters';
$hesklang['mfa_verify_another_way_admin']='Poseu en contacte amb l\'administrador del servei d\'assistència per obtenir ajuda';
$hesklang['mfa_verify_another_way_reset']='Restablir l\'autenticació multifactor carregant un fitxer al servidor';
$hesklang['mfa_send_another_email']='Enviar un altre correu electrònic';
$hesklang['mfa_sent']='S\'ha enviat un correu electrònic amb un nou codi de verificació a la vostra adreça de correu electrònic';
$hesklang['mfa_backup_code']='Codi de Respatller';
$hesklang['mfa_backup_codes']='Codis de Respatller';
$hesklang['mfa_backup_codes_info']='Codis d\'un sol ús per passar la verificació multifactor quan no pugueu accedir al vostre correu electrònic o a l\'aplicació d\'autenticació. Quan utilitzeu un codi de seguretat per iniciar sessió, aquest codi queda inactiu.';
$hesklang['mfa_backup_codes_num']='Podeu obtenir un nou conjunt de 10 codis de reserva quan vulgueu. Quan creeu un nou joc de codis, l\'antic queda automàticament inactiu.';
$hesklang['mfa_backup_codes_num2']='Nombre dels vostres codis actius: %s';
$hesklang['mfa_invalid_backup_code']='El codi de seguretat introduït és incorrecte o ja ha estat utilitzat.';
$hesklang['mfa_del_codes']='Esborrar els meus codis de seguretat';
$hesklang['mfa_del_codes2']='S\'han esborrat tots els codis de còpia de seguretat.';
$hesklang['mfa_new_codes']='Generació de codis de reserva nous';
$hesklang['mfa_new_codes2']='S\'han generat nous codis de còpia de seguretat';
$hesklang['old_php_version']='Error: Versió de PHP no suportada';
$hesklang['category_default_due_date']='Data de venciment per defecte';
$hesklang['category_change_default_due_date']='Establir Data de venciment per defecte';
$hesklang['category_leave_blank_for_no_default_due_date']='(deixar en blanc per no establir data de venciment per defecte)';
$hesklang['category_default_due_date_updated']='S\'ha actualitzat la data de venciment per defecte.';
$hesklang['email_formatting']='Format de correu electrònic';
$hesklang['email_formatting_html_and_plaintext']='HTML amb alternativa de text pla des de la plantilla de text pla (per defecte)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML amb text pla alternatiu generat a partir d\'una plantilla HTML';
$hesklang['email_formatting_html']='Només HTML';
$hesklang['email_formatting_plaintext']='Només text pla';
$hesklang['email_formatting_note']='La vostra selecció a %1$s &gt; %2$s &gt; %3$s s\'estableix a: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Això significa que Hesk ignorarà les plantilles HTML aquí.';
$hesklang['email_formatting_note1']='Això significa que Hesk ignorarà les plantilles de text pla aquí.';
$hesklang['email_formatting_note2']='Això significa que Hesk generarà la versió de text pla dels correus electrònics a partir de les plantilles HTML i ignorarà les plantilles de text pla aquí.';
$hesklang['etnu']='Aquesta plantilla de correu electrònic no és utilitzada actualment per Hesk segons la seva selecció a %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Editar Categoria';
$hesklang['create_category']='Crear Categoria';
$hesklang['one_user_included']='1 usuari inclòs';
$hesklang['one_user_excluded']='1 usuari exclòs';
$hesklang['x_users_included']='%s usuaris inclosos'; // %s = Number of users
$hesklang['x_users_excluded']='%s usuaris exclosos'; // %s = Number of users
$hesklang['aa_cat']='Assignació automàtica de tiquets en aquesta categoria';
$hesklang['modify_autoassign_settings']='Modificar la configuració de l\'autoassignació';
$hesklang['autoassign_on_all_users']='Sí, a qualsevol usuari amb accés a aquesta categoria';
$hesklang['autoassign_on_select_users']='Sí, a usuaris específics';
$hesklang['autoassign_off']='No, envieu les entrades com a no assignades';
$hesklang['autoassign_users']='Usuaris a incloure/excloure a l\'autoassignació';
$hesklang['autoassign_selected_include']='Els usuaris seleccionats han de ser <strong>inclosos</strong> en autoassignar tiquets en aquesta categoria';
$hesklang['autoassign_selected_exclude']='Els usuaris seleccionats han de ser <strong>exclosos</strong> en autoassignar tiquets en aquesta categoria';
$hesklang['cat_edited']='La categoria %s ha estat editada amb èxit';
$hesklang['search_for_user']='Cerca usuari';
$hesklang['email_sending']='Enviament de correus electrònics';
$hesklang['email_to_ticket']='Correu electrònic a Ticket';
$hesklang['email_to_ticket_info']='La conversió dels correus electrònics en tiquets requereix una configuració del costat del servidor. Per a més detalls, consulteu <a href="%s" target="_blank">aquesta guia de la base de coneixements</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk utilitza un servidor SMTP per enviar notificacions per correu electrònic. El vostre <strong>%1$s</strong> s\'ha d\'establir a <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Falta l\'extensió del fitxer';
$hesklang['block_ignore']='Correu electrònic a tiquet - Ignora els correus electrònics i evita els bucles';
$hesklang['block_noreply']='No respondre';
$hesklang['block_noreply2']='Ignora els correus electrònics enviats des d\'adreces de correu electrònic "no respondre".';
$hesklang['block_returned']='Tornat';
$hesklang['block_returned2']='Ignora els correus electrònics retornats, com ara les notificacions d\'estat de lliurament i les respostes automàtiques';
$hesklang['block_duplicate']='Duplicats';
$hesklang['block_duplicate2']='Ignorar els correus electrònics amb el mateix missatge enviats en un termini de &quot;%s&quot; segons'; // %s = "Timeframe"
$hesklang['loop_info']='Correus electrònics rebuts des de la mateixa adreça de correu electrònic a &quot;%s&quot; segons';
$hesklang['thist21']='<li class="smaller">%s | Enviament d\'una notificació per correu electrònic sobre el retard</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | correu electrònic de seguiment enviat</li>'; // %s = date
$hesklang['elevator_header']='Entrar a la Zona Segura';
$hesklang['elevator_intro']='Esteu a punt d\'entrar en una Zona Segura.';
$hesklang['elevator_enter_password']='Si us plau, introduïu la vostra contrasenya per continuar.';
$hesklang['elevator_duration_setting_title']='Durada de l\'àrea segura';
$hesklang['desc_survey']='(Client) Correu electrònic de seguiment (enquesta)'; // Email description
$hesklang['satisfaction']['tab']='Satisfacció';
$hesklang['satisfaction']['title']='Enquesta de satisfacció del client';
$hesklang['satisfaction']['intro']='Envieu als vostres clients una enquesta de satisfacció de seguiment per recollir les vostres opinions sobre l\'experiència amb el vostre servei d\'assistència tècnica.';
$hesklang['satisfaction']['tab1']='Ajustaments';
$hesklang['satisfaction']['tab2']='Exclusió';
$hesklang['satisfaction']['enable']='Habilitar els correus electrònics de seguiment:';
$hesklang['satisfaction']['enabled']='Habilitades les enquestes de satisfacció del client.';
$hesklang['satisfaction']['disabled']='Deshabilitades les enquestes de satisfacció del client.';
$hesklang['satisfaction']['url']='Adreça URL de l\'enquesta:';
$hesklang['satisfaction']['send']='Retard del correu electrònic de seguiment:';
$hesklang['satisfaction']['at_least']='Espera almenys';
$hesklang['satisfaction']['after']='després que el tiquet es resolgui abans d\'enviar el correu electrònic';
$hesklang['satisfaction']['h1']='Com utilitzar aquesta eina?';
$hesklang['satisfaction']['h2']='En primer lloc, creeu una enquesta de satisfacció del client a la vostra eina d\'enquestes preferida. Si no sabeu quina eina utilitzar o quines preguntes fer, tenim una <a href="%s" target="_blank">guia disponible aquí</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Quan la vostra enquesta estigui a punt, habiliteu els correus electrònics de seguiment utilitzant el formulari de sota. Hesk processarà els tiquets resolts amb almenys una resposta del personal una vegada per hora i enviarà l\'enllaç de la seva enquesta als clients.';
$hesklang['satisfaction']['e_url']='Introduïu una adreça URL vàlida per a l\'enquesta. Aquesta és la URL a la qual seran enviats els vostres clients.';
$hesklang['satisfaction']['as']='Introduïu una adreça URL vàlida per a l\'enquesta. Aquesta és la URL a la qual seran enviats els vostres clients.';
$hesklang['satisfaction']['oo1']='Aquesta pàgina enumera les adreces de correu electrònic a les quals no s\'enviaran correus electrònics de seguiment.';
$hesklang['satisfaction']['oo2']='Els seus clients poden optar per no rebre correus electrònics d\'enquestes fent clic en un enllaç al correu electrònic. També podeu afegir manualment les adreces de correu electrònic a aquesta pàgina.';
$hesklang['satisfaction']['ooe']='Adreça de correu electrònic per excloure\'s';
$hesklang['satisfaction']['ooe2']='Introduïu l\'adreça de correu electrònic que voleu excloure de la recepció de correus electrònics de l\'enquesta.';
$hesklang['satisfaction']['ooe3']='Aquesta adreça de correu electrònic <i>%s</i> ja ha optat per no rebre correus electrònics d\'enquestes.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Optar per excloure aquest correu electrònic';
$hesklang['satisfaction']['oob']='Exclòs per';
$hesklang['satisfaction']['no_oo']='Cap client ha optat per no rebre correus electrònics d\'enquestes.';
$hesklang['satisfaction']['oor']='Elimina';
$hesklang['satisfaction']['oor2']='Correu electrònic suprimit de la llista d\'exclusió';
$hesklang['satisfaction']['oor3']='Confirmar l\'eliminació';
$hesklang['satisfaction']['oor4']='Quan s\'elimini l\'opció d\'exclusió, aquest usuari tornarà a rebre correus electrònics de seguiment.';
$hesklang['satisfaction']['optedout']='L\'adreça de correu electrònic <i>%s</i> ha estat exclosa de la recepció de correus electrònics de l\'enquesta.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Identificació de l\'enquesta inexistent o no vàlida';
$hesklang['satisfaction']['starting']='Inici del procés de notificació de l\'enquesta de satisfacció del client';
$hesklang['satisfaction']['tc']='S\'han trobat %s de tiquets tancats als quals no s\'ha enviat l\'enquesta de satisfacció.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Enquesta de satisfacció del client finalitzada. Correus electrònics enviats: %1$s. Correus electrònics no enviats: %2$s. Entrades sense correu electrònic: %3$s. Entrades amb correu electrònic d\'exclusió: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignorant, aquest client no desitja rebre correus electrònics d\'enquestes.';
$hesklang['satisfaction']['ne']='Ignorant, aquest tiquet està sense adreça de correu electrònic';
$hesklang['satisfaction']['feat1']='Creeu la vostra enquesta utilitzant qualsevol eina de tercers, com Google Forms';
$hesklang['satisfaction']['feat2']='configurar l\'URL de l\'enquesta, les preferències i les limitacions dins d\'aquest mòdul';
$hesklang['satisfaction']['feat3']='quan es resolgui un tiquet, Hesk enviarà per correu electrònic al vostre client l\'enllaç a l\'enquesta';
$hesklang['dfor']='Format de data';
$hesklang['dtfor']='Data i Hora';
$hesklang['cdfor']='Format de selecció de data';
$hesklang['custom']='Personalitzat';
$hesklang['jsc_notice']='La selecció de la data no admet el format de data a l\'estil PHP. Seleccioneu una de les opcions preconfigurades o feu clic a la icona %s de sota per veure les opcions de visualització disponibles.'; // %s = replaced by icon
$hesklang['lcf3']='Només data'; // Display: "Date only"
$hesklang['epdd']='Error en analitzar el paràmetre \'data de venciment\':';
$hesklang['edit_pass']='Edita la contrasenya';
$hesklang['save_pass']='Desa la contrasenya';
$hesklang['cur_pass']='Contrasenya actual';
$hesklang['cur_pass2']='Heu de proporcionar la contrasenya actual per canviar-la.';
$hesklang['cur_pass3']='Després d\'actualitzar la contrasenya amb èxit, se us redirigirà a la pàgina d\'inici de sessió, on podreu connectar-vos amb la nova contrasenya.';
$hesklang['e_new_pass']='Si us plau, introduïu la vostra nova contrasenya';
$hesklang['pass_len']='La contrasenya no ha de superar els 64 caràcters';
$hesklang['pass_login']='Torna a connectar-se després de canviar la contrasenya';
$hesklang['bf_int']='S\'ha tancat la sessió a causa de massa intents de verificació fallits';
$hesklang['tst_cnt']='Nombre de correus electrònics que el vostre servidor de correu enviarà a Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='Té molts correus electrònics sense llegir a la vostra bústia (%1$s). Hesk convertirà tots aquests correus electrònics en tiquets.<br><br>És possible que vulgueu marcar els correus electrònics existents com a llegits abans d\'habilitar %2$s o utilitzar un nou compte de correu electrònic per a Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Té molts correus electrònics a la vostra bústia (%1$s). Hesk convertirà tots aquests correus electrònics en tiquets.<br><br>És possible que vulgueu eliminar els correus electrònics existents abans d\'habilitar %2$s o utilitzar un nou compte de correu electrònic per a Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Amb data de venciment'; // Due on (date)
$hesklang['search_due_date_range']='Amb venciment a'; // Due in (X days)
$hesklang['attachment_add_files']='Afegeix fitxer';
$hesklang['attachment_max_exceeded']='Aquest fitxer no es carregarà perquè ja ha carregat el nombre màxim de fitxers permès.';
$hesklang['attachment_viewer_message']='Arrossegueu els fitxers aquí o feu clic al botó \'Afegeix fitxer\' per seleccionar els fitxers que voleu carregar.';
$hesklang['attachment_invalid_type_message']='Ho sentim, però el tipus de fitxer que heu intentat carregar no està permès.';
$hesklang['attachment_upload_error']='S\'ha produït un error en intentar carregar. Si us plau, torneu-ho a provar més tard.';
$hesklang['attachment_too_large']='Aquest fitxer adjunt supera la mida màxima permesa.';
$hesklang['attachment_cancel']='Cancel·lar';
$hesklang['attachment_confirm_cancel']='Esteu segur que voleu cancel·lar aquesta càrrega?';
$hesklang['attachment_remove']='Treu l\'adjunt';
$hesklang['attachment_too_many_uploads']='S\'han carregat massa fitxers adjunts des de la vostra ubicació en un curt període de temps. Si us plau, torneu a provar la vostra sol·licitud.';
$hesklang['sub_note']='Envia nota';
$hesklang['can_view_users']='Veure tots els usuaris (però no gestionar-los)';
$hesklang['welcome1']='Hola, sembla que és nou per aquí. Benvingut!';
$hesklang['welcome2']='Per ajudar-vos a començar, consulteu el %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Guia d\'inici ràpid de Hesk online';
$hesklang['tmce1']='Utilitzeu Ctrl+Click dret per accedir al corrector ortogràfic';
$hesklang['tmce2']='Manteniu premuda la tecla Control (Ctrl) i feu clic amb el botó dret a la paraula mal escrita per accedir al corrector ortogràfic.';
$hesklang['desc_new_ticket_by_staff']='(Client) Nou tiquet enviat pel personal';
$hesklang['mod_et_h']='Podeu modificar les plantilles de correu electrònic a %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Establiu l\'idioma en';
$hesklang['ouwa']='Només els usuaris amb accés a aquesta categoria estan llistats a sota. Per afegir membres del personal a aquesta categoria, editeu els vostres permisos a la pàgina %s'; // %s = Team
$hesklang['previous_tickets']='Tiquets anteriors';
$hesklang['no_previous']='No hi ha tiquets anteriors per %s'; // %s = email address
$hesklang['all_previous']='Llista de tots els tiquets anteriors';
$hesklang['confirm_delete_ticket']='Esteu segur que voleu eliminar permanentment aquest tiquet?';
$hesklang['confirm_delete_reply']='Esteu segur que voleu esborrar permanentment aquesta resposta?';
$hesklang['select_new_category']='Nombre de tiquets en aquesta categoria: %s<br><br>Si us plau, seleccioneu una nova categoria a la qual transferir aquests tiquets:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Nombre de tiquets assignats a aquest usuari: %1$s<br>Nombre de <b>open</b> tiquets assignats a aquest usuari: %2$s<br><br> Tiquets <b>oberts</b> seran <b>desassignats</b> després d\'eliminar aquest usuari.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Llicència HESK';
$hesklang['hlic_free']='GRATIS';
$hesklang['hlic_buyl']='Comprar una llicència';
$hesklang['hlic_paid']='Amb llicència';
$hesklang['antdemo']='L\'enviament de tiquets des del panell d\'administració s\'ha desactivat en el mode de demostració.<br><br>Si us plau, utilitzeu el <a href="%s" target="_blank ">costat públic</a> per enviar un tiquet de prova.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Mètode d\'autenticació';
$hesklang['email_authentication_method_username_password']='Bàsic (Usuari / Contrasenya)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - No hi ha cap proveïdor verificat de OAuth configurat.';
$hesklang['email_authentication_method_oauth_link']='Gestionar proveïdors OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL de punt de connexió d\'autorització';
$hesklang['email_oauth_token_url']='URL de punt de connexió de token';
$hesklang['email_oauth_client_id']='ID Client';
$hesklang['email_oauth_client_secret']='Secret Client';
$hesklang['email_oauth_scope']='Abast';
$hesklang['oauth_error_invalid_state']='L\'estat de OAuth no coincideix amb l\'estat enviat al proveïdor de OAuth.';
$hesklang['oauth_error_unknown']='S\'ha produït un error desconegut en intentar desar tokens de OAuth.';
$hesklang['oauth_error_no_token']='Falta el token d\'accés a la resposta JSON.';
$hesklang['oauth_error_retrieve']='No es pot recuperar un token d\'accés. Confirmeu la configuració del vostre proveïdor de OAuth i torneu a desar-la per adquirir un nou token.';
$hesklang['email_oauth_provider']='Proveïdor OAuth';
$hesklang['email_oauth_providers']='Proveïdors OAuth';
$hesklang['email_oauth_provider_guide']='Abans d\'utilitzar OAuth, heu de registrar un proveïdor d\'OAuth. Per obtenir més informació, vegeu <a href="%s" target="_blank">aquesta guia de la base de coneixements</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='El vostre URI de redirecció de OAuth per a Hesk és:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Utilitzeu aquesta eina per afegir proveïdors d\'OAuth al vostre suport d\'escriptori';
$hesklang['email_oauth_provider_name']='Nom'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Nou proveïdor';
$hesklang['email_oauth_edit_provider']='Editar proveïdor';
$hesklang['email_oauth_provider_being_used_for']='Sent utilitzat per';
$hesklang['email_oauth_providers_none']='No s\'han desat proveïdors d\'OAuth. Podeu afegir-los fent clic a "Nou proveïdor" a dalt.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Aquest proveïdor no es pot suprimir perquè l\'està utilitzant el suport d\'escriptori.';
$hesklang['email_oauth_confirm_delete_provider']='Esteu segur que voleu suprimir aquest proveïdor de OAuth?';
$hesklang['oauth_provider_saved']='El proveïdor d\'OAuth s\'ha desat';
$hesklang['oauth_provider_use']='Ara podeu seleccionar aquest proveïdor a %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Introduïu el nom del proveïdor';
$hesklang['oauth_provider_err_auth_url']='Introduïu un URL d\'autorització vàlida';
$hesklang['oauth_provider_err_token_url']='Introduïu una URL de token vàlida';
$hesklang['oauth_provider_err_client_id']='Introduïu la identificació del client';
$hesklang['oauth_provider_err_client_secret']='Introduïu el secret del client';
$hesklang['oauth_provider_err_scope']='Introduïu l\'abast';
$hesklang['oauth_provider_deleted']='Proveïdor d\'OAuth eliminat';
$hesklang['oauth_provider_not_found']='Aquest proveïdor d\'OAuth no existeix';
$hesklang['oauth_provider_verified']='Verificat';
$hesklang['oauth_provider_click_to_verify']='Feu clic per verificar';
$hesklang['can_due_date']='Podeu establir la data de venciment'; // Permission to set and modify due date
$hesklang['can_due_date_e']='No teniu permís per establir dates de venciment';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verifiqueu el vostre registre';
$hesklang['customer_verify_new_email']='Verifiqueu la vostra nova adreça de correu electrònic';
$hesklang['customer_reset_password']='Restabliu la contrasenya de suport tècnic';
$hesklang['customer_approved']='Compte aprovat';
$hesklang['customer_rejected']='Compte rebutjat';
$hesklang['email_rejected']='Compte necessari per enviar tiquets de suport';
$hesklang['require_curl']='Aquesta funcionalitat requereix compatibilitat amb <strong>cURL</strong> per a PHP habilitada al vostre servidor. Demaneu al vostre proveïdor d\'allotjament web que habiliti cURL per a PHP.';
$hesklang['customer_accounts_heading']='Comptes de clients';
$hesklang['customer_accounts']='Comptes de clients';
$hesklang['customer_accounts_off']='<strong>Deshabilitat</strong>';
$hesklang['customer_accounts_allowed']='<strong>Habilitat: opcional</strong> (els clients poden enviar tiquets de suport sense registrar-se ni iniciar sessió)';
$hesklang['customer_accounts_required_to_submit']='<strong>Habilitat: obligatori per als tiquets</strong> (només els clients que hagin iniciat sessió poden enviar tiquets de suport)';
$hesklang['customer_accounts_required']='<strong>Habilitat: obligatori per accedir</strong> (només els clients que hagin iniciat sessió poden accedir al servei d\'assistència ia la base de coneixements)';
$hesklang['customer_accounts_reg']='Registre de compte';
$hesklang['customer_accounts_reg_customer']='Els clients poden registrar comptes';
$hesklang['customer_accounts_reg_approve']='Els clients poden registrar comptes, el personal ha d\'aprovar els registres nous';
$hesklang['customer_accounts_reg_staff']='Només el personal pot registrar comptes de clients';
$hesklang['customer_accounts_allow_email_changes']='Permetre que els clients canviïn la vostra adreça de correu electrònic';
$hesklang['customer_accounts_allow_email_resends']='Temps fins que els clients puguin sol·licitar un nou correu electrònic de verificació';
$hesklang['customer_login']='Iniciar sessió';
$hesklang['customer_logout']='Tancar sessió';
$hesklang['customer_register']='Registrar-se';
$hesklang['customer_accounts_disabled']='Els inicis de sessió i registres de clients estan deshabilitats.';
$hesklang['customer_accounts_registration_disabled']='Els registres de clients estan deshabilitats.';
$hesklang['customer_forgot_password']='Heu oblidat la vostra contrasenya?';
$hesklang['customer_email']='Adreça de correu electrònic';
$hesklang['customer_accounts_email_banned']='Se us ha prohibit utilitzar aquest servei d\'assistència.';
$hesklang['customer_registration_successful']='Registre exitós!';
$hesklang['customer_registration_email_exists_no_reset_link']='Ja existeix un compte amb el correu electrònic %s.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Ja existeix un compte amb el correu electrònic %s. <a href="login.php">Voleu iniciar sessió al vostre lloc</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Ja existeix un compte amb el correu electrònic %s i està pendent de verificació de correu electrònic.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Ja hi ha un compte amb el correu electrònic %s i està pendent d\'aprovació del personal.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Reviseu el vostre correu electrònic!';
$hesklang['customer_registration_check_your_email_content']='Ha de verificar la seva adreça de correu electrònic abans de poder iniciar sessió.<br><br>Si no el rep en uns minuts, reviseu les vostres carpetes de correu no desitjat, escombraries o correu brossa. Marqueu el missatge com a <b>No SPAM</b> per evitar problemes en rebre la nostra correspondència en el futur.';
$hesklang['customer_login_not_verified']='Heu de verificar la vostra adreça de correu electrònic abans de poder iniciar sessió.';
$hesklang['customer_login_not_verified2']='Si no heu rebut el nostre correu electrònic de verificació, reviseu les vostres carpetes de correu brossa, escombraries o correu brossa. Marqueu el missatge com a <b>No SPAM</b> per evitar problemes en rebre la nostra correspondència en el futur.';
$hesklang['customer_login_resend_verification_email']='Reenviar correu electrònic de verificació';
$hesklang['customer_login_resend_verification_email_none']='No hi ha verificacions de correu electrònic pendents per enviar.';
$hesklang['customer_login_resend_verification_email_too_early']='No podeu sol·licitar un nou correu electrònic de verificació en aquest moment, torneu-ho a provar més tard.';
$hesklang['customer_login_not_approved']='Un membre del personal ha d\'aprovar el vostre compte abans de poder iniciar sessió. Un cop aprovada, se us notificarà per correu electrònic.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verificar registre';
$hesklang['customer_registration_verify_success']='El vostre correu electrònic ha estat verificat i ara podeu iniciar sessió utilitzant el formulari a continuació.';
$hesklang['customer_registration_verify_approval_needed']='El vostre correu electrònic ha estat verificat. No obstant això, un membre del personal ha d\'aprovar el vostre compte abans de poder iniciar sessió. Un cop aprovada, se us notificarà per correu electrònic.';
$hesklang['customer_registration_verify_failure']='No s\'ha pogut verificar el vostre correu electrònic. L\'enllaç ja s\'ha utilitzat o expirat.';
$hesklang['emails_to_customers']='&raquo; Correus electrònics enviats a clients';
$hesklang['emails_to_staff']='&raquo; Correus electrònics enviats al personal';
$hesklang['emails_to_everyone']='&raquo; Correus electrònics enviats al personal o als clients';
$hesklang['new_customer_approval']='Té comptes de clients pendents d\'aprovació'; // Email subject
$hesklang['desc_new_customer_approval']='(Personal) Comptes de clients pendents d\'aprovació';
$hesklang['n_cust_app']='Hi ha aprovacions de clients pendents'; // Notify me when...
$hesklang['et_num_customers']='Nombre d\'aprovacions pendents';
$hesklang['et_link_customers']='Enllaç a la pàgina Administrar clients';
$hesklang['et_link_verify']='Enllaç de verificació';
$hesklang['et_cust_login']='URL d\'inici de sessió del client';
$hesklang['submit_ticket_customer_email_exists']='Ja existeix un client amb aquest correu electrònic. Si us plau, <a href="login.php?email=%s">inicieu sessió</a> per enviar un tiquet.'; // %s - User's email
$hesklang['customer_login_email_required']='Si us plau, introduïu una adreça de correu electrònic vàlida.';
$hesklang['customer_login_password_required']='Si us plau, introduïu la vostra contrasenya.';
$hesklang['customer_login_remember_just_email']='Recordar només el meu correu electrònic';
$hesklang['customer_login_remember_email']='Recordar el meu correu electrònic';
$hesklang['customer_wrong_user']='La vostra adreça de correu electrònic %s no està registrada amb nosaltres.<br><br>Voleu <a href="register.php">crear un compte</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='La vostra adreça de correu electrònic i contrasenya no coincideixen amb els nostres registres.<br><br>Voleu <a href="login.php?submittedForgot=1">restablir la contrasenya</a >?';
$hesklang['customer_must_be_logged_in_to_view']='Inicia sessió per continuar.';
$hesklang['customer_register_here']='Si no teniu un compte amb nosaltres, podeu <a href="register.php">registrar-vos aquí</a>.';
$hesklang['create_account']='Crear un compte';
$hesklang['customer_my_tickets_heading']='Els meus tiquets';
$hesklang['customer_my_tickets_description']='Veure tots els vostres tiquets anteriors';
$hesklang['customer_my_tickets_search_for_tickets']='Cerca tiquets';
$hesklang['customer_password_reset_successful']='La nova contrasenya ha estat guardada. Ara podeu iniciar sessió.';
$hesklang['customer_profile']='Perfil';
$hesklang['customer_edit_profile']='Editar perfil';
$hesklang['customer_edit_pass']='Edita la contrasenya';
$hesklang['customer_edit_pass_same']='La nova contrasenya no ha de ser la mateixa que l\'actual.';
$hesklang['customer_change_email']='Canviar correu electrònic';
$hesklang['customer_change_email_banned']='El correu electrònic que heu introduït està prohibit.';
$hesklang['customer_change_email_pending']='Hi ha una sol·licitud actual per canviar la vostra adreça de correu electrònic a: <b>%s</b><br><br>Hem enviat un correu electrònic a aquesta adreça. Feu clic a l\'enllaç dins del correu electrònic per confirmar el canvi.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Reenviar correu electrònic de confirmació</a>';
$hesklang['customer_change_email_submitted']='Feu clic a l\'enllaç de verificació que es va enviar a <b>%s</b> per verificar el nou correu electrònic.'; // %s - new email
$hesklang['customer_change_email_verify_success']='La nova adreça de correu electrònic ha estat verificada i el vostre perfil actualitzat.';
$hesklang['customer_change_email_disabled']='La possibilitat d\'actualitzar el vostre correu electrònic està deshabilitada. Poseu-vos en contacte amb nosaltres si voleu canviar la vostra adreça de correu electrònic.';
$hesklang['customer_profile_saved']='El vostre perfil ha estat desat.';
$hesklang['customers']='Clients';
$hesklang['customers_intro']='Els comptes de clients permeten als clients veure tots els seus tiquets en una ubicació central.';
$hesklang['sure_remove_customer']='Esteu segur que voleu suprimir aquest client?';
$hesklang['sure_remove_customer_additional_note']='L\'eliminació d\'un client és definitiva. Un cop eliminat, no es pot recuperar.';
$hesklang['new_customer']='Nou client';
$hesklang['new_follower']='Nou seguidor';
$hesklang['add_customer']='+ Afegeix client'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Afegeix seguidor'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='El client proporcionat encara no existeix. Feu clic a "Desa" si voleu crear aquest client.';
$hesklang['followers']='Seguidors';
$hesklang['no_customers']='Actualment no hi ha clients a la base de dades.';
$hesklang['no_customers_disabled']='Començarà a veure clients aquí quan enviïn tiquets de suport.';
$hesklang['no_customers_enabled']='Començarà a veure clients aquí quan es registrin o enviïn tiquets de suport.';
$hesklang['no_customers_enabled2']='Alternativament, els botons sobre aquest missatge us permeten crear manualment comptes de clients o importar clients existents al servei d\'assistència.';
$hesklang['import_customers']='Importa clients';
$hesklang['import_customers_tip']='Utilitzeu un fitxer CSV per importar diversos clients alhora.';
$hesklang['customer_not_found']='No s\'ha trobat el client per al tiquet!';
$hesklang['search_by_name_or_email']='Cerca per nom o correu electrònic...';
$hesklang['search_by_pattern']='Cerca per patró...';
$hesklang['is_searchable']='Es pot cercar';
$hesklang['custom_is_searchable']='Es pot cercar';
$hesklang['yes_via_autocomplete']='Sí (cercar mitjançant autocompletar)';
$hesklang['customer_required']='Heu de seleccionar un client';
$hesklang['customer_email_exists']='Ja existeix un client amb aquest correu electrònic.';
$hesklang['customer_name_with_no_email_exists']='Ja existeix un client amb aquest nom i sense correu electrònic.';
$hesklang['an_error_occurred_validating_email']='Es va produir un error en intentar verificar l\'adreça de correu electrònic ingressada.';
$hesklang['customer_count_x_more']='+%s més'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registrat';
$hesklang['customer_account_verified']='Verificat';
$hesklang['customer_account_verified_help']='Els clients han de verificar el vostre compte mitjançant un enllaç d\'activació enviat a la vostra adreça de correu electrònic abans de poder iniciar sessió al vostre compte.';
$hesklang['customer_account_setting_password_will_verify_user']='En establir una contrasenya per a aquest client, es verificarà automàticament el vostre compte.';
$hesklang['deleting_customer_with_tickets']='Aquest client té %1$s ticket(s) <b>(%2$s oberts)</b> que també tenen altres clients associats.<br>Què cal fer amb aquests tiquets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Es necessita una adreça de correu electrònic vàlida per tornar a enviar un correu electrònic de verificació.';
$hesklang['customer_resend_verification_email_not_found']='No hi ha cap compte amb aquesta adreça de correu electrònic o el compte ja ha estat verificat.';
$hesklang['customer_resend_verification_email_sent']='S\'ha enviat un correu electrònic de verificació a la vostra adreça de correu electrònic.<br><br>Si no el rep en uns minuts, reviseu les vostres carpetes de correu no desitjat, correu massiu o spam . Marqueu el missatge com a <b>No SPAM</b> per evitar problemes en rebre la nostra correspondència en el futur.';
$hesklang['customer_permission_denied']='No teniu permís per modificar clients.';
$hesklang['customer_manage_approvals']='Comptes de clients pendents d\'aprovació: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Aprovar client';
$hesklang['customer_manage_bulk_approve']='Aprovar clients seleccionats';
$hesklang['customer_manage_bulk_approve_complete']='Clients aprovats: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Rebutjar client';
$hesklang['customer_manage_bulk_reject']='Rebutjar clients seleccionats';
$hesklang['customer_manage_bulk_reject_complete']='Clients rebutjats: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Eliminar client';
$hesklang['customer_manage_bulk_delete']='Eliminar clients seleccionats';
$hesklang['customer_manage_bulk_delete_complete']='Clients eliminats: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Editar client';
$hesklang['customer_manage_verification_email_sent']='S\'ha enviat un correu electrònic de verificació a %s'; // %s = customer's email
$hesklang['can_man_customers']='Administrar clients';
$hesklang['can_view_customers']='Veure tots els clients (però no administrar-los)';
$hesklang['import_customer_select_file']='Seleccionar fitxer';
$hesklang['import_customer_step1_instructions']='Per importar clients, prepareu un fitxer CSV (valors separats per comes).';
$hesklang['import_customer_step1_note']='Seleccioneu el fitxer CSV';
$hesklang['import_customer_step1_separator']='Les columnes del meu fitxer CSV estan separades per';
$hesklang['import_customer_sample']='&raquo; Fitxers CSV de mostra';
$hesklang['import_customer_sample_1']='Fitxer CSV d\'estil nord-americà amb columnes separades per ,';
$hesklang['import_customer_sample_2']='Fitxer CSV d\'estil europeu amb columnes separades per ;';
$hesklang['import_customer_upload_requirements_1']='El vostre fitxer CSV ha d\'incloure almenys una columna de nom o adreça de correu electrònic. La columna de contrasenya és opcional.';
$hesklang['import_customer_upload_requirements_2']='La primera fila del vostre fitxer ha de contenir capçaleres de columna.';
$hesklang['import_customer_upload_requirements_3']='El vostre fitxer ha d\'estar codificat a UTF-8.';
$hesklang['import_customer_select_columns']='Seleccioneu columnes';
$hesklang['import_customer_upload_customers']='Carregar clients';
$hesklang['import_customer_column_name']='Columna de nom';
$hesklang['import_customer_column_email']='Columna de correu electrònic';
$hesklang['import_customer_column_pass']='Columna de contrasenya';
$hesklang['import_customer_step2_note']='Seleccioneu el nom de columna correcte del vostre fitxer CSV als menús desplegables i després feu clic a "Següent".';
$hesklang['import_customer_name_or_email_required']='Es requereix el nom o el correu electrònic';
$hesklang['import_customer_step3_note']='S\'estan important els vostres clients. No abandoneu aquesta pàgina!';
$hesklang['import_customer_step3_pending']='Pendent';
$hesklang['import_customer_step3_successful_imports']='Importacions exitoses';
$hesklang['import_customer_step3_failed_imports']='Importacions fallides';
$hesklang['import_customer_step3_progress']='Progrés';
$hesklang['import_customer_step3_complete_some_failed']='El procés d\'importació es va completar, però <b>%s</b> clients no van poder importar. Consulteu la taula a continuació per obtenir més informació.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='El procés d\'importació s\'ha completat!';
$hesklang['import_customer_step3_importing']='Important';
$hesklang['staff_deleted']='[Personal eliminat]';
$hesklang['customer_account_approved']='Registre de client aprovat';
$hesklang['customer_account_rejected']='Registre de client rebutjat';
$hesklang['customer_account_deleted']='Registre de client suprimit';
$hesklang['ticket_followers']='Seguidors de tiquets';
$hesklang['ticket_followers2']='Permetre que els tiquets tinguin diversos clients';
$hesklang['add_cc']='Afegeix Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separa cada correu electrònic amb una coma.';
$hesklang['search_customers']='Cerca clients';
$hesklang['page_size']='Mida de pàgina';
$hesklang['customers_on_pages']='Nombre de clients: %d | Nombre de pàgines: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Client) Restabliu la contrasenya';
$hesklang['desc_customer_verify_registration']='(Client) Verifiqueu el vostre registre';
$hesklang['desc_customer_verify_new_email']='(Client) Verifiqueu el vostre nou correu electrònic';
$hesklang['desc_customer_approved']='(Client) Compte aprovat';
$hesklang['desc_customer_rejected']='(Client) Compte rebutjat';
$hesklang['desc_email_rejected_can_self_register']='(Client) Tiquet per correu electrònic rebutjat; el client es pot registrar per si mateix';
$hesklang['desc_email_rejected_cannot_self_register']='(Client) Tiquet per correu electrònic rebutjat; el client no es pot registrar per si mateix';
$hesklang['user_added_success_no_pass']='S\'ha afegit correctament el nou usuari %s';
$hesklang['email_tag_requester']='Sol·licitant (De)';
$hesklang['email_tag_requester_name']='Nom del sol·licitant (De)';
$hesklang['email_tag_requester_first_name']='Nom del sol·licitant (De)';
$hesklang['email_tag_requester_email']='Correu electrònic del sol·licitant (De)';
$hesklang['email_tag_followers']='Seguidors (Cc)';
$hesklang['email_tag_follower_names']='Noms dels seguidors (Cc)';
$hesklang['email_tag_follower_emails']='Correus electrònics dels seguidors (Cc)';
$hesklang['barcode']='Codi de barres';
$hesklang['barcode_use']='Mostrar un codi de barres als tiquets impresos';
$hesklang['barcode_staff_only']='Ocultar el codi de barres als clients';
$hesklang['barcode_type']='Tipus de codi de barres';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Amplada';
$hesklang['barcode_height']='Alçada';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Fons';
$hesklang['copy_link']='Copiar enllaç del tiquet';
$hesklang['copy_link_title']='Copiar enllaç públic a aquest tiquet';
$hesklang['copy_link_exp']='L\'enllaç copiat és l\'enllaç directe perquè el client vegi aquest tiquet';
$hesklang['copy_value']='Copia aquest valor';
$hesklang['download_class']='Aquesta funció requereix la classe ZipArchive. Demaneu al vostre host que compile PHP amb suport per a zip.';
$hesklang['download_all']='Descarregar-ho tot';
$hesklang['download_prep']='Preparant descàrrega...';
$hesklang['download_tma']='Massa fitxers adjunts';
$hesklang['download_nva']='No hi ha fitxers adjunts vàlids';
$hesklang['download_ntd']='No hi ha res a descarregar';
$hesklang['resolved_at']='Resolt a';
$hesklang['disable_GSSAPI']='Deshabilitar l\'autenticador GSSAPI (solució temporal per a errors de Kerberos)';
$hesklang['ex_history']='Incloure el registre de l\'historial de tiquets en l\'exportació';
$hesklang['sm_location']='Ubicació'; // Location (page) of a service message
$hesklang['loc_sm']='Mostrar aquest missatge de servei a:';
$hesklang['loc_all']='Cada pàgina del client';
$hesklang['loc_norec']='(no recomanat)';
$hesklang['loc_home']='Pàgina d\'inici del servei d\'assistència tècnica';
$hesklang['loc_selected']='A les pàgines seleccionades';
$hesklang['loc_selerr']='Seleccioneu almenys una pàgina on mostrar el missatge';
$hesklang['loc_t_cat']='Enviar un tiquet - seleccionar una categoria';
$hesklang['loc_t_add']='Enviar un tiquet - enviar un formulari de tiquet';
$hesklang['loc_t_ok']='Enviar un tiquet - confirmació del tiquet';
$hesklang['loc_t_view']='Veure un tiquet';
$hesklang['loc_t_form']='Veure un formulari de tiquet';
$hesklang['loc_kb_main']='Pàgina d\'inici de la base de coneixements';
$hesklang['loc_kb_sub']='Pàgines de subcategories de la base de coneixements';
$hesklang['loc_kb_art']='Articles de la base de coneixements';
$hesklang['loc_login']='Pàgina d\'inici de sessió del client';
$hesklang['loc_register']='Pàgina de registre del client';
$hesklang['loc_register_ok']='El client s\'ha registrat correctament';
$hesklang['loc_acc']='Pàgina &quot;Els meus tiquets&quot; del client';
$hesklang['loc_profile']='Pàgina &quot;Perfil&quot; del client';
$hesklang['sending_show']='Mostra la notificació &quot;Enviant&quot;';
$hesklang['sending_wait']='Enviant, espereu...';
$hesklang['e_c_email']='Introduïu l\'adreça de correu electrònic correcta per veure aquest tiquet';
$hesklang['only_verified_cc']='Els seguidors que no tinguin un compte verificat seran ignorats.';
$hesklang['followers_removed']='Aquestes adreces de correu electrònic s\'han eliminat del tiquet perquè no tenen un compte verificat:';
$hesklang['novace']='No trobem cap compte registrat i verificat amb aquesta adreça de correu electrònic.';
$hesklang['max_recipients']='Màxim de destinataris';
$hesklang['max_recipients2']='en un sol correu electrònic';
$hesklang['admin_js']='JS d\'administrador';
$hesklang['admin_js2']='Carregar un fitxer Javascript personalitzat addicional per al tauler d\'administració';
$hesklang['cf_limit_all']='Ha arribat al límit de camps personalitzats i no podeu crear camps personalitzats nous.';
$hesklang['remind_assigned']='Recordatori al personal assignat';
$hesklang['remind_sent']='Recordatori per correu electrònic enviat al membre del personal assignat';
$hesklang['thist23']='<li class="smaller">%s | recordatori enviat a %s per %s</li>';
$hesklang['ql_bookmarks']='Marcadors';
$hesklang['bookmark']='El meu marcador';
$hesklang['bookmarks_add']='Afegeix a marcadors';
$hesklang['bookmarks_added']='Aquest tiquet ha estat afegit als vostres marcadors';
$hesklang['bookmarks_remove']='Treure de marcadors';
$hesklang['bookmarks_removed']='Aquest tiquet ha estat eliminat dels vostres marcadors';
$hesklang['genl_not_copied']='Error: Copiar al porta-retalls no és compatible amb aquest dispositiu/navegador.';
$hesklang['profile_duplicate_email']='L\'usuari amb el correu electrònic <b>%s</b> ja existeix.'; // %s: new email
$hesklang['seq_id_numeric']='La cerca de número de tiquet ha de contenir només números';
$hesklang['confirm_new_pass']='Confirmar nova contrasenya';
$hesklang['piping_notify_rejected_customers1']='Correus electrònics de rebuig de clients';
$hesklang['piping_notify_rejected_customers2']='Enviar un correu electrònic de rebuig als clients quan el vostre tiquet sigui rebutjat';
$hesklang['piping_notify_rejected_customers3']='Temps entre correus electrònics de rebuig';
$hesklang['register_url']='URL de registre';
$hesklang['email_subject']='Assumpte del correu electrònic';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Col·laborant en el tiquet: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] El personal ha respost a: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] S\'ha afegit una nota a: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Tiquet vençut: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Tiquet resolt: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Data límit per a correus de seguiment:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='No enviar correus a tiquets resolts fa més de'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='fa (ha de ser un període més llarg que \"%s\")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='El període de data límit ha de ser més llarg que el retard del correu de seguiment';
$hesklang['available_language']='Idiomes disponibles';
$hesklang['click_to_show_available_language']='Fes clic per veure els idiomes disponibles';
$hesklang['install_lan']='Instal·lar';
$hesklang['remove_lan']='Eliminar';
$hesklang['title_lan']='Títol';
$hesklang['description_lan']='Descripció';
$hesklang['completed_lan']='Completat';
$hesklang['no_language_availble']='No hi ha idiomes disponibles';
$hesklang['success_install_lan_txt']='L\'idioma s\'ha afegit correctament';
$hesklang['error_install_lan_txt']='No s\'ha pogut afegir l\'idioma';
$hesklang['success_remove_lan_txt']='L\'idioma s\'ha eliminat correctament';
$hesklang['error_remove_lan_txt']='No s\'ha pogut eliminar l\'idioma';
$hesklang['remove_default_language_error']='L\'idioma per defecte ha de romandre actiu i no es pot eliminar';
$hesklang['click_for_manual_step']='Fes clic per a la instal·lació manual';
$hesklang['upgrade_lan']='Actualitzar';
$hesklang['success_upgrade_lan_txt']='L\'idioma s\'ha actualitzat correctament';
$hesklang['error_upgrade_lan_txt']='No s\'ha pogut actualitzar l\'idioma';
$hesklang['please_wait']='Si us plau, espera...';
$hesklang['add_a_note']='Afegir una nota';
$hesklang['add_a_reply']='Afegir una resposta';
$hesklang['customer_id']='ID del client';
$hesklang['deleting_customer_tickets']='Tiquets oberts pel client: <b>%1$s</b><br>Què hauríem de fer amb aquests tiquets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tiquets on el client està copiat: <b>%1$s</b><br>Aquests perdran aquest client com a seguidor; els tiquets es mantindran sense canvis.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Eliminar permanentment els tiquets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonimitzar tiquets (eliminar missatges i dades personals)';
$hesklang['deleting_customer_retain_tickets2']='Conservar els tiquets (deixar totes les dades intactes)';
$hesklang['for_staff']='per al personal del servei tècnic'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='per als clients'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='Bústia IMAP';
$hesklang['file_attachment_options']='Opcions d\'adjunció de correus electrònics';
$hesklang['link_to_attachments_in_emails']='Enllaç als adjunts en els correus';
$hesklang['add_attachments_directly_to_emails']='Afegir adjunts directament als correus';
$hesklang['directly_attach_file_smaller_than']='Adjuntar directament només fitxers més petits de';
$hesklang['directly_attach_file_of_any_size']='Adjuntar directament fitxers de qualsevol mida';
$hesklang['directly_attach_only_first_x_attachments']='Adjuntar directament només els primers';
$hesklang['directly_attach_all_attachments']='Adjuntar directament tots els adjunts';
$hesklang['directly_attach_size']='Mida de l\'adjunt';
$hesklang['directly_attach_no_of_files']='Nombre de fitxers';
$hesklang['notice_about_directly_attach_files']='Adjuntar molts fitxers o fitxers grans pot causar retards en la comunicació amb el servidor SMTP';
$hesklang['fatt_2']='Fitxers addicionals adjunts a aquest missatge:';
$hesklang['no_collaborators']='Cap';
$hesklang['collaborate']='Col·labora en aquest tiquet';
$hesklang['collaborators']='Col·laboradors';
$hesklang['ql_cbm']='Col·laborador';
$hesklang['collaborating']='Ara estàs col·laborant en aquest tiquet';
$hesklang['not_collaborating']='Ja no estàs col·laborant en aquest tiquet';
$hesklang['add_collaborator']='Afegir un col·laborador';
$hesklang['user_collaborator_added']='L\'usuari s\'ha afegit com a col·laborador en aquest tiquet';
$hesklang['remove_collaborator']='Eliminar col·laborador';
$hesklang['staff_name']='Nom del personal';
$hesklang['user_collaborator_removed']='L\'usuari s\'ha eliminat com a col·laborador en aquest tiquet';
$hesklang['desc_collaborator_added']='(Personal) Estàs col·laborant en un nou tiquet';
$hesklang['desc_collaborator_staff_reply']='(Personal) Un membre del personal ha respost a un tiquet col·laborat';
$hesklang['desc_collaborator_note']='(Personal) S\'ha afegit una nova nota a un tiquet col·laborat';
$hesklang['desc_collaborator_resolved']='(Personal) Un tiquet col·laborat ha estat resolt';
$hesklang['desc_collaborator_overdue']='(Personal) Un tiquet col·laborat està vençut';
$hesklang['notify_collaborator_added']='M\'han afegit com a col·laborador d\'un tiquet';
$hesklang['notify_collaborator_customer_reply']='El client ha respost a un tiquet col·laborat';
$hesklang['notify_collaborator_staff_reply']='El personal ha respost a un tiquet col·laborat';
$hesklang['notify_collaborator_note']='El personal ha afegit una nota a un tiquet col·laborat';
$hesklang['notify_collaborator_resolved']='El personal ha resolt un tiquet col·laborat';
$hesklang['notify_collaborator_overdue']='El tiquet col·laborat està vençut';
$hesklang['recurring_tickets']['tab']='Tiquets recurrents'; // Menu link
$hesklang['recurring_tickets']['page_title']='Tiquets recurrents'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatitza les tasques repetitives; deixa que Hesk generi tiquets rutinaris per a tu, exactament quan els necessitis.';
$hesklang['recurring_tickets']['active_rules']='Regles actives';
$hesklang['recurring_tickets']['new']='Nova regla de tiquet recurrent';
$hesklang['recurring_tickets']['no_rules']='No tens cap regla de tiquet recurrent. Crea\'n una fent clic al botó \"Nova regla de tiquet recurrent\" de dalt.';
$hesklang['recurring_tickets']['title']='Títol de la regla';
$hesklang['recurring_tickets']['titlet']='Un títol descriptiu, per exemple: Reassignar tiquets no respostos en un dia';
$hesklang['recurring_tickets']['default_title']='Regla de %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Activador de la regla';
$hesklang['recurring_tickets']['trigt']='Defineix la condició que activarà (executarà) aquesta regla.';
$hesklang['recurring_tickets']['hits']='Activacions'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Hora de creació'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Configuració general'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Camps personalitzats'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Contingut'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Eliminar aquesta regla?';
$hesklang['recurring_tickets']['edit']='Editant la regla de tiquet recurrent amb ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Dins de:';
$hesklang['recurring_tickets']['minutes']='minuts';
$hesklang['recurring_tickets']['hours']='hores';
$hesklang['recurring_tickets']['days']='dies';
$hesklang['recurring_tickets']['weeks']='setmanes';
$hesklang['recurring_tickets']['months']='mesos';
$hesklang['recurring_tickets']['years']='anys';
$hesklang['recurring_tickets']['setpri']='Establir la prioritat a:';
$hesklang['recurring_tickets']['setsta']='Establir l\'estat a:';
$hesklang['recurring_tickets']['assto']='Assignar el tiquet a:';
$hesklang['recurring_tickets']['asm']='Un altre membre del personal';
$hesklang['recurring_tickets']['notify']='Notificar als membres del personal...';
$hesklang['recurring_tickets']['ato']='Aplicar a:';
$hesklang['recurring_tickets']['save']='Desar la regla';
$hesklang['recurring_tickets']['e_tt']='El temps ha d\'estar entre 1 i 10000';
$hesklang['recurring_tickets']['nocat']='Selecciona almenys una categoria';
$hesklang['recurring_tickets']['nouser']='Selecciona almenys un usuari';
$hesklang['recurring_tickets']['nostatus']='Selecciona almenys un estat';
$hesklang['recurring_tickets']['nocata']='%1$s no té accés a aquestes categories:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='S\'ha creat una nova regla';
$hesklang['recurring_tickets']['mdf']='S\'han desat els paràmetres de la regla';
$hesklang['recurring_tickets']['e_id']='No s\'ha trobat cap regla amb aquest ID';
$hesklang['recurring_tickets']['deleted']='S\'ha eliminat la regla seleccionada';
$hesklang['recurring_tickets']['log_title']='Regla #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Activa'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activar aquesta regla (començar a utilitzar-la)';
$hesklang['recurring_tickets']['activated']='S\'ha activat la regla seleccionada'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Desactivar aquesta regla (deixar d\'utilitzar-la)';
$hesklang['recurring_tickets']['deactivated']='S\'ha desactivat la regla seleccionada'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No hi ha regles de tiquets recurrents actives';
$hesklang['recurring_tickets']['tools']='Eines';
$hesklang['recurring_tickets']['tbef']='Abans que una regla estigui activa, cal activar-la fent clic a la casella de la columna \"ACTIVA\".<br><br>
								<strong>Les regles actives es processen cada %2$s minuts.</strong>'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[REGLA]';
$hesklang['recurring_tickets']['r2']='[REGLA] Regla #%s';
$hesklang['recurring_tickets']['r3']='Regla #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Nombre de tiquets ja creats avui: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reiniciar aquesta regla';
$hesklang['recurring_tickets']['reset2']='Estàs segur que vols reiniciar aquesta regla?<br><br>Les activacions de la regla es posaran a 0 i qualsevol tiquet ja generat avui podria tornar-se a generar en la propera execució del cron.';
$hesklang['recurring_tickets']['reset3']='S\'ha reiniciat la regla seleccionada';
$hesklang['recurring_tickets']['test']='Simular aquesta regla';
$hesklang['recurring_tickets']['testa']='Simular totes les regles';
$hesklang['recurring_tickets']['testaa']='Simular totes les regles actives';
$hesklang['recurring_tickets']['testr']='Resultats de la simulació';
$hesklang['recurring_tickets']['rsim']='Repetir simulació';
$hesklang['recurring_tickets']['sim']='MODE SIMULACIÓ, no es fan canvis a la base de dades';
$hesklang['recurring_tickets']['sic']='SIMULACIÓ COMPLETA';
$hesklang['recurring_tickets']['rrule_type_required']='Si us plau, selecciona un activador de regla recurrent vàlid.';
$hesklang['recurring_tickets']['rrule_string_required']='Si us plau, selecciona totes les opcions requerides per a l\'activador de la regla recurrent.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Introdueix un valor d\'interval de 1 o més per a \"Cada\".';
$hesklang['recurring_tickets']['disable_note']='*Si es canvia alguna configuració crítica de Hesk després de crear una regla, aquesta es desactivarà en el següent intent d\'execució i caldrà editar-la per complir els nous requisits de validació.';
$hesklang['recurring_tickets']['thist1']='<li class=\"smaller\">%1$s \n enviat per la Regla de Tiquets Recurrent \"%2$s\"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class=\"smaller\">%1$s \n assignat a %2$s per la Regla de Tiquets Recurrent \"%3$s\"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class=\"smaller\">%1$s \n tancat automàticament per la Regla de Tiquets Recurrent \"%2$s\"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class=\"smaller\">%1$s \n estat canviat a %2$s per la Regla de Tiquets Recurrent \"%3$s\"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class=\"smaller\">%1$s \n assignat automàticament a %2$s per la Regla de Tiquets Recurrent \"%3$s\"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='La regla s\'ha desactivat a causa d\'errors de validació. Consulta els detalls a continuació.';
$hesklang['recurring_tickets']['errors_title']='Una o més de les teves regles han generat errors en intentar executar-se i han estat desactivades.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Errors de la Regla #%s:';
$hesklang['recurring_tickets']['create_customers']='No hi ha clients existents - crea\'ls <a href=\"%s\" target=\"_blank\">aquí</a>.';
$hesklang['recurring_tickets']['exec_dates']='Dates d\'execució de la regla';
$hesklang['recurring_tickets']['show_exec_dates']='[Mostra les dates d\'execució actuals de la regla]';
$hesklang['recurring_tickets']['no_exec_dates']='Selecciona activadors de regla vàlids per veure les dates d\'execució.';
$hesklang['recurring_tickets']['invalid_disabled']='configuració de regla no vàlida - regla desactivada.';
$hesklang['recurring_tickets']['next_occ']='Properes ocurrències de la regla %s:';
$hesklang['recurring_tickets']['occ_on']='el %s';
$hesklang['recurring_tickets']['not_firing_today']='no cal executar-la avui.';
$hesklang['recurring_tickets']['rules_fulfilled']='regles recurrents complertes - tiquet creat avui!';
$hesklang['recurring_tickets']['validation_failed']='validació fallida - regla desactivada. Detalls a continuació:';
$hesklang['recurring_tickets']['validation_error']='Error de validació:';
$hesklang['recurring_tickets']['processed']='processada.';
$hesklang['recurring_tickets']['created_ticket']='tiquet creat amb ID: %1$s, ID de seguiment: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relatiu a la data de creació del tiquet';
$hesklang['priorities']='Prioritats';
$hesklang['priority_intro']='Utilitza aquesta eina per gestionar les prioritats dels tiquets del teu servei d\'assistència';
$hesklang['new_priority']='Nova prioritat';
$hesklang['edit_priority']='Editar prioritat';
$hesklang['priority_title']='Títol';
$hesklang['can_customers_select_it']='Els clients poden seleccionar aquesta prioritat?';
$hesklang['selected_by_customer']='Seleccionable pels clients';
$hesklang['err_priority']='Introdueix el títol de la prioritat';
$hesklang['priority_added']='S\'ha afegit una nova prioritat';
$hesklang['priority_e_id']='ID de prioritat no vàlid';
$hesklang['priority_mdf']='S\'ha desat la prioritat';
$hesklang['priority_deleted']='Prioritat eliminada';
$hesklang['priority_not_found']='Aquesta prioritat no existeix';
$hesklang['priority_not_empty']='Aquesta prioritat no es pot eliminar perquè hi ha tiquets amb aquesta prioritat';
$hesklang['click_to_enable_drag_drop']='Fes clic per activar l\'arrossega i deixa anar per a la fila, després arrossega-la amunt o avall per reordenar les prioritats.';
$hesklang['confirm_delete_priority']='Estàs segur que vols eliminar aquesta prioritat?';
$hesklang['reordered_message']='S\'ha desat l\'ordre de la llista de prioritats.';
$hesklang['list_tkt_priority']='Llistar tots els tiquets amb aquesta prioritat';
$hesklang['deletion_priority_restricted']='Aquesta és una prioritat especial i no es pot eliminar';
$hesklang['priority_limit']='No pots crear més prioritats';
$hesklang['skip_to_main_content']='Saltar al contingut principal';
$hesklang['opens_dialog']='Obre un diàleg';
$hesklang['create_a_ticket']='Crear un tiquet';
$hesklang['toggle_navigation']='Alternar la navegació';
$hesklang['add_a_ticket_reply']='Afegir una resposta al tiquet';
$hesklang['linked_tickets']='Tiquets enllaçats';
$hesklang['no_linked_tickets']='No hi ha tiquets enllaçats';
$hesklang['link_ticket']='Enllaçar tiquet';
$hesklang['can_link_tickets_e']='No estàs autoritzat a enllaçar/desenllaçar aquest tiquet';
$hesklang['link_ticket_success']='El tiquet s\'ha enllaçat correctament';
$hesklang['link_ticket_required_error']='Per enllaçar un tiquet, introdueix un ID de seguiment vàlid';
$hesklang['link_ticket_itself_error']='Un tiquet no es pot enllaçar amb ell mateix. Introdueix un ID de seguiment diferent';
$hesklang['already_linked_error']='El tiquet ja està enllaçat';
$hesklang['unlink_success']='El tiquet s\'ha desenllaçat correctament';
$hesklang['unlink_error']='No existeix cap registre enllaçat';
$hesklang['link_history']='<li class=\"smaller\">%s \n tiquet %s enllaçat per %s</li>';
$hesklang['unlink_history']='<li class=\"smaller\">%s \n tiquet %s desenllaçat per %s</li>';
$hesklang['can_link_tickets']='Pot enllaçar tiquet';
$hesklang['link_a_ticket']='Enllaçar un tiquet';
$hesklang['mfa_curl']='No es pot generar una imatge QR per escanejar perquè el suport <strong>cURL</strong> no està habilitat al teu servidor.';
$hesklang['require_xml']='Cal tenir habilitat PHP-XML per a missatges en text enriquit (HTML). Demana al teu proveïdor que activi XML per a PHP.';
$hesklang['thist24']='<li class=\"smaller\">%1$s \n %2$s afegit com a col·laborador per %3$s</li>';
$hesklang['thist25']='<li class=\"smaller\">%1$s \n %2$s eliminat com a col·laborador per %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Ideal per a tasques de manteniment preventiu, revisions mensuals d\'accés, seguiments recurrents amb clients i més.';
$hesklang['recurring_tickets']['feat1']='<strong>Programa i oblida.</strong> Diàriament, cada dilluns, cada març, el dia 15 de cada mes o qualsevol data futura';
$hesklang['recurring_tickets']['feat2']='<strong>Arriben preomplerts i assignats.</strong> Tria categoria, prioritat, agent i fins a 100 valors de camps personalitzats';
$hesklang['recurring_tickets']['feat3']='<strong>Previsualitza dates i simula.</strong> Veu cada tiquet que Hesk generarà abans d\'activar una regla, sense sorpreses.';
$hesklang['unlink_btn']='Desenllaçar';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');