<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Svenska (Swedish)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Mats-Ola Borglund (http://www.bloghome.se)
* Jesse Sarvak (https://jessesarvak.com)
* Mattias Magnusson (https://www.mspot.nu)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Svenska';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Swedish';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_swedish_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Svara ovanför denna linje ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Nytt ärende: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Ärendet mottaget: %%SUBJECT%%; Status: %%STATUS%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Ärendet tilldelat: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nytt svar till: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nytt svar till: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Ärendet flyttat: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Anmärkning tillagd till:: %%SUBJECT%%';
$hesklang['new_pm']='Nytt privat meddelande: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Lista över dina supportärenden';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Kan inte ansluta till databasen!';
$hesklang['invalid_action']='Ogiltig åtgärd';
$hesklang['select_username']='Välj ditt användarnamn';
$hesklang['enter_pass']='Skriv in ditt lösenord';
$hesklang['cant_sql']='Kan inte köra SQL';
$hesklang['contact_webmsater']='Vänligen meddela webbansvarig på';
$hesklang['mysql_said']='MySQL svarade';
$hesklang['wrong_pass']='Fel lösenord.';
$hesklang['session_expired']='Sessionen har upphört. Vänligen logga in via formuläret nedan.';
$hesklang['attempt']='Ogiltigt försök!';
$hesklang['not_authorized_tickets']='Du har inte behörighet att granska ärenden i denna kategorin!';
$hesklang['must_be_admin']='Du har inte behörighet att granska den här sidan! För att se sidan måste du vara inloggad som administratör.';
$hesklang['no_session']='Kan inte starta en ny session!';
$hesklang['error']='Fel';
$hesklang['int_error']='Internt fel: skriptfel, vänligen kontakta sidans administratör';
$hesklang['no_trackID']='Inget spårnings-ID';
$hesklang['status_not_valid']='Ogiltig status';
$hesklang['trackID_not_found']='Spårnings-ID hittades inte';
$hesklang['enter_message']='Vänligen Ange ditt meddelande';
$hesklang['select_priority']='Välj prioritet';
$hesklang['ticket_not_found']='Ditt ärende hittades inte! Har du angett rätt spårnings-ID?';
$hesklang['no_selected']='Inga ärenden valda, inga ändringar utförs!';
$hesklang['id_not_valid']='Det här är inte ett giltigt ID';
$hesklang['enter_id']='Fyll i ett spårnings-ID';
$hesklang['enter_name']='Ange kundens namn';
$hesklang['enter_date']='Ange det datum som du vill söka i';
$hesklang['date_not_valid']='Detta är inte ett giltigt datum. Ange datum <b>YYYY-MM-DD</b> för att söka';
$hesklang['enter_subject']='Vänligen, ange ärenderubrik';
$hesklang['invalid_search']='Ogiltig sökning';
$hesklang['choose_cat_ren']='Välj en kategori som ska namnändras';
$hesklang['cat_ren_name']='Ange ett nytt kategorinamn';
$hesklang['cat_not_found']='Kategorin hittades inte';
$hesklang['enter_cat_name']='Ange kategorinamn';
$hesklang['no_cat_id']='Inget kategori-ID';
$hesklang['cant_del_default_cat']='Du kan inte ta bort den förvalda kategorin, du kan enbart byta namn på den';
$hesklang['no_valid_id']='Ogiltigt användar-ID';
$hesklang['user_not_found']='användaren kunde inte hittas';
$hesklang['enter_real_name']='Vänligen fyll i ditt riktiga namn';
$hesklang['enter_valid_email']='Vänligen ange en giltig e-postadress';
$hesklang['enter_username']='Ange användarnamn (inloggning)';
$hesklang['asign_one_cat']='Vänligen tilldela användaren till minst en kategori!';
$hesklang['signature_long']='För lång användarsignatur! Vänligen begränsa signaturen till 1000 tecken';
$hesklang['confirm_user_pass']='Bekräfta ditt lösenord';
$hesklang['passwords_not_same']='Lösenordsfälten matchade inte, Vänligen ange samma lösenord två gånger!';
$hesklang['cant_del_admin']='Du kan inte ta bort standardadministratören!';
$hesklang['cant_del_own']='Du kan inte ta bort profilen som du är inloggad som!';
$hesklang['enter_your_name']='Vänligen ange ditt namn';
$hesklang['sel_app_cat']='Vänligen välj en lämplig kategori';
$hesklang['sel_app_priority']='Vänligen välj en lämplig prioritet';
$hesklang['enter_ticket_subject']='Ange rubriken på ditt ärende';
$hesklang['user_not_found_nothing_edit']='Användaren hittades inte eller så fanns det ingenting att ändra';

// ADMIN PANEL
$hesklang['administrator']='Administratör';
$hesklang['login']='Logga in';
$hesklang['user']='Användare';
$hesklang['username']='Användarnamn';
$hesklang['pass']='Lösenord';
$hesklang['confirm_pass']='Bekräfta ditt lösenord';
$hesklang['logged_out']='Utloggad';
$hesklang['logout']='Logga ut';
$hesklang['logout_success']='Utloggad!';
$hesklang['click_login']='Klicka här för att logga in';
$hesklang['back']='Gå tillbaka';
$hesklang['displaying_pages']='Visar <b>%d</b> ärenden. Sidor:';
$hesklang['trackID']='Spårnings-ID';
$hesklang['timestamp']='Tidsstämpel';
$hesklang['name']='Namn';
$hesklang['subject']='Ämne';
$hesklang['status']='Status';
$hesklang['priority']='Prioritet';
$hesklang['open']='Ny';
$hesklang['open_action']='Öppna ärendet igen'; // Open ACTION
$hesklang['close']='Stängd'; // Closed ticket STATUS
$hesklang['any_status']='status';
$hesklang['high']='Hög';
$hesklang['medium']='Mellan';
$hesklang['low']='Låg';
$hesklang['del_selected']='Radera valda ärenden';
$hesklang['manage_cat']='Hantera kategorier';
$hesklang['profile']='Din profil';
$hesklang['show_tickets']='visa ärenden';
$hesklang['sort_by']='Sortera efter';
$hesklang['date_posted']='Datum för postning';
$hesklang['category']='Kategori';
$hesklang['any_cat']='Alla kategorier';
$hesklang['order']='Sorteringsordning';
$hesklang['ascending']='Stigande';
$hesklang['descending']='fallande';
$hesklang['display']='Visa';
$hesklang['tickets_page']='Ärenden per sida';
$hesklang['find_ticket']='Hitta ärende';
$hesklang['yyyy_mm_dd']='YYYY-MM-DD';
$hesklang['results_page']='resultat per sida';
$hesklang['opened']='Öppnad'; // The ticket has been OPENED
$hesklang['closed']='Löst'; // Ticket has been RESOLVED
$hesklang['ticket']='Ärende';
$hesklang['tickets']='Ärenden';
$hesklang['ticket_been']='Detta ärendet har blivit';
$hesklang['view_ticket']='Granska ärende';
$hesklang['open_tickets']='Öppna ärenden';
$hesklang['remove_statement']='Ta bort &quot;Powered by&quot; statement';
$hesklang['click_info']='Klicka här för mer information';
$hesklang['reply_added']='Svar tillagt';
$hesklang['reply_submitted']='Svar skickat';
$hesklang['ticket_marked']='Det här ärendet har markerats';
$hesklang['ticket_status']='Ärendestatus';
$hesklang['replies']='Svar';
$hesklang['date']='Datum';
$hesklang['email']='E-post';
$hesklang['ip']='IP';
$hesklang['message']='Meddelande';
$hesklang['add_reply']='Lägg till svar';
$hesklang['close_this_ticket']='Stäng ärende';
$hesklang['change_priority']='Ändra prioritet till';
$hesklang['attach_sign']='Lägg till signatur';
$hesklang['profile_settings']='Profilinställningar';
$hesklang['submit_reply']='Skicka svar';
$hesklang['support_panel']='Supportpanel';
$hesklang['ticket_trackID']='Ärende-ID';
$hesklang['c2c']='Klicka för att fortsätta';
$hesklang['tickets_deleted']='Ärenden raderade';
$hesklang['num_tickets_deleted']='<b>%d</b> ärenden har raderats';
$hesklang['confirm_del_cat']='Är du säker på att du vill ta bort denna kategorin?';
$hesklang['cat_intro']='Här kan du hantera kategorier. Kategorier används
för att kategorisera ärenden efter relevans (ex. &quot;Försäljning&quot;,
&quot;Hårdvaruproblem&quot;, &quot;PHP/MySQL problem&quot; etc) och för att
tilldela användare kategorier (ex. så att din säljare bara ska kunna se
ärenden skickade till kategorin &quot;Försäljning&quot;)';
$hesklang['cat_name']='Kategorinamn';
$hesklang['remove']='Ta bort';
$hesklang['add_cat']='Lägg till ny kategori';
$hesklang['max_chars']='max 40 tecken';
$hesklang['create_cat']='Skapa kategori';
$hesklang['ren_cat']='Namnändra kategori';
$hesklang['to']='till';
$hesklang['cat_added']='Kategori tillagd';
$hesklang['cat_name_added']='Kategorin %s har framgångsrikt lagts till';
$hesklang['cat_renamed']='Kategori namnändrad';
$hesklang['cat_renamed_to']='Vald kategori blev namnändrad till';
$hesklang['cat_removed']=' Kategorin togs bort';
$hesklang['cat_removed_db']='Vald kategori har tagits bort från databasen';
$hesklang['sure_remove_user']='Vill du verkligen ta bort denna användare?';
$hesklang['manage_users']='Hantera användare';
$hesklang['users_intro']='Här kan du hantera användare som kan logga in i Adminpanelen och
hantera ärenden. Administratörer kan läsa och redigera alla ärenden i alla kategorier och har åtkomst
till alla funktioner i Adminpanelen (hantera användare, kategorier, ...) medan
andra användare endast kan läsa och besvara ärenden inom sin kategori.';
$hesklang['yes']='Ja';
$hesklang['no']='Nej';
$hesklang['edit']='Ändra';
$hesklang['add_user']='Lägg till ny användare';
$hesklang['req_marked_with']='Obligatoriska fält är markerade med';
$hesklang['real_name']='För- och efternamn';
$hesklang['signature_max']='Signatur (max 1000 tecken)';
$hesklang['sign_extra']='HTML-kod är inte tillåtet. Länkar kommer att vara klickbara.';
$hesklang['create_user']='Skapa användare';
$hesklang['editing_user']='Redigerar användare';
$hesklang['user_added']='Användare tillagd';
$hesklang['user_added_success']='Ny användare %s med lösenord %s har lagts till';
$hesklang['profile_updated']='Profile updated';
$hesklang['profile_updated_success']='Denna profil har uppdaterats';
$hesklang['user_removed']='Användarkontot har tagits bort';
$hesklang['sel_user_removed']='Vald användare togs bort från databasen';
$hesklang['profile_for']='Profil för';
$hesklang['new_pass']='Nytt Lösenord';
$hesklang['update_profile']='Uppdatera profil';
$hesklang['notify_new_posts']='Meddela mig om nya ärenden och inlägg inom mina kategorier';
$hesklang['view_profile']='Granska profil';
$hesklang['new_ticket_submitted']='Nytt ärende har skickats';
$hesklang['user_profile_updated_success']='Denna användarprofil har uppdaterats';
$hesklang['printer_friendly']='Utskriftsvänlig version';
$hesklang['end_ticket']='--- Slut på ärendet ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Ditt ärende har';
$hesklang['view_your_ticket']='Granska ditt ärende';
$hesklang['submit_ticket']='Registera ett ärende';
$hesklang['sub_ticket']='Skicka in ditt ärende';
$hesklang['before_submit']='Innan du registrerar ditt ärende, vänligen kontrollera följande';
$hesklang['all_info_in']='Att all nödvändig information har fyllts i';
$hesklang['all_error_free']='Att all information är korrekt och felfri';
$hesklang['we_have']='Vi har';
$hesklang['recorded_ip']='registrerat (denna adress som) din IP-adress';
$hesklang['recorded_time']='registrerat tidpunkten för din registrering';
$hesklang['save_changes']='Spara ändringar';
$hesklang['reply_submitted_success']='Ditt svar till detta ärende har skickats';
$hesklang['ticket_submitted']='Ärende skickat';
$hesklang['ticket_submitted_success']='Ditt ärende har skickats och fått ett ärende-ID';
$hesklang['your_ticket']='Ditt ärende';

// Added in version 0.94
$hesklang['check_updates']='Se till att du alltid har den senaste versionen av Hesk!';
$hesklang['check4updates']='Sök efter uppdateringar';
$hesklang['wait_reply']='Väntar på svar';
$hesklang['replied']='Besvarat';
$hesklang['last_replier']='Senast besvarad av';
$hesklang['staff']='Personal';
$hesklang['customer']='Kund';
$hesklang['close_selected']='Markera valda ärenden som lösta';
$hesklang['execute']='Verkställ';
$hesklang['saved_replies']='Standardsvar';
$hesklang['manage_saved']='Standardsvar';
$hesklang['manage_intro']='Här kan du lägga till och hantera standardsvar, de mest använda svaren, vilka mer eller mindre är desamma för alla kunder. De kan användas för att slippa skriva samma svar flera gånger till olika kunder.';
$hesklang['saved_title']='Titel';
$hesklang['no_saved']='Inga standardsvar';
$hesklang['delete_saved']='Är du säker på att du vill ta bort detta standardsvar?';
$hesklang['new_saved']='Lägg till eller ändra ett standardsvar';
$hesklang['canned_add']='Skapa ett nytt standardsvar';
$hesklang['canned_edit']='Ändra det valda standardsvaret';
$hesklang['save_reply']='Spara svar';
$hesklang['saved']='Svaret sparat';
$hesklang['your_saved']='Ditt standardsvar har sparats för framtida bruk';
$hesklang['ent_saved_title']='Ange svarsrubrik';
$hesklang['ent_saved_msg']='Skriv in svarsmeddelande';
$hesklang['saved_removed']='Standardsvar togs bort';
$hesklang['saved_rem_full']='Valt standardsvar har tagits bort från databasen';
$hesklang['clip_alt']='Inlägget har bilagor';
$hesklang['attachments']='Bilagor';
$hesklang['fill_all']='Obligatoriskt fält saknas';
$hesklang['file_too_large']='Din fil %s är för stor';
$hesklang['cannot_move_tmp']='Kan inte flytta filen till mappen bilagor';
$hesklang['created_on']='Skapad den';
$hesklang['tickets_closed']='Ärenden stängda';
$hesklang['num_tickets_closed']='<b>%d</b> ärenden har stängts';
$hesklang['select_saved']='Välj ett standardsvar';
$hesklang['select_empty']='Välj / Tomt';
$hesklang['insert_special']='Infoga specialtagg (kommer att ersättas med kundens info)';
$hesklang['move_to_catgory']='Flytta ärendet till';
$hesklang['move']='Flytta';
$hesklang['moved']='Ärendet har flyttats';
$hesklang['moved_to']='Detta ärendet har flyttats till den nya kategorin.';
$hesklang['url']='LÄNK';
$hesklang['all_not_closed']='Alla utom de stängda';
$hesklang['chg_all']='Ändra alla';
$hesklang['settings']='Inställningar';
$hesklang['settings_intro']='Använd detta verktyg för att konfigurera ditt ärendehanteringsprogram. För mer information om alla inställningar och alternativ klicka på Hjälp eller läs readme.html filen.';
$hesklang['all_req']='Alla fält (utom de som är inaktiverade) är obligatoriska!';
$hesklang['wbst_title']='Webbplatsens titel';
$hesklang['wbst_url']='Webbplatsens länk';
$hesklang['email_wm']='Huvudansvarigas e-post';
$hesklang['max_listings']='Listningar per sida.';
$hesklang['print_size']='Utskriftsstorlek';
$hesklang['debug_mode']='Felsökningsläge';
$hesklang['on']='PÅ';
$hesklang['off']='AV';
$hesklang['use_secimg']='Använd antispambild';
$hesklang['secimg_no']='Inte tillgänglig';
$hesklang['attach_use']='Använd bilagor';
$hesklang['attach_num']='Antal per post';
$hesklang['attach_type']='Tillåtna filtyper';
$hesklang['place_after']='Efter meddelandet';
$hesklang['place_before']='Före meddelandet';
$hesklang['custom_f']='Anpassade fält';
$hesklang['custom_u']='Använd det här fältet';
$hesklang['custom_n']='Fältnamn';
$hesklang['custom_l']='Maxlängd (tecken))';
$hesklang['db_host']='Databas host';
$hesklang['db_name']='Databasnamn';
$hesklang['db_user']='Databasanvändarnamn';
$hesklang['db_pass']='Databaslösenord';
$hesklang['err_sname']='Ange titel på din webbplats';
$hesklang['err_surl']='Ange din webbplats URL. Var noga med att det är en korrekt URL (börja med http:// eller https://)';
$hesklang['err_wmmail']='Ange en giltig mejladress för webbansvariges e-post';
$hesklang['err_nomail']='Vänligen skriv ett giltigt no reply-mejl';
$hesklang['err_htitle']='Ange titeln för din Helpdesk';
$hesklang['err_hurl']='Vänligen ange din Hesk-mapps URL-adress. Förvissa dig om att det är en giltig URL (börja med http:// eller https://)';
$hesklang['err_lang']='Vänligen välj Hesk-språk';
$hesklang['err_nolang']='Den specificerade språkfilen finns inte i språkmappen. Förvissa dig om att filen är uppladdad innan du ändrar språkinställning.';
$hesklang['err_max']='Ange maximala antalet uppgifter som visas per sida';
$hesklang['err_psize']='Ange utskriftsteckenstorlek';
$hesklang['err_dbhost']='Ange din MySQL-databas host';
$hesklang['err_dbname']='Ange ditt MySQL-databas namn';
$hesklang['err_dbuser']='Ange ditt MySQL-databas användarnamn';
$hesklang['err_dbpass']='Ange ditt MySQL-databas lösenord';
$hesklang['err_dbconn']='Kunde inte ansluta till MySQL-databasen med hjälp av lämnade uppgifter!';
$hesklang['err_dbsele']='Det gick inte att välja angiven MySQL-databas, vänligen dubbelkolla databasens namn';
$hesklang['err_custname']='ange namn på anpassat fält';
$hesklang['err_openset']='Kan inte öppna filen <b>hesk_settings.inc.php</b> för skrivning. Chmodda filen till 666 (rw-rw-rw-)';
$hesklang['set_saved']='Inställningar sparade';
$hesklang['set_were_saved']='Dina inställningar har framgångsrikt sparats.';
$hesklang['sec_img']='Säkerhetsbild';
$hesklang['sec_miss']='Ange säkerhetsnumret';
$hesklang['sec_wrng']='Fel säkerhetsnummer';
$hesklang['submit_problems']='Vänligen gå tillbaka och korrigera följande problem';
$hesklang['cat_order']='Kategoriordning';
$hesklang['reply_order']='Standardsvarsordning';
$hesklang['move_up']='Flytta upp';
$hesklang['move_dn']='Flytta ner';
$hesklang['cat_move_id']='Saknar kategori-ID';
$hesklang['reply_move_id']='Standardsvars-ID saknas';
$hesklang['forgot_tid']='Glömt ärendespårnings-ID';
$hesklang['tid_send']='Skicka mig mitt spårnings-ID';
$hesklang['tid_not_found']='Inga ärenden med din e-postadress hittades';
$hesklang['tid_sent']='Spårnings-ID skickat';
$hesklang['tid_sent2']='Ett e-postmeddelande med information om dina ärenden har skickats till din adress';
$hesklang['check_spambox']='Kontrollera att e-postmeddelandet inte finns i din skräppostmapp!';
$hesklang['reply_not_found']='Standardsvar hittades inte';
$hesklang['exists']='Finns';
$hesklang['no_exists']='Finns inte';
$hesklang['writable']='Skrivbar';
$hesklang['not_writable']='Inte skrivbar';
$hesklang['disabled']='inaktiverad';
$hesklang['e_settings']=' Du kommer inte att kunna spara dina inställningar, om inte den här filen är skrivbar via skriptet. Se Readme-filen för vidare instruktioner!';
$hesklang['e_attdir']='Du kommer inte att kunna använda funktionen bifoga filer om inte mappen Bilagor finns och är skrivbar via skriptet.';
$hesklang['e_save_settings']='Det går inte att spara dina inställningar eftersom filen <b>hesk_settings.inc.php</b> inte är skrivbar via skriptet.';
$hesklang['e_attach']='Inaktiverad eftersom  <b>attachments</b> katalogen inte är skrivbar via skriptet.';
$hesklang['go']='Gå';

// Added in version 2.0
$hesklang['v']='HESK version';
$hesklang['check_status']='Kontrollerar status';
$hesklang['sub_support']='Skapa ett supportärende';
$hesklang['open_ticket']='Skicka en ny fråga till en avdelning';
$hesklang['view_existing']='Granska existerande ärende';
$hesklang['vet']='Granska dina tidigare ärenden';
$hesklang['enter_user']='Vänligen ange ditt användarnamn';
$hesklang['remember_user']='Kom ihåg mitt användarnamn';
$hesklang['wrong_user']='Fel användarnamn';
$hesklang['no_permission']='Du har inte behörighet att utföra den här uppgiften, vänligen logga in med ett konto som har den behörigheten.';
$hesklang['tickets_on_pages']='Antal ärenden: %d | Antal sidor: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='Hoppa till sida:';
$hesklang['no_tickets_open']='Inga olösta ärenden hittades';
$hesklang['no_tickets_crit']='Inga ärenden matchade dina sökkriterier';
$hesklang['confirm_execute']='Är du säker på att du vill fortsätta?';
$hesklang['legend']='Beskrivning';
$hesklang['main_page']='Hem';
$hesklang['menu_users']='Användare';
$hesklang['menu_cat']='Kategorier';
$hesklang['menu_profile']='Profil';
$hesklang['menu_kb']='Kunskapsdatabas'; // Admin MENU item
$hesklang['kb_text']='Kunskapsdatabas'; // Item visible to customers
$hesklang['viewkb']='Se hela Kunskapsdatabasen';
$hesklang['kb']='Hantera kunskapsdatabasen';
$hesklang['kb_intro']='Kunskapsdatabasen är en samling svar på de vanligaste frågorna och artiklar som ger kunder möjlighet att själva lösa sina problem utan att behöva skicka in ett ärende.
En omfattande och välskriven kunskapsdatabas kan drastiskt minska antalet ärenden och spara värdefull tid. Du kan ordna artiklarna i kategorier och underkategorier.'; // Description in ADMIN panel
$hesklang['kb_is']='Kunskapsdatabasen är en samling utvalda artiklar och svar på de vanligaste frågorna till vår kundtjänst. Artiklarna är indelade i kategorier och underkategorier, du väljer därför enkelt själv vilka artiklar som intresserar dig'; // Description for CUSTOMERS
$hesklang['new_kb_art']=' Ny artikel i kunskapsdatabasen';
$hesklang['kb_cat']='Kategori';
$hesklang['kb_subject']='Ämne';
$hesklang['kb_content']='Innehåll';
$hesklang['kb_type']='Typ';
$hesklang['kb_published']='Publicerad';
$hesklang['kb_published2']='Artikeln kan läsas av alla.';
$hesklang['kb_private']='Privat';
$hesklang['kb_private2']='Privata artiklar kan endast läsas av personal.';
$hesklang['kb_draft']='Utkast';
$hesklang['kb_draft2']='Artikeln är sparad men inte publicerad än. Den kan endast läsas av personalen<br />som har behörighet att hantera artiklar i kunskapsdatabasen.';
$hesklang['kb_links']='<i><span class="notice"><b>Varning!</b></span><br />Ange giltig kod utan &lt;head&gt; och &lt;body&gt; taggar, bara innehåll!</i>';
$hesklang['kb_ehtml']='Detta är HTML-kod (jag kommer att skriva in giltig (X)HTML-kod)';
$hesklang['kb_dhtml']='Det här är ren text (länkar blir klickbara)';
$hesklang['kb_save']='Spara artikel';
$hesklang['kb_e_subj']='Ange artikelrubrik!';
$hesklang['kb_e_cont']='Ange artikelns innehåll!';
$hesklang['kb_art_added']='Artikel tillagd';
$hesklang['your_kb_added']='En ny kunskapsartikel har lagts till';
$hesklang['kb_art_deleted']='Artikel raderad';
$hesklang['your_kb_deleted']='Vald kunskapsartikel har framgångsrikt raderats';
$hesklang['kb_art_mod']='Artikel ändrad';
$hesklang['your_kb_mod']='Dina ändringar i den valda artikeln har framgångsrikt sparats';
$hesklang['kb_cat_new']='Ny kategori i kunskapsdatabasen';
$hesklang['kb_cat_parent']='Överordnad kategori';
$hesklang['kb_cat_sub']='Underkategorier';
$hesklang['kb_cat_title']='Kategorititel';
$hesklang['kb_cat_published']='Kategorin är synlig för alla i kunskapsdatabasen.';
$hesklang['kb_cat_private']='Kategorin kan endast läsas av personal.';
$hesklang['kb_cat_add']='Lägg till kategori';
$hesklang['kb_cat_e_title']='Ange kategorititel!';
$hesklang['kb_cat_added']='Kategori tillagd';
$hesklang['kb_cat_added2']='En ny kategori har lagts till i kunskapsdatabasen';
$hesklang['kb_cat_man']='Hantera kategori i kunskapsdatabasen';
$hesklang['kb_cat_edit']='Ändra kategoridetaljer';
$hesklang['kb_cat_inv']='Ogiltig kategori';
$hesklang['kb_cat_art']='Artiklar i denna kategori';
$hesklang['kb_p_art']='+ Artikel';
$hesklang['kb_p_art2']='Lägg till en ny artikel till den valda kategorin';
$hesklang['kb_add_art']='Lägg till artikel';
$hesklang['kb_p_cat']='+ Kategori';
$hesklang['kb_p_cat2']='Skapa en ny underkategori inom vald kategori.';
$hesklang['kb_add_cat']='Lägg till Kategori';
$hesklang['kb_p_man']='Hantera';
$hesklang['kb_p_man2']='hantera vald kategori (redigera, ta bort, hantera artiklar).';
$hesklang['kb_main']='Den överordnade kategorin i kunskapsdatabasen kan inte tas bort eller flyttas.';
$hesklang['kb_no_art']='Det finns inga artiklar i denna kategori.';
$hesklang['author']='Författare';
$hesklang['views']='Visningar';
$hesklang['delete']='Radera';
$hesklang['rating']='Betyg';
$hesklang['votes']='Röster';
$hesklang['kb_rated']='Artikeln betygsatt till %s/5.0';
$hesklang['kb_not_rated']='Artikeln är inte betygsatt än';
$hesklang['del_art']='Vill du verkligen ta bort den valda artikeln?';
$hesklang['kb_art_id']='ogiltigt artikel-ID!';
$hesklang['kb_art_edit']='Redigera artikeln';
$hesklang['revhist']='Versionshistorik';
$hesklang['revision1']='<li class="smaller">%s | inlämnad av %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | redigerad av %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Sortering';
$hesklang['kb_delcat']='Vill du verkligen radera den här kategorin?';
$hesklang['kb_cat_mod']='Kategori ändrad';
$hesklang['your_cat_mod']='Dina ändringar i den valda kategorin har framgångsrikt sparats';
$hesklang['kb_cat_del']='Kategori i kunskapsdatabasen raderad';
$hesklang['kb_cat_dlt']='Den valda kategorin i kunskapsdatabasen har raderats.';
$hesklang['allowed_cat']='Kategorier';
$hesklang['allow_feat']='Funktioner';
$hesklang['can_view_tickets']='Visa ärenden';
$hesklang['can_reply_tickets']='Besvara ärenden';
$hesklang['can_assign_tickets']='Tilldela ärenden';
$hesklang['can_del_tickets']='Radera ärenden';
$hesklang['can_edit_tickets']='Redigera ärendesvar';
$hesklang['can_change_cat']='Ändra ärendekategori (till vilken som helst)';
$hesklang['can_man_kb']='Hantera kunskapsdatabasen';
$hesklang['can_man_users']='Hantera användare';
$hesklang['can_man_cat']='Hantera kategorier';
$hesklang['can_man_canned']='Hantera standardsvar';
$hesklang['can_man_settings']='Hantera help desk inställningar';
$hesklang['can_del_notes']='Radera alla ärendenoteringar';
$hesklang['dan']='användare kan radera sina egna ärendenoteringar. Välj detta enbart om du vill ge den här användaren möjlighet att radera även andra användares ärendenoteringar.';
$hesklang['in_all_cat']='endast i tillåtna kategorier';
$hesklang['admin_can']='(tillgång till alla funktioner och kategorier)';
$hesklang['staff_can']='(Du kan begränsa funktioner och kategorier)';
$hesklang['asign_one_feat']='Vänligen tilldela den här användaren/denna användare minst en funktion!';
$hesklang['na_view_tickets']='Du får inte titta på några ärenden';
$hesklang['support_notice']='Detta avsnitt kan tyvärr endast döljas om du köper en Hesk licens!';
$hesklang['rart']='Var den här artikeln till hjälp?';
$hesklang['r']='Var detta svar till hjälp?';
$hesklang['tyr']='Tack för att du betygsatt';
$hesklang['cw']='Stäng fönster';
$hesklang['cw2']='Stäng fönstret och skicka in ärendet';
$hesklang['rh']='Bedömt som <i>hjälpsam</i>';
$hesklang['rnh']='Bedömt som <i>ohjälpsam</i>';
$hesklang['ar']='Redan betygsatt';
$hesklang['rated']='Användaren betygsatt som %s/5.0 av (%s röster)';
$hesklang['not_rated']='Användaren är ej betygsatt än';
$hesklang['rdis']='Betygsättningsfunktionen har avaktiverats';
$hesklang['kbdis']='Kunskapsdatabasen är avstängd';
$hesklang['kbpart']='Tyvärr har du inte behörighet att läsa den här artikeln';
$hesklang['popart']='Populäraste kb-artiklarna:';
$hesklang['latart']='Senaste kb-artiklarna:';
$hesklang['m']='Fler ämnen';
$hesklang['ac']='Artiklar i denna kategori:';
$hesklang['noa']='Inga artiklar ännu';
$hesklang['noac']='Inga artiklar ännu i denna kategori';
$hesklang['dta']='Tillagd den';
$hesklang['ad']='Artikeldetaljer';
$hesklang['aid']='Artikel-ID';
$hesklang['as']='Lösning';
$hesklang['search']='Sök';
$hesklang['sr']='Sökresultat';
$hesklang['nosr']='Inga matchande artiklar hittade. Prova att söka i kunskapsdatabasen eller skicka in ett nytt supportärende.';
$hesklang['rv']='Återställ visningar';
$hesklang['rr']='Återställ röstningar (betyg)';
$hesklang['opt']='Alternativ';
$hesklang['delcat']='Radera kategori';
$hesklang['move1']='Flytta artiklar till överordnad kategori';
$hesklang['move2']='Radera artiklar i den här kategorin';
$hesklang['sc']='Föreslagna kb-artiklar';
$hesklang['not']='Ärenden'; // Number of all tickets in category
$hesklang['graph']='Diagram';
$hesklang['lu']='Lista användarnamn';
$hesklang['aclose']='Stäng ärenden automatiskt';
$hesklang['aclose2']='dagar efter senaste personalsvar';
$hesklang['s_ucrt']='återöppna ärenden';
$hesklang['urate']='Svarsbetyg';
$hesklang['hesk_url']='Helpdesk LÄNK';
$hesklang['hesk_title']='Helpdesk titel';
$hesklang['cid']='ärende spårnings-ID';
$hesklang['tfor']='Tidsformat';
$hesklang['prefix']='tabellprefix';
$hesklang['s_ekb']='Aktivera kunskapsdatabasen';
$hesklang['s_kbs']='Aktivera KB sök';
$hesklang['s_kbr']='Aktivera KB betyg';
$hesklang['s_maxsr']='Max sökresultat';
$hesklang['s_suggest']='Föreslå KB-artiklar';
$hesklang['s_spop']='Visa populära artiklar';
$hesklang['s_slat']='Visa senaste artiklar';
$hesklang['s_onin']='på <a href="../" target="_blank">helpdesk index</a> sida';
$hesklang['s_onkb']='på <a href="../knowledgebase.php" target="_blank">Kunskapsdatabas index</a> sida';
$hesklang['s_scol']='Kategorier i rad';
$hesklang['s_ptxt']='Artikelns förhandsvisningslängd';
$hesklang['s_psubart']='Artiklar i underkategori';
$hesklang['enable']='Aktivera';
$hesklang['s_type']='Typ';
$hesklang['custom_r']='Krävs';
$hesklang['custom_place']='Plats';
$hesklang['custom_use']='Anpassade fält';
$hesklang['stf']='Textfält';
$hesklang['stb']='Stor textruta';
$hesklang['srb']='Alternativknapp';
$hesklang['ssb']='rullgardinslist';
$hesklang['db']='Databas';
$hesklang['hd']='Helpdesk Inställningar';
$hesklang['gs']='Allmänna inställningar';
$hesklang['cwin']='Stäng fönster';
$hesklang['defw']='Standardvärde';
$hesklang['ok']='OK';
$hesklang['ns']='De här inställningsvalen är tillgängliga för detta anpassade fält. För att spara ändringarna, klicka på <b>OK</b> och knappen <b>Spara ändringar</b> i Inställningar på adminsidan!';
$hesklang['rows']='Rader (höjd)';
$hesklang['cols']='Kolumner (bredd)';
$hesklang['opt2']='Val för denna alternativknapp, ange ett val per rad (varje rad kommer att skapa ett nytt alternativvärde att välja). Du måste ange minst två val!';
$hesklang['opt3']='Val för denna listruta, ange ett val per rad (varje rad blir då ett val dina kunder kan göra). Du måste ange minst två val!';
$hesklang['atl2']='Ange minst två alternativ (ett per rad)!';
$hesklang['notes']='Noteringar';
$hesklang['addnote']='+ Lägg till notering';
$hesklang['noteby']='Notering av';
$hesklang['delnote']='Radera notering';
$hesklang['noteerr']='Noteringen är redan raderad eller innehåller felaktiga parametrar';
$hesklang['s']='Skicka';
$hesklang['nhid']='Noteringar är dolda för kunderna!';
$hesklang['delt']='Ta bort detta inlägg';
$hesklang['edtt']='Redigera inlägg';
$hesklang['edt1']='Inlägg ändrat';
$hesklang['edt2']='Ändringar i valt inlägg har sparats';
$hesklang['dele']='Ta bort detta ärende';
$hesklang['repd']='Inlägg raderat';
$hesklang['repl']='Valt inlägg har raderats';
$hesklang['tickets_found']='Sökresultat';
$hesklang['al']='Admin-länk';
$hesklang['ap']='Gå till Administrationspanelen';
$hesklang['dap']='Visa en länk till adminpanelen från <a href="../" target="_blank">helpdesk index</a>';
$hesklang['q_miss']='Vänligen besvara anti-spam frågan';
$hesklang['use_q']='Använd anti-spam fråga';
$hesklang['q_q']='-&gt; Fråga (HTML-kod är <font class="success">tillåtet</font>)';
$hesklang['q_a']='-&gt; Svar';
$hesklang['err_qask']='Skriv en anti-spam fråga';
$hesklang['err_qans']='Skriv svaret på anti-spam frågan';
$hesklang['genq']='Generera en slumpmässig fråga';

// Added in version 2.1
$hesklang['amo']='Lägg till mer';
$hesklang['delatt']='Vill du radera vald bilaga?';
$hesklang['kb_att_rem']='Vald bilaga har tagits bort';
$hesklang['inv_att_id']='Ogiltigt bilage-ID!';
$hesklang['scb']='Kontrollruta';
$hesklang['opt4']='Alternativ för den här kontrollrutan, ange ett alternativ per rad. Varje rad kommer att skapa ett nytt alternativ som dina kunder kan välja, flera alternativ är möjliga.';
$hesklang['autologin']='Logga in mig automatiskt vid varje besök';
$hesklang['just_user']='Kom endast ihåg mitt användarnamn';
$hesklang['nothx']='Nej, tack';
$hesklang['pinfo']='Profilinformation';
$hesklang['sig']='Signatur';
$hesklang['pref']='Inställningar';
$hesklang['aftrep']='Efter att man har svarat på ett ärende';
$hesklang['showtic']='Visa ärendet som nyss blev besvarat';
$hesklang['gomain']='Gå tillbaka till admin-sidan';
$hesklang['shownext']='Öppna nästa ärende som behöver besvaras';
$hesklang['rssn']='Visar nästa ärende som behöver din uppmärksamhet';
$hesklang['mrep']='Ersätt meddelande';
$hesklang['madd']='Lägg till längst ner';
$hesklang['priv']='Privata kategorier och artiklar som är synliga enbart för personal är markerade med *';
$hesklang['inve']='giltig e-postfil';
$hesklang['emfm']='E-postfil saknas';
$hesklang['hesk_lang']='Standardspråk';
$hesklang['s_mlang']='Flera språk';
$hesklang['s_mlange']='Aktivera endast om du ger support på alla installerade språk!';
$hesklang['s_inl']='Testa språkmapp';
$hesklang['s_inle']='Testar språkmappen för giltiga språk. Endast språk som klarar alla tester är korrekt installerade.';
$hesklang['ta']='Testa igen';
$hesklang['alo']='Tillåt automatisk inloggning';
$hesklang['chol']='Önskat språk';
$hesklang['mmdl']='Gör detta till mitt önskade språk';
$hesklang['warn']='VARNING';
$hesklang['dmod']='Felsökningsläget är aktiverat. Avaktivera felsökningsläget i Inställningar, när HESK har installerats och fungerar korrekt.';
$hesklang['kb_spar']='En kategori kan inte vara sin egen överordnade kategori!';
$hesklang['mysql_root']='Ditt MySQL lösenord är tomt, är du säker på att du vill logga in med root-användaren? Detta är en betydande säkerhetsrisk!';
$hesklang['chg']='Ändra';
$hesklang['chpri']='Prioritet ändrad';
$hesklang['chpri2']='Ärendets prioritet har ändrats till %s';
$hesklang['selcan']='Välj det standardsvar som du vill redigera';
$hesklang['q_wrng']='Fel anti-SPAM svar';
$hesklang['cndupl']='Du har redan en kategori med det namnet. Välj ett unikt namn för varje kategori!';
$hesklang['wsel']='Välj det fält du vill söka efter';

// Added in version 2.2
$hesklang['eto']='Ogiltig begäran';
$hesklang['id']='ID';
$hesklang['geco']='Generera Direktlänk';
$hesklang['genl']='Direkt kategorilänk';
$hesklang['genl2']='Använd denna länk för att förvälja kategori i &quot;Skicka ärende&quot; formuläret.';
$hesklang['ask']='Sök hjälp:';
$hesklang['exa']='Exempel';
$hesklang['small']='liten Box';
$hesklang['large']='stor Box';
$hesklang['cpri']='Kundprioritet';
$hesklang['owner']='Ägare';
$hesklang['unas']='Otilldelad';
$hesklang['assi']='Tilldela';
$hesklang['asst']='Tilldela till';
$hesklang['asst2']='Tilldela detta ärende till';
$hesklang['asss']='Tilldela till sig själv';
$hesklang['asss2']='Tilldela detta ärende till mig själv';
$hesklang['can_assign_self']='Kan tilldela ärenden till sig själv';
$hesklang['can_assign_others']='Kan tilldela ärenden till andra';
$hesklang['can_run_reports']='Kan köra rapporter (egna)';
$hesklang['can_view_ass_others']='Kan se ärenden tilldelade till andra';
$hesklang['unoa']='Vald användare har inte åtkomst till denna kategori';
$hesklang['tasi']='Ägartilldelad';
$hesklang['tasy']='Detta ärende har tilldelats dig';
$hesklang['taso']='Detta ärende har tilldelats vald användare';
$hesklang['tasy2']='Tilldelad till mig själv';
$hesklang['taso2']='Tilldelat till annan personal';
$hesklang['nose']='Välj den nya Ägaren';
$hesklang['onasc']='Denna ägare har inte åtkomst till den valda kategorin.';
$hesklang['tunasi']='Ärendet är inte tilldelat någon.';
$hesklang['tunasi2']='Ärendet saknar ägare och är färdigt att tilldelas igen';
$hesklang['note']='Notering';
$hesklang['success']='Success';
$hesklang['nyt']='Detta ärende har tilldelats till';
$hesklang['noch']='Inga ändringar har gjorts';
$hesklang['orch']='Visningsordningen har ändrats';
$hesklang['rfm']='Obligatoriska uppgifter saknas:';
$hesklang['repl0']='Otillräckliga behörigheter för att utföra denna uppgift';
$hesklang['repl1']='Detta inlägg saknas';
$hesklang['reports']='Rapporter';
$hesklang['reports_intro']='Rapportsektionen låter dig köra flera rapporter och se ärendestatistiken i ett valt datumintervall.';
$hesklang['refi']='Återställ formulärdata';
$hesklang['dich']='Ignorera ändringar';
$hesklang['dire']='Visa rapport';
$hesklang['m1']='januari';
$hesklang['m2']='februari';
$hesklang['m3']='mars';
$hesklang['m4']='april';
$hesklang['m5']='maj';
$hesklang['m6']='juni';
$hesklang['m7']='juli';
$hesklang['m8']='augusti';
$hesklang['m9']='september';
$hesklang['m10']='oktober';
$hesklang['m11']='november';
$hesklang['m12']='december';
$hesklang['d1']='måndag';
$hesklang['d2']='tisdag';
$hesklang['d3']='onsdag';
$hesklang['d4']='torsdag';
$hesklang['d5']='fredag';
$hesklang['d6']='lördag';
$hesklang['d0']='söndag';
$hesklang['mo']='Må';
$hesklang['tu']='Ti';
$hesklang['we']='On';
$hesklang['th']='To';
$hesklang['fr']='Fre';
$hesklang['sa']='Lö';
$hesklang['su']='Sö';
$hesklang['from']='Från';
$hesklang['cinv']='Ogiltigt datum';
$hesklang['cinv2']='Accepterat format är mm/dd/yyyy';
$hesklang['cinm']='Ogiltig månad';
$hesklang['cinm2']='Tillåten period är';
$hesklang['cind']='Ogiltig dag i månaden';
$hesklang['cind2']='Tillåtet datumintervall för vald månad är';
$hesklang['month']='Månad';
$hesklang['ocal']='Öppna Kalender';
$hesklang['ca01']='Föregående år';
$hesklang['ca02']='Föregående månad';
$hesklang['ca03']='Nästa månad';
$hesklang['ca04']='Nästa år';
$hesklang['ca05']='Stäng Kalender';
$hesklang['cdr']='Välj datumintervall:';
$hesklang['crt']='Rapporttyp';
$hesklang['r1']='Idag';
$hesklang['r2']='Igår';
$hesklang['r3']='Den här månaden';
$hesklang['r4']='Förra månaden';
$hesklang['r5']='Senaste 30 dagarna';
$hesklang['r6']='Den här veckan (mån-sön)';
$hesklang['r7']='Förra veckan (mån-sön)';
$hesklang['r8']='Den här verksamhetsveckan (Mån-Fre)';
$hesklang['r9']='Förra verksamhetsveckan (Mån-Fre)';
$hesklang['r10']='Detta år';
$hesklang['r11']='Förra året';
$hesklang['r12']='Alla tider';
$hesklang['datetofrom']='&quot;Datum Från&quot; får inte vara senare än &quot;Datum till&quot;. Datumen har bytt plats med varandra.';
$hesklang['t1']='Ärenden per dag';
$hesklang['t2']='Ärenden per månad';
$hesklang['t3']='Ärenden per användare';
$hesklang['t4']='Ärenden per kategori';
$hesklang['ticass']='Tilldelade ärenden';
$hesklang['ticall']='Besvarade ärenden';
$hesklang['totals']='Totalt';
$hesklang['all']='Alla';
$hesklang['atik']='Nya ärenden';
$hesklang['kbca']='Du har redan en kategori i kunskapsdatabasen med detta namn.';
$hesklang['menu_msg']='E-post';
$hesklang['menu_can']='Standardsvar';
$hesklang['m_from']='Från:'; // Mail "from" address
$hesklang['m_to']='Till:'; // Mail "to" address
$hesklang['m_sub']='Ämne:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Privata meddelanden';
$hesklang['m_intro']='Använd privata meddelanden för att skicka snabbmeddelanden till andra handläggare inom HESK.';
$hesklang['e_udel']='(Användare raderad)';
$hesklang['new_mail']='Nytt privat meddelande';
$hesklang['m_send']='Skicka meddelande';
$hesklang['m_rec']='Välj meddelandemottagare';
$hesklang['m_inr']='Ogiltig meddelandemottagare';
$hesklang['m_esu']='Ange personligt meddelandeämne';
$hesklang['m_pms']='Ditt privata meddelande har skickats';
$hesklang['inbox']='INKORG';
$hesklang['outbox']='UTKORG';
$hesklang['m_new']='NYTT MEDDELANDE';
$hesklang['pg']='Visa sida';
$hesklang['npm']='Inga privata meddelanden i denna mapp';
$hesklang['m_ena']='Du har inte behörighet att läsa detta meddelande';
$hesklang['mau']='Markera som oläst';
$hesklang['mo1']='Markera valda meddelanden som lästa';
$hesklang['mo2']='Markera valda meddelanden som olästa';
$hesklang['mo3']='Radera valda meddelanden';
$hesklang['delm']='Radera detta meddelande';
$hesklang['e_tid']='Ett fel uppstod då ett unikt ärende-ID skulle genereras. Försök skicka formuläret igen senare';
$hesklang['smmr']='Valda meddelanden har markerats som lästa';
$hesklang['smmu']='Valda meddelanden har markerats som olästa';
$hesklang['smdl']='Valda meddelanden har raderats';
$hesklang['show']='Visa';
$hesklang['s_my']='Tilldelat mig';
$hesklang['s_ot']='Tilldelat andra';
$hesklang['s_un']='Ej tilldelade ärenden';
$hesklang['s_for']='Sök efter';
$hesklang['s_in']='Sök i';
$hesklang['s_incl']='Sök inom';
$hesklang['find_ticket_by']='Hitta ett ärende';
$hesklang['e_nose']='Ingen tilldelningsstatus vald, visar alla ärenden.';
$hesklang['fsq']='Ange din sökfråga';
$hesklang['topen']='Öppna';
$hesklang['nms']='Inga meddelanden valda, inget att ändra';
$hesklang['tlo']='Lås ärende';
$hesklang['tul']='Lås upp ärende';
$hesklang['loc']='Låst';
$hesklang['isloc']='Kunder kan inte svara på eller återöppna låsta ärenden. När ett ärende är låst, är det markerat som löst.';
$hesklang['tlock']='Ärendet har låsts';
$hesklang['tunlock']='Ärendet har öppnats igen';
$hesklang['tislock']='Detta ärende har låsts så kunden kommer inte att kunna posta ett svar';
$hesklang['tislock2']='Det här ärendet har låsts. Du kan inte besvara låsta ärenden.';
$hesklang['nsfo']='Inga relevanta artiklar hittades.';
$hesklang['thist1']='<li class="smaller">%s | flyttat till kategori %s av %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | tilldelat %s av %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | stängt av %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | öppnat av %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | Låst av %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | Upplåst av %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | ärendet skapat av %s</li>'; // %s = date, user making change
$hesklang['elocked']='Det här ärendet har låsts eller raderats';
$hesklang['nti2']='Lägg in ett nytt ärende';
$hesklang['nti3']='Använd detta formulär för att skapa ett nytt ärende i en kunds namn. Ange <i>kund</i>information i formuläret (kundens namn, kundens e-postadress,...) och INTE ditt namn! Ett ärende kommer att skapas som om det vore kunden som hade skickat det.';
$hesklang['addop']='Valmöjligheter';
$hesklang['seno']='Skicka e-postmeddelande till kunden';
$hesklang['otas']='Visa ärendet efter att det har skickats';
$hesklang['notn']='Notifieringar';
$hesklang['nomw']='Helpdesken skickar ett e-postmeddelande när:';
$hesklang['nwts']='Ett nytt ärende med ägare har skickats:';
$hesklang['ncrt']='Kund svarar på ett ärende med ägare';
$hesklang['ntam']='Ett ärende tilldelas mig';
$hesklang['npms']='Ett privat meddelande skickats till mig';
$hesklang['support_remove']='Det ligger en massa tid och jobb bakom utvecklandet av HESK. Stöd HESK, köp en licens som också kommer att ta bort referallänken <i>Powered by Help Desk Software HESK</i> från din helpdesk';
$hesklang['ycvtao']='Du har inte tillåtelse att se ärenden som är tilldelade andra.';
$hesklang['password_not_valid']=' Lösenordet måste vara minst 5 tecken långt';
$hesklang['lkbs']='Laddar förslag från kunskapsdatabasen...';
$hesklang['auto']='(automatiskt)';

// Added in version 2.3
$hesklang['unknown']='Okänd';
$hesklang['pcer']='Vänligen korrigera följande fel:';
$hesklang['seqid']='Ärendenummer';
$hesklang['close_action']='Markera som löst'; // Close ACTION
$hesklang['archived']='Taggat';
$hesklang['archived2']='Taggat ärende';
$hesklang['add_archive']='Tagga detta ärende';
$hesklang['add_archive_quick']='Tagga valda ärenden';
$hesklang['remove_archive']='Avtagga det här ärendet';
$hesklang['remove_archive_quick']='Avtagga valda ärenden';
$hesklang['added_archive']='Ärendet är Taggat';
$hesklang['removed_archive']='Ärendet är Avtaggat';
$hesklang['added2archive']='Ärendet har taggats';
$hesklang['removedfromarchive']='Ärendet har avtaggats';
$hesklang['num_tickets_tag']='<b>%d</b> ärenden har taggats';
$hesklang['num_tickets_untag']='<b>%d</b> ärenden har avtaggats';
$hesklang['can_add_archive']='Kan tagga ärenden';
$hesklang['disp_only_archived']='Endast taggade ärenden';
$hesklang['search_only_archived']='Endast taggade ärenden';
$hesklang['critical']=' * Kritiskt * ';
$hesklang['thist8']='<li class="smaller">%s | prioritet ändrad till %s av %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | status ändrad till %s av %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | automatiskt tilldelat %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | Skickats med e-post piping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='&aring;';
$hesklang['abbr']['month']='m&aring;';
$hesklang['abbr']['week']='v';
$hesklang['abbr']['day']='d';
$hesklang['abbr']['hour']='t';
$hesklang['abbr']['minute']='m';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='Kunde inte skicka meddelandet till:';
$hesklang['yhbb']='Du har blivit utelåst från systemet i %s minuter p.g.a. för många misslyckade inloggningar';
$hesklang['pwdst']='Lösenordsstyrka';
$hesklang['tid_mail']='Ingen fara. Skriv in din <b>E-postadress</b> så skickar vi dig omedelbart ditt spårnings-ID:';
$hesklang['rem_email']='Kom ihåg min e-postadress';
$hesklang['eytid']='Skriv ditt ärendes spårnings-ID.';
$hesklang['enmdb']='Den e-postadress du angett matchar inte den angivna adressen i databasen för detta ärende-ID.';
$hesklang['confemail']='Bekräfta e-postadressen';
$hesklang['confemail2']='Vänligen bekräfta din e-postadress';
$hesklang['confemaile']='De två e-postadresserna är inte identiska';
$hesklang['taso3']='Tilldelad till:';
$hesklang['sec_enter']='Skriv in siffrorna som du ser i bilden nedan.';
$hesklang['reload']='Ladda om bild.';
$hesklang['verify_q']='Spamskydd:'; // For anti-spam question
$hesklang['verify_i']='Spamskydd:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Personal-inloggning';
$hesklang['vrfy']='Du klarade testet';
$hesklang['last_update']='Uppdaterad';
$hesklang['cot']='Bumpa inte kritiska ärenden';
$hesklang['def']='Gör detta till min standardvy';
$hesklang['gbou']='Dessa ärenden är <b>Icke tilldelade</b>:';
$hesklang['gbom']='Ärenden tilldelade <b>mig</b>:';
$hesklang['gboo']='Ärenden tilldelade <b>%s</b>:';
$hesklang['select']=' - - Klicka för att Välja - - ';
$hesklang['chngstatus']='Ändra status till:';
$hesklang['perat']='%s av alla ärenden'; // Will change to "23% of all tickets"
$hesklang['viewart']='Se denna artikel';
$hesklang['chdp']='Vänligen byt standardlösenord på din <a href="profile.php">profil</a> sida!';
$hesklang['chdp2']='Ändra ditt lösenord, du använder det förvalda!';
$hesklang['security']='Säkerhet';
$hesklang['kb_i_art']='Ny Artikel';
$hesklang['kb_i_art2']='Infoga en artikel';
$hesklang['kb_i_cat']='Ny Kategori';
$hesklang['kb_i_cat2']='Infoga en kategori';
$hesklang['gopr']='Visa kunskapsdatabas';
$hesklang['kbstruct']='Kunskapsdatabas-struktur';
$hesklang['cancel']='Avbryt';
$hesklang['sh']='Göm Meddelande';
$hesklang['goodkb']='Hur man skriver bra KB-artiklar';
$hesklang['catset']='Kategori Inställningar';
$hesklang['inpr']='Välj ny prioritet';
$hesklang['incat']='Välj den nya kategorin';
$hesklang['instat']='Välj den nya statusen';
$hesklang['tsst']='Ärendestatus har ändrats till: %s';
$hesklang['aass']='Auto-tilldela';
$hesklang['aaon']='Auto-tilldelning av ärenden är aktiverad (klicka för att avaktivera)';
$hesklang['aaoff']='Auto-tilldelning av ärenden är avaktiverad (klicka för att aktivera)';
$hesklang['uaaon']='Auto-tilldelning har aktiverats för vald användare';
$hesklang['uaaoff']='Auto-tilldelning har inaktiverats för vald användare';
$hesklang['taasy']='Detta ärende har auto-tilldelats dig';
$hesklang['can_view_unassigned']='Kan titta på icke tilldelade ärenden';
$hesklang['ycovtay']='Du kan bara titta på ärenden tilldelade dig själv.';
$hesklang['in_progress']='Pågående';
$hesklang['on_hold']='Väntar på hantering';
$hesklang['import_kb']='Importera detta ärende till en KB-artikel';
$hesklang['import']='Du importerar ett <i>privat ärende</i> till en <i>publik artikel</i>.<br /><br />Se till att du tar bort all privat eller känslig information från artikelns ämne och meddelande!';
$hesklang['tab_1']='Allmänt';
$hesklang['tab_2']='HelpDesk';
$hesklang['tab_3']='Kunskapsdatabas';
$hesklang['tab_4']='Anpassade fält';
$hesklang['tab_5']='Diverse';
$hesklang['disable']='Inaktivera';
$hesklang['dat']='Datum &amp; Tid';
$hesklang['lgs']='Språk';
$hesklang['onc']='PÅ - Kunder';
$hesklang['ons']='PÅ - Alla';
$hesklang['viewvtic']='Visa ärenden';
$hesklang['reqetv']='Kräv e-post för att titta på ett ärende';
$hesklang['banlim']='Gräns för inloggningsförsök';
$hesklang['banmin']='Bannlysningstid (minuter)';
$hesklang['subnot']='Skicka notifiering';
$hesklang['subnot2']='Visa notifiering för kunder som skickar in ärenden';
$hesklang['eseqid']='Sekventiella ID-nummer';
$hesklang['sconfe']='Bekräfta e-post';
$hesklang['saass']='Tilldela ärenden automatiskt';
$hesklang['swyse']='WYSIWYG Redigerare';
$hesklang['hrts']='Betygsätt HESK';
$hesklang['hrts2']='Visa länken Betygsätt detta skript i adminpanelen';
$hesklang['emlpipe']='Pipar mejlet';
$hesklang['emlsend2']='Skicka mejlen och använd';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Server';
$hesklang['smtph']='SMTP Host';
$hesklang['smtpp']='SMTP Port';
$hesklang['smtpu']='SMTP Användarnamn';
$hesklang['smtpw']='SMTP Lösenord';
$hesklang['smtpt']='SMTP Timeout';
$hesklang['other']='Annan';
$hesklang['features']='Funktioner';
$hesklang['can_view_online']='Kan se inloggad personal';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Inloggade användare'; // For display in footer
$hesklang['sonline']='Inloggade användare'; // For settings page
$hesklang['sonline2']='Visa inloggade användare. Begränsning (minuter):'; // For settings page
$hesklang['gb']='Gruppera efter';
$hesklang['dg']='Gruppera inte';
$hesklang['err_dpi']='Databasen %s innehåller inte alla HESK-tabeller med prefix %s, inga ändringar sparades.';
$hesklang['err_dpi2']='Tabellerna hittades inte:';
$hesklang['sme']='SMTP-fel';
$hesklang['scl']='SMTP anslutningslogg';
$hesklang['dnl']='Ladda ner';
$hesklang['dela']='Ta bort denna bilaga';
$hesklang['pda']='Vill du ta bort den här bilagan permanent?';
$hesklang['thist12']='<li class="smaller">%s | bilagan %s raderad av %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Fler alternativ';
$hesklang['lopt']='Färre alternativ';
$hesklang['meml']='Flera e-postadresser';
$hesklang['meml2']='Tillåt kunder att använda mer än en e-postadress';

// Added in version 2.4
$hesklang['catd']='(Kategorin togs bort)';
$hesklang['noopen']='Inga öppna ärenden hittades för denna e-postadress.';
$hesklang['maxopen']='Du har nått maximala antalet öppna ärenden (%d av %d). Var god vänta tills ärendena har lösts innan du öppnar nya ärenden.';
$hesklang['ntnote']='Någon lägger till en anmärkning i ett ärende som tilldelats mig';
$hesklang['cat_public']='Den här kategorin är OFFENTLIG (klicka för att göra den privat)';
$hesklang['cat_private']='Den här kategorin är PRIVAT (klicka för att göra den offentlig)';
$hesklang['cat_aa']='Autotilldela ärenden i denna kategori.';
$hesklang['cat_type']='Gör denna kategorin privat (Endast personal kan välja den).';
$hesklang['caaon']='Autotilldelning har aktiverats för vald kategori';
$hesklang['caaoff']='Autotilldelning har avaktiverats för vald kategori';
$hesklang['cpub']='Kategorityp ändrades till OFFENTLIG';
$hesklang['cpriv']='Kategorityp ändrades till PRIVAT';
$hesklang['cpric']='Kunder kan inte välja privata kategorier. Endast personal kan göra det! ';
$hesklang['user_aa']='Autotilldela ärenden till denna användare.';
$hesklang['attach_size']='Maximal filstorlek';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='SSL Protokoll';
$hesklang['smtptls']='TLS Protokoll';
$hesklang['oo']='Lista endast öppna ärenden';
$hesklang['ool']='Lista endast öppna ärenden i &quot;Glömt spårnings-ID&quot; e-post';
$hesklang['mop']='Maximalt antal öppna ärenden';
$hesklang['rord']='Svarsordning';
$hesklang['newbot']='Nyaste svaret längst ner';
$hesklang['newtop']='Nyaste svaret högst upp';
$hesklang['ford']='Svarsformulär';
$hesklang['formbot']='Visa formuläret längst ner';
$hesklang['formtop']='Visa formuläret högst upp';
$hesklang['mysqlv']='MySQL version';
$hesklang['phpv']='PHP version';
$hesklang['csrt']='Aktuell HESK-tid:';
$hesklang['listp']='Lista privata artiklar';
$hesklang['listd']='Lista artikelutkast';
$hesklang['artp']='Privata artiklar';
$hesklang['artd']='Artikelutkast';
$hesklang['kb_no_part']='Inga privata artiklar i kunskapsdatabasen.';
$hesklang['kb_no_dart']='Inga artikelutkast i kunskapsdatabasen.';
$hesklang['attpri']='Du har inte tillgång till denna bilaga.';
$hesklang['can_merge_tickets']='Slå ihop ärenden';
$hesklang['mer_selected']='Slå ihop valda ärenden';
$hesklang['merged']='Valda ärenden har sammanfogats till ett.';
$hesklang['merge_err']='Ett problem uppstod vid sammanfogningen av ärendena:';
$hesklang['merr1']='Välj minst två ärenden.';
$hesklang['merr2']='Målärendet hittades inte.';
$hesklang['merr3']='Ärende i en kategori du inte har åtkomst till.';
$hesklang['tme']='Ärende %s har sammanfogats med detta ärende (%s).';
$hesklang['tme1']='Ärende %s har sammanfogats med ärende (%s)';
$hesklang['tme2']='För att få åtkomst till ärende %s skriv in associerad e-postadress.';
$hesklang['eyou']='Använd profilsidan för att redigera dina inställningar.';
$hesklang['npea']='Du har inte behörighet att redigera den här användaren.';
$hesklang['duplicate_user']='En användare med detta användarnamn finns redan, välj ett annat användarnamn.';
$hesklang['kw']='Nyckelord';
$hesklang['kw1']='valfritt - separera med mellanslag, komma eller ny rad)';
$hesklang['type_not_allowed']='Filer som slutar med <b>%s</b> är inte tillåtna (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Kunden har inte läst det här svaret än.';
$hesklang['sticky']='Gör den här artikeln &quot;Fastnålad&quot;';
$hesklang['stickyon']='Ändra artikeln till &quot;Fastnålad&quot;';
$hesklang['stickyoff']='Ändra artikeln till &quot;Normal&quot;';
$hesklang['ason']='Artikeln markerad som &quot;Fastnålad&quot;';
$hesklang['asoff']='Artikeln markerad som &quot;Normal&quot;';
$hesklang['ts']='Nedlagd tid';
$hesklang['start']='Start / Stopp';
$hesklang['reset']='Nollställ';
$hesklang['save']='Spara';
$hesklang['hh']='Timmar';
$hesklang['mm']='Minuter';
$hesklang['ss']='Sekunder';
$hesklang['thist']='Ärendehistorik';
$hesklang['thist13']='<li class="smaller">%s | Sammanfogat med ärende %s av %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | arbetad tid uppdaterad till %s av %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | inlämnat av %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | skickat via POP3 hämtning</li>';
$hesklang['twu']='Nedlagd tid på ärendet har uppdaterats.';
$hesklang['autoss']='Starta timer automatiskt när jag öppnar ett ärende';
$hesklang['ful']='Filuppladdningsgränser';
$hesklang['ufl']='Du får ladda upp filer som slutar med:';
$hesklang['nat']='Maximalt antal bilagor:';
$hesklang['mfs']='Maximal storlek per bilaga:';
$hesklang['lps']='Din språkinställning har sparats';
$hesklang['sav']='Visa artikelvisningar';
$hesklang['sad']='Visa artikeldatum';
$hesklang['emp']='Din PHP har inte stöd för MySQL aktiverat (mysqli-tillägg krävs)';
$hesklang['epd']='[HESK] E-POST PIPNING ÄR AVAKTIVERAD I INSTÄLLNINGARNA';
$hesklang['pfd']='[HESK] POP3-HÄMTNING ÄR AVAKTIVERAD I INSTÄLLNINGARNA';
$hesklang['pem']='[Pipad e-post]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Kund]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-post';
$hesklang['pop3']='POP3-hämtning';
$hesklang['pop3h']='POP3 Host';
$hesklang['pop3p']='POP3 Port';
$hesklang['pop3tls']='TLS-protokoll';
$hesklang['pop3u']='Användarnamn';
$hesklang['pop3w']='Lösenord';
$hesklang['pop3e']='POP3-fel';
$hesklang['pop3log']='POP3 anslutningslogg';
$hesklang['mysqltest']='Testa MySQL anslutning';
$hesklang['smtptest']='Testa SMTP anslutning';
$hesklang['pop3test']='Testa POP3 anslutning';
$hesklang['contest']='Testar anslutning, detta kan ta en liten stund...';
$hesklang['conok']='Anslutning fungerar!';
$hesklang['conokn']='Om din server kräver användarnamn och lösenord kommer e-post inte att skickas!';
$hesklang['saving']='Sparar inställningar, var god vänta...';
$hesklang['sns']='Inställningarna sparades, men några funktioner avaktiverades på grund av misslyckade tester.';
$hesklang['looph']='Maximalt antal träffar';
$hesklang['loopt']='Tidsram';
$hesklang['didum']='Menade du %s'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Ja, fixa det';
$hesklang['nole']='Nej! Låt det vara som det är';
$hesklang['sconfe2']='Visa ett &quot;Bekräfta e-post&quot; fält på Skapa ärende formuläret';
$hesklang['oln']='Gammalt namn:';
$hesklang['nen']='Nytt namn:';
$hesklang['use_form_below']='Vänligen ange så mycket relevant information som möjligt när du begär support.';
$hesklang['esf']='Kunde inte skicka e-postnotifieringar.';
$hesklang['qrr']='(citatsvar togs bort)';
$hesklang['remqr']='Plocka bort citatsvar';
$hesklang['remqr2']='Radera citatsvar från kundmejlen';
$hesklang['suge']='Spåra stavfel i e-posten';
$hesklang['epro']='E-postleverantörer';
$hesklang['email_noreply']='&quot;Från:&quot; e-post';
$hesklang['email_name']='&quot;Från:&quot; namn';
$hesklang['vscl']='Begränsningar i serverkonfigurationen';
$hesklang['fnuscphp']='Filuppladdning misslyckades, försök med en mindre eller ingen bifogad fil.';
$hesklang['redv']='återställ standardvyn';
$hesklang['fatte1']='Din bilageinställning &quot;Antal per post&quot; överskrider den som din server tillåter!';
$hesklang['fatte2']='Din maximala filbilagestorlek är större än vad din server tillåter!';
$hesklang['fatte3']='Din server tillåter inte så stora poster, prova med att minska antalet bilagor eller storleken på dem!';
$hesklang['embed']='Inbäddade filer';
$hesklang['embed2']='Spara inbäddade filer som bilagor';
$hesklang['emrem']='(bild raderad)';
$hesklang['hdemo']='(DOLD I DEMOLÄGE)';
$hesklang['ddemo']='Denna funktion är tyvärr inaktiverad i demoläge!';
$hesklang['sdemo']='Funktionen Spara ändringar är inaktiverad i demoläge';
$hesklang['hud']='HESK är uppdaterad';
$hesklang['hnw']='Uppdatering tillgänglig';
$hesklang['getup']='Uppdatera HESK';
$hesklang['updates']='Uppdateringar';
$hesklang['updates2']='Sök automatiskt efter uppdateringar till HESK.';

// Added in version 2.5.0
$hesklang['attdel']='Denna fil har tagits bort från servern och är inte längre tillgänglig för nedladdning.';
$hesklang['dsen']='Mejla inte detta svar till kunden';
$hesklang['attrem']='*Några filbilagor har raderats *';
$hesklang['attnum']='Maximalt antal uppnått: %s'; // %s will show attachment name
$hesklang['attsiz']='Filen är för stor: %s'; // %s will show attachment name
$hesklang['atttyp']='Otillåten typ: %s'; // %s will show attachment name
$hesklang['adf']='Adminmapp';
$hesklang['atf']='Bilagemapp';
$hesklang['err_adf']='Vald adminmapp (%s) finns inte!'; // %s will show folder name
$hesklang['err_atf']='Vald bilagemapp (%s) finns inte!'; // %s will show folder name
$hesklang['err_atr']='Vald bilagemapp (%s) är inte skrivbar!'; // %s will show folder name
$hesklang['fatt']='Filbilagor till detta meddelande:';
$hesklang['wrepo']='Vänligen skriv ett svar efter att du återöppnat detta ärendet';
$hesklang['ktool']='Verktyg i kunskapsdatabasen';
$hesklang['uac']='Kontrollera och uppdatera antalet artiklar i kategorin';
$hesklang['acv']='Artikelräknaren har kontrollerats';
$hesklang['xyz']='antal kategoriartiklar, som är privata, offentliga eller utkast.';
$hesklang['reports_tab']='Kör rapporter'; // Tab title
$hesklang['can_run_reports_full']='Kan köra rapporter (alla)';
$hesklang['can_export']='Kan exportera ärenden';
$hesklang['roo']='<i> (endast ärenden som är tilldelade dig är inkluderade i rapporten</i>';
$hesklang['shu']='Korta länkar';
$hesklang['export']='Exportera ärenden'; // Tab title
$hesklang['export_btn']='Exportera ärenden'; // Button title
$hesklang['export_intro']='Detta verktyg låter dig exportera ärenden till ett XML-kalkylblad som kan öppnas i Excel.';
$hesklang['stte']='Välj ärenden att exportera';
$hesklang['dtrg']='datumintervall';
$hesklang['sequentially']='Sekventiellt'; // Order tickets: Sequentially
$hesklang['ede']='Kan inte skapa exportkatalog, vänligen skapa en mapp manuellt med namnet <b>export</b>i din bilagemapp och förvissa dig om att den är skrivbar för PHP (i Linux chmodda den till 777 - rwxrwxrwx).';
$hesklang['eef']='Det går inte att skapa exportfilen, ingen behörighet att skriva i exportkatalogen.';
$hesklang['inite']='Initierar export';
$hesklang['gXML']='Genererar XML-fil';
$hesklang['nrow']='Antal exporterade rader: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Komprimerar fil till ett zip-arkiv';
$hesklang['eZIP']='Det uppstod ett fel när zip-arkivet skulle skapas';
$hesklang['fZIP']='Komprimeringen av filen är klar';
$hesklang['pmem']='Minnesanvändning (topp): %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; KLICKA HÄR FÖR ATT LADDA NER EXPORTFILEN  &laquo;';
$hesklang['n2ex']='Inga ärenden, som matchade dina kriterier hittades, inget att exportera!';
$hesklang['sp']='Spamskydd'; // For settings page
$hesklang['sit']='-&gt; Bildtyp';
$hesklang['sis']='Enkel bild';
$hesklang['rcpb']='Platsnyckel (Publik nyckel)';
$hesklang['rcpv']='Hemlig nyckel (Hemlig nyckel)';
$hesklang['pop3keep']='Behåll en kopia';
$hesklang['beta']='(TESTVERSION)';
$hesklang['maxpost']='Du försökte förmodligen skicka mer data än vad denna server accepterar.<br /><br />Försök skicka formuläret igen med mindre eller inga bilagor.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Fel spamskydds-svar, försök igen.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Ärendet stängt/löst';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Apr';
$hesklang['ms05']='Maj';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Aug';
$hesklang['ms09']='Sep';
$hesklang['ms10']='Okt';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dec';
$hesklang['sdf']='Inskickat datumformat';
$hesklang['lcf']='Uppdaterad datumformat';
$hesklang['lcf0']='Kort beskrivning';
$hesklang['lcf1']='Datum och tid';
$hesklang['lcf2']='HESK stil';
$hesklang['ticket_tpl']='Ärendemallar';
$hesklang['can_man_ticket_tpl']='Hantera ärendemallar'; // Permission title
$hesklang['ticket_tpl_man']='Hantera ärendemallar'; // Page and link title
$hesklang['ticket_tpl_intro']='Skapa och redigera ärendemallar som du kan använda för att snabbt lägga fram nya ärenden från admin-gränssnittet.';
$hesklang['no_ticket_tpl']='Inga ärendemallar';
$hesklang['ticket_tpl_title']='Titel';
$hesklang['delete_tpl']='Är du säker på att du vill radera den här mallen?';
$hesklang['new_ticket_tpl']='Lägg till eller redigera ärendemall';
$hesklang['ticket_tpl_add']='Skapa ny ärendemall';
$hesklang['ticket_tpl_edit']='Redigera vald ärendemall';
$hesklang['save_ticket_tpl']='Spara ärendemall';
$hesklang['ticket_tpl_saved']='Din ärendemall har sparats för framtida bruk';
$hesklang['ticket_tpl_removed']='Vald ärendemall har raderats från databasen';
$hesklang['ticket_tpl_not_found']='Ärendemall hittades inte';
$hesklang['sel_ticket_tpl']='Välj en ärendemall som du vill redigera';
$hesklang['ent_ticket_tpl_title']='Vänligen skriv en malltitel';
$hesklang['ent_ticket_tpl_msg']='Vänligen skriv ett mallmeddelande';
$hesklang['ticket_tpl_id']='Saknar ärendemalls-ID';
$hesklang['select_ticket_tpl']='Välj en ärendemall';
$hesklang['list_tickets_cat']='Lista alla ärenden som tillhör denna kategorin';
$hesklang['def_msg']='[Inget meddelande]';
$hesklang['emlreqmsg']='Kräv ett meddelande';
$hesklang['emlreqmsg2']='Ignorera hämtade mejl utan innehåll';
$hesklang['relart']='Relaterade artiklar'; // Title of related articles box
$hesklang['s_relart']='Relaterade artiklar'; // On settings page
$hesklang['tab_7']='Ärendelista';
$hesklang['fitl']='Fält i ärendelistan';
$hesklang['submitted']='Skickat';
$hesklang['clickemail']='Visa';
$hesklang['set_pri_to']='sätt prioritering till:'; // Action below the ticket list
$hesklang['pri_set_to']='Prioriteringen har ändrats till:';
$hesklang['cat_pri']='Kategoriprioritet kommer att användas när kunderna inte får välja prioritering och ett ärende har kommit från kundgränssnittet.';
$hesklang['cat_pri_info']='Dina kunder får välja prioritet, så kategoriprioritet kommer att ignoreras. <br /><br /> Stäng av följande funktion i hesk-inställningarna för att använda kategoriprioritet istället:';
$hesklang['def_pri']='Kategoriprioritet:';
$hesklang['ch_cat_pri']='sätt kategoriprioritet';
$hesklang['cat_pri_ch']='Kategoriprioritet har satts som:';
$hesklang['err_dbversion']='Föråldrad MySQL version:';
$hesklang['ip_whois']='Vems IP';
$hesklang['ednote']='Ändra noteringsmeddelande';
$hesklang['ednote2']='Noteringsmeddelande sparat';
$hesklang['perm_deny']='Åtkomst nekad';
$hesklang['mis_note']='Noterings-ID saknas';
$hesklang['no_note']='Notering med detta ID-nummer hittades ej';
$hesklang['sacl']='Spara och fortsätt senare';
$hesklang['reply_saved']='Ditt svarsmeddelande sparades till senare.';
$hesklang['submit_as']='Skickat som:';
$hesklang['sasc']='Skicka som svar till kund';
$hesklang['creb']='Kundsvar av:';
$hesklang['show_select']='Visa &quot;Klicka för att välja&quot; som standardalternativ';
// Settings
$hesklang['mms']='Underhållsläge';
$hesklang['mmd']='Aktivera underhållsläge';
// Customer notice
$hesklang['mm1']='Underhåll pågår';
$hesklang['mm2']='Webbplatsen är tillfälligt stängd för serviceunderhåll';
$hesklang['mm3']='Vi ber om ursäkt för besväret och ber dig försök igen senare.';
// Staff notice
$hesklang['mma1']='Underhållsläge är aktiverad!';
$hesklang['mma2']='Kunder kan inte använda helpdesken';
$hesklang['tools']='Verktyg';
$hesklang['banemail']='Bannlys e-postadresser';
$hesklang['banemail_intro']='Förhindra att vissa e-postadresser registrerar ärenden i helpdesken.';
$hesklang['no_banemails']='<i>Inga e-postadresser har bannlysts.</i>';
$hesklang['eperm']='Permanent e-postbannlysning:';
$hesklang['bananemail']='E-postadress att bannlysa';
$hesklang['savebanemail']='bannlys denna e-postadressen';
$hesklang['enterbanemail']='Vänligen fyll i den e-postadressen som du vill bannlysa.';
$hesklang['validbanemail']='Ange en giltig e-postadress (<i>john.doe@domain.com</i>) eller e-postdomän (<i>@domain.com</i>)';
$hesklang['email_banned']='E-postadressen <i>%s</i> blev bannlyst och Hesk kommer inte längre acceptera ärenden från denna epost-adressen.'; // %s will be replaced with email
$hesklang['emailbanexists']='E-postadressen <i>%s</i> är redan bannlyst.'; // %s will be replaced with email
$hesklang['email_unbanned']='E-postadressen raderades från bannlistan';
$hesklang['banby']='bannlyst av';
$hesklang['delban']='Radera bannlysning';
$hesklang['delban_confirm']='Radera den här bannlysningen?';
$hesklang['baned_e']='Du har bannlyst från att skicka in nya supportärenden.';
$hesklang['baned_ip']='Du har blivit bannlyst från denna helpdesk';
$hesklang['can_ban_emails']='Kan bannlysa e-postadresser';
$hesklang['can_unban_emails']='Kan häva bannlysningar (kan även lägga till e-postadresser som kan bannlysas)';
$hesklang['eisban']='Denna e-postadressen är bannlyst.';
$hesklang['click_unban']='Radera bannlysningen.';
$hesklang['banip']='Bannlys IP-adresser';
$hesklang['banip_intro']='Besökare från bannlysta IP-adresser kommer inte kunna logga in, granska eller skicka in nya ärenden i helpdesken.';
$hesklang['ipperm']='Permanent IP-bann:';
$hesklang['iptemp']='Bann pga inloggningsfel:';
$hesklang['savebanip']='bannlys denna IP-adress';
$hesklang['no_banips']='<i>Inga IP nummer har blivit bannlysta.</i>';
$hesklang['bananip']='IP-adresser som kan bannlysas';
$hesklang['banex']='Exempel:';
$hesklang['iprange']='IP-intervall';
$hesklang['ippermban']='bannlys denna IP-adress permanent';
$hesklang['enterbanip']='Ange en IP-adress eller ett intervall som du vill bannlysa.';
$hesklang['validbanip']='Ange en giltig IP-adress eller ett intervall';
$hesklang['ip_banned']='IP-adressen <i>%s</i> blev bannlyst och HESK kommer inte längre acceptera att ärenden skickas in från denna IP-adress.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='IP-adressen <i>%s</i> blev bannlyst och HESK kommer inte längre acceptera att ärenden skickas in från denna IP-adress.'; // %s will be replaced with IP
$hesklang['ipbanexists']='IP-adressen <i>%s</i> är redan bannlyst.'; // %s will be replaced with IP
$hesklang['iprbanexists']='IP-intervallen <i>%s</i> är redan bannlyst.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP bannlysningen är raderad';
$hesklang['ip_tempun']='Temporär IP bannlysning är raderad';
$hesklang['can_ban_ips']='Kan bannlysa IP-adresser';
$hesklang['can_unban_ips']='Har möjligheten att häva IP-bannlysning (kan även bannlysa.)';
$hesklang['ipisban']='Denna IP-adress är bannlyst.';
$hesklang['m2e']='Utgår i (minuter)';
$hesklang['info']='Info';
$hesklang['sm_title']='Servicemeddelanden';
$hesklang['sm_intro']='Visa ett servicemeddelande i kundens område, till exempel för att meddela dem om kända problem och viktiga nyheter.';
$hesklang['can_service_msg']='Redigera servicemeddelanden';
$hesklang['new_sm']='Nytt servicemeddelande';
$hesklang['edit_sm']='Ändra servicemeddelande';
$hesklang['ex_sm']='Existerande servicemeddelande';
$hesklang['sm_author']='Ägare';
$hesklang['sm_type']='Typ';
$hesklang['sm_published']='publicerad';
$hesklang['sm_draft']='utkast';
$hesklang['sm_style']='Stil';
$hesklang['sm_none']='Inget';
$hesklang['sm_success']='Success';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Anslag';
$hesklang['sm_error']='Fel';
$hesklang['sm_save']='Spara servicemeddelande';
$hesklang['sm_preview']='Förhandsgranska servicemeddelande';
$hesklang['sm_mtitle']='titel';
$hesklang['sm_msg']='Meddelande';
$hesklang['sm_e_title']='Vänligen ange en titel för servicemeddelande';
$hesklang['sm_e_msg']='Vänligen ange ditt servicemeddelande';
$hesklang['sm_e_id']='Saknar meddelande-ID';
$hesklang['sm_added']='Ett nytt servicemeddelande skapades';
$hesklang['sm_deleted']='Servicemeddelandet raderades';
$hesklang['sm_not_found']='Detta Servicemeddelande existerar inte';
$hesklang['no_sm']='Inget servicemeddelande';
$hesklang['del_sm']='Vill du radera detta servicemeddelande?';
$hesklang['sm_mdf']='Servicemeddelandet har sparats';
$hesklang['sska']='Visa föreslagna artiklar';
$hesklang['taws']='Dessa artiklar föreslogs:';
$hesklang['defaults']='Standard';
$hesklang['pncn']='Välj att meddela kundalternativ i det nya formuläret';
$hesklang['pncr']='Välj att meddela kundalternativ i svarsformuläret';
$hesklang['pssy']='Visa vilka artiklar som föreslogs till kunderna';
$hesklang['ccct']='Ärende löst';
$hesklang['custnot']='Meddela kunder när';
$hesklang['notnew']='Ett nytt ärende är skickat';
$hesklang['notclo']='Ett ärende har markerats som löst';
$hesklang['enn']='Med undantag för ärenden från e-postadresser om e-postämne innehåller:';
$hesklang['spamn']='SPAManslag';
$hesklang['spam_inbox']='<span style="color:red"><b>Ingen e-postbekräftelse?</b><br />Vi skickade en bekräftelse till din e-postadress. Om du inte fått de inom några minuter, vänligen kontrollera att mailet inte har hamnat i skräpposten. Markera mailet som <b>Ej SPAM</b> för att undvika problem att ta emot mail från oss i framtiden.</span>';
$hesklang['ekb_n']='<b>Nej</b>, Inaktivera kunskapsdatabasen';
$hesklang['ekb_y']='<b>Ja</b>, Aktivera kunskapsdatabasen';
$hesklang['ekb_o']='<b>Ja</b>, Använd HESK endast som en kunskapsdatabas (<i>inaktivera helpdesk</i>)';
$hesklang['kb_set']='Inställningar för kunskapsdatabas';
$hesklang['kbo1']='Endast kunskapsdatabas';
$hesklang['kbo2']='<br /><br />Besökare kan inte skicka in nya ärenden, dom kommer direkt till kunskapsbasen.';
$hesklang['fpass']='Glömt ditt lösenord?';
$hesklang['passr']='Lösenordsåterställning';
$hesklang['passa']='Tillåt användare att återställa ett glömt lösenord via e-post';
$hesklang['passe']='Fyll i din e-postadress';
$hesklang['passs']='Skicka en återställningslänk';
$hesklang['noace']=' Inget konto med denna e-postadressen hittades';
$hesklang['pemls']='Vi skickade ett mejl med instruktioner om hur du återställer ditt lösenord';
$hesklang['reset_password']='Återställ ditt helpdesklösenord'; // Email subject
$hesklang['ehash']='Ogiltig eller utgången återställningslänk';
$hesklang['ehaip']='Fel IP-adress. Lösenord kan endast återställas från IP-adressen som begärt återställningen.';
$hesklang['resim']='<b>Ange ditt nya lösenord i formuläret nedan!</b>';
$hesklang['permissions']='Rättigheter';
$hesklang['atype']='Kontotyp';
$hesklang['astaff']='Personal';
$hesklang['oon1']='Skicka endast öppna ärenden';
$hesklang['oon2']='Skicka alla mina ärenden';
$hesklang['anyown']='varje ägare';
$hesklang['pfr']='En annan POP3-hämtning pågår.';
$hesklang['pjt']='Uppgiftsavbrott';
$hesklang['pjt2']='Minuter efter start';
$hesklang['nkba']='Kunskapsökning kräver tillräckligt unika artiklar för att fungera korrekt.<br /><br />Överväg att lägga till fler artiklar i kunskapsdatabasen för att förbättra sök- och artikelförslag.';
$hesklang['saa']='Fastnålade artiklar visas överst på listan';
$hesklang['yhbr']='Du är utelåst av systemet i %s minuter p.g.a för många ärendesvar';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='sv';

// Added in version 2.7.0
$hesklang['imap']='IMAP-hämtning';
$hesklang['imaph']='IMAP Host';
$hesklang['imapp']='IMAP Port';
$hesklang['enc']='Kryptering';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Inga';
$hesklang['imapu']='IMAP Användarnamn';
$hesklang['imapw']='IMAP Lösenord';
$hesklang['imaptest']='Testa IMAP-anslutning';
$hesklang['ifd']='[HESK] IMAP-Hämtning ÄR INAKTIVERAD I INSTÄLLNINGARNA';
$hesklang['iei']='[HESK] PHP IMAP-tillägget är inte installerad.';
$hesklang['ifr']='En annan IMAP-hämtning pågår fortfarande.';
$hesklang['arp']='Automatisk omladdning av sidan';
$hesklang['arpp']='Automatisk omladdning av sidan med ärendelista var:';
$hesklang['seconds']='sekund';
$hesklang['minutes']='minut';
$hesklang['atbr']='detta ärende måste vara tilldelat innan det kan besvaras.';
$hesklang['attm']='Tilldela ärende till mig själv';
$hesklang['owneed']='Ägare behövs';
$hesklang['taat']='Detta ärendet är redan tilldelat till dig själv <b>%s</b>.';
$hesklang['scoy']='Är du säker på att du vill tilldela till dig själv?';
$hesklang['scot']='Är du säker på att du vill dela det till %s?';
$hesklang['ycto']='JA, byt ägare';
$hesklang['ncto']='NEJ, behåll ägare';
$hesklang['fass']='Ägare krävs';
$hesklang['req_sub']='Ämne krävs';
$hesklang['req_msg']='Meddelande krävs';
$hesklang['req_email']='E-post krävs';
$hesklang['default_subject']='Ärende från %s';
$hesklang['off-hide']='Dölj i kundformulär';
$hesklang['not_valid_email']='Vänligen ange en giltig e-postadress eller lämna fältet tomt.';
$hesklang['write_down']='<span style="color:red">Vi rekommenderar att du skriver upp ditt ärende-ID för framtida referenser.</span>';
$hesklang['re_confirm1']='Inaktiveras detta så inaktiveras även "Kräv e-postadress för att granska ärenden" under "Säkerhet". Fortsätt?';
$hesklang['re_confirm2']='Aktiveras detta så krävs en "e-postadress för ärendegranskning" under "Funktioner". Fortsätt?';
$hesklang['can_email_tpl']='Redigera e-postmallar';
$hesklang['et_title']='E-postmallar';
$hesklang['et_intro']='Redigera e-postmeddelanden som skickas till personal och kunder';
$hesklang['file']='Fil';
$hesklang['efile']='Redigera fil';
$hesklang['rdesc']='(Mottagare) Beskrivning';
$hesklang['desc_forgot_ticket_id']='(Kunder) Glömt Ärendespårnings-ID';
$hesklang['desc_new_reply_by_staff']='(Kunder) Nytt personalsvar';
$hesklang['desc_new_ticket']='(Kunder) Ärendet mottaget';
$hesklang['desc_ticket_closed']='(Kunder) Ärendet stängt/löst';
$hesklang['desc_category_moved']='(Personal) Detta ärende har flyttats till en ny kategorin';
$hesklang['desc_new_reply_by_customer']='(Personal) Nytt kundsvar';
$hesklang['desc_new_ticket_staff']='(Personal) Nytt ärende inskickat';
$hesklang['desc_ticket_assigned_to_you']='(Personal) Detta ärende har tilldelats dig';
$hesklang['desc_new_pm']='(Personal) Nytt privat meddelande';
$hesklang['desc_new_note']='(Personal) Ett ärende som tilldelats dig har en ny notering ';
$hesklang['desc_reset_password']='(Personal) Återställ ditt lösenord';
$hesklang['etfm']='En eller flera e-postmallar saknas.<br /><br />Förvissa dig om att alla e-postmallar är uppladdade till mappen <i>/language/%s/emails</i>.';
$hesklang['etfw']='Vissa e-postmallar är inte skrivbara.<br /><br />
                    Förvissa dig om att PHP har rättigheter att skriva till alla filer i mappen <i>/language/%s/emails</i>.<br /><br />
                    Om det är en linux servrar så måste e-postmallarna ha rättigheterna 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Saknad mall-ID';
$hesklang['et_fm']='Den här e-postmallen saknas';
$hesklang['et_fw']='Den här e-postmallen är inte skrivbar';
$hesklang['et_save']='Spara e-postmall';
$hesklang['updated_on']='Uppdaterad den';
$hesklang['ticket_url']='Ärendelänk';
$hesklang['pm_url']='Privat meddelandelänk';
$hesklang['et_num']='Antal ärenden';
$hesklang['et_list']='Ärendelista';
$hesklang['et_empty']='E-postmallen kan inte lämnas tom';
$hesklang['et_saved']='E-postmallen sparades';
$hesklang['source']='Källa';
$hesklang['select_category']='Välj kategori';
$hesklang['select_category_text']='Vad kan vi hjälpa dig med?';
$hesklang['select_category_staff']='Välj ärendekategori';
$hesklang['scat']='Välj kategorigräns';
$hesklang['scat2']='(En markeringsruta kommer att visas om  kategoriantalet är högre)';
$hesklang['new_cf']='Nytt anpassat fält';
$hesklang['cf_intro']='Använd den här funktionen för att lägga till anpassade fält på kundformuläret så att du kan få mer information från kunder.';
$hesklang['cf_public']='Publik';
$hesklang['cf_private']='Endast personal';
$hesklang['cf_cust']='För kunder';
$hesklang['cf_all']='Alla';
$hesklang['cf_cat']='Valda';
$hesklang['cf_ctrl']='Tips: håll ner CTRL tangenten för att välja flera kategorier';
$hesklang['visibility']='Synlighet';
$hesklang['cf_save']='Spara anpassat fält';
$hesklang['ex_cf']='Aktiva anpassade fält';
$hesklang['no_cf']='Inga aktiva anpassade fält';
$hesklang['del_cf']='Vill du radera anpassat fält? fältdata kommer raderas från databasen!';
$hesklang['cf_e_id']='Ogiltigt ID';
$hesklang['edit_cf']='Redigera anpassat fält';
$hesklang['cf_deleted']='Anpassat fält har raderats';
$hesklang['cf_not_found']='Det här anpassade fältet existerar inte';
$hesklang['cf_added']='Nytt anpassat fält har lagts till';
$hesklang['cf_nocat']='Välj minst en kategori för det anpassade fältet';
$hesklang['cf_mdf']='Anpassat fält har sparats';
$hesklang['atl1']='Du måste ange minst ett alternativ!.';
$hesklang['sch']='Dold';
$hesklang['meml3']='Tillåt att fler e-postadresser får anges';
$hesklang['dmin']='Minsta accepterade datum';
$hesklang['dmax']='Högsta accepterade datum';
$hesklang['d_day']='dag(ar)';
$hesklang['d_week']='vecka(or)';
$hesklang['d_month']='månad(er)';
$hesklang['d_year']='år';
$hesklang['d_any']='alla datum';
$hesklang['d_fixed']='fastställt datum';
$hesklang['d_relative']='relativt datum';
$hesklang['d_mm']='Minsta datumet får inte vara högre än maximalt datum';
$hesklang['d_emin']='Minsta datum för <i>%s</i> is %s';
$hesklang['d_emax']='Högsta datum för <i>%s</i> is %s';
$hesklang['d_format']='visningsformat på datum';
$hesklang['d_custom']='Anpassat format';
$hesklang['d_ci']='ENDAST AVANCERADE ANVÄNDARE: ett giltigt PHP datumsformat, se PHP manualen.';
$hesklang['cf_noe']='Ange en giltig e-postadress till <i>%s</i>';
$hesklang['cf_noem']='Välj en eller flera giltiga e-postadresser till <i>%s</i>';
$hesklang['can_resolve']='Kan lösa ärenden';
$hesklang['can_change_own_cat']='Ändra ärendekategori (att tillåta)';
$hesklang['can_submit_any_cat']='Kan skapa ärenden till alla kategorier';
$hesklang['noauth_submit']='Du har inte rättigheter att skapa ärenden till denna kategorin!';
$hesklang['noauth_move']='Du har inte rättigheter till att flytta ärenden till denna kategorin!';
$hesklang['noauth_resolve']='Du har inte rättigheter till att lösa ärenden!';
$hesklang['force_ssl']='Tvinga SSL anslutningar';
$hesklang['d_ssl']='<i>inaktiverad</i> - öppna sidan med https:// för att hantera denna funktionen';
$hesklang['scno']='Status kan inte ändras';
$hesklang['statuses']='Statusar';
$hesklang['statuses_intro']='Använd verktyget för att lägga till anpassade statusar till din helpdesk';
$hesklang['color']='Färger';
$hesklang['csscl']='CSS klass eller färg';
$hesklang['clr_view']='Förhandsvisning på färgtext';
$hesklang['cbc']='Utbytbara av kunder';
$hesklang['ccc']='Kan kunderna ändra denna statusen?';
$hesklang['del_status']='Vill du Radera denna statusen?';
$hesklang['ex_status']='Befintliga statusar';
$hesklang['status_hesk']='Inbyggda statusar (kan inte ändras här)';
$hesklang['status_custom']='Anpassade statusar';
$hesklang['status_custom_none']='Inga anpassade statusar. Du kan lägga till dem med hjälp av formuläret ovanför.';
$hesklang['status_save']='Spara status';
$hesklang['list_tkt_status']='lista alla ärenden med denna statusen';
$hesklang['new_status']='anpassad status';
$hesklang['edit_status']='Redigera anpassad status';
$hesklang['err_status']='Ange statusnamn';
$hesklang['status_added']='En ny status är tillagd';
$hesklang['status_e_id']='Ogiltigt ID';
$hesklang['status_mdf']='Anpassat fält har sparats';
$hesklang['status_deleted']='Anpassad status har raderats';
$hesklang['status_not_found']='Denna anpassade statusen existerar inte';
$hesklang['status_not_empty']='Denna statusen kunde inte raderas p.g.a att flera ärenden med denna statusen existerar';
$hesklang['status_limit']='Du har 100 anpassade statusar, inga nya kan skapas.';
$hesklang['public_link']='Publik länk';
$hesklang['frames']='Ramar';
$hesklang['frames2']='Förhindra belastning på Heskramar via tredjeparts-domäner';
$hesklang['numsub']='Skapade ärenden';
$hesklang['hidf']='Dolda fält är inte synliga för kunder på ärendeformuläret (värdet kommer fortfarande vara synligt på informationssidan om den har satts som offentlig). den uppför sig som vanliga textfält för personalanvändare.';
$hesklang['rcheck']='Välj inte ett standardalternativ';
$hesklang['refresh_page']='Ladda om sidan';
$hesklang['del_kba']='Radera vald artikel';
$hesklang['del_kbaa']='Radera artikeln permanent';
$hesklang['hni1']='Är hesk inte installerad än?';
$hesklang['hni2']='Det verkar som om denna helpdesken inte har installerats korrekt och konfigurerats ännu.';
$hesklang['hni3']='För att installera HESK följer du <a href="docs/">Instruktionerna i dokumentationen</a>';
$hesklang['cf']='Cache mapp';
$hesklang['e_cdir']='Hesk kommer inte att kunna tolka e-postadresser eller cache resultat om inte cache mappen finns och är skrivbar';
$hesklang['step1']='Steg 1';
$hesklang['step2']='Steg 2';
$hesklang['dffs']='Ta bort filen från servern när nerladdningen är färdig';
$hesklang['fd']='Exportfilen raderades från servern';

// Added in version 2.8.0
$hesklang['TZ']='Tidszon';
$hesklang['thist17']='<li class="smaller">%s | Skickad via IMAP-Hämtning</li>';
$hesklang['sir3']='dold reCAPTCHA';
$hesklang['invisible']='dold';
$hesklang['imap_not']='PHP är inte kompilerat med IMAP-stöd';
$hesklang['imap_warning']='Användaren %1$s har samma e-postadress som din IMAP-adress: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='user %1$s har samma e-postadress som din POP3-adress: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Detta kan ge upphov till en mejlsnurra där nya ärenden skapas från en användarens mejlnotifiiering. Mejladress du använder vid hämtning ska vara unik och inte användas av någon annan.';
$hesklang['can_view_ass_by']='Kan titta på ärenden som han/hon tilldelade till andra';
$hesklang['can_privacy']='Kan anonymisera ärenden';
$hesklang['confirm_anony']='Anonymisera detta ärendet';
$hesklang['anon_selected']='Anonymisera valda ärenden';
$hesklang['privacy_anon_info']='Ta bort all personligt identifierbar data och innehåll från ärenden (Kunders namn, e-postadress, meddelanden, bilagor, IP...), men behåll ärenden i databasen för statistik. (rätt att bli borttaget).';
$hesklang['success_anon']='Ärendet har framgångsrikt anonymiserats';
$hesklang['num_tickets_anon']='Antal anonymiserade ärenden: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Kund]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Ämne]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Meddelande]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonymiserad av %s</li>';
$hesklang['print_selected']='Skriv ut valda ärenden';
$hesklang['with_selected']='Valda:';
$hesklang['assign_selected']='Tilldela valda till:';
$hesklang['assign_no']='Ingen ägare är vald, inga ändringar utförs';
$hesklang['assign_1']='Valda ärenden har ändrats till otilldelad.';
$hesklang['assign_2']='Ärende-ID %1$s är satt som otilldelad'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s Fel: redan tilldelad till %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s tilldelad till %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s fel: %2$s har inte behörighet till ärendekategorin'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultat av tilldelning av m﻿assärenden:<br /><br />Tilldelat: %1$s<br />Fel: %2$s<br /><br />Logg:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP-address';
$hesklang['moret']='Fler alternativ'; // More options button title
$hesklang['btn_more']='Mer'; // More options button text
$hesklang['btn_print']='Utskriftsvänlig version';
$hesklang['btn_edit']='Redigera';
$hesklang['btn_lock']='Lås ärende';
$hesklang['btn_unlock']='Lås upp ärende';
$hesklang['btn_tag']='Tagga detta ärendet';
$hesklang['btn_resend']='Skicka e-postavisering igen';
$hesklang['btn_untag']='Avtagga detta ärendet';
$hesklang['btn_import_kb']='Importera detta ärende till en KB-artikel';
$hesklang['btn_anony']='Anonymisera ärendet';
$hesklang['btn_delt']='Ta bort detta ärende';
$hesklang['btn_delr']='Ta bort detta inlägg';
$hesklang['ernf']='Svar hittades inte';
$hesklang['tns']='E-postaviseriing har skickats!';
$hesklang['rns']='E-postaviseriing har skickats!';
$hesklang['fname']='Förnamn';
$hesklang['export_selected']='Exportera valda ärenden';
$hesklang['btn_export']='Exportera till XML för Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Responses';
$hesklang['team']='Team';
$hesklang['sm_content']='Innehåll';
$hesklang['sm_settings']='Inställningar';
$hesklang['wizard_back']='Bakåt'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Frammåt'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Gå till Inställningar';
$hesklang['sm_return_to_editing']='Återvänd till Redigering';
$hesklang['email_tpl_title']='Titel';
$hesklang['edit_email_template']='Redigera e-post mall';
$hesklang['err_no_settings_section']='Inga inställnings sektioner va ifyllda.';
$hesklang['this_field_is_required']='Det här fältet är obligatoriskt';
$hesklang['reset_your_password']='Återställ ditt lösenord';
$hesklang['reset_password_instructions']='Vänligen fyll i formuläret nedan. Vi kommer att skicka en återställnings länk för ditt lösenord.';
$hesklang['enter_email']='Fylli e-post';
$hesklang['password_reset_check_your_email']='Kontrollera din e-post';
$hesklang['password_reset_link_sent']='Vi har skickat en återställnings länk för ditt löseord.';
$hesklang['back_to_login']='Tillbaks till inloggningen';
$hesklang['pager_first']='Första';
$hesklang['pager_previous']='Föregående';
$hesklang['pager_next']='Nästa';
$hesklang['pager_last']='Sista';
$hesklang['new_team_member']='Ny Team Medlem';
$hesklang['role']='Roll';
$hesklang['optional']='Valfritt';
$hesklang['edit_profile']='Redigera Profil';
$hesklang['assigned_to']='Tilldelad till';
$hesklang['contact']='Kontakt';
$hesklang['unban_email']='Avblokera den här e-post adressen';
$hesklang['unban_ip']='Avblokera den här IP adressen';
$hesklang['show_previous_replies']='Visa föregående svar';
$hesklang['type_your_message']='Ditt meddelande'; // Used when there are no canned responses
$hesklang['close_button_text']='Stäng';
$hesklang['create_new_ticket']='Skapa nytt ärende';
$hesklang['delete_article']='Radera artikel';
$hesklang['view_existing_tickets']='Visa existerande ärenden';
$hesklang['how_can_we_help']='Hej! Hur kan vi hjälpa dig?';
$hesklang['search_for_articles']='Sök artiklar';
$hesklang['submit_a_support_request']='Skicka support förfrågan';
$hesklang['verify_header']='SPAM Förebyggande';
$hesklang['ticket_details']='Ärende Detaljer';
$hesklang['yes_title_case']='Ja';
$hesklang['no_title_case']='Nej';
$hesklang['no_results_found']='Inga bresultat hittades';
$hesklang['site_theme']='Site tema';
$hesklang['test_theme_folder']='Testa tema mapp';
$hesklang['test_theme_folder_description']='Testar tema mapp efter tillgängliga teman. Endast teman som uppfyller testen är korrekt installerade.';
$hesklang['err_site_theme']='Vänligen välj Hesk tema';
$hesklang['confirm']='Bekräfta';
$hesklang['confirm_deletion']='Bekräfta borttagning';
$hesklang['confirm_delete_status']='Är du säker på att du vill ta bort den här statusen?';
$hesklang['help_desk']='Kundtjänst'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.sv.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Tid visning';
$hesklang['tdisd']='Datum och tid';
$hesklang['tdisa']='Sedan (exempel: 5 timmar sedan)';
$hesklang['nav_templates']='Mallar'; // Admin panel navigation item
$hesklang['hide_replies']='Dölj ärende svar';
$hesklang['hide_replies_no']='Visa aldrig, alltid alla svar (Never, always show all replies)';
$hesklang['hide_replies_yes']='Dölj alla svar förutom senaste:';
$hesklang['hide_replies_def']='Visa det senaste personal svaret och eventuella efterföljande kundsvar';
$hesklang['reply_by']='Svarat av'; // Reply by NAME
$hesklang['btt']='Tillbaks högst upp';
$hesklang['lwidth']='Begränsa ticket bredd';
$hesklang['lwidtall']='Använd hela bredden';
$hesklang['lwidtpx']='Maximal bredd i pixlar:';
// 3-letter days of the week
$hesklang['mon']='Mon';
$hesklang['tue']='Tis';
$hesklang['wed']='Ons';
$hesklang['thu']='Tors';
$hesklang['fri']='Fre';
$hesklang['sat']='Lör';
$hesklang['sun']='Sön';
$hesklang['clear']='Rensa'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Moduler';
$hesklang['modules_demo']='Den här modulen ar endast tillgänglig i %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Pröva live demo här: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistik';
$hesklang['statistics']['intro']='Den här rapporten ger dig insikt i din kundtjänsts användning och hur din personal presterar.';
$hesklang['statistics']['ntsp']='Inga ärenden under den valda perioden.';
$hesklang['statistics']['pie_title_ro']='Öppna mot lösta ärenden';
$hesklang['statistics']['open']='Öppen';
$hesklang['statistics']['resolved']='Löst';
$hesklang['statistics']['pie_title_as']='Öppna ärenden: tilldelad mot otilldelade';
$hesklang['statistics']['ass']='Tilldelad';
$hesklang['statistics']['unas']='Otilldelad';
$hesklang['statistics']['pie_title_au']='Öppna ärtenden: Svarade mot osvarade';
$hesklang['statistics']['answered']='Svarade';
$hesklang['statistics']['unanswered']='Osvarade';
$hesklang['statistics']['pie_title_so']='Status av öppna ärenden';
$hesklang['statistics']['retic']='Ärenden:';
$hesklang['statistics']['chart_title_md']='Ärenden per dag i månaden';
$hesklang['statistics']['chart_title_wd']='Ärenden per veckodag';
$hesklang['statistics']['chart_title_hd']='Ärenden per timme';
$hesklang['statistics']['chart_title_tfr']='Tid till första personal svar';
$hesklang['statistics']['chart_title_tfrc']='Tidsramen av svarade ärenden';
$hesklang['statistics']['chart_title_ttr']='Tid det tagit från inskickad till löst ärende';
$hesklang['statistics']['chart_title_ttrc']='Ärenden lösta inom tidsramen';
$hesklang['statistics']['chart_title_sr']='Personal svar';
$hesklang['statistics']['chart_title_srt']='Personal svar per ärende';
$hesklang['statistics']['chart_title_srtr']='Personalsvar per ärende (Endast lösta ärenden)';
$hesklang['statistics']['chart_title_srt1']='Personal svar per ärende (Ärenden med minst ett svar)';
$hesklang['statistics']['ct_30']='30 minuter';
$hesklang['statistics']['ct_1h']='1 timme';
$hesklang['statistics']['ct_2h']='2 timmar';
$hesklang['statistics']['ct_4h']='4 timmar';
$hesklang['statistics']['ct_1d']='1 dag';
$hesklang['statistics']['ct_2d']='2 dagar';
$hesklang['statistics']['ct_3d']='3 dagar';
$hesklang['statistics']['ct_1w']='1 vecka';
$hesklang['statistics']['ct_wp']='> 1 vecka';
$hesklang['statistics']['ct_1m']='1 månad';
$hesklang['statistics']['ct_mp']='> 1 månad';
$hesklang['statistics']['axis1']='% av ärenden svarade';
$hesklang['statistics']['axis2']='% av ärenden lösta';
$hesklang['statistics']['axis3']='% av ärenden';
$hesklang['statistics']['axis4']='Tid till första svar';
$hesklang['statistics']['axis5']='Tid till löst';
$hesklang['statistics']['axis6']='Antal svar';
$hesklang['statistics']['axis7']='Antal ärenden';
$hesklang['statistics']['axis8']='Veckodag';
$hesklang['statistics']['axis9']='Timme';
$hesklang['statistics']['axis10']='Dag i månaden';
$hesklang['statistics']['tr_0']='Inget svar';
$hesklang['statistics']['tr_1']='1 svar';
$hesklang['statistics']['tr_2']='2 svar';
$hesklang['statistics']['tr_5']='3-5 svar';
$hesklang['statistics']['tr_10']='6-10 svar';
$hesklang['statistics']['tr_99']='> 10 svar';
$hesklang['statistics']['average']='Genomsnittligt';
$hesklang['statistics']['atfr']='Genomsnittlig tid till första personal svar:';
$hesklang['statistics']['attr']='Genomsnittlig tid till löst ärende:';
$hesklang['statistics']['about']='Ungefär %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Totalt antal ärenden personal har besvarat:';
$hesklang['statistics']['trnr']='Totalt antal lösta ärenden utan personal svar:';
$hesklang['statistics']['tsr']='Totalt personal svar:';
$hesklang['statistics']['tsrt']='Genomsnittligt antal personal svar per ärende:';
$hesklang['statistics']['tsro']='Genomsnittligt antal personal svar per ärende (ärenden med minst 1 svar):';
$hesklang['statistics']['tsrc']='Genomsnittligt antal personal svar per ärende som kräver lösning:';
$hesklang['statistics']['tsrr']='Genomsnittligt antal personal svar per äre4nde som kräver lösning (ärenden med minst 1 svar):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='och mycket mer...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ärende förfallet';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESKALERAD: %%SUBJECT%%';
$hesklang['escalate']['tab']='Eskalera'; // Menu link
$hesklang['escalate']['page_title']='Eskalera ärendens'; // Page H2 title
$hesklang['escalate']['intro']='Den här modulen hjälper dig att eskalera ärenden som inte fått uppmärksamhet i tid.';
$hesklang['escalate']['feat1']='Ärendet är inte tilldelat, svarat på eller löst inom tidsramen';
$hesklang['escalate']['feat2']='ärenden som närmar sig förfallo datum och har förfallit.';
$hesklang['escalate']['feat3']='automatiskt ändra ärende prioritet, tilldelaom ett ärende, skicka ett e-post notifiaktion';
$hesklang['escalate']['feat4']='värkställ regler baserat på ärende kategori, ägare och status';
$hesklang['escalate']['prefix']='Eskalerad:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Aktiva regler';
$hesklang['escalate']['new']='Ny eskalerings regel';
$hesklang['escalate']['no_rules']='Du har inga eskalerings regler. Skapa en denom att trycka på &quot;Ny eskalerings regel&quot; knappen ovan.';
$hesklang['escalate']['title']='Regel titel';
$hesklang['escalate']['titlet']='En beskrivande titel, till exempel: Tilldelaom ärenden som inte svarats inom ett dygn';
$hesklang['escalate']['default_title']='Regel av %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Regel utlösare';
$hesklang['escalate']['trigt']='Sätt anledningen som får utlösaren att köra den här regeln.';
$hesklang['escalate']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Anledning'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Åtgärd'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Verkställ för'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Ta bort den här regeln?';
$hesklang['escalate']['edit']='Redigera eskalerings regel ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Ett support ärende är:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='inte svarat av personal';
$hesklang['escalate']['nrepc']='inte svarat av en kund';
$hesklang['escalate']['nass']='inte tilldelad';
$hesklang['escalate']['nres']='inte löst';
$hesklang['escalate']['ndue']='närmar sig förfallodatum';
$hesklang['escalate']['odue']='förfallen';
$hesklang['escalate']['within']='Inom:';
$hesklang['escalate']['minutes']='minuter';
$hesklang['escalate']['hours']='timmar';
$hesklang['escalate']['days']='dagar';
$hesklang['escalate']['weeks']='veckor';
$hesklang['escalate']['months']='månader';
$hesklang['escalate']['years']='år';
$hesklang['escalate']['ofs']='överlämnas';
$hesklang['escalate']['resend']='Skicka e-mail notifikation igen:';
$hesklang['escalate']['force']='Skicka alltid, oavsätt personal inställningar';
$hesklang['escalate']['noforce']='Respektera anställdas notifikations inställningar';
$hesklang['escalate']['setpri']='Sätt prioritet till:';
$hesklang['escalate']['setsta']='Sätt status till:';
$hesklang['escalate']['assto']='Tilldela ärende till:';
$hesklang['escalate']['asm']='En annan anställd';
$hesklang['escalate']['notify']='Notis till anställda...';
$hesklang['escalate']['ato']='Tillämpa på:';
$hesklang['escalate']['tic']='Ärenden i kategori:';
$hesklang['escalate']['tat']='Ärenden tilldelade till:';
$hesklang['escalate']['tws']='Ärenden med status:';
$hesklang['escalate']['tall']='Tillämpa regel för tidigare och nya ärenden';
$hesklang['escalate']['tfn']='Tillämpa endast regel för nya ärenden, ignorera existerande ärenden';
$hesklang['escalate']['tfi']='Tillämpa endast regeln för ärenden med ID högre än:';
$hesklang['escalate']['save']='Spara regel';
$hesklang['escalate']['e_tt']='Tid ska vara mellan 1 och 10000';
$hesklang['escalate']['e_a']='Välj åtminstånde en handling att utföra på matchande ärenden';
$hesklang['escalate']['nocat']='Välj minst en kategori';
$hesklang['escalate']['nouser']='Välj minst en användare';
$hesklang['escalate']['nostatus']='Välj minst en status';
$hesklang['escalate']['nocata']='%1$s har inte tillgång till dessa kategorier:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Ny regel har skapats';
$hesklang['escalate']['mdf']='Regel inställningar sparades';
$hesklang['escalate']['e_id']='Ingen regem med detta ID hittades';
$hesklang['escalate']['deleted']='Vald regel har tagits bort';
$hesklang['escalate']['edit_notice']='ändringen av regelutlösaren kommer inte att påverka något ärende som redan eskalerats av denna regel (Så vida du inte återställer regeln).';
$hesklang['escalate']['reset']='Återställ den här regeln';
$hesklang['escalate']['reset2']='Är du säker att du vill återställa den här regeln?<br><br>Regel träffar kommer att sättas till 0 och alla ärenden som matchar den här regeln kommer att bli eskalerade igen.';
$hesklang['escalate']['reset3']='Vald regel har återställts';
$hesklang['escalate']['log_title']='Regel #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | eskalerades av %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - sätt prioritet till %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - tilldela till %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - skicka notifikation till anställda</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - skicka notifikation till anställda (tvingad)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - error: %2$s har inte tillgång till ärende kategori</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - error: %2$s Har inte behörighet att visa ärenden</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - error: ingen annan användare kan visa detta ärende</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - notis: prioritet redan tillämpad till %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - notis: redan tilldelad till %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notis: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - sätt status till %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - notis: status redan satttill %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Aktivera'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Aktivera denna regel (börja använda den)';
$hesklang['escalate']['activated']='Valda regler har aktiverats'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='inaktivera denna regel (sluta använda den)';
$hesklang['escalate']['deactivated']='Vald regel har avaktiverats'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Inga aktiva eskalerings regler';
$hesklang['escalate']['matched']='Antal matchande ärenden hittades: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Verktyg';
$hesklang['escalate']['test']='Simulera denna regel';
$hesklang['escalate']['testa']='Simulera alla regler';
$hesklang['escalate']['testaa']='Simulera alla activa regler';
$hesklang['escalate']['testr']='Simulerings resultat';
$hesklang['escalate']['rsim']='Upprepa simulering';
$hesklang['escalate']['tbef']='Innan en regel går live, måste du aktivera den genom att klicka i check boxen i &quot;AKTIVERA&quot; columnen.<br><br>
                               VI starkt rekommenderar att du <strong>simulerar</strong> varje regel genom att klicka %1$s (Simulera denna regel) iconen i regel tabellen
                               för att se hur effekten av dina existerande ärenden kommer att bli innan du aktiverar den.<br><br>
                               <strong>Aktiva regler processas varje %2$s minuter. Ett ärende kan bara eskaleras en gång per regel</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SIMULERINGSLÄGE, inga förändringar till databasen har utförts';
$hesklang['escalate']['sic']='SIMULERING FÄRDIG';
$hesklang['escalate']['r']='[REGEL]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Tips: håll ner CTRL knappen för att välja flera alternativ';
$hesklang['desc_ticket_escalated']='(Anställda) Ärendet har eskalerats'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Ärende formattering (Anställda)';
$hesklang['ticket_formatting_plaintext']='Plain Text';
$hesklang['ticket_formatting_rich_text']='Rich Text (HTML)';
$hesklang['due_date']='Förfallodatum';
$hesklang['invalid_due_date']='Ett ogiltigt förfallodatum fylldes i.';
$hesklang['thist19']='<li class="smaller">%s | Förfallodatum uppdaterades till %s av %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | förfallodatum togs bort av %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Ärende förfallodatum har uppdaterats.';
$hesklang['menu_kb_manage']='Hantera'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Visa'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Markera alla';
$hesklang['a_deselect']='Avmarkera alla';
$hesklang['a_toggle']='Aktivera alla';
$hesklang['ql_all']='Alla ärenden';
$hesklang['ql_alo']='Alla öppna ärenden';
$hesklang['ql_fit']='Filttrerade ärenden';
$hesklang['ql_a2m']='Tilldelade till mig';
$hesklang['ql_a2o']='Tilldelade till andra';
$hesklang['ql_una']='Ej tilldelade';
$hesklang['ql_due']='Snart försenade';
$hesklang['ql_ovr']='Försenad';
$hesklang['set_ds']='Visa som &quot;Snart försenade&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='Dagar till förening';
$hesklang['not_aos']='Några öppna ärenden du har tillgång till visas inte på grund av filter inställningar.';
$hesklang['ntoverdue']='Ett ärende är försenat med ägaren:';
$hesklang['ovdcron']='för förseningar till arbete, din administratör måste aktivera ett cron jobb.';
$hesklang['instructions']='Instruktioner';
$hesklang['desc_overdue_ticket']='(Anställda) Ärende försenat';
$hesklang['overdue_starting']='Påbörja försenade ärende notifikations process';
$hesklang['overdue_sim']='Skickar mail och uppdaterar ärenden är avstängt i simuleringsläge.';
$hesklang['overdue_ticket_count']='Hittade %s ärenden som är försenade.'; // %s = Number of tickets
$hesklang['overdue_finished']='Färdiga Försenade Ärenden. %s e-post skickades. %s e-post kunde inte skickas.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Läs in en extra CSS fil för admin panelen';
$hesklang['noval_cert']='Validera inte server certifikat';
$hesklang['chg_cat']='Klicka för att ändra ärende kategori';
$hesklang['tlan']='Ärendespråk';
$hesklang['uue']='Två eller fler anställda har samma e-post adress. Vi rekommenderar att sätta en unik e-post adress för varje anställd.';
$hesklang['flood']='Översvämningsgräns';
$hesklang['e_flood']='Ooops, du har redan skickat ett svar nydligeny. Vi stoppade denna förfrågan för att motverka svars översvämning.';
$hesklang['cookies']='Kakor';
$hesklang['ukey']='URL Access Key'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Generera en slumpmässig URL Access Key';
$hesklang['ukeym']='Error: för att köra denna fil via HTTP måste du inkludera din URL Access Key i förfrågningen. Till exampel:';
$hesklang['ukeyw']='Error: Fel URL Access Key';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket received: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% is your verification code';
$hesklang['follow_up_email']='Be honest - how did we do?';
$hesklang['mfa']='Multi-Factor Authentication (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Enabled?';
$hesklang['mfa_required']='Require Multi-Factor Authentication';
$hesklang['mfa_manage_profile']='Manage MFA';
$hesklang['mfa_disabled']='Multi-Factor Authentication is disabled';
$hesklang['mfa_enabled']='Multi-Factor Authentication is Enabled (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='None';
$hesklang['mfa_method_none_subtext']='Remove multi-factor authentication on your account.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='The helpdesk will send an email with a random login code to <strong>%s</strong> when logging in.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authenticator App';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Use a smartphone application, such as Authy or Google Authenticator, to generate a random login code when logging in.';
$hesklang['mfa_step_method']='Method';
$hesklang['mfa_step_verification']='Verification';
$hesklang['mfa_step_complete']='Complete';
$hesklang['mfa_introduction']='Multi-factor authentication improves account security by requiring you to verify your login using an additional verification method, such as email or an authenticator app (such as Authy or Google Authenticator).';
$hesklang['mfa_reset_warning']='You already have multi-factor authentication enabled. Completing this again will reset your multi-factor authentication device (if enabled).';
$hesklang['mfa_select_method_colon']='Select an authentication method:';
$hesklang['mfa_verification_header']='Verification - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='An email has been sent to <strong>%s</strong> containing a six-digit verification code. Enter the code you received via email below to continue.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Step 1: Scan the image below with the multi-factor authentication app on your mobile device.';
$hesklang['mfa_verification_auth_app_cant_scan']='Not able to scan the image? Manually enter this code on your device: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Step 2: Enter the 6-digit code displayed on your application to verify your device.';
$hesklang['mfa_verify']='Verify';
$hesklang['mfa_invalid_method']='Invalid multi-factor authentication method was received.';
$hesklang['mfa_invalid_verification_code']='The code that was entered is incorrect or expired.';
$hesklang['mfa_configured']='Multi-factor authentication has been enabled for your account!';
$hesklang['mfa_removed']='Multi-factor authentication has been disabled for your account!';
$hesklang['mfa_verification_needed']='Multi-factor authentication is enabled for this account.';
$hesklang['mfa_verification_needed_email']='Please enter the verification code that was sent to your email address.';
$hesklang['mfa_verification_needed_auth_app']='Please enter the code that is displayed on your authentication app.';
$hesklang['mfa_verification_code']='Verification code';
$hesklang['mfa_server_time_issue']='Your server time seems to be inaccurate: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Reset multi-factor authentication';
$hesklang['mfa_reset_confirm']='Are you sure you wish to reset MFA for this user?';
$hesklang['mfa_reset_yes']='Reset';
$hesklang['mfa_reset']='Multi-Factor Authentication has been reset for the user';
$hesklang['desc_mfa_verification']='(Staff) Multi-Factor Authentication Code';
$hesklang['mfa_code']='Code:';
$hesklang['mfa_backup_codes_header']='SAVE YOUR BACKUP CODES!';
$hesklang['mfa_backup_codes_description']='Keep these backup codes somewhere safe but accessible. In case you lose access to your MFA device or email, you can enter one of the following backup codes to log in.<br><br><strong>Be sure to treat these backup codes like passwords. You will not be able to see these codes again!</strong>';
$hesklang['mfa_verify_another_way']='Verify your account another way'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Get a verification code at %s';
$hesklang['mfa_verify_another_way_code']='Enter one of your 8-character backup codes';
$hesklang['mfa_verify_another_way_admin']='Contact your helpdesk administrator for help';
$hesklang['mfa_verify_another_way_reset']='Reset your multi-factor authentication by uploading a file to the server';
$hesklang['mfa_send_another_email']='Send another email';
$hesklang['mfa_sent']='An email with a new verification code was sent to your email address';
$hesklang['mfa_backup_code']='Backup Code';
$hesklang['mfa_backup_codes']='Backup Codes';
$hesklang['mfa_backup_codes_info']='Single-use codes to pass multi-factor verification when unable to access your email or authenticator app. Once you use a backup code to sign in, that code becomes inactive.';
$hesklang['mfa_backup_codes_num']='You can get a new set of 10 backup codes whenever you want. When you create a new set of codes, the old set automatically becomes inactive.';
$hesklang['mfa_backup_codes_num2']='Number of your active codes: %s';
$hesklang['mfa_invalid_backup_code']='The backup code that was entered is incorrect or has already been used.';
$hesklang['mfa_del_codes']='Delete my backup codes';
$hesklang['mfa_del_codes2']='All your backup codes have been deleted.';
$hesklang['mfa_new_codes']='Generate new backup codes';
$hesklang['mfa_new_codes2']='New backup codes have been generated';
$hesklang['old_php_version']='Error: Unsupported PHP version';
$hesklang['category_default_due_date']='Default Due Date';
$hesklang['category_change_default_due_date']='Set Default Due Date';
$hesklang['category_leave_blank_for_no_default_due_date']='(leave blank for no default due date)';
$hesklang['category_default_due_date_updated']='Default due date has been updated.';
$hesklang['email_formatting']='Email formatting';
$hesklang['email_formatting_html_and_plaintext']='HTML with plain text alternative from plain text template (default)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML with plain text alternative generated from HTML template';
$hesklang['email_formatting_html']='HTML only';
$hesklang['email_formatting_plaintext']='Plain text only';
$hesklang['email_formatting_note']='Your selection in %1$s &gt; %2$s &gt; %3$s is set to: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='This means Hesk will ignore the HTML templates here.';
$hesklang['email_formatting_note1']='This means Hesk will ignore the plain text templates here.';
$hesklang['email_formatting_note2']='This means Hesk will generate plain text version of emails from your HTML templates and ignore the plain text templates here.';
$hesklang['etnu']='This email template is currently not used by Hesk based on your selection in %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Edit Category';
$hesklang['create_category']='Create Category';
$hesklang['one_user_included']='1 user included';
$hesklang['one_user_excluded']='1 user excluded';
$hesklang['x_users_included']='%s users included'; // %s = Number of users
$hesklang['x_users_excluded']='%s users excluded'; // %s = Number of users
$hesklang['aa_cat']='Auto-assign tickets in this category';
$hesklang['modify_autoassign_settings']='Modify auto-assign settings';
$hesklang['autoassign_on_all_users']='Yes, to any user with access to this category';
$hesklang['autoassign_on_select_users']='Yes, to specific users';
$hesklang['autoassign_off']='No, submit tickets as unassigned';
$hesklang['autoassign_users']='Users to include/exclude in auto-assignment';
$hesklang['autoassign_selected_include']='Selected users should be <strong>included</strong> when auto-assigning tickets in this category';
$hesklang['autoassign_selected_exclude']='Selected users should be <strong>excluded</strong> when auto-assigning tickets in this category';
$hesklang['cat_edited']='Category %s has been successfully edited';
$hesklang['search_for_user']='Search for user';
$hesklang['email_sending']='Sending emails';
$hesklang['email_to_ticket']='Email to ticket';
$hesklang['email_to_ticket_info']='Converting emails to tickets requires some server-side setup. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk is using a SMTP server to send email notifications. Your <strong>%1$s</strong> should be set to <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Missing file extension';
$hesklang['block_ignore']='Email to ticket - Ignore emails and prevent loops';
$hesklang['block_noreply']='Do not reply';
$hesklang['block_noreply2']='Ignore emails sent from &quot;do not reply&quot; email addresses';
$hesklang['block_returned']='Returned';
$hesklang['block_returned2']='Ignore returned emails, such as delivery status notifications and automated replies';
$hesklang['block_duplicate']='Duplicates';
$hesklang['block_duplicate2']='Ignore emails with the same message sent within &quot;%s&quot; seconds'; // %s = "Timeframe"
$hesklang['loop_info']='emails received from the same email address within &quot;%s&quot; seconds';
$hesklang['thist21']='<li class="smaller">%s | overdue email notification sent</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | follow-up email sent</li>'; // %s = date
$hesklang['elevator_header']='Entering Secure Area';
$hesklang['elevator_intro']='You are about to enter a secure area.';
$hesklang['elevator_enter_password']='Please enter your password to continue.';
$hesklang['elevator_duration_setting_title']='Secure area duration';
$hesklang['desc_survey']='(Customer) Follow-up (survey) email'; // Email description
$hesklang['satisfaction']['tab']='Satisfaction';
$hesklang['satisfaction']['title']='Customer Satisfaction Survey';
$hesklang['satisfaction']['intro']='Send your customers a follow-up satisfaction survey to gather feedback about their experience with your help desk.';
$hesklang['satisfaction']['tab1']='Settings';
$hesklang['satisfaction']['tab2']='Opt-out';
$hesklang['satisfaction']['enable']='Enable follow-up emails:';
$hesklang['satisfaction']['enabled']='Customer Satisfaction Surveys are enabled.';
$hesklang['satisfaction']['disabled']='Customer Satisfaction Surveys are currently disabled.';
$hesklang['satisfaction']['url']='Survey URL address:';
$hesklang['satisfaction']['send']='Follow-up email delay:';
$hesklang['satisfaction']['at_least']='Wait at least';
$hesklang['satisfaction']['after']='after the ticket is resolved before sending the email';
$hesklang['satisfaction']['h1']='How to use this tool?';
$hesklang['satisfaction']['h2']='First, create a customer satisfaction survey in your favorite survey tool. If you are unsure what tool to use or what questions to ask, we have a <a href="%s" target="_blank">guide available here</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='When your survey is ready, enable follow-up emails using the form below. Hesk will process resolved tickets with at least one staff reply once per hour and send your survey link to your customers.';
$hesklang['satisfaction']['e_url']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['as']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['oo1']='This page lists email addresses that follow-up emails will <b>not</b> be sent to.';
$hesklang['satisfaction']['oo2']='Your customers are able to opt-out from receiving survey emails by clicking a link in the email. Alternatively, you can manually add email addresses on this page.';
$hesklang['satisfaction']['ooe']='Email address to opt-out';
$hesklang['satisfaction']['ooe2']='Enter the email address you wish to opt-out from receiving survey emails.';
$hesklang['satisfaction']['ooe3']='This email address <i>%s</i> is already opted out from receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Opt-out this email';
$hesklang['satisfaction']['oob']='Opted out by';
$hesklang['satisfaction']['no_oo']='No customer has opted out of receiving survey emails.';
$hesklang['satisfaction']['oor']='Remove';
$hesklang['satisfaction']['oor2']='Email removed from opt-out';
$hesklang['satisfaction']['oor3']='Confirm removal';
$hesklang['satisfaction']['oor4']='When removed from opt-out, this user will again receive follow-up emails.';
$hesklang['satisfaction']['optedout']='The email address <i>%s</i> was opted out of receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Missing or invalid survey ID';
$hesklang['satisfaction']['starting']='Starting customer satisfaction survey notification process';
$hesklang['satisfaction']['tc']='Found %s closed tickets that did not have satisfaction survey sent.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Finished Customer Satisfaction Survey. Emails sent: %1$s. Emails failed to send: %2$s. Tickets without an email: %3$s. Tickets with opt-out email: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignoring, this customer does not wish to receive survey emails.';
$hesklang['satisfaction']['ne']='Ignoring, this ticket is without an email address';
$hesklang['satisfaction']['feat1']='Create your survey using any third-party tool, such as Google Forms';
$hesklang['satisfaction']['feat2']='set up your survey URL, preferences, and limitations inside this module';
$hesklang['satisfaction']['feat3']='when you resolve a ticket, Hesk will email your customer the link to the survey';
$hesklang['dfor']='Date format';
$hesklang['dtfor']='Date and Time';
$hesklang['cdfor']='Date select format';
$hesklang['custom']='Custom';
$hesklang['jsc_notice']='The date selection doesn\'t support PHP-style date formatting. Select one of the pre-configured options or click the %s icon below to see available display options.'; // %s = replaced by icon
$hesklang['lcf3']='Date only'; // Display: "Date only"
$hesklang['epdd']='Error parsing due_date parameter:';
$hesklang['edit_pass']='Edit password';
$hesklang['save_pass']='Save password';
$hesklang['cur_pass']='Current password';
$hesklang['cur_pass2']='You must provide your current password in order to change it.';
$hesklang['cur_pass3']='After a successful password update, you will be redirected to the login page, where you can log in with your new password.';
$hesklang['e_new_pass']='Please enter your new password';
$hesklang['pass_len']='The password must not exceed 64 characters';
$hesklang['pass_login']='Please log in again after changing your password';
$hesklang['bf_int']='You have been logged out due to too many failed verification attempts';
$hesklang['tst_cnt']='Number of emails your mail server will send to Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='You have many unread emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to mark existing emails as read before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='You have many emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to delete existing emails before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Due on'; // Due on (date)
$hesklang['search_due_date_range']='Due in'; // Due in (X days)
$hesklang['attachment_add_files']='Add file';
$hesklang['attachment_max_exceeded']='This file will not be uploaded becuase you have already uploaded the maximum number of files allowed.';
$hesklang['attachment_viewer_message']='Drag files here or click the \'Add File\' button below to select files to upload.';
$hesklang['attachment_invalid_type_message']='Sorry, but the file type you tried to upload is not allowed.';
$hesklang['attachment_upload_error']='An error occurred when trying to upload. Please try again later.';
$hesklang['attachment_too_large']='This attachment is larger than the max filesize permitted.';
$hesklang['attachment_cancel']='Cancel';
$hesklang['attachment_confirm_cancel']='Are you sure you want to cancel this upload?';
$hesklang['attachment_remove']='Remove attachment';
$hesklang['attachment_too_many_uploads']='Too many attachments have been uploaded from your location in a short period of time. Please try your request again later.';
$hesklang['sub_note']='Submit note';
$hesklang['can_view_users']='View all users (but not manage them)';
$hesklang['welcome1']='Hey there, you seem to be new here. Welcome!';
$hesklang['welcome2']='To help you get started, check out the %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk online Quick Start Guide';
$hesklang['tmce1']='Use Ctrl+Right click to access spellchecker';
$hesklang['tmce2']='Hold the Control (Ctrl) key and right-click on the misspelled word to access the spellchecker.';
$hesklang['desc_new_ticket_by_staff']='(Customer) New staff-submitted ticket';
$hesklang['mod_et_h']='You can modify email templates under %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Set language to';
$hesklang['ouwa']='Only users with access to this category are listed below. To add staff members to this category, edit their permissions on the %s page'; // %s = Team
$hesklang['previous_tickets']='Previous tickets';
$hesklang['no_previous']='No previous tickets by %s'; // %s = email address
$hesklang['all_previous']='List all previous tickets';
$hesklang['confirm_delete_ticket']='Are you sure you want to permanently delete this ticket?';
$hesklang['confirm_delete_reply']='Are you sure you want to permanently delete this reply?';
$hesklang['select_new_category']='Number of tickets in this category: %s<br><br>Please select a new category to transfer these tickets to:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deleting this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK license';
$hesklang['hlic_free']='FREE';
$hesklang['hlic_buyl']='Buy a License';
$hesklang['hlic_paid']='Licensed';
$hesklang['antdemo']='Submitting tickets from the admin panel has been disabled in the demo mode.<br><br>Please use the <a href="%s" target="_blank">public side</a> to submit a test ticket.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Authentication method';
$hesklang['email_authentication_method_username_password']='Basic (Username / Password)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - No verified OAuth providers configured.';
$hesklang['email_authentication_method_oauth_link']='Manage OAuth providers'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Authorization Endpoint URL';
$hesklang['email_oauth_token_url']='Token Endpoint URL';
$hesklang['email_oauth_client_id']='Client ID';
$hesklang['email_oauth_client_secret']='Client Secret';
$hesklang['email_oauth_scope']='Scope';
$hesklang['oauth_error_invalid_state']='OAuth state does not match the state sent to OAuth provider.';
$hesklang['oauth_error_unknown']='An unknown error occurred when attempting to save OAuth tokens.';
$hesklang['oauth_error_no_token']='Access token missing in the JSON response.';
$hesklang['oauth_error_retrieve']='Unable to retrieve an access token. Please confirm your OAuth Provider settings and re-save them to acquire a new token.';
$hesklang['email_oauth_provider']='OAuth Provider';
$hesklang['email_oauth_providers']='OAuth Providers';
$hesklang['email_oauth_provider_guide']='Before using OAuth, you must register an OAuth Provider. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Your OAuth Redirect URI for Hesk is:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Use this tool to add OAuth providers to your help desk';
$hesklang['email_oauth_provider_name']='Name'; // OAuth provider name
$hesklang['email_oauth_new_provider']='New Provider';
$hesklang['email_oauth_edit_provider']='Edit Provider';
$hesklang['email_oauth_provider_being_used_for']='Being Used For';
$hesklang['email_oauth_providers_none']='No OAuth providers saved. You can add them by clicking "New Provider" above.';
$hesklang['email_oauth_provider_cannot_be_deleted']='This provider cannot be removed because it is being used by the help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Are you sure you want to delete this OAuth provider?';
$hesklang['oauth_provider_saved']='OAuth provider has been saved';
$hesklang['oauth_provider_use']='You can now select this provider in %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Enter the provider name';
$hesklang['oauth_provider_err_auth_url']='Enter a valid authorization URL';
$hesklang['oauth_provider_err_token_url']='Enter a valid token URL';
$hesklang['oauth_provider_err_client_id']='Enter the client ID';
$hesklang['oauth_provider_err_client_secret']='Enter the client secret';
$hesklang['oauth_provider_err_scope']='Enter the scope';
$hesklang['oauth_provider_deleted']='OAuth provider deleted';
$hesklang['oauth_provider_not_found']='This OAuth provider does not exist';
$hesklang['oauth_provider_verified']='Verified';
$hesklang['oauth_provider_click_to_verify']='Click to verify';
$hesklang['can_due_date']='Can set due date'; // Permission to set and modify due date
$hesklang['can_due_date_e']='You do not have permission to set due dates';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verify Your Registration';
$hesklang['customer_verify_new_email']='Verify Your New Email Address';
$hesklang['customer_reset_password']='Reset your help desk password';
$hesklang['customer_approved']='Account Approved';
$hesklang['customer_rejected']='Account Rejected';
$hesklang['email_rejected']='Account required to submit support tickets';
$hesklang['require_curl']='This functionality requires <strong>cURL</strong> support for PHP enabled on your server. Please ask your web host to enable cURL for PHP.';
$hesklang['customer_accounts_heading']='Customer Accounts';
$hesklang['customer_accounts']='Customer accounts';
$hesklang['customer_accounts_off']='<strong>Disabled</strong>';
$hesklang['customer_accounts_allowed']='<strong>Enabled - Optional</strong> (customers can submit support tickets without registering or logging in)';
$hesklang['customer_accounts_required_to_submit']='<strong>Enabled - Required for tickets</strong> (only logged-in customers can submit support tickets)';
$hesklang['customer_accounts_required']='<strong>Enabled - Required to access</strong> (only logged-in customers can access the help desk and knowledgebase)';
$hesklang['customer_accounts_reg']='Account registration';
$hesklang['customer_accounts_reg_customer']='Customers can register accounts';
$hesklang['customer_accounts_reg_approve']='Customers can register account, staff must approve new registrations';
$hesklang['customer_accounts_reg_staff']='Only staff can register customer accounts';
$hesklang['customer_accounts_allow_email_changes']='Allow customers to change their email address';
$hesklang['customer_accounts_allow_email_resends']='Time until customers can request new verification email';
$hesklang['customer_login']='Login';
$hesklang['customer_logout']='Logout';
$hesklang['customer_register']='Register';
$hesklang['customer_accounts_disabled']='Customer logins and registrations are disabled.';
$hesklang['customer_accounts_registration_disabled']='Customer registrations are disabled.';
$hesklang['customer_forgot_password']='Forgot password?';
$hesklang['customer_email']='Email Address';
$hesklang['customer_accounts_email_banned']='You have been banned from using this helpdesk.';
$hesklang['customer_registration_successful']='Registration Successful!';
$hesklang['customer_registration_email_exists_no_reset_link']='An account with email %s already exists.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='An account with email %s already exists. <a href="login.php">Do you wish to log in instead</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='An account with email %s already exists and is pending email verification.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='An account with email %s already exists and is pending staff approval.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Check Your Email!';
$hesklang['customer_registration_check_your_email_content']='You must verify your email address before being able to log in.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_not_verified']='You must verify your email address before being able to log in.';
$hesklang['customer_login_not_verified2']='If you did not receive the verification email from us, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_resend_verification_email']='Re-send verification email';
$hesklang['customer_login_resend_verification_email_none']='There are no pending email verifications to send.';
$hesklang['customer_login_resend_verification_email_too_early']='You cannot request a new verification email at this time, please try again later.';
$hesklang['customer_login_not_approved']='A member of staff must approve your account before being able to log in. Once approved, you will be notified via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verify Registration';
$hesklang['customer_registration_verify_success']='Your email has been verified and you may now log in using the form below.';
$hesklang['customer_registration_verify_approval_needed']='Your email has been verified. However, a member of staff must approve your account before being able to log in. Once approved, you will be notified via email.';
$hesklang['customer_registration_verify_failure']='Your email could not be verified. Either the link has already been used or has expired.';
$hesklang['emails_to_customers']='&raquo; Emails sent to customers';
$hesklang['emails_to_staff']='&raquo; Emails sent to staff';
$hesklang['emails_to_everyone']='&raquo; Emails sent to staff or customers';
$hesklang['new_customer_approval']='You have customer accounts pending approval'; // Email subject
$hesklang['desc_new_customer_approval']='(Staff) Customer accounts pending approval';
$hesklang['n_cust_app']='There are pending customer approvals'; // Notify me when...
$hesklang['et_num_customers']='Number of pending approvals';
$hesklang['et_link_customers']='Link to the Manage customers page';
$hesklang['et_link_verify']='Verification link';
$hesklang['et_cust_login']='Customer login URL';
$hesklang['submit_ticket_customer_email_exists']='A customer with this email already exists. Please <a href="login.php?email=%s">log in</a> to submit a ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Please enter a valid email address.';
$hesklang['customer_login_password_required']='Please enter your password.';
$hesklang['customer_login_remember_just_email']='Remember just my email';
$hesklang['customer_login_remember_email']='Remember my email';
$hesklang['customer_wrong_user']='Your email address %s is not registered with us.<br><br>Do you wish to <a href="register.php">create an account</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Your email address and password do not match our records.<br><br>Do you wish to <a href="login.php?submittedForgot=1">reset your password</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Please log in to continue.';
$hesklang['customer_register_here']='If you don\'t have an account with us, you can <a href="register.php">register here</a>.';
$hesklang['create_account']='Create an account';
$hesklang['customer_my_tickets_heading']='My tickets';
$hesklang['customer_my_tickets_description']='View all of your previous tickets';
$hesklang['customer_my_tickets_search_for_tickets']='Search for tickets';
$hesklang['customer_password_reset_successful']='Your new password has been saved. You may now log in.';
$hesklang['customer_profile']='Profile';
$hesklang['customer_edit_profile']='Edit Profile';
$hesklang['customer_edit_pass']='Edit Password';
$hesklang['customer_edit_pass_same']='Your new password must not be the same as your current one.';
$hesklang['customer_change_email']='Change Email';
$hesklang['customer_change_email_banned']='The email you entered is banned.';
$hesklang['customer_change_email_pending']='There is a current request to change your email address to: <b>%s</b><br><br>We have sent an email to this address. Please click the link inside the email to confirm the change.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Re-send confirmation email</a>';
$hesklang['customer_change_email_submitted']='Please click the verification link that was sent to <b>%s</b> to verify your new email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Your new email address has been verified and your profile updated.';
$hesklang['customer_change_email_disabled']='The ability to update your email is disabled. Contact us if you wish to change your email address.';
$hesklang['customer_profile_saved']='Your profile has been saved.';
$hesklang['customers']='Customers';
$hesklang['customers_intro']='Customer accounts allow customers to view all of their tickets in a central location.';
$hesklang['sure_remove_customer']='Are you sure you want to remove this customer?';
$hesklang['sure_remove_customer_additional_note']='Deleting a customer is final.  Once deleted, they cannot be recovered!';
$hesklang['new_customer']='New Customer';
$hesklang['new_follower']='New Follower';
$hesklang['add_customer']='+ Add Customer'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Add Follower'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='The provided customer does not yet exist. Click "Save" if you would like to create this customer.';
$hesklang['followers']='Followers';
$hesklang['no_customers']='There are currently no customers in the database.';
$hesklang['no_customers_disabled']='You will start seeing customers here when they submit support tickets.';
$hesklang['no_customers_enabled']='You will start seeing customers here when they register or submit support tickets.';
$hesklang['no_customers_enabled2']='Alternatively, the buttons above this message allow you to manually create customer accounts or import existing customers into the help desk.';
$hesklang['import_customers']='Import Customers';
$hesklang['import_customers_tip']='Use a CSV file to import multiple customers at once.';
$hesklang['customer_not_found']='Customer not found for ticket!';
$hesklang['search_by_name_or_email']='Search by name or email...';
$hesklang['search_by_pattern']='Search by pattern...';
$hesklang['is_searchable']='Searchable';
$hesklang['custom_is_searchable']='Searchable';
$hesklang['yes_via_autocomplete']='YES (search via autocomplete)';
$hesklang['customer_required']='You must select a customer';
$hesklang['customer_email_exists']='A customer with this email already exists.';
$hesklang['customer_name_with_no_email_exists']='A customer with this name and no email already exists.';
$hesklang['an_error_occurred_validating_email']='An error occurred when attempting to verify the entered email address.';
$hesklang['customer_count_x_more']='+%s more'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registered';
$hesklang['customer_account_verified']='Verified';
$hesklang['customer_account_verified_help']='Customers must verify their account via an activation link sent to their email address before being able to log into their account.';
$hesklang['customer_account_setting_password_will_verify_user']='Setting a password for this customer will automatically verify their account.';
$hesklang['deleting_customer_with_tickets']='This customer has %1$s ticket(s) <b>(%2$s open)</b> that also have other customers associated with them.<br>What should be done with these tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='A valid email address is needed to re-send a verification email.';
$hesklang['customer_resend_verification_email_not_found']='No account exists with this email address, or the account has already been verified.';
$hesklang['customer_resend_verification_email_sent']='A verification email has been sent to your email address.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_permission_denied']='You do not have permission to modify customers.';
$hesklang['customer_manage_approvals']='Customer accounts pending approval: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approve customer';
$hesklang['customer_manage_bulk_approve']='Approve Selected Customers';
$hesklang['customer_manage_bulk_approve_complete']='Customers approved: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Reject customer';
$hesklang['customer_manage_bulk_reject']='Reject Selected Customers';
$hesklang['customer_manage_bulk_reject_complete']='Customers rejected: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Delete customer';
$hesklang['customer_manage_bulk_delete']='Delete Selected Customers';
$hesklang['customer_manage_bulk_delete_complete']='Customers deleted: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Edit customer';
$hesklang['customer_manage_verification_email_sent']='Verification email has been sent to %s'; // %s = customer's email
$hesklang['can_man_customers']='Manage customers';
$hesklang['can_view_customers']='View all customers (but not manage them)';
$hesklang['import_customer_select_file']='Select File';
$hesklang['import_customer_step1_instructions']='To import customers, prepare a CSV (Comma-Separated Values) file.';
$hesklang['import_customer_step1_note']='Select Your CSV File';
$hesklang['import_customer_step1_separator']='Columns in my CSV file are separated by';
$hesklang['import_customer_sample']='&raquo; Sample CSV files';
$hesklang['import_customer_sample_1']='US-style CSV file with columns separated by ,';
$hesklang['import_customer_sample_2']='EU-style CSV file with columns separated by ;';
$hesklang['import_customer_upload_requirements_1']='Your CSV file must include at least a name or an email address column. The password column is optional.';
$hesklang['import_customer_upload_requirements_2']='The first row of your file must contain column headers.';
$hesklang['import_customer_upload_requirements_3']='Your file must be encoded in UTF-8.';
$hesklang['import_customer_select_columns']='Select Columns';
$hesklang['import_customer_upload_customers']='Upload Customers';
$hesklang['import_customer_column_name']='Name Column';
$hesklang['import_customer_column_email']='Email Column';
$hesklang['import_customer_column_pass']='Password Column';
$hesklang['import_customer_step2_note']='Select the correct column name from your CSV file in the dropdowns, and then click "Next".';
$hesklang['import_customer_name_or_email_required']='Name or email is required';
$hesklang['import_customer_step3_note']='Your customers are being imported. Do not leave this page!';
$hesklang['import_customer_step3_pending']='Pending';
$hesklang['import_customer_step3_successful_imports']='Successful Imports';
$hesklang['import_customer_step3_failed_imports']='Failed Imports';
$hesklang['import_customer_step3_progress']='Progress';
$hesklang['import_customer_step3_complete_some_failed']='The import process is complete, however <b>%s</b> customers failed to import. Check the table below for more information.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='The import process is complete!';
$hesklang['import_customer_step3_importing']='Importing';
$hesklang['staff_deleted']='[Staff Deleted]';
$hesklang['customer_account_approved']='Customer registration approved';
$hesklang['customer_account_rejected']='Customer registration rejected';
$hesklang['customer_account_deleted']='Customer registration deleted';
$hesklang['ticket_followers']='Ticket followers';
$hesklang['ticket_followers2']='Allow tickets to have multiple customers';
$hesklang['add_cc']='Add Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separate each email with a comma.';
$hesklang['search_customers']='Search Customers';
$hesklang['page_size']='Page Size';
$hesklang['customers_on_pages']='Number of customers: %d | Number of pages: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Customer) Reset your password';
$hesklang['desc_customer_verify_registration']='(Customer) Verify your registration';
$hesklang['desc_customer_verify_new_email']='(Customer) Verify your new e-mail';
$hesklang['desc_customer_approved']='(Customer) Account approved';
$hesklang['desc_customer_rejected']='(Customer) Account rejected';
$hesklang['desc_email_rejected_can_self_register']='(Customer) Ticket via email rejected; customer can self-register';
$hesklang['desc_email_rejected_cannot_self_register']='(Customer) Ticket via email rejected; customer cannot self-register';
$hesklang['user_added_success_no_pass']='New user %s has been successfully added';
$hesklang['email_tag_requester']='Requester (From)';
$hesklang['email_tag_requester_name']='Requester (From) Name';
$hesklang['email_tag_requester_first_name']='Requester (From) First Name';
$hesklang['email_tag_requester_email']='Requester (From) Email';
$hesklang['email_tag_followers']='Followers (Cc)';
$hesklang['email_tag_follower_names']='Follower (Cc) Names';
$hesklang['email_tag_follower_emails']='Follower (Cc) Emails';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Display a barcode on printed tickets';
$hesklang['barcode_staff_only']='Hide the barcode from customers';
$hesklang['barcode_type']='Barcode type';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Width';
$hesklang['barcode_height']='Height';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Background';
$hesklang['copy_link']='Copy ticket link';
$hesklang['copy_link_title']='Copy public link to this ticket';
$hesklang['copy_link_exp']='The copied link is the direct link for the customer to view this ticket';
$hesklang['copy_value']='Copy this value';
$hesklang['download_class']='This function requires the ZipArchive class. Ask your host to compile PHP with zip support.';
$hesklang['download_all']='Download all';
$hesklang['download_prep']='Preparing download...';
$hesklang['download_tma']='Too many attachments';
$hesklang['download_nva']='No valid attachments';
$hesklang['download_ntd']='Nothing to download';
$hesklang['resolved_at']='Resolved at';
$hesklang['disable_GSSAPI']='Disable GSSAPI authenticator (Kerberos error work-around)';
$hesklang['ex_history']='Include ticket history log in export';
$hesklang['sm_location']='Location'; // Location (page) of a service message
$hesklang['loc_sm']='Show this service message on:';
$hesklang['loc_all']='Every customer page';
$hesklang['loc_norec']='(not recommended)';
$hesklang['loc_home']='Help desk homepage';
$hesklang['loc_selected']='On selected pages';
$hesklang['loc_selerr']='Select at least one page to show the message on';
$hesklang['loc_t_cat']='Submit a ticket - select a category';
$hesklang['loc_t_add']='Submit a ticket - submit a ticket form';
$hesklang['loc_t_ok']='Submit a ticket - ticket confirmation';
$hesklang['loc_t_view']='View a ticket';
$hesklang['loc_t_form']='View a ticket form';
$hesklang['loc_kb_main']='Knowledgebase homepage';
$hesklang['loc_kb_sub']='Knowledgebase sub-category pages';
$hesklang['loc_kb_art']='Knowledgebase articles';
$hesklang['loc_login']='Customer login page';
$hesklang['loc_register']='Customer registration page';
$hesklang['loc_register_ok']='Customer registration successful';
$hesklang['loc_acc']='Customer &quot;My tickets&quot; page';
$hesklang['loc_profile']='Customer &quot;Profile&quot; page';
$hesklang['sending_show']='Show &quot;Submitting&quot; notification';
$hesklang['sending_wait']='Submitting, please wait...';
$hesklang['e_c_email']='Enter the correct email address to view this ticket';
$hesklang['only_verified_cc']='Followers without a verified account will be ignored.';
$hesklang['followers_removed']='These email addresses have been removed from the ticket because they do not have a verified account:';
$hesklang['novace']='We did not find any registered and verified accounts with this email address.';
$hesklang['max_recipients']='Max recipients';
$hesklang['max_recipients2']='in a single email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Load an extra custom Javascript file for the admin panel';
$hesklang['cf_limit_all']='You have reached the custom fields limit and cannot create new custom fields.';
$hesklang['remind_assigned']='Remind assigned staff';
$hesklang['remind_sent']='Email reminder to the assigned staff member sent';
$hesklang['thist23']='<li class="smaller">%s | reminder sent to %s by %s</li>';
$hesklang['ql_bookmarks']='Bookmarks';
$hesklang['bookmark']='My Bookmark';
$hesklang['bookmarks_add']='Add to Bookmarks';
$hesklang['bookmarks_added']='This ticket has been added to your Bookmarks';
$hesklang['bookmarks_remove']='Remove from Bookmarks';
$hesklang['bookmarks_removed']='This ticket has been removed from your Bookmarks';
$hesklang['genl_not_copied']='Error: Copying to clipboard not supported on this device/browser.';
$hesklang['profile_duplicate_email']='User with email <b>%s</b> already exists.'; // %s: new email
$hesklang['seq_id_numeric']='Ticket number search must contain numbers only';
$hesklang['confirm_new_pass']='Confirm new password';
$hesklang['piping_notify_rejected_customers1']='Customer rejection emails';
$hesklang['piping_notify_rejected_customers2']='Send a rejection email to customers when their ticket is rejected';
$hesklang['piping_notify_rejected_customers3']='Time between rejection emails';
$hesklang['register_url']='Registration URL';
$hesklang['email_subject']='Email subject';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborating on ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Staff replied to: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note added to: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket overdue: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolved: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Follow-up email cutoff date:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Do not email tickets resolved more than'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ago (must be longer time period than "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='The email cutoff date period must be longer than the follow-up email delay';
$hesklang['available_language']='Available Languages';
$hesklang['click_to_show_available_language']='Click to show available languages';
$hesklang['install_lan']='Install';
$hesklang['remove_lan']='Remove';
$hesklang['title_lan']='Title';
$hesklang['description_lan']='Description';
$hesklang['completed_lan']='Completed';
$hesklang['no_language_availble']='No languages are available';
$hesklang['success_install_lan_txt']='language has been successfully added';
$hesklang['error_install_lan_txt']='language has not been added';
$hesklang['success_remove_lan_txt']='language has been successfully removed';
$hesklang['error_remove_lan_txt']='language has not been removed';
$hesklang['remove_default_language_error']='The default language must remain active and cannot be removed';
$hesklang['click_for_manual_step']='Click for Manual installation';
$hesklang['upgrade_lan']='Update';
$hesklang['success_upgrade_lan_txt']='language has been successfully Updated';
$hesklang['error_upgrade_lan_txt']='language has not been Updated';
$hesklang['please_wait']='Please wait...';
$hesklang['add_a_note']='Add a note';
$hesklang['add_a_reply']='Add a reply';
$hesklang['customer_id']='Customer ID';
$hesklang['deleting_customer_tickets']='Tickets opened by customer: <b>%1$s</b><br>What should we do with these tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets where customer is copied: <b>%1$s</b><br>These will lose this customer as a follower; tickets remain unchanged.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Permanently delete tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymize tickets (remove messages and personal data)';
$hesklang['deleting_customer_retain_tickets2']='Keep tickets (leave all data intact)';
$hesklang['for_staff']='for help desk staff'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='for customers'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Email Attachment Options';
$hesklang['link_to_attachments_in_emails']='Link to attachments in emails';
$hesklang['add_attachments_directly_to_emails']='Add attachments directly to emails';
$hesklang['directly_attach_file_smaller_than']='Directly attach only files smaller than';
$hesklang['directly_attach_file_of_any_size']='Directly attach files of any size';
$hesklang['directly_attach_only_first_x_attachments']='Directly attach only first';
$hesklang['directly_attach_all_attachments']='Directly attach all attachments';
$hesklang['directly_attach_size']='Attachment size';
$hesklang['directly_attach_no_of_files']='Number of files';
$hesklang['notice_about_directly_attach_files']='Attaching many or large files to emails may case delays when communicating with your SMTP server';
$hesklang['fatt_2']='Additional files attached to this message:';
$hesklang['no_collaborators']='None';
$hesklang['collaborate']='Collaborate on this ticket';
$hesklang['collaborators']='Collaborators';
$hesklang['ql_cbm']='Collaborator';
$hesklang['collaborating']='You are now collaborating on this ticket';
$hesklang['not_collaborating']='You are not collaborating on this ticket anymore';
$hesklang['add_collaborator']='Add a collaborator';
$hesklang['user_collaborator_added']='User added as a collaborator on this ticket';
$hesklang['remove_collaborator']='Remove collaborator';
$hesklang['staff_name']='Staff name';
$hesklang['user_collaborator_removed']='User removed as a collaborator on this ticket';
$hesklang['desc_collaborator_added']='(Staff) You are collaborating on a new ticket';
$hesklang['desc_collaborator_staff_reply']='(Staff) A staff member responded to a collaborated ticket';
$hesklang['desc_collaborator_note']='(Staff) New note added to a collaborated ticket';
$hesklang['desc_collaborator_resolved']='(Staff) A collaborated ticket has been resolved';
$hesklang['desc_collaborator_overdue']='(Staff) A collaborated ticket is overdue';
$hesklang['notify_collaborator_added']='I am added as a ticket collaborator';
$hesklang['notify_collaborator_customer_reply']='Customer responds to a collaborated ticket';
$hesklang['notify_collaborator_staff_reply']='Staff responds to a collaborated ticket';
$hesklang['notify_collaborator_note']='Staff adds a note to a collaborated ticket';
$hesklang['notify_collaborator_resolved']='Staff resolves a collaborated ticket';
$hesklang['notify_collaborator_overdue']='Collaborated ticket is overdue';
$hesklang['recurring_tickets']['tab']='Recurring Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Recurring Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automate the busywork; let Hesk raise routine tickets for you, exactly when you need them.';
$hesklang['recurring_tickets']['active_rules']='Active rules';
$hesklang['recurring_tickets']['new']='New recurring ticket rule';
$hesklang['recurring_tickets']['no_rules']='You do not have any recurring ticket rules. Create one by clicking the &quot;New recurring ticket rule&quot; button above.';
$hesklang['recurring_tickets']['title']='Rule title';
$hesklang['recurring_tickets']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['recurring_tickets']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Rule trigger';
$hesklang['recurring_tickets']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['recurring_tickets']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Creation Time'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='General Settings'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Custom Fields'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Content'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Delete this rule?';
$hesklang['recurring_tickets']['edit']='Editing recurring ticket rule ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Within:';
$hesklang['recurring_tickets']['minutes']='minutes';
$hesklang['recurring_tickets']['hours']='hours';
$hesklang['recurring_tickets']['days']='days';
$hesklang['recurring_tickets']['weeks']='weeks';
$hesklang['recurring_tickets']['months']='months';
$hesklang['recurring_tickets']['years']='years';
$hesklang['recurring_tickets']['setpri']='Set priority to:';
$hesklang['recurring_tickets']['setsta']='Set status to:';
$hesklang['recurring_tickets']['assto']='Assign ticket to:';
$hesklang['recurring_tickets']['asm']='Another staff member';
$hesklang['recurring_tickets']['notify']='Notify staff members...';
$hesklang['recurring_tickets']['ato']='Apply to:';
$hesklang['recurring_tickets']['save']='Save rule';
$hesklang['recurring_tickets']['e_tt']='Time should be between 1 and 10000';
$hesklang['recurring_tickets']['nocat']='Select at least one category';
$hesklang['recurring_tickets']['nouser']='Select at least one user';
$hesklang['recurring_tickets']['nostatus']='Select at least one status';
$hesklang['recurring_tickets']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='New rule has been created';
$hesklang['recurring_tickets']['mdf']='Rule settings have been saved';
$hesklang['recurring_tickets']['e_id']='No rule with this ID found';
$hesklang['recurring_tickets']['deleted']='Selected rule has been deleted';
$hesklang['recurring_tickets']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Active'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activate this rule (start using it)';
$hesklang['recurring_tickets']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['recurring_tickets']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No active recurring ticket rules';
$hesklang['recurring_tickets']['tools']='Tools';
$hesklang['recurring_tickets']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               <strong>Active rules are processed every %2$s minutes.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Rule #%s';
$hesklang['recurring_tickets']['r3']='Rule #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Number of tickets already created today: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reset this rule';
$hesklang['recurring_tickets']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any tickets already generated for it today, might be re-generated on next cron run.';
$hesklang['recurring_tickets']['reset3']='Selected rule has been reset';
$hesklang['recurring_tickets']['test']='Simulate this rule';
$hesklang['recurring_tickets']['testa']='Simulate all rules';
$hesklang['recurring_tickets']['testaa']='Simulate all active rules';
$hesklang['recurring_tickets']['testr']='Simulation results';
$hesklang['recurring_tickets']['rsim']='Repeat simulation';
$hesklang['recurring_tickets']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['recurring_tickets']['sic']='SIMULATION COMPLETE';
$hesklang['recurring_tickets']['rrule_type_required']='Please select a valid recurring rule trigger.';
$hesklang['recurring_tickets']['rrule_string_required']='Please select all required recurring rule trigger options.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Please enter an interval value of 1 or bigger for "Every".';
$hesklang['recurring_tickets']['disable_note']='*If any critical hesk settings are changed after creation of a rule, it will be disabled on next run attempt and needs to be edited to pass new validation requirements.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | submitted by Recurring Tickets Rule "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | closed automatically by Recurring Tickets Rule "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status changed to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatically assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Rule was disabled due to validation errors. Check below for details.';
$hesklang['recurring_tickets']['errors_title']='One or more of your rules have produced errors when they attempted to be ran and were disabled.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Rule #%s errors:';
$hesklang['recurring_tickets']['create_customers']='There are no existing customers - please create them <a href="%s" target="_blank">here</a>.';
$hesklang['recurring_tickets']['exec_dates']='Rule execution dates';
$hesklang['recurring_tickets']['show_exec_dates']='[Show current rule execution dates]';
$hesklang['recurring_tickets']['no_exec_dates']='Please select valid rule triggers to see execution dates.';
$hesklang['recurring_tickets']['invalid_disabled']='invalid Rrule settings - rule disabled.';
$hesklang['recurring_tickets']['next_occ']='Next %s rule occurrences:';
$hesklang['recurring_tickets']['occ_on']='on %s';
$hesklang['recurring_tickets']['not_firing_today']='does not need firing today.';
$hesklang['recurring_tickets']['rules_fulfilled']='recurring rules fulfilled - ticket created today!';
$hesklang['recurring_tickets']['validation_failed']='validation failed - rule disabled. Details below:';
$hesklang['recurring_tickets']['validation_error']='Validation error:';
$hesklang['recurring_tickets']['processed']='processed.';
$hesklang['recurring_tickets']['created_ticket']='created ticket id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relative to ticket creation date';
$hesklang['priorities']='Priorities';
$hesklang['priority_intro']='Use this tool to manage ticket priorities for your help desk';
$hesklang['new_priority']='New priority';
$hesklang['edit_priority']='Edit priority';
$hesklang['priority_title']='Title';
$hesklang['can_customers_select_it']='Can customers select this priority?';
$hesklang['selected_by_customer']='Selectable by customers';
$hesklang['err_priority']='Enter the priority title';
$hesklang['priority_added']='A new priority has been added';
$hesklang['priority_e_id']='Invalid priority ID';
$hesklang['priority_mdf']='Priority has been saved';
$hesklang['priority_deleted']='Priority deleted';
$hesklang['priority_not_found']='This priority does not exist';
$hesklang['priority_not_empty']='This priority cannot be deleted because tickets with this priority exist';
$hesklang['click_to_enable_drag_drop']='Click to enable drag-and-drop for the row, then drag the row up or down to re-arrange priorities.';
$hesklang['confirm_delete_priority']='Are you sure you want to delete this priority?';
$hesklang['reordered_message']='Your priority list order has been saved.';
$hesklang['list_tkt_priority']='List all tickets with this priority';
$hesklang['deletion_priority_restricted']='This is a special priortiy and cannot be deleted';
$hesklang['priority_limit']='You cannot create any new priorities';
$hesklang['skip_to_main_content']='Skip to Main Content';
$hesklang['opens_dialog']='Opens a dialog';
$hesklang['create_a_ticket']='Create a ticket';
$hesklang['toggle_navigation']='Toggle navigation';
$hesklang['add_a_ticket_reply']='Add a ticket reply';
$hesklang['linked_tickets']='Linked tickets';
$hesklang['no_linked_tickets']='No linked tickets';
$hesklang['link_ticket']='Link ticket';
$hesklang['can_link_tickets_e']='You are not authorized to link/unlink this ticket';
$hesklang['link_ticket_success']='The ticket has been linked successfully';
$hesklang['link_ticket_required_error']='To link a ticket, please provide a valid Tracking ID';
$hesklang['link_ticket_itself_error']='A ticket cannot be linked to itself. Please enter a different Tracking ID';
$hesklang['already_linked_error']='The ticket has already been linked';
$hesklang['unlink_success']='The ticket has been successfully unlinked';
$hesklang['unlink_error']='No linked record exists';
$hesklang['link_history']='<li class="smaller">%s | %s ticket linked by %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket unlinked by %s</li>';
$hesklang['can_link_tickets']='Can link ticket';
$hesklang['link_a_ticket']='Link a ticket';
$hesklang['mfa_curl']='Unable to generate a QR image to scan because <strong>cURL</strong> support is not enabled on your server.';
$hesklang['require_xml']='PHP-XML must be enabled for Rich Text (HTML) messages. Please ask your web host to enable XML for PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s added as a collaborator by %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removed as a collaborator by %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfect for preventive-maintenance jobs, monthly access reviews, recurring customer check-ins, and more.';
$hesklang['recurring_tickets']['feat1']='<strong>Set and forget schedules.</strong> Daily, every Monday, every March, the 15th of each month, or any future date';
$hesklang['recurring_tickets']['feat2']='<strong>Arrive pre-filled and assigned.</strong> Choose category, priority, agent, and up to 100 custom field values';
$hesklang['recurring_tickets']['feat3']='<strong>Preview dates and Simulate.</strong> See every ticket Hesk will generate before activating a rule, so there are no surprises.';
$hesklang['unlink_btn']='Unlink';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');