<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Dansk (Danish)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Lars Juul (https://www.eucl.dk)
* Claus Trillingsgaard
* Robert Froslev (http://www.webhosting-hotel.com)
* Michael R. Christensen (http://www.micco.dk)
* Erling Christensen
* Martin Tranberg (https://blueprint.dk)
* Christian Bruun (https://christianb.dk)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Dansk';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Danish';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_danish_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Skriv dit svar over denne linje ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Ny sag: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Sag modtaget: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Sag tildelt: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nyt svar til: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nyt svar til: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Sagen blev flyttet: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Der blev tilføjet en note til: %%SUBJECT%%';
$hesklang['new_pm']='Ny privat besked: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Liste over dine supportsager';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Kan ikke forbinde til databasen!';
$hesklang['invalid_action']='Ulovlig handling';
$hesklang['select_username']='Skriv brugernavn';
$hesklang['enter_pass']='Skriv adgangskode';
$hesklang['cant_sql']='Kan ikke udføre SQL';
$hesklang['contact_webmsater']='Kontakt sidens webmaster';
$hesklang['mysql_said']='MySQL returnerede';
$hesklang['wrong_pass']='Forkert adgangskode.';
$hesklang['session_expired']='Din session er udløbet. Log ind igen.';
$hesklang['attempt']='Ulovligt forsøg!';
$hesklang['not_authorized_tickets']='Du har ikke adgang til at se sager i denne kategori.';
$hesklang['must_be_admin']='Du har ikke adgang til at se denne side. For at se siden skal du være logget ind som administrator.';
$hesklang['no_session']='Kan ikke starte en ny session!';
$hesklang['error']='Fejl';
$hesklang['int_error']='Intern script-fejl';
$hesklang['no_trackID']='Intet sags-ID';
$hesklang['status_not_valid']='Status ikke gyldig';
$hesklang['trackID_not_found']='Sags-ID blev ikke fundet';
$hesklang['enter_message']='Indtast venligst din besked';
$hesklang['select_priority']='Vælg prioritet';
$hesklang['ticket_not_found']='Sagen kunne ikke findes. Kontroller, at du har indtastet det korrekte sags-ID.';
$hesklang['no_selected']='Ingen sager markeret. Ingen ændring foretaget.';
$hesklang['id_not_valid']='Id\'et er ikke gyldigt.';
$hesklang['enter_id']='Indtast sags-ID.';
$hesklang['enter_name']='Indtast kundens navn';
$hesklang['enter_date']='Indast datoen, du vil søge på';
$hesklang['date_not_valid']='Datoen er ikke en gyldig. Angiv datoen i følgende format <b>ÅÅÅÅ-MM-DD</b> .';
$hesklang['enter_subject']='Indtast sagens emne';
$hesklang['invalid_search']='Ugyldig søgning';
$hesklang['choose_cat_ren']='Vælg kategorien, du vil omdøbe';
$hesklang['cat_ren_name']='Skriv det nye kategorinavn';
$hesklang['cat_not_found']='Kategorien findes ikke';
$hesklang['enter_cat_name']='Skriv kategoriens navn';
$hesklang['no_cat_id']='Intet kategori-ID';
$hesklang['cant_del_default_cat']='Du kan ikke slette standard-kategorien, men du kan omdøbe den';
$hesklang['no_valid_id']='Ugyldigt bruger-ID';
$hesklang['user_not_found']='Brugeren findes ikke';
$hesklang['enter_real_name']='Indtast brugerens fulde navn';
$hesklang['enter_valid_email']='Indtast en gyldig e-mail adresse';
$hesklang['enter_username']='Indtast brugernavn (login)';
$hesklang['asign_one_cat']='Tilføj brugeren til mindst en kategori!';
$hesklang['signature_long']='Brugersignatur er for lang! Begræns venligst signaturen til 1000 tegn';
$hesklang['confirm_user_pass']='Bekræft adgangskode';
$hesklang['passwords_not_same']='De to adgangskoder er ikke ens.';
$hesklang['cant_del_admin']='Du kan ikke slette systemets oprindelige administrator.';
$hesklang['cant_del_own']='Du kan ikke slette den profil, du er logget på med.';
$hesklang['enter_your_name']='Skriv dit navn';
$hesklang['sel_app_cat']='Vælg den rette kategori';
$hesklang['sel_app_priority']='Vælg den rette prioritet';
$hesklang['enter_ticket_subject']='Skriv emnet på din sag';
$hesklang['user_not_found_nothing_edit']='Brugeren blev ikke fundet, eller der var ikke noget at ændre';

// ADMIN PANEL
$hesklang['administrator']='Administrator';
$hesklang['login']='Log ind';
$hesklang['user']='Bruger';
$hesklang['username']='Brugernavn';
$hesklang['pass']='Adgangskode';
$hesklang['confirm_pass']='Bekræft adgangskode';
$hesklang['logged_out']='Logget ud';
$hesklang['logout']='Log ud';
$hesklang['logout_success']='Du er nu logget ud';
$hesklang['click_login']='Klik her for at logge på';
$hesklang['back']='Gå tilbage';
$hesklang['displaying_pages']='Viser <b>%d</b> sager. Sider:';
$hesklang['trackID']='Sags-ID';
$hesklang['timestamp']='Tidsstempel';
$hesklang['name']='Navn';
$hesklang['subject']='Emne';
$hesklang['status']='Status';
$hesklang['priority']='Prioritet';
$hesklang['open']='Ny';
$hesklang['open_action']='Åbn sag'; // Open ACTION
$hesklang['close']='Lukkede'; // Closed ticket STATUS
$hesklang['any_status']='Enhver status';
$hesklang['high']='Høj';
$hesklang['medium']='Medium';
$hesklang['low']='Lav';
$hesklang['del_selected']='Slet valgte sager';
$hesklang['manage_cat']='Administrer kategorier';
$hesklang['profile']='Din profil';
$hesklang['show_tickets']='Vis supportsager';
$hesklang['sort_by']='Sorter efter';
$hesklang['date_posted']='Posteringsdato';
$hesklang['category']='Kategori';
$hesklang['any_cat']='Alle kategorier';
$hesklang['order']='Rækkefølge';
$hesklang['ascending']='stigende';
$hesklang['descending']='faldende';
$hesklang['display']='Vis';
$hesklang['tickets_page']='sager per side';
$hesklang['find_ticket']='Find sag';
$hesklang['yyyy_mm_dd']='ÅÅÅÅ-MM-DD';
$hesklang['results_page']='resultater per side';
$hesklang['opened']='åbnet'; // The ticket has been OPENED
$hesklang['closed']='Løst'; // Ticket has been RESOLVED
$hesklang['ticket']='Sag';
$hesklang['tickets']='Sager';
$hesklang['ticket_been']='Denne sag er blevet';
$hesklang['view_ticket']='Vis sag';
$hesklang['open_tickets']='Åbne sager';
$hesklang['remove_statement']='Fjern &quot;Powered by&quot; statement';
$hesklang['click_info']='Klik her for mere information';
$hesklang['reply_added']='Svar tilføjet';
$hesklang['reply_submitted']='Svar indsendt';
$hesklang['ticket_marked']='Denne sag er blevet markeret';
$hesklang['ticket_status']='Sagsstatus';
$hesklang['replies']='Svar';
$hesklang['date']='Dato';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Besked';
$hesklang['add_reply']='Tilføj svar';
$hesklang['close_this_ticket']='Markér denne supportsag som løst';
$hesklang['change_priority']='ændre prioritet til';
$hesklang['attach_sign']='Tilføj signatur';
$hesklang['profile_settings']='Profilindstillinger';
$hesklang['submit_reply']='Tilføj svar';
$hesklang['support_panel']='Supportpanel';
$hesklang['ticket_trackID']='Sags-ID';
$hesklang['c2c']='Klik for at fortsætte';
$hesklang['tickets_deleted']='Sager slettet';
$hesklang['num_tickets_deleted']='Antal slettede sager: <b>%d</b>';
$hesklang['confirm_del_cat']='Er du sikker på, at du vil slette denne kategori?';
$hesklang['cat_intro']='Her er du i stand til at administrere kategorier. Kategorier er nyttige
til at kategorisere sager efter relevans (f.eks. &quot;Salg&quot;,
&quot;Hardwareproblemer&quot;, &quot;PHP/MySQL-problemer&quot; osv.) og for
tildele brugere til kategorier.';
$hesklang['cat_name']='Navn';
$hesklang['remove']='Fjern';
$hesklang['add_cat']='Ny kategori';
$hesklang['max_chars']='maks 40 tegn';
$hesklang['create_cat']='Gem kategori';
$hesklang['ren_cat']='Omdøb kategori';
$hesklang['to']='til';
$hesklang['cat_added']='Kategori tilføjet';
$hesklang['cat_name_added']='Kategorien %s blev tilføjet';
$hesklang['cat_renamed']='Kategori omdøbt';
$hesklang['cat_renamed_to']='Den valgte kategori blev omdøbt til';
$hesklang['cat_removed']='Kategori fjernet';
$hesklang['cat_removed_db']='Den valgte kategori blev fjernet';
$hesklang['sure_remove_user']='Er du sikker på, at du vil slette brugeren?';
$hesklang['manage_users']='Administrer brugere';
$hesklang['users_intro']='Her kan du administrere brugere, som kan logge ind i administrationspanelet 
og besvare sager. Administratorer kan se og redigere sager i enhver kategori og har 
adgang til alle funktionerne i adsministrationspanelet (administrer brugere, kategorier...)
hvor andre brugere kun har adgang til at se og svare på sager i deres egne kategorier.';
$hesklang['yes']='JA';
$hesklang['no']='NEJ';
$hesklang['edit']='Rediger';
$hesklang['add_user']='Tilføj ny bruger';
$hesklang['req_marked_with']='Påkrævede felter er angivet med';
$hesklang['real_name']='Fulde navn';
$hesklang['signature_max']='Signatur (maks. 1000 tegn)';
$hesklang['sign_extra']='Du må ikke bruge HTML-kode. Links bliver automatisk klikbare.';
$hesklang['create_user']='Opret bruger';
$hesklang['editing_user']='Rediger bruger';
$hesklang['user_added']='Bruger oprettet';
$hesklang['user_added_success']='Ny bruger %s med adgangskode %s blev oprettet';
$hesklang['profile_updated']='Profil opdateret';
$hesklang['profile_updated_success']='Din profil er blevet opdateret';
$hesklang['user_removed']='Bruger fjernet';
$hesklang['sel_user_removed']='Brugeren blev slettet';
$hesklang['profile_for']='Profil for';
$hesklang['new_pass']='Ny adgangskode';
$hesklang['update_profile']='Opdater profil';
$hesklang['notify_new_posts']='Adviser mig om nye sager og posteringer i mine kategorier';
$hesklang['view_profile']='Se profil';
$hesklang['new_ticket_submitted']='Ny sag er blevet oprettet';
$hesklang['user_profile_updated_success']='Brugeren blev opdateret';
$hesklang['printer_friendly']='Printervenlig version';
$hesklang['end_ticket']='--- Slut på sag ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Din sag er blevet';
$hesklang['view_your_ticket']='Se din supportsag';
$hesklang['submit_ticket']='Opret en sag';
$hesklang['sub_ticket']='Send sag';
$hesklang['before_submit']='Kontroler følgende, før du opretter din sag';
$hesklang['all_info_in']='Alt relevant information er angivet';
$hesklang['all_error_free']='Alt information er korrekt og fejlfrit';
$hesklang['we_have']='Vi har registreret';
$hesklang['recorded_ip']='som din IP-adresse';
$hesklang['recorded_time']='samt tidspunktet for oprettelsen';
$hesklang['save_changes']='Gem ændringer';
$hesklang['reply_submitted_success']='Dit svar til denne supportsag er blevet sendt';
$hesklang['ticket_submitted']='Supportsag indsendt';
$hesklang['ticket_submitted_success']='Din supportsag er blevet indsendt! Supportsags ID';
$hesklang['your_ticket']='Din supportsag';

// Added in version 0.94
$hesklang['check_updates']='Sørg for at du altid har installeret den seneste version af Hesk!';
$hesklang['check4updates']='Søg efter opdateringer';
$hesklang['wait_reply']='Venter svar';
$hesklang['replied']='Besvarede';
$hesklang['last_replier']='Sidste svarer';
$hesklang['staff']='Personal';
$hesklang['customer']='Kunde';
$hesklang['close_selected']='Markér valgte supportsag som løst';
$hesklang['execute']='Udfør';
$hesklang['saved_replies']='Gemt svar';
$hesklang['manage_saved']='Gemt svar';
$hesklang['manage_intro']='Her kan du tilføje og administrere standardsvar. Disse er almindeligt anvendte svar, som er mere eller mindre ens for hver kunde. Du bør bruge standardsvar for at undgå at skrive det samme svar til forskellige kunder adskillige gange.';
$hesklang['saved_title']='Titel';
$hesklang['no_saved']='Ingen standardsvar';
$hesklang['delete_saved']='Er du sikker på, at du vil slette dette standardsvar?';
$hesklang['new_saved']='Tilføj eller rediger et standardsvar';
$hesklang['canned_add']='Nyt standardsvar';
$hesklang['canned_edit']='Rediger valgt standardsvar';
$hesklang['save_reply']='Gem svar';
$hesklang['saved']='Svar gemt';
$hesklang['your_saved']='Dit originale svar er blevet gemt til fremtidig brug';
$hesklang['ent_saved_title']='Indtast venligst svartitel';
$hesklang['ent_saved_msg']='Skriv venligst svar besked';
$hesklang['saved_removed']='Standardsvar fjernet';
$hesklang['saved_rem_full']='Valgt standardsvar er blevet fjernet fra databasen';
$hesklang['clip_alt']='Dette indlæg har vedhæftede filer';
$hesklang['attachments']='Vedhæftede filer';
$hesklang['fill_all']='Mangler påkrævet felt';
$hesklang['file_too_large']='Din fil %s er for stor';
$hesklang['cannot_move_tmp']='Kan ikke uploade filen. Tjek serverens indstillinger eller kontakt siden webmaster';
$hesklang['created_on']='Oprettet den';
$hesklang['tickets_closed']='Supportsager lukket';
$hesklang['num_tickets_closed']='<b>%d</b> supportsager er blevet lukket';
$hesklang['select_saved']='Vælg et standardsvar';
$hesklang['select_empty']='Vælg/Tøm';
$hesklang['insert_special']='Indsæt speciel tag (vil blive erstattet med kundeinfo)';
$hesklang['move_to_catgory']='Flyt sagen til';
$hesklang['move']='Flyt';
$hesklang['moved']='Sagen er flyttet';
$hesklang['moved_to']='Denne sag er blevet flyttet til den nye kategori';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Alle bortset fra lukkede';
$hesklang['chg_all']='Opdater alle';
$hesklang['settings']='Indstillinger';
$hesklang['settings_intro']='Brug dette værktøj til at konfigurere din help desk. For mere information om indstillinger og muligheder kan du klikke på hjælp eller læse readme.html.';
$hesklang['all_req']='Alle felter (undtagen inaktive) er obligatoriske.';
$hesklang['wbst_title']='Website titel';
$hesklang['wbst_url']='Website URL';
$hesklang['email_wm']='Webmaster e-mail';
$hesklang['max_listings']='Poster per side';
$hesklang['print_size']='Udskriv - skrifttype størrelse';
$hesklang['debug_mode']='Debug mode';
$hesklang['on']='AKTIV';
$hesklang['off']='DEAKTIV';
$hesklang['use_secimg']='Brug anti-SPAM billede';
$hesklang['secimg_no']='Ikke tilgængelig';
$hesklang['attach_use']='Brug vedhæftninger';
$hesklang['attach_num']='Antal per post';
$hesklang['attach_type']='Tilladte filtyper';
$hesklang['place_after']='Efter besked';
$hesklang['place_before']='Før besked';
$hesklang['custom_f']='Specialfelt';
$hesklang['custom_u']='Anvend dette felt';
$hesklang['custom_n']='Feltnavn';
$hesklang['custom_l']='Makslængde (tegn)';
$hesklang['db_host']='Database host';
$hesklang['db_name']='Database navn';
$hesklang['db_user']='Database brugernavn';
$hesklang['db_pass']='Database adgangskode';
$hesklang['err_sname']='Indtast titlen på dit website';
$hesklang['err_surl']='Indtast dit URL på dit website. Kontroller, at det er en gyldig URL (starter med http:// eller https://)';
$hesklang['err_wmmail']='Indtast en gyldig webmaster e-mail';
$hesklang['err_nomail']='Indtast en gyldig noreply e-mail';
$hesklang['err_htitle']='Indtast titlen for din help desk';
$hesklang['err_hurl']='Indtast din HESK mappe URL. Kontroller, at det er en gyldig URL (starter med http:// eller https://)';
$hesklang['err_lang']='Vælg HESK sprog';
$hesklang['err_nolang']='Den valgte sprogfil findes ikke i sprogmappen. Kontroller, at filen er uploadet korrekt, før du ændrer sprogindstilling.';
$hesklang['err_max']='Indtast den maksimale visninger af poster per side';
$hesklang['err_psize']='Indtast print font størrelsen';
$hesklang['err_dbhost']='Indtast MySQL-database host';
$hesklang['err_dbname']='Indtast MySQL-databasenavn';
$hesklang['err_dbuser']='Indtast MySQL-database brugernavn';
$hesklang['err_dbpass']='Indtast MySQL-database adgangskode';
$hesklang['err_dbconn']='Kunne ikke oprette forbindelse til MySQL-databasen ved at bruge den oplyste information!';
$hesklang['err_dbsele']='Kunne ikke vælge MySQL-database. Kontroller databasenavn';
$hesklang['err_custname']='Indtast brugerdefineret feltnavn';
$hesklang['err_openset']='Kan ikke åbne filen <b>hesk_settings.inc.php</b> i skriveadgang. Anvend CHMOD på filen til 666 (rw-rw-rw-)';
$hesklang['set_saved']='Ændringerne blev gemt';
$hesklang['set_were_saved']='Dine ændringer blev gemt';
$hesklang['sec_img']='Sikkerhedsbillede';
$hesklang['sec_miss']='Indtast sikkerhedsnummer';
$hesklang['sec_wrng']='Forkert sikkerhedsnummer';
$hesklang['submit_problems']='Gå tilbage, og løs følgende problemer';
$hesklang['cat_order']='Kategorirækkefølge';
$hesklang['reply_order']='Standardsvarrækkefølge';
$hesklang['move_up']='Flyt op';
$hesklang['move_dn']='Flyt ned';
$hesklang['cat_move_id']='Manglende kategori-ID';
$hesklang['reply_move_id']='Manglende respons-ID';
$hesklang['forgot_tid']='Glemt sags-ID?';
$hesklang['tid_send']='Send mig mit sags-ID';
$hesklang['tid_not_found']='Der blev ikke fundet sager tilknyttet e-mail adressen.';
$hesklang['tid_sent']='Sags-ID blev sendt';
$hesklang['tid_sent2']='Dine sagsoplysninger er blevet sendt til din e-mail adresse.';
$hesklang['check_spambox']='Kontroller også din SPAM/uønsket mappe.';
$hesklang['reply_not_found']='Standardsvaret blev ikke fundet';
$hesklang['exists']='Findes';
$hesklang['no_exists']='Findes ikke';
$hesklang['writable']='Skrivbar';
$hesklang['not_writable']='Ikke skrivbar';
$hesklang['disabled']='deaktiveret';
$hesklang['e_settings']='Du vil ikke være i stand til at gemme dine indstillinger, hvis filen ikke er skrivbar af systemet. Kig i readme filen for at få yderligere informationer.';
$hesklang['e_attdir']='Du vil ikke være i stand til at understøtte vedhæftede filer, hvis ikke mappen findes og er skrivbar af systemet. Kig i readme filen for at få yderligere informationer.';
$hesklang['e_save_settings']='Systemet er ikke i stand til at gemme dine ændringer, fordi systemet ikke kan skrive til filen <b>hesk_settings.inc.php</b>';
$hesklang['e_attach']='Deaktiveret, fordi systemet ikke kan skrive til din <b>attachments</b> mappe.';
$hesklang['go']='Udfør';

// Added in version 2.0
$hesklang['v']='HESK version';
$hesklang['check_status']='Status';
$hesklang['sub_support']='Opret en sag';
$hesklang['open_ticket']='Opret en sag til en afdeling';
$hesklang['view_existing']='Se eksisterende sag';
$hesklang['vet']='Vis supportsager, du har oprettet tidligere';
$hesklang['enter_user']='Skriv dit brugernavn';
$hesklang['remember_user']='Husk mit brugernavn';
$hesklang['wrong_user']='Forkert brugernavn';
$hesklang['no_permission']='Du har ikke adgang til denne handling. Log på med en konto, som har adgang.';
$hesklang['tickets_on_pages']='Antal sager: %d | Antal sider: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Hop til side:';
$hesklang['no_tickets_open']='Ingen åbne sager blev fundet';
$hesklang['no_tickets_crit']='Der findes ingen sager, som matcher dine kriterier';
$hesklang['confirm_execute']='Er du sikker på, at du vil fortsætte?';
$hesklang['legend']='Legende';
$hesklang['main_page']='Hjem';
$hesklang['menu_users']='Brugere';
$hesklang['menu_cat']='Kategorier';
$hesklang['menu_profile']='Profil';
$hesklang['menu_kb']='Vidensdatabase'; // Admin MENU item
$hesklang['kb_text']='Vidensdatabase'; // Item visible to customers
$hesklang['viewkb']='Se hele vidensdatabasen';
$hesklang['kb']='Administrer vidensdatabasen';
$hesklang['kb_intro']='Vidensdatabasen er en samling svar til ofte stillede spørgsmål (OSS) og artikler, som kan hjælpe kunder med generelle problematikker.
En fyldestgørende vidensdatabase kan reducere antallet af sager som oprettes og spare tid. Du kan strukturere artiklerne i kategorier og underkategorier.'; // Description in ADMIN panel
$hesklang['kb_is']='Vidensdatabase er en samling af svar til ofte stillede spørgsmål (OSS) og artikler. Du kan læse artiklerne i denne kategori eller vælge en relevant underkategori.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Ny vidensdatabase-artikel';
$hesklang['kb_cat']='Kategori';
$hesklang['kb_subject']='Emne';
$hesklang['kb_content']='Indhold';
$hesklang['kb_type']='Type';
$hesklang['kb_published']='Publiseret';
$hesklang['kb_published2']='Artiklen er synlig for alle i vidensdatabasen.';
$hesklang['kb_private']='Privat';
$hesklang['kb_private2']='Private artikler kan kun læses af personalet.';
$hesklang['kb_draft']='Kladde';
$hesklang['kb_draft2']='Denne artikel er gemt, men endnu ikke udgivet. Den er kun synlig for dem, <br /> som er autoriserede til at administrere vidensdatabase-artikler.';
$hesklang['kb_links']='<i><span class="notice"><b>Advarsel!</b></span><br />Indtast gyldig kode uden &lt;head&gt; og &lt;body&gt; tags, kun indhold.</i>';
$hesklang['kb_ehtml']='Dette er HTML-kode (Jeg vil indtaste (X)HTML kode)';
$hesklang['kb_dhtml']='Dette er klartekst (links vil være klikbare)';
$hesklang['kb_save']='Gem artikel';
$hesklang['kb_e_subj']='Skriv artikelemne.';
$hesklang['kb_e_cont']='Skriv indhold.';
$hesklang['kb_art_added']='Artiklen blev tilføjet';
$hesklang['your_kb_added']='En ny vidensdatabase-artikel blev tilføjet';
$hesklang['kb_art_deleted']='Artiklen er slettet';
$hesklang['your_kb_deleted']='Den valgte vidensdatabase-artikel blev slettet';
$hesklang['kb_art_mod']='Artikel ændret';
$hesklang['your_kb_mod']='Dine ændringer til den valgte artikel blev gemt';
$hesklang['kb_cat_new']='Ny vidensdatabase-kategori';
$hesklang['kb_cat_parent']='Overordnet kategori';
$hesklang['kb_cat_sub']='Underkategorier';
$hesklang['kb_cat_title']='Kategorititel';
$hesklang['kb_cat_published']='Kategorien er synlig for alle i vidensdatabase.';
$hesklang['kb_cat_private']='Kategorien er kun synlig for personalet.';
$hesklang['kb_cat_add']='Tilføj kategori';
$hesklang['kb_cat_e_title']='Indtast kategorititel!';
$hesklang['kb_cat_added']='Kategorien blev tilføjet';
$hesklang['kb_cat_added2']='En ny kategori er blevet tilføjet til vidensdatabasen';
$hesklang['kb_cat_man']='Administrer vidensdatabase-kategori';
$hesklang['kb_cat_edit']='Rediger kategoridetaljer';
$hesklang['kb_cat_inv']='Ugyldig kategori';
$hesklang['kb_cat_art']='Artikler i kategorien';
$hesklang['kb_p_art']='+ Artikel';
$hesklang['kb_p_art2']='tilføj en ny artikel til den valgte kategori.';
$hesklang['kb_add_art']='Tilføj artikel';
$hesklang['kb_p_cat']='+ Kategori';
$hesklang['kb_p_cat2']='opret en ny underkategori under den valgte kategori.';
$hesklang['kb_add_cat']='Tilføj kategori';
$hesklang['kb_p_man']='Administrer';
$hesklang['kb_p_man2']='administrer valgte kategori (rediger, slet, administrer artikler).';
$hesklang['kb_main']='Hovedkategorien i vidensdatabase kan ikke slettes eller flyttes.';
$hesklang['kb_no_art']='Der er ingen artikler i denne kategori.';
$hesklang['author']='Forfatter';
$hesklang['views']='Visninger';
$hesklang['delete']='Slet';
$hesklang['rating']='Bedømmelse';
$hesklang['votes']='Stemmer';
$hesklang['kb_rated']='Artiklen er bedømt %s/5.0';
$hesklang['kb_not_rated']='Artiklen er ikke bedømt endnu';
$hesklang['del_art']='Er du sikker på, at du vil slette artiklen?';
$hesklang['kb_art_id']='Manglende eller ugyldigt artikel-ID!';
$hesklang['kb_art_edit']='Rediger artikel';
$hesklang['revhist']='Revisionshistorik';
$hesklang['revision1']='<li class="mindre">%s | indsendt af %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | ændret af %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Rækkefølge';
$hesklang['kb_delcat']='Er du sikker på, at du vil slette kategorien?';
$hesklang['kb_cat_mod']='Kategorien er ændret';
$hesklang['your_cat_mod']='Dine ændringer til den valgte kategori blev gemt';
$hesklang['kb_cat_del']='Kategorien er slettet';
$hesklang['kb_cat_dlt']='Den valgte kategori blev slettet.';
$hesklang['allowed_cat']='Kategorier';
$hesklang['allow_feat']='Muligheder';
$hesklang['can_view_tickets']='Vis supportsager';
$hesklang['can_reply_tickets']='Svar på sager';
$hesklang['can_assign_tickets']='Tildel sager';
$hesklang['can_del_tickets']='Slet sager';
$hesklang['can_edit_tickets']='Rediger besvarelser til sag';
$hesklang['can_change_cat']='Skift sagskategori (til enhver)';
$hesklang['can_man_kb']='Administrer vidensdatabase';
$hesklang['can_man_users']='Administrer brugere';
$hesklang['can_man_cat']='Administrer kategorier';
$hesklang['can_man_canned']='Administrer standardsvar';
$hesklang['can_man_settings']='Administrer help desk indstillinger';
$hesklang['can_del_notes']='Slet sagsnoter';
$hesklang['dan']='bruger kan slette noter på egne sager. Vælg kun indstillingen, hvis du ønsker, at brugeren også kan slette noter oprettet af andre brugere';
$hesklang['in_all_cat']='kun i tilladte kategorier';
$hesklang['admin_can']='(adgang til alle features og kategorier)';
$hesklang['staff_can']='(du kan begrænse features og kategorier)';
$hesklang['asign_one_feat']='Tildel mindst en feature til denne bruger!';
$hesklang['na_view_tickets']='Du har ikke adgang til at se sager';
$hesklang['support_notice']='Beklager. Sektionen kan kun skjules, hvis du køber en HESK licens!';
$hesklang['rart']='Hjalp denne artikel?';
$hesklang['r']='Hjalp dette svar?';
$hesklang['tyr']='Tak for din bedømmelse';
$hesklang['cw']='Luk vindue';
$hesklang['cw2']='Luk vindue og opret sag';
$hesklang['rh']='Vurderet som nyttig';
$hesklang['rnh']='Vurderet som ikke nyttig';
$hesklang['ar']='Allerede bedømt';
$hesklang['rated']='Bruger bedømt %s/5.0 (%s stemmer)';
$hesklang['not_rated']='Bruger ikke bedømt endnu';
$hesklang['rdis']='Bedømmelse er deaktiveret';
$hesklang['kbdis']='Vidensdatabasen er deaktiveret';
$hesklang['kbpart']='Beklager. Du har ikke adgang til at læse artiklen';
$hesklang['popart']='Top artikler';
$hesklang['latart']='Seneste artikler';
$hesklang['m']='Flere emner';
$hesklang['ac']='Artikler i denne kategori';
$hesklang['noa']='Der er ikke skrevet nogen artikler endnu';
$hesklang['noac']='Der er ikke skrevet nogen artikler i denne kategori';
$hesklang['dta']='Dato tilføjet';
$hesklang['ad']='Artikeldetaljer';
$hesklang['aid']='Artikel-ID';
$hesklang['as']='L&oslash;sning';
$hesklang['search']='Søg';
$hesklang['sr']='Søgeresultater';
$hesklang['nosr']='Der blev ikke fundet nogen artikler, der matcher din søgning. Du kan lede efter svaret i vidensdatabasen eller oprette en ny sag.';
$hesklang['rv']='Nulstil visninger';
$hesklang['rr']='Nulstil stemmer (bedømmelser)';
$hesklang['opt']='Muligheder';
$hesklang['delcat']='Slet kategori';
$hesklang['move1']='Flyt artikler til hovedkategori';
$hesklang['move2']='Slet artikler i denne kategori';
$hesklang['sc']='Forslag til artikler i vidensdatabasen om emnet';
$hesklang['not']='Sager'; // Number of all tickets in category
$hesklang['graph']='Graf';
$hesklang['lu']='List brugernavne';
$hesklang['aclose']='Luk sager automatisk ';
$hesklang['aclose2']='dage efter seneste svar fra personalet';
$hesklang['s_ucrt']='Genåbn sager';
$hesklang['urate']='Bedøm svar';
$hesklang['hesk_url']='Help desk URL';
$hesklang['hesk_title']='Help desk titel';
$hesklang['cid']='Sags-ID';
$hesklang['tfor']='Tidsformat';
$hesklang['prefix']='Tabel præfiks';
$hesklang['s_ekb']='Aktiver videnbase';
$hesklang['s_kbs']='Tillad søgning i vidensdatabasen';
$hesklang['s_kbr']='Tillad bedømmelser i vidensdatabasen';
$hesklang['s_maxsr']='Max søgeresultater';
$hesklang['s_suggest']='Foreslå artikler fra vidensdatabasen';
$hesklang['s_spop']='Vis populære artikler';
$hesklang['s_slat']='Vis seneste artikler';
$hesklang['s_onin']='på <a href="../" target="_blank">help desk index</a> side';
$hesklang['s_onkb']='på <a href="../knowledgebase.php" target="_blank">Vidensdatabase index</a> side';
$hesklang['s_scol']='Kategorier i række';
$hesklang['s_ptxt']='Længde af uddrag på artikel';
$hesklang['s_psubart']='Underkategori artikler';
$hesklang['enable']='Aktiver';
$hesklang['s_type']='Type';
$hesklang['custom_r']='Påkrævet';
$hesklang['custom_place']='Lokation';
$hesklang['custom_use']='Tilpassede felter';
$hesklang['stf']='Tekstfelt';
$hesklang['stb']='Stort tekstfelt';
$hesklang['srb']='Radioknap';
$hesklang['ssb']='Dropdown';
$hesklang['db']='Database';
$hesklang['hd']='Support indstillinger';
$hesklang['gs']='Generelle indstillinger';
$hesklang['cwin']='Luk vindue';
$hesklang['defw']='Standardværdi';
$hesklang['ok']='OK';
$hesklang['ns']='Dette er valgmulighederne for et tilpasset felt. For at gemme ændringer, klik <b>OK</b> og <b>Gem ændringer</b> knappen på admin-indstillingssiden';
$hesklang['rows']='Rækker (højde)';
$hesklang['cols']='Kolonner (vidde)';
$hesklang['opt2']='Valgmuligheder for radioknap. Skriv en værdi per linje (hver linje vil danne en ny radioknap, som kan vælges). Indtast mindst to valgmuligheder.';
$hesklang['opt3']='Valgmuligheder for dropdown. Skriv en værdi per linje (hver linje vil danne en ny radioknap, som kan vælges). Indtast mindst to valgmuligheder.';
$hesklang['atl2']='Skriv mindst to valgmuligheder (en per linje).';
$hesklang['notes']='Noter';
$hesklang['addnote']='Tilføj note';
$hesklang['noteby']='Note af';
$hesklang['delnote']='Slet note';
$hesklang['noteerr']='Noten er allerede slettet eller parametre er forkerte';
$hesklang['s']='Opret';
$hesklang['nhid']='Noter vises ikke til kunder.';
$hesklang['delt']='Slet post';
$hesklang['edtt']='Rediger post';
$hesklang['edt1']='Post ændret';
$hesklang['edt2']='ændringer til den valgte post blev gemt';
$hesklang['dele']='Slet sagen';
$hesklang['repd']='Post slettet';
$hesklang['repl']='Den valgte post blev slettet';
$hesklang['tickets_found']='Søgeresultat';
$hesklang['al']='Admininstrator link';
$hesklang['ap']='Gå til Administrationssitet';
$hesklang['dap']='Vis et Administratorlink fra <a href="../" target="_blank">help desk index</a>';
$hesklang['q_miss']='Besvar anti-SPAM spørgsmålet';
$hesklang['use_q']='Anvend anti-SPAM spørgsmål';
$hesklang['q_q']='Spørgsmål (HTML-kode er <span class="success">tilladt</span>)';
$hesklang['q_a']='Svar';
$hesklang['err_qask']='Skriv et anti-SPAM spørgsmål';
$hesklang['err_qans']='Skriv svaret til anti-SPAM spørgsmålet';
$hesklang['genq']='Generer et tilfældigt spørgsmål';

// Added in version 2.1
$hesklang['amo']='Tilføj mere';
$hesklang['delatt']='Slet valgte vedhæftning?';
$hesklang['kb_att_rem']='Den valgte vedhæftning blev fjernet';
$hesklang['inv_att_id']='Ugyldig vedhæftnings-ID';
$hesklang['scb']='Tjekboks';
$hesklang['opt4']='Valgmuligheder for dette afkrydsningsfelt, indtast én mulighed pr. linje. Hver linje vil være et valg, dine kunder kan vælge imellem, flere valg er mulige.';
$hesklang['autologin']='Log mig ind automatisk ved hvert besøg';
$hesklang['just_user']='Husk kun mit brugernavn';
$hesklang['nothx']='Nej tak';
$hesklang['pinfo']='Profilinformation';
$hesklang['sig']='Signatur';
$hesklang['pref']='Præferencer';
$hesklang['aftrep']='Efter besvarelse af en sag';
$hesklang['showtic']='Vis sagen, jeg besvarede';
$hesklang['gomain']='Retur til administrationssiden';
$hesklang['shownext']='Åbn den næste sag, som venter på mit svar';
$hesklang['rssn']='Vis næste sag, som har behov for besvarelse';
$hesklang['mrep']='Udskift besked';
$hesklang['madd']='Tilføj til slutningen';
$hesklang['priv']='Private kategorier og artikler, som kun er synlige for personalet er angivet med * ';
$hesklang['inve']='Ugyldig e-mail fil';
$hesklang['emfm']='Manglende e-mail fil';
$hesklang['hesk_lang']='Standardsprog';
$hesklang['s_mlang']='Flere sprog';
$hesklang['s_mlange']='Aktiverm kun hvis du tilbyder support i alle installerede sprog.';
$hesklang['s_inl']='Test sprogmappen';
$hesklang['s_inle']='Tester sprogmappen for gyldige sprog. Kun sprog, der består alle test, er korrekt installeret.';
$hesklang['ta']='Test igen';
$hesklang['alo']='Tillad automatisk login';
$hesklang['chol']='Foretrukent sprog';
$hesklang['mmdl']='Angiv dette som mit foretrukne sprog';
$hesklang['warn']='ADVARSEL';
$hesklang['dmod']='Debug mode er aktiveret. Husk at deaktivere debug mode, når HESK er installeret og virker korrekt. Debug mode bør ikke bruges i produktionsmode';
$hesklang['kb_spar']='Kategorien kan ikke flyttes til sig selv';
$hesklang['mysql_root']='Din MySQL adgangskode er tom. Er du sikker på, at du vil logge på som root bruger? En sikkerhedsrisiko kan være forbundet med det valg.';
$hesklang['chg']='ændre';
$hesklang['chpri']='Prioritet ændret';
$hesklang['chpri2']='Sagens prioritet er blevet ændret til %s';
$hesklang['selcan']='Vælg standardsvaret, du vil redigere';
$hesklang['q_wrng']='Forkert anti-SPAM svar';
$hesklang['cndupl']='Der findes allerede en kategori med det navn. Vælg et unikt navn for hver kategori.';
$hesklang['wsel']='Vælg det felt, du vil søge på';

// Added in version 2.2
$hesklang['eto']='Ugyldig forespørgsel';
$hesklang['id']='ID';
$hesklang['geco']='Generer direkte link';
$hesklang['genl']='Link kopieret til udklipsholder';
$hesklang['genl2']='Anvend dette link for at vælge kategori i &quot;Opret sag&quot; formularen.';
$hesklang['ask']='Søg hjælp:';
$hesklang['exa']='Eksempler';
$hesklang['small']='Lille boks';
$hesklang['large']='Stor boks';
$hesklang['cpri']='Kundeprioritet';
$hesklang['owner']='Ejer';
$hesklang['unas']='Ikke tildelt';
$hesklang['assi']='Tildel';
$hesklang['asst']='Tildel til';
$hesklang['asst2']='Tildel sagen til';
$hesklang['asss']='Tildel til mig';
$hesklang['asss2']='Tildel sagen til mig selv';
$hesklang['can_assign_self']='Kan tildele sager til sig selv';
$hesklang['can_assign_others']='Kan tildele sager til andre';
$hesklang['can_run_reports']='Kan køre rapporter (egne)';
$hesklang['can_view_ass_others']='Kan se sager, som er tildelt andre';
$hesklang['unoa']='Valgte bruger har ikke adgang til denne kategori';
$hesklang['tasi']='Ejer tildelt';
$hesklang['tasy']='Sagen er blevet tildelt dig';
$hesklang['taso']='Sagen er blevet tildelt brugeren';
$hesklang['tasy2']='Tildelt mig';
$hesklang['taso2']='Tildelt anden';
$hesklang['nose']='Vælg ny ejer';
$hesklang['onasc']='Ejeren har ikke adgang til kategorien.';
$hesklang['tunasi']='Sagen er ikke tildelt';
$hesklang['tunasi2']='Sag uden ejer og klar til at blive tildelt igen';
$hesklang['note']='Note';
$hesklang['success']='Succes';
$hesklang['nyt']='Sagen er tildelt';
$hesklang['noch']='Der er ingen ændringer';
$hesklang['orch']='Visningsrækkefølgen er ændret';
$hesklang['rfm']='Nødvendig information mangler:';
$hesklang['repl0']='Manglende rettigheder til at udføre denne handling';
$hesklang['repl1']='Denne post eksisterer ikke';
$hesklang['reports']='Rapporter';
$hesklang['reports_intro']='Rapportsektionen giver dig mulighed for at køre rapporter og se sagsstatstik for en given periode.';
$hesklang['refi']='Slet formulardata';
$hesklang['dich']='Glem ændringer';
$hesklang['dire']='Vis Rapport';
$hesklang['m1']='Januar';
$hesklang['m2']='Februar';
$hesklang['m3']='Marts';
$hesklang['m4']='April';
$hesklang['m5']='Maj';
$hesklang['m6']='Juni';
$hesklang['m7']='Juli';
$hesklang['m8']='August';
$hesklang['m9']='September';
$hesklang['m10']='Oktober';
$hesklang['m11']='November';
$hesklang['m12']='December';
$hesklang['d1']='Mandag';
$hesklang['d2']='Tirsdag';
$hesklang['d3']='Onsdag';
$hesklang['d4']='Torsdag';
$hesklang['d5']='Fredag';
$hesklang['d6']='Lørdag';
$hesklang['d0']='Søndag';
$hesklang['mo']='Ma';
$hesklang['tu']='Ti';
$hesklang['we']='On';
$hesklang['th']='To';
$hesklang['fr']='Fr';
$hesklang['sa']='Lø';
$hesklang['su']='Sø';
$hesklang['from']='Fra';
$hesklang['cinv']='Ugyldig dato';
$hesklang['cinv2']='Accepteret format er mm/dd/yyyy';
$hesklang['cinm']='Ugyldig måned';
$hesklang['cinm2']='Tilladte periode er';
$hesklang['cind']='Ugyldig dag for måneden';
$hesklang['cind2']='Tilladte interval for måneden';
$hesklang['month']='Måned';
$hesklang['ocal']='Åben kalender';
$hesklang['ca01']='Sidste år';
$hesklang['ca02']='Sidste måned';
$hesklang['ca03']='Næste måned';
$hesklang['ca04']='Næste år';
$hesklang['ca05']='Luk kalender';
$hesklang['cdr']='Vælg periode:';
$hesklang['crt']='Rapporttype';
$hesklang['r1']='I dag';
$hesklang['r2']='I går';
$hesklang['r3']='Denne måned';
$hesklang['r4']='Sidste måned';
$hesklang['r5']='Sidste 30 dage';
$hesklang['r6']='Denne uge (man-søn)';
$hesklang['r7']='Sidste uge (man-søn)';
$hesklang['r8']='Denne uge, hverdage (man-fre)';
$hesklang['r9']='Sidste uge, hverdage (man-fre)';
$hesklang['r10']='Dette år';
$hesklang['r11']='Sidste år';
$hesklang['r12']='Siden starten';
$hesklang['datetofrom']='&quot;Dato fra&quot; kan ikke være senere end &quot;Dato til&quot;.';
$hesklang['t1']='Sager per dag';
$hesklang['t2']='Sager per måned';
$hesklang['t3']='Sager per bruger';
$hesklang['t4']='Sager per kategori';
$hesklang['ticass']='Tildelte sager';
$hesklang['ticall']='Sager med svar';
$hesklang['totals']='Totaller';
$hesklang['all']='Alle';
$hesklang['atik']='Nye sager';
$hesklang['kbca']='Du har allerede en vidensdatabase-kategori med dette navn.';
$hesklang['menu_msg']='Mail';
$hesklang['menu_can']='Standardsvar';
$hesklang['m_from']='Fra'; // Mail "from" address
$hesklang['m_to']='Til'; // Mail "to" address
$hesklang['m_sub']='Emne'; // Mail subject
$hesklang['m_re']='SV:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='VS:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Private beskeder';
$hesklang['m_intro']='Brug privatbeskeder til at sende beskeder til andre brugere i staben.';
$hesklang['e_udel']='(Bruger slettet)';
$hesklang['new_mail']='Ny privatbesked';
$hesklang['m_send']='Send besked';
$hesklang['m_rec']='Vælg modtager';
$hesklang['m_inr']='Ugyldig modtager';
$hesklang['m_esu']='Skriv emnet på privatbeskeden';
$hesklang['m_pms']='Privatbesked blev sendt';
$hesklang['inbox']='Indbakke';
$hesklang['outbox']='Udbakke';
$hesklang['m_new']='Ny besked';
$hesklang['pg']='Vis side';
$hesklang['npm']='Ingen privatbeskeder i mappen.';
$hesklang['m_ena']='Du har ikke adgang til at læse beskeden.';
$hesklang['mau']='Marker som ulæst';
$hesklang['mo1']='Marker valgte beskeder som læst';
$hesklang['mo2']='Marker valgte beskeder som ulæst';
$hesklang['mo3']='Slet valgte beskeder';
$hesklang['delm']='Slet beskeden';
$hesklang['e_tid']='Der opstod en fejl under genereringen af sags-ID. Prøv igen senere.';
$hesklang['smmr']='Valgte beskeder blev markeret som læst';
$hesklang['smmu']='Valgte beskeder blev markeret som ulæst';
$hesklang['smdl']='Valgte beskeder blev slettet';
$hesklang['show']='Vis';
$hesklang['s_my']='Tildelt mig';
$hesklang['s_ot']='Tildelt andre';
$hesklang['s_un']='Ikke tildelte sager';
$hesklang['s_for']='Søg efter';
$hesklang['s_in']='Søg i';
$hesklang['s_incl']='Søg indenfor';
$hesklang['find_ticket_by']='Find en sag';
$hesklang['e_nose']='Ingen sagsstatus valgt. Viser alle sager.';
$hesklang['fsq']='Skriv din søgeforespørgsel';
$hesklang['topen']='Åbne';
$hesklang['nms']='Ingen besked valgt. Intet at ændre';
$hesklang['tlo']='Lås sag';
$hesklang['tul']='Frigiv sag';
$hesklang['loc']='Låst';
$hesklang['isloc']='Kunder kan ikke svare på eller genåbne låste sager. Når en sag er låst, markeres den som løst.';
$hesklang['tlock']='Sagen blev låst';
$hesklang['tunlock']='Sagen er blevet frigivet';
$hesklang['tislock']='Sagen er låst. Kunden vil ikke være i stand til at skrive et svar.';
$hesklang['tislock2']='Sagen er låst. Du kan ikke efterlade et svar.';
$hesklang['nsfo']='Ingen relevante artikler blev fundet.';
$hesklang['thist1']='<li class="smaller">%s | flyttet til kategori %s af %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | tildelt til %s af %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | lukket af %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | åbnet af %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | låst af %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | låst op af %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | supportsag oprettet af %s</li>'; // %s = date, user making change
$hesklang['elocked']='Sagen er låst eller slettet.';
$hesklang['nti2']='Opret ny sag';
$hesklang['nti3']='Brug formularen til at oprette en ny sag i kundens navn. Indast <i>kundens</i> information i formularen (kundens navn, e-mail, ...) og IKKE dine egne informationer. Sagen vil blive oprettet, som var det kunden selv.';
$hesklang['addop']='Valgmuligheder';
$hesklang['seno']='Send e-mail advisering til kunden';
$hesklang['otas']='Vis sagen efter oprettelse';
$hesklang['notn']='Adviseringer';
$hesklang['nomw']='Helpdesken vil automtisk sende en advisering når:';
$hesklang['nwts']='En ny sag er oprettet med ejer:';
$hesklang['ncrt']='Kunden besvarer en sag med ejer:';
$hesklang['ntam']='En sag tildeles mig';
$hesklang['npms']='En privatbesked sendes til mig';
$hesklang['support_remove']='Der er investeret meget tid og energi på udviklingen af HESK. Støt HESK. Køb en licens, som også vil fjerne alle <i>Powered by Help Desk Software HESK</i> links fra din helpdesk';
$hesklang['ycvtao']='Du har ikke adgang til at se sager, som er tildelt andre.';
$hesklang['password_not_valid']='Adgangskoden skal være mindst 5 tegn lang';
$hesklang['lkbs']='Henter forslag fra vidensdatabasen...';
$hesklang['auto']='(automatisk)';

// Added in version 2.3
$hesklang['unknown']='Ukendt';
$hesklang['pcer']='Ret følgende fejl:';
$hesklang['seqid']='Sagsnummer';
$hesklang['close_action']='Marker som løst'; // Close ACTION
$hesklang['archived']='Marker som tilføjet';
$hesklang['archived2']='Marker som tilføjet sag';
$hesklang['add_archive']='Tilføj markering til sagen';
$hesklang['add_archive_quick']='Tilføj markering til valgte sager';
$hesklang['remove_archive']='Fjern markering fra sagen';
$hesklang['remove_archive_quick']='Fjern markering fra valgte sager';
$hesklang['added_archive']='Sagen blev markeret';
$hesklang['removed_archive']='Sagen blev af-markeret';
$hesklang['added2archive']='Sagen er blevet markeret';
$hesklang['removedfromarchive']='Sagen er blevet af-markeret';
$hesklang['num_tickets_tag']='<b>%d</b> sager tilføjet markering';
$hesklang['num_tickets_untag']='<b>%d</b> sager har fået fjernet markering';
$hesklang['can_add_archive']='Kan tilføje markeringer til sager';
$hesklang['disp_only_archived']='Kun sager med markeringer tilføjet';
$hesklang['search_only_archived']='Kun sager med markeringer';
$hesklang['critical']='Kritisk';
$hesklang['thist8']='<li class="smaller">%s | prioritet ændret til %s af %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | status ændret til %s af %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | automatisk tildelt til %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | indsendt via e-mail piping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='år';
$hesklang['abbr']['month']='mån';
$hesklang['abbr']['week']='uge';
$hesklang['abbr']['day']='dag';
$hesklang['abbr']['hour']='tim';
$hesklang['abbr']['minute']='min';
$hesklang['abbr']['second']='sek';
// END abberviations
$hesklang['cnsm']='Kunne ikke sende besked til:';
$hesklang['yhbb']='Du er blevet låst ude af system i %s minutter pga. for mange login-forsøg.';
$hesklang['pwdst']='Adgangskodens styrke';
$hesklang['tid_mail']='Ingen grund til bekymring! Indtast din <b>e-mailadresse</b>, så modtager du dit sags-ID med det samme:';
$hesklang['rem_email']='Husk min e-mail';
$hesklang['eytid']='Skriv sags-ID';
$hesklang['enmdb']='E-mailadressen matcher ikke det indtastede sags-ID.';
$hesklang['confemail']='Bekræft e-mailadresse';
$hesklang['confemail2']='Bekræft din e-mailadresse';
$hesklang['confemaile']='De intastede e-mailadresser er ikke ens';
$hesklang['taso3']='Tildelt til:';
$hesklang['sec_enter']='Skriv tallene, du ser i billedet herunder.';
$hesklang['reload']='Genindlæs billede';
$hesklang['verify_q']='SPAM beskyttelse:'; // For anti-spam question
$hesklang['verify_i']='SPAM beskyttelse:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Velkommen! Vær venlig at logge ind.';
$hesklang['vrfy']='Test OK';
$hesklang['last_update']='Opdateret';
$hesklang['cot']='Vis ikke kritiske sager i toppen';
$hesklang['def']='Gør dette til min forudindstillet visning';
$hesklang['gbou']='Disse sager er <b>ikke tildelt</b>:';
$hesklang['gbom']='Sager tildelt <b>mig</b>:';
$hesklang['gboo']='Sager tildelt til <b>%s</b>:';
$hesklang['select']=' - - Klik for at vælge - - ';
$hesklang['chngstatus']='Skift status til ';
$hesklang['perat']='%s af alle sager'; // Will change to "23% of all tickets"
$hesklang['viewart']='Læs artikel';
$hesklang['chdp']='Skift din adgangskode på din <a href="profile.php">profil</a>.';
$hesklang['chdp2']='Skift din adgangskode. Du bruger en autogeneret adgangskode';
$hesklang['security']='Sikkerhed';
$hesklang['kb_i_art']='Ny artikel';
$hesklang['kb_i_art2']='Indsæt artikel';
$hesklang['kb_i_cat']='Ny kategori';
$hesklang['kb_i_cat2']='Indsæt kategori';
$hesklang['gopr']='Kig i vidensdatabasen';
$hesklang['kbstruct']='Struktur for vidensdatabasen';
$hesklang['cancel']='Annuller';
$hesklang['sh']='Skjul besked';
$hesklang['goodkb']='Hvordan skriver man gode artikler til vidensdatabasen?';
$hesklang['catset']='Kategoriindstillinger';
$hesklang['inpr']='Vælg ny prioritet';
$hesklang['incat']='Vælg ny kategori';
$hesklang['instat']='Vælg ny status';
$hesklang['tsst']='Sagens status blev sat til %s';
$hesklang['aass']='Auto-tildel';
$hesklang['aaon']='Auto-tildeling af sager er aktiveret (klik for at deaktivere)';
$hesklang['aaoff']='Auto-tildeling af sager er deaktiveret (klik for at akvtivere)';
$hesklang['uaaon']='Auto-tildeling er aktiveret for brugeren';
$hesklang['uaaoff']='Auto-tildeling er deaktiveret for brugeren';
$hesklang['taasy']='Sagen er blevet auto-tildelt til dig';
$hesklang['can_view_unassigned']='Kan se ikke tildelte sager';
$hesklang['ycovtay']='Du kan kun se sager, som er tildelt til dig';
$hesklang['in_progress']='I gang';
$hesklang['on_hold']='På hold';
$hesklang['import_kb']='Importer sag som artikel i vidensdatabasen';
$hesklang['import']='Du er ved at importere en <i>privat sag</i> ind i en <i>offentlig tilgængelig artikel</i>.<br /><br />Vær sikker på, at du fjerner følsomme oplysninger fra emnet og sagen.';
$hesklang['tab_1']='Generelt';
$hesklang['tab_2']='Help Desk';
$hesklang['tab_3']='Vidensdatabase';
$hesklang['tab_4']='Tilpassede felter';
$hesklang['tab_5']='Diverse';
$hesklang['disable']='Deaktiver';
$hesklang['dat']='Dato &amp; Tid';
$hesklang['lgs']='Sprog';
$hesklang['onc']='AKTIV - Kunder';
$hesklang['ons']='AKTIV - Alle';
$hesklang['viewvtic']='Vis supportsager';
$hesklang['reqetv']='Kræv e-mail for at se en sag';
$hesklang['banlim']='Maks loginforsøg';
$hesklang['banmin']='Tidslås (minutter)';
$hesklang['subnot']='Oprettelsesadvisering';
$hesklang['subnot2']='Vi sender advisering til kunder, der opretter sager';
$hesklang['eseqid']='Sekventielle ID';
$hesklang['sconfe']='Bekræft e-mail';
$hesklang['saass']='Auto-tildel sager';
$hesklang['swyse']='WYSIWYG Editor';
$hesklang['hrts']='Bedøm HESK';
$hesklang['hrts2']='Vis link til <i>Bedøm dette script</i> på administrationssiden';
$hesklang['emlpipe']='E-mail konvertering';
$hesklang['emlsend2']='Send e-mails via';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Server';
$hesklang['smtph']='SMTP Host';
$hesklang['smtpp']='SMTP Port';
$hesklang['smtpu']='SMTP Brugernavn';
$hesklang['smtpw']='SMTP Adgangskode';
$hesklang['smtpt']='SMTP Timeout';
$hesklang['other']='Andre';
$hesklang['features']='Muligheder';
$hesklang['can_view_online']='Kan se personale, der er online';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Brugere online'; // For display in footer
$hesklang['sonline']='Brugere online'; // For settings page
$hesklang['sonline2']='Vis brugere, der er online. Begræns (minutter):'; // For settings page
$hesklang['gb']='Grupper efter';
$hesklang['dg']='Grupper ikke';
$hesklang['err_dpi']='Database %s indeholder ikke alle HESK-tabeller med præfiks %s. Ingen ændringer blev gemt.';
$hesklang['err_dpi2']='Tabellerne blev ikke fundet:';
$hesklang['sme']='SMTP fejl';
$hesklang['scl']='SMTP forbindelseslog';
$hesklang['dnl']='Download';
$hesklang['dela']='Slet vedhæftning';
$hesklang['pda']='Er du sikker på, at du vil slette vedhæftningen?';
$hesklang['thist12']='<li class="smaller">%s | vedhæftet fil %s slettet af %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Flere valg';
$hesklang['lopt']='Færre valg';
$hesklang['meml']='Multiple e-mails';
$hesklang['meml2']='Tillad kunder at indtaste flere kontakt e-mailadresser';

// Added in version 2.4
$hesklang['catd']='(kategori slettet)';
$hesklang['noopen']='Der blev ikke fundet åbne sager tilknyttet e-mailadressen.';
$hesklang['maxopen']='Du kan ikke åbne flere sager, da du ramt grænsen for antallet af åbne sager. (%d af %d). Du kan åbne en ny sag, når en af dine eksisterende sager er løst.';
$hesklang['ntnote']='Nogle tilføjer en note til en sag, som er tildelt mig';
$hesklang['cat_public']='Offentlig';
$hesklang['cat_private']='Privat';
$hesklang['cat_aa']='Auto-tildel sager i kategorien.';
$hesklang['cat_type']='Type';
$hesklang['caaon']='Auto-tildel er aktiveret for kategorien';
$hesklang['caaoff']='Auto-tildel er blevet deaktiveret for kategorien';
$hesklang['cpub']='Kategoritype ændret til OFFENTLIG';
$hesklang['cpriv']='Kategoritype ændret til PRIVAT';
$hesklang['cpric']='Private kategorier er kun synlige for personalet';
$hesklang['user_aa']='Auto-tildel sager til brugeren.';
$hesklang['attach_size']='Maksimal filstørrelse';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='SSL Protokol';
$hesklang['smtptls']='TLS Protokol';
$hesklang['oo']='Kun åbne';
$hesklang['ool']='Vis kun liste over åbne sager i &quot;Glemt sags-ID&quot; e-mail';
$hesklang['mop']='Maksimalt antal åbne sager';
$hesklang['rord']='Svar rækkefølge';
$hesklang['newbot']='Nyeste svar i bunden';
$hesklang['newtop']='Nyeste svar i toppen';
$hesklang['ford']='Svar formular';
$hesklang['formbot']='Vis formularen i bunden';
$hesklang['formtop']='Vis formularen i toppen';
$hesklang['mysqlv']='MySQL-version';
$hesklang['phpv']='PHP-version';
$hesklang['csrt']='HESK tid:';
$hesklang['listp']='List private artikler';
$hesklang['listd']='List kladder';
$hesklang['artp']='Private artikler';
$hesklang['artd']='Kladder';
$hesklang['kb_no_part']='Ingen private artikler i vidensdatabasen.';
$hesklang['kb_no_dart']='Ingen kladder i vidensdatabasne.';
$hesklang['attpri']='Du har ikke adgang til at åbne vedhæftningen.';
$hesklang['can_merge_tickets']='Saml sager til en';
$hesklang['mer_selected']='Saml valgte sager til en';
$hesklang['merged']='De valgte sager blev samlet i en.';
$hesklang['merge_err']='Der opstod et problem med at samle sagerne til en:';
$hesklang['merr1']='vælg mindst to sager.';
$hesklang['merr2']='endelig sag ikke fundet.';
$hesklang['merr3']='sag findes i en kategori, du ikke har adgang til.';
$hesklang['tme']='Sag %s blev samlet med denne sag (%s).';
$hesklang['tme1']='Sag %s blev samlet med sag %s';
$hesklang['tme2']='For at tilgå sag %s skal du skrive den tilhørende e-mailadresse.';
$hesklang['eyou']='Brug profil-siden til at redigere dine indstillinger.';
$hesklang['npea']='Du har ikke adgang til at redigere brugeren.';
$hesklang['duplicate_user']='Brugernavnet eksisterer allerede. Skriv et andet brugernavn.';
$hesklang['kw']='Nøgleord';
$hesklang['kw1']='(valgfrit - separer med mellemrum, komma eller linjeskift)';
$hesklang['type_not_allowed']='Filer af typen <b>%s</b> kan ikke uploades (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Kunden har ikke læst svaret endnu.';
$hesklang['sticky']='Fastgør artiklen';
$hesklang['stickyon']='Ændre artikel til &quot;fastgjort&quot;';
$hesklang['stickyoff']='Ændre artikel til &quot;normal&quot;';
$hesklang['ason']='Artiklen blev markeret som &quot;fastgjort&quot;';
$hesklang['asoff']='Artiklen blev markeret som &quot;normal&quot;';
$hesklang['ts']='Tid brugt';
$hesklang['start']='Start / Stop';
$hesklang['reset']='Nulstil';
$hesklang['save']='Gem';
$hesklang['hh']='Timer';
$hesklang['mm']='Minutter';
$hesklang['ss']='Sekunder';
$hesklang['thist']='Sagshistorik';
$hesklang['thist13']='<li class="smaller">%s | slået sammen med supportsag %s af %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | arbejdet tid opdateret til %s af %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | indsendt af %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | indsendt ved POP3 hentning</li>';
$hesklang['twu']='Tid brugt på sagen er blevet opdateret.';
$hesklang['autoss']='Start automatisk tidtagning, når jeg åbner en sag';
$hesklang['ful']='Begrænsninger for filupload';
$hesklang['ufl']='Du må uploade filer af typerne:';
$hesklang['nat']='Maksimalt antal vedhæftninger:';
$hesklang['mfs']='Maksimal størrelse per vedhæftning:';
$hesklang['lps']='Dit sprogvalg blev gemt';
$hesklang['sav']='Vis artikelvisninger';
$hesklang['sad']='Vis artikeldato';
$hesklang['emp']='Din PHP-version har ikke MySQL-understøttelse aktiveret (MySQLi udvidelse påkrævet)';
$hesklang['epd']='[HESK] EMAIL PIPING ER DEAKTIVERET I INDSTILLINGER';
$hesklang['pfd']='[HESK] POP3 HENTNING ER DEAKTIVERET I INDSTILLINGER';
$hesklang['pem']='[Piped e-mail]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Kunde]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-mail';
$hesklang['pop3']='POP3-hentning';
$hesklang['pop3h']='POP3 host';
$hesklang['pop3p']='POP3 port';
$hesklang['pop3tls']='TLS protokol';
$hesklang['pop3u']='POP3 brugernavn';
$hesklang['pop3w']='POP3 adgangskode';
$hesklang['pop3e']='POP3 fejl';
$hesklang['pop3log']='POP3 forbindelseslog';
$hesklang['mysqltest']='Test MySQL-forbindelse';
$hesklang['smtptest']='Test SMTP-forbindelse';
$hesklang['pop3test']='Test POP3-forbindelse';
$hesklang['contest']='Tester forbindelse. Det kan tage tid...';
$hesklang['conok']='Forbindelsen er etableret korrekt.';
$hesklang['conokn']='Hvis din server kræver brugernavn og adgangskode bliver e-mails ikke afsendt.';
$hesklang['saving']='Gemmer indstillinger. Vent venligst...';
$hesklang['sns']='Indstillerne blev gemt, men nogle funktioner er deaktiveret pga fejl.';
$hesklang['looph']='Max hits';
$hesklang['loopt']='Tidsramme';
$hesklang['didum']='Mente du %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Ja, ret det';
$hesklang['nole']='Nej, glem det';
$hesklang['sconfe2']='Vis et &quot;Bekræft e-mail&quot; felt på opret sagsformularen?';
$hesklang['oln']='Gammelt navn:';
$hesklang['nen']='Nyt navn:';
$hesklang['use_form_below']='<i>Brug formularen til at oprette en sag. Nødvendige felter er angivet med</i>';
$hesklang['esf']='Kunne ikke afsende e-mailadviseringer.';
$hesklang['qrr']='(citeret svar fjernet)';
$hesklang['remqr']='Fjern citeret svar';
$hesklang['remqr2']='Slet citeret svar fra kunders e-mail';
$hesklang['suge']='Opdag fejl i e-mailadresse';
$hesklang['epro']='E-mailudbydere';
$hesklang['email_noreply']='&quot;Fra:&quot; e-mail';
$hesklang['email_name']='&quot;Fra:&quot; navn';
$hesklang['vscl']='Serverkonfiguration begrænsninger';
$hesklang['fnuscphp']='Filupload fejlet. Prøv igen uden vedhæftning eller med en mindre fil.';
$hesklang['redv']='nulstil forudindstillet visning';
$hesklang['fatte1']='Din vedhæftningsindstilling &quot;Antal per sag&quot; er større, end hvad din server tillader.';
$hesklang['fatte2']='Din maksimalstørrelse på vedhæftninger er større, end hvad din server tillader.';
$hesklang['fatte3']='Din server begrænser størrelsen på posts. Prøv at reducere størrelse på eller antallet af vedhæftninger.';
$hesklang['embed']='Indlejrede filer';
$hesklang['embed2']='Gem indlejrede filer som vedhæftninger';
$hesklang['emrem']='(billede fjernet)';
$hesklang['hdemo']='(SKJULT I DEMO)';
$hesklang['ddemo']='Beklager. Funktionen er deaktiveret i DEMO-mode.';
$hesklang['sdemo']='Du kan ikke gemme ændringer i DEMO-mode';
$hesklang['hud']='HESK er opdateret til nyeste version';
$hesklang['hnw']='Opdatering tilgængelig';
$hesklang['getup']='Opdater HESK';
$hesklang['updates']='Opdateringer';
$hesklang['updates2']='Kontroller automatisk efter nye HESK opdateringer.';

// Added in version 2.5.0
$hesklang['attdel']='Denne fil er blevet slettet fra serveren og kan ikke downloades længere.';
$hesklang['dsen']='Send ikke e-mail med dette svar til kunden';
$hesklang['attrem']='* Nogle vedhæftede filer er blevet fjernet *';
$hesklang['attnum']='Max antal nået: %s'; // %s will show attachment name
$hesklang['attsiz']='Filen er for stor: %s'; // %s will show attachment name
$hesklang['atttyp']='Type ikke tilladt: %s'; // %s will show attachment name
$hesklang['adf']='Admin mappe';
$hesklang['atf']='Attachements mappe';
$hesklang['err_adf']='Den valgte admin folder (%s) eksisterer ikke!'; // %s will show folder name
$hesklang['err_atf']='Den valgte attachements folder (%s) eksisterer ikke!'; // %s will show folder name
$hesklang['err_atr']='Den valgte attachements folder (%s) er ikke skrivbar!'; // %s will show folder name
$hesklang['fatt']='Filer vedhæftet beskeden:';
$hesklang['wrepo']='Skriv et svar efter at have genåbnet sagen.';
$hesklang['ktool']='Vidensbase værktøjer';
$hesklang['uac']='Godkend og kontroller antallet af artikler i kategorien';
$hesklang['acv']='Artikel antallet er blevet godkendt';
$hesklang['xyz']='Antal offentlige, private og kladde artikler i kategorien.';
$hesklang['reports_tab']='Kør rapporter'; // Tab title
$hesklang['can_run_reports_full']='Kan køre rapporter (alle)';
$hesklang['can_export']='Kan eksportere sager';
$hesklang['roo']='<i>(kun sager tildelt dig er med i denne rapport)</i>';
$hesklang['shu']='Korte links';
$hesklang['export']='Eksportér sager'; // Tab title
$hesklang['export_btn']='Eksporter sager'; // Button title
$hesklang['export_intro']='Dette værktøj tillader dig at eksportere sager til et XML-regneark ,som kan åbnes i Excel.';
$hesklang['stte']='Vælg sager til eksport';
$hesklang['dtrg']='Datospredning';
$hesklang['sequentially']='Rækkefølge'; // Order tickets: Sequentially
$hesklang['ede']='Kan ikke lave eksport folder. Opret manuelt en mappe, der hedder <b>export</b> i din attachments folder og vær sikker på, at den er skrivbar for PHP (i Linux CHMOD den til 777 - rwxrwxrwx).';
$hesklang['eef']='Kan ikke lave eksport-filen. Der er ikke tilladelse til at skrive til export folderen.';
$hesklang['inite']='Begynder eksport';
$hesklang['gXML']='Laver XML-fil';
$hesklang['nrow']='Antal linier, der er eksporteret: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Komprimerer filen til et zip-arkiv';
$hesklang['eZIP']='Fejl ved komprimeringen af zip-arkivet';
$hesklang['fZIP']='Færdig med at komprimere filen';
$hesklang['pmem']='Peak memory usage: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; KLIK HER FOR AT DOWNLOADE EKSPORT-FILEN &laquo;';
$hesklang['n2ex']='Der blev ikke fundet sager, der matcher dine kriterier.';
$hesklang['sp']='SPAM begræsning'; // For settings page
$hesklang['sit']='Billedtype';
$hesklang['sis']='Simpelt billede';
$hesklang['rcpb']='Site nøgle';
$hesklang['rcpv']='Hemmelig nøgle';
$hesklang['pop3keep']='Behold en kopi';
$hesklang['beta']='(TESTVERSION)';
$hesklang['maxpost']='Du har sandsynligvis forsøgt at indsende flere data, end denne server accepterer.<br /><br />Prøv venligst at indsende formularen igen med mindre eller ingen vedhæftede filer.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Kunne ikke validere reCAPTCHA SPAM-beskyttelse.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Sagen lukket/løst';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Apr';
$hesklang['ms05']='Maj';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Aug';
$hesklang['ms09']='Sep';
$hesklang['ms10']='Okt';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dec';
$hesklang['sdf']='Tilføjet datoformat';
$hesklang['lcf']='Opdateret datoformat';
$hesklang['lcf0']='Kort beskrivelse';
$hesklang['lcf1']='Dato og tid';
$hesklang['lcf2']='HESK stil';
$hesklang['ticket_tpl']='Sagsskabeloner';
$hesklang['can_man_ticket_tpl']='Håndter sagsskabeloner'; // Permission title
$hesklang['ticket_tpl_man']='Håndter sagsskabeloner'; // Page and link title
$hesklang['ticket_tpl_intro']='Opret og rediger sagsskabeloner, som du kan bruge for hurtigt at tilføje nye sager fra admin interfacet.';
$hesklang['no_ticket_tpl']='Ingen sagsskabeloner';
$hesklang['ticket_tpl_title']='Titel';
$hesklang['delete_tpl']='Er du sikker på, at du vil slette skabelonen?';
$hesklang['new_ticket_tpl']='Tilføj eller rediger en sagsskabelon';
$hesklang['ticket_tpl_add']='Ny sagskabelon';
$hesklang['ticket_tpl_edit']='Rediger den valgte sagsskabelon';
$hesklang['save_ticket_tpl']='Gem sagsskabelon';
$hesklang['ticket_tpl_saved']='Din sagsskabelon er blevet gemt';
$hesklang['ticket_tpl_removed']='Den valgte sagsskabelon er blevet slettet';
$hesklang['ticket_tpl_not_found']='Sagsskabelon ikke fundet';
$hesklang['sel_ticket_tpl']='Vælg den sagsskabelon, du ønsker at redigere';
$hesklang['ent_ticket_tpl_title']='Skriv titel på skabelon';
$hesklang['ent_ticket_tpl_msg']='Skriv teksten til skabelonen';
$hesklang['ticket_tpl_id']='Mangler id for sagsskabelon';
$hesklang['select_ticket_tpl']='Vælg en sagsskabelon';
$hesklang['list_tickets_cat']='List alle sager i kategorien';
$hesklang['def_msg']='[Ingen meddelelse]';
$hesklang['emlreqmsg']='Anmod om meddelelse';
$hesklang['emlreqmsg2']='Ignore piped/fetched e-mails med ingen meddelelse';
$hesklang['relart']='Relaterede artikler'; // Title of related articles box
$hesklang['s_relart']='Relaterede artikler'; // On settings page
$hesklang['tab_7']='Sagsliste';
$hesklang['fitl']='Felter i sagsliste';
$hesklang['submitted']='Tilføjet';
$hesklang['clickemail']='Se';
$hesklang['set_pri_to']='Sæt prioritet til:'; // Action below the ticket list
$hesklang['pri_set_to']='Prioritet er sat til:';
$hesklang['cat_pri']='Kategoriprioritet vil blive anvendt, når kunderne ikke får lov til at vælge prioritet og en sag er tilføjet fra kundens grænsefladen.';
$hesklang['cat_pri_info']='Dine kunder får lov til at vælge prioritet. Kategoriprioritet vil blive ignoreret.<br /><br />For at bruge kategori prioritet i stedet, sæt til OFF for følgende funktion i HESK indstillinger:';
$hesklang['def_pri']='Kategoriprioritet:';
$hesklang['ch_cat_pri']='Sæt kategoriprioritet';
$hesklang['cat_pri_ch']='Kategoriprioritet er sat til:';
$hesklang['err_dbversion']='MySQL-version er for gammel:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Rediger note';
$hesklang['ednote2']='Noten er gemt';
$hesklang['perm_deny']='Adgang nægtet';
$hesklang['mis_note']='Manglende id for note';
$hesklang['no_note']='Ingen note blevet fundet med dette id';
$hesklang['sacl']='Gem og forsæt senere';
$hesklang['reply_saved']='Dit svar er blevt gemt til senere brug.';
$hesklang['submit_as']='Tilføj som:';
$hesklang['sasc']='Tilføj som kundesvar';
$hesklang['creb']='Kundesvar skrevet af:';
$hesklang['show_select']='Vis &quot;Klik for at vælge&quot; som forudindstillet mulighed';
// Settings
$hesklang['mms']='Vedligeholdelsestilstand';
$hesklang['mmd']='Aktiver vedligeholdelsestilstand';
// Customer notice
$hesklang['mm1']='Vi opdaterer systemet';
$hesklang['mm2']='Vi opdaterer systemet og har midlertidigt lukket for vores helpdesk. Vi arbejder på højtryk for at være tilbage igen.';
$hesklang['mm3']='Vi beklager ulejligheden og beder dig prøve igen senere.';
// Staff notice
$hesklang['mma1']='Vedligeholdelsetilstand er aktiv!!';
$hesklang['mma2']='Kunderne er ikke i stand til at bruge systemet.';
$hesklang['tools']='Værktøjer';
$hesklang['banemail']='Forbyd e-mails';
$hesklang['banemail_intro']='Forhindrer visse e-mailadresser i at indsende sager til din helpdesk.';
$hesklang['no_banemails']='<i>Ingen e-mails bliver bandlyst.</i>';
$hesklang['eperm']='Permanente e-mail forbud:';
$hesklang['bananemail']='e-mail adresse, der skal forbydes';
$hesklang['savebanemail']='Forbyd denne e-mail';
$hesklang['enterbanemail']='Indtast den e-mailadresse du ønsker at udelukke.';
$hesklang['validbanemail']='Indtast en gyldig e-mail adresse (<i>john.doe@example.com</i>) eller e-mail domæne (<i>@example.com</i>)';
$hesklang['email_banned']='E-mailadressen <i>%s</i> blev forbudt og HESK vil ikke længere acceptere sager fra denne adresse.'; // %s will be replaced with email
$hesklang['emailbanexists']='E-mailadressen <i>%s</i> er allerede forbudt.'; // %s will be replaced with email
$hesklang['email_unbanned']='e-mail forbud slettet';
$hesklang['banby']='Forbudt af';
$hesklang['delban']='Ophæv udelukkelse';
$hesklang['delban_confirm']='Slet dette forbud?';
$hesklang['baned_e']='Du er blevet udelukket fra at indsende nye supportsager.';
$hesklang['baned_ip']='Du er blevet udelukket fra denne helpdesk';
$hesklang['can_ban_emails']='Kan udelukke e-mails';
$hesklang['can_unban_emails']='Kan ophæve e-mails (aktiverer Kan udelukke e-mails)';
$hesklang['eisban']='Denne e-mailadresse er forbudt.';
$hesklang['click_unban']='Klik her for at ophæve forbuddet.';
$hesklang['banip']='Forbyd IP-er';
$hesklang['banip_intro']='Besøgende fra forbudte IP-adresser vil ikke være i stand til at se eller indsende sager og logge ind på helpdesk.';
$hesklang['ipperm']='Permanente IP-forbud:';
$hesklang['iptemp']='Loginfejl forbudt:';
$hesklang['savebanip']='Forbyd denne IP';
$hesklang['no_banips']='<i>Ingen IP-er bliver forbudt.</i>';
$hesklang['bananip']='IP-adresse at udelukke';
$hesklang['banex']='Eksempler:';
$hesklang['iprange']='IP-område';
$hesklang['ippermban']='Forbyd denne IP permanent';
$hesklang['enterbanip']='Indtast den IP-adresse eller det område, du ønsker at udelukke.';
$hesklang['validbanip']='Indtast en gyldig IP-adresse eller IP-område';
$hesklang['ip_banned']='IP-adressen <i>%s</i> blev forbudt og HESK vil ikke længere acceptere sager fra denne IP-adresse.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='IP-området <i>%s</i> blev forbudt og HESK vil ikke længere acceptere sager fra dette IP-område.'; // %s will be replaced with IP
$hesklang['ipbanexists']='IP-adressen <i>%s</i> er allerede forbudt.'; // %s will be replaced with IP
$hesklang['iprbanexists']='IP-området <i>%s</i> er allerede forbudt.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP-forbud slettet';
$hesklang['ip_tempun']='Midlertidig IP-forbud slettet';
$hesklang['can_ban_ips']='Kan forbyde ips';
$hesklang['can_unban_ips']='Kan ophæve ips (aktiverer Kan udelukke ips)';
$hesklang['ipisban']='Denne IP-adresse er forbudt.';
$hesklang['m2e']='Udløber om (minutter)';
$hesklang['info']='Info';
$hesklang['sm_title']='Tjenestemeddelelser';
$hesklang['sm_intro']='Vis en servicemeddelelse i kundeområdet. Eksempelvis for at underrette dem om kendte problemer eller vigtige nyheder.';
$hesklang['can_service_msg']='Rediger servicemeddelelser';
$hesklang['new_sm']='Ny servicemeddelelse';
$hesklang['edit_sm']='Rediger servicemeddelelse';
$hesklang['ex_sm']='Eksisterende servicemeddelelser';
$hesklang['sm_author']='Forfatter';
$hesklang['sm_type']='Type';
$hesklang['sm_published']='Udgivet';
$hesklang['sm_draft']='Udkast';
$hesklang['sm_style']='Stil';
$hesklang['sm_none']='Ingen';
$hesklang['sm_success']='Succes';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Note';
$hesklang['sm_error']='Fejl';
$hesklang['sm_save']='Gem';
$hesklang['sm_preview']='Forhåndsvisning';
$hesklang['sm_mtitle']='Titel';
$hesklang['sm_msg']='Meddelelse';
$hesklang['sm_e_title']='Skriv titel';
$hesklang['sm_e_msg']='Skriv servicemeddelelse';
$hesklang['sm_e_id']='Id mangler for servicemeddelelse';
$hesklang['sm_added']='Servicemeddelelsen er blevet tilføjet';
$hesklang['sm_deleted']='Servicemeddelelsen er slettet';
$hesklang['sm_not_found']='Servicemeddelelsen findes ikke';
$hesklang['no_sm']='Ingen servicemeddelelser';
$hesklang['del_sm']='Slet servicemeddelelsen?';
$hesklang['sm_mdf']='Servicemeddelelsen er blevet gemt';
$hesklang['sska']='Vis forslåede artikler';
$hesklang['taws']='Disse artikler er forslået:';
$hesklang['defaults']='Forudindstillet';
$hesklang['pncn']='Vælg, advisér kunderne i den nye sagsformular';
$hesklang['pncr']='Vælg, advisér kunderne i sagens svarformular';
$hesklang['pssy']='Vis, hvilke artikler fra vidensdatabasen der er blevet foreslået til kunder';
$hesklang['ccct']='Kunders løsning';
$hesklang['custnot']='Advisér kunderne, når';
$hesklang['notnew']='En ny sag er tilføjet';
$hesklang['notclo']='En sag er markeret som løst';
$hesklang['enn']='Med undtagelse af sager fra e-mails, hvis e-mail emnet indeholder:';
$hesklang['spamn']='SPAM varsel';
$hesklang['spam_inbox']='<span style="color:red"><b>Ingen bekræftelsesmail?</b><br />Vi sendte en bekræftelse til din e-mailadresse. Hvis du ikke modtager den inden for et par minutter, skal du tjekke din spam-, junk eller uønsket-mappe. Markér meddelelsen som <b>ikke SPAM</b> for at undgå problemer med at modtage e-mails fra os i fremtiden.</span>';
$hesklang['ekb_n']='<b>NEJ</b>. Deaktivere vidensdatabasen';
$hesklang['ekb_y']='<b>JA</b>. Aktivere vidensdatabasen';
$hesklang['ekb_o']='<b>JA</b>. Brug kun HESK som en vidensdatabase (<i>deaktivere helpdesk</i>)';
$hesklang['kb_set']='Indstillinger for vidensdatabasen';
$hesklang['kbo1']='Kun vidensdatabase-mode';
$hesklang['kbo2']='<br /><br />Besøgende kan ikke indsende nye sager og er taget direkte til vidensdatabasen.';
$hesklang['fpass']='Glemt din adgangskode?';
$hesklang['passr']='Ændre adgangskode';
$hesklang['passa']='Tillad bruger at ændre en glemt adgangskode via e-mail';
$hesklang['passe']='Indtast din e-mailadresse';
$hesklang['passs']='Nulstil adgangskode';
$hesklang['noace']='Hvis du er oprettet i systemet, har vi sendt dig en e-mail med instruktioner til, hvordan du nulstiller din adgangskode.';
$hesklang['pemls']='Hvis du er oprettet i systemet, har vi sendt dig en e-mail med instruktioner til, hvordan du nulstiller din adgangskode.';
$hesklang['reset_password']='Nulstil din adgangskode'; // Email subject
$hesklang['ehash']='Linket er ugyldigt eller udløbet. Prøv at nulstille din adgangskode igen.';
$hesklang['ehaip']='Forkert IP-adresse. Adgangskoden kan kun nulstilles fra den IP-adresse, der anmodede om nulstilling af adgangskoden.';
$hesklang['resim']='<b>Opsætte din nye adgangskode i nedenstående formular!</b>';
$hesklang['permissions']='Tilladelser';
$hesklang['atype']='Kontotype';
$hesklang['astaff']='Personale';
$hesklang['oon1']='Send mig kun åbne sager';
$hesklang['oon2']='Send mig alle mine sager';
$hesklang['anyown']='Alle ejere';
$hesklang['pfr']='En anden POP3-hentning er stadig i gang.';
$hesklang['pjt']='Opgave timeout';
$hesklang['pjt2']='minutter efter start';
$hesklang['nkba']='Søgning i vidensdatabasen kræver nok unikke artikler for at fungere korrekt.<br /><br />Tilføj flere artikler til vidensdatabasen for at forbedre søgning og foreslag.';
$hesklang['saa']='Fastgjorte artikler vises i toppen af artikellisten';
$hesklang['yhbr']='Du er blevet låst ude af systemet i %s minutter pga. for mange svar på en sag.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='da';

// Added in version 2.7.0
$hesklang['imap']='IMAP-hentning';
$hesklang['imaph']='IMAP host';
$hesklang['imapp']='IMAP port';
$hesklang['enc']='Kryptering';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Ingen';
$hesklang['imapu']='IMAP brugernavn';
$hesklang['imapw']='IMAP adgangskode';
$hesklang['imaptest']='Test IMAP-forbindelse';
$hesklang['ifd']='[HESK] IMAP HENTNING ER SLÅET FRA I INDSTILLINGER';
$hesklang['iei']='[HESK] PHP IMAP udvidelse er ikke installeret.';
$hesklang['ifr']='En anden IMAP-hentning er stadig i gang.';
$hesklang['arp']='Genindlæs siden automatisk';
$hesklang['arpp']='Genindlæs siden med sagslisten automatisk hver:';
$hesklang['seconds']='sekund';
$hesklang['minutes']='minuter';
$hesklang['atbr']='Sagen skal være tildelt, før der kan svares på den.';
$hesklang['attm']='Tildel sagen til mig';
$hesklang['owneed']='Ejer mangler';
$hesklang['taat']='Sagen er allerede tildelt til <b>%s</b>.';
$hesklang['scoy']='Er du sikker på, du vil tildele den til dig selv?';
$hesklang['scot']='Er du sikker på, du vil tildele den til %s?';
$hesklang['ycto']='JA, kift ejer';
$hesklang['ncto']='NEJ, behold nuværende ejer';
$hesklang['fass']='Ejer påkrævet';
$hesklang['req_sub']='Emne påkrævet';
$hesklang['req_msg']='Besked påkrævet';
$hesklang['req_email']='E-mail påkrævet';
$hesklang['default_subject']='Sag fra %s';
$hesklang['off-hide']='Skjul i kunde formular';
$hesklang['not_valid_email']='Indtast en gyldig e-mailadresse eller lad felter være tom';
$hesklang['write_down']='<span style="color:red">Vi anbefaler, at du skriver dit sags-ID ned til brug ved senere henvendelse.</span>';
$hesklang['re_confirm1']='Deaktivere du dette, vil det også deaktivere "Kræver e-mail for at se sager" under "Sikkerhed". Fortsæt?';
$hesklang['re_confirm2']='Aktivere du dette vil det også aktivere "Kræver e-mail" under "Indstillinger". Fortsæt?';
$hesklang['can_email_tpl']='Tilpas e-mailskabeloner';
$hesklang['et_title']='E-mail skabeloner';
$hesklang['et_intro']='Tilpas e-mails, der sendes til dit personale eller kunder';
$hesklang['file']='Filer';
$hesklang['efile']='Rediger filer';
$hesklang['rdesc']='Beskrivelse';
$hesklang['desc_forgot_ticket_id']='(Kunder) Glemt sags-ID';
$hesklang['desc_new_reply_by_staff']='(Kunder) Nyt svar fra personalet';
$hesklang['desc_new_ticket']='(Kunder) Sag oprettet';
$hesklang['desc_ticket_closed']='(Kunder) Sag lukket/løst';
$hesklang['desc_category_moved']='(Personale) Sag flyttet til ny kategori';
$hesklang['desc_new_reply_by_customer']='(Personale) Nyt kundesvar';
$hesklang['desc_new_ticket_staff']='(Personale) Ny sag oprettet';
$hesklang['desc_ticket_assigned_to_you']='(Personale) En sag blev tildelt dig';
$hesklang['desc_new_pm']='(Personale) Ny privatbesked';
$hesklang['desc_new_note']='(Personale) Ny note på en sag tildelt dig';
$hesklang['desc_reset_password']='(Personale) Nulstil din adgangskode';
$hesklang['etfm']='En eller flere e-mail skabeloner mangler.<br><br>Sørg for at uploade alle e-mail skabelonfiler i disse to mapper:<br><br><i>/language/%s /emails</i><br><i>/language/%s/html_emails</i>';
$hesklang['etfw']='Nogle e-mail skabeloner kan ikke skrives.<br><br>
                     Sørg for, at PHP har tilladelse til at skrive til alle filer i disse to mapper:<br><br>
                     <i>/language/%s/emails</i><br>
                     <i>/language/%s/html_emails</i><br><br>
                     På Unix-servere skal du muligvis CHMOD e-mail skabeloner til 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Mangler skabelon ID';
$hesklang['et_fm']='Denne e-mail skabelonsfil mangler';
$hesklang['et_fw']='Denne e-mail skabelonsfil kan ikke skrives';
$hesklang['et_save']='Gem ændringer';
$hesklang['updated_on']='Opdateret den';
$hesklang['ticket_url']='Sagers URL';
$hesklang['pm_url']='Privat besked URL';
$hesklang['et_num']='Antal supportsager';
$hesklang['et_list']='Liste over supportsager';
$hesklang['et_empty']='E-mail skabelon må ikke være tom';
$hesklang['et_saved']='E-mail skabelon gemt';
$hesklang['source']='Kilde';
$hesklang['select_category']='Vælg en kategori';
$hesklang['select_category_text']='Hvad kan vi hjælp dig med?';
$hesklang['select_category_staff']='Vælg kategori';
$hesklang['scat']='Max antal kategori valg';
$hesklang['scat2']='(en valg boks vil vises hvis antallet er for højt)';
$hesklang['new_cf']='Nyt brugertilpasset felt';
$hesklang['cf_intro']='Brug denne funktion til at tilføje brugertilpasset felt til "Tilføj en sag"-formular, så du kan indsamle ekstra data om dine kunder.';
$hesklang['cf_public']='Offentlig';
$hesklang['cf_private']='Kun personale';
$hesklang['cf_cust']='Kun kunder';
$hesklang['cf_all']='Alle';
$hesklang['cf_cat']='Valgte';
$hesklang['cf_ctrl']='Tip: Hold CTRL/CMD-tasten nede for at vælge flere kategorier';
$hesklang['visibility']='Synlighed';
$hesklang['cf_save']='Gem brugertilpasset felt';
$hesklang['ex_cf']='Aktiv brugertilpasset felt';
$hesklang['no_cf']='Ingen aktive brugertilpasset felter';
$hesklang['del_cf']='Slet dette brugertilpasset felt? Det vil også slette alle data, som er indsamlet gennem feltet. Handlingen kan ikke fortrydes.';
$hesklang['cf_e_id']='Forkert id';
$hesklang['edit_cf']='Ret brugertilpasset felt';
$hesklang['cf_deleted']='Brugertilpasset felt er slettet';
$hesklang['cf_not_found']='Dette brugertilpasset felt findes ikke';
$hesklang['cf_added']='Et nyt brugertilpasset felt er tilføjet';
$hesklang['cf_nocat']='Vælg mindst en kategori til dette brugertilpasset felt';
$hesklang['cf_mdf']='Brugertilpasset felt er gemt';
$hesklang['atl1']='Indtast mindst et valg.';
$hesklang['sch']='Gemt';
$hesklang['meml3']='Tillad indtastning af flere e-mail adresser';
$hesklang['dmin']='Minimum accepteret dato';
$hesklang['dmax']='Maksimum accepteret dato';
$hesklang['d_day']='dag(e)';
$hesklang['d_week']='uge(r)';
$hesklang['d_month']='måned(er)';
$hesklang['d_year']='år';
$hesklang['d_any']='Enhver dato';
$hesklang['d_fixed']='Fast dato';
$hesklang['d_relative']='Cirka dato';
$hesklang['d_mm']='Minimum dato må ikke være højere end maksimum dato';
$hesklang['d_emin']='Minimum dato for <i>%s</i> er %s';
$hesklang['d_emax']='Maksimum dato for <i>%s</i> er %s';
$hesklang['d_format']='Format for datovisning';
$hesklang['d_custom']='Brugertilpasset format';
$hesklang['d_ci']='KUN FOR ADVANCERET BRUGER: Et valid PHP dato format. Se PHP manual.';
$hesklang['cf_noe']='Skriv en gyldig e-mail adresse i <i>%s</i>';
$hesklang['cf_noem']='Skriv en eller flere gyldige e-mail adresser i <i>%s</i>';
$hesklang['can_resolve']='Kan løse sager';
$hesklang['can_change_own_cat']='Skift sagskategori (til tilladt)';
$hesklang['can_submit_any_cat']='Kan oprette sager i alle kategorier';
$hesklang['noauth_submit']='Du har ikke tilladelse til at oprette sager i kategorien.';
$hesklang['noauth_move']='Du har ikke tilladelse til at flytte sager over i kategorien.';
$hesklang['noauth_resolve']='Du har ikke tilladelse til at løse sager!';
$hesklang['force_ssl']='Gennemtving SSL-forbindelse';
$hesklang['d_ssl']='<i>deaktiveret</i> - åben denne side med https:// for at ændre denne valgmulighed';
$hesklang['scno']='Denne status kan ikke ændres';
$hesklang['statuses']='Statusser';
$hesklang['statuses_intro']='Brug dette værktøj til at tilføje brugertilpasset sagsstatuser';
$hesklang['color']='Farve';
$hesklang['csscl']='CSS class-farver';
$hesklang['clr_view']='Vis tekstfarve forslag';
$hesklang['cbc']='Kan ændres af kunder';
$hesklang['ccc']='Kan kunder ændre denne status?';
$hesklang['del_status']='Slet status?';
$hesklang['ex_status']='Eksisterende statusser';
$hesklang['status_hesk']='Standard statusser (kan ikke ændres her)';
$hesklang['status_custom']='Brugertilpasset statusser';
$hesklang['status_custom_none']='Ingen brugerdefinerede statusser. Du kan tilføje dem ved at klikke på "Ny brugerdefineret status" ovenfor.';
$hesklang['status_save']='Gem';
$hesklang['list_tkt_status']='Vis alle sager med denne status';
$hesklang['new_status']='Ny tilpasset status';
$hesklang['edit_status']='Rediger tilpasset status';
$hesklang['err_status']='Skriv navn på status';
$hesklang['status_added']='En ny tilpasset status er blevet tilføjet';
$hesklang['status_e_id']='Forkert id';
$hesklang['status_mdf']='Tilpasset status er blevet gemt';
$hesklang['status_deleted']='Tilpasset status slettet';
$hesklang['status_not_found']='Denne tilpasset status findes ikke';
$hesklang['status_not_empty']='Denne status kan ikke slettes, da der findes sager med denne status';
$hesklang['status_limit']='Du har 100 tilpassede statuser. Der kan ikke tilføjes flere.';
$hesklang['public_link']='Offentlig genvej';
$hesklang['frames']='Rammer';
$hesklang['frames2']='Forbyd indlæsning af HESK i rammer på andre domæner';
$hesklang['numsub']='Tilføjede sager';
$hesklang['hidf']='Skjulte indtastninger er ikke synlig for kunder på "Tilføj en sag"-formularen. Oplysningen vil stadig være synlig på sagens oversigtsside, hvis de er sat som offentlig. De opfører sig som normale tekstfelter for personale.';
$hesklang['rcheck']='Vælg ikke en standardmulighed';
$hesklang['refresh_page']='Genindlæs siden';
$hesklang['del_kba']='Slet artiklen';
$hesklang['del_kbaa']='Er du sikker på, at du vil slette ariklen?';
$hesklang['hni1']='HESK ikke installeret endnu?';
$hesklang['hni2']='Det lader til at denne help desk, ikke er blevet installeret korrekt eller konfigureret endnu.';
$hesklang['hni3']='For at installere HESK, følg <a class="link" href="docs/">instruktionerne i dokumentationen</a>';
$hesklang['cf']='Cache mappe';
$hesklang['e_cdir']='HESK vil ikke have mulighed for at sende e-mails eller gemme resultater før en cache folder eksisterer og er skrivebar.';
$hesklang['step1']='Trin 1';
$hesklang['step2']='Trin 2';
$hesklang['dffs']='Når download er færdig, skal du slette filen fra serveren';
$hesklang['fd']='Eksportér fil slettet fra serveren';

// Added in version 2.8.0
$hesklang['TZ']='Tidszone';
$hesklang['thist17']='<li class="smaller">%s | indsat af IMAP-hentning</li>';
$hesklang['sir3']='Skjult reCAPTCHA';
$hesklang['invisible']='skjult';
$hesklang['imap_not']='PHP er ikke tilpasset med IMAP-support';
$hesklang['imap_warning']='bruger %1$s har samme e-mailadresse som din IMAP-hentnings e-mailadresse: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='bruger %1$s har samme e-mailadresse som din POP3-hentnings e-mailaddress: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Dette kunne føre til en e-mail loop, hvor nye sager bliver oprettet ud fra brugerens e-mailnotifikation. Din hentnings e-mailadresse bør være unik og ikke brugt af andre.';
$hesklang['can_view_ass_by']='Kan se sager, vedkommende har tildelt andre';
$hesklang['can_privacy']='Kan anonymiser sager';
$hesklang['confirm_anony']='Anonymiser sagen';
$hesklang['anon_selected']='Anonymiser udvalgte sager';
$hesklang['privacy_anon_info']='Fjern alle personhenførbare data og alt indhold fra sager (kunde navn, e-mail, besked, vedhæftninger, IP...), men behold sagerne i databasen pga. statistik. Handlingen kan ikke fortrydes.';
$hesklang['success_anon']='Sagen blevet anonymiseret';
$hesklang['num_tickets_anon']='Antal sager anonymiseret: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Anonymisteret kunde]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Anonymiseret emne]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Anonymiseret besked]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonymiseret af %s</li>';
$hesklang['print_selected']='Udskriv valgte sager';
$hesklang['with_selected']='Med valgte:';
$hesklang['assign_selected']='Tildel valgte til:';
$hesklang['assign_no']='Ingen ejer valgt. Inden ændringer udført';
$hesklang['assign_1']='Valgte sager er blevet ændre til: ikke tildelt .';
$hesklang['assign_2']='Sags ID %1$s ændret til: ikke tildelt'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s fejl: allerede tildelt til %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s tildelt til %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s fejl: %2$s har ikke adgang til sagskategori'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultatet af sagstildeling-proces:<br /><br />Tildelt: %1$s<br />Fejl: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP-adresse';
$hesklang['moret']='Flere muligheder'; // More options button title
$hesklang['btn_more']='Mere'; // More options button text
$hesklang['btn_print']='Print';
$hesklang['btn_edit']='Rediger';
$hesklang['btn_lock']='Lås sag';
$hesklang['btn_unlock']='Genåben sag';
$hesklang['btn_tag']='Marker sag';
$hesklang['btn_resend']='Gensend e-mail notifikation';
$hesklang['btn_untag']='Fjern markering på sag';
$hesklang['btn_import_kb']='Importere til vidensdatabasen';
$hesklang['btn_anony']='Anonymiser sag';
$hesklang['btn_delt']='Slet sag';
$hesklang['btn_delr']='Slet svar';
$hesklang['ernf']='Svar ikke fundet';
$hesklang['tns']='Sagsnotifikation sendt igen';
$hesklang['rns']='Svarnotifikation sendt igen';
$hesklang['fname']='Fornavn';
$hesklang['export_selected']='Eksportere valgte sager';
$hesklang['btn_export']='Eksportere til XML for Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Svar';
$hesklang['team']='Team';
$hesklang['sm_content']='Indhold';
$hesklang['sm_settings']='Indstillinger';
$hesklang['wizard_back']='Tilbage'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Næste'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Gå til Indstillinger';
$hesklang['sm_return_to_editing']='Vend tilbage til redigering';
$hesklang['email_tpl_title']='Titel';
$hesklang['edit_email_template']='Rediger e-mail skabelon';
$hesklang['err_no_settings_section']='Ingen indstillingssektion blev angivet.';
$hesklang['this_field_is_required']='Dette felt er påkrævet';
$hesklang['reset_your_password']='Nulstil din adgangskode';
$hesklang['reset_password_instructions']='Udfyld venligst nedenstående formular. Vi sender dig et link til, hvor du kan nulstille din adgangskode.';
$hesklang['enter_email']='Skriv e-mail';
$hesklang['password_reset_check_your_email']='Kontroller din e-mail';
$hesklang['password_reset_link_sent']='Vi har sendt dig et link til at nulstille din adgangskode.';
$hesklang['back_to_login']='Tilbage til login';
$hesklang['pager_first']='Første';
$hesklang['pager_previous']='Forrige';
$hesklang['pager_next']='Næste';
$hesklang['pager_last']='Sidste';
$hesklang['new_team_member']='Nyt teammedlem';
$hesklang['role']='Rolle';
$hesklang['optional']='Valgfri';
$hesklang['edit_profile']='Ret profil';
$hesklang['assigned_to']='Tildelt til';
$hesklang['contact']='Kontakt';
$hesklang['unban_email']='Tillad denne e-mail';
$hesklang['unban_ip']='Tillad denne IP';
$hesklang['show_previous_replies']='Vis tidligere svar';
$hesklang['type_your_message']='Skriv dit svar'; // Used when there are no canned responses
$hesklang['close_button_text']='Luk';
$hesklang['create_new_ticket']='Opret ny sag';
$hesklang['delete_article']='Slet artikel';
$hesklang['view_existing_tickets']='Vis eksisterende sag';
$hesklang['how_can_we_help']='Velkommen, Hvordan kan vi hjælpe ?';
$hesklang['search_for_articles']='Søg efter artikler';
$hesklang['submit_a_support_request']='Opret en sag';
$hesklang['verify_header']='SPAM-beskyttelse';
$hesklang['ticket_details']='Sagsdetajler';
$hesklang['yes_title_case']='Ja';
$hesklang['no_title_case']='Nej';
$hesklang['no_results_found']='Ingen resultater fundet';
$hesklang['site_theme']='Site tema';
$hesklang['test_theme_folder']='Test tema mappe';
$hesklang['test_theme_folder_description']='Tester temamappen for gyldige temaer. Kun temaer, der består alle tests, er korrekt installeret.';
$hesklang['err_site_theme']='Vælg venligst Hesk-tema';
$hesklang['confirm']='Bekræft';
$hesklang['confirm_deletion']='Bekræft sletning';
$hesklang['confirm_delete_status']='Er du sikker på, at du vil slette denne brugerdefinerede status?';
$hesklang['help_desk']='Help Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.da.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Visning af tid';
$hesklang['tdisd']='Dato og tid';
$hesklang['tdisa']='Tid siden (eksempel: 5 timer siden)';
$hesklang['nav_templates']='Skabeloner'; // Admin panel navigation item
$hesklang['hide_replies']='Skjul sagssvar';
$hesklang['hide_replies_no']='Aldrig, vis altid alle svar';
$hesklang['hide_replies_yes']='Skjul alle svar undtagen de sidste:';
$hesklang['hide_replies_def']='Vis det seneste personale svar og alle efterfølgende kunde svar';
$hesklang['reply_by']='Svaret af'; // Reply by NAME
$hesklang['btt']='Tilbage til toppen';
$hesklang['lwidth']='Begræns sagsbredde';
$hesklang['lwidtall']='Brug den fulde tilgængelige bredde';
$hesklang['lwidtpx']='Maksimal bredde i pixels:';
// 3-letter days of the week
$hesklang['mon']='Man';
$hesklang['tue']='Tir';
$hesklang['wed']='Ons';
$hesklang['thu']='Tor';
$hesklang['fri']='Fre';
$hesklang['sat']='Lør';
$hesklang['sun']='Søn';
$hesklang['clear']='Ryd'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Mindst én SPAM-forebyggende foranstaltning skal være aktiveret!';
$hesklang['modules']='Modul';
$hesklang['modules_demo']='Dette modul er i øjeblikket kun tilgængeligt i %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Prøv live demo her: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistikker';
$hesklang['statistics']['intro']='Rapporten vil give dig indsigt i systemets forbrug og personalets indsats.';
$hesklang['statistics']['ntsp']='Ingen sager i den valgte periode.';
$hesklang['statistics']['pie_title_ro']='Åbne vs løste sager';
$hesklang['statistics']['open']='Åbne';
$hesklang['statistics']['resolved']='Løste';
$hesklang['statistics']['pie_title_as']='Åbne sager: tildelte vs ikke tildelte';
$hesklang['statistics']['ass']='Tildelt';
$hesklang['statistics']['unas']='Ikke tildelt';
$hesklang['statistics']['pie_title_au']='Åbne sager: besvaret vs ubesvaret';
$hesklang['statistics']['answered']='Besvaret';
$hesklang['statistics']['unanswered']='Ubesvaret';
$hesklang['statistics']['pie_title_so']='Status for åbne sager';
$hesklang['statistics']['retic']='Sager:';
$hesklang['statistics']['chart_title_md']='Sager per dag i måneden';
$hesklang['statistics']['chart_title_wd']='Sager per ugedag';
$hesklang['statistics']['chart_title_hd']='Sager per time';
$hesklang['statistics']['chart_title_tfr']='Tid til første teamsvar';
$hesklang['statistics']['chart_title_tfrc']='Sager besvaret inden for tidsrammen';
$hesklang['statistics']['chart_title_ttr']='Tid fra indsendelse til løsning af en sag';
$hesklang['statistics']['chart_title_ttrc']='Sager løst inden for tidsrammen';
$hesklang['statistics']['chart_title_sr']='Teamsvar';
$hesklang['statistics']['chart_title_srt']='Teamsvar per sag';
$hesklang['statistics']['chart_title_srtr']='Teamsvar per sag (kun løste sager)';
$hesklang['statistics']['chart_title_srt1']='Teamsvar per sag (sager med mindst 1 svar)';
$hesklang['statistics']['ct_30']='30 minuter';
$hesklang['statistics']['ct_1h']='1 time';
$hesklang['statistics']['ct_2h']='2 timer';
$hesklang['statistics']['ct_4h']='4 timer';
$hesklang['statistics']['ct_1d']='1 dag';
$hesklang['statistics']['ct_2d']='2 dage';
$hesklang['statistics']['ct_3d']='3 dage';
$hesklang['statistics']['ct_1w']='1 uge';
$hesklang['statistics']['ct_wp']='Over 1 uge';
$hesklang['statistics']['ct_1m']='1 måned';
$hesklang['statistics']['ct_mp']='Over 1 måned';
$hesklang['statistics']['axis1']='% sager besvaret';
$hesklang['statistics']['axis2']='% sager løst';
$hesklang['statistics']['axis3']='% sager';
$hesklang['statistics']['axis4']='Tid til første svar';
$hesklang['statistics']['axis5']='Tid til løsning';
$hesklang['statistics']['axis6']='Antal svar';
$hesklang['statistics']['axis7']='Antal sager';
$hesklang['statistics']['axis8']='Ugedag';
$hesklang['statistics']['axis9']='Time';
$hesklang['statistics']['axis10']='Dag på måneden';
$hesklang['statistics']['tr_0']='Ingen svar';
$hesklang['statistics']['tr_1']='1 svar';
$hesklang['statistics']['tr_2']='2 svar';
$hesklang['statistics']['tr_5']='3-5 svar';
$hesklang['statistics']['tr_10']='6-10 svar';
$hesklang['statistics']['tr_99']='10+ svar';
$hesklang['statistics']['average']='Gennemsnit';
$hesklang['statistics']['atfr']='Gennemsnitlige timer og minutter til det første teamsvar:';
$hesklang['statistics']['attr']='Gennemsnitlige timer og minutter til sagen blev løst:';
$hesklang['statistics']['about']='omkring %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Total antal sager, som teamet har svaret på:';
$hesklang['statistics']['trnr']='Samlet antal sager løst uden teamsvar:';
$hesklang['statistics']['tsr']='Total antal teamsvar:';
$hesklang['statistics']['tsrt']='Gennemsnitligt antal teamsvar pr. sag:';
$hesklang['statistics']['tsro']='Gennemsnitligt antal teamsvar pr. sag (sager med mindst 1 team svar):';
$hesklang['statistics']['tsrc']='Gennemsnitligt antal teamsvar før en sag løses:';
$hesklang['statistics']['tsrr']='Gennemsnitligt antal teamsvar før en sag løses (sager med mindst 1 team svar):';
$hesklang['sep_1000']='.'; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='og meget mere...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Sagen er forsinket';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESKALERET: %%SUBJECT%%';
$hesklang['escalate']['tab']='Opgradering'; // Menu link
$hesklang['escalate']['page_title']='Opgradering'; // Page H2 title
$hesklang['escalate']['intro']='Modulet hjælper med at opgrader sager, som ikke er blevet behandlet.';
$hesklang['escalate']['feat1']='Sager, som ikke er tildelt, besvaret eller løst inden en given tidsramme';
$hesklang['escalate']['feat2']='Sager, som nærmer sig forfaldsdato og forfaldne sager';
$hesklang['escalate']['feat3']='Skift sagens prioritet automatisk, tildel sagen igen, send e-mail notifikation';
$hesklang['escalate']['feat4']='Anvend regler baseret på sagens kategori, ejer og status';
$hesklang['escalate']['prefix']='Opgradret:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Aktive regler';
$hesklang['escalate']['new']='Ny opgraderingsregel';
$hesklang['escalate']['no_rules']='Du har ikke nogen opgraderingsregler. Opret en regel ved at trykke &quot;Ny opgraderingsregel&quot; ovenfor.';
$hesklang['escalate']['title']='Navn på opgradering';
$hesklang['escalate']['titlet']='Lav en beskrivende titel. Eksempelvis: Tildel sag på ny, hvis den ikke er besvaret inden for 24 timer.';
$hesklang['escalate']['default_title']='Regel af %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Udløser';
$hesklang['escalate']['trigt']='Definér, hvad der udløser reglen.';
$hesklang['escalate']['hits']='Antal'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Betingelser'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Handling'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Tildel til'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Slet regel?';
$hesklang['escalate']['edit']='Redigér opgraderingsregel med ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='En sag er:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='ikke besvaret';
$hesklang['escalate']['nrepc']='ikke besvaret af kunden';
$hesklang['escalate']['nass']='ikke tildelt en bruger';
$hesklang['escalate']['nres']='ikke løst';
$hesklang['escalate']['ndue']='nærmer sig deadline';
$hesklang['escalate']['odue']='overskredet';
$hesklang['escalate']['within']='Inden for:';
$hesklang['escalate']['minutes']='minutter';
$hesklang['escalate']['hours']='timer';
$hesklang['escalate']['days']='dage';
$hesklang['escalate']['weeks']='uger';
$hesklang['escalate']['months']='måneder';
$hesklang['escalate']['years']='år';
$hesklang['escalate']['ofs']='fra oprettelse';
$hesklang['escalate']['resend']='Gen-send notifikation:';
$hesklang['escalate']['force']='Send altid. Tilsidesæt brugerens indstillinger for notifikationer';
$hesklang['escalate']['noforce']='Respektér brugerens indstillinger for notifikationer';
$hesklang['escalate']['setpri']='Sæt prioritet til:';
$hesklang['escalate']['setsta']='Sæt status til:';
$hesklang['escalate']['assto']='Tildel sag til:';
$hesklang['escalate']['asm']='En anden bruger';
$hesklang['escalate']['notify']='Notificér brugere...';
$hesklang['escalate']['ato']='Tildel til:';
$hesklang['escalate']['tic']='Sager i kategori:';
$hesklang['escalate']['tat']='Sager tildelt til:';
$hesklang['escalate']['tws']='Sager med status:';
$hesklang['escalate']['tall']='Anvend reglen på eksisterende og fremtidige sager';
$hesklang['escalate']['tfn']='Anvend kun reglen på fremtidige sager og ignorere eksisterende regler.';
$hesklang['escalate']['tfi']='Anvend reglen på sager med ID højere end:';
$hesklang['escalate']['save']='Gem reglen';
$hesklang['escalate']['e_tt']='Tid skal være mellem 1 og 10.000';
$hesklang['escalate']['e_a']='Vælg mindst en handling for at matche sager:';
$hesklang['escalate']['nocat']='Vælg mindst en kategori';
$hesklang['escalate']['nouser']='Vælg mindst en bruger';
$hesklang['escalate']['nostatus']='Vælg mindst en status';
$hesklang['escalate']['nocata']='%1$s har ikke adgang til følgende kategorier:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Reglen er tilføjet';
$hesklang['escalate']['mdf']='Regelbetingelser er blevet gemt';
$hesklang['escalate']['e_id']='Ingen regel med id\'et blev fundet';
$hesklang['escalate']['deleted']='Reglen er slettet';
$hesklang['escalate']['edit_notice']='Ændrer du, hvad der udløser reglen, har det ikke indflydelse på sager, som allerede er opgraderet af reglen (medmindre du nulstiller reglen).';
$hesklang['escalate']['reset']='Nulstil regel';
$hesklang['escalate']['reset2']='Er du sikker på, at du vil nulstille reglen?<br><br>Antallet af hits sættes til 0 og alle sager, som matcher reglen vil blive opgraderet igen.';
$hesklang['escalate']['reset3']='Reglen er nulstillet';
$hesklang['escalate']['log_title']='Regel #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | opgraderet af %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - sæt prioritet til %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - tildel til %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - send notifikation til personale</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - send notifikation til personale (tvungen)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - fejl: %2$s har ikke adgang til kategorien</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - fejl: %2$s har ikke adgang til sager</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - fejl: ingen anden bruger kan se sagen</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - info: prioriteten er allerede sat til %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - info: allerede tildelt til %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - giv besked: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - sæt status til %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - info: statussen er allerede sat til %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Aktiv'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Aktivér reglen';
$hesklang['escalate']['activated']='Reglen er blevet aktiveret'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deaktivér reglen';
$hesklang['escalate']['deactivated']='Reglen er deaktiveret'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Ingen aktive opgraderingsregler';
$hesklang['escalate']['matched']='Antal macthende sager fundet: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Værktøjer';
$hesklang['escalate']['test']='Test reglen';
$hesklang['escalate']['testa']='Test alle regler';
$hesklang['escalate']['testaa']='Test alle aktive relger';
$hesklang['escalate']['testr']='Testresultater';
$hesklang['escalate']['rsim']='Gentag test';
$hesklang['escalate']['tbef']='Før en regel er aktiv, skal du aktivere den ved at klikke i feltet &quot;AKTIV&quot;.<br><br>
                               Vi anbefaler kratigt, at du <strong>tester</strong> hver regel ved at klikke på ikonet %1$s (Test reglen) i oversigten
                               for at se, hvordan reglen påvirker eksisterende sager.<br><br>
                               <strong>Aktive regler køres hver %2$s. minut. En sag kan kun opgraderes en gang per regel</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='TEST MODE. Ingen ændring foretaget';
$hesklang['escalate']['sic']='TEST FÆRDIG';
$hesklang['escalate']['r']='[REGEL]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Tip: hold CTRL/CMD-tasten nede for at vælge flere muligheder';
$hesklang['desc_ticket_escalated']='(Personale) En sag er opgraderet'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Tekstformatering (personale)';
$hesklang['ticket_formatting_plaintext']='Almindelig tekst';
$hesklang['ticket_formatting_rich_text']='Formateret tekst (HTML)';
$hesklang['due_date']='Forfaldsdato';
$hesklang['invalid_due_date']='Forfaldsdatoen er ugyldig.';
$hesklang['thist19']='<li class="smaller">%s | forfaldsdato opdateret til %s af %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | forfaldsdato fjernet af %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Sagens forfaldsdato er blevet opdateret.';
$hesklang['menu_kb_manage']='Redigér'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Vis'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Vælg alle';
$hesklang['a_deselect']='Fravælg alle';
$hesklang['a_toggle']='Skjul alle';
$hesklang['ql_all']='Alle sager';
$hesklang['ql_alo']='Alle åbne sager';
$hesklang['ql_fit']='Filtrede sager';
$hesklang['ql_a2m']='Tildelt til mig';
$hesklang['ql_a2o']='Tildelt andre';
$hesklang['ql_una']='Ikke tildelt';
$hesklang['ql_due']='Forfalder snart';
$hesklang['ql_ovr']='Overskredet';
$hesklang['set_ds']='Vis som &quot;forfalder snart&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='dage til forfald';
$hesklang['not_aos']='Nogle åbne sager, du har adgang til, bliver ikke vist pga. det aktuelle filter.';
$hesklang['ntoverdue']='En sag er forfalden med ejer:';
$hesklang['ovdcron']='for at modtage notifikationer om forfaldne sager, skal webmasteren have aktiveret cronjob.';
$hesklang['instructions']='Instruktioner';
$hesklang['desc_overdue_ticket']='(Personale) En sag er forfalden';
$hesklang['overdue_starting']='Sender notifkationer om overskrede sager';
$hesklang['overdue_sim']='Afsendelse af e-mails og opdatering af sager er deaktiveret  og opdatering af sager er ikke muligt i SIMULATION mode.';
$hesklang['overdue_ticket_count']='Fandt %s sager, som er overskredet.'; // %s = Number of tickets
$hesklang['overdue_finished']='Notifikationer af overskredet sager sendt. %s e-mails sendt. %s e-mails kunne ikke sendes.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Administrator CSS';
$hesklang['admin_css2']='Indlæs en brugerdefineret css style for administrationsdelen';
$hesklang['noval_cert']='Verificer ikke server certifikater';
$hesklang['chg_cat']='Klik for at ændre sagskategorien';
$hesklang['tlan']='Sagssprog';
$hesklang['uue']='To eller flere brugere har den samme e-mailadresse. Vi anbefaler, at alle brugere har en unik e-mailadresse.';
$hesklang['flood']='Begrænsning af samtidige svar (flood)';
$hesklang['e_flood']='Hov. Du har allerede tilføjet et svar. For at undgå fejl har vi kun sendt et svar.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='URL adgangsnøgle'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Generer en tilfældig URL adgangsnøgle';
$hesklang['ukeym']='Fejl: For at køre filen via HTTP skal du inkludere din URL adgangsnøgle i forespørgslen. Eksempelvis:';
$hesklang['ukeyw']='Fejl: Forkert URL adgangsnøgle';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Sagen modtaget: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% er din bekræftelseskode';
$hesklang['follow_up_email']='Vær ærlig - hvordan gjorde vi det?';
$hesklang['mfa']='Multi-Factor Authentication (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA aktiveret?';
$hesklang['mfa_required']='Kræv Multi-Factor Authentication';
$hesklang['mfa_manage_profile']='Administrer MFA';
$hesklang['mfa_disabled']='Multi-Factor Authentication er deaktiveret';
$hesklang['mfa_enabled']='Multi-Factor Authentication er aktiveret (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Ingen';
$hesklang['mfa_method_none_subtext']='Fjern multi-faktor godkendelse på din konto.';
$hesklang['mfa_method_email']='E-mail';
$hesklang['mfa_method_email_subtext']='Helpdesk vil sende en e-mail med en tilfældig login-kode til <strong>%s</strong> når du logger ind.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authenticator-app';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Brug en smartphone-applikation, såsom Authy eller Google Authenticator, til at generere en tilfældig login-kode, når du logger ind.';
$hesklang['mfa_step_method']='Metode';
$hesklang['mfa_step_verification']='Bekræftelse';
$hesklang['mfa_step_complete']='Fuldfør';
$hesklang['mfa_introduction']='Multifaktorgodkendelse forbedrer kontosikkerheden ved at kræve, at du bekræfter dit login ved hjælp af en ekstra bekræftelsesmetode, såsom e-mail eller en godkendelsesapp (såsom Authy eller Google Authenticator).';
$hesklang['mfa_reset_warning']='Du har allerede multi-faktor godkendelse aktiveret. Hvis du udfylder dette igen, nulstilles din multifaktorgodkendelsesenhed (hvis aktiveret).';
$hesklang['mfa_select_method_colon']='Vælg en godkendelsesmetode:';
$hesklang['mfa_verification_header']='Bekræftelse - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='En e-mail er blevet sendt til <strong>%s</strong> indeholdende en sekscifret bekræftelseskode. Indtast koden du har modtaget via e-mail nedenfor for at fortsætte.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Trin 1: Scan billedet nedenfor med multifaktor-godkendelsesappen på din mobilenhed.';
$hesklang['mfa_verification_auth_app_cant_scan']='Kan du ikke scanne billedet? Indtast denne kode manuelt på din enhed: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Trin 2: Indtast den 6-cifrede kode, der vises på din applikation for at bekræfte din enhed.';
$hesklang['mfa_verify']='Bekræft';
$hesklang['mfa_invalid_method']='Ugyldig multi-faktor godkendelsesmetode blev modtaget.';
$hesklang['mfa_invalid_verification_code']='Koden der blev indtastet er forkert eller udløbet.';
$hesklang['mfa_configured']='Multi-faktor godkendelse er blevet aktiveret for din konto!';
$hesklang['mfa_removed']='Multi-faktor godkendelse er blevet deaktiveret for din konto!';
$hesklang['mfa_verification_needed']='Multi-faktor godkendelse er aktiveret for denne konto.';
$hesklang['mfa_verification_needed_email']='Indtast venligst bekræftelseskoden, der blev sendt til din e-mail adresse.';
$hesklang['mfa_verification_needed_auth_app']='Indtast venligst koden, der vises på din godkendelsesapp.';
$hesklang['mfa_verification_code']='Bekræftelseskode';
$hesklang['mfa_server_time_issue']='Din servertid ser ud til at være unøjagtig: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Nulstil multi-faktor godkendelse';
$hesklang['mfa_reset_confirm']='Er du sikker på, at du ønsker at nulstille MFA for denne bruger?';
$hesklang['mfa_reset_yes']='Nulstil';
$hesklang['mfa_reset']='Multi-Factor Authentication er blevet nulstillet for brugeren';
$hesklang['desc_mfa_verification']='(Personal) Multi-Factor Authentication Code';
$hesklang['mfa_code']='Kode:';
$hesklang['mfa_backup_codes_header']='GEM DINE BACKUP-KODER!';
$hesklang['mfa_backup_codes_description']='Opbevar disse backup-koder et sikkert, men tilgængeligt sted. I tilfælde af at du mister adgangen til din MFA-enhed eller e-mail, kan du indtaste en af følgende backupkoder for at logge ind.<br><br><strong>Sørg for at behandle disse backupkoder som adgangskoder. Du vil ikke kunne se disse koder igen!</strong>';
$hesklang['mfa_verify_another_way']='Bekræft din konto på en anden måde'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Få en bekræftelseskode på %s';
$hesklang['mfa_verify_another_way_code']='Indtast en af dine 8-tegns backup-koder';
$hesklang['mfa_verify_another_way_admin']='Kontakt din helpdesk-administrator for at få hjælp';
$hesklang['mfa_verify_another_way_reset']='Nulstil din multi-faktor godkendelse ved at uploade en fil til serveren';
$hesklang['mfa_send_another_email']='Send endnu en e-mail';
$hesklang['mfa_sent']='En e-mail med en ny bekræftelseskode blev sendt til din e-mailadresse';
$hesklang['mfa_backup_code']='Sikkerhedskopieringskode';
$hesklang['mfa_backup_codes']='Sikkerhedskopieringskoder';
$hesklang['mfa_backup_codes_info']='Engangskoder til at bestå multifaktorbekræftelse, når du ikke kan få adgang til din e-mail eller godkendelsesapp. Når du bruger en backupkode til at logge ind, bliver denne kode inaktiv.';
$hesklang['mfa_backup_codes_num']='Du kan få et nyt sæt med 10 backup-koder, når du vil. Når du opretter et nyt sæt koder, bliver det gamle sæt automatisk inaktivt.';
$hesklang['mfa_backup_codes_num2']='Antal af dine aktive koder: %s';
$hesklang['mfa_invalid_backup_code']='Sikkerhedskopieringskoden, der blev indtastet, er forkert eller er allerede blevet brugt.';
$hesklang['mfa_del_codes']='Slet mine backup-koder';
$hesklang['mfa_del_codes2']='Alle dine backup-koder er blevet slettet.';
$hesklang['mfa_new_codes']='Generer nye backup-koder';
$hesklang['mfa_new_codes2']='Nye backup-koder er blevet genereret';
$hesklang['old_php_version']='Fejl: Ikke-understøttet PHP-version';
$hesklang['category_default_due_date']='Standard forfaldsdato';
$hesklang['category_change_default_due_date']='Indstil standard forfaldsdato';
$hesklang['category_leave_blank_for_no_default_due_date']='(lad tom for ingen standard forfaldsdato)';
$hesklang['category_default_due_date_updated']='Standard forfaldsdato er blevet opdateret.';
$hesklang['email_formatting']='E-mail formatering';
$hesklang['email_formatting_html_and_plaintext']='HTML med tekst alternativ fra tekst skabelon (standard)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML med tekst-alternativ genereret fra HTML-skabelon';
$hesklang['email_formatting_html']='kun HTML';
$hesklang['email_formatting_plaintext']='Kun almindelig tekst';
$hesklang['email_formatting_note']='Dit valg i %1$s &gt; %2$s &gt; %3$s er indstillet til: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Dette betyder, at Hesk vil ignorere HTML-skabelonerne her.';
$hesklang['email_formatting_note1']='Dette betyder, at Hesk vil ignorere almindelig tekst skabeloner her.';
$hesklang['email_formatting_note2']='Dette betyder, at Hesk vil generere almindelig tekst-version af e-mails fra dine HTML-skabeloner og ignorere almindelig tekst-skabelonerne her.';
$hesklang['etnu']='Denne e-mail skabelon bruges i øjeblikket ikke af Hesk baseret på dit valg i %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Rediger kategori';
$hesklang['create_category']='Opret kategori';
$hesklang['one_user_included']='1 bruger inkluderet';
$hesklang['one_user_excluded']='1 bruger ekskluderet';
$hesklang['x_users_included']='%s brugere inkluderet'; // %s = Number of users
$hesklang['x_users_excluded']='%s brugere ekskluderet'; // %s = Number of users
$hesklang['aa_cat']='Tildel automatisk sager i denne kategori';
$hesklang['modify_autoassign_settings']='Rediger indstillinger for automatisk tildeling';
$hesklang['autoassign_on_all_users']='Ja, til enhver bruger med adgang til denne kategori';
$hesklang['autoassign_on_select_users']='Ja, til specifikke brugere';
$hesklang['autoassign_off']='Nej, indsend sagen som ikke-tildelte';
$hesklang['autoassign_users']='Brugere der skal inkluderes/ekskluderes i automatisk tildeling';
$hesklang['autoassign_selected_include']='Udvalgte brugere bør <strong>inkluderes</strong> når sager automatisk tildeles i denne kategori';
$hesklang['autoassign_selected_exclude']='Udvalgte brugere bør <strong>udelukkes</strong> når sager automatisk tildeles i denne kategori';
$hesklang['cat_edited']='Kategori %s er blevet redigeret';
$hesklang['search_for_user']='Søg efter bruger';
$hesklang['email_sending']='Sender e-mails';
$hesklang['email_to_ticket']='E-mail til sag';
$hesklang['email_to_ticket_info']='Konvertering af e-mails til sager kræver en vis opsætning på serversiden. For detaljer, se venligst <a href="%s" target="_blank">denne vidensbasevejledning</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk bruger en SMTP-server til at sende e-mail notifikationer. Din <strong>%1$s</strong> skal være indstillet til <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Manglende filtypenavn';
$hesklang['block_ignore']='E-mail til sag - Ignorer e-mails og forhindre loops';
$hesklang['block_noreply']='Svar ikke';
$hesklang['block_noreply2']='Ignorer e-mails sendt fra &quot;svar ikke&quot; email adresse';
$hesklang['block_returned']='Returneret';
$hesklang['block_returned2']='Ignorer returnerede e-mails, såsom meddelelser om leveringsstatus og automatiske svar';
$hesklang['block_duplicate']='Duplikater';
$hesklang['block_duplicate2']='Ignorer e-mails med den samme besked sendt inden for &quot;%s&quot; sekunder'; // %s = "Timeframe"
$hesklang['loop_info']='e-mails modtaget fra den samme e-mailadresse inden for &quot;%s&quot; sekunder';
$hesklang['thist21']='<li class="smaller">%s | forsinket e-mail meddelelse sendt</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | opfølgende e-mail sendt</li>'; // %s = date
$hesklang['elevator_header']='Gå ind i det sikre område';
$hesklang['elevator_intro']='Du er ved at gå ind i et sikkert område.';
$hesklang['elevator_enter_password']='Indtast venligst din adgangskode for at fortsætte.';
$hesklang['elevator_duration_setting_title']='Sikkert område varighed';
$hesklang['desc_survey']='(Kunde) Opfølgnings e-mail (undersøgelse)'; // Email description
$hesklang['satisfaction']['tab']='Tilfredshed';
$hesklang['satisfaction']['title']='Kundetilfredshedsundersøgelse';
$hesklang['satisfaction']['intro']='Send dine kunder en opfølgende tilfredshedsundersøgelse for at indsamle feedback om deres oplevelse med din helpdesk.';
$hesklang['satisfaction']['tab1']='Indstillinger';
$hesklang['satisfaction']['tab2']='Fravælg';
$hesklang['satisfaction']['enable']='Aktiver opfølgende e-mails:';
$hesklang['satisfaction']['enabled']='Kundetilfredshedsundersøgelser er aktiveret.';
$hesklang['satisfaction']['disabled']='Kundetilfredshedsundersøgelser er i øjeblikket deaktiveret.';
$hesklang['satisfaction']['url']='Survey URL-adresse:';
$hesklang['satisfaction']['send']='Forsinkelse af opfølgningsmail:';
$hesklang['satisfaction']['at_least']='Vent mindst';
$hesklang['satisfaction']['after']='efter at sagen er løst før afsendelse af e-mail';
$hesklang['satisfaction']['h1']='Hvordan bruger man dette værktøj?';
$hesklang['satisfaction']['h2']='Opret først en kundetilfredshedsundersøgelse i dit foretrukne undersøgelsesværktøj. Hvis du er usikker på, hvilket værktøj du skal bruge, eller hvilke spørgsmål du skal stille, har vi en <a href="%s" target="_blank">guide tilgængelig her</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Når din undersøgelse er klar, aktiver opfølgende e-mails ved at bruge formularen nedenfor. Hesk behandler løste sager med mindst ét svar fra personalet én gang i timen og sender dit undersøgelseslink til dine kunder.';
$hesklang['satisfaction']['e_url']='Indtast en gyldig undersøgelses-URL-adresse. Dette er den URL, dine kunder vil blive sendt til.';
$hesklang['satisfaction']['as']='Indtast en gyldig undersøgelses-URL-adresse. Dette er den URL, dine kunder vil blive sendt til.';
$hesklang['satisfaction']['oo1']='Denne side viser e-mailadresser, som opfølgende e-mails <b>ikke</b> bliver sendt til.';
$hesklang['satisfaction']['oo2']='Dine kunder kan fravælge at modtage undersøgelses-e-mails ved at klikke på et link i e-mailen. Alternativt kan du manuelt tilføje e-mail adresser på denne side.';
$hesklang['satisfaction']['ooe']='e-mail adresse for at fravælge';
$hesklang['satisfaction']['ooe2']='Indtast den e-mailadresse, du ønsker at fravælge at modtage undersøgelses-e-mails.';
$hesklang['satisfaction']['ooe3']='Denne e-mailadresse <i>%s</i> er allerede fravalgt at modtage undersøgelses-e-mails.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Fravælg denne e-mail';
$hesklang['satisfaction']['oob']='Fravalgt af';
$hesklang['satisfaction']['no_oo']='Ingen kunde har fravalgt at modtage undersøgelses-e-mails.';
$hesklang['satisfaction']['oor']='Fjern';
$hesklang['satisfaction']['oor2']='E-mail fjernet fra opt-out';
$hesklang['satisfaction']['oor3']='Bekræft fjernelse';
$hesklang['satisfaction']['oor4']='Når den fjernes fra opt-out, vil denne bruger igen modtage opfølgende e-mails.';
$hesklang['satisfaction']['optedout']='E-mailadressen <i>%s</i> blev fravalgt at modtage undersøgelses-e-mails.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Manglende eller ugyldigt undersøgelses-ID';
$hesklang['satisfaction']['starting']='Starter notifikationsproces for kundetilfredshedsundersøgelse';
$hesklang['satisfaction']['tc']='Fundet %s lukkede sager, der ikke havde tilsendt tilfredshedsundersøgelse.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Afsluttet kundetilfredshedsundersøgelse. Sendte e-mails: %1$s. E-mails kunne ikke sendes: %2$s. sager uden e-mail: %3$s. sager med fravalgs-e-mail: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignorerer, denne kunde ønsker ikke at modtage undersøgelses e-mails.';
$hesklang['satisfaction']['ne']='Ignorerer, denne sag er uden e-mail adresse';
$hesklang['satisfaction']['feat1']='Opret din undersøgelse ved hjælp af ethvert tredjepartsværktøj, såsom Google Forms';
$hesklang['satisfaction']['feat2']='Opsæt din undersøgelses-URL, præferencer og begrænsninger i dette modul';
$hesklang['satisfaction']['feat3']='Når du løser en sag, vil Hesk e-maile din kunde med linket til undersøgelsen';
$hesklang['dfor']='Datoformat';
$hesklang['dtfor']='Dato og tid';
$hesklang['cdfor']='Dato vælg format';
$hesklang['custom']='Brugerdefineret';
$hesklang['jsc_notice']='Datovalget understøtter ikke PHP-stil datoformatering. Vælg en af de forudkonfigurerede muligheder, eller klik på %s-ikonet nedenfor for at se tilgængelige visningsmuligheder.'; // %s = replaced by icon
$hesklang['lcf3']='Kun dato'; // Display: "Date only"
$hesklang['epdd']='Fejl ved parsing af due_date parameter:';
$hesklang['edit_pass']='Rediger adgangskode';
$hesklang['save_pass']='Gem adgangskode';
$hesklang['cur_pass']='Nuværende adgangskode';
$hesklang['cur_pass2']='Du skal angive din nuværende adgangskode for at ændre den.';
$hesklang['cur_pass3']='Efter en vellykket adgangskodeopdatering, vil du blive omdirigeret til login-siden, hvor du kan logge ind med dit nye kodeord.';
$hesklang['e_new_pass']='Indtast venligst din nye adgangskode';
$hesklang['pass_len']='Adgangskoden må ikke overstige 64 tegn';
$hesklang['pass_login']='Log venligst ind igen efter at have ændret din adgangskode';
$hesklang['bf_int']='Du er blevet logget ud på grund af for mange mislykkede bekræftelsesforsøg';
$hesklang['tst_cnt']='Antal e-mails din mailserver vil sende til Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='Du har mange ulæste e-mails i din postkasse (%1$s). Hesk vil forvandle alle disse e-mails til sager.<br><br>Du vil måske markere eksisterende e-mails som læst, før du aktiverer %2$s eller bruge en ny e-mail konto til Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Du har mange e-mails i din postkasse (%1$s). Hesk vil forvandle alle disse e-mails til sager.<br><br>Du ønsker måske at slette eksisterende e-mails, før du aktiverer %2$s eller bruge en ny e-mail konto til Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Forfaller den'; // Due on (date)
$hesklang['search_due_date_range']='Forfalder inden'; // Due in (X days)
$hesklang['attachment_add_files']='Tilføj fil';
$hesklang['attachment_max_exceeded']='Denne fil vil ikke blive uploadet, fordi du allerede har uploadet det maksimale antal tilladte filer.';
$hesklang['attachment_viewer_message']='Træk filer hertil eller klik på knappen \'Tilføj fil\' nedenfor for at vælge filer, der skal uploades.';
$hesklang['attachment_invalid_type_message']='Beklager, men den filtype du forsøgte at uploade er ikke tilladt.';
$hesklang['attachment_upload_error']='Der opstod en fejl under forsøg på at uploade. Prøv igen senere.';
$hesklang['attachment_too_large']='Denne vedhæftede fil er større end den tilladte maksimale filstørrelse.';
$hesklang['attachment_cancel']='Annuller';
$hesklang['attachment_confirm_cancel']='Er du sikker på, at du vil annullere denne upload?';
$hesklang['attachment_remove']='Fjern vedhæftet fil';
$hesklang['attachment_too_many_uploads']='For mange vedhæftede filer er blevet uploadet fra din placering i løbet af kort tid. Prøv venligst din anmodning igen senere.';
$hesklang['sub_note']='Send note';
$hesklang['can_view_users']='Se alle brugere (men ikke administrer dem)';
$hesklang['welcome1']='Hej, du ser ud til at være ny her. Velkommen!';
$hesklang['welcome2']='For at hjælpe dig i gang, Kontroller %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hurtig online hurtigstartguide';
$hesklang['tmce1']='Brug Ctrl+Højreklik for at få adgang til stavekontrol';
$hesklang['tmce2']='Hold kontroltasten (Ctrl) nede og højreklik på det forkert stavede ord for at få adgang til stavekontrollen.';
$hesklang['desc_new_ticket_by_staff']='(Kunde) Ny personale-indsendt sag';
$hesklang['mod_et_h']='Du kan ændre e-mail skabeloner under %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Sæt sprog til';
$hesklang['ouwa']='Kun brugere med adgang til denne kategori er anført nedenfor. For at tilføje medarbejdere til denne kategori, rediger deres tilladelser på %s siden'; // %s = Team
$hesklang['previous_tickets']='Tidligere sager';
$hesklang['no_previous']='Ingen tidligere sager fra %s'; // %s = email address
$hesklang['all_previous']='Vis alle tidligere sager';
$hesklang['confirm_delete_ticket']='Er du sikker på, at du vil slette denne sag permanent?';
$hesklang['confirm_delete_reply']='Er du sikker på, at du vil slette dette svar permanent?';
$hesklang['select_new_category']='Antal sager i denne kategori: %s<br><br>Vælg venligst en ny kategori for at overføre disse sager til:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Antal sager tildelt denne bruger: %1$s<br>Antal <b>åbne</b> sager tildelt denne bruger: %2$s<br><br> <b>Åbne</b> sager bliver <b>fjernet tildelt</b> efter sletning af denne bruger.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK-licens';
$hesklang['hlic_free']='GRATIS';
$hesklang['hlic_buyl']='Køb en licens';
$hesklang['hlic_paid']='Licenseret';
$hesklang['antdemo']='Afsendelse af sager fra administrationspanelet er blevet deaktiveret i demo-tilstand.<br><br>Brug venligst den <a href="%s" target="_blank">offentlige side</a> a> at indsende en sag.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Godkendelsesmetode';
$hesklang['email_authentication_method_username_password']='Grundlæggende (brugernavn/adgangskode)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Ingen bekræftede OAuth-udbydere konfigureret.';
$hesklang['email_authentication_method_oauth_link']='Administrer OAuth-udbydere'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Authorization Endpoint URL';
$hesklang['email_oauth_token_url']='Token Endpoint URL';
$hesklang['email_oauth_client_id']='Kunde-ID';
$hesklang['email_oauth_client_secret']='Kundens hemmelighed';
$hesklang['email_oauth_scope']='Omfang';
$hesklang['oauth_error_invalid_state']='OAuth-tilstand stemmer ikke overens med tilstanden sendt til OAuth-udbyderen.';
$hesklang['oauth_error_unknown']='Der opstod en ukendt fejl under forsøg på at gemme OAuth-tokens.';
$hesklang['oauth_error_no_token']='Adgangstoken mangler i JSON-svaret.';
$hesklang['oauth_error_retrieve']='Kan ikke hente et adgangstoken. Bekræft venligst dine OAuth-udbyderindstillinger og gem dem igen for at anskaffe et nyt token.';
$hesklang['email_oauth_provider']='OAuth-udbyder';
$hesklang['email_oauth_providers']='OAuth-udbydere';
$hesklang['email_oauth_provider_guide']='Før du bruger OAuth, skal du registrere en OAuth-udbyder. For detaljer, se venligst <a href="%s" target="_blank">denne vidensbasevejledning</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Din OAuth-omdirigerings-URI til Hesk er:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Brug dette værktøj til at tilføje OAuth-udbydere til din helpdesk';
$hesklang['email_oauth_provider_name']='Navn'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Ny udbyder';
$hesklang['email_oauth_edit_provider']='Rediger udbyder';
$hesklang['email_oauth_provider_being_used_for']='Bliver brugt til';
$hesklang['email_oauth_providers_none']='Ingen OAuth-udbydere gemt. Du kan tilføje dem ved at klikke på "Ny udbyder" ovenfor.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Denne udbyder kan ikke fjernes, fordi den bliver brugt af helpdesken.';
$hesklang['email_oauth_confirm_delete_provider']='Er du sikker på, at du vil slette denne OAuth-udbyder?';
$hesklang['oauth_provider_saved']='OAuth-udbyder er blevet gemt';
$hesklang['oauth_provider_use']='Du kan nu vælge denne udbyder i %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Indtast udbyderens navn';
$hesklang['oauth_provider_err_auth_url']='Indtast en gyldig autorisations-URL';
$hesklang['oauth_provider_err_token_url']='Indtast en gyldig token URL';
$hesklang['oauth_provider_err_client_id']='Indtast klient-ID';
$hesklang['oauth_provider_err_client_secret']='Indtast klienthemmeligheden';
$hesklang['oauth_provider_err_scope']='Indtast omfanget';
$hesklang['oauth_provider_deleted']='OAuth-udbyder slettet';
$hesklang['oauth_provider_not_found']='Denne OAuth-udbyder findes ikke';
$hesklang['oauth_provider_verified']='Bekræftet';
$hesklang['oauth_provider_click_to_verify']='Klik for at bekræfte';
$hesklang['can_due_date']='Kan indstille forfaldsdato'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Du har ikke tilladelse til at angive forfaldsdatoer';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Bekræft Din Registrering';
$hesklang['customer_verify_new_email']='Bekræft Din Nye Email Adresse';
$hesklang['customer_reset_password']='Nulstil dit helpdesk kodeord';
$hesklang['customer_approved']='Konto Godkendt';
$hesklang['customer_rejected']='Konto Afvist';
$hesklang['email_rejected']='Konto krævet for at indsende supporthenvendelser';
$hesklang['require_curl']='Denne funktionalitet kræver <strong>cURL</strong> support for PHP aktiveret på din server. Bed venligst din webudbyder om at aktivere cURL for PHP.';
$hesklang['customer_accounts_heading']='Kundekonti';
$hesklang['customer_accounts']='Kundekonti';
$hesklang['customer_accounts_off']='<strong>Deaktiveret</strong>';
$hesklang['customer_accounts_allowed']='<strong>Aktiveret - Valgfrit</strong> (kunder kan indsende supporthenvendelser uden at registrere sig eller logge ind)';
$hesklang['customer_accounts_required_to_submit']='<strong>Aktiveret - Påkrævet for henvendelser</strong> (kun indloggede kunder kan indsende supporthenvendelser)';
$hesklang['customer_accounts_required']='<strong>Aktiveret - Påkrævet for adgang</strong> (kun indloggede kunder kan få adgang til helpdesk og vidensbase)';
$hesklang['customer_accounts_reg']='Kontoregistrering';
$hesklang['customer_accounts_reg_customer']='Kunder kan registrere konti';
$hesklang['customer_accounts_reg_approve']='Kunder kan registrere konto, personale skal godkende nye registreringer';
$hesklang['customer_accounts_reg_staff']='Kun personale kan registrere kundekonti';
$hesklang['customer_accounts_allow_email_changes']='Tillad kunder at ændre deres emailadresse';
$hesklang['customer_accounts_allow_email_resends']='Tid indtil kunder kan anmode om ny bekræftelsesmail';
$hesklang['customer_login']='Log ind';
$hesklang['customer_logout']='Log ud';
$hesklang['customer_register']='Registrer';
$hesklang['customer_accounts_disabled']='Kundelogin og registreringer er deaktiveret.';
$hesklang['customer_accounts_registration_disabled']='Kunderegistreringer er deaktiveret.';
$hesklang['customer_forgot_password']='Glemt kodeord?';
$hesklang['customer_email']='Email Adresse';
$hesklang['customer_accounts_email_banned']='Du er blevet udelukket fra at bruge denne helpdesk.';
$hesklang['customer_registration_successful']='Registrering Gennemført!';
$hesklang['customer_registration_email_exists_no_reset_link']='En konto med email %s eksisterer allerede.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='En konto med email %s eksisterer allerede. <a href="login.php">Ønsker du at logge ind i stedet</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='En konto med email %s eksisterer allerede og afventer emailbekræftelse.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='En konto med email %s eksisterer allerede og afventer personalegodkendelse.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Tjek Din Email!';
$hesklang['customer_registration_check_your_email_content']='Du skal bekræfte din emailadresse før du kan logge ind.<br><br>Hvis du ikke modtager den inden for få minutter, bedes du tjekke dine Junk-, Bulk- eller Spam-mapper. Markér beskeden som <b>Ikke SPAM</b> for at undgå problemer med at modtage vores korrespondance i fremtiden.';
$hesklang['customer_login_not_verified']='Du skal bekræfte din emailadresse før du kan logge ind.';
$hesklang['customer_login_not_verified2']='Hvis du ikke har modtaget bekræftelsesmailen fra os, bedes du tjekke dine Junk-, Bulk- eller Spam-mapper. Markér beskeden som <b>Ikke SPAM</b> for at undgå problemer med at modtage vores korrespondance i fremtiden.';
$hesklang['customer_login_resend_verification_email']='Send bekræftelsesmail igen';
$hesklang['customer_login_resend_verification_email_none']='Der er ingen ventende emailbekræftelser at sende.';
$hesklang['customer_login_resend_verification_email_too_early']='Du kan ikke anmode om en ny bekræftelsesmail på nuværende tidspunkt, prøv venligst igen senere.';
$hesklang['customer_login_not_approved']='En medarbejder skal godkende din konto før du kan logge ind. Når den er godkendt, vil du blive underrettet via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Bekræft Registrering';
$hesklang['customer_registration_verify_success']='Din email er blevet bekræftet, og du kan nu logge ind ved hjælp af formularen nedenfor.';
$hesklang['customer_registration_verify_approval_needed']='Din email er blevet bekræftet. Dog skal en medarbejder godkende din konto, før du kan logge ind. Når den er godkendt, vil du blive underrettet via email.';
$hesklang['customer_registration_verify_failure']='Din email kunne ikke bekræftes. Enten er linket allerede blevet brugt eller er udløbet.';
$hesklang['emails_to_customers']='&raquo; Emails sendt til kunder';
$hesklang['emails_to_staff']='&raquo; Emails sendt til personale';
$hesklang['emails_to_everyone']='&raquo; Emails sendt til personale eller kunder';
$hesklang['new_customer_approval']='Du har kundekonti der afventer godkendelse'; // Email subject
$hesklang['desc_new_customer_approval']='(Personale) Kundekonti der afventer godkendelse';
$hesklang['n_cust_app']='Der er ventende kundegodkendelser'; // Notify me when...
$hesklang['et_num_customers']='Antal ventende godkendelser';
$hesklang['et_link_customers']='Link til Administrer kunder-siden';
$hesklang['et_link_verify']='Bekræftelseslink';
$hesklang['et_cust_login']='Kunde login URL';
$hesklang['submit_ticket_customer_email_exists']='En kunde med denne email eksisterer allerede. Venligst <a href="login.php?email=%s">log ind</a> for at indsende en henvendelse.'; // %s - User's email
$hesklang['customer_login_email_required']='Indtast venligst en gyldig emailadresse.';
$hesklang['customer_login_password_required']='Indtast venligst dit kodeord.';
$hesklang['customer_login_remember_just_email']='Husk kun min email';
$hesklang['customer_login_remember_email']='Husk min email';
$hesklang['customer_wrong_user']='Din emailadresse %s er ikke registreret hos os.<br><br>Ønsker du at <a href="register.php">oprette en konto</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Din emailadresse og kodeord matcher ikke vores optegnelser.<br><br>Ønsker du at <a href="login.php?submittedForgot=1">nulstille dit kodeord</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Log venligst ind for at fortsætte.';
$hesklang['customer_register_here']='Hvis du ikke har en konto hos os, kan du <a href="register.php">registrere dig her</a>.';
$hesklang['create_account']='Opret en konto';
$hesklang['customer_my_tickets_heading']='Mine henvendelser';
$hesklang['customer_my_tickets_description']='Se alle dine tidligere henvendelser';
$hesklang['customer_my_tickets_search_for_tickets']='Søg efter henvendelser';
$hesklang['customer_password_reset_successful']='Dit nye kodeord er blevet gemt. Du kan nu logge ind.';
$hesklang['customer_profile']='Profil';
$hesklang['customer_edit_profile']='Rediger Profil';
$hesklang['customer_edit_pass']='Rediger Kodeord';
$hesklang['customer_edit_pass_same']='Dit nye kodeord må ikke være det samme som dit nuværende.';
$hesklang['customer_change_email']='Skift Email';
$hesklang['customer_change_email_banned']='Den indtastede email er udelukket.';
$hesklang['customer_change_email_pending']='Der er en aktuel anmodning om at ændre din emailadresse til: <b>%s</b><br><br>Vi har sendt en email til denne adresse. Klik venligst på linket i emailen for at bekræfte ændringen.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Send bekræftelsesmail igen</a>';
$hesklang['customer_change_email_submitted']='Klik venligst på bekræftelseslinket der blev sendt til <b>%s</b> for at bekræfte din nye email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Din nye emailadresse er blevet bekræftet og din profil opdateret.';
$hesklang['customer_change_email_disabled']='Muligheden for at opdatere din email er deaktiveret. Kontakt os hvis du ønsker at ændre din emailadresse.';
$hesklang['customer_profile_saved']='Din profil er blevet gemt.';
$hesklang['customers']='Kunder';
$hesklang['customers_intro']='Kundekonti giver kunder mulighed for at se alle deres henvendelser på ét centralt sted.';
$hesklang['sure_remove_customer']='Er du sikker på, at du vil fjerne denne kunde?';
$hesklang['sure_remove_customer_additional_note']='Sletning af en kunde er endelig. Når den er slettet, kan den ikke gendannes!';
$hesklang['new_customer']='Ny Kunde';
$hesklang['new_follower']='Ny Følger';
$hesklang['add_customer']='+ Tilføj Kunde'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Tilføj Følger'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='Den angivne kunde eksisterer ikke endnu. Klik "Gem" hvis du ønsker at oprette denne kunde.';
$hesklang['followers']='Følgere';
$hesklang['no_customers']='Der er i øjeblikket ingen kunder i databasen.';
$hesklang['no_customers_disabled']='Du vil begynde at se kunder her, når de indsender supporthenvendelser.';
$hesklang['no_customers_enabled']='Du vil begynde at se kunder her, når de registrerer sig eller indsender supporthenvendelser.';
$hesklang['no_customers_enabled2']='Alternativt giver knapperne over denne besked dig mulighed for manuelt at oprette kundekonti eller importere eksisterende kunder til helpdesken.';
$hesklang['import_customers']='Importér Kunder';
$hesklang['import_customers_tip']='Brug en CSV-fil til at importere flere kunder på én gang.';
$hesklang['customer_not_found']='Kunde ikke fundet for henvendelsen!';
$hesklang['search_by_name_or_email']='Søg efter navn eller email...';
$hesklang['search_by_pattern']='Søg efter mønster...';
$hesklang['is_searchable']='Søgbar';
$hesklang['custom_is_searchable']='Søgbar';
$hesklang['yes_via_autocomplete']='JA (søg via autofuldførelse)';
$hesklang['customer_required']='Du skal vælge en kunde';
$hesklang['customer_email_exists']='En kunde med denne email eksisterer allerede.';
$hesklang['customer_name_with_no_email_exists']='En kunde med dette navn og ingen email eksisterer allerede.';
$hesklang['an_error_occurred_validating_email']='Der opstod en fejl ved forsøg på at bekræfte den indtastede emailadresse.';
$hesklang['customer_count_x_more']='+%s flere'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registreret';
$hesklang['customer_account_verified']='Bekræftet';
$hesklang['customer_account_verified_help']='Kunder skal bekræfte deres konto via et aktiveringslink sendt til deres emailadresse, før de kan logge ind på deres konto.';
$hesklang['customer_account_setting_password_will_verify_user']='Indstilling af et kodeord for denne kunde vil automatisk bekræfte deres konto.';
$hesklang['deleting_customer_with_tickets']='Denne kunde har %1$s henvendelse(r) <b>(%2$s åbne)</b> som også har andre kunder tilknyttet.<br>Hvad skal der gøres med disse henvendelser?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='En gyldig emailadresse er nødvendig for at gensende en bekræftelsesmail.';
$hesklang['customer_resend_verification_email_not_found']='Ingen konto eksisterer med denne emailadresse, eller kontoen er allerede blevet bekræftet.';
$hesklang['customer_resend_verification_email_sent']='En bekræftelsesmail er blevet sendt til din emailadresse.<br><br>Hvis du ikke modtager den inden for få minutter, bedes du tjekke dine Junk-, Bulk- eller Spam-mapper. Markér beskeden som <b>Ikke SPAM</b> for at undgå problemer med at modtage vores korrespondance i fremtiden.';
$hesklang['customer_permission_denied']='Du har ikke tilladelse til at ændre kunder.';
$hesklang['customer_manage_approvals']='Kundekonti der afventer godkendelse: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Godkend kunde';
$hesklang['customer_manage_bulk_approve']='Godkend Valgte Kunder';
$hesklang['customer_manage_bulk_approve_complete']='Kunder godkendt: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Afvis kunde';
$hesklang['customer_manage_bulk_reject']='Afvis Valgte Kunder';
$hesklang['customer_manage_bulk_reject_complete']='Kunder afvist: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Slet kunde';
$hesklang['customer_manage_bulk_delete']='Slet Valgte Kunder';
$hesklang['customer_manage_bulk_delete_complete']='Kunder slettet: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Rediger kunde';
$hesklang['customer_manage_verification_email_sent']='Bekræftelsesmail er blevet sendt til %s'; // %s = customer's email
$hesklang['can_man_customers']='Administrer kunder';
$hesklang['can_view_customers']='Se alle kunder (men ikke administrer dem)';
$hesklang['import_customer_select_file']='Vælg Fil';
$hesklang['import_customer_step1_instructions']='For at importere kunder, forbered en CSV-fil (Kommaseparerede værdier).';
$hesklang['import_customer_step1_note']='Vælg Din CSV-fil';
$hesklang['import_customer_step1_separator']='Kolonner i min CSV-fil er adskilt af';
$hesklang['import_customer_sample']='&raquo; Eksempel CSV-filer';
$hesklang['import_customer_sample_1']='US-stil CSV-fil med kolonner adskilt af ,';
$hesklang['import_customer_sample_2']='EU-stil CSV-fil med kolonner adskilt af ;';
$hesklang['import_customer_upload_requirements_1']='Din CSV-fil skal indeholde mindst et navn eller en emailadresse kolonne. Kodeordskolonnen er valgfri.';
$hesklang['import_customer_upload_requirements_2']='Den første række i din fil skal indeholde kolonneoverskrifter.';
$hesklang['import_customer_upload_requirements_3']='Din fil skal være kodet i UTF-8.';
$hesklang['import_customer_select_columns']='Vælg Kolonner';
$hesklang['import_customer_upload_customers']='Upload Kunder';
$hesklang['import_customer_column_name']='Navnekolonne';
$hesklang['import_customer_column_email']='Emailkolonne';
$hesklang['import_customer_column_pass']='Kodeordskolonne';
$hesklang['import_customer_step2_note']='Vælg det korrekte kolonnenavn fra din CSV-fil i rullemenuerne, og klik derefter på "Næste".';
$hesklang['import_customer_name_or_email_required']='Navn eller email er påkrævet';
$hesklang['import_customer_step3_note']='Dine kunder bliver importeret. Forlad ikke denne side!';
$hesklang['import_customer_step3_pending']='Afventer';
$hesklang['import_customer_step3_successful_imports']='Vellykkede Importer';
$hesklang['import_customer_step3_failed_imports']='Mislykkede Importer';
$hesklang['import_customer_step3_progress']='Fremskridt';
$hesklang['import_customer_step3_complete_some_failed']='Importprocessen er færdig, men <b>%s</b> kunder kunne ikke importeres. Tjek tabellen nedenfor for mere information.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='Importprocessen er færdig!';
$hesklang['import_customer_step3_importing']='Importerer';
$hesklang['staff_deleted']='[Personale Slettet]';
$hesklang['customer_account_approved']='Kunderegistrering godkendt';
$hesklang['customer_account_rejected']='Kunderegistrering afvist';
$hesklang['customer_account_deleted']='Kunderegistrering slettet';
$hesklang['ticket_followers']='Henvendelsens følgere';
$hesklang['ticket_followers2']='Tillad henvendelser at have flere kunder';
$hesklang['add_cc']='Tilføj Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Adskil hver email med et komma.';
$hesklang['search_customers']='Søg Kunder';
$hesklang['page_size']='Sidestørrelse';
$hesklang['customers_on_pages']='Antal kunder: %d | Antal sider: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Kunde) Nulstil dit kodeord';
$hesklang['desc_customer_verify_registration']='(Kunde) Bekræft din registrering';
$hesklang['desc_customer_verify_new_email']='(Kunde) Bekræft din nye e-mail';
$hesklang['desc_customer_approved']='(Kunde) Konto godkendt';
$hesklang['desc_customer_rejected']='(Kunde) Konto afvist';
$hesklang['desc_email_rejected_can_self_register']='(Kunde) Henvendelse via email afvist; kunde kan selv-registrere';
$hesklang['desc_email_rejected_cannot_self_register']='(Kunde) Henvendelse via email afvist; kunde kan ikke selv-registrere';
$hesklang['user_added_success_no_pass']='Ny bruger %s er blevet tilføjet med succes';
$hesklang['email_tag_requester']='Anmoder (Fra)';
$hesklang['email_tag_requester_name']='Anmoder (Fra) Navn';
$hesklang['email_tag_requester_first_name']='Anmoder (Fra) Fornavn';
$hesklang['email_tag_requester_email']='Anmoder (Fra) Email';
$hesklang['email_tag_followers']='Følgere (Cc)';
$hesklang['email_tag_follower_names']='Følger (Cc) Navne';
$hesklang['email_tag_follower_emails']='Følger (Cc) Emails';
$hesklang['barcode']='Stregkode';
$hesklang['barcode_use']='Vis en stregkode på udskrevne henvendelser';
$hesklang['barcode_staff_only']='Skjul stregkoden for kunder';
$hesklang['barcode_type']='Stregkodetype';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Bredde';
$hesklang['barcode_height']='Højde';
$hesklang['barcode_color']='Farve';
$hesklang['barcode_bg']='Baggrund';
$hesklang['copy_link']='Kopiér henvendelseslink';
$hesklang['copy_link_title']='Kopiér offentligt link til denne henvendelse';
$hesklang['copy_link_exp']='Det kopierede link er det direkte link for kunden til at se denne henvendelse';
$hesklang['copy_value']='Kopiér denne værdi';
$hesklang['download_class']='Denne funktion kræver ZipArchive klassen. Bed din vært om at kompilere PHP med zip-understøttelse.';
$hesklang['download_all']='Download alle';
$hesklang['download_prep']='Forbereder download...';
$hesklang['download_tma']='For mange vedhæftninger';
$hesklang['download_nva']='Ingen gyldige vedhæftninger';
$hesklang['download_ntd']='Intet at downloade';
$hesklang['resolved_at']='Løst den';
$hesklang['disable_GSSAPI']='Deaktiver GSSAPI-godkender (Kerberos fejl work-around)';
$hesklang['ex_history']='Inkluder henvendelseshistorik i eksport';
$hesklang['sm_location']='Placering'; // Location (page) of a service message
$hesklang['loc_sm']='Vis denne servicemeddelelse på:';
$hesklang['loc_all']='Hver kundeside';
$hesklang['loc_norec']='(anbefales ikke)';
$hesklang['loc_home']='Helpdesk hjemmeside';
$hesklang['loc_selected']='På valgte sider';
$hesklang['loc_selerr']='Vælg mindst én side at vise meddelelsen på';
$hesklang['loc_t_cat']='Indsend en henvendelse - vælg en kategori';
$hesklang['loc_t_add']='Indsend en henvendelse - indsend henvendelsesformular';
$hesklang['loc_t_ok']='Indsend en henvendelse - henvendelse bekræftet';
$hesklang['loc_t_view']='Se en henvendelse';
$hesklang['loc_t_form']='Se en henvendelsesformular';
$hesklang['loc_kb_main']='Vidensbase hjemmeside';
$hesklang['loc_kb_sub']='Vidensbase underkategori sider';
$hesklang['loc_kb_art']='Vidensbase artikler';
$hesklang['loc_login']='Kunde login side';
$hesklang['loc_register']='Kunde registreringsside';
$hesklang['loc_register_ok']='Kunde registrering gennemført';
$hesklang['loc_acc']='Kunde "Mine henvendelser" side';
$hesklang['loc_profile']='Kunde "Profil" side';
$hesklang['sending_show']='Vis "Indsender" notifikation';
$hesklang['sending_wait']='Indsender, vent venligst...';
$hesklang['e_c_email']='Indtast den korrekte emailadresse for at se denne henvendelse';
$hesklang['only_verified_cc']='Følgere uden en bekræftet konto vil blive ignoreret.';
$hesklang['followers_removed']='Disse emailadresser er blevet fjernet fra henvendelsen, fordi de ikke har en bekræftet konto:';
$hesklang['novace']='Vi fandt ingen registrerede og bekræftede konti med denne emailadresse.';
$hesklang['max_recipients']='Maks modtagere';
$hesklang['max_recipients2']='i en enkelt email';
$hesklang['admin_js']='Administrator JS';
$hesklang['admin_js2']='Indlæs en ekstra tilpasset Javascript-fil til adminpanelet';
$hesklang['cf_limit_all']='Du har nået grænsen for tilpassede felter og kan ikke oprette nye tilpassede felter.';
$hesklang['remind_assigned']='Påmind tildelt personale';
$hesklang['remind_sent']='Email-påmindelse til det tildelte personalemedlem sendt';
$hesklang['thist23']='<li class="smaller">%s | påmindelse sendt til %s af %s</li>';
$hesklang['ql_bookmarks']='Bogmærker';
$hesklang['bookmark']='Mit Bogmærke';
$hesklang['bookmarks_add']='Tilføj til Bogmærker';
$hesklang['bookmarks_added']='Denne henvendelse er blevet tilføjet til dine Bogmærker';
$hesklang['bookmarks_remove']='Fjern fra Bogmærker';
$hesklang['bookmarks_removed']='Denne henvendelse er blevet fjernet fra dine Bogmærker';
$hesklang['genl_not_copied']='Fejl: Kopiering til udklipsholder understøttes ikke på denne enhed/browser.';
$hesklang['profile_duplicate_email']='Bruger med email <b>%s</b> eksisterer allerede.'; // %s: new email
$hesklang['seq_id_numeric']='Henvendelsesnummersøgning må kun indeholde tal';
$hesklang['confirm_new_pass']='Bekræft nyt kodeord';
$hesklang['piping_notify_rejected_customers1']='Kunde afvisnings-emails';
$hesklang['piping_notify_rejected_customers2']='Send en afvisningsmail til kunder når deres henvendelse afvises';
$hesklang['piping_notify_rejected_customers3']='Tid mellem afvisningsmails';
$hesklang['register_url']='Registrerings-URL';
$hesklang['email_subject']='Email emne';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Deltager på sag: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Support svarede på: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note tilføjet til: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Sag forfalden: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Sag løst: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Skæringsdato for opfølgningsmail:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Send ikke mails til sager der er løst for mere end'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='siden (skal være en længere periode end "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='Perioden for skæringsdatoen skal være længere end forsinkelsen for opfølgningsmail';
$hesklang['available_language']='Tilgængelige sprog';
$hesklang['click_to_show_available_language']='Klik for at vise tilgængelige sprog';
$hesklang['install_lan']='Installer';
$hesklang['remove_lan']='Fjern';
$hesklang['title_lan']='Titel';
$hesklang['description_lan']='Beskrivelse';
$hesklang['completed_lan']='Fuldført';
$hesklang['no_language_availble']='Ingen sprog er tilgængelige';
$hesklang['success_install_lan_txt']='sprog er blevet tilføjet';
$hesklang['error_install_lan_txt']='sprog er ikke blevet tilføjet';
$hesklang['success_remove_lan_txt']='sprog er blevet fjernet';
$hesklang['error_remove_lan_txt']='sprog er ikke blevet fjernet';
$hesklang['remove_default_language_error']='Standardsproget skal forblive aktivt og kan ikke fjernes';
$hesklang['click_for_manual_step']='Klik for manuel installation';
$hesklang['upgrade_lan']='Opdater';
$hesklang['success_upgrade_lan_txt']='sprog er blevet opdateret';
$hesklang['error_upgrade_lan_txt']='sprog er ikke blevet opdateret';
$hesklang['please_wait']='Vent venligst...';
$hesklang['add_a_note']='Tilføj en note';
$hesklang['add_a_reply']='Tilføj et svar';
$hesklang['customer_id']='Kunde-ID';
$hesklang['deleting_customer_tickets']='Sager oprettet af kunden: <b>%1$s</b><br>Hvad skal vi gøre med disse sager?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Sager hvor kunden er kopieret: <b>%1$s</b><br>Disse mister kunden som følger; sagerne forbliver uændrede.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Slet sager permanent';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymisér sager (fjern beskeder og persondata)';
$hesklang['deleting_customer_retain_tickets2']='Behold sager (lad alle data forblive intakte)';
$hesklang['for_staff']='for helpdesk‑personale'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='for kunder'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP-postkasse';
$hesklang['file_attachment_options']='Indstillinger for mailvedhæftninger';
$hesklang['link_to_attachments_in_emails']='Link til vedhæftninger i e-mails';
$hesklang['add_attachments_directly_to_emails']='Vedhæft filer direkte i e-mails';
$hesklang['directly_attach_file_smaller_than']='Vedhæft kun filer direkte, der er mindre end';
$hesklang['directly_attach_file_of_any_size']='Vedhæft filer direkte uanset størrelse';
$hesklang['directly_attach_only_first_x_attachments']='Vedhæft kun de første';
$hesklang['directly_attach_all_attachments']='Vedhæft alle filer direkte';
$hesklang['directly_attach_size']='Vedhæftningsstørrelse';
$hesklang['directly_attach_no_of_files']='Antal filer';
$hesklang['notice_about_directly_attach_files']='Vedhæftning af mange eller store filer kan give forsinkelser ved kommunikation med din SMTP-server';
$hesklang['fatt_2']='Yderligere filer vedhæftet denne besked:';
$hesklang['no_collaborators']='Ingen';
$hesklang['collaborate']='Deltag i denne sag';
$hesklang['collaborators']='Deltagere';
$hesklang['ql_cbm']='Deltagere';
$hesklang['collaborating']='Du deltager nu i denne sag';
$hesklang['not_collaborating']='Du deltager ikke længere i denne sag';
$hesklang['add_collaborator']='Tilføj en deltager';
$hesklang['user_collaborator_added']='Bruger tilføjet som deltager på denne sag';
$hesklang['remove_collaborator']='Fjern deltager';
$hesklang['staff_name']='Medarbejdernavn';
$hesklang['user_collaborator_removed']='Bruger fjernet som deltager på denne sag';
$hesklang['desc_collaborator_added']='(Personale) Du deltager på en ny sag';
$hesklang['desc_collaborator_staff_reply']='(Personale) En medarbejder har svaret på en fælles sag';
$hesklang['desc_collaborator_note']='(Personale) Ny note tilføjet til en fælles sag';
$hesklang['desc_collaborator_resolved']='(Personale) En fælles sag er blevet løst';
$hesklang['desc_collaborator_overdue']='(Personale) En fælles sag er forfalden';
$hesklang['notify_collaborator_added']='Jeg er tilføjet som deltager på en sag';
$hesklang['notify_collaborator_customer_reply']='Kunde svarer på en fælles sag';
$hesklang['notify_collaborator_staff_reply']='Personale svarer på en fælles sag';
$hesklang['notify_collaborator_note']='Personale tilføjer en note til en fælles sag';
$hesklang['notify_collaborator_resolved']='Personale løser en fælles sag';
$hesklang['notify_collaborator_overdue']='Deltagersag er forfalden';
$hesklang['recurring_tickets']['tab']='Tilbagevendende sager'; // Menu link
$hesklang['recurring_tickets']['page_title']='Tilbagevendende sager'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatisér rutinearbejdet; lad Hesk oprette standardsager for dig præcis, når du har brug for dem.';
$hesklang['recurring_tickets']['active_rules']='Aktive regler';
$hesklang['recurring_tickets']['new']='Ny tilbagevendende sagsregel';
$hesklang['recurring_tickets']['no_rules']='Du har ingen regler for tilbagevendende sager. Opret en ved at klikke på knappen &quot;Ny tilbagevendende sagsregel&quot; ovenfor.';
$hesklang['recurring_tickets']['title']='Regeltitel';
$hesklang['recurring_tickets']['titlet']='En beskrivende titel, fx: Tildel sager på ny, som ikke er besvaret inden for en dag';
$hesklang['recurring_tickets']['default_title']='Regel af %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Regeltrigger';
$hesklang['recurring_tickets']['trigt']='Angiv betingelsen, der udløser (kører) denne regel.';
$hesklang['recurring_tickets']['hits']='Træffere'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Oprettelsestidspunkt'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Generelle indstillinger'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Brugerdefinerede felter'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Indhold'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Slet denne regel?';
$hesklang['recurring_tickets']['edit']='Rediger tilbagevendende sagsregel ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Inden for:';
$hesklang['recurring_tickets']['minutes']='minutter';
$hesklang['recurring_tickets']['hours']='timer';
$hesklang['recurring_tickets']['days']='dage';
$hesklang['recurring_tickets']['weeks']='uger';
$hesklang['recurring_tickets']['months']='måneder';
$hesklang['recurring_tickets']['years']='år';
$hesklang['recurring_tickets']['setpri']='Sæt prioritet til:';
$hesklang['recurring_tickets']['setsta']='Sæt status til:';
$hesklang['recurring_tickets']['assto']='Tildel sag til:';
$hesklang['recurring_tickets']['asm']='En anden medarbejder';
$hesklang['recurring_tickets']['notify']='Underret medarbejdere...';
$hesklang['recurring_tickets']['ato']='Gælder for:';
$hesklang['recurring_tickets']['save']='Gem regel';
$hesklang['recurring_tickets']['e_tt']='Tiden skal være mellem 1 og 10000';
$hesklang['recurring_tickets']['nocat']='Vælg mindst én kategori';
$hesklang['recurring_tickets']['nouser']='Vælg mindst én bruger';
$hesklang['recurring_tickets']['nostatus']='Vælg mindst én status';
$hesklang['recurring_tickets']['nocata']='%1$s har ikke adgang til disse kategorier:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Ny regel er oprettet';
$hesklang['recurring_tickets']['mdf']='Regelindstillingerne er gemt';
$hesklang['recurring_tickets']['e_id']='Ingen regel med dette ID fundet';
$hesklang['recurring_tickets']['deleted']='Valgt regel er blevet slettet';
$hesklang['recurring_tickets']['log_title']='Regel #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Aktiv'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Aktivér denne regel (tag den i brug)';
$hesklang['recurring_tickets']['activated']='Valgt regel er blevet aktiveret'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deaktivér denne regel (stop brugen)';
$hesklang['recurring_tickets']['deactivated']='Valgt regel er blevet deaktiveret'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Ingen aktive regler for tilbagevendende sager';
$hesklang['recurring_tickets']['tools']='Værktøjer';
$hesklang['recurring_tickets']['tbef']='Før en regel er aktiv, skal du aktivere den ved at klikke afkrydsningsfeltet i kolonnen &quot;AKTIV&quot;.<br><br>
                               <strong>Aktive regler behandles hver %2$s. minut.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[REGEL]';
$hesklang['recurring_tickets']['r2']='[REGEL] Regel #%s';
$hesklang['recurring_tickets']['r3']='Regel #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Antal sager allerede oprettet i dag: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Nulstil denne regel';
$hesklang['recurring_tickets']['reset2']='Er du sikker på, at du vil nulstille denne regel?<br><br>Regel-træffere sættes til 0 og sager, der allerede er genereret for den i dag, kan blive genskabt ved næste cron-kørsel.';
$hesklang['recurring_tickets']['reset3']='Valgt regel er blevet nulstillet';
$hesklang['recurring_tickets']['test']='Simulér denne regel';
$hesklang['recurring_tickets']['testa']='Simulér alle regler';
$hesklang['recurring_tickets']['testaa']='Simulér alle aktive regler';
$hesklang['recurring_tickets']['testr']='Simuleringsresultater';
$hesklang['recurring_tickets']['rsim']='Gentag simulering';
$hesklang['recurring_tickets']['sim']='SIMULERINGSTILSTAND, ingen ændringer i databasen';
$hesklang['recurring_tickets']['sic']='SIMULERING FÆRDIG';
$hesklang['recurring_tickets']['rrule_type_required']='Vælg en gyldig trigger for tilbagevendende regel.';
$hesklang['recurring_tickets']['rrule_string_required']='Vælg alle påkrævede indstillinger for tilbagevendende regel.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Angiv en intervalværdi på 1 eller større for "Hver".';
$hesklang['recurring_tickets']['disable_note']='*Hvis kritiske Hesk-indstillinger ændres efter oprettelse af en regel, vil den blive deaktiveret ved næste kørsel og skal redigeres for at opfylde nye valideringskrav.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | indsendt af Regel for tilbagevendende sager "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | tildelt til %2$s af Regel for tilbagevendende sager "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | lukket automatisk af Regel for tilbagevendende sager "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status ændret til %2$s af Regel for tilbagevendende sager "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatisk tildelt til %2$s af Regel for tilbagevendende sager "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Reglen blev deaktiveret pga. valideringsfejl. Se detaljer nedenfor.';
$hesklang['recurring_tickets']['errors_title']='En eller flere af dine regler gav fejl ved kørsel og blev deaktiveret.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Fejl for regel #%s:';
$hesklang['recurring_tickets']['create_customers']='Der findes ingen kunder – opret dem venligst <a href="%s" target="_blank">her</a>.';
$hesklang['recurring_tickets']['exec_dates']='Kørselsdatoer for regel';
$hesklang['recurring_tickets']['show_exec_dates']='[Vis aktuelle kørselsdatoer for regel]';
$hesklang['recurring_tickets']['no_exec_dates']='Vælg gyldige regeltriggere for at se kørselsdatoer.';
$hesklang['recurring_tickets']['invalid_disabled']='ugyldige Rrule-indstillinger – regel deaktiveret.';
$hesklang['recurring_tickets']['next_occ']='Næste %s regel-forekomster:';
$hesklang['recurring_tickets']['occ_on']='den %s';
$hesklang['recurring_tickets']['not_firing_today']='skal ikke udløses i dag.';
$hesklang['recurring_tickets']['rules_fulfilled']='tilbagevendende regler opfyldt – sag oprettet i dag!';
$hesklang['recurring_tickets']['validation_failed']='validering mislykkedes – regel deaktiveret. Detaljer nedenfor:';
$hesklang['recurring_tickets']['validation_error']='Valideringsfejl:';
$hesklang['recurring_tickets']['processed']='behandlet.';
$hesklang['recurring_tickets']['created_ticket']='oprettet sag id: %1$s, sporings-id: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relativt til sagens oprettelsesdato';
$hesklang['priorities']='Prioriteter';
$hesklang['priority_intro']='Brug dette værktøj til at administrere sagsprioriteter i din helpdesk';
$hesklang['new_priority']='Ny prioritet';
$hesklang['edit_priority']='Rediger prioritet';
$hesklang['priority_title']='Titel';
$hesklang['can_customers_select_it']='Kan kunder vælge denne prioritet?';
$hesklang['selected_by_customer']='Kan vælges af kunder';
$hesklang['err_priority']='Angiv prioritetens titel';
$hesklang['priority_added']='En ny prioritet er tilføjet';
$hesklang['priority_e_id']='Ugyldigt prioritet-ID';
$hesklang['priority_mdf']='Prioritet er gemt';
$hesklang['priority_deleted']='Prioritet slettet';
$hesklang['priority_not_found']='Denne prioritet findes ikke';
$hesklang['priority_not_empty']='Denne prioritet kan ikke slettes, fordi der findes sager med den';
$hesklang['click_to_enable_drag_drop']='Klik for at aktivere træk-og-slip for rækken, og træk derefter rækken op eller ned for at omarrangere prioriteter.';
$hesklang['confirm_delete_priority']='Er du sikker på, at du vil slette denne prioritet?';
$hesklang['reordered_message']='Rækkefølgen af prioriteter er gemt.';
$hesklang['list_tkt_priority']='Vis alle sager med denne prioritet';
$hesklang['deletion_priority_restricted']='Dette er en særlig prioritet og kan ikke slettes';
$hesklang['priority_limit']='Du kan ikke oprette flere prioriteter';
$hesklang['skip_to_main_content']='Spring til hovedindhold';
$hesklang['opens_dialog']='Åbner en dialog';
$hesklang['create_a_ticket']='Opret en sag';
$hesklang['toggle_navigation']='Skift navigation';
$hesklang['add_a_ticket_reply']='Tilføj et sagsvar';
$hesklang['linked_tickets']='Tilknyttede sager';
$hesklang['no_linked_tickets']='Ingen tilknyttede sager';
$hesklang['link_ticket']='Knyt sag';
$hesklang['can_link_tickets_e']='Du har ikke tilladelse til at knytte/fjerne denne sag';
$hesklang['link_ticket_success']='Sagen er knyttet med succes';
$hesklang['link_ticket_required_error']='For at knytte en sag skal du angive et gyldigt sporings-ID';
$hesklang['link_ticket_itself_error']='En sag kan ikke knyttes til sig selv. Indtast et andet sporings-ID';
$hesklang['already_linked_error']='Sagen er allerede knyttet';
$hesklang['unlink_success']='Sagen er blevet frigjort';
$hesklang['unlink_error']='Der findes ingen tilknyttet post';
$hesklang['link_history']='<li class="smaller">%s | %s sag knyttet af %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s sag frigjort af %s</li>';
$hesklang['can_link_tickets']='Kan knytte sag';
$hesklang['link_a_ticket']='Knyt en sag';
$hesklang['mfa_curl']='Kan ikke generere et QR-billede til scanning, fordi <strong>cURL</strong> ikke er aktiveret på din server.';
$hesklang['require_xml']='PHP-XML skal være aktiveret for Rich Text (HTML) beskeder. Bed din webhost om at aktivere XML til PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s tilføjet som deltager af %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s fjernet som deltager af %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfekt til forebyggende vedligehold, månedlige adgangsgennemgange, tilbagevendende kundetjek m.m.';
$hesklang['recurring_tickets']['feat1']='<strong>Sæt og glem tidsplaner.</strong> Dagligt, hver mandag, hver marts, den 15. i hver måned eller en vilkårlig fremtidig dato';
$hesklang['recurring_tickets']['feat2']='<strong>Kommer forudfyldte og tildelte.</strong> Vælg kategori, prioritet, agent og op til 100 brugerdefinerede feltværdier';
$hesklang['recurring_tickets']['feat3']='<strong>Forhåndsvis datoer og simulér.</strong> Se alle sager Hesk vil oprette før du aktiverer en regel, så der ikke kommer overraskelser.';
$hesklang['unlink_btn']='Fjern kobling';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');