<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Magyar (Hungarian)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Hunet Kft (https://www.hunetkft.hu/)
* Stock Péter (https://servantes.hu)
* Tóth Roland
* Zólyomi László
* Ultimate Support Kft. (https://ultimatesupport.hu/)
* Attila Temesvári
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Magyar';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Hungarian';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_hungarian_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Válasz ez a sor felett ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Új hibajegy: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Hibajegy érkezett: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Hibajegy hozzárendelve: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Új válasz erre: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Új válasz erre: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Hibajegy áthelyezve: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Megjegyzés hozzáadva: %%SUBJECT%%';
$hesklang['new_pm']='Új privát üzenet: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Támogatási hibajegyek listája';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Nem lehet csatlakozni az adatbázishoz!';
$hesklang['invalid_action']='Helytelen művelet';
$hesklang['select_username']='Kérjük, válassza ki a felhasználónevét';
$hesklang['enter_pass']='Kérjük, adja meg jelszavát';
$hesklang['cant_sql']='Nem lehet végrehajtani az SQL-t';
$hesklang['contact_webmsater']='Kérjük, értesítse a webmestert a következő címen:';
$hesklang['mysql_said']='MySQL mondta';
$hesklang['wrong_pass']='Helytelen jelszó.';
$hesklang['session_expired']='A munkamenet lejárt, kérjük lépjen be.';
$hesklang['attempt']='Érvénytelen kísérlet!';
$hesklang['not_authorized_tickets']='Ön nem jogosult a hibajegyek megtekintésére ebben a kategóriában!';
$hesklang['must_be_admin']='Ön nem jogosult az oldal megtekintésére! Az oldal megtekintéséhez rendszergazdaként kell bejelentkeznie. ';
$hesklang['no_session']='Nem lehet új munkamenetet indítani!';
$hesklang['error']='Hiba';
$hesklang['int_error']='Belső szkript hiba';
$hesklang['no_trackID']='Nincs azonosító ID';
$hesklang['status_not_valid']='Az állapot érvénytelen';
$hesklang['trackID_not_found']='Azonosító ID nem található';
$hesklang['enter_message']='Kérjük, írja be az üzenetét';
$hesklang['select_priority']='Kérjük, válasszon prioritást';
$hesklang['ticket_not_found']='A hibajegy nem található! Kérjük, ellenőrizze, hogy a helyes ID-t adta-e meg! ';
$hesklang['no_selected']='Nincs kiválasztott hibajegy, nincs mit változtatni';
$hesklang['id_not_valid']='Ez nem érvényes ID';
$hesklang['enter_id']='Kérjük, adjon meg egy azonosító ID-t';
$hesklang['enter_name']='Kérjük, adja meg az ügyfél nevét';
$hesklang['enter_date']='Kérjük, írja be a keresés dátumát';
$hesklang['date_not_valid']='Ez nem érvényes dátum. Kérjük, adja meg a dátumot <b> ÉÉÉÉ-HH-NN </b> formátumban. ';
$hesklang['enter_subject']='Kérjük, adja meg a hibajegy tárgyát';
$hesklang['invalid_search']='Érvénytelen keresési művelet';
$hesklang['choose_cat_ren']='Kérjük válasszon egy átnevezendő kategóriát';
$hesklang['cat_ren_name']='Kérjük, írja be az új kategória nevét';
$hesklang['cat_not_found']='Kategória nem található';
$hesklang['enter_cat_name']='Kérjük, adja meg a kategória nevét';
$hesklang['no_cat_id']='Nincs kategóriaazonosító';
$hesklang['cant_del_default_cat']='Az alapértelmezett kategória nem törölhető, csak átnevezhető';
$hesklang['no_valid_id']='Nincs érvényes felhasználói azonosító';
$hesklang['user_not_found']='A felhasználó nem található';
$hesklang['enter_real_name']='Kérjük, adja meg a valódi felhasználó nevét';
$hesklang['enter_valid_email']='Kérjük, adjon meg egy érvényes e-mail címet';
$hesklang['enter_username']='Kérjük, adja meg a felhasználónevét (bejelentkezés)';
$hesklang['asign_one_cat']='Kérjük, rendeljen felhasználót legalább egy kategóriához!';
$hesklang['signature_long']='A felhasználói aláírás túl hosszú! Kérjük, az aláírást korlátozza 1000 karakterre';
$hesklang['confirm_user_pass']='Kérjük, erősítse meg a jelszavát';
$hesklang['passwords_not_same']='A megadott két jelszó nem azonos!';
$hesklang['cant_del_admin']='Alapértelmezett rendszergazda NEM törölhető!';
$hesklang['cant_del_own']='Nem törölhető az a profil, amellyel bejelentkezett!';
$hesklang['enter_your_name']='Kérjük, írja be a nevét';
$hesklang['sel_app_cat']='Kérjük, válassza ki a megfelelő kategóriát';
$hesklang['sel_app_priority']='Kérjük, válassza ki a megfelelő prioritást';
$hesklang['enter_ticket_subject']='Kérjük, adja meg a hibajegy tárgyát';
$hesklang['user_not_found_nothing_edit']='A felhasználó nem található, vagy nincs mit változtatni';

// ADMIN PANEL
$hesklang['administrator']='Rendszergazda';
$hesklang['login']='Bejelentkezés';
$hesklang['user']='Felhasználó';
$hesklang['username']='Felhasználónév';
$hesklang['pass']='Jelszó';
$hesklang['confirm_pass']='Jelszó megerősítése';
$hesklang['logged_out']='Kijelentkezve';
$hesklang['logout']='Kijelentkezés';
$hesklang['logout_success']='Sikeresen kijelentkezett!';
$hesklang['click_login']='Kattintson ide a bejelentkezéshez';
$hesklang['back']='Vissza';
$hesklang['displaying_pages']='<b>% d </b> hibajegy megjelenítése. Oldalak: ';
$hesklang['trackID']='Azonosító ID';
$hesklang['timestamp']='Időbélyeg';
$hesklang['name']='Név';
$hesklang['subject']='Tárgy';
$hesklang['status']='Állapot';
$hesklang['priority']='Prioritás';
$hesklang['open']='Új';
$hesklang['open_action']='Nyitott hibajegy'; // Open ACTION
$hesklang['close']='Zárt'; // Closed ticket STATUS
$hesklang['any_status']='Bármilyen állapot';
$hesklang['high']='Magas';
$hesklang['medium']='Közepes';
$hesklang['low']='Alacsony';
$hesklang['del_selected']='Kijelölt hibajegyek törlése';
$hesklang['manage_cat']='Kategóriák kezelése';
$hesklang['profile']='Az Ön profilja';
$hesklang['show_tickets']='Hibajegy megjelenítése';
$hesklang['sort_by']='Rendezés';
$hesklang['date_posted']='Feladás dátuma';
$hesklang['category']='Kategória';
$hesklang['any_cat']='Bármely kategória';
$hesklang['order']='Rendelés';
$hesklang['ascending']='Emelkedő';
$hesklang['descending']='Csökkenő';
$hesklang['display']='Megjelenítés';
$hesklang['tickets_page']='Hibajegyek oldalanként';
$hesklang['find_ticket']='Hibajegy keresése';
$hesklang['yyyy_mm_dd']='ÉÉÉÉ-HH-NN';
$hesklang['results_page']='eredmények oldalanként';
$hesklang['opened']='nyitva'; // The ticket has been OPENED
$hesklang['closed']='Megoldva'; // Ticket has been RESOLVED
$hesklang['ticket']='Hibajegy';
$hesklang['tickets']='Hibajegyek';
$hesklang['ticket_been']='Ez a hibajegy volt';
$hesklang['view_ticket']='Hibajegy megtekintése';
$hesklang['open_tickets']='Nyitott hibajegyek';
$hesklang['remove_statement']='Eltávolítás &quot; Powered by &quot; nyilatkozat';
$hesklang['click_info']='Kattintson ide további információkért';
$hesklang['reply_added']='Válasz hozzáadva';
$hesklang['reply_submitted']='Válasz elküldve';
$hesklang['ticket_marked']='Ezt a hibajegyet megjelölték';
$hesklang['ticket_status']='Hibajegy állapota';
$hesklang['replies']='Válaszok';
$hesklang['date']='Dátum';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Üzenet';
$hesklang['add_reply']='Válasz hozzáadása';
$hesklang['close_this_ticket']='Jelölje meg a hibajegyet megoldottra';
$hesklang['change_priority']='Prioritás módosítása';
$hesklang['attach_sign']='Aláírás csatolása';
$hesklang['profile_settings']='Profilbeállítások';
$hesklang['submit_reply']='Válasz elküldése';
$hesklang['support_panel']='Támogatási panel';
$hesklang['ticket_trackID']='Hibajegykövetési azonosító';
$hesklang['c2c']='Kattintson a folytatáshoz';
$hesklang['tickets_deleted']='Hibajegyek törölve';
$hesklang['num_tickets_deleted']='Törölt hibajegyek száma: <b>% d </b>';
$hesklang['confirm_del_cat']='Biztosan el akarja távolítani ezt a kategóriát?';
$hesklang['cat_intro']='Itt kezelheti a kategóriákat. A kategóriák hasznosak
a hibajegyek relevancia szerinti kategorizálásához (például &quot; Értékesítés &quot ;,
&quot; Hardverproblémák &quot ;, &quot; PHP / MySQL problémák &quot; stb.) és
felhasználók hozzárendelése kategóriákhoz.';
$hesklang['cat_name']='Név';
$hesklang['remove']='Eltávolítás';
$hesklang['add_cat']='Új kategória';
$hesklang['max_chars']='max 40 karakter';
$hesklang['create_cat']='Kategória mentése';
$hesklang['ren_cat']='Kategória átnevezése';
$hesklang['to']='ig';
$hesklang['cat_added']='Kategória hozzáadva';
$hesklang['cat_name_added']=' %s kategória sikeresen hozzáadva';
$hesklang['cat_renamed']='Kategória átnevezve';
$hesklang['cat_renamed_to']='A kiválasztott kategóriát sikeresen átnevezték';
$hesklang['cat_removed']='Kategória eltávolítva';
$hesklang['cat_removed_db']='A kiválasztott kategória sikeresen eltávolítva az adatbázisból';
$hesklang['sure_remove_user']='Biztosan el akarja távolítani ezt a felhasználót?';
$hesklang['manage_users']='Felhasználók kezelése';
$hesklang['users_intro']='Itt lehet az admin oldalra belépő felhasználókat kezelni.
Az adminisztrátorok bármely kategóriában található hibajegyeket megnézhetik és módosíthatják
és az admin oldal minden funkcióját elérik (felhasználók kezelése, kategóriák kezelése, stb)
A felhasználók csak a saját kategóriájukban található hibajegyeket nézhetik meg és válaszolhatnak rá.';
$hesklang['yes']='IGEN';
$hesklang['no']='NEM';
$hesklang['edit']='Szerkeszt';
$hesklang['add_user']='Új felhasználó hozzáadása';
$hesklang['req_marked_with']='A kötelező mezőket jelöli ';
$hesklang['real_name']='Valódi név';
$hesklang['signature_max']='Aláírás (max 1000 katakter)';
$hesklang['sign_extra']='A HTML kód nem engedélyezett. A linkek kattinthatók lesznek. ';
$hesklang['create_user']='Felhasználó létrehozása';
$hesklang['editing_user']='Felhasználó módosítása';
$hesklang['user_added']='Felhasználó hozzáadva';
$hesklang['user_added_success']='A (z) %s jelszóval rendelkező új felhasználót  %s sikeresen hozzáadtuk';
$hesklang['profile_updated']='Profil frissítve';
$hesklang['profile_updated_success']='Profilt sikeresen frissítetve';
$hesklang['user_removed']='Felhasználó eltávolítva';
$hesklang['sel_user_removed']='A kiválasztott felhasználót sikeresen eltávolítottuk az adatbázisból';
$hesklang['profile_for']='Profil ';
$hesklang['new_pass']='Új jelszó';
$hesklang['update_profile']='Profil frissítése';
$hesklang['notify_new_posts']='Értesítsen, ha a kategóriámban új hibajegy vagy bejegyzés születik.';
$hesklang['view_profile']='Profil megtekintése';
$hesklang['new_ticket_submitted']='Új hibajegy elküldve';
$hesklang['user_profile_updated_success']='Felhasználói profil sikeresen frissítetve';
$hesklang['printer_friendly']='Nyomtatóbarát változat';
$hesklang['end_ticket']='--- A hibajegy vége ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='A hibajegyed volt';
$hesklang['view_your_ticket']='Tekintse meg a hibajegyét';
$hesklang['submit_ticket']='Hibajegy elküldése';
$hesklang['sub_ticket']='Hibajegy elküldése';
$hesklang['before_submit']='A beküldés előtt kérjük, győződjön meg a következőkről';
$hesklang['all_info_in']='Minden szükséges információ kitöltve';
$hesklang['all_error_free']='Minden információ helyes és hibamentes';
$hesklang['we_have']='Van';
$hesklang['recorded_ip']='elmentve, mint az Ön IP címe';
$hesklang['recorded_time']='az Ön beküldésének ideje elmentve';
$hesklang['save_changes']='Változtatások mentése';
$hesklang['reply_submitted_success']='Erre a hibajegyre az Ön válasza sikeresen elküldve';
$hesklang['ticket_submitted']='Hibajegy elküldve';
$hesklang['ticket_submitted_success']='Ön hibajegye sikeresen elküldve! Hibajegy ID';
$hesklang['your_ticket']='A hibajegyed';

// Added in version 0.94
$hesklang['check_updates']='Győződjön meg róla, hogy mindig a Hesk legújabb verzióját telepítette!';
$hesklang['check4updates']='Frissítések keresése';
$hesklang['wait_reply']='Válaszra várok';
$hesklang['replied']='Válaszolt';
$hesklang['last_replier']='Utolsó válaszoló';
$hesklang['staff']='Személyzet';
$hesklang['customer']='Ügyfél';
$hesklang['close_selected']='Kijelölt hibajegyek megjelölése megoldottra';
$hesklang['execute']='Végrehajt';
$hesklang['saved_replies']='Előre megírt válaszok';
$hesklang['manage_saved']='Előre megírt válaszok';
$hesklang['manage_intro']='Itt tudja kezelni az előre megírt válaszokat. Ezek általánosan használt válaszok, ami többé-kevésbé ugyanaz minden ügyfél számára. Az előre megírt válaszok segítségével el tudja kerülni, hogy ugyanazt többször kelljen megírni különböző ügyfeleknek.';
$hesklang['saved_title']='Cím';
$hesklang['no_saved']='Nincsenek előre megirt válaszok';
$hesklang['delete_saved']='Biztosan törli ezt az előre megírt választ?';
$hesklang['new_saved']='Tárolt válasz hozzáadása vagy szerkesztése';
$hesklang['canned_add']='Új előre megírt válasz';
$hesklang['canned_edit']='Kiválasztott konzerv válasz szerkesztése';
$hesklang['save_reply']='Válasz mentése';
$hesklang['saved']='A válasz mentve';
$hesklang['your_saved']='Előre megírt válasz elmentve, jövőbeli használatra';
$hesklang['ent_saved_title']='Kérjük, adja meg a válasz címét';
$hesklang['ent_saved_msg']='Kérjük, adja meg a válaszüzenetet';
$hesklang['saved_removed']='A konzervált válasz eltávolítva';
$hesklang['saved_rem_full']='A kiválasztott konzerv választ eltávolítottuk az adatbázisból';
$hesklang['clip_alt']='A bejegyzéshez mellékletek vannak';
$hesklang['attachments']='Mellékletek';
$hesklang['fill_all']='Hiányzik a kötelező mező';
$hesklang['file_too_large']='A (z)  %s fájl túl nagy';
$hesklang['cannot_move_tmp']='A fájl nem helyezhető át a mellékletek mappájába';
$hesklang['created_on']='Létrehozva';
$hesklang['tickets_closed']='Hibajegyek zárva';
$hesklang['num_tickets_closed']='<b> %d </b> hibajegyet lezárták';
$hesklang['select_saved']='Válasszon konzerv választ';
$hesklang['select_empty']='Kiválasztás / ürítés';
$hesklang['insert_special']='Speciális címke beszúrása (helyébe az ügyfél információ kerül)';
$hesklang['move_to_catgory']='Hibajegy áthelyezése ide';
$hesklang['move']='Hibajegy áthelyezve';
$hesklang['moved']='Hibajegy átmozgatva';
$hesklang['moved_to']='Ez a hibajegy átmozgatva egy új kategóriába';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Minden, csak zárt';
$hesklang['chg_all']='Összes módosítása';
$hesklang['settings']='Beállítások';
$hesklang['settings_intro']='Ezzel az eszközzel konfigurálhatja a ügyfélszolgálatot. Az összes beállításról és opcióról további információkért kattintson a súgójelre, vagy olvassa el a readme.html fájlt. ';
$hesklang['all_req']='Minden mező kitöltése (a letiltott kivételével) kötelező!';
$hesklang['wbst_title']='Webhely címe';
$hesklang['wbst_url']='Webhely URL-je';
$hesklang['email_wm']='Webmester e-mail';
$hesklang['max_listings']='Adatok oldalanként';
$hesklang['print_size']='Betűméret nyomtatása';
$hesklang['debug_mode']='Hibakeresési mód';
$hesklang['on']='BE';
$hesklang['off']='KI';
$hesklang['use_secimg']='SPAM-ellenes kép használata';
$hesklang['secimg_no']='Nem elérhető';
$hesklang['attach_use']='Mellékletek használata';
$hesklang['attach_num']='Jegyenként feltölthető fájlok max. száma';
$hesklang['attach_type']='Engedélyezett fájl típusok';
$hesklang['place_after']='Üzenet után';
$hesklang['place_before']='Üzenet elõtt';
$hesklang['custom_f']='Egyéni mező';
$hesklang['custom_u']='Használja ezt a mezőt';
$hesklang['custom_n']='Mező neve';
$hesklang['custom_l']='Maximális hosszúság (karakter)';
$hesklang['db_host']='Adatbázis gazdagép';
$hesklang['db_name']='Adatbázis neve';
$hesklang['db_user']='Adatbázis felhasználóneve';
$hesklang['db_pass']='Adatbázis jelszó';
$hesklang['err_sname']='Kérjük, írja be a webhely címét';
$hesklang['err_surl']='Kérjük, írja be webhelye URL-jét. Győződjön meg arról, hogy ez egy érvényes URL (kezdje a következővel: http: // vagy https: //)';
$hesklang['err_wmmail']='Kérjük, adjon meg egy érvényes webmester e-mailt';
$hesklang['err_nomail']='Kérjük, adjon meg egy érvényes noreply e-mailt';
$hesklang['err_htitle']='Kérjük, írja be az ügyfélszolgálat címét';
$hesklang['err_hurl']='Kérjük, írja be a Hesk mappa URL-jét. Győződjön meg arról, hogy ez egy érvényes URL (kezdje a következővel: http: // vagy https: //) ';
$hesklang['err_lang']='Kérjük, válassza a Hesk nyelvét';
$hesklang['err_nolang']='A megadott nyelvfájl nem létezik a nyelvi mappában! Győződjön meg arról, hogy a fájlt feltöltötte, mielőtt megváltoztatta a nyelvi beállítást. ';
$hesklang['err_max']='Kérjük, adja meg az oldalankénti megjelenítés maximális listáját';
$hesklang['err_psize']='Kérjük, adja meg a nyomtatás betűméretét';
$hesklang['err_dbhost']='Kérjük, adja meg MySQL adatbázis-gazdagépét';
$hesklang['err_dbname']='Kérjük, adja meg a MySQL adatbázis nevét';
$hesklang['err_dbuser']='Kérjük, adja meg a MySQL adatbázis felhasználónevét';
$hesklang['err_dbpass']='Kérjük, adja meg MySQL adatbázis jelszavát';
$hesklang['err_dbconn']='Nem sikerült csatlakozni a MySQL adatbázishoz a megadott információk felhasználásával!';
$hesklang['err_dbsele']='Nem sikerült kiválasztani a MySQL adatbázist, kérjük, ellenőrizze újra a NAME adatbázist';
$hesklang['err_custname']='Adja meg az egyéni mező nevét';
$hesklang['err_openset']='Nem lehet megnyitni a <b> hesk_settings.inc.php </b> fájlt íráshoz. Kérjük, CHMOD ezt a fájlt 666-ra (rw-rw-rw-) ';
$hesklang['set_saved']='Beállítások mentve';
$hesklang['set_were_saved']='Beállítások sikeresen elmentve!';
$hesklang['sec_img']='Biztonsági kép';
$hesklang['sec_miss']='Kérjük, adja meg a biztonsági számot';
$hesklang['sec_wrng']='Helytelen biztonsági szám';
$hesklang['submit_problems']='Kérjük, menjen vissza, és javítsa ki a következő problémákat';
$hesklang['cat_order']='Kategória sorrend';
$hesklang['reply_order']='Előre megírt válasz sorrend';
$hesklang['move_up']='Feljebb';
$hesklang['move_dn']='Mozgás lefelé';
$hesklang['cat_move_id']='Hiányzó kategóriaazonosító';
$hesklang['reply_move_id']='Hiányzó előre megírt válasz ID';
$hesklang['forgot_tid']='Elfelejtette a követési azonosítót?';
$hesklang['tid_send']='Küldje el nekem a követési azonosítómat';
$hesklang['tid_not_found']='Nem található hibajegy az Ön e-mail címével';
$hesklang['tid_sent']='Követési azonosító elküldve';
$hesklang['tid_sent2']='E-mailt küldtünk az Ön címére a hibajegyek részleteivel';
$hesklang['check_spambox']='Ügyeljen arra, hogy a SPAM / Junk postafiókban is ellenőrizze az e-mailt!';
$hesklang['reply_not_found']='Előre megírt válasz nem található';
$hesklang['exists']='Létezik';
$hesklang['no_exists']='Nem létezik';
$hesklang['writable']='Írható';
$hesklang['not_writable']='Nem írható';
$hesklang['disabled']='letiltva';
$hesklang['e_settings']='A beállításokat csak akkor mentheti, ha ezt a fájlt a szkript írja. További útmutatásért olvassa el a readme fájlt! ';
$hesklang['e_attdir']='Csak akkor használhatja a fájlmellékleteket, ha a mellékletmappa létezik, és azt a szkript írhatja.';
$hesklang['e_save_settings']='Nem lehet menteni a beállításokat, mert a <b> hesk_settings.inc.php </b> fájlt nem írhatja a szkript.';
$hesklang['e_attach']='Letiltva, mert a <b> mellékletek </b> könyvtárat nem írja a szkript.';
$hesklang['go']='Menj';

// Added in version 2.0
$hesklang['v']='HESK verzió';
$hesklang['check_status']='Állapot ellenőrzése';
$hesklang['sub_support']='Hibajegy küldése';
$hesklang['open_ticket']='Új kérdés elküldése egy osztálynak';
$hesklang['view_existing']='Meglévő hibajegy megtekintése';
$hesklang['vet']='Régebben beküldött hibajegyek megtekintése';
$hesklang['enter_user']='Kérjük, adja meg felhasználónevét';
$hesklang['remember_user']='Emlékezzen a felhasználónevemre';
$hesklang['wrong_user']='Helytelen felhasználónév';
$hesklang['no_permission']='Nincs engedélye ennek a feladatnak a végrehajtására, kérjük, jelentkezzen be egy olyan fiókkal, amely rendelkezik.';
$hesklang['tickets_on_pages']='Hibajegyek száma:%d | Oldalak száma:%d '; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='| Ugrás az oldalra: ';
$hesklang['no_tickets_open']='Nem található megoldatlan hibajegy';
$hesklang['no_tickets_crit']='Nem található a feltételeknek megfelelő hibajegy';
$hesklang['confirm_execute']='Biztosan folytatja?';
$hesklang['legend']='Jelmagyarázat';
$hesklang['main_page']='Főlap';
$hesklang['menu_users']='Felhasználók';
$hesklang['menu_cat']='Kategóriák';
$hesklang['menu_profile']='Profil';
$hesklang['menu_kb']='Tudástár'; // Admin MENU item
$hesklang['kb_text']='Tudástár'; // Item visible to customers
$hesklang['viewkb']='A teljes Tudásbázis megtekintése';
$hesklang['kb']='Tudásbázis kezelése';
$hesklang['kb_intro']='A Tudásbázis a gyakran feltett kérdésekre adott válaszok és cikkek gyűjteménye, amelyek önsegítő forrásokat kínálnak az ügyfeleknek.
Az átfogó és jól megírt tudásbázis drasztikusan csökkentheti a kapott támogatási hibajegyek számát, és sok időt takaríthat meg. A cikkeket kategóriákba rendezheti
és alkategóriák.'; // Description in ADMIN panel
$hesklang['kb_is']='A Tudásbázis a gyakran feltett kérdésekre (GYIK) és cikkekre adott válaszok kategorizált gyűjteménye. Elolvashatja ebben a kategóriában a cikkeket, vagy kiválaszthatja az Önt érdeklő alkategóriát. '; // Description for CUSTOMERS
$hesklang['new_kb_art']='Új tudásbázis-cikk';
$hesklang['kb_cat']='Kategória';
$hesklang['kb_subject']='Tárgy';
$hesklang['kb_content']='Tartalom';
$hesklang['kb_type']='Típus';
$hesklang['kb_published']='Közzétett';
$hesklang['kb_published2']='A cikk mindenki számára látható a tudásbázisban.';
$hesklang['kb_private']='Privát';
$hesklang['kb_private2']='A privát cikkeket csak az alkalmazottak olvashatják.';
$hesklang['kb_draft']='Piszkozat';
$hesklang['kb_draft2']='A cikk el lett mentve, de még nem jelent meg. Csak az a személyzet olvashatja el <br />, akinek engedélye van a tudásbázis cikkeinek kezelésére. ';
$hesklang['kb_links']='<i> <span class = "note"> <b> Figyelem! </b> </span> <br /> Adjon meg érvényes kódot & lt; head & gt; és & lt; test & gt; címkék, csak tartalom! </i> ';
$hesklang['kb_ehtml']='Ez egy HTML kód (érvényes (X) HTML kódot adok meg)';
$hesklang['kb_dhtml']='Ez egyszerű szöveg (a linkek kattinthatók lesznek)';
$hesklang['kb_save']='Cikk mentése';
$hesklang['kb_e_subj']='Írja be a cikk tárgyát!';
$hesklang['kb_e_cont']='A cikk tartalmának írása!';
$hesklang['kb_art_added']='Cikk hozzáadva';
$hesklang['your_kb_added']='Új tudásbázis-cikk sikeresen hozzáadva';
$hesklang['kb_art_deleted']='Cikk törölve';
$hesklang['your_kb_deleted']='A kiválasztott tudásbázis cikk sikeresen törölve';
$hesklang['kb_art_mod']='Cikk módosítva';
$hesklang['your_kb_mod']='Kiválasztott cikk módosításai sikeresen elmentetve';
$hesklang['kb_cat_new']='Új tudásbázis kategória';
$hesklang['kb_cat_parent']='Szülő kategória';
$hesklang['kb_cat_sub']='Alkategóriák';
$hesklang['kb_cat_title']='Kategória címe';
$hesklang['kb_cat_published']='A kategória mindenki számára látható a tudásbázisban.';
$hesklang['kb_cat_private']='A kategóriát csak az alkalmazottak olvashatják.';
$hesklang['kb_cat_add']='Kategória hozzáadása';
$hesklang['kb_cat_e_title']='Írja be a kategória címét!';
$hesklang['kb_cat_added']='Kategória hozzáadva';
$hesklang['kb_cat_added2']='Új kategória sikeresen hozzáadva a tudásbázishoz';
$hesklang['kb_cat_man']='Tudásbázis-kategória kezelése';
$hesklang['kb_cat_edit']='A kategória részleteinek szerkesztése';
$hesklang['kb_cat_inv']='Érvénytelen kategória';
$hesklang['kb_cat_art']='cikkek ebben a kategóriában';
$hesklang['kb_p_art']='+ cikk';
$hesklang['kb_p_art2']='új cikk hozzáadása a kiválasztott kategóriához.';
$hesklang['kb_add_art']='Cikk hozzáadása';
$hesklang['kb_p_cat']='+ Kategória';
$hesklang['kb_p_cat2']='hozzon létre egy új alkategóriát a kiválasztott kategórián belül.';
$hesklang['kb_add_cat']='Kategória hozzáadása';
$hesklang['kb_p_man']='Kezelés';
$hesklang['kb_p_man2']='kiválasztott kategória kezelése (cikkek szerkesztése, törlése, kezelése).';
$hesklang['kb_main']='A fő tudásbázis-kategóriát nem lehet törölni vagy áthelyezni.';
$hesklang['kb_no_art']='Ebben a kategóriában nincsenek cikkek.';
$hesklang['author']='Szerző';
$hesklang['views']='Nézetek';
$hesklang['delete']='Törlés';
$hesklang['rating']='Értékelés';
$hesklang['votes']='Szavazatok';
$hesklang['kb_rated']='  %s / 5.0 besorolású cikk';
$hesklang['kb_not_rated']='A cikk még nincs besorolva';
$hesklang['del_art']='Biztosan törli a kijelölt cikket?';
$hesklang['kb_art_id']='Hiányzó vagy érvénytelen cikkazonosító!';
$hesklang['kb_art_edit']='Cikk szerkesztése';
$hesklang['revhist']='Verzióelőzmények';
$hesklang['revision1']='<li class = "smaller"> %s | beküldte: %s </li> '; // %s = date, user making change
$hesklang['revision2']='<li class = "smaller"> %s |  %s módosította </li> '; // %s = date, user making change
$hesklang['kb_order']='Rendelés';
$hesklang['kb_delcat']='Biztosan törli ezt a kategóriát?';
$hesklang['kb_cat_mod']='Kategória módosítva';
$hesklang['your_cat_mod']='Kiválasztott kategória módosításai sikeresen elmentetve';
$hesklang['kb_cat_del']='Tudásbázis kategória törölve';
$hesklang['kb_cat_dlt']='A kiválasztott tudásbázis kategória törölve.';
$hesklang['allowed_cat']='Kategóriák';
$hesklang['allow_feat']='Jellemzők';
$hesklang['can_view_tickets']='Hibajegyek megtekintése';
$hesklang['can_reply_tickets']='Válasz a hibajegyekre';
$hesklang['can_assign_tickets']='Hibajegyek hozzárendelése';
$hesklang['can_del_tickets']='Hibajegyek törlése';
$hesklang['can_edit_tickets']='Hibajegyválaszok szerkesztése';
$hesklang['can_change_cat']='Hibajegy kategória módosítása (bármelyikre)';
$hesklang['can_man_kb']='Tudásbázis kezelése';
$hesklang['can_man_users']='Felhasználók kezelése';
$hesklang['can_man_cat']='Kategóriák kezelése';
$hesklang['can_man_canned']='Tárolt válaszok kezelése';
$hesklang['can_man_settings']='Súgó beállításainak kezelése';
$hesklang['can_del_notes']='Minden hibajegy törlése';
$hesklang['dan']='a felhasználók törölhetik saját hibajegyeiket, csak akkor válassza ezt, ha engedélyezni kívánja, hogy a felhasználó törölhesse más felhasználók jegyzeteit is';
$hesklang['in_all_cat']='csak engedélyezett kategóriákban';
$hesklang['admin_can']='(hozzáférés az összes szolgáltatáshoz és kategóriához)';
$hesklang['staff_can']='(korlátozhatja a funkciókat és kategóriákat)';
$hesklang['asign_one_feat']='Kérjük, rendeljen hozzá legalább egy funkciót ehhez a felhasználóhoz!';
$hesklang['na_view_tickets']='Ön nem jogosult a hibajegyek megtekintésére';
$hesklang['support_notice']='Sajnáljuk, ezt a részt csak akkor lehet elrejteni, ha HESK licencet vásárol!';
$hesklang['rart']='Hasznos volt ez a cikk?';
$hesklang['r']='Hasznos volt ez a válasz?';
$hesklang['tyr']='Köszönjük az értékelést';
$hesklang['cw']='Ablak bezárása';
$hesklang['cw2']='Ablak bezárása és hibajegy elküldése';
$hesklang['rh']='Hasznosnak minősített';
$hesklang['rnh']='Nem minősítették hasznosnak';
$hesklang['ar']='Már értékeltem';
$hesklang['rated']='Felhasználó értékelése  %s / 5,0 ( %s szavazat)';
$hesklang['not_rated']='A felhasználó még nincs besorolva';
$hesklang['rdis']='Az értékelés le van tiltva';
$hesklang['kbdis']='A Tudásbázis le van tiltva';
$hesklang['kbpart']='Elnézést, nincs engedélye a cikk elérésére';
$hesklang['popart']='Top cikkek';
$hesklang['latart']='Legfrissebb cikkek';
$hesklang['m']='További témák';
$hesklang['ac']='cikkek ebben a kategóriában';
$hesklang['noa']='Még nincs cikk';
$hesklang['noac']='Még nincs cikk ebben a kategóriában';
$hesklang['dta']='Hozzáadás dátuma';
$hesklang['ad']='Cikk részletei';
$hesklang['aid']='cikkazonosító';
$hesklang['as']='Megoldás';
$hesklang['search']='Keresés';
$hesklang['sr']='Keresési eredmények';
$hesklang['nosr']='Nem található megfelelő cikk. Próbáljon böngészni a tudásbázisban, vagy küldjön be új támogatási hibajegyet. ';
$hesklang['rv']='Nézetek visszaállítása';
$hesklang['rr']='A szavazatok (értékelések) alaphelyzetbe állítása';
$hesklang['opt']='Opciók';
$hesklang['delcat']='Kategória törlése';
$hesklang['move1']='Cikkek áthelyezése szülő kategóriába';
$hesklang['move2']='Cikkek törlése ebben a kategóriában';
$hesklang['sc']='Javasolt tudásbázis cikkek';
$hesklang['not']='Hibajegyek'; // Number of all tickets in category
$hesklang['graph']='Grafikon';
$hesklang['lu']='Felhasználói nevek listázása';
$hesklang['aclose']='Hibajegyek automatikus lezárása';
$hesklang['aclose2']='nap a személyzet utolsó válasza után';
$hesklang['s_ucrt']='Hibajegyeket újra megnyitása';
$hesklang['urate']='Válasz értékelések';
$hesklang['hesk_url']='Súgó URL-je';
$hesklang['hesk_title']='Súgó címe';
$hesklang['cid']='Esetkövetési azonosító';
$hesklang['tfor']='Idő formátum';
$hesklang['prefix']='Tábla előtag';
$hesklang['s_ekb']='Tudásbázis engedélyezése';
$hesklang['s_kbs']='KB-keresés engedélyezése';
$hesklang['s_kbr']='KB besorolás engedélyezése';
$hesklang['s_maxsr']='Maximális keresési eredmények';
$hesklang['s_suggest']='KB cikkek javaslata';
$hesklang['s_spop']='Népszerű cikkek megjelenítése';
$hesklang['s_slat']='Legfrissebb cikkek megjelenítése';
$hesklang['s_onin']='a <a href="../" target="_blank"> help desk index </a> oldalon';
$hesklang['s_onkb']='a <a href="../knowledgebase.php" target="_blank"> Tudásbázis index </a> oldalán';
$hesklang['s_scol']='Kategóriák a sorban';
$hesklang['s_ptxt']='A cikk előnézeti hossza';
$hesklang['s_psubart']='Alkategóriás cikkek';
$hesklang['enable']='Engedélyezés';
$hesklang['s_type']='Típus';
$hesklang['custom_r']='Kötelező';
$hesklang['custom_place']='Hely';
$hesklang['custom_use']='Egyéni mezők';
$hesklang['stf']='Szövegmező';
$hesklang['stb']='Nagy szövegdoboz';
$hesklang['srb']='Rádió gomb';
$hesklang['ssb']='Válasszon mezőt';
$hesklang['db']='Adatbázis';
$hesklang['hd']='Súgó beállításai';
$hesklang['gs']='Általános beállítások';
$hesklang['cwin']='Ablak bezárása';
$hesklang['defw']='Alapértelmezett érték';
$hesklang['ok']='OK';
$hesklang['ns']='Ezek az opcionális lehetőségek állnak rendelkezésre ehhez az egyéni mezőhöz. A változtatások mentéséhez kattintson az <b> OK </b> és a <b> Módosítások mentése </b> gombra az adminisztrációs beállítások oldalon! ';
$hesklang['rows']='Sorok (magasság)';
$hesklang['cols']='Oszlopok (szélesség)';
$hesklang['opt2']='Ennek a választógombnak az opciói, soronként adjon meg egy opciót (minden sor új választógombértéket hoz létre, amelyből választhat). Legalább két lehetőséget kell megadnia! ';
$hesklang['opt3']='Ennek a jelölőnégyzetnek az opciói, soronként adjon meg egy opciót (minden sor olyan választás lesz, amelyet az ügyfelek választhatnak). Legalább két lehetőséget kell megadnia! ';
$hesklang['atl2']='Írjon be legalább két opciót (soronként egyet)!';
$hesklang['notes']='Jegyzetek';
$hesklang['addnote']='Jegyzet hozzáadása';
$hesklang['noteby']='Megjegyzés:';
$hesklang['delnote']='Jegyzet törlése';
$hesklang['noteerr']='A megjegyzés már törölve vagy rossz paraméterek';
$hesklang['s']='Küldés';
$hesklang['nhid']='A jegyzetek el vannak rejtve az ügyfelek elől!';
$hesklang['delt']='A bejegyzés törlése';
$hesklang['edtt']='Bejegyzés szerkesztése';
$hesklang['edt1']='Bejegyzés módosítva';
$hesklang['edt2']='Kiválasztott bejegyzés módosításai elmentetve';
$hesklang['dele']='Törölje ezt a hibajegyet';
$hesklang['repd']='Bejegyzés törölve';
$hesklang['repl']='A kiválasztott bejegyzés törölve lett';
$hesklang['tickets_found']='Keresési eredmények';
$hesklang['al']='Rendszergazda link';
$hesklang['ap']='Ugrás az adminisztrációs panelre';
$hesklang['dap']='Link megjelenítése az adminisztrációs panelhez a <a href="../" target="_blank"> help desk indexből </a>';
$hesklang['q_miss']='Kérem, válaszoljon a SPAM-ellenes kérdésre';
$hesklang['use_q']='SPAM-ellenes kérdés használata';
$hesklang['q_q']='Kérdés (a HTML kód <span class = "siker"> megengedett </span>)';
$hesklang['q_a']='Válasz';
$hesklang['err_qask']='Írjon be egy SPAM-ellenes kérdést';
$hesklang['err_qans']='Írja be a választ a SPAM-ellenes kérdésre';
$hesklang['genq']='Véletlenszerű kérdés generálása';

// Added in version 2.1
$hesklang['amo']='További hozzáadása';
$hesklang['delatt']='Törli a kijelölt mellékletet?';
$hesklang['kb_att_rem']='A kiválasztott mellékletet eltávolítottuk';
$hesklang['inv_att_id']='Érvénytelen mellékletazonosító!';
$hesklang['scb']='Jelölőnégyzet';
$hesklang['opt4']='A jelölőnégyzet beállításai, soronként adjon meg egy opciót. Minden sor olyan választás, amelyet az ügyfelek választhatnak, többféle lehetőség is lehetséges. ';
$hesklang['autologin']='Automatikus bejelentkezés';
$hesklang['just_user']='Csak a felhasználónevemre emlékszem';
$hesklang['nothx']='Nem, köszönöm';
$hesklang['pinfo']='Profilinformációk';
$hesklang['sig']='Aláírás';
$hesklang['pref']='Beállítások';
$hesklang['aftrep']='Miután válaszolt egy hibajegyre';
$hesklang['showtic']='Mutassa a hibajegyet, amire most válaszoltam';
$hesklang['gomain']='Vissza a fő adminisztrációs oldalra';
$hesklang['shownext']='Nyissa meg a következő hibajegyet, amelyre a válaszomra van szükség';
$hesklang['rssn']='A következő figyelmét igénylő hibajegy megjelenítése';
$hesklang['mrep']='Üzenet cseréje';
$hesklang['madd']='Hozzáadás az aljához';
$hesklang['priv']='Csak a személyzet számára látható privát kategóriákat és cikkeket * jelöli';
$hesklang['inve']='Érvénytelen e-mail fájl';
$hesklang['emfm']='Hiányzó e-mail fájl';
$hesklang['hesk_lang']='Alapértelmezett nyelv';
$hesklang['s_mlang']='Több nyelv';
$hesklang['s_mlange']='Csak akkor engedélyezhető, ha minden telepített nyelven támogatást nyújt!';
$hesklang['s_inl']='Tesztnyelv-mappa';
$hesklang['s_inle']='Érvényes nyelvi mappa tesztelése. Csak azok a nyelvek telepítve, amelyek megfelelnek az összes tesztnek. ';
$hesklang['ta']='Tesztelje újra';
$hesklang['alo']='Automatikus bejelentkezés engedélyezése';
$hesklang['chol']='Előnyben részesített nyelv';
$hesklang['mmdl']='Legyen ez a preferált nyelv';
$hesklang['warn']='FIGYELEM';
$hesklang['dmod']='A hibakeresési mód engedélyezve van. A HESK telepítése és megfelelő működése után feltétlenül tiltsa le a hibakeresési módot a beállításokban. ';
$hesklang['kb_spar']='A kategória nem lehet a saját szülőkategóriája!';
$hesklang['mysql_root']='A MySQL jelszava üres, biztosan root felhasználóval szeretnél bejelentkezni? Ez jelentős biztonsági kockázatot jelent! ';
$hesklang['chg']='Módosítás';
$hesklang['chpri']='A prioritás megváltozott';
$hesklang['chpri2']='A hibajegy prioritása %s-ra változott';
$hesklang['selcan']='Válassza ki a szerkeszteni kívánt konzervált választ';
$hesklang['q_wrng']='Rossz SPAM-ellenes válasz';
$hesklang['cndupl']='Már van ilyen nevű kategóriája. Válasszon egyedi nevet minden kategóriához. ';
$hesklang['wsel']='Válassza ki a keresni kívánt mezőt';

// Added in version 2.2
$hesklang['eto']='Érvénytelen kérés';
$hesklang['id']='ID';
$hesklang['geco']='Közvetlen kapcsolat létrehozása';
$hesklang['genl']='A link vágólapra másolva';
$hesklang['genl2']='Ezt a linket használva előválaszthatja a kategóriát a &quot; Hibajegy beküldése &quot; forma.';
$hesklang['ask']='Súgó keresése:';
$hesklang['exa']='Példák';
$hesklang['small']='Kis doboz';
$hesklang['large']='Nagy doboz';
$hesklang['cpri']='Ügyfél prioritása';
$hesklang['owner']='Tulajdonos';
$hesklang['unas']='Kiosztatlan';
$hesklang['assi']='Hozzárendelés';
$hesklang['asst']='Hozzárendelés';
$hesklang['asst2']='Rendelje ezt a hibajegyet';
$hesklang['asss']='Hozzárendelés önmagamhoz';
$hesklang['asss2']='Rendeljem magamhoz ezt a hibajegyet';
$hesklang['can_assign_self']='Hibajegyeket rendelhet magához';
$hesklang['can_assign_others']='Hibajegyeket rendelhet másoknak';
$hesklang['can_run_reports']='Jelentéseket tud futtatni (saját)';
$hesklang['can_view_ass_others']='Megtekintheti a másoknak rendelt hibajegyeket';
$hesklang['unoa']='A kiválasztott felhasználónak nincs hozzáférése ehhez a kategóriához';
$hesklang['tasi']='Tulajdonos kijelölve';
$hesklang['tasy']='Ezt a hibajegyet neked rendelték';
$hesklang['taso']='Ezt a hibajegyet a kiválasztott felhasználóhoz rendelték';
$hesklang['tasy2']='Hozzám rendelt';
$hesklang['taso2']='Máshoz rendelt';
$hesklang['nose']='Az új tulajdonos kiválasztása';
$hesklang['onasc']='Ez a tulajdonos nem fér hozzá a kiválasztott kategóriához.';
$hesklang['tunasi']='Hibajegy nincs hozzárendelve';
$hesklang['tunasi2']='A hibajegy tulajdonos nélkül van, és újra készen áll a hozzárendelésre';
$hesklang['note']='Megjegyzés';
$hesklang['success']='Siker';
$hesklang['nyt']='Ez a hibajegy tulajdonosa:';
$hesklang['noch']='Nem történt változás';
$hesklang['orch']='A megjelenítési sorrend módosult';
$hesklang['rfm']='Szükséges információ hiányzik:';
$hesklang['repl0']='Nincs elegendő engedélye ehhez a művelethez';
$hesklang['repl1']='Ez a bejegyzés nem létezik';
$hesklang['reports']='Jelentések';
$hesklang['reports_intro']='A Jelentések szakasz lehetővé teszi több jelentés futtatását és a hibajegystatisztikák megtekintését egy kiválasztott dátumtartományban.';
$hesklang['refi']='Űrlapadatok visszaállítása';
$hesklang['dich']='Változások elvetése';
$hesklang['dire']='Jelentés megjelenítése';
$hesklang['m1']='Január';
$hesklang['m2']='Február';
$hesklang['m3']='Március';
$hesklang['m4']='Április';
$hesklang['m5']='Május';
$hesklang['m6']='Június';
$hesklang['m7']='Július';
$hesklang['m8']='Augusztus';
$hesklang['m9']='Szeptember';
$hesklang['m10']='Október';
$hesklang['m11']='November';
$hesklang['m12']='December';
$hesklang['d1']='Hétfő';
$hesklang['d2']='Kedd';
$hesklang['d3']='Szerda';
$hesklang['d4']='Csütörtök';
$hesklang['d5']='Péntek';
$hesklang['d6']='Szombat';
$hesklang['d0']='Vasárnap';
$hesklang['mo']='Hé';
$hesklang['tu']='Ke';
$hesklang['we']='Sze';
$hesklang['th']='Csü';
$hesklang['fr']='Pé';
$hesklang['sa']='Szo';
$hesklang['su']='Va';
$hesklang['from']='';
$hesklang['cinv']='Helytelen dátum';
$hesklang['cinv2']='Helyes formátum: ÉÉÉÉ/HH/NN';
$hesklang['cinm']='Helytelen hónap érték';
$hesklang['cinm2']='Engedélyezett tartomány:';
$hesklang['cind']='Helytelen nap érték';
$hesklang['cind2']='A kiválasztott hónap megengedett tartománya';
$hesklang['month']='Hónap';
$hesklang['ocal']='Naptár megnyitása';
$hesklang['ca01']='Előző év';
$hesklang['ca02']='Előző hónap';
$hesklang['ca03']='Következő hónap';
$hesklang['ca04']='Következő év';
$hesklang['ca05']='Naptár bezárása';
$hesklang['cdr']='Dátum választása:';
$hesklang['crt']='Jelentés típusa';
$hesklang['r1']='Ma';
$hesklang['r2']='Tegnap';
$hesklang['r3']='Ez a hónap';
$hesklang['r4']='Előző hónap';
$hesklang['r5']='Előző 30 nap';
$hesklang['r6']='Ezen a héten (Hét-Vas)';
$hesklang['r7']='Múlt hét (Hét-Vas)';
$hesklang['r8']='Ez az üzleti hét (Hét-Pén)';
$hesklang['r9']='Előző üzleti hét (Hét-Pén)';
$hesklang['r10']='Ez az év';
$hesklang['r11']='Előző év';
$hesklang['r12']='Mindig';
$hesklang['datetofrom']='&quot;Tól dátum&quot; nem lehet nagyobb, mint az &quot;Ig dátum&quot;. Dátum értékek kicserélve.';
$hesklang['t1']='Hibajegy naponként';
$hesklang['t2']='Hibajegyek havonta';
$hesklang['t3']='Hibajegyek felhasználónként';
$hesklang['t4']='Hibajegyek kategóriánként';
$hesklang['ticass']='Kiosztott hibajegyek';
$hesklang['ticall']='Megválaszolt hibajegyek';
$hesklang['totals']='Összesen';
$hesklang['all']='Mind';
$hesklang['atik']='Új hibajegyek';
$hesklang['kbca']='Már rendelkezik egy tudásbázis-kategóriával ezzel a névvel.';
$hesklang['menu_msg']='Levelezés';
$hesklang['menu_can']='Előre megírt';
$hesklang['m_from']='Feladó'; // Mail "from" address
$hesklang['m_to']='Címzett'; // Mail "to" address
$hesklang['m_sub']='Tárgy'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Privát üzenetek';
$hesklang['m_intro']='Privát üzenetek használatával gyors üzeneteket küldhet a HESK-n belüli munkatársaknak.';
$hesklang['e_udel']='(Felhasználó törölve)';
$hesklang['new_mail']='Új privát üzenet';
$hesklang['m_send']='Üzenet küldése';
$hesklang['m_rec']='Válassza ki az üzenet címzettjét';
$hesklang['m_inr']='Érvénytelen üzenet címzettje';
$hesklang['m_esu']='Adja meg a privát üzenet tárgyát';
$hesklang['m_pms']='Privát üzenet elküldve';
$hesklang['inbox']='Beérkező';
$hesklang['outbox']='Kimenő';
$hesklang['m_new']='Új üzenet';
$hesklang['pg']='Oldal megjelenítése';
$hesklang['npm']='Nincs privát üzenet ebben a mappában.';
$hesklang['m_ena']='Nincs engedélye ennek az üzenetnek az elolvasására.';
$hesklang['mau']='Megjelölés olvasatlanként';
$hesklang['mo1']='A kijelölt üzenetek megjelölése olvasottként';
$hesklang['mo2']='A kijelölt üzenetek megjelölése olvasatlanként';
$hesklang['mo3']='Kijelölt üzenetek törlése';
$hesklang['delm']='Az üzenet törlése';
$hesklang['e_tid']='Hiba történt az egyedi hibajegyazonosító létrehozása során, próbálkozzon később az űrlap újbóli elküldésével.';
$hesklang['smmr']='A kijelölt üzeneteket olvasottként megjelölve';
$hesklang['smmu']='A kijelölt üzeneteket olvasatlanként lettek megjelölve';
$hesklang['smdl']='A kiválasztott üzenetek törölve';
$hesklang['show']='Megjelenítés';
$hesklang['s_my']='Hozzám rendelve';
$hesklang['s_ot']='Másokhoz rendelt';
$hesklang['s_un']='Kiosztatlan hibajegyek';
$hesklang['s_for']='Keresés';
$hesklang['s_in']='Keresés itt';
$hesklang['s_incl']='Keresés belül';
$hesklang['find_ticket_by']='Hibajegy keresése';
$hesklang['e_nose']='Nincs kijelölve hozzárendelési állapot, az összes hibajegy látható.';
$hesklang['fsq']='Írja be a keresési lekérdezést';
$hesklang['topen']='Nyitott';
$hesklang['nms']='Nincs kiválasztott üzenet, nincs mit változtatni';
$hesklang['tlo']='Hibajegy zárolása';
$hesklang['tul']='Hibajegy feloldása';
$hesklang['loc']='Zárva';
$hesklang['isloc']='Az ügyfelek nem válaszolhatnak vagy nem nyithatják meg újra a lezárt jegyeket. Ha a lezárt hibajegyet megoldottként jelölik. ';
$hesklang['tlock']='A hibajegy zárolva van';
$hesklang['tunlock']='A hibajegyet feloldották';
$hesklang['tislock']='Ezt a hibajegyet lezárták, az ügyfél nem fog tudni választ küldeni.';
$hesklang['tislock2']='Ez a hibajegy zárolva van, nem küldhet választ.';
$hesklang['nsfo']='Nem található releváns cikk.';
$hesklang['thist1']='<li class = "smaller"> %s |  %s kategóriába helyezte %s </li> '; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller"> %s |  %s hozzárendelve %s által </li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class = "smaller"> %s |  %s zárta </li> '; // %s = date, user making change
$hesklang['thist4']='<li class = "smaller"> %s |  %s nyitotta meg </li> '; // %s = date, user making change
$hesklang['thist5']='<li class = "smaller"> %s |  %s zárolta </li> '; // %s = date, user making change
$hesklang['thist6']='<li class = "smaller"> %s |  %s feloldotta </li> '; // %s = date, user making change
$hesklang['thist7']='<li class = "smaller"> %s | hibajegyet készítette: %s </li> '; // %s = date, user making change
$hesklang['elocked']='Ez a hibajegy lezárva vagy törölve.';
$hesklang['nti2']='Helyezzen be új hibajegyet';
$hesklang['nti3']='Ezzel az űrlappal új hibajegyet hozhat létre az ügyfél nevében. Írja be az űrlapba az <i> ügyfél </i> adatokat (ügyfél neve, ügyfél e-mail címe, ...), és NEM a nevét! A hibajegy úgy készül, mintha az ügyfél nyújtotta volna be.';
$hesklang['addop']='Opciók';
$hesklang['seno']='Értesítés küldése e-mailben az ügyfélnek';
$hesklang['otas']='Megjeleníti a hibajegyet beküldés után';
$hesklang['notn']='Értesítések';
$hesklang['nomw']='A ügyfélszolgálat e-mail értesítést küld, ha:';
$hesklang['nwts']='Új hibajegyet küldtek be a tulajdonosával:';
$hesklang['ncrt']='Az ügyfél válaszol egy hibajegyre a tulajdonosával:';
$hesklang['ntam']='Hibajegyet rendelnek hozzám';
$hesklang['npms']='Privát üzenetet küldtek nekem';
$hesklang['support_remove']='Sok idő és erőfeszítés fordult a HESK fejlesztésére. Támogassa a HESK-t egy licenc megvásárlásával, amely eltávolítja a kredit linkeket <i> Powered by Help Desk Software HESK </i> a helpdeskből ';
$hesklang['ycvtao']='Nem nézheted meg a másoknak kijelölt hibajegyeket';
$hesklang['password_not_valid']='A jelszónak legalább 5 karakter hosszúnak kell lennie';
$hesklang['lkbs']='Tudásbázis-javaslatok betöltése ...';
$hesklang['auto']='(automatikusan)';

// Added in version 2.3
$hesklang['unknown']='Ismeretlen';
$hesklang['pcer']='Kérjük, javítsa ki a következő hibákat:';
$hesklang['seqid']='Hibajegy száma';
$hesklang['close_action']='Megjelölés megoldottként'; // Close ACTION
$hesklang['archived']='Címkézve';
$hesklang['archived2']='Címkézett hibajegy';
$hesklang['add_archive']='Jelölje meg a hibajegyet';
$hesklang['add_archive_quick']='Kijelölt hibajegyek cimkézése';
$hesklang['remove_archive']='Vegye fel a hibajegy címkéjét';
$hesklang['remove_archive_quick']='Kijelölt hibajegyek címkézésének megszüntetése';
$hesklang['added_archive']='Hibajegy címkézve';
$hesklang['removed_archive']='Hibajegy nem címkézve';
$hesklang['added2archive']='A hibajegyet felcímkézték';
$hesklang['removedfromarchive']='A hibajegy nem lett jelölve';
$hesklang['num_tickets_tag']='<b>% d </b> hibajegyet megcímkéztek';
$hesklang['num_tickets_untag']='<b> <b>% d </b> hibajegy megjelölve';
$hesklang['can_add_archive']='Felcímkézheti a hibajegyeket';
$hesklang['disp_only_archived']='Csak címkével ellátott hibajegyek';
$hesklang['search_only_archived']='Csak címkével ellátott hibajegyek';
$hesklang['critical']='Kritikus';
$hesklang['thist8']='<li class="smaller"> %s | a prioritás %s-ra változott %s által</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class = "smaller"> %s | az állapot %s-ra változott %s által </li> '; // %s = date, new status, user making change
$hesklang['thist10']='<li class = "smaller"> %s | automatikusan hozzárendelve a következőhöz: %s </li> '; // %s = date, user making change
$hesklang['thist11']='<li class = "smaller"> %s | e-mail útján küldött </li> '; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='ÉV';
$hesklang['abbr']['month']='HÓ';
$hesklang['abbr']['week']='HÉT';
$hesklang['abbr']['day']='NAP';
$hesklang['abbr']['hour']='ÓRA';
$hesklang['abbr']['minute']='P';
$hesklang['abbr']['second']='MP';
// END abberviations
$hesklang['cnsm']='A hívás nem küldte el az üzenetet a következőnek:';
$hesklang['yhbb']='Túl sok bejelentkezési hiba miatt %s percre bezárta a rendszert.';
$hesklang['pwdst']='Jelszó erőssége';
$hesklang['tid_mail']='Semmi gond! Írja be az <b> e-mail címét </b>, és azonnal elküldjük a követési azonosítóját: ';
$hesklang['rem_email']='Emlékezzem az e-mail címemre';
$hesklang['eytid']='Adja meg a hibajegykövetési azonosítóját.';
$hesklang['enmdb']='A megadott e-mail cím nem egyezik meg ezzel a hibajegyazonosítóval az adatbázisban találhatóval.';
$hesklang['confemail']='E-mail megerősítése';
$hesklang['confemail2']='Kérjük, erősítse meg e-mail címét';
$hesklang['confemaile']='A két e-mail cím nem azonos';
$hesklang['taso3']='Hozzárendelve:';
$hesklang['sec_enter']='Írja be az alábbi képen látható számokat.';
$hesklang['reload']='Kép újratöltése';
$hesklang['verify_q']='SPAM védelem:'; // For anti-spam question
$hesklang['verify_i']='SPAM védelem:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Üdvözlünk! Kérjük jelentkezzen be.';
$hesklang['vrfy']='A teszt sikeres volt';
$hesklang['last_update']='Frissítve';
$hesklang['cot']='Ne erőltesse a kritikus hibajegyeket a tetején';
$hesklang['def']='Legyen ez az alapértelmezett nézetem';
$hesklang['gbou']='Ezek a hibajegyek <b> nincsenek kijelölve </b>:';
$hesklang['gbom']='A <b> nekem </b> rendelt hibajegyek:';
$hesklang['gboo']='A (z) <b> %s </b> címhez rendelt hibajegyek:';
$hesklang['select']='- - Klikk a kiválasztáshoz - -';
$hesklang['chngstatus']='Állapot módosítása';
$hesklang['perat']='Az összes hibajegy  %s'; // Will change to "23% of all tickets"
$hesklang['viewart']='A cikk megtekintése';
$hesklang['chdp']='Kérjük, módosítsa az alapértelmezett jelszót a <a href="profile.php"> Profil </a> oldalon!';
$hesklang['chdp2']='Változtassa meg a jelszavát, az alapértelmezettet használja!';
$hesklang['security']='Biztonság';
$hesklang['kb_i_art']='Új cikk';
$hesklang['kb_i_art2']='Cikk beszúrása';
$hesklang['kb_i_cat']='Új kategória';
$hesklang['kb_i_cat2']='Kategória beszúrása';
$hesklang['gopr']='Tudástár megtekintése';
$hesklang['kbstruct']='Tudásbázis-szerkezet';
$hesklang['cancel']='Mégse';
$hesklang['sh']='Üzenet elrejtése';
$hesklang['goodkb']='Hogyan lehet jó tudásbázis cikkeket írni?';
$hesklang['catset']='Kategória beállításai';
$hesklang['inpr']='Válassza ki az új prioritást';
$hesklang['incat']='Válassza ki az új kategóriát';
$hesklang['instat']='Válassza ki az új állapotot';
$hesklang['tsst']='A hibajegy státusát  %s értékre állítottuk';
$hesklang['aass']='Automatikus hozzárendelés';
$hesklang['aaon']='A hibajegyek automatikus hozzárendelése engedélyezve (kattintson a letiltáshoz)';
$hesklang['aaoff']='A hibajegyek automatikus hozzárendelése letiltva (kattintson az engedélyezéshez)';
$hesklang['uaaon']='Az automatikus hozzárendelés engedélyezve van a kiválasztott felhasználó számára';
$hesklang['uaaoff']='Az automatikus hozzárendelés ki van kapcsolva a kiválasztott felhasználó számára';
$hesklang['taasy']='Ezt a hibajegy automatikusan hozzárendelve';
$hesklang['can_view_unassigned']='Megtekintheti a kiosztatlan hibajegyeket';
$hesklang['ycovtay']='Csak a hozzád rendelt hibajegyeket nézheted meg';
$hesklang['in_progress']='Folyamatban';
$hesklang['on_hold']='Felfüggesztve';
$hesklang['import_kb']='Importálja ezt a hibajegyet egy Tudásbázis cikkbe';
$hesklang['import']='<i> privát hibajegyet </i> importál egy <i> nyilvános cikkbe </i>. <br /> <br /> Ügyeljen arra, hogy töröljön minden privát vagy bizalmas információt információk a cikk tárgyából és az üzenetből! ';
$hesklang['tab_1']='Általános';
$hesklang['tab_2']='Help Desk';
$hesklang['tab_3']='Tudástár';
$hesklang['tab_4']='Egyéni mezők';
$hesklang['tab_5']='Egyéb';
$hesklang['disable']='Letiltás';
$hesklang['dat']='Dátum és amp; Idő';
$hesklang['lgs']='Nyelv';
$hesklang['onc']='BE - Ügyfelek';
$hesklang['ons']='BE - Mindenki';
$hesklang['viewvtic']='Hibajegyek megtekintése';
$hesklang['reqetv']=' Hibajegy megtekintéséhez, e-mail szükséges';
$hesklang['banlim']='Bejelentkezési kísérletek korlátja';
$hesklang['banmin']='Kitiltási idő (perc)';
$hesklang['subnot']='Értesítés elküldése';
$hesklang['subnot2']='Értesítés megjelenítése a hibajegyet leadó ügyfeleknek';
$hesklang['eseqid']='Szekvenciális azonosítók';
$hesklang['sconfe']='E-mail megerősítése';
$hesklang['saass']='Hibajegyek automatikus hozzárendelése';
$hesklang['swyse']='WYSIWYG szerkesztő';
$hesklang['hrts']='HESK értékelése';
$hesklang['hrts2']='Show A parancsfájl hivatkozásának értékelése az admin panelen';
$hesklang['emlpipe']='E-mail küldése';
$hesklang['emlsend2']='Email küldése a következő használatával';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP szerver';
$hesklang['smtph']='SMTP  kiszolgáló';
$hesklang['smtpp']='SMTP port';
$hesklang['smtpu']='SMTP felhasználónév';
$hesklang['smtpw']='SMTP jelszó';
$hesklang['smtpt']='SMTP időtúllépés';
$hesklang['other']='Egyéb';
$hesklang['features']='Funkciók';
$hesklang['can_view_online']='Megtekintheti az online munkatársakat';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Online felhasználók'; // For display in footer
$hesklang['sonline']='Online felhasználók'; // For settings page
$hesklang['sonline2']='Online felhasználók megjelenítése. Korlát (perc): '; // For settings page
$hesklang['gb']='Csoportosítva';
$hesklang['dg']='Nem csoportosítva';
$hesklang['err_dpi']='Az adatbázis: %s nem tartalmaz minden HESK táblát %s előtaggel, változás nem lett mentve.';
$hesklang['err_dpi2']='Táblák nem találhatók:';
$hesklang['sme']='SMTP hiba';
$hesklang['scl']='SMTP csatlakozás napló';
$hesklang['dnl']='Letöltés';
$hesklang['dela']='Ez a csatolmány törlése';
$hesklang['pda']='Véglegesen törölni kívánja ezt a csatolmányt?';
$hesklang['thist12']='<li class = "smaller"> %s |  %s mellékletet törölte: %s </li> '; // %s = date, deleted attachment, user making change
$hesklang['mopt']='További lehetőségek';
$hesklang['lopt']='Kevesebb lehetőség';
$hesklang['meml']='Több e-mail';
$hesklang['meml2']='Ügyfelek több email kapcsolatot is beírhatnak';

// Added in version 2.4
$hesklang['catd']='(kategória törölve)';
$hesklang['noopen']='Erre az e-mail címre nem található nyitott hibajegy.';
$hesklang['maxopen']='Elérte a maximális nyitott hibajegyek számát (%d / %d). Kérjük várjon, amíg a meglévő hibajegyek megodlásra kerülnek, mielőtt újat nyit.';
$hesklang['ntnote']='Valaki megjegyzést írt egy hibajegyhez, ami hozzám van rendelve';
$hesklang['cat_public']='Nyilvános';
$hesklang['cat_private']='Privát';
$hesklang['cat_aa']='Ebben a kategóriában a hibajegyek automatikus hozzárendelése.';
$hesklang['cat_type']='Típus';
$hesklang['caaon']='Kiválasztott kategóriára az automatikus hozzárendelés bekapcsolva';
$hesklang['caaoff']='Kiválasztott kategóriára az automatikus hozzárendelés kikapcsolva';
$hesklang['cpub']='Kategória módosítva PUBLIKUS-ra';
$hesklang['cpriv']='Kategória módosítva PRIVÁT-ra';
$hesklang['cpric']='Ügyfelek nem választhatnak privát kategóriákat, csak a munkatársak!';
$hesklang['user_aa']='Automatikus hibajegy hozzárendelés ehhez a felhasználóhoz.';
$hesklang['attach_size']='Maximális fájlméret';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='byte';
$hesklang['kilobytes']='kilobyte';
$hesklang['megabytes']='megabájt';
$hesklang['gigabytes']='gigabájt';
$hesklang['smtpssl']='SSL protokoll';
$hesklang['smtptls']='TLS protokoll';
$hesklang['oo']='Csak megnyitható';
$hesklang['ool']='Csak a nyitott hibajegyek listázása az &quot;Elfelejtett követő ID&quot; emailben';
$hesklang['mop']='Max. nyitott hibajegyek';
$hesklang['rord']='Válaszolási sorrend';
$hesklang['newbot']='Legfrissebb válasz alul';
$hesklang['newtop']='Legfrissebb válasz a tetején';
$hesklang['ford']='Válasz űrlap';
$hesklang['formbot']='Az űrlap megjelenítése alul';
$hesklang['formtop']='Az űrlap megjelenítése a tetején';
$hesklang['mysqlv']='MySQL verzió';
$hesklang['phpv']='PHP verzió';
$hesklang['csrt']='Jelenlegi HESK idő:';
$hesklang['listp']='Privát cikkek felsorolása';
$hesklang['listd']='Cikkvázlatok felsorolása';
$hesklang['artp']='Magáncikkek';
$hesklang['artd']='Cikkvázlatok';
$hesklang['kb_no_part']='Nincsenek privát cikkek a tudásbázisban.';
$hesklang['kb_no_dart']='Nincs cikk piszkozat a tudásbázisban.';
$hesklang['attpri']='Nincs hozzáférése ehhez a csatolmányhoz.';
$hesklang['can_merge_tickets']='Hibajegyek egyesítése';
$hesklang['mer_selected']='Kijelölt hibajegyek egyesítése';
$hesklang['merged']='Kijelölt hibajegyek összevonva.';
$hesklang['merge_err']='Hiba történt a hibajegyek összevonásakor:';
$hesklang['merr1']='válasszon ki legalább két hibajegyet.';
$hesklang['merr2']='cé hibaljegy nem található.';
$hesklang['merr3']='ez egy hibajegy, amelyik kategóriához nincs hozzáférése.';
$hesklang['tme']='%s hibajegy összevonva (%s) hibajeggyel.';
$hesklang['tme1']='%s hibajegy összevonva %s hibajeggyel';
$hesklang['tme2']='A %s hibajegyhez való hozzáféréshez írja be a hozzávaló email címet.';
$hesklang['eyou']='Használja a Profil oldalt a beállításai módosításához.';
$hesklang['npea']='Nincs jogosultsága ennek a felhasználónak módosításához.';
$hesklang['duplicate_user']='Ez a felhasználónév már létezik, kérjük válasszon egy másikat.';
$hesklang['kw']='Kulcsszavak';
$hesklang['kw1']='(opcionális - szóközzel, vesszővel vagy új sorral elválasztva)';
$hesklang['type_not_allowed']='Fájlok <b>%s</b> kiterjesztéssel nem megengedettek (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Az ügyfél még nem olvasta el ezt a választ.';
$hesklang['sticky']='Ez a cikk legyen &quot;Ragadós&quot;';
$hesklang['stickyon']='Cikk változtatása &quot;Ragadós&quot;-ra';
$hesklang['stickyoff']='Cikk változtatása &quot;Normál&quot;-ra';
$hesklang['ason']='Cikk megjelölve &quot;Ragadós&quot;-nak';
$hesklang['asoff']='Cikk megjelölve &quot;Normál&quot;-nak';
$hesklang['ts']='Ledolgozott idő';
$hesklang['start']='Start / Stop';
$hesklang['reset']='Ujrakezd';
$hesklang['save']='Ment';
$hesklang['hh']='Óra';
$hesklang['mm']='Perc';
$hesklang['ss']='Másodperc';
$hesklang['thist']='Hibajegy előzmények';
$hesklang['thist13']='<li class = "smaller"> %s |  %s a %s jeggyel egyesült: %s </li> '; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class = "smaller"> %s | a ledolgozott idő %s-ra frissítve %s-ra %s </li> '; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class = "smaller"> %s | beküldte: %s </li> '; // %s = date, user making change
$hesklang['thist16']='<li class = "smaller"> %s | beküldte a POP3 lekérésével </li> ';
$hesklang['twu']='A hibajegyen ledolgozott idő frissült.';
$hesklang['autoss']='Automatikusan indítsa az időzítőt, amikor megnyitom a hibajegyet';
$hesklang['ful']='Fájl feltöltési korlátok';
$hesklang['ufl']='Fájlokat tölthet fel a következő kiterjesztésekkel:';
$hesklang['nat']='A mellékletek maximális száma:';
$hesklang['mfs']='Mellékletenként maximális méret:';
$hesklang['lps']='Nyelvi beállítások elmentetve';
$hesklang['sav']='Cikknézetek megjelenítése';
$hesklang['sad']='A cikk dátumának megjelenítése';
$hesklang['emp']='Az Ön PHP-jében nincs engedélyezve a MySQL támogatás (mysqli kiterjesztés szükséges)';
$hesklang['epd']='[HESK] A BEÁLLÍTÁSOKBAN EMAIL PIPING KIKAPCSOLVA';
$hesklang['pfd']='[HESK] A BEÁLLÍTÁSOKBAN POP3 LETÖLTÉS KIKAPCSOLVA';
$hesklang['pem']='[Átadott e-mail]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Ügyfél]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-mail';
$hesklang['pop3']='POP3 Letöltés';
$hesklang['pop3h']='POP3 zerver';
$hesklang['pop3p']='POP3 Port';
$hesklang['pop3tls']='TLS Protokoll';
$hesklang['pop3u']='POP3 Felhasználónév';
$hesklang['pop3w']='POP3 Jelszó';
$hesklang['pop3e']='POP3 Hiba';
$hesklang['pop3log']='POP3 Csatlakozási napló';
$hesklang['mysqltest']='Tesztelje a MySQL kapcsolatot';
$hesklang['smtptest']='SMTP-kapcsolat tesztelése';
$hesklang['pop3test']='Tesztelje a POP3 kapcsolatot';
$hesklang['contest']='A kapcsolat tesztelése, ez eltarthat egy ideig ...';
$hesklang['conok']='A kapcsolat sikeres!';
$hesklang['conokn']='Nem küldünk e-mailt ha a szerver felhasználónevet és jelszót igényel!';
$hesklang['saving']='Beállítások mentése, kérem várjon ...';
$hesklang['sns']='A beállítások mentésre kerültek, de a sikertelen tesztek miatt egyes funkciók tiltva lettek.';
$hesklang['looph']='Max találatok';
$hesklang['loopt']='Időkeret';
$hesklang['didum']=' %s-t akart írni?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Igen, javítás';
$hesklang['nole']='Nem, maradjon';
$hesklang['sconfe2']='&quot;Email megerősítés&quot; mező mutatása a hibajegy űrlapon';
$hesklang['oln']='Régi név:';
$hesklang['nen']='Új név:';
$hesklang['use_form_below']='<i> Ezen az űrlapon nyújthat be támogatási kérelmet. Kötelező mezők megjelölve: </i> ';
$hesklang['esf']='Nem sikerült e-mail értesítéseket küldeni.';
$hesklang['qrr']='(idézett válasz eltávolítva)';
$hesklang['remqr']='Idézett válasz eltávolítása';
$hesklang['remqr2']='Idézett válasz törlése az ügyfél e-mailjeiből';
$hesklang['suge']='E-mail elírások észlelése';
$hesklang['epro']='E-mail szolgáltatók';
$hesklang['email_noreply']='&laquo; Feladó: &raquo; email';
$hesklang['email_name']='&laquo; Feladó: &raquo; név';
$hesklang['vscl']='Szerver konfiguráció korlátok';
$hesklang['fnuscphp']='A fájl feltöltése sikertelen volt, próbálkozzon kisebb fájllal vagy egyáltalán ne.';
$hesklang['redv']='alapértelmezett nézet visszaállítása';
$hesklang['fatte1']='A mellékletek száma "Bejegyzésenkénti szám" nagyobb, mint amit a szervered megenged! ';
$hesklang['fatte2']='A maximális mellékletméret nagyobb, mint amit a szervered megenged!';
$hesklang['fatte3']='A szerver nem engedélyez elég nagy bejegyzést, próbálja csökkenteni a mellékletek számát vagy a megengedett fájlméretet!';
$hesklang['embed']='Beágyazott fájlok';
$hesklang['embed2']='Beágyazott fájlok mentése mellékletként';
$hesklang['emrem']='(kép eltávolítva)';
$hesklang['hdemo']='(DEMÓBAN REJTETT)';
$hesklang['ddemo']='Sajnáljuk, ezt a funkciót DEMO módban letiltották!';
$hesklang['sdemo']='A változtatások mentése le van tiltva DEMO módban';
$hesklang['hud']='A HESK naprakész';
$hesklang['hnw']='Frissítés elérhető';
$hesklang['getup']='HESK frissítése';
$hesklang['updates']='Frissítések';
$hesklang['updates2']='A HESK frissítéseinek automatikus ellenőrzése.';

// Added in version 2.5.0
$hesklang['attdel']='Ezt a fájlt törölték a szerverről, és már nem lehet letölteni';
$hesklang['dsen']='Ne küldjön e-mailt erről a válaszról az ügyfélnek';
$hesklang['attrem']='* Néhány csatolt fájlt eltávolítottunk *';
$hesklang['attnum']='Elért maximális szám: %s'; // %s will show attachment name
$hesklang['attsiz']='A fájl túl nagy: %s'; // %s will show attachment name
$hesklang['atttyp']='A típus nem engedélyezett: %s'; // %s will show attachment name
$hesklang['adf']='Rendszergazda mappa';
$hesklang['atf']='Mellékletek mappa';
$hesklang['err_adf']='A kiválasztott admin mappa ( %s) nem létezik!'; // %s will show folder name
$hesklang['err_atf']='A kiválasztott mellékletmappa ( %s) nem létezik!'; // %s will show folder name
$hesklang['err_atr']='A kiválasztott mellékletmappa ( %s) nem írható!'; // %s will show folder name
$hesklang['fatt']='Az üzenethez csatolt fájlok:';
$hesklang['wrepo']='Kérjük, írjon választ, miután újra kinyitotta a hibajegyet.';
$hesklang['ktool']='Tudástár eszközei';
$hesklang['uac']='Ellenőrizze és frissítse a cikkcikkek számát';
$hesklang['acv']='A cikkek száma ellenőrizve';
$hesklang['xyz']='nyilvános, magán- és vázlatcikkek száma a kategóriában.';
$hesklang['reports_tab']='Jelentések futtatása'; // Tab title
$hesklang['can_run_reports_full']='Futtathat jelentéseket (minden)';
$hesklang['can_export']='Exportálhat hibajegyeket';
$hesklang['roo']='<i> (a jelentésben csak az Önhöz rendelt hibajegyek szerepelnek) </i>';
$hesklang['shu']='Rövid hivatkozások';
$hesklang['export']='Hibajegyek exportálása'; // Tab title
$hesklang['export_btn']='Hibajegyek exportálása'; // Button title
$hesklang['export_intro']='Ez az eszköz lehetővé teszi a hibajegyek exportálását az Excelben megnyitható XML táblázatokba.';
$hesklang['stte']='Exportálandó hibajegyek kiválasztása';
$hesklang['dtrg']='Dátumtartomány';
$hesklang['sequentially']='Egymás után'; // Order tickets: Sequentially
$hesklang['ede']='Nem lehet létrehozni az export könyvtárat, kérjük, manuálisan hozzon létre egy <b> export </b> nevű mappát a mellékletek mappájában, és győződjön meg arról, hogy a PHP írhatja (Linux CHMOD esetén 777-re - rwxrwxrwx).';
$hesklang['eef']='Nem lehet exportfájlt létrehozni, nincs engedélye az export könyvtárba írni.';
$hesklang['inite']='Exportálás inicializálása';
$hesklang['gXML']='XML fájl létrehozása';
$hesklang['nrow']='Exportált sorok száma:% d'; // %d will show number of rows exported
$hesklang['cZIP']='Fájl tömörítése Zip archívumba';
$hesklang['eZIP']='Hiba a Zip archívum létrehozásakor';
$hesklang['fZIP']='A fájl tömörítése befejeződött';
$hesklang['pmem']='Csúcs memóriahasználat:% .2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; Ide kattintva letöltheti az exportfájlt &laquo; ';
$hesklang['n2ex']='Nem található a feltételeknek megfelelő hibajegy, nem lehet exportálni!';
$hesklang['sp']='SPAM-megelőzés'; // For settings page
$hesklang['sit']='Képtípus';
$hesklang['sis']='Egyszerű kép';
$hesklang['rcpb']='Webhelykulcs';
$hesklang['rcpv']='Titkos kulcs';
$hesklang['pop3keep']='Másolat megőrzése';
$hesklang['beta']='(TESZTIVERZIÓ)';
$hesklang['maxpost']='Valószínűleg több adatot próbált elküldeni, mint amennyit ez a szerver elfogad. <br /> <br /> Kérjük, próbálja meg újra elküldeni az űrlapot kisebb vagy anélküli mellékletekkel.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Nem sikerült érvényesíteni a reCAPTCHA SPAM-védelmet.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] A hibajegy zárva / megoldva';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Ápr';
$hesklang['ms05']='Máj';
$hesklang['ms06']='jún';
$hesklang['ms07']='júl';
$hesklang['ms08']='Aug';
$hesklang['ms09']='Szep';
$hesklang['ms10']='Okt';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dec';
$hesklang['sdf']='Beküldött dátum formátum';
$hesklang['lcf']='Frissített dátum formátum';
$hesklang['lcf0']='Rövid leíró';
$hesklang['lcf1']='Dátum és idő';
$hesklang['lcf2']='HESK stílus';
$hesklang['ticket_tpl']='Hibajegy sablonok';
$hesklang['can_man_ticket_tpl']='Hibajegy sablonok kezelése'; // Permission title
$hesklang['ticket_tpl_man']='Hibajegy sablonok kezelése'; // Page and link title
$hesklang['ticket_tpl_intro']='Hozzon létre és szerkesszen olyan hibajegy sablonokat, amelyek segítségével gyorsan új hibajegyeket küldhet be az admin felületről.';
$hesklang['no_ticket_tpl']='Nincs hibajegy sablon';
$hesklang['ticket_tpl_title']='Cím';
$hesklang['delete_tpl']='Biztosan törli ezt a sablont?';
$hesklang['new_ticket_tpl']='Hibajegysablon hozzáadása vagy szerkesztése';
$hesklang['ticket_tpl_add']='Új hiba hibajegy sablon';
$hesklang['ticket_tpl_edit']='Kiválasztott hibajegy sablon szerkesztése';
$hesklang['save_ticket_tpl']='Hibajegy sablon mentése';
$hesklang['ticket_tpl_saved']='A hibajegy sablon elmentve későbbi használatra';
$hesklang['ticket_tpl_removed']='A kiválasztott hibajegy sablon eltávolításra került az adatbázisból';
$hesklang['ticket_tpl_not_found']='Hibajegy sablon nem található';
$hesklang['sel_ticket_tpl']='Válassza ki a szerkeszteni kívánt hibajegy sablonját';
$hesklang['ent_ticket_tpl_title']='Kérjük, írja be a sablon címét';
$hesklang['ent_ticket_tpl_msg']='Kérjük, írja be a sablonüzenetet';
$hesklang['ticket_tpl_id']='Hiányzó hibajegy sablonazonosító';
$hesklang['select_ticket_tpl']='Hibajegy sablon kiválasztása';
$hesklang['list_tickets_cat']='Sorolja fel az összes hibajegyet ebben a kategóriában';
$hesklang['def_msg']='[Nincs üzenet]';
$hesklang['emlreqmsg']='Üzenet szükséges';
$hesklang['emlreqmsg2']='Figyelmen kívül hagyja az üzenet nélkül küldött / letöltött e-maileket';
$hesklang['relart']='Kapcsolódó cikkek'; // Title of related articles box
$hesklang['s_relart']='Kapcsolódó cikkek'; // On settings page
$hesklang['tab_7']='Hibajegylista';
$hesklang['fitl']='Mezők ebben a hibajegy listában';
$hesklang['submitted']='Beküldve';
$hesklang['clickemail']='Megtekintés';
$hesklang['set_pri_to']='Prioritás beállítása:'; // Action below the ticket list
$hesklang['pri_set_to']='A prioritás beállítása:';
$hesklang['cat_pri']='A kategória prioritás lesz használva, amikor a ügyfélnek nincs engedélye a priorítás kiválasztására és hibajegy a ügyféli felületről került beküldésre.';
$hesklang['cat_pri_info']='A ügyfeleknek lehetősége van pirorítás választásra, a kategória priorítás figyelmen kívül hagyva.<br /><br />A kategória priorítás használatához, kapcsolja KI a következő funkciót a HESK beállításaiban:';
$hesklang['def_pri']='Kategória prioritása:';
$hesklang['ch_cat_pri']='Kategória prioritásának beállítása';
$hesklang['cat_pri_ch']='A kategória prioritása a következőre lett állítva:';
$hesklang['err_dbversion']='Túl régi MySQL verzió:';
$hesklang['ip_whois']='IP WHOIS';
$hesklang['ednote']='Jegyzet szerkesztése';
$hesklang['ednote2']='Megjegyzés: üzenet mentve';
$hesklang['perm_deny']='Engedély megtagadva';
$hesklang['mis_note']='Hiányzó jegyzet ID';
$hesklang['no_note']='Megjegyzés ezzel az azonosítóval nem található';
$hesklang['sacl']='Mentés és folytatás később';
$hesklang['reply_saved']='A válasz üzenete elmentve későbbre.';
$hesklang['submit_as']='Küldés:';
$hesklang['sasc']='Küldés ügyfélválaszként';
$hesklang['creb']='Az ügyfél válasza:';
$hesklang['show_select']='Megjelenítés &quot; Kattintson a &quot; alapértelmezett beállításként ';
// Settings
$hesklang['mms']='Karbantartási mód';
$hesklang['mmd']='Karbantartási mód engedélyezése';
// Customer notice
$hesklang['mm1']='Karbantartás folyamatban';
$hesklang['mm2']='Az ütemezett karbantartás elvégzése érdekében az ügyfélszolgálatunk ideiglenesen leállt.';
$hesklang['mm3']='Elnézést a kellemetlenségért, és kérjük, próbálkozzon újra később.';
// Staff notice
$hesklang['mma1']='A karbantartási mód aktív!';
$hesklang['mma2']='Az ügyfelek nem tudják használni a ügyfélszolgálatot.';
$hesklang['tools']='Eszközök';
$hesklang['banemail']='E-mailek letiltása';
$hesklang['banemail_intro']='Akadályozzuk meg, hogy bizonyos e-mail címek beküldjék a jegyeket az ügyfélszolgálathoz.';
$hesklang['no_banemails']='<i> Nincsenek letiltott e-mailek. </i>';
$hesklang['eperm']='Végleges e-mail tilalmak:';
$hesklang['bananemail']='Letiltandó e-mail cím';
$hesklang['savebanemail']='Letiltja ezt az e-mailt';
$hesklang['enterbanemail']='Írja be a kitiltani kívánt e-mail címet.';
$hesklang['validbanemail']='Adjon meg egy érvényes e-mail címet (<i> john.doe@example.com </i>) vagy e-mail tartományt (<i> @ example.com </i>)';
$hesklang['email_banned']='A <i> %s </i> e-mail címet betiltották, és a HESK már nem fogad el jegyeket erről a címről.'; // %s will be replaced with email
$hesklang['emailbanexists']='Az <i> %s </i> e-mail cím már tiltva van.'; // %s will be replaced with email
$hesklang['email_unbanned']='E-mail tilalom törölve';
$hesklang['banby']='Tiltotta';
$hesklang['delban']='Feloldás';
$hesklang['delban_confirm']='Törli ezt a tiltást?';
$hesklang['baned_e']='Önnek tiltott az új hibajegy beküldése.';
$hesklang['baned_ip']='Ön ki van tiltva erről az ügyfélszolgálatról';
$hesklang['can_ban_emails']='Letilthatja az e-maileket';
$hesklang['can_unban_emails']='Visszavonhatja az e-maileket (engedélyezheti az e-mailek betiltását)';
$hesklang['eisban']='Ez az e-mail cím tiltva van.';
$hesklang['click_unban']='Kattintson ide a bannolás megszüntetéséhez.';
$hesklang['banip']='IP címek tiltása';
$hesklang['banip_intro']='A tiltott IP-címekről érkező látogatók nem tekinthetik meg, nem küldhetik be a hibajegyeket, és nem tudnak bejelentkezni a help desk-be.';
$hesklang['ipperm']='Tartós IP-tiltások:';
$hesklang['iptemp']='Bejelentkezési hiba tilalma:';
$hesklang['savebanip']='Tiltsa ki ezt az IP címet';
$hesklang['no_banips']='<i> Nincs letiltott IP-cím. </i>';
$hesklang['bananip']='Letiltandó IP-cím';
$hesklang['banex']='Példák:';
$hesklang['iprange']='IP-tartomány';
$hesklang['ippermban']='Véglegesen tiltsa ki ezt az IP-címet';
$hesklang['enterbanip']='Írja be a tiltani kívánt IP-címet vagy tartományt.';
$hesklang['validbanip']='Érvényes IP-címet vagy IP-tartományt adjon meg';
$hesklang['ip_banned']='Az <i> %s </i> IP-címet letiltották, és a HESK már nem fogad el hibajegyeket erről az IP-címről.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Az <i> %s </i> IP-tartomány tiltva volt, és a HESK már nem fogad el hibajegyeket erről az IP-tartományról.'; // %s will be replaced with IP
$hesklang['ipbanexists']='Az <i> %s </i> IP-cím már tiltott.'; // %s will be replaced with IP
$hesklang['iprbanexists']='Az <i> %s </i> IP-tartomány már tiltott.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP-tiltás törölve';
$hesklang['ip_tempun']='Ideiglenes IP-tiltás törölve';
$hesklang['can_ban_ips']='Letilthatja az ips-t';
$hesklang['can_unban_ips']='Feloldhatja az ips-t (engedélyezi az ips letiltását)';
$hesklang['ipisban']='Ez az IP-cím tiltva van.';
$hesklang['m2e']='Lejár (perc)';
$hesklang['info']='Info';
$hesklang['sm_title']='Szolgáltatási üzenetek';
$hesklang['sm_intro']='Szolgáltatási üzenet megjelenítése az ügyfél területén, például az ismert problémák és fontos hírek értesítése érdekében.';
$hesklang['can_service_msg']='Szolgáltatási üzenetek szerkesztése';
$hesklang['new_sm']='Új szolgáltatási üzenet';
$hesklang['edit_sm']='Szolgáltatási üzenet szerkesztése';
$hesklang['ex_sm']='Meglévő szolgáltatási üzenetek';
$hesklang['sm_author']='Szerző';
$hesklang['sm_type']='Típus';
$hesklang['sm_published']='Közzétett';
$hesklang['sm_draft']='Piszkozat';
$hesklang['sm_style']='Stílus';
$hesklang['sm_none']='Nincs';
$hesklang['sm_success']='Siker';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Értesítés';
$hesklang['sm_error']='Hiba';
$hesklang['sm_save']='Mentés';
$hesklang['sm_preview']='Előnézet';
$hesklang['sm_mtitle']='Cím';
$hesklang['sm_msg']='Üzenet';
$hesklang['sm_e_title']='Adja meg a szolgáltatási üzenet címét';
$hesklang['sm_e_msg']='Szolgáltatási üzenet megadása';
$hesklang['sm_e_id']='Hiányzó üzenetazonosító';
$hesklang['sm_added']='Új szolgáltatási üzenet lett hozzáadva';
$hesklang['sm_deleted']='Szolgáltatási üzenet törölve';
$hesklang['sm_not_found']='Ez a szolgáltatási üzenet nem létezik';
$hesklang['no_sm']='Nincsenek szolgáltatási üzenetek';
$hesklang['del_sm']='Törli ezt a szolgáltatási üzenetet?';
$hesklang['sm_mdf']='A szolgáltatási üzenet mentve';
$hesklang['sska']='Javasolt cikkek megjelenítése';
$hesklang['taws']='Ezeket a cikkeket javasolták:';
$hesklang['defaults']='Alapértelmezések';
$hesklang['pncn']='Válassza az Ügyfél értesítése opciót az új hibajegy formában';
$hesklang['pncr']='Válassza ki az ügyfél értesítési opcióját a hibajegy bevallási űrlapon';
$hesklang['pssy']='Mutassa meg, milyen tudásbázis cikkeket javasoltak az ügyfeleknek';
$hesklang['ccct']='Ügyfél megoldása';
$hesklang['custnot']='Értesítés az ügyfelekről, amikor';
$hesklang['notnew']='Új támogatási hibajegy érkezik';
$hesklang['notclo']='A támogatási hibajegy meg van jelölve Megoldva';
$hesklang['enn']='Kivéve az e-mailekből származó hibajegyeket, ha az e-mail tárgya a következőket tartalmazza:';
$hesklang['spamn']='SPAM-értesítés';
$hesklang['spam_inbox']='<span style = "color: red"> <b> Nincs megerősítő e-mail? </b> <br /> Megerősítő üzenetet küldtünk az Ön e-mail címére. Ha néhány percen belül nem kapja meg, ellenőrizze a Szemét, Tömeges vagy Spam mappákat. Jelölje meg az üzenetet <b> Nem SPAM </b> néven, hogy elkerülje a későbbi levelezésünk fogadásának problémáit.';
$hesklang['ekb_n']='<b> NEM </b>, tiltsa le a Tudásbázist';
$hesklang['ekb_y']='<b> IGEN </b>, engedélyezze a Tudásbázist';
$hesklang['ekb_o']='<b> IGEN </b>, a HESK-t csak Tudásbázisként használja (<i> a help desk letiltása </i>)';
$hesklang['kb_set']='Tudásbázis beállításai';
$hesklang['kbo1']='Csak tudásbázis-mód';
$hesklang['kbo2']='<br /> <br /> A látogatók nem nyújthatnak be új támogatási hibajegyeket, és közvetlenül a tudásbázisba viszik őket.';
$hesklang['fpass']='Elfelejtette a jelszavát?';
$hesklang['passr']='Jelszó visszaállítása';
$hesklang['passa']='Elfelejtett jelszó visszaállítása e-mailben';
$hesklang['passe']='Írja be az e-mail címét';
$hesklang['passs']='Jelszó visszaállítása';
$hesklang['noace']='Nem található fiók ezzel az e-mail címmel';
$hesklang['pemls']='Küldtünk egy e-mailt a jelszó visszaállítására vonatkozó utasításokkal';
$hesklang['reset_password']='Állítsa vissza a ügyfélszolgálat jelszavát'; // Email subject
$hesklang['ehash']='Érvénytelen vagy lejárt jelszó-visszaállító link';
$hesklang['ehaip']='Rossz IP-cím. A jelszavakat csak a jelszó visszaállítását kérő IP-címről lehet visszaállítani. ';
$hesklang['resim']='<b> Állítsa be új jelszavát az alábbi űrlapon! </b>';
$hesklang['permissions']='Engedélyek';
$hesklang['atype']='Számlatípus';
$hesklang['astaff']='Személyzet';
$hesklang['oon1']='Csak nyitott hibajegyeket küldj nekem';
$hesklang['oon2']='Küldje el nekem az összes hibajegyemet';
$hesklang['anyown']='Bármely tulajdonos';
$hesklang['pfr']='Egy másik POP3 lekérési feladat még folyamatban van.';
$hesklang['pjt']='Feladat időkorlátja';
$hesklang['pjt2']='perc az indulás után';
$hesklang['nkba']='A Tudásbázis-kereséshez elegendő egyedi cikkre van szükség a megfelelő működéshez. <br /> <br /> Fontolja meg, hogy további cikkeket vegyen fel az ismeretterjesztő adatbázisba a keresési és cikkjavaslati eredmények javítása érdekében.';
$hesklang['saa']='A ragacsos cikkek a cikklista tetején jelennek meg';
$hesklang['yhbr']=' %s percre bezárták a rendszert, mert túl sok válasz érkezett egy hibajegyre.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='hu';

// Added in version 2.7.0
$hesklang['imap']='IMAP-lekérés';
$hesklang['imaph']='IMAP gazdagép';
$hesklang['imapp']='IMAP-port';
$hesklang['enc']='Titkosítás';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Nincs';
$hesklang['imapu']='IMAP felhasználónév';
$hesklang['imapw']='IMAP jelszó';
$hesklang['imaptest']='IMAP-kapcsolat tesztelése';
$hesklang['ifd']='A [HESK] IMAP FETCHING KI van tiltva a beállításokban';
$hesklang['iei']='A [HESK] PHP IMAP kiterjesztés nincs telepítve.';
$hesklang['ifr']='Egy másik IMAP-lekérési feladat még folyamatban van.';
$hesklang['arp']='Oldal automatikus újratöltése';
$hesklang['arpp']='Automatikusan újratölti az oldalt a hibajegylistákkal:';
$hesklang['seconds']='másodperc';
$hesklang['minutes']='perc';
$hesklang['atbr']='Ezt a hibajegyet ki kell rendelni, hogy megválaszolható legyen.';
$hesklang['attm']='Rendelje hozzám ezt a hibajegyet';
$hesklang['owneed']='Tulajdonosra van szükség';
$hesklang['taat']='Ez a hibajegy már hozzá van rendelve a következőhöz: <b> %s </b>.';
$hesklang['scoy']='Biztosan hozzárendeli magához?';
$hesklang['scot']='Biztosan hozzárendeli a következőhöz: %s?';
$hesklang['ycto']='IGEN, cserélj gazdát';
$hesklang['ncto']='NEM, a jelenlegi tulajdonos megtartása';
$hesklang['fass']='Tulajdonos megkövetelése';
$hesklang['req_sub']='Tárgy megkövetelése';
$hesklang['req_msg']='Üzenet igénylése';
$hesklang['req_email']='E-mail megkövetelése';
$hesklang['default_subject']='Hibajegy innen: %s';
$hesklang['off-hide']='Elrejtés ügyfél formában';
$hesklang['not_valid_email']='Adjon meg egy érvényes e-mail címet, vagy hagyja üresen ezt a mezőt';
$hesklang['write_down']='<span style = "color: red"> Javasoljuk, hogy írja le hibajegy-azonosítóját későbbi felhasználás céljából. </span>';
$hesklang['re_confirm1']='Ennek kikapcsolásával a "Biztonság" részben letiltja az "E-mail megkövetelése a hibajegyek megtekintéséhez" funkciót is. Folytassa?';
$hesklang['re_confirm2']='Ennek engedélyezésével engedélyezi a "Funkciók" alatt az "E-mail megkövetelése" lehetőséget is. Folytassa?';
$hesklang['can_email_tpl']='E-mail sablonok szerkesztése';
$hesklang['et_title']='E-mail sablonok';
$hesklang['et_intro']='Módosítsa a munkatársainak és az ügyfeleknek küldött e-maileket';
$hesklang['file']='Fájl';
$hesklang['efile']='Fájl szerkesztése';
$hesklang['rdesc']='Leírás';
$hesklang['desc_forgot_ticket_id']='(Ügyfél) Elfelejtett hibajegykövetési azonosító';
$hesklang['desc_new_reply_by_staff']='(Ügyfél) Új munkatárs válasza';
$hesklang['desc_new_ticket']='(Ügyfél) hibajegy beérkezett';
$hesklang['desc_ticket_closed']='(Ügyfél) hibajegy zárva / megoldva';
$hesklang['desc_category_moved']='(Személyzet) hibajegy új kategóriába került';
$hesklang['desc_new_reply_by_customer']='(Személyzet) Új ügyfélválasz';
$hesklang['desc_new_ticket_staff']='(Személyzet) Új hibajegy benyújtva';
$hesklang['desc_ticket_assigned_to_you']='(Személyzet) Hibajegyet rendeltek neked';
$hesklang['desc_new_pm']='(Személyzet) Új privát üzenet';
$hesklang['desc_new_note']='(Személyzet) Új jegyzet a hozzád rendelt hibajegyre';
$hesklang['desc_reset_password']='(Személyzet) Állítsa vissza a jelszavát';
$hesklang['etfm']='Egy vagy több e-mail sablon hiányzik. <br> Ügyeljen arra, hogy az összes e-mail sablonfájlt feltöltse a <i> / language / %s / emails </i> mappába.';
$hesklang['etfw']='Néhány e-mail sablon nem írható. <br>
                    Győződjön meg arról, hogy a PHP rendelkezik engedéllyel az összes fájlhoz az <i> / language / %s / emails </i> mappában. <br>
                    Unix kiszolgálókon előfordulhat, hogy CHMOD e-mail sablonokat kell 666-ra (rw-rw-rw-) ';
$hesklang['et_e_id']='Hiányzó sablonazonosító';
$hesklang['et_fm']='Hiányzik ez az e-mail sablonfájl';
$hesklang['et_fw']='Ez az e-mail sablonfájl nem írható';
$hesklang['et_save']='Változtatások mentése';
$hesklang['updated_on']='Frissítve';
$hesklang['ticket_url']='Hibajegy URL-je';
$hesklang['pm_url']='Privát üzenet URL-je';
$hesklang['et_num']='Hibajegyek száma';
$hesklang['et_list']='A támogatási hibajegyek listája';
$hesklang['et_empty']='Az e-mail sablon nem lehet üres';
$hesklang['et_saved']='E-mail sablon mentve';
$hesklang['source']='Forrás';
$hesklang['select_category']='Válasszon kategóriát';
$hesklang['select_category_text']='Miben segíthetünk?';
$hesklang['select_category_staff']='Hibajegy kategória kiválasztása';
$hesklang['scat']='Kategória választási korlát';
$hesklang['scat2']='(egy jelölőnégyzet akkor jelenik meg, ha a kategóriák száma nagyobb)';
$hesklang['new_cf']='Új egyéni mező';
$hesklang['cf_intro']='Ezzel a funkcióval egyéni mezőket adhat hozzá a Jegy elküldése űrlaphoz, hogy további adatokat gyűjthessen az ügyfelektől.';
$hesklang['cf_public']='Nyilvános';
$hesklang['cf_private']='Csak személyzet';
$hesklang['cf_cust']='Ügyfeleknek';
$hesklang['cf_all']='Mind';
$hesklang['cf_cat']='Kiválasztott';
$hesklang['cf_ctrl']='Tipp: tartsa lenyomva a CTRL billentyűt több kategória kiválasztásához';
$hesklang['visibility']='Láthatóság';
$hesklang['cf_save']='Egyéni mező mentése';
$hesklang['ex_cf']='Aktív egyéni mezők';
$hesklang['no_cf']='Nincs aktív egyéni mező';
$hesklang['del_cf']='Törli ezt az egyéni mezőt? Ezzel az összes mentett egyéni mezőadatot is törli az adatbázisból! ';
$hesklang['cf_e_id']='Érvénytelen azonosító';
$hesklang['edit_cf']='Egyéni mező szerkesztése';
$hesklang['cf_deleted']='Az egyéni mező törölve';
$hesklang['cf_not_found']='Ez az egyéni mező nem létezik';
$hesklang['cf_added']='Új egyéni mező került hozzá';
$hesklang['cf_nocat']='Válasszon legalább egy kategóriát ehhez az egyéni mezőhöz';
$hesklang['cf_mdf']='Az egyéni mező mentve';
$hesklang['atl1']='Írjon be legalább egy opciót.';
$hesklang['sch']='Rejtett';
$hesklang['meml3']='Több e-mail megadásának engedélyezése';
$hesklang['dmin']='Minimálisan elfogadott dátum';
$hesklang['dmax']='Maximális elfogadott dátum';
$hesklang['d_day']='nap (ok)';
$hesklang['d_week']='hét (ek)';
$hesklang['d_month']='hónap (ok)';
$hesklang['d_year']='év (ek)';
$hesklang['d_any']='Bármely dátum';
$hesklang['d_fixed']='Javított dátum';
$hesklang['d_relative']='Relatív dátum';
$hesklang['d_mm']='A minimális dátum nem lehet magasabb, mint a maximális dátum';
$hesklang['d_emin']='A <i> %s </i> minimális dátuma %s';
$hesklang['d_emax']='A <i> %s </i> maximális dátuma %s';
$hesklang['d_format']='Dátum megjelenítési formátum';
$hesklang['d_custom']='Egyéni formátum';
$hesklang['d_ci']='CSAK FEJLETT FELHASZNÁLÓK: érvényes PHP dátumformátum, lásd a PHP kézikönyvét.';
$hesklang['cf_noe']='Adjon meg egy érvényes e-mail címet a <i> %s </i> mezőbe';
$hesklang['cf_noem']='Írjon be egy vagy több érvényes e-mail címet a <i> %s </i> mezőbe';
$hesklang['can_resolve']='Megoldhatja a hibajegyeket';
$hesklang['can_change_own_cat']='Hibajegy kategória módosítása (engedélyezettre)';
$hesklang['can_submit_any_cat']='Jegyeket beküldhet bármely kategóriába';
$hesklang['noauth_submit']='Ön nem jogosult hibajegyeket küldeni ebbe a kategóriába!';
$hesklang['noauth_move']='Ön nem jogosult hibajegyeket áthelyezni ebbe a kategóriába!';
$hesklang['noauth_resolve']='Ön nem jogosult a hibajegyek felbontására!';
$hesklang['force_ssl']='SSL-kapcsolatok kényszerítése';
$hesklang['d_ssl']='<i>kikapcsolva</i> - nyissa meg ezt az oldalt https://-sel ennek a lehetőségnek a kezeléséhez';
$hesklang['scno']='Ezt az állapotot nem lehet megváltoztatni';
$hesklang['statuses']='Állapotok';
$hesklang['statuses_intro']='Használja ezt az eszközt egyéni hibajegyállapotok hozzáadásához a ügyfélszolgálathoz';
$hesklang['color']='Szín';
$hesklang['csscl']='CSS osztály vagy szín';
$hesklang['clr_view']='Színes előnézet a szövegen';
$hesklang['cbc']='Az ügyfelek megváltoztathatják';
$hesklang['ccc']='Megváltoztathatják az ügyfelek ezt az állapotot?';
$hesklang['del_status']='Törli ezt az állapotot?';
$hesklang['ex_status']='Meglévő állapotok';
$hesklang['status_hesk']='Beépített állapotok (itt nem lehet módosítani)';
$hesklang['status_custom']='Egyéni állapotok';
$hesklang['status_custom_none']='Nincsenek egyéni állapotok. A fenti "Új egyéni állapot" gombra kattintva hozzáadhatja őket. ';
$hesklang['status_save']='Mentés';
$hesklang['list_tkt_status']='Sorolja fel az összes ilyen állapotú hibajegyet';
$hesklang['new_status']='Új egyéni állapot';
$hesklang['edit_status']='Egyéni állapot szerkesztése';
$hesklang['err_status']='Írja be az állapot nevét';
$hesklang['status_added']='Új egyéni állapot került hozzá';
$hesklang['status_e_id']='Érvénytelen azonosító';
$hesklang['status_mdf']='Az egyéni állapot mentve';
$hesklang['status_deleted']='Az egyedi állapot törölve';
$hesklang['status_not_found']='Ez az egyedi állapot nem létezik';
$hesklang['status_not_empty']='Ez az állapot nem távolítható el, mert léteznek ilyen állapotú hibajegyek';
$hesklang['status_limit']='100 egyéni állapota van, nem hozható létre új.';
$hesklang['public_link']='Nyilvános link';
$hesklang['frames']='Keretek';
$hesklang['frames2']='Meggátolja, hogy a HESK-et külső domainen keretben betölhető legyen';
$hesklang['numsub']='Beküldött hibajegyek';
$hesklang['hidf']='A rejtett bemenetek nem láthatók az ügyfelek számára a hibajegy elküldése űrlapon (az érték továbbra is látható lesz a hibajegy részleteinek oldalán, ha nyilvánosak). Az alkalmazottak normál szövegmezőként viselkednek.';
$hesklang['rcheck']='Ne válasszon alapértelmezett beállítást';
$hesklang['refresh_page']='Az oldal frissítése';
$hesklang['del_kba']='A cikk törlése';
$hesklang['del_kbaa']='A cikk végleges törlése';
$hesklang['hni1']='A HESK még nincs telepítve?';
$hesklang['hni2']='Úgy tűnik, hogy ez a help desk még nincs megfelelően telepítve és konfigurálva.';
$hesklang['hni3']='A HESK telepítéséhez kövesse a <a class="link" href="docs/"> utasításokat a dokumentációban </a>';
$hesklang['cf']='Gyorsítótár mappa';
$hesklang['e_cdir']='A Hesk csak akkor tudja elemezni az e-maileket vagy a gyorsítótár eredményeit, ha a cache mappa létezik és írható.';
$hesklang['step1']='1. lépés';
$hesklang['step2']='2. lépés';
$hesklang['dffs']='A letöltés befejeztével törölje a fájlt a szerverről';
$hesklang['fd']='A szerverről törölt fájl exportálása';

// Added in version 2.8.0
$hesklang['TZ']='Időzóna';
$hesklang['thist17']='<li class = "smaller"> %s | az IMAP lekérésével küldte be </li> ';
$hesklang['sir3']='Láthatatlan reCAPTCHA';
$hesklang['invisible']='láthatatlan';
$hesklang['imap_not']='A PHP nem IMAP támogatással van lefordítva';
$hesklang['imap_warning']='A (z)%1$s felhasználónak ugyanaz az e-mail címe, mint az Ön IMAP-lekérő e-mail címének:%2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='A (z)%1$s felhasználónak ugyanaz az e-mail címe, mint a POP3 e-mail címének:%2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Ez e-mail ciklust eredményezhet, ahol új hibajegyek készülnek a felhasználói e-mail értesítésekből. Az e-mail címének egyedinek kell lennie, és senki más nem használhatja. ';
$hesklang['can_view_ass_by']='Megtekintheti a másoknak kijelölt hibajegyeket';
$hesklang['can_privacy']='Anonimizálhatja a hibajegyeket';
$hesklang['confirm_anony']='Anonimizálja ezt a hibajegyet';
$hesklang['anon_selected']='Kijelölt hibajegyek névtelenítése';
$hesklang['privacy_anon_info']='Távolítson el minden személyazonosításra alkalmas adatot és tartalmat a hibajegyekből (ügyfélnév, e-mail, üzenet, mellékletek, IP ...), de a hibajegyeket statisztikákként őrizze meg az adatbázisban (jogot elfelejteni).';
$hesklang['success_anon']='A hibajegy sikeresen névtelenített';
$hesklang['num_tickets_anon']='Névtelen hibajegyek száma: <b>% d </b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Ügyfél]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Tárgy]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Üzenet]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class = "smaller"> %s |  %s névtelenítette </li> ';
$hesklang['print_selected']='Kijelölt hibajegyek nyomtatása';
$hesklang['with_selected']='Kiválasztva:';
$hesklang['assign_selected']='Kiválasztott hozzárendelése:';
$hesklang['assign_no']='Nincs kiválasztva tulajdonos, nincs változtatás';
$hesklang['assign_1']='A kijelölt hibajegyek beállítása Nincs hozzárendelve.';
$hesklang['assign_2']='A (z)%1$s hibajegyazonosító nincs hozzárendelve'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s hiba: már hozzárendelve a következőhöz:%2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s hozzárendelve%2$s-hoz'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s hiba:%2$s nem fér hozzá a jegy kategóriájához'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Tömeges jegy hozzárendelés eredménye: <br /> <br /> Hozzárendelve:%1$s <br /> Hibák:%2$s <br /> <br /> Napló: <br /> <pre>% 3 $ s </pre> '; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP-cím';
$hesklang['moret']='További lehetőségek'; // More options button title
$hesklang['btn_more']='Több'; // More options button text
$hesklang['btn_print']='Nyomtatás';
$hesklang['btn_edit']='Szerkesztés';
$hesklang['btn_lock']='Hibajegy zárolása';
$hesklang['btn_unlock']='Hibajegy feloldása';
$hesklang['btn_tag']='Hibajegy címkézése';
$hesklang['btn_resend']='Értesítés újraküldése';
$hesklang['btn_untag']='Hibajegy visszavonása';
$hesklang['btn_import_kb']='Importálás a Tudásbázisba';
$hesklang['btn_anony']='Hbajegy anonimizálása';
$hesklang['btn_delt']='Hibajegy törlése';
$hesklang['btn_delr']='Válasz törlése';
$hesklang['ernf']='A válasz nem található';
$hesklang['tns']='Hibajegy értesítő újra elküldve';
$hesklang['rns']='Válasz értesítő újra elküldve';
$hesklang['fname']='Keresztnév';
$hesklang['export_selected']='Kijelölt hibajegyek exportálása';
$hesklang['btn_export']='XML (Excel) exportálás';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Válaszok';
$hesklang['team']='Csapat';
$hesklang['sm_content']='Tartalom';
$hesklang['sm_settings']='Beállítások';
$hesklang['wizard_back']='Vissza'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Következő'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Ugrás a Beállításokra';
$hesklang['sm_return_to_editing']='Vissza a szerkesztéshez';
$hesklang['email_tpl_title']='Cím';
$hesklang['edit_email_template']='E-mail sablon szerkesztése';
$hesklang['err_no_settings_section']='Nincs beállítási szakasz.';
$hesklang['this_field_is_required']='Ezt a mezőt kötelező kitölteni';
$hesklang['reset_your_password']='Jelszó visszaállítása';
$hesklang['reset_password_instructions']='Kérjük, töltse ki az alábbi űrlapot. Küldünk egy linket, ahol visszaállíthatja jelszavát. ';
$hesklang['enter_email']='E-mail megadása';
$hesklang['password_reset_check_your_email']='Ellenőrizze az e-mailt';
$hesklang['password_reset_link_sent']='Linket küldtünk a jelszó visszaállításához.';
$hesklang['back_to_login']='Vissza a bejelentkezéshez';
$hesklang['pager_first']='Első';
$hesklang['pager_previous']='Előző';
$hesklang['pager_next']='Következő';
$hesklang['pager_last']='Utolsó';
$hesklang['new_team_member']='Új csapattag';
$hesklang['role']='Szerep';
$hesklang['optional']='Nem kötelező';
$hesklang['edit_profile']='Profil szerkesztése';
$hesklang['assigned_to']='Hozzárendelve:';
$hesklang['contact']='Kapcsolat';
$hesklang['unban_email']='Az e-mail letiltása';
$hesklang['unban_ip']='Unban this IP';
$hesklang['show_previous_replies']='Korábbi válaszok megjelenítése';
$hesklang['type_your_message']='Írja be az üzenetét'; // Used when there are no canned responses
$hesklang['close_button_text']='Bezár';
$hesklang['create_new_ticket']='Új hibajegy létrehozása';
$hesklang['delete_article']='Cikk törlése';
$hesklang['view_existing_tickets']='Meglévő jegyek megtekintése';
$hesklang['how_can_we_help']='Üdvözlöm, miben tudunk segíteni?';
$hesklang['search_for_articles']='Cikkek keresése';
$hesklang['submit_a_support_request']='Támogatási kérelem benyújtása';
$hesklang['verify_header']='SPAM megakadályozás';
$hesklang['ticket_details']='Hibajegy részletei';
$hesklang['yes_title_case']='Igen';
$hesklang['no_title_case']='Nem';
$hesklang['no_results_found']='Nincs találat';
$hesklang['site_theme']='Webhely témája';
$hesklang['test_theme_folder']='Téma mappa ellenőrzése';
$hesklang['test_theme_folder_description']='A téma mappa ellenőrzése. Csak azok a témák lesznek telepítve, amelyek az összes teszten átmennek .';
$hesklang['err_site_theme']='Kérjük, válassza a Hesk témát';
$hesklang['confirm']='Megerősítés';
$hesklang['confirm_deletion']='Törlés megerősítése';
$hesklang['confirm_delete_status']='Biztosan törli ezt az egyedi állapotot?';
$hesklang['help_desk']='Help-Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.hu.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Idő kijelzése';
$hesklang['tdisd']='Dátum és idő';
$hesklang['tdisa']='Idővel ezelőtt (példa: 5 órával ezelőtt)';
$hesklang['nav_templates']='Sablonok'; // Admin panel navigation item
$hesklang['hide_replies']='Hibajegyválaszok elrejtése';
$hesklang['hide_replies_no']='Ne rejtsd el, mindig mutasd az összes választ';
$hesklang['hide_replies_yes']='Az összes válasz elrejtése az utolsó kivételével:';
$hesklang['hide_replies_def']='Mutasd a személyzet utolsó válaszát és az esetleges későbbi válaszokat';
$hesklang['reply_by']='Megválaszolta'; // Reply by NAME
$hesklang['btt']='Vissza a tetejére';
$hesklang['lwidth']='Hibajegy szélességének korlátozása';
$hesklang['lwidtall']='Használja a teljes elérhető szélességet';
$hesklang['lwidtpx']='Maximális szélesség pixelben:';
// 3-letter days of the week
$hesklang['mon']='Hé';
$hesklang['tue']='Ke';
$hesklang['wed']='Sze';
$hesklang['thu']='Csü';
$hesklang['fri']='Pé';
$hesklang['sat']='Szo';
$hesklang['sun']='Vas';
$hesklang['clear']='Törlés'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Legalább egy SPAM-megelőzési intézkedést engedélyezni kell!';
$hesklang['modules']='Modulok';
$hesklang['modules_demo']='Ez a modul jelenleg csak %s -ban érhető el'; // %s = Hesk cloud link
$hesklang['see_demo']='Próbálja ki az élő demót itt: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statisztika';
$hesklang['statistics']['intro']='Ez a jelentés betekintést nyújt a help desk használatába és a személyzet teljesítményébe.';
$hesklang['statistics']['ntsp']='Nincs hibajegy a kiválasztott időszakban.';
$hesklang['statistics']['pie_title_ro']='Nyitott és megoldott hibajegyek';
$hesklang['statistics']['open']='Nyitott';
$hesklang['statistics']['resolved']='Megoldott';
$hesklang['statistics']['pie_title_as']='Nyitott hibajegyek: Hozzárendelt és nem hozzárendelt';
$hesklang['statistics']['ass']='Hozzárendelt';
$hesklang['statistics']['unas']='Nem hozzárendelt';
$hesklang['statistics']['pie_title_au']='Nyitott hibajegyek: megválaszolva és megválaszolatlan';
$hesklang['statistics']['answered']='Megválaszolt';
$hesklang['statistics']['unanswered']='Megválaszolatlan';
$hesklang['statistics']['pie_title_so']='Hibajegyek állapota';
$hesklang['statistics']['retic']='Hibajegyek:';
$hesklang['statistics']['chart_title_md']='Hibajegyek száma a hónapban';
$hesklang['statistics']['chart_title_wd']='Hibajegyek száma a héten';
$hesklang['statistics']['chart_title_hd']='Hibajegyek száma óránként';
$hesklang['statistics']['chart_title_tfr']='A szeméyzet első válaszáig eltelt idő';
$hesklang['statistics']['chart_title_tfrc']='Megválaszolt hibajegyek aránya adott időn belül';
$hesklang['statistics']['chart_title_ttr']='A hibajegy beküldésétől a megoldásáig eltelt idő';
$hesklang['statistics']['chart_title_ttrc']='Megoldott hibajegyek aránya adott időn belül';
$hesklang['statistics']['chart_title_sr']='Személyzet válaszok';
$hesklang['statistics']['chart_title_srt']='Személyzet válaszainak száma hibajegyenként';
$hesklang['statistics']['chart_title_srtr']='Személyzet válaszai hibajegyenként (csak megoldott jegyek)';
$hesklang['statistics']['chart_title_srt1']='Személyzet válaszai hibajegyenként (jegyek legalább egy válasszal)';
$hesklang['statistics']['ct_30']='30 perc';
$hesklang['statistics']['ct_1h']='1 óra';
$hesklang['statistics']['ct_2h']='2 óra';
$hesklang['statistics']['ct_4h']='4 óra';
$hesklang['statistics']['ct_1d']='1 nap';
$hesklang['statistics']['ct_2d']='2 nap';
$hesklang['statistics']['ct_3d']='3 nap';
$hesklang['statistics']['ct_1w']='1 hét';
$hesklang['statistics']['ct_wp']='> 1 hét';
$hesklang['statistics']['ct_1m']='1 hónap';
$hesklang['statistics']['ct_mp']='> 1 hónap';
$hesklang['statistics']['axis1']='% a hibajegyeknek megválaszolva';
$hesklang['statistics']['axis2']='% a hibajegyeknek megoldva';
$hesklang['statistics']['axis3']='% a hibajegyeknek';
$hesklang['statistics']['axis4']='Idő az első válaszig';
$hesklang['statistics']['axis5']='Idő a megoldásig';
$hesklang['statistics']['axis6']='Válaszok száma';
$hesklang['statistics']['axis7']='Hibajegyek száma';
$hesklang['statistics']['axis8']='Hétköznap';
$hesklang['statistics']['axis9']='Óra';
$hesklang['statistics']['axis10']='A hónap napja';
$hesklang['statistics']['tr_0']='Nincs válasz';
$hesklang['statistics']['tr_1']='1 válasz';
$hesklang['statistics']['tr_2']='2 válasz';
$hesklang['statistics']['tr_5']='3-5 válasz';
$hesklang['statistics']['tr_10']='6-10 válasz';
$hesklang['statistics']['tr_99']='> 10 válasz';
$hesklang['statistics']['average']='Átlag';
$hesklang['statistics']['atfr']='Átlagos idő a személyzet első válaszáig:';
$hesklang['statistics']['attr']='Átlagos idő a hibajegy megoldásáig:';
$hesklang['statistics']['about']='körülbelül  %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N / A';
$hesklang['statistics']['trept']='Összes hibajegy a személyzet által megválaszolva:';
$hesklang['statistics']['trnr']='Összes hibajegy a személyzet válasza nélkül megoldva:';
$hesklang['statistics']['tsr']='Összes személyzeti válasz:';
$hesklang['statistics']['tsrt']='Válaszok száma átlagosan hibajegyenként:';
$hesklang['statistics']['tsro']='Válaszok száma átlagosan hibajegyenként (jegyek legalább 1 válasszal):';
$hesklang['statistics']['tsrc']='Átlagosan szükséges válaszok száma egy hibajegy megoldásához:';
$hesklang['statistics']['tsrr']='Átlagosan szükséges válaszok száma egy hibajegy megoldásához (jegyek legalább 1 válasszal):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='és még sok minden más...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] hibajegy késett';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESZKALÁLT: %%SUBJECT%%';
$hesklang['escalate']['tab']='Eszkaláció'; // Menu link
$hesklang['escalate']['page_title']='Hibajegyek eszkalálása'; // Page H2 title
$hesklang['escalate']['intro']='Ez a modul segít olyan hibajegyek eszkalációjában, amelyekre nem vesznek fel időben.';
$hesklang['escalate']['feat1']='A hibajegyeket nem rendelték senkihez, nem válaszolták meg vagy nem kerültek megoldásra határidőn belül';
$hesklang['escalate']['feat2']='esedékességhez közeledő és lejárt jegyek';
$hesklang['escalate']['feat3']='automatikusan megváltoztatja a hibajegy prioritását, újból kijelöl egy hibajegyet, értesítést küld e-mailben';
$hesklang['escalate']['feat4']='szabályokat alkalmazzon a hibajegy kategóriája, tulajdonosa, státusza alapján';
$hesklang['escalate']['prefix']='Eszkalálódott:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Aktív szabályok';
$hesklang['escalate']['new']='Új eszkalációs szabály';
$hesklang['escalate']['no_rules']='Nincsenek eszkalációs szabályok. Hozzon létre egyet az &quot; Új eszkalációs szabály &quot; gomb felett. ';
$hesklang['escalate']['title']='Szabály címe';
$hesklang['escalate']['titlet']='Leíró cím, például: Egy nap alatt megválaszolatlan jegyek hozzárendelése';
$hesklang['escalate']['default_title']='%1 $s szabálya'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Szabályindító';
$hesklang['escalate']['trigt']='Állítsa be azt a feltételt, amely elindítja (futtatja) ezt a szabályt.';
$hesklang['escalate']['hits']='Találatok "; // Hányszor váltott ki egy szabályt'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Feltétel'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Művelet'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Jelentkezés'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Törli ezt a szabályt?';
$hesklang['escalate']['edit']='%1$s eszkalációs szabályazonosító szerkesztése'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='A támogatási hibajegy:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='a személyzet nem válaszolt rá';
$hesklang['escalate']['nrepc']='az ügyfél nem válaszolt rá';
$hesklang['escalate']['nass']='nincs hozzárendelve';
$hesklang['escalate']['nres']='nincs megoldva';
$hesklang['escalate']['ndue']='közeledik a határidő';
$hesklang['escalate']['odue']='lejárt';
$hesklang['escalate']['within']='Belül:';
$hesklang['escalate']['minutes']='perc';
$hesklang['escalate']['hours']='óra';
$hesklang['escalate']['days']='napok';
$hesklang['escalate']['weeks']='hetes';
$hesklang['escalate']['months']='hónap';
$hesklang['escalate']['years']='évek';
$hesklang['escalate']['ofs']='beküldés';
$hesklang['escalate']['resend']='E-mail értesítések újraküldése:';
$hesklang['escalate']['force']='Mindig küldje, hagyja figyelmen kívül a személyzet beállításait';
$hesklang['escalate']['noforce']='A személyzet értesítési beállításainak tiszteletben tartása';
$hesklang['escalate']['setpri']='Prioritás beállítása:';
$hesklang['escalate']['setsta']='Állapot beállítása:';
$hesklang['escalate']['assto']='Hibajegy rendelése a következőhöz:';
$hesklang['escalate']['asm']='Egy másik alkalmazott';
$hesklang['escalate']['notify']='Értesítés az alkalmazottakról ...';
$hesklang['escalate']['ato']='Jelentkezés:';
$hesklang['escalate']['tic']='Hibajegyek a kategóriában:';
$hesklang['escalate']['tat']='Hibajegyek hozzárendelve:';
$hesklang['escalate']['tws']='Hibajegyek állapota:';
$hesklang['escalate']['tall']='Alkalmazza ezt a szabályt a meglévő és a jövőbeli hibajegyekre';
$hesklang['escalate']['tfn']='Ezt a szabályt csak a jövőbeli hibajegyekre alkalmazza, a meglévő hibajegyeket figyelmen kívül hagyja';
$hesklang['escalate']['tfi']='Ezt a szabályt csak azokra a hibajegyekre alkalmazza, amelyek azonosítója magasabb, mint:';
$hesklang['escalate']['save']='Szabály mentése';
$hesklang['escalate']['e_tt']='Az időnek 1 és 10000 között kell lennie';
$hesklang['escalate']['e_a']='Válasszon ki legalább egy műveletet, amelyet a megfelelő hibajegyeknél el kell végeznie';
$hesklang['escalate']['nocat']='Válasszon ki legalább egy kategóriát';
$hesklang['escalate']['nouser']='Válasszon ki legalább egy felhasználót';
$hesklang['escalate']['nostatus']='Válasszon ki legalább egy állapotot';
$hesklang['escalate']['nocata']='%1$s nem fér hozzá ezekhez a kategóriákhoz:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Új szabály létrejött';
$hesklang['escalate']['mdf']='Szabály beállításai elmentetve';
$hesklang['escalate']['e_id']='Nem található szabály ezzel az azonosítóval';
$hesklang['escalate']['deleted']='A kiválasztott szabály törölve lett';
$hesklang['escalate']['edit_notice']='A szabályindító megváltoztatása nem lesz hatással a szabály által már eszkalált hibajegyekre (hacsak nem állítja vissza a szabályt).';
$hesklang['escalate']['reset']='A szabály visszaállítása';
$hesklang['escalate']['reset2']='Biztos, hogy vissza akarja állítani ezt a szabályt? <br> <br> A szabálytalálatok 0-ra kerülnek, és minden, a szabálynak megfelelő hibajegy újra eszkalálódik.';
$hesklang['escalate']['reset3']='A kiválasztott szabály vissza lett állítva';
$hesklang['escalate']['log_title']='#%1$s (%2$s) szabály'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class = "smaller">%1$s | %2$s fokozta: </li> '; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class = "smaller">%1$s | - prioritás beállítása %2$s </li> '; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class = "smaller">%1$s | - hozzárendelés a következőhöz:%2$s </li> '; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class = "smaller">%1$s | - küldje el a személyzet értesítését </li> ';
$hesklang['escalate']['thist5']='<li class = "smaller">%1$s | - a személyzet értesítésének elküldése (kényszerű) </li> ';
$hesklang['escalate']['thist6']='<li class = "smaller">%1$s | - hiba:%2$s nem fér hozzá a hibajegykategóriához </li> '; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class = "smaller">%1$s | - hiba:%2$s nincs engedélye a hibajegyek megtekintésére </li> '; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class = "smaller">%1$s | - hiba: nincs más felhasználó, aki megtekintheti ezt a hibajegyet </li> '; // %1$s = date
$hesklang['escalate']['thist9']='<li class = "smaller">%1$s | - értesítés: a prioritás már beállítva %2$s </li> '; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class = "smaller">%1$s | - értesítés:%2$s már hozzárendelve </li> '; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class = "smaller">%1$s | - értesítés:%2$s </li> '; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class = "smaller">%1$s | - állítsa az állapotot %2$s értékre </li> '; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class = "smaller">%1$s | - értesítés: az állapot már beállítva %2$s </li> '; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Aktív'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Aktiválja ezt a szabályt (kezdje el használni)';
$hesklang['escalate']['activated']='A kiválasztott szabály aktiválva van'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deaktiválja ezt a szabályt (ne használja tovább)';
$hesklang['escalate']['deactivated']='A kiválasztott szabály deaktiválva van'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Nincsenek aktív eszkalációs szabályok';
$hesklang['escalate']['matched']='Megtalált hibajegyek száma:%1$s'; // %1$s = number of tickets
$hesklang['escalate']['tools']='Eszközök';
$hesklang['escalate']['test']='Szimulálja ezt a szabályt';
$hesklang['escalate']['testa']='Az összes szabály szimulálása';
$hesklang['escalate']['testaa']='Az összes aktív szabály szimulálása';
$hesklang['escalate']['testr']='Szimulációs eredmények';
$hesklang['escalate']['rsim']='Szimuláció megismétlése';
$hesklang['escalate']['tbef']='Mielőtt egy szabály életbe lépne, aktiválnia kell azt az &quot; AKTÍV &quot; oszlop. <br> <br>
                               Erősen javasoljuk, hogy <strong> szimulálja </strong> az egyes szabályokat, ha rákattint a%1$s (Ezt a szabályt szimulálja) ikonra a szabálytáblában
                               aktiválás előtt megtudhatja, hogyan befolyásolja a meglévő hibajegyeket. <br> <br>
                               <strong> Az aktív szabályokat%2$s percenként dolgozzuk fel. A hibajegyet minden szabály csak egyszer növelheti </strong>. '; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SZIMULÁCIÓS MÓD, nincs változás az adatbázisban';
$hesklang['escalate']['sic']='SZIMULÁCIÓ TELJES';
$hesklang['escalate']['r']='[RULE]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Tipp: tartsa lenyomva a CTRL billentyűt több opció kiválasztásához';
$hesklang['desc_ticket_escalated']='(Személyzet) A hibajegyet fokozták'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Hibajegy formázása (személyzet)';
$hesklang['ticket_formatting_plaintext']='Sima szöveg';
$hesklang['ticket_formatting_rich_text']='Rich Text (HTML)';
$hesklang['due_date']='határidő';
$hesklang['invalid_due_date']='Érvénytelen határidőt adtunk meg.';
$hesklang['thist19']='<li class = "smaller"> %s | az esedékesség %s-ra frissítve: %s </li> '; // %s = date, new due date, user making change
$hesklang['thist20']='<li class = "smaller"> %s | esedékességi dátumot eltávolította: %s </li> '; // %s = date, user making change
$hesklang['due_date_updated']='A hibajegy esedékessége frissült.';
$hesklang['menu_kb_manage']='Kezelés'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Nézet'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Összes kijelölése';
$hesklang['a_deselect']='Kijelölések megszüntetése';
$hesklang['a_toggle']='Összes be- és kikapcsolása';
$hesklang['ql_all']='Minden hibajegy';
$hesklang['ql_alo']='Minden nyitott hibajegy';
$hesklang['ql_fit']='Szűrt hibajegyek';
$hesklang['ql_a2m']='Hozzám rendelt';
$hesklang['ql_a2o']='Másokhoz rendelt';
$hesklang['ql_una']='Kiosztatlan';
$hesklang['ql_due']='Hamarosan esedékes';
$hesklang['ql_ovr']='Lejárt';
$hesklang['set_ds']='Megjelenés &quot; hamarosan esedékes &quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='nappal az esedékesség előtt';
$hesklang['not_aos']='Néhány nyitott hibajegy, amelyhez hozzáfér, a szűrők miatt nem jelenik meg.';
$hesklang['ntoverdue']='Egy hibajegy késik a tulajdonosnál:';
$hesklang['ovdcron']='a lejárt értesítések működéséhez a rendszergazdának engedélyeznie kell a cron feladatot.';
$hesklang['instructions']='Utasítások';
$hesklang['desc_overdue_ticket']='(Személyzet) Hibajegy lejárt';
$hesklang['overdue_starting']='A késedelmes hibajegyek értesítési folyamatának megkezdése';
$hesklang['overdue_sim']='SZIMULÁCIÓ módban le van tiltva az e-mailek küldése és a hibajegyek frissítése.';
$hesklang['overdue_ticket_count']='Talált %s hibajegyet, amely lejárt.'; // %s = Number of tickets
$hesklang['overdue_finished']='Kész késedelmes hibajegyek.  %s e-mail elküldve.  %s e-mail küldése nem sikerült. '; // %s = Successful emails, failed emails
$hesklang['admin_css']='Rendszergazda CSS';
$hesklang['admin_css2']='Extra egyedi stílusfájl betöltése az admin panelhez';
$hesklang['noval_cert']='Ne érvényesítse a szerver tanúsítványait';
$hesklang['chg_cat']='Kattintson a hibajegy kategóriájának megváltoztatásához';
$hesklang['tlan']='Hibajegy nyelve';
$hesklang['uue']='Két vagy több alkalmazottnak ugyanaz az e-mail címe. Javasoljuk, hogy minden felhasználó számára állítson be egyedi e-mail címet. ';
$hesklang['flood']='Árvízkorlát';
$hesklang['e_flood']='Hoppá, a közelmúltban már beküldte a választ. A válaszáradások megakadályozása érdekében leállítottuk ezt a kérést. ';
$hesklang['cookies']='Cookie-k';
$hesklang['ukey']='URL-hozzáférési kulcs'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Véletlen URL-hozzáférési kulcs létrehozása';
$hesklang['ukeym']='Hiba: A fájl HTTP-n keresztüli futtatásához meg kell adnia az URL-hozzáférési kulcsot a kérelemben. Példa:';
$hesklang['ukeyw']='Hiba: helytelen URL-hozzáférési kulcs';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Jegy érkezett: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% a megerősítő kódod';
$hesklang['follow_up_email']='Légy őszinte – hogyan sikerült?';
$hesklang['mfa']='Többtényezős Hitelesítés (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Engedélyezve?';
$hesklang['mfa_required']='Többtényezős hitelesítés szükséges';
$hesklang['mfa_manage_profile']='MFA kezelése';
$hesklang['mfa_disabled']='A többtényezős hitelesítés le van tiltva';
$hesklang['mfa_enabled']='A többtényezős hitelesítés engedélyezve van (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Egyik sem';
$hesklang['mfa_method_none_subtext']='Távolítsa el a többtényezős hitelesítést fiókjában.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='A helpdesk bejelentkezéskor egy véletlenszerű bejelentkezési kódot tartalmazó e-mailt küld a <strong>%s</strong> címre.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Hitelesítő alkalmazás';
$hesklang['mfa_method_auth_app_short']='Alkalmazás';
$hesklang['mfa_method_auth_app_subtext']='Használjon okostelefonos alkalmazást, például az Authyt vagy a Google Authenticatort, hogy véletlenszerű bejelentkezési kódot generáljon bejelentkezéskor.';
$hesklang['mfa_step_method']='Módszer';
$hesklang['mfa_step_verification']='Ellenőrzés';
$hesklang['mfa_step_complete']='Kész';
$hesklang['mfa_introduction']='A többtényezős hitelesítés javítja a fiók biztonságát azáltal, hogy megköveteli a bejelentkezés igazolását egy további ellenőrzési módszerrel, például e-mail vagy hitelesítő alkalmazás (például Authy vagy Google Authenticator) használatával.';
$hesklang['mfa_reset_warning']='Már engedélyezte a többtényezős hitelesítést. Ennek újbóli elvégzése visszaállítja a többkomponensű hitelesítő eszközt (ha engedélyezve van).';
$hesklang['mfa_select_method_colon']='Válasszon hitelesítési módot:';
$hesklang['mfa_verification_header']='Ellenőrzés - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Egy hatjegyű ellenőrző kódot tartalmazó e-mailt küldtünk a(z) <strong>%s</strong> címre. A folytatáshoz írja be alább az e-mailben kapott kódot'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; 1. lépés: Szkennelje be az alábbi képet a többtényezős hitelesítési alkalmazással mobileszközén.';
$hesklang['mfa_verification_auth_app_cant_scan']='Nem tudja beolvasni a képet? Írja be kézzel ezt a kódot az eszközén: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; 2. lépés: Írja be az alkalmazásban megjelenő 6 számjegyű kódot az eszköz ellenőrzéséhez.';
$hesklang['mfa_verify']='Ellenőrizze';
$hesklang['mfa_invalid_method']='Érvénytelen többtényezős hitelesítési módszer érkezett.';
$hesklang['mfa_invalid_verification_code']='A beírt kód helytelen vagy lejárt.';
$hesklang['mfa_configured']='A többtényezős hitelesítés engedélyezve van fiókjában!';
$hesklang['mfa_removed']='A többtényezős hitelesítést letiltottuk a fiókjában!';
$hesklang['mfa_verification_needed']='A többtényezős hitelesítés engedélyezve van ennél a fióknál.';
$hesklang['mfa_verification_needed_email']='Kérjük, adja meg az e-mail címére küldött ellenőrző kódot.';
$hesklang['mfa_verification_needed_auth_app']='Kérjük, adja meg a hitelesítő alkalmazásban megjelenő kódot.';
$hesklang['mfa_verification_code']='Ellenőrző kód';
$hesklang['mfa_server_time_issue']='Úgy tűnik, hogy a szerveridő pontatlan: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Többtényezős hitelesítés visszaállítása';
$hesklang['mfa_reset_confirm']='Biztosan vissza szeretné állítani az MFA-t ehhez a felhasználóhoz?';
$hesklang['mfa_reset_yes']='Visszaállítás';
$hesklang['mfa_reset']='A többtényezős hitelesítés visszaállításra került a felhasználó számára';
$hesklang['desc_mfa_verification']='(Személyzet) Többtényezős hitelesítési kód';
$hesklang['mfa_code']='Kód:';
$hesklang['mfa_backup_codes_header']='MENTSE A VISSZAÁLLÍTÁSI KÓDJAIT';
$hesklang['mfa_backup_codes_description']='Tartsa ezeket a biztonsági kódokat biztonságos, de hozzáférhető helyen. Ha elveszíti hozzáférését MFA-eszközéhez vagy e-mailjéhez, a bejelentkezéshez adja meg az alábbi biztonsági kódok egyikét.<br><br><strong>Ügyeljen arra, hogy ezeket a biztonsági kódokat jelszavaként kezelje. Ezeket a kódokat többé nem fogja látni!</strong>';
$hesklang['mfa_verify_another_way']='Ellenőrizze fiókját más módon'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Kérjen ellenőrző kódot a következő címen: %s';
$hesklang['mfa_verify_another_way_code']='Írja be a 8 karakteres biztonsági kódok egyikét';
$hesklang['mfa_verify_another_way_admin']='Segítségért forduljon a helpdesk rendszergazdájához';
$hesklang['mfa_verify_another_way_reset']='Állítsa vissza a többtényezős hitelesítést úgy, hogy feltölt egy fájlt a szerverre';
$hesklang['mfa_send_another_email']='Küldjön egy másik e-mailt';
$hesklang['mfa_sent']='Egy új ellenőrző kódot tartalmazó e-mailt küldtünk az Ön e-mail címére';
$hesklang['mfa_backup_code']='Biztonsági kód';
$hesklang['mfa_backup_codes']='Biztonsági kódok';
$hesklang['mfa_backup_codes_info']='Egyszer használatos kódok a többtényezős ellenőrzés átadásához, ha nem fér hozzá az e-mailekhez vagy a hitelesítő alkalmazáshoz. Ha biztonsági kódot használ a bejelentkezéshez, az inaktívvá válik.';
$hesklang['mfa_backup_codes_num']='Bármikor beszerezhet egy új, 10 biztonsági kódból álló készletet. Amikor új kódkészletet hoz létre, a régi készlet automatikusan inaktívvá válik.';
$hesklang['mfa_backup_codes_num2']='Aktív kódjainak száma: %s';
$hesklang['mfa_invalid_backup_code']='A megadott biztonsági kód helytelen, vagy már használatban van.';
$hesklang['mfa_del_codes']='Törölje a biztonsági kódjaimat';
$hesklang['mfa_del_codes2']='Az összes biztonsági kódot törölték.';
$hesklang['mfa_new_codes']='Hozzon létre új biztonsági kódokat';
$hesklang['mfa_new_codes2']='Új biztonsági kódok generálva';
$hesklang['old_php_version']='Hiba: Nem támogatott PHP-verzió';
$hesklang['category_default_due_date']='Alapértelmezett határidő';
$hesklang['category_change_default_due_date']='Alapértelmezett határidő beállítása';
$hesklang['category_leave_blank_for_no_default_due_date']='(hagyja üresen, ha nincs alapértelmezett határidő)';
$hesklang['category_default_due_date_updated']='Az alapértelmezett határidő frissítve.';
$hesklang['email_formatting']='E-mail formázás';
$hesklang['email_formatting_html_and_plaintext']='HTML egyszerű szöveges alternatívával egyszerű szöveges sablonból (alapértelmezett)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML egyszerű szöveges alternatívával, amelyet HTML-sablonból generáltak';
$hesklang['email_formatting_html']='csak HTML';
$hesklang['email_formatting_plaintext']='Csak egyszerű szöveg';
$hesklang['email_formatting_note']='Az Ön által kiválasztott %1$s &gt; %2$s &gt; %3$s be van állítva: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Ez azt jelenti, hogy a Hesk figyelmen kívül hagyja az itt található HTML-sablonokat.';
$hesklang['email_formatting_note1']='Ez azt jelenti, hogy a Hesk figyelmen kívül hagyja az itt található egyszerű szöveges sablonokat.';
$hesklang['email_formatting_note2']='Ez azt jelenti, hogy a Hesk egyszerű szöveges verziót generál az e-mailekből a HTML-sablonokból, és figyelmen kívül hagyja az itt található egyszerű szöveges sablonokat.';
$hesklang['etnu']='Ezt az e-mail-sablont a Hesk jelenleg nem használja az Ön által megadott választás alapján %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Kategória szerkesztése';
$hesklang['create_category']='Kategória létrehozása';
$hesklang['one_user_included']='1 felhasználó van benne';
$hesklang['one_user_excluded']='1 felhasználó kizárva';
$hesklang['x_users_included']='%s a felhasználók száma'; // %s = Number of users
$hesklang['x_users_excluded']='%s felhasználó kizárva'; // %s = Number of users
$hesklang['aa_cat']='Jegyek automatikus hozzárendelése ebben a kategóriában';
$hesklang['modify_autoassign_settings']='Módosítsa az automatikus hozzárendelés beállításait';
$hesklang['autoassign_on_all_users']='Igen, minden olyan felhasználónak, aki hozzáfér ehhez a kategóriához';
$hesklang['autoassign_on_select_users']='Igen, bizonyos felhasználóknak';
$hesklang['autoassign_off']='Nem, küldje el a jegyeket hozzá nem rendeltként';
$hesklang['autoassign_users']='Az automatikus hozzárendelésbe belefoglalandó/kizárandó felhasználók';
$hesklang['autoassign_selected_include']='A kiválasztott felhasználókat <strong>bele kell foglalni</strong> a jegyek automatikus hozzárendelése során ebbe a kategóriában';
$hesklang['autoassign_selected_exclude']='A kiválasztott felhasználókat <strong>ki kell zárni</strong> a jegyek automatikus hozzárendelésekor ebbe a kategóriában';
$hesklang['cat_edited']='A %s kategória szerkesztése sikeresen megtörtént';
$hesklang['search_for_user']='Felhasználó keresése';
$hesklang['email_sending']='E-mailek küldése';
$hesklang['email_to_ticket']='E-mail a jegyhez';
$hesklang['email_to_ticket_info']='Az e-mailek jegyekké alakítása bizonyos szerveroldali beállítást igényelnek. A részletekért tekintse meg <a href="%s" target="_blank">ezt a tudásbázis-útmutatót</a>.'; // %s = link to article
$hesklang['from_warning2']='A Hesk SMTP-kiszolgálót használ az e-mail értesítések küldésére. A <strong>%1$s</strong> címet a következőre kell állítani <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Hiányzó fájlkiterjesztés';
$hesklang['block_ignore']='E-mail a jegyhez – Az e-mailek figyelmen kívül hagyása és a hurkok megelőzése';
$hesklang['block_noreply']='Ne válaszoljon';
$hesklang['block_noreply2']='Figyelmen kívül hagyja a &quot;do not reply&quot; email címeket';
$hesklang['block_returned']='Visszaküldött';
$hesklang['block_returned2']='Hagyja figyelmen kívül a visszaküldött e-maileket, például a kézbesítési állapotról szóló értesítéseket és az automatikus válaszokat';
$hesklang['block_duplicate']='Ismétlődések';
$hesklang['block_duplicate2']='Hagyja figyelmen kívül azokat az e-maileket, amelyek ugyanazt az üzenetet küldik &quot;%s&quot; másodpercig'; // %s = "Timeframe"
$hesklang['loop_info']='ugyanarról az e-mail címről kapott e-maileket &quot;%s&quot; másodpercig';
$hesklang['thist21']='<li class="smaller">%s | késedelmes e-mail értesítést küldtünk</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | nyomon követő e-mail elküldve</li>'; // %s = date
$hesklang['elevator_header']='Belépés a Biztonságos területre';
$hesklang['elevator_intro']='Egy biztonságos területre készül.';
$hesklang['elevator_enter_password']='A folytatáshoz adja meg jelszavát.';
$hesklang['elevator_duration_setting_title']='Biztonságos terület időtartama';
$hesklang['desc_survey']='(Customer) Nyomon követés (survey) email'; // Email description
$hesklang['satisfaction']['tab']='Elégedettség';
$hesklang['satisfaction']['title']='Ügyfél-elégedettségi felmérés';
$hesklang['satisfaction']['intro']='Küldjön ügyfeleinek egy utólagos elégedettségi felmérést, hogy visszajelzést gyűjtsön az ügyfélszolgálattal kapcsolatos tapasztalataikról.';
$hesklang['satisfaction']['tab1']='Beállítások';
$hesklang['satisfaction']['tab2']='Leiratkozás';
$hesklang['satisfaction']['enable']='Követő e-mailek engedélyezése:';
$hesklang['satisfaction']['enabled']='Az ügyfél-elégedettségi felmérések engedélyezve vannak.';
$hesklang['satisfaction']['disabled']='Az ügyfél-elégedettségi felmérések jelenleg le vannak tiltva.';
$hesklang['satisfaction']['url']='Felmérés URL-címe:';
$hesklang['satisfaction']['send']='Nyomon követési e-mail késés:';
$hesklang['satisfaction']['at_least']='Várjon legalább';
$hesklang['satisfaction']['after']='a jegy megoldása után az e-mail elküldése előtt';
$hesklang['satisfaction']['h1']='Hogyan kell használni ezt az eszközt?';
$hesklang['satisfaction']['h2']='Először is hozzon létre egy ügyfél-elégedettségi felmérést kedvenc felmérési eszközében. Ha nem biztos abban, hogy milyen eszközt használjon, vagy milyen kérdéseket tegyen fel, itt található <a href="%s" target="_blank"> egy útmutatónk</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Ha elkészült a felmérés, engedélyezze a nyomon követési e-maileket az alábbi űrlap segítségével. A Hesk óránként egyszer feldolgozza a megoldott jegyeket legalább egy munkatárs válaszával, és elküldi a felmérés linkjét az ügyfeleknek.';
$hesklang['satisfaction']['e_url']='Adjon meg egy érvényes felmérés URL-címét. Ez az az URL, amelyre az ügyfelek elküldik.';
$hesklang['satisfaction']['as']='Adjon meg egy érvényes felmérés URL-címét. Ez az az URL, amelyre az ügyfelek elküldik.';
$hesklang['satisfaction']['oo1']='Ez az oldal felsorolja azokat az e-mail címeket, amelyekre <b>nem</b> küldünk utólagos e-maileket.';
$hesklang['satisfaction']['oo2']='Ügyfelei leiratkozhatnak a kérdőíves e-mailek fogadásáról az e-mailben található hivatkozásra kattintva. Alternatív megoldásként ezen az oldalon manuálisan is hozzáadhat e-mail címeket.';
$hesklang['satisfaction']['ooe']='E-mail cím a leiratkozáshoz';
$hesklang['satisfaction']['ooe2']='Adja meg azt az e-mail címet, amelyről le szeretne iratkozni a kérdőíves e-mailek fogadásáról.';
$hesklang['satisfaction']['ooe3']='Ez az e-mail cím <i>%s</i> már le van tiltva a kérdőíves e-mailek fogadásáról.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Leiratkozás erről az e-mailről';
$hesklang['satisfaction']['oob']='Leiratkozott';
$hesklang['satisfaction']['no_oo']='Egyetlen ügyfél sem iratkozott le a felmérésről szóló e-mailek fogadásáról.';
$hesklang['satisfaction']['oor']='Eltávolítás';
$hesklang['satisfaction']['oor2']='Az e-mail eltávolítva a leiratkozásból';
$hesklang['satisfaction']['oor3']='Erősítse meg az eltávolítást';
$hesklang['satisfaction']['oor4']='Ha eltávolítják a leiratkozásból, ez a felhasználó ismét kap utólagos e-maileket.';
$hesklang['satisfaction']['optedout']='A(z) <i>%s</i> e-mail címre letiltották a kérdőíves e-mailek fogadását.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Hiányzó vagy érvénytelen felmérésazonosító';
$hesklang['satisfaction']['starting']='Az ügyfél-elégedettségi felmérés értesítési folyamatának elindítása';
$hesklang['satisfaction']['tc']='%s zárt jegyet találtunk, amelyekhez nem küldött elégedettségi felmérést.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Elkészült az ügyfél-elégedettségi felmérés. E-mailek elküldve: %1$s. Az e-maileket nem sikerült elküldeni: %2$s. Jegyek email nélkül: %3$s. Jegyek leiratkozási e-mail-címmel: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Figyelmen kívül hagyva, ez az ügyfél nem kíván kérdőíves e-maileket kapni.';
$hesklang['satisfaction']['ne']='Figyelmen kívül hagyva, ez a jegy e-mail cím nélküli';
$hesklang['satisfaction']['feat1']='Készítse el felmérését bármely harmadik fél eszközével, például a Google Űrlapokkal';
$hesklang['satisfaction']['feat2']='állítsa be felmérés URL-jét, beállításait és korlátozásait ebben a modulban';
$hesklang['satisfaction']['feat3']='Amikor megold egy jegyet, a Hesk e-mailben elküldi ügyfelének a felmérés linkjét';
$hesklang['dfor']='Dátumformátum';
$hesklang['dtfor']='Dátum és idő';
$hesklang['cdfor']='Dátum kiválasztása formátum';
$hesklang['custom']='Egyedi';
$hesklang['jsc_notice']='A dátum kiválasztása nem támogatja a PHP-stílusú dátumformázást. Válasszon egyet az előre konfigurált lehetőségek közül, vagy kattintson az alábbi %s ikonra az elérhető megjelenítési lehetőségek megtekintéséhez.'; // %s = replaced by icon
$hesklang['lcf3']='Csak dátum'; // Display: "Date only"
$hesklang['epdd']='Hiba a due_date paraméter elemzésekor:';
$hesklang['edit_pass']='Jelszó szerkesztése';
$hesklang['save_pass']='Jelszó mentése';
$hesklang['cur_pass']='Jelenlegi jelszó';
$hesklang['cur_pass2']='Meg kell adnia jelenlegi jelszavát annak megváltoztatásához.';
$hesklang['cur_pass3']='Sikeres jelszófrissítés után átirányíjuk a bejelentkezési oldalra, ahol új jelszavával tud bejelentkezni.';
$hesklang['e_new_pass']='Kérjük, adja meg új jelszavát';
$hesklang['pass_len']='A jelszó nem haladhatja meg a 64 karaktert';
$hesklang['pass_login']='Kérjük, jelszava megváltoztatása után jelentkezzen be újra';
$hesklang['bf_int']='Túl sok sikertelen ellenőrzési kísérlet miatt kijelentkezett';
$hesklang['tst_cnt']='Azon e-mailek száma, amelyeket a levelezőszerver küld a Hesk-nek: %s'; // %s = number of emails
$hesklang['wrn_imap']='Sok olvasatlan e-mail van a postaládájában (%1$s). A Hesk ezeket az e-maileket jegyekké alakítja.<br><br>A %2$s engedélyezése előtt érdemes megjelölni a meglévő e-maileket olvasottként, vagy új e-mail fiókot használni a Hesk számára.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Sok e-mail van a postaládájában (%1$s). A Hesk ezeket az e-maileket jegyekké alakítja.<br><br>Érdemes lehet törölni a meglévő e-maileket a %2$s engedélyezése előtt, vagy új e-mail fiókot használni a Hesk számára.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Lejárat dátuma'; // Due on (date)
$hesklang['search_due_date_range']='Napon belül lejár'; // Due in (X days)
$hesklang['attachment_add_files']='Fájl hozzáadása';
$hesklang['attachment_max_exceeded']='Ez a fájl nem kerül feltöltésre, mert már feltöltötte a megengedett maximális számú fájlt.';
$hesklang['attachment_viewer_message']='Húzza ide a fájlokat, vagy a \'Fájl hozzáadása\' gombra kattintva kiválaszthatja a feltöltendő fájlokat.';
$hesklang['attachment_invalid_type_message']='Sajnáljuk, de a feltölteni próbált fájltípus nem engedélyezett.';
$hesklang['attachment_upload_error']='Hiba történt a feltöltési kísérlet során. Kérjük, próbálja újra később.';
$hesklang['attachment_too_large']='Ez a melléklet nagyobb, mint a megengedett maximális fájlméret.';
$hesklang['attachment_cancel']='Mégsem';
$hesklang['attachment_confirm_cancel']='Biztosan megszakítja ezt a feltöltést?';
$hesklang['attachment_remove']='Távolítsa el a mellékletet';
$hesklang['attachment_too_many_uploads']='Túl sok mellékletet töltöttek fel az Ön helyéről rövid időn belül. Kérjük, próbálkozzon újra a kéréssel később.';
$hesklang['sub_note']='Jegyzet beküldése';
$hesklang['can_view_users']='Az összes felhasználó megtekintése (de nem kezelése)';
$hesklang['welcome1']='Szia, úgy tűnik, új vagy itt. Üdvözölünk!';
$hesklang['welcome2']='Az induláshoz tekintse meg a következő címet %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk online Gyors üzembe helyezési útmutató';
$hesklang['tmce1']='A helyesírás-ellenőrző eléréséhez használja a Ctrl+Jobb gombokat';
$hesklang['tmce2']='Tartsa lenyomva a Control (Ctrl) billentyűt, és kattintson a jobb gombbal a hibásan írt szóra a helyesírás-ellenőrző eléréséhez.';
$hesklang['desc_new_ticket_by_staff']='(Ügyfél) Új személyzet által benyújtott jegy';
$hesklang['mod_et_h']='Módosíthatja az e-mail sablonokat itt %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Állítsa be a nyelvet';
$hesklang['ouwa']='Az alábbiakban csak a kategóriához hozzáféréssel rendelkező felhasználók jelennek meg. Ha munkatársakat szeretne hozzáadni ehhez a kategóriába, szerkessze az engedélyeiket a %s oldalon'; // %s = Team
$hesklang['previous_tickets']='Korábbi jegyek';
$hesklang['no_previous']='Nincs korábbi jegy %s'; // %s = email address
$hesklang['all_previous']='Sorolja fel az összes korábbi jegyet';
$hesklang['confirm_delete_ticket']='Biztos benne, hogy véglegesen törli ezt a jegyet?';
$hesklang['confirm_delete_reply']='Biztosan véglegesen törli ezt a választ?';
$hesklang['select_new_category']='Jegyek száma ebben a kategóriában: %s<br><br>Kérjük, válasszon egy új kategóriát, amelybe át szeretné vinni ezeket a jegyeket:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='A felhasználóhoz rendelt jegyek száma: %1$s<br>A felhasználóhoz rendelt <b>nyitott</b> jegyek száma: %2$s<br><br><b>Nyitott</b> jegy a felhasználó törlése után <b>feloldásra kerül.</b>'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK licenc';
$hesklang['hlic_free']='INGYENES';
$hesklang['hlic_buyl']='Vásároljon licencet';
$hesklang['hlic_paid']='Licencelt';
$hesklang['antdemo']='A jegyek beküldése az adminisztrációs panelről demó módban le van tiltva.<br><br>Kérjük, használja a <a href="%s" target="_blank">nyilvános oldalt</a> tesztjegy benyújtásához.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Hitelesítési módszer';
$hesklang['email_authentication_method_username_password']='Alap (felhasználónév / jelszó)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Nincsenek konfigurálva ellenőrzött OAuth-szolgáltatók.';
$hesklang['email_authentication_method_oauth_link']='OAuth-szolgáltatók kezelése'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Engedélyezési végpont URL-je';
$hesklang['email_oauth_token_url']='Token végpont URL-je';
$hesklang['email_oauth_client_id']='Ügyfél ID';
$hesklang['email_oauth_client_secret']='Ügyfél titok';
$hesklang['email_oauth_scope']='Hatály';
$hesklang['oauth_error_invalid_state']='Az OAuth állapota nem egyezik az OAuth-szolgáltatónak küldött állapottal.';
$hesklang['oauth_error_unknown']='Ismeretlen hiba történt az OAuth-tokenek mentésére tett kísérlet során.';
$hesklang['oauth_error_no_token']='A JSON-válaszból hiányzik a hozzáférési token.';
$hesklang['oauth_error_retrieve']='Nem sikerült lekérni a hozzáférési tokent. Kérjük, erősítse meg az OAuth-szolgáltató beállításait, és mentse újra őket új token beszerzéséhez.';
$hesklang['email_oauth_provider']='OAuth-szolgáltató';
$hesklang['email_oauth_providers']='OAuth-szolgáltatók';
$hesklang['email_oauth_provider_guide']='Az OAuth használata előtt regisztrálnia kell egy OAuth-szolgáltatót. A részletekért lásd <a href="%s" target="_blank"> ezt a tudásbázis útmutatót</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Az Ön OAuth-átirányítási URI-je a Hesk-hez:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Ezzel az eszközzel OAuth-szolgáltatókat adhat hozzá az ügyfélszolgálathoz';
$hesklang['email_oauth_provider_name']='Név'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Új szolgáltató';
$hesklang['email_oauth_edit_provider']='Szolgáltató szerkesztése';
$hesklang['email_oauth_provider_being_used_for']='Használatban';
$hesklang['email_oauth_providers_none']='Nincs mentett OAuth-szolgáltató. Ezeket a fenti „Új szolgáltató” lehetőségre kattintva adhatja hozzá.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Ez a szolgáltató nem távolítható el, mert az ügyfélszolgálat használja.';
$hesklang['email_oauth_confirm_delete_provider']='Biztosan törli ezt az OAuth-szolgáltatót?';
$hesklang['oauth_provider_saved']='Az OAuth-szolgáltató el lett mentve';
$hesklang['oauth_provider_use']='Most kiválaszthatja ezt a szolgáltatót %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Írja be a szolgáltató nevét';
$hesklang['oauth_provider_err_auth_url']='Adjon meg egy érvényes engedélyezési URL-t';
$hesklang['oauth_provider_err_token_url']='Adjon meg egy érvényes token URL-t';
$hesklang['oauth_provider_err_client_id']='Adja meg a kliens ID-t';
$hesklang['oauth_provider_err_client_secret']='Adja meg az ügyfél titkát';
$hesklang['oauth_provider_err_scope']='Adja meg a hatókört';
$hesklang['oauth_provider_deleted']='Az OAuth-szolgáltató törölve';
$hesklang['oauth_provider_not_found']='Ez az OAuth-szolgáltató nem létezik';
$hesklang['oauth_provider_verified']='Ellenőrzött';
$hesklang['oauth_provider_click_to_verify']='Kattintson az ellenőrzéshez';
$hesklang['can_due_date']='Beállíthatja a határidőt'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Nincs engedélye határidők beállítására';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Ellenőrizze regisztrációját';
$hesklang['customer_verify_new_email']='Igazolja új e-mail címét';
$hesklang['customer_reset_password']='Állítsa vissza ügyfélszolgálati jelszavát';
$hesklang['customer_approved']='Fiók jóváhagyva';
$hesklang['customer_rejected']='Fiók elutasítva';
$hesklang['email_rejected']='A támogatási jegyek benyújtásához fiók szükséges';
$hesklang['require_curl']='Ehhez a funkcióhoz <strong>cURL</strong> támogatás szükséges a PHP-hez, amely engedélyezve van a szerverén. Kérje meg webszolgáltatóját, hogy engedélyezze a cURL-t a PHP számára.';
$hesklang['customer_accounts_heading']='Ügyfél fiókok';
$hesklang['customer_accounts']='Ügyfél fiókok';
$hesklang['customer_accounts_off']='<strong>Letiltva</strong>';
$hesklang['customer_accounts_allowed']='<strong>Engedélyezve – Nem kötelező</strong> (az ügyfelek regisztráció vagy bejelentkezés nélkül nyújthatnak be támogatási jegyeket)';
$hesklang['customer_accounts_required_to_submit']='<strong>Engedélyezve – kötelező a jegyekhez</strong> (csak bejelentkezett ügyfelek küldhetnek támogatási jegyeket)';
$hesklang['customer_accounts_required']='<strong>Engedélyezve – A hozzáféréshez szükséges</strong> (csak a bejelentkezett ügyfelek férhetnek hozzá az ügyfélszolgálathoz és a tudásbázishoz)';
$hesklang['customer_accounts_reg']='Fiók regisztráció';
$hesklang['customer_accounts_reg_customer']='Ügyfelek regisztrálhatnak fiókokat';
$hesklang['customer_accounts_reg_approve']='Az ügyfelek regisztrálhatnak fiókot, a személyzetnek jóvá kell hagynia az új regisztrációkat';
$hesklang['customer_accounts_reg_staff']='Csak a személyzet regisztrálhatnak ügyfélfiókokat';
$hesklang['customer_accounts_allow_email_changes']='Az ügyfelek megváltoztathatják e-mail címüket';
$hesklang['customer_accounts_allow_email_resends']='Eltelt idő, amíg az ügyfelek új ellenőrző e-mailt kérhetnek';
$hesklang['customer_login']='Bejelentkezés';
$hesklang['customer_logout']='Kijelentkezés';
$hesklang['customer_register']='Regisztrálás';
$hesklang['customer_accounts_disabled']='Az ügyfelek bejelentkezése és regisztrációja le van tiltva.';
$hesklang['customer_accounts_registration_disabled']='Az ügyfelek regisztrációja le van tiltva.';
$hesklang['customer_forgot_password']='Elfelejtett jelszó?';
$hesklang['customer_email']='E-mail cím';
$hesklang['customer_accounts_email_banned']='Önt kitiltották a helpdesk használatából.';
$hesklang['customer_registration_successful']='Sikeres regisztráció!';
$hesklang['customer_registration_email_exists_no_reset_link']='Már létezik fiók a(z) %s e-mail-címmel.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Már létezik fiók a(z) %s e-mail-címmel. <a href="login.php">be szeretne-e jelentkezni helyette</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Már létezik fiók a(z) %s e-mail címmel, és e-mail megerősítésre vár.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Már létezik egy fiók a(z) %s e-mail címmel, és a személyzet jóváhagyására vár.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Ellenőrizze e-mailjét!';
$hesklang['customer_registration_check_your_email_content']='A bejelentkezéshez igazolnia kell e-mail címét.<br><br>Ha néhány percen belül nem kapja meg, kérjük, ellenőrizze a Levélszemét, a Kéretlen vagy a Spam mappákat. Jelölje meg az üzenetet <b>Nem SPAM</b>ként, hogy elkerülje a jövőbeni levelezésünk fogadásával kapcsolatos problémákat.';
$hesklang['customer_login_not_verified']='A bejelentkezéshez igazolnia kell az e-mail címét.';
$hesklang['customer_login_not_verified2']='Ha nem kapta meg tőlünk az ellenőrző e-mailt, kérjük, ellenőrizze Levélszemét, Tömeges vagy Spam mappáit. Jelölje meg az üzenetet <b>Nem SPAM</b>ként, hogy elkerülje a jövőbeni levelezésünk fogadásával kapcsolatos problémákat.';
$hesklang['customer_login_resend_verification_email']='Küldje el újra az ellenőrző e-mailt';
$hesklang['customer_login_resend_verification_email_none']='Nincs elküldendő függőben lévő e-mailes megerősítés.';
$hesklang['customer_login_resend_verification_email_too_early']='Jelenleg nem kérhet új megerősítő e-mailt, kérjük, próbálja meg később.';
$hesklang['customer_login_not_approved']='Egy munkatársnak jóvá kell hagynia a fiókját, mielőtt be tudna jelentkezni. A jóváhagyást követően e-mailben értesítjük.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Regisztráció megerősítése';
$hesklang['customer_registration_verify_success']='Az e-mail-címe sikeresen megerősítésre került, most már bejelentkezhet az alábbi űrlap segítségével.';
$hesklang['customer_registration_verify_approval_needed']='Az e-mail-címe sikeresen megerősítésre került. Azonban egy munkatársnak jóvá kell hagynia a fiókját, mielőtt be tudna jelentkezni. A jóváhagyást követően e-mailben értesítjük.';
$hesklang['customer_registration_verify_failure']='Az e-mail-címét nem sikerült megerősíteni. Lehet, hogy a linket már felhasználták, vagy az lejárt.';
$hesklang['emails_to_customers']='&raquo; E-mailek elküldve az ügyfeleknek';
$hesklang['emails_to_staff']='&raquo; E-mail elküldve a munkatársaknak';
$hesklang['emails_to_everyone']='&raquo; E-mail elküldve az ügyfelekenek vagy munkatársaknak';
$hesklang['new_customer_approval']='Jóváhagyásra váró ügyfélfiókjai vannak'; // Email subject
$hesklang['desc_new_customer_approval']='(Munkatárs) Ügyfélfiókok jóváhagyásra várnak';
$hesklang['n_cust_app']='Vannak függőben lévő ügyfél jóváhagyások'; // Notify me when...
$hesklang['et_num_customers']='Függőben lévő jóváhagyások száma';
$hesklang['et_link_customers']='Link az Ügyfelek kezelése oldalra';
$hesklang['et_link_verify']='Ellenőrző link';
$hesklang['et_cust_login']='Ügyfél bejelentkezési URL-je';
$hesklang['submit_ticket_customer_email_exists']='Már létezik ezzel az e-mail-címmel rendelkező ügyfél. Kérjük, <a href="login.php?email=%s">jelentkezzen be</a> jegy benyújtásához.'; // %s - User's email
$hesklang['customer_login_email_required']='Kérjük, adjon meg egy érvényes e-mail címet.';
$hesklang['customer_login_password_required']='Kérjük, adja meg jelszavát.';
$hesklang['customer_login_remember_just_email']='Emlékezz csak az e-mailemre';
$hesklang['customer_login_remember_email']='Emlékezz az email címemre';
$hesklang['customer_wrong_user']='Az Ön e-mail címe %s nincs regisztrálva nálunk.<br><br>Szeretne <a href="register.php">létrehozni egy fiókot?</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Az Ön e-mail címe és jelszava nem egyezik nyilvántartásunkkal.<br><br>Szeretné <a href="login.php?submittedForgot=1">újra beállítani jelszavát</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Kérjük, jelentkezzen be a folytatáshoz.';
$hesklang['customer_register_here']='Ha nincs fiókja nálunk, <a href="register.php">itt regisztrálhat</a>.';
$hesklang['create_account']='Hozzon létre egy fiókot';
$hesklang['customer_my_tickets_heading']='Hibajegyeim';
$hesklang['customer_my_tickets_description']='Tekintse meg az összes korábbi jegyét';
$hesklang['customer_my_tickets_search_for_tickets']='Jegyek keresése';
$hesklang['customer_password_reset_successful']='Az új jelszava el lett mentve. Most már bejelentkezhet.';
$hesklang['customer_profile']='Profil';
$hesklang['customer_edit_profile']='Profil szerkesztése';
$hesklang['customer_edit_pass']='Jelszó szerkesztése';
$hesklang['customer_edit_pass_same']='Az új jelszava nem lehet ugyanaz, mint a jelenlegi.';
$hesklang['customer_change_email']='E-mail cím módosítása';
$hesklang['customer_change_email_banned']='A beírt e-mail cím tiltva van.';
$hesklang['customer_change_email_pending']='Jelenleg egy kérés érkezett az e-mail címének módosítására a következőre: <b>%s</b><br><br>E-mailt küldtünk erre a címre. Kérjük, kattintson az e-mailben található linkre a módosítás megerősítéséhez.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Megerősítő e-mail újraküldése</a>';
$hesklang['customer_change_email_submitted']='Kérjük, kattintson a(z) <b>%s</b> címre küldött ellenőrző linkre az új e-mail igazolásához.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Új e-mail címét ellenőriztük, profilját pedig frissítettük.';
$hesklang['customer_change_email_disabled']='Az e-mail frissítés lehetősége le van tiltva. Lépjen kapcsolatba velünk, ha módosítani szeretné az e-mail címét.';
$hesklang['customer_profile_saved']='A profilod el lett mentve.';
$hesklang['customers']='Ügyfelek';
$hesklang['customers_intro']='Az ügyfélfiókok lehetővé teszik az ügyfelek számára, hogy az összes jegyüket egy központi helyen tekinthessék meg.';
$hesklang['sure_remove_customer']='Biztosan eltávolítja ezt az ügyfelet?';
$hesklang['sure_remove_customer_additional_note']='Az ügyfél törlése végleges. Törlés után nem állíthatók vissza!';
$hesklang['new_customer']='Új Ügyfél';
$hesklang['new_follower']='Új követő';
$hesklang['add_customer']='+ Ügyfél hozzáadása'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Követő hozzáadása'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='A megadott ügyfél még nem létezik. Kattintson a "Mentés" gombra, ha létre szeretné hozni ezt az ügyfelet.';
$hesklang['followers']='Követői';
$hesklang['no_customers']='Jelenleg nincs ügyfél az adatbázisban.';
$hesklang['no_customers_disabled']='Itt fogja látni az ügyfeleket, amikor támogatási jegyeket küldenek be.';
$hesklang['no_customers_enabled']='Itt fogja látni az ügyfeleket, amikor regisztrálnak vagy támogatási jegyeket küldenek be.';
$hesklang['no_customers_enabled2']='Alternatív megoldásként az üzenet feletti gombokkal manuálisan hozhat létre ügyfélfiókokat, vagy importálhat meglévő ügyfeleket.';
$hesklang['import_customers']='Ügyfelek importálása';
$hesklang['import_customers_tip']='Használjon CSV-fájlt egyszerre több ügyfél importálásához.';
$hesklang['customer_not_found']='Az ügyfél nem található a jegyhez!';
$hesklang['search_by_name_or_email']='Keresés név vagy e-mail alapján...';
$hesklang['search_by_pattern']='Keresés minta szerint...';
$hesklang['is_searchable']='Kereshető';
$hesklang['custom_is_searchable']='Kereshető';
$hesklang['yes_via_autocomplete']='IGEN (keresés automatikus kiegészítéssel)';
$hesklang['customer_required']='Ki kell választania egy ügyfelet';
$hesklang['customer_email_exists']='Már létezik ezzel az e-mail-címmel rendelkező ügyfél.';
$hesklang['customer_name_with_no_email_exists']='Már létezik ilyen nevű és e-mail-cím nélküli ügyfél.';
$hesklang['an_error_occurred_validating_email']='Hiba történt a megadott e-mail cím ellenőrzése során.';
$hesklang['customer_count_x_more']='+%s more'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Regisztrált';
$hesklang['customer_account_verified']='Ellenőrzött';
$hesklang['customer_account_verified_help']='Az ügyfeleknek igazolniuk kell fiókjukat az e-mail címükre küldött aktiváló link segítségével, mielőtt bejelentkezhetnének a fiókjukba.';
$hesklang['customer_account_setting_password_will_verify_user']='Ha jelszót állít be ehhez az ügyfélhez, a rendszer automatikusan igazolja fiókját.';
$hesklang['deleting_customer_with_tickets']='Ennek az ügyfélnek %1$s jegye(i) van(nak) <b>(%2$s nyitva)</b> amelyhez más ügyfelek is társulnak.<br>Mi a teendő ezekkel a jegyekkel?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Az ellenőrző e-mail újbóli elküldéséhez érvényes e-mail cím szükséges.';
$hesklang['customer_resend_verification_email_not_found']='Nincs fiók ezzel az e-mail címmel, vagy a fiókot már ellenőrizték.';
$hesklang['customer_resend_verification_email_sent']='Ellenőrző e-mailt küldtünk az Ön e-mail címére.<br><br>Ha néhány percen belül nem kapja meg, kérjük, ellenőrizze Levélszemét, Tömeges vagy Spam mappáit. Jelölje meg az üzenetet <b>Nem SPAM</b>ként, hogy elkerülje a jövőbeni levelezésünk fogadásával kapcsolatos problémákat.';
$hesklang['customer_permission_denied']='Nincs engedélye az ügyfelek módosítására.';
$hesklang['customer_manage_approvals']='Jóváhagyásra váró ügyfélfiókok: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Ügyfél jóváhagyása';
$hesklang['customer_manage_bulk_approve']='Kiválasztott ügyfelek jóváhagyása';
$hesklang['customer_manage_bulk_approve_complete']='Jóváhagyott Ügyfelek: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Elutasított Ügyfelek';
$hesklang['customer_manage_bulk_reject']='Kiválasztott ügyfelek elutasítása';
$hesklang['customer_manage_bulk_reject_complete']='Ügyfelek elutasítva: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Ügyfél törlése';
$hesklang['customer_manage_bulk_delete']='Törölje a kiválasztott ügyfeleket';
$hesklang['customer_manage_bulk_delete_complete']='Ügyfelek törölve: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Ügyfél szerkesztése';
$hesklang['customer_manage_verification_email_sent']='Az ellenőrző e-mailt elküldtük a(z)  %s'; // %s = customer's email
$hesklang['can_man_customers']='Ügyfelek kezelése';
$hesklang['can_view_customers']='Az összes ügyfél megtekintése (de nem kezelése)';
$hesklang['import_customer_select_file']='Fájl kiválasztása';
$hesklang['import_customer_step1_instructions']='Az ügyfelek importálásához készítsen egy CSV-fájlt (vesszővel tagolt értékek).';
$hesklang['import_customer_step1_note']='Válassza ki a CSV-fájlt';
$hesklang['import_customer_step1_separator']='A CSV-fájlomban lévő oszlopok a következővel vannak elválasztva';
$hesklang['import_customer_sample']='&raquo; Minta CSV-fájlok';
$hesklang['import_customer_sample_1']='Amerikai stílusú CSV-fájl, amelyen az oszlopok egymástól elválasztva ,';
$hesklang['import_customer_sample_2']='EU-stílusú CSV-fájl, amelynek oszlopai egymástól elválasztva ;';
$hesklang['import_customer_upload_requirements_1']='A CSV-fájlnak tartalmaznia kell legalább egy nevet vagy egy e-mail-cím oszlopot. A jelszó oszlop nem kötelező.';
$hesklang['import_customer_upload_requirements_2']='A fájl első sorának oszlopfejléceket kell tartalmaznia.';
$hesklang['import_customer_upload_requirements_3']='A fájlnak UTF-8 kódolásúnak kell lennie.';
$hesklang['import_customer_select_columns']='Válassza az Oszlopok lehetőséget';
$hesklang['import_customer_upload_customers']='Ügyfelek feltöltése';
$hesklang['import_customer_column_name']='Név oszlop';
$hesklang['import_customer_column_email']='E-mail oszlop';
$hesklang['import_customer_column_pass']='Jelszó oszlop';
$hesklang['import_customer_step2_note']='Válassza ki a megfelelő oszlopnevet a CSV-fájlból a legördülő menükben, majd kattintson a "Tovább" gombra.';
$hesklang['import_customer_name_or_email_required']='Név vagy e-mail cím megadása kötelező';
$hesklang['import_customer_step3_note']='Az ügyfelek importálása folyamatban van. Ne hagyd el ezt az oldalt!';
$hesklang['import_customer_step3_pending']='Függőben levő';
$hesklang['import_customer_step3_successful_imports']='Sikeres import';
$hesklang['import_customer_step3_failed_imports']='Sikertelen importálás';
$hesklang['import_customer_step3_progress']='Folyamatban';
$hesklang['import_customer_step3_complete_some_failed']='Az importálási folyamat befejeződött, azonban <b>%s</b> ügyfeleknek nem sikerült importálnia. További információkért tekintse meg az alábbi táblázatot.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='Az importálási folyamat befejeződött!';
$hesklang['import_customer_step3_importing']='Importálás';
$hesklang['staff_deleted']='[Személyzet törölve]';
$hesklang['customer_account_approved']='Ügyfélregisztráció jóváhagyva';
$hesklang['customer_account_rejected']='Az ügyfél regisztrációja elutasítva';
$hesklang['customer_account_deleted']='Ügyfél regisztráció törölve';
$hesklang['ticket_followers']='Jegykövetők';
$hesklang['ticket_followers2']='Lehetővé teszi, hogy a jegyeknek több ügyfele is legyen';
$hesklang['add_cc']='Másolat hozzáadása';
$hesklang['cc']='Másolat';
$hesklang['cc_help']='Az egyes e-maileket vesszővel válassza el.';
$hesklang['search_customers']='Ügyfelek keresése';
$hesklang['page_size']='Oldal mérete';
$hesklang['customers_on_pages']='Ügyfelek száma: %d | Oldalak száma: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Ügyfél) Állítsa vissza jelszavát';
$hesklang['desc_customer_verify_registration']='(Ügyfél) Ellenőrizze regisztrációját';
$hesklang['desc_customer_verify_new_email']='(Ügyfél) Ellenőrizze új e-mail címét';
$hesklang['desc_customer_approved']='(Ügyfél) Fiók jóváhagyva';
$hesklang['desc_customer_rejected']='(Ügyfél) Számla elutasítva';
$hesklang['desc_email_rejected_can_self_register']='(Ügyfél) Az e-mailben küldött jegy elutasítva; az ügyfél önállóan regisztrálhat';
$hesklang['desc_email_rejected_cannot_self_register']='(Ügyfél) Az e-mailben küldött jegy elutasítva; az ügyfél nem tud önállóan regisztrálni';
$hesklang['user_added_success_no_pass']='Új felhasználó %s sikeresen hozzáadva';
$hesklang['email_tag_requester']='Kérelmező (feladó)';
$hesklang['email_tag_requester_name']='Kérelmező (Feladó) neve';
$hesklang['email_tag_requester_first_name']='Kérelmező (feladó) keresztneve';
$hesklang['email_tag_requester_email']='Kérelmező (Feladó) e-mail';
$hesklang['email_tag_followers']='Követők (másolat)';
$hesklang['email_tag_follower_names']='Követő (Cc) nevei';
$hesklang['email_tag_follower_emails']='Követő (másolat) e-mailek';
$hesklang['barcode']='Vonalkód';
$hesklang['barcode_use']='Vonalkód megjelenítése a nyomtatott jegyeken';
$hesklang['barcode_staff_only']='A vonalkód elrejtése az ügyfelek elől';
$hesklang['barcode_type']='Vonalkód típusa';
$hesklang['barcode_format']='Formátum';
$hesklang['barcode_width']='Szélesség';
$hesklang['barcode_height']='Magasság';
$hesklang['barcode_color']='Szín';
$hesklang['barcode_bg']='Háttér';
$hesklang['copy_link']='Jegy linkjének másolása';
$hesklang['copy_link_title']='Másolja a nyilvános linket ehhez a jegyhez';
$hesklang['copy_link_exp']='A kimásolt link a közvetlen link, amellyel az ügyfél megtekintheti ezt a jegyet';
$hesklang['copy_value']='Másolja ezt az értéket';
$hesklang['download_class']='Ez a funkció a ZipArchive osztályt igényli. Kérje meg a szolgáltatóját, hogy fordítsa le a PHP-t zip támogatással.';
$hesklang['download_all']='Az összes letöltése';
$hesklang['download_prep']='Letöltés előkészítése...';
$hesklang['download_tma']='Túl sok melléklet';
$hesklang['download_nva']='Nincsenek érvényes mellékletek';
$hesklang['download_ntd']='Nincs mit letölteni';
$hesklang['resolved_at']='Megoldva';
$hesklang['disable_GSSAPI']='A GSSAPI hitelesítő letiltása (Kerberos hiba)';
$hesklang['ex_history']='Tartalmazza a jegyelőzmények naplóját az exportálásban';
$hesklang['sm_location']='Elhelyezkedés'; // Location (page) of a service message
$hesklang['loc_sm']='Jelenítse meg ezt a szolgáltatási üzenetet:';
$hesklang['loc_all']='Minden ügyféloldal';
$hesklang['loc_norec']='(nem ajánlott)';
$hesklang['loc_home']='Help desk kezdőoldal';
$hesklang['loc_selected']='A kiválasztott oldalakon';
$hesklang['loc_selerr']='Válasszon ki legalább egy oldalt az üzenet megjelenítéséhez';
$hesklang['loc_t_cat']='Jegy benyújtása – válasszon kategóriát';
$hesklang['loc_t_add']='Jegy benyújtása - jegyűrlap beküldése';
$hesklang['loc_t_ok']='Jegy benyújtása - jegy visszaigazolása';
$hesklang['loc_t_view']='Nézze meg a jegyet';
$hesklang['loc_t_form']='Jegyűrlap megtekintése';
$hesklang['loc_kb_main']='Tudásbázis kezdőlapja';
$hesklang['loc_kb_sub']='Tudásbázis alkategória oldalai';
$hesklang['loc_kb_art']='Tudásbázis cikkek';
$hesklang['loc_login']='Ügyfél bejelentkező oldala';
$hesklang['loc_register']='Ügyfél regisztrációs oldal';
$hesklang['loc_register_ok']='Ügyfél regisztráció sikeres';
$hesklang['loc_acc']='Ügyfél &quot;Jegyeim&quot; page';
$hesklang['loc_profile']='Ügyfél &quot;Profil&quot; page';
$hesklang['sending_show']='Jelenítse meg a &quot;Beküldött&quot; értesítéseket';
$hesklang['sending_wait']='Beküldés, kérem várjon...';
$hesklang['e_c_email']='A jegy megtekintéséhez írja be a helyes e-mail címet';
$hesklang['only_verified_cc']='Az ellenőrzött fiókkal nem rendelkező követőket figyelmen kívül hagyjuk.';
$hesklang['followers_removed']='Ezeket az e-mail címeket eltávolítottuk a jegyből, mert nem rendelkeznek ellenőrzött fiókkal:';
$hesklang['novace']='Ezzel az e-mail címmel nem találtunk regisztrált és ellenőrzött fiókokat.';
$hesklang['max_recipients']='Maximum címzettek';
$hesklang['max_recipients2']='egyetlen e-mailben';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Töltsön be egy extra egyéni Javascript-fájlt az adminisztrációs panelhez';
$hesklang['cf_limit_all']='Elérte az egyéni mezők korlátját, és nem tud új egyéni mezőket létrehozni.';
$hesklang['remind_assigned']='Emlékeztető küldése az kijelölt munkatársaknak';
$hesklang['remind_sent']='E-mailes emlékeztető küldve a kijelölt munkatársnak.';
$hesklang['thist23']='<li class="smaller">%s | emlékeztető elküldve a címre %s by %s</li>';
$hesklang['ql_bookmarks']='Könyvjelzők';
$hesklang['bookmark']='Saját könyvjelző';
$hesklang['bookmarks_add']='Hozzáadás a könyvjelzőkhöz';
$hesklang['bookmarks_added']='Ez a jegy hozzáadva a könyvjelzőihez';
$hesklang['bookmarks_remove']='Eltávolítás a könyvjelzők közül';
$hesklang['bookmarks_removed']='Ezt a jegyet eltávolítottuk a könyvjelzők közül';
$hesklang['genl_not_copied']='Hiba: A vágólapra másolás nem támogatott ezen az eszközön/böngészőn.';
$hesklang['profile_duplicate_email']='A(z) <b>%s</b> e-mail-címmel már létezik felhasználó.'; // %s: new email
$hesklang['seq_id_numeric']='A hibajegyszám keresése csak számokat tartalmazhat';
$hesklang['confirm_new_pass']='Erősítse meg az új jelszót';
$hesklang['piping_notify_rejected_customers1']='Ügyfél elutasító e-mailjei';
$hesklang['piping_notify_rejected_customers2']='Elutasító e-mail küldése az ügyfeleknek, ha a jegyüket elutasították';
$hesklang['piping_notify_rejected_customers3']='Az elutasító e-mailek közötti idő';
$hesklang['register_url']='Regisztrációs URL';
$hesklang['email_subject']='E-mail tárgya';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Együttműködés a jegykezelésen: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] A személyzet így válaszolt: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Megjegyzés hozzáadva ehhez: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Lejárt jegy: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Hibajegy megoldva: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Utánkövetési e-mail határideje:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Ne küldjön e-mailben olyan jegyeket, amelyek több mint'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ezelőtt (hosszabb időszaknak kell lennie, mint "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='Az e-mail-küldési határidőnek hosszabbnak kell lennie, mint a követő e-mail késleltetésének.';
$hesklang['available_language']='Elérhető nyelvek';
$hesklang['click_to_show_available_language']='Kattintson az elérhető nyelvek megjelenítéséhez';
$hesklang['install_lan']='Telepítés';
$hesklang['remove_lan']='Eltávolítás';
$hesklang['title_lan']='Cím';
$hesklang['description_lan']='Leírás';
$hesklang['completed_lan']='Befejezve';
$hesklang['no_language_availble']='Nincs elérhető nyelv';
$hesklang['success_install_lan_txt']='A nyelv sikeresen hozzáadva';
$hesklang['error_install_lan_txt']='Nem lett nyelv hozzáadva';
$hesklang['success_remove_lan_txt']='A nyelv sikeresen eltávolítva';
$hesklang['error_remove_lan_txt']='a nyelvet nem távolították el';
$hesklang['remove_default_language_error']='Az alapértelmezett nyelvnek aktívnak kell maradnia, és nem távolítható el.';
$hesklang['click_for_manual_step']='Kattintson a manuális telepítéshez';
$hesklang['upgrade_lan']='Frissítés';
$hesklang['success_upgrade_lan_txt']='A nyelv sikeresen frissítve';
$hesklang['error_upgrade_lan_txt']='a nyelv nem frissült';
$hesklang['please_wait']='Kérjük, várjon...';
$hesklang['add_a_note']='Megjegyzés hozzáadása';
$hesklang['add_a_reply']='Válasz hozzáadása';
$hesklang['customer_id']='Ügyfél-azonosító';
$hesklang['deleting_customer_tickets']='Ügyfél által megnyitott jegyek: <b>%1$s</b><br>Mit tegyünk ezekkel a jegyekkel?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Jegyek, amelyekből az ügyfél másolatot kap: <b>%1$s</b><br>Ezek elveszítik ezt az ügyfelet, mint követőt; a jegyek változatlanok maradnak.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Jegyek végleges törlése';
$hesklang['deleting_customer_anonymize_tickets2']='Anonimizálja a jegyeket (üzenetek és személyes adatok eltávolítása)';
$hesklang['deleting_customer_retain_tickets2']='Őrizd meg a jegyeket (hagyd érintetlenül az összes adatot)';
$hesklang['for_staff']='az ügyfélszolgálat munkatársainak'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='ügyfelek számára'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP postafiók';
$hesklang['file_attachment_options']='E-mail mellékletek beállításai';
$hesklang['link_to_attachments_in_emails']='Mellékletekre mutató hivatkozás e-mailekben';
$hesklang['add_attachments_directly_to_emails']='Mellékletek hozzáadása közvetlenül az e-mailekhez';
$hesklang['directly_attach_file_smaller_than']='Csak a következőnél kisebb fájlokat csatolhat közvetlenül:';
$hesklang['directly_attach_file_of_any_size']='Bármilyen méretű fájl közvetlen csatolása';
$hesklang['directly_attach_only_first_x_attachments']='Közvetlenül csak az elsőt csatold';
$hesklang['directly_attach_all_attachments']='Az összes melléklet közvetlen csatolása';
$hesklang['directly_attach_size']='Melléklet mérete';
$hesklang['directly_attach_no_of_files']='Fájlok száma';
$hesklang['notice_about_directly_attach_files']='Sok vagy nagyméretű fájl csatolása az e-mailekhez késéseket okozhat az SMTP-kiszolgálóval való kommunikáció során.';
$hesklang['fatt_2']='Az üzenethez csatolt további fájlok:';
$hesklang['no_collaborators']='Egyik sem';
$hesklang['collaborate']='Együttműködés ezen a jegyen';
$hesklang['collaborators']='Együttműködők';
$hesklang['ql_cbm']='Együttműködő';
$hesklang['collaborating']='Mostantól együttműködsz ezen a jegyen';
$hesklang['not_collaborating']='Többé nem működsz együtt ezen a jegyen.';
$hesklang['add_collaborator']='Együttműködő hozzáadása';
$hesklang['user_collaborator_added']='Felhasználó hozzáadva együttműködőként ehhez a jegyhez';
$hesklang['remove_collaborator']='Együttműködő eltávolítása';
$hesklang['staff_name']='Személyzet neve';
$hesklang['user_collaborator_removed']='Felhasználó eltávolítva közreműködőként ebből a jegyből';
$hesklang['desc_collaborator_added']='(Személyzet) Egy új jegyen dolgozol együtt.';
$hesklang['desc_collaborator_staff_reply']='(Személyzet) Egy munkatárs válaszolt egy közösen kiadott jegyre';
$hesklang['desc_collaborator_note']='(Személyzet) Új jegyzet hozzáadva egy együttműködött jegyhez';
$hesklang['desc_collaborator_resolved']='(Személyzet) Egy együttműködő jegy megoldva';
$hesklang['desc_collaborator_overdue']='(Személyzet) Egy együttműködő jegy lejárt.';
$hesklang['notify_collaborator_added']='Hozzáadtak jegykezelőként';
$hesklang['notify_collaborator_customer_reply']='Az ügyfél válaszol egy együttműködött jegyre';
$hesklang['notify_collaborator_staff_reply']='A személyzet válaszol egy együttműködő jegyre';
$hesklang['notify_collaborator_note']='A személyzet megjegyzést fűz egy közösen készített jegyhez';
$hesklang['notify_collaborator_resolved']='A személyzet megold egy együttműködő jegyet';
$hesklang['notify_collaborator_overdue']='Az együttműködésen alapuló jegy lejárt';
$hesklang['recurring_tickets']['tab']='Ismétlődő jegyek'; // Menu link
$hesklang['recurring_tickets']['page_title']='Ismétlődő jegyek'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatizáld az időrabló feladatokat; bízd a Heskre a rutinszerű jegyek létrehozását – éppen akkor, amikor szükséged van rájuk.';
$hesklang['recurring_tickets']['active_rules']='Aktív szabályok';
$hesklang['recurring_tickets']['new']='Új ismétlődő jegyszabály';
$hesklang['recurring_tickets']['no_rules']='Nincsenek ismétlődő jegyszabályai. Hozzon létre egyet a fenti &quot;Új ismétlődő jegyszabály&quot; gombra kattintva.';
$hesklang['recurring_tickets']['title']='Szabály címe';
$hesklang['recurring_tickets']['titlet']='Egy leíró cím, például: Az egy napon belül meg nem válaszolt jegyek újraosztása';
$hesklang['recurring_tickets']['default_title']='Szabályozás %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Szabály kiváltója';
$hesklang['recurring_tickets']['trigt']='Állítsa be azt a feltételt, amely aktiválja (lefuttatja) ezt a szabályt.';
$hesklang['recurring_tickets']['hits']='Találatok'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Létrehozási idő'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Általános beállítások'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Egyéni mezők'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Tartalom'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Törli ezt a szabályt?';
$hesklang['recurring_tickets']['edit']='Ismétlődő jegyszabály azonosítójának szerkesztése %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Belül:';
$hesklang['recurring_tickets']['minutes']='perc';
$hesklang['recurring_tickets']['hours']='óra';
$hesklang['recurring_tickets']['days']='nap';
$hesklang['recurring_tickets']['weeks']='hét';
$hesklang['recurring_tickets']['months']='hónap';
$hesklang['recurring_tickets']['years']='év';
$hesklang['recurring_tickets']['setpri']='Prioritás beállítása erre:';
$hesklang['recurring_tickets']['setsta']='Állapot beállítása erre:';
$hesklang['recurring_tickets']['assto']='Jegy hozzárendelése ehhez:';
$hesklang['recurring_tickets']['asm']='Egy másik alkalmazott';
$hesklang['recurring_tickets']['notify']='Értesítsd a munkatársakat...';
$hesklang['recurring_tickets']['ato']='Jelentkezés ide:';
$hesklang['recurring_tickets']['save']='Szabály mentése';
$hesklang['recurring_tickets']['e_tt']='Az időnek 1 és 10000 között kell lennie';
$hesklang['recurring_tickets']['nocat']='Válasszon ki legalább egy kategóriát';
$hesklang['recurring_tickets']['nouser']='Válasszon ki legalább egy felhasználót';
$hesklang['recurring_tickets']['nostatus']='Válasszon ki legalább egy állapotot';
$hesklang['recurring_tickets']['nocata']='%1$s nincs hozzáférése ezekhez a kategóriához:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Új szabály jött létre';
$hesklang['recurring_tickets']['mdf']='A szabálybeállítások mentésre kerültek';
$hesklang['recurring_tickets']['e_id']='Nem található ilyen azonosítójú szabály';
$hesklang['recurring_tickets']['deleted']='A kiválasztott szabály törölve lett';
$hesklang['recurring_tickets']['log_title']='Szabály #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Aktív'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Aktiválja ezt a szabályt (kezdje el használni)';
$hesklang['recurring_tickets']['activated']='A kiválasztott szabály aktiválva lett'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='A szabály deaktiválása (használatának leállítása)';
$hesklang['recurring_tickets']['deactivated']='A kiválasztott szabály deaktiválva lett'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Nincsenek aktív ismétlődő jegyszabályok';
$hesklang['recurring_tickets']['tools']='Eszközök';
$hesklang['recurring_tickets']['tbef']='Mielőtt egy szabály élessé válna, aktiválnia kell azt az &quot;AKTÍV&quot; oszlopban található jelölőnégyzetre kattintva.<br><br>
                               <strong>Az aktív szabályok %2$s percenként feldolgozásra kerülnek.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[SZABÁLY]';
$hesklang['recurring_tickets']['r2']='[SZABÁLY] Szabály #%s';
$hesklang['recurring_tickets']['r3']='Szabály #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='A ma már létrehozott jegyek száma: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Szabály visszaállítása';
$hesklang['recurring_tickets']['reset2']='Biztosan vissza szeretné állítani ezt a szabályt?<br><br>A szabálytalálatok száma 0-ra csökken, és a ma már generált jegyek a következő cron futtatáskor újragenerálódhatnak.';
$hesklang['recurring_tickets']['reset3']='A kiválasztott szabály visszaállítva';
$hesklang['recurring_tickets']['test']='Szimulálja ezt a szabályt';
$hesklang['recurring_tickets']['testa']='Az összes szabály szimulálása';
$hesklang['recurring_tickets']['testaa']='Az összes aktív szabály szimulálása';
$hesklang['recurring_tickets']['testr']='Szimulációs eredmények';
$hesklang['recurring_tickets']['rsim']='Ismételje meg a szimulációt';
$hesklang['recurring_tickets']['sim']='SZIMULÁCIÓS MÓD, nincs változás az adatbázisban';
$hesklang['recurring_tickets']['sic']='SZIMULÁCIÓ BEFEJEZVE';
$hesklang['recurring_tickets']['rrule_type_required']='Kérjük, válasszon egy érvényes ismétlődő szabályindítót.';
$hesklang['recurring_tickets']['rrule_string_required']='Kérjük, válassza ki az összes szükséges ismétlődő szabály aktiválási opcióját.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Kérjük, adjon meg egy 1-es vagy nagyobb intervallumértéket a "Minden" értékhez..';
$hesklang['recurring_tickets']['disable_note']='*Ha egy szabály létrehozása után bármilyen kritikus védelmi beállítás megváltozik, a szabály a következő futtatási kísérletkor letiltásra kerül, és az új érvényesítési követelményeknek való megfeleléshez szerkeszteni kell.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | Beküldte: Ismétlődő jegyek szabálya "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | Az Ismétlődő Jegyek Szabálya hozzárendelte ehhez: %2$s "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | automatikusan lezárva az Ismétlődő jegyek szabálya alapján "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | Az állapotot %2$s-ra módosította az Ismétlődő jegyek szabálya "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatikusan hozzárendelve ehhez: %2$s az Ismétlődő jegyek szabálya alapján "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='A szabályt érvényesítési hibák miatt letiltottuk. A részletekért lásd alább.';
$hesklang['recurring_tickets']['errors_title']='Egy vagy több szabályod hibát jelzett a futtatásuk során, ezért letiltásra kerültek.';
$hesklang['recurring_tickets']['rule_errors']='<hr>#%s szabályhibák:';
$hesklang['recurring_tickets']['create_customers']='Nincsenek meglévő ügyfelek - kérjük, hozza létre őket <a href="%s" target="_blank">here</a>.';
$hesklang['recurring_tickets']['exec_dates']='Szabály végrehajtási dátumai';
$hesklang['recurring_tickets']['show_exec_dates']='[Aktuális szabályvégrehajtási dátumok megjelenítése]';
$hesklang['recurring_tickets']['no_exec_dates']='Kérjük, válasszon érvényes szabályindítókat a végrehajtási dátumok megtekintéséhez.';
$hesklang['recurring_tickets']['invalid_disabled']='érvénytelen szabálybeállítások - szabály letiltva.';
$hesklang['recurring_tickets']['next_occ']='Következő %s szabály előfordulások:';
$hesklang['recurring_tickets']['occ_on']='on %s';
$hesklang['recurring_tickets']['not_firing_today']='Ma nem kell lefuttatni';
$hesklang['recurring_tickets']['rules_fulfilled']='Az ismétlődő szabályok teljesültek – a jegy ma létrejött!';
$hesklang['recurring_tickets']['validation_failed']='érvényesítés sikertelen - a szabály letiltva. Részletek alább:';
$hesklang['recurring_tickets']['validation_error']='Érvényesítési hiba:';
$hesklang['recurring_tickets']['processed']='feldolgozott.';
$hesklang['recurring_tickets']['created_ticket']='létrehozva a jegy azonosítója: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='a jegy létrehozási dátumához képest';
$hesklang['priorities']='Prioritások';
$hesklang['priority_intro']='Használja ezt az eszközt a segélyszolgálat jegyprioritásának kezelésére';
$hesklang['new_priority']='Új prioritás';
$hesklang['edit_priority']='Prioritás szerkesztése';
$hesklang['priority_title']='Cím';
$hesklang['can_customers_select_it']='Kiválaszthatják-e az ügyfelek ezt a prioritást?';
$hesklang['selected_by_customer']='Ügyfél által választható';
$hesklang['err_priority']='Adja meg a prioritási címet';
$hesklang['priority_added']='Új prioritás került hozzáadásra';
$hesklang['priority_e_id']='Érvénytelen prioritásazonosító';
$hesklang['priority_mdf']='Prioritás mentve';
$hesklang['priority_deleted']='Prioritás törölve';
$hesklang['priority_not_found']='Ez a prioritás nem létezik';
$hesklang['priority_not_empty']='Ez a prioritás nem törölhető, mert már léteznek ilyen prioritású jegyek.';
$hesklang['click_to_enable_drag_drop']='Kattints a sor húzásával történő áthelyezésének engedélyezéséhez, majd húzd a sort felfelé vagy lefelé a prioritások átrendezéséhez.';
$hesklang['confirm_delete_priority']='Biztosan törölni szeretné ezt a prioritást?';
$hesklang['reordered_message']='A prioritási lista sorrendjét mentettük.';
$hesklang['list_tkt_priority']='Az összes ilyen prioritású jegy listázása';
$hesklang['deletion_priority_restricted']='Ez egy különleges prioritású, és nem törölhető';
$hesklang['priority_limit']='Nem hozhatsz létre új prioritásokat';
$hesklang['skip_to_main_content']='Ugrás a fő tartalomra';
$hesklang['opens_dialog']='Megnyit egy párbeszédpanelt';
$hesklang['create_a_ticket']='Jegy létrehozása';
$hesklang['toggle_navigation']='Navigáció váltása';
$hesklang['add_a_ticket_reply']='Jegyre adott válasz hozzáadása';
$hesklang['linked_tickets']='Kapcsolódó jegyek';
$hesklang['no_linked_tickets']='Nincsenek összekapcsolt jegyek';
$hesklang['link_ticket']='Jegy összekapcsolása';
$hesklang['can_link_tickets_e']='Nincs jogosultsága a jegy összekapcsolására/szétválasztására';
$hesklang['link_ticket_success']='A jegy sikeresen összekapcsolva';
$hesklang['link_ticket_required_error']='Jegy csatolásához kérjük, adjon meg egy érvényes követési azonosítót';
$hesklang['link_ticket_itself_error']='Egy jegy nem kapcsolható önmagához. Kérjük, adjon meg egy másik követőazonosítót.';
$hesklang['already_linked_error']='A jegyet már összekapcsolták';
$hesklang['unlink_success']='A jegy sikeresen szétválasztva';
$hesklang['unlink_error']='Nincs csatolt rekord';
$hesklang['link_history']='<li class="smaller">%s | %s jegylink a következőtől %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s jegy szétválasztása általa %s</li>';
$hesklang['can_link_tickets']='Össze lehet kapcsolni a jegyet';
$hesklang['link_a_ticket']='Jegy összekapcsolása';
$hesklang['mfa_curl']='Nem sikerült QR-kódot generálni a beolvasáshoz, mert a <strong>cURL</strong> támogatás nincs engedélyezve a szerveren.';
$hesklang['require_xml']='A PHP-XML-t engedélyezni kell a Rich Text (HTML) üzenetekhez. Kérjük, kérje meg webszolgáltatóját, hogy engedélyezze az XML-t a PHP-hez.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s munkatársként hozzáadta: %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s eltávolította együttműködőként a következő személy által: %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Tökéletes megelőző karbantartási feladatokhoz, havi hozzáférés-felülvizsgálatokhoz, rendszeres ügyfél-bejelentkezésekhez és egyebekhez.';
$hesklang['recurring_tickets']['feat1']='<strong>Állítson be és felejtsen el ütemterveket.</strong> Naponta, minden hétfőn, minden márciusban, minden hónap 15-én vagy bármely későbbi dátumon';
$hesklang['recurring_tickets']['feat2']='<strong>Előre kitöltve és hozzárendelve érkezzen meg.</strong> Válasszon kategóriát, prioritást, ügynököt és akár 100 egyéni mezőértéket';
$hesklang['recurring_tickets']['feat3']='<strong>Dátumok előnézete és szimuláció.</strong> Tekintse meg a Hesk által generált összes jegyet a szabály aktiválása előtt, így nincsenek meglepetések.';
$hesklang['unlink_btn']='Leválasztás';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='első';
$hesklang['recurring_tickets']['second']='második';
$hesklang['recurring_tickets']['third']='harmadik';
$hesklang['recurring_tickets']['fourth']='negyedik';
$hesklang['recurring_tickets']['fifth']='ötödik';
$hesklang['recurring_tickets']['rt1_txt']='Minden [X] napon a héten';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Minden [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Minden [X] napon a hónapban';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Minden [bymonthday] napon a hónapban';
$hesklang['recurring_tickets']['rt3_txt']='Minden [X] dátumon az évben';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Minden [bymonthday][bymonth] dátumon az évben';
$hesklang['recurring_tickets']['rt4_txt']='Minden [nth] [Week day] a hónapban';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Minden [bysetpos] [byweekday] a hónapban';
$hesklang['recurring_tickets']['rt5_txt']='Minden [x] [Nap/Hét/Hónap]';
$hesklang['recurring_tickets']['rt5_ui']='Minden [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='Adott dátumon';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]Ekkor: [dtstart]';


$hesklang['nickname']='Becenév';
$hesklang['nicknames']='Becenevek';
$hesklang['staff_nicknames']='Engedélyezze, hogy a munkatársak becenevet állítsanak be, amely az ügyfelek számára a valódi nevük helyett jelenik meg';
$hesklang['what_cust_see']='Ez az a név, amelyet az ügyfelek látnak. Ha üresen marad, a valódi név jelenik meg.';
$hesklang['login_credentials']='Bejelentkezési adatok';
$hesklang['change_pass_info']='A jelszó megváltoztatásához használja a „Jelszó szerkesztése” gombot a Profil oldalán';
$hesklang['email_column_display']='E-mail oszlop megjelenítése';
$hesklang['email_show_view']='„Megtekintés” link megjelenítése';
$hesklang['email_show_full']='Teljes e-mail cím megjelenítése';
$hesklang['customer_theme']='Ügyfél téma';
$hesklang['err_customer_theme']='Kérjük, válasszon érvényes ügyfél témát';
$hesklang['rebuild_assets']='Erőforrások újraépítése';
$hesklang['rebuild_assets_btn']='Éles erőforrások újraépítése';
$hesklang['rebuild_assets_success']='Az éles erőforrások sikeresen újraépültek.';
$hesklang['rebuild_again']='Újraépítés ismét';
$hesklang['rebuilt_assets']='Csomagolt és tömörített erőforrások:';
$hesklang['tab_8']='Megjelenés';
$hesklang['laf']='Megjelenés';
$hesklang['theme_name_default']='Óceánkék (Alapértelmezett)';
$hesklang['theme_name_midnight_ocean']='Éjféli óceán (Sötét)';
$hesklang['theme_name_modern_light']='Modern világos';
$hesklang['theme_colors_note']='A legtöbb téma szín automatikusan a fő márkaszínekből készül. Ez segít az egységes megjelenésben és időt takarít meg.<br><br>Az automatikus színek csillaggal (<span class="asterix"></span>) vannak jelölve és a Haladó beállítások alatt találhatók. A fő márkaszín módosításakor az összes kapcsolódó szín is módosul, hacsak nem írja felül manuálisan.';
$hesklang['theme_changed_note']='Vannak meglévő téma-szín felülbírálásai, amelyek nem biztos, hogy jól működnek ezzel a témával – érdemes lehet visszaállítani őket az „Összes felülbírálás visszaállítása” gombbal.';
$hesklang['theme_overrides']='Téma szín felülbírálások';
$hesklang['reset_all_overrides']='Összes felülbírálás visszaállítása';
$hesklang['view_advanced']='Haladó beállítások megtekintése';
$hesklang['view_basic']='Vissza az alapbeállításokhoz';
$hesklang['invalid_theme_setting']='Érvénytelen beállításkulcs: „%s”.';
$hesklang['invalid_hex_color']='Érvénytelen HEX szín: „%s” a(z) %s kulcshoz.';
$hesklang['theme_var--yellow-1']='Sárga (Elsődleges)';
$hesklang['theme_var--yellow-2']='Sárga (Másodlagos)';
$hesklang['theme_var--green-1']='Zöld';
$hesklang['theme_var--red-1']='Piros (Elsődleges)';
$hesklang['theme_var--red-2']='Piros (Másodlagos)';
$hesklang['theme_var--success']='Siker szín';
$hesklang['theme_var--success-2']='Siker (Másodlagos)';
$hesklang['theme_var--error']='Hiba szín';
$hesklang['theme_var--error-2']='Hiba (Másodlagos)';
$hesklang['theme_var--error-3']='Hiba (Harmadlagos)';
$hesklang['theme_var--warning']='Figyelmeztetés szín';
$hesklang['theme_var--warning-2']='Figyelmeztetés (Másodlagos)';
$hesklang['theme_var--info']='Információ szín';
$hesklang['theme_var--info-2']='Információ (Másodlagos)';
$hesklang['theme_var--info-3']='Információ (Harmadlagos)';
$hesklang['theme_var--notification__clr']='Értesítés szövegszíne';
$hesklang['theme_var--primary']='Elsődleges szín';
$hesklang['theme_var--secondary']='Másodlagos szín';
$hesklang['theme_var--tertiary']='Harmadlagos szín';
$hesklang['theme_var--surface']='Felület szín';
$hesklang['theme_var--main-background']='Fő háttér';
$hesklang['theme_var--font__pri-clr']='Elsődleges betűszín';
$hesklang['theme_var--font__sec-clr']='Másodlagos betűszín';
$hesklang['theme_var--header_logo__clr']='Fejléc logó háttérszíne';
$hesklang['theme_var--header__bg']='Fejléc háttér';
$hesklang['theme_var--header_nav__clr']='Fejléc navigáció színe';
$hesklang['theme_var--header_nav__hover_clr']='Fejléc navigáció hover színe';
$hesklang['theme_var--header_links__clr']='Fejléc linkek színe';
$hesklang['theme_var--input-bg']='Beviteli mező háttér';
$hesklang['theme_var--input-clr']='Beviteli mező szövegszíne';
$hesklang['theme_var--link__pri-clr']='Elsődleges link színe';
$hesklang['theme_var--link__pri-hover-clr']='Elsődleges link hover színe';
$hesklang['theme_var--link__sec-clr']='Másodlagos link színe';
$hesklang['theme_var--link__sec-hover-clr']='Másodlagos link hover színe';
$hesklang['theme_var--footer__link-clr']='Lábléc link színe';
$hesklang['theme_var--radio__bg']='Rádiógomb háttér';
$hesklang['theme_var--radio__fill-clr']='Rádiógomb kitöltő színe';
$hesklang['theme_var--radio__hover-bg']='Rádiógomb hover háttér';
$hesklang['theme_var--radio__hover-fill-clr']='Rádiógomb hover kitöltő színe';
$hesklang['theme_var--checkbox__bg']='Jelölőnégyzet háttér';
$hesklang['theme_var--checkbox__hover-bg']='Jelölőnégyzet hover háttér';
$hesklang['theme_var--preview__bg']='Cikk előnézet háttér';
$hesklang['theme_var--preview__border-clr']='Cikk előnézet keret színe';
$hesklang['theme_var--preview__hover-bg']='Cikk előnézet hover háttér';
$hesklang['theme_var--preview__hover-icon-fill']='Cikk előnézet hover ikon színe';
$hesklang['theme_var--preview__title-clr']='Cikk előnézet cím színe';
$hesklang['theme_var--suggest_preview__bg']='Cikkjavaslat háttér';
$hesklang['theme_var--suggest_preview__clr']='Cikkjavaslat színe';
$hesklang['theme_var--suggest_preview__border-clr']='Cikkjavaslat keret színe';
$hesklang['theme_var--suggest_preview__hover-bg']='Cikkjavaslat hover háttér';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Cikkjavaslat hover ikon színe';
$hesklang['theme_var--suggest_preview__title-clr']='Cikkjavaslat cím színe';
$hesklang['theme_var--article_preview__hover-clr']='Cikkjavaslat hover színe';
$hesklang['theme_var--article_preview_suggestion_clr']='Cikkjavaslat színe';
$hesklang['theme_var--ticket_body__bg']='Jegy tartalom háttér';
$hesklang['theme_var--ticket_response__bg']='Jegy válasz háttér';
$hesklang['theme_var--table_row__bg']='Táblázat sor háttér';
$hesklang['theme_var--table_row__bg-even']='Táblázat sor háttér (páros)';
$hesklang['theme_var--table_row__bg-hover']='Táblázat sor hover háttér';
$hesklang['theme_var--breadcrumbs__a-clr']='Morzsamenü link színe';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Morzsamenü link hover színe';
$hesklang['theme_var--header_profile__clr']='Profil menü színe';
$hesklang['theme_var--header_profile__menu-bg']='Profil menü háttér';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profil menü avatar háttér';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profil menü avatar háttér (mobil)';
$hesklang['theme_var--navlink__bg']='Navigációs doboz háttér';
$hesklang['theme_var--navlink__clr']='Navigációs doboz színe';
$hesklang['theme_var--navlink__hover-bg']='Navigációs doboz hover háttér';
$hesklang['theme_var--navlink__title-clr']='Navigációs doboz cím színe';
$hesklang['theme_var--step_bar__item-clr']='Lépéssáv elem színe';
$hesklang['theme_var--search__clr']='Keresés színe';
$hesklang['theme_var--search__bg']='Keresés háttér';
$hesklang['theme_var--search__title-clr']='Keresés cím színe';
$hesklang['theme_var--search__input-placeholder-clr']='Keresőmező helykitöltő színe';
$hesklang['theme_var--search__icon-fill']='Keresés ikon színe';
$hesklang['theme_var--search__input-bg']='Keresőmező háttér';
$hesklang['theme_var--modal_body__bg']='Modális ablak törzs háttér';
$hesklang['theme_var--btn__bg-clr-pri']='Elsődleges gomb háttér';
$hesklang['theme_var--btn__clr-pri']='Elsődleges gomb szövegszín';
$hesklang['theme_var--btn__border-clr-pri']='Elsődleges gomb keretszín';
$hesklang['theme_var--btn__disabled-bg-clr']='Letiltott gomb háttér';
$hesklang['theme_var--btn__disabled-clr']='Letiltott gomb szövegszín';
$hesklang['theme_var--dropdown__bg']='Legördülő háttér';
$hesklang['theme_var--dropdown__clr']='Legördülő szöveg szín';
$hesklang['theme_var--dropdown__border-clr']='Legördülő keretszín';
$hesklang['theme_var--dropdown_ver1__border-clr']='Legördülő (1. verzió) keretszín';
$hesklang['theme_var--dropdown_ver2__border-clr']='Legördülő (2. verzió) keretszín';
$hesklang['theme_var--dropdown__hover-bg']='Legördülő hover háttér';
$hesklang['theme_var--dropdown__hover-clr']='Legördülő hover szöveg';
$hesklang['theme_var--dropdown__hover-border-clr']='Legördülő hover keret';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Legördülő (2. verzió) hover keret';
$hesklang['theme_var--datepicker_btn__bg']='Dátumválasztó gomb háttér';
$hesklang['theme_var--datepicker_btn__clr']='Dátumválasztó gomb szöveg';
$hesklang['theme_var--datepicker__bg']='Dátumválasztó háttér';
$hesklang['theme_var--datepicker__clr']='Dátumválasztó szöveg';
$hesklang['theme_group_main_brand']='Fő márka';
$hesklang['theme_group_main_elements']='Fő elemek';
$hesklang['theme_group_buttons']='Gombok';
$hesklang['theme_group_navigation']='Navigáció';
$hesklang['theme_group_dropdowns']='Legördülők';
$hesklang['theme_group_datepickers']='Dátumválasztók';
$hesklang['theme_group_base_colors']='Alapszínek';
$hesklang['theme_group_notifications']='Értesítések';
$hesklang['theme_group_search']='Keresés';
$hesklang['theme_group_article_previews']='Cikk előnézetek';
$hesklang['theme_group_misc']='Egyéb';
$hesklang['customer_email_exists_already_registered']='Már létezik regisztrált ügyfél ezzel az e-mail címmel.';
$hesklang['link_id']='Jegyszám vagy követési azonosító'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Jogosultsági csoportok kezelése';
$hesklang['permission_groups_title']='Jogosultsági csoportok';
$hesklang['permission_groups_intro']='A jogosultsági csoportok lehetővé teszik, hogy egyszerre több felhasználónak rendeljen helpdesk jogosultságokat.';
$hesklang['permission_groups_new']='Új jogosultsági csoport';
$hesklang['permission_groups_name']='Név';
$hesklang['permission_groups_staff_count']='Munkatársak száma';
$hesklang['permission_groups_copy']='Jogosultsági csoport másolása';
$hesklang['permission_groups_none']='Jelenleg nincs jogosultsági csoport az adatbázisban. Hozza létre az elsőt a fenti „Új jogosultsági csoport” gombra kattintva.';
$hesklang['permission_groups_delete_not_allowed']='Ez a jogosultsági csoport nem törölhető, mert munkatársak vannak hozzárendelve';
$hesklang['permission_groups_delete_confirm']='Biztosan törölni szeretné ezt a jogosultsági csoportot?';
$hesklang['permission_groups_create_title']='Új jogosultsági csoport hozzáadása';
$hesklang['permission_groups_create_general_info']='Általános információk';
$hesklang['permission_groups_create_users_none']='Az összes helpdesk munkatárs adminisztrátor, nincs szükség jogosultsági csoportra.';
$hesklang['permission_groups_create_submit']='Jogosultsági csoport létrehozása';
$hesklang['permission_groups_create_success']='A(z) %s jogosultsági csoport sikeresen létrejött'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Jogosultsági csoport szerkesztése';
$hesklang['permission_groups_edit_success']='A jogosultsági csoport sikeresen frissült';
$hesklang['permission_groups_error_duplicate']='Már létezik jogosultsági csoport ezzel a névvel: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='A jogosultsági csoport frissítése sikertelen jogosultsági probléma miatt.';
$hesklang['permission_groups_error_name']='Adja meg a jogosultsági csoport nevét';
$hesklang['permission_groups_error_missing_category_feature']='Legalább egy kategóriát vagy funkciót ki kell választani';
$hesklang['permission_groups_deleted']='Jogosultsági csoport törölve';
$hesklang['edit_user_notice_with_permission_groups']='Ez a felhasználó jogosultsági csoporton keresztül fér hozzá kategóriákhoz vagy funkciókhoz. A hozzáférés eltávolításához vegye ki őket a jogosultsági csoportból.';
$hesklang['link_selected_tickets']='Kijelölt jegyek összekapcsolása';
$hesklang['at_least_two_more']='Legalább két jegyet kell kijelölni az összekapcsoláshoz.';
$hesklang['selected_link_success']='A kijelölt jegyek összekapcsolása sikeres.<br><br>Új kapcsolatok: %s<br>Meglévő kapcsolatok figyelmen kívül hagyva: %s';
$hesklang['confirm_ordering_title']='Automatikus módosítások megerősítése';
$hesklang['order_cat_by_name']='Kategóriák rendezése név szerint';
$hesklang['warning_order_cat_by_name']='Biztosan név szerint szeretné rendezni a kategóriákat? Ez automatikusan nem vonható vissza!';
$hesklang['success_order_cat_by_name']='A kategóriák sikeresen név szerint lettek rendezve.';
$hesklang['order_cat_by_id']='Kategóriák rendezése azonosító szerint';
$hesklang['warning_order_cat_by_id']='Biztosan azonosító szerint szeretné rendezni a kategóriákat? Ez automatikusan nem vonható vissza!';
$hesklang['success_order_cat_by_id']='A kategóriák sikeresen azonosító szerint lettek rendezve.';
$hesklang['download_selected']='Kijelöltek letöltése';
$hesklang['delete_selected']='Kijelöltek törlése';
$hesklang['attach_delete_db']='A kijelölt mellékletek sikeresen eltávolításra kerültek az adatbázisból';
$hesklang['mute_emails']='E-mailek némítása';
$hesklang['mute_email_intro']='Ha egy e-mail cím némítva van, a felhasználó továbbra is küldhet jegyeket és használhatja a rendszert, azonban nem kerülnek kiküldésre kimenő e-mailek erre a címre.';
$hesklang['mute_an_email']='Adja meg a némítandó e-mail címet';
$hesklang['save_mute_email']='E-mail némítása';
$hesklang['muted_by']='Némította';
$hesklang['no_mute_emails']='Nincs némított e-mail.';
$hesklang['enter_mute_email']='Adja meg a némítandó e-mail címet.';
$hesklang['valid_mute_email']='Adjon meg érvényes e-mail címet (<i>john.doe@example.com</i>) vagy e-mail domaint (<i>@example.com</i>)';
$hesklang['email_muted']='A(z) <i>%s</i> e-mail cím némításra került. Erre a címre többé nem kerülnek kiküldésre e-mailek.'; // %s will be replaced with email
$hesklang['email_mute_exists']='A(z) <i>%s</i> e-mail cím már némítva van.'; // %s will be replaced with email
$hesklang['email_unmuted']='Az e-mail cím némítása sikeresen megszüntetve';
$hesklang['del_mute_confirm']='Feloldja az e-mail cím némítását?';
$hesklang['can_mute_emails']='E-mailek némítása engedélyezett';
$hesklang['can_unmute_emails']='E-mailek némításának feloldása (engedélyezi az e-mailek némítását)';
$hesklang['eis_mute']='Ez az e-mail cím némítva van.';
$hesklang['click_unmute']='Kattintson ide a némítás feloldásához.';
$hesklang['del_mute']='Némítás feloldása';
$hesklang['unmute_email']='E-mail némításának feloldása';
$hesklang['can_merge_customers']='Ügyfelek egyesítése (Ügyfelek kezelése jogosultság szükséges)';
$hesklang['merge_selected_customers']='Kijelölt ügyfelek egyesítése';
$hesklang['customer_merge_complete']='A kijelölt ügyfélfiókok sikeresen egyesítésre kerültek.';
$hesklang['merge_more_error']='Az egyesítéshez legalább két ügyfelet kell kiválasztani.';
$hesklang['merge_target_error']='A cél ügyfél nem található.';
$hesklang['merge_customer_err']='Hiba történt az ügyfelek egyesítése során:';
$hesklang['error_msg_for_approved']='A kiválasztott ügyfelek egy része már jóvá lett hagyva, további feldolgozás nem szükséges.';
$hesklang['confirm_merge']='Fiókok egyesítésének megerősítése';
$hesklang['confirm_merge_text']='Biztosan egyesíti a kijelölt ügyfeleket?';
$hesklang['confirm_merge_additional_text']='Az egyesítés a kiválasztott ügyfélfiókokat egy fiókká vonja össze. Az egyesítés után a művelet nem vonható vissza.';
$hesklang['customers_pending_approval']='Jóváhagyásra váró ügyfélregisztrációk';
$hesklang['existing_customers']='Meglévő ügyfelek';
$hesklang['cant_deactivate_admin']='Az alapértelmezett adminisztrátor nem deaktiválható!';
$hesklang['cant_deactivate_own']='A saját, bejelentkezett profilt nem deaktiválhatja!';
$hesklang['deactivated_users']='Deaktivált felhasználók';
$hesklang['deactivate_user']='Felhasználó deaktiválása';
$hesklang['activate_user']='Felhasználó aktiválása';
$hesklang['user_deactivated']='A kiválasztott felhasználó deaktiválásra került';
$hesklang['user_activated']='A kiválasztott felhasználó aktiválásra került';
$hesklang['confirm_deactivation']='Deaktiválás megerősítése';
$hesklang['sure_deactivate_user']='Biztosan deaktiválja ezt a felhasználót?';
$hesklang['deactivating_user_with_tickets']='A felhasználóhoz rendelt jegyek száma: %1$s<br>Nyitott jegyek száma: %2$s<br><br>A <b>nyitott</b> jegyek a felhasználó deaktiválása után <b>leválasztásra</b> kerülnek.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Mezők a jegylistában – ügyfél oldal';
$hesklang['setting_extend']='Munkamenetek meghosszabbítása';
$hesklang['extend_admin']='Munkatársi munkamenetek automatikus meghosszabbítása';
$hesklang['extend_customer']='Ügyfél munkamenetek automatikus meghosszabbítása';
$hesklang['setting_process_to_cc']='E-mail követők';
$hesklang['setting_process_to_cc_notice']='A funkció működéséhez engedélyeznie kell a(z) „%s” opciót a(z) %s &gt; %s &gt; %s oldalon';
$hesklang['email_include_to']='A „Címzett (To)” fejlécben szereplő kapcsolatok hozzáadása jegy követőként';
$hesklang['email_include_cc']='A „Másolat (Cc)” fejlécben szereplő kapcsolatok hozzáadása jegy követőként';
$hesklang['purge_cache']='Gyorsítótár törlése';
$hesklang['purge_cache_btn']='Teljes gyorsítótár törlése most';
$hesklang['purge_cache_done']='A gyorsítótár törlésre került';
$hesklang['customer_name_email_exists']='Már létezik ügyfél ezzel a névvel és e-mail címmel.';
$hesklang['no_cust_sel']='Nincs kiválasztott ügyfél, nincs teendő';
$hesklang['spam_inbox_notice']='<b>Nincs megerősítő e-mail?</b><br />Megerősítő üzenetet küldtünk az e-mail címére. Ha néhány percen belül nem érkezik meg, ellenőrizze a Levélszemét vagy Spam mappát. Jelölje meg az üzenetet <b>Nem spam</b>-ként a jövőbeni problémák elkerülése érdekében.';
$hesklang['write_down_notice']='Javasoljuk, hogy jegyezze fel a jegyazonosítót későbbi hivatkozás céljából.';
$hesklang['theme_colors_note_co']='A témák jelenleg csak a nyilvános (ügyfél oldali) helpdesk oldalakat érintik.';
$hesklang['ticket_already_in_category']='Ez a jegy már a(z) %s kategóriában van, nem történt módosítás.';
$hesklang['ticket_already_priority']='Ennek a jegynek a prioritása már %s, nem történt módosítás.';
$hesklang['ticket_already_unassigned']='Ez a jegy már nincs hozzárendelve, nem történt módosítás.';
$hesklang['conok_but_no_count']='A kapcsolat működik, de nem sikerült érvényes e-mail számot lekérni. <a href="%s">Próbálja ezt</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Egyéni HTML';
$hesklang['custom_html_link']='Fejléc és lábléc HTML szerkesztése';
$hesklang['custom_head']='Egyéni Head';
$hesklang['custom_head_desc']='Egyéni HTML kód, amely a HTML dokumentum head részében jelenik meg (head.txt fájl).';
$hesklang['custom_head_cmnt']='A &lt;/head&gt; tag elé beszúrandó egyéni kód'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Egyéni fejléc';
$hesklang['custom_header_desc']='Egyéni HTML kód, amely a helpdesk törzse előtt jelenik meg (header.txt fájl). Például itt adhatja hozzá a <a href="%s" target="_blank">logó HTML kódját</a>.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='A &lt;body&gt; tag után beszúrandó egyéni kód'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Egyéni lábléc';
$hesklang['custom_footer_desc']='Egyéni HTML kód, amely a helpdesk törzse után jelenik meg (footer.txt fájl).';
$hesklang['custom_footer_cmnt']='A &lt;/body&gt; tag elé beszúrandó egyéni kód'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='A fájl hiányzik vagy nem írható: <b>%s</b><br><br>Állítsa be a megfelelő jogosultságokat, vagy szerkessze kézzel a fájlt. Linuxon próbálja meg a CHMOD 666 (rw-rw-rw-) beállítást.'; // %s = file name
$hesklang['uanble_not_writable']='A módosítások mentése nem lehetséges, mert a szükséges fájlok nem írhatók PHP által';
$hesklang['custom_html_saved']='Az egyéni HTML kód mentésre került';
$hesklang['custom_html_disabled']='Az egyéni HTML szerkesztése ebből a felületből le van tiltva. Kérjük, szerkessze manuálisan a head/header/footer fájlokat.';
$hesklang['search_by_category']='Kategória keresése vagy kiválasztása...';
$hesklang['imap_test_bad']='Lehetséges megoldásért lásd <a href="%s" target="_blank">ezt a tudásbázis útmutatót</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='Első válasz ideje';
$hesklang['reply_messages']='Válaszüzenetek';
$hesklang['ex_replies']='Jegyválaszok 포함ása az exportba';
$hesklang['remember_custom_field_values']='Egyéni mezők értékeinek megjegyzése';
$hesklang['disable_autocomplete']='Automatikus kiegészítés letiltása';
$hesklang['disable_autofill_admin']='autocomplete="off" attribútum hozzáadása az ügyfél „Jegy beküldése” űrlaphoz';
$hesklang['disable_autofill_customer']='autocomplete="off" attribútum hozzáadása a munkatárs „Jegy beküldése” űrlaphoz';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');