<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Italiano (Italian)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Marino Allegri (http://www.hostwebservice.com)
* Marco Borla (http://www.peopleinside.it)
* Tim Moses (http://securityreviewer.com)
* Marco Foradini
* Leopoldo Saggin aka Topoldo (http://www.bio.unipd.it/CIS/CIV/leopoldo.html)
* Nicola Saponieri
* Francesco Russo
* Eugenio Licitra
* Andrea Piran
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Italiano';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Italian';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Rispondi sopra questa riga ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Nuovo ticket: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Ticket ricevuto: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Ticket assegnato: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nuova risposta a: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nuova risposta a: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Ticket spostato: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Nota aggiunta a: %%SUBJECT%%';
$hesklang['new_pm']='Nuovo messaggio privato: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Elenco dei tuoi ticket';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Impossibile connettersi al database!';
$hesklang['invalid_action']='Azione non valida';
$hesklang['select_username']='Selezionare il nome utente';
$hesklang['enter_pass']='Inserire la password';
$hesklang['cant_sql']='Impossibile eseguire SQL';
$hesklang['contact_webmsater']='Segnalare questo errore al webmaster scrivendo a';
$hesklang['mysql_said']='MySQL riporta';
$hesklang['wrong_pass']='Password errata';
$hesklang['session_expired']='La sessione è scaduta, accedere nuovamente utilizzando il modulo seguente';
$hesklang['attempt']='Tentativo non valido!';
$hesklang['not_authorized_tickets']='Non si è autorizzati a visualizzare i ticket presenti in questa categoria!';
$hesklang['must_be_admin']='Non si è autorizzati a visualizzare questa pagina! Per poterlo fare bisogna effettuare l\'accesso come amministratori';
$hesklang['no_session']='Impossibile avviare una nuova sessione!';
$hesklang['error']='Errore';
$hesklang['int_error']='Errore interno dello script';
$hesklang['no_trackID']='Nessun codice del ticket';
$hesklang['status_not_valid']='Stato non valido';
$hesklang['trackID_not_found']='Codice del ticket non trovato';
$hesklang['enter_message']='Inserire il messaggio';
$hesklang['select_priority']='Scegliere la priorità';
$hesklang['ticket_not_found']='Ticket non trovato! Assicurarsi di aver inserito il codice corretto!';
$hesklang['no_selected']='Nessun ticket selezionato, nessuna modifica da apportare';
$hesklang['id_not_valid']='Questo codice non è valido';
$hesklang['enter_id']='Inserire il codice del ticket';
$hesklang['enter_name']='Inserire il nome del cliente';
$hesklang['enter_date']='Inserire la data che si vuol cercare';
$hesklang['date_not_valid']='Data non valida. Il formato deve essere <b>AAAA-MM-GG</b>';
$hesklang['enter_subject']='Inserire l\'oggetto del ticket';
$hesklang['invalid_search']='Ricerca non valida';
$hesklang['choose_cat_ren']='Selezionare la categoria da rinominare';
$hesklang['cat_ren_name']='Scrivere il nome della nuova categoria';
$hesklang['cat_not_found']='Categoria non trovata';
$hesklang['enter_cat_name']='Inserire il nome della categoria';
$hesklang['no_cat_id']='Codice categoria assente';
$hesklang['cant_del_default_cat']='Non si può eliminare la categoria predefinita. La si può solo rinominare';
$hesklang['no_valid_id']='Codice utente non valido';
$hesklang['user_not_found']='Utente non trovato';
$hesklang['enter_real_name']='Inserire il nome reale dell\'utente';
$hesklang['enter_valid_email']='Inserire un indirizzo di email valido';
$hesklang['enter_username']='Inserire il nome utente (username/login)';
$hesklang['asign_one_cat']='Assegnare l\'utente ad almeno una categoria!';
$hesklang['signature_long']='La firma è troppo lunga! Si prega di ridurla a 1000 caratteri';
$hesklang['confirm_user_pass']='Confermare la password';
$hesklang['passwords_not_same']='Le password inserite non coincidono!';
$hesklang['cant_del_admin']='Non è possibile eliminare l\'amministratore predefinito!';
$hesklang['cant_del_own']='Non è possibile eliminare il profilo utente con il quale si è collegati!';
$hesklang['enter_your_name']='Inserire Nome e Cognome';
$hesklang['sel_app_cat']='Selezionare la categoria appropriata';
$hesklang['sel_app_priority']='Selezionare la priorità appropriata';
$hesklang['enter_ticket_subject']='Inserire l\'oggetto del ticket';
$hesklang['user_not_found_nothing_edit']='Utente non trovato o nulla da modificare';

// ADMIN PANEL
$hesklang['administrator']='Amministratore';
$hesklang['login']='Accesso';
$hesklang['user']='Utente';
$hesklang['username']='Nome utente';
$hesklang['pass']='Password';
$hesklang['confirm_pass']='Conferma password';
$hesklang['logged_out']='Disconnesso';
$hesklang['logout']='Esci';
$hesklang['logout_success']='Disconnessione effettuata con successo!';
$hesklang['click_login']='Entra';
$hesklang['back']='Indietro';
$hesklang['displaying_pages']='Ticket visualizzati: <b>%d</b>. Pagine:';
$hesklang['trackID']='Codice ticket';
$hesklang['timestamp']='Timestamp';
$hesklang['name']='Nome e Cognome';
$hesklang['subject']='Oggetto';
$hesklang['status']='Stato';
$hesklang['priority']='Priorità';
$hesklang['open']='Nuovo';
$hesklang['open_action']='Apri ticket'; // Open ACTION
$hesklang['close']='Chiuso'; // Closed ticket STATUS
$hesklang['any_status']='Qualsiasi stato';
$hesklang['high']='Alta';
$hesklang['medium']='Media';
$hesklang['low']='Bassa';
$hesklang['del_selected']='Elimina i ticket selezionati';
$hesklang['manage_cat']='Gestione categorie';
$hesklang['profile']='Il tuo profilo';
$hesklang['show_tickets']='Mostra ticket';
$hesklang['sort_by']='Ordina per';
$hesklang['date_posted']='Data di invio';
$hesklang['category']='Categoria';
$hesklang['any_cat']='Qualsiasi categoria';
$hesklang['order']='Ordinamento';
$hesklang['ascending']='Crescente';
$hesklang['descending']='Decrescente';
$hesklang['display']='Visualizza';
$hesklang['tickets_page']='ticket per pagina';
$hesklang['find_ticket']='Cerca ticket';
$hesklang['yyyy_mm_dd']='AAAA-MM-GG';
$hesklang['results_page']='risultati per pagina';
$hesklang['opened']='aperto'; // The ticket has been OPENED
$hesklang['closed']='Risolto'; // Ticket has been RESOLVED
$hesklang['ticket']='Ticket';
$hesklang['tickets']='Ticket';
$hesklang['ticket_been']='Questo ticket è stato';
$hesklang['view_ticket']='Visualizzazione ticket';
$hesklang['open_tickets']='Ticket aperti';
$hesklang['remove_statement']='Rimuovi la scritta &quot;Powered by&quot;';
$hesklang['click_info']='Fare clic qui per maggiori informazioni';
$hesklang['reply_added']='Risposta aggiunta';
$hesklang['reply_submitted']='Risposta inviata';
$hesklang['ticket_marked']='Questo ticket è stato evidenziato';
$hesklang['ticket_status']='Stato del ticket';
$hesklang['replies']='Risposte';
$hesklang['date']='Data';
$hesklang['email']='Email';
$hesklang['ip']='IP';
$hesklang['message']='Messaggio';
$hesklang['add_reply']='Aggiungi risposta';
$hesklang['close_this_ticket']='Segna questo ticket come risolto';
$hesklang['change_priority']='Cambia la priorità in';
$hesklang['attach_sign']='Allega firma';
$hesklang['profile_settings']='Impostazioni profilo';
$hesklang['submit_reply']='Invia risposta';
$hesklang['support_panel']='Pannello di supporto';
$hesklang['ticket_trackID']='Codice ticket';
$hesklang['c2c']='Per continuare, fare clic qui';
$hesklang['tickets_deleted']='Ticket eliminati';
$hesklang['num_tickets_deleted']='Numero di ticket eliminati: <b>%d</b>';
$hesklang['confirm_del_cat']='Si è sicuri di voler rimuovere questa categoria?';
$hesklang['cat_intro']='Qui è possibile gestire le categorie. Le categorie servono per differenziare i ticket per rilevanza (per esempio &quot;Vendite&quot;, &quot;Problemi hardware&quot;,&quot;Problemi di PHP/MySQL&quot; ecc…) e per assegnare gli utenti alle categorie (per esempio la persona che si occupa di vendite può vedere solo i ticket inviati alle categorie &quot;Vendite&quot;)';
$hesklang['cat_name']='Nome';
$hesklang['remove']='Elimina';
$hesklang['add_cat']='Aggiungi nuova categoria';
$hesklang['max_chars']='40 caratteri al massimo';
$hesklang['create_cat']='Salva categoria';
$hesklang['ren_cat']='Rinomina categoria';
$hesklang['to']='a';
$hesklang['cat_added']='Categoria aggiunta';
$hesklang['cat_name_added']='La categoria %s è stata aggiunta con successo';
$hesklang['cat_renamed']='Categoria rinominata';
$hesklang['cat_renamed_to']='La categoria selezionata è stata rinominata con successo in';
$hesklang['cat_removed']='Categoria rimossa';
$hesklang['cat_removed_db']='La categoria selezionata è stata rimossa con successo dal database';
$hesklang['sure_remove_user']='Si è sicuri di voler rimuovere questo utente?';
$hesklang['manage_users']='Gestione utenti';
$hesklang['users_intro']='Qui è possibile gestire gli utenti che accedono al Pannello di Amministrazione e rispondono ai ticket. Gli amministratori possono invece visualizzare/modificare i ticket di qualsiasi categoria e hanno accesso a tutte le funzioni del Pannello di Amministrazione (gestione utenti, gestione categorie, ecc…), mentre gli altri utenti dello staff possono solo visualizzare e rispondere ai ticket delle loro categorie.';
$hesklang['yes']='SÌ';
$hesklang['no']='NO';
$hesklang['edit']='Modifica';
$hesklang['add_user']='Aggiungi nuovo utente';
$hesklang['req_marked_with']='I campi obbligatori sono evidenziati con';
$hesklang['real_name']='Nome reale';
$hesklang['signature_max']='Firma (massimo 1000 caratteri)';
$hesklang['sign_extra']='Non è consentito usare codice HTML. I link invece risulteranno cliccabili';
$hesklang['create_user']='Crea utente';
$hesklang['editing_user']='Modifica utente';
$hesklang['user_added']='Utente aggiunto';
$hesklang['user_added_success']='Il nuovo utente %s avente password %s è stato aggiunto con successo';
$hesklang['profile_updated']='Profilo aggiornato';
$hesklang['profile_updated_success']='Questo profilo è stato aggiornato con successo';
$hesklang['user_removed']='Utente rimosso';
$hesklang['sel_user_removed']='L\'utente selezionato è stato rimosso con successo dal database';
$hesklang['profile_for']='Profilo di';
$hesklang['new_pass']='Nuova password';
$hesklang['update_profile']='Aggiorna profilo';
$hesklang['notify_new_posts']='Avvisami se sono presenti nuovi ticket e/o messaggi nelle categorie di mia pertinenza';
$hesklang['view_profile']='Visualizza profilo';
$hesklang['new_ticket_submitted']='Inviato nuovo ticket';
$hesklang['user_profile_updated_success']='Il profilo di questo utente è stato aggiornato con successo';
$hesklang['printer_friendly']='Versione stampabile';
$hesklang['end_ticket']='--- Fine del ticket ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Il tuo ticket è stato';
$hesklang['view_your_ticket']='Visualizza il tuo ticket';
$hesklang['submit_ticket']='Invia un ticket';
$hesklang['sub_ticket']='Invia ticket';
$hesklang['before_submit']='Prima dell\'invio assicurarsi che:';
$hesklang['all_info_in']='Tutte le informazioni necessarie siano state inserite';
$hesklang['all_error_free']='Tutte le informazioni siano corrette e prive di errori';
$hesklang['we_have']='Abbiamo registrato';
$hesklang['recorded_ip']='come tuo indirizzo IP';
$hesklang['recorded_time']='la data e l\'ora della tua richiesta di invio';
$hesklang['save_changes']='Salva modifiche';
$hesklang['reply_submitted_success']='La tua risposta a questo ticket è stata inviata con successo';
$hesklang['ticket_submitted']='Ticket inviato';
$hesklang['ticket_submitted_success']='Il tuo ticket è stato inviato con successo! Codice ticket';
$hesklang['your_ticket']='Il tuo ticket';

// Added in version 0.94
$hesklang['check_updates']='Controllare sempre di aver installato l\'ultima versione di HESK!';
$hesklang['check4updates']='Controllo degli aggiornamenti';
$hesklang['wait_reply']='In attesa di risposta';
$hesklang['replied']='Risposto';
$hesklang['last_replier']='Ultimo a rispondere';
$hesklang['staff']='Staff';
$hesklang['customer']='Cliente';
$hesklang['close_selected']='Segna i ticket selezionati come \'Risolti\'';
$hesklang['execute']='Esegui';
$hesklang['saved_replies']='Risposte precompilate';
$hesklang['manage_saved']='Risposte precompilate';
$hesklang['manage_intro']='Qui è possibile aggiungere e gestire le risposte precompilate. Si tratta di risposte \'tipo\' usate frequentemente, valide per tutti i clienti. Conviene usarle per evitare di dover digitare ripetutamente le stesse risposte per clienti diversi.';
$hesklang['saved_title']='Titolo';
$hesklang['no_saved']='Nessuna risposta precompilata';
$hesklang['delete_saved']='Si è sicuri di voler eliminare questa risposta precompilata?';
$hesklang['new_saved']='Aggiungi o modifica una risposta precompilata';
$hesklang['canned_add']='Crea nuova risposta precompilata';
$hesklang['canned_edit']='Modifica la risposta precompilata selezionata';
$hesklang['save_reply']='Salva risposta';
$hesklang['saved']='Risposta salvata';
$hesklang['your_saved']='La risposta precompilata è stata salvata per un suo futuro utilizzo';
$hesklang['ent_saved_title']='Inserire il titolo della risposta';
$hesklang['ent_saved_msg']='Inserire il contenuto del messaggio di risposta';
$hesklang['saved_removed']='Risposta precompilata rimossa';
$hesklang['saved_rem_full']='Le risposte precompilate selezionate sono state rimosse dal database';
$hesklang['clip_alt']='Questo messaggio ha degli allegati';
$hesklang['attachments']='Allegati';
$hesklang['fill_all']='Campo obbligatorio mancante';
$hesklang['file_too_large']='Il file %s è troppo grande';
$hesklang['cannot_move_tmp']='Impossibile spostare il file nella cartella degli allegati';
$hesklang['created_on']='Creato il';
$hesklang['tickets_closed']='Ticket chiusi';
$hesklang['num_tickets_closed']='Sono stati chiusi <b>%d</b> ticket';
$hesklang['select_saved']='Selezionare una risposta precompilata';
$hesklang['select_empty']='Seleziona / Annulla selezione';
$hesklang['insert_special']='Inserisci una o più &quot;variabili speciali&quot; che verranno successivamente sostituite con le informazioni specifiche del cliente';
$hesklang['move_to_catgory']='Sposta il ticket in';
$hesklang['move']='Sposta';
$hesklang['moved']='Ticket spostato';
$hesklang['moved_to']='Questo ticket è stato spostato in una nuova categoria';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Tutti eccetto i chiusi';
$hesklang['chg_all']='Cambia tutto';
$hesklang['settings']='Impostazioni';
$hesklang['settings_intro']='Usa questo strumento per configurare l\'Helpdesk. Per maggiori informazioni sulle impostazioni, fare clic sul simbolo di aiuto (punto di domanda) o fare riferimento al file readme.html';
$hesklang['all_req']='Tutti i campi (eccetto quelli disabilitati) sono obbligatori!';
$hesklang['wbst_title']='Nome sito web';
$hesklang['wbst_url']='URL sito web';
$hesklang['email_wm']='Indirizzo email del webmaster';
$hesklang['max_listings']='Visualizzazioni per pagina';
$hesklang['print_size']='Dimensioni carattere di stampa';
$hesklang['debug_mode']='Modalità di debug';
$hesklang['on']='SÌ';
$hesklang['off']='NO';
$hesklang['use_secimg']='Usa immagine anti-SPAM';
$hesklang['secimg_no']='Non disponibile';
$hesklang['attach_use']='Usa allegati';
$hesklang['attach_num']='N. allegati per messaggio';
$hesklang['attach_type']='Tipi di file consentiti';
$hesklang['place_after']='Dopo il messaggio';
$hesklang['place_before']='Prima del messaggio';
$hesklang['custom_f']='Campo personalizzato';
$hesklang['custom_u']='Usa questo campo';
$hesklang['custom_n']='Nome del campo';
$hesklang['custom_l']='Lunghezza massima (caratteri)';
$hesklang['db_host']='Server del database';
$hesklang['db_name']='Nome del database';
$hesklang['db_user']='Nome utente per il database';
$hesklang['db_pass']='Password per il database';
$hesklang['err_sname']='Inserire il nome del sito web';
$hesklang['err_surl']='Inserire l\'URL del sito web. Assicurarsi che si tratti di una URL valida (che inizi cioè con http:// o con https://)';
$hesklang['err_wmmail']='Inserire un indirizzo valido di email per il webmaster';
$hesklang['err_nomail']='Inserire un indirizzo valido di email per il no-reply';
$hesklang['err_htitle']='Inserire il nome del tuo sistema di supporto';
$hesklang['err_hurl']='Inserire l\'URL della cartella HESK. Assicurarsi che si tratti di una URL valida (che inizi cioè con http:// o con https://)';
$hesklang['err_lang']='Selezionare la lingua di HESK';
$hesklang['err_nolang']='Il file di lingua specificato non esiste nella cartella della lingua! Assicurarsi che il file sia stato caricato prima di modificare le impostazioni della lingua.';
$hesklang['err_max']='Inserire il massimo numero di visualizzazioni per pagina';
$hesklang['err_psize']='Inserire la dimensione del font per la stampa';
$hesklang['err_dbhost']='Inserire il nome del server del database MySQL';
$hesklang['err_dbname']='Inserire il nome del database MySQL';
$hesklang['err_dbuser']='Inserire il nome dell\'utente gestore del database MySQL';
$hesklang['err_dbpass']='Inserire la password per accedere al database MySQL';
$hesklang['err_dbconn']='Impossibile connettersi al database MySQL utilizzando le informazioni fornite!';
$hesklang['err_dbsele']='Impossibile selezionare il database MySQL: ricontrollare il NOME del database';
$hesklang['err_custname']='Inserire il nome del campo personalizzato';
$hesklang['err_openset']='Impossibile aprire in scrittura il file <b>hesk_settings.inc.php</b>. Questo file deve avere chmod 666 (rw-rw-rw-)';
$hesklang['set_saved']='Impostazioni salvate';
$hesklang['set_were_saved']='Le impostazioni sono state salvate con successo';
$hesklang['sec_img']='Immagine di sicurezza';
$hesklang['sec_miss']='Inserire il numero di sicurezza';
$hesklang['sec_wrng']='Numero di sicurezza errato';
$hesklang['submit_problems']='Tornare indietro e correggere i seguenti problemi';
$hesklang['cat_order']='Ordinamento categorie';
$hesklang['reply_order']='Ordinamento risposte precompilate';
$hesklang['move_up']='Sposta su';
$hesklang['move_dn']='Sposta giù';
$hesklang['cat_move_id']='Codice categoria mancante';
$hesklang['reply_move_id']='Codice risposta precompilata mancante';
$hesklang['forgot_tid']='Codice del ticket dimenticato?';
$hesklang['tid_send']='Inviatemi il codice del ticket';
$hesklang['tid_not_found']='Non sono stati trovati ticket con il vostro indirizzo di email';
$hesklang['tid_sent']='Codice del ticket inviato';
$hesklang['tid_sent2']='È stato inviato al vostro indirizzo di email un messaggio contenente i dettagli dei ticket';
$hesklang['check_spambox']='In caso di mancata ricezione del messaggio, ricordarsi di controllare anche le cartelle Spam/Junk/Indesiderata!';
$hesklang['reply_not_found']='Risposta precompilata non trovata';
$hesklang['exists']='Esiste';
$hesklang['no_exists']='Non esiste';
$hesklang['writable']='Accessibile in scrittura';
$hesklang['not_writable']='Non accessibile in scrittura';
$hesklang['disabled']='disabilitato';
$hesklang['e_settings']='Non sarà possibile salvare le impostazioni fino a quando lo script non potrà accedere in scrittura a questo file. Per maggiori informazioni far riferimento al file readme.html.';
$hesklang['e_attdir']='Non è possibile salvare allegati se la cartella che li deve contenere non esiste e/o fino a che lo script non può accedervi in scrittura';
$hesklang['e_save_settings']='Impossibile salvare le impostazioni poiché lo script non può accedere in scrittura al file <b>hesk_settings.inc.php</b>.';
$hesklang['e_attach']='Disabilitati perché lo script non può accedere in scrittura alla cartella <b>attachments</b>.';
$hesklang['go']='Vai';

// Added in version 2.0
$hesklang['v']='Versione HESK';
$hesklang['check_status']='Verifica stato';
$hesklang['sub_support']='Invia un ticket';
$hesklang['open_ticket']='Invia una nuova richiesta relativa a una categoria';
$hesklang['view_existing']='Visualizza ticket esistente';
$hesklang['vet']='Visualizza ticket già inviati';
$hesklang['enter_user']='Inserisci il tuo nome utente';
$hesklang['remember_user']='Memorizza il nome utente';
$hesklang['wrong_user']='Nome utente errato';
$hesklang['no_permission']='Non si ha il permesso di eseguire questa azione. Accedere con un account autorizzato ad eseguirla.';
$hesklang['tickets_on_pages']='Numero di ticket: %d | Numero di pagine: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Va alla pagina:';
$hesklang['no_tickets_open']='Non ci sono ticket non risolti';
$hesklang['no_tickets_crit']='Non ci sono ticket che corrispondano ai criteri scelti';
$hesklang['confirm_execute']='Si è sicuri di voler continuare?';
$hesklang['legend']='Legenda';
$hesklang['main_page']='Home';
$hesklang['menu_users']='Utenti';
$hesklang['menu_cat']='Categorie';
$hesklang['menu_profile']='Profilo';
$hesklang['menu_kb']='Knowledgebase'; // Admin MENU item
$hesklang['kb_text']='Knowledgebase'; // Item visible to customers
$hesklang['viewkb']='Visualizza l\'intera knowledgebase';
$hesklang['kb']='Gestione knowledgebase';
$hesklang['kb_intro']='La knowledgebase (KB) è una raccolta di di informazioni (articoli) e di risposte alle domande più frequenti (FAQ). Rappresenta un\'importante risorsa per i clienti consentendo loro di cavarsela da soli. Una KB ricca e ben strutturata può ridurre drasticamente il numero di richieste di aiuto con conseguente risparmio di tempo. È possibile organizzare le informazioni in categorie e sotto-categorie.'; // Description in ADMIN panel
$hesklang['kb_is']='La knowledgebase (KB) è una raccolta strutturata di informazioni (articoli) e di risposte alle domande più frequenti (FAQ). Consente la consultazione di una serie di informazioni relative a una categoria o a una sotto-categoria di proprio interesse.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Nuovo articolo della knowledgebase';
$hesklang['kb_cat']='Categoria';
$hesklang['kb_subject']='Oggetto';
$hesklang['kb_content']='Contenuto';
$hesklang['kb_type']='Tipo';
$hesklang['kb_published']='Pubblico';
$hesklang['kb_published2']='Tutti possono visualizzare questo articolo nella knowledgebase';
$hesklang['kb_private']='Privato';
$hesklang['kb_private2']='Solo lo staff può leggere gli articoli privati';
$hesklang['kb_draft']='Bozza';
$hesklang['kb_draft2']='L\'articolo è stato salvato, ma non è stato ancora reso pubblico. Può essere letto solo dallo staff che ha il permesso di gestire gli articoli della knowledgebase.';
$hesklang['kb_links']='<i><span class="notice"><b>Attenzione!</b></span><br />Inserire un codice valido senza le tag &lt;head&gt; e &lt;body&gt;: solo il contenuto!</i>';
$hesklang['kb_ehtml']='Questo è codice HTML (verrà inserito solo codice [X]HTML valido)';
$hesklang['kb_dhtml']='Questo è puro testo (i link saranno cliccabili)';
$hesklang['kb_save']='Salva articolo';
$hesklang['kb_e_subj']='Inserire l\'oggetto dell\'articolo!';
$hesklang['kb_e_cont']='Scrivere il contenuto dell\'articolo!';
$hesklang['kb_art_added']='Articolo aggiunto';
$hesklang['your_kb_added']='un nuovo articolo è stato aggiunto con successo alla knowledgebase';
$hesklang['kb_art_deleted']='Articolo eliminato';
$hesklang['your_kb_deleted']='L\'articolo selezionato è stato eliminato dalla knowledgebase';
$hesklang['kb_art_mod']='Articolo modificato';
$hesklang['your_kb_mod']='Le modifiche all\'articolo selezionato sono state salvate con successo';
$hesklang['kb_cat_new']='Nuova categoria della knowledgebase';
$hesklang['kb_cat_parent']='Categoria principale';
$hesklang['kb_cat_sub']='Sotto-categorie';
$hesklang['kb_cat_title']='Titolo categoria';
$hesklang['kb_cat_published']='Tutti possono visualizzare questa categoria';
$hesklang['kb_cat_private']='Solo lo staff può visualizzare questa categoria';
$hesklang['kb_cat_add']='Aggiungi categoria';
$hesklang['kb_cat_e_title']='Inserire il titolo della categoria!';
$hesklang['kb_cat_added']='Categoria aggiunta';
$hesklang['kb_cat_added2']='Una nuova categoria è stata aggiunta con successo alla knowledgebase';
$hesklang['kb_cat_man']='Gestione categorie della knowledgebase';
$hesklang['kb_cat_edit']='Modifica dettagli categoria';
$hesklang['kb_cat_inv']='Categoria non valida';
$hesklang['kb_cat_art']='Articoli in questa categoria';
$hesklang['kb_p_art']='+ Articolo';
$hesklang['kb_p_art2']='Aggiunge un nuovo articolo alla categoria selezionata';
$hesklang['kb_add_art']='Aggiungi articolo';
$hesklang['kb_p_cat']='+ Categoria';
$hesklang['kb_p_cat2']='Crea una nuova sotto-categoria all\'interno della categoria selezionata';
$hesklang['kb_add_cat']='Aggiungi categoria';
$hesklang['kb_p_man']='Gestione';
$hesklang['kb_p_man2']='Gestisce la categoria selezionata: modifica, elimina e gestisce gli articoli';
$hesklang['kb_main']='La categoria principale della knowledgebase non può essere spostata o eliminata!';
$hesklang['kb_no_art']='In questa categoria non ci sono articoli';
$hesklang['author']='Autore';
$hesklang['views']='Visualizzazioni';
$hesklang['delete']='Elimina';
$hesklang['rating']='Valutazione';
$hesklang['votes']='Voti';
$hesklang['kb_rated']='Articolo valutato %s/5.0';
$hesklang['kb_not_rated']='Articolo non ancora valutato';
$hesklang['del_art']='Si è sicuri di voler eliminare l\'articolo selezionato?';
$hesklang['kb_art_id']='Codice articolo mancante o non valido!';
$hesklang['kb_art_edit']='Modifica articolo';
$hesklang['revhist']='Cronologia modifiche';
$hesklang['revision1']='<li class="smaller">%s | inviato da %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modificato da %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Ordine';
$hesklang['kb_delcat']='Si è sicuri di voler eliminare questa categoria?';
$hesklang['kb_cat_mod']='Categoria modificata';
$hesklang['your_cat_mod']='Le modifiche apportate alla categoria selezionata sono state salvate con successo';
$hesklang['kb_cat_del']='Categoria eliminata dalla knowledgebase';
$hesklang['kb_cat_dlt']='La categoria selezionata è stata eliminata dalla knowledgebase';
$hesklang['allowed_cat']='Categorie';
$hesklang['allow_feat']='Autorizzazioni';
$hesklang['can_view_tickets']='Visualizzazione di ticket';
$hesklang['can_reply_tickets']='Risposta ai ticket';
$hesklang['can_assign_tickets']='Assegna i ticket';
$hesklang['can_del_tickets']='Eliminazione di ticket';
$hesklang['can_edit_tickets']='Modifica delle risposte ai ticket';
$hesklang['can_change_cat']='Spostamento di ticket in qualsiasi altro tipo di categoria';
$hesklang['can_man_kb']='Gestione knowledgebase';
$hesklang['can_man_users']='Gestione utenti';
$hesklang['can_man_cat']='Gestione categorie';
$hesklang['can_man_canned']='Gestione risposte precompilate';
$hesklang['can_man_settings']='Gestione impostazioni Helpdesk';
$hesklang['can_del_notes']='Eliminazione di tutte le note dai ticket';
$hesklang['dan']='gli utenti possono eliminare le note solo dai propri ticket. Selezionare questa opzione solamente se si vuol consentire a questo utente di eliminare anche le note di altri utenti';
$hesklang['in_all_cat']='solo nelle categorie consentite';
$hesklang['admin_can']='(accesso consentito a tutte le categorie e autorizzazioni)';
$hesklang['staff_can']='(accesso limitato a categorie e autorizzazioni)';
$hesklang['asign_one_feat']='Assegna almeno una autorizzazione a questo utente!';
$hesklang['na_view_tickets']='Non si è autorizzati a visualizzare i ticket';
$hesklang['support_notice']='Spiacente, si può nascondere questa sezione solo se si acquista una licenza di HESK!';
$hesklang['rart']='Questo articolo è stato d\'aiuto?';
$hesklang['r']='Questa risposta è stata d\'aiuto?';
$hesklang['tyr']='Grazie per la valutazione!';
$hesklang['cw']='Chiudi la finestra';
$hesklang['cw2']='Chiudi la finestra e invia ticket';
$hesklang['rh']='Vàluta come <i>utile</i>';
$hesklang['rnh']='Vàluta come <i>poco o non utile</i>';
$hesklang['ar']='Già valutato';
$hesklang['rated']='Valutazione utente: %s/5.0 (%s voti)';
$hesklang['not_rated']='Utente non ancora valutato';
$hesklang['rdis']='La valutazione è stata disabilitata';
$hesklang['kbdis']='La knowledgebase è stata disabilitata';
$hesklang['kbpart']='Spiacente, non si hanno i permessi di accesso a questo articolo';
$hesklang['popart']='Articoli più popolari della knowledgebase';
$hesklang['latart']='Ultimi articoli pubblicati nella knowledgebase';
$hesklang['m']='Più argomenti…';
$hesklang['ac']='Articoli in questa categoria';
$hesklang['noa']='Non ci sono ancora articoli';
$hesklang['noac']='Non ci sono ancora articoli in questa categoria';
$hesklang['dta']='Data di inserimento';
$hesklang['ad']='Dettagli articolo';
$hesklang['aid']='Codice articolo';
$hesklang['as']='Soluzione';
$hesklang['search']='Cerca';
$hesklang['sr']='Risultati ricerca';
$hesklang['nosr']='Non è stato trovato alcun articolo corrispondente ai criteri. Provare a cercare nella knowledgebase o inviare un nuovo ticket';
$hesklang['rv']='Azzeramento visualizzazioni';
$hesklang['rr']='Azzeramento dei voti (valutazioni)';
$hesklang['opt']='Opzioni';
$hesklang['delcat']='Elimina categoria';
$hesklang['move1']='Sposta gli articoli nella categoria principale';
$hesklang['move2']='Elimina gli articoli di questa categoria';
$hesklang['sc']='Articoli suggeriti della knowledgebase';
$hesklang['not']='Ticket'; // Number of all tickets in category
$hesklang['graph']='Grafico';
$hesklang['lu']='Elenco dei nomi utente';
$hesklang['aclose']='Chiusura automatica ticket';
$hesklang['aclose2']='giorni dopo l\'ultima risposta dello staff';
$hesklang['s_ucrt']='Riapertura ticket';
$hesklang['urate']='Valutazione delle risposte';
$hesklang['hesk_url']='URL di HESK';
$hesklang['hesk_title']='Titolo Helpdesk';
$hesklang['cid']='Codice di tracciamento del caso';
$hesklang['tfor']='Formato ora';
$hesklang['prefix']='Prefisso tabelle';
$hesklang['s_ekb']='Attiva la knowledgebase';
$hesklang['s_kbs']='Abilita ricerca nella KB';
$hesklang['s_kbr']='Abilita valutazione della KB';
$hesklang['s_maxsr']='N. max risultati della ricerca';
$hesklang['s_suggest']='Suggerisci articoli della KB';
$hesklang['s_spop']='Mostra articoli più popolari';
$hesklang['s_slat']='Mostra articoli più recenti';
$hesklang['s_onin']='sulla <a href="../" target="_blank">Home page</a> dell\'Helpdesk';
$hesklang['s_onkb']='sulla <a href="../knowledgebase.php" target="_blank">Home page</a> della Knowledgebase';
$hesklang['s_scol']='Categorie per riga';
$hesklang['s_ptxt']='Anteprima articolo (caratteri)';
$hesklang['s_psubart']='Articoli in sotto-categorie';
$hesklang['enable']='Abilita';
$hesklang['s_type']='Tipo';
$hesklang['custom_r']='Obbligatorio';
$hesklang['custom_place']='Posizione';
$hesklang['custom_use']='Campi personalizzati';
$hesklang['stf']='Campo di testo';
$hesklang['stb']='Area di testo';
$hesklang['srb']='Pulsante di scelta';
$hesklang['ssb']='Lista di selezione';
$hesklang['db']='Database';
$hesklang['hd']='Impostazioni Helpdesk';
$hesklang['gs']='Impostazioni generali';
$hesklang['cwin']='Chiudi finestra';
$hesklang['defw']='Valore predefinito';
$hesklang['ok']='OK';
$hesklang['ns']='Queste sono le opzioni disponibili per questo campo personalizzato. Per salvare le modifiche, fare clic su <b>OK</b> e sul pulsante <b>Salva modifiche</b> nella pagina delle impostazioni amministrative';
$hesklang['rows']='Righe (altezza)';
$hesklang['cols']='Colonne (larghezza)';
$hesklang['opt2']='Introdurre un elemento per riga. Ciascuna riga rappresenta una possibile scelta selezionabile tramite pulsante. Una scelta esclude le altre. È necessario introdurre almeno due elementi.';
$hesklang['opt3']='Introdurre un elemento per riga. Ciascuna riga rappresenta una possibile scelta per il cliente. È necessario introdurre almeno due elementi.';
$hesklang['atl2']='Introdurre almeno due elementi (un\'opzione per riga)!';
$hesklang['notes']='Note';
$hesklang['addnote']='Aggiungi nota';
$hesklang['noteby']='Nota di';
$hesklang['delnote']='Elimina nota';
$hesklang['noteerr']='Nota già eliminata o parametri errati';
$hesklang['s']='Invia';
$hesklang['nhid']='Le note risultano nascoste per i clienti!';
$hesklang['delt']='Elimina questo messaggio';
$hesklang['edtt']='Modifica messaggio';
$hesklang['edt1']='Messaggio modificato';
$hesklang['edt2']='Le modifiche al messaggio selezionato sono state salvate';
$hesklang['dele']='Elimina questo ticket';
$hesklang['repd']='Messaggio eliminato';
$hesklang['repl']='Il messaggio selezionato è stato eliminato';
$hesklang['tickets_found']='Risultati della ricerca';
$hesklang['al']='Link all\'area amministrativa';
$hesklang['ap']='Pannello di amministrazione';
$hesklang['dap']='Visualizza un link al Pannello di amministrazione nella <a href="../" target="_blank">Home</a> dell\'Helpdesk';
$hesklang['q_miss']='Si prega di rispondere alla domanda anti-SPAM';
$hesklang['use_q']='Usa domanda anti-SPAM';
$hesklang['q_q']='Domanda (il codice HTML è <font class="success">ammesso</font>)';
$hesklang['q_a']='Risposta';
$hesklang['err_qask']='Inserire una domanda anti-SPAM';
$hesklang['err_qans']='Inserire la risposta alla domanda anti-SPAM';
$hesklang['genq']='Genera una domanda casuale';

// Added in version 2.1
$hesklang['amo']='Aggiungine altri';
$hesklang['delatt']='Eliminare l\'allegato selezionato?';
$hesklang['kb_att_rem']='L\'allegato selezionato è stato rimosso';
$hesklang['inv_att_id']='Codice allegato non valido!';
$hesklang['scb']='Casella di controllo';
$hesklang['opt4']='Inserire un\'opzione per riga. Ciascuna riga rappresenta una possibile scelta per i clienti. Essi possono anche effettuare una scelta multipla. In ogni caso debbono esserci almeno due elementi.';
$hesklang['autologin']='Connettimi automaticamente ad ogni visita';
$hesklang['just_user']='Ricorda solo il nome utente';
$hesklang['nothx']='Non ricordare nulla';
$hesklang['pinfo']='Informazioni profilo';
$hesklang['sig']='Firma';
$hesklang['pref']='Preferenze';
$hesklang['aftrep']='Dopo aver risposto a un ticket';
$hesklang['showtic']='mostra il ticket cui si è appena risposto';
$hesklang['gomain']='ritorna alla pagina amministrativa principale';
$hesklang['shownext']='apri il ticket successivo che è in attesa di una mia risposta';
$hesklang['rssn']='Sto visualizzando il prossimo ticket che necessita della tua attenzione';
$hesklang['mrep']='Sostituisci il messaggio';
$hesklang['madd']='Aggiungi in basso';
$hesklang['priv']='Le categorie private e gli articoli visibili solo dallo staff sono contrassegnati con *';
$hesklang['inve']='File di email non valido';
$hesklang['emfm']='File di email mancante';
$hesklang['hesk_lang']='Lingua predefinita';
$hesklang['s_mlang']='Lingue multiple';
$hesklang['s_mlange']='Abilitarle solo se è possibile fornire supporto in tutte le lingue installate!';
$hesklang['s_inl']='Cartella di test per la lingua';
$hesklang['s_inle']='Sto testando la cartella della lingua per convalidare le lingue. Solo le lingue che superano tutti i test saranno installate.';
$hesklang['ta']='Esegui nuovamente il test';
$hesklang['alo']='Accesso automatico';
$hesklang['chol']='Lingua preferita';
$hesklang['mmdl']='Imposta questa come lingua preferita';
$hesklang['warn']='ATTENZIONE';
$hesklang['dmod']='La modalità di debug è abilitata. Disabilitare la modalità di debug nelle impostazioni una volta che HESK sia stato installato e funzioni correttamente';
$hesklang['kb_spar']='Una categoria non può essere la categoria principale di se stessa!';
$hesklang['mysql_root']='La password per MySQL è assente. Si è sicuri di volersi connettere come utente \'root\'? Ciò rappresenta un grave rischio per la sicurezza!';
$hesklang['chg']='Modifica';
$hesklang['chpri']='Priorità modificata';
$hesklang['chpri2']='La priorità del ticket è stata modificata in %s';
$hesklang['selcan']='Selezionare la risposta precompilata che si desidera modificare';
$hesklang['q_wrng']='Risposta anti-SPAM errata';
$hesklang['cndupl']='Esiste già una categoria con questo nome. Scegliere un nome univoco per ciascuna categoria.';
$hesklang['wsel']='Selezionare il campo su cui si vuol effettuare la ricerca';

// Added in version 2.2
$hesklang['eto']='Richiesta non valida';
$hesklang['id']='Codice';
$hesklang['geco']='Genera un link diretto';
$hesklang['genl']='Link copiato nel blocco appunti (clipboard)';
$hesklang['genl2']='Usare questo link per preselezionare una categoria nel modulo &quot;Invia un ticket&quot;.';
$hesklang['ask']='Aiuto per la ricerca:';
$hesklang['exa']='Esempi';
$hesklang['small']='Casella piccola';
$hesklang['large']='Casella grande';
$hesklang['cpri']='Priorità impostata dal cliente';
$hesklang['owner']='Proprietario';
$hesklang['unas']='Non assegnato';
$hesklang['assi']='Assegna';
$hesklang['asst']='Assegna a';
$hesklang['asst2']='Assegna questo ticket a';
$hesklang['asss']='Auto-asségnati questo ticket';
$hesklang['asss2']='Assegna questo ticket a me stesso';
$hesklang['can_assign_self']='Assegnazione di ticket a se stessi';
$hesklang['can_assign_others']='Assegnazione di ticket ad altri';
$hesklang['can_run_reports']='Produzione dei propri rapporti';
$hesklang['can_view_ass_others']='Visualizzazione di ticket assegnati ad altri';
$hesklang['unoa']='L\'utente selezionato non ha accesso a questa categoria';
$hesklang['tasi']='Assegnato al proprietario';
$hesklang['tasy']='Questo ticket ti è stato assegnato';
$hesklang['taso']='Questo ticket è stato assegnato all\'utente selezionato';
$hesklang['tasy2']='Assegnato a me';
$hesklang['taso2']='Assegnato ad altra persona dello staff';
$hesklang['nose']='Seleziona il nuovo proprietario';
$hesklang['onasc']='Questo proprietario non ha accesso alla categoria selezionata.';
$hesklang['tunasi']='Ticket non assegnati';
$hesklang['tunasi2']='Il ticket attualmente non ha proprietario ed è pronto per essere riassegnato';
$hesklang['note']='Nota';
$hesklang['success']='Successo';
$hesklang['nyt']='Questo ticket è assegnato a';
$hesklang['noch']='Non sono state apportate modifiche';
$hesklang['orch']='L\'ordine di visualizzazione è stato modificato';
$hesklang['rfm']='Mancano alcune informazioni obbligatorie:';
$hesklang['repl0']='Autorizzazioni insufficienti per eseguire questa operazione';
$hesklang['repl1']='Questo messaggio non esiste';
$hesklang['reports']='Rapporti';
$hesklang['reports_intro']='La sezione \'Rapporti\' consente la generazione di parecchi tipi di rapporto e la visualizzazione di statistiche relative ai ticket in uno specifico intervallo di tempo';
$hesklang['refi']='Azzeramento dati modulo';
$hesklang['dich']='Annulla le modifiche';
$hesklang['dire']='Visualizza rapporto';
$hesklang['m1']='Gennaio';
$hesklang['m2']='Febbraio';
$hesklang['m3']='Marzo';
$hesklang['m4']='Aprile';
$hesklang['m5']='Maggio';
$hesklang['m6']='Giugno';
$hesklang['m7']='Luglio';
$hesklang['m8']='Agosto';
$hesklang['m9']='Settembre';
$hesklang['m10']='Ottobre';
$hesklang['m11']='Novembre';
$hesklang['m12']='Dicembre';
$hesklang['d1']='Lunedì';
$hesklang['d2']='Martedì';
$hesklang['d3']='Mercoledì';
$hesklang['d4']='Giovedì';
$hesklang['d5']='Venerdì';
$hesklang['d6']='Sabato';
$hesklang['d0']='Domenica';
$hesklang['mo']='Lu';
$hesklang['tu']='Ma';
$hesklang['we']='Me';
$hesklang['th']='Gi';
$hesklang['fr']='Ve';
$hesklang['sa']='Sa';
$hesklang['su']='Do';
$hesklang['from']='Da';
$hesklang['cinv']='Data non valida';
$hesklang['cinv2']='Il formato accettato è mm/gg/aaaa';
$hesklang['cinm']='Il valore del mese non è valido';
$hesklang['cinm2']='L\'intervallo consentito è';
$hesklang['cind']='Il valore del giorno del mese non è valido';
$hesklang['cind2']='L\'intervallo consentito per il mese selezionato è';
$hesklang['month']='Mese';
$hesklang['ocal']='Apri calendario';
$hesklang['ca01']='Anno precedente';
$hesklang['ca02']='Mese precedente';
$hesklang['ca03']='Mese successivo';
$hesklang['ca04']='Anno successivo';
$hesklang['ca05']='Chiudi calendario';
$hesklang['cdr']='Scegliere l\'intervallo di tempo:';
$hesklang['crt']='Tipo di rapporto';
$hesklang['r1']='Oggi';
$hesklang['r2']='Ieri';
$hesklang['r3']='Questo mese';
$hesklang['r4']='Il mese scorso';
$hesklang['r5']='Ultimi 30 giorni';
$hesklang['r6']='Questa settimana (Lu-Do)';
$hesklang['r7']='La settimana scorsa (Lu-Do)';
$hesklang['r8']='Questa settimana lavorativa (Lu-Ve)';
$hesklang['r9']='La scorsa settimana lavorativa (Lu-Ve)';
$hesklang['r10']='Quest\'anno';
$hesklang['r11']='L\'anno scorso';
$hesklang['r12']='Tutto';
$hesklang['datetofrom']='&quot;La data iniziale&quot; non può essere posteriore alla &quot;Data finale&quot;. Le date sono state invertite!';
$hesklang['t1']='Ticket per giorno';
$hesklang['t2']='Ticket per mese';
$hesklang['t3']='Ticket per utente';
$hesklang['t4']='Ticket per categoria';
$hesklang['ticass']='Ticket assegnati';
$hesklang['ticall']='Risposte ai ticket';
$hesklang['totals']='Totali';
$hesklang['all']='Qualsiasi';
$hesklang['atik']='Nuovi ticket';
$hesklang['kbca']='Nella knowledgebase esiste già una categoria con questo nome';
$hesklang['menu_msg']='Messaggi';
$hesklang['menu_can']='In automatico';
$hesklang['m_from']='Da:'; // Mail "from" address
$hesklang['m_to']='A:'; // Mail "to" address
$hesklang['m_sub']='Oggetto:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Messaggi privati';
$hesklang['m_intro']='Usare i messaggi privati per inviare rapide comunicazioni ad altri membri dello staff all\'interno di HESK';
$hesklang['e_udel']='(Utente eliminato)';
$hesklang['new_mail']='Nuovo messaggio privato';
$hesklang['m_send']='Invia messaggio';
$hesklang['m_rec']='Selezionare il destinatario del messaggio';
$hesklang['m_inr']='Destinatario del messaggio non valido';
$hesklang['m_esu']='Inserire l\'oggetto del messaggio privato';
$hesklang['m_pms']='Il messaggio privato è stato inviato';
$hesklang['inbox']='Posta in arrivo';
$hesklang['outbox']='Posta inviata';
$hesklang['m_new']='Nuovo messaggio';
$hesklang['pg']='Mostra pagina';
$hesklang['npm']='Nessun messaggio privato in questa cartella';
$hesklang['m_ena']='Non si ha il permesso di leggere questo messaggio';
$hesklang['mau']='Segna come non letto';
$hesklang['mo1']='Segna i messaggi selezionati come letti';
$hesklang['mo2']='Segna i messaggi selezionati come non letti';
$hesklang['mo3']='Elimina i messaggi selezionati';
$hesklang['delm']='Elimina questo messaggio';
$hesklang['e_tid']='Errore durante la generazione di un codice ticket univoco. Provare a re-inviare il modulo di richiesta tra qualche minuto.';
$hesklang['smmr']='I messaggi selezionati sono stati contrassegnati come letti';
$hesklang['smmu']='I messaggi selezionati sono stati contrassegnati come non letti';
$hesklang['smdl']='I messaggi selezionati sono stati eliminati';
$hesklang['show']='Visualizza';
$hesklang['s_my']='Assegnati a me';
$hesklang['s_ot']='Assegnato ad altri';
$hesklang['s_un']='Ticket non assegnati';
$hesklang['s_for']='Cerca per';
$hesklang['s_in']='Cerca in';
$hesklang['s_incl']='Cerca all\'interno di';
$hesklang['find_ticket_by']='Trova un ticket';
$hesklang['e_nose']='Non è stato selezionato alcun stato di assegnazione. Vengono mostrati tutti i ticket.';
$hesklang['fsq']='Inserire i termini di ricerca';
$hesklang['topen']='Aperti';
$hesklang['nms']='Nessun messaggio selezionato, niente da modificare';
$hesklang['tlo']='Blocca ticket';
$hesklang['tul']='Sblocca ticket';
$hesklang['loc']='Bloccato';
$hesklang['isloc']='I clienti non possono rispondere o riaprire i ticket bloccati. Quando un ticket viene bloccato, viene anche contrassegnato come risolto.';
$hesklang['tlock']='Il ticket è stato bloccato';
$hesklang['tunlock']='Il ticket è stato sbloccato';
$hesklang['tislock']='Questo ticket è stato bloccato. Il cliente non sarà in grado di inviare un messaggio di risposta.';
$hesklang['tislock2']='Questo ticket è stato bloccato. Non si può inviare una risposta.';
$hesklang['nsfo']='Non sono stati trovati articoli rilevanti';
$hesklang['thist1']='<li class="smaller">%s | spostato nella categoria %s da %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | assegnato a %s da %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | chiuso da %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | aperto da %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | bloccato da %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | sbloccato da %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | ticket creato da %s</li>'; // %s = date, user making change
$hesklang['elocked']='Questo ticket è stato bloccato o eliminato';
$hesklang['nti2']='Inserire un nuovo ticket';
$hesklang['nti3']='Utilizzare questo modulo per creare un nuovo ticket per conto di un cliente. Nel modulo inserire le informazioni relative al <i>cliente</i>: cognome e nome, indirizzo di email ecc…, NON il tuo nome! Il ticket verrà generato come se fosse stato creato dal cliente stesso.';
$hesklang['addop']='Opzioni';
$hesklang['seno']='Invia una email di notifica al cliente';
$hesklang['otas']='Dopo l\'inserimento, mostra il ticket';
$hesklang['notn']='Notifiche';
$hesklang['nomw']='L\'Helpdesk mi invierà una notifica per email:';
$hesklang['nwts']='Quando viene inserito un nuovo ticket avente per proprietario:';
$hesklang['ncrt']='Quando il cliente risponde a un ticket avente per proprietario:';
$hesklang['ntam']='Quando mi viene assegnato un ticket';
$hesklang['npms']='Quando mi è stato inviato un messaggio privato';
$hesklang['support_remove']='Per lo sviluppo di HESK sono stati investiti tempo ed energie.<br />Supporta HESK acquistando una licenza il che consente di rimuovere dal tuo Helpdesk il link alla scritta &quot;<b>Powered by Help Desk Software HESK, in partnership with SysAid Technologies</b>&quot;';
$hesklang['ycvtao']='Non si è autorizzati a visualizzare i ticket assegnati ad altri';
$hesklang['password_not_valid']='La password deve essere lunga almeno 5 caratteri';
$hesklang['lkbs']='Sto caricando i suggerimenti dalla knowledgebase…';
$hesklang['auto']='(automaticamente)';

// Added in version 2.3
$hesklang['unknown']='Sconosciuto';
$hesklang['pcer']='Correggere i seguenti errori:';
$hesklang['seqid']='Numero ticket';
$hesklang['close_action']='Segna come risolto'; // Close ACTION
$hesklang['archived']='Etichettato';
$hesklang['archived2']='Ticket etichettato';
$hesklang['add_archive']='Etichetta questo ticket';
$hesklang['add_archive_quick']='Etichetta i ticket selezionati';
$hesklang['remove_archive']='Rimuovi l\'etichetta da questo ticket';
$hesklang['remove_archive_quick']='Rimuovi le etichette dai ticket selezionati';
$hesklang['added_archive']='Ticket etichettato';
$hesklang['removed_archive']='Etichetta rimossa dal ticket';
$hesklang['added2archive']='Il ticket è stato etichettato';
$hesklang['removedfromarchive']='L\'etichetta è stata rimossa dal ticket';
$hesklang['num_tickets_tag']='Sono stati etichettati <b>%d</b> ticket';
$hesklang['num_tickets_untag']='L\'etichetta è stata rimossa da <b>%d</b> ticket';
$hesklang['can_add_archive']='Assegnazione di etichette ai ticket';
$hesklang['disp_only_archived']='Solo ticket etichettati';
$hesklang['search_only_archived']='Solo ticket etichettati';
$hesklang['critical']='Critica';
$hesklang['thist8']='<li class="smaller">%s | priorità modificata in %s da %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | stato modificato in %s da %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | assegnato automaticamente a %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | inviato via email piping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='a';
$hesklang['abbr']['month']='m';
$hesklang['abbr']['week']='set';
$hesklang['abbr']['day']='g';
$hesklang['abbr']['hour']='h';
$hesklang['abbr']['minute']='min';
$hesklang['abbr']['second']='sec';
// END abberviations
$hesklang['cnsm']='Non è possibile inviare il messaggio a:';
$hesklang['yhbb']='Si è stati bloccati fuori dal sistema per %s minuti poiché si sono effettuati troppi tentativi di accesso che sono falliti';
$hesklang['pwdst']='Robustezza della password';
$hesklang['tid_mail']='Nessun problema! Inserire il proprio <b>indirizzo di email</b><br />Vi verrà imediatamente inviato il codice del ticket:';
$hesklang['rem_email']='Memorizza il mio indirizzo di email';
$hesklang['eytid']='Inserisci il codice del tuo ticket';
$hesklang['enmdb']='L\'indirizzo di email inserito non corrisponde a quello presente nel database per questo ticket';
$hesklang['confemail']='Conferma indirizzo email';
$hesklang['confemail2']='Confermare il proprio indirizzo di email';
$hesklang['confemaile']='I due indirizzi di email non sono identici';
$hesklang['taso3']='Assegnato a:';
$hesklang['sec_enter']='Digita il numero che vedi nell\'immagine sottostante:';
$hesklang['reload']='Ricarica l\'immagine';
$hesklang['verify_q']='Prevenzione SPAM:'; // For anti-spam question
$hesklang['verify_i']='Prevenzione SPAM:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Salve! Entrate pure…';
$hesklang['vrfy']='Test superato';
$hesklang['last_update']='Aggiornamento';
$hesklang['cot']='Non forzare in cima i ticket con stato \'Critico\'';
$hesklang['def']='Rendi questa la mia vista predefinita';
$hesklang['gbou']='Questi ticket sono <b>Non assegnati</b>:';
$hesklang['gbom']='Ticket assegnati a <b>me</b>:';
$hesklang['gboo']='Ticket assegnati a <b>%s</b>:';
$hesklang['select']=' --- Seleziona --- ';
$hesklang['chngstatus']='Cambia lo stato in';
$hesklang['perat']='%s di tutti i ticket'; // Will change to "23% of all tickets"
$hesklang['viewart']='Visualizza questo articolo';
$hesklang['chdp']='Cambia la password predefinita nel tuo <a href="profile.php">Profilo!</a>';
$hesklang['chdp2']='Cambia la password, stai utlizzando quella predefinita!';
$hesklang['security']='Sicurezza';
$hesklang['kb_i_art']='Nuovo articolo';
$hesklang['kb_i_art2']='Inserire un articolo';
$hesklang['kb_i_cat']='Nuova categoria';
$hesklang['kb_i_cat2']='Inserire una categoria';
$hesklang['gopr']='Visualizza la knowledgebase';
$hesklang['kbstruct']='Struttura della knowledgebase';
$hesklang['cancel']='Annulla';
$hesklang['sh']='Nascondi il messaggio';
$hesklang['goodkb']='Come scrivere buoni articoli per la knowledgebase (in inglese)';
$hesklang['catset']='Impostazioni categoria';
$hesklang['inpr']='Seleziona la nuova priorità';
$hesklang['incat']='Seleziona la nuova categoria';
$hesklang['instat']='Seleziona il nuovo stato';
$hesklang['tsst']='Lo stato del ticket è stato impostato a %s';
$hesklang['aass']='Auto-assegnazione';
$hesklang['aaon']='Auto-assegnazione dei ticket abilitata (fare clic per disabilitarla)';
$hesklang['aaoff']='Auto-assegnazione dei ticket disabilitata (fare clic per abilitarla)';
$hesklang['uaaon']='L\'auto-assegnazione è stata abilitata per l\'utente selezionato';
$hesklang['uaaoff']='L\'auto-assegnazione è stata disabilitata per l\'utente selezionato';
$hesklang['taasy']='Ti sei autoassegnato questo ticket';
$hesklang['can_view_unassigned']='Visualizzazione anche di ticket non assegnati';
$hesklang['ycovtay']='È possibile visualizzare solo i ticket che ti sono stati assegnati';
$hesklang['in_progress']='In lavorazione';
$hesklang['on_hold']='In attesa';
$hesklang['import_kb']='Trasferisci questo ticket in un articolo della knowledgebase';
$hesklang['import']='Si sta trasferendo un <i>ticket privato</i> in un <i>articolo pubblico</i>.<br /><br />Assicurarsi di aver eliminato tutte le informazioni di tipo privato o sensibile dall\'oggetto e dal contenuto del messaggio!';
$hesklang['tab_1']='Generali';
$hesklang['tab_2']='Helpdesk';
$hesklang['tab_3']='Knowledgebase';
$hesklang['tab_4']='Campi personalizzati';
$hesklang['tab_5']='Varie';
$hesklang['disable']='Disabilitato';
$hesklang['dat']='Data &amp; ora';
$hesklang['lgs']='Lingua';
$hesklang['onc']='SÌ (clienti)';
$hesklang['ons']='SÌ (tutti)';
$hesklang['viewvtic']='Visualizzazione ticket';
$hesklang['reqetv']='Indirizzo di email obbligatorio per la visualizzazione del ticket';
$hesklang['banlim']='N. max tentativi di accesso';
$hesklang['banmin']='Sospensione (in min)';
$hesklang['subnot']='Invia avviso';
$hesklang['subnot2']='Mostra un avviso ai clienti che inviano ticket';
$hesklang['eseqid']='Codici sequenziali';
$hesklang['sconfe']='Conferma indirizzo di email';
$hesklang['saass']='Auto-assegnazione ticket';
$hesklang['swyse']='Editor WYSIWYG';
$hesklang['hrts']='Vàluta HESK';
$hesklang['hrts2']='Mostra il link a \'Vàluta questo script\' nel Pannello di amministrazione';
$hesklang['emlpipe']='Email piping';
$hesklang['emlsend2']='Invia email usando';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='Server SMTP';
$hesklang['smtph']='Server SMTP';
$hesklang['smtpp']='Porta SMTP';
$hesklang['smtpu']='Nome utente su SMTP';
$hesklang['smtpw']='Password su SMTP';
$hesklang['smtpt']='Timeout SMTP';
$hesklang['other']='Altro';
$hesklang['features']='Opzioni';
$hesklang['can_view_online']='Visualizzazione degli altri membri dello staff online';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Utenti online'; // For display in footer
$hesklang['sonline']='Utenti online'; // For settings page
$hesklang['sonline2']='Mostra gli utenti presenti online. Limite (in minuti):'; // For settings page
$hesklang['gb']='Raggruppa per';
$hesklang['dg']='Non raggruppare';
$hesklang['err_dpi']='Il database %s non contiene tutte le tabelle HESK aventi prefisso %s. Le modifiche non sono state salvate';
$hesklang['err_dpi2']='Tabelle non trovate:';
$hesklang['sme']='Errore SMTP';
$hesklang['scl']='Log di connessione SMTP';
$hesklang['dnl']='Download';
$hesklang['dela']='Elimina questo allegato';
$hesklang['pda']='Si vuol eliminare definitivamente questo allegato?';
$hesklang['thist12']='<li class="smaller">%s | allegato %s rimosso da %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Più opzioni';
$hesklang['lopt']='Meno opzioni';
$hesklang['meml']='Indirizzi di email multipli';
$hesklang['meml2']='Ai clienti è consentito l\'inserimento di più indirizzi di email';

// Added in version 2.4
$hesklang['catd']='(categoria eliminata)';
$hesklang['noopen']='Non è stato trovato alcun ticket aperto appartenente a questo indirizzo di email';
$hesklang['maxopen']='Si è raggiunto il numero massimo di ticket aperti (%d di %d). Attendere che i ticket in corso vengano chiusi prima di aprirne di nuovi.';
$hesklang['ntnote']='Quando qualcuno aggiunge una nota a un ticket di mia competenza';
$hesklang['cat_public']='Pubblica';
$hesklang['cat_private']='Privata';
$hesklang['cat_aa']='Assegna automaticamente i ticket a questa categoria';
$hesklang['cat_type']='Tipo';
$hesklang['caaon']='Per la categoria selezionata è stata abilitata l\'assegnazione automatica';
$hesklang['caaoff']='Per la categoria selezionata è stata disabilitata l\'assegnazione automatica';
$hesklang['cpub']='Tipo di categoria cambiato in PUBBLICO';
$hesklang['cpriv']='Tipo di categoria cambiato in PRIVATO';
$hesklang['cpric']='I clienti non possono selezionare categorie private, solo lo staff lo può fare!';
$hesklang['user_aa']='Assegna in automatico i ticket a questo utente';
$hesklang['attach_size']='Dimensione max allegati';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='byte';
$hesklang['kilobytes']='kilobyte';
$hesklang['megabytes']='megabyte';
$hesklang['gigabytes']='gigabyte';
$hesklang['smtpssl']='Protocollo SSL';
$hesklang['smtptls']='Protocollo TLS';
$hesklang['oo']='Solo ticket aperti';
$hesklang['ool']='Nel messaggio &quot;Codice di tracciamento dimenticato&quot;, elenca solo i ticket ancora aperti';
$hesklang['mop']='Numero max ticket aperti';
$hesklang['rord']='Ordinamento delle risposte';
$hesklang['newbot']='Risposta più recente in fondo';
$hesklang['newtop']='Risposta più recente in cima';
$hesklang['ford']='Modulo di risposta';
$hesklang['formbot']='Mostra il modulo in fondo';
$hesklang['formtop']='Mostra il modulo in cima';
$hesklang['mysqlv']='Versione MySQL';
$hesklang['phpv']='Versione PHP';
$hesklang['csrt']='Ora locale del server HESK:';
$hesklang['listp']='Elenca gli articoli privati';
$hesklang['listd']='Elenca gli articoli in bozza';
$hesklang['artp']='Articoli privati';
$hesklang['artd']='Articoli in bozza';
$hesklang['kb_no_part']='Nessun articolo privato nella knowledgebase';
$hesklang['kb_no_dart']='Nessun articolo in bozza nella knowledgebase';
$hesklang['attpri']='Non si ha accesso a questo allegato';
$hesklang['can_merge_tickets']='Unione di ticket';
$hesklang['mer_selected']='Unisci i ticket selezionati';
$hesklang['merged']='I ticket selezionati sono stati uniti in un unico ticket';
$hesklang['merge_err']='Unendo i ticket si è verificato un problema:';
$hesklang['merr1']='seleziona almeno due ticket';
$hesklang['merr2']='il ticket ricercato non è stato trovato';
$hesklang['merr3']='ticket in una categoria cui non puoi accedere';
$hesklang['tme']='Il ticket %s è stato unito con questo ticket (%s)';
$hesklang['tme1']='Il ticket %s è stato unito con il ticket %s';
$hesklang['tme2']='Inserire l\'indirizzo di email associato per accedere al ticket %s';
$hesklang['eyou']='Per modificare le impostazioni, usare la pagina del proprio profilo';
$hesklang['npea']='Non si dispone dei permessi per modificare questo utente';
$hesklang['duplicate_user']='Esiste già un utente con questo nome utente. Scegliere un nome utente diverso';
$hesklang['kw']='Parole-chiave';
$hesklang['kw1']='(opzionale - separate da spazio, virgola o dall\'inserimento di nuova riga)';
$hesklang['type_not_allowed']='I file aventi estensione (%s) non appartengono ad un formato valido [%s]'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Il cliente non ha ancora letto questa risposta';
$hesklang['sticky']='Metti &quot;In evidenza&quot; questo articolo';
$hesklang['stickyon']='Cambia l\'articolo in &quot;In evidenza&quot;';
$hesklang['stickyoff']='Cambia l\'articolo in &quot;Normale&quot;';
$hesklang['ason']='Articolo contrassegnato come &quot;In evidenza&quot;';
$hesklang['asoff']='Articolo contrassegnato come &quot;Normale&quot;';
$hesklang['ts']='Tempo di lavorazione';
$hesklang['start']='Inizio/Fine';
$hesklang['reset']='Azzeramento';
$hesklang['save']='Salva';
$hesklang['hh']='Ore';
$hesklang['mm']='Minuti';
$hesklang['ss']='Secondi';
$hesklang['thist']='Cronologia del ticket';
$hesklang['thist13']='<li class="smaller">%s | unito al ticket %s da %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | tempo di lavorazione aggiornato a %s da %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | inviato da %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | inviato via POP3 fetching</li>';
$hesklang['twu']='Il tempo di lavorazione del ticket è stato aggiornato';
$hesklang['autoss']='Quando si apre un ticket, fa partire automaticamente il timer';
$hesklang['ful']='Limitazioni nel caricamento del file';
$hesklang['ufl']='È possibile caricare file con estensione:';
$hesklang['nat']='Numero massimo di allegati:';
$hesklang['mfs']='Dimensione massima per allegato:';
$hesklang['lps']='Le preferenze di lingua sono state salvate';
$hesklang['sav']='Mostra le visite all\'articolo';
$hesklang['sad']='Mostra la data dell\'articolo';
$hesklang['emp']='Il PHP in uso non ha il supporto per MySQL attivato (è richiesta l\'estensione mysqli)';
$hesklang['epd']='[HESK] L\'&quot;Email piping&quot; è disabilitato nelle impostazioni';
$hesklang['pfd']='[HESK] Il &quot;POP3 fetching&quot; è disabilitato nelle impostazioni';
$hesklang['pem']='[Piped email]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Cliente]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='Email';
$hesklang['pop3']='POP3 fetching';
$hesklang['pop3h']='Server POP3';
$hesklang['pop3p']='Porta POP3';
$hesklang['pop3tls']='Protocollo TLS';
$hesklang['pop3u']='Nome utente POP3';
$hesklang['pop3w']='Password POP3';
$hesklang['pop3e']='Errore POP3';
$hesklang['pop3log']='Log della connessione POP3';
$hesklang['mysqltest']='Test di connessione MySQL';
$hesklang['smtptest']='Test di connessione SMTP';
$hesklang['pop3test']='Test di connessione POP3';
$hesklang['contest']='Sto testando la connessione. Attendere, prego…';
$hesklang['conok']='Connessione OK!';
$hesklang['conokn']='Tuttavia, se il server richiede nome utente e password, il messaggio non verrà inviato!';
$hesklang['saving']='Sto salvando le impostazioni. Attendere, prego…';
$hesklang['sns']='Le impostazioni sono state salvate, ma alcune funzioni sono state disabilitate poiché il test è fallito';
$hesklang['looph']='Max Hits';
$hesklang['loopt']='Timeframe';
$hesklang['didum']='Si intendeva dire %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Sì, correggi!';
$hesklang['nole']='No, lascia così!';
$hesklang['sconfe2']='Nel modulo di invio ticket mostra un campo &quot;Conferma indirizzo di email&quot;';
$hesklang['oln']='Vecchio nome:';
$hesklang['nen']='Nuovo nome:';
$hesklang['use_form_below']='<i>Per inviare una richiesta di supporto (= ticket), utilizza questo modulo. I campi obbligatori sono evidenziati con</i>';
$hesklang['esf']='Non è possibile inviare notifiche via email';
$hesklang['qrr']='(rimossa la risposta con citazione)';
$hesklang['remqr']='Rimuovi la risposta con citazione';
$hesklang['remqr2']='Elimina la risposta con citazione dai messaggi dei clienti';
$hesklang['suge']='Trova refusi nell\'indirizzo di email';
$hesklang['epro']='Fornitori di indirizzi di email';
$hesklang['email_noreply']='Indirizzo email dell\'Helpdesk';
$hesklang['email_name']='Nome reale per l\'email dell\'Helpdesk';
$hesklang['vscl']='Limiti del server di configurazione';
$hesklang['fnuscphp']='Il caricamento del file non è riuscito. Riprovare senza allegati o usando allegati più piccoli.';
$hesklang['redv']='ritorna alla vista predefinita';
$hesklang['fatte1']='L\'impostazione del &quot;Numero di allegati&quot; per messaggio è superiore a quanto consentito dal server!';
$hesklang['fatte2']='Il file allegato più pesante supera quanto consentito dal server!';
$hesklang['fatte3']='Il server non permette messaggi così grandi. Provare a ridurre il numero di allegati o la dimensione del file!';
$hesklang['embed']='File incorporati';
$hesklang['embed2']='Salva come allegati i file incorporati';
$hesklang['emrem']='(immagine rimossa)';
$hesklang['hdemo']='(NASCOSTA NELLA DEMO)';
$hesklang['ddemo']='Spiacente, questa caratteristica è disabilitata in modalità DEMO!';
$hesklang['sdemo']='Il salvataggio delle modifiche è disabilitato  in modalità DEMO!';
$hesklang['hud']='HESK è aggiornato';
$hesklang['hnw']='Aggiornamento disponibile';
$hesklang['getup']='Aggiorna HESK';
$hesklang['updates']='Aggiornamenti';
$hesklang['updates2']='Controlla automaticamente gli aggiornamenti di HESK';

// Added in version 2.5.0
$hesklang['attdel']='Questo file è stato eliminato dal server e non è più disponibile per lo scaricamento';
$hesklang['dsen']='Non inviare al cliente il messaggio di notifica relativo a questa risposta';
$hesklang['attrem']='*** Alcuni file allegati sono stati rimossi ***';
$hesklang['attnum']='Numero massimo raggiunto: %s'; // %s will show attachment name
$hesklang['attsiz']='File troppo grande: %s'; // %s will show attachment name
$hesklang['atttyp']='Estensione non ammessa: %s'; // %s will show attachment name
$hesklang['adf']='Cartella di amministrazione';
$hesklang['atf']='Cartella degli allegati';
$hesklang['err_adf']='La cartella di amministrazione selezionata (%s) non esiste!'; // %s will show folder name
$hesklang['err_atf']='La cartella degli allegati selezionata (%s) non esiste!'; // %s will show folder name
$hesklang['err_atr']='La cartella degli allegati selezionata (%s) non è accessibile in scrittura!'; // %s will show folder name
$hesklang['fatt']='File allegati a questo messaggio:';
$hesklang['wrepo']='Dopo aver riaperto il ticket, scrivere un messaggio';
$hesklang['ktool']='Strumenti di knowledgebase';
$hesklang['uac']='Verifica e aggiorna il contatore delle visualizzazioni articoli';
$hesklang['acv']='Il contatore degli articoli è stato verificato';
$hesklang['xyz']='Numero di articoli pubblici, privati e in forma di bozza per la categoria';
$hesklang['reports_tab']='Produzione rapporti'; // Tab title
$hesklang['can_run_reports_full']='Produzione di qualsiasi rapporto';
$hesklang['can_export']='Esportazione dei ticket';
$hesklang['roo']='<i>(solo i ticket che ti sono stati assegnati sono inclusi nel rapporto)</i>';
$hesklang['shu']='Link brevi';
$hesklang['export']='Esportazione ticket'; // Tab title
$hesklang['export_btn']='Esportazione ticket'; // Button title
$hesklang['export_intro']='Questo strumento consente di esportare i ticket in un foglio elettronico XML che può essere aperto con Excel';
$hesklang['stte']='Seleziona ticket da esportare';
$hesklang['dtrg']='Intervallo date';
$hesklang['sequentially']='In sequenza'; // Order tickets: Sequentially
$hesklang['ede']='Impossibile creare la cartella di esportazione. Si prega di creare manualmente una cartella denominata <b>export</b> all\'interno della propria cartella degli allegati e di assicurarsi che il PHP vi possa accedere in scrittura (in unix: chmod 777 - rwxrwxrwx).';
$hesklang['eef']='Impossibile creare il file di esportazione essendo privi del permesso di scrittura all\'interno della directory di esportazione';
$hesklang['inite']='Sto inizializzando l\'esportazione';
$hesklang['gXML']='Sto creando il file XML';
$hesklang['nrow']='Numero di righe esportate: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Sto comprimendo il file in un archivio .zip';
$hesklang['eZIP']='Errore nella creazione dell\'archivio .zip';
$hesklang['fZIP']='Compressione file terminata';
$hesklang['pmem']='utilizzo massimo di memoria: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo;FARE CLIC QUI PER SCARICARE IL FILE DI ESPORTAZIONE&laquo;';
$hesklang['n2ex']='Nessun ticket corrisponde ai criteri desiderati: non vi è niente da esportare!';
$hesklang['sp']='Prevenzione SPAM'; // For settings page
$hesklang['sit']='Tipo di immagine';
$hesklang['sis']='Immagine semplice';
$hesklang['rcpb']='Chiave del sito';
$hesklang['rcpv']='Chiave segreta';
$hesklang['pop3keep']='Conserva una copia';
$hesklang['beta']='(VERSIONE DI PROVA)';
$hesklang['maxpost']='Probabilmente si è cercato di inserire più dati di quanti ne accetti questo server.<br /><br />Provare ad inviare nuovamente il modulo senza (o con un numero inferiore di) allegati.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Non risulta possibile validare la protezione reCAPTCHA contro lo SPAM';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Ticket chiuso/risolto';
$hesklang['ms01']='Gen';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Apr';
$hesklang['ms05']='Mag';
$hesklang['ms06']='Giu';
$hesklang['ms07']='Lug';
$hesklang['ms08']='Ago';
$hesklang['ms09']='Set';
$hesklang['ms10']='Ott';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dic';
$hesklang['sdf']='Formato della data inserito';
$hesklang['lcf']='Formato della data aggiornato';
$hesklang['lcf0']='Breve descrizione';
$hesklang['lcf1']='Data e ora';
$hesklang['lcf2']='Stile \'HESK\'';
$hesklang['ticket_tpl']='Modelli di ticket';
$hesklang['can_man_ticket_tpl']='Gestione modelli di ticket'; // Permission title
$hesklang['ticket_tpl_man']='Gestione dei modelli di ticket'; // Page and link title
$hesklang['ticket_tpl_intro']='Creazione e modifica di modelli di ticket utilizzabili per inviare velocemente dei nuovi ticket utilizzando l\'interfaccia di amministrazione';
$hesklang['no_ticket_tpl']='Nessun modello di ticket';
$hesklang['ticket_tpl_title']='Nome';
$hesklang['delete_tpl']='Si è sicuri di voler eliminare questo modello?';
$hesklang['new_ticket_tpl']='Aggiungi o modifica modello di ticket';
$hesklang['ticket_tpl_add']='Crea nuovo modello di ticket';
$hesklang['ticket_tpl_edit']='Modifica il modello di ticket selezionato';
$hesklang['save_ticket_tpl']='Salva il modello di ticket';
$hesklang['ticket_tpl_saved']='Il modello di ticket è stato salvato per un uso futuro';
$hesklang['ticket_tpl_removed']='Il modello di ticket selezionato è stato rimosso dal database';
$hesklang['ticket_tpl_not_found']='Modello di ticket non trovato';
$hesklang['sel_ticket_tpl']='Selezionare il modello di ticket che si desidera modificare';
$hesklang['ent_ticket_tpl_title']='Inserire un nome per il modello';
$hesklang['ent_ticket_tpl_msg']='Inserire il messaggio del modello di ticket';
$hesklang['ticket_tpl_id']='Codice del modello di ticket mancante';
$hesklang['select_ticket_tpl']='Selezionare un modello di ticket';
$hesklang['list_tickets_cat']='Elenca tutti i ticket di questa categoria';
$hesklang['def_msg']='[Nessun messaggio]';
$hesklang['emlreqmsg']='Contenuto obbligatorio';
$hesklang['emlreqmsg2']='Ignora i messaggi email &quot;piped/fetched&quot; privi di contenuto';
$hesklang['relart']='Articoli correlati'; // Title of related articles box
$hesklang['s_relart']='Articoli correlati'; // On settings page
$hesklang['tab_7']='Elenco ticket';
$hesklang['fitl']='Campi dell\'elenco ticket';
$hesklang['submitted']='Inviato';
$hesklang['clickemail']='Visualizza';
$hesklang['set_pri_to']='Impostazione priorità:'; // Action below the ticket list
$hesklang['pri_set_to']='Priorità impostata:';
$hesklang['cat_pri']='Quando i clienti non sono autorizzati a selezionare la priorità e un ticket viene inviato tramite l\'interfaccia-utente, si utilizza la priorità in base alla categoria';
$hesklang['cat_pri_info']='I clienti possono selezionare la priorità. Pertanto viene ignorata la priorità in base alla categoria.<br />Per poter usare quest\'ultima, nelle impostazioni di HESK bisogna selezionare <b>NO</b> per la seguente caratteristica:';
$hesklang['def_pri']='Priorità in base alla categoria:';
$hesklang['ch_cat_pri']='Imposta priorità in base alla categoria';
$hesklang['cat_pri_ch']='La priorità in base alla categoria è stata impostata su:';
$hesklang['err_dbversion']='Versione di MySQL troppo vecchia:';
$hesklang['ip_whois']='IP WHOIS';
$hesklang['ednote']='Modifica la nota del messaggio';
$hesklang['ednote2']='Nota del messaggio salvata';
$hesklang['perm_deny']='Permesso negato';
$hesklang['mis_note']='Codice nota mancante';
$hesklang['no_note']='Non sono state trovate note con questo codice';
$hesklang['sacl']='Salva e prosegui più tardi';
$hesklang['reply_saved']='La risposta è stata salvata per un uso successivo';
$hesklang['submit_as']='Invia come:';
$hesklang['sasc']='Invia come risposta del cliente';
$hesklang['creb']='Risposta del cliente inserita da:';
$hesklang['show_select']='Visualizza &quot;Seleziona&quot; come opzione predefinita';
// Settings
$hesklang['mms']='Modalità di manutenzione';
$hesklang['mmd']='Attiva la modalità di manutenzione';
// Customer notice
$hesklang['mm1']='Manutenzione in corso';
$hesklang['mm2']='Al fine di eseguire le operazioni di manutenzione il servizio di Helpdesk è temporaneamente sospeso.';
$hesklang['mm3']='Ci scusiamo per il disagio e vi invitiamo a riprovare più tardi. Grazie!';
// Staff notice
$hesklang['mma1']='Modalità di manutenzione attiva!';
$hesklang['mma2']='I clienti non possono usare l\'Helpdesk.';
$hesklang['tools']='Strumenti';
$hesklang['banemail']='Blocco degli indirizzi di email';
$hesklang['banemail_intro']='Impedisci ad alcuni indirizzi di email di creare ticket';
$hesklang['no_banemails']='<i>Nessun indirizzo di email al momento risulta bloccato</i>';
$hesklang['eperm']='Blocco permanente dell\'indirizzo di email:';
$hesklang['bananemail']='Indirizzo di email da bloccare';
$hesklang['savebanemail']='Blocca questo indirizzo di email';
$hesklang['enterbanemail']='Inserire l\'indirizzo di email da bloccare';
$hesklang['validbanemail']='Inserire un indirizzo di email (<i>nome.cognome@domain.com</i>) o un dominio (<i>@domain.com</i>) valido';
$hesklang['email_banned']='L\'indirizzo di email <i>%s</i> è stato bloccato. Pertanto, HESK non accetta ticket provenienti da questo indirizzo'; // %s will be replaced with email
$hesklang['emailbanexists']='L\'indirizzo di email <i>%s</i> risulta già bloccato.'; // %s will be replaced with email
$hesklang['email_unbanned']='L\'indirizzo di email è stato sbloccato';
$hesklang['banby']='Blocco eseguita da';
$hesklang['delban']='Sbloccare';
$hesklang['delban_confirm']='Sbloccare questo?';
$hesklang['baned_e']='Si è stati bloccati e non è possibile aprire nuovi ticket';
$hesklang['baned_ip']='Siete stati interdetti da questo Helpdesk';
$hesklang['can_ban_emails']='Blocco degli indirizzi di email';
$hesklang['can_unban_emails']='Sblocco degli indirizzi di email (abilita anche il blocco degli indirizzi)';
$hesklang['eisban']='Questo indirizzo di email è bloccato';
$hesklang['click_unban']='Per sbloccare, fare clic qui ';
$hesklang['banip']='Blocco degli IP';
$hesklang['banip_intro']='Un visitatore proveniente da un IP bloccato non può visualizzare, né inviare ticket e neppure accedere all\'Helpdesk';
$hesklang['ipperm']='Blocco permanente IP:';
$hesklang['iptemp']='Blocco per accesso fallito:';
$hesklang['savebanip']='Blocca questo IP';
$hesklang['no_banips']='<i>Nessun indirizzo IP al momento risulta bloccato</i>';
$hesklang['bananip']='Indirizzo IP da bloccare';
$hesklang['banex']='Esempi:';
$hesklang['iprange']='Intervallo di IP';
$hesklang['ippermban']='Bloccare questo IP in modo permanente';
$hesklang['enterbanip']='Inserire l\'indirizzo o l\'intervallo di indirizzi IP che si desidera bloccare';
$hesklang['validbanip']='Inserire un IP o un intervallo di IP validi';
$hesklang['ip_banned']='L\'indirizzo IP <i>%s</i> è stato bloccato ed HESK non accetterà nuovi ticket da questo IP'; // %s will be replaced with IP
$hesklang['ip_rbanned']='L\'intervallo di IP <i>%s</i> è stato bloccato ed HESK non accetterà nuovi ticket da questo intervallo di IP.'; // %s will be replaced with IP
$hesklang['ipbanexists']='L\'IP <i>%s</i> è già bloccato'; // %s will be replaced with IP
$hesklang['iprbanexists']='L\'intervallo di IP <i>%s</i> è già bloccato'; // %s will be replaced with IP
$hesklang['ip_unbanned']='Sbloccato l\'IP';
$hesklang['ip_tempun']='Tolto il blocco temporaneo dell\'IP';
$hesklang['can_ban_ips']='Blocco degli IP';
$hesklang['can_unban_ips']='Sblocco degli IP';
$hesklang['ipisban']='Questo indirizzo IP è bloccato';
$hesklang['m2e']='Scade tra (minuti)';
$hesklang['info']='Info';
$hesklang['sm_title']='Messaggi di servizio';
$hesklang['sm_intro']='Visualizza un messaggio di servizio nell\'area clienti, ad esempio per notificare loro problemi noti e/o notizie importanti';
$hesklang['can_service_msg']='Modifica dei messaggi di servizio';
$hesklang['new_sm']='Nuovo messaggio di servizio';
$hesklang['edit_sm']='Modifica messaggio di servizio';
$hesklang['ex_sm']='Messaggi di servizio esistenti';
$hesklang['sm_author']='Autore';
$hesklang['sm_type']='Tipo';
$hesklang['sm_published']='Pubblicato';
$hesklang['sm_draft']='Bozza';
$hesklang['sm_style']='Tipo';
$hesklang['sm_none']='Nessuno';
$hesklang['sm_success']='OK, riuscito';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Avviso';
$hesklang['sm_error']='Errore';
$hesklang['sm_save']='Salva';
$hesklang['sm_preview']='Anteprima';
$hesklang['sm_mtitle']='Titolo';
$hesklang['sm_msg']='Messaggio';
$hesklang['sm_e_title']='Inserire il titolo del messaggio di servizio';
$hesklang['sm_e_msg']='Inserire il contenuto del messaggio di servizio';
$hesklang['sm_e_id']='Codice del messaggio di servizio mancante';
$hesklang['sm_added']='Aggiunto un nuovo messaggio di servizio';
$hesklang['sm_deleted']='Messaggio di servizio eliminato';
$hesklang['sm_not_found']='Questo messaggio di servizio non esiste';
$hesklang['no_sm']='Nessun messaggio di servizio';
$hesklang['del_sm']='Eliminare questo messaggio di servizio?';
$hesklang['sm_mdf']='Il messaggio di servizio è stato salvato';
$hesklang['sska']='Mostra gli articoli suggeriti';
$hesklang['taws']='Sono stati suggeriti questi articoli:';
$hesklang['defaults']='Valori predefiniti';
$hesklang['pncn']='Notifica al cliente l\'avvenuto invio del nuovo ticket';
$hesklang['pncr']='Notifica al cliente l\'avvenuto invio di una nuova risposta';
$hesklang['pssy']='Visualizza quali articoli della knowledgebase sono stati suggeriti al cliente';
$hesklang['ccct']='Il cliente può risolvere i ticket';
$hesklang['custnot']='Manda una notifica al cliente quando:';
$hesklang['notnew']='Viene aperto un nuovo ticket';
$hesklang['notclo']='Un ticket viene contrassegnato come &quot;Risolto&quot;';
$hesklang['enn']='eccetto i ticket provenienti via email, se l\'oggetto dell\'email contiene: ';
$hesklang['spamn']='Avviso di SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>Nessun messaggio di conferma?</b><br />Abbiamo inviato un messaggio di conferma al vostro indirizzo di email. Se non si riceve nulla entro qualche minuto, controllare la cartelle di posta "Spam", "Junk" o "Indesiderata". Per evitare ulteriori problemi di ricezione in futuro, si consiglia di contrassegnare eventualmente il messaggio come <b>NON È SPAM</b>.</span>';
$hesklang['ekb_n']='<b>NO</b>, disattiva la knowledgebase';
$hesklang['ekb_y']='<b>SÌ</b>, attiva la knowledgebase';
$hesklang['ekb_o']='<b>SÌ</b>, usa HESK solamente come knowledgebase (<i>disabilitando l\'Helpdesk</i>)';
$hesklang['kb_set']='Impostazioni della knowledgebase';
$hesklang['kbo1']='Modalità di sola knowledgebase';
$hesklang['kbo2']='<br /><br />I visitatori non possono aprire ticket e vengono ridiretti alla knowledgebase';
$hesklang['fpass']='Password dimenticata?';
$hesklang['passr']='Reimpostazione password';
$hesklang['passa']='Gli utenti possono reimpostare la propria password dimenticata usando l\'indirizzo di email';
$hesklang['passe']='Inserire il proprio indirizzo di email';
$hesklang['passs']='Ripristina la password';
$hesklang['noace']='Non è stato trovato alcun account con questo indirizzo di email';
$hesklang['pemls']='È stato inviato un messaggio con le istruzioni per reimpostare la password';
$hesklang['reset_password']='Reimpostazione della password dell\'Helpdesk'; // Email subject
$hesklang['ehash']='Link per reimpostare la password non valido o scaduto';
$hesklang['ehaip']='Indirizzo IP errato. La password può essere reimpostata solo dallo stesso IP che ne ha richiesto la reimpostazione';
$hesklang['resim']='<b>Impostare la password nel modulo sottostante</b>';
$hesklang['permissions']='Autorizzazioni';
$hesklang['atype']='Tipo di account';
$hesklang['astaff']='Staff';
$hesklang['oon1']='Inviatemi solo ticket aperti';
$hesklang['oon2']='Inviatemi tutti i ticket di mia competenza';
$hesklang['anyown']='Qualsiasi proprietario';
$hesklang['pfr']='È in corso un altro processo di POP3 fetching';
$hesklang['pjt']='Timeout processo';
$hesklang['pjt2']='minuti dopo l\'inizio';
$hesklang['nkba']='La ricerca all\'interno della knowledgebase per funzionare adeguatamente richiede un certo numero di articoli.<br />Conviene aggiungere quanti più articoli possibili alla knowledgebase per migliorare i risultati della ricerca e i suggerimenti per la risoluzione dei problemi';
$hesklang['saa']='Gli articoli \'in evidenza\' (sticky) vengono visualizzati in cima alla lista';
$hesklang['yhbr']='Siete stati bloccati fuori dal sistema per %s minuti per aver inviato troppe risposte a un ticket';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='it';

// Added in version 2.7.0
$hesklang['imap']='IMAP fetching';
$hesklang['imaph']='Server IMAP';
$hesklang['imapp']='Porta IMAP';
$hesklang['enc']='Crittografia';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Nessuno';
$hesklang['imapu']='Nome utente IMAP';
$hesklang['imapw']='Password IMAP';
$hesklang['imaptest']='Test di connessione IMAP';
$hesklang['ifd']='[HESK] L\'IMAP fetching è disabilitato nelle impostazioni';
$hesklang['iei']='[HESK] L\'estensione IMAP del PHP non è installata';
$hesklang['ifr']='È in corso un altro processo di IMAP fetching';
$hesklang['arp']='Autoaggiornamento pagina';
$hesklang['arpp']='Ricarica automaticamente la pagina con l\'elenco dei ticket ogni:';
$hesklang['seconds']='secondi';
$hesklang['minutes']='minuti';
$hesklang['atbr']='Questo ticket deve essere assegnato, prima che vi si possa rispondere';
$hesklang['attm']='Assegnami questo ticket';
$hesklang['owneed']='È necessario un proprietario';
$hesklang['taat']='Questo ticket è già assegnato a <b>%s</b>.';
$hesklang['scoy']='Si è sicuri di volerselo autoassegnare?';
$hesklang['scot']='Si è sicuri di volerlo assegnare a %s?';
$hesklang['ycto']='SÌ, modifica il proprietario';
$hesklang['ncto']='NO, mantieni il proprietario attuale';
$hesklang['fass']='Richiede un proprietario';
$hesklang['req_sub']='Il ticket richiede un oggetto';
$hesklang['req_msg']='Richiede un contenuto (messaggio)';
$hesklang['req_email']='Richiede un indirizzo di email';
$hesklang['default_subject']='Ticket da %s';
$hesklang['off-hide']='Nascosto nel modulo-utente';
$hesklang['not_valid_email']='Inserire un indirizzo di email valido o lasciare vuoto questo campo';
$hesklang['write_down']='<span style="color:red">Si raccomanda di salvare da qualche parte il codice identificativo del ticket per possibili usi futuri</span>';
$hesklang['re_confirm1']='Disabilitando ciò si disabilita anche: "Indirizzo di email obbligatorio per la visualizzazione del ticket" in "Sicurezza". Procedere?';
$hesklang['re_confirm2']='Abilitando ciò si abilita anche: "Richiede un indirizzo di email" in "Opzioni". Procedere?';
$hesklang['can_email_tpl']='Modifica dei modelli di messaggio email';
$hesklang['et_title']='Modelli di messaggio email';
$hesklang['et_intro']='Permette di modificare i messaggi di email che vengono spediti allo staff e ai clienti';
$hesklang['file']='File';
$hesklang['efile']='Modifica file';
$hesklang['rdesc']='Descrizione';
$hesklang['desc_forgot_ticket_id']='(Cliente) Codice identificativo ticket dimenticato';
$hesklang['desc_new_reply_by_staff']='(Cliente) Nuova risposta dallo staff';
$hesklang['desc_new_ticket']='(Cliente) Ticket ricevuto';
$hesklang['desc_ticket_closed']='(Cliente) Ticket chiuso/risolto';
$hesklang['desc_category_moved']='(Staff) Ticket spostato in una nuova categoria';
$hesklang['desc_new_reply_by_customer']='(Staff) Nuova risposta dal cliente';
$hesklang['desc_new_ticket_staff']='(Staff) Nuovo ticket';
$hesklang['desc_ticket_assigned_to_you']='(Staff) Ti è stato assegnato un ticket';
$hesklang['desc_new_pm']='(Staff) Nuovo messaggio privato';
$hesklang['desc_new_note']='(Staff) Nuova nota riguardante un ticket che ti è stato assegnato';
$hesklang['desc_reset_password']='(Staff) Reimposta la password';
$hesklang['etfm']='Mancano uno o più modelli di messaggio email.<br /><br />Assicurarsi di caricare tutti i modelli di messaggio email all\'interno della cartella <i>/language/%s/emails</i>.';
$hesklang['etfw']='Alcuni modelli di messaggio email non sono accessibili in scrittura.<br /><br />Assicurarsi che PHP abbia il permesso di scrittura su tutti i file all\'interno della cartella <i>/language/%s/emails</i><br /><br />Nei server unix potrebbe essere necessario modificare il chmod dei file dei modelli di messaggio email in 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Identificativo del modello mancante';
$hesklang['et_fm']='Questo modello di messaggio email manca';
$hesklang['et_fw']='Questo modello di messaggio email non è accessibile in scrittura';
$hesklang['et_save']='Salva modifiche';
$hesklang['updated_on']='Aggiornamento in corso';
$hesklang['ticket_url']='URL del ticket';
$hesklang['pm_url']='URL del messaggio privato';
$hesklang['et_num']='Numero dei ticket';
$hesklang['et_list']='Elenco dei ticket';
$hesklang['et_empty']='Il modello di messaggio email non può essere vuoto';
$hesklang['et_saved']='Modello di messaggio email salvato';
$hesklang['source']='Sorgente';
$hesklang['select_category']='Selezionare una categoria';
$hesklang['select_category_text']='In che cosa possiamo aiutarvi?';
$hesklang['select_category_staff']='Selezionare una categoria di ticket';
$hesklang['scat']='N. max di categorie selezionabili';
$hesklang['scat2']='Se il numero di categorie disponibili supera il limite sopra definito,<br>compare un menu di selezione a discesa al posto della visualizzazione di tutte le categorie';
$hesklang['new_cf']='Nuovo campo personalizzato';
$hesklang['cf_intro']='Usare questa opzione per aggiungere campi personalizzati al modulo per l\'Invio dei ticket, così da acquisire ulteriori informazioni riguardanti i clienti';
$hesklang['cf_public']='Pubblico';
$hesklang['cf_private']='Privato';
$hesklang['cf_cust']='Clienti';
$hesklang['cf_all']='Tutte';
$hesklang['cf_cat']='Selezionate';
$hesklang['cf_ctrl']='Suggerimento: tenere premuto il pulsante CTRL per selezionare più categorie contemporaneamente';
$hesklang['visibility']='Visibilità';
$hesklang['cf_save']='Salva campo personalizzato';
$hesklang['ex_cf']='Campi personalizzati attivi';
$hesklang['no_cf']='Nessun campo personalizzato attivo';
$hesklang['del_cf']='Eliminare questo campo personalizzato? Anche tutti i dati relativi a tale campo saranno eliminati dal database!';
$hesklang['cf_e_id']='Identificativo non valido';
$hesklang['edit_cf']='Modifica campo personalizzato';
$hesklang['cf_deleted']='Eliminazione campo personalizzato';
$hesklang['cf_not_found']='Questo campo personalizzato non esiste';
$hesklang['cf_added']='Aggiunto un nuovo campo personalizzato';
$hesklang['cf_nocat']='Per questo campo personalizzato selezionare almeno una categoria';
$hesklang['cf_mdf']='Il campo personalizzato è stato salvato';
$hesklang['atl1']='Inserire almeno un\'opzione';
$hesklang['sch']='Campo di testo nascosto';
$hesklang['meml3']='Consente di inserire più email';
$hesklang['dmin']='Data minima accettata';
$hesklang['dmax']='Data massima accettata';
$hesklang['d_day']='giorno/i';
$hesklang['d_week']='settimana/e';
$hesklang['d_month']='mese/i';
$hesklang['d_year']='anno/i';
$hesklang['d_any']='Qualsiasi data';
$hesklang['d_fixed']='Data assoluta';
$hesklang['d_relative']='Data relativa';
$hesklang['d_mm']='La data minima non può essere posteriore alla data massima!';
$hesklang['d_emin']='La data minima per <i>%s</i> è %s';
$hesklang['d_emax']='La data massima per <i>%s</i> è %s';
$hesklang['d_format']='Formato di visualizzazione data';
$hesklang['d_custom']='Formato personalizzato';
$hesklang['d_ci']='SOLO PER UTENTI ESPERTI:  per inserire un formato di data PHP compatibile, consultare il relativo manuale';
$hesklang['cf_noe']='Inserire un indirizzo di email valido in <i>%s</i>';
$hesklang['cf_noem']='Inserire uno o più indirizzi di email validi in <i>%s</i>';
$hesklang['can_resolve']='Risoluzione di ticket';
$hesklang['can_change_own_cat']='Spostamento di ticket in un tipo di categoria consentito';
$hesklang['can_submit_any_cat']='Creazione di ticket per qualsiasi tipo di categoria';
$hesklang['noauth_submit']='Non si è autorizzati a creare ticket per questa categoria!';
$hesklang['noauth_move']='Non si è autorizzati a spostare ticket in questa categoria!';
$hesklang['noauth_resolve']='Non si è autorizzati a risolvere ticket!';
$hesklang['force_ssl']='Forza connessioni SSL';
$hesklang['d_ssl']='disabilitato - Per gestire questa opzione, aprire questa pagina usando https://';
$hesklang['scno']='Questo stato non può essere cambiato';
$hesklang['statuses']='Stato';
$hesklang['statuses_intro']='Usare questo strumento per aggiungere uno o più stati personalizzati ai ticket del vostro Helpdesk';
$hesklang['color']='Colore';
$hesklang['csscl']='Classe o colore del CSS';
$hesklang['clr_view']='Anteprima del colore del testo';
$hesklang['cbc']='Modificabile dai clienti';
$hesklang['ccc']='I clienti possono modificare questo stato?';
$hesklang['del_status']='Eliminare questo stato?';
$hesklang['ex_status']='Stati esistenti';
$hesklang['status_hesk']='Stati preimpostati (qui non si possono modificare)';
$hesklang['status_custom']='Stati personalizzati';
$hesklang['status_custom_none']='Non esistono stati personalizzati. Si possono aggiungere facendo clic sul pulsante "Nuovo stato personalizzato" posto in alto a destra.';
$hesklang['status_save']='Salva';
$hesklang['list_tkt_status']='Elenca tutti i ticket aventi questo stato';
$hesklang['new_status']='Nuovo stato personalizzato';
$hesklang['edit_status']='Modifica stato personalizzato';
$hesklang['err_status']='Inserire il nome dello stato';
$hesklang['status_added']='Creato un nuovo stato';
$hesklang['status_e_id']='Identificativo non valido';
$hesklang['status_mdf']='Salvato lo stato personalizzato';
$hesklang['status_deleted']='Eliminato lo stato personalizzato';
$hesklang['status_not_found']='Questo stato personalizzato non esiste';
$hesklang['status_not_empty']='Questo stato non può essere rimosso perché esistono dei ticket in questo stato';
$hesklang['status_limit']='Vi sono già 100 stati personalizzati: non è possibile crearne altri!';
$hesklang['public_link']='Link pubblico';
$hesklang['frames']='Frame';
$hesklang['frames2']='Non è consentito il caricamento di HESK come \'frame\' in un dominio di terze parti';
$hesklang['numsub']='Ticket inviati';
$hesklang['hidf']='I clienti non possono visualizzare i campi di testo nascosti eventualmente presenti nel modulo di invio dei ticket. Se però la loro \'Visibilità\' è \'Pubblica\', il loro contenuto sarà comunque visibile nella pagina di dettaglio dei ticket. Per i membri dello staff i campi nascosti sono uguali ai normali campi di testo.';
$hesklang['rcheck']='Non selezionare un\'opzione predefinita';
$hesklang['refresh_page']='Aggiorna questa pagina';
$hesklang['del_kba']='Elimina questo articolo';
$hesklang['del_kbaa']='Eliminazione definitiva di questo articolo';
$hesklang['hni1']='HESK non ancora installato?';
$hesklang['hni2']='Sembra che questa istanza di HESK non sia stata ancora installata e/o configurata in modo appropriato';
$hesklang['hni3']='Per installare HESK, seguire le <a href="docs/">Istruzioni</a> presenti nella documentazione';
$hesklang['cf']='Cartella di cache';
$hesklang['e_cdir']='HESK non è in grado di analizzare le email o di memorizzare i risultati a meno che non esista una cartella di cache accessibile in scrittura';
$hesklang['step1']='I Passaggio';
$hesklang['step2']='II Passaggio';
$hesklang['dffs']='A scaricamento completato, eliminare questo file dal server';
$hesklang['fd']='File di esportazione eliminato dal server';

// Added in version 2.8.0
$hesklang['TZ']='Fuso orario';
$hesklang['thist17']='<li class="smaller">%s | inviato tramite IMAP</li>';
$hesklang['sir3']='reCAPTCHA invisibile';
$hesklang['invisible']='invisibile';
$hesklang['imap_not']='Il PHP non è stato compilato con il supporto per IMAP';
$hesklang['imap_warning']='L\'utente %1$s ha lo stesso indirizzo email dell\'IMAP fetching: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='L\'utente %1$s ha lo stesso indirizzo email del POP3 fetching: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Ciò potrebbe determinare l\'insorgenza di un \'Email loop\' in cui vengono creati nuovi ticket a partire dalle notifiche email dell\'utente. L\'indirizzo di posta elettronica di fetching dovrebbe essere univoco e non essere usato da nessun altro';
$hesklang['can_view_ass_by']='Visualizzazione di ticket che l\'interessato/a ha assegnato ad altri';
$hesklang['can_privacy']='Anonimizzazione di ticket';
$hesklang['confirm_anony']='Rendi anonimo questo ticket';
$hesklang['anon_selected']='Rendi anonimi i ticket selezionati';
$hesklang['privacy_anon_info']='A seguito del diritto all\'oblio, vengono rimossi tutti i dati che consentono un\'identificazione personale nonché i contenuti dei ticket (nome cliente, indirizzo di email, messaggio, allegati, IP…), conservando però i ticket nel database a scopo statistico';
$hesklang['success_anon']='Ticket reso anonimo con successo';
$hesklang['num_tickets_anon']='Numero di ticket resi anonimi: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Cliente]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Oggetto]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Messaggio]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | reso anonimo da %s</li>';
$hesklang['print_selected']='Stampa i ticket selezionati';
$hesklang['with_selected']='Con i selezionati:';
$hesklang['assign_selected']='Assegna i selezionati a:';
$hesklang['assign_no']='Nessun proprietario selezionato, nessuna modifica effettuata';
$hesklang['assign_1']='I ticket selezionati sono stati impostati come \'Non assegnato\'';
$hesklang['assign_2']='Il codice ticket %1$s è stato impostato come \'Non assegnato\''; // %1$s = ticket numerical ID
$hesklang['assign_3']='Errore %1$s: già assegnato a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s assegnato a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='Errore %1$s: %2$s non può accedere alla categoria del ticket'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Risultato dell\'assegnazione dei ticket in massa:<br /><br />Assegnati: %1$s<br />Errori: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='Indirizzo IP';
$hesklang['moret']='Altre opzioni'; // More options button title
$hesklang['btn_more']='Altro'; // More options button text
$hesklang['btn_print']='Stampa';
$hesklang['btn_edit']='Modifica';
$hesklang['btn_lock']='Blocca ticket';
$hesklang['btn_unlock']='Sblocca ticket';
$hesklang['btn_tag']='Etichetta ticket';
$hesklang['btn_resend']='Re-invia la notifica per email';
$hesklang['btn_untag']='Rimuovi etichetta al ticket';
$hesklang['btn_import_kb']='Importa nella knowledgebase';
$hesklang['btn_anony']='Rendi anonimo il ticket';
$hesklang['btn_delt']='Elimina ticket';
$hesklang['btn_delr']='Elimina risposta';
$hesklang['ernf']='Risposta non trovata';
$hesklang['tns']='Le notifiche ai ticket sono state re-inviate';
$hesklang['rns']='Le risposte ai ticket sono state re-inviate';
$hesklang['fname']='Nome';
$hesklang['export_selected']='Esporta i ticket selezionati';
$hesklang['btn_export']='Esporta in XML per Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Risposte';
$hesklang['team']='Team';
$hesklang['sm_content']='Contenuto';
$hesklang['sm_settings']='Impostazioni';
$hesklang['wizard_back']='Precedente'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Successivo'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Va alle impostazioni';
$hesklang['sm_return_to_editing']='Ritorna alle modifiche';
$hesklang['email_tpl_title']='Titolo';
$hesklang['edit_email_template']='Modifica il modello di messaggio email';
$hesklang['err_no_settings_section']='Non è stata fornito alcun gruppo di impostazioni';
$hesklang['this_field_is_required']='Questo campo è obbligatorio';
$hesklang['reset_your_password']='Ripristino della password';
$hesklang['reset_password_instructions']='Si prega di inserire qui sotto l\'indirizzo di email con il quale siete registrati. Vi verrà inviato un messaggio contenente un link da cui è possibile ripristinare la password';
$hesklang['enter_email']='Inserire l\'indirizzo di email';
$hesklang['password_reset_check_your_email']='Si prega di controllare la propria posta elettronica';
$hesklang['password_reset_link_sent']='Vi è stato inviato un link per ripristinare la password';
$hesklang['back_to_login']='Ritorna alla pagina di accesso';
$hesklang['pager_first']='Prima';
$hesklang['pager_previous']='Precedente';
$hesklang['pager_next']='Successiva';
$hesklang['pager_last']='Ultima';
$hesklang['new_team_member']='Nuovo membro del team';
$hesklang['role']='Ruolo';
$hesklang['optional']='Opzionale';
$hesklang['edit_profile']='Modifica profilo';
$hesklang['assigned_to']='Assegnato a';
$hesklang['contact']='Contatto';
$hesklang['unban_email']='Sblocca questo indirizzo di email';
$hesklang['unban_ip']='Sblocca questo IP';
$hesklang['show_previous_replies']='Mostra risposte precedenti';
$hesklang['type_your_message']='Componi il messaggio'; // Used when there are no canned responses
$hesklang['close_button_text']='Chiudi';
$hesklang['create_new_ticket']='Crea nuovo ticket';
$hesklang['delete_article']='Cancella articolo';
$hesklang['view_existing_tickets']='Visualizza ticket esistenti';
$hesklang['how_can_we_help']='Salve! In che cosa possiamo aiutarvi?';
$hesklang['search_for_articles']='Ricerca articoli';
$hesklang['submit_a_support_request']='Invia una richiesta di assistenza';
$hesklang['verify_header']='Antispam';
$hesklang['ticket_details']='Dettagli ticket';
$hesklang['yes_title_case']='Sì';
$hesklang['no_title_case']='No';
$hesklang['no_results_found']='Non è stato trovato alcun risultato';
$hesklang['site_theme']='Tema del sito';
$hesklang['test_theme_folder']='Cartella di test per il tema';
$hesklang['test_theme_folder_description']='Sto testando la cartella dei temi per la presenza di temi validi. Solo i temi che superano tutti i test vengono installati correttamente';
$hesklang['err_site_theme']='Selezionare il tema di HESK';
$hesklang['confirm']='Conferma';
$hesklang['confirm_deletion']='Conferma la cancellazione';
$hesklang['confirm_delete_status']='Si è sicuri di voler cancellare questo stato personalizzato?';
$hesklang['help_desk']='Helpdesk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.it.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Visualizzazione del tempo';
$hesklang['tdisd']='Data e ora';
$hesklang['tdisa']='Tempo fa (per esempio: 5 ore fa)';
$hesklang['nav_templates']='Modelli'; // Admin panel navigation item
$hesklang['hide_replies']='Nascondi le risposte ai ticket';
$hesklang['hide_replies_no']='Mai, mostra sempre tutte le risposte';
$hesklang['hide_replies_yes']='Nascondi tutte le risposte eccetto l\'ultima:';
$hesklang['hide_replies_def']='Mostra l\'ultima risposta dello staff e tutte le successive risposte del cliente';
$hesklang['reply_by']='Risposta da'; // Reply by NAME
$hesklang['btt']='Ritorna in cima';
$hesklang['lwidth']='Limita l\'ampiezza del ticket';
$hesklang['lwidtall']='Usa la larghezza massima disponibile';
$hesklang['lwidtpx']='Ampiezza massima (in pixel):';
// 3-letter days of the week
$hesklang['mon']='Lun';
$hesklang['tue']='mar';
$hesklang['wed']='Mer';
$hesklang['thu']='Gio';
$hesklang['fri']='Ven';
$hesklang['sat']='Sab';
$hesklang['sun']='Dom';
$hesklang['clear']='Svuota'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Moduli';
$hesklang['modules_demo']='Questo modulo è attualmente disponibile solo a %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Provate qui %s la versione \'demo\''; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistiche';
$hesklang['statistics']['intro']='Questo rapporto fornisce degli approfondimenti riguardanti l\'uso del vostro Helpdesk e le performance dello staff.';
$hesklang['statistics']['ntsp']='Nessun ticket nel periodo di tempo selezionato.';
$hesklang['statistics']['pie_title_ro']='Ticket: aperti vs risolti';
$hesklang['statistics']['open']='Aperti';
$hesklang['statistics']['resolved']='Risolti';
$hesklang['statistics']['pie_title_as']='Ticket aperti: assegnati vs non assegnati';
$hesklang['statistics']['ass']='Assegnati';
$hesklang['statistics']['unas']='Non assegnati';
$hesklang['statistics']['pie_title_au']='Ticket aperti: con risposta vs senza risposta';
$hesklang['statistics']['answered']='Con risposta';
$hesklang['statistics']['unanswered']='Senza risposta';
$hesklang['statistics']['pie_title_so']='Stato dei ticket aperti';
$hesklang['statistics']['retic']='Ticket:';
$hesklang['statistics']['chart_title_md']='Ticket per giorno del mese';
$hesklang['statistics']['chart_title_wd']='Ticket per giorno della settimana';
$hesklang['statistics']['chart_title_hd']='Ticket per ora del giorno';
$hesklang['statistics']['chart_title_tfr']='Tempo per la prima risposta dello staff';
$hesklang['statistics']['chart_title_tfrc']='Ticket cui è stato risposto entro un certo lasso di tempo';
$hesklang['statistics']['chart_title_ttr']='Tempo fra l\'invio iniziale e la risoluzione di un ticket';
$hesklang['statistics']['chart_title_ttrc']='Ticket risolti entro un certo lasso di tempo';
$hesklang['statistics']['chart_title_sr']='Risposte dello staff';
$hesklang['statistics']['chart_title_srt']='Risposte dello staff per ticket';
$hesklang['statistics']['chart_title_srtr']='Risposte dello staff per ticket (solo per i ticket risolti)';
$hesklang['statistics']['chart_title_srt1']='Risposte dello staff per ticket (ticket con almeno una risposta)';
$hesklang['statistics']['ct_30']='30 minutes';
$hesklang['statistics']['ct_1h']='1 ora';
$hesklang['statistics']['ct_2h']='2 ore';
$hesklang['statistics']['ct_4h']='4 ore';
$hesklang['statistics']['ct_1d']='1 giorno';
$hesklang['statistics']['ct_2d']='2 giorni';
$hesklang['statistics']['ct_3d']='3 giorni';
$hesklang['statistics']['ct_1w']='1 settimana';
$hesklang['statistics']['ct_wp']='> 1 settimana';
$hesklang['statistics']['ct_1m']='1 mese';
$hesklang['statistics']['ct_mp']='> 1 mese';
$hesklang['statistics']['axis1']='% di ticket con risposta';
$hesklang['statistics']['axis2']='% di ticket risolti';
$hesklang['statistics']['axis3']='% di ticket';
$hesklang['statistics']['axis4']='Tempo per la prima risposta';
$hesklang['statistics']['axis5']='Tempo per la risoluzione';
$hesklang['statistics']['axis6']='Numero di risposte';
$hesklang['statistics']['axis7']='Numero di ticket';
$hesklang['statistics']['axis8']='Giorno della settimana';
$hesklang['statistics']['axis9']='Ora';
$hesklang['statistics']['axis10']='Giorno del mese';
$hesklang['statistics']['tr_0']='Nessuna risposta';
$hesklang['statistics']['tr_1']='1 risposta';
$hesklang['statistics']['tr_2']='2 risposte';
$hesklang['statistics']['tr_5']='3-5 risposte';
$hesklang['statistics']['tr_10']='6-10 risposte';
$hesklang['statistics']['tr_99']='> 10 risposte';
$hesklang['statistics']['average']='Media';
$hesklang['statistics']['atfr']='Tempo medio in ore e minuti per la prima risposta dello staff:';
$hesklang['statistics']['attr']='Tempo medio in ore e minuti per la risoluzione di un ticket:';
$hesklang['statistics']['about']='circa %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N.D.';
$hesklang['statistics']['trept']='Numero totale di ticket cui lo staff ha risposto:';
$hesklang['statistics']['trnr']='Numero totale di ticket risolti senza risposte dello staff:';
$hesklang['statistics']['tsr']='Numero totale di risposte dello staff:';
$hesklang['statistics']['tsrt']='Numero medio di risposte dello staff per ticket:';
$hesklang['statistics']['tsro']='Numero medio di risposte (ticket con almeno una risposta dello staff):';
$hesklang['statistics']['tsrc']='Numero medio di risposte dello staff per risolvere un ticket:';
$hesklang['statistics']['tsrr']='Numero medio di risposte dello staff per risolvere un ticket (ticket con almeno una risposta dello staff):';
$hesklang['sep_1000']='.'; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='e molto altro…'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket scaduto';
$hesklang['ticket_escalated']='La priorità del Ticket[#%%TRACK_ID%%] è stata innalzata: %%SUBJECT%%';
$hesklang['escalate']['tab']='Incrementa Priorità'; // Menu link
$hesklang['escalate']['page_title']='Incrementa Priorità Ticket'; // Page H2 title
$hesklang['escalate']['intro']='Questo modulo incrementerà tutti i ticket che non sono stati risolti nei tempi previsti';
$hesklang['escalate']['feat1']='Ticket non assegnato, senza risposta, o oltre la scadenza';
$hesklang['escalate']['feat2']='ticket prossimi alla scadenza o già scaduti';
$hesklang['escalate']['feat3']='cambia automaticamente la priorità del ticket, riassegna il ticket, manda una notifica via email';
$hesklang['escalate']['feat4']='applica regole basate sulla categoria del ticket, proprietario, stato';
$hesklang['escalate']['prefix']='Priorità incrementata:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Regole attive';
$hesklang['escalate']['new']='Nuova regola di innalzamento priorità';
$hesklang['escalate']['no_rules']='Non ci sono regole di innalzamento priorità. Creane una cliccando sul bottone &quot;Nuova regola di innalzamento priorità&quot;.';
$hesklang['escalate']['title']='Titolo Regola';
$hesklang['escalate']['titlet']='Un titolo descrittivo per esempio: Riassegna i ticket senza risposta dopo 24 ore';
$hesklang['escalate']['default_title']='Regola creata da %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Condizione regola';
$hesklang['escalate']['trigt']='Imposta la condizione che attiverà questa regola';
$hesklang['escalate']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condizione'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Azione'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Si applica a'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Eliminare questa regola?';
$hesklang['escalate']['edit']='Modifico regola di innalzamento ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Il ticket di supporto è:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='senza risposta da parte dello staff';
$hesklang['escalate']['nrepc']='senza risposta da parte del cliente';
$hesklang['escalate']['nass']='non assegnato';
$hesklang['escalate']['nres']='non risolto';
$hesklang['escalate']['ndue']='in scadenza';
$hesklang['escalate']['odue']='scaduto';
$hesklang['escalate']['within']='in:';
$hesklang['escalate']['minutes']='minuti';
$hesklang['escalate']['hours']='ore';
$hesklang['escalate']['days']='giorni';
$hesklang['escalate']['weeks']='settimane';
$hesklang['escalate']['months']='mesi';
$hesklang['escalate']['years']='anni';
$hesklang['escalate']['ofs']='dalla sua creazione';
$hesklang['escalate']['resend']='Reinvia notifiche via mail';
$hesklang['escalate']['force']='Invia sempre, sovrascrivi le impostazioni dello staff';
$hesklang['escalate']['noforce']='Rispetta le impostazioni di notifica dello staff';
$hesklang['escalate']['setpri']='Imposta la priorità su:';
$hesklang['escalate']['setsta']='Imposta lo stato su:';
$hesklang['escalate']['assto']='Assegna il ticket a:';
$hesklang['escalate']['asm']='Un altro membro dello staff';
$hesklang['escalate']['notify']='Notifica ai membri dello staff...';
$hesklang['escalate']['ato']='Si applica a:';
$hesklang['escalate']['tic']='Ticket nella categoria:';
$hesklang['escalate']['tat']='Ticket assegnati a:';
$hesklang['escalate']['tws']='Ticket con stato:';
$hesklang['escalate']['tall']='Applica questa regola ai ticket attuali e a quelli futuri';
$hesklang['escalate']['tfn']='Applica questa regola solo ai prossimi, ignora per quelli esistenti';
$hesklang['escalate']['tfi']='Applica questa regola solo ai ticket con ID maggiore di:';
$hesklang['escalate']['save']='Salva regola';
$hesklang['escalate']['e_tt']='Il tempo dovrebbe essere tra 1 e 10000';
$hesklang['escalate']['e_a']='Selezionare almeno una azione da compiere sui ticket corrispondenti';
$hesklang['escalate']['nocat']='Selezionare almeno una categoria';
$hesklang['escalate']['nouser']='Selezionare almeno un utente';
$hesklang['escalate']['nostatus']='Selezionare almeno uno stato';
$hesklang['escalate']['nocata']='%1$s non ha accesso a queste categorie'; // %1$s = user name
$hesklang['escalate']['rule_added']='Una nuova regola è stata creata';
$hesklang['escalate']['mdf']='Le impostazioni della regola sono state salvate';
$hesklang['escalate']['e_id']='Nessuna regola trovata con questo ID';
$hesklang['escalate']['deleted']='La regola selezionata è stata eliminata';
$hesklang['escalate']['edit_notice']='cambiare la condizione di attivazione della regola non influirà sui ticket già innalzati da questa regola(a meno che non resetti la regola).';
$hesklang['escalate']['reset']='Resetta la regola';
$hesklang['escalate']['reset2']='Sei sicuro di voler resettare questa regola?<br><br>Il numero di hits verrà azzerato tutti i ticket corrispondenti saranno innalzati';
$hesklang['escalate']['reset3']='La regola selezionata è stata resettata';
$hesklang['escalate']['log_title']='Regola #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | priorità innalzata da %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - imposta prirità su %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - assegna a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - invia notifiche allo staff</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - invia notifiche allo staff (forced)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - errore: %2$s non ha accesso alla categoria del ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - errore: %2$s non ha il permesso per vedere i ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - errore: nessun altro utente può vedere questo ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - notifica: priorità già impostata su %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - notifica: già assegnata a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notifica: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - imposta lo stato su %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - notifica: stato già impostato su %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Attiva'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Attiva questa regola (inizia a usarla)';
$hesklang['escalate']['activated']='La regola selezionata è stata attivata'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Disattiva questa regola(smetti di usarla)';
$hesklang['escalate']['deactivated']='La regola selezionata è stata disattivata'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Nessuna regola di innalzamento attiva';
$hesklang['escalate']['matched']='Numero di ticket corrispondenti: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Strumenti';
$hesklang['escalate']['test']='Simula questa regola';
$hesklang['escalate']['testa']='Simula tutte le regole';
$hesklang['escalate']['testaa']='Simula tutte le regole attive';
$hesklang['escalate']['testr']='Risultati della simulazione';
$hesklang['escalate']['rsim']='Ripeti simulazione';
$hesklang['escalate']['tbef']='Prima che una regola funzioni, è necessario attivarla cliccando sulla casella nella colonna &quot;ACTIVE&quot;.<br><br>
                               Raccomandiamo vivamente di <strong>simulare</strong> ogni regola cliccando sulla icona %1$s (Simulate this rule) presente nella tabella delle regole per vedere come influenzerà i ticket esistenti prima di attivarla.<br><br>
                               <strong>Le regole attive vengono processate ogni %2$s minuti. Un ticket può essere solo innalzato una volta da ogni regola</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='MODO SIMULAZIONE, nessuna modifica al database';
$hesklang['escalate']['sic']='SIMULAZIONE COMPLETATA';
$hesklang['escalate']['r']='[RULE]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Suggerimento: tieni premuto il tasto CTRL key per selezionare più opzioni';
$hesklang['desc_ticket_escalated']='(Staff) Il ticket è stato innalzato'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Ticket Formatting (Staff)';
$hesklang['ticket_formatting_plaintext']='Plain Text';
$hesklang['ticket_formatting_rich_text']='Rich Text (HTML)';
$hesklang['due_date']='Data di scadenza';
$hesklang['invalid_due_date']='È stata inserita una data di scadenza non valida';
$hesklang['thist19']='<li class="smaller">%s | data di scadenza aggiornata al %s da %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | data di scadenza eliminata da %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='La data di scadenza del ticket è stata aggiornata.';
$hesklang['menu_kb_manage']='Gestisci'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Visualizza'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Seleziona tutti';
$hesklang['a_deselect']='Deseleziona tutti';
$hesklang['a_toggle']='Abilita tutti';
$hesklang['ql_all']='Tutti i ticket';
$hesklang['ql_alo']='Tutti i ticket aperti';
$hesklang['ql_fit']='Ticket filtrati';
$hesklang['ql_a2m']='Assegnati a me';
$hesklang['ql_a2o']='Assegnati ad altri';
$hesklang['ql_una']='Non assegnati';
$hesklang['ql_due']='In scadenza';
$hesklang['ql_ovr']='Scaduti';
$hesklang['set_ds']='Mostra come &quot;in scadenza &quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='giorni prima della scadenza';
$hesklang['not_aos']='Alcuni dei tuoi ticket non vengono mostrati per i filtri che hai impostato.';
$hesklang['ntoverdue']='È scaduto il ticket assegnato a:';
$hesklang['ovdcron']='perchè le notifiche di scadenza funzionino, il tuo amministratore deve abilitare un cron job';
$hesklang['instructions']='Istruzioni';
$hesklang['desc_overdue_ticket']='(Staff) Ticket scaduto';
$hesklang['overdue_starting']='Inizio il processo di notifica dei ticket scaduti';
$hesklang['overdue_sim']='Inviare email e aggiornare le notifiche è disabilitato nella SIMULATION mode.';
$hesklang['overdue_ticket_count']='Found %s tickets that are overdue.'; // %s = Number of tickets
$hesklang['overdue_finished']='Ticket scaduti terminati. %s email inviate. %s email con invio fallito.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Carica un foglio di stile personalizzato per il pannello di amministratore';
$hesklang['noval_cert']='Non validare i certificati server';
$hesklang['chg_cat']='Cliccare per modificare la categoria del ticket';
$hesklang['tlan']='Lingua del ticket';
$hesklang['uue']='Due o più membri dello staff hanno lo stesso indirizzo email. Vi raccomandiamo di usare un indirizzo email diverso per ogni utente';
$hesklang['flood']='Flood limit';
$hesklang['e_flood']='Ooops, hai già inviato una risposta recentemente. Abbiamo bloccato questa richiesta per prevenire i messaggi indesiderati.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='URL Access Key'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Genera una random URL Access Key';
$hesklang['ukeym']='Errore: per eseguire questo file via HTTP devi includere la tua URL Access Key nella richiesta. Esempio:';
$hesklang['ukeyw']='Errore: Access Key URL non valido';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket ricevuto: %%SUBJECT%%';
$hesklang['mfa_verification']='Il tuo codice di verifica è %%VERIFICATION_CODE%%';
$hesklang['follow_up_email']='Sii onesto: come abbiamo fatto?';
$hesklang['mfa']='Autenticazione multi-fattore (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Abilitata?';
$hesklang['mfa_required']='Richiedi autenticazione multi-fattore';
$hesklang['mfa_manage_profile']='Gestisci MFA';
$hesklang['mfa_disabled']='Autenticazione multi-fattore disabilitata';
$hesklang['mfa_enabled']='Autenticazione multi-fattore abilitata (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='None';
$hesklang['mfa_method_none_subtext']='Rimuovi l\'autenticazione multi-fattore dal tuo account.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='L\'helpdesk manderà una mail con un codice d\'accesso casuale a <strong>%s</strong> in fase d\'accesso.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='App d\'autenticazione';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Usa un\'applicazione per smartphone, come Authy o Google Authenticator, per generare un codice di accesso casuale in fase d\'accesso.';
$hesklang['mfa_step_method']='Metodo';
$hesklang['mfa_step_verification']='Verifica';
$hesklang['mfa_step_complete']='Completata';
$hesklang['mfa_introduction']='L\'autenticazione multi-fattore migliora la sicurezza dell\'account richiedendoti di verificare il tuo accesso utilizzando un metodo aggiuntivo di verifica, come una email o un\'app di autenticazione (ad esempio Authy o Google Authenticator).';
$hesklang['mfa_reset_warning']='Hai già abilitato l\'autenticazione multi-fattore. Completando nuovamente questa fase si ripristinerà il tuo dispositivo per l\'autenticazione multi-fattore (se attiva).';
$hesklang['mfa_select_method_colon']='Seleziona un metodo d\'autenticazione:';
$hesklang['mfa_verification_header']='Verifica - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Abbiamo inviato una mail a <strong>%s</strong> contenente un codice di verifica a 6 cifre. Inserisci di seguito il codice che hai ricevuto via mail per continuare.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Step 1: Scansiona l\'immagine sottostante con l\'app d\'autenticazione multi-fattore installata sul tuo dispositivo mobile.';
$hesklang['mfa_verification_auth_app_cant_scan']='Non riesci a scansionare l\'immagine? Inserisci manualmente questo codice sul tuo dispositivo: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Step 2: Inserisci il codice a 6 cifre mostrato sulla tua applicazione per completare la verifica del tuo dispositivo.';
$hesklang['mfa_verify']='Verifica';
$hesklang['mfa_invalid_method']='Abbiamo ricevuto un codice d\'autenticazione multi-fattore non valido.';
$hesklang['mfa_invalid_verification_code']='Il codice inserito non è corretto o è scaduto.';
$hesklang['mfa_configured']='L\'autenticazione multi-fattore è stata abilitata per il tuo account!';
$hesklang['mfa_removed']='L\'autenticazione multi-fattore è stata disattivata per il tuo account!';
$hesklang['mfa_verification_needed']='L\'autenticazione multi-fattore è attiva per il tuo account.';
$hesklang['mfa_verification_needed_email']='Inserisci il codice di verifica che hai ricevuto via mail.';
$hesklang['mfa_verification_needed_auth_app']='Inserisci il codice mostrato nella tua app d\'autenticazione.';
$hesklang['mfa_verification_code']='Codice di verifica';
$hesklang['mfa_server_time_issue']='L\'orario del tuo server sembra essere impreciso: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Resetta l\'autenticazione multi-fattore';
$hesklang['mfa_reset_confirm']='Sei sicuro di voler resettare l\'autenticazione multi-fattore per questo utente?';
$hesklang['mfa_reset_yes']='Reset';
$hesklang['mfa_reset']='L\'autenticazione multi-fattore è stata resettata per l\'utente';
$hesklang['desc_mfa_verification']='(Staff) Codice di Autenticazione Multi-Fattore';
$hesklang['mfa_code']='Code:';
$hesklang['mfa_backup_codes_header']='MEMORIZZA I TUOI CODICI DI BACKUP!';
$hesklang['mfa_backup_codes_description']='Conserva questi codici di backup in modo sicuro ma accessibile. Se perdi l\'accesso al dispositivo per l\'autenticazione multi-fattore o alla mail, puoi inserire uno dei seguenti codici di backup per accedere.<br><br><strong>Assicurati di trattare questi codici di backup come fossero password. Non ti sarà possibile visualizzare nuovamente questi codici!</strong>';
$hesklang['mfa_verify_another_way']='Verifica il tuo account in un altro modo'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Ottieni un codice di verifica su %s';
$hesklang['mfa_verify_another_way_code']='Inserisci uno dei tuoi codici di backup a 8 caratteri';
$hesklang['mfa_verify_another_way_admin']='Contatta l\'amministratore del tuo helpdesk per supporto';
$hesklang['mfa_verify_another_way_reset']='Resetta la tua autenticazione multi-fattore caricando un file sul server';
$hesklang['mfa_send_another_email']='Manda un\'altra email';
$hesklang['mfa_sent']='Un\'email con un codice di verifica è stata inviata al tuo indirizzo email';
$hesklang['mfa_backup_code']='Codice di backup';
$hesklang['mfa_backup_codes']='Codici di backup';
$hesklang['mfa_backup_codes_info']='Codici monouso per bypassare la verifica multi-fattore quando non hai accesso all\'app di autenticazione o non è possibile accedere alla posta elettronica.Una volta usato un codice di backup per accedere, quel codice diventa inattivo.';
$hesklang['mfa_backup_codes_num']='Puoi ottenere un nuovo set di 10 codici di backup in qualsiasi momento. Quando crei un nuovo set di codici, il vecchio set diventa automaticamente inattivo.';
$hesklang['mfa_backup_codes_num2']='Numero dei tuoi codici attivi: %s';
$hesklang['mfa_invalid_backup_code']='Il codice di backup inserito non è corretto o è già stato utilizzato.';
$hesklang['mfa_del_codes']='Cancella i miei codici di backup';
$hesklang['mfa_del_codes2']='Tutti i tuoi codici di backup sono stati eliminati.';
$hesklang['mfa_new_codes']='Genera nuovi codici di backup';
$hesklang['mfa_new_codes2']='Sono stati generati nuovi codici di backup';
$hesklang['old_php_version']='Errore: versione di PHP non supportata';
$hesklang['category_default_due_date']='Data di scadenza predefinita';
$hesklang['category_change_default_due_date']='Imposta una data di scadenza predefinita';
$hesklang['category_leave_blank_for_no_default_due_date']='(lascia vuoto se non vuoi impostare una data di scadenza predefinita)';
$hesklang['category_default_due_date_updated']='La data di scadenza preddefinita è stata aggiornata.';
$hesklang['email_formatting']='Formattazione della posta elettronica';
$hesklang['email_formatting_html_and_plaintext']='HTML con testo normale alternativo al modello di testo normale (predefinito)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML con testo semplice alternativo generato dal modello HTML';
$hesklang['email_formatting_html']='Solo HTML';
$hesklang['email_formatting_plaintext']='Solo testo normale';
$hesklang['email_formatting_note']='La tua selezione in %1$s &gt; %2$s &gt; %3$s è impostata a: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Questo significa che Hesk ignorerà modelli HTML qui.';
$hesklang['email_formatting_note1']='Questo significa che Hesk ignorerà i modelli di testo normale qui.';
$hesklang['email_formatting_note2']='Questo significa che Hesk genererà una versione in testo normale delle e-mail dai tuoi modelli HTML e ignorerà i modelli in testo normale qui.';
$hesklang['etnu']='Questo modello di email non è attualmente utilizzato da Hesk in base alla tua selezione in %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Modifica Categoria';
$hesklang['create_category']='Crea Categoria';
$hesklang['one_user_included']='1 utente incluso';
$hesklang['one_user_excluded']='1 utente escluso';
$hesklang['x_users_included']='%s utenti inclusi'; // %s = Number of users
$hesklang['x_users_excluded']='%s utenti esclusi'; // %s = Number of users
$hesklang['aa_cat']='Autoassegna ticket in questa categoria';
$hesklang['modify_autoassign_settings']='Modifica le impostazioni di autoassegnazione';
$hesklang['autoassign_on_all_users']='Sì, a qualsiasi utente con accesso a questa categoria';
$hesklang['autoassign_on_select_users']='Sì, a utenti specifici';
$hesklang['autoassign_off']='No, contrassegna i ticket come non assegnati';
$hesklang['autoassign_users']='Utenti da includere/escludere nelle autoassegnazioni';
$hesklang['autoassign_selected_include']='Gli utenti selezionati devono essere <strong>inclusi</strong> quando vengono autoassegnati i ticket in questa categoria';
$hesklang['autoassign_selected_exclude']='Gli utenti selezionati devono essere <strong>esclusi</strong> quando vengono autoassegnati i ticket in questa categoria';
$hesklang['cat_edited']='La categoria %s è stata modificata correttamente';
$hesklang['search_for_user']='Cerca utente';
$hesklang['email_sending']='Email in fase di invio';
$hesklang['email_to_ticket']='Conversione email in ticket';
$hesklang['email_to_ticket_info']='La conversione di email in ticket richiede una configurazione lato server. Per dettagli, guardare <a href="%s" target="_blank">questa guida sulle conoscenze di base</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk sta usando un server SMTP per mandare notifiche email. Il tuo <strong>%1$s</strong> dovrebbe essere impostato come <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Estensione del file mancante';
$hesklang['block_ignore']='Conversione email in ticket - Ignora le mail e previene i loop';
$hesklang['block_noreply']='Non rispondere';
$hesklang['block_noreply2']='Ignora le mail inviate da &quot;non rispondere&quot; indirizzi email';
$hesklang['block_returned']='Ritornata';
$hesklang['block_returned2']='Ignorare le mail di ritorno, come le notifiche sullo stato della consegna e le risposte automatiche';
$hesklang['block_duplicate']='Duplicate';
$hesklang['block_duplicate2']='Ignorare le mail inviate con lo stesso messaggio entro &quot;%s&quot; secondi'; // %s = "Timeframe"
$hesklang['loop_info']='email ricevute dallo stesso indirizzo di posta elettronica entro &quot;%s&quot; secondi';
$hesklang['thist21']='<li class="smaller">%s | notifica e-mail in ritardo inviata</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | email di follow-up inviata</li>'; // %s = date
$hesklang['elevator_header']='Entra in un\'area sicura';
$hesklang['elevator_intro']='Stai entrando in un\'area sicura.';
$hesklang['elevator_enter_password']='Per favore, inserisci la tua password per continuare.';
$hesklang['elevator_duration_setting_title']='Durata dell\'area protetta';
$hesklang['desc_survey']='(Cliente) Email di follow-up (sondaggio)'; // Email description
$hesklang['satisfaction']['tab']='Gradimento';
$hesklang['satisfaction']['title']='Sondaggio di gradimento del cliente';
$hesklang['satisfaction']['intro']='Invia ai tuoi clienti un sondaggio di follow-up sul gradimento per raccogliere feedback sulla loro esperienza con il tuo help desk.';
$hesklang['satisfaction']['tab1']='Impostazioni';
$hesklang['satisfaction']['tab2']='Decidere di uscire';
$hesklang['satisfaction']['enable']='Abilita email di follow-up:';
$hesklang['satisfaction']['enabled']='I sondaggi di gradimento dei clienti sono abilitati.';
$hesklang['satisfaction']['disabled']='I sondaggi sul gradimento dei clienti sono attualmente disattivati.';
$hesklang['satisfaction']['url']='Indirizzo URL per i sondaggi:';
$hesklang['satisfaction']['send']='Ritardo email di follow-up:';
$hesklang['satisfaction']['at_least']='Aspetta almeno';
$hesklang['satisfaction']['after']='che il ticket sia stato risolto prima di mandare la mail';
$hesklang['satisfaction']['h1']='Come si usa questo strumento?';
$hesklang['satisfaction']['h2']='Innanzitutto, crea un\'indagine sul gradimento del cliente nel tuo strumento di indagine preferito. Se non sei sicuro di quale strumento utilizzare o quali domande porre, abbiamo una <a href="%s" target="_blank">guida disponibile qui</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Quando il tuo sondaggio è pronto, abilita le mail di follow-up emails usando il form sottostande. Hesk elaborerà i ticket risolti con almeno una risposta del personale una volta all\'ora e invierà il link del sondaggio ai tuoi clienti.';
$hesklang['satisfaction']['e_url']='Inserisci un indirizzo URL valido per il sondaggio. Questo è l\'URL a cui verranno indirizzati i clienti.';
$hesklang['satisfaction']['as']='Inserisci un indirizzo URL valido per il sondaggio. Questo è l\'URL a cui verranno indirizzati i clienti.';
$hesklang['satisfaction']['oo1']='Questa pagina elenca gli indirizzi a cui <b>non</b> verranno inviate le mail di follow-up.';
$hesklang['satisfaction']['oo2']='I tuoi clienti possono scegliere di non ricevere e-mail di sondaggi facendo clic su un collegamento nell\'e-mail. In alternativa, puoi aggiungere manualmente gli indirizzi email in questa pagina.';
$hesklang['satisfaction']['ooe']='Indirizzo e-mail per l\'opt-out';
$hesklang['satisfaction']['ooe2']='Inserisci l\'indirizzo e-mail a cui desideri rinunciare a ricevere e-mail di sondaggi.';
$hesklang['satisfaction']['ooe3']='Questo indirizzo email <i>%s</i> è già disattivato dalla ricezione di e-mail di sondaggi.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Disattiva questa mail';
$hesklang['satisfaction']['oob']='Annullato da';
$hesklang['satisfaction']['no_oo']='Nessun cliente ha scelto di non ricevere e-mail di sondaggi.';
$hesklang['satisfaction']['oor']='Rimuovi';
$hesklang['satisfaction']['oor2']='Email rimossa dalle esculusioni';
$hesklang['satisfaction']['oor3']='Conferma rimozione';
$hesklang['satisfaction']['oor4']='Una volta rimosso dalle esclusioni, questo utente riceverà nuovamente email di follow-up.';
$hesklang['satisfaction']['optedout']='L\'indirizzo email <i>%s</i> è stato escluso dalla ricezione di email di sondaggi.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='ID sondaggio mancante o non valido';
$hesklang['satisfaction']['starting']='Avvio del processo di notifica del sondaggio sul gradimento del cliente';
$hesklang['satisfaction']['tc']='Trovati %s ticket chiusi a cui non è stato inviato il sondaggio sul gradimento.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Sondaggio sul gradimento del cliente terminato. Email inviate: %1$s. Email non inviate: %2$s. Ticket senza una mail: %3$s. Tickets con email di esclusione: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignorare, questo cliente non desidera ricevere e-mail di sondaggi.';
$hesklang['satisfaction']['ne']='Ignorare, questo biglietto è senza indirizzo email';
$hesklang['satisfaction']['feat1']='Crea il tuo sondaggio utilizzando qualsiasi strumento di terze parti, come Google Forms';
$hesklang['satisfaction']['feat2']='imposta l\'URL del sondaggio, le preferenze e le limitazioni all\'interno di questo modulo';
$hesklang['satisfaction']['feat3']='una volta risolto un ticket, Hesk invierà una mail al cliente con il link al sondaggio';
$hesklang['dfor']='Formato Data';
$hesklang['dtfor']='Data e Ora';
$hesklang['cdfor']='Formato selezione data';
$hesklang['custom']='Personalizza';
$hesklang['jsc_notice']='La selezione della data non supporta la formattazione della data in stile PHP. Seleziona una delle opzioni preconfigurate o clicca la sorrostante %s icona per vedere le opzioni di visualizzazione disponibili.'; // %s = replaced by icon
$hesklang['lcf3']='Solo Data'; // Display: "Date only"
$hesklang['epdd']='Errore durante l\'analisi del parametro due_date:';
$hesklang['edit_pass']='Modifica password';
$hesklang['save_pass']='Salva password';
$hesklang['cur_pass']='Password attuale';
$hesklang['cur_pass2']='Devi fornire la tua password attuale per poterla cambiare.';
$hesklang['cur_pass3']='Dopo un aggiornamento della password riuscito, verrai reindirizzato alla pagina di accesso, dove potrai accedere con la tua nuova password.';
$hesklang['e_new_pass']='Inserisci la tua nuova password';
$hesklang['pass_len']='La password non deve superare i 64 caratteri';
$hesklang['pass_login']='Per favore, accedi nuovamente dopo aver cambiato la tua password';
$hesklang['bf_int']='Sei stato disconnesso a causa di troppi tentativi di verifica non riusciti';
$hesklang['tst_cnt']='Numero di email che il tuo server di posta invierà a Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='Hai molte email non lette nella tua casella di posta (%1$s). Hesk convertirà tutte queste mail in ticket.<br><br>Potresti voler contrassegnare le e-mail esistenti come lette prima di abilitarle %2$s o usare un nuovo account email per Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Hai molte email non lette nella tua casella di posta (%1$s). Hesk convertirà tutte queste mail in ticket.<br><br>Potresti voler eliminare le email esistenti prima di abilitarle %2$s o usare un nuovo account email per Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='In scadenza il'; // Due on (date)
$hesklang['search_due_date_range']='Scaduto tra'; // Due in (X days)
$hesklang['attachment_add_files']='Aggiungi file';
$hesklang['attachment_max_exceeded']='Questo file non verrà caricato perché hai già caricato il numero massimo di file consentito.';
$hesklang['attachment_viewer_message']='Trascina qui i file o clicca il pulsante \'Aggiungi File\' sottostante per selezionare i file da caricare.';
$hesklang['attachment_invalid_type_message']='Spiacenti, ma il tipo di file che hai tentato di caricare non è consentito.';
$hesklang['attachment_upload_error']='Si è verificato un errore durante il tentativo di caricamento. Per favore riprova più tardi.';
$hesklang['attachment_too_large']='Questo allegato è più grande della dimensione massima del file consentita.';
$hesklang['attachment_cancel']='Cancella';
$hesklang['attachment_confirm_cancel']='Sei sicuro di voler annullare questo caricamento?';
$hesklang['attachment_remove']='Rimuovi allegato';
$hesklang['attachment_too_many_uploads']='Sono stati caricati troppi allegati dalla tua posizione in un breve periodo di tempo. Si prega di riprovare la richiesta più tardi.';
$hesklang['sub_note']='Invia nota';
$hesklang['can_view_users']='Visualizza tutti gli utenti (ma senza gestirli)';
$hesklang['welcome1']='Hei, sembra che tu sia nuovo qui. Benvenuto!';
$hesklang['welcome2']='Per aiutarti a iniziare, dai un\'occhiata alla %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Guida rapida online di Hesk';
$hesklang['tmce1']='Usa Ctrl+Click destro per accedere al correttore ortografico';
$hesklang['tmce2']='Tieni premuto il tasto Ctrl e fai clic con il pulsante destro del mouse sulla parola errata per accedere al correttore ortografico.';
$hesklang['desc_new_ticket_by_staff']='(Cliente) Nuovo ticket inviato dallo staff';
$hesklang['mod_et_h']='Puoi modificare i modelli di email in %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Imposta lingua su';
$hesklang['ouwa']='Nella lista sottostante sono inseriti solo gli utenti con accesso a questa categoria. Per aggiungere membri dello staff a questa categoria, modifica i loro permessi alla pagina %s'; // %s = Team
$hesklang['previous_tickets']='Ticket precedenti';
$hesklang['no_previous']='Nessun ticket precedente da %s'; // %s = email address
$hesklang['all_previous']='Elenca tutti i ticket precedenti';
$hesklang['confirm_delete_ticket']='Sei sicuro di voler eliminare in modo permanente questo ticket?';
$hesklang['confirm_delete_reply']='Sei sicuro di voler eliminare in modo permanente questa risposta?';
$hesklang['select_new_category']='Numero di ticket in questa categoria: %s<br><br>Seleziona una nuova categoria in cui trasferire questi biglietti:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Numero di ticket assegnati a questo utente: %1$s<br>Numero di ticket <b>aperti</b> assegnati a questo utente: %2$s<br><br> ticket <b>aperti</b> saranno <b>disassegnati</b> dopo aver rimosso questo utente.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Licenza HESK';
$hesklang['hlic_free']='GRATUITA';
$hesklang['hlic_buyl']='Compra una licenza';
$hesklang['hlic_paid']='Autorizzato';
$hesklang['antdemo']='L\'invio di ticket dal pannello di amministrazione è stato disabilitato in modalità demo.<br><br>Si prega di utilizzare un <a href="%s" target="_blank">utente pubblico</a> per inviare un ticket di prova.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Metodo d\'autenticazione';
$hesklang['email_authentication_method_username_password']='Basico (Username / Password)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Nessun fornitore OAuth verificato configurato.';
$hesklang['email_authentication_method_oauth_link']='Gestisci i fornitore di OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Autorizzazione dell\'indirizzo di rete server';
$hesklang['email_oauth_token_url']='Token Endpoint URL';
$hesklang['email_oauth_client_id']='ID Cliente';
$hesklang['email_oauth_client_secret']='Client Secret';
$hesklang['email_oauth_scope']='Scopo';
$hesklang['oauth_error_invalid_state']='Lo stato OAuth non corrisponde allo stato inviato al fornitore di OAuth.';
$hesklang['oauth_error_unknown']='Si è verificato un errore sconosciuto durante il tentativo di salvare i token OAuth.';
$hesklang['oauth_error_no_token']='Token di accesso mancante nella risposta JSON.';
$hesklang['oauth_error_retrieve']='Impossibile recuperare un token di accesso. Conferma le impostazioni del tuo fornitore di OAuth e salvale nuovamente per acquisire un nuovo token.';
$hesklang['email_oauth_provider']='Fornitore di OAuth';
$hesklang['email_oauth_providers']='Fornitori di OAuth';
$hesklang['email_oauth_provider_guide']='Prima di utilizzare OAuth, è necessario registrare un fornitore di OAuth. Per dettagli, consultare <a href="%s" target="_blank">questa guida rapida sulle conoscenze di base</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Il tuo URL di reindirizzamento OAuth per Hesk è:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Utilizza questo strumento per aggiungere fornitore di OAuth al tuo help desk';
$hesklang['email_oauth_provider_name']='Nome'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Nuovo fornitore';
$hesklang['email_oauth_edit_provider']='Modifica fornitore';
$hesklang['email_oauth_provider_being_used_for']='Utilizzato per';
$hesklang['email_oauth_providers_none']='Nessun fornitore di OAuth salvato. Puoi aggiungerli facendo clic su "Nuovo fornitore" in alto.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Questo fornitore non può essere rimosso perché usato dall\help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Sei sicuro di voler rimuovere questo fornitore di OAuth?';
$hesklang['oauth_provider_saved']='Fornitore di OAuth salvato';
$hesklang['oauth_provider_use']='Ora puoi selezionare questo fornitore in %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Inserisci il nome del fornitore';
$hesklang['oauth_provider_err_auth_url']='Inserisci un URL di autorizzazione valido';
$hesklang['oauth_provider_err_token_url']='Inserisci un token URL valido';
$hesklang['oauth_provider_err_client_id']='Inserisci l\'ID cliente';
$hesklang['oauth_provider_err_client_secret']='Inserisci il segreto del cliente';
$hesklang['oauth_provider_err_scope']='Inserisci lo scopo';
$hesklang['oauth_provider_deleted']='Fornitore di OAuth rimosso';
$hesklang['oauth_provider_not_found']='Questo fornitore di OAuth non esiste';
$hesklang['oauth_provider_verified']='Verificato';
$hesklang['oauth_provider_click_to_verify']='Clicca per verificare';
$hesklang['can_due_date']='Puoi impostare la data di scadenza'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Non sei autorizzato a impostare le date di scadenza';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verifica la tua registrazione';
$hesklang['customer_verify_new_email']='Verifica il tuo nuovo indirizzo email';
$hesklang['customer_reset_password']='Reimposta la password del tuo help desk';
$hesklang['customer_approved']='Account approvato';
$hesklang['customer_rejected']='Account rifiutato';
$hesklang['email_rejected']='Account richiesto per inviare ticket di supporto';
$hesklang['require_curl']='Questa funzionalità richiede il supporto <strong>cURL</strong> per PHP abilitato sul tuo server. Chiedi al tuo provider di abilitare cURL per PHP.';
$hesklang['customer_accounts_heading']='Account clienti';
$hesklang['customer_accounts']='Account clienti';
$hesklang['customer_accounts_off']='<strong>Disabilitati</strong>';
$hesklang['customer_accounts_allowed']='<strong>Abilitati - Opzionali</strong> (i clienti possono inviare ticket di supporto senza registrarsi o accedere)';
$hesklang['customer_accounts_required_to_submit']='<strong>Abilitati - Richiesti per i ticket</strong> (solo i clienti registrati possono inviare ticket di supporto)';
$hesklang['customer_accounts_required']='<strong>Abilitati - Richiesti per accedere</strong> (solo i clienti registrati possono accedere all’help desk e alla knowledgebase)';
$hesklang['customer_accounts_reg']='Registrazione account';
$hesklang['customer_accounts_reg_customer']='I clienti possono registrare account';
$hesklang['customer_accounts_reg_approve']='I clienti possono registrare account, lo staff deve approvare le nuove registrazioni';
$hesklang['customer_accounts_reg_staff']='Solo lo staff può registrare account clienti';
$hesklang['customer_accounts_allow_email_changes']='Permetti ai clienti di cambiare il loro indirizzo email';
$hesklang['customer_accounts_allow_email_resends']='Tempo prima che i clienti possano richiedere una nuova email di verifica';
$hesklang['customer_login']='Accedi';
$hesklang['customer_logout']='Esci';
$hesklang['customer_register']='Registrati';
$hesklang['customer_accounts_disabled']='Accessi e registrazioni clienti disabilitati.';
$hesklang['customer_accounts_registration_disabled']='Registrazioni clienti disabilitate.';
$hesklang['customer_forgot_password']='Password dimenticata?';
$hesklang['customer_email']='Indirizzo email';
$hesklang['customer_accounts_email_banned']='Sei stato bannato dall’utilizzo di questo help desk.';
$hesklang['customer_registration_successful']='Registrazione completata con successo!';
$hesklang['customer_registration_email_exists_no_reset_link']='Esiste già un account con l’email %s.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Esiste già un account con l’email %s. <a href="login.php">Vuoi accedere invece</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Esiste già un account con l’email %s in attesa di verifica email.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Esiste già un account con l’email %s in attesa di approvazione da parte dello staff.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Controlla la tua email!';
$hesklang['customer_registration_check_your_email_content']='Devi verificare il tuo indirizzo email prima di poter accedere.<br><br>Se non ricevi l’email entro pochi minuti, controlla le cartelle Junk, Bulk o Spam. Contrassegna il messaggio come <b>Non SPAM</b> per evitare problemi nel ricevere la nostra corrispondenza in futuro.';
$hesklang['customer_login_not_verified']='Devi verificare il tuo indirizzo email prima di poter accedere.';
$hesklang['customer_login_not_verified2']='Se non hai ricevuto l’email di verifica da parte nostra, controlla le cartelle Junk, Bulk o Spam. Contrassegna il messaggio come <b>Non SPAM</b> per evitare problemi nel ricevere la nostra corrispondenza in futuro.';
$hesklang['customer_login_resend_verification_email']='Reinvia email di verifica';
$hesklang['customer_login_resend_verification_email_none']='Non ci sono verifiche email in sospeso da inviare.';
$hesklang['customer_login_resend_verification_email_too_early']='Non puoi richiedere una nuova email di verifica in questo momento, riprova più tardi.';
$hesklang['customer_login_not_approved']='Un membro dello staff deve approvare il tuo account prima di poter accedere. Una volta approvato, sarai notificato via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verifica registrazione';
$hesklang['customer_registration_verify_success']='La tua email è stata verificata e ora puoi accedere utilizzando il modulo sottostante.';
$hesklang['customer_registration_verify_approval_needed']='La tua email è stata verificata. Tuttavia, un membro dello staff deve approvare il tuo account prima di poter accedere. Una volta approvato, sarai notificato via email.';
$hesklang['customer_registration_verify_failure']='La tua email non può essere verificata. Il link è già stato utilizzato o è scaduto.';
$hesklang['emails_to_customers']='&raquo; Email inviate ai clienti';
$hesklang['emails_to_staff']='&raquo; Email inviate allo staff';
$hesklang['emails_to_everyone']='&raquo; Email inviate allo staff o ai clienti';
$hesklang['new_customer_approval']='Hai account clienti in attesa di approvazione'; // Email subject
$hesklang['desc_new_customer_approval']='(Staff) Account clienti in attesa di approvazione';
$hesklang['n_cust_app']='Ci sono approvazioni clienti in sospeso'; // Notify me when...
$hesklang['et_num_customers']='Numero di approvazioni in sospeso';
$hesklang['et_link_customers']='Link alla pagina Gestisci clienti';
$hesklang['et_link_verify']='Link di verifica';
$hesklang['et_cust_login']='URL di accesso cliente';
$hesklang['submit_ticket_customer_email_exists']='Esiste già un cliente con questa email. Per favore <a href="login.php?email=%s">accedi</a> per inviare un ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Per favore inserisci un indirizzo email valido.';
$hesklang['customer_login_password_required']='Per favore inserisci la tua password.';
$hesklang['customer_login_remember_just_email']='Ricorda solo la mia email';
$hesklang['customer_login_remember_email']='Ricorda la mia email';
$hesklang['customer_wrong_user']='Il tuo indirizzo email %s non è registrato presso di noi.<br><br>Vuoi <a href="register.php">creare un account</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Il tuo indirizzo email e la password non corrispondono ai nostri record.<br><br>Vuoi <a href="login.php?submittedForgot=1">reimpostare la tua password</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Per favore accedi per continuare.';
$hesklang['customer_register_here']='Se non hai un account con noi, puoi <a href="register.php">registrarti qui</a>.';
$hesklang['create_account']='Crea un account';
$hesklang['customer_my_tickets_heading']='I miei ticket';
$hesklang['customer_my_tickets_description']='Visualizza tutti i tuoi ticket precedenti';
$hesklang['customer_my_tickets_search_for_tickets']='Cerca ticket';
$hesklang['customer_password_reset_successful']='La tua nuova password è stata salvata. Ora puoi accedere.';
$hesklang['customer_profile']='Profilo';
$hesklang['customer_edit_profile']='Modifica profilo';
$hesklang['customer_edit_pass']='Modifica password';
$hesklang['customer_edit_pass_same']='La tua nuova password non deve essere uguale a quella attuale.';
$hesklang['customer_change_email']='Cambia email';
$hesklang['customer_change_email_banned']='L’email inserita è bannata.';
$hesklang['customer_change_email_pending']='C’è una richiesta in corso per cambiare il tuo indirizzo email in: <b>%s</b><br><br>Abbiamo inviato un’email a questo indirizzo. Per favore clicca sul link all’interno dell’email per confermare il cambiamento.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Reinvia email di conferma</a>';
$hesklang['customer_change_email_submitted']='Per favore clicca sul link di verifica che è stato inviato a <b>%s</b> per verificare la tua nuova email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Il tuo nuovo indirizzo email è stato verificato e il tuo profilo aggiornato.';
$hesklang['customer_change_email_disabled']='La possibilità di aggiornare la tua email è disabilitata. Contattaci se desideri cambiare il tuo indirizzo email.';
$hesklang['customer_profile_saved']='Il tuo profilo è stato salvato.';
$hesklang['customers']='Clienti';
$hesklang['customers_intro']='Gli account clienti permettono ai clienti di visualizzare tutti i loro ticket in un’unica posizione centrale.';
$hesklang['sure_remove_customer']='Sei sicuro di voler rimuovere questo cliente?';
$hesklang['sure_remove_customer_additional_note']='Eliminare un cliente è definitivo. Una volta eliminato, non può essere recuperato!';
$hesklang['new_customer']='Nuovo cliente';
$hesklang['new_follower']='Nuovo follower';
$hesklang['add_customer']='+ Aggiungi cliente'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Aggiungi follower'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='Il cliente fornito non esiste ancora. Clicca su "Salva" se desideri creare questo cliente.';
$hesklang['followers']='Follower';
$hesklang['no_customers']='Attualmente non ci sono clienti nel database.';
$hesklang['no_customers_disabled']='Inizierai a vedere i clienti qui quando invieranno ticket di supporto.';
$hesklang['no_customers_enabled']='Inizierai a vedere i clienti qui quando si registreranno o invieranno ticket di supporto.';
$hesklang['no_customers_enabled2']='In alternativa, i pulsanti sopra questo messaggio ti permettono di creare manualmente account clienti o importare clienti esistenti nell’help desk.';
$hesklang['import_customers']='Importa clienti';
$hesklang['import_customers_tip']='Usa un file CSV per importare più clienti contemporaneamente.';
$hesklang['customer_not_found']='Cliente non trovato per il ticket!';
$hesklang['search_by_name_or_email']='Cerca per nome o email...';
$hesklang['search_by_pattern']='Cerca per modello...';
$hesklang['is_searchable']='Ricercabile';
$hesklang['custom_is_searchable']='Ricercabile';
$hesklang['yes_via_autocomplete']='SÌ (cerca tramite autocompletamento)';
$hesklang['customer_required']='Devi selezionare un cliente';
$hesklang['customer_email_exists']='Esiste già un cliente con questa email.';
$hesklang['customer_name_with_no_email_exists']='Esiste già un cliente con questo nome e senza email.';
$hesklang['an_error_occurred_validating_email']='Si è verificato un errore durante il tentativo di verificare l’indirizzo email inserito.';
$hesklang['customer_count_x_more']='+%s in più'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registrato';
$hesklang['customer_account_verified']='Verificato';
$hesklang['customer_account_verified_help']='I clienti devono verificare il loro account tramite un link di attivazione inviato al loro indirizzo email prima di poter accedere al loro account.';
$hesklang['customer_account_setting_password_will_verify_user']='Impostare una password per questo cliente verificherà automaticamente il loro account.';
$hesklang['deleting_customer_with_tickets']='Questo cliente ha %1$s ticket <b>(%2$s aperti)</b> che hanno anche altri clienti associati a loro.<br>Cosa dovrebbe essere fatto con questi ticket?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='È necessario un indirizzo email valido per reinviare un’email di verifica.';
$hesklang['customer_resend_verification_email_not_found']='Non esiste alcun account con questo indirizzo email, o l’account è già stato verificato.';
$hesklang['customer_resend_verification_email_sent']='Un’email di verifica è stata inviata al tuo indirizzo email.<br><br>Se non la ricevi entro pochi minuti, controlla le cartelle Junk, Bulk o Spam. Contrassegna il messaggio come <b>Non SPAM</b> per evitare problemi nel ricevere la nostra corrispondenza in futuro.';
$hesklang['customer_permission_denied']='Non hai il permesso di modificare i clienti.';
$hesklang['customer_manage_approvals']='Account clienti in attesa di approvazione: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approva cliente';
$hesklang['customer_manage_bulk_approve']='Approva clienti selezionati';
$hesklang['customer_manage_bulk_approve_complete']='Clienti approvati: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Rifiuta cliente';
$hesklang['customer_manage_bulk_reject']='Rifiuta clienti selezionati';
$hesklang['customer_manage_bulk_reject_complete']='Clienti rifiutati: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Elimina cliente';
$hesklang['customer_manage_bulk_delete']='Elimina clienti selezionati';
$hesklang['customer_manage_bulk_delete_complete']='Clienti eliminati: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Modifica cliente';
$hesklang['customer_manage_verification_email_sent']='Email di verifica inviata a %s'; // %s = customer's email
$hesklang['can_man_customers']='Gestisci clienti';
$hesklang['can_view_customers']='Visualizza tutti i clienti (ma non gestirli)';
$hesklang['import_customer_select_file']='Seleziona file';
$hesklang['import_customer_step1_instructions']='Per importare i clienti, prepara un file CSV (Comma-Separated Values).';
$hesklang['import_customer_step1_note']='Seleziona il tuo file CSV';
$hesklang['import_customer_step1_separator']='Le colonne nel mio file CSV sono separate da';
$hesklang['import_customer_sample']='&raquo; File CSV di esempio';
$hesklang['import_customer_sample_1']='File CSV in stile USA con colonne separate da ,';
$hesklang['import_customer_sample_2']='File CSV in stile UE con colonne separate da ;';
$hesklang['import_customer_upload_requirements_1']='Il tuo file CSV deve includere almeno una colonna nome o una colonna indirizzo email. La colonna password è opzionale.';
$hesklang['import_customer_upload_requirements_2']='La prima riga del tuo file deve contenere le intestazioni delle colonne.';
$hesklang['import_customer_upload_requirements_3']='Il tuo file deve essere codificato in UTF-8.';
$hesklang['import_customer_select_columns']='Seleziona colonne';
$hesklang['import_customer_upload_customers']='Carica clienti';
$hesklang['import_customer_column_name']='Colonna nome';
$hesklang['import_customer_column_email']='Colonna email';
$hesklang['import_customer_column_pass']='Colonna password';
$hesklang['import_customer_step2_note']='Seleziona il nome della colonna corretto dal tuo file CSV nei menu a tendina, quindi clicca su "Avanti".';
$hesklang['import_customer_name_or_email_required']='Nome o email è richiesto';
$hesklang['import_customer_step3_note']='I tuoi clienti stanno venendo importati. Non lasciare questa pagina!';
$hesklang['import_customer_step3_pending']='In sospeso';
$hesklang['import_customer_step3_successful_imports']='Importazioni riuscite';
$hesklang['import_customer_step3_failed_imports']='Importazioni fallite';
$hesklang['import_customer_step3_progress']='Progresso';
$hesklang['import_customer_step3_complete_some_failed']='Il processo di importazione è completo, tuttavia <b>%s</b> clienti non sono riusciti a essere importati. Controlla la tabella sottostante per maggiori informazioni.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='Il processo di importazione è completo!';
$hesklang['import_customer_step3_importing']='Importazione in corso';
$hesklang['staff_deleted']='[Staff eliminato]';
$hesklang['customer_account_approved']='Registrazione cliente approvata';
$hesklang['customer_account_rejected']='Registrazione cliente rifiutata';
$hesklang['customer_account_deleted']='Registrazione cliente eliminata';
$hesklang['ticket_followers']='Follower del ticket';
$hesklang['ticket_followers2']='Permetti ai ticket di avere più clienti';
$hesklang['add_cc']='Aggiungi Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separa ogni email con una virgola.';
$hesklang['search_customers']='Cerca clienti';
$hesklang['page_size']='Dimensione pagina';
$hesklang['customers_on_pages']='Numero di clienti: %d | Numero di pagine: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Cliente) Reimposta la tua password';
$hesklang['desc_customer_verify_registration']='(Cliente) Verifica la tua registrazione';
$hesklang['desc_customer_verify_new_email']='(Cliente) Verifica la tua nuova email';
$hesklang['desc_customer_approved']='(Cliente) Account approvato';
$hesklang['desc_customer_rejected']='(Cliente) Account rifiutato';
$hesklang['desc_email_rejected_can_self_register']='(Cliente) Ticket via email rifiutato; il cliente può registrarsi autonomamente';
$hesklang['desc_email_rejected_cannot_self_register']='(Cliente) Ticket via email rifiutato; il cliente non può registrarsi autonomamente';
$hesklang['user_added_success_no_pass']='Il nuovo utente %s è stato aggiunto con successo';
$hesklang['email_tag_requester']='Richiedente (Da)';
$hesklang['email_tag_requester_name']='Nome del richiedente (Da)';
$hesklang['email_tag_requester_first_name']='Nome del richiedente (Da)';
$hesklang['email_tag_requester_email']='Email del richiedente (Da)';
$hesklang['email_tag_followers']='Follower (Cc)';
$hesklang['email_tag_follower_names']='Nomi dei follower (Cc)';
$hesklang['email_tag_follower_emails']='Email dei follower (Cc)';
$hesklang['barcode']='Codice a barre';
$hesklang['barcode_use']='Mostra un codice a barre sui ticket stampati';
$hesklang['barcode_staff_only']='Nascondi il codice a barre ai clienti';
$hesklang['barcode_type']='Tipo di codice a barre';
$hesklang['barcode_format']='Formato';
$hesklang['barcode_width']='Larghezza';
$hesklang['barcode_height']='Altezza';
$hesklang['barcode_color']='Colore';
$hesklang['barcode_bg']='Sfondo';
$hesklang['copy_link']='Copia link del ticket';
$hesklang['copy_link_title']='Copia il link pubblico a questo ticket';
$hesklang['copy_link_exp']='Il link copiato è il link diretto per il cliente per visualizzare questo ticket';
$hesklang['copy_value']='Copia questo valore';
$hesklang['download_class']='Questa funzione richiede la classe ZipArchive. Chiedi al tuo provider di compilare PHP con il supporto zip.';
$hesklang['download_all']='Scarica tutto';
$hesklang['download_prep']='Preparazione del download...';
$hesklang['download_tma']='Troppi allegati';
$hesklang['download_nva']='Nessun allegato valido';
$hesklang['download_ntd']='Niente da scaricare';
$hesklang['resolved_at']='Risolto il';
$hesklang['disable_GSSAPI']='Disabilita l’autenticatore GSSAPI (soluzione per errore Kerberos)';
$hesklang['ex_history']='Includi il registro della cronologia del ticket nell’esportazione';
$hesklang['sm_location']='Posizione'; // Location (page) of a service message
$hesklang['loc_sm']='Mostra questo messaggio di servizio su:';
$hesklang['loc_all']='Ogni pagina cliente';
$hesklang['loc_norec']='(non raccomandato)';
$hesklang['loc_home']='Homepage dell’help desk';
$hesklang['loc_selected']='Su pagine selezionate';
$hesklang['loc_selerr']='Seleziona almeno una pagina su cui mostrare il messaggio';
$hesklang['loc_t_cat']='Invia un ticket - seleziona una categoria';
$hesklang['loc_t_add']='Invia un ticket - invia un modulo di ticket';
$hesklang['loc_t_ok']='Invia un ticket - conferma del ticket';
$hesklang['loc_t_view']='Visualizza un ticket';
$hesklang['loc_t_form']='Visualizza un modulo di ticket';
$hesklang['loc_kb_main']='Homepage della knowledgebase';
$hesklang['loc_kb_sub']='Pagine delle sottocategorie della knowledgebase';
$hesklang['loc_kb_art']='Articoli della knowledgebase';
$hesklang['loc_login']='Pagina di accesso cliente';
$hesklang['loc_register']='Pagina di registrazione cliente';
$hesklang['loc_register_ok']='Registrazione cliente avvenuta con successo';
$hesklang['loc_acc']='Pagina "I miei ticket" del cliente';
$hesklang['loc_profile']='Pagina "Profilo" del cliente';
$hesklang['sending_show']='Mostra notifica "Invio in corso"';
$hesklang['sending_wait']='Invio in corso, per favore attendi...';
$hesklang['e_c_email']='Inserisci l’indirizzo email corretto per visualizzare questo ticket';
$hesklang['only_verified_cc']='I follower senza un account verificato saranno ignorati.';
$hesklang['followers_removed']='Questi indirizzi email sono stati rimossi dal ticket perché non hanno un account verificato:';
$hesklang['novace']='Non abbiamo trovato alcun account registrato e verificato con questo indirizzo email.';
$hesklang['max_recipients']='Massimo destinatari';
$hesklang['max_recipients2']='in una singola email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Carica un file Javascript personalizzato extra per il pannello di amministrazione';
$hesklang['cf_limit_all']='Hai raggiunto il limite dei campi personalizzati e non puoi creare nuovi campi personalizzati.';
$hesklang['remind_assigned']='Ricorda allo staff assegnato';
$hesklang['remind_sent']='Promemoria email inviato al membro dello staff assegnato';
$hesklang['thist23']='<li class="smaller">%s | promemoria inviato a %s da %s</li>';
$hesklang['ql_bookmarks']='Segnalibri';
$hesklang['bookmark']='Il mio segnalibro';
$hesklang['bookmarks_add']='Aggiungi ai segnalibri';
$hesklang['bookmarks_added']='Questo ticket è stato aggiunto ai tuoi segnalibri';
$hesklang['bookmarks_remove']='Rimuovi dai segnalibri';
$hesklang['bookmarks_removed']='Questo ticket è stato rimosso dai tuoi segnalibri';
$hesklang['genl_not_copied']='Errore: Copia negli appunti non supportata su questo dispositivo/browser.';
$hesklang['profile_duplicate_email']='Esiste già un utente con l’email <b>%s</b>.'; // %s: new email
$hesklang['seq_id_numeric']='La ricerca del numero del ticket deve contenere solo numeri';
$hesklang['confirm_new_pass']='Conferma nuova password';
$hesklang['piping_notify_rejected_customers1']='Email di rifiuto cliente';
$hesklang['piping_notify_rejected_customers2']='Invia un’email di rifiuto ai clienti quando il loro ticket viene rifiutato';
$hesklang['piping_notify_rejected_customers3']='Tempo tra le email di rifiuto';
$hesklang['register_url']='URL di registrazione';
$hesklang['email_subject']='Oggetto dell’email';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborazione sul ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Il personale ha risposto a: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Nota aggiunta a: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket in ritardo: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket risolto: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Scadenza per l’invio dell’email di follow-up:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Non inviare email ai ticket risolti da più di'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='fa (deve essere un periodo più lungo di "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='Il periodo della scadenza per l’email deve essere più lungo del ritardo dell’email di follow-up';
$hesklang['available_language']='Lingue disponibili';
$hesklang['click_to_show_available_language']='Clicca per mostrare le lingue disponibili';
$hesklang['install_lan']='Installa';
$hesklang['remove_lan']='Rimuovi';
$hesklang['title_lan']='Titolo';
$hesklang['description_lan']='Descrizione';
$hesklang['completed_lan']='Completato';
$hesklang['no_language_availble']='Nessuna lingua disponibile';
$hesklang['success_install_lan_txt']='la lingua è stata aggiunta con successo';
$hesklang['error_install_lan_txt']='la lingua non è stata aggiunta';
$hesklang['success_remove_lan_txt']='la lingua è stata rimossa con successo';
$hesklang['error_remove_lan_txt']='la lingua non è stata rimossa';
$hesklang['remove_default_language_error']='La lingua predefinita deve rimanere attiva e non può essere rimossa';
$hesklang['click_for_manual_step']='Clicca per l’installazione manuale';
$hesklang['upgrade_lan']='Aggiorna';
$hesklang['success_upgrade_lan_txt']='la lingua è stata aggiornata con successo';
$hesklang['error_upgrade_lan_txt']='la lingua non è stata aggiornata';
$hesklang['please_wait']='Attendere prego...';
$hesklang['add_a_note']='Aggiungi una nota';
$hesklang['add_a_reply']='Aggiungi una risposta';
$hesklang['customer_id']='ID cliente';
$hesklang['deleting_customer_tickets']='Ticket aperti dal cliente: <b>%1$s</b><br>Come vogliamo gestire questi ticket?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Ticket con il cliente in copia: <b>%1$s</b><br>Il cliente non seguirà più questi ticket, ma i ticket resteranno invariati'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Elimina definitivamente i ticket';
$hesklang['deleting_customer_anonymize_tickets2']='Anonimizza i ticket (rimuovi messaggi e dati personali)';
$hesklang['deleting_customer_retain_tickets2']='Mantieni i ticket (lascia intatti tutti i dati)';
$hesklang['for_staff']='per il personale del help desk'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='per i clienti'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='Casella di posta IMAP';
$hesklang['file_attachment_options']='Opzioni per gli allegati email';
$hesklang['link_to_attachments_in_emails']='Collegamento agli allegati nelle email';
$hesklang['add_attachments_directly_to_emails']='Aggiungi allegati direttamente alle email';
$hesklang['directly_attach_file_smaller_than']='Allega direttamente solo file più piccoli di';
$hesklang['directly_attach_file_of_any_size']='Allega direttamente file di qualsiasi dimensione';
$hesklang['directly_attach_only_first_x_attachments']='Allega direttamente solo i primi';
$hesklang['directly_attach_all_attachments']='Allega direttamente tutti gli allegati';
$hesklang['directly_attach_size']='Dimensione allegato';
$hesklang['directly_attach_no_of_files']='Numero di file';
$hesklang['notice_about_directly_attach_files']='Allegare molti file o file pesanti alle email potrebbe causare ritardi nella comunicazione con il server SMTP';
$hesklang['fatt_2']='File aggiuntivi allegati a questo messaggio:';
$hesklang['no_collaborators']='Nessuno';
$hesklang['collaborate']='Collabora a questo ticket';
$hesklang['collaborators']='Collaboratori';
$hesklang['ql_cbm']='Collaborazioni';
$hesklang['collaborating']='Stai ora collaborando a questo ticket';
$hesklang['not_collaborating']='Non stai più collaborando a questo ticket';
$hesklang['add_collaborator']='Aggiungi un collaboratore';
$hesklang['user_collaborator_added']='Utente aggiunto come collaboratore per questo ticket';
$hesklang['remove_collaborator']='Rimuovi collaboratore';
$hesklang['staff_name']='Nome del personale';
$hesklang['user_collaborator_removed']='Utente rimosso come collaboratore da questo ticket';
$hesklang['desc_collaborator_added']='(Personale) Stai collaborando a un nuovo ticket';
$hesklang['desc_collaborator_staff_reply']='(Personale) Un membro del personale ha risposto a un ticket collaborato';
$hesklang['desc_collaborator_note']='(Personale) Nuova nota aggiunta a un ticket collaborato';
$hesklang['desc_collaborator_resolved']='(Personale) Un ticket collaborato è stato risolto';
$hesklang['desc_collaborator_overdue']='(Personale) Un ticket collaborato è scaduto';
$hesklang['notify_collaborator_added']='Sono stato aggiunto come collaboratore al ticket';
$hesklang['notify_collaborator_customer_reply']='Il cliente risponde a un ticket in collaborazione';
$hesklang['notify_collaborator_staff_reply']='Il personale risponde a un ticket in collaborazione';
$hesklang['notify_collaborator_note']='Il personale aggiunge una nota a un ticket in collaborazione';
$hesklang['notify_collaborator_resolved']='Il personale risolve un ticket in collaborazione';
$hesklang['notify_collaborator_overdue']='Il ticket in collaborazione è scaduto';
$hesklang['recurring_tickets']['tab']='Ticket ricorrenti'; // Menu link
$hesklang['recurring_tickets']['page_title']='Ticket ricorrenti'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatizza il lavoro noioso; lascia che Hesk apra ticket di routine per te, esattamente quando ne hai bisogno.';
$hesklang['recurring_tickets']['active_rules']='Regole attive';
$hesklang['recurring_tickets']['new']='Nuova regola per ticket ricorrenti';
$hesklang['recurring_tickets']['no_rules']='Non hai regole per ticket ricorrenti. Creane una facendo clic sul pulsante &quot;Nuova regola per ticket ricorrenti&quot; qui sopra.';
$hesklang['recurring_tickets']['title']='Titolo della regola';
$hesklang['recurring_tickets']['titlet']='Un titolo descrittivo, ad esempio: Riassegna ticket non risposti entro un giorno';
$hesklang['recurring_tickets']['default_title']='Regola di %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Attivatore della regola';
$hesklang['recurring_tickets']['trigt']='Imposta la condizione che attiverà (eseguirà) questa regola.';
$hesklang['recurring_tickets']['hits']='Occorrenze'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Tempo di creazione'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Impostazioni generali'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Campi personalizzati'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Contenuto'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Eliminare questa regola?';
$hesklang['recurring_tickets']['edit']='Modifica regola per ticket ricorrenti con ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Entro:';
$hesklang['recurring_tickets']['minutes']='minuti';
$hesklang['recurring_tickets']['hours']='ore';
$hesklang['recurring_tickets']['days']='giorni';
$hesklang['recurring_tickets']['weeks']='settimane';
$hesklang['recurring_tickets']['months']='mesi';
$hesklang['recurring_tickets']['years']='anni';
$hesklang['recurring_tickets']['setpri']='Imposta priorità su:';
$hesklang['recurring_tickets']['setsta']='Imposta stato su:';
$hesklang['recurring_tickets']['assto']='Assegna ticket a:';
$hesklang['recurring_tickets']['asm']='Un altro membro del personale';
$hesklang['recurring_tickets']['notify']='Notifica ai membri del personale...';
$hesklang['recurring_tickets']['ato']='Applica a:';
$hesklang['recurring_tickets']['save']='Salva regola';
$hesklang['recurring_tickets']['e_tt']='Il tempo deve essere compreso tra 1 e 10000';
$hesklang['recurring_tickets']['nocat']='Seleziona almeno una categoria';
$hesklang['recurring_tickets']['nouser']='Seleziona almeno un utente';
$hesklang['recurring_tickets']['nostatus']='Seleziona almeno uno stato';
$hesklang['recurring_tickets']['nocata']='%1$s non ha accesso a queste categorie:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='È stata creata una nuova regola';
$hesklang['recurring_tickets']['mdf']='Le impostazioni della regola sono state salvate';
$hesklang['recurring_tickets']['e_id']='Nessuna regola con questo ID trovata';
$hesklang['recurring_tickets']['deleted']='La regola selezionata è stata eliminata';
$hesklang['recurring_tickets']['log_title']='Regola #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Attivazione'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Attiva questa regola (inizia a usarla)';
$hesklang['recurring_tickets']['activated']='La regola selezionata è stata attivata'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Disattiva questa regola (smetti di usarla)';
$hesklang['recurring_tickets']['deactivated']='La regola selezionata è stata disattivata'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Nessuna regola per ticket ricorrenti attiva';
$hesklang['recurring_tickets']['tools']='Strumenti';
$hesklang['recurring_tickets']['tbef']='Prima che una regola possa essere utilizzata, devi attivarla facendo clic sulla casella di controllo nella colonna &quot;ATTIVA&quot;.<br><br>
                               <strong>Le regole attive vengono elaborate ogni %2$s minuti.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[REGOLA]';
$hesklang['recurring_tickets']['r2']='[REGOLA] Regola #%s';
$hesklang['recurring_tickets']['r3']='Regola #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Numero di ticket già creati oggi: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Ripristina questa regola';
$hesklang['recurring_tickets']['reset2']='Sei sicuro di voler ripristinare questa regola?<br><br>Il contatore verrà azzerato e i ticket già generati per essa oggi potrebbero essere rigenerati al prossimo avvio di cron.';
$hesklang['recurring_tickets']['reset3']='La regola selezionata è stata ripristinata';
$hesklang['recurring_tickets']['test']='Simula questa regola';
$hesklang['recurring_tickets']['testa']='Simula tutte le regole';
$hesklang['recurring_tickets']['testaa']='Simula tutte le regole attive';
$hesklang['recurring_tickets']['testr']='Risultati della simulazione';
$hesklang['recurring_tickets']['rsim']='Ripeti simulazione';
$hesklang['recurring_tickets']['sim']='MODALITÀ SIMULAZIONE, nessuna modifica al database';
$hesklang['recurring_tickets']['sic']='SIMULAZIONE COMPLETATA';
$hesklang['recurring_tickets']['rrule_type_required']='Seleziona un trigger valido per la regola ricorrente.';
$hesklang['recurring_tickets']['rrule_string_required']='Seleziona tutte le opzioni richieste per il trigger della regola ricorrente.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Inserisci un valore di intervallo di 1 o superiore per la voce "Ogni".';
$hesklang['recurring_tickets']['disable_note']='*Se vengono modificate impostazioni critiche di hesk dopo la creazione di una regola, questa verrà disabilitata al prossimo tentativo di esecuzione e dovrà essere modificata per superare i nuovi requisiti di validazione.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | inviato dalla regola "Ticket Ricorrenti" "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assegnato a %2$s dalla regola "Ticket Ricorrenti" "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | chiuso automaticamente dalla regola "Ticket Ricorrenti" "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | stato cambiato in %2$s dalla regola "Ticket Ricorrenti" "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | assegnato automaticamente a %2$s dalla regola "Ticket Ricorrenti" "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='La regola è stata disabilitata a causa di errori di validazione. Controlla in seguito per i dettagli.';
$hesklang['recurring_tickets']['errors_title']='Una o più delle tue regole hanno generato errori in esecuzione e sono state disabilitate.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Errore nella regola #%s:';
$hesklang['recurring_tickets']['create_customers']='Non ci sono clienti inseriti - puoi creali <a href="%s" target="_blank">qui</a>.';
$hesklang['recurring_tickets']['exec_dates']='Date di esecuzione della regola';
$hesklang['recurring_tickets']['show_exec_dates']='[Mostra le attuali date di esecuzione della regola]';
$hesklang['recurring_tickets']['no_exec_dates']='Seleziona trigger valido per vedere le date di esecuzione.';
$hesklang['recurring_tickets']['invalid_disabled']='Impostazioni non valide - regola disabilitata.';
$hesklang['recurring_tickets']['next_occ']='Prossime %s occorrenze della regola:';
$hesklang['recurring_tickets']['occ_on']='il %s';
$hesklang['recurring_tickets']['not_firing_today']='non è necessario attivarlo oggi.';
$hesklang['recurring_tickets']['rules_fulfilled']='Regole ricorrenti eseguite con successo – ticket creato oggi!';
$hesklang['recurring_tickets']['validation_failed']='validazione fallita - regola disabilitata. Dettagli di seguito:';
$hesklang['recurring_tickets']['validation_error']='Errore di validazione:';
$hesklang['recurring_tickets']['processed']='Eseguito.';
$hesklang['recurring_tickets']['created_ticket']='ticket creato con id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='rispetto alla data di creazione del ticket';
$hesklang['priorities']='Priorità';
$hesklang['priority_intro']='Usa questo strumento per gestire le priorità dei ticket per il tuo help desk';
$hesklang['new_priority']='Nuova priorità';
$hesklang['edit_priority']='Modifica priorità';
$hesklang['priority_title']='Titolo';
$hesklang['can_customers_select_it']='I clienti possono selezionare questa priorità?';
$hesklang['selected_by_customer']='Selezionabile dai clienti';
$hesklang['err_priority']='Inserisci il titolo della priorità';
$hesklang['priority_added']='È stata aggiunta una nuova priorità';
$hesklang['priority_e_id']='ID priorità non valido';
$hesklang['priority_mdf']='La priorità è stata salvata';
$hesklang['priority_deleted']='Priorità eliminata';
$hesklang['priority_not_found']='Questa priorità non esiste';
$hesklang['priority_not_empty']='Questa priorità non può essere eliminata perché esistono ticket con questa priorità';
$hesklang['click_to_enable_drag_drop']='Clicca per abilitare il trascinamento, quindi trascina la riga su o giù per riordinare le priorità.';
$hesklang['confirm_delete_priority']='Sei sicuro di voler eliminare questa priorità?';
$hesklang['reordered_message']='L’ordine della tua lista di priorità è stato salvato.';
$hesklang['list_tkt_priority']='Elenca tutti i ticket con questa priorità';
$hesklang['deletion_priority_restricted']='Questa è una priorità speciale e non può essere eliminata';
$hesklang['priority_limit']='Non puoi creare nuove priorità';
$hesklang['skip_to_main_content']='Salta al contenuto principale';
$hesklang['opens_dialog']='Apre un dialogo';
$hesklang['create_a_ticket']='Crea un ticket';
$hesklang['toggle_navigation']='Attiva/disattiva navigazione';
$hesklang['add_a_ticket_reply']='Aggiungi una risposta al ticket';
$hesklang['linked_tickets']='Ticket collegati';
$hesklang['no_linked_tickets']='Nessun ticket collegato';
$hesklang['link_ticket']='Collega ticket';
$hesklang['can_link_tickets_e']='Non sei autorizzato a collegare/scollegare questo ticket';
$hesklang['link_ticket_success']='Il ticket è stato collegato con successo';
$hesklang['link_ticket_required_error']='Per collegare un ticket, fornisci un ID valido';
$hesklang['link_ticket_itself_error']='Un ticket non può essere collegato a se stesso. Inserisci un ID diverso';
$hesklang['already_linked_error']='Il ticket è già collegato';
$hesklang['unlink_success']='Il ticket è stato scollegato con successo';
$hesklang['unlink_error']='Nessun record collegato esistente';
$hesklang['link_history']='<li class="smaller">%s | %s ticket collegato da %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket scollegato da %s</li>';
$hesklang['can_link_tickets']='Può collegare il ticket';
$hesklang['link_a_ticket']='Collega un ticket';
$hesklang['mfa_curl']='Impossibile generare un’immagine QR da scansionare perché il supporto <strong>cURL</strong> non è abilitato sul tuo server.';
$hesklang['require_xml']='PHP-XML deve essere abilitato per i messaggi in Rich Text (HTML). Chiedi al tuo provider di hosting di abilitare XML per PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s aggiunto come collaboratore da %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s rimosso come collaboratore da %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfetto per lavori di manutenzione preventiva, revisioni mensili degli accessi, controlli ricorrenti dei clienti e altro ancora.';
$hesklang['recurring_tickets']['feat1']='<strong>Imposta e dimentica.</strong> Quotidiano, ogni lunedì, ogni mese, il 15 di ogni mese o qualsiasi data futura';
$hesklang['recurring_tickets']['feat2']='<strong>Arriva pre-compilato e assegnato.</strong> Scegli categoria, priorità, agente e fino a 100 valori di campi personalizzati';
$hesklang['recurring_tickets']['feat3']='<strong>Anteprima date e simulazione.</strong> Vedi ogni ticket che Hesk genererà prima di attivare una regola, così non ci saranno sorprese.';
$hesklang['unlink_btn']='Scollega';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');