<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Deutsch (German)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Silvio Paschke
* Olaf Nöhring (http://datenbank-projekt.de)
* Alexander Moll (http://www.mentis-vis.de)
* OSWorX (https://osworx.net)
* Andreas (https://www.zzshop.de)
* Stefan Kuske (http://totalidea.com)
* Christoph Herthel (https://www.hchristo.de/)
* Christoph Eder
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Deutsch';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='German';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_general_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Bitte oberhalb dieser Zeile antworten ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Neues Ticket: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Ticket erhalten: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Ticket zugewiesen: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Neue Antwort auf: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Neue Antwort auf: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Ticket verschoben: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Notiz hinzugefügt zu: %%SUBJECT%%';
$hesklang['new_pm']='Neue private Nachricht: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Liste eigener Supporttickets';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Keine Verbindung zur Datenbank möglich!';
$hesklang['invalid_action']='Ungültige Aktion';
$hesklang['select_username']='Bitte einen Benutzernamen auswählen.';
$hesklang['enter_pass']='Bitte Passwort eingeben.';
$hesklang['cant_sql']='SQL kann nicht ausgeführt werden.';
$hesklang['contact_webmsater']='Bitte den Betreiber informieren';
$hesklang['mysql_said']='MySQL antwortet';
$hesklang['wrong_pass']='Passwort falsch';
$hesklang['session_expired']='Die Benutzersitzung ist abgelaufen, bitte nochmals anmelden.';
$hesklang['attempt']='Ungültiger Versuch!';
$hesklang['not_authorized_tickets']='Keine Berechtigung Tickets in dieser Kategorie einzusehen!';
$hesklang['must_be_admin']='Keine Berechtigung diese Seite aufzurufen - nur möglich für Admins.';
$hesklang['no_session']='Neue Sitzung konnte nicht gestartet werden!';
$hesklang['error']='Fehler';
$hesklang['int_error']='Interner Programmfehler!';
$hesklang['no_trackID']='Keine Tracking-Nr.';
$hesklang['status_not_valid']='Status ungültig';
$hesklang['trackID_not_found']='Tracking-Nr. nicht gefunden';
$hesklang['enter_message']='Bitte eine Nachricht eingeben.';
$hesklang['select_priority']='Bitte eine Prioritätsstufe auswählen.';
$hesklang['ticket_not_found']='Ticket nicht gefunden - bitte angegebene Tracking-Nr. überprüfen';
$hesklang['no_selected']='Für Änderungen bitte ein Ticket auswählen.';
$hesklang['id_not_valid']='Nr. ist nicht gültig.';
$hesklang['enter_id']='Bitte Tracking-Nr. eingeben.';
$hesklang['enter_name']='Bitte Kundennamen eingeben';
$hesklang['enter_date']='Bitte Datum angeben innerhalb dessen gesucht werden soll.';
$hesklang['date_not_valid']='Keine gültige Datumsangabe - Format muss in dieser Form sein: <b>JJJJ-MM-TT</b>';
$hesklang['enter_subject']='Betreff für dieses Ticket';
$hesklang['invalid_search']='Ungültige Suchabfrage';
$hesklang['choose_cat_ren']='Kategorie auswählen welche umbenannt werden soll.';
$hesklang['cat_ren_name']='Bitte neuen Kategorienamen eingeben.';
$hesklang['cat_not_found']='Kategorie nicht gefunden';
$hesklang['enter_cat_name']='Bitte Kategorienamen eingeben.';
$hesklang['no_cat_id']='Keine Kategorie-ID';
$hesklang['cant_del_default_cat']='Die Standardkategorie kann nicht gelöscht werden, nur umbenannt!';
$hesklang['no_valid_id']='Benutzer-ID nicht gültig';
$hesklang['user_not_found']='Benutzer nicht gefunden';
$hesklang['enter_real_name']='Vollständiger Name fehlt.';
$hesklang['enter_valid_email']='Gültige E-Mail Adresse fehlt.';
$hesklang['enter_username']='Benutzername fehlt.';
$hesklang['asign_one_cat']='Der Benutzer muss mindestens einer Kategorie zugewiesen sein!';
$hesklang['signature_long']='Die Unterschrift des Nutzers ist zu lang! Bitte beschränken Sie diese auf 1000 Zeichen';
$hesklang['confirm_user_pass']='Passwort nochmals angeben.';
$hesklang['passwords_not_same']='Die Passwörter stimmen nicht überein!';
$hesklang['cant_del_admin']='Der Standardadministrator kann nicht gelöscht werden!';
$hesklang['cant_del_own']='Das Profil mit welchem die Anmeldung erfolgte kann nicht gleichzeitig gelöscht werden!';
$hesklang['enter_your_name']='Bitte Namen eingeben.';
$hesklang['sel_app_cat']='Passende Kategorie auswählen.';
$hesklang['sel_app_priority']='Prioritätsstufe auswählen.';
$hesklang['enter_ticket_subject']='Bitte den Betreff für das Ticket angeben.';
$hesklang['user_not_found_nothing_edit']='Benutzer nicht gefunden oder keine Daten zu ändern!';

// ADMIN PANEL
$hesklang['administrator']='Administrator';
$hesklang['login']='Anmeldung';
$hesklang['user']='Benutzer';
$hesklang['username']='Benutzername';
$hesklang['pass']='Passwort';
$hesklang['confirm_pass']='Passwort bestätigen';
$hesklang['logged_out']='Abgemeldet';
$hesklang['logout']='Abmelden';
$hesklang['logout_success']='Abmeldung erfolgreich.';
$hesklang['click_login']='Hier klicken zur Anmeldung';
$hesklang['back']='Zurück';
$hesklang['displaying_pages']='Anzahl Tickets: <b>%d</b> - Seiten';
$hesklang['trackID']='Tracking-Nr.';
$hesklang['timestamp']='Zeitstempel';
$hesklang['name']='Name';
$hesklang['subject']='Betreff';
$hesklang['status']='Status';
$hesklang['priority']='Priorität';
$hesklang['open']='Neu';
$hesklang['open_action']='Ticket wiedereröffnen'; // Open ACTION
$hesklang['close']='Erledigt'; // Closed ticket STATUS
$hesklang['any_status']='Jeder Status';
$hesklang['high']='Hoch';
$hesklang['medium']='Mittel';
$hesklang['low']='Niedrig';
$hesklang['del_selected']='Ausgewählte Tickets löschen';
$hesklang['manage_cat']='Kategorieverwaltung';
$hesklang['profile']='Mein Profil';
$hesklang['show_tickets']='Tickets anzeigen';
$hesklang['sort_by']='Sortieren nach';
$hesklang['date_posted']='Erstellt';
$hesklang['category']='Kategorie';
$hesklang['any_cat']='Alle Kategorien';
$hesklang['order']='Sortierung';
$hesklang['ascending']='Aufsteigend (A-Z)';
$hesklang['descending']='Absteigend (Z-A)';
$hesklang['display']='Anzeige';
$hesklang['tickets_page']='Tickets pro Seite';
$hesklang['find_ticket']='Ticket finden';
$hesklang['yyyy_mm_dd']='JJJJ-MM-TT';
$hesklang['results_page']='Ergebnisse pro Seite';
$hesklang['opened']='Erstellt'; // The ticket has been OPENED
$hesklang['closed']='Erledigt'; // Ticket has been RESOLVED
$hesklang['ticket']='Ticket';
$hesklang['tickets']='Tickets';
$hesklang['ticket_been']='Dieses Ticket wurde';
$hesklang['view_ticket']='Ticket anzeigen';
$hesklang['open_tickets']='Offene Tickets';
$hesklang['remove_statement']='&quot;Powered by&quot;-Hinweis Entfernen';
$hesklang['click_info']='Hier klicken um weitere Informationen zu erhalten.';
$hesklang['reply_added']='Antwort hinzugefügt';
$hesklang['reply_submitted']='Antwort gesendet';
$hesklang['ticket_marked']='Ticket wurde markiert';
$hesklang['ticket_status']='Ticketstatus';
$hesklang['replies']='Antworten';
$hesklang['date']='Datum';
$hesklang['email']='E-Mail Adresse';
$hesklang['ip']='IP';
$hesklang['message']='Nachricht';
$hesklang['add_reply']='Antwort hinzufügen';
$hesklang['close_this_ticket']='Dieses Ticket als erledigt markieren';
$hesklang['change_priority']='Priorität ändern zu';
$hesklang['attach_sign']='Signatur hinzufügen';
$hesklang['profile_settings']='Profileinstellungen';
$hesklang['submit_reply']='Antwort senden';
$hesklang['support_panel']='Support-Oberfläche';
$hesklang['ticket_trackID']='Tracking-Nr. des Tickets';
$hesklang['c2c']='Klicken um fortzufahren';
$hesklang['tickets_deleted']='Tickets gelöscht.';
$hesklang['num_tickets_deleted']='<b>%d</b> Tickets wurden gelöscht';
$hesklang['confirm_del_cat']='Soll diese Kategorie wirklich gelöscht werden?';
$hesklang['cat_intro']='Kategorien können helfen, Tickets nach Relevanz zu sortieren (z.B. &quot;Verkauf&quot;, &quot;Produkte&quot;, &quot;Hardwareprobleme&quot;, &quot;Softwareprobleme&quot; usw.) sowie Benutzer einzelnen Kategorien zuzuordnen (z.B. einem Vertriebsmitarbeiter nur Tickets der ihm zugewiesenen Kategorie anzuzeigen)';
$hesklang['cat_name']='Kategoriename';
$hesklang['remove']='Löschen';
$hesklang['add_cat']='Neue Kategorie hinzufügen';
$hesklang['max_chars']='max. 40 Zeichen';
$hesklang['create_cat']='Kategorie erstellen';
$hesklang['ren_cat']='Kategorie umbenennen';
$hesklang['to']='zu';
$hesklang['cat_added']='Kategorie hinzugefügt.';
$hesklang['cat_name_added']='Kategorie %s wurde erfolgreich hinzugefügt';
$hesklang['cat_renamed']='Kategorie wurde umbenannt.';
$hesklang['cat_renamed_to']='Die ausgewählte Kategorie wurde erfolgreich umbenannt in';
$hesklang['cat_removed']='Kategorie entfernt.';
$hesklang['cat_removed_db']='Die ausgewählte Kategorie wurde erfolgreich aus der Datenbank entfernt.';
$hesklang['sure_remove_user']='Sicher, dass dieser Benutzer entfernt werden soll?';
$hesklang['manage_users']='Benutzerverwaltung';
$hesklang['users_intro']='Hier werden die Benutzer verwaltet, z.B. Zugriff auf die Administrationsoberfläche und Tickets beantworten. Administratoren können Tickets jeder Kategorie sehen sowie bearbeiten und haben Zugriff auf alle Administratorfunktionen (Benutzer- & Kategorieverwaltung, usw.). Normale Benutzer haben nur Zugriff auf die ihnen gewährten Funktionen.';
$hesklang['yes']='JA';
$hesklang['no']='NEIN';
$hesklang['edit']='Bearbeiten';
$hesklang['add_user']='Neuen Benutzer erstellen';
$hesklang['req_marked_with']='Pflichtfelder sind markiert mit';
$hesklang['real_name']='Vollständiger Name (Vor- und Zuname)';
$hesklang['signature_max']='Unterschrift (max 1000 Zeichen)';
$hesklang['sign_extra']='Kein HTML-Code erlaubt, Links werden automatisch umgewandelt.';
$hesklang['create_user']='Benutzer erstellen';
$hesklang['editing_user']='Benutzer bearbeiten';
$hesklang['user_added']='Benutzer hinzugefügt';
$hesklang['user_added_success']='Neuer Benutzer %s mit dem Passwort %s wurde erfolgreich hinzugefügt.';
$hesklang['profile_updated']='Profil aktualisiert.';
$hesklang['profile_updated_success']='Das Profil wurde erfolgreich aktualisiert.';
$hesklang['user_removed']='Benutzer entfernt.';
$hesklang['sel_user_removed']='Der ausgewählte Benutzer wurde erfolgreich aus der Datenbank entfernt.';
$hesklang['profile_for']='Profil für';
$hesklang['new_pass']='Neues Passwort';
$hesklang['update_profile']='Profil aktualisieren';
$hesklang['notify_new_posts']='Benachrichtigung bei neuen Tickets und Einträgen in den zugewiesenen Kategorien';
$hesklang['view_profile']='Profil anzeigen';
$hesklang['new_ticket_submitted']='Neues Ticket ist eingegangen.';
$hesklang['user_profile_updated_success']='Das Benutzerprofil wurde erfolgreich aktualisiert.';
$hesklang['printer_friendly']='Druckoptimierte Ausgabe';
$hesklang['end_ticket']='--- Ende des Tickets ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Das Ticket wurde';
$hesklang['view_your_ticket']='Ticket anzeigen';
$hesklang['submit_ticket']='Ticket senden';
$hesklang['sub_ticket']='Nachricht absenden';
$hesklang['before_submit']='Vor dem Absenden bitte überprüfen ob';
$hesklang['all_info_in']='alle notwendigen Informationen eingegeben wurden';
$hesklang['all_error_free']='alle Informationen so genau wie möglich sowie korrekt und fehlerfrei sind';
$hesklang['we_have']='Wir werden';
$hesklang['recorded_ip']='als die verwendete IP-Adresse aufzeichnen.';
$hesklang['recorded_time']='den Zeitpunkt der Übermittlung speichern.';
$hesklang['save_changes']='Änderungen speichern';
$hesklang['reply_submitted_success']='Die Antwort zu diesem Ticket wurde erfolgreich gesendet';
$hesklang['ticket_submitted']='Ticket-Anfrage versendet';
$hesklang['ticket_submitted_success']='Das Ticket wurde erfolgreich gesendet, Ticket-Nr.';
$hesklang['your_ticket']='Ticket';

// Added in version 0.94
$hesklang['check_updates']='Immer aktuellste Version von Hesk installiert haben!';
$hesklang['check4updates']='Auf Aktualisierungen prüfen';
$hesklang['wait_reply']='Warte auf Antwort';
$hesklang['replied']='Beantwortet';
$hesklang['last_replier']='Letzter Bearbeiter';
$hesklang['staff']='Mitarbeiter';
$hesklang['customer']='Kunde';
$hesklang['close_selected']='Ausgewählte Tickets als &quot;Erledigt&quot; markieren';
$hesklang['execute']='Ausführen';
$hesklang['saved_replies']='Vorlagen';
$hesklang['manage_saved']='Vorlagenverwaltung';
$hesklang['manage_intro']='Hier werden Vorlagen (vorgefertigte Antworten) verwaltet. Das sind allgemein gehaltene Antworten, die für jeden Kunden mehr oder weniger identisch verwendet werden. So können oftmals verwendete Textpassagen einfach verwendet werden ohne sie jedes Mal neu schreiben zu müssen.';
$hesklang['saved_title']='Titel <span style="color: #565656;">(max. 50 Zeichen)</span>';
$hesklang['no_saved']='Noch keine Vorlagen vorhanden';
$hesklang['delete_saved']='Soll diese Vorlagen sicher gelöscht werden?';
$hesklang['new_saved']='Eine Vorlagen neu erstellen oder ändern';
$hesklang['canned_add']='Eine neue Vorlagen erstellen';
$hesklang['canned_edit']='Ausgewählte Vorlagen bearbeiten';
$hesklang['save_reply']='Antwort speichern';
$hesklang['saved']='Antwort gespeichert';
$hesklang['your_saved']='Die Vorlagen wurde zur zukünftigen Verwendung gespeichert.';
$hesklang['ent_saved_title']='Antwort muss eine Überschrift haben';
$hesklang['ent_saved_msg']='Antwort muss einen Text enthalten';
$hesklang['saved_removed']='Vorlagen entfernt.';
$hesklang['saved_rem_full']='Die ausgewählten vorgefertigten Antworten wurden aus der Datenbank entfernt.';
$hesklang['clip_alt']='Dieser Eintrag enthält Anhänge.';
$hesklang['attachments']='Anhänge';
$hesklang['fill_all']='Pflichtfeld(er) nicht ausgefüllt!';
$hesklang['file_too_large']='Die Datei %s ist zu groß!';
$hesklang['cannot_move_tmp']='Die Datei konnte nicht in den Anhangsordner verschoben werden';
$hesklang['created_on']='Erstellt am';
$hesklang['tickets_closed']='Tickets erledigt';
$hesklang['num_tickets_closed']='<b>%d</b> Tickets wurden als erledigt markiert';
$hesklang['select_saved']='Eine Vorlagen auswählen';
$hesklang['select_empty']='Auswählen / Leer';
$hesklang['insert_special']='Platzhalter einfügen (wird durch Kundeninformation ersetzt)';
$hesklang['move_to_catgory']='Ticket verschieben nach';
$hesklang['move']='Verschieben';
$hesklang['moved']='Ticket verschoben';
$hesklang['moved_to']='Dieses Ticket wurde in die neue Kategorie verschoben.';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Alle außer erledigte';
$hesklang['chg_all']='Alle ändern';
$hesklang['settings']='Einstellungen';
$hesklang['settings_intro']='Generelle Einstellungen für das Hilfesystem. Für weitere Informationen zu den Einstellungen siehe die Hilfesymbole oder Hilfe.';
$hesklang['all_req']='Alle aktiven Felder sind notwendig!';
$hesklang['wbst_title']='Name Webseite';
$hesklang['wbst_url']='URL Webseite';
$hesklang['email_wm']='Admin E-Mail Adresse';
$hesklang['max_listings']='Datensätze pro Seite';
$hesklang['print_size']='Schriftgröße für Druckausgabe';
$hesklang['debug_mode']='Debug-Modus';
$hesklang['on']='<span style="color:green;">AN</span>';
$hesklang['off']='<span style="color:red;">AUS</span>';
$hesklang['use_secimg']='Anti-SPAM-Grafik verwenden';
$hesklang['secimg_no']='Nicht verfügbar';
$hesklang['attach_use']='Dateianhänge erlauben';
$hesklang['attach_num']='Anzahl pro Eintrag';
$hesklang['attach_type']='Erlaubte Dateitypen';
$hesklang['place_after']='Nach der Nachricht';
$hesklang['place_before']='Vor der Nachricht';
$hesklang['custom_f']='Benutzerdefiniertes Feld';
$hesklang['custom_u']='Dieses Feld verwenden';
$hesklang['custom_n']='Feldname';
$hesklang['custom_l']='Maximale Länge (Zeichen)';
$hesklang['db_host']='Host';
$hesklang['db_name']='Name';
$hesklang['db_user']='Benutzer';
$hesklang['db_pass']='Passwort';
$hesklang['err_sname']='Webseitenname fehlt';
$hesklang['err_surl']='URL der Webseite fehlt - URL muss gültig sein sowie mit http:// oder https:// beginnen';
$hesklang['err_wmmail']='E-Mail Adresse für Admin fehlt';
$hesklang['err_nomail']='Es fehlt eine gültige E-Mail Adresse als Absenderadresse (&quot;NOREPLY&quot;)';
$hesklang['err_htitle']='Name für das Hilfesystem fehlt';
$hesklang['err_hurl']='Es fehlt die URL zu diesem System - URL muss gültig sein sowie mit http:// oder https:// beginnen';
$hesklang['err_lang']='Es wurde keine Sprache ausgewählt';
$hesklang['err_nolang']='Die angegebene Sprachdatei ist im Ordner &quot;language&quot; nicht vorhanden! Bitte vor einer Änderung überprüfen ob die gewünschte Datei am Server vorhanden ist';
$hesklang['err_max']='Bitte auswählen wieviele Einträge pro Seite maximal angezeigt werden sollen.';
$hesklang['err_psize']='Es fehlt die Schriftgröße für die Druckausgabe.';
$hesklang['err_dbhost']='Hostname der MySQL-Datenbank fehlt.';
$hesklang['err_dbname']='Name der MySQL-Datenbank fehlt.';
$hesklang['err_dbuser']='Benutzername für die MySQL-Datenbank fehlt.';
$hesklang['err_dbpass']='Passwort für die MySQL-Datenbank fehlt.';
$hesklang['err_dbconn']='Mit den eingegebenen Daten konnte keine Verbindung zur MySQL-Datenbank hergestellt werden!';
$hesklang['err_dbsele']='MySQL-Datenbank konnte nicht gefunden werden, bitte die Datenbankeinstellungen überprüfen.';
$hesklang['err_custname']='Es fehlt die Bezeichnung für die optionalen Felder.';
$hesklang['err_openset']='Die Datei <b>hesk_settings.inc.php</b> hat keinen Schreibzugriff! Bitte vor dem Ändern/Speichern die Rechte an dieser Datei via FTP ändern (je nach Server 0644 oder 0666).';
$hesklang['set_saved']='Einstellungen gespeichert.';
$hesklang['set_were_saved']='Die Einstellungen wurden erfolgreich gespeichert.';
$hesklang['sec_img']='Anti-SPAM-Grafik (Captcha)';
$hesklang['sec_miss']='Die angezeigten Werte zum SPAM-Schutz wurden nicht angegeben';
$hesklang['sec_wrng']='Die eingegebenen Werte zum SPAM-Schutz stimmen nicht';
$hesklang['submit_problems']='Bitte zurückgehen und nachstehende Probleme beheben';
$hesklang['cat_order']='Kategoriesortierung';
$hesklang['reply_order']='Sortierung der vorgefertigten Antworten';
$hesklang['move_up']='Nach oben verschieben';
$hesklang['move_dn']='Nach unten verschieben';
$hesklang['cat_move_id']='Kategorie-Nr. fehlt!';
$hesklang['reply_move_id']='Nr. der vorgefertigten Antwort fehlt!';
$hesklang['forgot_tid']='Tracking-Nr. vergessen?';
$hesklang['tid_send']='Bitte meine Ticket-Nr. zusenden!';
$hesklang['tid_not_found']='Zu der angegebenen E-Mail Adresse konnte kein Ticket gefunden werden!';
$hesklang['tid_sent']='Ticket-Nr. wurde erfolgreich per Email zugesendet';
$hesklang['tid_sent2']='Ein Email mit den Ticketdetails wurde an die angegbene E-Mail Adresse gesendet.';
$hesklang['check_spambox']='Sollte die E-Mail nicht angekommen sein, bitte den Spam-/Junkmailordner überprüfen!';
$hesklang['reply_not_found']='Vorgefertigte Antwort wurde nicht gefunden!';
$hesklang['exists']='Vorhanden';
$hesklang['no_exists']='Nicht vorhanden!';
$hesklang['writable']='Schreibrechte vorhanden';
$hesklang['not_writable']='Nicht beschreibbar!';
$hesklang['disabled']='Deaktiviert!';
$hesklang['e_settings']='Die Einstellungen können nicht gespeichert solange die Datei keine Schreibrechte besitzt. Weitere Anweisungen siehe Hilfe.';
$hesklang['e_attdir']='Es können keine Dateianhänge gespeichert werden solange der Ordner nicht vorhanden ist und die erforderlichen Schreibrechte (0755 bzw. 0777) besitzt. Weitere Anweisungen siehe die Hilfe.';
$hesklang['e_save_settings']='Die Einstellungen konnten nicht gespeichert werden, da die Datei <b>hesk_settings.inc.php</b> keine Schreibrechte (0644 oder 0666) besitzt.';
$hesklang['e_attach']='Nicht aktiv, da das Script keinen Schreibzugriff auf den Ordner <b>attachments</b> hat.';
$hesklang['go']='Los!';

// Added in version 2.0
$hesklang['v']='HESK Version';
$hesklang['check_status']='Statusüberprüfung';
$hesklang['sub_support']='Ein Ticket senden';
$hesklang['open_ticket']='Ticket-Anfrage erstellen';
$hesklang['view_existing']='Vorhandenes Ticket anzeigen';
$hesklang['vet']='Tickets anzeigen, welche früher erstellt wurden';
$hesklang['enter_user']='Bitte den Benutzernamen angeben';
$hesklang['remember_user']='Benutzer merken';
$hesklang['wrong_user']='Falscher Benutzername';
$hesklang['no_permission']='Keine Berechtigung diese Aufgabe auszuführen - eventuell nochmals mit anderem Profil anmelden';
$hesklang['tickets_on_pages']='Ticketanzahl: %d - Anzahl Seiten: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='Gehe zu Seite:';
$hesklang['no_tickets_open']='Keine offenen Tickets gefunden';
$hesklang['no_tickets_crit']='Keine Tickets gefunden, die den Kriterien entsprechen';
$hesklang['confirm_execute']='Diese Aktion sicher ausführen?';
$hesklang['legend']='Beschreibung';
$hesklang['main_page']='Startseite';
$hesklang['menu_users']='Benutzer';
$hesklang['menu_cat']='Kategorien';
$hesklang['menu_profile']='Mein Profil';
$hesklang['menu_kb']='Wissensdatenbank'; // Admin MENU item
$hesklang['kb_text']='Wissensdatenbank'; // Item visible to customers
$hesklang['viewkb']='Gesamten Inhalt der Wissensdatenbank anzeigen';
$hesklang['kb']='Wissensdatenbank verwalten';
$hesklang['kb_intro']='Die Wissensdatenbank ist u.a. eine Sammlung von Antworten auf häufig gestellte Fragen (FAQ) sowie Texten um Kunden eventuell das Erstellen eines Tickets zu ersparen. Eine umfassende und gut geschriebene Wissensdatenbank kann die Zahl der Supporttickets drastisch senken und somit viel Arbeitszeit ersparen. Die Datenbank kann in Kategorien und Unterkategorien organisiert werden.'; // Description in ADMIN panel
$hesklang['kb_is']='Diese Wissensdatenbank ist eine Sammlung von Antworten auf (häufig) gestellte Fragen (FAQ) sowie anderen Texten.<br />Sie soll eine Ersthilfe sein - ist die gesuchte Antwort nicht vorhanden, kann ein Ticket erstellt werden.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Neuer Artikel für die Wissensdatenbank';
$hesklang['kb_cat']='Kategorie';
$hesklang['kb_subject']='Betreff';
$hesklang['kb_content']='Inhalt';
$hesklang['kb_type']='Art';
$hesklang['kb_published']='Öffentlich';
$hesklang['kb_published2']='Dieser Artikel in der Wissensdatenbank kann von jedem gelesen werden.';
$hesklang['kb_private']='Intern';
$hesklang['kb_private2']='Interne Artikel können nur von Mitarbeitern gelesen werden.';
$hesklang['kb_draft']='Entwurf';
$hesklang['kb_draft2']='Der Artikel ist gespeichert, aber noch nicht veröffentlicht.<br />Er kann nur von Mitarbeitern gelesen werden welche eine Berechtigung zur Artikelverwaltung in der Wissensdatenbank haben.';
$hesklang['kb_links']='<i><span class="notice"><b>Achtung - Hinweis!</b></span><br />Text muss gütig sein, z.B. keine &lt;Head&gt;- und/oder &lt;Body&gt;-Tags verwenden!</i>';
$hesklang['kb_ehtml']='Dies ist HTML-Code (gültiger (X)HTML-Code muss verwendet werden)';
$hesklang['kb_dhtml']='Dies ist reiner Text (Links werden automatisch umgewandelt)';
$hesklang['kb_save']='Artikel speichern';
$hesklang['kb_e_subj']='Keine Artikelüberschrift angegeben!';
$hesklang['kb_e_cont']='Kein Artikelinhalt angegeben!';
$hesklang['kb_art_added']='Artikel wurde erfolgreich gespeichert';
$hesklang['your_kb_added']='Der Wissensdatenbank wurde erfolgreich ein neuer Artikel hinzugefügt';
$hesklang['kb_art_deleted']='Artikel gelöscht';
$hesklang['your_kb_deleted']='Der ausgewählte Artikel in der Wissensdatenbank wurde erfolgreich gelöscht';
$hesklang['kb_art_mod']='Artikel bearbeitet';
$hesklang['your_kb_mod']='Die Änderung am ausgewählten Artikel wurde erfolgreich gespeichert';
$hesklang['kb_cat_new']='Neue (Unter-)Kategorie in der Wissensdatenbank';
$hesklang['kb_cat_parent']='Übergeordnete Kategorie';
$hesklang['kb_cat_sub']='Unterkategorien';
$hesklang['kb_cat_title']='Kategoriename';
$hesklang['kb_cat_published']='Diese Kategorie in der Wissensdatenbank ist für jeden sichtbar.';
$hesklang['kb_cat_private']='Diese Kategorie ist nur für Mitarbeiter sichtbar.';
$hesklang['kb_cat_add']='Kategorie hinzufügen';
$hesklang['kb_cat_e_title']='Kategoriename fehlt!';
$hesklang['kb_cat_added']='Kategorie hinzugefügt';
$hesklang['kb_cat_added2']='Der Wissensdatenbank wurde erfolgreich eine neue Kategorie hinzugefügt';
$hesklang['kb_cat_man']='Kategorien der Wissensdatenbank verwalten';
$hesklang['kb_cat_edit']='Kategoriedetails bearbeiten';
$hesklang['kb_cat_inv']='Ungültige Kategorie';
$hesklang['kb_cat_art']='Artikel in dieser Kategorie';
$hesklang['kb_p_art']='+ Artikel';
$hesklang['kb_p_art2']='der ausgewählten Kategorie einen neuen Artikel hinzufügen.';
$hesklang['kb_add_art']='Artikel hinzufügen';
$hesklang['kb_p_cat']='+ Kategorie';
$hesklang['kb_p_cat2']='in der ausgewählten Kategorie eine neue Unterkategorie anlegen.';
$hesklang['kb_add_cat']='Kategorie hinzufügen';
$hesklang['kb_p_man']='Verwalten';
$hesklang['kb_p_man2']='ausgewählte Kategorie verwalten (Artikel bearbeiten, löschen oder verwalten).';
$hesklang['kb_main']='Die Hauptkategorie der Wissensdatenbank kann nicht gelöscht oder verschoben werden.';
$hesklang['kb_no_art']='In dieser Kategorie sind (noch) keine Artikel vorhanden.';
$hesklang['author']='Autor';
$hesklang['views']='Aufrufe';
$hesklang['delete']='Löschen';
$hesklang['rating']='Bewertung';
$hesklang['votes']='Stimmen';
$hesklang['kb_rated']='Artikelbewertung %s/5.0';
$hesklang['kb_not_rated']='Artikel wurde noch nicht bewertet';
$hesklang['del_art']='Soll der ausgewählte Artikel gelöscht werden?';
$hesklang['kb_art_id']='Fehlende oder ungültige Artikelnr.!';
$hesklang['kb_art_edit']='Artikel bearbeiten';
$hesklang['revhist']='Bearbeitungsverlauf';
$hesklang['revision1']='<li class="smaller">%s &#124; Übermittelt von %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s &#124; Bearbeitet durch %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Anweisung';
$hesklang['kb_delcat']='Soll diese Kategorie gelöscht werden?';
$hesklang['kb_cat_mod']='Kategorie geändert';
$hesklang['your_cat_mod']='Die Änderungen an der ausgewählten Kategorie wurden erfolgreich gespeichert';
$hesklang['kb_cat_del']='Kategorie der Wissensdatenbank gelöscht';
$hesklang['kb_cat_dlt']='Die ausgewählte Kategorie der Wissensdatenbank wurde gelöscht.';
$hesklang['allowed_cat']='Kategorien';
$hesklang['allow_feat']='Funktionen';
$hesklang['can_view_tickets']='Tickets anzeigen';
$hesklang['can_reply_tickets']='Tickets beantworten';
$hesklang['can_assign_tickets']='Tickets zuordnen';
$hesklang['can_del_tickets']='Tickets löschen';
$hesklang['can_edit_tickets']='Beantwortete Tickets bearbeiten';
$hesklang['can_change_cat']='Ticketkategorie ändern';
$hesklang['can_man_kb']='Wissensdatenbank verwalten';
$hesklang['can_man_users']='Benutzer verwalten';
$hesklang['can_man_cat']='Kategorien verwalten';
$hesklang['can_man_canned']='Gespeicherte Antworten verwalten';
$hesklang['can_man_settings']='<strong style="color:red;">Generelle Helpdeskeinstellungen verwalten</strong>';
$hesklang['can_del_notes']='Anmerkungen zu Tickets entfernen';
$hesklang['dan']='Mitarbeiter können prinzipiell ihre eigenen Anmerkungen zu Tickets löschen, daher nur auswählen wenn Benutzer auch Notizen <strong>anderer</strong> Benutzer löschen dürfen!';
$hesklang['in_all_cat']='nur in erlaubten Kategorien';
$hesklang['admin_can']='(Zugang zu allen Funktionen und Kategorien)';
$hesklang['staff_can']='(Funktionen und Kategorien können eingeschränkt werden)';
$hesklang['asign_one_feat']='Dem Benutzer muss mindestens eine Funktion zugewiesen werden!';
$hesklang['na_view_tickets']='Keine Berechtigung um Tickets einzusehen';
$hesklang['support_notice']='Dieser Abschnitt kann nur versteckt werden, wenn eine HESK-Lizenz erworben wurde!';
$hesklang['rart']='War dieser Artikel hilfreich?';
$hesklang['r']='War diese Antwort hilfreich?';
$hesklang['tyr']='Vielen Dank f&uuml;r diese Bewertung';
$hesklang['cw']='Fenster schließen';
$hesklang['cw2']='Fenster schließen und Ticket senden';
$hesklang['rh']='Bewertet als <i>hilfreich</i>';
$hesklang['rnh']='Bewertet als <i>nicht hilfreich</i>';
$hesklang['ar']='Bereits bewertet';
$hesklang['rated']='Mitarbeiterbewertung %s/5.0 (%s Stimmen)';
$hesklang['not_rated']='Mitarbeiter wurde noch nicht bewertet';
$hesklang['rdis']='Bewertungsfunktion ist deaktiviert';
$hesklang['kbdis']='Wissensdatenbank ist deaktiviert';
$hesklang['kbpart']='Bedauerlicherweise keine Berechtigung diesen Artikel aufzurufen';
$hesklang['popart']='Am besten bewertete Artikel in der Wissensdatenbank:';
$hesklang['latart']='Neueste Artikel in der Wissensdatenbank:';
$hesklang['m']='Weitere Themen';
$hesklang['ac']='Artikel in dieser Kategorie:';
$hesklang['noa']='Noch keine Artikel';
$hesklang['noac']='Noch keine Artikel in dieser Kategorie';
$hesklang['dta']='Datum (erstellt)';
$hesklang['ad']='Artikeldetails';
$hesklang['aid']='Artikel-ID';
$hesklang['as']='Lösung';
$hesklang['search']='Suche';
$hesklang['sr']='Suchergebnisse';
$hesklang['nosr']='Leider keine passenden Artikel zum Suchbegriff gefunden.<br />Möglicherweise ist aber zu diesem Thema ein Artikel vorhanden, andernfalls kann ein neues Ticket erstellt werden.';
$hesklang['rv']='Aufrufe zurück setzen';
$hesklang['rr']='Bewertung zurücksetzen';
$hesklang['opt']='Optionen';
$hesklang['delcat']='Kategorie löschen';
$hesklang['move1']='Artikel in die übergeordnete Kategorie verschieben';
$hesklang['move2']='Artikel in dieser Kategorie löschen';
$hesklang['sc']='Vorgeschlagene Artikel in der Wissensdatenbank lt. Suchbegriff';
$hesklang['not']='Tickets'; // Number of all tickets in category
$hesklang['graph']='Auswertung';
$hesklang['lu']='Auswahl Mitarbeiter';
$hesklang['aclose']='Tickets autom. als erledigt markieren';
$hesklang['aclose2']='Tage seit letzter Antwort eines Mitarbeiter';
$hesklang['s_ucrt']='Tickets wiedereröffnen';
$hesklang['urate']='Bewertung der Antworten';
$hesklang['hesk_url']='Helpdesk-URL';
$hesklang['hesk_title']='Name des Helpdesks';
$hesklang['cid']='Ticket-Nr. des Falls';
$hesklang['tfor']='Zeitformat';
$hesklang['prefix']='Tabellenvorzeichen';
$hesklang['s_ekb']='Wissensdatenbank einschalten';
$hesklang['s_kbs']='WDB-Suche aktivieren';
$hesklang['s_kbr']='WDB-Bewertung aktivieren';
$hesklang['s_maxsr']='Max. Suchergebnisse';
$hesklang['s_suggest']='WDB-Artikel vorschlagen';
$hesklang['s_spop']='Häufig gelesene Artikel anzeigen';
$hesklang['s_slat']='Neueste Artikel anzeigen';
$hesklang['s_onin']='auf der <a href="../" target="_blank">Helpdesk</a>-Seite';
$hesklang['s_onkb']='auf der <a href="../knowledgebase.php" target="_blank">Wissensdatenbank</a>-Seite';
$hesklang['s_scol']='Anzahl Kategorien pro Reihe';
$hesklang['s_ptxt']='Zeichen Artikelvorschau';
$hesklang['s_psubart']='Anzahl Artikel in Unterkategorien';
$hesklang['enable']='Aktivieren';
$hesklang['s_type']='Typ';
$hesklang['custom_r']='Erforderlich';
$hesklang['custom_place']='Ort';
$hesklang['custom_use']='Benutzerdefinierte Felder';
$hesklang['stf']='Textzeile';
$hesklang['stb']='Textfeld';
$hesklang['srb']='Radio-Button';
$hesklang['ssb']='Auswahlfeld';
$hesklang['db']='Datenbank';
$hesklang['hd']='Generelle Einstellungen';
$hesklang['gs']='Basiseinstellungen';
$hesklang['cwin']='Fenster schließen';
$hesklang['defw']='Standardwert';
$hesklang['ok']='OK';
$hesklang['ns']='Verfügbare Optionen für das ausgewählte benutzerdefinierte Feld. Um Änderungen zu speichern unten auf die Schaltfläche <strong>OK</strong> klicken, anschließend auf <b>Änderungen speichern</b> auf der Administrationsseite!';
$hesklang['rows']='Reihen (Untereinander)';
$hesklang['cols']='Spalten (Nebeneinander)';
$hesklang['opt2']='Optionen für diesen Radio-Button: pro Zeile jeweils einen Wert (jede Zeile erzeugt einen neuen auswählbaren Wert).<br />Es müssen mindestens 2 Optionen angegeben werden!';
$hesklang['opt3']='Optionen für dieses Auswahlfeld: pro Zeile jeweils einen Wert (jede Zeile erzeugt einen neuen auswählbaren Wert).<br />Es müssen mindestens 2 Optionen angegeben werden!';
$hesklang['atl2']='Es müssen mindestens 2 Werte (Optionen) definiert sein (1 pro Zeile)!';
$hesklang['notes']='Notizen';
$hesklang['addnote']='+ Notiz hinzufügen';
$hesklang['noteby']='Notiz von';
$hesklang['delnote']='Notiz löschen';
$hesklang['noteerr']='Notiz bereits gelöscht oder falscher Parameter';
$hesklang['s']='Speichern';
$hesklang['nhid']='Notizen sind für Kunden nicht sichtbar!';
$hesklang['delt']='Diesen Beitrag löschen';
$hesklang['edtt']='Beitrag bearbeiten';
$hesklang['edt1']='Beitrag geändert';
$hesklang['edt2']='Änderungen im ausgewählten Beitrag erfolgreich gespeichert';
$hesklang['dele']='Dieses Ticket löschen';
$hesklang['repd']='Beitrag gelöscht';
$hesklang['repl']='Der ausgewählte Beitrag wurde gelöscht';
$hesklang['tickets_found']='Suchergebnisse';
$hesklang['al']='Link zum Verwaltungsbereich';
$hesklang['ap']='Zum Verwaltungsbereich';
$hesklang['dap']='Auf der <a href="../" target="_blank">Hilfeseite</a> einen Link zur Verwaltung anzeigen';
$hesklang['q_miss']='Die Anti-SPAM-Frage muss beantwortet werden';
$hesklang['use_q']='Anti-SPAM-Frage verwenden';
$hesklang['q_q']='-&gt; Frage (HTML-Code ist <span class="success">erlaubt</span>)';
$hesklang['q_a']='-&gt; Antwort';
$hesklang['err_qask']='Anti-SPAM-Frage eingeben';
$hesklang['err_qans']='Antwort auf die Anti-SPAM-Frage eingeben';
$hesklang['genq']='Zufallsfrage generieren';

// Added in version 2.1
$hesklang['amo']='Weitere hinzufügen';
$hesklang['delatt']='Ausgewählten Anhang löschen?';
$hesklang['kb_att_rem']='Ausgewählter Anhang wurde gelöscht';
$hesklang['inv_att_id']='Anhang-ID ist ungültig!';
$hesklang['scb']='Checkbox';
$hesklang['opt4']='Optionen für diese Checkbox:<ul><li>pro Zeile 1 Option</li><li>mindestens 2 Optionen</li><li>Mehrfachauswahl ist möglich</li></ul>';
$hesklang['autologin']='Bei jedem Besuch automatisch anmelden';
$hesklang['just_user']='Nur meinen Benutzernamen merken';
$hesklang['nothx']='Nein, danke';
$hesklang['pinfo']='Profilinformation';
$hesklang['sig']='Signatur';
$hesklang['pref']='Einstellungen';
$hesklang['aftrep']='Nach Beantwortung eines Tickets';
$hesklang['showtic']='Das soeben beantwortete Ticket anzeigen';
$hesklang['gomain']='Zur Verwaltungsübersicht zurückkehren';
$hesklang['shownext']='Nächstes offenes Ticket öffnen (Verwaltungsübersicht öffnet sich autom. wenn keine offenen Tickets vorhanden sind)';
$hesklang['rssn']='Nächstes Ticket anzeigen das bearbeitet werden soll';
$hesklang['mrep']='Bestehende Nachricht ersetzen';
$hesklang['madd']='Am Ende anhängen';
$hesklang['priv']='Interne Kategorien und nur für Mitarbeiter sichtbare Artikel sind markiert mit *';
$hesklang['inve']='Ungültige Emailvorlage';
$hesklang['emfm']='Fehlende Emailvorlage';
$hesklang['hesk_lang']='Standardsprache';
$hesklang['s_mlang']='Mehrsprachig';
$hesklang['s_mlange']='Wenn aktiviert können Benutzer die Webseite in jeder der installierten Sprachen verwenden. Nur auswählen, wenn auch in allen installierten Sprachen Unterstützung angeboten wird!';
$hesklang['s_inl']='Sprachenordner testen';
$hesklang['s_inle']='Den Sprachenordner auf gültige Sprachen testen. Nur Sprachen, die alle Tests bestehen, sind korrekt installiert und können verwendet werden.';
$hesklang['ta']='Test wiederholen';
$hesklang['alo']='Autom. Anmeldung erlauben';
$hesklang['chol']='Bevorzugte Sprache';
$hesklang['mmdl']='Diese Sprache bevorzugen';
$hesklang['warn']='WARNUNG';
$hesklang['dmod']='<strong>Debugmodus ist aktiviert</strong>.<br />Bitte nicht vergessen den Debugmodus zu deaktivieren sobald HESK installiert ist und problemlos funktioniert.';
$hesklang['kb_spar']='Kategorie kann nicht ihre eigene übergeordnete Kategorie sein!';
$hesklang['mysql_root']='Kein MySQL-Passwort angegeben, die Anmeldung würde jetzt als Benutzer \"root\" erfolgen!<br />Bitte sofort ändern, da dies ein extremes Sicherheitsrisiko ist!';
$hesklang['chg']='Ändern';
$hesklang['chpri']='Priorität geändert';
$hesklang['chpri2']='Priorität des Tickets geändert in %s';
$hesklang['selcan']='Vorlage auswählen welche bearbeitet werden soll';
$hesklang['q_wrng']='Antwort auf die Anti-SPAM-Frage ist falsch!';
$hesklang['cndupl']='Es gibt bereits eine Kategorie mit diesem Namen.<br />Bitte einen Anderen wählen.';
$hesklang['wsel']='Das Feld auswählen welches durchsucht werden soll';

// Added in version 2.2
$hesklang['eto']='Ungültige Anfrage';
$hesklang['id']='ID';
$hesklang['geco']='Direktlink erstellen';
$hesklang['genl']='Direktlink zur Kategorie';
$hesklang['genl2']='Diesen Link verwenden um eine Kategorie für das Formular &quot;Ein Ticket übermitteln&quot; vorzugeben.';
$hesklang['ask']='Suchbegriff(e)';
$hesklang['exa']='Beispiele';
$hesklang['small']='Kleiner Kasten';
$hesklang['large']='Großer Kasten';
$hesklang['cpri']='Kundenpriorität';
$hesklang['owner']='Besitzer';
$hesklang['unas']='Nicht zugewiesen';
$hesklang['assi']='Zuweisen';
$hesklang['asst']='Zuweisen an';
$hesklang['asst2']='Dieses Ticket zuweisen an:';
$hesklang['asss']='Selbst zuweisen';
$hesklang['asss2']='Dieses Ticket mir selbst zuweisen';
$hesklang['can_assign_self']='Kann Tickets sich selbst zuweisen';
$hesklang['can_assign_others']='Kann Tickets anderen zuweisen';
$hesklang['can_run_reports']='Kann Berichte erstellen (eigene)';
$hesklang['can_view_ass_others']='Kann Tickets einsehen, die anderen zugewiesen sind';
$hesklang['unoa']='Der ausgewählte Benutzer hat keinen Zugang zu dieser Kategorie';
$hesklang['tasi']='Besitzer zugewiesen';
$hesklang['tasy']='Dieses Ticket wurde zugewiesen';
$hesklang['taso']='Dieses Ticket wurde dem ausgewählten Benutzer zugewiesen';
$hesklang['tasy2']='Mir zugewiesen';
$hesklang['taso2']='Anderen Mitarbeitern zugewiesen';
$hesklang['nose']='Kein Besitzer ausgewählt';
$hesklang['onasc']='Dieser Besitzer hat keinen Zugriff auf die ausgewählte Kategorie.';
$hesklang['tunasi']='Ticket nicht zugewiesen';
$hesklang['tunasi2']='Ticket hat keinen Besitzer und kann wieder zugewiesen werden';
$hesklang['note']='Notiz';
$hesklang['success']='OK';
$hesklang['nyt']='Dieses Ticket ist zugewiesen an';
$hesklang['noch']='Es wurden keine Änderungen durchgeführt';
$hesklang['orch']='Anzeigereihenfolge wurde geändert';
$hesklang['rfm']='Erforderliche Information fehlt:';
$hesklang['repl0']='Unzureichende Berechtigungen um diese Aufgabe auszuführen';
$hesklang['repl1']='Dieser Eintrag existiert nicht';
$hesklang['reports']='Berichte';
$hesklang['reports_intro']='Im Bereich Berichte können verschiedene Berichte sowie Statistiken über Tickets zu definierten Zeiträumen erstellt werden.';
$hesklang['refi']='Formular zurücksetzen';
$hesklang['dich']='Änderungen verwerfen';
$hesklang['dire']='Bericht anzeigen';
$hesklang['m1']='Januar';
$hesklang['m2']='Februar';
$hesklang['m3']='März';
$hesklang['m4']='April';
$hesklang['m5']='Mai';
$hesklang['m6']='Juni';
$hesklang['m7']='Juli';
$hesklang['m8']='August';
$hesklang['m9']='September';
$hesklang['m10']='Oktober';
$hesklang['m11']='November';
$hesklang['m12']='Dezember';
$hesklang['d1']='Montag';
$hesklang['d2']='Dienstag';
$hesklang['d3']='Mittwoch';
$hesklang['d4']='Donnerstag';
$hesklang['d5']='Freitag';
$hesklang['d6']='Samstag';
$hesklang['d0']='Sonntag';
$hesklang['mo']='Mo';
$hesklang['tu']='Di';
$hesklang['we']='Mi';
$hesklang['th']='Do';
$hesklang['fr']='Fr';
$hesklang['sa']='Sa';
$hesklang['su']='So';
$hesklang['from']='Von';
$hesklang['cinv']='Ungültiges Datum';
$hesklang['cinv2']='Erlaubtes Datumsformat ist MM/TT/JJJJ';
$hesklang['cinm']='Ungültiger Wert für Monat';
$hesklang['cinm2']='Erlaubter Bereich ist';
$hesklang['cind']='Ungültiger Wert für Tag des Monats';
$hesklang['cind2']='Erlaubter Bereich für den gewählten Monat ist';
$hesklang['month']='Monat';
$hesklang['ocal']='Kalender öffnen';
$hesklang['ca01']='Voriges Jahr';
$hesklang['ca02']='Voriger Monat';
$hesklang['ca03']='Nächster Monat';
$hesklang['ca04']='Nächstes Jahr';
$hesklang['ca05']='Kalender schließen';
$hesklang['cdr']='Datumsbereich auswählen:';
$hesklang['crt']='Berichtsart';
$hesklang['r1']='Heute';
$hesklang['r2']='Gestern';
$hesklang['r3']='Dieser Monat';
$hesklang['r4']='Letzter Monat';
$hesklang['r5']='Letzte 30 Tage';
$hesklang['r6']='Diese Woche (Mo-So)';
$hesklang['r7']='Letzte Woche (Mo-So)';
$hesklang['r8']='Diese Geschäftswoche (Mo-Fr)';
$hesklang['r9']='Letzte Geschäftswoche (Mo-Fr)';
$hesklang['r10']='Dieses Jahr';
$hesklang['r11']='Letztes Jahr';
$hesklang['r12']='Gesamte Zeit';
$hesklang['datetofrom']='&quot;Beginndatum&quot; kann nicht nach dem &quot;Enddatum&quot; liegen -  die Datumsangaben wurden ausgetauscht.';
$hesklang['t1']='Tickets pro Tag';
$hesklang['t2']='Tickets pro Monat';
$hesklang['t3']='Tickets pro Benutzer';
$hesklang['t4']='Tickets pro Kategorie';
$hesklang['ticass']='Zugewiesene Tickets';
$hesklang['ticall']='Beantwortete Tickets';
$hesklang['totals']='Gesamt';
$hesklang['all']='Alle';
$hesklang['atik']='Neue Tickets';
$hesklang['kbca']='In der Wissensdatenbank existiert bereits eine Kategorie dieses Namens.';
$hesklang['menu_msg']='Nachricht';
$hesklang['menu_can']='Vorlagen';
$hesklang['m_from']='Von:'; // Mail "from" address
$hesklang['m_to']='An:'; // Mail "to" address
$hesklang['m_sub']='Betreff:'; // Mail subject
$hesklang['m_re']='AW:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='WG:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Private Nachrichten';
$hesklang['m_intro']='Private Nachrichten verwenden um andere Mitarbeiter innerhalb des Systems direkt zu kontaktieren.';
$hesklang['e_udel']='(Benutzer gelöscht)';
$hesklang['new_mail']='Neue private Nachricht';
$hesklang['m_send']='Nachricht senden';
$hesklang['m_rec']='Empfänger auswählen';
$hesklang['m_inr']='Ungültiger Empfänger';
$hesklang['m_esu']='Betreff fehlt';
$hesklang['m_pms']='Nachricht wurde gesendet';
$hesklang['inbox']='EINGANG';
$hesklang['outbox']='AUSGANG';
$hesklang['m_new']='NEUE NACHRICHT';
$hesklang['pg']='Seite anzeigen';
$hesklang['npm']='Keine privaten Nachrichten in diesem Ordner vorhanden.';
$hesklang['m_ena']='Keine Berechtigung diese Nachricht zu lesen.';
$hesklang['mau']='Als ungelesen markieren';
$hesklang['mo1']='Ausgewählte Nachrichten als gelesen markieren';
$hesklang['mo2']='Ausgewählte Nachrichten als ungelesen markieren';
$hesklang['mo3']='Ausgewählte Nachrichten löschen';
$hesklang['delm']='Diese Nachricht löschen';
$hesklang['e_tid']='Fehler beim Erstellen einer eindeutigen Ticket-Nr., die Anfrage bitte später nochmals absenden.';
$hesklang['smmr']='Ausgewählte Nachrichten wurden als gelesen markiert';
$hesklang['smmu']='Ausgewählte Nachrichten wurden als ungelesen markiert';
$hesklang['smdl']='Ausgewählte Nachrichten wurden gelöscht';
$hesklang['show']='Anzeigen';
$hesklang['s_my']='Mir zugewiesen';
$hesklang['s_ot']='Anderen zugewiesen';
$hesklang['s_un']='Nicht zugewiesene Tickets';
$hesklang['s_for']='Suchen nach';
$hesklang['s_in']='Suchen in';
$hesklang['s_incl']='Suchen innerhalb';
$hesklang['find_ticket_by']='Ticket finden';
$hesklang['e_nose']='Keine Zuweisungen ausgewählt, alle Tickets werden angezeigt.';
$hesklang['fsq']='Suchbegriff eingeben';
$hesklang['topen']='Offen';
$hesklang['nms']='Keine Nachricht ausgewählt, nichts zu ändern';
$hesklang['tlo']='Ticket sperren';
$hesklang['tul']='Ticket freigeben';
$hesklang['loc']='Gesperrt';
$hesklang['isloc']='Kunden können gesperrte Tickets weder beantworten noch wiedereröffnen. Ein gesperrtes Ticket wird als gelöst markiert.';
$hesklang['tlock']='Ticket wurde gesperrt';
$hesklang['tunlock']='Ticket wurde freigegeben';
$hesklang['tislock']='Ticket wurde gesperrt - der Kunde kann keine Antwort mehr hinzufügen.';
$hesklang['tislock2']='Ticket wurde gesperrt - es können keine Antworten mehr hinzugefügt werden.';
$hesklang['nsfo']='Keine verwandten Artikel gefunden.';
$hesklang['thist1']='<li class="smaller">%s &#124; Verschoben in Kategorie <b>%s</b> von %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s &#124; Zugewiesen an <b>%s</b> von %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s &#124; Erledigt von %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s &#124; Geöffnet von %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s &#124; Gesperrt von %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s &#124; Freigegeben von %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s &#124; Ticket eröffnet von %s</li>'; // %s = date, user making change
$hesklang['elocked']='Ticket wurde gesperrt oder gelöscht.';
$hesklang['nti2']='Ein neues Ticket einfügen';
$hesklang['nti3']='Dieses Formular dient dazu im Namen eines Kunden ein neues Ticket zu eröffnen.<br /><strong>Bei Name und Email sind jeweils die Kundendaten anzugeben!</strong><br />Das Ticket wird angelegt, als hätte der Kunde es übermittelt.';
$hesklang['addop']='Optionen';
$hesklang['seno']='Dem Kunden eine Email senden';
$hesklang['otas']='Ticket nach dem Anlegen anzeigen';
$hesklang['notn']='Benachrichtigungen';
$hesklang['nomw']='Der Helpdesk wird ein Email senden wenn:';
$hesklang['nwts']='Ein Ticket übermittelt wird mit dem Besitzer:';
$hesklang['ncrt']='Ein Kunde beantwortete ein Ticket mit dem Besitzer:';
$hesklang['ntam']='Mir ein Ticket zugewiesen wird';
$hesklang['npms']='Mir eine private Nachricht gesendet wurde';
$hesklang['support_remove']='Eine Menge Arbeit, Zeit und Geld stecken in der Entwicklung von HESK.<br />Durch den Kauf einer Lizenz wird sowohl der Autor unterstützt, wie auch dann damit der Urheberhinweis <i>Powered by Help Desk Software HESK&trade;</i> aus dem System entfernt';
$hesklang['ycvtao']='Keine Erlaubnis Tickets einzusehen welche anderen zugewiesen sind';
$hesklang['password_not_valid']='Passwort muss mindestens 5 Zeichen lang sein';
$hesklang['lkbs']='Vorschläge aus der Wissensdatenbank werden geladen ..';
$hesklang['auto']='(automatisch)';

// Added in version 2.3
$hesklang['unknown']='Unbekannt';
$hesklang['pcer']='Bitte folgende Fehler bereinigen:';
$hesklang['seqid']='Ticketnummer';
$hesklang['close_action']='Ticket als erledigt markieren'; // Close ACTION
$hesklang['archived']='Markiert';
$hesklang['archived2']='Markiertes Ticket';
$hesklang['add_archive']='Markiere dieses Ticket';
$hesklang['add_archive_quick']='Markiere ausgewählte Tickets';
$hesklang['remove_archive']='Demarkiere dieses Ticket';
$hesklang['remove_archive_quick']='Demarkiere ausgewählte Tickets';
$hesklang['added_archive']='Ticket markiert';
$hesklang['removed_archive']='Ticket demarkiert';
$hesklang['added2archive']='Ticket wurde markiert';
$hesklang['removedfromarchive']='Ticket wurde demarkiert';
$hesklang['num_tickets_tag']='<b>%d</b> Tickets wurden markiert';
$hesklang['num_tickets_untag']='<b>%d</b> wurden demarkiert';
$hesklang['can_add_archive']='Kann Tickets markieren';
$hesklang['disp_only_archived']='Nur markierte Tickets';
$hesklang['search_only_archived']='Nur markierte Tickets';
$hesklang['critical']=' * Kritisch * ';
$hesklang['thist8']='<li class="smaller">%s &#124; Priorität geändert auf <b>%s</b> von %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s &#124; Status geändert auf <b>%s</b> von %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s &#124; Automatisch zugewiesen an %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s &#124; Eingereicht via Emailpiping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='J ';
$hesklang['abbr']['month']='M ';
$hesklang['abbr']['week']='W ';
$hesklang['abbr']['day']='T ';
$hesklang['abbr']['hour']='S ';
$hesklang['abbr']['minute']='M ';
$hesklang['abbr']['second']='S';
// END abberviations
$hesklang['cnsm']='Nachricht konnte nicht gesendet werden an:';
$hesklang['yhbb']='Das System wurde für %s Minuten gesperrt, da mehrfach versucht wurde sich mit falschen Zugangsdaten anzumelden.';
$hesklang['pwdst']='Passwortstärke';
$hesklang['tid_mail']='Bitte E-Mail Adresse angeben, die Ticket-Nr. wird zugesendet:';
$hesklang['rem_email']='Meine E-Mail Adresse merken';
$hesklang['eytid']='Bitte Ticket-Nr. eingeben.';
$hesklang['enmdb']='Die eingegebene E-Mail Adresse stimmt nicht mit jener zu dieser Ticket-Nr. zugewiesenen überein.';
$hesklang['confemail']='Bestätigung der E-Mail Adresse';
$hesklang['confemail2']='Bitte Emaildresse bestätigen';
$hesklang['confemaile']='E-Mail Adresse und Bestätigung stimmen nicht überein';
$hesklang['taso3']='Zugewiesen zu:';
$hesklang['sec_enter']='Bitte unten im Bild angezeigte Ziffern eingeben.';
$hesklang['reload']='Bild neu laden';
$hesklang['verify_q']='SPAM-Schutz:'; // For anti-spam question
$hesklang['verify_i']='SPAM-Schutz:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Mitarbeiter Anmeldung';
$hesklang['vrfy']='Test erfolgreich';
$hesklang['last_update']='Aktualisiert';
$hesklang['cot']='Kritische Tickets nicht erzwingen an den Anfang gereiht zu werden';
$hesklang['def']='Dies als meine Standardansicht setzen';
$hesklang['gbou']='Diese Tickets sind <strong>nicht zugewiesen</strong>:';
$hesklang['gbom']='Tickets an <strong>mich</strong> zugewiesen:';
$hesklang['gboo']='Tickets an <strong>%s</strong> zugewiesen:';
$hesklang['select']=' - - Auswählen - - ';
$hesklang['chngstatus']='Status ändern zu';
$hesklang['perat']='%s von allen Tickets'; // Will change to "23% of all tickets"
$hesklang['viewart']='Artikel anzeigen';
$hesklang['chdp']='Bitte das Standardpasswort im <a href="profile.php">Profil</a> ändern!';
$hesklang['chdp2']='Passwort ändern da das Standardpasswort benutzt wird!';
$hesklang['security']='Sicherheit';
$hesklang['kb_i_art']='Neuer Artikel';
$hesklang['kb_i_art2']='Artikel einfügen';
$hesklang['kb_i_cat']='Neue Kategorie';
$hesklang['kb_i_cat2']='Kategorie einfügen';
$hesklang['gopr']='Wissensdatenbank anzeigen';
$hesklang['kbstruct']='Aufbau der Wissensdatenbank';
$hesklang['cancel']='Abbrechen';
$hesklang['sh']='Meldung ausblenden';
$hesklang['goodkb']='Wie schreibt man gute Artikel für die Wissensdatenbank?';
$hesklang['catset']='Kategorieeinstellungen';
$hesklang['inpr']='Neue Priorität auswählen';
$hesklang['incat']='Neue Kategorie auswählen';
$hesklang['instat']='Neuen Status auswählen';
$hesklang['tsst']='Ticketstatus wurde gesetzt auf %s';
$hesklang['aass']='Autom. Zuweisung';
$hesklang['aaon']='Autom. Zuweisung von Tickets ist aktiviert (zum Deaktivieren klicken)';
$hesklang['aaoff']='Autom. Zuweisung von Tickets ist deaktiviert (zum Aktivieren klicken)';
$hesklang['uaaon']='Autom. Zuweisung von Tickets wurde für den ausgewählten Mitarbeiter aktiviert';
$hesklang['uaaoff']='Autom. Zuweisung von Tickets wurde für den ausgewählten Mitarbeiter deaktiviert';
$hesklang['taasy']='Dieses Ticket wurde mir automatisch zugewiesen';
$hesklang['can_view_unassigned']='Kann nicht zugewiesene Tickets einsehen';
$hesklang['ycovtay']='Es können nur mir zugewiesene Tickets angesehen werden';
$hesklang['in_progress']='In Bearbeitung';
$hesklang['on_hold']='Wartet auf Bearbeitung';
$hesklang['import_kb']='Dieses Ticket in einen Artikel der Wissendatenbank importieren';
$hesklang['import']='Es wird ein <em>privates Ticket</em> in einen <em>öffentlichen Artikel</em> umgewandelt.<br /><br />Unbedingt sicherstellen dass private und sensible Informationen aus dem Betreff sowie dem Artikel selbst entfernt werden!';
$hesklang['tab_1']='Allgemein';
$hesklang['tab_2']='Helpdesk';
$hesklang['tab_3']='Wissensdatenbank';
$hesklang['tab_4']='Benutzerdefinierte Felder';
$hesklang['tab_5']='Sonstiges';
$hesklang['disable']='Deaktivieren';
$hesklang['dat']='Datum &amp; Zeit';
$hesklang['lgs']='Sprache';
$hesklang['onc']='Nur Kunden';
$hesklang['ons']='Für Alle';
$hesklang['viewvtic']='Ticketansicht';
$hesklang['reqetv']='E-Mail Adresse wird benötigt um Tickets einsehen zu können';
$hesklang['banlim']='Limit fehlerhafte Loginversuche';
$hesklang['banmin']='Sperrzeit (Minuten)';
$hesklang['subnot']='Übermittlungshinweis';
$hesklang['subnot2']='Zeigt Übermittlungshinweis den Kunden, welche ein Ticket absenden';
$hesklang['eseqid']='Aufeinanderfolgende IDs';
$hesklang['sconfe']='Emailbestätigung';
$hesklang['saass']='Autom. Zuweisung von Tickets';
$hesklang['swyse']='WYSIWYG-Editor';
$hesklang['hrts']='HESK-Bewertung';
$hesklang['hrts2']='Zeigt einen Bewertungslink im Admin-Panel';
$hesklang['emlpipe']='Email Piping';
$hesklang['emlsend2']='Versende Emails über';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP-Server';
$hesklang['smtph']='SMTP-Host';
$hesklang['smtpp']='SMTP-Port';
$hesklang['smtpu']='SMTP-Benutzername';
$hesklang['smtpw']='SMTP-Passwort';
$hesklang['smtpt']='SMTP-Zeitbeschränkung';
$hesklang['other']='Andere';
$hesklang['features']='Funktionen';
$hesklang['can_view_online']='Kann angemeldete Mitarbeiter sehen';
$hesklang['online']='Angemeldet';
$hesklang['offline']='Abgemeldet';
$hesklang['onlinep']='Mitarbeiter angemeldet'; // For display in footer
$hesklang['sonline']='Mitarbeiter angemeldet'; // For settings page
$hesklang['sonline2']='Zeigt angemeldete Mitarbeiter - Limit (Minuten):'; // For settings page
$hesklang['gb']='Gruppieren nach';
$hesklang['dg']='Nicht gruppieren';
$hesklang['err_dpi']='Datenbank %s enthält nicht alle HESK-Tabellen mit dem Vorzeichen %s, daher wurden Änderungen nicht gespeichert.';
$hesklang['err_dpi2']='Tabellen nicht gefunden:';
$hesklang['sme']='SMTP-Fehler';
$hesklang['scl']='SMTP-Verbindungsprotokoll';
$hesklang['dnl']='Download';
$hesklang['dela']='Diesen Anhang löschen';
$hesklang['pda']='Soll dieser Anhang wirklich gelöscht werden?';
$hesklang['thist12']='<li class="smaller">%s &#124; Anhang %s gelöscht von %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Mehr Optionen';
$hesklang['lopt']='Weniger Optionen';
$hesklang['meml']='Mehrere E-Mail Adresse';
$hesklang['meml2']='Erlaubt Kunden mehrere E-Mail Adressen eingeben zu können.';

// Added in version 2.4
$hesklang['catd']='(Kategorie gelöscht)';
$hesklang['noopen']='Keine offenen Tickets zu dieser E-Mail Adresse gefunden.';
$hesklang['maxopen']='Das Maximum möglicher offener Tickets wurde erreicht (%d von %d). Neue Tickets sind erst wieder möglich nachdem offene Tickets erledigt wurden.';
$hesklang['ntnote']='Andere Person hat eine Notiz zu einem mir zugewiesenen Ticket hinzugefügt';
$hesklang['cat_public']='Diese Kategorie ist ÖFFENTLICH (Klicken, um auf INTERN zu ändern)';
$hesklang['cat_private']='Diese Kategorie ist INTERN (Klicken, um auf ÖFFENTLICH zu ändern)';
$hesklang['cat_aa']='Autom. Zuweisung von Tickets in diese Kategorie.';
$hesklang['cat_type']='Diese Kategorie auf INTERN setzen (nur Mitarbeiter können diese dann auswählen).';
$hesklang['caaon']='Autom. Zuweisung wurde für diese Kategorie aktiviert';
$hesklang['caaoff']='Autom. Zuweisung wurde für diese Kategorie deaktiviert';
$hesklang['cpub']='Kategorieart auf ÖFFENTLICH geändert';
$hesklang['cpriv']='Kategorieart auf INTERN geändert';
$hesklang['cpric']='Kunden können interne Kategorien nicht auswählen, nur Mitarbeiter!';
$hesklang['user_aa']='Autom. Zuweisung von Tickets für diesen Mitarbeiter aktivieren.';
$hesklang['attach_size']='Maximale Dateigröße';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='Byte';
$hesklang['kilobytes']='Kilobyte';
$hesklang['megabytes']='Megabyte';
$hesklang['gigabytes']='Gigabyte';
$hesklang['smtpssl']='SSL-Protokoll';
$hesklang['smtptls']='TLS-Protokoll';
$hesklang['oo']='Nur offene Tickets anzeigen';
$hesklang['ool']='Zeigt nur offene Tickets in der &quot;Tracking-ID vergessen?&quot; Email auf';
$hesklang['mop']='Max. offene Kundentickets';
$hesklang['rord']='Reihenfolge der Antworten';
$hesklang['newbot']='Neueste Antwort unten';
$hesklang['newtop']='Neueste Antwort oben';
$hesklang['ford']='Antwortformular';
$hesklang['formbot']='Anzeige des Formulars unten';
$hesklang['formtop']='Anzeige des Formulars oben';
$hesklang['mysqlv']='MySQL-Version';
$hesklang['phpv']='PHP-Version';
$hesklang['csrt']='Aktuelle Serverzeit:';
$hesklang['listp']='Anzeige von internen Artikeln';
$hesklang['listd']='Anzeige von Artikelentwürfen';
$hesklang['artp']='Interne Artikel';
$hesklang['artd']='Artikelentwürfe';
$hesklang['kb_no_part']='Keine internen Artikel in der Wissensdatenbank.';
$hesklang['kb_no_dart']='Keine Artikelentwürfe in der Wissensdatenbank.';
$hesklang['attpri']='Kein Zugriff auf diesen Anhang.';
$hesklang['can_merge_tickets']='Tickets zusammenlegen';
$hesklang['mer_selected']='Ausgewählte Tickets zusammenlegen';
$hesklang['merged']='Ausgewählte Tickets wurden zu Einem zusammengelegt.';
$hesklang['merge_err']='Es gab ein Problem beim Zusammenlegen der Tickets:';
$hesklang['merr1']='mindestens zwei Tickets auswählen.';
$hesklang['merr2']='Zielticket nicht gefunden.';
$hesklang['merr3']='Ticket in einer Kategorie, auf die kein Zugriff erlaubt ist.';
$hesklang['tme']='Ticket %s wurde mit diesem Ticket (%s) zusammengelegt.';
$hesklang['tme1']='Ticket %s wurde mit Ticket %s zusammengelegt';
$hesklang['tme2']='Um auf Ticket %s zugreifen zu können bitte die passende E-Mail Adresse eingeben.';
$hesklang['eyou']='Profilseite verwenden um eigene Einstellungen zu bearbeiten.';
$hesklang['npea']='Keine Berechtigung um diesen Benutzer bearbeiten zu können.';
$hesklang['duplicate_user']='Dieser Benutzername ist nicht möglich - bitte einen Anderen wählen.';
$hesklang['kw']='Stichwörter';
$hesklang['kw1']='(optional - mit Leerzeichen, Komma oder neuer Zeile trennen)';
$hesklang['type_not_allowed']='Dateien, die auf <b>%s</b> enden, werden nicht akzeptiert (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Kunde hat diese Antwort noch nicht gelesen.';
$hesklang['sticky']='Artikel als &quot;Wichtig&quot; markieren';
$hesklang['stickyon']='Artikel auf &quot;Wichtig&quot; ändern';
$hesklang['stickyoff']='Ändere Artikel auf &quot;Normal&quot;';
$hesklang['ason']='Artikel als &quot;Wichtig&quot; markiert';
$hesklang['asoff']='Artikel als &quot;Normal&quot; markiert';
$hesklang['ts']='Bearbeitungszeit';
$hesklang['start']='Start / Stopp';
$hesklang['reset']='Zurücksetzen';
$hesklang['save']='Speichern';
$hesklang['hh']='Stunden';
$hesklang['mm']='Minuten';
$hesklang['ss']='Sekunden';
$hesklang['thist']='Ticketverlauf';
$hesklang['thist13']='<li class="smaller">%s &#124; Zusammengelegt mit Ticket %s von %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s &#124; Bearbeitungszeit aktualisiert auf %s von %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s &#124; Eingereicht von %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s &#124; Eingereicht über POP3-Abruf</li>';
$hesklang['twu']='Bearbeitungszeit wurde aktualisiert.';
$hesklang['autoss']='Autom. Start der Zeitzählers wenn ein Ticket geöffnet wird';
$hesklang['ful']='Dateibeschränkungen';
$hesklang['ufl']='Es dürfen nur Dateien mit folgender Endung hochgeladen werden:';
$hesklang['nat']='Maximale Anzahl an Anhängen';
$hesklang['mfs']='Maximale Größe pro Anhang:';
$hesklang['lps']='Spracheinstellung wurde gespeichert';
$hesklang['sav']='Artikelaufrufe zeigen';
$hesklang['sad']='Artikeldatum zeigen';
$hesklang['emp']='Installierte PHP-Version hat keine MySQL-Unterstützung (mySQLi) aktiviert';
$hesklang['epd']='[HESK] E-MAIL-PIPING IST IN DEN EINSTELLUNGEN DEAKTIVIERT';
$hesklang['pfd']='[HESK] POP3-ABRUF IST IN DEN EINSTELLUNGEN DEAKTIVIERT';
$hesklang['pem']='[Zugeleitete Mail]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Kunde]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-Mail Adresse';
$hesklang['pop3']='POP3-Abruf';
$hesklang['pop3h']='POP3-Host';
$hesklang['pop3p']='POP3-Port';
$hesklang['pop3tls']='TLS-Protokoll';
$hesklang['pop3u']='POP3-Benutzername';
$hesklang['pop3w']='POP3-Passwort';
$hesklang['pop3e']='POP3-Fehler';
$hesklang['pop3log']='POP3-Verbindungs-Log';
$hesklang['mysqltest']='Teste MySQL-Verbindung';
$hesklang['smtptest']='Teste SMTP-Verbindung';
$hesklang['pop3test']='Teste POP3-Verbindung';
$hesklang['contest']='Teste Verbindung, dies kann etwas dauern ...';
$hesklang['conok']='Verbindung erfolgreich!';
$hesklang['conokn']='Falls der Mailserver Benutzername und Passwort benötigt, werden Emails ohne diese nicht versendet werden!';
$hesklang['saving']='Speichern der Einstellungen, bitte warten ...';
$hesklang['sns']='Einstellungen wurden gespeichert, aber einige Funktionen wurden deaktiviert da dazugehörige Tests fehlschlugen.';
$hesklang['looph']='Maximale Treffer';
$hesklang['loopt']='Zeitintervall';
$hesklang['didum']='Wurde das gemeint %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Ja, bitte korrigieren';
$hesklang['nole']='Nein, bitte so belassen';
$hesklang['sconfe2']='Email Bestätigungsfeld im Formular &quot;Ein Ticket übermitteln&quot; anzeigen';
$hesklang['oln']='Bisheriger Name:';
$hesklang['nen']='Neuer Name:';
$hesklang['use_form_below']='<i>Pflichtfelder sind gekennzeichnet mit einem</i>';
$hesklang['esf']='Konnte Emailbenachrichtigung nicht versenden.';
$hesklang['qrr']='(zitierte Antwort entfernt)';
$hesklang['remqr']='Zitierte Antwort Löschen';
$hesklang['remqr2']='Zitierte Antwort aus Kundenemails Löschen';
$hesklang['suge']='Erkenne Tippfehler in E-Mail Adressen';
$hesklang['epro']='Emailanbieter';
$hesklang['email_noreply']='&quot;Von:&quot; E-Mail Adresse';
$hesklang['email_name']='&quot;Von:&quot; Name';
$hesklang['vscl']='Serverkonfigurationsbeschränkungen';
$hesklang['fnuscphp']='Hochladen der Datei gescheitert, nochmals mit Kleinerer oder ohne probieren.';
$hesklang['redv']='Standardansicht zurücksetzen';
$hesklang['fatte1']='Die Anhangseinstellung &quot;Anzahl pro Eintrag&quot; übersteigt das erlaubte Serverlimit!';
$hesklang['fatte2']='Die maximale Dateigröße für Anhänge übersteigt das erlaubte Serverlimit!';
$hesklang['fatte3']='Der Server erlaubt keine derart großen Beiträge. Bitte Anzahl oder Dateigröße der Anhänge verringern!';
$hesklang['embed']='Eingebettete Dateien';
$hesklang['embed2']='Eingebettete Dateien als Anhänge speichern';
$hesklang['emrem']='(Bild entfernt)';
$hesklang['hdemo']='(AUSGEBLENDET IM DEMO-MODUS)';
$hesklang['ddemo']='Funktion ist im DEMO-Modus deaktiviert!';
$hesklang['sdemo']='Speichern von Änderungen ist im DEMO-Modus deaktiviert';
$hesklang['hud']='HESK ist aktuell';
$hesklang['hnw']='Aktualisierung verfügbar';
$hesklang['getup']='HESK aktualisieren';
$hesklang['updates']='Aktualisierungen';
$hesklang['updates2']='Autom. auf HESK Aktualisierungen prüfen.';

// Added in version 2.5.0
$hesklang['attdel']='Diese Datei wurde vom Server gelöscht und steht zum Download nicht mehr zur Verfügung';
$hesklang['dsen']='Keine Emailbenachrichtigung zu dieser Antwort an den Kunden senden';
$hesklang['attrem']='* Einige angehängte Dateien wurden entfernt *';
$hesklang['attnum']='Maximale Anzahl erreicht: %s'; // %s will show attachment name
$hesklang['attsiz']='Datei zu groß: %s'; // %s will show attachment name
$hesklang['atttyp']='Dateiart nicht erlaubt: %s'; // %s will show attachment name
$hesklang['adf']='Verzeichnis für Admindateien';
$hesklang['atf']='Verzeichnis für Anhänge';
$hesklang['err_adf']='Der gewählte Adminordner (%s) existiert nicht!'; // %s will show folder name
$hesklang['err_atf']='Der gewählte Anhangsordner (%s) existiert nicht!'; // %s will show folder name
$hesklang['err_atr']='Der gewählte Anhangsordner (%s) ist nicht beschreibbar!'; // %s will show folder name
$hesklang['fatt']='An diese Nachricht angehängte Dateien:';
$hesklang['wrepo']='Bitte eine Antwort schreiben nachdem das Ticket wiedereröffnet wurde.';
$hesklang['ktool']='&raquo; Wissensdatenbank-Werkzeuge';
$hesklang['uac']='Prüfe und aktualisiere die Artikelzählung';
$hesklang['acv']='Artikelzählung wurde geprüft';
$hesklang['xyz']='Anzahl an öffentlichen, internen und im Entwurf befindlichen Artikeln einer Kategorie.';
$hesklang['reports_tab']='Berichte erstellen'; // Tab title
$hesklang['can_run_reports_full']='Kann Berichte erstellen (alle)';
$hesklang['can_export']='Kann Tickets exportieren';
$hesklang['roo']='<em>(nur mir selbst zugeordnete Tickets sind im Bericht enthalten)</em>';
$hesklang['shu']='Gekürzte Linkanzeige';
$hesklang['export']='Tickets exportieren'; // Tab title
$hesklang['export_btn']='Tickets exportieren'; // Button title
$hesklang['export_intro']='Mit diesem Werkzeug werden Tickets in eine XML-Datei exportiert welche z.B. in Excel geöffnet werden kann.';
$hesklang['stte']='Tickets für Export auswählen';
$hesklang['dtrg']='Zeitspanne';
$hesklang['sequentially']='Fortlaufend '; // Order tickets: Sequentially
$hesklang['ede']='Konnte Exportordner nicht erstellen. Bitte Ordner <b>export</b> innerhalb des Anhangsordners manuell erstellen und dieses für PHP beschreibbar setzen (per FTP - CHMOD auf 0755 [manche Server 0777]).';
$hesklang['eef']='Konnte Exportdatei nicht erstellen, da innerhalb des Exportordners keine Schreibrechte vorhanden sind.';
$hesklang['inite']='Starte den Export';
$hesklang['gXML']='Erstelle XML-Datei';
$hesklang['nrow']='Anzahl der exportierten Zeilen: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Komprimierung der Datei in ein ZIP-Archiv';
$hesklang['eZIP']='Fehler beim Erstellen des ZIP-Archivs';
$hesklang['fZIP']='Komprimierung der Datei abgeschlossen';
$hesklang['pmem']='Arbeitsspeichernutzung (Spitzenlast): %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; HIER KLICKEN FÜR DEN DOWNLOAD DER EXPORTDATEI &laquo;';
$hesklang['n2ex']='Keine Tickets gefunden welche den Kriterien entsprechen, daher nichts zum Exportieren!';
$hesklang['sp']='SPAM-Vorbeugung'; // For settings page
$hesklang['sit']='-&gt; Bildtyp';
$hesklang['sis']='Einfaches Bild';
$hesklang['rcpb']='Site Schlüssel (Öffentlicher Schlüssel)';
$hesklang['rcpv']='Geheimer Schlüssel (Privater Schlüssel)';
$hesklang['pop3keep']='Kopie auf Mailserver lassen';
$hesklang['beta']='(TESTVERSION)';
$hesklang['maxpost']='Es wurde wahrscheinlich versucht mehr Daten als dieser Server akzeptiert, zu übermitteln.<br /><br />Bitte nochmals mit kleineren oder keinen Anhängen probieren.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Falsche Eingabe. Bitte nochmals versuchen.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Ticket geschlossen/erledigt';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mär';
$hesklang['ms04']='Apr';
$hesklang['ms05']='Mai';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Aug';
$hesklang['ms09']='Sep';
$hesklang['ms10']='Okt';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dez';
$hesklang['sdf']='Übertragenes Datumsformat';
$hesklang['lcf']='Aktualisiertes Datumsformat';
$hesklang['lcf0']='Kurzbeschreibung';
$hesklang['lcf1']='Datum und Zeit';
$hesklang['lcf2']='HESK Style';
$hesklang['ticket_tpl']='Ticket-Vorlage';
$hesklang['can_man_ticket_tpl']='Ticket-Vorlagen verwalten'; // Permission title
$hesklang['ticket_tpl_man']='Ticket-Vorlagen verwalten'; // Page and link title
$hesklang['ticket_tpl_intro']='Erstellen und verändern von Ticketvorlagen welche verwendet werden können um schnell neue Tickets aus dem Adminbereich zu erstellen.';
$hesklang['no_ticket_tpl']='Keine Ticketvorlagen';
$hesklang['ticket_tpl_title']='Titel';
$hesklang['delete_tpl']='Soll diese Vorlage sicher gelöscht werden - keine Wiederherstellung möglich!';
$hesklang['new_ticket_tpl']='Hinzufügen und Bearbeiten einer Ticketvorlage';
$hesklang['ticket_tpl_add']='Erstellen einer neuen Ticketvorlage';
$hesklang['ticket_tpl_edit']='Bearbeiten der gewählten Ticketvorlage';
$hesklang['save_ticket_tpl']='Ticketvorlage speichern';
$hesklang['ticket_tpl_saved']='Ticketvorlage wurde gespeichert und kann jetzt angewendet werden';
$hesklang['ticket_tpl_removed']='Ausgewählte Ticketvorlage wurde aus der Datenbank entfernt';
$hesklang['ticket_tpl_not_found']='Ticketvorlage nicht gefunden';
$hesklang['sel_ticket_tpl']='Bitte Ticketvorlage zum bearbeiten auswählen';
$hesklang['ent_ticket_tpl_title']='Bitte einen Vorlagentitel eingeben';
$hesklang['ent_ticket_tpl_msg']='Bitte den Text der Vorlage angeben';
$hesklang['ticket_tpl_id']='Fehlende Ticketvorlagen Nr.';
$hesklang['select_ticket_tpl']='Eine Ticketvorlage wählen';
$hesklang['list_tickets_cat']='Alle Tickets aus dieser Kategorie anzeigen';
$hesklang['def_msg']='[Keine Nachricht]';
$hesklang['emlreqmsg']='Nachricht benötigt';
$hesklang['emlreqmsg2']='Piped/geholte Emails ohne Nachricht ignorieren';
$hesklang['relart']='Verwandte Artikel'; // Title of related articles box
$hesklang['s_relart']='Verwandte Artikel'; // On settings page
$hesklang['tab_7']='Ticketliste';
$hesklang['fitl']='Felder der Ticketliste';
$hesklang['submitted']='Eingesendet';
$hesklang['clickemail']='Ansehen';
$hesklang['set_pri_to']='Priorität setzen auf:'; // Action below the ticket list
$hesklang['pri_set_to']='Priorität wurde gesetzt auf:';
$hesklang['cat_pri']='Die Kategorie-Priorität wird verwendet wenn es Kunden nicht erlaubt ist einem Ticket eine Priorität zuzuordnen das über die Kundenoberfläche gelegt wurde';
$hesklang['cat_pri_info']='Kunden dürfen eine Priorität setzen, daher wird die Kategorien-Priorität ignoriert.<br /><br />Um stattdessen die Kategorienpriorität zu verwenden, folgende Optionen in den HESK Einstellungen auf AUS setzen:';
$hesklang['def_pri']='Kategoriepriorität:';
$hesklang['ch_cat_pri']='Kategoriepriorität setzen';
$hesklang['cat_pri_ch']='Kategoriepriorität wurde gesetzt auf:';
$hesklang['err_dbversion']='Zu alte MySQL Version:';
$hesklang['ip_whois']='IP Whois';
$hesklang['ednote']='Notiz bearbeiten';
$hesklang['ednote2']='Notiz gespeichert';
$hesklang['perm_deny']='Zugriff verweigert';
$hesklang['mis_note']='Fehlende Notiz Nr.';
$hesklang['no_note']='Notiz mit Nr. nicht gefunden';
$hesklang['sacl']='als Entwurf Speichern';
$hesklang['reply_saved']='Antwort wurde für später gespeichert.';
$hesklang['submit_as']='Absenden als:';
$hesklang['sasc']='Absenden als Kundenantwort';
$hesklang['creb']='Kundenantwort erstellt von:';
$hesklang['show_select']='Zeige &quot;Klicken zum Auswählen&quot; als Standard Option';
// Settings
$hesklang['mms']='Wartungsmodus';
$hesklang['mmd']='Wartungsmodus einschalten';
// Customer notice
$hesklang['mm1']='Wir bedauern aber aktuell findet eine Wartung statt';
$hesklang['mm2']='Um notwendige Wartungsarbeiten durchführen zu können, ist der Helpdesk vorübergehend nicht erreichbar.';
$hesklang['mm3']='Wir bitten um Entschuldigung und bitten um einen erneuten, späteren Versuch.';
// Staff notice
$hesklang['mma1']='Wartungsmodus ist aktiv!';
$hesklang['mma2']='Kunden können den Helpdesk derzeit nicht nutzen.';
$hesklang['tools']='Werkzeuge';
$hesklang['banemail']='Verbotene E-Mail Adressen';
$hesklang['banemail_intro']='Das Einreichen von Tickets durch bestimmte E-Mail Adressen verhindern';
$hesklang['no_banemails']='<i>Keine verbotenen E-Mail Adressen.</i>';
$hesklang['eperm']='Dauerhafte verbotene E-Mail Adressen:';
$hesklang['bananemail']='Zu verbietende E-Mail Adressen';
$hesklang['savebanemail']='Diese E-Mail Adresse verbieten';
$hesklang['enterbanemail']='E-Mail Adresse eingeben welche verboten werden soll';
$hesklang['validbanemail']='Gültige E-Mail Adresse (<i>john.doe@domain.com</i>) oder Domain (<i>@domain.com</i>) eingeben';
$hesklang['email_banned']='Die E-Mail Adresse <i>%s</i> wurde verboten und HESK wird keine weiteren Tickets von dieser akzeptieren.'; // %s will be replaced with email
$hesklang['emailbanexists']='Die E-Mail Adresse <i>%s</i> ist schon verboten.'; // %s will be replaced with email
$hesklang['email_unbanned']='Verbotene E-Mail Adresse entfernt';
$hesklang['banby']='Verboten durch';
$hesklang['delban']='Verbot aufheben';
$hesklang['delban_confirm']='Dieses Verbot aufheben?';
$hesklang['baned_e']='Neue Tickets mit dieser E-Mail Adresse sind nicht mehr erlaubt';
$hesklang['baned_ip']='Von dieser IP wurde die Verwendung dieses Helpdesks unterbunden';
$hesklang['can_ban_emails']='Kann E-Mail Adressen verbieten';
$hesklang['can_unban_emails']='Kann verbotene E-Mail Adressen wieder zulassen (schaltet -Kann E-Mail Adressen verbieten- ein)';
$hesklang['eisban']='Diese E-Mail Adresse ist verboten';
$hesklang['click_unban']='Hier klicken um das Verbot aufzuheben';
$hesklang['banip']='Verbotene IPs';
$hesklang['banip_intro']='Besucher von verbotenen IP-Adressen können weder Tickets sehen noch einreichen und können sich nicht im Helpdesk anmelden.';
$hesklang['ipperm']='Dauerhaft verbotene IP:';
$hesklang['iptemp']='Vorübergehend verbotene IPs wegen fehlerhafter Logins:';
$hesklang['savebanip']='Diese IP verbieten';
$hesklang['no_banips']='<i>Keine IPs verboten.</i>';
$hesklang['bananip']='Zu verbietende IP-Adresse';
$hesklang['banex']='Beispiele:';
$hesklang['iprange']='IP Bereich';
$hesklang['ippermban']='Diese IP dauerhaft verbieten';
$hesklang['enterbanip']='IP-Adresse oder Bereich eingeben welcher verboten werden soll';
$hesklang['validbanip']='Gültige IP-Adresse oder gültigen IP-Bereich eingeben';
$hesklang['ip_banned']='Die IP-Adresse <i>%s</i> wurde verboten und HESK wird keine weiteren Tickets von dieser IP-Adresse akzeptieren.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Der IP-Bereich <i>%s</i> wurde verboten und HESK wird keine weiteren Tickets aus diesem IP-Bereich akzeptieren.'; // %s will be replaced with IP
$hesklang['ipbanexists']='Die IP-Adresse <i>%s</i> ist schon verboten.'; // %s will be replaced with IP
$hesklang['iprbanexists']='Der IP-Bereich <i>%s</i> ist schon verboten.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP Verbot entfernt';
$hesklang['ip_tempun']='Vorübergehend verbotene IP entfernt';
$hesklang['can_ban_ips']='Kann IPs verbieten';
$hesklang['can_unban_ips']='Kann verbotene IPs wieder zulassen (schaltet -Kann IPs verbieten- ein)';
$hesklang['ipisban']='Diese IP-Adresse ist verboten.';
$hesklang['m2e']='Ablauf in (Minuten)';
$hesklang['info']='Info';
$hesklang['sm_title']='Service-Nachrichten';
$hesklang['sm_intro']='Im Kundenbereich eine Service-Nachricht anzeigen, z.B. um auf bekannte Probleme hinzuweisen oder über wichtige Neuigkeiten zu informieren.';
$hesklang['can_service_msg']='Kann Service-Nachrichten bearbeiten';
$hesklang['new_sm']='Neue Service-Nachricht';
$hesklang['edit_sm']='Service-Nachricht bearbeiten';
$hesklang['ex_sm']='Vorhandene Service-Nachrichten';
$hesklang['sm_author']='Verfasser';
$hesklang['sm_type']='Art';
$hesklang['sm_published']='Veröffentlicht';
$hesklang['sm_draft']='Entwurf';
$hesklang['sm_style']='Stil';
$hesklang['sm_none']='Keiner';
$hesklang['sm_success']='Erfolg';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Notiz';
$hesklang['sm_error']='Fehler';
$hesklang['sm_save']='Servicenachricht speichern';
$hesklang['sm_preview']='Vorschau der Servicenachricht';
$hesklang['sm_mtitle']='Titel';
$hesklang['sm_msg']='Nachricht';
$hesklang['sm_e_title']='Titel der Service-Nachricht';
$hesklang['sm_e_msg']='Text der Service-Nachricht muss angegeben werden';
$hesklang['sm_e_id']='Fehlende Nachrichten Nr.';
$hesklang['sm_added']='Eine neue Servicenachricht wurde hinzugefügt';
$hesklang['sm_deleted']='Servicenachricht gelöscht';
$hesklang['sm_not_found']='Diese Servicenachricht existiert nicht';
$hesklang['no_sm']='Keine Servicenachrichten';
$hesklang['del_sm']='Diese Servicenachricht löschen?';
$hesklang['sm_mdf']='Servicenachricht wurde gespeichert';
$hesklang['sska']='Zeige vorgeschlagene Artikel';
$hesklang['taws']='Diese Artikel wurden vorgeschlagen:';
$hesklang['defaults']='Standards';
$hesklang['pncn']='Option Kundenbenachrichtigung im Bereich neuer Tickets auswählen';
$hesklang['pncr']='Option Kundenbenachrichtigung im Ticket-Antwort Bereich auswählen';
$hesklang['pssy']='Zeigen, welche Artikel der Wissensdatenbank Kunden vorgeschlagen wurden';
$hesklang['ccct']='Vom Kunden erledigt';
$hesklang['custnot']='Kunden benachrichtigen wenn';
$hesklang['notnew']='Ein neues Ticket eingereicht wird';
$hesklang['notclo']='Ein Ticket als erledigt markiert wird';
$hesklang['enn']='Außer für Email Piping/POP3 wenn im Betreff vorkommt:';
$hesklang['spamn']='SPAM Hinweis';
$hesklang['spam_inbox']='<span style="color:red"><b>Keine Bestätigungsmail?</b><br />Wir haben eine Bestätigungsmail an die angegebene E-Mail Adresse gesendet. Sollten diese nicht innerhalb weniger Minuten ankommen, bitte das Junk- oder Spamverzeichnis überprüfen. Dann diese Nachricht als <b>Kein SPAM</b> markieren um zukünftig Empfangsprobleme zu vermeiden.</span>';
$hesklang['ekb_n']='<b>NEIN</b>, Wissensdatenbank ausschalten';
$hesklang['ekb_y']='<b>JA</b>, Wissensdatenbank einschalten';
$hesklang['ekb_o']='<b>JA</b>, HESK nur als Wissensdatenbank verwenden (<i>Helpdesk abschalten</i>)';
$hesklang['kb_set']='Einstellungen der Wissensdatenbank';
$hesklang['kbo1']='Nur-Wissensdatenbank Modus';
$hesklang['kbo2']='<br /><br />Benutzer können keine neuen Tickets einreichen und werden direkt zur Wissensdatenbank weitergeleitet.';
$hesklang['fpass']='Passwort vergessen?';
$hesklang['passr']='Passwort zurücksetzen';
$hesklang['passa']='Benutzern erlauben ein vergessenes Passwort per Email zurückzusetzen';
$hesklang['passe']='Bitte die E-Mail Adresse eingeben';
$hesklang['passs']='Passwort zurücksetzen';
$hesklang['noace']='Es wurde kein Konto mit dieser E-Mail Adresse gefunden';
$hesklang['pemls']='Wir haben ein Email mit Hinweisen wie das Passwort zurückgesetzt wird, zugesendet';
$hesklang['reset_password']='Helpdesk Passwort zurücksetzen'; // Email subject
$hesklang['ehash']='Ungültiger oder abgelaufener Link um ein Passwort zurückzusetzen';
$hesklang['ehaip']='Falsche IP-Adresse. Passwort kann nur von der IP-Adresse zurückgesetzt werden, welche dies angefordert hat.';
$hesklang['resim']='<b>Im Formular unten das neues Passwort eingeben</b>';
$hesklang['permissions']='Rechte';
$hesklang['atype']='Kontoart';
$hesklang['astaff']='Mitarbeiter';
$hesklang['oon1']='Mir nur OFFENE Tickets senden';
$hesklang['oon2']='Mir ALLE meine Tickets senden';
$hesklang['anyown']='Jeder Inhaber';
$hesklang['pfr']='Eine andere POP3 Aufgabe läuft noch.';
$hesklang['pjt']='Zeitüberschreitung der Aufgabe';
$hesklang['pjt2']='Minuten nach Start';
$hesklang['nkba']='Die Suche in der Wissensdatenbank benötigt eine gewisse Artikelzahl um richtig zu arbeiten.<br /><br />Weitere Artikel der Wissensdatenbank hinzuzufügen um die Suche und Artikelvorschläge zu verbessern.';
$hesklang['saa']='Wichtige Artikel werden oben in der Artikelliste angezeigt';
$hesklang['yhbr']='Aufgrund zu vieler Antworten auf ein Ticket, wurde dieses Konto für %s Minuten vom System blockiert.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='de';

// Added in version 2.7.0
$hesklang['imap']='IMAP Abruf';
$hesklang['imaph']='IMAP Host';
$hesklang['imapp']='IMAP Port';
$hesklang['enc']='Verschlüsselung';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Keine';
$hesklang['imapu']='IMAP Benutzername';
$hesklang['imapw']='IMAP Passwort';
$hesklang['imaptest']='Test IMAP Verbindung';
$hesklang['ifd']='[HESK] IMAP ABRUF IST IN DEN EINSTELLUNGEN AUSGESTELLT';
$hesklang['iei']='[HESK] PHP IMAP Erweiterung ist nicht installiert.';
$hesklang['ifr']='Ein IMAP Abruf ist gerade in Arbeit ..';
$hesklang['arp']='Seite automatisch aktualisieren';
$hesklang['arpp']='Automatische Seiten-Aktualisierung alle:';
$hesklang['seconds']='Sekunden';
$hesklang['minutes']='Minuten';
$hesklang['atbr']='Dieses Ticket muss zugewiesen werden bevor es beantwortet werden kann.';
$hesklang['attm']='Mir dieses Ticket zuweisen';
$hesklang['owneed']='Besitzer erforderlich';
$hesklang['taat']='Dieses Ticket ist bereits an <b>%s</b> zugeordnet';
$hesklang['scoy']='Sicher dieses Ticket slebst zuweisen?';
$hesklang['scot']='Sicher dieses Ticket an <b>%s</b> zuweisen?';
$hesklang['ycto']='JA, Besitzer ändern';
$hesklang['ncto']='NEIN, aktuellen Besitzer behalten';
$hesklang['fass']='Besitzer erforderlich';
$hesklang['req_sub']='Betreff erforderlich';
$hesklang['req_msg']='Nachricht erforderlich';
$hesklang['req_email']='E-Mail Adresse erforderlich';
$hesklang['default_subject']='Ticket von %s';
$hesklang['off-hide']='Ausblenden bei Kundenansicht';
$hesklang['not_valid_email']='Entweder gültige Emaildresse eingeben oder Feld leer lassen';
$hesklang['write_down']='<span style="color:red">Wir empfehlen die Ticket Nr. zum späteren Nachschlagen aufzuschreiben.</span>';
$hesklang['re_confirm1']='Wenn diese Option deaktiviert ist, wird auch die Option "Emails erforderlich um Tickets zu sehen" unter "Sicherheit" deaktiviert .. fortfahren?';
$hesklang['re_confirm2']='Wenn diese Option aktiviert ist, wird auch "Email erforderlich" unter "Einstellungen" aktiviert .. fortfahren?';
$hesklang['can_email_tpl']='Emailvorlagen bearbeiten';
$hesklang['et_title']='Email Vorlagen';
$hesklang['et_intro']='Emailsvorlagen ändern welche an Mitarbeiter und Kunden gesendet werden';
$hesklang['file']='Datei';
$hesklang['efile']='Datei bearbeiten';
$hesklang['rdesc']='(Empfänger) Beschreibung';
$hesklang['desc_forgot_ticket_id']='(Kunde) Ticket Nr. vergessen';
$hesklang['desc_new_reply_by_staff']='(Kunde) Neue Mitarbeiterantwort';
$hesklang['desc_new_ticket']='(Kunde) Ticket erhalten';
$hesklang['desc_ticket_closed']='(Kunde) Ticket geschlossen/gelöst';
$hesklang['desc_category_moved']='(Mitarbeiter) Ticket in eine neue Kategorie verschoben';
$hesklang['desc_new_reply_by_customer']='(Mitarbeiter) Neue Kundenantwort';
$hesklang['desc_new_ticket_staff']='(Mitarbeiter) Neues Ticket eingereicht';
$hesklang['desc_ticket_assigned_to_you']='(Mitarbeiter) wurde ein neues Ticket zugewiesen';
$hesklang['desc_new_pm']='(Mitarbeiter) Neue Private Nachricht';
$hesklang['desc_new_note']='(Mitarbeiter) Neue Notiz auf einem mir zugewiesenen Ticket';
$hesklang['desc_reset_password']='(Mitarbeiter) Passwort zurücksetzen';
$hesklang['etfm']='Eine oder mehrere Emailvorlagen fehlen.<br /><br />Bitte sicherstellen, dass alle Emailvorlagen im Ordner <i>/language/%s/emails</i> gespeichert sind!';
$hesklang['etfw']='Einige Emailvorlagen sind nicht beschreibbar!<br><br>Bitte die Dateirechte im Ordner <i>/language/%s/emails</i> überprüfen.<br><br>Auf *nix-Servern wird 0644 (bzw. 0666 rw-rw-rw-) benötigt';
$hesklang['et_e_id']='Fehlende Vorlagennr.';
$hesklang['et_fm']='Diese Emailvorlagendatei ist nicht vorhanden';
$hesklang['et_fw']='Diese Emailvorlagendatei ist nicht beschreibbar';
$hesklang['et_save']='Emailvorlage speichern';
$hesklang['updated_on']='Aktualisiert am';
$hesklang['ticket_url']='Ticket URL';
$hesklang['pm_url']='Private Nachrichten-URL';
$hesklang['et_num']='Anzahl der Tickets';
$hesklang['et_list']='Liste der Support-Tickets';
$hesklang['et_empty']='Emailvorlage darf nicht leer sein';
$hesklang['et_saved']='Emailvorlage gespeichert';
$hesklang['source']='Quelle';
$hesklang['select_category']='Kateghorie auswählen';
$hesklang['select_category_text']='Wie können wir behilflich sein?';
$hesklang['select_category_staff']='Bitte eine Ticketkategorie auswählen';
$hesklang['scat']='Kategorieauswahl Anzahl';
$hesklang['scat2']='(Ein Auswahlfeld wird angezeigt, wenn die Gesamtkategoriezahl höher ist)';
$hesklang['new_cf']='Neues benutzerdefiniertes Feld';
$hesklang['cf_intro']='Diese Funktion verwenden um benutzerdefinierte Felder zum Einreichen eines Ticketformulars hinzuzufügen, damit zusätzliche Daten von Kunden erfassen werden können.';
$hesklang['cf_public']='Öffentlich';
$hesklang['cf_private']='Nur Mitarbeiter';
$hesklang['cf_cust']='Für Kunden';
$hesklang['cf_all']='Alle';
$hesklang['cf_cat']='Ausgewählt';
$hesklang['cf_ctrl']='Tip: STRG-Taste gedrückt halten um mehrere Kategorien auszuwählen';
$hesklang['visibility']='Sichtbar';
$hesklang['cf_save']='Benutzerdefiniertes Feld speichern';
$hesklang['ex_cf']='Aktive Kunden Felder';
$hesklang['no_cf']='Keine aktiven, benutzerdefinierten Felder';
$hesklang['del_cf']='Dieses benutzerdefinierte Feld löschen? Dadurch werden auch alle gespeicherten benutzerdefinierten Felddaten aus der Datenbank gelöscht!';
$hesklang['cf_e_id']='Ungültige Nr.';
$hesklang['edit_cf']='Benutzerdefiniertes Feld bearbeiten';
$hesklang['cf_deleted']='Benutzerdefiniertes Feld gelöscht';
$hesklang['cf_not_found']='Dieses benutzerdefinierte Feld existiert nicht';
$hesklang['cf_added']='Ein neues benutzerdefiniertes Feld wurde hinzugefügt';
$hesklang['cf_nocat']='Mindestens eine Kategorie für dieses benutzerdefinierte Feld ist auszuwählen';
$hesklang['cf_mdf']='Das benutzerdefinierte Feld wurde gespeichert';
$hesklang['atl1']='Mindestens eine Option ist anzugeben';
$hesklang['sch']='Versteckt';
$hesklang['meml3']='Erlaube mehrere E-Mail Adressen';
$hesklang['dmin']='Mindest zulässiges Datum';
$hesklang['dmax']='Maximal zulässiges Datum';
$hesklang['d_day']='Tag(e)';
$hesklang['d_week']='Woche(n)';
$hesklang['d_month']='Monat(e)';
$hesklang['d_year']='Jahr(e)';
$hesklang['d_any']='Jedes Datum';
$hesklang['d_fixed']='Fixes Datum';
$hesklang['d_relative']='Relatives Datum';
$hesklang['d_mm']='Das Mindestdatum darf nicht größer als das Höchstdatum sein';
$hesklang['d_emin']='Mindestdatum für <i>%s</i> ist %s';
$hesklang['d_emax']='Maximaldatum für <i>%s</i> ist %s';
$hesklang['d_format']='Datumsanzeigeformat';
$hesklang['d_custom']='Benutzerdefiniertes Format';
$hesklang['d_ci']='FÜR ERWEITERTE BENUTZER: gültige PHP-Datumsformate siehe PHP-Handbuch.';
$hesklang['cf_noe']='Bitte eine gültige E-Mail Adresse eingeben <i>%s</i>';
$hesklang['cf_noem']='Bitet eine oder mehrere gültige Emaialdressen eingeben <i>%s</i>';
$hesklang['can_resolve']='Kann Tickets lösen';
$hesklang['can_change_own_cat']='Ticketkategorie ändern (erlauben)';
$hesklang['can_submit_any_cat']='Kann Tickets für jede Kategorie einreichen';
$hesklang['noauth_submit']='Keine Berechtigung Tickets für diese Kategorie einzureichen';
$hesklang['noauth_move']='Keine Berechtigung Tickets in diese Kategorie zu verschieben';
$hesklang['noauth_resolve']='Keine Berechtigung Tickets zu lösen';
$hesklang['force_ssl']='SSL-Verbindung erzwingen';
$hesklang['d_ssl']='<i>Deaktiviert</i> - Die Seite mit https:// öffnen um diese Option zu verwalten';
$hesklang['scno']='Dieser Status kann nicht geändert werden';
$hesklang['statuses']='Status';
$hesklang['statuses_intro']='Dieses Werkzeug anwenden, um einen benutzerdefinierten Ticketstatus zum Helpdesk hinzuzufügen';
$hesklang['color']='Farbe';
$hesklang['csscl']='CSS Klasse oder Farbe';
$hesklang['clr_view']='Farbe Vorschau für Text';
$hesklang['cbc']='Veränderbar durch Kunden';
$hesklang['ccc']='Können Kunden diesen Status ändern?';
$hesklang['del_status']='Diesen Status löschen?';
$hesklang['ex_status']='Vorhandener Status';
$hesklang['status_hesk']='Eingebauter Status (kann nicht geändert werden)';
$hesklang['status_custom']='Benutzerdefinierter Status';
$hesklang['status_custom_none']='Kein benutzerdefinierter Status vorhanden, es kann ein neuer Status im oben stehenden Formular hinzugefügt werden';
$hesklang['status_save']='Status speichern';
$hesklang['list_tkt_status']='Liste aller Tickets mit diesem Status';
$hesklang['new_status']='Neuer Benutzerstatus';
$hesklang['edit_status']='Benutzerstatus bearbeiten';
$hesklang['err_status']='Benutzerdefinierten Statusnamen eingeben';
$hesklang['status_added']='Neuer benutzerdefinierter Status wurde hinzugefügt';
$hesklang['status_e_id']='Ungültige Nr.';
$hesklang['status_mdf']='Benutzerdefinierter Status wurde gespeichert';
$hesklang['status_deleted']='Benutzerdefinierter Status wurde gelöscht';
$hesklang['status_not_found']='Dieser benutzerdefinierte Status existiert nicht';
$hesklang['status_not_empty']='Dieser Status kann nicht entfernt werden, da Tickets mit diesem Status vorhanden sind';
$hesklang['status_limit']='Maximal 100 benutzerdefinierte Status sind möglich, es können keine neuen erstellt werden';
$hesklang['public_link']='Öffentlicher Link';
$hesklang['frames']='Frames';
$hesklang['frames2']='Verhindern, dass HESK in Frames auf Domains von Drittanbietern geladen wird';
$hesklang['numsub']='Übermittelte Tickets';
$hesklang['hidf']='Ausgeblendete Eingaben sind für Kunden nicht sichtbar (der Wert ist weiterhin auf der Ticket-Detailseite sichtbar, sofern als öffentlich festgelegt ist). Nur Mitarbeiter können die versteckten Felder sehen.';
$hesklang['rcheck']='Keine Standardoption wählen';
$hesklang['refresh_page']='Seite aktualisieren';
$hesklang['del_kba']='Diesen Artikel löschen';
$hesklang['del_kbaa']='Diesen Artikel dauerhaft löschen';
$hesklang['hni1']='HESK noch nicht installiert?';
$hesklang['hni2']='Es scheint, dass dieser Helpdesk noch nicht richtig installiert und konfiguriert wurde.';
$hesklang['hni3']='Um HESK zu installieren, folgen Sie den <a href="docs/">Anweisungen in der Dokumentation</a>';
$hesklang['cf']='Cache Ordner';
$hesklang['e_cdir']='Hesk kann Emails oder Cache-Ergebnisse nicht analysieren, es sei denn, der Cacheordner existiert und ist beschreibbar.';
$hesklang['step1']='Schritt 1';
$hesklang['step2']='Schritt 2';
$hesklang['dffs']='Sobald der Download abgeschlossen ist, Datei am Server entfernen?';
$hesklang['fd']='Exportdatei vom Server gelöscht';

// Added in version 2.8.0
$hesklang['TZ']='Zeitzone';
$hesklang['thist17']='<li class="smaller">%s | übermittelt via IMAP Abruf</li>';
$hesklang['sir3']='Unsichtbares reCAPTCHA';
$hesklang['invisible']='unsichtbar';
$hesklang['imap_not']='PHP ist nicht mit IMAP-Unterstützung kompiliert';
$hesklang['imap_warning']='Benutzer %1$s hat dieselbe E-Mail Adresse wie die IMAP Abruf E-Mail Adresse: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='Benutzer %1$s hat dieselbe E-Mail Adresse wie die POP3 Abruf E-Mail Adresse: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Dies könnte zu einer Emailschleife führen, in der neue Tickets aus Benutzeremailbenachrichtigungen erstellt werden. Die AbrufE-Mail Adresse sollte eindeutig sein und nicht von anderen Personen verwendet werden.';
$hesklang['can_view_ass_by']='Kann Tickets anzeigen welche anderen zugewiesen wurden';
$hesklang['can_privacy']='Kann Tickets anonymisieren';
$hesklang['confirm_anony']='Dieses Ticket anonymisieren';
$hesklang['anon_selected']='Ausgewählte Ticktes anonymisieren';
$hesklang['privacy_anon_info']='Entferne alle persönlich identifizierbaren Daten und Inhalte von Tickets (Kundenname, E-Mail, Nachricht, Anhänge, IP ...), aber behalte Tickets in der Datenbank für Statistiken (DSGVO: Recht vergessen zu werden).';
$hesklang['success_anon']='Ticket erfolgreich anonymisiert';
$hesklang['num_tickets_anon']='Anzahl der anonymisierten Tickets: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Kunde]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Betreff]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Nachricht]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonymisiert von %s</li>';
$hesklang['print_selected']='Ausgewählte Tickets drucken';
$hesklang['with_selected']='Mit Auswahl:';
$hesklang['assign_selected']='Ausgewählte zuweisen an:';
$hesklang['assign_no']='Kein Besitzer ausgewählt, keine Änderungen vorgenommen';
$hesklang['assign_1']='Ausgewählte Tickets wurden auf "Nicht zugewiesen" festgelegt.';
$hesklang['assign_2']='Ticket Nr. %1$s nicht zugewiesen'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s Fehler: bereits zugewiesen an %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s zugewiesen an %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s Fehler: %2$s kann auf diese Ticketkategorie nicht zugreifen'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Sammelticketzuweisung Ergebnis:<br /><br />Zugewiesen: %1$s<br />Fehler: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP-Adresse';
$hesklang['moret']='Weitere Optionen'; // More options button title
$hesklang['btn_more']='Mehr'; // More options button text
$hesklang['btn_print']='Drucken';
$hesklang['btn_edit']='Bearbeiten';
$hesklang['btn_lock']='Ticket sperren';
$hesklang['btn_unlock']='Sperrung aufheben';
$hesklang['btn_tag']='Ticket markieren';
$hesklang['btn_resend']='E-Mail-Benachrichtigung erneut senden';
$hesklang['btn_untag']='Ticketmarkierung Löschen';
$hesklang['btn_import_kb']='In Wissensdatenbank importieren';
$hesklang['btn_anony']='Ticket anonymisieren';
$hesklang['btn_delt']='Ticket löschen';
$hesklang['btn_delr']='Antwort löschen';
$hesklang['ernf']='Antwort nicht gefunden';
$hesklang['tns']='Ticketbenachrichtigungen wurden erneut gesendet';
$hesklang['rns']='Antwortbenachrichtigungen wurden erneut gesendet';
$hesklang['fname']='Vorname';
$hesklang['export_selected']='Ausgewählte Tickets exportieren';
$hesklang['btn_export']='Exportieren nach XML für Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Antworten';
$hesklang['team']='Team';
$hesklang['sm_content']='Inhalt';
$hesklang['sm_settings']='Einstellungen';
$hesklang['wizard_back']='Zurück'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Weiter'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Zu den Einstellungen';
$hesklang['sm_return_to_editing']='Zurück zum Editor';
$hesklang['email_tpl_title']='Titel';
$hesklang['edit_email_template']='Editiere die E-Mail Vorlage';
$hesklang['err_no_settings_section']='Es wurde kein Abschnitt zu den Einstellungen bereitgestellt.';
$hesklang['this_field_is_required']='Dieses Feld muss ausgefüllt werden';
$hesklang['reset_your_password']='Setzen Sie Ihr Passwort zurück';
$hesklang['reset_password_instructions']='Bitte füllen Sie das untenstehende Formular aus. Wir senden Ihnen einen Link, über den Sie Ihr Passwort zurücksetzen können.';
$hesklang['enter_email']='E-Mail eingeben';
$hesklang['password_reset_check_your_email']='Überprüfen Sie Ihre E-Mail';
$hesklang['password_reset_link_sent']='Wir haben Ihnen einen Link zum Zurücksetzen Ihres Passworts geschickt.';
$hesklang['back_to_login']='Zurück zum Login';
$hesklang['pager_first']='Erste';
$hesklang['pager_previous']='Vorherige';
$hesklang['pager_next']='Nächste';
$hesklang['pager_last']='Letzte';
$hesklang['new_team_member']='Neues Teammitglied';
$hesklang['role']='Rolle';
$hesklang['optional']='Optional';
$hesklang['edit_profile']='Profil bearbeiten';
$hesklang['assigned_to']='Zugewiesen an';
$hesklang['contact']='Kontakt';
$hesklang['unban_email']='Sperre dieser E-Mail löschen';
$hesklang['unban_ip']='Sperre dieser IP löschen';
$hesklang['show_previous_replies']='Frühere Antworten anzeigen';
$hesklang['type_your_message']='Tippe eine Nachricht'; // Used when there are no canned responses
$hesklang['close_button_text']='Schließen';
$hesklang['create_new_ticket']='Neues Ticket erstellen';
$hesklang['delete_article']='Artikel löschen';
$hesklang['view_existing_tickets']='Vorhandene Tickets anzeigen';
$hesklang['how_can_we_help']='Hallo, wie können wir helfen?';
$hesklang['search_for_articles']='Suche nach Artikeln';
$hesklang['submit_a_support_request']='Support-Anfrage einreichen';
$hesklang['verify_header']='SPAM Prevention';
$hesklang['ticket_details']='Ticket Details';
$hesklang['yes_title_case']='Ja';
$hesklang['no_title_case']='Nein';
$hesklang['no_results_found']='Keine Ergebnisse gefunden';
$hesklang['site_theme']='Design';
$hesklang['test_theme_folder']='Teste Design Ordner';
$hesklang['test_theme_folder_description']='Testen des Themenordners auf gültige Designs. Nur Designs, die alle Tests bestehen, werden ordnungsgemäß installiert.';
$hesklang['err_site_theme']='Bitte wählen Sie das Hesk-Design';
$hesklang['confirm']='Bestätigen';
$hesklang['confirm_deletion']='Löschen bestätigen';
$hesklang['confirm_delete_status']='Sind Sie sicher, dass Sie diesen benutzerdefinierten Status löschen möchten?';
$hesklang['help_desk']='Help Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.de.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Zeitanzeige';
$hesklang['tdisd']='Datum und Uhrzeit';
$hesklang['tdisa']='Vergangende Zeit (Beispiel: 5 Stunden vergangen)';
$hesklang['nav_templates']='Vorlagen'; // Admin panel navigation item
$hesklang['hide_replies']='Ticket-Antworten ausblenden';
$hesklang['hide_replies_no']='Niemals Antworten anzeigen';
$hesklang['hide_replies_yes']='Alle Antworten bis auf die letzte ausblenden:';
$hesklang['hide_replies_def']='Zeigen Sie die letzte Mitarbeiterantwort und alle nachfolgenden Kundenantworten';
$hesklang['reply_by']='Antwort von'; // Reply by NAME
$hesklang['btt']='Zurück zum Anfang';
$hesklang['lwidth']='Ticket-Breite begrenzen';
$hesklang['lwidtall']='Nutzung der gesamten verfügbaren Breite';
$hesklang['lwidtpx']='Maximale Breite in Pixeln:';
// 3-letter days of the week
$hesklang['mon']='Mo';
$hesklang['tue']='Di';
$hesklang['wed']='Mi';
$hesklang['thu']='Do';
$hesklang['fri']='Fr';
$hesklang['sat']='Sa';
$hesklang['sun']='So';
$hesklang['clear']='Leeren'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Module';
$hesklang['modules_demo']='Dieses Modul ist derzeit nur verfügbar in %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Versuchen Sie die Live-Demo hier: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistiken';
$hesklang['statistics']['intro']='Dieser Bericht gibt Ihnen Einblick in die Nutzung Ihres Helpdesks und die Leistung Ihrer Mitarbeiter.';
$hesklang['statistics']['ntsp']='Keine Tickets in der ausgewählten Zeitspanne.';
$hesklang['statistics']['pie_title_ro']='Offene gegen Erledigte Tickets';
$hesklang['statistics']['open']='Offen';
$hesklang['statistics']['resolved']='Erledigt';
$hesklang['statistics']['pie_title_as']='Offene Tickets: Zugeteilt vs. Nicht zugeteilt';
$hesklang['statistics']['ass']='Zugewiesen';
$hesklang['statistics']['unas']='Nicht zugewiesen';
$hesklang['statistics']['pie_title_au']='Offene Tickets: Beantwortet vs. Unbeantwortet';
$hesklang['statistics']['answered']='Beantwortet';
$hesklang['statistics']['unanswered']='Unbeantwortet';
$hesklang['statistics']['pie_title_so']='Status der offenen Tickets';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets pro Tag des Monats';
$hesklang['statistics']['chart_title_wd']='Tickets pro Wochentag';
$hesklang['statistics']['chart_title_hd']='Fahrkarten pro Tagesstunde';
$hesklang['statistics']['chart_title_tfr']='Zeit bis zur ersten Antwort der Mitarbeiter';
$hesklang['statistics']['chart_title_tfrc']='Tickets, die innerhalb eines Zeitrahmens beantwortet wurden';
$hesklang['statistics']['chart_title_ttr']='Zeit vom Einreichen bis zum Lösen eines Tickets';
$hesklang['statistics']['chart_title_ttrc']='Tickets innerhalb eines Zeitrahmens gelöst';
$hesklang['statistics']['chart_title_sr']='Antworten der Mitarbeiter';
$hesklang['statistics']['chart_title_srt']='Mitarbeiterantworten pro Ticket';
$hesklang['statistics']['chart_title_srtr']='Mitarbeiterantworten pro Ticket (nur gelöste Tickets)';
$hesklang['statistics']['chart_title_srt1']='Mitarbeiterantworten pro Ticket (Tickets mit mindestens 1 Antwort)';
$hesklang['statistics']['ct_30']='30 Minuten';
$hesklang['statistics']['ct_1h']='1 Stunde';
$hesklang['statistics']['ct_2h']='2 Stunden';
$hesklang['statistics']['ct_4h']='4 Stunden';
$hesklang['statistics']['ct_1d']='1 Tag';
$hesklang['statistics']['ct_2d']='2 Tage';
$hesklang['statistics']['ct_3d']='3 Tage';
$hesklang['statistics']['ct_1w']='1 Woche';
$hesklang['statistics']['ct_wp']='> 1 Woche';
$hesklang['statistics']['ct_1m']='1 Monat';
$hesklang['statistics']['ct_mp']='> 1 Monat';
$hesklang['statistics']['axis1']='% von Tickets beantwortet';
$hesklang['statistics']['axis2']='% von Tickets erledigt';
$hesklang['statistics']['axis3']='% von Tickets';
$hesklang['statistics']['axis4']='Zeit für die erste Antwort';
$hesklang['statistics']['axis5']='Zeit bis zur Lösung';
$hesklang['statistics']['axis6']='Anzahl der Antworten';
$hesklang['statistics']['axis7']='Anzahl der Tickets';
$hesklang['statistics']['axis8']='Wochentag';
$hesklang['statistics']['axis9']='Stunde';
$hesklang['statistics']['axis10']='Tag pro Monat';
$hesklang['statistics']['tr_0']='keine Antwort';
$hesklang['statistics']['tr_1']='1 Antwort';
$hesklang['statistics']['tr_2']='2 Antworten';
$hesklang['statistics']['tr_5']='3-5 Antworten';
$hesklang['statistics']['tr_10']='6-10 Antworten';
$hesklang['statistics']['tr_99']='> 10 Antworten';
$hesklang['statistics']['average']='Durchschnitt';
$hesklang['statistics']['atfr']='Durchschnittliche Stunden und Minuten bis zur ersten Mitarbeiterantwort:';
$hesklang['statistics']['attr']='Durchschnittliche Stunden und Minuten zur Lösung eines Tickets:';
$hesklang['statistics']['about']='über %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='Nicht Verfügbar';
$hesklang['statistics']['trept']='Gesamtzahl der Tickets, auf die das Personal geantwortet hat:';
$hesklang['statistics']['trnr']='Gesamtzahl der Tickets ohne Antwort des Personals gelöst:';
$hesklang['statistics']['tsr']='Antworten der Mitarbeiter insgesamt:';
$hesklang['statistics']['tsrt']='Durchschnittliche Personalantworten pro Ticket:';
$hesklang['statistics']['tsro']='Durchschnittliche Personalantworten pro Ticket (Tickets mit mindestens 1 Personalantwort):';
$hesklang['statistics']['tsrc']='Durchschnittlich erforderliche Antworten des Personals zur Lösung eines Tickets:';
$hesklang['statistics']['tsrr']='Durchschnittlich erforderliche Antworten des Personals zur Lösung eines Tickets (Tickets mit mindestens 1 Antwort des Personals):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='und vieles mehr...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket Überfällig';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] Eskalation: %%SUBJECT%%';
$hesklang['escalate']['tab']='Eskalation'; // Menu link
$hesklang['escalate']['page_title']='Eskalations Tickets'; // Page H2 title
$hesklang['escalate']['intro']='Dieses Modul hilft Ihnen, Tickets zu eskalieren, die nicht rechtzeitig bearbeitet werden.';
$hesklang['escalate']['feat1']='Tickets, die nicht innerhalb eines bestimmten Zeitrahmens zugewiesen, beantwortet oder gelöst werden';
$hesklang['escalate']['feat2']='Tickets, die sich dem Fälligkeitsdatum nähern und überfällige Tickets';
$hesklang['escalate']['feat3']='Ticketpriorität automatisch ändern, ein Ticket neu zuweisen, eine E-Mail-Benachrichtigung senden';
$hesklang['escalate']['feat4']='Regeln basierend auf Ticketkategorie, Besitzer, Status anwenden';
$hesklang['escalate']['prefix']='Eskaliert:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Aktive Regeln';
$hesklang['escalate']['new']='Neue Eskalationsregel';
$hesklang['escalate']['no_rules']='Sie haben noch keine Eskalationsregeln. Erstellen Sie eine, indem Sie oben auf die Schaltfläche &quot;Neue Eskalationsregel&quot; klicken.';
$hesklang['escalate']['title']='Titel der Regel';
$hesklang['escalate']['titlet']='Ein beschreibender Titel, zum Beispiel: Tickets, die nicht innerhalb eines Tages beantwortet werden, neu zuweisen';
$hesklang['escalate']['default_title']='Regel von %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Regelauslöser';
$hesklang['escalate']['trigt']='Legen Sie die Bedingung fest, die diese Regel auslösen (ausführen) soll.';
$hesklang['escalate']['hits']='Treffer'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Zustand'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Aktion'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='zuweisen an'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Diese Regel löschen?';
$hesklang['escalate']['edit']='ID der Eskalationsregel bearbeiten %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Ein Support-Ticket ist:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='vom Mitarbeiter noch nicht beantwortet';
$hesklang['escalate']['nrepc']='vom Kunden nicht beantwortete Anfrage';
$hesklang['escalate']['nass']='nicht zugeordnet';
$hesklang['escalate']['nres']='nicht aufgelöst';
$hesklang['escalate']['ndue']='nahendes Fälligkeitsdatum';
$hesklang['escalate']['odue']='überfällig';
$hesklang['escalate']['within']='innerhalb:';
$hesklang['escalate']['minutes']='Minuten';
$hesklang['escalate']['hours']='Stunden';
$hesklang['escalate']['days']='Tage';
$hesklang['escalate']['weeks']='Wochen';
$hesklang['escalate']['months']='Monate';
$hesklang['escalate']['years']='Jahre';
$hesklang['escalate']['ofs']='eingereicht zu werden';
$hesklang['escalate']['resend']='E-Mail-Benachrichtigungen erneut senden:';
$hesklang['escalate']['force']='Immer senden, Personaleinstellungen ignorieren';
$hesklang['escalate']['noforce']='Einstellungen für Personalmeldungen respektieren';
$hesklang['escalate']['setpri']='Setzen Sie die Priorität auf:';
$hesklang['escalate']['setsta']='Setzen Sie den Status auf:';
$hesklang['escalate']['assto']='Ticket zuweisen an:';
$hesklang['escalate']['asm']='Ein weiterer Mitarbeiter';
$hesklang['escalate']['notify']='Mitarbeiter benachrichtigen...';
$hesklang['escalate']['ato']='Zuweisen an:';
$hesklang['escalate']['tic']='Tickets in der Kategorie:';
$hesklang['escalate']['tat']='Tickets zugewiesen an:';
$hesklang['escalate']['tws']='Tickets mit Status:';
$hesklang['escalate']['tall']='Wenden Sie diese Regel auf bestehende und zukünftige Tickets an';
$hesklang['escalate']['tfn']='Diese Regel nur auf zukünftige Tickets anwenden, bestehende Tickets ignorieren';
$hesklang['escalate']['tfi']='Wenden Sie diese Regel nur auf Tickets mit einer ID höher als an:';
$hesklang['escalate']['save']='Regel speichern';
$hesklang['escalate']['e_tt']='Die Zeit sollte zwischen 1 und 10000 liegen';
$hesklang['escalate']['e_a']='Wählen Sie mindestens eine Aktion aus, die bei übereinstimmenden Tickets ausgeführt werden soll';
$hesklang['escalate']['nocat']='Wählen Sie mindestens eine Kategorie';
$hesklang['escalate']['nouser']='Mindestens einen Benutzer auswählen';
$hesklang['escalate']['nostatus']='Wählen Sie mindestens einen Status';
$hesklang['escalate']['nocata']='%1$s hat keinen Zugriff auf diese Kategorien:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Neue Regel wurde erstellt';
$hesklang['escalate']['mdf']='Regeleinstellungen wurden gespeichert';
$hesklang['escalate']['e_id']='Keine Regel mit dieser ID gefunden';
$hesklang['escalate']['deleted']='Ausgewählte Regel wurde gelöscht';
$hesklang['escalate']['edit_notice']='Das Ändern des Regelauslösers hat keine Auswirkungen auf Tickets, die bereits durch diese Regel eskaliert wurden (es sei denn, Sie setzen die Regel zurück).';
$hesklang['escalate']['reset']='Diese Regel zurücksetzen';
$hesklang['escalate']['reset2']='Sind Sie sicher, dass Sie diese Regel zurücksetzen wollen?<br><br>Regeltreffer werden auf 0 gesetzt und jedes Ticket, das dieser Regel entspricht, wird erneut eskaliert.';
$hesklang['escalate']['reset3']='Ausgewählte Regel wurde zurückgesetzt';
$hesklang['escalate']['log_title']='Regel #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | eskaliert durch %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - setze Priorität auf %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - Zugewiesen an %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - Sende Mitarbeiter benachrichtigung</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - Personalbenachrichtigung senden (erzwungen)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - Fehler: %2$s hat nicht die Berechtigung, auf die Ticket-Kategorie</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - Fehler: %2$s hat nicht die Berechtigung, Tickets anzusehen</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - Fehler: kein anderer Benutzer, der dieses Ticket sehen kann</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - Hinweis: Priorität bereits eingestellt auf %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - Hinweis: bereits vergeben an %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - benachrichtigen: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - setze Status auf %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - Hinweis: Der Status ist bereits auf %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Aktiv'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Aktivieren Sie diese Regel (verwenden Sie sie)';
$hesklang['escalate']['activated']='Ausgewählte Regel wurde aktiviert'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deaktivieren Sie diese Regel (verwenden Sie sie nicht mehr)';
$hesklang['escalate']['deactivated']='Ausgewählte Regel wurde deaktiviert'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Keine aktiven Eskalationsregeln';
$hesklang['escalate']['matched']='Anzahl der gefundenen übereinstimmenden Tickets: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Werkzeuge';
$hesklang['escalate']['test']='Simulieren Sie diese Regel';
$hesklang['escalate']['testa']='Alle Regeln simulieren';
$hesklang['escalate']['testaa']='Alle aktiven Regeln simulieren';
$hesklang['escalate']['testr']='Ergebnisse der Simulation';
$hesklang['escalate']['rsim']='Simulation wiederholen';
$hesklang['escalate']['tbef']='Bevor eine Regel aktiv wird, müssen Sie sie aktivieren, indem Sie auf das Kontrollkästchen in der Spalte &quot;AKTIV&quot; klicken.<br><br>
                               Wir empfehlen Ihnen dringend, jede Regel zu <strong>simulieren</strong>, indem Sie auf das Symbol %1$s (Diese Regel simulieren) in der Regeltabelle klicken
                               um zu sehen, wie sie sich auf Ihre bestehenden Tickets auswirkt, bevor Sie sie aktivieren.<br><br>
                               <strong>Aktive Regeln werden alle %2$s Minuten verarbeitet. Ein Ticket kann von jeder Regel nur einmal eskaliert werden</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SIMULATIONSMODUS, keine Änderungen an der Datenbank';
$hesklang['escalate']['sic']='SIMULATION KOMPLETT';
$hesklang['escalate']['r']='[Regel]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Tipp: Halten Sie die STRG-Taste gedrückt, um mehrere Optionen auszuwählen';
$hesklang['desc_ticket_escalated']='(Mitarbeiter) Ticket wurde eskaliert'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Ticket Formatierung (Mitarbeiter)';
$hesklang['ticket_formatting_plaintext']='Einfacher Text';
$hesklang['ticket_formatting_rich_text']='Rich Text (HTML)';
$hesklang['due_date']='Fälligkeitsdatum';
$hesklang['invalid_due_date']='Es wurde ein ungültiges Fälligkeitsdatum eingegeben.';
$hesklang['thist19']='<li class="smaller">%s | Fälligkeitsdatum aktualisiert auf %s von %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | Fälligkeitsdatum entfernt von %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Das Ticket-Fälligkeitsdatum wurde aktualisiert.';
$hesklang['menu_kb_manage']='Verwalten'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Ansehen'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Alle Auswählen';
$hesklang['a_deselect']='Alle abwählen';
$hesklang['a_toggle']='Auswahl umkehren';
$hesklang['ql_all']='Alle Tickets';
$hesklang['ql_alo']='Alle offenen Tickets';
$hesklang['ql_fit']='Gefilterte Tickets';
$hesklang['ql_a2m']='Mir zugewiesen';
$hesklang['ql_a2o']='Zugewiesen an andere';
$hesklang['ql_una']='Nicht zugewiesen';
$hesklang['ql_due']='Bald fällig';
$hesklang['ql_ovr']='Überfällig';
$hesklang['set_ds']='Anzeigen als &quot;bald fällig&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='Tage vor Fälligkeit';
$hesklang['not_aos']='Einige offene Tickets, auf die Sie Zugriff haben, werden aufgrund Ihrer Filter nicht angezeigt.';
$hesklang['ntoverdue']='Ein Ticket ist beim Besitzer überfällig:';
$hesklang['ovdcron']='Damit überfällige Benachrichtigungen funktionieren, muss Ihr Administrator einen Cron-Job aktivieren.';
$hesklang['instructions']='Anweisungen';
$hesklang['desc_overdue_ticket']='(Mitarbeiter) Ticket Überfällig';
$hesklang['overdue_starting']='Benachrichtigungsprozess für überfällige Tickets starten';
$hesklang['overdue_sim']='Das Senden von E-Mails und das Aktualisieren von Tickets ist im Modus SIMULATION deaktiviert.';
$hesklang['overdue_ticket_count']='%s Tickets gefunden, die überfällig sind.'; // %s = Number of tickets
$hesklang['overdue_finished']='Beendete überfällige Tickets. %s E-Mails gesendet. %s E-Mails konnten nicht gesendet werden.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Eigenes CSS';
$hesklang['admin_css2']='Laden einer zusätzlichen benutzerdefinierten Stildatei für das Bedienfeld';
$hesklang['noval_cert']='Server-Zertifikate nicht validieren';
$hesklang['chg_cat']='Klicken Sie, um die Ticketkategorie zu ändern';
$hesklang['tlan']='Ticket Sprache';
$hesklang['uue']='Zwei oder mehr Mitarbeiter haben die gleiche E-Mail-Adresse. Wir empfehlen, für jeden Benutzer eine eindeutige E-Mail-Adresse einzustellen.';
$hesklang['flood']='Flut limit';
$hesklang['e_flood']='Ooops, Sie haben vor kurzem bereits eine Antwort gesendet. Wir haben diese Anfrage gestoppt, um eine Antwortflut zu verhindern.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='URL Zugriffsschlüssel'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Generieren eines zufälligen URL-Zugriffsschlüssels';
$hesklang['ukeym']='Fehler: Um diese Datei über HTTP auszuführen, müssen Sie Ihren URL-Zugriffsschlüssel in die Anfrage aufnehmen. Beispiel:';
$hesklang['ukeyw']='Fehler: falscher URL-Zugriffsschlüssel';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket erhalten: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% ist Ihr Verifizierungscode';
$hesklang['follow_up_email']='Seien Sie ehrlich - wie haben wir uns geschlagen?';
$hesklang['mfa']='Multi-Faktor-Authentifizierung (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Aktiviert?';
$hesklang['mfa_required']='Multi-Faktor-Authentifizierung erforderlich';
$hesklang['mfa_manage_profile']='MFA verwalten';
$hesklang['mfa_disabled']='Die Multi-Faktor-Authentifizierung ist deaktiviert.';
$hesklang['mfa_enabled']='Multi-Faktor-Authentifizierung ist aktiviert (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Keine';
$hesklang['mfa_method_none_subtext']='Löschen Sie die Multi-Faktor-Authentifizierung für Ihr Konto.';
$hesklang['mfa_method_email']='E-Mail';
$hesklang['mfa_method_email_subtext']='Der Helpdesk schickt eine E-Mail mit einem zufälligen Anmeldecode an <strong>%s</strong> wenn Sie sich anmelden.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authentifikator App';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Verwenden Sie eine Smartphone-Anwendung wie Authy oder Google Authenticator, um beim Einloggen einen zufälligen Anmeldecode zu generieren.';
$hesklang['mfa_step_method']='Methode';
$hesklang['mfa_step_verification']='Überprüfung';
$hesklang['mfa_step_complete']='Vollständig';
$hesklang['mfa_introduction']='Die Multi-Faktor-Authentifizierung verbessert die Kontosicherheit, indem sie Sie auffordert, Ihre Anmeldung mit einer zusätzlichen Verifizierungsmethode zu verifizieren, z. B. per E-Mail oder mit einer Authentifizierungs-App (wie Authy oder Google Authenticator).';
$hesklang['mfa_reset_warning']='Sie haben die Multi-Faktor-Authentifizierung bereits aktiviert. Wenn Sie diesen Vorgang erneut ausführen, wird Ihr Gerät für die Multi-Faktor-Authentifizierung zurückgesetzt (falls aktiviert).';
$hesklang['mfa_select_method_colon']='Wählen Sie eine Authentifizierungsmethode:';
$hesklang['mfa_verification_header']='Überprüfung - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Es wurde eine E-Mail mit einem sechsstelligen Verifizierungscode an <strong>%s</strong> gesendet. Geben Sie den Code, den Sie per E-Mail erhalten haben, unten ein, um fortzufahren.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Schritt 1: Scannen Sie das unten stehende Bild mit der App für die Multifaktor-Authentifizierung auf Ihrem mobilen Gerät.';
$hesklang['mfa_verification_auth_app_cant_scan']='Sie können das Bild nicht scannen? Geben Sie diesen Code manuell auf Ihrem Gerät ein: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Schritt 2: Geben Sie den 6-stelligen Code ein, der in Ihrer Anwendung angezeigt wird, um Ihr Gerät zu verifizieren.';
$hesklang['mfa_verify']='Überprüfen';
$hesklang['mfa_invalid_method']='Es wurde eine ungültige Multi-Faktor-Authentifizierungsmethode empfangen.';
$hesklang['mfa_invalid_verification_code']='Der eingegebene Code ist falsch oder abgelaufen.';
$hesklang['mfa_configured']='Die Multi-Faktor-Authentifizierung wurde für Ihr Konto aktiviert!';
$hesklang['mfa_removed']='Die Multi-Faktor-Authentifizierung wurde für Ihr Konto deaktiviert!';
$hesklang['mfa_verification_needed']='Die Multi-Faktor-Authentifizierung ist für dieses Konto aktiviert.';
$hesklang['mfa_verification_needed_email']='Bitte geben Sie den Verifizierungscode ein, der an Ihre E-Mail-Adresse gesendet wurde.';
$hesklang['mfa_verification_needed_auth_app']='Bitte geben Sie den Code ein, der in Ihrer Authentifizierungs-App angezeigt wird.';
$hesklang['mfa_verification_code']='Verifizierungscode';
$hesklang['mfa_server_time_issue']='Ihre Serverzeit scheint ungenau zu sein: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Zurücksetzen der Multi-Faktor-Authentifizierung';
$hesklang['mfa_reset_confirm']='Sind Sie sicher, dass Sie die MFA für diesen Benutzer zurücksetzen möchten?';
$hesklang['mfa_reset_yes']='Zurücksetzen';
$hesklang['mfa_reset']='Die Multi-Faktor-Authentifizierung wurde für den Benutzer zurückgesetzt';
$hesklang['desc_mfa_verification']='(Personal) Multi-Faktor-Authentifizierungscode';
$hesklang['mfa_code']='Code:';
$hesklang['mfa_backup_codes_header']='SPEICHERN SIE IHRE BACKUP-CODES!';
$hesklang['mfa_backup_codes_description']='Bewahren Sie diese Backup-Codes an einem sicheren, aber zugänglichen Ort auf. Falls Sie den Zugriff auf Ihr MFA-Gerät oder Ihre E-Mail verlieren, können Sie einen der folgenden Backup-Codes eingeben, um sich anzumelden.<br><br><strong>Behandeln Sie diese Sicherungscodes wie Passwörter. Sie werden diese Codes nicht mehr sehen können!</strong>';
$hesklang['mfa_verify_another_way']='Überprüfen Sie Ihr Konto auf andere Weise'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Einen Verifizierungscode erhalten Sie unter %s';
$hesklang['mfa_verify_another_way_code']='Geben Sie einen Ihrer 8-stelligen Backup-Codes ein';
$hesklang['mfa_verify_another_way_admin']='Kontaktieren Sie Ihren Helpdesk-Administrator für Hilfe';
$hesklang['mfa_verify_another_way_reset']='Setzen Sie Ihre Multi-Faktor-Authentifizierung zurück, indem Sie eine Datei auf den Server hochladen';
$hesklang['mfa_send_another_email']='Weitere E-Mail senden';
$hesklang['mfa_sent']='Eine E-Mail mit einem neuen Verifizierungscode wurde an Ihre E-Mail-Adresse gesendet';
$hesklang['mfa_backup_code']='Sicherungscode';
$hesklang['mfa_backup_codes']='Sicherungs-Codes';
$hesklang['mfa_backup_codes_info']='Codes zur einmaligen Verwendung, um die Multi-Faktor-Verifizierung zu umgehen, wenn Sie nicht auf Ihre E-Mail oder Authentifizierungs-App zugreifen können. Sobald Sie einen Backup-Code zur Anmeldung verwenden, wird dieser Code inaktiv.';
$hesklang['mfa_backup_codes_num']='Sie können jederzeit einen neuen Satz von 10 Backup-Codes erhalten. Wenn Sie einen neuen Satz von Codes erstellen, wird der alte Satz automatisch inaktiv.';
$hesklang['mfa_backup_codes_num2']='Anzahl Ihrer aktiven Codes: %s';
$hesklang['mfa_invalid_backup_code']='Der eingegebene Sicherungscode ist falsch oder wurde bereits verwendet.';
$hesklang['mfa_del_codes']='Meine Sicherungscodes löschen';
$hesklang['mfa_del_codes2']='Alle Ihre Sicherungscodes wurden gelöscht.';
$hesklang['mfa_new_codes']='Neue Sicherungscodes generieren';
$hesklang['mfa_new_codes2']='Es wurden neue Backup-Codes generiert';
$hesklang['old_php_version']='Fehler: Nicht unterstützte PHP-Version';
$hesklang['category_default_due_date']='Verzug Fälligkeitsdatum';
$hesklang['category_change_default_due_date']='Standard-Fälligkeitsdatum festlegen';
$hesklang['category_leave_blank_for_no_default_due_date']='(leer lassen, wenn kein Fälligkeitsdatum angegeben ist)';
$hesklang['category_default_due_date_updated']='Das Standardfälligkeitsdatum wurde aktualisiert.';
$hesklang['email_formatting']='E-Mail-Formatierung';
$hesklang['email_formatting_html_and_plaintext']='HTML mit Klartextalternative aus Klartextvorlage (Standard)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML mit Klartextalternative aus HTML-Vorlage generiert';
$hesklang['email_formatting_html']='Nur HTML';
$hesklang['email_formatting_plaintext']='Nur Klartext';
$hesklang['email_formatting_note']='Ihre Auswahl in %1$s &gt; %2$s &gt; %3$s eingestellt ist: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Das bedeutet, dass Hesk die HTML-Vorlagen hier ignoriert.';
$hesklang['email_formatting_note1']='Das bedeutet, dass Hesk hier die reinen Textvorlagen ignorieren wird.';
$hesklang['email_formatting_note2']='Das bedeutet, dass Hesk aus Ihren HTML-Vorlagen eine Klartextversion der E-Mails erzeugt und die Klartextvorlagen hier ignoriert.';
$hesklang['etnu']='Diese E-Mail-Vorlage wird derzeit nicht von Hesk verwendet, basierend auf Ihrer Auswahl in %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Kategorie bearbeiten';
$hesklang['create_category']='Kategorie erstellen';
$hesklang['one_user_included']='1 Benutzer eingeschlossen';
$hesklang['one_user_excluded']='1 Benutzer ausgeschlossen';
$hesklang['x_users_included']='%s Benutzer eingeschlossen'; // %s = Number of users
$hesklang['x_users_excluded']='%s Benutzer ausgeschlossen'; // %s = Number of users
$hesklang['aa_cat']='Tickets in dieser Kategorie automatisch zuweisen';
$hesklang['modify_autoassign_settings']='Ändern der Einstellungen für die automatische Zuweisung';
$hesklang['autoassign_on_all_users']='Ja, für jeden Benutzer mit Zugriff auf diese Kategorie';
$hesklang['autoassign_on_select_users']='Ja, für bestimmte Benutzer';
$hesklang['autoassign_off']='Nein, Tickets als nicht zugewiesen einreichen';
$hesklang['autoassign_users']='UBenutzer, die in die automatische Zuweisung einbezogen/ausgeschlossen werden sollen';
$hesklang['autoassign_selected_include']='Ausgewählte Benutzer sollten bei der automatischen Zuweisung von Tickets in dieser Kategorie <strong>miteinbezogen</strong> werden';
$hesklang['autoassign_selected_exclude']='Ausgewählte Benutzer sollten <strong>ausgeschlossen</strong> werden, wenn Tickets in dieser Kategorie automatisch zugewiesen werden';
$hesklang['cat_edited']='Kategorie %s wurde erfolgreich bearbeitet';
$hesklang['search_for_user']='Suche nach Benutzer';
$hesklang['email_sending']='Versenden von E-Mails';
$hesklang['email_to_ticket']='E-Mail an Ticket';
$hesklang['email_to_ticket_info']='Die Umwandlung von E-Mails in Tickets erfordert einige serverseitige Einstellungen. Für Details siehe bitte <a href="%s" target="_blank">dieser Wissensdatenbank-Leitfaden</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk verwendet einen SMTP-Server, um E-Mail-Benachrichtigungen zu versenden. Ihr <strong>%1$s</strong> sollte eingestellt werden auf <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Fehlende Dateierweiterung';
$hesklang['block_ignore']='E-Mail an Ticket - E-Mails ignorieren und Schleifen verhindern';
$hesklang['block_noreply']='Nicht antworten';
$hesklang['block_noreply2']='E-Mails ignorieren, die von &quot;nicht antworten&quot; E-Mail-Adressen gesendet werden';
$hesklang['block_returned']='Zurückgeschickt';
$hesklang['block_returned2']='Ignorieren Sie zurückgesendete E-Mails, z. B. Benachrichtigungen über den Zustellstatus und automatische Antworten';
$hesklang['block_duplicate']='Duplikate';
$hesklang['block_duplicate2']='Ignorieren von E-Mails mit der gleichen Nachricht, die innerhalb von &quot;%s&quot; Sekunden gesendet werden'; // %s = "Timeframe"
$hesklang['loop_info']='E-Mails, die von derselben E-Mail-Adresse innerhalb von &quot;%s&quot; Sekunden empfangen werden';
$hesklang['thist21']='<li class="smaller">%s | Überfällige E-Mail-Benachrichtigung gesendet</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | Folge-E-Mail gesendet</li>'; // %s = date
$hesklang['elevator_header']='Betreten des Sicherheitsbereichs';
$hesklang['elevator_intro']='Sie sind im Begriff, einen Sicherheitsbereich zu betreten.';
$hesklang['elevator_enter_password']='Bitte geben Sie Ihr Passwort ein, um fortzufahren.';
$hesklang['elevator_duration_setting_title']='Dauer des Sicherheitsbereichs';
$hesklang['desc_survey']='(Kunden-)Follow-up (Umfrage) E-Mail'; // Email description
$hesklang['satisfaction']['tab']='Zufriedenstellung';
$hesklang['satisfaction']['title']='Umfrage zur Kundenzufriedenheit';
$hesklang['satisfaction']['intro']='Senden Sie Ihren Kunden eine Zufriedenheitsumfrage, um ein Feedback über ihre Erfahrungen mit Ihrem Helpdesk zu erhalten.';
$hesklang['satisfaction']['tab1']='Einstellungen';
$hesklang['satisfaction']['tab2']='Opt-out';
$hesklang['satisfaction']['enable']='Aktivieren Sie Follow-up-E-Mails:';
$hesklang['satisfaction']['enabled']='Umfragen zur Kundenzufriedenheit sind aktiviert.';
$hesklang['satisfaction']['disabled']='Umfragen zur Kundenzufriedenheit sind derzeit deaktiviert.';
$hesklang['satisfaction']['url']='URL-Adresse der Umfrage:';
$hesklang['satisfaction']['send']='Verspätung der Folge-E-Mail:';
$hesklang['satisfaction']['at_least']='Warten Sie mindestens';
$hesklang['satisfaction']['after']='nachdem das Ticket gelöst wurde, bevor die E-Mail versendet wird';
$hesklang['satisfaction']['h1']='Wie wird dieses Tool verwendet?';
$hesklang['satisfaction']['h2']='Erstellen Sie zunächst eine Umfrage zur Kundenzufriedenheit in Ihrem bevorzugten Umfragetool. Wenn Sie unsicher sind, welches Tool Sie verwenden oder welche Fragen Sie stellen sollen, haben wir ein <a href="%s" target="_blank">Leitfaden hier</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Wenn Ihre Umfrage fertig ist, aktivieren Sie Follow-up-E-Mails über das unten stehende Formular. Hesk wird gelöste Tickets mit mindestens einer Antwort pro Stunde bearbeiten und den Link zu Ihrer Umfrage an Ihre Kunden senden.';
$hesklang['satisfaction']['e_url']='Geben Sie eine gültige URL-Adresse für die Umfrage ein. Dies ist die URL, an die Ihre Kunden weitergeleitet werden.';
$hesklang['satisfaction']['as']='Geben Sie eine gültige URL-Adresse für die Umfrage ein. Dies ist die URL, an die Ihre Kunden weitergeleitet werden.';
$hesklang['satisfaction']['oo1']='Diese Seite listet E-Mail-Adressen auf, die Folge-E-Mails <b>nicht</b> gesendet werden.';
$hesklang['satisfaction']['oo2']='Ihre Kunden können den Erhalt von Umfrage-E-Mails abbestellen, indem sie auf einen Link in der E-Mail klicken. Alternativ können Sie auf dieser Seite auch manuell E-Mail-Adressen hinzufügen.';
$hesklang['satisfaction']['ooe']='E-Mail Adresse an opt-out';
$hesklang['satisfaction']['ooe2']='Geben Sie die E-Mail-Adresse ein, mit der Sie keine Umfragen mehr erhalten möchten.';
$hesklang['satisfaction']['ooe3']='Diese E-Mail-Adresse <i>%s</i> ist bereits vom Erhalt von Umfragen abgemeldet.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Diese E-Mail abbestellen';
$hesklang['satisfaction']['oob']='Abgemeldet von';
$hesklang['satisfaction']['no_oo']='Kein Kunde hat sich gegen den Erhalt von Umfrage-E-Mails entschieden.';
$hesklang['satisfaction']['oor']='Löschen';
$hesklang['satisfaction']['oor2']='E-Mail aus Opt-out entfernt';
$hesklang['satisfaction']['oor3']='Bestätigen Sie die Entfernung';
$hesklang['satisfaction']['oor4']='Wenn die Abmeldung aufgehoben wird, erhält dieser Nutzer wieder Follow-up-E-Mails.';
$hesklang['satisfaction']['optedout']='Die E-Mail-Adresse <i>%s</i> wurde für den Erhalt von Umfrage-E-Mails abgemeldet.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Fehlende oder ungültige Umfrage-ID';
$hesklang['satisfaction']['starting']='Beginn des Benachrichtigungsverfahrens für Umfragen zur Kundenzufriedenheit';
$hesklang['satisfaction']['tc']='Es wurden %s der geschlossenen Tickets gefunden, für die keine Zufriedenheitsumfrage gesendet wurde.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Beendete Umfrage zur Kundenzufriedenheit. E-Mails gesendet: %1$s. E-Mails konnten nicht gesendet werden: %2$s. Tickets ohne E-Mail: %3$s. Tickets mit Opt-out-E-Mail: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignorieren, dieser Kunde möchte keine Umfrage-E-Mails erhalten.';
$hesklang['satisfaction']['ne']='Ignorieren, dieses Ticket ist ohne Email-Adresse';
$hesklang['satisfaction']['feat1']='Erstellen Sie Ihre Umfrage mit einem beliebigen Tool eines Drittanbieters, z. B. Google Forms';
$hesklang['satisfaction']['feat2']='Ihre Umfrage-URL, Präferenzen und Einschränkungen in diesem Modul einrichten';
$hesklang['satisfaction']['feat3']='Wenn Sie ein Ticket gelöst haben, sendet Hesk Ihrem Kunden den Link zur Umfrage per E-Mail.';
$hesklang['dfor']='Datumsformat';
$hesklang['dtfor']='Datum und Uhrzeit';
$hesklang['cdfor']='Datum wählen Format';
$hesklang['custom']='Benutzerdefiniert';
$hesklang['jsc_notice']='Die Datumsauswahl unterstützt nicht die PHP-übliche Datumsformatierung. Wählen Sie eine der vorkonfigurierten Optionen aus oder klicken Sie auf das %s Symbol unten, um die verfügbaren Anzeigeoptionen anzuzeigen.'; // %s = replaced by icon
$hesklang['lcf3']='Nur Datum'; // Display: "Date only"
$hesklang['epdd']='Fehler beim Parsen des Parameters Fälligkeitsdatum:';
$hesklang['edit_pass']='Passwort bearbeiten';
$hesklang['save_pass']='Passwort speichern';
$hesklang['cur_pass']='Aktuelles Passwort';
$hesklang['cur_pass2']='Sie müssen Ihr aktuelles Passwort angeben, um es ändern zu können.';
$hesklang['cur_pass3']='Nach erfolgreicher Passwortaktualisierung werden Sie zur Anmeldeseite weitergeleitet, wo Sie sich mit Ihrem neuen Passwort anmelden können.';
$hesklang['e_new_pass']='Bitte geben Sie Ihr neues Passwort ein';
$hesklang['pass_len']='Das Passwort darf nicht länger als 64 Zeichen sein.';
$hesklang['pass_login']='Bitte melden Sie sich nach der Änderung Ihres Passworts erneut an';
$hesklang['bf_int']='Sie wurden wegen zu vieler fehlgeschlagener Verifizierungsversuche abgemeldet';
$hesklang['tst_cnt']='Anzahl der E-Mails, die Ihr Mailserver an Hesk senden wird: %s'; // %s = number of emails
$hesklang['wrn_imap']='Sie haben viele ungelesene E-Mails in Ihrer Mailbox (%1$s). Hesk wird alle diese E-Mails in Tickets umwandeln.<br><br>Möglicherweise möchten Sie vorhandene E-Mails als gelesen markieren, bevor Sie die %2$s oder verwenden Sie ein neues E-Mail-Konto für Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Sie haben viele E-Mails in Ihrer Mailbox (%1$s). Hesk wird alle diese E-Mails in Tickets umwandeln.<br><br>Sie können bestehende E-Mails löschen, bevor Sie %2$s aktivieren oder ein neues E-Mail-Konto für Hesk verwenden.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Fällig am'; // Due on (date)
$hesklang['search_due_date_range']='Fällig in'; // Due in (X days)
$hesklang['attachment_add_files']='Datei hinzufügen';
$hesklang['attachment_max_exceeded']='Diese Datei wird nicht hochgeladen, da Sie bereits die zulässige Höchstzahl an Dateien hochgeladen haben.';
$hesklang['attachment_viewer_message']='Ziehen Sie Dateien hierher oder klicken Sie auf die Schaltfläche \'Datei hinzufügen\' , um Dateien zum Hochladen auszuwählen.';
$hesklang['attachment_invalid_type_message']='Es tut uns leid, aber der Dateityp, den Sie hochladen wollten, ist nicht erlaubt.';
$hesklang['attachment_upload_error']='Beim Hochladen ist ein Fehler aufgetreten. Bitte versuchen Sie es später noch einmal.';
$hesklang['attachment_too_large']='Dieser Anhang ist größer als die maximal zulässige Dateigröße.';
$hesklang['attachment_cancel']='Abbrechen';
$hesklang['attachment_confirm_cancel']='Sind Sie sicher, dass Sie diesen Upload abbrechen möchten?';
$hesklang['attachment_remove']='Anhang Löschen';
$hesklang['attachment_too_many_uploads']='Es wurden in kurzer Zeit zu viele Anhänge von Ihrem Standort hochgeladen. Bitte versuchen Sie Ihre Anfrage später erneut.';
$hesklang['sub_note']='Notiz speichern';
$hesklang['can_view_users']='Alle Benutzer anzeigen (aber nicht verwalten)';
$hesklang['welcome1']='Hallo, du scheinst neu hier zu sein. Herzlich willkommen!';
$hesklang['welcome2']='Um Ihnen den Einstieg zu erleichtern, sehen Sie sich die %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk online Schnellstartanleitung';
$hesklang['tmce1']='Verwenden Sie Strg+Rechtsklick, um die Rechtschreibprüfung aufzurufen';
$hesklang['tmce2']='Halten Sie die Steuerungstaste (Strg) gedrückt und klicken Sie mit der rechten Maustaste auf das falsch geschriebene Wort, um die Rechtschreibprüfung aufzurufen.';
$hesklang['desc_new_ticket_by_staff']='(Kunde) Neues, von Mitarbeitern eingereichtes Ticket';
$hesklang['mod_et_h']='Sie können E-Mail-Vorlagen ändern unter %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Sprache einstellen auf';
$hesklang['ouwa']='Nur Benutzer mit Zugriff auf diese Kategorie sind unten aufgeführt. Um Mitarbeiter zu dieser Kategorie hinzuzufügen, bearbeiten Sie ihre Berechtigungen auf der Seite %s'; // %s = Team
$hesklang['previous_tickets']='Frühere Tickets';
$hesklang['no_previous']='Keine vorherigen Tickets von %s'; // %s = email address
$hesklang['all_previous']='Alle bisherigen Tickets auflisten';
$hesklang['confirm_delete_ticket']='Sind Sie sicher, dass Sie dieses Ticket dauerhaft löschen möchten?';
$hesklang['confirm_delete_reply']='Sind Sie sicher, dass Sie diese Antwort endgültig löschen wollen?';
$hesklang['select_new_category']='Anzahl der Tickets in dieser Kategorie: %s<br><br>Bitte wählen Sie eine neue Kategorie, in die diese Tickets übertragen werden sollen:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Anzahl der Tickets, die diesem Benutzer zugewiesen wurden: %1$s<br>Anzahl der <b>Offenen</b> Tickets, die diesem Benutzer zugewiesen sind: %2$s<br><br><b>Offene</b> Tickets werden <b>nicht zugewiesen</b> nachdem dieser Benutzer gelöscht wurde.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK-Lizenz';
$hesklang['hlic_free']='KOSTENLOS';
$hesklang['hlic_buyl']='Eine Lizenz kaufen';
$hesklang['hlic_paid']='Lizenziert';
$hesklang['antdemo']='Das Einreichen von Tickets über das Admin-Panel wurde im Demo-Modus deaktiviert.<br><br>Bitte verwenden Sie die <a href="%s" target="_blank">öffentliche Seite</a> um ein Testticket einzureichen.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Verfahren zur Authentifizierung';
$hesklang['email_authentication_method_username_password']='Basic (Benutzername / Passwort)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Keine verifizierten OAuth-Anbieter konfiguriert.';
$hesklang['email_authentication_method_oauth_link']='Verwalten von OAuth-Anbietern'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Autorisierungsendpunkt-URL';
$hesklang['email_oauth_token_url']='Token Endpoint URL';
$hesklang['email_oauth_client_id']='Client ID';
$hesklang['email_oauth_client_secret']='Client Secret';
$hesklang['email_oauth_scope']='Bereich';
$hesklang['oauth_error_invalid_state']='Der OAuth-Status stimmt nicht mit dem an den OAuth-Anbieter gesendeten Status überein.';
$hesklang['oauth_error_unknown']='Beim Versuch, OAuth-Tokens zu speichern, ist ein unbekannter Fehler aufgetreten.';
$hesklang['oauth_error_no_token']='Zugriffstoken fehlt in der JSON-Antwort.';
$hesklang['oauth_error_retrieve']='Ein Zugriffstoken kann nicht abgerufen werden. Bitte bestätigen Sie Ihre OAuth Provider-Einstellungen und speichern Sie sie erneut, um ein neues Token zu erhalten.';
$hesklang['email_oauth_provider']='OAuth-Anbieter';
$hesklang['email_oauth_providers']='OAuth-Anbieter';
$hesklang['email_oauth_provider_guide']='Bevor Sie OAuth verwenden, müssen Sie einen OAuth-Provider registrieren. Für Details siehe bitte <a href="%s" target="_blank">diese Wissensdatenbank-Anleitung</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Ihr OAuth Redirect URI für Hesk lautet: <br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Verwenden Sie dieses Tool, um OAuth-Anbieter zu Ihrem Helpdesk hinzuzufügen';
$hesklang['email_oauth_provider_name']='Name'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Neuer Anbieter';
$hesklang['email_oauth_edit_provider']='Anbieter bearbeiten';
$hesklang['email_oauth_provider_being_used_for']='Wird verwendet für';
$hesklang['email_oauth_providers_none']='Keine OAuth-Anbieter gespeichert. Sie können sie hinzufügen, indem Sie oben auf "Neuer Anbieter" klicken.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Dieser Anbieter kann nicht entfernt werden, da er vom Helpdesk verwendet wird.';
$hesklang['email_oauth_confirm_delete_provider']='Sind Sie sicher, dass Sie diesen OAuth-Anbieter löschen möchten?';
$hesklang['oauth_provider_saved']='OAuth-Anbieter wurde gespeichert';
$hesklang['oauth_provider_use']='Sie können diesen Anbieter nun auswählen in %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Geben Sie den Namen des Anbieters ein';
$hesklang['oauth_provider_err_auth_url']='Geben Sie eine gültige Autorisierungs-URL ein';
$hesklang['oauth_provider_err_token_url']='Geben Sie eine gültige Token-URL ein';
$hesklang['oauth_provider_err_client_id']='Geben Sie die Client-ID ein';
$hesklang['oauth_provider_err_client_secret']='Eingane des "client secrets"';
$hesklang['oauth_provider_err_scope']='Geben Sie den Bereich ein';
$hesklang['oauth_provider_deleted']='OAuth-Anbieter gelöscht';
$hesklang['oauth_provider_not_found']='Dieser OAuth-Anbieter existiert nicht';
$hesklang['oauth_provider_verified']='Verifiziert';
$hesklang['oauth_provider_click_to_verify']='Zum Überprüfen anklicken';
$hesklang['can_due_date']='Kann ablauf Datum setzen'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Sie haben nicht die Erlaubnis, Fälligkeitsdaten festzulegen';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Überprüfen Sie Ihre Registrierung';
$hesklang['customer_verify_new_email']='Überprüfen Sie Ihre neue E-Mail-Adresse';
$hesklang['customer_reset_password']='Setzen Sie Ihr Helpdesk-Passwort zurück';
$hesklang['customer_approved']='Konto Freigegeben';
$hesklang['customer_rejected']='Konto Abgelehnt';
$hesklang['email_rejected']='Konto erforderlich, um Support-Tickets einzureichen';
$hesklang['require_curl']='Für diese Funktion muss die <strong>cURL</strong>-Unterstützung für PHP auf Ihrem Server aktiviert sein. Bitte fragen Sie Ihren Webhoster, um cURL für PHP zu aktivieren.';
$hesklang['customer_accounts_heading']='Kundenkonten';
$hesklang['customer_accounts']='Kundenkonten';
$hesklang['customer_accounts_off']='<strong>Deaktiviert</strong>';
$hesklang['customer_accounts_allowed']='<strong>Aktiviert - Optional</strong> (Kunden können Support-Tickets einreichen, ohne sich zu registrieren oder anzumelden)';
$hesklang['customer_accounts_required_to_submit']='<strong>Aktiviert - Erforderlich für Tickets</strong> (nur eingeloggte Kunden können Support-Tickets einreichen)';
$hesklang['customer_accounts_required']='<strong>Aktiviert - Für den Zugriff erforderlich</strong> (nur angemeldete Kunden können auf den Helpdesk und die Wissensdatenbank zugreifen)';
$hesklang['customer_accounts_reg']='Registrierung eines Kontos';
$hesklang['customer_accounts_reg_customer']='Kunden können Konten registrieren';
$hesklang['customer_accounts_reg_approve']='Kunden können Konto registrieren, Mitarbeiter müssen neue Registrierungen genehmigen';
$hesklang['customer_accounts_reg_staff']='Nur Mitarbeiter können Kundenkonten registrieren';
$hesklang['customer_accounts_allow_email_changes']='Kunden die Möglichkeit geben, ihre E-Mail-Adresse zu ändern';
$hesklang['customer_accounts_allow_email_resends']='Zeit, bis Kunden eine neue Bestätigungs-E-Mail anfordern können';
$hesklang['customer_login']='Anmelden';
$hesklang['customer_logout']='Abmelden';
$hesklang['customer_register']='Registrieren';
$hesklang['customer_accounts_disabled']='Kundenanmeldungen und -registrierungen sind deaktiviert.';
$hesklang['customer_accounts_registration_disabled']='Kundenregistrierungen sind deaktiviert.';
$hesklang['customer_forgot_password']='Passwort vergessen?';
$hesklang['customer_email']='E-Mail Adresse';
$hesklang['customer_accounts_email_banned']='Sie wurden von der Nutzung dieses Helpdesks ausgeschlossen.';
$hesklang['customer_registration_successful']='Anmeldung erfolgreich!';
$hesklang['customer_registration_email_exists_no_reset_link']='Ein Konto mit der E-Mail %s existiert bereits.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Ein Konto mit der E-Mail Adresse %s existiert bereits. <a href="login.php">Möchten Sie sich stattdessen anmelden</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Ein Konto mit der E-Mail %s existiert bereits und muss noch verifiziert werden.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Ein Konto mit der E-Mail %s existiert bereits und muss noch von den Mitarbeitern genehmigt werden.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Prüfen Sie Ihre E-Mail!';
$hesklang['customer_registration_check_your_email_content']='Sie müssen Ihre E-Mail-Adresse verifizieren, bevor Sie sich anmelden können.<br><br>Wenn Sie sie nicht innerhalb weniger Minuten erhalten, überprüfen Sie bitte Ihre Junk-, Bulk- oder Spam-Ordner. Markieren Sie die Nachricht als <b>Nicht SPAM</b>, um Probleme beim Empfang unserer Korrespondenz in Zukunft zu vermeiden.';
$hesklang['customer_login_not_verified']='Sie müssen Ihre E-Mail-Adresse verifizieren, bevor Sie sich anmelden können.';
$hesklang['customer_login_not_verified2']='Wenn Sie die Bestätigungs-E-Mail von uns nicht erhalten haben, überprüfen Sie bitte Ihre Junk-, Bulk- oder Spam-Ordner. Markieren Sie die Nachricht als <b>Nicht SPAM</b>, um Probleme beim Empfang unserer Korrespondenz in Zukunft zu vermeiden.';
$hesklang['customer_login_resend_verification_email']='Verifizierungs-E-Mail erneut senden';
$hesklang['customer_login_resend_verification_email_none']='Es sind keine ausstehenden E-Mail-Bestätigungen zu versenden.';
$hesklang['customer_login_resend_verification_email_too_early']='Sie können zur Zeit keine neue Bestätigungs-E-Mail anfordern. Bitte versuchen Sie es später noch einmal.';
$hesklang['customer_login_not_approved']='Ein Mitglied des Personals muss Ihr Konto genehmigen, bevor Sie sich anmelden können. Sobald die Genehmigung erteilt ist, werden Sie per E-Mail benachrichtigt.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Registrierung überprüfen';
$hesklang['customer_registration_verify_success']='Ihre E-Mail wurde verifiziert und Sie können sich nun über das untenstehende Formular anmelden.';
$hesklang['customer_registration_verify_approval_needed']='Ihre E-Mail wurde überprüft. Allerdings muss ein Mitarbeiter Ihr Konto genehmigen, bevor Sie sich anmelden können. Nach der Genehmigung werden Sie per E-Mail benachrichtigt.';
$hesklang['customer_registration_verify_failure']='Ihre E-Mail konnte nicht verifiziert werden. Entweder wurde der Link bereits verwendet oder er ist abgelaufen.';
$hesklang['emails_to_customers']='&raquo; An Kunden gesendete E-Mails';
$hesklang['emails_to_staff']='&raquo; An das Personal gesendete E-Mails';
$hesklang['emails_to_everyone']='&raquo; An Mitarbeiter oder Kunden gesendete E-Mails';
$hesklang['new_customer_approval']='Sie haben Kundenkonten, die zur Genehmigung anstehen'; // Email subject
$hesklang['desc_new_customer_approval']='(Personal) Kundenkonten, die zur Genehmigung anstehen';
$hesklang['n_cust_app']='Es gibt noch ausstehende Kundengenehmigungen'; // Notify me when...
$hesklang['et_num_customers']='Anzahl der ausstehenden Genehmigungen';
$hesklang['et_link_customers']='Link zur Seite „Kunden verwalten"';
$hesklang['et_link_verify']='Link zur Verifizierung';
$hesklang['et_cust_login']='Kunden-Login-URL';
$hesklang['submit_ticket_customer_email_exists']='Ein Kunde mit dieser E-Mail existiert bereits. Bitte <a href="login.php?email=%s">Anmelden</a> um ein Ticket einzureichen.'; // %s - User's email
$hesklang['customer_login_email_required']='Bitte geben Sie eine gültige E-Mail Adresse ein.';
$hesklang['customer_login_password_required']='Bitte geben Sie Ihr Passwort ein.';
$hesklang['customer_login_remember_just_email']='Erinnern Sie sich nur an meine E-Mail';
$hesklang['customer_login_remember_email']='Erinnern Sie sich an meine E-Mail';
$hesklang['customer_wrong_user']='Ihre E-Mail Adresse %s ist nicht bei uns registriert.<br><br>Möchten Sie <a href="register.php">ein Konto erstellen</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Ihre E-Mail-Adresse und Ihr Passwort stimmen nicht mit unseren Aufzeichnungen überein.<br><br>Möchten Sie <a href="login.php?submittedForgot=1">Ihr Passwort zurücksetzen</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Bitte loggen Sie sich ein, um fortzufahren.';
$hesklang['customer_register_here']='Wenn Sie noch kein Konto bei uns haben, können Sie <a href="register.php">sich hier registrieren</a>.';
$hesklang['create_account']='Ein Konto erstellen';
$hesklang['customer_my_tickets_heading']='Meine Tickets';
$hesklang['customer_my_tickets_description']='Alle Ihre bisherigen Tickets anzeigen';
$hesklang['customer_my_tickets_search_for_tickets']='Suche nach Tickets';
$hesklang['customer_password_reset_successful']='Ihr neues Passwort wurde gespeichert. Sie können sich jetzt anmelden.';
$hesklang['customer_profile']='Profil';
$hesklang['customer_edit_profile']='Profil bearbeiten';
$hesklang['customer_edit_pass']='Passwort bearbeiten';
$hesklang['customer_edit_pass_same']='Ihr neues Passwort darf nicht mit dem bisherigen identisch sein.';
$hesklang['customer_change_email']='E-Mail ändern';
$hesklang['customer_change_email_banned']='Die von Ihnen eingegebene E-Mail ist gesperrt.';
$hesklang['customer_change_email_pending']='Es gibt eine aktuelle Anfrage, Ihre E-Mail-Adresse zu ändern: <b>%s</b><br><br>Wir haben eine E-Mail an diese Adresse geschickt. Bitte klicken Sie auf den Link in der E-Mail, um die Änderung zu bestätigen.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Bestätigungs-E-Mail erneut senden</a>';
$hesklang['customer_change_email_submitted']='Bitte klicken Sie auf den Verifizierungslink, der an folgende Adresse geschickt wurde <b>%s</b> um Ihre neue E-Mail zu bestätigen.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Ihre neue E-Mail-Adresse wurde überprüft und Ihr Profil aktualisiert.';
$hesklang['customer_change_email_disabled']='Die Möglichkeit zur Aktualisierung Ihrer E-Mail-Adresse ist deaktiviert. Kontaktieren Sie uns, wenn Sie Ihre E-Mail-Adresse ändern möchten.';
$hesklang['customer_profile_saved']='Ihr Profil wurde gespeichert.';
$hesklang['customers']='Kunden';
$hesklang['customers_intro']='Kundenkonten ermöglichen es den Kunden, alle ihre Tickets an einem zentralen Ort einzusehen.';
$hesklang['sure_remove_customer']='Sind Sie sicher, dass Sie diesen Kunden Löschen möchten?';
$hesklang['sure_remove_customer_additional_note']='Die Löschung eines Kunden ist endgültig.  Einmal gelöscht, können sie nicht wiederhergestellt werden!';
$hesklang['new_customer']='Neuer Kunde';
$hesklang['new_follower']='Neuer Follower';
$hesklang['add_customer']='+ Kunde hinzufügen'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Follower hinzufügen'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='Der angegebene Kunde existiert noch nicht. Klicken Sie auf „Speichern“, wenn Sie diesen Kunden anlegen möchten.';
$hesklang['followers']='Follower';
$hesklang['no_customers']='Derzeit sind keine Kunden in der Datenbank vorhanden.';
$hesklang['no_customers_disabled']='Hier sehen Sie die ersten Kunden, wenn sie Support-Tickets einreichen.';
$hesklang['no_customers_enabled']='Hier sehen Sie die ersten Kunden, wenn sie sich registrieren oder Support-Tickets einreichen.';
$hesklang['no_customers_enabled2']='Alternativ können Sie über die Schaltflächen oberhalb dieser Meldung manuell Kundenkonten anlegen oder bestehende Kunden in den Helpdesk importieren.';
$hesklang['import_customers']='Kunden importieren';
$hesklang['import_customers_tip']='Verwenden Sie eine CSV-Datei, um mehrere Kunden auf einmal zu importieren.';
$hesklang['customer_not_found']='Kunde für Ticket nicht gefunden!';
$hesklang['search_by_name_or_email']='Suche nach Name oder E-Mail...';
$hesklang['search_by_pattern']='Suche nach Muster...';
$hesklang['is_searchable']='Durchsuchbar';
$hesklang['custom_is_searchable']='Durchsuchbar';
$hesklang['yes_via_autocomplete']='JA (Suche über Autovervollständigung)';
$hesklang['customer_required']='Sie müssen einen Kunden auswählen';
$hesklang['customer_email_exists']='Ein Kunde mit dieser E-Mail existiert bereits.';
$hesklang['customer_name_with_no_email_exists']='Ein Kunde mit diesem Namen und ohne E-Mail existiert bereits.';
$hesklang['an_error_occurred_validating_email']='Beim Versuch, die eingegebene E-Mail-Adresse zu überprüfen, ist ein Fehler aufgetreten.';
$hesklang['customer_count_x_more']='+%s mehr'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registriert';
$hesklang['customer_account_verified']='Verifiziert';
$hesklang['customer_account_verified_help']='Die Kunden müssen ihr Konto über einen Aktivierungslink verifizieren, der an ihre E-Mail-Adresse gesendet wird, bevor sie sich in ihr Konto einloggen können.';
$hesklang['customer_account_setting_password_will_verify_user']='Wenn Sie ein Passwort für diesen Kunden festlegen, wird sein Konto automatisch verifiziert.';
$hesklang['deleting_customer_with_tickets']='Dieser Kunde hat %1$s Ticket(s) <b>(%2$s offen)</b> die auch mit anderen Kunden verknüpft sind.<br> Was soll mit diesen Tickets geschehen?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Für die erneute Zusendung einer Bestätigungs-E-Mail ist eine gültige E-Mail-Adresse erforderlich.';
$hesklang['customer_resend_verification_email_not_found']='Es existiert kein Konto mit dieser E-Mail-Adresse, oder das Konto wurde bereits verifiziert.';
$hesklang['customer_resend_verification_email_sent']='Es wurde eine Bestätigungs-E-Mail an Ihre E-Mail-Adresse gesendet.<br><br>Wenn Sie sie nicht innerhalb weniger Minuten erhalten, überprüfen Sie bitte Ihre Junk-, Bulk- oder Spam-Ordner. Markieren Sie die Nachricht als <b>Kein SPAM</b>, um Probleme beim Empfang unserer Korrespondenz in Zukunft zu vermeiden.';
$hesklang['customer_permission_denied']='Sie haben nicht die Erlaubnis, Kunden zu ändern.';
$hesklang['customer_manage_approvals']='Kundenkonten, die zur Genehmigung anstehen: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Kunde genehmigen';
$hesklang['customer_manage_bulk_approve']='Ausgewählte Kunden genehmigen';
$hesklang['customer_manage_bulk_approve_complete']='Kunden genehmigt: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Kunde ablehnen';
$hesklang['customer_manage_bulk_reject']='Ausgewählte Kunden ablehnen';
$hesklang['customer_manage_bulk_reject_complete']='Kunden abgelehnt: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Kunde löschen';
$hesklang['customer_manage_bulk_delete']='Ausgewählte Kunden löschen';
$hesklang['customer_manage_bulk_delete_complete']='Kunden gelöscht: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Kunde bearbeiten';
$hesklang['customer_manage_verification_email_sent']='Die Verifizierungs-E-Mail wurde gesendet an %s'; // %s = customer's email
$hesklang['can_man_customers']='Kunden verwalten';
$hesklang['can_view_customers']='Alle Kunden anzeigen (aber nicht verwalten)';
$hesklang['import_customer_select_file']='Datei auswählen';
$hesklang['import_customer_step1_instructions']='Um Kunden zu importieren, bereiten Sie eine CSV-Datei (Komma-getrennte Werte) vor.';
$hesklang['import_customer_step1_note']='Wählen Sie Ihre CSV-Datei';
$hesklang['import_customer_step1_separator']='Die Spalten in meiner CSV-Datei sind getrennt durch';
$hesklang['import_customer_sample']='&raquo; Beispiel-CSV-Dateien';
$hesklang['import_customer_sample_1']='CSV-Datei im US-Stil mit Spalten, die durch ,';
$hesklang['import_customer_sample_2']='CSV-Datei im EU-Stil mit Spalten, die durch ;';
$hesklang['import_customer_upload_requirements_1']='Ihre CSV-Datei muss mindestens eine Namens- oder eine E-Mail-Adressspalte enthalten. Die Passwortspalte ist optional.';
$hesklang['import_customer_upload_requirements_2']='Die erste Zeile Ihrer Datei muss Spaltenüberschriften enthalten.';
$hesklang['import_customer_upload_requirements_3']='Ihre Datei muss in UTF-8 kodiert sein.';
$hesklang['import_customer_select_columns']='Spalten auswählen';
$hesklang['import_customer_upload_customers']='Kunden hochladen';
$hesklang['import_customer_column_name']='Namensspalte';
$hesklang['import_customer_column_email']='E-Mail-Spalte';
$hesklang['import_customer_column_pass']='Passwort-Spalte';
$hesklang['import_customer_step2_note']='Wählen Sie den richtigen Spaltennamen aus Ihrer CSV-Datei in den Dropdowns aus und klicken Sie dann auf „Weiter“.';
$hesklang['import_customer_name_or_email_required']='Name oder E-Mail ist erforderlich';
$hesklang['import_customer_step3_note']='Ihre Kunden werden gerade importiert. Verlassen Sie diese Seite nicht!';
$hesklang['import_customer_step3_pending']='ausstehend';
$hesklang['import_customer_step3_successful_imports']='Erfolgreiche Importe';
$hesklang['import_customer_step3_failed_imports']='Fehlgeschlagene Importe';
$hesklang['import_customer_step3_progress']='Fortschritt';
$hesklang['import_customer_step3_complete_some_failed']='Der Importvorgang ist abgeschlossen, aber <b>%s</b> Kunden konnten nicht importiert werden. Prüfen Sie die Tabelle unten für weitere Informationen.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='Der Importvorgang ist abgeschlossen!';
$hesklang['import_customer_step3_importing']='Importiere';
$hesklang['staff_deleted']='[Personal Gelöscht]';
$hesklang['customer_account_approved']='Kundenregistrierung genehmigt';
$hesklang['customer_account_rejected']='Kundenregistrierung abgelehnt';
$hesklang['customer_account_deleted']='Kundenregistrierung gelöscht';
$hesklang['ticket_followers']='Ticket-Follower';
$hesklang['ticket_followers2']='Erlauben, dass Tickets mehrere Kunden haben können';
$hesklang['add_cc']='Cc hinzufügen';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Trennen Sie jede E-Mail durch ein Komma.';
$hesklang['search_customers']='Kunden suchen';
$hesklang['page_size']='Anzahl der ergebnisse';
$hesklang['customers_on_pages']='Anzahl der Kunden: %d | Anzahl der Seiten: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Kunde) Passwort zurücksetzen';
$hesklang['desc_customer_verify_registration']='(Customer) Verify your registration';
$hesklang['desc_customer_verify_new_email']='(Kunde) Überprüfen Sie Ihre neue E-Mail';
$hesklang['desc_customer_approved']='(Kunde) Konto genehmigt';
$hesklang['desc_customer_rejected']='(Kunden-)Konto abgelehnt';
$hesklang['desc_email_rejected_can_self_register']='(Kunde) Ticket per E-Mail abgelehnt; Kunde kann sich selbst registrieren';
$hesklang['desc_email_rejected_cannot_self_register']='(Kunde) Ticket per E-Mail abgelehnt; Kunde kann sich nicht selbst registrieren';
$hesklang['user_added_success_no_pass']='Der neue Benutzer %s wurde erfolgreich hinzugefügt';
$hesklang['email_tag_requester']='Antragsteller (von)';
$hesklang['email_tag_requester_name']='Name des Antragstellers (von)';
$hesklang['email_tag_requester_first_name']='Antragsteller (von) Vorname';
$hesklang['email_tag_requester_email']='Antragsteller (von) E-Mail';
$hesklang['email_tag_followers']='Follower (Cc)';
$hesklang['email_tag_follower_names']='Follower (Cc) Namen';
$hesklang['email_tag_follower_emails']='Follower (Cc) E-Mails';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Anzeige eines Barcodes auf gedruckten Tickets';
$hesklang['barcode_staff_only']='Verstecken Sie den Barcode vor Kunden';
$hesklang['barcode_type']='Barcode-Typ';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Breite';
$hesklang['barcode_height']='Höhe';
$hesklang['barcode_color']='Farbe';
$hesklang['barcode_bg']='Hintergrund';
$hesklang['copy_link']='Ticket-Link kopieren';
$hesklang['copy_link_title']='Öffentlichen Link zu diesem Ticket kopieren';
$hesklang['copy_link_exp']='Der kopierte Link ist der direkte Link, über den der Kunde dieses Ticket einsehen kann';
$hesklang['copy_value']='Kopieren Sie diesen Wert';
$hesklang['download_class']='Diese Funktion erfordert die Klasse ZipArchive. Bitten Sie Ihren Host, PHP mit Zip-Unterstützung zu kompilieren.';
$hesklang['download_all']='Alles Runterladen';
$hesklang['download_prep']='Bereite download vor...';
$hesklang['download_tma']='Zu viele Anhänge';
$hesklang['download_nva']='Keine zulässigen Anhänge';
$hesklang['download_ntd']='Nichts zum Herunterladen';
$hesklang['resolved_at']='Gelöst am';
$hesklang['disable_GSSAPI']='GSSAPI-Authentifikator deaktivieren (Kerberos-Fehlerumgehung)';
$hesklang['ex_history']='Ticketverlaufsprotokoll in den Export einbeziehen';
$hesklang['sm_location']='Standort'; // Location (page) of a service message
$hesklang['loc_sm']='Zeigen Sie diese Servicemeldung an:';
$hesklang['loc_all']='Jede Kundenseite';
$hesklang['loc_norec']='(nicht empfohlen)';
$hesklang['loc_home']='Helpdesk-Startseite';
$hesklang['loc_selected']='Auf ausgewählten Seiten';
$hesklang['loc_selerr']='Wählen Sie mindestens eine Seite aus, auf der die Nachricht angezeigt werden soll';
$hesklang['loc_t_cat']='Ticket einreichen - wählen Sie eine Kategorie';
$hesklang['loc_t_add']='Ein Ticket einreichen - Formular zum Einreichen eines Tickets';
$hesklang['loc_t_ok']='Ein Ticket einreichen - Ticketbestätigung';
$hesklang['loc_t_view']='Ticket ansehen';
$hesklang['loc_t_form']='Ticketformular anzeigen';
$hesklang['loc_kb_main']='Startseite der Wissensdatenbank';
$hesklang['loc_kb_sub']='Unterseiten der Wissensdatenbank';
$hesklang['loc_kb_art']='Wissensdatenbank-Artikel';
$hesklang['loc_login']='Kundenlogin-Seite';
$hesklang['loc_register']='Kundenregistrierungsseite';
$hesklang['loc_register_ok']='Kundenregistrierung erfolgreich';
$hesklang['loc_acc']='Kunden &quot;Meine Tickets&quot; Seite';
$hesklang['loc_profile']='Kunden &quot;Profil&quot; Seite';
$hesklang['sending_show']='&quot;Senden&quot; Benachrichtigung anzeigen';
$hesklang['sending_wait']='Übermittlung, bitte warten...';
$hesklang['e_c_email']='Geben Sie die richtige E-Mail-Adresse ein, um dieses Ticket zu sehen';
$hesklang['only_verified_cc']='Follower, die kein verifiziertes Konto haben, werden ignoriert.';
$hesklang['followers_removed']='Diese E-Mail-Adressen wurden aus dem Ticket entfernt, da sie über kein verifiziertes Konto verfügen:';
$hesklang['novace']='Wir haben keine registrierten und verifizierten Konten mit dieser E-Mail-Adresse gefunden.';
$hesklang['max_recipients']='Maximale Empfänger';
$hesklang['max_recipients2']='in einer einzigen E-Mail';
$hesklang['admin_js']='Eigenes JS';
$hesklang['admin_js2']='Laden Sie eine zusätzliche benutzerdefinierte Javascript-Datei für das Admin-Panel';
$hesklang['cf_limit_all']='Sie haben das Limit der benutzerdefinierten Felder erreicht und können keine neuen benutzerdefinierten Felder erstellen.';
$hesklang['remind_assigned']='Das zugewiesene Personal daran erinnern';
$hesklang['remind_sent']='E-Mail-Erinnerung an den zugewiesenen Mitarbeiter gesendet';
$hesklang['thist23']='<li class="smaller">%s | Erinnerung gesendet an %s von %s</li>';
$hesklang['ql_bookmarks']='Lesezeichen';
$hesklang['bookmark']='Mein Lesezeichen';
$hesklang['bookmarks_add']='Zu den Lesezeichen hinzufügen';
$hesklang['bookmarks_added']='Dieses Ticket wurde zu Ihren Lesezeichen hinzugefügt';
$hesklang['bookmarks_remove']='Von Lesezeichen Entfernen';
$hesklang['bookmarks_removed']='Dieses Ticket wurde aus Ihren Lesezeichen entfernt';
$hesklang['genl_not_copied']='Fehler: Kopieren in die Zwischenablage wird von diesem Gerät/Browser nicht unterstützt.';
$hesklang['profile_duplicate_email']='Benutzer mit E-Mail <b>%s</b> existiert bereits.'; // %s: new email
$hesklang['seq_id_numeric']='Die Suche nach Ticketnummern darf nur Zahlen enthalten';
$hesklang['confirm_new_pass']='Neues Passwort bestätigen';
$hesklang['piping_notify_rejected_customers1']='Ablehnungs-E-Mails von Kunden';
$hesklang['piping_notify_rejected_customers2']='Senden Sie eine Ablehnungs-E-Mail an Kunden, wenn ihr Ticket abgelehnt wurde.';
$hesklang['piping_notify_rejected_customers3']='Zeit zwischen den Ablehnungs-E-Mails';
$hesklang['register_url']='Registrierung URL';
$hesklang['email_subject']='Betreff der E-Mail';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Zusammenarbeit am Ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Das Personal antwortete auf: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Anmerkung hinzugefügt zu: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket überfällig: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket erledigt: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Annahmeschluss für Follow-up-E-Mails:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Mailen Sie keine Tickets, die mehr als'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='vor (muss länger zurückliegen als "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='Die Frist für das Auslaufen der E-Mail muss länger sein als die Frist für die Follow-up-E-Mail';
$hesklang['available_language']='Verfügbare Sprachen';
$hesklang['click_to_show_available_language']='Anklicken, um verfügbare Sprachen anzuzeigen';
$hesklang['install_lan']='Installieren';
$hesklang['remove_lan']='Entfernen';
$hesklang['title_lan']='Titel';
$hesklang['description_lan']='Beschreibung';
$hesklang['completed_lan']='Erledigt';
$hesklang['no_language_availble']='Es sind keine Sprachen verfügbar';
$hesklang['success_install_lan_txt']='Die Sprache wurde erfolgreich hinzugefügt';
$hesklang['error_install_lan_txt']='Die Sprache wurde nicht hinzugefügt';
$hesklang['success_remove_lan_txt']='Die Sprache wurde erfolgreich entfernt';
$hesklang['error_remove_lan_txt']='die Sprache wurde nicht entfernt';
$hesklang['remove_default_language_error']='Die Standardsprache muss aktiv bleiben und kann nicht entfernt werden';
$hesklang['click_for_manual_step']='Klicken Sie für die manuelle Installation';
$hesklang['upgrade_lan']='Aktualisieren';
$hesklang['success_upgrade_lan_txt']='Sprache wurde erfolgreich aktualisiert';
$hesklang['error_upgrade_lan_txt']='Sprache wurde nicht aktualisiert';
$hesklang['please_wait']='Bitte warten...';
$hesklang['add_a_note']='Hinterlasse eine Notitz';
$hesklang['add_a_reply']='Eine Antwort hinzufügen';
$hesklang['customer_id']='Kunden-ID';
$hesklang['deleting_customer_tickets']='Tickets geöffnet von Kunde: <b>%1$s</b><br>Was sollen wir mit diesen Tickets machen?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets, bei denen der Kunde kopiert wird: <b>%1$s</b><br>Sie werden diesen Kunden als Follower verlieren; Tickets bleiben unverändert.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Tickets dauerhaft löschen';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymisieren von Tickets (Entfernen von Nachrichten und persönlichen Daten)';
$hesklang['deleting_customer_retain_tickets2']='Tickets aufbewahren (alle Daten intakt lassen)';
$hesklang['for_staff']='für Helpdesk-Mitarbeiter'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='für Kunden'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Optionen für E-Mail-Anhänge';
$hesklang['link_to_attachments_in_emails']='Link zu Anhängen von E-Mails';
$hesklang['add_attachments_directly_to_emails']='Anhänge direkt zu E-Mails hinzufügen';
$hesklang['directly_attach_file_smaller_than']='Hängen Sie nur Dateien direkt an, die kleiner sind als';
$hesklang['directly_attach_file_of_any_size']='Direktes Anhängen von Dateien beliebiger Größe';
$hesklang['directly_attach_only_first_x_attachments']='Nur erste Datei anhängen';
$hesklang['directly_attach_all_attachments']='Alle Dateien anhängen';
$hesklang['directly_attach_size']='Angang größe';
$hesklang['directly_attach_no_of_files']='Anzahl Dateien';
$hesklang['notice_about_directly_attach_files']='Das Anhängen vieler oder großer Dateien an E-Mails kann zu Verzögerungen bei der Kommunikation mit Ihrem SMTP-Server führen.';
$hesklang['fatt_2']='Zusätzliche Dateien im Anhang zu dieser Nachricht:';
$hesklang['no_collaborators']='Keine';
$hesklang['collaborate']='An diesem Ticket mitarbeiten';
$hesklang['collaborators']='Mitbearbeiter';
$hesklang['ql_cbm']='Mitbearbeiter';
$hesklang['collaborating']='Sie arbeiten jetzt an diesem Ticket mit';
$hesklang['not_collaborating']='Sie arbeiten nicht mehr an diesem Ticket mit';
$hesklang['add_collaborator']='Einen Mitarbeiter hinzufügen';
$hesklang['user_collaborator_added']='Benutzer als Mitwirkender an diesem Ticket hinzugefügt';
$hesklang['remove_collaborator']='Mitarbeiter entfernen';
$hesklang['staff_name']='Name des Personals';
$hesklang['user_collaborator_removed']='Benutzer als Mitwirkender an diesem Ticket entfernt';
$hesklang['desc_collaborator_added']='(Mitarbeiter) Sie arbeiten an einem neuen Ticket mit';
$hesklang['desc_collaborator_staff_reply']='(Mitarbeiter) Ein Mitarbeiter hat auf ein kollaboriertes Ticket geantwortet';
$hesklang['desc_collaborator_note']='(Mitarbeiter) Neue Notiz zu einem gemeinsam genutzten Ticket hinzugefügt';
$hesklang['desc_collaborator_resolved']='(Mitarbeiter) Ein kollaboriertes Ticket wurde gelöst';
$hesklang['desc_collaborator_overdue']='(Mitarbeiter) Ein gemeinsames Ticket ist überfällig';
$hesklang['notify_collaborator_added']='Ich bin als Ticket-Mitarbeiter hinzugefügt';
$hesklang['notify_collaborator_customer_reply']='Kunde antwortet auf ein gemeinsames Ticket';
$hesklang['notify_collaborator_staff_reply']='Mitarbeiter antworten auf ein gemeinsames Ticket';
$hesklang['notify_collaborator_note']='Mitarbeiter fügt eine Notiz zu einem gemeinsamen Ticket hinzu';
$hesklang['notify_collaborator_resolved']='Mitarbeiter lösen ein gemeinsames Ticket';
$hesklang['notify_collaborator_overdue']='Gemeinsames Ticket ist überfällig';
$hesklang['recurring_tickets']['tab']='Wiederkehrende Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Wiederkehrende Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatisieren Sie die Arbeit; lassen Sie Hesk Routine-Tickets für Sie erstellen, genau dann, wenn Sie sie brauchen.';
$hesklang['recurring_tickets']['active_rules']='Aktive Regeln';
$hesklang['recurring_tickets']['new']='Neue Regel für wiederkehrende Tickets';
$hesklang['recurring_tickets']['no_rules']='Sie haben noch keine Regeln für wiederkehrende Tickets. Erstellen Sie eine, indem Sie oben auf die Schaltfläche &quot;Neue wiederkehrende Ticketregel&quot; klicken.';
$hesklang['recurring_tickets']['title']='Titel der Regel';
$hesklang['recurring_tickets']['titlet']='Ein beschreibender Titel, zum Beispiel: Nicht innerhalb eines Tages beantwortete Tickets neu zuweisen';
$hesklang['recurring_tickets']['default_title']='Regel durch %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Regelauslöser';
$hesklang['recurring_tickets']['trigt']='Legen Sie die Bedingung fest, die diese Regel auslösen (ausführen) soll.';
$hesklang['recurring_tickets']['hits']='Treffer'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Erstellungszeit'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Allgemeine Einstellungen'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Benutzerdefinierte Felder'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Inhalt'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Diese Regel löschen?';
$hesklang['recurring_tickets']['edit']='ID der Regel für wiederkehrende Tickets bearbeiten %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Innerhalb:';
$hesklang['recurring_tickets']['minutes']='Minuten';
$hesklang['recurring_tickets']['hours']='Stunden';
$hesklang['recurring_tickets']['days']='Tage';
$hesklang['recurring_tickets']['weeks']='Wochen';
$hesklang['recurring_tickets']['months']='Monate';
$hesklang['recurring_tickets']['years']='Jahre';
$hesklang['recurring_tickets']['setpri']='Priorität einstellen auf:';
$hesklang['recurring_tickets']['setsta']='Status setzen auf:';
$hesklang['recurring_tickets']['assto']='Ticket zuweisen an:';
$hesklang['recurring_tickets']['asm']='Ein weiteres Mitglied des Personals';
$hesklang['recurring_tickets']['notify']='Benachrichtigung des Personals...';
$hesklang['recurring_tickets']['ato']='Anwenden auf:';
$hesklang['recurring_tickets']['save']='Regel speichern';
$hesklang['recurring_tickets']['e_tt']='Die Zeit sollte zwischen 1 und 10000 liegen.';
$hesklang['recurring_tickets']['nocat']='Wählen Sie mindestens eine Kategorie';
$hesklang['recurring_tickets']['nouser']='Mindestens einen Benutzer auswählen';
$hesklang['recurring_tickets']['nostatus']='Wählen Sie mindestens einen Status';
$hesklang['recurring_tickets']['nocata']='%1$s hat keine Berechtigung zu diesen Kategorien:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Neue Regel wurde erstellt';
$hesklang['recurring_tickets']['mdf']='Die Regeleinstellungen wurden gespeichert';
$hesklang['recurring_tickets']['e_id']='Keine Regel mit dieser ID gefunden';
$hesklang['recurring_tickets']['deleted']='Die ausgewählte Regel wurde gelöscht';
$hesklang['recurring_tickets']['log_title']='Regel #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Aktiv'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Aktivieren Sie diese Regel (verwenden Sie sie)';
$hesklang['recurring_tickets']['activated']='Ausgewählte Regel wurde aktiviert'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deaktivieren Sie diese Regel (verwenden Sie sie nicht mehr)';
$hesklang['recurring_tickets']['deactivated']='Die ausgewählte Regel wurde deaktiviert'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Keine aktiven Regeln für wiederkehrende Tickets';
$hesklang['recurring_tickets']['tools']='Werkzeuge';
$hesklang['recurring_tickets']['tbef']='Bevor eine Regel aktiv wird, müssen Sie sie aktivieren, indem Sie das Kontrollkästchen in der Spalte &quot;ACTIVE&quot;.<br><br>
                               <strong>Aktive Regeln werden alle %2$s Minuten verarbeitet.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Regel #%s';
$hesklang['recurring_tickets']['r3']='Regel #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Anzahl der heute bereits erstellten Tickets: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Diese Regel zurücksetzen';
$hesklang['recurring_tickets']['reset2']='Sind Sie sicher, dass Sie diese Regel zurücksetzen wollen?<br><br>Die Treffer der Regel werden auf 0 gesetzt und alle Tickets, die heute bereits für diese Regel generiert wurden, können beim nächsten Cron-Lauf erneut generiert werden.';
$hesklang['recurring_tickets']['reset3']='Die ausgewählte Regel wurde zurückgesetzt';
$hesklang['recurring_tickets']['test']='Diese Regel simulieren';
$hesklang['recurring_tickets']['testa']='Alle Regeln simulieren';
$hesklang['recurring_tickets']['testaa']='Alle aktiven Regeln simulieren';
$hesklang['recurring_tickets']['testr']='Ergebnisse der Simulation';
$hesklang['recurring_tickets']['rsim']='Wiederholung der Simulation';
$hesklang['recurring_tickets']['sim']='SIMULATIONSMODUS, keine Änderungen an der Datenbank';
$hesklang['recurring_tickets']['sic']='SIMULATION ABGESCHLOSSEN';
$hesklang['recurring_tickets']['rrule_type_required']='Bitte wählen Sie einen gültigen Auslöser für eine wiederkehrende Regel.';
$hesklang['recurring_tickets']['rrule_string_required']='Bitte wählen Sie alle erforderlichen Optionen für den Auslöser einer wiederkehrenden Regel aus.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Bitte geben Sie für „Jede“ einen Intervallwert von 1 oder größer ein.';
$hesklang['recurring_tickets']['disable_note']='*Wenn kritische Hesk-Einstellungen nach der Erstellung einer Regel geändert werden, wird sie beim nächsten Laufversuch deaktiviert und muss bearbeitet werden, um die neuen Validierungsanforderungen zu erfüllen.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | eingereicht von Recurring Tickets Regel "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | zugewiesen an %2$s durch die Regel für wiederkehrende Tickets "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | automatisch durch die Regel für wiederkehrende Tickets geschlossen "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | Status durch Regel für wiederkehrende Tickets auf %2$s geändert "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatisch %2$s durch die Regel für wiederkehrende Tickets zugewiesen "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Regel wurde aufgrund von Validierungsfehlern deaktiviert. Für Details siehe unten.';
$hesklang['recurring_tickets']['errors_title']='Eine oder mehrere Ihrer Regeln haben beim Versuch, sie auszuführen, Fehler verursacht und wurden deaktiviert.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Regel #%s fehler:';
$hesklang['recurring_tickets']['create_customers']='Es gibt keine bestehenden Kunden - bitte erstellen Sie sie <a href="%s" target="_blank">hier</a>.';
$hesklang['recurring_tickets']['exec_dates']='Termine der Regelausführung';
$hesklang['recurring_tickets']['show_exec_dates']='[Aktuelle Ausführungsdaten der Regel anzeigen]';
$hesklang['recurring_tickets']['no_exec_dates']='Bitte wählen Sie gültige Regelauslöser aus, um die Ausführungsdaten zu sehen.';
$hesklang['recurring_tickets']['invalid_disabled']='Ungültige Regeleinstellungen - Regel deaktiviert.';
$hesklang['recurring_tickets']['next_occ']='Nächstes Auftreten von %s Regeln:';
$hesklang['recurring_tickets']['occ_on']='auf %s';
$hesklang['recurring_tickets']['not_firing_today']='muss heute nicht geschossen werden.';
$hesklang['recurring_tickets']['rules_fulfilled']='Wiederkehrende Regeln erfüllt - Ticket heute erstellt!';
$hesklang['recurring_tickets']['validation_failed']='Validierung fehlgeschlagen - Regel deaktiviert. Details unten:';
$hesklang['recurring_tickets']['validation_error']='Validierungsfehler:';
$hesklang['recurring_tickets']['processed']='verarbeitet.';
$hesklang['recurring_tickets']['created_ticket']='Ticket-ID erstellt: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relativ zum Erstellungsdatum des Tickets';
$hesklang['priorities']='Prioritäten';
$hesklang['priority_intro']='Verwenden Sie dieses Tool, um die Prioritäten von Tickets für Ihren Helpdesk zu verwalten.';
$hesklang['new_priority']='Neue Priorität';
$hesklang['edit_priority']='Priorität bearbeiten';
$hesklang['priority_title']='Titel';
$hesklang['can_customers_select_it']='Können die Kunden diese Priorität auswählen?';
$hesklang['selected_by_customer']='Vom Kunden auswählbar';
$hesklang['err_priority']='Geben Sie den Prioritätstitel ein';
$hesklang['priority_added']='Es wurde eine neue Priorität hinzugefügt';
$hesklang['priority_e_id']='Ungültige Prioritäts-ID';
$hesklang['priority_mdf']='Die Priorität wurde gespeichert';
$hesklang['priority_deleted']='Priorität gelöscht';
$hesklang['priority_not_found']='Diese Priorität existiert nicht';
$hesklang['priority_not_empty']='Diese Priorität kann nicht gelöscht werden, da Tickets mit dieser Priorität existieren';
$hesklang['click_to_enable_drag_drop']='Klicken Sie auf , um das Ziehen und Ablegen für die Zeile zu aktivieren, und ziehen Sie dann die Zeile nach oben oder unten, um die Prioritäten neu zu ordnen.';
$hesklang['confirm_delete_priority']='Sind Sie sicher, dass Sie diese Priorität löschen wollen?';
$hesklang['reordered_message']='Die Reihenfolge Ihrer Prioritätenliste wurde gespeichert.';
$hesklang['list_tkt_priority']='Liste aller Tickets mit dieser Priorität';
$hesklang['deletion_priority_restricted']='Dies ist ein Sondervorrecht und kann nicht gelöscht werden.';
$hesklang['priority_limit']='Sie können keine neuen Prioritäten erstellen';
$hesklang['skip_to_main_content']='Zum Hauptinhalt wechseln';
$hesklang['opens_dialog']='Öffnet einen Dialog';
$hesklang['create_a_ticket']='Ein Ticket erstellen';
$hesklang['toggle_navigation']='Umschalten der Navigation';
$hesklang['add_a_ticket_reply']='Antwort auf ein Ticket hinzufügen';
$hesklang['linked_tickets']='Verknüpfte Tickets';
$hesklang['no_linked_tickets']='Keine verknüpften Tickets';
$hesklang['link_ticket']='Ticket verknüpfen';
$hesklang['can_link_tickets_e']='Sie sind nicht berechtigt, dieses Ticket zu verknüpfen';
$hesklang['link_ticket_success']='Das Ticket wurde erfolgreich verknüpft';
$hesklang['link_ticket_required_error']='Um ein Ticket zu verknüpfen, geben Sie bitte eine gültige Tracking-ID an';
$hesklang['link_ticket_itself_error']='Ein Ticket kann nicht mit sich selbst verknüpft werden. Bitte geben Sie eine andere Tracking-ID ein';
$hesklang['already_linked_error']='Das Ticket ist bereits verknüpft';
$hesklang['unlink_success']='Das Ticket wurde erfolgreich entkoppelt';
$hesklang['unlink_error']='Es gibt keinen verknüpften Datensatz';
$hesklang['link_history']='<li class="smaller">%s | %s Ticket verknüpft mit %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s Ticket entkoppelt von %s</li>';
$hesklang['can_link_tickets']='Kann Ticket verknüpfen';
$hesklang['link_a_ticket']='Ticket verknüpfen';
$hesklang['mfa_curl']='Es kann kein QR-Bild zum Scannen erzeugt werden, weil <strong>cURL</strong> Unterstützung ist auf Ihrem Server nicht aktiviert.';
$hesklang['require_xml']='PHP-XML muss für Rich Text (HTML) Nachrichten aktiviert sein. Bitten Sie Ihren Webhoster, XML für PHP zu aktivieren.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s hinzugefügt als Mitarbeiter von %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s als Mitarbeiter entfernt von %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Ideal für vorbeugende Wartungsarbeiten, monatliche Zugangsprüfungen, wiederkehrende Kundenkontrollen und vieles mehr.';
$hesklang['recurring_tickets']['feat1']='<strong>Zeitpläne festlegen und vergessen.</strong> Täglich, jeden Montag, jeden März, am 15. eines jeden Monats oder an jedem zukünftigen Datum';
$hesklang['recurring_tickets']['feat2']='<strong>Sie kommen vorgefüllt und zugewiesen an.</strong> Wählen Sie Kategorie, Priorität, Bearbeiter und bis zu 100 benutzerdefinierte Feldwerte';
$hesklang['recurring_tickets']['feat3']='<strong>Terminvorschau und Simulieren.</strong> Sehen Sie alle Tickets, die Hesk erstellt, bevor Sie eine Regel aktivieren, damit es keine Überraschungen gibt.';
$hesklang['unlink_btn']='Aufheben der Verknüpfung';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');