<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Español (Spanish)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Franxisco Flores (http://www.franxiscoflores.com)
* OCReactive (Óscar Cuesta)
* Alberto Gimeno Marión (https://www.aliksi.es)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Español';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Spanish';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_spanish_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Responder sobre esta línea ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Nuevo ticket: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Ticket recibido: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Ticket asignado: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nueva respuesta para: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nueva respuesta para: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Ticket movido: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Nota agregada a: %%SUBJECT%%';
$hesklang['new_pm']='Nuevo mensaje privado: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Lista de sus tickets de soporte';

// ERROR MESSAGES
$hesklang['cant_connect_db']='¡No se puede conectar a la base de datos!';
$hesklang['invalid_action']='Acción no permitida';
$hesklang['select_username']='Por favor, seleccione su nombre de usuario';
$hesklang['enter_pass']='Por favor, teclee su contraseña';
$hesklang['cant_sql']='No se puede ejecutar SQL';
$hesklang['contact_webmsater']='Por favor notifique al administrador en';
$hesklang['mysql_said']='MySQL dice';
$hesklang['wrong_pass']='Contraseña incorrecta.';
$hesklang['session_expired']='Su sesión ha caducado, por favor identifíquese a través del siguiente formulario.';
$hesklang['attempt']='¡Intento no válido!';
$hesklang['not_authorized_tickets']='Usted no está autorizado para ver los tickets dentro de esta categoría';
$hesklang['must_be_admin']='¡Usted no está autorizado para ver esta página! Para ver esta página debe ser administrador.';
$hesklang['no_session']='¡No se puede iniciar una nueva sesión!';
$hesklang['error']='Error';
$hesklang['int_error']='Error de Script Interno';
$hesklang['no_trackID']='No hay ID de seguimiento';
$hesklang['status_not_valid']='Estado no es válido';
$hesklang['trackID_not_found']='ID de seguimiento no encontrado';
$hesklang['enter_message']='Por favor introduzca su mensaje';
$hesklang['select_priority']='Por favor seleccione su prioridad';
$hesklang['ticket_not_found']='¡Ticket no encontrado! ¡Por favor asegúrese que ha introducido el ID de seguimiento correcto!';
$hesklang['no_selected']='No hay tickets seleccionados, nada que cambiar';
$hesklang['id_not_valid']='Este no es un ID válido';
$hesklang['enter_id']='Por favor indique el ID de seguimiento';
$hesklang['enter_name']='Por favor indique el nombre de cliente';
$hesklang['enter_date']='Por favor indique la fecha que desea buscar en';
$hesklang['date_not_valid']='Esta no es una fecha válida. Por favor introduzca la fecha en el siguiente formato: <b>YYYY-MM-DD</b>';
$hesklang['enter_subject']='Por favor indique el asunto del ticket';
$hesklang['invalid_search']='Acción de búsqueda inválida';
$hesklang['choose_cat_ren']='Por favor seleccione categoría a ser renombrada';
$hesklang['cat_ren_name']='Por favor escriba el nuevo nombre de la categoría';
$hesklang['cat_not_found']='Categoría no encontrada';
$hesklang['enter_cat_name']='Por favor indique el nombre de la categoría';
$hesklang['no_cat_id']='Ninguna categoría de identificación';
$hesklang['cant_del_default_cat']='No puede eliminar la categoría por defecto, sólo puede renombrarla';
$hesklang['no_valid_id']='Usuario de identificación no válido';
$hesklang['user_not_found']='Usuario no encontrado';
$hesklang['enter_real_name']='Por favor indique el nombre real del usuario';
$hesklang['enter_valid_email']='Por favor indique un e-mail válido';
$hesklang['enter_username']='Por favor indique su usuario (login)';
$hesklang['asign_one_cat']='¡Por favor, asigne usuario al menos en una categoría!';
$hesklang['signature_long']='¡La firma del usuario es demasiado larga! Por favor, limite la firma a 1000 caracteres';
$hesklang['confirm_user_pass']='Por favor confirme contraseña';
$hesklang['passwords_not_same']='¡Las contraseñas introducidas no concuerdan!';
$hesklang['cant_del_admin']='¡No puede eliminar el administrador por defecto!';
$hesklang['cant_del_own']='¡No puede eliminar el perfil en el que se encuentra logueado!';
$hesklang['enter_your_name']='Por favor indique su nombre';
$hesklang['sel_app_cat']='Por favor seleccione la categoría apropiada';
$hesklang['sel_app_priority']='Por favor seleccione la prioridad apropiada';
$hesklang['enter_ticket_subject']='Por favor indique el asunto de su ticket';
$hesklang['user_not_found_nothing_edit']='Usuario no encontrado o nada que cambiar';

// ADMIN PANEL
$hesklang['administrator']='Administrador';
$hesklang['login']='Login';
$hesklang['user']='Usuario';
$hesklang['username']='Nombre de Usuario';
$hesklang['pass']='Contraseña';
$hesklang['confirm_pass']='Confirme la contraseña';
$hesklang['logged_out']='Desconectado';
$hesklang['logout']='Cerrar sesión';
$hesklang['logout_success']='¡Ha salido correctamente de la sesión!';
$hesklang['click_login']='Pulse aquí para entrar';
$hesklang['back']='Volver atrás';
$hesklang['displaying_pages']='Viendo <b>%d</b> tickets. Páginas:';
$hesklang['trackID']='ID de seguimiento';
$hesklang['timestamp']='Fecha y hora';
$hesklang['name']='Nombre';
$hesklang['subject']='Asunto';
$hesklang['status']='Estado';
$hesklang['priority']='Prioridad';
$hesklang['open']='Nuevo';
$hesklang['open_action']='Abrir ticket'; // Open ACTION
$hesklang['close']='Cerrado'; // Closed ticket STATUS
$hesklang['any_status']='Cualquier estado';
$hesklang['high']='Alta';
$hesklang['medium']='Media';
$hesklang['low']='Baja';
$hesklang['del_selected']='Eliminar los tickets seleccionados';
$hesklang['manage_cat']='Administrar categorías';
$hesklang['profile']='Su perfil';
$hesklang['show_tickets']='Mostrar tickets';
$hesklang['sort_by']='Ordenar por';
$hesklang['date_posted']='Fecha de publicación';
$hesklang['category']='Categoría';
$hesklang['any_cat']='Cualquiera de las categorías';
$hesklang['order']='Orden';
$hesklang['ascending']='ascendente';
$hesklang['descending']='descendente';
$hesklang['display']='Mostrar';
$hesklang['tickets_page']='tickets por página';
$hesklang['find_ticket']='Buscar ticket';
$hesklang['yyyy_mm_dd']='YYYY-MM-DD';
$hesklang['results_page']='Resultados por página';
$hesklang['opened']='Abierto'; // The ticket has been OPENED
$hesklang['closed']='Resuelto'; // Ticket has been RESOLVED
$hesklang['ticket']='Ticket';
$hesklang['tickets']='Tickets';
$hesklang['ticket_been']='Este ticket ha sido';
$hesklang['view_ticket']='Ver ticket';
$hesklang['open_tickets']='Tickets abiertos';
$hesklang['remove_statement']='Eliminar la declaración &quot;Powered by&quot;';
$hesklang['click_info']='Haga click aquí para más información';
$hesklang['reply_added']='Respuesta agregada';
$hesklang['reply_submitted']='Respuesta enviada';
$hesklang['ticket_marked']='Este ticket ha sido marcado';
$hesklang['ticket_status']='Estado del ticket';
$hesklang['replies']='Respuestas';
$hesklang['date']='Fecha';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Mensaje';
$hesklang['add_reply']='Añadir respuesta';
$hesklang['close_this_ticket']='Marcar este ticket como resuelto';
$hesklang['change_priority']='Cambiar prioridad a';
$hesklang['attach_sign']='Agregar firma';
$hesklang['profile_settings']='Configuración del perfil';
$hesklang['submit_reply']='Enviar respuesta';
$hesklang['support_panel']='Panel de soporte';
$hesklang['ticket_trackID']='Ticket ID';
$hesklang['c2c']='Click para continuar';
$hesklang['tickets_deleted']='Tickets eliminados';
$hesklang['num_tickets_deleted']='Número de tickets eliminados: <b>%d</b>';
$hesklang['confirm_del_cat']='¿Está seguro de borrar esta categoría?';
$hesklang['cat_intro']='Aquí puede gestionar las categorías. Las categorías son útiles para organizar los tickets por relevancia (por ejemplo &quot;Ventas&quot;, &quot;Problemas de hardware&quot;, &quot;Problemas de PHP/MySQL&quot; etc) y para asignar usuarios a las categorías.';
$hesklang['cat_name']='Nombre';
$hesklang['remove']='Borrar';
$hesklang['add_cat']='Nueva categoría';
$hesklang['max_chars']='40 caracteres máximo';
$hesklang['create_cat']='Guardar categoría';
$hesklang['ren_cat']='Renombrar categoría';
$hesklang['to']='para';
$hesklang['cat_added']='Agregar categoría';
$hesklang['cat_name_added']='La categoría %s ha sido agregada satisfactoriamente';
$hesklang['cat_renamed']='Categoría renombrada';
$hesklang['cat_renamed_to']='La categoría seleccionada se ha renombrado a';
$hesklang['cat_removed']='Categoría eliminada';
$hesklang['cat_removed_db']='La categoría seleccionada ha sido eliminada de la base de datos';
$hesklang['sure_remove_user']='¿Está seguro de borrar este usuario?';
$hesklang['manage_users']='Administrar usuarios';
$hesklang['users_intro']='Aquí puede administrar los usuarios que pueden acceder al panel de administración y responder tickets. Los administradores pueden ver/editar tickets en cualquier categoría y tienen acceso a todas las funciones del panel de administración (administrar usuarios, administrar categorías, ...) mientras que otros usuarios sólo pueden ver y responder tickets que se encuentren dentro de su propia categoría';
$hesklang['yes']='Sí';
$hesklang['no']='No';
$hesklang['edit']='Editar';
$hesklang['add_user']='Agregar nuevo usuario';
$hesklang['req_marked_with']='Campos marcados son requeridos';
$hesklang['real_name']='Nombre real';
$hesklang['signature_max']='Firma (máximo 1000 caracteres)';
$hesklang['sign_extra']='Código HTML no está permitido. Los enlaces (links) pueden ser clickeables.';
$hesklang['create_user']='Crear usuario';
$hesklang['editing_user']='Editar usuario';
$hesklang['user_added']='Usuario agregado';
$hesklang['user_added_success']='Nuevo usuario %s con clave %s ha sido agregado satisfactoriamente';
$hesklang['profile_updated']='Perfil actualizado';
$hesklang['profile_updated_success']='Su perfil ha sido actualizado satisfactoriamente';
$hesklang['user_removed']='Usuario borrado';
$hesklang['sel_user_removed']='El usuario seleccionado ha sido borrado satisfactoriamente de la base de datos';
$hesklang['profile_for']='Perfil de';
$hesklang['new_pass']='Nueva contraseña';
$hesklang['update_profile']='Actualizar perfil';
$hesklang['notify_new_posts']='Notificarme tickets nuevos y respondidos dentro de mi categoría';
$hesklang['view_profile']='Ver perfil';
$hesklang['new_ticket_submitted']='Nuevo ticket de soporte ha sido creado';
$hesklang['user_profile_updated_success']='Este perfil de usuario ha sido actualizado satisfactoriamente';
$hesklang['printer_friendly']='Versión para imprimir';
$hesklang['end_ticket']='--- Fin del ticket ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Su ticket ha sido';
$hesklang['view_your_ticket']='Ver su ticket';
$hesklang['submit_ticket']='Enviar un ticket';
$hesklang['sub_ticket']='Enviar ticket';
$hesklang['before_submit']='Antes de enviar, por favor, asegúrese de lo siguiente';
$hesklang['all_info_in']='Toda la información necesaria ha sido rellenada';
$hesklang['all_error_free']='Toda la información es correcta y libre de errores';
$hesklang['we_have']='Hemos registrado';
$hesklang['recorded_ip']='como su dirección IP';
$hesklang['recorded_time']='registrado el tiempo de envío';
$hesklang['save_changes']='Guardar cambios';
$hesklang['reply_submitted_success']='Su respuesta a esta entrada se ha enviado correctamente';
$hesklang['ticket_submitted']='Ticket enviado';
$hesklang['ticket_submitted_success']='¡Su ticket ha sido enviado satisfactoriamente! Ticket ID';
$hesklang['your_ticket']='Su ticket';

// Added in version 0.94
$hesklang['check_updates']='¡Asegúrese de tener siempre instalada la última versión de Hesk!';
$hesklang['check4updates']='Buscar actualizaciones';
$hesklang['wait_reply']='Esperando respuesta';
$hesklang['replied']='Respondido';
$hesklang['last_replier']='Última respuesta';
$hesklang['staff']='Equipo';
$hesklang['customer']='Cliente';
$hesklang['close_selected']='Marcar tickets seleccionados como resueltos';
$hesklang['execute']='Ejecutar';
$hesklang['saved_replies']='Respuestas predeterminadas';
$hesklang['manage_saved']='Respuestas predeterminadas';
$hesklang['manage_intro']='Aquí puede agregar y administrar las respuestas predeterminadas. Éstas son generalmente usadas para responder a la mayoría de los clientes. Puede usar las respuestas predeterminadas para ahorrar escribir la misma respuesta para los diferentes usuarios numerosas veces.';
$hesklang['saved_title']='Título';
$hesklang['no_saved']='No hay respuesta predeterminada';
$hesklang['delete_saved']='¿Esta seguro de eliminar esta respuesta predeterminada?';
$hesklang['new_saved']='Agregar o eliminar respuesta predeterminada';
$hesklang['canned_add']='Nueva respuesta predefinida';
$hesklang['canned_edit']='Editar la respuesta predeterminada seleccionada';
$hesklang['save_reply']='Guardar respuesta';
$hesklang['saved']='Respuesta guardada';
$hesklang['your_saved']='Su respuesta predeterminada ha sido guardada para su futuro uso';
$hesklang['ent_saved_title']='Por favor introduzca el título de respuesta';
$hesklang['ent_saved_msg']='Por favor introduzca el mensaje de respuesta';
$hesklang['saved_removed']='respuesta predeterminada borrada';
$hesklang['saved_rem_full']='respuesta predeterminada seleccionada ha sido eliminada de la base de datos';
$hesklang['clip_alt']='Este mensaje contiene adjuntos';
$hesklang['attachments']='Adjuntos';
$hesklang['fill_all']='Falta campo obligatorio';
$hesklang['file_too_large']='Su archivo %s es demasiado grande';
$hesklang['cannot_move_tmp']='No se puede mover el archivo a la carpeta de archivos adjuntos';
$hesklang['created_on']='Creado en';
$hesklang['tickets_closed']='Tickets cerrados';
$hesklang['num_tickets_closed']='<b>%d</b> tickets han sido cerrados';
$hesklang['select_saved']='Seleccionar respuesta predeterminada';
$hesklang['select_empty']='Seleccionar / Vacío';
$hesklang['insert_special']='Insertar etiqueta especial (será reemplazada con la información del cliente)';
$hesklang['move_to_catgory']='Mover ticket a';
$hesklang['move']='Mover';
$hesklang['moved']='Ticket movido';
$hesklang['moved_to']='El ticket ha sido movido a la nueva categoría';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Todos, excepto cerrados';
$hesklang['chg_all']='Cambiar todo';
$hesklang['settings']='Configuración';
$hesklang['settings_intro']='Use esta herramienta para configurar su help desk. Para mayor información acerca de todas las configuraciones y opciones haga click en ayuda o refiérase al archivo readme.html.';
$hesklang['all_req']='¡Todos los campos (excepto los deshabilitados) son obligatorios!';
$hesklang['wbst_title']='Título Sitio Web';
$hesklang['wbst_url']='URL del Sitio';
$hesklang['email_wm']='Webmaster e-mail';
$hesklang['max_listings']='Listado por página';
$hesklang['print_size']='Tamaño fuente para Impresión';
$hesklang['debug_mode']='Modo de depuración';
$hesklang['on']='ACTIVADO';
$hesklang['off']='DESACTIVADO';
$hesklang['use_secimg']='Usar imagen anti-SPAM';
$hesklang['secimg_no']='No disponible';
$hesklang['attach_use']='Usar adjuntos';
$hesklang['attach_num']='Número por respuesta';
$hesklang['attach_type']='Tipos de archivo permitidos';
$hesklang['place_after']='Después del mensaje';
$hesklang['place_before']='Antes del mensaje';
$hesklang['custom_f']='Campo personalizado';
$hesklang['custom_u']='Usar este campo';
$hesklang['custom_n']='Nombre de campo';
$hesklang['custom_l']='Tamaño máximo (caracteres)';
$hesklang['db_host']='Servidor Base de Datos';
$hesklang['db_name']='Nombre Base de Datos';
$hesklang['db_user']='Usuario Base de Datos';
$hesklang['db_pass']='Contraseña Base de Datos';
$hesklang['err_sname']='Por favor introduzca el título de su sitio web';
$hesklang['err_surl']='Por favor introduzca la URL de su sitio web. Asegúrese de que sea una URL válida (inicie con http:// o https://)';
$hesklang['err_wmmail']='Por favor introduzca un e-mail de webmaster válido';
$hesklang['err_nomail']='Por favor introduzca un e-mail de no respuesta válido';
$hesklang['err_htitle']='Por favor introduzca el título para el centro de soporte';
$hesklang['err_hurl']='Por favor introduzca la URL para su centro de soporte. Asegúrese de que sea una URL válida (inicie con http:// o https://)';
$hesklang['err_lang']='Por favor seleccione el idioma para Hesk';
$hesklang['err_nolang']='¡El archivo de lenguaje especificado no existe en la carpeta de lenguajes! Asegúrese de que el archivo fue subido antes de cambiar la configuración de lenguaje.';
$hesklang['err_max']='Por favor introduzca las listas máximas que serán desplegadas por página';
$hesklang['err_psize']='Por favor introduzca el tamaño de la fuente';
$hesklang['err_dbhost']='Por favor introduzca el servidor para su base de datos MySQL';
$hesklang['err_dbname']='Por favor introduzca el nombre para su base de datos MySQL';
$hesklang['err_dbuser']='Por favor introduzca el usuario para su base de datos MySQL';
$hesklang['err_dbpass']='Por favor introduzca la clave para su base de datos MySQL';
$hesklang['err_dbconn']='¡No se ha podido conectar a la base de datos MySQL con la información proporcionada!';
$hesklang['err_dbsele']='No se pudo seleccionar la base de datos MySQL, por favor compruebe el NOMBRE de la base de datos';
$hesklang['err_custname']='Introducir el nombre del campo personalizado';
$hesklang['err_openset']='No se puede abrir el archivo <b>hesk_settings.inc.php</b> para escritura. Por favor cambie los permisos CHMOD de este archivo a 666 (rw-rw-rw-)';
$hesklang['set_saved']='Configuración guardada';
$hesklang['set_were_saved']='Sus configuraciones han sido guardadas con éxito';
$hesklang['sec_img']='Imagen de seguridad';
$hesklang['sec_miss']='Por favor introduzca el número de seguridad';
$hesklang['sec_wrng']='Número de seguridad equivocado';
$hesklang['submit_problems']='Por favor regrese y corrija los problemas siguientes';
$hesklang['cat_order']='Orden Categoría';
$hesklang['reply_order']='Orden Respuesta Predefinida';
$hesklang['move_up']='Mover arriba';
$hesklang['move_dn']='Mover abajo';
$hesklang['cat_move_id']='Falta el ID de categoría';
$hesklang['reply_move_id']='Falta el ID de respuesta predeterminada';
$hesklang['forgot_tid']='¿Recordar su ID de seguimiento?';
$hesklang['tid_send']='Enviar mi ID de seguimiento';
$hesklang['tid_not_found']='No han sido encontrados tickets con su dirección e-mail';
$hesklang['tid_sent']='ID de seguimiento enviado';
$hesklang['tid_sent2']='Un e-mail con detalles acerca de sus tickets ha sido enviado a su dirección de correo';
$hesklang['check_spambox']='¡Asegúrese comprobar también el email recibido dentro de su carpeta SPAM o correo no deseado!';
$hesklang['reply_not_found']='Respuesta predeterminada no encontrada';
$hesklang['exists']='Existe';
$hesklang['no_exists']='No existe';
$hesklang['writable']='Grabable';
$hesklang['not_writable']='No grabable';
$hesklang['disabled']='deshabilitado';
$hesklang['e_settings']='Usted no será capaz de guardar la configuración a menos que este archivo sea escribible por el script. ¡Por favor consulte el archivo readme para más instrucciones!';
$hesklang['e_attdir']='Usted no será capaz de adjuntar archivos a menos que exista y sea escribible por el script. ¡Por favor consulte el archivo readme para más instrucciones!';
$hesklang['e_save_settings']='Imposible guardar su configuración porque el archivo <b>hesk_settings.inc.php</b> no es escribible por el script.';
$hesklang['e_attach']='Deshabilitado porque su carpeta <b>attachments</b> no es escribible por el script.';
$hesklang['go']='Ir';

// Added in version 2.0
$hesklang['v']='Versión HESK';
$hesklang['check_status']='Comprobar el estado';
$hesklang['sub_support']='Enviar un ticket';
$hesklang['open_ticket']='Enviar un nuevo ticket a un departamento';
$hesklang['view_existing']='Ver el ticket existente';
$hesklang['vet']='Ver tickets enviados en el pasado';
$hesklang['enter_user']='Por favor introduzca su usuario';
$hesklang['remember_user']='Recordar mi usuario';
$hesklang['wrong_user']='Usuario equivocado';
$hesklang['no_permission']='Usted no tiene permiso para realizar esta tarea, por favor identifíquese con una cuenta que posea.';
$hesklang['tickets_on_pages']='Número de tickets: %d Número de páginas: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='Ir a la página:';
$hesklang['no_tickets_open']='No se han encontrado tickets sin resolver';
$hesklang['no_tickets_crit']='No se han encontrado tickets que coincidan con su criterio';
$hesklang['confirm_execute']='¿Está seguro que desea continuar?';
$hesklang['legend']='Leyenda';
$hesklang['main_page']='Inicio';
$hesklang['menu_users']='Usuarios';
$hesklang['menu_cat']='Categorías';
$hesklang['menu_profile']='Perfil';
$hesklang['menu_kb']='Base de conocimientos'; // Admin MENU item
$hesklang['kb_text']='Base de Conocimientos (KB)'; // Item visible to customers
$hesklang['viewkb']='Ver toda la base de conocimientos (KB)';
$hesklang['kb']='Administrar la base de conocimiento (KB)';
$hesklang['kb_intro']='La base de conocimientos es una colección de respuestas a preguntas frecuentes (FAQ) y artículos que brindan recursos de autoayuda a sus clientes. Una base de conocimientos completa y bien redactada puede reducir drásticamente la cantidad de tickets de soporte que recibe y ahorrarle mucho tiempo. Puede organizar los artículos en categorías y subcategorías.'; // Description in ADMIN panel
$hesklang['kb_is']='La base de conocimiento es una colección de respuestas por categorías a las preguntas más frecuentes (FAQ) y artículos de su interés. Usted puede leer los artículos en esta categoría o seleccionar una subcategoría en la que Usted esté interesado.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Nuevo artículo para la base de conocimiento (KB)';
$hesklang['kb_cat']='Categoría';
$hesklang['kb_subject']='Asunto';
$hesklang['kb_content']='Contenidos';
$hesklang['kb_type']='Tipo';
$hesklang['kb_published']='Publicado';
$hesklang['kb_published2']='El artículo puede ser visto por cualquiera en la base de conocimiento. (KB)';
$hesklang['kb_private']='Privado';
$hesklang['kb_private2']='artículos privados sólo pueden ser leídos por el personal.';
$hesklang['kb_draft']='Borrador';
$hesklang['kb_draft2']='El artículo ha sido guardado pero no se ha publicado aun. Éste sólo puede ser leído por el personal <br />que tiene permiso para administrar los artículos de la base de conocimientos (KB).';
$hesklang['kb_links']='<i><span class="notice"><b>¡Peligro!</b></span><br />¡Introduzca un código válido sin etiquetas &lt;head&gt; y &lt;body&gt; , sólo contenido!</i>';
$hesklang['kb_ehtml']='Esto es código HTML (Aquí deberá introducir código (X)HTML válido)';
$hesklang['kb_dhtml']='Esto es texto plano (links pueden ser pulsados)';
$hesklang['kb_save']='Guardar artículo';
$hesklang['kb_e_subj']='¡Introduzca asunto del artículo!';
$hesklang['kb_e_cont']='¡Escriba el contenido del artículo!';
$hesklang['kb_art_added']='artículo agregado';
$hesklang['your_kb_added']='Un nuevo artículo para la base de conocimiento (KB) ha sido agregado con éxito';
$hesklang['kb_art_deleted']='artículo eliminado';
$hesklang['your_kb_deleted']='artículo seleccionado en la base de conocimiento (KB) ha sido eliminado satisfactoriamente';
$hesklang['kb_art_mod']='artículo modificado';
$hesklang['your_kb_mod']='Sus cambios en los artículos seleccionados han sido guardados satisfactoriamente';
$hesklang['kb_cat_new']='Nueva subcategoría de la base de conocimiento (KB)';
$hesklang['kb_cat_parent']='Categoría superior';
$hesklang['kb_cat_sub']='Subcategorías';
$hesklang['kb_cat_title']='Título de categoría';
$hesklang['kb_cat_published']='La categoría es visible para todos en la base de conocimiento (KB).';
$hesklang['kb_cat_private']='La categoría sólo puede ser leída por el equipo.';
$hesklang['kb_cat_add']='Agregar categoría';
$hesklang['kb_cat_e_title']='¡Introduzca título de categoría!';
$hesklang['kb_cat_added']='Categoría agregada';
$hesklang['kb_cat_added2']='La nueva categoría ha sido agregada satisfactoriamente a la base de conocimiento (KB)';
$hesklang['kb_cat_man']='Administrar categoría de la base de conocimiento (KB)';
$hesklang['kb_cat_edit']='Editar detalles de categoría';
$hesklang['kb_cat_inv']='Categoría inválida';
$hesklang['kb_cat_art']='artículos en esta categoría';
$hesklang['kb_p_art']='+ artículo';
$hesklang['kb_p_art2']='agregar nuevo artículo a la categoría seleccionada.';
$hesklang['kb_add_art']='Agregar artículo';
$hesklang['kb_p_cat']='+ Categoría';
$hesklang['kb_p_cat2']='crear nueva subcategoría dentro de la categoría seleccionada.';
$hesklang['kb_add_cat']='Agregar categoría';
$hesklang['kb_p_man']='Administrar';
$hesklang['kb_p_man2']='administrar categoría seleccionada (editar, eliminar, administrar artículos).';
$hesklang['kb_main']='La categoría de base de conocimiento (KB) principal no puede ser eliminada o movida.';
$hesklang['kb_no_art']='No hay artículos en esta categoría.';
$hesklang['author']='Autor';
$hesklang['views']='Vistas';
$hesklang['delete']='Eliminar';
$hesklang['rating']='valoración';
$hesklang['votes']='Votar';
$hesklang['kb_rated']='valoración del artículo %s/5.0';
$hesklang['kb_not_rated']='artículo no votado';
$hesklang['del_art']='¿Está seguro de eliminar el artículo seleccionado?';
$hesklang['kb_art_id']='¡ID de artículo inválido o no encontrado!';
$hesklang['kb_art_edit']='Editar artículo';
$hesklang['revhist']='Historial';
$hesklang['revision1']='<li class="smaller">%s | enviado por %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modificado por %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Orden';
$hesklang['kb_delcat']='¿Está seguro de eliminar esta categoría?';
$hesklang['kb_cat_mod']='Categoría modificada';
$hesklang['your_cat_mod']='Los cambios para la categoría seleccionada ha sido guardada satisfactoriamente';
$hesklang['kb_cat_del']='Categoría de base de conocimientos (KB) ha sido eliminada';
$hesklang['kb_cat_dlt']='La categoría de base de conocimiento (KB) seleccionada ha sido eliminada.';
$hesklang['allowed_cat']='Categorías';
$hesklang['allow_feat']='Características';
$hesklang['can_view_tickets']='Ver tickets';
$hesklang['can_reply_tickets']='Responder a los tickets';
$hesklang['can_assign_tickets']='Asignar tickets';
$hesklang['can_del_tickets']='Eliminar tickets';
$hesklang['can_edit_tickets']='Editar respuestas a ticket';
$hesklang['can_change_cat']='Cambiar la categoría del ticket (a cualquiera)';
$hesklang['can_man_kb']='Administrar base de conocimiento (KB)';
$hesklang['can_man_users']='Administrar usuarios';
$hesklang['can_man_cat']='Administrar categorías';
$hesklang['can_man_canned']='Administrar respuestas predeterminadas';
$hesklang['can_man_settings']='Administrar configuración Centro de Soporte';
$hesklang['can_del_notes']='Eliminar cualquier nota de ticket';
$hesklang['dan']='los usuarios pueden borrar sus propias notas en los tickets, seleccione esta opción sólo si desea permitir a este usuario también borrar las notas de otros usuarios';
$hesklang['in_all_cat']='permitido en categorías únicamente';
$hesklang['admin_can']='(acceso a todas las características y categorías)';
$hesklang['staff_can']='(acceso limitado a características y categorías)';
$hesklang['asign_one_feat']='¡Por favor asigne por lo menos una función a este usuario!';
$hesklang['na_view_tickets']='Usted no esta autorizado a ver tickets';
$hesklang['support_notice']='¡Lo sentimos, esta sección sólo se puede esconder cuando Usted compra una licencia HESK!';
$hesklang['rart']='¿Le ha sido útil este artículo?';
$hesklang['r']='¿Esta respuesta le fue útil?';
$hesklang['tyr']='Gracias por su valoración';
$hesklang['cw']='Cerrar ventana';
$hesklang['cw2']='Cerrar ventana y enviar un ticket';
$hesklang['rh']='Calificado como util';
$hesklang['rnh']='Calificado como poco util';
$hesklang['ar']='Ya calificado';
$hesklang['rated']='Usuario calificado %s/5.0 (%s votos)';
$hesklang['not_rated']='Usuario no calificado aún';
$hesklang['rdis']='Clasificación ha sido deshabilitada';
$hesklang['kbdis']='La base de conocimiento (KB) ha sido deshabilitada';
$hesklang['kbpart']='Lo sentimos, Usted no tiene permisos para acceder a este artículo';
$hesklang['popart']='Artículos destacados';
$hesklang['latart']='Últimos artículos';
$hesklang['m']='Más asuntos';
$hesklang['ac']='Artículos de esta categoría';
$hesklang['noa']='No hay artículos todavía';
$hesklang['noac']='No hay artículos todavía en esta categoría';
$hesklang['dta']='Fecha de alta';
$hesklang['ad']='Detalles del artículo';
$hesklang['aid']='ID de artículo';
$hesklang['as']='Solución';
$hesklang['search']='Buscar';
$hesklang['sr']='Resultados de la búsqueda';
$hesklang['nosr']='No hay artículos encontrados que coincidan. Trate de explorar la base de datos o enviar un nuevo ticket de soporte.';
$hesklang['rv']='Resetear vistas';
$hesklang['rr']='Resetear votos (valoraciones)';
$hesklang['opt']='Opciones';
$hesklang['delcat']='Eliminar categoría';
$hesklang['move1']='Mover los artículos a la categoría superior';
$hesklang['move2']='Eliminar artículos en esta categoría';
$hesklang['sc']='artículos sugeridos de la base de conocimiento (KB)';
$hesklang['not']='Tickets'; // Number of all tickets in category
$hesklang['graph']='Gráfico';
$hesklang['lu']='Listar usuarios';
$hesklang['aclose']='Autocerrar tickets';
$hesklang['aclose2']='días después de la última respuesta del personal';
$hesklang['s_ucrt']='Reabrir tickets';
$hesklang['urate']='Responder a puntuaciones';
$hesklang['hesk_url']='URL Centro de Soporte';
$hesklang['hesk_title']='Título Centro de Soporte';
$hesklang['cid']='Caso ID de seguimiento';
$hesklang['tfor']='Formato de Hora';
$hesklang['prefix']='Prefijo de las tablas';
$hesklang['s_ekb']='Habilitar Base de Conocimiento';
$hesklang['s_kbs']='Habilitar búsqueda KB';
$hesklang['s_kbr']='Habilitar valoración KB';
$hesklang['s_maxsr']='Número máximo de resultados por búsqueda';
$hesklang['s_suggest']='Sugerir artículos KB';
$hesklang['s_spop']='Mostrar artículos populares';
$hesklang['s_slat']='Mostrar últimos artículos';
$hesklang['s_onin']='en <a href="../" target="_blank">Centro de Soporte </a>(Página Índice)';
$hesklang['s_onkb']='en <a href="../knowledgebase.php" target="_blank">Base de conocimiento </a>(Página Índice)';
$hesklang['s_scol']='Categorías por fila';
$hesklang['s_ptxt']='Longitud previa del artículo';
$hesklang['s_psubart']='Artículos de Subcategoría';
$hesklang['enable']='Habilitado';
$hesklang['s_type']='Tipo de Campo';
$hesklang['custom_r']='Obligatorio';
$hesklang['custom_place']='Ubicación';
$hesklang['custom_use']='Campos personalizados';
$hesklang['stf']='Campo de texto';
$hesklang['stb']='Caja de texto grande';
$hesklang['srb']='Botón de opción';
$hesklang['ssb']='Caja de selección';
$hesklang['db']='Base de Datos';
$hesklang['hd']='Configuración Centro de Soporte';
$hesklang['gs']='Configuración general';
$hesklang['cwin']='Cerrar ventana';
$hesklang['defw']='Valor por defecto';
$hesklang['ok']='OK';
$hesklang['ns']='Estas son las opciones disponibles para este campo personalizado. Para guardar los cambios, ¡haga click en el botón <b>Aceptar</b> y en <b>Guardar cambios</b> en la página de configuración principal!';
$hesklang['rows']='Filas (alto)';
$hesklang['cols']='Columnas (ancho)';
$hesklang['opt2']='Opciones para este botón de radio, introducir una por línea (cada línea creará un nuevo valor de botón de radio a elegir). ¡Debe introducir al menos dos opciones!';
$hesklang['opt3']='Opciones para esta caja de selección, introduzca una opción por línea (cada línea será una opción que sus clientes podrán elegir). ¡Debe introducir al menos dos opciones!';
$hesklang['atl2']='Introduzca al menos dos opciones (una por línea)';
$hesklang['notes']='Notas';
$hesklang['addnote']='Anadir nota';
$hesklang['noteby']='Nota por';
$hesklang['delnote']='Eliminar nota';
$hesklang['noteerr']='Nota ya fue eliminada o parámetros equivocados';
$hesklang['s']='Enviar';
$hesklang['nhid']='¡Las notas se ocultan a los clientes!';
$hesklang['delt']='Eliminar este mensaje';
$hesklang['edtt']='Editar mensaje';
$hesklang['edt1']='Mensaje modificado';
$hesklang['edt2']='Cambios al mensaje seleccionado guardados';
$hesklang['dele']='Eliminar este ticket';
$hesklang['repd']='Mensaje eliminado';
$hesklang['repl']='Mensaje seleccionado ha sido eliminado';
$hesklang['tickets_found']='Resultados de la búsqueda';
$hesklang['al']='Link admin';
$hesklang['ap']='Ir al panel de Administración';
$hesklang['dap']='Mostrar un enlace al Panel de Administración desde <a href="../" target="_blank">página de inicio HESK</a>';
$hesklang['q_miss']='Por favor responda la pregunta anti-SPAM';
$hesklang['use_q']='Usar pregunta anti-SPAM';
$hesklang['q_q']='Pregunta (el código HTML es <span class="success">permitido</span>)';
$hesklang['q_a']='Respuesta';
$hesklang['err_qask']='Introduzca una pregunta anti-SPAM';
$hesklang['err_qans']='Introduzca respuesta para la pregunta anti-SPAM';
$hesklang['genq']='Generar pregunta aleatoria';

// Added in version 2.1
$hesklang['amo']='Añadir más';
$hesklang['delatt']='¿Borrar el adjunto seleccionado?';
$hesklang['kb_att_rem']='Adjunto seleccionado ha sido borrado';
$hesklang['inv_att_id']='¡ID de adjunto inválido!';
$hesklang['scb']='Casilla de verificación';
$hesklang['opt4']='Opciones para esta casilla, introducir una opción por línea. Cada línea sera una opción que los clientes pueden elegir, son posibles múltiples opciones.';
$hesklang['autologin']='Iniciar sesión automáticamente en cada visita';
$hesklang['just_user']='Recordar únicamente mi usuario';
$hesklang['nothx']='No, gracias';
$hesklang['pinfo']='Información del perfil';
$hesklang['sig']='Firma';
$hesklang['pref']='Preferencias';
$hesklang['aftrep']='Después de responder un ticket';
$hesklang['showtic']='Mostrar el ticket acabo de responder a';
$hesklang['gomain']='Volver a la página de administración principal';
$hesklang['shownext']='Abrir el siguiente ticket que necesita mi respuesta (si no ir a la página principal de administración)';
$hesklang['rssn']='Mostrar el siguiente ticket que necesita su atención';
$hesklang['mrep']='Reemplazar mensaje existente';
$hesklang['madd']='Añadir a la parte inferior';
$hesklang['priv']='Categorías privadas y artículos visible para el personal sólo están marcados con el *';
$hesklang['inve']='Archivo de correo inválido';
$hesklang['emfm']='Falta el archivo de correo electrónico';
$hesklang['hesk_lang']='Idioma Predeterminado';
$hesklang['s_mlang']='Múltiples Idiomas';
$hesklang['s_mlange']='Si se habilita, sus usuarios podrán acceder al centro de soporte en cualquiera de los idiomas instalados. ¡Habilitelo sólo si ofrece soporte en todos los idiomas instalados!';
$hesklang['s_inl']='Probar carpeta de idiomas';
$hesklang['s_inle']='Comprobacion de la carpeta de idiomas para ver si son válidos. Sólo se instalan correctamente los idiomas que superan todas las pruebas.';
$hesklang['ta']='Pruebe de nuevo';
$hesklang['alo']='Permitir inicio sesión automático';
$hesklang['chol']='Lenguaje preferido';
$hesklang['mmdl']='Establecer como mi idioma preferido';
$hesklang['warn']='ADVERTENCIA';
$hesklang['dmod']='El modo de depuración está habilitado. Asegúrese de desactivar el modo de depuración en la configuración una vez Hesk esté instalado y funcione correctamente.';
$hesklang['kb_spar']='¡La categoría no puede ser su propia categoría superior!';
$hesklang['mysql_root']='Su contraseña de MySQL esta vacía, ¿está  seguro de que desea acceder con el usuario root? ¡Esto representa un riesgo de seguridad!';
$hesklang['chg']='Cambiar';
$hesklang['chpri']='Prioridad cambiada';
$hesklang['chpri2']='La prioridad del ticket ha sido cambiada a %s';
$hesklang['selcan']='Seleccione la respuesta estándar que le gustaria editar';
$hesklang['q_wrng']='Respuesta anti-SPAM incorrecta';
$hesklang['cndupl']='Usted ya tiene una categoría con ese nombre. Elija un nombre único para cada categoría.';
$hesklang['wsel']='Seleccione el campo por el que desea buscar';

// Added in version 2.2
$hesklang['eto']='Solicitud no válida';
$hesklang['id']='ID';
$hesklang['geco']='Generar enlace directo';
$hesklang['genl']='Enlace copiado en el portapapeles';
$hesklang['genl2']='Utilice este enlace para preseleccionar la categoría en el formulario &quot;Enviar un ticket&quot;.';
$hesklang['ask']='Buscar ayuda:';
$hesklang['exa']='Ejemplos';
$hesklang['small']='Caja pequeña';
$hesklang['large']='Caja grande';
$hesklang['cpri']='Prioridad cliente';
$hesklang['owner']='Propietario';
$hesklang['unas']='Sin asignar';
$hesklang['assi']='Asignar';
$hesklang['asst']='Asignar a';
$hesklang['asst2']='Asignar este ticket a';
$hesklang['asss']='Asignar aleatoriamente';
$hesklang['asss2']='Asignar este ticket a mí mismo';
$hesklang['can_assign_self']='Puede asignarse entradas a sí mismo';
$hesklang['can_assign_others']='Puede asignar entradas a los demás';
$hesklang['can_run_reports']='Puede ejecutar informes (propios)';
$hesklang['can_view_ass_others']='Puede ver los tickets asignados a otros';
$hesklang['unoa']='El usuario seleccionado no tiene acceso a esta categoría';
$hesklang['tasi']='Propietario asignado';
$hesklang['tasy']='Este ticket se le ha asignado a Usted';
$hesklang['taso']='Este ticket se le ha asignado al usuario seleccionado';
$hesklang['tasy2']='Asignado a Usted';
$hesklang['taso2']='Asignado a otros miembros del personal (staff)';
$hesklang['nose']='Ningún propietario seleccionado';
$hesklang['onasc']='Este propietario no tiene acceso a la categoría seleccionada.';
$hesklang['tunasi']='Ticket sin asignar';
$hesklang['tunasi2']='Ticket sin propietario y listo para ser asignado de nuevo';
$hesklang['note']='Nota';
$hesklang['success']='éxito';
$hesklang['nyt']='Este ticket se asigna a';
$hesklang['noch']='No se han producido cambios';
$hesklang['orch']='Orden de visualización se ha modificado';
$hesklang['rfm']='La información necesaria que falta:';
$hesklang['repl0']='Permisos insuficientes para realizar esta tarea';
$hesklang['repl1']='Este artículo (post) no existe';
$hesklang['reports']='Informes (Reports)';
$hesklang['reports_intro']='La sección de informes le permite ejecutar varios informes y ver las estadísticas de entradas en un rango de fechas elegido.';
$hesklang['refi']='Restablecer los datos del formulario';
$hesklang['dich']='Descartar cambios';
$hesklang['dire']='Mostrar informe';
$hesklang['m1']='Enero';
$hesklang['m2']='Febrero';
$hesklang['m3']='Marzo';
$hesklang['m4']='Abril';
$hesklang['m5']='Mayo';
$hesklang['m6']='Junio';
$hesklang['m7']='Julio';
$hesklang['m8']='Agosto';
$hesklang['m9']='Septiembre';
$hesklang['m10']='Octubre';
$hesklang['m11']='Noviembre';
$hesklang['m12']='Diciembre';
$hesklang['d1']='Lunes';
$hesklang['d2']='Martes';
$hesklang['d3']='Miércoles';
$hesklang['d4']='Jueves';
$hesklang['d5']='Viernes';
$hesklang['d6']='Sábado';
$hesklang['d0']='Domingo';
$hesklang['mo']='Lu';
$hesklang['tu']='Ma';
$hesklang['we']='Mi';
$hesklang['th']='Ju';
$hesklang['fr']='Vi';
$hesklang['sa']='Sa';
$hesklang['su']='Do';
$hesklang['from']='De';
$hesklang['cinv']='Fecha incorrecta';
$hesklang['cinv2']='Formato aceptado es mm/dd/yyyy';
$hesklang['cinm']='Valor de mes inválido';
$hesklang['cinm2']='Rango permitido es de';
$hesklang['cind']='Dia inválido de valor de mes';
$hesklang['cind2']='Límite permitido para el mes seleccionado';
$hesklang['month']='Mes';
$hesklang['ocal']='Abrir Calendario';
$hesklang['ca01']='Año Anterior';
$hesklang['ca02']='Mes Anterior';
$hesklang['ca03']='Siguiente Mes';
$hesklang['ca04']='Año Siguiente';
$hesklang['ca05']='Cerrar Calendario';
$hesklang['cdr']='Seleccione rango de fechas:';
$hesklang['crt']='Tipo de informe';
$hesklang['r1']='Hoy';
$hesklang['r2']='Ayer';
$hesklang['r3']='Este mes';
$hesklang['r4']='El último mes';
$hesklang['r5']='Últimos 30 días';
$hesklang['r6']='Esta semana (Lu-Do)';
$hesklang['r7']='Última semana (Lu-Do)';
$hesklang['r8']='Esta semana de trabajo (Lu-Vi)';
$hesklang['r9']='Semana pasada de trabajo (Lu-Vi)';
$hesklang['r10']='Este año';
$hesklang['r11']='Año pasado';
$hesklang['r12']='Todo el tiempo';
$hesklang['datetofrom']='&quot;Fecha desde&quot; no puede ser mayor que &quot;Fecha hasta&quot;. Las fechas han sido cambiadas.';
$hesklang['t1']='Tickets por día';
$hesklang['t2']='Tickets por mes';
$hesklang['t3']='Tickets por usuario';
$hesklang['t4']='Tickets por categoría';
$hesklang['ticass']='Tickets Asignados';
$hesklang['ticall']='Tickets Respondidos';
$hesklang['totals']='Totales';
$hesklang['all']='Todos';
$hesklang['atik']='Nuevos tickets';
$hesklang['kbca']='Usted ya tiene una base de conocimiento (KB) de la categoría con ese nombre.';
$hesklang['menu_msg']='Correo';
$hesklang['menu_can']='Respuestas predeterminadas';
$hesklang['m_from']='De'; // Mail "from" address
$hesklang['m_to']='A'; // Mail "to" address
$hesklang['m_sub']='Asunto'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Mensajes privados';
$hesklang['m_intro']='Utilizar mensajes privados para enviar mensajes rápidos a otros funciónarios dentro de la HESK.';
$hesklang['e_udel']='(Usuario borrado)';
$hesklang['new_mail']='Nuevo mensaje privado';
$hesklang['m_send']='Enviar mensaje';
$hesklang['m_rec']='Seleccionar destinatario del mensaje';
$hesklang['m_inr']='Destinatario de mensaje inválido';
$hesklang['m_esu']='Introduzca el asunto del mensaje privado';
$hesklang['m_pms']='Su mensaje privado ha sido enviado';
$hesklang['inbox']='Bandeja de entrada';
$hesklang['outbox']='Bandeja de salida';
$hesklang['m_new']='Nuevo Mensaje';
$hesklang['pg']='Mostrar la página';
$hesklang['npm']='No hay mensajes en esta carpeta';
$hesklang['m_ena']='Usted no tiene permiso para leer este mensaje.';
$hesklang['mau']='Marcar como no leído';
$hesklang['mo1']='Marcar los mensajes seleccionados como leídos';
$hesklang['mo2']='Marcar los mensajes seleccionados como no leídos';
$hesklang['mo3']='Eliminar los mensajes seleccionados';
$hesklang['delm']='Eliminar este mensaje';
$hesklang['e_tid']='Error al generar una única ID de ticket, por favor, intente enviar el formulario de nuevo más tarde.';
$hesklang['smmr']='Los mensajes seleccionados se han marcado como leídos';
$hesklang['smmu']='Los mensajes seleccionados se han marcado como no leídos';
$hesklang['smdl']='Los mensajes seleccionados se han eliminado';
$hesklang['show']='Mostrar';
$hesklang['s_my']='Asignado a mí';
$hesklang['s_ot']='Asignado a los demás';
$hesklang['s_un']='Tickets sin asignar';
$hesklang['s_for']='Buscar';
$hesklang['s_in']='Buscar en';
$hesklang['s_incl']='Buscar dentro de';
$hesklang['find_ticket_by']='Buscar un ticket';
$hesklang['e_nose']='No hay estado de asignación seleccionada, mostrando todos los tickets.';
$hesklang['fsq']='Indique su pregunta';
$hesklang['topen']='Abierto';
$hesklang['nms']='No hay mensajes seleccionados, nada para cambiar';
$hesklang['tlo']='Bloquear ticket';
$hesklang['tul']='Desbloquear ticket';
$hesklang['loc']='Bloqueado';
$hesklang['isloc']='Los clientes no pueden responder ni reabrir tickets bloqueados cuando un ticket bloqueado se marca como resuelto.';
$hesklang['tlock']='Ticket se ha bloqueado';
$hesklang['tunlock']='Ticket se ha desbloqueado';
$hesklang['tislock']='Este ticket se ha bloqueado, el cliente no será capaz de enviar una respuesta.';
$hesklang['tislock2']='Este ticket ha sido bloqueado, no se puede enviar una respuesta.';
$hesklang['nsfo']='No hay artículos relevantes encontrados.';
$hesklang['thist1']='<li class="smaller">%s | movido a la categoría %s por %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | asignado a %s por %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | cerrado por %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | abierto por %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | bloqueado por %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | desbloqueado por %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | ticket creado por %s</li>'; // %s = date, user making change
$hesklang['elocked']='Este ticket se ha bloqueado o eliminado';
$hesklang['nti2']='Insertar un nuevo ticket';
$hesklang['nti3']='Utilice este formulario para crear un nuevo ticket en un nombre del cliente. ¡Introduzca la información del <i>cliente</i> en el formulario (nombre de cliente, el correo electrónico, ...) y NO su nombre! El Ticket será creado como si fuera enviado por el propio cliente.';
$hesklang['addop']='Opciones';
$hesklang['seno']='Enviar notificación por correo electrónico al cliente';
$hesklang['otas']='Mostrar el ticket después del envío';
$hesklang['notn']='Notificaciones';
$hesklang['nomw']='El centro de soporte le enviará una notificación por correo electrónico cuando:';
$hesklang['nwts']='Nuevo ticket con propietario:';
$hesklang['ncrt']='Cliente responde a un ticket con el propietario:';
$hesklang['ntam']='Un ticket asignado a mí';
$hesklang['npms']='Un mensaje privado para mí';
$hesklang['support_remove']='Una gran cantidad de esfuerzo, tiempo y dinero fue invertido en el desarrollo de HESK. Por favor, apoye el proyecto HESK para comprar una licencia que eliminará también los enlaces <i>Powered by Help Desk Software HESK&trade;</i> de su servicio de soporte';
$hesklang['ycvtao']='No está autorizado para ver los tickets asignados a otros';
$hesklang['password_not_valid']='La contraseña debe tener al menos 5 caracteres de largo';
$hesklang['lkbs']='Cargando sugerencias para base de conocimiento (KB)';
$hesklang['auto']='(automáticamente)';

// Added in version 2.3
$hesklang['unknown']='Desconocido';
$hesklang['pcer']='Por favor, corrija los siguientes errores:';
$hesklang['seqid']='Ticket número ';
$hesklang['close_action']='Marcar como Resuelto'; // Close ACTION
$hesklang['archived']='Etiquetado';
$hesklang['archived2']='Ticket etiquetado';
$hesklang['add_archive']='Etiquetar ticket';
$hesklang['add_archive_quick']='Etiquetar los tickets seleccionados';
$hesklang['remove_archive']='Quitar etiqueta del ticket';
$hesklang['remove_archive_quick']='Quitar etiqueta de los tickets seleccionados';
$hesklang['added_archive']='Ticket etiquetado';
$hesklang['removed_archive']='Ticket no etiquetado';
$hesklang['added2archive']='Ticket ha sido etiquetado';
$hesklang['removedfromarchive']='Se ha quitado la etiqueta del ticket';
$hesklang['num_tickets_tag']='<b>%d</b> tickets han sido etiquetados';
$hesklang['num_tickets_untag']='<b>%d</b> tickets han sido etiquetados';
$hesklang['can_add_archive']='Puede etiquetar tickets';
$hesklang['disp_only_archived']='Sólo tickets etiquetados';
$hesklang['search_only_archived']='Sólo tickets etiquetados';
$hesklang['critical']='Crítica';
$hesklang['thist8']='<li class="smaller">%s | prioridad cambiada a %s por %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | estado cambiado a %s por %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | asignado automáticamente a %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | enviado por correo electrónico</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='año';
$hesklang['abbr']['month']='mes';
$hesklang['abbr']['week']='sem';
$hesklang['abbr']['day']='d';
$hesklang['abbr']['hour']='h';
$hesklang['abbr']['minute']='m';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='No se pudo enviar mensaje a';
$hesklang['yhbb']='Usted ha sido bloqueado por el sistema durante %s minutos debido a intentos de acceso fallidos al sistema.';
$hesklang['pwdst']='Seguridad de la contraseña';
$hesklang['tid_mail']='¡No se preocupe!, introduzca su <b>Email</b> y le enviaremos su ID de seguimiento de inmediato';
$hesklang['rem_email']='Recordar mi dirección de email';
$hesklang['eytid']='Introduzca el ID de seguimiento de su ticket';
$hesklang['enmdb']='La dirección de email indicada no coincide con la de nuestra base de datos para este ID de seguimiento.';
$hesklang['confemail']='Confirmar email';
$hesklang['confemail2']='Por favor, confirme su email';
$hesklang['confemaile']='Los dos email no son iguales';
$hesklang['taso3']='Asignado a:';
$hesklang['sec_enter']='Escriba el número que aparece en la imagen';
$hesklang['reload']='Recargar imagen';
$hesklang['verify_q']='SPAM Prevención:'; // For anti-spam question
$hesklang['verify_i']='SPAM Prevención:'; // For anti-spam image (captcha)
$hesklang['admin_login']='¡Bienvenido! Por favor, inicie sesión.';
$hesklang['vrfy']='Test OK';
$hesklang['last_update']='Actualizado';
$hesklang['cot']='No forzar entradas criticas en la parte superior';
$hesklang['def']='Dejar como "Mi vista por defecto" ';
$hesklang['gbou']='Este ticket esta <b>sin asignar</b>:';
$hesklang['gbom']='Ticket asignado a <b>mí</b>:';
$hesklang['gboo']='Tickets asignados a <b>%s</b>:';
$hesklang['select']='Haga click para seleccionar:';
$hesklang['chngstatus']='Cambiar estado a';
$hesklang['perat']='%s de todos los tickets.'; // Will change to "23% of all tickets"
$hesklang['viewart']='Ver este artículo';
$hesklang['chdp']='¡Por favor, cambie la contraseña por defecto en su <a href="profile.php">Profile</a> perfil!';
$hesklang['chdp2']='Cambie su clave. Está usando una por defecto';
$hesklang['security']='Seguridad';
$hesklang['kb_i_art']='Nuevo artículo';
$hesklang['kb_i_art2']='Inserte un artículo';
$hesklang['kb_i_cat']='Nueva categoría';
$hesklang['kb_i_cat2']='Inserte una categoría';
$hesklang['gopr']='Ver base de conocimiento (KB)';
$hesklang['kbstruct']='Estructura base de conocimiento (KB)';
$hesklang['cancel']='Cancelar';
$hesklang['sh']='Mensaje oculto';
$hesklang['goodkb']='Como escribir buenos artículos en la base de conocimiento (KB)';
$hesklang['catset']='Ajustes de categoría';
$hesklang['inpr']='Seleccionar nueva prioridad';
$hesklang['incat']='Seleccionar nueva categoría';
$hesklang['instat']='Seleccionar nuevo estado';
$hesklang['tsst']='Estado del ticket establecido a %s';
$hesklang['aass']='Autoasignar';
$hesklang['aaon']='Autoasignar tickets activado (click para desactivar)';
$hesklang['aaoff']='Autoasignar tickets desactivado (click para activar)';
$hesklang['uaaon']='Autoasignar ha sido activado para los usuarios seleccionados';
$hesklang['uaaoff']='Autoasignar ha sido desactivado para los usuarios seleccionados';
$hesklang['taasy']='Este ticket ha sido auto asignado a';
$hesklang['can_view_unassigned']='Puede ver tickets sin asignar';
$hesklang['ycovtay']='Sólo puede ver los tickets que estén asignados a Usted';
$hesklang['in_progress']='En progreso';
$hesklang['on_hold']='En espera';
$hesklang['import_kb']='Importar este ticket dentro de la base de conocimiento (KB)';
$hesklang['import']='Está importando un <i>ticket privado</i> dentro de <i>un artículo publico</i>.<br /><br />Asegúrese de eliminar cualquier información privada del asunto y contenido del artículo';
$hesklang['tab_1']='Ajustes Generales';
$hesklang['tab_2']='Centro de Soporte';
$hesklang['tab_3']='Base de conocimiento (KB)';
$hesklang['tab_4']='Campos personalizados';
$hesklang['tab_5']='Misc';
$hesklang['disable']='Desactivado';
$hesklang['dat']='Fecha &amp; hora';
$hesklang['lgs']='Idioma';
$hesklang['onc']='ACTIVADO - Usuarios';
$hesklang['ons']='ACTIVADO - Todos';
$hesklang['viewvtic']='Ver tickets';
$hesklang['reqetv']='Email requerido para ver ticket';
$hesklang['banlim']='Límite de intentos conexión';
$hesklang['banmin']='Tiempo Bloqueo (minutos)';
$hesklang['subnot']='Enviar aviso';
$hesklang['subnot2']='Mostrar aviso a los clientes enviando tickets';
$hesklang['eseqid']='ID sequencial';
$hesklang['sconfe']='Confirmar email';
$hesklang['saass']='Autoasignar tickets';
$hesklang['swyse']='Editor WYSIWYG';
$hesklang['hrts']='Valorar HESK';
$hesklang['hrts2']='Mostrar valorar en el panel de administracón';
$hesklang['emlpipe']='Email piping';
$hesklang['emlsend2']='Enviar email usando';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='Servidor SMTP';
$hesklang['smtph']='Servidor SMTP';
$hesklang['smtpp']='Puerto SMTP';
$hesklang['smtpu']='Usuario SMTP';
$hesklang['smtpw']='Su contraseña SMTP';
$hesklang['smtpt']='Tiempo de espera SMTP';
$hesklang['other']='Otros';
$hesklang['features']='Características';
$hesklang['can_view_online']='Ver en línea miembros de la organización';
$hesklang['online']='Conectado';
$hesklang['offline']='Desconectado';
$hesklang['onlinep']='Usuarios Conectados'; // For display in footer
$hesklang['sonline']='Usuarios Conectados'; // For settings page
$hesklang['sonline2']='Ver usuarios Conectados. límite (minutos):'; // For settings page
$hesklang['gb']='Agrupar';
$hesklang['dg']='No Agrupar';
$hesklang['err_dpi']='Database %s no contiene todas las tablas HESK con el prefijo %s, cambios no guardados.';
$hesklang['err_dpi2']='Tablas no encontradas:';
$hesklang['sme']='SMTP error';
$hesklang['scl']='SMTP log de conexión';
$hesklang['dnl']='Descarga';
$hesklang['dela']='Borrar este adjunto';
$hesklang['pda']='¿Borrar permanentemente este adjunto?';
$hesklang['thist12']='<li class="smaller">%s | archivo adjunto %s eliminado por %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Más opciones';
$hesklang['lopt']='Menos opciones';
$hesklang['meml']='Múltiples Emails';
$hesklang['meml2']='Permitir a los clientes introducir múltiples emails';

// Added in version 2.4
$hesklang['catd']='(categoría eliminada)';
$hesklang['noopen']='No se han encontrado tickets abiertos para esta dirección de correo electrónico.';
$hesklang['maxopen']='Usted ha llegado al máximo de tickets abiertos (%d de %d). Por favor, espere hasta que sus tickets actuales estén resueltos antes de la apertura de nuevos tickets.';
$hesklang['ntnote']='Alguien agregó una nota a un ticket asignado';
$hesklang['cat_public']='Público';
$hesklang['cat_private']='Privado';
$hesklang['cat_aa']='Autoasignar tickets de esta categoría.';
$hesklang['cat_type']='Tipo';
$hesklang['caaon']='Se ha habilitado Autoasignar para la categoría seleccionada';
$hesklang['caaoff']='Se ha deshabilitado Autoasignar para la categoría seleccionada';
$hesklang['cpub']='Tipo de categoría cambiado a PÚBLICA';
$hesklang['cpriv']='Tipo de categoría cambiado a PRIVADO';
$hesklang['cpric']='¡Los clientes no pueden seleccionar las categorías privadas, sólo el personal autorizado!';
$hesklang['user_aa']='Autoasignar tickets para este usuario.';
$hesklang['attach_size']='Tamaño máximo del archivo';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='Protocolo SSL';
$hesklang['smtptls']='Protocolo TLS';
$hesklang['oo']='Sólo Abiertos';
$hesklang['ool']='Listar sólo los tickets abiertos en el correo &quot;Olvidó su ID de seguimiento&quot;';
$hesklang['mop']='Máximo tickets abiertos';
$hesklang['rord']='Orden Respondidos';
$hesklang['newbot']='Los más nuevos al final';
$hesklang['newtop']='Los más nuevos al principio';
$hesklang['ford']='Formulario de respuesta';
$hesklang['formbot']='Mostrar formulario al final';
$hesklang['formtop']='Mostrar formulario al principio';
$hesklang['mysqlv']='Versión MySQL';
$hesklang['phpv']='Versión PHP';
$hesklang['csrt']='Hora actual del Centro de Ayuda:';
$hesklang['listp']='Listar artículos privados';
$hesklang['listd']='Listar los artículos en borrador';
$hesklang['artp']='Artículos privados';
$hesklang['artd']='Artículos en borrador';
$hesklang['kb_no_part']='No hay artículos privados en la base de conocimientos.';
$hesklang['kb_no_dart']='No hay artículos en borrador en la base de conocimientos.';
$hesklang['attpri']='Usted no tiene acceso a este archivo adjunto.';
$hesklang['can_merge_tickets']='Combinar tickets';
$hesklang['mer_selected']='Combinar tickets seleccionados';
$hesklang['merged']='Los tickets seleccionados se han combinado en uno solo.';
$hesklang['merge_err']='Hubo un problema al combinar Los tickets:';
$hesklang['merr1']='Seleccione al menos dos tickets.';
$hesklang['merr2']='Ticket de destino no encontrado.';
$hesklang['merr3']='Ticket en una categoría que no tiene acceso.';
$hesklang['tme']='Ticket %s se ha combinado con este ticket (%s).';
$hesklang['tme1']='Ticket %s se ha combinado con el ticket %s';
$hesklang['tme2']='Para acceder al ticket %s introduzca la dirección de correo electrónico asociada.';
$hesklang['eyou']='Utilice la página del perfil para editar la configuración.';
$hesklang['npea']='Usted no tiene permiso para editar este usuario.';
$hesklang['duplicate_user']='El usuario con este nombre de usuario ya existe, elija un nombre de usuario diferente.';
$hesklang['kw']='Palabras clave';
$hesklang['kw1']='(opcional - separado por un espacio, una coma o una nueva línea)';
$hesklang['type_not_allowed']='Los archivos que terminan con <b>%s</b> no se aceptan (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='El cliente no ha leído esta respuesta aún.';
$hesklang['sticky']='Hacer este artículo &quot;Permanente&quot;';
$hesklang['stickyon']='Cambiar este artículo a &quot;Permanente&quot;';
$hesklang['stickyoff']='Cambiar este artículo a &quot;Normal&quot;';
$hesklang['ason']='Artículo marcado como &quot;Permanente&quot;';
$hesklang['asoff']='Artículo marcado como &quot;Normal&quot;';
$hesklang['ts']='Tiempo Dedicado';
$hesklang['start']='Iniciar / Parar';
$hesklang['reset']='Restablecer';
$hesklang['save']='Guardar';
$hesklang['hh']='Horas';
$hesklang['mm']='Minutos';
$hesklang['ss']='Segundos';
$hesklang['thist']='Historial de Tickets';
$hesklang['thist13']='<li class="smaller">%s | fusionado con el ticket %s por %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | tiempo trabajado actualizado a %s por %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | Enviado por %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | enviado por correo electrónico POP3</li>';
$hesklang['twu']='Tiempo dedicado al ticket a sido actualizado.';
$hesklang['autoss']='Inicio automático de temporizador al abrir un ticket';
$hesklang['ful']='Límite de carga de archivos';
$hesklang['ufl']='Puede cargar archivos que terminan en:';
$hesklang['nat']='El número máximo de archivos adjuntos:';
$hesklang['mfs']='El tamaño máximo del archivo adjunto:';
$hesklang['lps']='Su preferencia de idioma se ha guardado';
$hesklang['sav']='Mostrar vistas del artículo';
$hesklang['sad']='Mostrar fecha de artículo';
$hesklang['emp']='Su PHP no tiene habilitado el soporte de MySQL (se requiere la extension mysqli)';
$hesklang['epd']='[HESK] EMAIL PIPING ESTA DESHABILITADO EN LOS AJUSTES';
$hesklang['pfd']='[HESK] POP3 FETCHING ESTA DESHABILITADO EN LOS AJUSTES';
$hesklang['pem']='[Piped email]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Cliente]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='Email';
$hesklang['pop3']='POP3 Fetching';
$hesklang['pop3h']='Servidor POP3';
$hesklang['pop3p']='Puerto POP3';
$hesklang['pop3tls']='Protocolo TLS';
$hesklang['pop3u']='Usuario POP3';
$hesklang['pop3w']='Contraseña POP3';
$hesklang['pop3e']='Error POP3';
$hesklang['pop3log']='Conexión de registro POP3';
$hesklang['mysqltest']='Test de conexión MySQL';
$hesklang['smtptest']='Test de conexión SMTP';
$hesklang['pop3test']='Test de conexión POP3';
$hesklang['contest']='Probando conexión , esto puede tardar un poco...';
$hesklang['conok']='¡Conexión exitosa!';
$hesklang['conokn']='Sin embargo, si su servidor requiere nombre de usuario y contraseña el correo ¡no se enviará!';
$hesklang['saving']='Guardando cambios, espere...';
$hesklang['sns']='Los cambios se guardaron, pero algunas funciones se fueron deshabilitadas por pruebas fallidas.';
$hesklang['looph']='Máximo de Correos';
$hesklang['loopt']='Rango de tiempo';
$hesklang['didum']='¿Quiso decir %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Sí, cámbialo';
$hesklang['nole']='No, déjalo asi';
$hesklang['sconfe2']='Mostrar campo &quot;Confirmar email&quot; en el formulario de ticket';
$hesklang['oln']='Nombre anterior:';
$hesklang['nen']='Nombre Nuevo:';
$hesklang['use_form_below']='<i>Utilice este formulario para enviar una solicitud de soporte. Los campos obligatorios están marcados con</i>';
$hesklang['esf']='No se pudieron enviar notificaciones por correo electrónico.';
$hesklang['qrr']='(Respuesta citada eliminada)';
$hesklang['remqr']='Eliminar citado en respuesta';
$hesklang['remqr2']='Eliminar la respuesta citada de los Emails de los clientes';
$hesklang['suge']='Detectar errores tipográficos';
$hesklang['epro']='Proveedores de Email';
$hesklang['email_noreply']='&quot;De:&quot; email';
$hesklang['email_name']='&quot;De:&quot; nombre';
$hesklang['vscl']='Límites de configuración del servidor';
$hesklang['fnuscphp']='Carga de archivos fallida, prueba con un archivo adjunto más pequeño o sin adjunto.';
$hesklang['redv']='restablecer la vista predeterminada';
$hesklang['fatte1']='¡Los ajustes de archivos adjuntos &quot;Número por mensaje&quot; es superior al que su servidor permite!';
$hesklang['fatte2']='¡Los ajustes de tamaño máximo de archivo adjunto es superior al que su servidor permite!';
$hesklang['fatte3']='¡Su servidor no permite mensajes con ese tamaño, intente reducir el número de archivos adjuntos o tamaño de archivo permitido!';
$hesklang['embed']='Archivos incrustados';
$hesklang['embed2']='Guardar archivos incrustados como archivos adjuntos';
$hesklang['emrem']='(imagen eliminada)';
$hesklang['hdemo']='(OCULTO EN DEMO)';
$hesklang['ddemo']='¡Lo sentimos, esta función se ha desactivado en el modo DEMO!';
$hesklang['sdemo']='La opción para guardar los cambios se ha desactivado en el modo DEMO';
$hesklang['hud']='El Centro de Soporte está al día';
$hesklang['hnw']='Actualización disponible';
$hesklang['getup']='Actualizar El Centro de Soporte';
$hesklang['updates']='Actualizaciones';
$hesklang['updates2']='Comprobar automáticamente si hay actualizaciones.';

// Added in version 2.5.0
$hesklang['attdel']='Este archivo ha sido borrado del servidor y ya no está disponible para su descarga';
$hesklang['dsen']='No enviar al cliente notificaciones de correo electrónico para esta respuesta';
$hesklang['attrem']='* Algunos archivos adjuntos se han eliminado *';
$hesklang['attnum']='Número máximo alcanzado: %s'; // %s will show attachment name
$hesklang['attsiz']='El archivo es demasiado grande: %s'; // %s will show attachment name
$hesklang['atttyp']='Tipo no permitido: %s'; // %s will show attachment name
$hesklang['adf']='Directorio Administrador';
$hesklang['atf']='Directorio Adjuntos';
$hesklang['err_adf']='¡El directorio de administrador seleccionado (%s) no existe!'; // %s will show folder name
$hesklang['err_atf']='¡El directorio de adjuntos seleccionado (%s) no existe!'; // %s will show folder name
$hesklang['err_atr']='¡El directorio de adjuntos seleccionado (%s) no es escribible!'; // %s will show folder name
$hesklang['fatt']='Archivos adjuntos del mensaje:';
$hesklang['wrepo']='Por favor escriba una respuesta después de volver a abrir el ticket.';
$hesklang['ktool']='Herramientas de la base de conocimientos';
$hesklang['uac']='Verificar y actualizar el recuento de artículo en Categoría';
$hesklang['acv']='Recuento de artículo ha sido verificado';
$hesklang['xyz']='número de artículos públicos, privados y del proyecto en la categoría.';
$hesklang['reports_tab']='Informes de ejecución'; // Tab title
$hesklang['can_run_reports_full']='Puede ejecutar informes (todos)';
$hesklang['can_export']='Puede exportar tickets';
$hesklang['roo']='<i>(sólo se incluyen en el informe los tickets que tiene asignados)</i>';
$hesklang['shu']='Enlaces cortos';
$hesklang['export']='Exportar Tickets'; // Tab title
$hesklang['export_btn']='Exportar tickets'; // Button title
$hesklang['export_intro']='Esta herramienta le permite exportar tickets en una hoja de cálculo XML que se puede abrir en Excel.';
$hesklang['stte']='Seleccione tickets para exportar';
$hesklang['dtrg']='Intervalo de fechas';
$hesklang['sequentially']='Secuencial'; // Order tickets: Sequentially
$hesklang['ede']='No se puede crear el directorio de exportación, por favor, cree manualmente un directorio llamado <b>export</b> dentro de su carpeta de archivos adjuntos y asegúrese de que tiene permisos de escritura por PHP (en Linux CHMOD 777 - rwxrwxrwx).';
$hesklang['eef']='No se puede crear el archivo de exportación, no tiene permiso para escribir en el directorio de exportación.';
$hesklang['inite']='Iniciando exportación';
$hesklang['gXML']='Generando archivos XML';
$hesklang['nrow']='Número de filas exportadas: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Comprimiendo archivos a Zip';
$hesklang['eZIP']='Error al crear el archivo Zip';
$hesklang['fZIP']='La compresión del archivo ha finalizado';
$hesklang['pmem']='Máximo uso de la memoria: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; CLICK AQUÍ PARA DESCARGAR EL ARCHIVO EXPORTADO &laquo;';
$hesklang['n2ex']='¡No hay entradas que coincidan con sus criterios, nada que exportar!';
$hesklang['sp']='Prevención SPAM'; // For settings page
$hesklang['sit']='Tipo de Imagen';
$hesklang['sis']='Imagen simple';
$hesklang['rcpb']='Clave del sitio';
$hesklang['rcpv']='Clave secreta';
$hesklang['pop3keep']='Mantener una copia';
$hesklang['beta']='(VERSIÓN DE PRUEBA)';
$hesklang['maxpost']='Probablemente ha intentado enviar mas datos de los que este servidor acepta.<br /><br />Por favor, intente enviar el formulario de nuevo con menos datos o sin ellos.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='No se ha podido validar la protección reCAPTCHA SPAM.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Ticket cerrado/resuelto';
$hesklang['ms01']='Ene';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Abr';
$hesklang['ms05']='May';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Ago';
$hesklang['ms09']='Sep';
$hesklang['ms10']='Oct';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dic';
$hesklang['sdf']='Formato de fecha Enviado';
$hesklang['lcf']='Formato de fecha Actualizado';
$hesklang['lcf0']='Descriptivo Corto';
$hesklang['lcf1']='Fecha y Hora';
$hesklang['lcf2']='Estilo HESK';
$hesklang['ticket_tpl']='Plantillas de tickets';
$hesklang['can_man_ticket_tpl']='Administrar plantillas de ticket'; // Permission title
$hesklang['ticket_tpl_man']='Administrar plantillas de ticket'; // Page and link title
$hesklang['ticket_tpl_intro']='Crear y editar las plantillas de entradas que puede utilizar para enviar rápidamente nuevas entradas desde la interfaz de administración.';
$hesklang['no_ticket_tpl']='Sin plantillas de ticket';
$hesklang['ticket_tpl_title']='Título';
$hesklang['delete_tpl']='¿Seguro que quiere eliminar esta plantilla?';
$hesklang['new_ticket_tpl']='Agregar o editar una plantilla de ticket';
$hesklang['ticket_tpl_add']='Nueva plantilla de ticket';
$hesklang['ticket_tpl_edit']='Editar plantilla del ticket seleccionado';
$hesklang['save_ticket_tpl']='Guardar la plantilla de ticket';
$hesklang['ticket_tpl_saved']='Su plantilla de ticket se ha guardado para su futuro uso';
$hesklang['ticket_tpl_removed']='La plantilla de ticket seleccionada se ha eliminado de la base de datos';
$hesklang['ticket_tpl_not_found']='La plantilla de ticket no encontrada';
$hesklang['sel_ticket_tpl']='Seleccione la plantilla de ticket que le gustaria editar';
$hesklang['ent_ticket_tpl_title']='Por favor indique título de la plantilla';
$hesklang['ent_ticket_tpl_msg']='Por favor indique el mensaje de plantilla';
$hesklang['ticket_tpl_id']='Falta la ID de la plantilla de ticket';
$hesklang['select_ticket_tpl']='Selecione una plantilla de ticket';
$hesklang['list_tickets_cat']='Mostrar todos los tickets de esta categoría';
$hesklang['def_msg']='[Sin mensaje]';
$hesklang['emlreqmsg']='Requerir mensaje';
$hesklang['emlreqmsg2']='Ignorar correos canalizados/obtenidos sin mensaje';
$hesklang['relart']='Artículos relacionados'; // Title of related articles box
$hesklang['s_relart']='Artículos relacionados'; // On settings page
$hesklang['tab_7']='Lista de Tickets';
$hesklang['fitl']='Campos en la Lista de Tickets';
$hesklang['submitted']='Enviado';
$hesklang['clickemail']='Ver';
$hesklang['set_pri_to']='Establecer prioridad a:'; // Action below the ticket list
$hesklang['pri_set_to']='Prioridad se ha establecido en:';
$hesklang['cat_pri']='La prioridad de categoría se utilizará cuando a los clientes no se les permite seleccionar la prioridad y un ticket se envia desde la interfaz del cliente.';
$hesklang['cat_pri_info']='Si a sus clientes se les permite seleccionar la prioridad, se ignorará la prioridad de categoría.<br /><br />Para utilizar la prioridad de categoría, deshabilite esta función en la configuración de HESK:';
$hesklang['def_pri']='Prioridad de categoría:';
$hesklang['ch_cat_pri']='Establecer prioridad de categoría';
$hesklang['cat_pri_ch']='La prioridad de categoría se ha establecido en:';
$hesklang['err_dbversion']='Versión de MySQL muy antigua:';
$hesklang['ip_whois']='IP WHOIS';
$hesklang['ednote']='Editar nota de mensaje';
$hesklang['ednote2']='Nota de mensaje guardada';
$hesklang['perm_deny']='Permiso denegado';
$hesklang['mis_note']='Falta ID de nota';
$hesklang['no_note']='Nota con esta ID no encontrada';
$hesklang['sacl']='Guardar y continuar despues';
$hesklang['reply_saved']='Su mensaje de respuesta se ha guardado para su uso posterior.';
$hesklang['submit_as']='Enviar como:';
$hesklang['sasc']='Enviar como: respuesta del cliente';
$hesklang['creb']='Respuesta del cliente introducida por:';
$hesklang['show_select']='Mostrar &quot;Clik para selecionar&quot; como opción por defecto';
// Settings
$hesklang['mms']='Modo mantenimiento';
$hesklang['mmd']='Habilitar modo mantenimiento';
// Customer notice
$hesklang['mm1']='Mantenimiento en curso';
$hesklang['mm2']='Con el fin de realizar tareas de mantenimiento programadas, nuestro centro de soporte esta deshabilitado temporalmente.';
$hesklang['mm3']='Pedimos disculpas por las molestias y pedimos que por favor intente de nuevo más tarde.';
// Staff notice
$hesklang['mma1']='¡El modo de mantenimiento está activo!';
$hesklang['mma2']='El servicio de soporte está deshabilitado para los clientes.';
$hesklang['tools']='Herramientas';
$hesklang['banemail']='Prohibir los correos electrónicos';
$hesklang['banemail_intro']='Evitar que ciertas direcciones de correo electrónico envíen tickets al servicio de soporte.';
$hesklang['no_banemails']='<i>No hay Emails bloqueados.</i>';
$hesklang['eperm']='Bloqueo de Emails Permanentes:';
$hesklang['bananemail']='Dirección de correo electrónico a bloquear';
$hesklang['savebanemail']='Bloquear esta dirección de correo electrónico';
$hesklang['enterbanemail']='Introduzca la dirección de correo electrónico que desea bloquear.';
$hesklang['validbanemail']='Introduzca una dirección de correo electrónico válida (<i>john.doe@domain.com</i>) o dominio de dirección de correo electrónico (<i>@domain.com</i>)';
$hesklang['email_banned']='La dirección de correo electrónico <i>%s</i> esta bloqueada y HESK ya no aceptará tickets de esta dirección.'; // %s will be replaced with email
$hesklang['emailbanexists']='Esta dirección de correo electrónico <i>%s</i> ya está bloqueada.'; // %s will be replaced with email
$hesklang['email_unbanned']='Dirección de correo electrónico desbloqueada';
$hesklang['banby']='Bloqueada por';
$hesklang['delban']='Desbloquear';
$hesklang['delban_confirm']='¿Desbloquear?';
$hesklang['baned_e']='Se le ha prohibido enviar nuevas solicitudes de soporte.';
$hesklang['baned_ip']='Se le ha prohibido hacer uso de este centro de soporte';
$hesklang['can_ban_emails']='Puede bloquear dirección de correo electrónico ';
$hesklang['can_unban_emails']='Puede desbloquear dirección de correo electrónico (habilita el bloqueo de Emails)';
$hesklang['eisban']='Esta dirección de correo electrónico está bloqueada.';
$hesklang['click_unban']='Click aquí para desbloquear.';
$hesklang['banip']='Bloquear IPs';
$hesklang['banip_intro']='Los visitantes de estas direcciones IP bloqueadas no podrán ver o enviar tickets ni tampoco podrán iniciar sesión en el Centro de Soporte.';
$hesklang['ipperm']='Bloqueo IP permanente:';
$hesklang['iptemp']='Bloqueo de inicio de sesión fallido:';
$hesklang['savebanip']='Bloquear esta IP';
$hesklang['no_banips']='<i>No hay IPs bloqueadas.</i>';
$hesklang['bananip']='IP a bloquear';
$hesklang['banex']='Ejemplos:';
$hesklang['iprange']='Rango de IP';
$hesklang['ippermban']='Bloquear esta IP permanentemente';
$hesklang['enterbanip']='Introduzca la IP o rango de IP que desea bloquear.';
$hesklang['validbanip']='Introduzca una IP válida o rango de IP';
$hesklang['ip_banned']='La IP <i>%s</i> ha sido bloqueada y HESK ya no aceptará tickets de esta IP.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Este rango de IP <i>%s</i> ha sido bloqueada y HESK ya no aceptará tickets de este rango de IP.'; // %s will be replaced with IP
$hesklang['ipbanexists']='Esta IP <i>%s</i> ya está bloqueada .'; // %s will be replaced with IP
$hesklang['iprbanexists']='Este rango de IP <i>%s</i> ya está bloqueado.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP desbloqueada';
$hesklang['ip_tempun']='IP desbloqueada temporalmente';
$hesklang['can_ban_ips']='Bloquear IPs deshabilitado';
$hesklang['can_unban_ips']='Puede desbloquear IPs (habilita bloquear IPs)';
$hesklang['ipisban']='Esta IP está bloqueada.';
$hesklang['m2e']='Expira en (minutos)';
$hesklang['info']='Info';
$hesklang['sm_title']='Mensajes de Servicio';
$hesklang['sm_intro']='Muestra un mensaje en el área de clientes, por ejemplo, para notificarles sobre problemas conocidos y noticias importantes.';
$hesklang['can_service_msg']='Editar Mensajes del Centro de Soporte';
$hesklang['new_sm']='Nuevo Mensaje del Centro de Soporte';
$hesklang['edit_sm']='Edita Mensaje del Centro de Soporte';
$hesklang['ex_sm']='Mensajes del Centro de Soporte Existentes';
$hesklang['sm_author']='Autor';
$hesklang['sm_type']='Tipo';
$hesklang['sm_published']='Publicado';
$hesklang['sm_draft']='Borrador';
$hesklang['sm_style']='Estilo';
$hesklang['sm_none']='Ninguno';
$hesklang['sm_success']='Realizado';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Noticia';
$hesklang['sm_error']='Error';
$hesklang['sm_save']='Guardar';
$hesklang['sm_preview']='Previsualizar';
$hesklang['sm_mtitle']='Título';
$hesklang['sm_msg']='Mensaje';
$hesklang['sm_e_title']='Introduzca el título del mensaje';
$hesklang['sm_e_msg']='Introduzca el Mensaje del Centro de Soporte';
$hesklang['sm_e_id']='Falta el ID del mensaje';
$hesklang['sm_added']='Se ha agregado un mensaje nuevo del centro de soporte';
$hesklang['sm_deleted']='Mensaje del Centro de Soporte eliminado';
$hesklang['sm_not_found']='Este Mensaje del Centro de Soporte no existe';
$hesklang['no_sm']='No hay Mensajes del Centro de Soporte';
$hesklang['del_sm']='¿Eliminar este Mensaje?';
$hesklang['sm_mdf']='El mensaje ha sido guardado';
$hesklang['sska']='Mostrar artículos sugeridos';
$hesklang['taws']='Estos artículos están relacionados:';
$hesklang['defaults']='Predeterminados';
$hesklang['pncn']='Seleccionar opción: notificar al cliente en el formulario de nuevo ticket';
$hesklang['pncr']='Seleccionar opción: notificar al cliente en el formulario de respuesta';
$hesklang['pssy']='Mostrar los artículos de la base de conocimientos sugeridos a los clientes';
$hesklang['ccct']='Resuelve el Cliente';
$hesklang['custnot']='Notificar al Cliente cuando';
$hesklang['notnew']='Se envió una nueva solicitud de ayuda';
$hesklang['notclo']='Un ticket de soporte se marca como Resuelto';
$hesklang['enn']='Excepto las entradas de los correos electrónicos si el asunto del correo electrónico contiene:';
$hesklang['spamn']='Notificación SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>¿Sin email de confirmación?</b><br />Enviamos un mensaje de confirmación a su dirección de correo electrónico. Si no lo recibe en pocos minutos, por favor revise su carpeta de correo no deseado. Marque el mensaje como <b>No SPAM</b> para evitar problemas en el futuro al recibir nuestra correspondencia.</span>';
$hesklang['ekb_n']='<b>No</b>, Deshabilitar Base de Conocimiento';
$hesklang['ekb_y']='<b>Sí</b>, habilitar Base de Conocimiento';
$hesklang['ekb_o']='<b>Sí</b>, usar HESK como Base de Conocimiento solamente (<i>Deshabilitar Centro de Soporte</i>)';
$hesklang['kb_set']='Ajustes Base de Conocimiento';
$hesklang['kbo1']='Modo Base de Conocimiento solamente';
$hesklang['kbo2']='<br /><br />Los visitantes no pueden enviar tickets de soporte y son llevados directamente a la base de conocimiento.';
$hesklang['fpass']='¿Ha olvidado su contraseña?';
$hesklang['passr']='Restablecer contraseña';
$hesklang['passa']='Permitir a los Clientes restablecer su contraseña a través del correo electrónico';
$hesklang['passe']='Introduzca su dirección de correo electrónico';
$hesklang['passs']='Restablecer contraseña';
$hesklang['noace']='No se a encontrado una cuenta con esa dirección de correo electrónico';
$hesklang['pemls']='Le hemos enviado un correo electrónico con instrucciones sobre cómo restablecer su contraseña';
$hesklang['reset_password']='Restablecer su contraseña'; // Email subject
$hesklang['ehash']='Enlace de restablecimiento de contraseña no válido o caducado';
$hesklang['ehaip']='Dirección IP incorrecta. Las contraseñas sólo se pueden restablecer a partir de la dirección IP que solicitó el restablecimiento de contraseña.';
$hesklang['resim']='<b>¡Introduzca su nueva contraseña en el formulario de abajo!</b>';
$hesklang['permissions']='Permisos';
$hesklang['atype']='Tipo de cuenta';
$hesklang['astaff']='Personal';
$hesklang['oon1']='Envíame sólo tickets abiertos';
$hesklang['oon2']='Envíame todos mis tickets';
$hesklang['anyown']='Cualquier propietario';
$hesklang['pfr']='Otra tarea de POP3 fetching está aún en curso.';
$hesklang['pjt']='Tiempo de espera para las tareas';
$hesklang['pjt2']='minutos después de comenzar';
$hesklang['nkba']='La búsqueda en la Base de Conocimientos requiere de suficientes artículos únicos para que funcione correctamente.<br /><br />Considere agregar más artículos a la base de conocimientos para mejorar los resultados de búsqueda y artículos de sugerencias.';
$hesklang['saa']='Los artículos relevantes se muestran en la parte superior de la lista de artículos';
$hesklang['yhbr']='Se le ha bloqueado el acceso al sistema durante %s minutos, debido a demasiadas respuestas a un ticket.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='es';

// Added in version 2.7.0
$hesklang['imap']='Obtención IMAP';
$hesklang['imaph']='Anfitrion de IMAP';
$hesklang['imapp']='Puerto IMAP';
$hesklang['enc']='Cifrado';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Ninguno';
$hesklang['imapu']='Nombre de usuario IMAP';
$hesklang['imapw']='Contraseña IMAP';
$hesklang['imaptest']='Prueba de conexión IMAP';
$hesklang['ifd']='[HESK] IMAP FETCHING ESTA DESHABILITADO EN CONFIGURACIONES';
$hesklang['iei']='[HESK] La extensión PHP IMAP no esta instalada.';
$hesklang['ifr']='Otra tarea de búsqueda IMAP esta aun en curso.';
$hesklang['arp']='Recarga automática de página';
$hesklang['arpp']='Recargar automáticamente la página con la lista de tickets cada:';
$hesklang['seconds']='segundos';
$hesklang['minutes']='minutos';
$hesklang['atbr']='Este ticket necesita ser asignado antes de que pueda ser contestado.';
$hesklang['attm']='Asignarme este ticket a mí mismo';
$hesklang['owneed']='Propietario necesario';
$hesklang['taat']='Este ticket ya está asignado a<b>%s</b>.';
$hesklang['scoy']='¿Está seguro de que quiere asignárselo a Usted mismo?';
$hesklang['scot']='¿Está seguro de que desea asignarlo a %s?';
$hesklang['ycto']='SÍ, cambiar el propietario';
$hesklang['ncto']='NO, mantener al propietario actual';
$hesklang['fass']='Requiere propietario';
$hesklang['req_sub']='Requiere asunto';
$hesklang['req_msg']='Requiere mensaje';
$hesklang['req_email']='Requiere email';
$hesklang['default_subject']='Ticket desde %s';
$hesklang['off-hide']='Ocultar en el formulario de cliente';
$hesklang['not_valid_email']='Introduzca una dirección de correo electrónico válida o deje este campo vacío';
$hesklang['write_down']='<span style="color:red">Le recomendamos que anote su ID de Ticket para referencia futura.</span>';
$hesklang['re_confirm1']='Al inhabilitarlo, también se deshabilitará "Requerir correo electrónico para ver las entradas" en "Seguridad". ¿Proceder?';
$hesklang['re_confirm2']='Habilitar esto también habilitará "Requerir correo electrónico" en "Funciones". ¿Proceder?';
$hesklang['can_email_tpl']='Editar plantillas de correo electrónico';
$hesklang['et_title']='Plantillas de correo electrónico';
$hesklang['et_intro']='Modifique los correos electrónicos que se envían a su personal y clientes';
$hesklang['file']='Archivo';
$hesklang['efile']='Edición de archivo';
$hesklang['rdesc']='Descripción';
$hesklang['desc_forgot_ticket_id']='(Cliente) Olvidó el ID de seguimiento de ticket';
$hesklang['desc_new_reply_by_staff']='(Cliente) Nueva respuesta del personal';
$hesklang['desc_new_ticket']='(Cliente) Ticket recibido';
$hesklang['desc_ticket_closed']='(Cliente) Ticket cerrado/resuelto';
$hesklang['desc_category_moved']='(Empleados) El ticket se traslado a una nueva categoría';
$hesklang['desc_new_reply_by_customer']='(Empleados) Nueva respuesta de cliente';
$hesklang['desc_new_ticket_staff']='(Empleados) Nuevo ticket enviado';
$hesklang['desc_ticket_assigned_to_you']='(Empleados) Se le asignó un ticket';
$hesklang['desc_new_pm']='(Empleados) Nuevo mensaje privado';
$hesklang['desc_new_note']='(Empleados) Nueva nota en un ticket asignado a Usted';
$hesklang['desc_reset_password']='(Empleados) Restablecer su contraseña';
$hesklang['etfm']='Faltan una o más plantillas de correo electrónico.<br><br>Asegúrese de subir todos los archivos de plantillas de correo electrónico dentro de estas dos carpetas:<br><br><i>/language/%s/emails</i><br><i>/language/%s/html_emails</i>';
$hesklang['etfw']='Algunas plantillas de correo electrónico no son escribibles.<br><br>
                    Asegúrese de que PHP tiene permiso para escribir en todos los archivos dentro de estas dos carpetas:<br><br>
                    <i>/language/%s/emails</i><br>
                    <i>/language/%s/html_emails</i><br><br>
                    En los servidores Unix puede ser necesario CHMOD las plantillas de correo electrónico a 666 (rw-rw-rw-)';
$hesklang['et_e_id']='ID de plantilla ausente';
$hesklang['et_fm']='Falta este archivo de plantilla de correo electrónico';
$hesklang['et_fw']='Esta plantilla de correo electrónico no se puede escribir';
$hesklang['et_save']='Guardar Cambios';
$hesklang['updated_on']='Actualizado en';
$hesklang['ticket_url']='URL de ticket';
$hesklang['pm_url']='URL de mensaje privado';
$hesklang['et_num']='Número de tickets';
$hesklang['et_list']='Lista de tickets de soporte';
$hesklang['et_empty']='La plantilla de correo electrónico no puede estar vacia';
$hesklang['et_saved']='Plantilla de correo electrónico guardada';
$hesklang['source']='Fuente';
$hesklang['select_category']='Seleccione una categoría';
$hesklang['select_category_text']='¿En qué podemos ayudarle?';
$hesklang['select_category_staff']='Seleccione la categoría del ticket';
$hesklang['scat']='Límite de seleccion de categoría';
$hesklang['scat2']='(Un cuadro de selección mostrará si el recuento de categorías es mayor)';
$hesklang['new_cf']='Nuevo campo personalizado';
$hesklang['cf_intro']='Utilice esta función para agregar campos personalizados al formulario Enviar un Ticket, para que pueda recopilar datos adicionales de los clientes.';
$hesklang['cf_public']='Público';
$hesklang['cf_private']='Sólo Personal';
$hesklang['cf_cust']='Para clientes';
$hesklang['cf_all']='Todo';
$hesklang['cf_cat']='seleccionado';
$hesklang['cf_ctrl']='Sugerencia: mantenga presionada la tecla CTRL para seleccionar varias categorías';
$hesklang['visibility']='Visibilidad';
$hesklang['cf_save']='Guardar campo personalizado';
$hesklang['ex_cf']='Campos personalizados activos';
$hesklang['no_cf']='No hay campos personalizados activos';
$hesklang['del_cf']='¿Desea eliminar este campo personalizado? ¡Esto también eliminará los datos de campo personalizados guardados de la base de datos!';
$hesklang['cf_e_id']='ID no válida';
$hesklang['edit_cf']='Editar campo personalizado';
$hesklang['cf_deleted']='Campo personalizado eliminado';
$hesklang['cf_not_found']='Este campo personalizado no existe';
$hesklang['cf_added']='Se ha agregado un nuevo campo personalizado';
$hesklang['cf_nocat']='Seleccione al menos una categoría para este campo personalizado';
$hesklang['cf_mdf']='El campo personalizado se ha guardado';
$hesklang['atl1']='Introduzca al menos una opción.';
$hesklang['sch']='Oculto';
$hesklang['meml3']='Permitir que se introduzcan varios correos electrónicos';
$hesklang['dmin']='Fecha mínima aceptada';
$hesklang['dmax']='Fecha máxima aceptada';
$hesklang['d_day']='día(s)';
$hesklang['d_week']='semana(s)';
$hesklang['d_month']='mes(es)';
$hesklang['d_year']='año(s)';
$hesklang['d_any']='Cualquier fecha';
$hesklang['d_fixed']='Fecha fijada';
$hesklang['d_relative']='Fecha relativa';
$hesklang['d_mm']='La fecha mínima no puede ser superior a la fecha máxima';
$hesklang['d_emin']='Fecha mínima para <i>%s</i> es %s';
$hesklang['d_emax']='Fecha máxima para <i>%s</i> es %s';
$hesklang['d_format']='Formato de visualización de fecha';
$hesklang['d_custom']='Formato personalizado';
$hesklang['d_ci']='SÓLO PARA USUARIOS AVANZADOS: Un formato de fecha PHP válido, consulte el manual de PHP.';
$hesklang['cf_noe']='Introduzca una dirección de correo electrónico válida en <i>%s</i>';
$hesklang['cf_noem']='Introduzca una o más direcciones de correo electrónico válidas en <i>%s</i>';
$hesklang['can_resolve']='Puede resolver tickets';
$hesklang['can_change_own_cat']='Cambiar categoría de ticket (a permitido)';
$hesklang['can_submit_any_cat']='Puede enviar tickets a cualquier categoría';
$hesklang['noauth_submit']='¡No está autorizado para enviar tickets a esta categoría!';
$hesklang['noauth_move']='¡No tiene autorizacion para mover tickets a esta categoría!';
$hesklang['noauth_resolve']='¡No está autorizado para resolver los tickets!';
$hesklang['force_ssl']='Forzar conexiones SSL';
$hesklang['d_ssl']='<i>deshabilitado</i> - Abra esta página con https:// Para gestionar esta opción';
$hesklang['scno']='Este estado no se puede cambiar';
$hesklang['statuses']='Estados';
$hesklang['statuses_intro']='Utilice esta herramienta para agregar estados personalizados de tickets a su Centro de Soporte';
$hesklang['color']='Color';
$hesklang['csscl']='Clase CSS o color';
$hesklang['clr_view']='Vista previa del color en el texto';
$hesklang['cbc']='Modificable por los clientes';
$hesklang['ccc']='¿Pueden los clientes cambiar este estado?';
$hesklang['del_status']='¿Eliminar este estado?';
$hesklang['ex_status']='Estados existentes';
$hesklang['status_hesk']='Estados predeterminados (no se puede modificar aquí)';
$hesklang['status_custom']='Estados personalizados';
$hesklang['status_custom_none']='No hay estados personalizados. Puede anadirlos haciendo click en "Nuevo estado personalizado" arriba.';
$hesklang['status_save']='Guardar';
$hesklang['list_tkt_status']='Anote todas las entradas con este estado';
$hesklang['new_status']='Nuevo estado personalización';
$hesklang['edit_status']='Editar estado personalizado';
$hesklang['err_status']='Introduzca el nombre del estado';
$hesklang['status_added']='Se ha agregado un nuevo estado personalizado';
$hesklang['status_e_id']='ID no válida';
$hesklang['status_mdf']='El estado personalizado se ha guardado';
$hesklang['status_deleted']='Estado personalizado eliminado';
$hesklang['status_not_found']='Este estado personalizado no existe';
$hesklang['status_not_empty']='No se puede eliminar este estado porque existen tickets con este estado.';
$hesklang['status_limit']='Tiene 100 estados personalizados, no se pueden crear nuevos.';
$hesklang['public_link']='Enlace público';
$hesklang['frames']='Frames/marcos';
$hesklang['frames2']='Evitar la carga de HESK en frames/marcos en dominios de terceros';
$hesklang['numsub']='Tickets enviados';
$hesklang['hidf']='Las entradas ocultas no son visibles para los clientes en el formulario Enviar un ticket (El valor seguirá estando visible en la página de detalles del ticket si están configurados como públicos). Se comportan como campos normales de texto para los miembros del personal.';
$hesklang['rcheck']='No seleccione una opción predeterminada';
$hesklang['refresh_page']='Actualizar esta página';
$hesklang['del_kba']='Eliminar este artículo';
$hesklang['del_kbaa']='Eliminar permanentemente este artículo';
$hesklang['hni1']='¿HESK aún no está instalado?';
$hesklang['hni2']='Parece que este Centro de Soporte no ha sido correctamente instalado y configurado.';
$hesklang['hni3']='Para instalar HESK, siga las <a class="link" href="docs/">Instrucciones en la documentación</a>';
$hesklang['cf']='Carpeta de caché';
$hesklang['e_cdir']='Hesk no será capaz de analizar correos electrónicos o resultados de caché a menos que la carpeta de caché exista y sea escribible.';
$hesklang['step1']='Paso 1';
$hesklang['step2']='Paso 2';
$hesklang['dffs']='Cuando termine la descarga, elimine el archivo del servidor';
$hesklang['fd']='archivo exportado eliminado del servidor';

// Added in version 2.8.0
$hesklang['TZ']='Zona horaria';
$hesklang['thist17']='<li class="smaller">%s | enviado por IMAP fetching</li>';
$hesklang['sir3']='reCAPTCHA invisible';
$hesklang['invisible']='invisible';
$hesklang['imap_not']='PHP no está compilado con soporte IMAP';
$hesklang['imap_warning']='el usuario %1$s tiene la misma dirección de correo electrónico que la dirección de correo electrónico de recuperación IMAP: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='el usuario %1$s tiene la misma dirección de correo electrónico que su dirección de correo POP3: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Esto podría generar un bucle de correo electrónico en el que se crearán nuevos tickets a partir de las notificaciones de los usuarios por correo electrónico. Su dirección de correo electrónico debe ser única y no utilizada por nadie más.';
$hesklang['can_view_ass_by']='Puede ver los tickets que asignó a otros';
$hesklang['can_privacy']='Puede anonimizar los tickets';
$hesklang['confirm_anony']='Anonimizar este ticket';
$hesklang['anon_selected']='Anonimizar los tickets seleccionados';
$hesklang['privacy_anon_info']='Eliminar todos los datos de identificación personal y el contenido de los tickets (nombre del cliente, correo electrónico, mensaje, archivos adjuntos, IP ...), pero mantener los tickets en la base de datos para estadísticas (derecho a ser olvidado).';
$hesklang['success_anon']='Ticket exitosamente anonimizado';
$hesklang['num_tickets_anon']='Número de tickets anonimizados: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Cliente]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Asunto]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Mensaje]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonimizado por %s</li>';
$hesklang['print_selected']='Imprimir tickets seleccionados';
$hesklang['with_selected']='Seleccionado/s:';
$hesklang['assign_selected']='Asignar seleccionado/s a:';
$hesklang['assign_no']='Sin propietario seleccionado, sin cambios realizados';
$hesklang['assign_1']='Los tickets seleccionados se han configurado como Sin asignar.';
$hesklang['assign_2']='Ticket ID %1$s establecido a Sin asignar'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s error: ya asignado a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s asignado a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s error: %2$s no tiene acceso a la categoría de ticket'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultado de asignación masiva de tickets:<br /><br />Asignados: %1$s<br />Errores: %2$s<br /><br />Registro:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='Dirección IP';
$hesklang['moret']='Más opciones'; // More options button title
$hesklang['btn_more']='Más'; // More options button text
$hesklang['btn_print']='Imprimir';
$hesklang['btn_edit']='Editar';
$hesklang['btn_lock']='Bloquear ticket';
$hesklang['btn_unlock']='Desbloquear ticket';
$hesklang['btn_tag']='Etiquetar ticket';
$hesklang['btn_resend']='Re-enviar notificacion de email';
$hesklang['btn_untag']='Desetiquetar ticket';
$hesklang['btn_import_kb']='Importar a la Base de datos';
$hesklang['btn_anony']='Anonimizar ticket';
$hesklang['btn_delt']='Eliminar ticket';
$hesklang['btn_delr']='Eliminar respuesta';
$hesklang['ernf']='Respuesta no encontrada';
$hesklang['tns']='Las notificaciones de tickets fueron enviadas de nuevo';
$hesklang['rns']='Las notificaciones de respuesta fueron enviadas de nuevo';
$hesklang['fname']='Nombre de pila';
$hesklang['export_selected']='Exportar tickets seleccionados';
$hesklang['btn_export']='Exportar a XML para Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Respuestas';
$hesklang['team']='Equipo';
$hesklang['sm_content']='Contenido';
$hesklang['sm_settings']='Configuración';
$hesklang['wizard_back']='Atrás'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Siguiente'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Ir a Configuración';
$hesklang['sm_return_to_editing']='Volver a la edición';
$hesklang['email_tpl_title']='Título';
$hesklang['edit_email_template']='Editar la plantilla de correo electrónico';
$hesklang['err_no_settings_section']='No se suministró ninguna sección de ajustes.';
$hesklang['this_field_is_required']='Este campo es obligatorio';
$hesklang['reset_your_password']='Restablecer su contraseña';
$hesklang['reset_password_instructions']='Por favor, rellene el siguiente formulario. Le enviaremos un enlace para que pueda restablecer su contraseña.';
$hesklang['enter_email']='Introduzca el correo electrónico';
$hesklang['password_reset_check_your_email']='Compruebe su correo electrónico';
$hesklang['password_reset_link_sent']='Le hemos enviado un enlace para restablecer su contraseña.';
$hesklang['back_to_login']='Volver al inicio de sesión';
$hesklang['pager_first']='Primero';
$hesklang['pager_previous']='Anterior';
$hesklang['pager_next']='Siguiente';
$hesklang['pager_last']='Último';
$hesklang['new_team_member']='Nuevo miembro del equipo';
$hesklang['role']='Rol';
$hesklang['optional']='Opcional';
$hesklang['edit_profile']='Editar Perfil';
$hesklang['assigned_to']='Asignado a';
$hesklang['contact']='Contacto';
$hesklang['unban_email']='Desbloquear este correo electrónico';
$hesklang['unban_ip']='Desbloquear esta IP';
$hesklang['show_previous_replies']='Mostrar respuestas anteriores';
$hesklang['type_your_message']='Escriba su mensaje'; // Used when there are no canned responses
$hesklang['close_button_text']='Cerrar';
$hesklang['create_new_ticket']='Crear nuevo ticket';
$hesklang['delete_article']='Eliminar artículo';
$hesklang['view_existing_tickets']='Ver tickets existentes';
$hesklang['how_can_we_help']='Hola, ¿cómo podemos ayudarle?';
$hesklang['search_for_articles']='Buscar artículos';
$hesklang['submit_a_support_request']='Enviar una Solicitud de Asistencia';
$hesklang['verify_header']='Prevención del SPAM';
$hesklang['ticket_details']='Detalles del ticket';
$hesklang['yes_title_case']='Sí';
$hesklang['no_title_case']='No';
$hesklang['no_results_found']='No se han encontrado resultados';
$hesklang['site_theme']='Tema del sitio';
$hesklang['test_theme_folder']='Comprobar la carpeta de temas';
$hesklang['test_theme_folder_description']='Probando la carpeta de temas para ver si los temas son válidos. Sólo los temas que pasan todas las pruebas se instalan correctamente.';
$hesklang['err_site_theme']='Por favor, seleccione el tema de Hesk';
$hesklang['confirm']='Confirmar';
$hesklang['confirm_deletion']='Confirmar eliminación';
$hesklang['confirm_delete_status']='¿Está seguro de querer borrar este estado personalizado?';
$hesklang['help_desk']='Centro de Soporte'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.es.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Visualización del tiempo';
$hesklang['tdisd']='Fecha y hora';
$hesklang['tdisa']='Hace tiempo (ejemplo: hace 5 horas)';
$hesklang['nav_templates']='Plantillas'; // Admin panel navigation item
$hesklang['hide_replies']='Ocultar las respuestas de los tickets';
$hesklang['hide_replies_no']='Nunca, siempre mostrar todas las respuestas';
$hesklang['hide_replies_yes']='Ocultar todas las respuestas excepto la última:';
$hesklang['hide_replies_def']='Mostrar la última respuesta del personal y cualquier respuesta posterior del cliente';
$hesklang['reply_by']='Respuesta de'; // Reply by NAME
$hesklang['btt']='Volver al inicio';
$hesklang['lwidth']='Limitar el ancho del ticket';
$hesklang['lwidtall']='Utilizar toda la anchura disponible';
$hesklang['lwidtpx']='Ancho máximo en píxeles:';
// 3-letter days of the week
$hesklang['mon']='Lun';
$hesklang['tue']='Mar';
$hesklang['wed']='Mie';
$hesklang['thu']='Jue';
$hesklang['fri']='Vie';
$hesklang['sat']='Sab';
$hesklang['sun']='Dom';
$hesklang['clear']='Borrar'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='¡Al menos una medida de prevención de SPAM debe ser activada!';
$hesklang['modules']='Módulos';
$hesklang['modules_demo']='Este módulo está disponible actualmente sólo en %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Prueba la demostración en vivo aquí: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Estadísticas';
$hesklang['statistics']['intro']='Este informe le brindará información sobre el uso de su centro de soporte y el desempeño del personal';
$hesklang['statistics']['ntsp']='No hay tickets en el período de tiempo seleccionado.';
$hesklang['statistics']['pie_title_ro']='Tickets abiertos vs. Resueltos';
$hesklang['statistics']['open']='Abiertos';
$hesklang['statistics']['resolved']='Resueltos';
$hesklang['statistics']['pie_title_as']='Tickets abiertos: Asignados vs. Sin asignar';
$hesklang['statistics']['ass']='Asignados';
$hesklang['statistics']['unas']='Sin asignar';
$hesklang['statistics']['pie_title_au']='Tickets abiertos: Contestados vs. Sin respuesta';
$hesklang['statistics']['answered']='Contestados';
$hesklang['statistics']['unanswered']='Sin respuesta';
$hesklang['statistics']['pie_title_so']='Estados de los tickets abiertos';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets por día del mes';
$hesklang['statistics']['chart_title_wd']='Tickets por día de la semana';
$hesklang['statistics']['chart_title_hd']='Tickets por hora del día';
$hesklang['statistics']['chart_title_tfr']='Tiempo para la primera respuesta del personal';
$hesklang['statistics']['chart_title_tfrc']='Tickets contestados dentro de un marco de tiempo';
$hesklang['statistics']['chart_title_ttr']='Tiempo que transcurre entre la solicitud y la resolución de un ticket';
$hesklang['statistics']['chart_title_ttrc']='Tickets resueltos dentro de un marco de tiempo';
$hesklang['statistics']['chart_title_sr']='Respuestas del personal';
$hesklang['statistics']['chart_title_srt']='Respuestas del personal por ticket';
$hesklang['statistics']['chart_title_srtr']='Respuestas del personal por ticket (sólo tickets resueltos)';
$hesklang['statistics']['chart_title_srt1']='Respuestas del personal por ticket (tickets con al menos 1 respuesta)';
$hesklang['statistics']['ct_30']='30 minutos';
$hesklang['statistics']['ct_1h']='1 hora';
$hesklang['statistics']['ct_2h']='2 horas';
$hesklang['statistics']['ct_4h']='4 horas';
$hesklang['statistics']['ct_1d']='1 día';
$hesklang['statistics']['ct_2d']='2 días';
$hesklang['statistics']['ct_3d']='3 días';
$hesklang['statistics']['ct_1w']='1 semana';
$hesklang['statistics']['ct_wp']='> 1 semana';
$hesklang['statistics']['ct_1m']='1 mes';
$hesklang['statistics']['ct_mp']='> 1 mes';
$hesklang['statistics']['axis1']='% de tickets contestados';
$hesklang['statistics']['axis2']='% de tickets resueltos';
$hesklang['statistics']['axis3']='% de tickets';
$hesklang['statistics']['axis4']='Tiempo para la primera respuesta';
$hesklang['statistics']['axis5']='Tiempo para resolver';
$hesklang['statistics']['axis6']='Número de respuestas';
$hesklang['statistics']['axis7']='Número de tickets';
$hesklang['statistics']['axis8']='Día de la semana';
$hesklang['statistics']['axis9']='Hora';
$hesklang['statistics']['axis10']='Día del mes';
$hesklang['statistics']['tr_0']='Sin respuesta';
$hesklang['statistics']['tr_1']='1 respuesta';
$hesklang['statistics']['tr_2']='2 respuestas';
$hesklang['statistics']['tr_5']='3-5 respuestas';
$hesklang['statistics']['tr_10']='6-10 respuestas';
$hesklang['statistics']['tr_99']='> 10 respuestas';
$hesklang['statistics']['average']='Media';
$hesklang['statistics']['atfr']='Promedio de horas y minutos para la primera respuesta del personal:';
$hesklang['statistics']['attr']='Promedio de horas y minutos para resolver un ticket:';
$hesklang['statistics']['about']='alrededor de %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/D';
$hesklang['statistics']['trept']='Total de tickets a los que el personal respondió:';
$hesklang['statistics']['trnr']='Total de tickets resueltos sin respuesta del personal:';
$hesklang['statistics']['tsr']='Total de respuestas del personal:';
$hesklang['statistics']['tsrt']='Promedio de respuestas del personal por ticket:';
$hesklang['statistics']['tsro']='Promedio de respuestas del personal por ticket (tickets con al menos 1 respuesta del personal):';
$hesklang['statistics']['tsrc']='Promedio de respuestas del personal necesarias para resolver un ticket:';
$hesklang['statistics']['tsrr']='Promedio de respuestas del personal necesarias para resolver un ticket (tickets con al menos 1 respuesta del personal):';
$hesklang['sep_1000']='.'; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='y mucho más...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket atrasado';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESCALADO: %%SUBJECT%%';
$hesklang['escalate']['tab']='Escalar'; // Menu link
$hesklang['escalate']['page_title']='Escalar Tickets'; // Page H2 title
$hesklang['escalate']['intro']='Este módulo le ayudará a escalar los tickets que no son atendidos a tiempo.';
$hesklang['escalate']['feat1']='Tickets no asignados, contestados o resueltos en plazo';
$hesklang['escalate']['feat2']='tickets que se acercan a la fecha de vencimiento y tickets vencidos';
$hesklang['escalate']['feat3']='cambiar automáticamente la prioridad del ticket, reasignar un ticket, enviar una notificación por correo electrónico';
$hesklang['escalate']['feat4']='aplicar reglas basadas en la categoría del ticket,  propietario, estado';
$hesklang['escalate']['prefix']='Escalamiento:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Reglas activas';
$hesklang['escalate']['new']='Nueva regla de escalamiento';
$hesklang['escalate']['no_rules']='No tiene ninguna regla de escalamiento. Cree una haciendo click en el botón &quot;Nueva regla de escalamiento&quot; de arriba.';
$hesklang['escalate']['title']='Título de la regla';
$hesklang['escalate']['titlet']='Un título descriptivo, por ejemplo: Reasignar los tickets que no han sido respondidos en un día';
$hesklang['escalate']['default_title']='Regla por %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Activación de la regla';
$hesklang['escalate']['trigt']='Establece la condición que activará (ejecutará) esta regla.';
$hesklang['escalate']['hits']='Activaciones'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condición'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Acción'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Aplica a'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='¿Suprimir esta regla?';
$hesklang['escalate']['edit']='Edición de la regla de escalada ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Un ticket de soporte es:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='no contestado por el personal';
$hesklang['escalate']['nrepc']='no contestado por el cliente';
$hesklang['escalate']['nass']='no asignado';
$hesklang['escalate']['nres']='sin resolver';
$hesklang['escalate']['ndue']='se acerca la fecha de vencimiento';
$hesklang['escalate']['odue']='atrasado';
$hesklang['escalate']['within']='En:';
$hesklang['escalate']['minutes']='minutos';
$hesklang['escalate']['hours']='horas';
$hesklang['escalate']['days']='días';
$hesklang['escalate']['weeks']='semanas';
$hesklang['escalate']['months']='meses';
$hesklang['escalate']['years']='años';
$hesklang['escalate']['ofs']='de ser enviado';
$hesklang['escalate']['resend']='Reenviar notificaciones por correo electrónico:';
$hesklang['escalate']['force']='Enviar siempre, sin tener en cuenta la configuración del personal';
$hesklang['escalate']['noforce']='Respetar la configuración de las notificaciones del personal';
$hesklang['escalate']['setpri']='Establecer la prioridad en:';
$hesklang['escalate']['setsta']='Poner el estado en:';
$hesklang['escalate']['assto']='Asignar ticket a:';
$hesklang['escalate']['asm']='Otro miembro del personal';
$hesklang['escalate']['notify']='Notificar a los miembros del personal...';
$hesklang['escalate']['ato']='Aplica a:';
$hesklang['escalate']['tic']='Tickets en la categoría:';
$hesklang['escalate']['tat']='Tickets asignados a:';
$hesklang['escalate']['tws']='Tickets con estado:';
$hesklang['escalate']['tall']='Aplicar esta regla a los tickets existentes y futuros';
$hesklang['escalate']['tfn']='Aplicar esta regla sólo a los futuros tickets, ignorar los tickets existentes';
$hesklang['escalate']['tfi']='Aplicar esta regla únicamente a tickets con ID mayor a:';
$hesklang['escalate']['save']='Guardar regla';
$hesklang['escalate']['e_tt']='El tiempo debe estar entre 1 y 10000';
$hesklang['escalate']['e_a']='Seleccionar al menos una acción para realizar en los tickets coincidentes';
$hesklang['escalate']['nocat']='Seleccionar al menos una categoría';
$hesklang['escalate']['nouser']='Seleccionar al menos un usuario';
$hesklang['escalate']['nostatus']='Seleccionar al menos un estado';
$hesklang['escalate']['nocata']='%1$s no tiene acceso a estas categorías:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Se ha creado una nueva norma';
$hesklang['escalate']['mdf']='Se han guardado los ajustes de las reglas';
$hesklang['escalate']['e_id']='No se ha encontrado ninguna regla con este ID';
$hesklang['escalate']['deleted']='La regla seleccionada ha sido eliminada';
$hesklang['escalate']['edit_notice']='El cambio del activador de la regla no tendrá efecto en ningún ticket ya escalado por esta regla (a menos que se restablezca la regla).';
$hesklang['escalate']['reset']='Restablecer esta regla';
$hesklang['escalate']['reset2']='¿Está seguro de que quiere restablecer esta regla? <br><br>Las activaciones de la regla pasarán a ser 0 y cualquier ticket que coincida con esta regla será escalado de nuevo.';
$hesklang['escalate']['reset3']='La regla seleccionada ha sido anulada';
$hesklang['escalate']['log_title']='Regla #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | escalado por %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - establecer prioridad a %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - asignar a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - enviar notificación al personal</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - enviar notificación al personal (forzado)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - error: %2$s no tiene acceso a la categoría del ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - error: %2$s no tiene permiso para ver las entradas</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - error: no hay otro usuario que pueda ver este ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - aviso: la prioridad ya está fijada en %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - aviso: ya está asignado a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notificar: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - establecer el estado en %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - aviso: el estado ya está establecido en %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Activa'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Activar esta regla (comenzar a usarla)';
$hesklang['escalate']['activated']='La regla seleccionada ha sido activada'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Desactivar esta regla (dejar de usarla)';
$hesklang['escalate']['deactivated']='La regla seleccionada ha sido desactivada'; // %1$s = rule log title
$hesklang['escalate']['no_active']='No hay reglas de escalamiento activas';
$hesklang['escalate']['matched']='Número de tickets coincidentes encontrados: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Herramientas';
$hesklang['escalate']['test']='Simular esta regla';
$hesklang['escalate']['testa']='Simular todas las reglas';
$hesklang['escalate']['testaa']='Simular todas las reglas activas';
$hesklang['escalate']['testr']='Resultados de la simulación';
$hesklang['escalate']['rsim']='Repetir simulación';
$hesklang['escalate']['tbef']='Antes de que una regla esté activa, debe activarla haciendo click en la casilla de verificación de la columna &quot;ACTIVAR&quot;.<br><br>\n                               Recomendamos encarecidamente que <strong>simules</strong> cada regla haciendo click en el icono %1$s (Simular esta regla) en la tabla de reglas\n                               para ver cómo afectará a sus tickets existentes antes de activarla.<br><br>\n                               Las reglas activas se procesan cada %2$s minutos.  Un ticket sólo puede ser escalado una vez por cada regla</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='MODO SIMULACIÓN, sin cambios en la base de datos';
$hesklang['escalate']['sic']='SIMULACIÓN COMPLETA';
$hesklang['escalate']['r']='[REGLA]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Consejo: mantener pulsada la tecla CTRL para seleccionar varias opciones';
$hesklang['desc_ticket_escalated']='(Personal) El ticket ha sido escalado'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Formato de los tickets (Personal)';
$hesklang['ticket_formatting_plaintext']='Texto Plano';
$hesklang['ticket_formatting_rich_text']='Texto Enriquecido (HTML)';
$hesklang['due_date']='Fecha de vencimiento';
$hesklang['invalid_due_date']='Se ha introducido una fecha de vencimiento no válida.';
$hesklang['thist19']='<li class="smaller">%s | fecha de vencimiento actualizada a %s por %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | fecha de vencimiento eliminada por %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Se ha actualizado la fecha de vencimiento del ticket.';
$hesklang['menu_kb_manage']='Gestionar'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Ver'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Seleccionar todo';
$hesklang['a_deselect']='Deseleccionar todo';
$hesklang['a_toggle']='Alternar todo';
$hesklang['ql_all']='Todos los tickets';
$hesklang['ql_alo']='Todos los tickets abiertos';
$hesklang['ql_fit']='Tickets filtrados';
$hesklang['ql_a2m']='Asignados a mí';
$hesklang['ql_a2o']='Asignados a otros';
$hesklang['ql_una']='Sin asignar';
$hesklang['ql_due']='Próximos a vencer';
$hesklang['ql_ovr']='Atrasados';
$hesklang['set_ds']='Mostrar como &quot;Próximo a vencer&quot'; // Settings page (title of setting)
$hesklang['set_ds2']='días antes de la fecha límite';
$hesklang['not_aos']='Algunos tickets abiertos a los que hay acceso no se muestran debido a sus filtros.';
$hesklang['ntoverdue']='Un ticket está atrasado con el asunto:';
$hesklang['ovdcron']='para que las notificaciones de vencimiento funcionen, su administrador debe habilitar un trabajo cron.';
$hesklang['instructions']='Instrucciones';
$hesklang['desc_overdue_ticket']='(Personal) Ticket atrasado';
$hesklang['overdue_starting']='Inicio del proceso de notificación de tickets atrasados';
$hesklang['overdue_sim']='El envío de correos electrónicos y la actualización de tickets están desactivados en el modo SIMULACIÓN.';
$hesklang['overdue_ticket_count']='Se han encontrado %s tickets que están atrasados.'; // %s = Number of tickets
$hesklang['overdue_finished']='Tickets atrasados terminados. %s emails enviados. %s correos electrónicos no enviados.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Cargar un archivo de estilo personalizado adicional para el panel de administración';
$hesklang['noval_cert']='No validar los certificados del servidor';
$hesklang['chg_cat']='Click para cambiar la categoría del ticket';
$hesklang['tlan']='Idioma del ticket';
$hesklang['uue']='Dos o más miembros del personal tienen la misma dirección de correo electrónico. Se recomienda establecer una dirección de correo electrónico única para cada usuario.';
$hesklang['flood']='Límite de desbordamiento (flood)';
$hesklang['e_flood']='Ooops, ya ha enviado una respuesta hace poco. Hemos detenido esta solicitud para evitar la inundación de respuestas.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='Clave de acceso URL'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Generar una clave de acceso URL aleatoria';
$hesklang['ukeym']='Error: para ejecutar este archivo a través de HTTP debe incluir su clave de acceso a la URL en la solicitud. Ejemplo:';
$hesklang['ukeyw']='Error: clave de acceso a la URL incorrecta';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket recibido: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% es su código de verificación';
$hesklang['follow_up_email']='Honestamente - ¿cómo lo hemos hecho?';
$hesklang['mfa']='Autenticación multifactor (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='¿MFA Habilitado?';
$hesklang['mfa_required']='Requerir autenticación multifactor';
$hesklang['mfa_manage_profile']='Administrar MFA';
$hesklang['mfa_disabled']='Autenticación multifactor deshabilitada';
$hesklang['mfa_enabled']='Autenticación multifactor habilitada (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Ninguno';
$hesklang['mfa_method_none_subtext']='Eliminar la autenticación multifactor en su cuenta.';
$hesklang['mfa_method_email']='Correo electrónico';
$hesklang['mfa_method_email_subtext']='El servicio de asistencia enviará un correo electrónico con un código de inicio de sesión aleatorio a <strong>%s</strong> al iniciar la sesión.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Aplicación de autenticación';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Utilice una aplicación para teléfonos inteligentes, como Authy o Google Authenticator, para generar un código de acceso aleatorio al iniciar la sesión.';
$hesklang['mfa_step_method']='Método';
$hesklang['mfa_step_verification']='Verificación';
$hesklang['mfa_step_complete']='Completado';
$hesklang['mfa_introduction']='La autenticación multifactor mejora la seguridad de la cuenta al exigir verificar el inicio de sesión mediante un método de verificación adicional, como el correo electrónico o una aplicación de autenticación (como Authy o Google Authenticator).';
$hesklang['mfa_reset_warning']='Ya tiene activada la autenticación multifactor. Al completar esto de nuevo, se restablecerá su dispositivo de autenticación multifactor (si está habilitado).';
$hesklang['mfa_select_method_colon']='Seleccione un método de autenticación:';
$hesklang['mfa_verification_header']='Verificación - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Se ha enviado un correo electrónico a <strong>%s</strong> con un código de verificación de seis dígitos. Introduzca el código que ha recibido por correo electrónico a continuación para continuar.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Paso 1: Escanee la siguiente imagen con la aplicación de autenticación multifactor en su dispositivo móvil.';
$hesklang['mfa_verification_auth_app_cant_scan']='¿No puede escanear la imagen? Introduzca manualmente este código en su dispositivo: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Paso 2: Introduzca el código de 6 dígitos que aparece en su aplicación para verificar su dispositivo.';
$hesklang['mfa_verify']='Verifique';
$hesklang['mfa_invalid_method']='Se ha recibido un método de autenticación multifactor no válido.';
$hesklang['mfa_invalid_verification_code']='El código introducido es incorrecto o ha caducado.';
$hesklang['mfa_configured']='¡Se ha activado la autenticación multifactor para su cuenta!';
$hesklang['mfa_removed']='¡Se ha desactivado la autenticación multifactor para su cuenta!';
$hesklang['mfa_verification_needed']='La autenticación multifactor está activada para esta cuenta.';
$hesklang['mfa_verification_needed_email']='Por favor, introduzca el código de verificación que se le ha enviado a su dirección de correo electrónico.';
$hesklang['mfa_verification_needed_auth_app']='Introduzca el código que aparece en su aplicación de autenticación.';
$hesklang['mfa_verification_code']='Código de verificación';
$hesklang['mfa_server_time_issue']='La hora de su servidor parece ser inexacta: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Restablecer la autenticación multifactor';
$hesklang['mfa_reset_confirm']='¿Seguro que desea restablecer la MFA para este usuario?';
$hesklang['mfa_reset_yes']='Restablecer';
$hesklang['mfa_reset']='La autenticación multifactor se ha restablecido para el usuario';
$hesklang['desc_mfa_verification']='(Personal) Código de autenticación multifactor';
$hesklang['mfa_code']='Código:';
$hesklang['mfa_backup_codes_header']='¡GUARDE SUS CÓDIGOS DE SEGURIDAD!';
$hesklang['mfa_backup_codes_description']='Guarde estos códigos de seguridad en un lugar seguro pero accesible. En caso de que pierda el acceso a su dispositivo MFA o a su correo electrónico, puede introducir uno de los siguientes códigos de reserva para iniciar la sesión.<br><br><strong>Asegúrese de tratar estos códigos de seguridad como contraseñas. ¡No podrá volver a ver estos códigos!</strong>';
$hesklang['mfa_verify_another_way']='Verifique su cuenta de otra manera'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Obtenga un código de verificación en %s';
$hesklang['mfa_verify_another_way_code']='Introduzca uno de sus códigos de seguridad de 8 caracteres';
$hesklang['mfa_verify_another_way_admin']='Póngase en contacto con el administrador del servicio de asistencia para obtener ayuda';
$hesklang['mfa_verify_another_way_reset']='Restablecer la autenticación multifactor cargando un archivo en el servidor';
$hesklang['mfa_send_another_email']='Enviar otro correo electrónico';
$hesklang['mfa_sent']='Se ha enviado un correo electrónico con un nuevo código de verificación a su dirección de correo electrónico';
$hesklang['mfa_backup_code']='Código de Respaldo';
$hesklang['mfa_backup_codes']='Códigos de Respaldo';
$hesklang['mfa_backup_codes_info']='Códigos de un solo uso para pasar la verificación multifactor cuando no pueda acceder a su correo electrónico o a la aplicación de autenticación. Una vez que utilice un código de respaldo para iniciar sesión, ese código queda inactivo.';
$hesklang['mfa_backup_codes_num']='Puede obtener un nuevo conjunto de 10 códigos de reserva cuando lo desee. Cuando se crea un nuevo juego de códigos, el antiguo queda automáticamente inactivo.';
$hesklang['mfa_backup_codes_num2']='Número de sus códigos activos: %s';
$hesklang['mfa_invalid_backup_code']='El código de seguridad introducido es incorrecto o ya ha sido utilizado.';
$hesklang['mfa_del_codes']='Borrar mis códigos de seguridad';
$hesklang['mfa_del_codes2']='Se han borrado todos sus códigos de copia de seguridad.';
$hesklang['mfa_new_codes']='Generación de nuevos códigos de reserva';
$hesklang['mfa_new_codes2']='Se han generado nuevos códigos de copia de seguridad';
$hesklang['old_php_version']='Error: Versión de PHP no soportada';
$hesklang['category_default_due_date']='Fecha de vencimiento por defecto';
$hesklang['category_change_default_due_date']='Establecer Fecha de vencimiento por defecto';
$hesklang['category_leave_blank_for_no_default_due_date']='(dejar en blanco para no establecer fecha de vencimiento por defecto)';
$hesklang['category_default_due_date_updated']='Se ha actualizado la fecha de vencimiento por defecto.';
$hesklang['email_formatting']='Formato de correo electrónico';
$hesklang['email_formatting_html_and_plaintext']='HTML con alternativa de texto plano desde la plantilla de texto plano (por defecto)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML con texto plano alternativo generado a partir de una plantilla HTML';
$hesklang['email_formatting_html']='Sólo HTML';
$hesklang['email_formatting_plaintext']='Sólo texto plano';
$hesklang['email_formatting_note']='Su selección en %1$s &gt; %2$s &gt; %3$s se establece en: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Esto significa que Hesk ignorará las plantillas HTML aquí.';
$hesklang['email_formatting_note1']='Esto significa que Hesk ignorará las plantillas de texto plano aquí.';
$hesklang['email_formatting_note2']='Esto significa que Hesk generará la versión de texto plano de los correos electrónicos a partir de sus plantillas HTML e ignorará las plantillas de texto plano aquí.';
$hesklang['etnu']='Esta plantilla de correo electrónico no es utilizada actualmente por Hesk según su selección en %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Editar Categoría';
$hesklang['create_category']='Crear Categoría';
$hesklang['one_user_included']='1 usuario incluido';
$hesklang['one_user_excluded']='1 usuario excluido';
$hesklang['x_users_included']='%s usuarios incluidos'; // %s = Number of users
$hesklang['x_users_excluded']='%s usuarios excluidos'; // %s = Number of users
$hesklang['aa_cat']='Asignación automática de tickets en esta categoría';
$hesklang['modify_autoassign_settings']='Modificar la configuración de la autoasignación';
$hesklang['autoassign_on_all_users']='Sí, a cualquier usuario con acceso a esta categoría';
$hesklang['autoassign_on_select_users']='Sí, a usuarios específicos';
$hesklang['autoassign_off']='No, envía las entradas como no asignadas';
$hesklang['autoassign_users']='Usuarios a incluir/excluir en la autoasignación';
$hesklang['autoassign_selected_include']='Los usuarios seleccionados deben ser <strong>incluidos</strong> al autoasignar tickets en esta categoría';
$hesklang['autoassign_selected_exclude']='Los usuarios seleccionados deben ser <strong>excluidos</strong> al autoasignar tickets en esta categoría';
$hesklang['cat_edited']='La categoría %s ha sido editada con éxito';
$hesklang['search_for_user']='Buscar usuario';
$hesklang['email_sending']='Envío de correos electrónicos';
$hesklang['email_to_ticket']='Correo electrónico a Ticket';
$hesklang['email_to_ticket_info']='La conversión de los correos electrónicos en tickets requiere una configuración del lado del servidor. Para más detalles, consulte <a href="%s" target="_blank">esta guía de la base de conocimientos</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk utiliza un servidor SMTP para enviar notificaciones por correo electrónico. Su <strong>%1$s</strong> debe establecerse en <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Falta la extensión del archivo';
$hesklang['block_ignore']='Correo electrónico a ticket - Ignora los emails y evita los bucles';
$hesklang['block_noreply']='No responder';
$hesklang['block_noreply2']='Ignorar los correos electrónicos enviados desde direcciones de correo electrónico "no responder".';
$hesklang['block_returned']='Devuelto';
$hesklang['block_returned2']='Ignorar los correos electrónicos devueltos, como las notificaciones de estado de entrega y las respuestas automáticas';
$hesklang['block_duplicate']='Duplicados';
$hesklang['block_duplicate2']='Ignorar los correos electrónicos con el mismo mensaje enviados en un plazo de &quot;%s&quot; segundos'; // %s = "Timeframe"
$hesklang['loop_info']='Correos electrónicos recibidos desde la misma dirección de correo electrónico en &quot;%s&quot; segundos';
$hesklang['thist21']='<li class="smaller">%s | Envío de una notificación por correo electrónico sobre el retraso</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | correo electrónico de seguimiento enviado</li>'; // %s = date
$hesklang['elevator_header']='Entrar en la Zona Segura';
$hesklang['elevator_intro']='Está a punto de entrar en una Zona Segura.';
$hesklang['elevator_enter_password']='Por favor, introduzca su contraseña para continuar.';
$hesklang['elevator_duration_setting_title']='Duración de la Zona Segura';
$hesklang['desc_survey']='(Cliente) Correo electrónico de seguimiento (encuesta)'; // Email description
$hesklang['satisfaction']['tab']='Satisfacción';
$hesklang['satisfaction']['title']='Encuesta de satisfacción del cliente';
$hesklang['satisfaction']['intro']='Envíe a sus clientes una encuesta de satisfacción de seguimiento para recoger sus opiniones sobre la experiencia con su servicio de asistencia técnica.';
$hesklang['satisfaction']['tab1']='Ajustes';
$hesklang['satisfaction']['tab2']='Exclusión';
$hesklang['satisfaction']['enable']='Habilitar los correos electrónicos de seguimiento:';
$hesklang['satisfaction']['enabled']='Habilitadas las encuestas de satisfacción del cliente.';
$hesklang['satisfaction']['disabled']='Deshabilitadas las encuestas de satisfacción del cliente.';
$hesklang['satisfaction']['url']='Dirección URL de la encuesta:';
$hesklang['satisfaction']['send']='Retraso del correo electrónico de seguimiento:';
$hesklang['satisfaction']['at_least']='Espera al menos';
$hesklang['satisfaction']['after']='después de que el Ticket se resuelva antes de enviar el correo electrónico';
$hesklang['satisfaction']['h1']='¿Cómo utilizar esta herramienta?';
$hesklang['satisfaction']['h2']='En primer lugar, cree una encuesta de satisfacción del cliente en su herramienta de encuestas favorita. Si no está seguro de qué herramienta utilizar o qué preguntas hacer, tenemos una <a href="%s" target="_blank">guía disponible aquí</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Cuando su encuesta esté lista, habilite los correos electrónicos de seguimiento utilizando el formulario de abajo. Hesk procesará los tickets resueltos con al menos una respuesta del personal una vez por hora y enviará el enlace de su encuesta a sus clientes.';
$hesklang['satisfaction']['e_url']='Introduzca una dirección URL válida para la encuesta. Esta es la URL a la que serán enviados sus clientes.';
$hesklang['satisfaction']['as']='Introduzca una dirección URL válida para la encuesta. Esta es la URL a la que serán enviados sus clientes.';
$hesklang['satisfaction']['oo1']='Esta página enumera las direcciones de correo electrónico a las que no se enviarán correos electrónicos de seguimiento.';
$hesklang['satisfaction']['oo2']='Sus clientes pueden optar por no recibir correos electrónicos de encuestas haciendo click en un enlace en el correo electrónico. También puede añadir manualmente las direcciones de correo electrónico en esta página.';
$hesklang['satisfaction']['ooe']='Dirección de correo electrónico para excluirse';
$hesklang['satisfaction']['ooe2']='Introduzca la dirección de correo electrónico que desea excluir de la recepción de correos electrónicos de la encuesta.';
$hesklang['satisfaction']['ooe3']='Esta dirección de correo electrónico <i>%s</i> ya ha optado por no recibir correos electrónicos de encuestas.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Optar por la exclusión de este correo electrónico';
$hesklang['satisfaction']['oob']='Excluido por';
$hesklang['satisfaction']['no_oo']='Ningún cliente ha optado por no recibir correos electrónicos de encuestas.';
$hesklang['satisfaction']['oor']='Eliminar';
$hesklang['satisfaction']['oor2']='Correo electrónico eliminado de la lista de exclusión';
$hesklang['satisfaction']['oor3']='Confirmar la eliminación';
$hesklang['satisfaction']['oor4']='Cuando se elimine la opción de exclusión, este usuario volverá a recibir correos electrónicos de seguimiento.';
$hesklang['satisfaction']['optedout']='La dirección de correo electrónico <i>%s</i> fue excluida de la recepción de correos electrónicos de la encuesta.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Identificación de la encuesta inexistente o no válida';
$hesklang['satisfaction']['starting']='Inicio del proceso de notificación de la encuesta de satisfacción del cliente';
$hesklang['satisfaction']['tc']='Se han encontrado %s de tickets cerrados a los que no se les ha enviado la encuesta de satisfacción.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Encuesta de satisfacción del cliente finalizada. Correos electrónicos enviados: %1$s. Correos electrónicos no enviados: %2$s. Entradas sin correo electrónico: %3$s. Entradas con correo electrónico de exclusión: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignorando, este cliente no desea recibir correos electrónicos de encuestas.';
$hesklang['satisfaction']['ne']='Ignorando, este ticket está sin dirección de correo electrónico';
$hesklang['satisfaction']['feat1']='Cree su encuesta utilizando cualquier herramienta de terceros, como Google Forms';
$hesklang['satisfaction']['feat2']='configurar la URL de la encuesta, las preferencias y las limitaciones dentro de este módulo';
$hesklang['satisfaction']['feat3']='cuando se resuelva un ticket, Hesk enviará por correo electrónico a su cliente el enlace a la encuesta';
$hesklang['dfor']='Formato de fecha';
$hesklang['dtfor']='Fecha y Hora';
$hesklang['cdfor']='Formato de selección de fecha';
$hesklang['custom']='Personalizado';
$hesklang['jsc_notice']='La selección de la fecha no soporta el formato de fecha al estilo PHP. Seleccione una de las opciones preconfiguradas o haga click en el icono %s de abajo para ver las opciones de visualización disponibles.'; // %s = replaced by icon
$hesklang['lcf3']='Sólo fecha'; // Display: "Date only"
$hesklang['epdd']='Error al analizar el parámetro \'fecha de vencimiento\':';
$hesklang['edit_pass']='Editar contraseña';
$hesklang['save_pass']='Guardar contraseña';
$hesklang['cur_pass']='Contraseña actual';
$hesklang['cur_pass2']='Debe proporcionar su contraseña actual para poder cambiarla.';
$hesklang['cur_pass3']='Después de actualizar la contraseña con éxito, se le redirigirá a la página de inicio de sesión, donde podrá conectarse con su nueva contraseña.';
$hesklang['e_new_pass']='Por favor, introduzca su nueva contraseña';
$hesklang['pass_len']='La contraseña no debe superar los 64 caracteres';
$hesklang['pass_login']='Vuelva a conectarse después de cambiar su contraseña';
$hesklang['bf_int']='Se ha cerrado la sesión debido a demasiados intentos de verificación fallidos';
$hesklang['tst_cnt']='Número de correos electrónicos que su servidor de correo enviará a Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='Tiene muchos correos electrónicos sin leer en su buzón  (%1$s). Hesk convertirá todos estos correos electrónicos en tickets.<br><br>Es posible que desee marcar los correos electrónicos existentes como leídos antes de habilitar %2$s o utilizar una nueva cuenta de correo electrónico para Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Tiene muchos correos electrónicos en su buzón (%1$s). Hesk convertirá todos estos correos electrónicos en tickets.<br><br>Es posible que desee eliminar los correos electrónicos existentes antes de habilitar %2$s o utilizar una nueva cuenta de correo electrónico para Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Con fecha de vencimiento'; // Due on (date)
$hesklang['search_due_date_range']='Con vencimiento en'; // Due in (X days)
$hesklang['attachment_add_files']='Añadir archivo';
$hesklang['attachment_max_exceeded']='Este archivo no se cargará porque ya ha cargado el número máximo de archivos permitido.';
$hesklang['attachment_viewer_message']='Arrastre los archivos aquí o haga click en el botón \'Añadir archivo\' para seleccionar los archivos que desea cargar.';
$hesklang['attachment_invalid_type_message']='Lo sentimos, pero el tipo de archivo que ha intentado cargar no está permitido.';
$hesklang['attachment_upload_error']='Se ha producido un error al intentar cargar. Por favor, inténtelo de nuevo más tarde.';
$hesklang['attachment_too_large']='Este archivo adjunto supera el tamaño máximo permitido.';
$hesklang['attachment_cancel']='Cancelar';
$hesklang['attachment_confirm_cancel']='¿Está seguro de que quiere cancelar esta carga?';
$hesklang['attachment_remove']='Quitar el adjunto';
$hesklang['attachment_too_many_uploads']='Se han cargado demasiados archivos adjuntos desde su ubicación en un corto período de tiempo. Por favor, intente su solicitud de nuevo más tarde.';
$hesklang['sub_note']='Enviar nota';
$hesklang['can_view_users']='Ver todos los usuarios (pero no gestionarlos)';
$hesklang['welcome1']='Hola, parece que es nuevo por aquí. ¡Bienvenido!';
$hesklang['welcome2']='Para ayudarle a empezar, consulte el %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Guía de inicio rápido de Hesk online';
$hesklang['tmce1']='Utilice Ctrl+Click derecho para acceder al corrector ortográfico';
$hesklang['tmce2']='Mantenga pulsada la tecla Control (Ctrl) y haga click con el botón derecho en la palabra mal escrita para acceder al corrector ortográfico.';
$hesklang['desc_new_ticket_by_staff']='(Cliente) Nuevo ticket enviado por el personal';
$hesklang['mod_et_h']='Puede modificar las plantillas de correo electrónico en %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Establecer el idioma en';
$hesklang['ouwa']='Sólo los usuarios con acceso a esta categoría están listados abajo. Para añadir miembros del personal a esta categoría, edite sus permisos en la página %s'; // %s = Team
$hesklang['previous_tickets']='Tickets anteriores';
$hesklang['no_previous']='No hay tickets anteriores por %s'; // %s = email address
$hesklang['all_previous']='Lista de todas los tickets anteriores';
$hesklang['confirm_delete_ticket']='¿Está seguro de que desea eliminar permanentemente este ticket?';
$hesklang['confirm_delete_reply']='¿Está seguro de que quiere borrar permanentemente esta respuesta?';
$hesklang['select_new_category']='Número de tickets en esta categoría: %s<br><br>Por favor, seleccione una nueva categoría a la que transferir estos tickets:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Número de tickets asignados a este usuario: %1$s<br>Número de <b>open</b> tickets asignados a este usuario: %2$s<br><br>Tickets <b>abiertos</b> serán <b>desasignados</b> después de eliminar este usuario.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Licencia HESK';
$hesklang['hlic_free']='GRATIS';
$hesklang['hlic_buyl']='Comprar una licencia';
$hesklang['hlic_paid']='Con licencia';
$hesklang['antdemo']='El envío de tickets desde el panel de administración se ha desactivado en el modo de demostración.<br><br>Por favor, utilice el <a href="%s" target="_blank">lado público</a> para enviar un ticket de prueba.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Método de autenticación';
$hesklang['email_authentication_method_username_password']='Básico (Usuario / Contraseña)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - No hay ningún proveedor verificado de OAuth configurado.';
$hesklang['email_authentication_method_oauth_link']='Gestionar proveedores OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL de punto de conexión de autorización';
$hesklang['email_oauth_token_url']='URL de punto de conexión de token';
$hesklang['email_oauth_client_id']='ID Cliente';
$hesklang['email_oauth_client_secret']='Secreto Cliente';
$hesklang['email_oauth_scope']='Alcance';
$hesklang['oauth_error_invalid_state']='El estado de OAuth no coincide con el estado enviado al proveedor de OAuth.';
$hesklang['oauth_error_unknown']='Se produjo un error desconocido al intentar guardar tokens de OAuth.';
$hesklang['oauth_error_no_token']='Falta el token de acceso en la respuesta JSON.';
$hesklang['oauth_error_retrieve']='No se puede recuperar un token de acceso. Confirme la configuración de su proveedor de OAuth y vuelva a guardarla para adquirir un nuevo token.';
$hesklang['email_oauth_provider']='Proveedor OAuth';
$hesklang['email_oauth_providers']='Proveedores OAuth';
$hesklang['email_oauth_provider_guide']='Antes de usar OAuth, debe registrar un proveedor de OAuth. Para obtener más información, consulte <a href="%s" target="_blank">esta guía de la base de conocimientos</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Su URI de redirección de OAuth para Hesk es:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Use esta herramienta para agregar proveedores de OAuth a su soporte de escritorio';
$hesklang['email_oauth_provider_name']='Nombre'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Nuevo proveedor';
$hesklang['email_oauth_edit_provider']='Editar proveedor';
$hesklang['email_oauth_provider_being_used_for']='Siendo usado para';
$hesklang['email_oauth_providers_none']='No se guardaron proveedores de OAuth. Puede agregarlos haciendo click en "Nuevo proveedor" arriba.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Este proveedor no se puede eliminar porque está siendo utilizado por el soporte de escritorio.';
$hesklang['email_oauth_confirm_delete_provider']='¿Está seguro de que desea eliminar este proveedor de OAuth?';
$hesklang['oauth_provider_saved']='El proveedor de OAuth se ha guardado';
$hesklang['oauth_provider_use']='Ahora puede seleccionar este proveedor en %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Introduzca el nombre del proveedor';
$hesklang['oauth_provider_err_auth_url']='Introduzca una URL de autorización válida';
$hesklang['oauth_provider_err_token_url']='Introduzca una URL de token válida';
$hesklang['oauth_provider_err_client_id']='Introduzca la identificación del cliente';
$hesklang['oauth_provider_err_client_secret']='Introduzca el secreto del cliente';
$hesklang['oauth_provider_err_scope']='Introduzca el alcance';
$hesklang['oauth_provider_deleted']='Proveedor de OAuth eliminado';
$hesklang['oauth_provider_not_found']='Este proveedor de OAuth no existe';
$hesklang['oauth_provider_verified']='Verificado';
$hesklang['oauth_provider_click_to_verify']='Haga click para verificar';
$hesklang['can_due_date']='Puede establecer la fecha de vencimiento'; // Permission to set and modify due date
$hesklang['can_due_date_e']='No tiene permiso para establecer fechas de vencimiento';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verifique su registro';
$hesklang['customer_verify_new_email']='Verifique su nueva dirección de correo electrónico';
$hesklang['customer_reset_password']='Restablezca su contraseña de soporte técnico';
$hesklang['customer_approved']='Cuenta aprobada';
$hesklang['customer_rejected']='Cuenta rechazada';
$hesklang['email_rejected']='Cuenta necesaria para enviar tickets de soporte';
$hesklang['require_curl']='Esta funcionalidad requiere compatibilidad con <strong>cURL</strong> para PHP habilitada en su servidor. Solicite a su proveedor de alojamiento web que habilite cURL para PHP.';
$hesklang['customer_accounts_heading']='Cuentas de clientes';
$hesklang['customer_accounts']='Cuentas de clientes';
$hesklang['customer_accounts_off']='<strong>Deshabilitado</strong>';
$hesklang['customer_accounts_allowed']='<strong>Habilitado: opcional</strong> (los clientes pueden enviar tickets de soporte sin registrarse ni iniciar sesión)';
$hesklang['customer_accounts_required_to_submit']='<strong>Habilitado: obligatorio para los tickets</strong> (sólo los clientes que hayan iniciado sesión pueden enviar tickets de soporte)';
$hesklang['customer_accounts_required']='<strong>Habilitado: obligatorio para acceder</strong> (sólo los clientes que hayan iniciado sesión pueden acceder al servicio de asistencia y a la base de conocimientos)';
$hesklang['customer_accounts_reg']='Registro de cuenta';
$hesklang['customer_accounts_reg_customer']='Los clientes pueden registrar cuentas';
$hesklang['customer_accounts_reg_approve']='Los clientes pueden registrar cuentas, el personal debe aprobar los nuevos registros';
$hesklang['customer_accounts_reg_staff']='Sólo el personal puede registrar cuentas de clientes';
$hesklang['customer_accounts_allow_email_changes']='Permitir que los clientes cambien su dirección de correo electrónico';
$hesklang['customer_accounts_allow_email_resends']='Tiempo hasta que los clientes puedan solicitar un nuevo correo electrónico de verificación';
$hesklang['customer_login']='Iniciar sesión';
$hesklang['customer_logout']='Cerrar sesión';
$hesklang['customer_register']='Registrarse';
$hesklang['customer_accounts_disabled']='Los inicios de sesión y registros de clientes están deshabilitados.';
$hesklang['customer_accounts_registration_disabled']='Los registros de clientes están deshabilitados.';
$hesklang['customer_forgot_password']='¿Ha olvidado su contraseña?';
$hesklang['customer_email']='Dirección de correo electrónico';
$hesklang['customer_accounts_email_banned']='Se le ha prohibido usar este servicio de asistencia.';
$hesklang['customer_registration_successful']='¡Registro exitoso!';
$hesklang['customer_registration_email_exists_no_reset_link']='Ya existe una cuenta con el correo electrónico %s.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Ya existe una cuenta con el correo electrónico %s. <a href="login.php">¿Desea iniciar sesión en su lugar</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Ya existe una cuenta con el correo electrónico %s y está pendiente de verificación de correo electrónico.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Ya existe una cuenta con el correo electrónico %s y está pendiente de aprobación del personal.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='¡Revise su correo electrónico!';
$hesklang['customer_registration_check_your_email_content']='Debe verificar su dirección de correo electrónico antes de poder iniciar sesión.<br><br>Si no lo recibe en unos minutos, revise sus carpetas de correo no deseado, basura o spam. Marque el mensaje como <b>No SPAM</b> para evitar problemas al recibir nuestra correspondencia en el futuro.';
$hesklang['customer_login_not_verified']='Debe verificar su dirección de correo electrónico antes de poder iniciar sesión.';
$hesklang['customer_login_not_verified2']='Si no recibió nuestro correo electrónico de verificación, revise sus carpetas de correo no deseado, basura o spam. Marque el mensaje como <b>No SPAM</b> para evitar problemas al recibir nuestra correspondencia en el futuro.';
$hesklang['customer_login_resend_verification_email']='Reenviar correo electrónico de verificación';
$hesklang['customer_login_resend_verification_email_none']='No hay verificaciones de correo electrónico pendientes para enviar.';
$hesklang['customer_login_resend_verification_email_too_early']='No puede solicitar un nuevo correo electrónico de verificación en este momento, inténtelo nuevamente más tarde.';
$hesklang['customer_login_not_approved']='Un miembro del personal debe aprobar su cuenta antes de poder iniciar sesión. Una vez aprobada, se le notificará por correo electrónico.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verificar registro';
$hesklang['customer_registration_verify_success']='Su correo electrónico ha sido verificado y ahora puede iniciar sesión utilizando el formulario a continuación.';
$hesklang['customer_registration_verify_approval_needed']='Su correo electrónico ha sido verificado. Sin embargo, un miembro del personal debe aprobar su cuenta antes de poder iniciar sesión. Una vez aprobada, se le notificará por correo electrónico.';
$hesklang['customer_registration_verify_failure']='No se pudo verificar su correo electrónico. El enlace ya se ha utilizado o ha expirado.';
$hesklang['emails_to_customers']='&raquo; Correos electrónicos enviados a clientes';
$hesklang['emails_to_staff']='&raquo; Correos electrónicos enviados al personal';
$hesklang['emails_to_everyone']='&raquo; Correos electrónicos enviados al personal o a los clientes';
$hesklang['new_customer_approval']='Tiene cuentas de clientes pendientes de aprobación'; // Email subject
$hesklang['desc_new_customer_approval']='(Personal) Cuentas de clientes pendientes de aprobación';
$hesklang['n_cust_app']='Hay aprobaciones de clientes pendientes'; // Notify me when...
$hesklang['et_num_customers']='Número de aprobaciones pendientes';
$hesklang['et_link_customers']='Enlace a la página Administrar clientes';
$hesklang['et_link_verify']='Enlace de verificación';
$hesklang['et_cust_login']='URL de inicio de sesión del cliente';
$hesklang['submit_ticket_customer_email_exists']='Ya existe un cliente con este correo electrónico. Por favor, <a href="login.php?email=%s">inicie sesión</a> para enviar un ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Por favor, introduzca una dirección de correo electrónico válida.';
$hesklang['customer_login_password_required']='Por favor, introduzca su contraseña.';
$hesklang['customer_login_remember_just_email']='Recordar sólo mi correo electrónico';
$hesklang['customer_login_remember_email']='Recordar mi correo electrónico';
$hesklang['customer_wrong_user']='Su dirección de correo electrónico %s no está registrada con nosotros.<br><br>¿Desea <a href="register.php">crear una cuenta</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Su dirección de correo electrónico y contraseña no coinciden con nuestros registros.<br><br>¿Desea <a href="login.php?submittedForgot=1">restablecer su contraseña</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Inicie sesión para continuar.';
$hesklang['customer_register_here']='Si no tiene una cuenta con nosotros, puede <a href="register.php">registrarse aquí</a>.';
$hesklang['create_account']='Crear una cuenta';
$hesklang['customer_my_tickets_heading']='Mis tickets';
$hesklang['customer_my_tickets_description']='Ver todos sus tickets anteriores';
$hesklang['customer_my_tickets_search_for_tickets']='Buscar tickets';
$hesklang['customer_password_reset_successful']='Su nueva contraseña ha sido guardada. Ahora puede iniciar sesión.';
$hesklang['customer_profile']='Perfil';
$hesklang['customer_edit_profile']='Editar perfil';
$hesklang['customer_edit_pass']='Editar contraseña';
$hesklang['customer_edit_pass_same']='Su nueva contraseña no debe ser la misma que la actual.';
$hesklang['customer_change_email']='Cambiar correo electrónico';
$hesklang['customer_change_email_banned']='El correo electrónico que ingresó está prohibido.';
$hesklang['customer_change_email_pending']='Hay una solicitud actual para cambiar su dirección de correo electrónico a: <b>%s</b><br><br>Hemos enviado un correo electrónico a esta dirección. Haga clic en el enlace dentro del correo electrónico para confirmar el cambio.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Reenviar correo electrónico de confirmación</a>';
$hesklang['customer_change_email_submitted']='Haga clic en el enlace de verificación que se envió a <b>%s</b> para verificar su nuevo correo electrónico.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Su nueva dirección de correo electrónico ha sido verificada y su perfil actualizado.';
$hesklang['customer_change_email_disabled']='La posibilidad de actualizar su correo electrónico está deshabilitada. Póngase en contacto con nosotros si desea cambiar su dirección de correo electrónico.';
$hesklang['customer_profile_saved']='Su perfil ha sido guardado.';
$hesklang['customers']='Clientes';
$hesklang['customers_intro']='Las cuentas de clientes permiten a los clientes ver todos sus tickets en una ubicación central.';
$hesklang['sure_remove_customer']='¿Está seguro de que desea eliminar este cliente?';
$hesklang['sure_remove_customer_additional_note']='La eliminación de un cliente es definitiva. Una vez eliminado, no se puede recuperar.';
$hesklang['new_customer']='Nuevo cliente';
$hesklang['new_follower']='Nuevo seguidor';
$hesklang['add_customer']='+ Agregar cliente'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Agregar seguidor'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='El cliente proporcionado aún no existe. Haga clic en "Guardar" si desea crear este cliente.';
$hesklang['followers']='Seguidores';
$hesklang['no_customers']='Actualmente no hay clientes en la base de datos.';
$hesklang['no_customers_disabled']='Comenzará a ver clientes aquí cuando envíen tickets de soporte.';
$hesklang['no_customers_enabled']='Comenzará a ver clientes aquí cuando se registren o envíen tickets de soporte.';
$hesklang['no_customers_enabled2']='Alternativamente, los botones sobre este mensaje le permiten crear manualmente cuentas de clientes o importar clientes existentes al servicio de asistencia.';
$hesklang['import_customers']='Importar clientes';
$hesklang['import_customers_tip']='Use un archivo CSV para importar varios clientes a la vez.';
$hesklang['customer_not_found']='¡No ​​se encontró el cliente para el ticket!';
$hesklang['search_by_name_or_email']='Buscar por nombre o correo electrónico...';
$hesklang['search_by_pattern']='Buscar por patrón...';
$hesklang['is_searchable']='Se puede buscar';
$hesklang['custom_is_searchable']='Se puede buscar';
$hesklang['yes_via_autocomplete']='Sí (buscar mediante autocompletar)';
$hesklang['customer_required']='Debe seleccionar un cliente';
$hesklang['customer_email_exists']='Ya existe un cliente con este correo electrónico.';
$hesklang['customer_name_with_no_email_exists']='Ya existe un cliente con este nombre y sin correo electrónico.';
$hesklang['an_error_occurred_validating_email']='Se produjo un error al intentar verificar la dirección de correo electrónico ingresada.';
$hesklang['customer_count_x_more']='+%s más'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registrado';
$hesklang['customer_account_verified']='Verificado';
$hesklang['customer_account_verified_help']='Los clientes deben verificar su cuenta a través de un enlace de activación enviado a su dirección de correo electrónico antes de poder iniciar sesión en su cuenta.';
$hesklang['customer_account_setting_password_will_verify_user']='Al establecer una contraseña para este cliente, se verificará automáticamente su cuenta.';
$hesklang['deleting_customer_with_tickets']='Este cliente tiene %1$s ticket(s) <b>(%2$s abiertos)</b> que también tienen otros clientes asociados a ellos.<br>¿Qué se debe hacer con estos tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Se necesita una dirección de correo electrónico válida para volver a enviar un correo electrónico de verificación.';
$hesklang['customer_resend_verification_email_not_found']='No existe ninguna cuenta con esta dirección de correo electrónico o la cuenta ya ha sido verificada.';
$hesklang['customer_resend_verification_email_sent']='Se ha enviado un correo electrónico de verificación a su dirección de correo electrónico.<br><br>Si no lo recibe en unos minutos, revise sus carpetas de correo no deseado, correo masivo o spam. Marque el mensaje como <b>No SPAM</b> para evitar problemas al recibir nuestra correspondencia en el futuro.';
$hesklang['customer_permission_denied']='No tiene permiso para modificar clientes.';
$hesklang['customer_manage_approvals']='Cuentas de clientes pendientes de aprobación: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Aprobar cliente';
$hesklang['customer_manage_bulk_approve']='Aprobar clientes seleccionados';
$hesklang['customer_manage_bulk_approve_complete']='Clientes aprobados: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Rechazar cliente';
$hesklang['customer_manage_bulk_reject']='Rechazar clientes seleccionados';
$hesklang['customer_manage_bulk_reject_complete']='Clientes rechazados: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Eliminar cliente';
$hesklang['customer_manage_bulk_delete']='Eliminar clientes seleccionados';
$hesklang['customer_manage_bulk_delete_complete']='Clientes eliminados: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Editar cliente';
$hesklang['customer_manage_verification_email_sent']='Se ha enviado un correo electrónico de verificación a %s'; // %s = customer's email
$hesklang['can_man_customers']='Administrar clientes';
$hesklang['can_view_customers']='Ver todos los clientes (pero no administrarlos)';
$hesklang['import_customer_select_file']='Seleccionar archivo';
$hesklang['import_customer_step1_instructions']='Para importar clientes, prepare un archivo CSV (valores separados por comas).';
$hesklang['import_customer_step1_note']='Seleccione su archivo CSV';
$hesklang['import_customer_step1_separator']='Las columnas de mi archivo CSV están separadas por';
$hesklang['import_customer_sample']='&raquo; Archivos CSV de muestra';
$hesklang['import_customer_sample_1']='Archivo CSV de estilo estadounidense con columnas separadas por ,';
$hesklang['import_customer_sample_2']='Archivo CSV de estilo europeo con columnas separadas por ;';
$hesklang['import_customer_upload_requirements_1']='Su archivo CSV debe incluir al menos una columna de nombre o dirección de correo electrónico. La columna de contraseña es opcional.';
$hesklang['import_customer_upload_requirements_2']='La primera fila de su archivo debe contener encabezados de columna.';
$hesklang['import_customer_upload_requirements_3']='Su archivo debe estar codificado en UTF-8.';
$hesklang['import_customer_select_columns']='Seleccionar columnas';
$hesklang['import_customer_upload_customers']='Cargar clientes';
$hesklang['import_customer_column_name']='Columna de nombre';
$hesklang['import_customer_column_email']='Columna de correo electrónico';
$hesklang['import_customer_column_pass']='Columna de contraseña';
$hesklang['import_customer_step2_note']='Seleccione el nombre de columna correcto de su archivo CSV en los menús desplegables y luego haga clic en "Siguiente".';
$hesklang['import_customer_name_or_email_required']='Se requiere el nombre o el correo electrónico';
$hesklang['import_customer_step3_note']='Se están importando sus clientes. ¡No abandone esta página!';
$hesklang['import_customer_step3_pending']='Pendiente';
$hesklang['import_customer_step3_successful_imports']='Importaciones exitosas';
$hesklang['import_customer_step3_failed_imports']='Importaciones fallidas';
$hesklang['import_customer_step3_progress']='Progreso';
$hesklang['import_customer_step3_complete_some_failed']='El proceso de importación se completó, sin embargo, <b>%s</b> clientes no pudieron importar. Consulte la tabla a continuación para obtener más información.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='¡El proceso de importación se ha completado!';
$hesklang['import_customer_step3_importing']='Importando';
$hesklang['staff_deleted']='[Personal eliminado]';
$hesklang['customer_account_approved']='Registro de cliente aprobado';
$hesklang['customer_account_rejected']='Registro de cliente rechazado';
$hesklang['customer_account_deleted']='Registro de cliente eliminado';
$hesklang['ticket_followers']='Seguidores de tickets';
$hesklang['ticket_followers2']='Permitir que los tickets tengan varios clientes';
$hesklang['add_cc']='Agregar Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separa cada correo electrónico con una coma.';
$hesklang['search_customers']='Buscar clientes';
$hesklang['page_size']='Tamaño de página';
$hesklang['customers_on_pages']='Número de clientes: %d | Número de páginas: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Cliente) Restablezca su contraseña';
$hesklang['desc_customer_verify_registration']='(Cliente) Verifique su registro';
$hesklang['desc_customer_verify_new_email']='(Cliente) Verifique su nuevo correo electrónico';
$hesklang['desc_customer_approved']='(Cliente) Cuenta aprobada';
$hesklang['desc_customer_rejected']='(Cliente) Cuenta rechazada';
$hesklang['desc_email_rejected_can_self_register']='(Cliente) Ticket por correo electrónico rechazado; el cliente puede registrarse por sí mismo';
$hesklang['desc_email_rejected_cannot_self_register']='(Cliente) Ticket por correo electrónico rechazado; el cliente no puede registrarse por sí mismo';
$hesklang['user_added_success_no_pass']='Se agregó correctamente el nuevo usuario %s';
$hesklang['email_tag_requester']='Solicitante (De)';
$hesklang['email_tag_requester_name']='Nombre del solicitante (De)';
$hesklang['email_tag_requester_first_name']='Nombre del solicitante (De)';
$hesklang['email_tag_requester_email']='Correo electrónico del solicitante (De)';
$hesklang['email_tag_followers']='Seguidores (Cc)';
$hesklang['email_tag_follower_names']='Nombres de los seguidores (Cc)';
$hesklang['email_tag_follower_emails']='Correos electrónicos de los seguidores (Cc)';
$hesklang['barcode']='Código de barras';
$hesklang['barcode_use']='Mostrar un código de barras en los tickets impresos';
$hesklang['barcode_staff_only']='Ocultar el código de barras a los clientes';
$hesklang['barcode_type']='Tipo de código de barras';
$hesklang['barcode_format']='Formato';
$hesklang['barcode_width']='Ancho';
$hesklang['barcode_height']='Alto';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Fondo';
$hesklang['copy_link']='Copiar enlace del ticket';
$hesklang['copy_link_title']='Copiar enlace público a este ticket';
$hesklang['copy_link_exp']='El enlace copiado es el enlace directo para que el cliente vea este ticket';
$hesklang['copy_value']='Copiar este valor';
$hesklang['download_class']='Esta función requiere la clase ZipArchive. Solicite a su host que compile PHP con soporte para zip.';
$hesklang['download_all']='Descargar todo';
$hesklang['download_prep']='Preparando descarga...';
$hesklang['download_tma']='Demasiados archivos adjuntos';
$hesklang['download_nva']='No hay archivos adjuntos válidos';
$hesklang['download_ntd']='No hay nada que descargar';
$hesklang['resolved_at']='Resuelto en';
$hesklang['disable_GSSAPI']='Deshabilitar el autenticador GSSAPI (solución temporal para errores de Kerberos)';
$hesklang['ex_history']='Incluir el registro del historial de tickets en la exportación';
$hesklang['sm_location']='Ubicación'; // Location (page) of a service message
$hesklang['loc_sm']='Mostrar este mensaje de servicio en:';
$hesklang['loc_all']='Cada página del cliente';
$hesklang['loc_norec']='(no recomendado)';
$hesklang['loc_home']='Página de inicio del servicio de asistencia técnica';
$hesklang['loc_selected']='En las páginas seleccionadas';
$hesklang['loc_selerr']='Seleccione al menos una página en la que mostrar el mensaje';
$hesklang['loc_t_cat']='Enviar un ticket - seleccionar una categoría';
$hesklang['loc_t_add']='Enviar un ticket - enviar un formulario de ticket';
$hesklang['loc_t_ok']='Enviar un ticket - confirmación del ticket';
$hesklang['loc_t_view']='Ver un ticket';
$hesklang['loc_t_form']='Ver un formulario de ticket';
$hesklang['loc_kb_main']='Página de inicio de la base de conocimientos';
$hesklang['loc_kb_sub']='Páginas de subcategorías de la base de conocimientos';
$hesklang['loc_kb_art']='Artículos de la base de conocimientos';
$hesklang['loc_login']='Página de inicio de sesión del cliente';
$hesklang['loc_register']='Página de registro del cliente';
$hesklang['loc_register_ok']='El cliente se ha registrado correctamente';
$hesklang['loc_acc']='Página &quot;Mis tickets&quot; del cliente';
$hesklang['loc_profile']='Página &quot;Perfil&quot; del cliente';
$hesklang['sending_show']='Mostrar notificación &quot;Enviando&quot;';
$hesklang['sending_wait']='Enviando, espere...';
$hesklang['e_c_email']='Introduzca la dirección de correo electrónico correcta para ver este ticket';
$hesklang['only_verified_cc']='Los seguidores que no tengan una cuenta verificada serán ignorados.';
$hesklang['followers_removed']='Estas direcciones de correo electrónico se han eliminado del ticket porque no tienen una cuenta verificada:';
$hesklang['novace']='No encontramos ninguna cuenta registrada y verificada con esta dirección de correo electrónico.';
$hesklang['max_recipients']='Máximo de destinatarios';
$hesklang['max_recipients2']='en un solo correo electrónico';
$hesklang['admin_js']='JS de administrador';
$hesklang['admin_js2']='Cargar un archivo Javascript personalizado adicional para el panel de administración';
$hesklang['cf_limit_all']='Ha alcanzado el límite de campos personalizados y no puede crear nuevos campos personalizados.';
$hesklang['remind_assigned']='Recordatorio al personal asignado';
$hesklang['remind_sent']='Recordatorio por correo electrónico enviado al miembro del personal asignado';
$hesklang['thist23']='<li class="smaller">%s | recordatorio enviado a %s por %s</li>';
$hesklang['ql_bookmarks']='Marcadores';
$hesklang['bookmark']='Mi marcador';
$hesklang['bookmarks_add']='Añadir a marcadores';
$hesklang['bookmarks_added']='Este ticket ha sido añadido a sus marcadores';
$hesklang['bookmarks_remove']='Quitar de marcadores';
$hesklang['bookmarks_removed']='Este ticket ha sido eliminado de sus marcadores';
$hesklang['genl_not_copied']='Error: Copiar al portapapeles no es compatible con este dispositivo/navegador.';
$hesklang['profile_duplicate_email']='El usuario con el correo electrónico <b>%s</b> ya existe.'; // %s: new email
$hesklang['seq_id_numeric']='La búsqueda de número de ticket debe contener sólo números';
$hesklang['confirm_new_pass']='Confirmar nueva contraseña';
$hesklang['piping_notify_rejected_customers1']='Correos electrónicos de rechazo de clientes';
$hesklang['piping_notify_rejected_customers2']='Enviar un correo electrónico de rechazo a los clientes cuando su ticket sea rechazado';
$hesklang['piping_notify_rejected_customers3']='Tiempo entre correos electrónicos de rechazo';
$hesklang['register_url']='URL de registro';
$hesklang['email_subject']='Asunto del correo electrónico';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Colaborando en el ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] El personal respondió a: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Nota añadida a: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket vencido: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resuelto: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Fecha límite para enviar correos electrónicos de seguimiento:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='No enviar correos electrónicos a tickets resueltos hace más de'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='(debe ser un período mayor a "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='El período de la fecha límite para enviar correos electrónicos debe ser mayor que el retraso del correo electrónico de seguimiento';
$hesklang['available_language']='Idiomas disponibles';
$hesklang['click_to_show_available_language']='Haga clic para mostrar los idiomas disponibles';
$hesklang['install_lan']='Instalar';
$hesklang['remove_lan']='Eliminar';
$hesklang['title_lan']='Título';
$hesklang['description_lan']='Descripción';
$hesklang['completed_lan']='Completado';
$hesklang['no_language_availble']='No hay idiomas disponibles';
$hesklang['success_install_lan_txt']='El idioma se ha añadido correctamente';
$hesklang['error_install_lan_txt']='El idioma no se ha añadido';
$hesklang['success_remove_lan_txt']='El idioma se ha eliminado correctamente';
$hesklang['error_remove_lan_txt']='El idioma no se ha eliminado';
$hesklang['remove_default_language_error']='El idioma predeterminado debe permanecer activo y no se puede eliminar';
$hesklang['click_for_manual_step']='Haga clic para la instalación manual';
$hesklang['upgrade_lan']='Actualizar';
$hesklang['success_upgrade_lan_txt']='El idioma se ha actualizado correctamente';
$hesklang['error_upgrade_lan_txt']='El idioma no se ha actualizado';
$hesklang['please_wait']='Espere...';
$hesklang['add_a_note']='Añadir una nota';
$hesklang['add_a_reply']='Añadir una respuesta';
$hesklang['customer_id']='ID del cliente';
$hesklang['deleting_customer_tickets']='Tickets abiertos por el cliente: <b>%1$s</b><br>¿Qué hacemos con estos tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets donde se copia al cliente: <b>%1$s</b><br>Estos perderán a este cliente como seguidor; los tickets se mantienen sin cambios.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Eliminar tickets permanentemente';
$hesklang['deleting_customer_anonymize_tickets2']='Anonimizar tickets (eliminar mensajes y datos personales)';
$hesklang['deleting_customer_retain_tickets2']='Conservar tickets (dejar todos los datos intactos)';
$hesklang['for_staff']='para el personal de soporte técnico'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='para clientes'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='Buzón IMAP';
$hesklang['file_attachment_options']='Opciones de adjuntos de correo electrónico';
$hesklang['link_to_attachments_in_emails']='Enlace a adjuntos en correos electrónicos';
$hesklang['add_attachments_directly_to_emails']='Añadir adjuntos directamente a los correos electrónicos';
$hesklang['directly_attach_file_smaller_than']='Adjuntar directamente solo archivos menores a';
$hesklang['directly_attach_file_of_any_size']='Adjuntar directamente archivos de cualquier tamaño';
$hesklang['directly_attach_only_first_x_attachments']='Adjuntar solo primero directamente';
$hesklang['directly_attach_all_attachments']='Adjuntar todos los adjuntos directamente';
$hesklang['directly_attach_size']='Tamaño del adjunto';
$hesklang['directly_attach_no_of_files']='Número de archivos';
$hesklang['notice_about_directly_attach_files']='Adjuntar muchos archivos o archivos grandes a los correos electrónicos puede causar retrasos en la comunicación con su servidor SMTP';
$hesklang['fatt_2']='Archivos adicionales adjuntos a este mensaje:';
$hesklang['no_collaborators']='Ninguno';
$hesklang['collaborate']='Colaborar en este ticket';
$hesklang['collaborators']='Colaboradores';
$hesklang['ql_cbm']='Colaborador';
$hesklang['collaborating']='Ahora colabora en este ticket';
$hesklang['not_collaborating']='Ya no colabora en este ticket';
$hesklang['add_collaborator']='Añadir colaborador';
$hesklang['user_collaborator_added']='Usuario añadido como colaborador en este ticket';
$hesklang['remove_collaborator']='Eliminar colaborador';
$hesklang['staff_name']='Nombre del personal';
$hesklang['user_collaborator_removed']='Usuario eliminado como colaborador en este ticket';
$hesklang['desc_collaborator_added']='(Staff) Está colaborando en un nuevo ticket';
$hesklang['desc_collaborator_staff_reply']='(Staff) Un miembro del personal respondió a un ticket colaborado';
$hesklang['desc_collaborator_note']='(Staff) Nueva nota añadida a un ticket colaborado';
$hesklang['desc_collaborator_resolved']='(Staff) Se ha resuelto un ticket colaborado';
$hesklang['desc_collaborator_overdue']='(Staff) Un ticket colaborado está vencido';
$hesklang['notify_collaborator_added']='Me han añadido como colaborador del ticket';
$hesklang['notify_collaborator_customer_reply']='El cliente responde a un ticket colaborativo';
$hesklang['notify_collaborator_staff_reply']='El personal responde a un ticket colaborativo';
$hesklang['notify_collaborator_note']='El personal añade una nota a un ticket colaborativo';
$hesklang['notify_collaborator_resolved']='El personal resuelve un ticket colaborativo';
$hesklang['notify_collaborator_overdue']='El ticket colaborativo está vencido';
$hesklang['recurring_tickets']['tab']='Tickets recurrentes'; // Menu link
$hesklang['recurring_tickets']['page_title']='Tickets recurrentes'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatice el trabajo pesado; deje que Hesk genere tickets rutinarios por Usted, justo cuando los necesita.';
$hesklang['recurring_tickets']['active_rules']='Reglas activas';
$hesklang['recurring_tickets']['new']='Nueva regla de ticket recurrente';
$hesklang['recurring_tickets']['no_rules']='No tiene ninguna regla de ticket recurrente. Cree una haciendo clic en el botón "Nueva regla de ticket recurrente" que aparece arriba.';
$hesklang['recurring_tickets']['title']='Título de la regla';
$hesklang['recurring_tickets']['titlet']='Un título descriptivo, por ejemplo: Reasignar tickets no respondidos en un día';
$hesklang['recurring_tickets']['default_title']='Regla de %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Activador de la regla';
$hesklang['recurring_tickets']['trigt']='Establecer la condición que activará (ejecutará) esta regla.';
$hesklang['recurring_tickets']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Hora de creación'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Configuración general'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Campos personalizados'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Contenido'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='¿Eliminar esta regla?';
$hesklang['recurring_tickets']['edit']='Editando el ID de la regla de ticket recurrente %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Dentro de:';
$hesklang['recurring_tickets']['minutes']='minutos';
$hesklang['recurring_tickets']['hours']='horas';
$hesklang['recurring_tickets']['days']='días';
$hesklang['recurring_tickets']['weeks']='semanas';
$hesklang['recurring_tickets']['months']='meses';
$hesklang['recurring_tickets']['years']='años';
$hesklang['recurring_tickets']['setpri']='Establecer prioridad en:';
$hesklang['recurring_tickets']['setsta']='Establecer estado en:';
$hesklang['recurring_tickets']['assto']='Asignar ticket a:';
$hesklang['recurring_tickets']['asm']='Otro miembro del personal';
$hesklang['recurring_tickets']['notify']='Notificar al personal...';
$hesklang['recurring_tickets']['ato']='Aplicar a:';
$hesklang['recurring_tickets']['save']='Guardar regla';
$hesklang['recurring_tickets']['e_tt']='El tiempo debe estar entre 1 y 10000';
$hesklang['recurring_tickets']['nocat']='Seleccionar al menos una categoría';
$hesklang['recurring_tickets']['nouser']='Seleccionar al menos un usuario';
$hesklang['recurring_tickets']['nostatus']='Seleccione al menos un estado';
$hesklang['recurring_tickets']['nocata']='%1$s no tiene acceso a estas categorías:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Se ha creado una nueva regla';
$hesklang['recurring_tickets']['mdf']='Se ha guardado la configuración de la regla';
$hesklang['recurring_tickets']['e_id']='No se encontró ninguna regla con este ID';
$hesklang['recurring_tickets']['deleted']='La regla seleccionada ha sido eliminada';
$hesklang['recurring_tickets']['log_title']='Regla #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Activa'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activar esta regla (empezar a usarla)';
$hesklang['recurring_tickets']['activated']='La regla seleccionada ha sido activada'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Desactivar esta regla (dejar de usarla)';
$hesklang['recurring_tickets']['deactivated']='La regla seleccionada ha sido desactivada'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No hay reglas de tickets recurrentes activas';
$hesklang['recurring_tickets']['tools']='Herramientas';
$hesklang['recurring_tickets']['tbef']='Antes de que una regla esté activa, debe activarla marcando la casilla de verificación en la columna "ACTIVO".<br><br>
<strong>Las reglas activas se procesan cada %2$s minutos.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Regla #%s';
$hesklang['recurring_tickets']['r3']='Regla #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Número de tickets ya creados hoy: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Restablecer esta regla';
$hesklang['recurring_tickets']['reset2']='¿Está seguro de que desea restablecer esta regla?<br><br>Los aciertos de la regla se reducirán a 0 y cualquier ticket ya generado hoy podría regenerarse en la próxima ejecución del cron.';
$hesklang['recurring_tickets']['reset3']='La regla seleccionada se ha restablecido';
$hesklang['recurring_tickets']['test']='Simular esta regla';
$hesklang['recurring_tickets']['testa']='Simular todas las reglas';
$hesklang['recurring_tickets']['testaa']='Simular todas las reglas activas';
$hesklang['recurring_tickets']['testr']='Resultados de la simulación';
$hesklang['recurring_tickets']['rsim']='Repetir simulación';
$hesklang['recurring_tickets']['sim']='MODO DE SIMULACIÓN, sin cambios en la base de datos';
$hesklang['recurring_tickets']['sic']='SIMULACIÓN COMPLETA';
$hesklang['recurring_tickets']['rrule_type_required']='Seleccione un activador de regla recurrente válido.';
$hesklang['recurring_tickets']['rrule_string_required']='Seleccione todas las opciones de activador de regla recurrente requeridas.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Ingrese un valor de intervalo de 1 o mayor para "Cada".';
$hesklang['recurring_tickets']['disable_note']='*Si se modifica alguna configuración crítica de hesk después de crear una regla, se deshabilitará en el siguiente intento de ejecución y deberá editarse para cumplir con los nuevos requisitos de validación.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | Enviado por la regla de tickets recurrentes "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | Asignado a %2$s por la regla de tickets recurrentes "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | Cerrado automáticamente por la regla de tickets recurrentes "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | estado cambiado a %2$s por la regla de tickets recurrentes "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | asignado automáticamente a %2$s por la regla de tickets recurrentes "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='La regla se deshabilitó debido a errores de validación. Consulte a continuación para obtener más información.';
$hesklang['recurring_tickets']['errors_title']='Una o más de sus reglas produjeron errores al intentar ejecutarse y se deshabilitaron.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Errores de la regla #%s:';
$hesklang['recurring_tickets']['create_customers']='No hay clientes existentes; por favor, créelos <a href="%s" target="_blank">aquí</a>.';
$hesklang['recurring_tickets']['exec_dates']='Fechas de ejecución de la regla';
$hesklang['recurring_tickets']['show_exec_dates']='[Mostrar fechas de ejecución de la regla actual]';
$hesklang['recurring_tickets']['no_exec_dates']='Seleccione activadores de reglas válidos para ver las fechas de ejecución.';
$hesklang['recurring_tickets']['invalid_disabled']='Configuración de regla inválida - regla deshabilitada.';
$hesklang['recurring_tickets']['next_occ']='Próximas %s ocurrencias de la regla:';
$hesklang['recurring_tickets']['occ_on']='en %s';
$hesklang['recurring_tickets']['not_firing_today']='No es necesario activarlo hoy.';
$hesklang['recurring_tickets']['rules_fulfilled']='Reglas recurrentes cumplidas - ¡ticket creado hoy!';
$hesklang['recurring_tickets']['validation_failed']='Error de validación - regla deshabilitada. Detalles a continuación:';
$hesklang['recurring_tickets']['validation_error']='Error de validación:';
$hesklang['recurring_tickets']['processed']='Procesado.';
$hesklang['recurring_tickets']['created_ticket']='ID del ticket creado: %1$s, ID de seguimiento: %2$s';
$hesklang['recurring_tickets']['due_date_note']='Relativo a la fecha de creación del ticket';
$hesklang['priorities']='Prioridades';
$hesklang['priority_intro']='Utilice esta herramienta para gestionar las prioridades de los tickets de su servicio de asistencia';
$hesklang['new_priority']='Nueva prioridad';
$hesklang['edit_priority']='Editar prioridad';
$hesklang['priority_title']='Título';
$hesklang['can_customers_select_it']='¿Pueden los clientes seleccionar esta prioridad?';
$hesklang['selected_by_customer']='Seleccionable por los clientes';
$hesklang['err_priority']='Ingrese el título de la prioridad';
$hesklang['priority_added']='Se ha añadido una nueva prioridad';
$hesklang['priority_e_id']='ID de prioridad no válido';
$hesklang['priority_mdf']='Se ha guardado la prioridad';
$hesklang['priority_deleted']='Prioridad eliminada';
$hesklang['priority_not_found']='Esta prioridad no existe';
$hesklang['priority_not_empty']='Esta prioridad no se puede eliminar porque existen tickets con esta prioridad';
$hesklang['click_to_enable_drag_drop']='Haga clic para habilitar la función de arrastrar y soltar en la fila y, a continuación, arrástrela hacia arriba o hacia abajo para reorganizar las prioridades.';
$hesklang['confirm_delete_priority']='¿Está seguro de que desea eliminar esta prioridad?';
$hesklang['reordered_message']='Su orden de prioridad se ha guardado.';
$hesklang['list_tkt_priority']='Mostrar todos los tickets con esta prioridad';
$hesklang['deletion_priority_restricted']='Esta es una prioridad especial y no se puede eliminar.';
$hesklang['priority_limit']='No puede crear nuevas prioridades.';
$hesklang['skip_to_main_content']='Ir al contenido principal';
$hesklang['opens_dialog']='Abre un diálogo';
$hesklang['create_a_ticket']='Crear un ticket';
$hesklang['toggle_navigation']='Activar/desactivar navegación';
$hesklang['add_a_ticket_reply']='Añadir una respuesta al ticket';
$hesklang['linked_tickets']='Entradas vinculadas';
$hesklang['no_linked_tickets']='No hay entradas vinculadas';
$hesklang['link_ticket']='Vincular ticket';
$hesklang['can_link_tickets_e']='No está autorizado a vincular/desvincular este ticket';
$hesklang['link_ticket_success']='El ticket se ha vinculado correctamente';
$hesklang['link_ticket_required_error']='Para vincular un ticket, proporcione un ID de seguimiento válido';
$hesklang['link_ticket_itself_error']='Un ticket no se puede vincular a sí mismo. Introduzca un ID de seguimiento diferente';
$hesklang['already_linked_error']='El ticket ya se ha vinculado';
$hesklang['unlink_success']='El ticket se ha desvinculado correctamente';
$hesklang['unlink_error']='No existe ningún registro vinculado';
$hesklang['link_history']='<li class="smaller">%s | %s ticket vinculado por %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket desvinculado por %s</li>';
$hesklang['can_link_tickets']='Se puede vincular el ticket';
$hesklang['link_a_ticket']='Vincular un ticket';
$hesklang['mfa_curl']='No se puede generar una imagen QR para escanear porque la compatibilidad con <strong>cURL</strong> no está habilitada en su servidor.';
$hesklang['require_xml']='Debe habilitarse PHP-XML para mensajes de texto enriquecido (HTML). Solicite a su proveedor de alojamiento web que habilite XML para PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s añadido como colaborador por %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s eliminado como colaborador por %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfecto para trabajos de mantenimiento preventivo, revisiones mensuales de acceso, registros recurrentes de clientes y más.';
$hesklang['recurring_tickets']['feat1']='<strong>Programaciones personalizables.</strong> Diariamente, todos los lunes, cada mes de marzo, el 15 de cada mes o en cualquier fecha futura.';
$hesklang['recurring_tickets']['feat2']='<strong>Llega precargado y asignado.</strong> Elija categoría, prioridad, agente y hasta 100 valores de campo personalizados.';
$hesklang['recurring_tickets']['feat3']='<strong>Vista previa de fechas y simulación.</strong> Vea todos los tickets que Hesk generará antes de activar una regla, para evitar sorpresas.';
$hesklang['unlink_btn']='Desvincular';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='first';
$hesklang['recurring_tickets']['second']='second';
$hesklang['recurring_tickets']['third']='third';
$hesklang['recurring_tickets']['fourth']='fourth';
$hesklang['recurring_tickets']['fifth']='fifth';
$hesklang['recurring_tickets']['rt1_txt']='Every [X] day in Week';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Every [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Every [X] day in Month';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Every [bymonthday] day in Month';
$hesklang['recurring_tickets']['rt3_txt']='Every [X] date in Year';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Every [bymonthday][bymonth] date in Year';
$hesklang['recurring_tickets']['rt4_txt']='Every [nth] [Week day] in Month';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Every [bysetpos] [byweekday] in Month';
$hesklang['recurring_tickets']['rt5_txt']='Every [x] [Days/Weeks/Months]';
$hesklang['recurring_tickets']['rt5_ui']='Every [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='On Specific date';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]On [dtstart]';


$hesklang['nickname']='Nickname';
$hesklang['nicknames']='Nicknames';
$hesklang['staff_nicknames']='Allow staff to set a nickname that will be displayed to customers instead of their real name';
$hesklang['what_cust_see']='This is the name customers will see. If left empty, the real name will be shown.';
$hesklang['login_credentials']='Login credentials';
$hesklang['change_pass_info']='To change your password, use the "Edit password" button in your Profile page';
$hesklang['email_column_display']='Email column display';
$hesklang['email_show_view']='Show "View" link';
$hesklang['email_show_full']='Show full email address';
$hesklang['customer_theme']='Customer theme';
$hesklang['err_customer_theme']='Please select a valid customer theme';
$hesklang['rebuild_assets']='Rebuild Assets';
$hesklang['rebuild_assets_btn']='Rebuild production assets';
$hesklang['rebuild_assets_success']='Production assets rebuilt successfully.';
$hesklang['rebuild_again']='Rebuild again';
$hesklang['rebuilt_assets']='Assets bundled and minified:';
$hesklang['tab_8']='Look & Feel';
$hesklang['laf']='Look &amp; Feel';
$hesklang['theme_name_default']='Ocean Blue (Default)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (Dark)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Most theme colors are created automatically from your Main Brand colors. This helps keep your design consistent and saves you time.<br><br>These automatic colors are marked with an asterisk (<span class="asterix"></span>) and appear under Advanced Settings. When you change a Main Brand color, all linked colors change as well unless you override them manually.';
$hesklang['theme_changed_note']='You have existing theme color overrides, which might not work well with this changed theme - You may want to reset them by clicking on the "Reset all overrides" button.';
$hesklang['theme_overrides']='Theme color overrides';
$hesklang['reset_all_overrides']='Reset all overrides';
$hesklang['view_advanced']='View Advanced Settings';
$hesklang['view_basic']='Back To Basic Settings';
$hesklang['invalid_theme_setting']='Invalid setting key of "%s" passed.';
$hesklang['invalid_hex_color']='Invalid HEX color of "%s" passed for key %s.';
$hesklang['theme_var--yellow-1']='Yellow (Primary)';
$hesklang['theme_var--yellow-2']='Yellow (Secondary)';
$hesklang['theme_var--green-1']='Green';
$hesklang['theme_var--red-1']='Red (Primary)';
$hesklang['theme_var--red-2']='Red (Secondary)';
$hesklang['theme_var--success']='Success color';
$hesklang['theme_var--success-2']='Success (Secondary)';
$hesklang['theme_var--error']='Error color';
$hesklang['theme_var--error-2']='Error (Secondary)';
$hesklang['theme_var--error-3']='Error (Tertiary)';
$hesklang['theme_var--warning']='Warning color';
$hesklang['theme_var--warning-2']='Warning (Secondary)';
$hesklang['theme_var--info']='Info color';
$hesklang['theme_var--info-2']='Info (Secondary)';
$hesklang['theme_var--info-3']='Info (Tertiary)';
$hesklang['theme_var--notification__clr']='Notification text color';
$hesklang['theme_var--primary']='Primary color';
$hesklang['theme_var--secondary']='Secondary color';
$hesklang['theme_var--tertiary']='Tertiary color';
$hesklang['theme_var--surface']='Surface color';
$hesklang['theme_var--main-background']='Main background';
$hesklang['theme_var--font__pri-clr']='Primary font color';
$hesklang['theme_var--font__sec-clr']='Secondary font color';
$hesklang['theme_var--header_logo__clr']='Header logo background';
$hesklang['theme_var--header__bg']='Header background';
$hesklang['theme_var--header_nav__clr']='Header nav color';
$hesklang['theme_var--header_nav__hover_clr']='Header nav hover color';
$hesklang['theme_var--header_links__clr']='Header links color';
$hesklang['theme_var--input-bg']='Input background';
$hesklang['theme_var--input-clr']='Input text color';
$hesklang['theme_var--link__pri-clr']='Primary link color';
$hesklang['theme_var--link__pri-hover-clr']='Primary link hover color';
$hesklang['theme_var--link__sec-clr']='Secondary link color';
$hesklang['theme_var--link__sec-hover-clr']='Secondary link hover color';
$hesklang['theme_var--footer__link-clr']='Footer link color';
$hesklang['theme_var--radio__bg']='Radio background';
$hesklang['theme_var--radio__fill-clr']='Radio fill color';
$hesklang['theme_var--radio__hover-bg']='Footer hover background';
$hesklang['theme_var--radio__hover-fill-clr']='Radio hover fill color';
$hesklang['theme_var--checkbox__bg']='Checkbox background';
$hesklang['theme_var--checkbox__hover-bg']='Checkbox hover background';
$hesklang['theme_var--preview__bg']='Article preview background';
$hesklang['theme_var--preview__border-clr']='Article preview border color';
$hesklang['theme_var--preview__hover-bg']='Article preview hover background';
$hesklang['theme_var--preview__hover-icon-fill']='Article preview hover icon color';
$hesklang['theme_var--preview__title-clr']='Article preview title color';
$hesklang['theme_var--suggest_preview__bg']='Article suggestion background';
$hesklang['theme_var--suggest_preview__clr']='Article suggestion color';
$hesklang['theme_var--suggest_preview__border-clr']='Article suggestion border color';
$hesklang['theme_var--suggest_preview__hover-bg']='Article suggestion hover background';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Article suggestion hover icon color';
$hesklang['theme_var--suggest_preview__title-clr']='Article suggestion title color';
$hesklang['theme_var--article_preview__hover-clr']='Article suggestion hover color';
$hesklang['theme_var--article_preview_suggestion_clr']='Article suggestion color';
$hesklang['theme_var--ticket_body__bg']='Ticket body background';
$hesklang['theme_var--ticket_response__bg']='Ticket response background';
$hesklang['theme_var--table_row__bg']='Table row background';
$hesklang['theme_var--table_row__bg-even']='Table row background (even)';
$hesklang['theme_var--table_row__bg-hover']='Table row hover background';
$hesklang['theme_var--breadcrumbs__a-clr']='Breadcrumbs link color';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Breadcrumbs link hover color';
$hesklang['theme_var--header_profile__clr']='Profile menu color';
$hesklang['theme_var--header_profile__menu-bg']='Profile menu background';
$hesklang['theme_var--header_profile__user-avatar-bg']='Profile menu avatar background';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Profile menu avatar background (mobile)';
$hesklang['theme_var--navlink__bg']='Navigation box background';
$hesklang['theme_var--navlink__clr']='Navigation box color';
$hesklang['theme_var--navlink__hover-bg']='Navigation box hover background';
$hesklang['theme_var--navlink__title-clr']='Navigation box title color';
$hesklang['theme_var--step_bar__item-clr']='Step bar item color';
$hesklang['theme_var--search__clr']='Search color';
$hesklang['theme_var--search__bg']='Search background';
$hesklang['theme_var--search__title-clr']='Search title color';
$hesklang['theme_var--search__input-placeholder-clr']='Search input placeholder color';
$hesklang['theme_var--search__icon-fill']='Search icon fill color';
$hesklang['theme_var--search__input-bg']='Search input background';
$hesklang['theme_var--modal_body__bg']='Modal body background';
$hesklang['theme_var--btn__bg-clr-pri']='Primary button background';
$hesklang['theme_var--btn__clr-pri']='Primary button text color';
$hesklang['theme_var--btn__border-clr-pri']='Primary button border color';
$hesklang['theme_var--btn__disabled-bg-clr']='Disabled button background';
$hesklang['theme_var--btn__disabled-clr']='Disabled button text color';
$hesklang['theme_var--dropdown__bg']='Dropdown background';
$hesklang['theme_var--dropdown__clr']='Dropdown text color';
$hesklang['theme_var--dropdown__border-clr']='Dropdown border color';
$hesklang['theme_var--dropdown_ver1__border-clr']='Dropdown version 1 border color';
$hesklang['theme_var--dropdown_ver2__border-clr']='Dropdown version 2 border color';
$hesklang['theme_var--dropdown__hover-bg']='Dropdown hover background';
$hesklang['theme_var--dropdown__hover-clr']='Dropdown hover text color';
$hesklang['theme_var--dropdown__hover-border-clr']='Dropdown hover border color';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Dropdown version 2 hover border color';
$hesklang['theme_var--datepicker_btn__bg']='Datepicker button background';
$hesklang['theme_var--datepicker_btn__clr']='Datepicker button text color';
$hesklang['theme_var--datepicker__bg']='Datepicker background';
$hesklang['theme_var--datepicker__clr']='Datepicker text color';
$hesklang['theme_group_main_brand']='Main Brand';
$hesklang['theme_group_main_elements']='Main Elements';
$hesklang['theme_group_buttons']='Buttons';
$hesklang['theme_group_navigation']='Navigation';
$hesklang['theme_group_dropdowns']='Dropdowns';
$hesklang['theme_group_datepickers']='Datepickers';
$hesklang['theme_group_base_colors']='Base Colors';
$hesklang['theme_group_notifications']='Notifications';
$hesklang['theme_group_search']='Search';
$hesklang['theme_group_article_previews']='Article Previews';
$hesklang['theme_group_misc']='Miscellaneous';
$hesklang['customer_email_exists_already_registered']='A registered customer with this email already exists.';
$hesklang['link_id']='Ticket number or Tracking ID'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Can manage permission groups';
$hesklang['permission_groups_title']='Permission Groups';
$hesklang['permission_groups_intro']='Permission groups allow you to easily assign helpdesk permissions to several users at once.';
$hesklang['permission_groups_new']='New Permission Group';
$hesklang['permission_groups_name']='Name';
$hesklang['permission_groups_staff_count']='Staff Count';
$hesklang['permission_groups_copy']='Copy Permission Group';
$hesklang['permission_groups_none']='There are currently no permission groups in the database. Create your first one by clicking the "New Permission Group" button above.';
$hesklang['permission_groups_delete_not_allowed']='This permission group cannot be deleted because staff members are assigned to this permission group';
$hesklang['permission_groups_delete_confirm']='Are you sure you want to delete this permission group?';
$hesklang['permission_groups_create_title']='Add New Permission Group';
$hesklang['permission_groups_create_general_info']='General Information';
$hesklang['permission_groups_create_users_none']='All helpdesk staff are admins and do not need to be in a permission group.';
$hesklang['permission_groups_create_submit']='Create Permission Group';
$hesklang['permission_groups_create_success']='Permission group %s created successfully'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Edit Permission Group';
$hesklang['permission_groups_edit_success']='Permission group has been updated successfully';
$hesklang['permission_groups_error_duplicate']='A permission group already exists with name: %s'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Unable to update permission group due to a permissions issue.';
$hesklang['permission_groups_error_name']='Enter permission group name';
$hesklang['permission_groups_error_missing_category_feature']='You must select at least one category or feature';
$hesklang['permission_groups_deleted']='Permission group deleted';
$hesklang['edit_user_notice_with_permission_groups']='This user has access to categories or features via a permission group. To remove access to those categories or features, remove them from the permission group.';
$hesklang['link_selected_tickets']='Link selected tickets';
$hesklang['at_least_two_more']='At least two tickets must be selected to establish a link.';
$hesklang['selected_link_success']='Linking selected tickets processed successfully.<br><br>New links established: %s<br>Existing links ignored: %s';
$hesklang['confirm_ordering_title']='Confirm Automated Changes';
$hesklang['order_cat_by_name']='Order categories by name';
$hesklang['warning_order_cat_by_name']='Are you sure you want to order categories by name? This cannot be undone automatically!';
$hesklang['success_order_cat_by_name']='Categories have been successfully ordered by name.';
$hesklang['order_cat_by_id']='Order categories by ID number';
$hesklang['warning_order_cat_by_id']='Are you sure you want to order categories by ID number? This cannot be undone automatically!';
$hesklang['success_order_cat_by_id']='Categories have been successfully ordered by ID number.';
$hesklang['download_selected']='Download selected';
$hesklang['delete_selected']='Delete selected';
$hesklang['attach_delete_db']='Selected attachments has been successfully removed from the database';
$hesklang['mute_emails']='Mute Emails';
$hesklang['mute_email_intro']='When an email address is muted, the user can still submit tickets and interact with the system as usual. However, no outgoing emails will be sent to the muted email address.';
$hesklang['mute_an_email']='Enter email address to mute';
$hesklang['save_mute_email']='Mute this email';
$hesklang['muted_by']='Muted By';
$hesklang['no_mute_emails']='No emails are being muted.';
$hesklang['enter_mute_email']='Enter the email address you wish to mute.';
$hesklang['valid_mute_email']='Enter a valid email address (<i>john.doe@example.com</i>) or email domain (<i>@example.com</i>)';
$hesklang['email_muted']='The email address <i>%s</i> was muted. No emails will be sent to this address anymore.'; // %s will be replaced with email
$hesklang['email_mute_exists']='The email address <i>%s</i> is already muted.'; // %s will be replaced with email
$hesklang['email_unmuted']='You have successfully unmuted this email';
$hesklang['del_mute_confirm']='Unmute this email address?';
$hesklang['can_mute_emails']='Can mute emails';
$hesklang['can_unmute_emails']='Can unmute emails (enables Can mute emails)';
$hesklang['eis_mute']='This email address is muted.';
$hesklang['click_unmute']='Click here to unmute.';
$hesklang['del_mute']='Unmute';
$hesklang['unmute_email']='Unmute this email';
$hesklang['can_merge_customers']='Merge customers (requires Manage customers)';
$hesklang['merge_selected_customers']='Merge Selected Customers';
$hesklang['customer_merge_complete']='Selected customer accounts were merged successfully.';
$hesklang['merge_more_error']='Please select two or more customers to proceed with the merge.';
$hesklang['merge_target_error']='Target customer not found.';
$hesklang['merge_customer_err']='There was a problem merging customers:';
$hesklang['error_msg_for_approved']='Some customers you selected have already been approved, no further processing is required.';
$hesklang['confirm_merge']='Confirm merging accounts';
$hesklang['confirm_merge_text']='Are you sure you want to merge selected customers?';
$hesklang['confirm_merge_additional_text']='Merging will combine selected customer accounts into one. Once merged, this action cannot be undone.';
$hesklang['customers_pending_approval']='Customer registrations pending approval';
$hesklang['existing_customers']='Existing customers';
$hesklang['cant_deactivate_admin']='You cannot deactivate the default administrator!';
$hesklang['cant_deactivate_own']='You cannot deactivate the profile you are logged in as!';
$hesklang['deactivated_users']='Deactivated Users';
$hesklang['deactivate_user']='Deactivate user';
$hesklang['activate_user']='Activate user';
$hesklang['user_deactivated']='Selected user has been deactivated';
$hesklang['user_activated']='Selected user has been activated';
$hesklang['confirm_deactivation']='Confirm Deactivation';
$hesklang['sure_deactivate_user']='Are you sure you want to deactivate this user?';
$hesklang['deactivating_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deactivating this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Fields in ticket list - Customer side';
$hesklang['setting_extend']='Extend sessions';
$hesklang['extend_admin']='Auto-extend staff sessions';
$hesklang['extend_customer']='Auto-extend customer sessions';
$hesklang['setting_process_to_cc']='Email followers';
$hesklang['setting_process_to_cc_notice']='For this function to work, you must also enable "%s" on page %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Include contacts from the "To" email header as ticket followers';
$hesklang['email_include_cc']='Include contacts from the "Cc" email header as ticket followers';
$hesklang['purge_cache']='Purge the cache';
$hesklang['purge_cache_btn']='Purge all cache now';
$hesklang['purge_cache_done']='The cache has been purged';
$hesklang['customer_name_email_exists']='A customer with this name and email already exists.';
$hesklang['no_cust_sel']='No customer selected, nothing to do';
$hesklang['spam_inbox_notice']='<b>No confirmation email?</b><br />We sent a confirmation message to your email address. If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['write_down_notice']='We recommend that you write down your Ticket ID for future reference.';
$hesklang['theme_colors_note_co']='Themes currently affect only the public-facing (customer) help desk pages.';
$hesklang['ticket_already_in_category']='This ticket is already in category %s, no changes have been made.';
$hesklang['ticket_already_priority']='This ticket has priority already set to %s, no changes have been made.';
$hesklang['ticket_already_unassigned']='This ticket is already unassigned, no changes have been made. ';
$hesklang['conok_but_no_count']='Connection appears to be working, but we cannot get a valid count of emails. <a href="%s">Try this</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Custom HTML';
$hesklang['custom_html_link']='Edit Header &amp; Footer HTML';
$hesklang['custom_head']='Custom Head';
$hesklang['custom_head_desc']='Custom HTML code that will be displayed inside HTML document head (file head.txt).';
$hesklang['custom_head_cmnt']='Custom code to be included before the &lt;/head&gt; tag'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Custom Header';
$hesklang['custom_header_desc']='Custom HTML code that will be displayed before help desk body (file header.txt). For example, you can add your <a href="%s" target="_blank">logo HTML code</a> here.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Custom code to be included after the &lt;body&gt; tag'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Custom Footer';
$hesklang['custom_footer_desc']='Custom HTML code that will be displayed after help desk body (file footer.txt).';
$hesklang['custom_footer_cmnt']='Custom code to be included before the &lt;/body&gt; tag'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='This file is missing or not writable: <b>%s</b><br><br>Set correct file permissions or manually edit the file. On Linux, try setting CHMOD to 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Unable to save changes because required files are not writable by PHP';
$hesklang['custom_html_saved']='Custom HTML code has been saved';
$hesklang['custom_html_disabled']='Editing custom HTML code from this UI has been disabled. Please edit head/header/footer files manually.';
$hesklang['search_by_category']='Find or select a category...';
$hesklang['imap_test_bad']='For a possible solution see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='First reply at';
$hesklang['reply_messages']='Reply messages';
$hesklang['ex_replies']='Include ticket replies in export';
$hesklang['remember_custom_field_values']='Remember custom field values';
$hesklang['disable_autocomplete']='Disable autocomplete';
$hesklang['disable_autofill_admin']='Add autocomplete="off" attribute to customer "Submit a ticket" form';
$hesklang['disable_autofill_customer']='Add autocomplete="off" attribute to staff "Submit a ticket" form';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');