<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Pусский (Russian)
* Version: 3.7.x
*
* ==> CONTRIBUTORS
*
* Nikolai Rykov (http://www.leiming.ru)
* Pavel Khobotov
* Denis Poletchuk
* Michael Krekin
* Mikhail Balakin
* Dmitry Ivlev
* Denis Shipkov
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Pусский';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Russian';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Ответ пишите выше этой строки! ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Новая заявка: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Заявка получена: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Заявка назначена: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Новый ответ [пользователь]: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Новый ответ [специалист]: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Заявка перемещена: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Примечание добавлено к: %%SUBJECT%%';
$hesklang['new_pm']='Новое личное сообщение: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Список Ваших заявок';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Соединение с базой данных невозможно!';
$hesklang['invalid_action']='Неверная операция';
$hesklang['select_username']='Пожалуйста, выберите имя пользователя';
$hesklang['enter_pass']='Пожалуйста, введите пароль';
$hesklang['cant_sql']='Невозможно выполнить SQL';
$hesklang['contact_webmsater']='Пожалуйста, обратитесь к веб-мастеру';
$hesklang['mysql_said']='MySQL ответил';
$hesklang['wrong_pass']='Неверный пароль.';
$hesklang['session_expired']='Время сеанса истекло, пожалуйста, авторизуйтесь.';
$hesklang['attempt']='Попытка неверна!';
$hesklang['not_authorized_tickets']='У Вас нет доступа к просмотру заявок в этой категории!';
$hesklang['must_be_admin']='У Вас нет доступа к этой странице! Для ее просмотра необходимо авторизоваться как администратор.';
$hesklang['no_session']='Невозможно начать новый сеанс!';
$hesklang['error']='Ошибка';
$hesklang['int_error']='Внутренняя ошибка скрипта';
$hesklang['no_trackID']='Отсутствует идентификатор';
$hesklang['status_not_valid']='Статус неверен';
$hesklang['trackID_not_found']='Идентификатор заявки не найден';
$hesklang['enter_message']='Пожалуйста, введите текст сообщения';
$hesklang['select_priority']='Пожалуйста, выберите приоритет';
$hesklang['ticket_not_found']='Заявка не найдена! Проверьте правильность введённого идентификатора!';
$hesklang['no_selected']='Заявки не выбраны, нечего изменять';
$hesklang['id_not_valid']='Этот идентификатор неверен.';
$hesklang['enter_id']='Пожалуйста, введите идентификатор.';
$hesklang['enter_name']='Пожалуйста, введите имя клиента';
$hesklang['enter_date']='Пожалуйста, введите дату для поиска';
$hesklang['date_not_valid']='Эта дата неверна. Пожалуйста, введите дату в формате <b>YYYY-MM-DD</b>.';
$hesklang['enter_subject']='Пожалуйста, введите тему заявки';
$hesklang['invalid_search']='Операция поиска неверна';
$hesklang['choose_cat_ren']='Пожалуйста, выберите категорию, которую необходимо переименовать';
$hesklang['cat_ren_name']='Пожалуйста, введите название новой категории';
$hesklang['cat_not_found']='Категории не найдены';
$hesklang['enter_cat_name']='Пожалуйста, введите название категории';
$hesklang['no_cat_id']='Отсутствует идентификатор категории';
$hesklang['cant_del_default_cat']='Категорию по умолчанию удалить нельзя, ее можно только переименовать.';
$hesklang['no_valid_id']='Идентификатор пользователя неверен';
$hesklang['user_not_found']='Пользователь не найден';
$hesklang['enter_real_name']='Пожалуйста, введите настоящее имя пользователя';
$hesklang['enter_valid_email']='Пожалуйста, введите корректный e-mail адрес';
$hesklang['enter_username']='Пожалуйста, введите имя пользователя (логин)';
$hesklang['asign_one_cat']='Пожалуйста, назначьте пользователю хотя бы одну категорию!';
$hesklang['signature_long']='Подпись пользователя слишком длинная! Пожалуйста, сократите ее до 1000 символов';
$hesklang['confirm_user_pass']='Пожалуйста, подтвердите пароль';
$hesklang['passwords_not_same']='Введены два разных пароля!';
$hesklang['cant_del_admin']='Администратор по умолчанию не может быть удален!';
$hesklang['cant_del_own']='Невозможно удалить профиль, в котором Вы работаете!';
$hesklang['enter_your_name']='Пожалуйста, введите Ваши полные Фамилию Имя и Отчество';
$hesklang['sel_app_cat']='Пожалуйста, выберите категорию';
$hesklang['sel_app_priority']='Пожалуйста, выберите приоритет';
$hesklang['enter_ticket_subject']='Пожалуйста, введите тему заявки';
$hesklang['user_not_found_nothing_edit']='Пользователь не найден или нет элементов для изменения';

// ADMIN PANEL
$hesklang['administrator']='Администратор';
$hesklang['login']='Вход';
$hesklang['user']='Пользователь';
$hesklang['username']='Имя пользователя';
$hesklang['pass']='Пароль';
$hesklang['confirm_pass']='Подтверждение пароля';
$hesklang['logged_out']='Сеанс завершен';
$hesklang['logout']='Выход';
$hesklang['logout_success']='Сеанс успешно завершен!';
$hesklang['click_login']='Войти';
$hesklang['back']='Назад';
$hesklang['displaying_pages']='Отображено <b>%d</b> заявок. Страницы:';
$hesklang['trackID']='ID заявки';
$hesklang['timestamp']='Отметка времени';
$hesklang['name']='Фамилия, Имя, Отчество';
$hesklang['subject']='Тема';
$hesklang['status']='Статус';
$hesklang['priority']='Приоритет';
$hesklang['open']='Новая';
$hesklang['open_action']='Открыть заявку'; // Open ACTION
$hesklang['close']='Закрыт'; // Closed ticket STATUS
$hesklang['any_status']='Любой статус';
$hesklang['high']='Высокий';
$hesklang['medium']='Нормальный';
$hesklang['low']='Низкий';
$hesklang['del_selected']='Удалить выбранные заявки';
$hesklang['manage_cat']='Управление категориями';
$hesklang['profile']='Ваш профиль';
$hesklang['show_tickets']='Показать заявки';
$hesklang['sort_by']='Сортировать по';
$hesklang['date_posted']='Дата внесения';
$hesklang['category']='Категория';
$hesklang['any_cat']='Любая категория';
$hesklang['order']='Сортировка';
$hesklang['ascending']='по возрастанию';
$hesklang['descending']='по убыванию';
$hesklang['display']='Отображать';
$hesklang['tickets_page']='заявок на странице';
$hesklang['find_ticket']='Найти заявку';
$hesklang['yyyy_mm_dd']='YYYY-MM-DD';
$hesklang['results_page']='результатов на странице';
$hesklang['opened']='Открыта'; // The ticket has been OPENED
$hesklang['closed']='Решена'; // Ticket has been RESOLVED
$hesklang['ticket']='Заявка';
$hesklang['tickets']='Заявки';
$hesklang['ticket_been']='Данная заявка';
$hesklang['view_ticket']='Просмотреть заявку';
$hesklang['open_tickets']='Открытые заявки';
$hesklang['remove_statement']='Удалить сообщение &quot;Powered by...&quot;';
$hesklang['click_info']='Щелкните, чтобы узнать подробности';
$hesklang['reply_added']='Ответ добавлен';
$hesklang['reply_submitted']='Ответ отправлен';
$hesklang['ticket_marked']='Эта заявка отмечена';
$hesklang['ticket_status']='Статус заявки';
$hesklang['replies']='Ответы';
$hesklang['date']='Дата';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Сообщение';
$hesklang['add_reply']='Добавить ответ';
$hesklang['close_this_ticket']='Отметить эту заявку как решенную';
$hesklang['change_priority']='Изменить приоритет:';
$hesklang['attach_sign']='Прикрепить подпись';
$hesklang['profile_settings']='настроить в профиле';
$hesklang['submit_reply']='Отправить ответ';
$hesklang['support_panel']='Панель поддержки';
$hesklang['ticket_trackID']='Идентификатор заявки';
$hesklang['c2c']='Щелкните, чтобы продолжить';
$hesklang['tickets_deleted']='Заявки удалены';
$hesklang['num_tickets_deleted']='<b>%d</b> заявок удалено';
$hesklang['confirm_del_cat']='Вы уверены, что хотите удалить эту категорию?';
$hesklang['cat_intro']='Здесь Вы можете управлять категориями. Они используются 
для классификации заявок по тематике (например, &quot;Продажи&quot;, 
&quot;Проблемы с оборудованием&quot;, &quot;Проблемы PHP/MySQL&quot; и т.д.) 
и для назначения специалистов в зависимости от категории (например, чтобы менеджер по 
продажам мог просматривать только заявки, внесённые в категорию &quot;Продажи&quot;)';
$hesklang['cat_name']='Категория';
$hesklang['remove']='Удалить';
$hesklang['add_cat']='Добавить новую категорию';
$hesklang['max_chars']='макс. 40 символов';
$hesklang['create_cat']='Создать категорию';
$hesklang['ren_cat']='Переименовать категорию';
$hesklang['to']='в';
$hesklang['cat_added']='Категория добавлена';
$hesklang['cat_name_added']='Категория %s успешно добавлена';
$hesklang['cat_renamed']='Категория переименована';
$hesklang['cat_renamed_to']='Выбранная категория успешно переименована в';
$hesklang['cat_removed']='Категория удалена';
$hesklang['cat_removed_db']='Выбранная категория успешно удалена из базы данных';
$hesklang['sure_remove_user']='Вы уверены, что хотите удалить этого пользователя?';
$hesklang['manage_users']='Пользователи';
$hesklang['users_intro']='Здесь Вы определяете, кто из пользователей может авторизоваться 
в панели администратора и обрабатывать заявки. Администраторы могут 
просматривать/редактировать заявки в любой категории и имеют доступ ко всем функциям 
панели администратора (управление пользователями, категориями и т.д.), тогда как
другие пользователи могут только работать с заявками в своей категории.';
$hesklang['yes']='ДА';
$hesklang['no']='НЕТ';
$hesklang['edit']='Редактировать';
$hesklang['add_user']='Добавление нового пользователя';
$hesklang['req_marked_with']='Обязательные поля отмечены';
$hesklang['real_name']='Настоящее имя';
$hesklang['signature_max']='Подпись (до 1000 символов)';
$hesklang['sign_extra']='HTML код запрещён. Ссылки распознаются автоматически.';
$hesklang['create_user']='Создать пользователя';
$hesklang['editing_user']='Редактировать пользователя';
$hesklang['user_added']='Пользователь добавлен';
$hesklang['user_added_success']='Новый пользователь %s с паролем %s успешно добавлен';
$hesklang['profile_updated']='Профиль обновлен';
$hesklang['profile_updated_success']='Этот профиль успешно обновлен';
$hesklang['user_removed']='Пользователь удален';
$hesklang['sel_user_removed']='Выбранный пользователь успешно удален из базы данных';
$hesklang['profile_for']='Профиль ';
$hesklang['new_pass']='Новый пароль';
$hesklang['update_profile']='Обновить профиль';
$hesklang['notify_new_posts']='Уведомлять меня о новых заявках и сообщениях в моих категориях';
$hesklang['view_profile']='Просмотр профиля';
$hesklang['new_ticket_submitted']='Новая заявка отправлена';
$hesklang['user_profile_updated_success']='Профиль этого пользователя успешно обновлен';
$hesklang['printer_friendly']='Версия для печати';
$hesklang['end_ticket']='--- Конец заявки ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Ваша заявка';
$hesklang['view_your_ticket']='Просмотр Вашей заявки';
$hesklang['submit_ticket']='Создать новую заявку';
$hesklang['sub_ticket']='Отправить заявку';
$hesklang['before_submit']='Перед отправкой проверьте следующее';
$hesklang['all_info_in']='Вся необходимая информация внесена';
$hesklang['all_error_free']='Вся информация верна и внесена без ошибок';
$hesklang['we_have']='Зафиксировано';
$hesklang['recorded_ip']='как Ваш IP адрес';
$hesklang['recorded_time']=' время отправки';
$hesklang['save_changes']='Применить';
$hesklang['reply_submitted_success']='Ваш ответ на эту заявку успешно отправлен';
$hesklang['ticket_submitted']='Заявка отправлена';
$hesklang['ticket_submitted_success']='Ваша заявка успешно отправлена! Идентификатор заявки';
$hesklang['your_ticket']='Ваша заявка';

// Added in version 0.94
$hesklang['check_updates']='Следите за тем, чтобы у Вас всегда была установлена последняя версия Hesk!';
$hesklang['check4updates']='Проверить обновления';
$hesklang['wait_reply']='Получен комментарий';
$hesklang['replied']='Комментарий отправлен';
$hesklang['last_replier']='Последний ответивший';
$hesklang['staff']='Сотрудник';
$hesklang['customer']='Клиент';
$hesklang['close_selected']='Установить статус «Решена»';
$hesklang['execute']='Применить';
$hesklang['saved_replies']='Шаблоны ответов';
$hesklang['manage_saved']='Шаблоны ответов';
$hesklang['manage_intro']='Здесь Вы можете добавлять шаблоны ответов и управлять ими. Это стандартные ответы, практически одинаковые для всех клиентов. Используйте шаблоны, чтобы избежать повторного ввода тех же текстов для разных клиентов.';
$hesklang['saved_title']='Название (макс. 50 символов)';
$hesklang['no_saved']='Шаблоны ответов отстутствуют';
$hesklang['delete_saved']='Вы уверены, что хотите удалить этот шаблон ответа?';
$hesklang['new_saved']='Добавить или редактировать шаблон ответа';
$hesklang['canned_add']='Создать новый шаблон ответа';
$hesklang['canned_edit']='Редактировать выбранный шаблон ответа';
$hesklang['save_reply']='Сохранить ответ';
$hesklang['saved']='Ответ сохранен';
$hesklang['your_saved']='Ваш шаблон ответа сохранен и готов к дальнейшему использованию';
$hesklang['ent_saved_title']='Пожалуйста, введите тему ответа';
$hesklang['ent_saved_msg']='Пожалуйста, введите текст ответа';
$hesklang['saved_removed']='Шаблон ответа удален';
$hesklang['saved_rem_full']='Выбранный шаблон ответа удален из базы данных';
$hesklang['clip_alt']='В этом сообщении есть вложения';
$hesklang['attachments']='Вложения';
$hesklang['fill_all']='Обязательное поле не заполнено';
$hesklang['file_too_large']='Ваш файл %s слишком большой';
$hesklang['cannot_move_tmp']='Невозможно перенести файл в каталог вложений';
$hesklang['created_on']='Создано';
$hesklang['tickets_closed']='Заявки закрыты';
$hesklang['num_tickets_closed']='<b>%d</b> заявок закрыто';
$hesklang['select_saved']='Выбрать шаблон ответа';
$hesklang['select_empty']='Пустой шаблон';
$hesklang['insert_special']='Вставить специальный тэг (будет заменён данными клиента)';
$hesklang['move_to_catgory']='Переместить заявку';
$hesklang['move']='Переместить';
$hesklang['moved']='Заявка перемещена';
$hesklang['moved_to']='Эта заявка перемещена в новую категорию';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Все, кроме закрытых';
$hesklang['chg_all']='Изменить все';
$hesklang['settings']='Настройки';
$hesklang['settings_intro']='Используйте этот инструмент для настройки сервиса технической поддержки. Для получения дополнительной информации обо всех настройках и параметрах щелкните знак вопроса или обратитесь к файлу readme.html.';
$hesklang['all_req']='Все поля (кроме заблокированных) являются обязательными!';
$hesklang['wbst_title']='Название веб-сайта';
$hesklang['wbst_url']='URL веб-сайта';
$hesklang['email_wm']='E-mail веб-мастера';
$hesklang['max_listings']='Заявок на странице';
$hesklang['print_size']='Размер шрифта для печати';
$hesklang['debug_mode']='Режим отладки';
$hesklang['on']='ВКЛ.';
$hesklang['off']='ВЫКЛ.';
$hesklang['use_secimg']='Использовать изображение';
$hesklang['secimg_no']='Недоступно';
$hesklang['attach_use']='Использовать вложения';
$hesklang['attach_num']='Количество в сообщении';
$hesklang['attach_type']='Разрешенные типы файлов';
$hesklang['place_after']='После сообщения';
$hesklang['place_before']='Перед сообщением';
$hesklang['custom_f']='доп. поле';
$hesklang['custom_u']='Использовать это поле';
$hesklang['custom_n']='Имя поля';
$hesklang['custom_l']='Максимальная длина (символов)';
$hesklang['db_host']='Хост базы данных';
$hesklang['db_name']='Имя базы данных';
$hesklang['db_user']='Имя пользователя БД';
$hesklang['db_pass']='Пароль к БД';
$hesklang['err_sname']='Пожалуйста, введите название Вашего веб-сайта';
$hesklang['err_surl']='Пожалуйста, введите URL Вашего веб-сайта. Убедитесь в его правильности (должен начинаться с http:// или https://)';
$hesklang['err_wmmail']='Пожалуйста, введите корректный e-mail адрес веб-мастера';
$hesklang['err_nomail']='Пожалуйста, введите корректный e-mail noreply';
$hesklang['err_htitle']='Пожалуйста, введите название вашего сайта службы поддержки';
$hesklang['err_hurl']='Пожалуйста, введите URL Вашего каталога Hesk. Убедитесь в его правильности (должен начинаться с http:// или https://)';
$hesklang['err_lang']='Пожалуйста, выберите язык HESK';
$hesklang['err_nolang']='Файл выбранного языка отсутствует в каталоге language! Перед изменением настроек языка убедитесь, что файл выгружен.';
$hesklang['err_max']='Пожалуйста, укажите максимальное число заявок на странице';
$hesklang['err_psize']='Пожалуйста, укажите размер шрифта для печати';
$hesklang['err_dbhost']='Пожалуйста, введите хост вашей базы данных MySQL';
$hesklang['err_dbname']='Пожалуйста, введите имя вашей базы данных MySQL';
$hesklang['err_dbuser']='Пожалуйста, введите имя пользователя вашей базы данных MySQL';
$hesklang['err_dbpass']='Пожалуйста, введите пароль к вашей базе данных MySQL';
$hesklang['err_dbconn']='Не удалось соединиться с базой данных MySQL, используя предоставленную информацию!';
$hesklang['err_dbsele']='Невозможно выбрать базу данных MySQL, пожалуйста, перепроверьте ИМЯ базы данных';
$hesklang['err_custname']='Введите имя настраиваемого поля';
$hesklang['err_openset']='Невозможно открыть файл <b>hesk_settings.inc.php</b> для записи. Пожалуйста, измените права доступа (CHMOD) на 666 (rw-rw-rw-)';
$hesklang['set_saved']='Настройки сохранены';
$hesklang['set_were_saved']='Ваши настройки успешно сохранены';
$hesklang['sec_img']='Изображение защиты';
$hesklang['sec_miss']='Пожалуйста, введите код защиты';
$hesklang['sec_wrng']='Неверный код защиты';
$hesklang['submit_problems']='Пожалуйста, вернитесь и исправьте следующие ошибки';
$hesklang['cat_order']='Порядок категорий';
$hesklang['reply_order']='Порядок шаблонов ответа';
$hesklang['move_up']='Вверх';
$hesklang['move_dn']='Вниз';
$hesklang['cat_move_id']='Отсутствует идентификатор категории';
$hesklang['reply_move_id']='Отсутствует идентификатор шаблона ответа';
$hesklang['forgot_tid']='Забыли идентификатор?';
$hesklang['tid_send']='Отправить мне мой идентификатор';
$hesklang['tid_not_found']='Заявки с Вашим e-mail адресом не найдены';
$hesklang['tid_sent']='Идентификатор заявки отправлен';
$hesklang['tid_sent2']='На Ваш e-mail отправлено сообщение с детализацией Ваших заявок';
$hesklang['check_spambox']='Обязательно проверьте, не попали ли сообщения в ящик SPAM/Junk!';
$hesklang['reply_not_found']='Шаблон ответа не найден';
$hesklang['exists']='Существует';
$hesklang['no_exists']='Не существует';
$hesklang['writable']='запись разрешена';
$hesklang['not_writable']='запись запрещена';
$hesklang['disabled']='отключено';
$hesklang['e_settings']='Вы не сможете сохранить настройки, пока сценарий не имеет прав на запись в этот файл. Для дальнейших инструкций обратитесь, пожалуйста, к файлу readme!';
$hesklang['e_attdir']='Вы не сможете использовать вложения, пока каталог для них не существует или сценарий не имеет права на запись в него. Для дальнейших инструкций обратитесь, пожалуйста, к файлу readme!';
$hesklang['e_save_settings']='Сохранение Ваших настроек невозможно, так как сценарий не имеет прав на запись в файл <b>hesk_settings.inc.php</b>.';
$hesklang['e_attach']='Отключено, так как сценарий не имеет прав на запись в ваш каталог <b>attachments</b>.';
$hesklang['go']='Выполнить';

// Added in version 2.0
$hesklang['v']='Версия HESK';
$hesklang['check_status']='Проверка статуса';
$hesklang['sub_support']='Отправить заявку';
$hesklang['open_ticket']='Отправить новый запрос в категорию';
$hesklang['view_existing']='Просмотр существующих заявок';
$hesklang['vet']='Посмотреть ранее отправленные заявки';
$hesklang['enter_user']='Пожалуйста, введите Ваше имя пользователя.';
$hesklang['remember_user']='Запомнить мое имя пользователя';
$hesklang['wrong_user']='Неверное имя пользователя';
$hesklang['no_permission']='У Вас нет прав доступа для выполнения этой задачи. Пожалуйста, авторизуйтесь под учетной записью с этими правами.';
$hesklang['tickets_on_pages']='Количество заявок: %d | Количество страниц: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Перейти к странице:';
$hesklang['no_tickets_open']='Отличная работа, все заявки решены!';
$hesklang['no_tickets_crit']='Заявки, соответствующие указанным критериям, не найдены';
$hesklang['confirm_execute']='Вы уверены, что хотите продолжить?';
$hesklang['legend']='Легенда';
$hesklang['main_page']='Главная';
$hesklang['menu_users']='Пользователи';
$hesklang['menu_cat']='Категории';
$hesklang['menu_profile']='Профиль';
$hesklang['menu_kb']='База знаний'; // Admin MENU item
$hesklang['kb_text']='База знаний'; // Item visible to customers
$hesklang['viewkb']='Просмотр всей Базы знаний';
$hesklang['kb']='Управление Базой знаний';
$hesklang['kb_intro']='База знаний - это совокупность ответов на часто задаваемые вопросы (FAQ) и статей, являющихся источниками информации для самостоятельного решения проблем вашими клиентами.
Всеобъемлющая и грамотно построенная База знаний может заметно снизить количество получаемых заявок и значительно сэкономить Ваше время. Статьи можно распределить по разделам
и подразделам.'; // Description in ADMIN panel
$hesklang['kb_is']='База знаний - это подборка распределённых по разделам ответов на часто задаваемые вопросы (FAQ) и статей. Вы можете прочесть статьи в этом разделе или выбрать интересующий Вас подраздел.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Новая статья Базы знаний';
$hesklang['kb_cat']='Раздел';
$hesklang['kb_subject']='Тема';
$hesklang['kb_content']='Содержание';
$hesklang['kb_type']='Тип';
$hesklang['kb_published']='Открытая';
$hesklang['kb_published2']='Доступна всем пользователям Базы знаний.';
$hesklang['kb_private']='Частная';
$hesklang['kb_private2']='Доступна только для сотрудников.';
$hesklang['kb_draft']='Черновик';
$hesklang['kb_draft2']='Сохранена, но не опубликована. Доступна только для сотрудников,<br />имеющих доступ к управлению статьями Базы знаний.';
$hesklang['kb_links']='<i><span class="notice"><b>Внимание!</b></span><br />Введите корректный код без тегов &lt;head&gt; и &lt;body&gt;, только содержимое!</i>';
$hesklang['kb_ehtml']='Это HTML код (я введу корректный код (X)HTML)';
$hesklang['kb_dhtml']='Это простой текст (ссылки распознаются автоматически)';
$hesklang['kb_save']='Сохранить статью';
$hesklang['kb_e_subj']='Введите тему статьи!';
$hesklang['kb_e_cont']='Введите содержимое статьи!';
$hesklang['kb_art_added']='Статья добавлена';
$hesklang['your_kb_added']='Новая статья Базы знаний успешно добавлена';
$hesklang['kb_art_deleted']='Статья удалена';
$hesklang['your_kb_deleted']='Выбранная статья Базы знаний успешно удалена';
$hesklang['kb_art_mod']='Статья изменена';
$hesklang['your_kb_mod']='Изменения, внесённые в выбранную статью, успешно сохранены';
$hesklang['kb_cat_new']='Новый раздел Базы знаний';
$hesklang['kb_cat_parent']='«Родительский» раздел';
$hesklang['kb_cat_sub']='Подразделы';
$hesklang['kb_cat_title']='Название раздела';
$hesklang['kb_cat_published']='Доступен всем пользователям Базы знаний.';
$hesklang['kb_cat_private']='Доступен только для сотрудников.';
$hesklang['kb_cat_add']='Добавить раздел';
$hesklang['kb_cat_e_title']='Введите название раздела!';
$hesklang['kb_cat_added']='Раздел добавлен';
$hesklang['kb_cat_added2']='Новый раздел успешно добавлен в Базу знаний';
$hesklang['kb_cat_man']='Управление разделом Базы знаний';
$hesklang['kb_cat_edit']='Редактировать сведения о разделе';
$hesklang['kb_cat_inv']='Неверный раздел';
$hesklang['kb_cat_art']='Статьи в этом разделе';
$hesklang['kb_p_art']='+ Статья';
$hesklang['kb_p_art2']='добавить новую статью в выбранный раздел.';
$hesklang['kb_add_art']='Добавить статью';
$hesklang['kb_p_cat']='+ Раздел';
$hesklang['kb_p_cat2']='создать новый подраздел внутри выбранного раздела.';
$hesklang['kb_add_cat']='Добавить раздел';
$hesklang['kb_p_man']='Управление';
$hesklang['kb_p_man2']='управление выбранным разделом (редактирование, удаление, управление статьями).';
$hesklang['kb_main']='Удаление или перемещение основного раздела Базы знаний невозможно.';
$hesklang['kb_no_art']='В этом разделе статей нет.';
$hesklang['author']='Автор';
$hesklang['views']='Просмотры';
$hesklang['delete']='Удалить';
$hesklang['rating']='Рейтинг';
$hesklang['votes']='Голоса';
$hesklang['kb_rated']='Рейтинг статьи %s/5.0';
$hesklang['kb_not_rated']='Статья еще не получила оценку';
$hesklang['del_art']='Вы уверены, что хотите удалить выбранную статью?';
$hesklang['kb_art_id']='Идентификатор статьи неверен или отсутствует!';
$hesklang['kb_art_edit']='Редактировать статью';
$hesklang['revhist']='История изменений';
$hesklang['revision1']='<li class="smaller">%s | разместил %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | изменил %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Порядок';
$hesklang['kb_delcat']='Вы уверены, что хотите удалить этот раздел?';
$hesklang['kb_cat_mod']='Раздел изменён';
$hesklang['your_cat_mod']='Изменения, внесённые в выбранный раздел, успешно сохранены';
$hesklang['kb_cat_del']='Раздел Базы знаний удалён';
$hesklang['kb_cat_dlt']='Выбранный раздел Базы знаний удалён.';
$hesklang['allowed_cat']='Разделы';
$hesklang['allow_feat']='Действия';
$hesklang['can_view_tickets']='Просмотр заявок';
$hesklang['can_reply_tickets']='Ответ на заявки';
$hesklang['can_assign_tickets']='Назначение заявок';
$hesklang['can_del_tickets']='Удаление заявок';
$hesklang['can_edit_tickets']='Редактирование ответов';
$hesklang['can_change_cat']='Изменение категории заявок (на любые)';
$hesklang['can_man_kb']='Управление Базой знаний';
$hesklang['can_man_users']='Управление пользователями';
$hesklang['can_man_cat']='Управление категориями';
$hesklang['can_man_canned']='Управление шаблонами ответов';
$hesklang['can_man_settings']='Управление настройками';
$hesklang['can_del_notes']='Удаление примечания к заявке';
$hesklang['dan']='пользователи могут удалять собственные примечания к заявке. Выберите только в том случае, если хотите, чтобы этот пользователь мог также удалять примечания, созданные другими';
$hesklang['in_all_cat']='только в разрешенных категориях';
$hesklang['admin_can']='(доступ ко всем действиям и категориям)';
$hesklang['staff_can']='(можно ограничить доступные действия и категории)';
$hesklang['asign_one_feat']='Пожалуйста, разрешите этому пользователю по крайней мере одно действие!';
$hesklang['na_view_tickets']='У Вас нет доступа к просмотру заявок';
$hesklang['support_notice']='Извините, но этот блок может быть скрыт только после приобретения лицензии HESK!';
$hesklang['rart']='Была ли эта статья полезной?';
$hesklang['r']='Помог ли Вам этот ответ?';
$hesklang['tyr']='Спасибо за Вашу оценку';
$hesklang['cw']='Закрыть окно';
$hesklang['cw2']='Закрыть окно и оправить заявку';
$hesklang['rh']='Оценено как <i>полезное</i>';
$hesklang['rnh']='Оценено как <i>бесполезное</i>';
$hesklang['ar']='Оценка уже выставлена';
$hesklang['rated']='Оценка пользователей %s/5.0 (%s голосов)';
$hesklang['not_rated']='Оценка пользователей пока отсутствует';
$hesklang['rdis']='Рейтинг отключен';
$hesklang['kbdis']='База знаний отключена';
$hesklang['kbpart']='Извините, у Вас нет прав доступа к этой статье';
$hesklang['popart']='Популярные статьи Базы знаний:';
$hesklang['latart']='Новые статьи Базы знаний:';
$hesklang['m']='Прочие темы';
$hesklang['ac']='Статьи в этом разделе:';
$hesklang['noa']='Статьи пока отсутствуют';
$hesklang['noac']='В этом разделе статьи пока отсутствуют';
$hesklang['dta']='Дата добавления';
$hesklang['ad']='Метаданные статьи';
$hesklang['aid']='Идентификатор статьи';
$hesklang['as']='Решение';
$hesklang['search']='Поиск';
$hesklang['sr']='Результаты поиска';
$hesklang['nosr']='Статьи, соответствующие критериям поиска, не найдены. Попробуйте просмотреть Базу знаний или разместите новую заявку.';
$hesklang['rv']='Сброс просмотров';
$hesklang['rr']='Сброс голосов (рейтингов)';
$hesklang['opt']='Опции';
$hesklang['delcat']='Удалить раздел';
$hesklang['move1']='Переместить статьи в «родительский» раздел';
$hesklang['move2']='Удалить статьи в этом разделе';
$hesklang['sc']='Предлагаемые статьи Базы знаний';
$hesklang['not']='Заявок'; // Number of all tickets in category
$hesklang['graph']='Диаграмма';
$hesklang['lu']='Список пользователей';
$hesklang['aclose']='Автоматическое закрытие заявок';
$hesklang['aclose2']='дней с момента последнего ответа';
$hesklang['s_ucrt']='Повторное открытие заявок';
$hesklang['urate']='Рейтинги ответов';
$hesklang['hesk_url']='URL службы технической поддержки';
$hesklang['hesk_title']='Название службы технической поддержки';
$hesklang['cid']='Идентификатор события';
$hesklang['tfor']='Формат даты и времени';
$hesklang['prefix']='Префикс таблицы';
$hesklang['s_ekb']='Включить базу знаний';
$hesklang['s_kbs']='Включить поиск по БЗ';
$hesklang['s_kbr']='Включить рейтинг в БЗ';
$hesklang['s_maxsr']='Макс. число результатов';
$hesklang['s_suggest']='Предлагать статьи из БЗ';
$hesklang['s_spop']='Показывать популярные';
$hesklang['s_slat']='Показывать новые статьи';
$hesklang['s_onin']='на главной странице <a href="../" target="_blank">службы техподдержки</a>';
$hesklang['s_onkb']='на главной странице <a href="../knowledgebase.php" target="_blank">Базы знаний</a>';
$hesklang['s_scol']='Разделов в строке';
$hesklang['s_ptxt']='Длина фрагмента для предпросмотра';
$hesklang['s_psubart']='Статей из подраздела';
$hesklang['enable']='Включить';
$hesklang['s_type']='Тип';
$hesklang['custom_r']='Обязательное';
$hesklang['custom_place']='Размещение';
$hesklang['custom_use']='Дополнительные поля';
$hesklang['stf']='Текстовое поле';
$hesklang['stb']='Большой блок текста';
$hesklang['srb']='Кнопка-переключатель';
$hesklang['ssb']='Выпадающее меню';
$hesklang['db']='База данных';
$hesklang['hd']='Настройки службы технической поддержки';
$hesklang['gs']='Основные настройки';
$hesklang['cwin']='Закрыть окно';
$hesklang['defw']='Значение по умолчанию';
$hesklang['ok']='OK';
$hesklang['ns']='Это доступные опции для данного настраиваемого поля. Чтобы сохранить изменения, щелкните кнопку <b>OK</b> и <b>Сохранить изменения</b> на странице настроек администратора!';
$hesklang['rows']='Строки (высота)';
$hesklang['cols']='Столбцы (ширина)';
$hesklang['opt2']='Варианты для этой кнопки-переключателя. Введите по одному варианту в строку (каждая строка станет новым значением кнопки для выбора). Необходимо ввести хотя бы два варианта!';
$hesklang['opt3']='Варианты для этого выпадающего меню. Введите по одному варианту в строку (каждая строка станет вариантом, из которых пользователь сможет выбирать). Необходимо ввести хотя бы два варианта!';
$hesklang['atl2']='Введите хотя бы два варианта (один вариант в строке)!';
$hesklang['notes']='Примечания';
$hesklang['addnote']='+ Добавить примечание';
$hesklang['noteby']='Внес ';
$hesklang['delnote']='Удалить примечание';
$hesklang['noteerr']='Примечание уже удалено или неверные параметры';
$hesklang['s']='Отправить';
$hesklang['nhid']='Примечания скрыты от клиентов!';
$hesklang['delt']='Удалить это сообщение';
$hesklang['edtt']='Редактирование сообщения';
$hesklang['edt1']='Сообщение изменено';
$hesklang['edt2']='Изменения, внесённые в выбранное сообщение, сохранены';
$hesklang['dele']='Удалить эту заявку';
$hesklang['repd']='Сообщение удалено';
$hesklang['repl']='Выбранное сообщение удалено';
$hesklang['tickets_found']='Результаты поиска';
$hesklang['al']='Администрирование';
$hesklang['ap']='Перейти в Панель администрирования';
$hesklang['dap']='Отобразить ссылку на Панель администрирования на <a href="../" target="_blank">главной странице службы техподдержки</a>';
$hesklang['q_miss']='Пожалуйста, ответьте на вопрос анти-SPAM';
$hesklang['use_q']='Использовать вопрос';
$hesklang['q_q']='-&gt; Вопрос (HTML код <font class="success">разрешен</font>)';
$hesklang['q_a']='-&gt; Ответ';
$hesklang['err_qask']='Введите вопрос анти-SPAM';
$hesklang['err_qans']='Введите ответ на вопрос анти-SPAM';
$hesklang['genq']='Создать случайный вопрос';

// Added in version 2.1
$hesklang['amo']='Добавить еще';
$hesklang['delatt']='Удалить выбранное вложение?';
$hesklang['kb_att_rem']='Выбранное вложение удалено';
$hesklang['inv_att_id']='Неверный идентификатор вложения!';
$hesklang['scb']='Кнопка-флажок';
$hesklang['opt4']='Варианты для этой кнопки-флажка. Введите по одному варианту в строку. Возможен множественный выбор.';
$hesklang['autologin']='Автоматическая авторизация при каждом сеансе';
$hesklang['just_user']='Запомнить только мое имя пользователя';
$hesklang['nothx']='Нет, спасибо';
$hesklang['pinfo']='Данные профиля';
$hesklang['sig']='Подпись';
$hesklang['pref']='Настройки';
$hesklang['aftrep']='После ответа на заявку';
$hesklang['showtic']='Показать заявку, на которую я только что ответил';
$hesklang['gomain']='Вернуться на главную страницу администрирования';
$hesklang['shownext']='Открыть следующую заявку, требующую ответа (если таких нет, перейти на главную страницу)';
$hesklang['rssn']='Переход к следующей заявке, требующей рассмотрения';
$hesklang['mrep']='Заменить сообщение';
$hesklang['madd']='Добавить в нижнюю часть';
$hesklang['priv']='Частные категории и статьи, предназначенные только для сотрудников, отмечены *';
$hesklang['inve']='Неверный e-mail файл';
$hesklang['emfm']='Отсутствует e-mail файл';
$hesklang['hesk_lang']='Язык по умолчанию';
$hesklang['s_mlang']='Несколько языков';
$hesklang['s_mlange']='Если активировано, пользователи смогут обращаться в службу техподдержки на любом из установленных языков. Активируйте только в том случае, если Вы оказываете поддержку на всех установленных языках!';
$hesklang['s_inl']='Проверить каталог языка';
$hesklang['s_inle']='Поиск корректных локализаций в каталоге языков. Только языки, которые успешно пройдут все тесты, корректно установлены.';
$hesklang['ta']='Повторная проверка';
$hesklang['alo']='Разрешить автоматический вход';
$hesklang['chol']='Предпочтительный язык';
$hesklang['mmdl']='Определить этот язык как основной';
$hesklang['warn']='ВНИМАНИЕ!';
$hesklang['dmod']='Включен режим отладки. Не забудьте отключить режим отладки в настройках после установки и запуска HESK.';
$hesklang['kb_spar']='Раздел не может быть «родительским» для самого себя!';
$hesklang['mysql_root']='Пароль MySQL не определен. Вы уверены, что хотите авторизоваться как привилегированный (root) пользователь? Это крайне рисковано!';
$hesklang['chg']='Изменить';
$hesklang['chpri']='Приоритет изменен';
$hesklang['chpri2']='Приоритет заявки изменён на %s';
$hesklang['selcan']='Выберите шаблон ответа, который Вы хотели бы изменить';
$hesklang['q_wrng']='Неверный ответ анти-SPAM';
$hesklang['cndupl']='Категория с таким названием уже существует. Каждая категория должна иметь уникальное название.';
$hesklang['wsel']='Выберите поле, по которому должен осуществляться поиск';

// Added in version 2.2
$hesklang['eto']='Некорректный запрос';
$hesklang['id']='№ п/п';
$hesklang['geco']='Создать прямую ссылку';
$hesklang['genl']='Прямая ссылка на категорию';
$hesklang['genl2']='Используйте эту ссылку для предварительного выбора категории в форме &quot;Отправить заявку&quot;.';
$hesklang['ask']='Поиск справки:';
$hesklang['exa']='Примеры';
$hesklang['small']='Маленький блок';
$hesklang['large']='Большой блок';
$hesklang['cpri']='Приоритет клиента';
$hesklang['owner']='Исполнитель';
$hesklang['unas']='Не назначено';
$hesklang['assi']='Назначить';
$hesklang['asst']='Назначить';
$hesklang['asst2']='Назначить эту заявку';
$hesklang['asss']='Назначить себе';
$hesklang['asss2']='Назначить эту заявку себе';
$hesklang['can_assign_self']='Назначение заявок себе';
$hesklang['can_assign_others']='Назначение заявок другим';
$hesklang['can_run_reports']='Формирование собственных отчётов';
$hesklang['can_view_ass_others']='Просмотр заявок, назначенных другим';
$hesklang['unoa']='Выбранный пользователь не имеет доступа к этой категории';
$hesklang['tasi']='Исполнитель назначен';
$hesklang['tasy']='Эта заявка назначена Вам';
$hesklang['taso']='Эта заявка назначена выбранному пользователю';
$hesklang['tasy2']='Назначена Вам';
$hesklang['taso2']='Назначена другому сотруднику';
$hesklang['nose']='Выберите нового исполнителя';
$hesklang['onasc']='Этот исполнитель не имеет доступа к выбранной категории.';
$hesklang['tunasi']='Заявка без назначения';
$hesklang['tunasi2']='Заявка не имеет исполнителя и может быть назначена снова';
$hesklang['note']='Примечание';
$hesklang['success']='Готово';
$hesklang['nyt']='Эта заявка назначена';
$hesklang['noch']='Ничего не изменено';
$hesklang['orch']='Последовательность отображения изменена';
$hesklang['rfm']='Отсутствуют обязательные данные:';
$hesklang['repl0']='Для выполнения этой задачи недостаточно прав';
$hesklang['repl1']='Это сообщение не существует';
$hesklang['reports']='Отчёты';
$hesklang['reports_intro']='В этом разделе можно создавать некоторые отчёты и видеть статистику по заявкам в выбранном диапазоне дат.';
$hesklang['refi']='Очистить форму';
$hesklang['dich']='Аннулировать изменения';
$hesklang['dire']='Показать отчёт';
$hesklang['m1']='Январь';
$hesklang['m2']='Февраль';
$hesklang['m3']='Март';
$hesklang['m4']='Апрель';
$hesklang['m5']='Май';
$hesklang['m6']='Июнь';
$hesklang['m7']='Июль';
$hesklang['m8']='Август';
$hesklang['m9']='Сентябрь';
$hesklang['m10']='Октябрь';
$hesklang['m11']='Ноябрь';
$hesklang['m12']='Декабрь';
$hesklang['d1']='Понедельник';
$hesklang['d2']='Вторник';
$hesklang['d3']='Среда';
$hesklang['d4']='Четверг';
$hesklang['d5']='Пятница';
$hesklang['d6']='Суббота';
$hesklang['d0']='Воскресенье';
$hesklang['mo']='Пн';
$hesklang['tu']='Вт';
$hesklang['we']='Ср';
$hesklang['th']='Чт';
$hesklang['fr']='Пт';
$hesklang['sa']='Сб';
$hesklang['su']='Вс';
$hesklang['from']='От';
$hesklang['cinv']='Некорректная дата';
$hesklang['cinv2']='Принятый формат - mm/dd/yyyy';
$hesklang['cinm']='Неверно указан месяц';
$hesklang['cinm2']='Допустимый диапазон — ';
$hesklang['cind']='Неверно указан день';
$hesklang['cind2']='Допустимый диапазон для выбранного месяца — ';
$hesklang['month']='Месяц';
$hesklang['ocal']='Открыть календарь';
$hesklang['ca01']='Предыдущий год';
$hesklang['ca02']='Предыдущий месяц';
$hesklang['ca03']='Следующий месяц';
$hesklang['ca04']='Следующий год';
$hesklang['ca05']='Закрыть календарь';
$hesklang['cdr']='Выбрать диапазон дат:';
$hesklang['crt']='Тип отчёта';
$hesklang['r1']='Сегодня';
$hesklang['r2']='Вчера';
$hesklang['r3']='Этот месяц';
$hesklang['r4']='Прошедший месяц';
$hesklang['r5']='Прошедшие 30 дней';
$hesklang['r6']='Эта неделя (Пнд-Вск)';
$hesklang['r7']='Прошедшая неделя (Пнд-Вск)';
$hesklang['r8']='Эта рабочая неделя (Пнд-Птн)';
$hesklang['r9']='Прошедшая рабочая неделя (Пнд-Птн)';
$hesklang['r10']='Этот год';
$hesklang['r11']='Прошедший год';
$hesklang['r12']='Все время';
$hesklang['datetofrom']='«Начальная дата» не может превышать «Конечную дату». Даты изменены.';
$hesklang['t1']='Заявок в день';
$hesklang['t2']='Заявок в месяц';
$hesklang['t3']='Заявок на одного пользователя';
$hesklang['t4']='Заявок на одну категорию';
$hesklang['ticass']='Назначенные заявки';
$hesklang['ticall']='Ответы на заявки';
$hesklang['totals']='Всего';
$hesklang['all']='Все';
$hesklang['atik']='Новые заявки';
$hesklang['kbca']='Раздел Базы знаний с таким названием уже существует.';
$hesklang['menu_msg']='Сообщения';
$hesklang['menu_can']='Шаблоны';
$hesklang['m_from']='От:'; // Mail "from" address
$hesklang['m_to']='Кому:'; // Mail "to" address
$hesklang['m_sub']='Тема:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Личные сообщения';
$hesklang['m_intro']='Используйте личные сообщения для общения между сотрудниками в системе HESK.';
$hesklang['e_udel']='(Пользователь удалён)';
$hesklang['new_mail']='Новое личное сообщение';
$hesklang['m_send']='Отправить сообщение';
$hesklang['m_rec']='Выберите получателя сообщения';
$hesklang['m_inr']='Получатель сообщения указан неверно';
$hesklang['m_esu']='Введите тему сообщения';
$hesklang['m_pms']='Ваше сообщение отправлено';
$hesklang['inbox']='ВХОДЯЩИЕ';
$hesklang['outbox']='ИСХОДЯЩИЕ';
$hesklang['m_new']='НОВОЕ СООБЩЕНИЕ';
$hesklang['pg']='Показать страницу';
$hesklang['npm']='В этой папке личных сообщений нет.';
$hesklang['m_ena']='У Вас нет прав для чтения этого сообщения.';
$hesklang['mau']='Отметить как непрочтённое';
$hesklang['mo1']='Отметить выбранные сообщения как прочтённые';
$hesklang['mo2']='Отметить выбранные сообщения как непрочтённые';
$hesklang['mo3']='Удалить выбранные сообщения';
$hesklang['delm']='Удалить это сообщение';
$hesklang['e_tid']='Ошибка создания уникального идентификатора заявки. Пожалуйста, повторите попытку отправки формы позже.';
$hesklang['smmr']='Выбранные сообщения отмечены как прочтённые';
$hesklang['smmu']='выбранные сообщения отмечены как непрочтённые';
$hesklang['smdl']='Выбранные сообщения удалены';
$hesklang['show']='Показать';
$hesklang['s_my']='Назначенные мне';
$hesklang['s_ot']='Назначенные другим';
$hesklang['s_un']='Без назначения';
$hesklang['s_for']='Искать ';
$hesklang['s_in']='Искать в';
$hesklang['s_incl']='Фильтр';
$hesklang['find_ticket_by']='Поиск заявки';
$hesklang['e_nose']='Статус назначения не выбран, показаны все заявки.';
$hesklang['fsq']='Введите строку поиска';
$hesklang['topen']='Открытые';
$hesklang['nms']='Нет выбранных сообщений. Нечего изменять.';
$hesklang['tlo']='Заблокировать заявку';
$hesklang['tul']='Разблокировать заявку';
$hesklang['loc']='Заблокировано';
$hesklang['isloc']='Если заблокированные заявки отмечены как Решенные, клиенты не могут отвечать на них или повторно их открывать.';
$hesklang['tlock']='Заявка заблокирована';
$hesklang['tunlock']='Заявка разблокирована';
$hesklang['tislock']='Эта заявка заблокирована. Клиент не сможет отправить ответ.';
$hesklang['tislock2']='Эта заявка заблокирована. Отправить ответ невозможно.';
$hesklang['nsfo']='Подходящие статьи не найдены.';
$hesklang['thist1']='<li class="smaller">%s | перемещена в категорию %s пользователем %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | назначена специалисту %s пользователем %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | закрыта пользователем %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | открыта пользователем %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | заблокирована %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | разблокирована %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | создана пользователем %s</li>'; // %s = date, user making change
$hesklang['elocked']='Эта заявка заблокирована или удалена.';
$hesklang['nti2']='Добавить новую заявку';
$hesklang['nti3']='Используйте эту форму для создания нового запроса от имени клиента. Введите информацию о <i>клиенте</i> в форму! Запрос будет создан так, как будто клиент отправил его.';
$hesklang['addop']='Дополнительно';
$hesklang['seno']='Отправить клиенту e-mail уведомление';
$hesklang['otas']='Показать заявку после отправки';
$hesklang['notn']='Уведомления';
$hesklang['nomw']='Отправлять уведомление по e-mail, если:';
$hesklang['nwts']='Отправлена новая заявка, у которой исполнитель:';
$hesklang['ncrt']='Клиент ответил в заявке, у которой исполнитель:';
$hesklang['ntam']='Мне назначена заявка';
$hesklang['npms']='Мне отправлено личное сообщение';
$hesklang['support_remove']='Powered by Help Desk Software HESK, in partnership with SysAid Technologies';
$hesklang['ycvtao']='Вы не можете просматривать заявки, назначенные другим';
$hesklang['password_not_valid']='Пароль должен содержать не менее 5 символов';
$hesklang['lkbs']='Загрузка предложений из Базы знаний...';
$hesklang['auto']='(автоматически)';

// Added in version 2.3
$hesklang['unknown']='Неизвестно';
$hesklang['pcer']='Пожалуйста, исправьте следующие ошибки:';
$hesklang['seqid']='Номер заявки';
$hesklang['close_action']='Заявка решена'; // Close ACTION
$hesklang['archived']='Помеченные';
$hesklang['archived2']='Помеченная заявка';
$hesklang['add_archive']='Пометить эту заявку';
$hesklang['add_archive_quick']='Пометить выбранные заявки';
$hesklang['remove_archive']='Снять метку для этой заявки';
$hesklang['remove_archive_quick']='Снять метки с выбранных заявок';
$hesklang['added_archive']='Заявка помечена';
$hesklang['removed_archive']='Заявка не помечена';
$hesklang['added2archive']='Заявка была помечена';
$hesklang['removedfromarchive']='С заявки была снята метка';
$hesklang['num_tickets_tag']='Заявок помечено: <b>%d</b>';
$hesklang['num_tickets_untag']='Снято меток с заявок: <b>%d</b>';
$hesklang['can_add_archive']='Установка/снятие меток на заявки';
$hesklang['disp_only_archived']='Только помеченные';
$hesklang['search_only_archived']='Только помеченные заявки';
$hesklang['critical']=' * Критический * ';
$hesklang['thist8']='<li class="smaller">%s | приоритет изменён на &quot;%s&quot; пользователем %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | статус изменён на &quot;%s&quot; пользователем %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | автоматически назначена специалисту %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | отправлена посредством e-mail piping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='г.';
$hesklang['abbr']['month']='м.';
$hesklang['abbr']['week']='нед.';
$hesklang['abbr']['day']='д.';
$hesklang['abbr']['hour']='ч.';
$hesklang['abbr']['minute']='мин.';
$hesklang['abbr']['second']='сек.';
// END abberviations
$hesklang['cnsm']='Невозможно отправить сообщение адресату:';
$hesklang['yhbb']='Вы были заблокированы системой на %s минут из-за повторных неудачных попыток авторизации.';
$hesklang['pwdst']='Надёжность пароля';
$hesklang['tid_mail']='Не переживайте! Введите свой <b>E-mail адрес</b> и мы отправим Вам идентификатор заявки в ближайшее время:';
$hesklang['rem_email']='Запомнить мой  адрес e-mail';
$hesklang['eytid']='Введите идентификатор Вашей заявки.';
$hesklang['enmdb']='Введённый Вами e-mail адрес не совпадает с имеющимся в базе для этого идентификатора.';
$hesklang['confemail']='Подтвердить e-mail';
$hesklang['confemail2']='Пожалуйста, подтвердите e-mail';
$hesklang['confemaile']='Два e-mail адреса не совпадают';
$hesklang['taso3']='Назначена:';
$hesklang['sec_enter']='Введите число, которое Вы видите на картинке ниже.';
$hesklang['reload']='Обновить изображение';
$hesklang['verify_q']='Защита от SPAM:'; // For anti-spam question
$hesklang['verify_i']='Защита от SPAM:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Авторизация специалиста поддержки';
$hesklang['vrfy']='Тест пройден';
$hesklang['last_update']='Обновлено';
$hesklang['cot']='Не перемещать критические заявки наверх';
$hesklang['def']='Назначить этот вид для меня по умолчанию';
$hesklang['gbou']='Эти заявки <b>без назначения</b>:';
$hesklang['gbom']='Заявки, назначенные <b>мне</b>:';
$hesklang['gboo']='Заявки, назначенные <b>%s</b>:';
$hesklang['select']=' - Щелкните, чтобы выбрать - ';
$hesklang['chngstatus']='Изменить статус на';
$hesklang['perat']='%s для всех заявок'; // Will change to "23% of all tickets"
$hesklang['viewart']='Посмотреть эту статью';
$hesklang['chdp']='Пожалуйста, измените пароль на странице Вашего <a href="profile.php">Профиля</a>!';
$hesklang['chdp2']='Измените свой пароль, сейчас Вы используете назначенный по умолчанию!';
$hesklang['security']='Безопасность';
$hesklang['kb_i_art']='Новая статья';
$hesklang['kb_i_art2']='Добавить статью';
$hesklang['kb_i_cat']='Новый раздел';
$hesklang['kb_i_cat2']='Добавить раздел';
$hesklang['gopr']='Просмотр Базы знаний';
$hesklang['kbstruct']='Структура Базы знаний';
$hesklang['cancel']='Отменить';
$hesklang['sh']='Скрыть сообщение';
$hesklang['goodkb']='Как написать хорошую статью для Базы знаний?';
$hesklang['catset']='Настройки категории';
$hesklang['inpr']='Выберите новый приоритет';
$hesklang['incat']='Выберите новую категорию';
$hesklang['instat']='Выберите новый статус';
$hesklang['tsst']='Статус заявки был установлен в %s';
$hesklang['aass']='Автоназначение';
$hesklang['aaon']='Автоназначение заявок включено (щёлкните для отключения)';
$hesklang['aaoff']='Автоназначение заявок отключено (щёлкните для включения)';
$hesklang['uaaon']='Автоназначение заявок было включено для выбранного пользователя';
$hesklang['uaaoff']='Автоназначение заявок было отключено для выбранного пользователя';
$hesklang['taasy']='Эта заявка была автоматически назначена Вам';
$hesklang['can_view_unassigned']='Просмотр заявок без назначения';
$hesklang['ycovtay']='Вы можете просматривать только назаченные Вам заявки';
$hesklang['in_progress']='В работе';
$hesklang['on_hold']='Приостановлена';
$hesklang['import_kb']='Импортировать данную заявку в Базу знаний';
$hesklang['import']='Вы импортируете <i>частную заявку</i> в <i>открытую статью</i>.<br /><br />Убедитесь, что удалили информацию частного и служебного характера из названия статьи и её содержания!';
$hesklang['tab_1']='Основное';
$hesklang['tab_2']='Параметры';
$hesklang['tab_3']='База знаний';
$hesklang['tab_4']='Дополнительные поля';
$hesklang['tab_5']='Прочее';
$hesklang['disable']='Отключить';
$hesklang['dat']='Дата и время';
$hesklang['lgs']='Язык интерфейса';
$hesklang['onc']='ВКЛ. - Клиенты';
$hesklang['ons']='ВКЛ. - Все';
$hesklang['viewvtic']='Просмотр заявок';
$hesklang['reqetv']='Требовать e-mail для просмотра заявки';
$hesklang['banlim']='Число попыток авторизации';
$hesklang['banmin']='Время блокирования (мин)';
$hesklang['subnot']='Предупреждение в форме';
$hesklang['subnot2']='Показывать предупреждение клиентам, отправляющим заявку через форму';
$hesklang['eseqid']='Последовательные идентификаторы';
$hesklang['sconfe']='Подтверждение e-mail';
$hesklang['saass']='Автоназначение заявок';
$hesklang['swyse']='WYSIWYG редактор';
$hesklang['hrts']='Оценить HESK';
$hesklang['hrts2']='Показать ссылку [Оценить этот скрипт] в панели администрирования';
$hesklang['emlpipe']='E-mail piping';
$hesklang['emlsend2']='Отправлять с помощью';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='Сервер SMTP';
$hesklang['smtph']='Хост SMTP';
$hesklang['smtpp']='Порт SMTP';
$hesklang['smtpu']='Пользователь SMTP';
$hesklang['smtpw']='Пароль SMTP';
$hesklang['smtpt']='Интервал SMTP';
$hesklang['other']='Прочее';
$hesklang['features']='Действия';
$hesklang['can_view_online']='Просмотр, кто из специалистов он-лайн';
$hesklang['online']='В системе';
$hesklang['offline']='Не в системе';
$hesklang['onlinep']='Пользователи он-лайн'; // For display in footer
$hesklang['sonline']='Пользователи он-лайн'; // For settings page
$hesklang['sonline2']='Индикация пользователей он-лайн. Интервал (минут):'; // For settings page
$hesklang['gb']='Группировать по';
$hesklang['dg']='Не группировать';
$hesklang['err_dpi']='База данных %s не содержит все таблицы HESK с префиксом %s, изменения не сохранены.';
$hesklang['err_dpi2']='Таблицы не найдены:';
$hesklang['sme']='Ошибка SMTP';
$hesklang['scl']='Журнал событий SMTP';
$hesklang['dnl']='Загрузить';
$hesklang['dela']='Удалить это вложение';
$hesklang['pda']='Вы хотите полностью удалить это вложение?';
$hesklang['thist12']='<li class="smaller">%s | вложение %s удалено пользователем %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Больше настроек';
$hesklang['lopt']='Меньше настроек';
$hesklang['meml']='Несколько e-mail адресов';
$hesklang['meml2']='Разрешить клиентам указывать несколько контактных e-mail адресов.';

// Added in version 2.4
$hesklang['catd']='(категория удалена)';
$hesklang['noopen']='Нет открытых заявок, связанных с этим e-mail';
$hesklang['maxopen']='Достигнуто максимальное количество открытых заявок (%d из %d). Пожалуйста, перед созданием новых заявок подождите, пока Ваши текущие заявки будут обработаны.';
$hesklang['ntnote']='Кто-то добавил примечание к заявке, назначенной мне';
$hesklang['cat_public']='Эта категория ОТКРЫТАЯ (щелкните, чтобы сделать частной)';
$hesklang['cat_private']='Эта категория ЧАСТНАЯ (щелкните, чтобы сделать открытой)';
$hesklang['cat_aa']='Автоназначение заявок в этой категории.';
$hesklang['cat_type']='Сделать эту категорию частной (её смогут выбрать только специалисты поддержки)';
$hesklang['caaon']='Для выбранной категории было включено Автоназначение.';
$hesklang['caaoff']='Для выбранной категории было выключено Автоназначение.';
$hesklang['cpub']='Тип категории был изменён на ОТКРЫТАЯ';
$hesklang['cpriv']='Тип категории был изменён на ЧАСТНАЯ';
$hesklang['cpric']='Клиенты не могут выбирать частную категорию!';
$hesklang['user_aa']='Автоназначение заявок этому пользователю.';
$hesklang['attach_size']='Макс. размер файла';
$hesklang['B']='Б';
$hesklang['kB']='кБ';
$hesklang['MB']='МБ';
$hesklang['GB']='ГБ';
$hesklang['bytes']='байт';
$hesklang['kilobytes']='килобайт';
$hesklang['megabytes']='мегабайт';
$hesklang['gigabytes']='гигабайт';
$hesklang['smtpssl']='SSL Протокол';
$hesklang['smtptls']='TLS Протокол';
$hesklang['oo']='Только открытые';
$hesklang['ool']='Отображать только открытые заявки в письме &quot;Забытый идентификатор&quot; ';
$hesklang['mop']='Максимальное число открытых заявок';
$hesklang['rord']='Последовательность ответов';
$hesklang['newbot']='Самые новые ответы внизу';
$hesklang['newtop']='Самые новые ответы вверху';
$hesklang['ford']='Форма ответа';
$hesklang['formbot']='Показать форму внизу';
$hesklang['formtop']='Показать форму вверху';
$hesklang['mysqlv']='Версия MySQL';
$hesklang['phpv']='Версия PHP';
$hesklang['csrt']='Текущее время HESK:';
$hesklang['listp']='Список частных статей';
$hesklang['listd']='Список черновиков статей';
$hesklang['artp']='Частные статьи';
$hesklang['artd']='Черновики статей';
$hesklang['kb_no_part']='Нет частных статей в Базе знаний.';
$hesklang['kb_no_dart']='Нет черновиков статей в Базе знаний.';
$hesklang['attpri']='У Вас нет доступа к данному вложению';
$hesklang['can_merge_tickets']='Объединение заявок';
$hesklang['mer_selected']='Объединить выбранные заявки';
$hesklang['merged']='Выбранные заявки были объединены в одну';
$hesklang['merge_err']='При объединении заявок возникла проблема:';
$hesklang['merr1']='выберите не менее двух заявок.';
$hesklang['merr2']='целевая заявка не найдена.';
$hesklang['merr3']='заявка в категории, к которой у Вас нет доступа';
$hesklang['tme']='Заявка %s была объединена с этой заявкой (%s).';
$hesklang['tme1']='Заявка %s была объединена с заявкой %s';
$hesklang['tme2']='Для доступа к заявке %s введите связанный с ней адрес e-mail.';
$hesklang['eyou']='Используйте страницу Профиля для редактирования персональных настроек.';
$hesklang['npea']='У Вас нет прав доступа для редактирования этого пользователя.';
$hesklang['duplicate_user']='Пользователь с таким именем уже существует, выберите другое имя.';
$hesklang['kw']='Ключевые слова';
$hesklang['kw1']='(не обязательно, разделитель — пробел, запятая или новая строка)';
$hesklang['type_not_allowed']='Файл с расширением <b>%s</b> не разрешён (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Автор заявки еще не прочитал ответ.';
$hesklang['sticky']='Присвоить статье статус &laquo;Важная&raquo;';
$hesklang['stickyon']='Изменить статус статьи на &laquo;Важная&raquo;';
$hesklang['stickyoff']='Изменить статус статьи на &laquo;Обычная&raquo;';
$hesklang['ason']='Статья отмечена как &laquo;Важная&raquo;';
$hesklang['asoff']='Статья отмечена как &laquo;Обычная&raquo;';
$hesklang['ts']='Затраты времени';
$hesklang['start']='Старт / Стоп';
$hesklang['reset']='Сбросить';
$hesklang['save']='Сохранить';
$hesklang['hh']='часов';
$hesklang['mm']='минут';
$hesklang['ss']='секунд';
$hesklang['thist']='История изменений';
$hesklang['thist13']='<li class="smaller">%s | объединена с заявкой %s пользователем %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | время работы над заявкой было обновлено на %s пользователем %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | создана пользователем %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | отправлена посредством POP3 fetching</li>';
$hesklang['twu']='Время работы над заявкой было изменено.';
$hesklang['autoss']='Автоматически начинать отсчёт времени, когда я открываю заявку';
$hesklang['ful']='поддерживаемые типы файлов';
$hesklang['ufl']='Вы можете загрузить файлы с расширениями:';
$hesklang['nat']='Максимальное количество вложений:';
$hesklang['mfs']='Максимальный размер вложения:';
$hesklang['lps']='Выбор языка интерфейса сохранен.';
$hesklang['sav']='Показывать число просмотров';
$hesklang['sad']='Показать дату статьи';
$hesklang['emp']='В PHP не включена поддержка MySQL (требуется расширение mysqli)';
$hesklang['epd']='[HESK] E-MAIL PIPING ВЫКЛЮЧЕН В НАСТРОЙКАХ';
$hesklang['pfd']='[HESK] POP3 FETCHING ВЫКЛЮЧЕН В НАСТРОЙКАХ';
$hesklang['pem']='[Piped e-mail]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Клиент]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-mail';
$hesklang['pop3']='Получение по POP3';
$hesklang['pop3h']='Хост POP3';
$hesklang['pop3p']='Порт POP3';
$hesklang['pop3tls']='TLS Протокол';
$hesklang['pop3u']='Пользователь POP3';
$hesklang['pop3w']='Пароль POP3';
$hesklang['pop3e']='Ошибка POP3';
$hesklang['pop3log']='Журнал соединения POP3';
$hesklang['mysqltest']='Тест соединения с MySQL';
$hesklang['smtptest']='Проверка соединения SMTP';
$hesklang['pop3test']='Проверка соединения POP3';
$hesklang['contest']='Проверка соединения, это может занять некоторое время...';
$hesklang['conok']='Подключение выполнено успешно!';
$hesklang['conokn']='Однако, если Ваш сервер требует указания пользователя и пароля, то e-mail не будет отправлен!';
$hesklang['saving']='Сохранение настроек, подождите, пожалуйста..';
$hesklang['sns']='Настройки были сохранены, но некоторые функции были отключены из-за наличия ошибок во время тестирования.';
$hesklang['looph']='Макс. число писем';
$hesklang['loopt']='Интервал времени';
$hesklang['didum']='Вы имели ввиду %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Да, исправить!';
$hesklang['nole']='Нет, оставить как есть';
$hesklang['sconfe2']='Показать поле &laquo;Подтвердить e-mail&raquo; в форме отправки заявки';
$hesklang['oln']='Старое имя:';
$hesklang['nen']='Новое имя:';
$hesklang['use_form_below']='<i>Используйте эту форму для отправки заявки. Обязательные поля отмечены</i>';
$hesklang['esf']='Не удалось отправить e-mail уведомления.';
$hesklang['qrr']='(цитата из ответа удалена)';
$hesklang['remqr']='Удаление цитаты из ответа';
$hesklang['remqr2']='Удалить цитату ответа из e-mail сотрудника';
$hesklang['suge']='Проверка опечаток в адресе';
$hesklang['epro']='Провайдеры e-mail';
$hesklang['email_noreply']='&quot;От:&quot; e-mail';
$hesklang['email_name']='&quot;От:&quot; Имя';
$hesklang['vscl']='Ограничения в конфигурации сервера';
$hesklang['fnuscphp']='Файл выгружен с ошибкой, попробуйте использовать вложения меньшего размера или вообще отказаться от вложений.';
$hesklang['redv']='сбросить вид по умолчанию';
$hesklang['fatte1']='Настройка вложений: &laquo;Количество в сообщении&raquo; больше, чем допускает ваш сервер!';
$hesklang['fatte2']='Максимальный размер файла вложения больше, чем допускает ваш сервер!';
$hesklang['fatte3']='Ваш сервер не разрешает слишком большие сообщения, попробуйте уменьшить количество вложений или допустимый размер файла!';
$hesklang['embed']='Встроенные файлы';
$hesklang['embed2']='Сохранить встроенные файлы как вложения';
$hesklang['emrem']='(изображение удалено)';
$hesklang['hdemo']='(СКРЫТО В ДЕМО)';
$hesklang['ddemo']='Извините, эта функция отключена в ДЕМО-режиме!';
$hesklang['sdemo']='Сохранение изменений отключено в ДЕМО-режиме!';
$hesklang['hud']='актуальная';
$hesklang['hnw']='Доступны обновления';
$hesklang['getup']='Обновить HESK';
$hesklang['updates']='Обновления';
$hesklang['updates2']='Автоматически проверять обновления HESK';

// Added in version 2.5.0
$hesklang['attdel']='Этот файл был удалён с сервера и более не доступен для загрузки';
$hesklang['dsen']='Не уведомлять автора об этом ответе по e-mail';
$hesklang['attrem']='* Некоторые прикреплённые файлы были удалены *';
$hesklang['attnum']='Достигнуто максимальное число: %s'; // %s will show attachment name
$hesklang['attsiz']='Файл слишком большой: %s'; // %s will show attachment name
$hesklang['atttyp']='Недопустимый тип: %s'; // %s will show attachment name
$hesklang['adf']='Административный каталог';
$hesklang['atf']='Каталог вложений';
$hesklang['err_adf']='Выбранный административный каталог (%s) не существует!'; // %s will show folder name
$hesklang['err_atf']='Выбранный каталог вложений (%s) не существует!'; // %s will show folder name
$hesklang['err_atr']='Нет прав на запись в выбранном каталоге вложений (%s)!'; // %s will show folder name
$hesklang['fatt']='Файлы, прикреплённые к этому сообщению:';
$hesklang['wrepo']='Пожалуйста, напишите ответ после повторного открытия заявки.';
$hesklang['ktool']='&raquo; Инструменты Базы знаний';
$hesklang['uac']='Проверить и обновить счётчик статей раздела';
$hesklang['acv']='Счётчик статей проверен';
$hesklang['xyz']='количество открытых, частных и черновых статей в разделе.';
$hesklang['reports_tab']='Подготовить отчёт'; // Tab title
$hesklang['can_run_reports_full']='Формирование всех отчётов';
$hesklang['can_export']='Экспорт заявок';
$hesklang['roo']='<i>(только заявки, назначенные Вам, включены в отчёт)</i>';
$hesklang['shu']='Короткие ссылки';
$hesklang['export']='Экспорт заявок'; // Tab title
$hesklang['export_btn']='Экспортировать заявки'; // Button title
$hesklang['export_intro']='Этот инструмент позволяет экспортировать заявки в XML-документ, который можно открыть в Excel.';
$hesklang['stte']='Выберите заявки для экспорта';
$hesklang['dtrg']='Диапазон дат';
$hesklang['sequentially']='Последовательно'; // Order tickets: Sequentially
$hesklang['ede']='Невозможно создать каталог для экспорта. Пожалуйста, создайте каталог с именем <b>export</b> внутри каталога вложений вручную и убедитесь, что PHP имеет права на запись в нём (в Linux CHMOD соответствует 777 - rwxrwxrwx).';
$hesklang['eef']='Невозможно создать файл экспорта - нет прав на запись в каталоге для экспорта.';
$hesklang['inite']='Инициализация экспорта';
$hesklang['gXML']='Генерация XML-файла';
$hesklang['nrow']='Количество экспортированных записей: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Сжатие файла в Zip-архив';
$hesklang['eZIP']='Ошибка создания Zip-архива';
$hesklang['fZIP']='Сжатие файла завершено';
$hesklang['pmem']='Пиковое использование памяти: %.2f Мб'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; НАЖМИТЕ ЗДЕСЬ, ЧТОБЫ СКАЧАТЬ ФАЙЛ ЭКСПОРТА &laquo;';
$hesklang['n2ex']='Заявок, удовлетворяющих Вашим критериям, не найдено. Нечего экспортировать!';
$hesklang['sp']='Защита от СПАМа'; // For settings page
$hesklang['sit']='Тип изображения';
$hesklang['sis']='Простое изображение';
$hesklang['rcpb']='Ключ сайта (Публичный ключ)';
$hesklang['rcpv']='Секретный ключ (Частный ключ)';
$hesklang['pop3keep']='Оставлять копию';
$hesklang['beta']='(ТЕСТОВАЯ ВЕРСИЯ)';
$hesklang['maxpost']='Возможно, Вы попытались отправить больше данных, чем может принять сервер.<br /><br />Пожалуйста, попытайтесь отправить форму снова с вложениями меньшего размера либо без них.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Ответ неверный. Пожалуйста, попробуйте снова.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Заявка закрыта/решена';
$hesklang['ms01']='Янв';
$hesklang['ms02']='Фев';
$hesklang['ms03']='Мар';
$hesklang['ms04']='Апр';
$hesklang['ms05']='Май';
$hesklang['ms06']='Июн';
$hesklang['ms07']='Июл';
$hesklang['ms08']='Авг';
$hesklang['ms09']='Сен';
$hesklang['ms10']='Окт';
$hesklang['ms11']='Ноя';
$hesklang['ms12']='Дек';
$hesklang['sdf']='Формат даты отправления';
$hesklang['lcf']='Формат даты обновления';
$hesklang['lcf0']='Краткое описание';
$hesklang['lcf1']='Дата и время';
$hesklang['lcf2']='Стиль HESK';
$hesklang['ticket_tpl']='Шаблоны заявок';
$hesklang['can_man_ticket_tpl']='Управление шаблонами заявок'; // Permission title
$hesklang['ticket_tpl_man']='Управление шаблонами заявок'; // Page and link title
$hesklang['ticket_tpl_intro']='Создавайте и редактируйте шаблоны заявок, чтобы быстро формировать новый заявки из интерфейса администратора.';
$hesklang['no_ticket_tpl']='Нет шаблонов заявок';
$hesklang['ticket_tpl_title']='Заголовок';
$hesklang['delete_tpl']='Вы уверены что хотите удалить этот шаблон?';
$hesklang['new_ticket_tpl']='Добавить или редактировать шаблон заявки';
$hesklang['ticket_tpl_add']='Создать новый шаблон заявки';
$hesklang['ticket_tpl_edit']='Редактировать выбранный шаблон заявки';
$hesklang['save_ticket_tpl']='Сохранить шаблон заявки';
$hesklang['ticket_tpl_saved']='Ваш шаблон заявки был сохранен для будущего использования';
$hesklang['ticket_tpl_removed']='Выбранный шаблон заявки был удален из базы данных';
$hesklang['ticket_tpl_not_found']='Шаблон заявки не найден';
$hesklang['sel_ticket_tpl']='Выберите шаблон заявки, который хотите редактировать';
$hesklang['ent_ticket_tpl_title']='Пожалуйста введите заголовок шаблона';
$hesklang['ent_ticket_tpl_msg']='Пожалуйста введите текст шаблона';
$hesklang['ticket_tpl_id']='Пропущен ID шаблона заявки';
$hesklang['select_ticket_tpl']='Выберите шаблон заявки';
$hesklang['list_tickets_cat']='Показать все заявки в этой категории';
$hesklang['def_msg']='[No message]';
$hesklang['emlreqmsg']='Требовать текст сообщения';
$hesklang['emlreqmsg2']='Игнорировать piped/fetched сообщения без текста';
$hesklang['relart']='Связанные статьи'; // Title of related articles box
$hesklang['s_relart']='Связанные статьи'; // On settings page
$hesklang['tab_7']='Список заявок';
$hesklang['fitl']='Поля в списке заявок';
$hesklang['submitted']='Дата';
$hesklang['clickemail']='Просмотр';
$hesklang['set_pri_to']='Приоритет:'; // Action below the ticket list
$hesklang['pri_set_to']='Приоритет был изменен на:';
$hesklang['cat_pri']='Приоритет категории будет использован, когда клиентам запрещено выбирать приоритет, а заявка вносится через интерфейс клиента.';
$hesklang['cat_pri_info']='Вашим клиентам разрешено выбирать приоритет, поэтому приоритет категории будет игнорироваться.<br /><br />Чтобы вместо этого использовать приоритет категории, отключите следующую фунцию в настройках HESK:';
$hesklang['def_pri']='Приоритет категории:';
$hesklang['ch_cat_pri']='Установить приоритет категории';
$hesklang['cat_pri_ch']='Приоритет категории изменен на:';
$hesklang['err_dbversion']='Версия MySQL слишком старая:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Редактировать текст заметки';
$hesklang['ednote2']='Текст заметки изменен';
$hesklang['perm_deny']='Недостаточно полномочий';
$hesklang['mis_note']='Пропущен ID заметки';
$hesklang['no_note']='Заметка с этим ID не найдена';
$hesklang['sacl']='Сохранить черновик';
$hesklang['reply_saved']='Текст вашего ответа был сохранен на будущее.';
$hesklang['submit_as']='Отправить ответ и сменить статус:';
$hesklang['sasc']='Отправить как ответ Клиента';
$hesklang['creb']='Ответ клиента введен:';
$hesklang['show_select']='Показать &quot;Щелкните для выбора&quot; как вариант по умолчанию';
// Settings
$hesklang['mms']='Режим обслуживания';
$hesklang['mmd']='Включить режим обслуживания';
// Customer notice
$hesklang['mm1']='Ведутся технические работы';
$hesklang['mm2']='В связи в выполнением технических работ, наш help desk временно закрыт.';
$hesklang['mm3']='Мы приносим свои извинения за неудобства и просим Вас попробовать еще раз позже.';
// Staff notice
$hesklang['mma1']='Включен режим обслуживания!';
$hesklang['mma2']='Клиенты не могут использовать help desk.';
$hesklang['tools']='Инструменты';
$hesklang['banemail']='Заблокированные email';
$hesklang['banemail_intro']='Предотвращает отправку заявок с определенных адресов email в ваш Hesk.';
$hesklang['no_banemails']='<i>Нет заблокированных адресов.</i>';
$hesklang['eperm']='Постоянно заблокированные email:';
$hesklang['bananemail']='Блокируемый адрес email';
$hesklang['savebanemail']='Заблокировать этот email';
$hesklang['enterbanemail']='Введите email адрес, который хотите заблокировать.';
$hesklang['validbanemail']='Введите корректный email адрес (<i>john.doe@domain.com</i>) или почтовый домен (<i>@domain.com</i>)';
$hesklang['email_banned']='Еmail адрес <i>%s</i> был заблокирован и HESK больше не принимает заявки с этого адреса.'; // %s will be replaced with email
$hesklang['emailbanexists']='Еmail адрес <i>%s</i> уже заблокирован.'; // %s will be replaced with email
$hesklang['email_unbanned']='Блокировка Email снята';
$hesklang['banby']='Заблокирован';
$hesklang['delban']='Снять блокировку';
$hesklang['delban_confirm']='Снять эту блокировку?';
$hesklang['baned_e']='Вы не можете использовать этот адрес электронной почты для создания заявки. Используйте адрес @surgu.ru';
$hesklang['baned_ip']='Вы были заблокированы на этом help desk';
$hesklang['can_ban_emails']='Может блокировать адреса Email';
$hesklang['can_unban_emails']='Может разблокировать адреса email (а также блокировать их)';
$hesklang['eisban']='Этот email адрес заблокирован.';
$hesklang['click_unban']='Щелкните, чтобы разблокировать.';
$hesklang['banip']='Заблокированные IP';
$hesklang['banip_intro']='Посетители с заблокированных IP адресов не смогут просматривать или создавать заявки и авторизоваться в этом Hesk.';
$hesklang['ipperm']='Постоянная блокировка IP:';
$hesklang['iptemp']='Блокировка по неудачным авторизациям:';
$hesklang['savebanip']='Заблокировать этот IP';
$hesklang['no_banips']='<i>Нет заблокированных IP адресов.</i>';
$hesklang['bananip']='Блокируемый IP адрес';
$hesklang['banex']='Примеры:';
$hesklang['iprange']='Диапазон IP';
$hesklang['ippermban']='Заблокировать этот IP навсегда';
$hesklang['enterbanip']='Введите IP адрес или диапазон который Вы хотите заблокировать.';
$hesklang['validbanip']='Введите корректный IP адрес или диапазон IP адресов';
$hesklang['ip_banned']='IP адрес <i>%s</i> был заблокирован и HESK больше не принимает заявки с этого IP адреса.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Диапазон IP <i>%s</i> был заблокирован и HESK больше не принимает заявки с этого диапазона IP.'; // %s will be replaced with IP
$hesklang['ipbanexists']='IP адрес <i>%s</i> уже заблокирован.'; // %s will be replaced with IP
$hesklang['iprbanexists']='Диапазон IP <i>%s</i> уже заблокирован.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='Блокировка IPадреса снята';
$hesklang['ip_tempun']='Временная блокировка IP адреса снята';
$hesklang['can_ban_ips']='Может блокировать IP адреса';
$hesklang['can_unban_ips']='Может разблокировать IP адреса (а также блокировать их)';
$hesklang['ipisban']='Этот IP адрес заблокирован.';
$hesklang['m2e']='Истекает через (минуты)';
$hesklang['info']='Информация';
$hesklang['sm_title']='Служебные сообщения';
$hesklang['sm_intro']='Служебное сообщение будет показано на главной странице, например, чтобы оповестить об известных проблемах и важных новостях.';
$hesklang['can_service_msg']='Редактировать служебное сообщение';
$hesklang['new_sm']='Новое служебное сообщение';
$hesklang['edit_sm']='Редактировать служебное сообщение';
$hesklang['ex_sm']='Существующее служебное сообщение';
$hesklang['sm_author']='Автор';
$hesklang['sm_type']='Тип';
$hesklang['sm_published']='Опубликовано';
$hesklang['sm_draft']='Черновик';
$hesklang['sm_style']='Стиль';
$hesklang['sm_none']='Нет';
$hesklang['sm_success']='Успех';
$hesklang['sm_info']='Информация';
$hesklang['sm_notice']='Примечание';
$hesklang['sm_error']='Ошибка';
$hesklang['sm_save']='Сохранить служебное сообщение';
$hesklang['sm_preview']='Предпросмотр служебного сообщения';
$hesklang['sm_mtitle']='Заголовок';
$hesklang['sm_msg']='Сообщение';
$hesklang['sm_e_title']='Введите заголовок служебного сообщения';
$hesklang['sm_e_msg']='Введите служебное сообщение';
$hesklang['sm_e_id']='Пропущен ID сообщения';
$hesklang['sm_added']='Было добавлено новое служебное сообщение';
$hesklang['sm_deleted']='Служебное сообщение удалено';
$hesklang['sm_not_found']='Это служебное сообщение не существует';
$hesklang['no_sm']='Нет служебных сообщений';
$hesklang['del_sm']='Удалить это служебное сообщение?';
$hesklang['sm_mdf']='Служебное сообщение сохранено';
$hesklang['sska']='Показать предлагаемые статьи';
$hesklang['taws']='Эти статьи были предложены:';
$hesklang['defaults']='Умолчания';
$hesklang['pncn']='Выбирать вариант «Послать уведомление клиенту по e-mail» в форме новой заявки';
$hesklang['pncr']='Выбирать вариант «Послать уведомление клиенту по e-mail» в форме ответа на заявку';
$hesklang['pssy']='Показывать, какие статьи из базы знаний были предложены клиенту';
$hesklang['ccct']='Клиент может отмечать решенной';
$hesklang['custnot']='Оповестить клиента, когда';
$hesklang['notnew']='Была создана Новая заявка';
$hesklang['notclo']='Заявка отмечена как решенная';
$hesklang['enn']='Кроме Email piping/получения по POP3 , если тема email содержит:';
$hesklang['spamn']='Напоминание о папке SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>Нет письма с подтверждением?</b><br />Мы отправили подтверждающее сообщение на Ваш email адрес. Если Вы его не получили в течение нескольких минут, пожалуйста проверьте папки Спам, Рассылки и Корзина. Отметьте сообщение как <b>не спам</b>, чтобы избежать проблем с получением корреспонденции от нас в дальнейшем.</span>';
$hesklang['ekb_n']='<b>НЕТ</b>, отключить базу знаний';
$hesklang['ekb_y']='<b>ДА</b>, включить базу знаний';
$hesklang['ekb_o']='<b>ДА</b>, использовать HESK только как базу знаний (<i>отключить help desk</i>)';
$hesklang['kb_set']='Настройки базы знаний';
$hesklang['kbo1']='Режим «Только база знаний»';
$hesklang['kbo2']='<br /><br />Посетители не могут создавать новые заявки, и будут сразу направлены в базу знаний.';
$hesklang['fpass']='Забыли свой пароль?';
$hesklang['passr']='Сброс пароля';
$hesklang['passa']='Позволить пользователям сбрасывать забытый пароль с помощью email';
$hesklang['passe']='Введите Ваш email адрес';
$hesklang['passs']='Отправить мне ссылку для сброса пароля';
$hesklang['noace']='Нет учетной записи с таким email адресом';
$hesklang['pemls']='Мы отправили Вам письмо с инструкциями, как сбросить Ваш пароль';
$hesklang['reset_password']='Сброс Вашего пароля к help desk'; // Email subject
$hesklang['ehash']='Неправильная или устаревшая ссылка для сброса пароля';
$hesklang['ehaip']='Неверный IP адрес. Пароль может быть сброшен только с IP адреса, с которого был запрошен сброс.';
$hesklang['resim']='<b>Введите Ваш новый пароль в поле ниже!</b>';
$hesklang['permissions']='Права доступа';
$hesklang['atype']='Тип учетной записи';
$hesklang['astaff']='Персонал';
$hesklang['oon1']='Отправить мне только открытые заявки';
$hesklang['oon2']='Отправить мне все мои заявки';
$hesklang['anyown']='Любой исполнитель';
$hesklang['pfr']='Другая задача POP3 fetching все еще выполняется.';
$hesklang['pjt']='Таймаут задачи';
$hesklang['pjt2']='минут после начала';
$hesklang['nkba']='Для правильной работы поиска в базе знаний требуется достаточное количество уникальных статей.<br /><br />Подумайте о добавлении большего количества статей в базу знаний для улучшения результатов поиска.';
$hesklang['saa']='Закрепленные статьи отображаются наверху списка статей';
$hesklang['yhbr']='Вы заблокировали систему на %s минут из-за слишком частой отправки ответов на заявку.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='ru';

// Added in version 2.7.0
$hesklang['imap']='Получение по IMAP';
$hesklang['imaph']='Хост IMAP';
$hesklang['imapp']='Порт IMAP';
$hesklang['enc']='Шифрование';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Нет';
$hesklang['imapu']='Пользователь IMAP';
$hesklang['imapw']='Пароль IMAP';
$hesklang['imaptest']='Проверить соединение IMAP';
$hesklang['ifd']='[HESK] IMAP ОТКЛЮЧЕН В НАСТРОЙКАХ';
$hesklang['iei']='[HESK] расширение PHP IMAP не установлено.';
$hesklang['ifr']='Выполняется другая задача получения почты по IMAP.';
$hesklang['arp']='Автообновление страницы';
$hesklang['arpp']='Автоматически обновлять страницу со списком заявок каждые:';
$hesklang['seconds']='с';
$hesklang['minutes']='мин';
$hesklang['atbr']='Необходимо назначить исполнителя заявки, прежде чем на нее можно будет ответить.';
$hesklang['attm']='Назначить заявку мне';
$hesklang['owneed']='Требуется исполнитель';
$hesklang['taat']='Эта заявка уже назначена <b>%s</b>.';
$hesklang['scoy']='Вы уверены, что хотите назначить заявку себе?';
$hesklang['scot']='Вы уверены, что хотите назначить ее %s?';
$hesklang['ycto']='ДА, сменить исполнителя';
$hesklang['ncto']='НЕТ, оставить прежнего исполнителя';
$hesklang['fass']='Всегда назначать исполнителя';
$hesklang['req_sub']='Требовать тему';
$hesklang['req_msg']='Требовать сообщение';
$hesklang['req_email']='Требовать email';
$hesklang['default_subject']='Заявка от %s';
$hesklang['off-hide']='Скрыть в форме клиента';
$hesklang['not_valid_email']='Введите корректный адрес email или оставьте поле пустым';
$hesklang['write_down']='<span style="color:red">Рекомендуем записать ID вашей заявки для ссылок на нее в будущем.</span>';
$hesklang['re_confirm1']='Отключение этого отключит также «Требовать email для просмотра заявок» в «Безопасность». Отключить?';
$hesklang['re_confirm2']='Включение этого также включит «Требовать email» в «Избранное». Включить?';
$hesklang['can_email_tpl']='Редактировать шаблоны email';
$hesklang['et_title']='Шаблоны email';
$hesklang['et_intro']='Редактирование сообщений email, отправляемых сотрудникам и клиентам';
$hesklang['file']='Файл';
$hesklang['efile']='Редактирование файла';
$hesklang['rdesc']='(Получатель) Описание';
$hesklang['desc_forgot_ticket_id']='(Клиент) Забыт ID заявки';
$hesklang['desc_new_reply_by_staff']='(Клиент) Новый ответ сотрудника';
$hesklang['desc_new_ticket']='(Клиент) Заявка получена';
$hesklang['desc_ticket_closed']='(Клиент) Заявка закрыта/решена';
$hesklang['desc_category_moved']='(Сотрудник) Заявка перенесена в другую категорию';
$hesklang['desc_new_reply_by_customer']='(Сотрудник) Новый ответ клиента';
$hesklang['desc_new_ticket_staff']='(Сотрудник) Новая заявка';
$hesklang['desc_ticket_assigned_to_you']='(Сотрудник) Заявка назначена вам';
$hesklang['desc_new_pm']='(Сотрудник) Новое личное сообщение';
$hesklang['desc_new_note']='(Сотрудник) Новая заметка в завке, назначенной вам';
$hesklang['desc_reset_password']='(Сотрудник) Сброс пароля';
$hesklang['etfm']='Один или более шаблонов email отсутствует.<br /><br />Убедитесь, что все шаблоны email загружены в папке <i>/language/%s/emails</i>.';
$hesklang['etfw']='Некоторые шаблоны email защищены от записи.<br /><br />
                    Убедитесь, что PHP разрешена запись для всех файлов в папке <i>/language/%s/emails</i>.<br /><br />
                    На Unix-серверах требуется CHMOD шаблоны email в 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Отсутствует ID шаблона';
$hesklang['et_fm']='Этот файл шаблона email отсутствует';
$hesklang['et_fw']='Этот файл шаблона email защищен от записи';
$hesklang['et_save']='Сохарнить шаблон email';
$hesklang['updated_on']='Обновлен';
$hesklang['ticket_url']='URL запроса';
$hesklang['pm_url']='URL личного сообщения';
$hesklang['et_num']='Количество заявок';
$hesklang['et_list']='Список заявок';
$hesklang['et_empty']='Шаблон Email не может быть пустым';
$hesklang['et_saved']='Шаблон Email сохранен';
$hesklang['source']='Исходный файл';
$hesklang['select_category']='Выберите категорию';
$hesklang['select_category_text']='Выберите необходимую Вам категорию заявки';
$hesklang['select_category_staff']='Выберите категорию заявки';
$hesklang['scat']='Макс. число категорий';
$hesklang['scat2']='(в поле выбора будет показано, превышено ли число категорий)';
$hesklang['new_cf']='Новое доп. поле';
$hesklang['cf_intro']='Используйте эту функцию, чтобы добавить в форму Отправки заявки поля для получения дополнительной информации от автора заявки.';
$hesklang['cf_public']='Общая';
$hesklang['cf_private']='Для сотрудников';
$hesklang['cf_cust']='Для клиентов';
$hesklang['cf_all']='Все';
$hesklang['cf_cat']='Выбранные';
$hesklang['cf_ctrl']='Совет: для выбора нескольких категорий удерживайте CTRL';
$hesklang['visibility']='Видимость';
$hesklang['cf_save']='Сохранить доп. поле';
$hesklang['ex_cf']='Активные доп. поля';
$hesklang['no_cf']='Нет активных доп. полей';
$hesklang['del_cf']='Удалить это доп. поле? Также будут удалены все введенные с помощью этого поля данные!';
$hesklang['cf_e_id']='Ошибочный ID';
$hesklang['edit_cf']='Редактирование доп. поля';
$hesklang['cf_deleted']='доп. поле удалено';
$hesklang['cf_not_found']='Это доп. поле не существует';
$hesklang['cf_added']='Добавлено новое доп. поле';
$hesklang['cf_nocat']='Выберите как минимум одну категорию для этого доп. поля';
$hesklang['cf_mdf']='доп. поле сохранено';
$hesklang['atl1']='Введите как минимум один вариант.';
$hesklang['sch']='Скрытое';
$hesklang['meml3']='Разрешить ввести несколько email';
$hesklang['dmin']='Самая ранняя дата';
$hesklang['dmax']='Самая поздняя дата';
$hesklang['d_day']='дн.';
$hesklang['d_week']='нед.';
$hesklang['d_month']='мес.';
$hesklang['d_year']='г.';
$hesklang['d_any']='Любая дата';
$hesklang['d_fixed']='Фиксированная дата';
$hesklang['d_relative']='Относительная дата';
$hesklang['d_mm']='Первая дата не может быть позднее второй';
$hesklang['d_emin']='Самая ранняя дата для <i>%s</i> — %s';
$hesklang['d_emax']='Самая поздняя дата для <i>%s</i> — %s';
$hesklang['d_format']='Формат вывода даты';
$hesklang['d_custom']='Настраиваемый формат';
$hesklang['d_ci']='ТОЛЬКО ДЛЯ ОПЫТНЫХ ПОЛЬЗОВАТЕЛЕЙ: формат даты PHP, см. руководство по PHP.';
$hesklang['cf_noe']='Введите корректный адрес email в <i>%s</i>';
$hesklang['cf_noem']='Введите один или более корректных адресов email в <i>%s</i>';
$hesklang['can_resolve']='Может отмечать заявки решенными';
$hesklang['can_change_own_cat']='Изменение категории заявок (на разрешенные)';
$hesklang['can_submit_any_cat']='Отправление заявок в любую категорию';
$hesklang['noauth_submit']='Вам не разрешено отправлять заявки в эту категорию!';
$hesklang['noauth_move']='Вам не разрешено перемещать заявки в эту категорию!';
$hesklang['noauth_resolve']='Вам не разрешено отмечать заявки решенными!';
$hesklang['force_ssl']='Форсировать соединения по SSL';
$hesklang['d_ssl']='<i>отключено</i> - откройте эту страницу по https://, чтобы изменять эту настройку';
$hesklang['scno']='Этот статус нельзя изменить';
$hesklang['statuses']='Статусы';
$hesklang['statuses_intro']='Используйте, чтобы добавлять настраиваемые статусы в help desk';
$hesklang['color']='Цвет';
$hesklang['csscl']='Класс CSS или цвет';
$hesklang['clr_view']='Предпросмотр цвета';
$hesklang['cbc']='Изменяется клиентом';
$hesklang['ccc']='Может ли клиент изменять этот статус?';
$hesklang['del_status']='Удалить этот статус?';
$hesklang['ex_status']='Существующие статусы';
$hesklang['status_hesk']='Встроенные статусы (не могут быть изменены здесь)';
$hesklang['status_custom']='Настраиваемые статусы';
$hesklang['status_custom_none']='Нет настраиваемых статусов. Можно добавить их, используя форму выше.';
$hesklang['status_save']='Сохранить статус';
$hesklang['list_tkt_status']='Список всех заявок с таким статусом';
$hesklang['new_status']='Новый статус';
$hesklang['edit_status']='Редактирование настраиваемого статуса';
$hesklang['err_status']='Введите имя статуса';
$hesklang['status_added']='Добавлен новый настраиваемый статус';
$hesklang['status_e_id']='Неправильный ID';
$hesklang['status_mdf']='Настраиваемый статус сохранен';
$hesklang['status_deleted']='Настраиваемый статус удален';
$hesklang['status_not_found']='Этот настраиваемый статус не существует';
$hesklang['status_not_empty']='Этот статус нельзя удалить, т.к. имеются заявки с таким статусом';
$hesklang['status_limit']='Имеется 100 настраиваемых статусов, создать больше невозможно.';
$hesklang['public_link']='Общедоступная ссылка';
$hesklang['frames']='Фреймы';
$hesklang['frames2']='Блокировать загрузку HESK во фрейме на сторонних доменах';
$hesklang['numsub']='Отправленные заявки';
$hesklang['hidf']='Скрытые поля не видны клиентам в форме отправки заявки (значение остается видимым на странице заявки, если установлено как «открытое»). Для сотрудников действует как обычное текстовое поле.';
$hesklang['rcheck']='Не выбирать вариант по умолчанию';
$hesklang['refresh_page']='Обновить эту страницу';
$hesklang['del_kba']='Удалить эту статью';
$hesklang['del_kbaa']='Навсегда удалить эту статью';
$hesklang['hni1']='HESK еще не установлен?';
$hesklang['hni2']='Похоже, что help desk еще не был правильно установлен и настроен.';
$hesklang['hni3']='Чтобы установить HESK, следуйте <a href="docs/">Инструкции</a>';
$hesklang['cf']='Папка кэша';
$hesklang['e_cdir']='Hesk не сможет разбирать сообщения email и кэшировать результаты, если папка кэша не существует или не имеет разрешений на запись.';
$hesklang['step1']='Шаг 1';
$hesklang['step2']='Шаг 2';
$hesklang['dffs']='Когда загрузка завершится, удалить файлы с сервера';
$hesklang['fd']='Файл экспорта удален с сервера';

// Added in version 2.8.0
$hesklang['TZ']='Временная зона';
$hesklang['thist17']='<li class="smaller">%s | создана при получении по IMAP</li>';
$hesklang['sir3']='Невидимая reCAPTCHA';
$hesklang['invisible']='невидимый';
$hesklang['imap_not']='PHP не скомпилирован с поддержкой IMAP';
$hesklang['imap_warning']='пользователь %1$s имеет такой же адрес email, что и ваш email для получения по IMAP: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='пользователь %1$s имеет такой же адрес email, что и ваш email для получения по POP3: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Это может вызвать зацикливание email, когда новая заявка создается с адреса email пользователя. Ваш адрес email для получения заявок должен быть уникальным, и никем больше не использоваться.';
$hesklang['can_view_ass_by']='Может видеть заявки, которые назначил другим';
$hesklang['can_privacy']='Может анонимизировать заявку';
$hesklang['confirm_anony']='Анонимизировать эту заявку';
$hesklang['anon_selected']='Анонимизировать выбранные заявки';
$hesklang['privacy_anon_info']='Удалить из заявки все персональные данные и содержимое (имя клиента, email, сообщение, приложения, IP...), но сохранить заявку в базе данных для статистики (право на забвение).';
$hesklang['success_anon']='Заявка успешно анонимизирована';
$hesklang['num_tickets_anon']='Количество анонимизированных заявок: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Клиент]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Тема]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Сообщение]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | анонимизировал %s</li>';
$hesklang['print_selected']='Напечатать выбранные заявки';
$hesklang['with_selected']='С выбранными:';
$hesklang['assign_selected']='Назначить выбранные:';
$hesklang['assign_no']='Исполнитель не выбран, изменения не сделаны';
$hesklang['assign_1']='Выбранные заявки отмечены как «Без назначения».';
$hesklang['assign_2']='Заявка ID %1$s отмечена как «Без назначения»'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s ошибка: уже назначен %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s назначен %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s ошибка: %2$s не имеет доступа к категории заявки'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Результат массового назначения заявок:<br /><br />Назначено: %1$s<br />Ошибок: %2$s<br /><br />Журнал:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP адрес';
$hesklang['moret']='Больше вариантов'; // More options button title
$hesklang['btn_more']='Еще'; // More options button text
$hesklang['btn_print']='Печать';
$hesklang['btn_edit']='Изменить';
$hesklang['btn_lock']='Заблокировать заявку';
$hesklang['btn_unlock']='Разблокировать заявку';
$hesklang['btn_tag']='Пометить заявку';
$hesklang['btn_resend']='Повторно оповестить по email';
$hesklang['btn_untag']='Убрать метку';
$hesklang['btn_import_kb']='Импортировать в Базу знаний';
$hesklang['btn_anony']='Анонимизировать заявку';
$hesklang['btn_delt']='Удалить заявку';
$hesklang['btn_delr']='Удалить ответ';
$hesklang['ernf']='Ответ не найден';
$hesklang['tns']='Оповещение о заявке отправлено повторно';
$hesklang['rns']='Оповещение об ответе отправлено повторно';
$hesklang['fname']='Имя';
$hesklang['export_selected']='Экспортировать выбранные заявки';
$hesklang['btn_export']='Экспортировать в XML для Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Ответов';
$hesklang['team']='Команда';
$hesklang['sm_content']='Содержание';
$hesklang['sm_settings']='Параметры';
$hesklang['wizard_back']='Назад'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Далее'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Перейти к параметрам';
$hesklang['sm_return_to_editing']='Вернуться к редактированию';
$hesklang['email_tpl_title']='Название';
$hesklang['edit_email_template']='Изменить шаблон email';
$hesklang['err_no_settings_section']='Настройки не могут быть открыты';
$hesklang['this_field_is_required']='Это поле обязательно к заполнению';
$hesklang['reset_your_password']='Сбросить пароль';
$hesklang['reset_password_instructions']='Пожалуйста, заполните форму ниже. Мы вышлем вам ссылку, где вы можете сбросить пароль.';
$hesklang['enter_email']='Введите email';
$hesklang['password_reset_check_your_email']='Проверьте свою электронную почту';
$hesklang['password_reset_link_sent']='Мы отправили вам ссылку для сброса пароля.';
$hesklang['back_to_login']='На страницу входа';
$hesklang['pager_first']='Первая';
$hesklang['pager_previous']='Предыдущая';
$hesklang['pager_next']='Далее';
$hesklang['pager_last']='Последняя';
$hesklang['new_team_member']='Новый сотрудник команды';
$hesklang['role']='Группа';
$hesklang['optional']='Необязательно';
$hesklang['edit_profile']='Редактировать';
$hesklang['assigned_to']='Исполнитель';
$hesklang['contact']='Автор';
$hesklang['unban_email']='Разблокировать эту почту';
$hesklang['unban_ip']='Разблокировать IP';
$hesklang['show_previous_replies']='Показать пред. ответы';
$hesklang['type_your_message']='Введите ваше сообщение'; // Used when there are no canned responses
$hesklang['close_button_text']='Закрыть';
$hesklang['create_new_ticket']='Новая заявка';
$hesklang['delete_article']='Удалить статью';
$hesklang['view_existing_tickets']='Найти уже созданную';
$hesklang['how_can_we_help']='Добрый день.<br>Чем мы можем Вам помочь?';
$hesklang['search_for_articles']='Поиск статей';
$hesklang['submit_a_support_request']='Создать новую заявку';
$hesklang['verify_header']='Защита от спама';
$hesklang['ticket_details']='Информация';
$hesklang['yes_title_case']='Да';
$hesklang['no_title_case']='Нет';
$hesklang['no_results_found']='Нет результатов';
$hesklang['site_theme']='Тема сайта';
$hesklang['test_theme_folder']='Проверка каталога темы';
$hesklang['test_theme_folder_description']='Testing the theme folder for valid themes. Only themes that pass all tests are properly installed.';
$hesklang['err_site_theme']='Выберите HESK тему';
$hesklang['confirm']='Подтвердить';
$hesklang['confirm_deletion']='Подтверждение получено';
$hesklang['confirm_delete_status']='Вы уверены, что хотите удалить этот пользовательский статус?';
$hesklang['help_desk']='АСПЗ'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.ru.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Шаблон времени';
$hesklang['tdisd']='Дата и время';
$hesklang['tdisa']='Времени прошло (напр.: 5 часов назад)';
$hesklang['nav_templates']='Шаблоны'; // Admin panel navigation item
$hesklang['hide_replies']='Скрывать старые ответы';
$hesklang['hide_replies_no']='Показывать все ответы';
$hesklang['hide_replies_yes']='Отображать только:';
$hesklang['hide_replies_def']='Показать последний ответ сотрудника и любые последующие от клиента';
$hesklang['reply_by']='Ответ от:'; // Reply by NAME
$hesklang['btt']='Вернуться к началу';
$hesklang['lwidth']='Ширина текстового поля';
$hesklang['lwidtall']='Не ограничивать';
$hesklang['lwidtpx']='Ограничить до (пикселей):';
// 3-letter days of the week
$hesklang['mon']=' Пн';
$hesklang['tue']=' Вт';
$hesklang['wed']=' Ср';
$hesklang['thu']=' Чт';
$hesklang['fri']=' Пт';
$hesklang['sat']=' Сб';
$hesklang['sun']=' Вс';
$hesklang['clear']='Сбросить'; // delete field value
$hesklang['first_day_of_week']='0'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Модули';
$hesklang['modules_demo']='Данный модуль в настоящее время доступен только в %s.'; // %s = Hesk cloud link
$hesklang['see_demo']='Попробуйте демо-версию здесь: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Статистика';
$hesklang['statistics']['intro']='Отчёт предоставит информацию об использовании системы и покажет производительность сотрудников.';
$hesklang['statistics']['ntsp']='За выбранный период нет заявок.';
$hesklang['statistics']['pie_title_ro']='Заявки в работе и выполненные';
$hesklang['statistics']['open']='Открыто';
$hesklang['statistics']['resolved']='Решено';
$hesklang['statistics']['pie_title_as']='Заявки в работе: Назначены и Не назначены';
$hesklang['statistics']['ass']='Назначено';
$hesklang['statistics']['unas']='Не назначено';
$hesklang['statistics']['pie_title_au']='Заявки в работе: С ответом и Без ответа';
$hesklang['statistics']['answered']='Отвечено';
$hesklang['statistics']['unanswered']='Не отвечено';
$hesklang['statistics']['pie_title_so']='Текущие статусы заявок';
$hesklang['statistics']['retic']='Заявок:';
$hesklang['statistics']['chart_title_md']='Количество заявок в месяц';
$hesklang['statistics']['chart_title_wd']='Количество заявок в день';
$hesklang['statistics']['chart_title_hd']='Количество заявок в час';
$hesklang['statistics']['chart_title_tfr']='Время ответа сотрудников';
$hesklang['statistics']['chart_title_tfrc']='Количество ответов за промежуток времени';
$hesklang['statistics']['chart_title_ttr']='Время от назначения и до решения заявки';
$hesklang['statistics']['chart_title_ttrc']='Количество решенных заявок за промежуток времени';
$hesklang['statistics']['chart_title_sr']='Ответы сотрудников';
$hesklang['statistics']['chart_title_srt']='Ответы сотрудников на заявки';
$hesklang['statistics']['chart_title_srtr']='Ответов сотрудников на заявку (учитываются только решенные заявки)';
$hesklang['statistics']['chart_title_srt1']='Ответов сотрудников на заявку (заявки как минимум с 1 ответом)';
$hesklang['statistics']['ct_30']='30 минут';
$hesklang['statistics']['ct_1h']='1 час';
$hesklang['statistics']['ct_2h']='2 часа';
$hesklang['statistics']['ct_4h']='4 часа';
$hesklang['statistics']['ct_1d']='1 день';
$hesklang['statistics']['ct_2d']='2 дня';
$hesklang['statistics']['ct_3d']='3 дня';
$hesklang['statistics']['ct_1w']='1 неделя';
$hesklang['statistics']['ct_wp']='> 1 недели';
$hesklang['statistics']['ct_1m']='1 месяц';
$hesklang['statistics']['ct_mp']='> 1 месяца';
$hesklang['statistics']['axis1']='% из заявок отвечено';
$hesklang['statistics']['axis2']='% из заявок решено';
$hesklang['statistics']['axis3']='% из заявок';
$hesklang['statistics']['axis4']='Время ответа';
$hesklang['statistics']['axis5']='Время решения';
$hesklang['statistics']['axis6']='Количество ответов';
$hesklang['statistics']['axis7']='Количество заявок';
$hesklang['statistics']['axis8']='День';
$hesklang['statistics']['axis9']='Час';
$hesklang['statistics']['axis10']='День месяца';
$hesklang['statistics']['tr_0']='Без ответа';
$hesklang['statistics']['tr_1']='1 ответ';
$hesklang['statistics']['tr_2']='2 ответа';
$hesklang['statistics']['tr_5']='3-5 ответов';
$hesklang['statistics']['tr_10']='6-10 ответов';
$hesklang['statistics']['tr_99']='> 10 ответов';
$hesklang['statistics']['average']='Среднее';
$hesklang['statistics']['atfr']='Среднее время до первого ответа сотрудника:';
$hesklang['statistics']['attr']='Среднее время до решения заявки:';
$hesklang['statistics']['about']='Около %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='Нет данных';
$hesklang['statistics']['trept']='Количество заявок, на которые ответили сотрудники:';
$hesklang['statistics']['trnr']='Количество заявок, решенных без ответов сотрудников: Total tickets resolved without a staff reply:';
$hesklang['statistics']['tsr']='Всего ответов сотрудников:';
$hesklang['statistics']['tsrt']='Среднее количество ответов сотрудников на заявку:';
$hesklang['statistics']['tsro']='Среднее количество ответов сотрудников на заявку (на заявку отвечало более 1 сотрудника):';
$hesklang['statistics']['tsrc']='Среднее количество ответов сотрудников, необходимых для решения заявки:';
$hesklang['statistics']['tsrr']='Среднее количество ответов сотрудников, необходимых для решения заявки (на заявку отвечало более 1 сотрудника):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='и многое другое...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Заявка просрочена';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ЭСКАЛАЦИЯ: %%SUBJECT%%';
$hesklang['escalate']['tab']='Эскалация'; // Menu link
$hesklang['escalate']['page_title']='Эскалация заявок'; // Page H2 title
$hesklang['escalate']['intro']='Этот модуль поможет вам увеличить количество заявок, которые не были обработаны вовремя.';
$hesklang['escalate']['feat1']='Заявки не назначены, не отвечены или не решены в установленные сроки';
$hesklang['escalate']['feat2']='заявка скоро просрочится';
$hesklang['escalate']['feat3']='автоматическое изменение приоритета заявки, повторное назначение заявки, отправка уведомления по электронной почте';
$hesklang['escalate']['feat4']='применяйте правила, основанные на категории заявки, владельце, статусе';
$hesklang['escalate']['prefix']='Эскалация:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Активные правила';
$hesklang['escalate']['new']='Новое правило эскалации';
$hesklang['escalate']['no_rules']='У вас нет никаких правил эскалации. Создайте его, нажав кнопку &quot;Новое правило эскалации&quot выше.';
$hesklang['escalate']['title']='Название правила';
$hesklang['escalate']['titlet']='Описательный заголовок, например: Переоформить заявки, на которые не было ответа в течение дня';
$hesklang['escalate']['default_title']='Правило от %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Триггер правила';
$hesklang['escalate']['trigt']='Установите условие, которое вызовет (выполнит) это правило.';
$hesklang['escalate']['hits']='Раз'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Состояние'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Действие'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Применить к'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Удалить это правило?';
$hesklang['escalate']['edit']='Редактирование правила эскалации %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Заявка поддержки-это:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='персонал не отвечает';
$hesklang['escalate']['nrepc']='не ответил клиент';
$hesklang['escalate']['nass']='не назначено';
$hesklang['escalate']['nres']='не решено';
$hesklang['escalate']['ndue']='приближается срок сдачи';
$hesklang['escalate']['odue']='просроченный';
$hesklang['escalate']['within']='Внутри:';
$hesklang['escalate']['minutes']='минут';
$hesklang['escalate']['hours']='часов';
$hesklang['escalate']['days']='дней';
$hesklang['escalate']['weeks']='недель';
$hesklang['escalate']['months']='месяцев';
$hesklang['escalate']['years']='годов';
$hesklang['escalate']['ofs']='быть представленным';
$hesklang['escalate']['resend']='Повторная отправка уведомлений по электронной почте:';
$hesklang['escalate']['force']='Всегда отправляйте, не обращайте внимания на настройки персонала';
$hesklang['escalate']['noforce']='Уважайте настройки уведомлений персонала';
$hesklang['escalate']['setpri']='Установить приоритет на:';
$hesklang['escalate']['setsta']='Установить статус на:';
$hesklang['escalate']['assto']='Назначить заявку:';
$hesklang['escalate']['asm']='Еще один сотрудник';
$hesklang['escalate']['notify']='Сообщите сотрудникам...';
$hesklang['escalate']['ato']='Применить к:';
$hesklang['escalate']['tic']='Заявки в категории:';
$hesklang['escalate']['tat']='Заявки, назначенные:';
$hesklang['escalate']['tws']='Заявки со статусом со статусом:';
$hesklang['escalate']['tall']='Примените это правило к существующим и будущим заявкам';
$hesklang['escalate']['tfn']='Применяйте это правило только к будущим заявкам, игнорировать прошлые заявки';
$hesklang['escalate']['tfi']='Применяйте это правило только к заявкам с идентификатором выше:';
$hesklang['escalate']['save']='Сохранить правило';
$hesklang['escalate']['e_tt']='Время должно быть от 1 до 10000';
$hesklang['escalate']['e_a']='Выберите хотя бы одно действие для выполнения с соответствующими заявками';
$hesklang['escalate']['nocat']='Выберите хотя бы одну категорию';
$hesklang['escalate']['nouser']='Выберите хотя бы одного пользователя';
$hesklang['escalate']['nostatus']='Выберите хотя бы один статус';
$hesklang['escalate']['nocata']='%1$s не имеет доступа к этим категориям:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Было создано новое правило';
$hesklang['escalate']['mdf']='Настройки правил были сохранены';
$hesklang['escalate']['e_id']='Правило с этим идентификатором не найдено';
$hesklang['escalate']['deleted']='Выбранное правило было удалено';
$hesklang['escalate']['edit_notice']='изменение триггера правила не окажет никакого влияния на любую заявку, уже эскалированный этим правилом (если только вы не сбросите правило).';
$hesklang['escalate']['reset']='Сбросить это правило';
$hesklang['escalate']['reset2']='Вы уверены, что хотите сбросить это правило?<br><br>Попадание в правило будет равно 0, и любая заявка, соответствующая этому правилу, будет снова увеличена.';
$hesklang['escalate']['reset3']='Выбранное правило было сброшено';
$hesklang['escalate']['log_title']='Правила #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | обострилась на %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - установил приоритет на %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - назначен на %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - отправлено уведомление сотрудникам</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - отправить уведомление персоналу (принудительно)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - ошибка: %2$s не имеет доступа к категории заявки</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - ошибка: %2$s не имеет разрешения на просмотр заявок</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - ошибка: нет другого пользователя, который может просмотреть эту заявку</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - обратите внимание: приоритет уже установлен на %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - обратите внимание: уже назначено %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - уведомление: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - установить статус %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - notice: status already set to %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Активный'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Активируйте это правило (начните его использовать)';
$hesklang['escalate']['activated']='Выбранное правило активировано'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Деактивируйте это правило (прекратите его использовать)';
$hesklang['escalate']['deactivated']='Выбранное правило деактивировано'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Нет активных правил эскалации';
$hesklang['escalate']['matched']='Количество найденных совпадающих заявок: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Инструменты';
$hesklang['escalate']['test']='Смоделируйте это правило';
$hesklang['escalate']['testa']='Имитация всех правил';
$hesklang['escalate']['testaa']='Имитация всех активных правил';
$hesklang['escalate']['testr']='Результаты имитации';
$hesklang['escalate']['rsim']='Повторить имитацию';
$hesklang['escalate']['tbef']='Прежде чем правило заработает, его нужно активировать, установив флажок в столбце &quot;АКТИВНО&quot;.<br><br>
                               Мы настоятельно рекомендуем вам <strong>имитировать</strong> для каждого правила щелкните значок %1$s (Имитация этого правила) в таблице правил.
                               чтобы увидеть, как это повлияет на ваши существующие заявки, прежде чем активировать его.<br><br>
                               <strong>Активные правила обрабатываются каждые %2$s минуты. Заявка может быть увеличена только один раз по каждому правилу</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='РЕЖИМ ИМИТАЦИИ, никаких изменений в базе данных';
$hesklang['escalate']['sic']='ИМИТАЦИЯ ЗАВЕРШЕНА';
$hesklang['escalate']['r']='[ПРАВИЛО]';
$hesklang['escalate']['i']='[ИНФОРМАЦИЯ]';
$hesklang['multopt']='Совет: удерживая нажатой клавишу CTRL, выберите несколько вариантов';
$hesklang['desc_ticket_escalated']='(Персонал) Заявка был увеличена'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Форматирование заявки (Персонал)';
$hesklang['ticket_formatting_plaintext']='Обычный Текст';
$hesklang['ticket_formatting_rich_text']='Форматированный текст (HTML)';
$hesklang['due_date']='Срок истечения';
$hesklang['invalid_due_date']='Была введена недопустимая дата.';
$hesklang['thist19']='<li class="smaller">%s | срок выполнения обновлен до %s на %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | срок выполнения удален на %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Дата срока истечения заявки была обновлена.';
$hesklang['menu_kb_manage']='Управление'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Просмотр'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Выбрать всё';
$hesklang['a_deselect']='Убрать выделение';
$hesklang['a_toggle']='Переключить все';
$hesklang['ql_all']='Все заявки';
$hesklang['ql_alo']='Открытые заявки';
$hesklang['ql_fit']='Отфильтрованные заявки';
$hesklang['ql_a2m']='Назначенные на меня';
$hesklang['ql_a2o']='Назначенные на других';
$hesklang['ql_una']='Неназначенные';
$hesklang['ql_due']='Истекает срок';
$hesklang['ql_ovr']='Просроченные';
$hesklang['set_ds']='Показать как "скоро должно быть";'; // Settings page (title of setting)
$hesklang['set_ds2']='за несколько дней до срока истечения';
$hesklang['not_aos']='Некоторые открытые заявки, к которым у вас есть доступ, не отображаются из-за ваших фильтров.';
$hesklang['ntoverdue']='Заявка просрочена у владельца:';
$hesklang['ovdcron']='чтобы просроченные уведомления работали, администратор должен включить задание cron.';
$hesklang['instructions']='Инструкции';
$hesklang['desc_overdue_ticket']='(Персонал) Заявка просрочена';
$hesklang['overdue_starting']='Запуск процесса уведомления о просроченных заявках';
$hesklang['overdue_sim']='Отправка электронных писем и обновление заявок отключены в режиме ИМИТАЦИИ.';
$hesklang['overdue_ticket_count']='Найдено %s заявок, которые просрочены.'; // %s = Number of tickets
$hesklang['overdue_finished']='Закончились Просроченные заявки. %s отправленные электронные письма. Письма %s не удалось отправить.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Свой CSS';
$hesklang['admin_css2']='Сделать пользовательский стиль панели администрирования';
$hesklang['noval_cert']='Не проверяйте сертификаты сервера';
$hesklang['chg_cat']='Нажмите, чтобы изменить категорию заявки';
$hesklang['tlan']='Не проверяйте сертификаты сервера';
$hesklang['uue']='Два или более сотрудников имеют один и тот же адрес электронной почты. Мы рекомендуем установить уникальный адрес электронной почты для каждого пользователя.';
$hesklang['flood']='Лимит спама';
$hesklang['e_flood']='Упс, вы уже отправили ответ совсем недавно. Мы остановили этот запрос, чтобы предотвратить ответное наводнение.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='URL ключ-доступа'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Генерация случайного ключа доступа к URL-адресу';
$hesklang['ukeym']='Ошибка: чтобы запустить этот файл через HTTP, вы должны включить в запрос свой URL-ключ доступа. Пример:';
$hesklang['ukeyw']='Ошибка: неверный ключ доступа к URL-адресу';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Заявка получена: %%SUBJECT%%';
$hesklang['mfa_verification']='Ваш проверочный код %%VERIFICATION_CODE%%';
$hesklang['follow_up_email']='Будьте честны. Как у нас получилось?';
$hesklang['mfa']='Многофакторная аутенификация (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA включена?';
$hesklang['mfa_required']='Требуется многофакторная аутенификация';
$hesklang['mfa_manage_profile']='Управление MFA';
$hesklang['mfa_disabled']='Многофакторная аутенификация отключена';
$hesklang['mfa_enabled']='Многофакторная аутенификация включена (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Отсутствует';
$hesklang['mfa_method_none_subtext']='Многофакторная аутенификация отключена на Вашем аккаунте.';
$hesklang['mfa_method_email']='Электронная почта';
$hesklang['mfa_method_email_subtext']='Служба поддержки отправит электронное письмо со случайным кодом входа на электрооную почту <strong>%s</strong> при входе в систему.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Приложение Аутенификатор';
$hesklang['mfa_method_auth_app_short']='Приложение';
$hesklang['mfa_method_auth_app_subtext']='Используйте приложение для смартфона, например Authy или Google Authenticator, чтобы сгенерировать случайный код входа при входе в систему.';
$hesklang['mfa_step_method']='Способ';
$hesklang['mfa_step_verification']='Проверка';
$hesklang['mfa_step_complete']='Выполнено';
$hesklang['mfa_introduction']='Многофакторная аутентификация повышает безопасность учетной записи, требуя от вас подтверждения вашего входа с помощью дополнительного метода проверки, такого как электронная почта или приложение-аутентификатор (например, Authy или Google Authenticator).';
$hesklang['mfa_reset_warning']='У вас уже включена многофакторная аутентификация. Повторное выполнение этого действия приведет к сбросу вашего устройства многофакторной аутентификации (если оно включено).';
$hesklang['mfa_select_method_colon']='Выберите способ аутенификации:';
$hesklang['mfa_verification_header']='Проверка - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='На адрес <strong>%s</strong> было отправлено электронное письмо, содержащее шестизначный проверочный код. Введите код, который вы получили по электронной почте ниже, чтобы продолжить.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Шаг 1: Отсканируйте изображение ниже с помощью приложения многофакторной аутентификации на вашем мобильном устройстве.';
$hesklang['mfa_verification_auth_app_cant_scan']='Не удается отсканировать изображение? Вручную введите этот код на своем устройстве: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Шаг 2: Введите 6-значный код, отображаемый в вашем приложении, для проверки вашего устройства.';
$hesklang['mfa_verify']='Проверка';
$hesklang['mfa_invalid_method']='Получен неверный метод многофакторной аутентификации.';
$hesklang['mfa_invalid_verification_code']='Введенный код неверен или истек.';
$hesklang['mfa_configured']='На Вашем аккаунте включена многофакторная аутенификация!';
$hesklang['mfa_removed']='Многофакторная аутенификация на Вашем аккаунте отключена!';
$hesklang['mfa_verification_needed']='Для этой учетной записи включена многофакторная аутентификация.';
$hesklang['mfa_verification_needed_email']='Пожалуйста, введите проверочный код, который был отправлен на ваш адрес электронной почты.';
$hesklang['mfa_verification_needed_auth_app']='Пожалуйста, введите код, который отображается в вашем приложении для аутентификации.';
$hesklang['mfa_verification_code']='Проверочный код';
$hesklang['mfa_server_time_issue']='Время на вашем сервере неверное: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Сброс многофакторной аутентификации';
$hesklang['mfa_reset_confirm']='Вы уверены, что хотите сбросить MFA для этого пользователя?';
$hesklang['mfa_reset_yes']='Сброс';
$hesklang['mfa_reset']='Многофакторная аутентификация была сброшена для пользователя';
$hesklang['desc_mfa_verification']='(Персонал) Код многофакторной аутентификации';
$hesklang['mfa_code']='Код:';
$hesklang['mfa_backup_codes_header']='СОХРАНИТЕ СВОИ РЕЗЕРВНЫЕ КОДЫ!';
$hesklang['mfa_backup_codes_description']='Храните эти резервные коды в надежном, но доступном месте. В случае, если вы потеряете доступ к своему устройству MFA или электронной почте, вы можете ввести один из следующих резервных кодов для входа в систему.<br><br><strong>Обязательно используйте эти резервные коды как пароли. Вы больше не сможете видеть эти коды!!</strong>';
$hesklang['mfa_verify_another_way']='Подтвердите свою учетную запись другим способом'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Проверьте свою электронную почту %s';
$hesklang['mfa_verify_another_way_code']='Введите один из ваших 8-символьных резервных кодов';
$hesklang['mfa_verify_another_way_admin']='Обратитесь за помощью к администратору службы поддержки';
$hesklang['mfa_verify_another_way_reset']='Сбросьте многофакторную аутентификацию, загрузив файл на сервер';
$hesklang['mfa_send_another_email']='Отправить другое электронное письмо';
$hesklang['mfa_sent']='На ваш адрес электронной почты было отправлено письмо с новым кодом подтверждения';
$hesklang['mfa_backup_code']='Резервный код';
$hesklang['mfa_backup_codes']='Резервные коды';
$hesklang['mfa_backup_codes_info']='Одноразовые коды для прохождения многофакторной проверки при невозможности доступа к вашей электронной почте или приложению аутентификации. Как только вы используете резервный код для входа в систему, этот код становится неактивным.';
$hesklang['mfa_backup_codes_num']='Вы можете получить новый набор из 10 резервных кодов в любое удобное для вас время. Когда вы создаете новый набор кодов, старый набор автоматически становится неактивным.';
$hesklang['mfa_backup_codes_num2']='Количество ваших активных кодов: %s';
$hesklang['mfa_invalid_backup_code']='Введенный код резервной копии неверен или уже использовался.';
$hesklang['mfa_del_codes']='Удалить мои резервные коды';
$hesklang['mfa_del_codes2']='Все ваши резервные коды были удалены.';
$hesklang['mfa_new_codes']='Создать новые резервные коды';
$hesklang['mfa_new_codes2']='Новые резервные коды созданы';
$hesklang['old_php_version']='Ошибка: Неподдерживаемая версия PHP';
$hesklang['category_default_due_date']='Срок выполнения по умолчанию';
$hesklang['category_change_default_due_date']='Установить срок выполнения по умолчанию';
$hesklang['category_leave_blank_for_no_default_due_date']='(оставьте поле пустым для указания даты выполнения по умолчанию)';
$hesklang['category_default_due_date_updated']='Дата выполнения по умолчанию была обновлена.';
$hesklang['email_formatting']='Форматирование электронной почты';
$hesklang['email_formatting_html_and_plaintext']='HTML с альтернативой обычному тексту из шаблона обычного текста (по умолчанию)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML с альтернативой обычного текста, сгенерированного из шаблона HTML';
$hesklang['email_formatting_html']='Только HTML';
$hesklang['email_formatting_plaintext']='Только обычный текст';
$hesklang['email_formatting_note']='Ваш выбор %1$s &gt; %2$s &gt; %3$s установлен на: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='HESK будет игнорировать HTML-шаблоны.';
$hesklang['email_formatting_note1']='HESK будет игнорировать шаблоны обычного текста.';
$hesklang['email_formatting_note2']='HESK будет генерировать текстовую версию электронных писем из ваших HTML-шаблонов и игнорировать шаблоны обычного текста.';
$hesklang['etnu']='Этот шаблон электронной почты в настоящее время не используется Hesk на основе вашего выбора в %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='редактировать категорию.';
$hesklang['create_category']='Создать категорию';
$hesklang['one_user_included']='1 пользователь включен';
$hesklang['one_user_excluded']='1 пользователь исключен';
$hesklang['x_users_included']='%s пользователя (-лей) включено'; // %s = Number of users
$hesklang['x_users_excluded']='%s пользователя (-лей) исключено'; // %s = Number of users
$hesklang['aa_cat']='Автоматическое назначение заявок в этой категории';
$hesklang['modify_autoassign_settings']='Изменение параметров автоматического назначения';
$hesklang['autoassign_on_all_users']='Да, любому пользователю, имеющему доступ к этой категории';
$hesklang['autoassign_on_select_users']='Да, для конкретных пользователей';
$hesklang['autoassign_off']='Нет, отправлять заявки как неназначенные';
$hesklang['autoassign_users']='Пользователи для включения/исключения в автоматическое назначение';
$hesklang['autoassign_selected_include']='Выбранные пользователи должны быть <strong>включены</strong> при автоматическом назначении заявок в этой категории';
$hesklang['autoassign_selected_exclude']='Выбранные пользователи должны быть <strong>исключены</strong> при автоматическом назначении заявок в этой категории';
$hesklang['cat_edited']='Категория %s была успешно отредактирована';
$hesklang['search_for_user']='Найти пользователя';
$hesklang['email_sending']='Отправить письма';
$hesklang['email_to_ticket']='Электронная почта для отправки заявки';
$hesklang['email_to_ticket_info']='Преобразование электронных писем в заявки требует некоторой настройки на стороне сервера. Для получения более подробной информации, пожалуйста, смотрите <a href="%s" target="_blank">это руководство по базе знаний</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk использует SMTP-сервер для отправки уведомлений по электронной почте. Ваш <strong>%1$s</strong> должен быть установлен на <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Отсутствующее расширение файла';
$hesklang['block_ignore']='E-Mail в заявку - Игнорировать электронные письма и предотвращать циклы циклы';
$hesklang['block_noreply']='Не отвечать';
$hesklang['block_noreply2']='Игнорировать электронные письма, отправленные с адресов электронной почты "не отвечать"';
$hesklang['block_returned']='Возвращено';
$hesklang['block_returned2']='Игнорировать возвращенные электронные письма, такие как уведомления о статусе доставки и автоматические ответы';
$hesklang['block_duplicate']='Дубликаты';
$hesklang['block_duplicate2']='Игнорировать электронные письма с одним и тем же сообщением, отправленным в течение &quot;%s&quot; секунд'; // %s = "Timeframe"
$hesklang['loop_info']='электронные письма, полученные с того же адреса электронной почты в течение &quot;%s&quot; секунд';
$hesklang['thist21']='<li class="smaller">%s | отправлено просроченное уведомление по электронной почте</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | последующее отправленное электронное письмо</li>'; // %s = date
$hesklang['elevator_header']='Вход в защищенную область';
$hesklang['elevator_intro']='Вы входите в защищенную область.';
$hesklang['elevator_enter_password']='Введите Ваш пароль для продолжения.';
$hesklang['elevator_duration_setting_title']='Длительность в защищенной области';
$hesklang['desc_survey']='(Клиент) Последующая (опросная) электронная почта'; // Email description
$hesklang['satisfaction']['tab']='Удовлетворенность';
$hesklang['satisfaction']['title']='Опрос удовлетворенности клиента';
$hesklang['satisfaction']['intro']='Отправьте своим клиентам последующий опрос об удовлетворенности, чтобы собрать отзывы об их опыте работы с вашей службой поддержки.';
$hesklang['satisfaction']['tab1']='Настройки';
$hesklang['satisfaction']['tab2']='Отказ от участия';
$hesklang['satisfaction']['enable']='Включить последующие электронные письма:';
$hesklang['satisfaction']['enabled']='Включены опросы удовлетворенности клиентов.';
$hesklang['satisfaction']['disabled']='Customer Satisfaction Surveys are currently disabled.';
$hesklang['satisfaction']['url']='URL-адрес опроса:';
$hesklang['satisfaction']['send']='Последующая задержка по электронной почте:';
$hesklang['satisfaction']['at_least']='Подождите хотя-бы';
$hesklang['satisfaction']['after']='после того, как тикет будет разрешен перед отправкой электронного письма';
$hesklang['satisfaction']['h1']='Как использовать этот инструмент?';
$hesklang['satisfaction']['h2']='Во-первых, создайте опрос удовлетворенности клиентов в вашем любимом инструменте опроса. Если вы не уверены, какой инструмент использовать или какие вопросы задавать, у нас есть руководство <a href="%s" target="_blank">, доступное здесь</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Когда ваш опрос будет готов, включите последующие электронные письма, используя форму ниже. Heck будет обрабатывать разрешенные заявки по крайней мере с одним ответом персонала один раз в час и отправлять ссылку на ваш опрос вашим клиентам.';
$hesklang['satisfaction']['e_url']='Введите действительный URL-адрес опроса. Это URL-адрес, по которому будут отправляться ваши клиенты.';
$hesklang['satisfaction']['as']='Введите действительный URL-адрес опроса. Это URL-адрес, по которому будут отправляться ваши клиенты.';
$hesklang['satisfaction']['oo1']='На этой странице перечислены адреса электронной почты, на которые последующие электронные письма <b> не будут </b> отправляться.';
$hesklang['satisfaction']['oo2']='Ваши клиенты могут отказаться от получения электронных писем с опросами, нажав на ссылку в электронном письме. Кроме того, вы можете вручную добавить адреса электронной почты на этой странице.';
$hesklang['satisfaction']['ooe']='Адрес электронной почты для отказа';
$hesklang['satisfaction']['ooe2']='Введите адрес электронной почты, от которого вы хотите отказаться, чтобы получать электронные письма с опросами.';
$hesklang['satisfaction']['ooe3']='Этот адрес электронной почты <i>%s</i> уже не получает электронные письма с опросом.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Откажитесь от этого электронного письма';
$hesklang['satisfaction']['oob']='Отказался от участия';
$hesklang['satisfaction']['no_oo']='Ни один клиент не отказался от получения электронных писем с опросом.';
$hesklang['satisfaction']['oor']='Удалить';
$hesklang['satisfaction']['oor2']='Электронная почта удалена из отказа';
$hesklang['satisfaction']['oor3']='Подвердить удаление';
$hesklang['satisfaction']['oor4']='После удаления из подписки этот пользователь снова будет получать последующие электронные письма.';
$hesklang['satisfaction']['optedout']='Адрес электронной почты <i>%s</i> был исключен из получения электронных писем с опросом.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Отсутствующий или неверный идентификатор опроса';
$hesklang['satisfaction']['starting']='Запуск процесса уведомления об опросе удовлетворенности клиентов';
$hesklang['satisfaction']['tc']='Найдено % закрытых заявок, для которых не был отправлен опрос об удовлетворенности.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Законченный опрос удовлетворенности клиентов. Отправленные электронные письма:% 1$s. Не удалось отправить электронные письма:%2$s. Заявки без электронного письма: %3$s. Заявки с отказом по электронной почте: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Игнорировать, этот клиент не желает получать электронные письма с опросом.';
$hesklang['satisfaction']['ne']='Игнорировать, эта заявка без адреса электронной почты';
$hesklang['satisfaction']['feat1']='Создайте свой опрос с помощью любого стороннего инструмента, например Google Forms';
$hesklang['satisfaction']['feat2']='настройте URL-адрес вашего опроса, настройки и ограничения внутри этого модуля';
$hesklang['satisfaction']['feat3']='когда вы оформите заявку, Служба поддержки отправит вашему клиенту по электронной почте ссылку на опрос';
$hesklang['dfor']='Формат даты';
$hesklang['dtfor']='Дата и Время';
$hesklang['cdfor']='Выбрать формат даты';
$hesklang['custom']='Вручную';
$hesklang['jsc_notice']='Выбор даты не поддерживает форматирование даты в стиле PHP. Выберите один из предварительно настроенных параметров или щелкните значок %s ниже, чтобы просмотреть доступные параметры отображения.'; // %s = replaced by icon
$hesklang['lcf3']='Только дата'; // Display: "Date only"
$hesklang['epdd']='Ошибка синтаксического анализа параметра due_date:';
$hesklang['edit_pass']='Редактировать пароль';
$hesklang['save_pass']='Сохранить пароль';
$hesklang['cur_pass']='Текущий пароль';
$hesklang['cur_pass2']='Вы должны указать свой текущий пароль, чтобы изменить его.';
$hesklang['cur_pass3']='После успешного обновления пароля вы будете перенаправлены на страницу входа в систему, где сможете войти в систему под своим новым паролем.';
$hesklang['e_new_pass']='Пожалуйста, введите свой новый пароль';
$hesklang['pass_len']='Пароль не должен превышать 64 символов';
$hesklang['pass_login']='Пожалуйста, войдите в систему еще раз после смены пароля';
$hesklang['bf_int']='Вы вышли из системы из-за слишком большого количества неудачных попыток проверки';
$hesklang['tst_cnt']='Количество электронных писем, которые ваш почтовый сервер отправит в Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='У вас в почтовом ящике много непрочитанных писем (% 1$s). Черт возьми, все эти электронные письма превратятся в заявки.<br><br>Возможно, вы захотите пометить существующие электронные письма как прочитанные перед включением %2$s или использовать новую учетную запись электронной почты для Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='У вас много писем в вашем почтовом ящике (% 1$s). Черт возьми, все эти электронные письма превратятся в заявки.<br><br>Возможно, вы захотите удалить существующие электронные письма перед включением %2$s или использовать новую учетную запись электронной почты для Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Срок исполнения'; // Due on (date)
$hesklang['search_due_date_range']='Срок сдачи'; // Due in (X days)
$hesklang['attachment_add_files']='Добавить файл';
$hesklang['attachment_max_exceeded']='Этот файл не будет загружен, потому что вы уже загрузили максимальное количество разрешенных файлов.';
$hesklang['attachment_viewer_message']='Перетащите файлы сюда или нажмите кнопку "Добавить файл" ниже, чтобы выбрать файлы для загрузки.';
$hesklang['attachment_invalid_type_message']='Извините, но тип файла, который вы пытались загрузить, не разрешен.';
$hesklang['attachment_upload_error']='При попытке загрузки произошла ошибка. Пожалуйста, попробуйте еще раз позже.';
$hesklang['attachment_too_large']='Размер этого вложения превышает максимально допустимый размер файла.';
$hesklang['attachment_cancel']='Отмена';
$hesklang['attachment_confirm_cancel']='Вы уверены, что хотите отменить эту загрузку?';
$hesklang['attachment_remove']='Удалить вложение';
$hesklang['attachment_too_many_uploads']='Слишком много вложений было загружено из вашего местоположения за короткий промежуток времени. Пожалуйста, повторите свой запрос позже.';
$hesklang['sub_note']='Отправить примечание';
$hesklang['can_view_users']='Просмотр всех пользователей (но не управление ими)';
$hesklang['welcome1']='Привет, ты, кажется, здесь новенький (-ая). Добро пожаловать!';
$hesklang['welcome2']='Чтобы помочь вам начать работу, ознакомьтесь с %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Краткое руководство пользователя Hesk online';
$hesklang['tmce1']='Используйте Ctrl + Щелчок правой кнопкой мыши, чтобы получить доступ к программе проверки орфографии';
$hesklang['tmce2']='Удерживая клавишу Control (Ctrl), щелкните правой кнопкой мыши на слове с ошибкой, чтобы открыть средство проверки орфографии.';
$hesklang['desc_new_ticket_by_staff']='(Клиент) Новый заявка, отправленная персоналом';
$hesklang['mod_et_h']='Вы можете изменить шаблоны электронной почты в разделе %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Установить язык на';
$hesklang['ouwa']='Ниже перечислены только пользователи, имеющие доступ к этой категории. Чтобы добавить сотрудников в эту категорию, измените их разрешения на странице %s'; // %s = Team
$hesklang['previous_tickets']='Предыдущие заявки';
$hesklang['no_previous']='Нет предыдущих заявок от %s'; // %s = email address
$hesklang['all_previous']='Показать все предыдущие заявки';
$hesklang['confirm_delete_ticket']='Вы уверены, что хотите навсегда удалить эту заявку?';
$hesklang['confirm_delete_reply']='Вы уверены, что хотите навсегда удалить этот ответ?';
$hesklang['select_new_category']='Количество заявок в этой категории: %s<br><br>Пожалуйста, выберите новую категорию, чтобы перенести эти заявки:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Количество заявок, назначенных этому пользователю:%1$s<br>Количество <b>открытых</b> заявок, назначенных этому пользователю: %2$s<br><br><b>Открытые</b> заявки будут <b>неназначенными</b> после удаления этого пользователя.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Лицензия HESK';
$hesklang['hlic_free']='БЕСПЛАТНАЯ';
$hesklang['hlic_buyl']='Купить лицензию';
$hesklang['hlic_paid']='Лицензия';
$hesklang['antdemo']='Отправка заявок из админ-панели была отключена в демонстрационном режиме.<br><br>Пожалуйста, используйте <a href="%s" target="_blank">общедоступную сторону</a>, чтобы отправить тестовую заявку.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Способ аутенификации';
$hesklang['email_authentication_method_username_password']='Базовый (имя_пользователя / Пароль)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Не настроены проверенные поставщики OAuth.';
$hesklang['email_authentication_method_oauth_link']='Управление поставщиками OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL конечной точки авторизации';
$hesklang['email_oauth_token_url']='URL-адрес конечной точки токена';
$hesklang['email_oauth_client_id']='ID клиента';
$hesklang['email_oauth_client_secret']='Пароль';
$hesklang['email_oauth_scope']='Масштаб';
$hesklang['oauth_error_invalid_state']='Состояние OAuth не соответствует состоянию, отправленному поставщику OAuth.';
$hesklang['oauth_error_unknown']='При попытке сохранить токены OAuth произошла неизвестная ошибка.';
$hesklang['oauth_error_no_token']='Маркер доступа отсутствует в ответе JSON.';
$hesklang['oauth_error_retrieve']='Не удалось получить маркер доступа. Пожалуйста, подтвердите настройки вашего поставщика OAuth и повторно сохраните их, чтобы получить новый токен.';
$hesklang['email_oauth_provider']='Поставщик OAuth';
$hesklang['email_oauth_providers']='Поставщики OAuth';
$hesklang['email_oauth_provider_guide']='Перед использованием OAuth вы должны зарегистрировать поставщика OAuth. Для получения более подробной информации, пожалуйста, смотрите <a href="%s" target="_blank">это руководство по базе знаний</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Ваш URI перенаправления OAuth для Hesk:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Используйте этот инструмент для добавления поставщиков OAuth в службу поддержки';
$hesklang['email_oauth_provider_name']='Имя'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Новый поставщик';
$hesklang['email_oauth_edit_provider']='Редактировать поставщика';
$hesklang['email_oauth_provider_being_used_for']='Используется для';
$hesklang['email_oauth_providers_none']='Поставщики OAuth не сохранены. Вы можете добавить их, нажав "Новый поставщик" выше.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Этот поставщик не может быть удален, поскольку он используется службой поддержки.';
$hesklang['email_oauth_confirm_delete_provider']='Вы уверены, что хотите удалить этого поставщика OAuth?';
$hesklang['oauth_provider_saved']='Поставщик OAuth был сохранен';
$hesklang['oauth_provider_use']='Теперь вы можете выбрать этого поставщика в %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Введите имя поставщика';
$hesklang['oauth_provider_err_auth_url']='Введите действительный URL-адрес авторизации';
$hesklang['oauth_provider_err_token_url']='Введите действительный URL-адрес токена';
$hesklang['oauth_provider_err_client_id']='Введите ID клиента';
$hesklang['oauth_provider_err_client_secret']='Введите пароль';
$hesklang['oauth_provider_err_scope']='Введите область действия';
$hesklang['oauth_provider_deleted']='Поставщик OAuth удален';
$hesklang['oauth_provider_not_found']='Этот поставщик OAuth не существует';
$hesklang['oauth_provider_verified']='Проверено';
$hesklang['oauth_provider_click_to_verify']='Нажмите, чтобы подтвердить';
$hesklang['can_due_date']='Можно установить срок выполнения'; // Permission to set and modify due date
$hesklang['can_due_date_e']='У вас нет разрешения устанавливать сроки выполнения';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Пожалуйста, подтвердите вашу регистрацию';
$hesklang['customer_verify_new_email']='Пожалуйста, подтвердите ваш новый адрес электронной почты';
$hesklang['customer_reset_password']='Сброс пароля';
$hesklang['customer_approved']='Аккаунт одобрен';
$hesklang['customer_rejected']='Аккаунт отклонен';
$hesklang['email_rejected']='Для подачи заявок в службу поддержки требуется аккаунт';
$hesklang['require_curl']='Эта функция требует поддержки <strong>cURL</strong> для PHP на вашем сервере. Пожалуйста, попросите вашего хостинг-провайдера включить cURL для PHP.';
$hesklang['customer_accounts_heading']='Учетные записи клиентов';
$hesklang['customer_accounts']='Учетные записи клиентов';
$hesklang['customer_accounts_off']='<strong>Отключено</strong>';
$hesklang['customer_accounts_allowed']='<strong>Включено - Необязательно</strong> (клиенты могут отправлять запросы в службу поддержки без регистрации или входа в систему)';
$hesklang['customer_accounts_required_to_submit']='<strong>Включено - Обязательно для запросов</strong> (только зарегистрированные клиенты могут отправлять запросы в службу поддержки)';
$hesklang['customer_accounts_required']='<strong>Включено - Обязательно для доступа</strong> (только зарегистрированные клиенты могут получить доступ к службе поддержки и базе знаний)';
$hesklang['customer_accounts_reg']='Регистрация учетной записи';
$hesklang['customer_accounts_reg_customer']='Клиенты могут регистрировать учетные записи';
$hesklang['customer_accounts_reg_approve']='Клиенты могут регистрировать учетные записи, сотрудники должны подтвердить новые регистрации';
$hesklang['customer_accounts_reg_staff']='Только сотрудники могут регистрировать учетные записи клиентов';
$hesklang['customer_accounts_allow_email_changes']='Разрешить клиентам изменять свой адрес электронной почты';
$hesklang['customer_accounts_allow_email_resends']='Время до того, как клиенты смогут запросить новое подтверждающее письмо';
$hesklang['customer_login']='Вход';
$hesklang['customer_logout']='Выход';
$hesklang['customer_register']='Регистрация';
$hesklang['customer_accounts_disabled']='Вход и регистрация клиентов отключены.';
$hesklang['customer_accounts_registration_disabled']='Регистрация клиентов отключена.';
$hesklang['customer_forgot_password']='Забыли пароль?';
$hesklang['customer_email']='Адрес электронной почты';
$hesklang['customer_accounts_email_banned']='Вам запрещено использовать эту службу поддержки.';
$hesklang['customer_registration_successful']='Регистрация успешна!';
$hesklang['customer_registration_email_exists_no_reset_link']='Учетная запись с адресом электронной почты %s уже существует.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Учетная запись с адресом электронной почты %s уже существует. <a href="login.php">Хотите войти вместо этого</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Учетная запись с адресом электронной почты %s уже существует и ожидает подтверждения электронной почты.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Учетная запись с адресом электронной почты %s уже существует и ожидает подтверждения сотрудниками.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Проверьте свою электронную почту!';
$hesklang['customer_registration_check_your_email_content']='Вы должны подтвердить свой адрес электронной почты перед тем, как сможете войти.<br><br>Если вы не получили его в течение нескольких минут, проверьте папки "Спам", "Нежелательная почта" или "Рассылка". Пометьте сообщение как <b>Не СПАМ</b>, чтобы избежать проблем с получением нашей корреспонденции в будущем.';
$hesklang['customer_login_not_verified']='Вы должны подтвердить свой адрес электронной почты перед тем, как сможете войти.';
$hesklang['customer_login_not_verified2']='Если вы не получили подтверждающее письмо от нас, проверьте папки "Спам", "Нежелательная почта" или "Рассылка". Пометьте сообщение как <b>Не СПАМ</b>, чтобы избежать проблем с получением нашей корреспонденции в будущем.';
$hesklang['customer_login_resend_verification_email']='Отправить подтверждающее письмо повторно';
$hesklang['customer_login_resend_verification_email_none']='Нет ожидающих подтверждений электронной почты для отправки.';
$hesklang['customer_login_resend_verification_email_too_early']='Вы не можете запросить новое подтверждающее письмо в данный момент, попробуйте позже.';
$hesklang['customer_login_not_approved']='Сотрудник должен утвердить вашу учетную запись перед тем, как вы сможете войти. После подверждения вам будет отправлено уведомление по электронной почте.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Подтверждение регистрации';
$hesklang['customer_registration_verify_success']='Ваш адрес электронной почты был подтвержден, и теперь вы можете войти, используя форму ниже.';
$hesklang['customer_registration_verify_approval_needed']='Ваш адрес электронной почты был подтвержден. Однако сотрудник должен утвердить вашу учетную запись перед тем, как вы сможете войти. После подтверждения вам будет отправлено уведомление по электронной почте.';
$hesklang['customer_registration_verify_failure']='Ваш адрес электронной почты не может быть подтвержден. Либо ссылка уже была использована, либо она истекла.';
$hesklang['emails_to_customers']='&raquo; Письма, отправленные клиентам';
$hesklang['emails_to_staff']='&raquo; Письма, отправленные сотрудникам';
$hesklang['emails_to_everyone']='&raquo; Письма, отправленные сотрудникам или клиентам';
$hesklang['new_customer_approval']='У вас есть учетные записи клиентов, ожидающие подтверждения'; // Email subject
$hesklang['desc_new_customer_approval']='(Сотрудники) Учетные записи клиентов, ожидающие подтверждения';
$hesklang['n_cust_app']='Есть ожидающие подтверждения клиентов'; // Notify me when...
$hesklang['et_num_customers']='Количество клиентов ожидающих подтверждения';
$hesklang['et_link_customers']='Ссылка на страницу управления клиентами';
$hesklang['et_link_verify']='Ссылка для подтверждения';
$hesklang['et_cust_login']='URL входа клиента';
$hesklang['submit_ticket_customer_email_exists']='Клиент с таким адресом электронной почты уже существует. Пожалуйста, <a href="login.php?email=%s">войдите</a>, чтобы отправить запрос.'; // %s - User's email
$hesklang['customer_login_email_required']='Пожалуйста, введите действительный адрес электронной почты.';
$hesklang['customer_login_password_required']='Пожалуйста, введите ваш пароль.';
$hesklang['customer_login_remember_just_email']='Запомнить только мой адрес электронной почты';
$hesklang['customer_login_remember_email']='Запомнить мой адрес электронной почты';
$hesklang['customer_wrong_user']='Ваш адрес электронной почты %s не зарегистрирован у нас.<br><br>Хотите <a href="register.php">создать учетную запись</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Ваш адрес электронной почты и пароль не совпадают с нашими записями.<br><br>Хотите <a href="login.php?submittedForgot=1">сбросить пароль</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Пожалуйста, войдите, чтобы продолжить.';
$hesklang['customer_register_here']='Если у вас нет учетной записи у нас, вы можете <a href="register.php">зарегистрироваться здесь</a>.';
$hesklang['create_account']='Создать учетную запись';
$hesklang['customer_my_tickets_heading']='Личный кабинет';
$hesklang['customer_my_tickets_description']='Просмотреть все свои предыдущие заявки';
$hesklang['customer_my_tickets_search_for_tickets']='Поиск заявок';
$hesklang['customer_password_reset_successful']='Ваш новый пароль был сохранен. Теперь вы можете войти.';
$hesklang['customer_profile']='Профиль';
$hesklang['customer_edit_profile']='Редактировать профиль';
$hesklang['customer_edit_pass']='Изменить пароль';
$hesklang['customer_edit_pass_same']='Ваш новый пароль не должен совпадать с текущим.';
$hesklang['customer_change_email']='Изменить адрес электронной почты';
$hesklang['customer_change_email_banned']='Введенный вами адрес электронной почты заблокирован.';
$hesklang['customer_change_email_pending']='Существует текущий запрос на изменение вашего адреса электронной почты на: <b>%s</b><br><br>Мы отправили письмо на этот адрес. Пожалуйста, нажмите на ссылку внутри письма, чтобы подтвердить изменение.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Отправить подтверждающее письмо повторно</a>';
$hesklang['customer_change_email_submitted']='Пожалуйста, нажмите на ссылку для подтверждения, отправленную на <b>%s</b>, чтобы подтвердить ваш новый адрес электронной почты.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Ваш новый адрес электронной почты был подтвержден, и ваш профиль обновлен.';
$hesklang['customer_change_email_disabled']='Возможность обновления вашего адреса электронной почты отключена. Свяжитесь с нами, если вы хотите изменить свой адрес электронной почты.';
$hesklang['customer_profile_saved']='Ваш профиль был сохранен.';
$hesklang['customers']='Клиенты';
$hesklang['customers_intro']='Учетные записи клиентов позволяют клиентам просматривать все свои запросы в одном месте.';
$hesklang['sure_remove_customer']='Вы уверены, что хотите удалить этого клиента?';
$hesklang['sure_remove_customer_additional_note']='Удаление клиента является окончательным. После удаления его нельзя будет восстановить!';
$hesklang['new_customer']='Новый клиент';
$hesklang['new_follower']='Новый подписчик';
$hesklang['add_customer']='+ Добавить клиента'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Добавить подписчика'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='Указанный клиент еще не существует. Нажмите "Сохранить", если хотите создать этого клиента.';
$hesklang['followers']='Подписчики';
$hesklang['no_customers']='В базе данных в настоящее время нет клиентов.';
$hesklang['no_customers_disabled']='Вы начнете видеть клиентов здесь, когда они будут отправлять запросы в службу поддержки.';
$hesklang['no_customers_enabled']='Вы начнете видеть клиентов здесь, когда они будут регистрироваться или отправлять запросы в службу поддержки.';
$hesklang['no_customers_enabled2']='Кроме того, кнопки выше этого сообщения позволяют вам вручную создавать учетные записи клиентов или импортировать существующих клиентов в службу поддержки.';
$hesklang['import_customers']='Импорт клиентов';
$hesklang['import_customers_tip']='Используйте CSV-файл для импорта нескольких клиентов одновременно.';
$hesklang['customer_not_found']='Клиент не найден для запроса!';
$hesklang['search_by_name_or_email']='Поиск по имени или адресу электронной почты...';
$hesklang['search_by_pattern']='Поиск по шаблону...';
$hesklang['is_searchable']='Доступно для поиска';
$hesklang['custom_is_searchable']='Доступно для поиска';
$hesklang['yes_via_autocomplete']='ДА (поиск через автозаполнение)';
$hesklang['customer_required']='Вы должны выбрать клиента';
$hesklang['customer_email_exists']='Клиент с таким адресом электронной почты уже существует.';
$hesklang['customer_name_with_no_email_exists']='Клиент с таким именем и без адреса электронной почты уже существует.';
$hesklang['an_error_occurred_validating_email']='Произошла ошибка при попытке проверить введенный адрес электронной почты.';
$hesklang['customer_count_x_more']='+%s еще'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Зарегистрирован';
$hesklang['customer_account_verified']='Подтвержден';
$hesklang['customer_account_verified_help']='Клиенты должны подтвердить свою учетную запись через ссылку активации, отправленную на их адрес электронной почты, перед тем, как смогут войти в свою учетную запись.';
$hesklang['customer_account_setting_password_will_verify_user']='Установка пароля для этого клиента автоматически подтвердит его учетную запись.';
$hesklang['deleting_customer_with_tickets']='У этого клиента есть %1$s запрос(ов) <b>(%2$s открытых)</b>, которые также связаны с другими клиентами.<br>Что следует сделать с этими запросами?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Требуется действительный адрес электронной почты для повторной отправки подтверждающего письма.';
$hesklang['customer_resend_verification_email_not_found']='Учетная запись с таким адресом электронной почты не существует, или учетная запись уже подтверждена.';
$hesklang['customer_resend_verification_email_sent']='Подтверждающее письмо было отправлено на ваш адрес электронной почты.<br><br>Если вы не получите его в течение нескольких минут, проверьте папки "Спам", "Нежелательная почта" или "Рассылка". Пометьте сообщение как <b>Не СПАМ</b>, чтобы избежать проблем с получением нашей корреспонденции в будущем.';
$hesklang['customer_permission_denied']='У вас нет разрешения на изменение данных клиентов.';
$hesklang['customer_manage_approvals']='Учетные записи клиентов, ожидающие подтверждения: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Подвердить клиента';
$hesklang['customer_manage_bulk_approve']='Подтвердить выбранных клиентов';
$hesklang['customer_manage_bulk_approve_complete']='Клиенты подтверждены: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Отклонить клиента';
$hesklang['customer_manage_bulk_reject']='Отклонить выбранных клиентов';
$hesklang['customer_manage_bulk_reject_complete']='Клиенты отклонены: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Удалить клиента';
$hesklang['customer_manage_bulk_delete']='Удалить выбранных клиентов';
$hesklang['customer_manage_bulk_delete_complete']='Клиенты удалены: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Редактировать клиента';
$hesklang['customer_manage_verification_email_sent']='Подтверждающее письмо было отправлено на %s'; // %s = customer's email
$hesklang['can_man_customers']='Управлять клиентами';
$hesklang['can_view_customers']='Просматривать всех клиентов (но не управлять ими)';
$hesklang['import_customer_select_file']='Выбрать файл';
$hesklang['import_customer_step1_instructions']='Для импорта клиентов подготовьте CSV-файл (Comma-Separated Values).';
$hesklang['import_customer_step1_note']='Выберите ваш CSV-файл';
$hesklang['import_customer_step1_separator']='Столбцы в моем CSV-файле разделены';
$hesklang['import_customer_sample']='&raquo; Примеры CSV-файлов';
$hesklang['import_customer_sample_1']='CSV-файл в стиле США с разделителями ,';
$hesklang['import_customer_sample_2']='CSV-файл в стиле ЕС с разделителями ;';
$hesklang['import_customer_upload_requirements_1']='Ваш CSV-файл должен содержать хотя бы столбец с именем или адресом электронной почты. Столбец с паролем является необязательным.';
$hesklang['import_customer_upload_requirements_2']='Первая строка вашего файла должна содержать заголовки столбцов.';
$hesklang['import_customer_upload_requirements_3']='Ваш файл должен быть закодирован в UTF-8.';
$hesklang['import_customer_select_columns']='Выбрать столбцы';
$hesklang['import_customer_upload_customers']='Загрузить список клиентов';
$hesklang['import_customer_column_name']='Столбец имени';
$hesklang['import_customer_column_email']='Столбец адреса электронной почты';
$hesklang['import_customer_column_pass']='Столбец пароля';
$hesklang['import_customer_step2_note']='Выберите правильное имя столбца из вашего CSV-файла в выпадающих списках, затем нажмите "Далее".';
$hesklang['import_customer_name_or_email_required']='Требуется имя или адрес электронной почты';
$hesklang['import_customer_step3_note']='Ваши клиенты импортируются. Не покидайте эту страницу!';
$hesklang['import_customer_step3_pending']='В ожидании';
$hesklang['import_customer_step3_successful_imports']='Успешный импорт';
$hesklang['import_customer_step3_failed_imports']='Неудачный импорт';
$hesklang['import_customer_step3_progress']='Прогресс';
$hesklang['import_customer_step3_complete_some_failed']='Процесс импорта завершен, однако <b>%s</b> клиентов не удалось импортировать. Проверьте таблицу ниже для получения дополнительной информации.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='Процесс импорта завершен!';
$hesklang['import_customer_step3_importing']='Импорт';
$hesklang['staff_deleted']='[Сотрудник удален]';
$hesklang['customer_account_approved']='Регистрация клиента подтверждена';
$hesklang['customer_account_rejected']='Регистрация клиента отклонена';
$hesklang['customer_account_deleted']='Регистрация клиента удалена';
$hesklang['ticket_followers']='Подписчики заявки';
$hesklang['ticket_followers2']='Разрешить в заявках иметь несколько клиентов';
$hesklang['add_cc']='Добавить копию';
$hesklang['cc']='Копия';
$hesklang['cc_help']='Разделите каждый адрес электронной почты запятой.';
$hesklang['search_customers']='Поиск клиентов';
$hesklang['page_size']='Размер страницы';
$hesklang['customers_on_pages']='Количество клиентов: %d | Количество страниц: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Клиент) Сбросить ваш пароль';
$hesklang['desc_customer_verify_registration']='(Клиент) Подтвердите вашу регистрацию';
$hesklang['desc_customer_verify_new_email']='(Клиент) Подтвердите ваш новый адрес электронной почты';
$hesklang['desc_customer_approved']='(Клиент) Учетная запись подтверждена';
$hesklang['desc_customer_rejected']='(Клиент) Учетная запись отклонена';
$hesklang['desc_email_rejected_can_self_register']='(Клиент) Запрос по электронной почте отклонен; клиент может зарегистрироваться самостоятельно';
$hesklang['desc_email_rejected_cannot_self_register']='(Клиент) Запрос по электронной почте отклонен; клиент не может зарегистрироваться самостоятельно';
$hesklang['user_added_success_no_pass']='Новый пользователь %s успешно добавлен';
$hesklang['email_tag_requester']='Заявитель (От)';
$hesklang['email_tag_requester_name']='Заявитель (От) Имя';
$hesklang['email_tag_requester_first_name']='Заявитель (От) Имя';
$hesklang['email_tag_requester_email']='Заявитель (От) Электронная почта';
$hesklang['email_tag_followers']='Подписчики (Копия)';
$hesklang['email_tag_follower_names']='Подписчик (Копия) Имена';
$hesklang['email_tag_follower_emails']='Подписчик (Копия) Электронная почта';
$hesklang['barcode']='Штрих-код';
$hesklang['barcode_use']='Отображать штрих-код на распечатанных запросах';
$hesklang['barcode_staff_only']='Скрыть штрих-код от клиентов';
$hesklang['barcode_type']='Тип штрих-кода';
$hesklang['barcode_format']='Формат';
$hesklang['barcode_width']='Ширина';
$hesklang['barcode_height']='Высота';
$hesklang['barcode_color']='Цвет';
$hesklang['barcode_bg']='Фон';
$hesklang['copy_link']='Скопировать ссылку на запрос';
$hesklang['copy_link_title']='Скопировать публичную ссылку на этот запрос';
$hesklang['copy_link_exp']='Скопированная ссылка является прямой ссылкой для клиента на просмотр этого запроса';
$hesklang['copy_value']='Скопировать это значение';
$hesklang['download_class']='Эта функция требует класса ZipArchive. Попросите вашего хостинг-провайдера скомпилировать PHP с поддержкой zip.';
$hesklang['download_all']='Скачать все';
$hesklang['download_prep']='Подготовка загрузки...';
$hesklang['download_tma']='Слишком много вложений';
$hesklang['download_nva']='Нет действительных вложений';
$hesklang['download_ntd']='Нет данных для загрузки';
$hesklang['resolved_at']='Решено в';
$hesklang['disable_GSSAPI']='Отключить аутентификатор GSSAPI (обход ошибки Kerberos)';
$hesklang['ex_history']='Включить журнал истории запросов в экспорт';
$hesklang['sm_location']='Местоположение'; // Location (page) of a service message
$hesklang['loc_sm']='Показать это служебное сообщение на:';
$hesklang['loc_all']='Каждая страница клиента';
$hesklang['loc_norec']='(не рекомендуется)';
$hesklang['loc_home']='Домашняя страница службы поддержки';
$hesklang['loc_selected']='На выбранных страницах';
$hesklang['loc_selerr']='Выберите хотя бы одну страницу для отображения сообщения';
$hesklang['loc_t_cat']='Отправить запрос - выбрать категорию';
$hesklang['loc_t_add']='Отправить запрос - отправить форму запроса';
$hesklang['loc_t_ok']='Отправить запрос - подтверждение запроса';
$hesklang['loc_t_view']='Просмотреть запрос';
$hesklang['loc_t_form']='Просмотреть форму запроса';
$hesklang['loc_kb_main']='Домашняя страница базы знаний';
$hesklang['loc_kb_sub']='Страницы подкатегорий базы знаний';
$hesklang['loc_kb_art']='Статьи базы знаний';
$hesklang['loc_login']='Страница входа клиента';
$hesklang['loc_register']='Страница регистрации клиента';
$hesklang['loc_register_ok']='Регистрация клиента успешна';
$hesklang['loc_acc']='Страница клиента "Мои запросы"';
$hesklang['loc_profile']='Страница клиента "Профиль"';
$hesklang['sending_show']='Показать уведомление "Отправка"';
$hesklang['sending_wait']='Отправка, пожалуйста, подождите...';
$hesklang['e_c_email']='Введите правильный адрес электронной почты для просмотра этого запроса';
$hesklang['only_verified_cc']='Подписчики без подтвержденной учетной записи будут проигнорированы.';
$hesklang['followers_removed']='Эти адреса электронной почты были удалены из запроса, так как у них нет подтвержденной учетной записи:';
$hesklang['novace']='Мы не нашли зарегистрированных и подтвержденных учетных записей с этим адресом электронной почты.';
$hesklang['max_recipients']='Максимум получателей';
$hesklang['max_recipients2']='в одном письме';
$hesklang['admin_js']='Админ JS';
$hesklang['admin_js2']='Загрузить дополнительный пользовательский файл JavaScript для админ-панели';
$hesklang['cf_limit_all']='Вы достигли лимита пользовательских полей и не можете создавать новые пользовательские поля.';
$hesklang['remind_assigned']='Напомнить назначенному сотруднику';
$hesklang['remind_sent']='Напоминание по электронной почте отправлено назначенному сотруднику';
$hesklang['thist23']='<li class="smaller">%s | напоминание отправлено %s от %s</li>';
$hesklang['ql_bookmarks']='Закладки';
$hesklang['bookmark']='Моя закладка';
$hesklang['bookmarks_add']='Добавить в закладки';
$hesklang['bookmarks_added']='Этот запрос был добавлен в ваши закладки';
$hesklang['bookmarks_remove']='Удалить из закладок';
$hesklang['bookmarks_removed']='Этот запрос был удален из ваших закладок';
$hesklang['genl_not_copied']='Ошибка: Копирование в буфер обмена не поддерживается на этом устройстве/браузере.';
$hesklang['profile_duplicate_email']='Пользователь с адресом электронной почты <b>%s</b> уже существует.'; // %s: new email
$hesklang['seq_id_numeric']='Поиск номера запроса должен содержать только цифры';
$hesklang['confirm_new_pass']='Подтвердите новый пароль';
$hesklang['piping_notify_rejected_customers1']='Письма об отклонении клиентов';
$hesklang['piping_notify_rejected_customers2']='Отправить письмо об отклонении клиентам, когда их запрос отклонен';
$hesklang['piping_notify_rejected_customers3']='Время между письмами об отклонении';
$hesklang['register_url']='URL регистрации';
$hesklang['email_subject']='Тема письма';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Участие в заявке: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Ответ сотрудника в заявке: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Добавлена заметка к заявке: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Просроченная заявка: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Заявка решена: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Дата отсечки для последующих писем:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Не отправлять письма по заявкам, решенным более чем'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='назад (должен быть более длительный период, чем "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='Период отсечки писем должен быть больше задержки последующего письма';
$hesklang['available_language']='Доступные языки';
$hesklang['click_to_show_available_language']='Нажмите для отображения доступных языков';
$hesklang['install_lan']='Установить';
$hesklang['remove_lan']='Удалить';
$hesklang['title_lan']='Название';
$hesklang['description_lan']='Описание';
$hesklang['completed_lan']='Завершено';
$hesklang['no_language_availble']='Нет доступных языков';
$hesklang['success_install_lan_txt']='Язык успешно добавлен';
$hesklang['error_install_lan_txt']='Язык не был добавлен';
$hesklang['success_remove_lan_txt']='Язык успешно удален';
$hesklang['error_remove_lan_txt']='Язык не был удален';
$hesklang['remove_default_language_error']='Язык по умолчанию должен оставаться активным и не может быть удален';
$hesklang['click_for_manual_step']='Нажмите для ручной установки';
$hesklang['upgrade_lan']='Обновить';
$hesklang['success_upgrade_lan_txt']='Язык успешно обновлен';
$hesklang['error_upgrade_lan_txt']='Язык не был обновлен';
$hesklang['please_wait']='Пожалуйста, подождите...';
$hesklang['add_a_note']='Добавить заметку';
$hesklang['add_a_reply']='Добавить ответ';
$hesklang['customer_id']='ID клиента';
$hesklang['deleting_customer_tickets']='Заявки, открытые клиентом: <b>%1$s</b><br>Что делать с этими заявками?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Заявки, где клиент указан в копии: <b>%1$s</b><br>Клиент будет удален из списка наблюдателей; заявки останутся без изменений.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Полностью удалить заявки';
$hesklang['deleting_customer_anonymize_tickets2']='Анонимизировать заявки (удалить сообщения и персональные данные)';
$hesklang['deleting_customer_retain_tickets2']='Оставить заявки (данные останутся без изменений)';
$hesklang['for_staff']='для сотрудников службы поддержки'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='для клиентов'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='Почтовый ящик IMAP';
$hesklang['file_attachment_options']='Настройки вложений в письмах';
$hesklang['link_to_attachments_in_emails']='Ссылки на вложения в письмах';
$hesklang['add_attachments_directly_to_emails']='Добавлять вложения непосредственно в письма';
$hesklang['directly_attach_file_smaller_than']='Добавлять непосредственно только файлы меньше';
$hesklang['directly_attach_file_of_any_size']='Добавлять непосредственно файлы любого размера';
$hesklang['directly_attach_only_first_x_attachments']='Добавлять непосредственно только первые';
$hesklang['directly_attach_all_attachments']='Добавлять непосредственно все вложения';
$hesklang['directly_attach_size']='Размер вложения';
$hesklang['directly_attach_no_of_files']='Количество файлов';
$hesklang['notice_about_directly_attach_files']='Добавление множества или больших файлов в письма может вызвать задержки при взаимодействии с SMTP-сервером';
$hesklang['fatt_2']='Дополнительные файлы, прикрепленные к этому сообщению:';
$hesklang['no_collaborators']='Нет';
$hesklang['collaborate']='Участвовать в этой заявке';
$hesklang['collaborators']='Участники';
$hesklang['ql_cbm']='Участник';
$hesklang['collaborating']='Теперь вы участвуете в этой заявке';
$hesklang['not_collaborating']='Вы больше не участвуете в этой заявке';
$hesklang['add_collaborator']='Добавить участника';
$hesklang['user_collaborator_added']='Пользователь добавлен как участник этой заявки';
$hesklang['remove_collaborator']='Удалить участника';
$hesklang['staff_name']='Имя сотрудника';
$hesklang['user_collaborator_removed']='Пользователь удален из участников этой заявки';
$hesklang['desc_collaborator_added']='(Сотрудник) Вы участвуете в новой заявке';
$hesklang['desc_collaborator_staff_reply']='(Сотрудник) Сотрудник ответил в заявке, где вы участник';
$hesklang['desc_collaborator_note']='(Сотрудник) Добавлена заметка в заявке, где вы участник';
$hesklang['desc_collaborator_resolved']='(Сотрудник) Заявка, где вы участник, решена';
$hesklang['desc_collaborator_overdue']='(Сотрудник) Заявка, где вы участник, просрочена';
$hesklang['notify_collaborator_added']='Меня добавили как участника заявки';
$hesklang['notify_collaborator_customer_reply']='Клиент ответил в заявке, где вы участник';
$hesklang['notify_collaborator_staff_reply']='Сотрудник ответил в заявке, где вы участник';
$hesklang['notify_collaborator_note']='Сотрудник добавил заметку в заявке, где вы участник';
$hesklang['notify_collaborator_resolved']='Сотрудник решил заявку, где вы участник';
$hesklang['notify_collaborator_overdue']='Заявка, где вы участник, просрочена';
$hesklang['recurring_tickets']['tab']='Повторяющиеся заявки'; // Menu link
$hesklang['recurring_tickets']['page_title']='Повторяющиеся заявки'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Автоматизируйте рутинную работу; позвольте Hesk создавать регулярные заявки за вас, именно тогда, когда это нужно.';
$hesklang['recurring_tickets']['active_rules']='Активные правила';
$hesklang['recurring_tickets']['new']='Новое правило для повторяющихся заявок';
$hesklang['recurring_tickets']['no_rules']='У вас нет правил для повторяющихся заявок. Создайте его, нажав кнопку "Новое правило для повторяющихся заявок" выше.';
$hesklang['recurring_tickets']['title']='Название правила';
$hesklang['recurring_tickets']['titlet']='Описательное название, например: Переназначение заявок без ответа в течение дня';
$hesklang['recurring_tickets']['default_title']='Правило от %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Условие срабатывания правила';
$hesklang['recurring_tickets']['trigt']='Установите условие, которое будет активировать (запускать) это правило.';
$hesklang['recurring_tickets']['hits']='Срабатывания'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Время создания'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Основные настройки'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Пользовательские поля'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Содержание'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Удалить это правило?';
$hesklang['recurring_tickets']['edit']='Редактирование правила для повторяющихся заявок ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='В течение:';
$hesklang['recurring_tickets']['minutes']='минут';
$hesklang['recurring_tickets']['hours']='часов';
$hesklang['recurring_tickets']['days']='дней';
$hesklang['recurring_tickets']['weeks']='недель';
$hesklang['recurring_tickets']['months']='месяцев';
$hesklang['recurring_tickets']['years']='лет';
$hesklang['recurring_tickets']['setpri']='Установить приоритет:';
$hesklang['recurring_tickets']['setsta']='Установить статус:';
$hesklang['recurring_tickets']['assto']='Назначить заявку:';
$hesklang['recurring_tickets']['asm']='Другому сотруднику';
$hesklang['recurring_tickets']['notify']='Уведомить сотрудников...';
$hesklang['recurring_tickets']['ato']='Применить к:';
$hesklang['recurring_tickets']['save']='Сохранить правило';
$hesklang['recurring_tickets']['e_tt']='Время должно быть от 1 до 10000';
$hesklang['recurring_tickets']['nocat']='Выберите хотя бы одну категорию';
$hesklang['recurring_tickets']['nouser']='Выберите хотя бы одного пользователя';
$hesklang['recurring_tickets']['nostatus']='Выберите хотя бы один статус';
$hesklang['recurring_tickets']['nocata']='%1$s не имеет доступа к этим категориям:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Новое правило создано';
$hesklang['recurring_tickets']['mdf']='Настройки правила сохранены';
$hesklang['recurring_tickets']['e_id']='Правило с таким ID не найдено';
$hesklang['recurring_tickets']['deleted']='Выбранное правило удалено';
$hesklang['recurring_tickets']['log_title']='Правило #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Активно'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Активировать это правило (начать использовать)';
$hesklang['recurring_tickets']['activated']='Выбранное правило активировано'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Деактивировать это правило (прекратить использование)';
$hesklang['recurring_tickets']['deactivated']='Выбранное правило деактивировано'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Нет активных правил для повторяющихся заявок';
$hesklang['recurring_tickets']['tools']='Инструменты';
$hesklang['recurring_tickets']['tbef']='Перед тем как правило станет активным, его нужно активировать, установив флажок в колонке "АКТИВНО".<br><br>
                               <strong>Активные правила обрабатываются каждые %2$s минут.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[ПРАВИЛО]';
$hesklang['recurring_tickets']['r2']='[ПРАВИЛО] Правило #%s';
$hesklang['recurring_tickets']['r3']='Правило #%s';
$hesklang['recurring_tickets']['i']='[ИНФО]';
$hesklang['recurring_tickets']['matched']='Количество заявок, созданных сегодня: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Сбросить это правило';
$hesklang['recurring_tickets']['reset2']='Вы уверены, что хотите сбросить это правило?<br><br>Количество срабатываний обнулится, и заявки, созданные сегодня, могут быть созданы повторно при следующем запуске cron.';
$hesklang['recurring_tickets']['reset3']='Выбранное правило сброшено';
$hesklang['recurring_tickets']['test']='Тестировать это правило';
$hesklang['recurring_tickets']['testa']='Тестировать все правила';
$hesklang['recurring_tickets']['testaa']='Тестировать все активные правила';
$hesklang['recurring_tickets']['testr']='Результаты тестирования';
$hesklang['recurring_tickets']['rsim']='Повторить тестирование';
$hesklang['recurring_tickets']['sim']='РЕЖИМ ТЕСТИРОВАНИЯ, изменения в базу данных не вносятся';
$hesklang['recurring_tickets']['sic']='ТЕСТИРОВАНИЕ ЗАВЕРШЕНО';
$hesklang['recurring_tickets']['rrule_type_required']='Выберите корректное условие срабатывания правила.';
$hesklang['recurring_tickets']['rrule_string_required']='Выберите все необходимые параметры условия срабатывания правила.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Введите значение интервала 1 или больше для параметра "Каждые".';
$hesklang['recurring_tickets']['disable_note']='*Если после создания правила были изменены критические настройки Hesk, правило будет отключено при следующей попытке запуска и потребует редактирования для соответствия новым требованиям.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | создано Правилом повторяющихся заявок "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | назначено на %2$s Правилом повторяющихся заявок "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | автоматически закрыто Правилом повторяющихся заявок "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | статус изменен на %2$s Правилом повторяющихся заявок "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | автоматически назначено на %2$s Правилом повторяющихся заявок "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Правило было отключено из-за ошибок валидации. Проверьте детали ниже.';
$hesklang['recurring_tickets']['errors_title']='Одно или несколько ваших правил вызвали ошибки при попытке выполнения и были отключены.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Ошибки правила #%s:';
$hesklang['recurring_tickets']['create_customers']='Нет существующих клиентов - создайте их <a href="%s" target="_blank">здесь</a>.';
$hesklang['recurring_tickets']['exec_dates']='Даты выполнения правила';
$hesklang['recurring_tickets']['show_exec_dates']='[Показать даты выполнения текущего правила]';
$hesklang['recurring_tickets']['no_exec_dates']='Выберите корректные условия срабатывания правила для отображения дат выполнения.';
$hesklang['recurring_tickets']['invalid_disabled']='некорректные настройки Rrule - правило отключено.';
$hesklang['recurring_tickets']['next_occ']='Следующие %s выполнения правила:';
$hesklang['recurring_tickets']['occ_on']='%s';
$hesklang['recurring_tickets']['not_firing_today']='не требует выполнения сегодня.';
$hesklang['recurring_tickets']['rules_fulfilled']='условия повторяющегося правила выполнены - заявка создана сегодня!';
$hesklang['recurring_tickets']['validation_failed']='валидация не пройдена - правило отключено. Подробности ниже:';
$hesklang['recurring_tickets']['validation_error']='Ошибка валидации:';
$hesklang['recurring_tickets']['processed']='обработано.';
$hesklang['recurring_tickets']['created_ticket']='создана заявка id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='относительно даты создания заявки';
$hesklang['priorities']='Приоритеты';
$hesklang['priority_intro']='Используйте этот инструмент для управления приоритетами заявок в вашей службе поддержки';
$hesklang['new_priority']='Новый приоритет';
$hesklang['edit_priority']='Редактировать приоритет';
$hesklang['priority_title']='Название';
$hesklang['can_customers_select_it']='Могут ли клиенты выбирать этот приоритет?';
$hesklang['selected_by_customer']='Доступен для выбора клиентами';
$hesklang['err_priority']='Введите название приоритета';
$hesklang['priority_added']='Добавлен новый приоритет';
$hesklang['priority_e_id']='Некорректный ID приоритета';
$hesklang['priority_mdf']='Приоритет сохранен';
$hesklang['priority_deleted']='Приоритет удален';
$hesklang['priority_not_found']='Этот приоритет не существует';
$hesklang['priority_not_empty']='Этот приоритет нельзя удалить, так как существуют заявки с этим приоритетом';
$hesklang['click_to_enable_drag_drop']='Нажмите для включения перетаскивания строки, затем переместите строку вверх или вниз для изменения порядка приоритетов.';
$hesklang['confirm_delete_priority']='Вы уверены, что хотите удалить этот приоритет?';
$hesklang['reordered_message']='Порядок приоритетов сохранен.';
$hesklang['list_tkt_priority']='Показать все заявки с этим приоритетом';
$hesklang['deletion_priority_restricted']='Это специальный приоритет, который нельзя удалить';
$hesklang['priority_limit']='Вы не можете создать новые приоритеты';
$hesklang['skip_to_main_content']='Перейти к основному содержимому';
$hesklang['opens_dialog']='Открывает диалоговое окно';
$hesklang['create_a_ticket']='Создать заявку';
$hesklang['toggle_navigation']='Переключить навигацию';
$hesklang['add_a_ticket_reply']='Добавить ответ к заявке';
$hesklang['linked_tickets']='Связанные заявки';
$hesklang['no_linked_tickets']='Нет связанных заявок';
$hesklang['link_ticket']='Связать заявку';
$hesklang['can_link_tickets_e']='У вас нет прав для связывания/разрыва связи этой заявки';
$hesklang['link_ticket_success']='Заявки успешно связаны';
$hesklang['link_ticket_required_error']='Для связывания заявки укажите корректный Tracking ID';
$hesklang['link_ticket_itself_error']='Заявка не может быть связана сама с собой. Укажите другой Tracking ID';
$hesklang['already_linked_error']='Заявки уже связаны';
$hesklang['unlink_success']='Связь между заявками успешно удалена';
$hesklang['unlink_error']='Нет связанных записей';
$hesklang['link_history']='<li class="smaller">%s | %s связь заявки создана %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s связь заявки удалена %s</li>';
$hesklang['can_link_tickets']='Может связывать заявки';
$hesklang['link_a_ticket']='Связать заявку';
$hesklang['mfa_curl']='Невозможно сгенерировать QR-код для сканирования, так как поддержка <strong>cURL</strong> не включена на вашем сервере.';
$hesklang['require_xml']='Для сообщений в формате Rich Text (HTML) должен быть включен PHP-XML. Обратитесь к вашему хостинг-провайдеру для включения XML в PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s добавлен как участник %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s удален как участник %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Идеально для планового технического обслуживания, ежемесячных проверок доступа, регулярных проверок клиентов и многого другого.';
$hesklang['recurring_tickets']['feat1']='<strong>Настройте и забудьте.</strong> Ежедневно, каждый понедельник, каждый март, 15-е число каждого месяца или любую другую будущую дату';
$hesklang['recurring_tickets']['feat2']='<strong>Поступают предзаполненными и назначенными.</strong> Выберите категорию, приоритет, ответственного и до 100 значений пользовательских полей';
$hesklang['recurring_tickets']['feat3']='<strong>Предпросмотр дат и тестирование.</strong> Увидьте каждую заявку, которую создаст Hesk, перед активацией правила, чтобы избежать неожиданностей.';
$hesklang['unlink_btn']='Отвязать';

// Added in version 3.7.0

// IMPORTANT! The in-bracket values in recurring_tickets strings (for example, [freq_hidden] and [bymonthday]) below get filled dynamically in JS with data - do NOT translate inside brackets!!!
$hesklang['recurring_tickets']['first']='первый';
$hesklang['recurring_tickets']['second']='второй';
$hesklang['recurring_tickets']['third']='третий';
$hesklang['recurring_tickets']['fourth']='четвёртый';
$hesklang['recurring_tickets']['fifth']='пятый';
$hesklang['recurring_tickets']['rt1_txt']='Каждый [X] день недели';
$hesklang['recurring_tickets']['rt1_ui']='[freq_hidden]Каждый [byweekday]';
$hesklang['recurring_tickets']['rt2_txt']='Каждый [X] день месяца';
$hesklang['recurring_tickets']['rt2_ui']='[freq_hidden]Каждый [bymonthday]-й день месяца';
$hesklang['recurring_tickets']['rt3_txt']='Каждую [X] дату года';
$hesklang['recurring_tickets']['rt3_ui']='[freq_hidden]Каждая [bymonthday][bymonth] дата года';
$hesklang['recurring_tickets']['rt4_txt']='Каждый [nth] [день недели] месяца';
$hesklang['recurring_tickets']['rt4_ui']='[freq_hidden]Каждый [bysetpos] [byweekday] месяца';
$hesklang['recurring_tickets']['rt5_txt']='Каждые [x] [дней/недель/месяцев]';
$hesklang['recurring_tickets']['rt5_ui']='Каждые [interval] [freq] [dtstart_row]';
$hesklang['recurring_tickets']['rt6_txt']='В определённую дату';
$hesklang['recurring_tickets']['rt6_ui']='[freq_hidden]В [dtstart]';


$hesklang['nickname']='Псевдоним';
$hesklang['nicknames']='Псевдонимы';
$hesklang['staff_nicknames']='Разрешить сотрудникам указывать псевдоним, который будет отображаться клиентам вместо их настоящего имени';
$hesklang['what_cust_see']='Это имя будут видеть клиенты. Если поле оставить пустым, будет показано настоящее имя.';
$hesklang['login_credentials']='Учётные данные для входа';
$hesklang['change_pass_info']='Чтобы изменить пароль, используйте кнопку «Изменить пароль» на странице вашего профиля';
$hesklang['email_column_display']='Отображение колонки электронной почты';
$hesklang['email_show_view']='Показывать ссылку «Просмотреть»';
$hesklang['email_show_full']='Показывать полный адрес электронной почты';
$hesklang['customer_theme']='Тема оформления для клиентов';
$hesklang['err_customer_theme']='Выберите корректную тему оформления для клиентов';
$hesklang['rebuild_assets']='Пересобрать ресурсы';
$hesklang['rebuild_assets_btn']='Пересобрать production-ресурсы';
$hesklang['rebuild_assets_success']='Production-ресурсы успешно пересобраны.';
$hesklang['rebuild_again']='Пересобрать снова';
$hesklang['rebuilt_assets']='Ресурсы собраны и минифицированы:';
$hesklang['tab_8']='Внешний вид';
$hesklang['laf']='Внешний вид';
$hesklang['theme_name_default']='Ocean Blue (по умолчанию)';
$hesklang['theme_name_midnight_ocean']='Midnight Ocean (тёмная)';
$hesklang['theme_name_modern_light']='Modern Light';
$hesklang['theme_colors_note']='Большинство цветов темы автоматически генерируются на основе ваших основных фирменных цветов. Это помогает поддерживать согласованность дизайна и экономит ваше время.<br><br>Автоматически сгенерированные цвета помечены звёздочкой (<span class="asterix"></span>) и находятся в разделе «Расширенные настройки». При изменении основного фирменного цвета все связанные с ним цвета также изменятся, если вы не переопределили их вручную.';
$hesklang['theme_changed_note']='У вас есть существующие переопределения цветов темы, которые могут некорректно отображаться в новой выбранной теме. Возможно, стоит сбросить их, нажав кнопку «Сбросить все переопределения».';
$hesklang['theme_overrides']='Переопределения цветов темы';
$hesklang['reset_all_overrides']='Сбросить все переопределения';
$hesklang['view_advanced']='Показать расширенные настройки';
$hesklang['view_basic']='Вернуться к базовым настройкам';
$hesklang['invalid_theme_setting']='Передан недопустимый ключ настройки: «%s».';
$hesklang['invalid_hex_color']='Передан недопустимый HEX-цвет «%s» для ключа %s.';
$hesklang['theme_var--yellow-1']='Жёлтый (основной)';
$hesklang['theme_var--yellow-2']='Жёлтый (второстепенный)';
$hesklang['theme_var--green-1']='Зелёный';
$hesklang['theme_var--red-1']='Красный (основной)';
$hesklang['theme_var--red-2']='Красный (второстепенный)';
$hesklang['theme_var--success']='Цвет успешного действия';
$hesklang['theme_var--success-2']='Успешный (второстепенный)';
$hesklang['theme_var--error']='Цвет ошибки';
$hesklang['theme_var--error-2']='Ошибка (второстепенная)';
$hesklang['theme_var--error-3']='Ошибка (третичная)';
$hesklang['theme_var--warning']='Цвет предупреждения';
$hesklang['theme_var--warning-2']='Предупреждение (второстепенное)';
$hesklang['theme_var--info']='Цвет информационного сообщения';
$hesklang['theme_var--info-2']='Информация (второстепенная)';
$hesklang['theme_var--info-3']='Информация (третичная)';
$hesklang['theme_var--notification__clr']='Цвет текста уведомлений';
$hesklang['theme_var--primary']='Основной цвет';
$hesklang['theme_var--secondary']='Второстепенный цвет';
$hesklang['theme_var--tertiary']='Третичный цвет';
$hesklang['theme_var--surface']='Цвет поверхности';
$hesklang['theme_var--main-background']='Основной фон';
$hesklang['theme_var--font__pri-clr']='Основной цвет шрифта';
$hesklang['theme_var--font__sec-clr']='Второстепенный цвет шрифта';
$hesklang['theme_var--header_logo__clr']='Фон логотипа в шапке';
$hesklang['theme_var--header__bg']='Фон шапки';
$hesklang['theme_var--header_nav__clr']='Цвет навигации в шапке';
$hesklang['theme_var--header_nav__hover_clr']='Цвет навигации при наведении в шапке';
$hesklang['theme_var--header_links__clr']='Цвет ссылок в шапке';
$hesklang['theme_var--input-bg']='Фон поля ввода';
$hesklang['theme_var--input-clr']='Цвет текста в поле ввода';
$hesklang['theme_var--link__pri-clr']='Основной цвет ссылки';
$hesklang['theme_var--link__pri-hover-clr']='Цвет основной ссылки при наведении';
$hesklang['theme_var--link__sec-clr']='Второстепенный цвет ссылки';
$hesklang['theme_var--link__sec-hover-clr']='Цвет второстепенной ссылки при наведении';
$hesklang['theme_var--footer__link-clr']='Цвет ссылки в подвале';
$hesklang['theme_var--radio__bg']='Фон радиокнопки';
$hesklang['theme_var--radio__fill-clr']='Цвет заполнения радиокнопки';
$hesklang['theme_var--radio__hover-bg']='Фон радиокнопки при наведении';
$hesklang['theme_var--radio__hover-fill-clr']='Цвет заполнения радиокнопки при наведении';
$hesklang['theme_var--checkbox__bg']='Фон флажка';
$hesklang['theme_var--checkbox__hover-bg']='Фон флажка при наведении';
$hesklang['theme_var--preview__bg']='Фон превью статьи';
$hesklang['theme_var--preview__border-clr']='Цвет границы превью статьи';
$hesklang['theme_var--preview__hover-bg']='Фон превью статьи при наведении';
$hesklang['theme_var--preview__hover-icon-fill']='Цвет значка при наведении на превью статьи';
$hesklang['theme_var--preview__title-clr']='Цвет заголовка превью статьи';
$hesklang['theme_var--suggest_preview__bg']='Фон предложения статьи';
$hesklang['theme_var--suggest_preview__clr']='Цвет текста предложения статьи';
$hesklang['theme_var--suggest_preview__border-clr']='Цвет границы предложения статьи';
$hesklang['theme_var--suggest_preview__hover-bg']='Фон предложения статьи при наведении';
$hesklang['theme_var--suggest_preview__hover-icon-fill']='Цвет значка при наведении на предложение статьи';
$hesklang['theme_var--suggest_preview__title-clr']='Цвет заголовка предложения статьи';
$hesklang['theme_var--article_preview__hover-clr']='Цвет текста предложения статьи при наведении';
$hesklang['theme_var--article_preview_suggestion_clr']='Цвет текста предложения статьи';
$hesklang['theme_var--ticket_body__bg']='Фон тела заявки';
$hesklang['theme_var--ticket_response__bg']='Фон ответа в заявке';
$hesklang['theme_var--table_row__bg']='Фон строки таблицы';
$hesklang['theme_var--table_row__bg-even']='Фон чётной строки таблицы';
$hesklang['theme_var--table_row__bg-hover']='Фон строки таблицы при наведении';
$hesklang['theme_var--breadcrumbs__a-clr']='Цвет ссылки в навигационной цепочке';
$hesklang['theme_var--breadcrumbs__a-hover-clr']='Цвет ссылки в навигационной цепочке при наведении';
$hesklang['theme_var--header_profile__clr']='Цвет меню профиля';
$hesklang['theme_var--header_profile__menu-bg']='Фон меню профиля';
$hesklang['theme_var--header_profile__user-avatar-bg']='Фон аватара в меню профиля';
$hesklang['theme_var--header_profile__mobile-user-avatar-bg']='Фон аватара в меню профиля (мобильная версия)';
$hesklang['theme_var--navlink__bg']='Фон блока навигации';
$hesklang['theme_var--navlink__clr']='Цвет текста блока навигации';
$hesklang['theme_var--navlink__hover-bg']='Фон блока навигации при наведении';
$hesklang['theme_var--navlink__title-clr']='Цвет заголовка блока навигации';
$hesklang['theme_var--step_bar__item-clr']='Цвет элемента пошаговой индикации';
$hesklang['theme_var--search__clr']='Цвет поиска';
$hesklang['theme_var--search__bg']='Фон поиска';
$hesklang['theme_var--search__title-clr']='Цвет заголовка поиска';
$hesklang['theme_var--search__input-placeholder-clr']='Цвет placeholder’а в поле поиска';
$hesklang['theme_var--search__icon-fill']='Цвет заливки значка поиска';
$hesklang['theme_var--search__input-bg']='Фон поля ввода поиска';
$hesklang['theme_var--modal_body__bg']='Фон тела модального окна';
$hesklang['theme_var--btn__bg-clr-pri']='Фон основной кнопки';
$hesklang['theme_var--btn__clr-pri']='Цвет текста основной кнопки';
$hesklang['theme_var--btn__border-clr-pri']='Цвет границы основной кнопки';
$hesklang['theme_var--btn__disabled-bg-clr']='Фон неактивной кнопки';
$hesklang['theme_var--btn__disabled-clr']='Цвет текста неактивной кнопки';
$hesklang['theme_var--dropdown__bg']='Фон выпадающего списка';
$hesklang['theme_var--dropdown__clr']='Цвет текста выпадающего списка';
$hesklang['theme_var--dropdown__border-clr']='Цвет границы выпадающего списка';
$hesklang['theme_var--dropdown_ver1__border-clr']='Цвет границы выпадающего списка (версия 1)';
$hesklang['theme_var--dropdown_ver2__border-clr']='Цвет границы выпадающего списка (версия 2)';
$hesklang['theme_var--dropdown__hover-bg']='Фон выпадающего списка при наведении';
$hesklang['theme_var--dropdown__hover-clr']='Цвет текста выпадающего списка при наведении';
$hesklang['theme_var--dropdown__hover-border-clr']='Цвет границы выпадающего списка при наведении';
$hesklang['theme_var--dropdown_ver2__hover-border-clr']='Цвет границы выпадающего списка (версия 2) при наведении';
$hesklang['theme_var--datepicker_btn__bg']='Фон кнопки выбора даты';
$hesklang['theme_var--datepicker_btn__clr']='Цвет текста кнопки выбора даты';
$hesklang['theme_var--datepicker__bg']='Фон календаря выбора даты';
$hesklang['theme_var--datepicker__clr']='Цвет текста календаря выбора даты';
$hesklang['theme_group_main_brand']='Основные фирменные цвета';
$hesklang['theme_group_main_elements']='Основные элементы';
$hesklang['theme_group_buttons']='Кнопки';
$hesklang['theme_group_navigation']='Навигация';
$hesklang['theme_group_dropdowns']='Выпадающие списки';
$hesklang['theme_group_datepickers']='Календари выбора даты';
$hesklang['theme_group_base_colors']='Базовые цвета';
$hesklang['theme_group_notifications']='Уведомления';
$hesklang['theme_group_search']='Поиск';
$hesklang['theme_group_article_previews']='Превью статей';
$hesklang['theme_group_misc']='Прочее';
$hesklang['customer_email_exists_already_registered']='Зарегистрированный клиент с таким адресом электронной почты уже существует.';
$hesklang['link_id']='Номер заявки или идентификатор отслеживания'; // Ticket numerical ID or tracking ID
$hesklang['can_man_permission_groups']='Может управлять группами прав доступа';
$hesklang['permission_groups_title']='Группы прав доступа';
$hesklang['permission_groups_intro']='Группы прав доступа позволяют легко назначать права доступа к системе поддержки сразу нескольким пользователям.';
$hesklang['permission_groups_new']='Новая группа прав доступа';
$hesklang['permission_groups_name']='Название';
$hesklang['permission_groups_staff_count']='Количество сотрудников';
$hesklang['permission_groups_copy']='Копировать группу прав доступа';
$hesklang['permission_groups_none']='В базе данных пока нет ни одной группы прав доступа. Создайте первую, нажав кнопку «Новая группа прав доступа» выше.';
$hesklang['permission_groups_delete_not_allowed']='Эту группу прав доступа нельзя удалить, так как ей назначены сотрудники';
$hesklang['permission_groups_delete_confirm']='Вы уверены, что хотите удалить эту группу прав доступа?';
$hesklang['permission_groups_create_title']='Добавить новую группу прав доступа';
$hesklang['permission_groups_create_general_info']='Общая информация';
$hesklang['permission_groups_create_users_none']='Все сотрудники службы поддержки являются администраторами и не нуждаются в добавлении в группу прав доступа.';
$hesklang['permission_groups_create_submit']='Создать группу прав доступа';
$hesklang['permission_groups_create_success']='Группа прав доступа «%s» успешно создана'; // %s = permission group name
$hesklang['permission_groups_edit_title']='Редактировать группу прав доступа';
$hesklang['permission_groups_edit_success']='Группа прав доступа успешно обновлена';
$hesklang['permission_groups_error_duplicate']='Группа прав доступа с названием «%s» уже существует'; // %s = permission group name
$hesklang['permission_groups_error_permissions']='Не удалось обновить группу прав доступа из-за проблем с правами.';
$hesklang['permission_groups_error_name']='Введите название группы прав доступа';
$hesklang['permission_groups_error_missing_category_feature']='Необходимо выбрать хотя бы одну категорию или функцию';
$hesklang['permission_groups_deleted']='Группа прав доступа удалена';
$hesklang['edit_user_notice_with_permission_groups']='Этот пользователь получает доступ к категориям или функциям через группу прав доступа. Чтобы отозвать доступ к этим категориям или функциям, удалите его из соответствующей группы прав доступа.';
$hesklang['link_selected_tickets']='Связать выбранные заявки';
$hesklang['at_least_two_more']='Для создания связи необходимо выбрать как минимум две заявки.';
$hesklang['selected_link_success']='Связывание выбранных заявок успешно выполнено.<br><br>Новых связей создано: %s<br>Существующих связей проигнорировано: %s';
$hesklang['confirm_ordering_title']='Подтвердите автоматические изменения';
$hesklang['order_cat_by_name']='Сортировать категории по названию';
$hesklang['warning_order_cat_by_name']='Вы уверены, что хотите отсортировать категории по названию? Это действие невозможно автоматически отменить!';
$hesklang['success_order_cat_by_name']='Категории успешно отсортированы по названию.';
$hesklang['order_cat_by_id']='Сортировать категории по ID';
$hesklang['warning_order_cat_by_id']='Вы уверены, что хотите отсортировать категории по ID? Это действие невозможно автоматически отменить!';
$hesklang['success_order_cat_by_id']='Категории успешно отсортированы по ID.';
$hesklang['download_selected']='Скачать выбранные';
$hesklang['delete_selected']='Удалить выбранные';
$hesklang['attach_delete_db']='Выбранные вложения успешно удалены из базы данных';
$hesklang['mute_emails']='Отключить отправку писем';
$hesklang['mute_email_intro']='Когда адрес электронной почты отключён от рассылки, пользователь может продолжать подавать заявки и взаимодействовать с системой как обычно. Однако исходящие письма на этот адрес отправляться не будут.';
$hesklang['mute_an_email']='Введите адрес электронной почты для отключения рассылки';
$hesklang['save_mute_email']='Отключить рассылку на этот адрес';
$hesklang['muted_by']='Отключено пользователем';
$hesklang['no_mute_emails']='Нет отключённых от рассылки адресов электронной почты.';
$hesklang['enter_mute_email']='Введите адрес электронной почты, который вы хотите отключить от рассылки.';
$hesklang['valid_mute_email']='Введите корректный адрес электронной почты (<i>john.doe@example.com</i>) или домен электронной почты (<i>@example.com</i>)';
$hesklang['email_muted']='Адрес электронной почты <i>%s</i> отключён от рассылки. На этот адрес больше не будут отправляться письма.'; // %s will be replaced with email
$hesklang['email_mute_exists']='Адрес электронной почты <i>%s</i> уже отключён от рассылки.'; // %s will be replaced with email
$hesklang['email_unmuted']='Вы успешно включили рассылку на этот адрес';
$hesklang['del_mute_confirm']='Включить рассылку на этот адрес электронной почты?';
$hesklang['can_mute_emails']='Может отключать рассылку писем';
$hesklang['can_unmute_emails']='Может включать рассылку писем (включает возможность отключения рассылки)';
$hesklang['eis_mute']='Этот адрес электронной почты отключён от рассылки.';
$hesklang['click_unmute']='Нажмите здесь, чтобы включить рассылку.';
$hesklang['del_mute']='Включить рассылку';
$hesklang['unmute_email']='Включить рассылку на этот адрес';
$hesklang['can_merge_customers']='Объединять клиентов (требуется право «Управлять клиентами»)';
$hesklang['merge_selected_customers']='Объединить выбранных клиентов';
$hesklang['customer_merge_complete']='Выбранные учётные записи клиентов успешно объединены.';
$hesklang['merge_more_error']='Для продолжения объединения выберите двух или более клиентов.';
$hesklang['merge_target_error']='Целевой клиент не найден.';
$hesklang['merge_customer_err']='При объединении клиентов возникла проблема:';
$hesklang['error_msg_for_approved']='Некоторые из выбранных клиентов уже подтверждены, дальнейшая обработка не требуется.';
$hesklang['confirm_merge']='Подтвердите объединение учётных записей';
$hesklang['confirm_merge_text']='Вы уверены, что хотите объединить выбранных клиентов?';
$hesklang['confirm_merge_additional_text']='Объединение объединит выбранные учётные записи клиентов в одну. После объединения это действие невозможно отменить.';
$hesklang['customers_pending_approval']='Регистрации клиентов, ожидающие подтверждения';
$hesklang['existing_customers']='Существующие клиенты';
$hesklang['cant_deactivate_admin']='Вы не можете деактивировать учётную запись администратора по умолчанию!';
$hesklang['cant_deactivate_own']='Вы не можете деактивировать учётную запись, под которой вошли в систему!';
$hesklang['deactivated_users']='Деактивированные пользователи';
$hesklang['deactivate_user']='Деактивировать пользователя';
$hesklang['activate_user']='Активировать пользователя';
$hesklang['user_deactivated']='Выбранный пользователь деактивирован';
$hesklang['user_activated']='Выбранный пользователь активирован';
$hesklang['confirm_deactivation']='Подтвердите деактивацию';
$hesklang['sure_deactivate_user']='Вы уверены, что хотите деактивировать этого пользователя?';
$hesklang['deactivating_user_with_tickets']='Количество заявок, назначенных этому пользователю: %1$s<br>Количество <b>открытых</b> заявок, назначенных этому пользователю: %2$s<br><br><b>Открытые</b> заявки будут <b>отвязаны</b> после деактивации пользователя.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['fictl']='Поля в списке заявок — клиентская часть';
$hesklang['setting_extend']='Продлевать сессии';
$hesklang['extend_admin']='Автоматически продлевать сессии сотрудников';
$hesklang['extend_customer']='Автоматически продлевать сессии клиентов';
$hesklang['setting_process_to_cc']='Уведомлять подписчиков по электронной почте';
$hesklang['setting_process_to_cc_notice']='Для работы этой функции необходимо также включить «%s» на странице %s &gt; %s &gt; %s';
$hesklang['email_include_to']='Добавлять контакты из заголовка письма «Кому» в подписчики заявки';
$hesklang['email_include_cc']='Добавлять контакты из заголовка письма «Копия» в подписчики заявки';
$hesklang['purge_cache']='Очистить кэш';
$hesklang['purge_cache_btn']='Очистить весь кэш сейчас';
$hesklang['purge_cache_done']='Кэш успешно очищен';
$hesklang['customer_name_email_exists']='Клиент с таким именем и адресом электронной почты уже существует.';
$hesklang['no_cust_sel']='Клиент не выбран, нечего выполнять';
$hesklang['spam_inbox_notice']='<b>Не получили письмо с подтверждением?</b><br />Мы отправили сообщение с подтверждением на ваш адрес электронной почты. Если вы не получите его в течение нескольких минут, проверьте папки «Спам», «Нежелательная почта» или «Массовые рассылки». Отметьте сообщение как <b>«Не спам»</b>, чтобы избежать проблем с получением нашей корреспонденции в будущем.';
$hesklang['write_down_notice']='Рекомендуем записать номер вашей заявки для дальнейшего использования.';
$hesklang['theme_colors_note_co']='В настоящее время темы влияют только на публичные (клиентские) страницы службы поддержки.';
$hesklang['ticket_already_in_category']='Эта заявка уже находится в категории %s, изменения не внесены.';
$hesklang['ticket_already_priority']='Приоритет этой заявки уже установлен в значение %s, изменения не внесены.';
$hesklang['ticket_already_unassigned']='Эта заявка уже не назначена никому, изменения не внесены. ';
$hesklang['conok_but_no_count']='Подключение, похоже, работает, но мы не можем получить корректное количество писем. <a href="%s">Попробуйте это</a>.'; // %s = link to knowledgebase article
$hesklang['custom_html']='Пользовательский HTML';
$hesklang['custom_html_link']='Редактировать HTML шапки и подвала';
$hesklang['custom_head']='Пользовательский HEAD';
$hesklang['custom_head_desc']='Пользовательский HTML-код, который будет отображаться внутри тега head HTML-документа (файл head.txt).';
$hesklang['custom_head_cmnt']='Пользовательский код, включаемый перед закрывающим тегом &lt;/head&gt;'; // do NOT translate "&lt;/head&gt;"
$hesklang['custom_header']='Пользовательская шапка';
$hesklang['custom_header_desc']='Пользовательский HTML-код, который будет отображаться перед основным телом системы поддержки (файл header.txt). Например, вы можете добавить сюда <a href="%s" target="_blank">HTML-код своего логотипа</a>.'; // %s = URL to knowledgebase article
$hesklang['custom_header_cmnt']='Пользовательский код, включаемый сразу после открывающего тега &lt;body&gt;'; // do NOT translate "&lt;body&gt;"
$hesklang['custom_footer']='Пользовательский подвал';
$hesklang['custom_footer_desc']='Пользовательский HTML-код, который будет отображаться после основного тела системы поддержки (файл footer.txt).';
$hesklang['custom_footer_cmnt']='Пользовательский код, включаемый перед закрывающим тегом &lt;/body&gt;'; // do NOT translate "&lt;/body&gt;"
$hesklang['file_missing_not_writable']='Этот файл отсутствует или недоступен для записи: <b>%s</b><br><br>Установите корректные права доступа к файлу или отредактируйте его вручную. В Linux попробуйте установить CHMOD в значение 666 (rw-rw-rw-)'; // %s = file name
$hesklang['uanble_not_writable']='Невозможно сохранить изменения, так как требуемые файлы недоступны для записи PHP';
$hesklang['custom_html_saved']='Пользовательский HTML-код успешно сохранён';
$hesklang['custom_html_disabled']='Редактирование пользовательского HTML-кода через данный интерфейс отключено. Пожалуйста, редактируйте файлы head/header/footer вручную.';
$hesklang['search_by_category']='Найдите или выберите категорию...';
$hesklang['imap_test_bad']='Возможное решение описано в <a href="%s" target="_blank">этом руководстве базы знаний</a>.'; // %s = URL to knowledgebase article
$hesklang['first_reply_at']='Первый ответ в';
$hesklang['reply_messages']='Сообщения с ответами';
$hesklang['ex_replies']='Включать ответы по заявке в экспорт';
$hesklang['remember_custom_field_values']='Запоминать значения пользовательских полей';
$hesklang['disable_autocomplete']='Отключить автозаполнение';
$hesklang['disable_autofill_admin']='Добавить атрибут autocomplete="off" в форму «Подать заявку» для клиентов';
$hesklang['disable_autofill_customer']='Добавить атрибут autocomplete="off" в форму «Подать заявку» для сотрудников';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');