<?php
/**
 * @package    Joomla.Language
 *
 * @copyright  Copyright (C) 2005 - 2023 Open Source Matters, Inc. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\String\StringHelper;

defined('_JEXEC') or die;

/**
 * kk_KZ localise class
 *
 * @package        Joomla.Site
 * @since          1.6
 */
abstract class kk_KZLocalise
{
	/**
	 * Returns the potential suffixes for a specific number of items
	 *
	 * @param int $count The number of items.
	 *
	 * @return    array  An array of potential suffixes.
	 * @since    1.6
	 */
	public static function getPluralSuffixes($count)
	{
		if($count == 0)
		{
			return [ '0' ];
		}

		return [ ($count % 10 == 1 && $count % 100 != 11 ? '1' : ($count % 10 >= 2 && $count % 10 <= 4 && ($count % 100 < 10 || $count % 100 >= 20) ? '2' : 'MORE')) ];
	}

	/**
	 * @param $string
	 *
	 * @return mixed|null|string|string[]
	 */
	public static function transliterate($string)
	{
		switch(self::simple_detect_language($string))
		{
			case 'ru':
				$str         = StringHelper::strtolower($string);
				$glyph_array = [
					'a'       => 'а',
					'b'       => 'б',
					'v'       => 'в',
					'g'       => 'г,ғ',
					'd'       => 'д',
					'e'       => 'е,э',
					'jo'      => 'ё',
					'zh'      => 'ж',
					'z'       => 'з',
					'i'       => 'и,і',
					'ji'      => 'и',
					'j'       => 'й',
					'k'       => 'к',
					'l'       => 'л',
					'm'       => 'м',
					'n'       => 'н',
					'o'       => 'о',
					'p'       => 'п',
					'r'       => 'р',
					's'       => 'с',
					't'       => 'т',
					'u'       => 'у',
					'f'       => 'ф',
					'kh'      => 'х',
					'ts'      => 'ц',
					'ch'      => 'ч',
					'sh'      => 'ш',
					'shch'    => 'щ',
					''        => 'ъ,ь,—',
					'y'       => 'ы',
					'yu'      => 'ю',
					'ya'      => 'я',
					'uah'     => '₴',
					'eur'     => '€',
					'usd'     => '$',
					'protsen' => '%',
				];

				foreach($glyph_array as $letter => $glyphs)
				{
					$glyphs = explode(',', $glyphs);
					$str    = str_replace($glyphs, $letter, $str);
				}

				return preg_replace('#&\#?[a-z0-9]+;#ismu', '', $str);

				break;

			default:
			case 'kz':
				$trans = [
					'а' => 'a',
					'ә' => 'a',
					'б' => 'b',
					'в' => 'v',
					'г' => 'g',
					'ғ' => 'g',
					'д' => 'd',
					'е' => 'e',
					'ё' => 'e',
					'ж' => 'zh',
					'з' => 'z',
					'и' => 'y',
					'й' => 'i',
					'к' => 'k',
					'қ' => 'kh',
					'л' => 'l',
					'м' => 'm',
					'н' => 'n',
					'ң' => 'n',
					'о' => 'o',
					'ө' => 'o',
					'п' => 'p',
					'р' => 'r',
					'с' => 's',
					'т' => 't',
					'у' => 'u',
					'ұ' => 'u',
					'ү' => 'u',
					'ф' => 'f',
					'х' => 'kh',
					'һ' => 'kh',
					'ц' => 'ts',
					'ч' => 'ch',
					'ш' => 'sh',
					'щ' => 'shch',
					'Ъ'  => '',
					'ъ'  => '',
					'ы' => 'y',
					'і' => 'i',
					'ь'  => '',
					'Ь'  => '',
					'э' => 'e',
					'ю' => 'iu',
					'я' => 'ia',
					
					
					'!'  => '',
					'?'  => '',
					':'  => '',
					';'  => '',
					'’'  => '',
					"'"  => '',
					'—'  => '',
					'--' => '',
					'-'  => '',
					'.'  => '',

					'@' => '',
					'#' => '',
					'^' => '',
					'*' => '',
					'(' => '',
					')' => '',
					'_' => '',
					'=' => '',
					'+' => '',

					'₴' => 'uah',
					'€' => 'eur',
					'$' => 'usd',
					'%' => 'protsent',

					'à' => 'a',
					'ô' => 'o',
					'ď' => 'd',
					'ḟ' => 'f',
					'ë' => 'e',
					'š' => 's',
					'ơ' => 'o',
					'ß' => 'ss',
					'ă' => 'a',
					'ř' => 'r',
					'ț' => 't',
					'ň' => 'n',
					'ā' => 'a',
					'ķ' => 'k',
					'ŝ' => 's',
					'ỳ' => 'y',
					'ņ' => 'n',
					'ĺ' => 'l',
					'ħ' => 'h',
					'ṗ' => 'p',
					'ó' => 'o',
					'ú' => 'u',
					'ě' => 'e',
					'é' => 'e',
					'ç' => 'c',
					'ẁ' => 'w',
					'ċ' => 'c',
					'õ' => 'o',
					'ṡ' => 's',
					'ø' => 'o',
					'ģ' => 'g',
					'ŧ' => 't',
					'ș' => 's',
					'ė' => 'e',
					'ĉ' => 'c',
					'ś' => 's',
					'î' => 'i',
					'ű' => 'u',
					'ć' => 'c',
					'ę' => 'e',
					'ŵ' => 'w',
					'ṫ' => 't',
					'ū' => 'u',
					'č' => 'c',
					'ö' => 'oe',
					'è' => 'e',
					'ŷ' => 'y',
					'ą' => 'a',
					'ł' => 'l',
					'ų' => 'u',
					'ů' => 'u',
					'ş' => 's',
					'ğ' => 'g',
					'ļ' => 'l',
					'ƒ' => 'f',
					'ž' => 'z',
					'ẃ' => 'w',
					'ḃ' => 'b',
					'å' => 'a',
					'ì' => 'i',
					'ï' => 'i',
					'ḋ' => 'd',
					'ť' => 't',
					'ŗ' => 'r',
					'ä' => 'ae',
					'í' => 'i',
					'ŕ' => 'r',
					'ê' => 'e',
					'ü' => 'ue',
					'ò' => 'o',
					'ē' => 'e',
					'ñ' => 'n',
					'ń' => 'n',
					'ĥ' => 'h',
					'ĝ' => 'g',
					'đ' => 'd',
					'ĵ' => 'j',
					'ÿ' => 'y',
					'ũ' => 'u',
					'ŭ' => 'u',
					'ư' => 'u',
					'ţ' => 't',
					'ý' => 'y',
					'ő' => 'o',
					'â' => 'a',
					'ľ' => 'l',
					'ẅ' => 'w',
					'ż' => 'z',
					'ī' => 'i',
					'ã' => 'a',
					'ġ' => 'g',
					'ṁ' => 'm',
					'ō' => 'o',
					'ĩ' => 'i',
					'ù' => 'u',
					'į' => 'i',
					'ź' => 'z',
					'á' => 'a',
					'û' => 'u',
					'þ' => 'th',
					'ð' => 'dh',
					'æ' => 'ae',
					'µ' => 'u',
					'ĕ' => 'e',
					'œ' => 'oe',

					'А' => 'A',
					'Ә' => 'A',
					'Б' => 'B',
					'В' => 'V',
					'Г' => 'G',
					'Ғ' => 'G',
					'Д' => 'D',
					'Е' => 'E',
					'Ё' => 'E',
					'Ж' => 'Zh',
					'З' => 'Z',
					'И' => 'Y',
					'Й' => 'Y',
					'К' => 'K',
					'Қ' => 'Kh',
					'Л' => 'L',
					'М' => 'M',
					'Н' => 'N',
					'Ң' => 'N',
					'О' => 'O',
					'Ө' => 'O',
					'П' => 'P',
					'Р' => 'R',
					'С' => 'S',
					'Т' => 'T',
					'У' => 'U',
					'Ұ' => 'U',
					'Ү' => 'U',
					'Ф' => 'F',
					'Х' => 'Kh',
					'Һ' => 'H',
					'Ц' => 'Ts',
					'Ч' => 'Ch',
					'Ш' => 'Sh',
					'Щ' => 'Shch',
					'Ы' => 'Y',
					'І' => 'I',
					'Э' => 'E',
					'Ю' => 'Yu',
					'Я' => 'Ya',
					
					

					'À' => 'A',
					'Ô' => 'O',
					'Ď' => 'D',
					'Ḟ' => 'F',
					'Ë' => 'E',
					'Š' => 'S',
					'Ơ' => 'O',
					'Ă' => 'A',
					'Ř' => 'R',
					'Ț' => 'T',
					'Ň' => 'N',
					'Ā' => 'A',
					'Ķ' => 'K',
					'Ŝ' => 'S',
					'Ỳ' => 'Y',
					'Ņ' => 'N',
					'Ĺ' => 'L',
					'Ħ' => 'H',
					'Ṗ' => 'P',
					'Ó' => 'O',
					'Ú' => 'U',
					'Ě' => 'E',
					'É' => 'E',
					'Ç' => 'C',
					'Ẁ' => 'W',
					'Ċ' => 'C',
					'Õ' => 'O',
					'Ṡ' => 'S',
					'Ø' => 'O',
					'Ģ' => 'G',
					'Ŧ' => 'T',
					'Ș' => 'S',
					'Ė' => 'E',
					'Ĉ' => 'C',
					'Ś' => 'S',
					'Î' => 'I',
					'Ű' => 'U',
					'Ć' => 'C',
					'Ę' => 'E',
					'Ŵ' => 'W',
					'Ṫ' => 'T',
					'Ū' => 'U',
					'Č' => 'C',
					'Ö' => 'Oe',
					'È' => 'E',
					'Ŷ' => 'Y',
					'Ą' => 'A',
					'Ł' => 'L',
					'Ų' => 'U',
					'Ů' => 'U',
					'Ş' => 'S',
					'Ğ' => 'G',
					'Ļ' => 'L',
					'Ƒ' => 'F',
					'Ž' => 'Z',
					'Ẃ' => 'W',
					'Ḃ' => 'B',
					'Å' => 'A',
					'Ì' => 'I',
					'Ï' => 'I',
					'Ḋ' => 'D',
					'Ť' => 'T',
					'Ŗ' => 'R',
					'Ä' => 'Ae',
					'Í' => 'I',
					'Ŕ' => 'R',
					'Ê' => 'E',
					'Ü' => 'Ue',
					'Ò' => 'O',
					'Ē' => 'E',
					'Ñ' => 'N',
					'Ń' => 'N',
					'Ĥ' => 'H',
					'Ĝ' => 'G',
					'Đ' => 'D',
					'Ĵ' => 'J',
					'Ÿ' => 'Y',
					'Ũ' => 'U',
					'Ŭ' => 'U',
					'Ư' => 'U',
					'Ţ' => 'T',
					'Ý' => 'Y',
					'Ő' => 'O',
					'Â' => 'A',
					'Ľ' => 'L',
					'Ẅ' => 'W',
					'Ż' => 'Z',
					'Ī' => 'I',
					'Ã' => 'A',
					'Ġ' => 'G',
					'Ṁ' => 'M',
					'Ō' => 'O',
					'Ĩ' => 'I',
					'Ù' => 'U',
					'Į' => 'I',
					'Ź' => 'Z',
					'Á' => 'A',
					'Û' => 'U',
					'Þ' => 'Th',
					'Ð' => 'Dh',
					'Æ' => 'Ae',
					'Ĕ' => 'E',
					'Œ' => 'Oe'
				];

				if(preg_match('/[а-яА-Я]/u', $string))
				{
					return strtr($string, $trans);
				}

				return $string;

				break;
		}
	}

	/**
	 * @param $text
	 *
	 * @return int|null|string
	 */
	private static function simple_detect_language($text)
	{
		$detectLang = [
			'kz' => [
				
			],
			'ru' => [
				
			],
		];

		# Get chars presence index
		$langsDetected = [];
		foreach($detectLang as $langId => $nativeChars)
		{
			$langsDetected[ $langId ] = 0;
			foreach($nativeChars as $nativeChr)
			{
				if(preg_match("/$nativeChr/ui", $text))
				{
					$langsDetected[ $langId ] += 1 / count($nativeChars);
				}
			}
		}

		# Get the most preferred language for this text
		$lang         = null;
		$langIndexMax = 0;
		foreach($langsDetected as $langId => $index)
		{
			if($index > $langIndexMax)
			{
				$langIndexMax = $index;
				$lang         = $langId;
			}
		}

		return $lang;
	}

	/**
	 * Returns the ignored search words
	 *
	 * @return    array  An array of ignored search words.
	 * @since    1.6
	 */
	public static function getIgnoredSearchWords()
	{
		

		return $search_ignore;
	}

	/**
	 * Returns the lower length limit of search words
	 *
	 * @return    integer  The lower length limit of search words.
	 * @since    1.6
	 */
	public static function getLowerLimitSearchWord()
	{
		return 3;
	}

	/**
	 * Returns the upper length limit of search words
	 *
	 * @return    integer  The upper length limit of search words.
	 * @since    1.6
	 */
	public static function getUpperLimitSearchWord()
	{
		return 50;
	}

	/**
	 * Returns the number of chars to display when searching
	 *
	 * @return    integer  The number of chars to display when searching.
	 * @since    1.6
	 */
	public static function getSearchDisplayedCharactersNumber()
	{
		return 300;
	}
}