/**
 * plugin.js
 *
 * Copyright, Moxiecode Systems AB
 * Released under LGPL License.
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/** [1]
var dropletsvalues = [
{ text:'check-css', value:'check-css'},
{ text:'EditThisPage', value:'EditThisPage'},
{ text:'year', value:'year'},
{ text:'EmailFilter', value:'EmailFilter'},
{ text:'LoginBox', value:'LoginBox'},
{ text:'Lorem', value:'Lorem'},
{ text:'Aldus', value:'aldus' }
];
**/

tinymce.ScriptLoader.load(tinyMCE.baseURL + '/plugins/droplets/droplets.php');

tinymce.PluginManager.add('droplets', function(editor, url) {
	var win;
	
    // Add a button that opens a window
    editor.ui.registry.addButton('droplets', {
       /* text: 'Droplets', */
        icon: 'color-levels', // false // # this is a css identifier!
        image: tinyMCE.baseURL + "/plugins/droplets/img/droplets.png",
        tooltip: "Insert Droplet",
        
        onAction: function() {
            // Open window
           win= editor.windowManager.open({
                title: 'Droplets',
                //width: 400,
                //height: 300,
                body: {
                   // {type: 'textbox', name: 'title', label: 'Title'},
                   type: 'panel', 
                   items: [ {
                    	type: 'selectbox',
                    	name: 'dropletselect',
                    	label: 'select a Droplet',
                    	items: dropletsvalues, // siehe [1]
                    	onchange: function(e) {
                    	        
								var m = dropletsinfo.length;
								for(var i=0; i<m; i++) {
									if (dropletsinfo[i].text == e.control.value() ) {
										win.find('#info').html( dropletsinfo[i].comment );
										win.find('#desc').html( dropletsinfo[i].desc );
									}
								}
							}
					},
                    /*{
                    	type: 'htmlpanel',
                    	name: 'dropletattributes',
                    	label: 'Params',
                    	html: 'Params'
                    },*/
                    {
                    	type: 'textarea',
                    	name: 'desc',
                    	label: 'Description',
                    	multiline: true,
                    	disabled: true,
                    	// style: "color:#990000;height:50px;font-family:Verdana, sans-serif; font-size:12px;line-height:1.3em;",
                        placeholder: dropletsinfo[0].desc,
                        maximized: true 
                    },
                    {
                    	type: 'textarea',
                    	name: 'info',
                    	label: 'Information',
                    	multiline: true,
                    	disabled: true,
                    	// style: "color:#990000;height:100px;font-family:Verdana, sans-serif; font-size:12px;line-height:1.3em;",
                    	placeholder: dropletsinfo[0].comment, // first entry of the dropletsinfo
                        maximized: true
                    }
                    ]
                },
                // h1
            buttons: [
                {
                  type: 'cancel',
                  text: 'Close'
                },
                {
                  type: 'submit',
                  text: 'Ok',
                  primary: true
                }
            ],
                // h2
                onSubmit: function(api) {
                    var data = api.getData();
                    var temp_attrib = ""; // ((data.dropletattributes == "") || (data.dropletattributes=="undefined")) ? "" : "?"+data.dropletattributes;
                    // alert("call me!");
                    // Insert content when the window form is submitted
                    editor.insertContent(/*'Title: ' + */'[[' + data.dropletselect + temp_attrib + ']]');
                    api.close();
                },
                onChange (api, changeData)
                {
                    // alert("**** call here by select");
                    // console.log("change name: "+changeData.name); // es gibt nur "name"
                    if (changeData.name === 'dropletselect') 
                    {
                        var data = api.getData();
                        
                        // console.log( "E: "+data['dropletselect']);
                        // api.setData( { desc: data['dropletselect'] }); // this works!
                        var m = dropletsinfo.length;
                        for(var i=0; i<m; i++) {
                            if (dropletsinfo[i].text == data['dropletselect'] ) {
										api.setData( { desc: dropletsinfo[i].desc });
										api.setData( { info: dropletsinfo[i].comment });
                            }
                        }
                    }
                }
            });
        }
    });

    // Adds a menu item to the tools menu
    /*
    editor.addMenuItem('droplets', {
        text: 'Droplets',
        context: 'insert',
        onclick: function() {
            // Open window with a specific url
            editor.windowManager.open({
                title: 'Droplets',
                url: url+'/droplets.php',//'http://www.tinymce.com', // here the dialog
                width: 300,
                height: 300,
                buttons: [{
                    text: 'Close',
                    onclick: 'close'
                }]
            });
        }
    });
    */
});