﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['sk']={"application":"Rich Text Editor","editor":"Editor formátovaného textu","editorPanel":"Panel editora formátovaného textu","common":{"editorHelp":"Stlačením ALT 0 spustiť pomocníka","browseServer":"Prehliadať server","url":"URL","protocol":"Protokol","upload":"Odoslať","uploadSubmit":"Odoslať na server","image":"Obrázok","form":"Formulár","checkbox":"Zaškrtávacie pole","radio":"Prepínač","textField":"Textové pole","textarea":"Textová oblasť","hiddenField":"Skryté pole","button":"Tlačidlo","select":"Rozbaľovací zoznam","imageButton":"Obrázkové tlačidlo","notSet":"<nenastavené>","id":"Id","name":"Meno","langDir":"Orientácia jazyka","langDirLtr":"Zľava doprava (LTR)","langDirRtl":"Sprava doľava (RTL)","langCode":"Kód jazyka","longDescr":"Dlhý popis URL","cssClass":"Trieda štýlu","advisoryTitle":"Pomocný titulok","cssStyle":"Štýl","ok":"OK","cancel":"Zrušiť","close":"Zatvoriť","preview":"Náhľad","resize":"Zmeniť veľkosť","generalTab":"Hlavné","advancedTab":"Rozšírené","validateNumberFailed":"Hodnota nie je číslo.","confirmNewPage":"Prajete si načítat novú stránku? Všetky neuložené zmeny budú stratené. ","confirmCancel":"Niektore možnosti boli zmenené. Naozaj chcete zavrieť okno?","options":"Možnosti","target":"Cieľ","targetNew":"Nové okno (_blank)","targetTop":"Najvrchnejšie okno (_top)","targetSelf":"To isté okno (_self)","targetParent":"Rodičovské okno (_parent)","langDirLTR":"Zľava doprava (LTR)","langDirRTL":"Sprava doľava (RTL)","styles":"Štýl","cssClasses":"Triedy štýlu","width":"Šírka","height":"Výška","align":"Zarovnanie","left":"Vľavo","right":"Vpravo","center":"Na stred","justify":"Do bloku","alignLeft":"Zarovnať vľavo","alignRight":"Zarovnať vpravo","alignCenter":"Zarovnať na stred","alignTop":"Nahor","alignMiddle":"Na stred","alignBottom":"Dole","alignNone":"Žiadne","invalidValue":"Neplatná hodnota.","invalidHeight":"Výška musí byť číslo.","invalidWidth":"Šírka musí byť číslo.","invalidLength":"Hodnota uvedená v poli \"%1\" musí byť kladné číslo a s platnou mernou jednotkou (%2), alebo bez nej.","invalidCssLength":"Špecifikovaná hodnota pre pole \"%1\" musí byť kladné číslo s alebo bez platnej CSS mernej jednotky (px, %, in, cm, mm, em, ex, pt alebo pc).","invalidHtmlLength":"Špecifikovaná hodnota pre pole \"%1\" musí byť kladné číslo s alebo bez platnej HTML mernej jednotky (px alebo %).","invalidInlineStyle":"Zadaná hodnota pre inline štýl musí pozostávať s jedného, alebo viac dvojíc formátu \"názov: hodnota\", oddelených bodkočiarkou.","cssLengthTooltip":"Vložte číslo pre hodnotu v pixeloch alebo číslo so správnou CSS jednotou (px, %, in, cm, mm, em, ex, pt alebo pc).","unavailable":"%1<span class=\"cke_accessibility\">, nedostupný</span>","keyboard":{"8":"Backspace","13":"Enter","16":"Shift","17":"Ctrl","18":"Alt","32":"Medzerník","35":"End","36":"Home","46":"Delete","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Klávesová skratka","optionDefault":"Predvolený"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Všetky práva vyhradené.","dlgTitle":"O aplikácii CKEditor 4","moreInfo":"Pre informácie o licenciách, prosíme, navštívte našu web stránku:"},"basicstyles":{"bold":"Tučné","italic":"Kurzíva","strike":"Prečiarknuté","subscript":"Dolný index","superscript":"Horný index","underline":"Podčiarknuté"},"bidi":{"ltr":"Smer textu zľava doprava","rtl":"Smer textu sprava doľava"},"blockquote":{"toolbar":"Citácia"},"notification":{"closed":"Notifikácia zatvorená."},"toolbar":{"toolbarCollapse":"Zbaliť lištu nástrojov","toolbarExpand":"Rozbaliť lištu nástrojov","toolbarGroups":{"document":"Dokument","clipboard":"Schránka pre kopírovanie/Späť","editing":"Upravovanie","forms":"Formuláre","basicstyles":"Základné štýly","paragraph":"Odsek","links":"Odkazy","insert":"Vložiť","styles":"Štýly","colors":"Farby","tools":"Nástroje"},"toolbars":"Lišty nástrojov editora"},"clipboard":{"copy":"Kopírovať","copyError":"Bezpečnostné nastavenia vášho prehliadača nedovoľujú editoru automaticky spustiť operáciu kopírovania. Použite na to klávesnicu (Ctrl/Cmd+C).","cut":"Vystrihnúť","cutError":"Bezpečnostné nastavenia vášho prehliadača nedovoľujú editoru automaticky spustiť operáciu vystrihnutia. Použite na to klávesnicu (Ctrl/Cmd+X).","paste":"Vložiť","pasteNotification":"Stlačte %1 na vloženie. Váš prehliadač nepodporuje vloženie prostredníctvom tlačidla v nástrojovej lište alebo voľby v kontextovom menu.","pasteArea":"Miesto pre vloženie","pasteMsg":"Vložte svoj obsah do nasledujúcej oblasti a stlačte OK.","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Automaticky","bgColorTitle":"Farba pozadia","colors":{"000":"Čierna","800000":"Gaštanová","8B4513":"Sedlová hnedá","2F4F4F":"Tmavo bridlicovo sivá","008080":"Modrozelená","000080":"Tmavomodrá","4B0082":"Indigo","696969":"Tmavá sivá","B22222":"Ohňová tehlová","A52A2A":"Hnedá","DAA520":"Zlatobyľ","006400":"Tmavá zelená","40E0D0":"Tyrkysová","0000CD":"Stredná modrá","800080":"Purpurová","808080":"Sivá","F00":"Červená","FF8C00":"Tmavá oranžová","FFD700":"Zlatá","008000":"Zelená","0FF":"Azúrová","00F":"Modrá","EE82EE":"Fialová","A9A9A9":"Tmavá sivá","FFA07A":"Svetlá lososová","FFA500":"Oranžová","FFFF00":"Žltá","00FF00":"Vápenná","AFEEEE":"Svetlá tyrkysová","ADD8E6":"Svetlá modrá","DDA0DD":"Slivková","D3D3D3":"Svetlá sivá","FFF0F5":"Levanduľovo červená","FAEBD7":"Antická biela","FFFFE0":"Svetlá žltá","F0FFF0":"Medová","F0FFFF":"Azúrová","F0F8FF":"Alicovo modrá","E6E6FA":"Levanduľová","FFF":"Biela","1ABC9C":"Silno tyrkysová","2ECC71":"Smaragdová","3498DB":"Svetlo modrá","9B59B6":"Ametystová","4E5F70":"Sivo modrá","F1C40F":"Sýto žltá","16A085":"Tmavo tyrkysová","27AE60":"Tmavo smaragdová","2980B9":"Silno modrá","8E44AD":"Tmavo fialová","2C3E50":"Nesýto modrá","F39C12":"Oranžová","E67E22":"Mrkvová","E74C3C":"Bledo červená","ECF0F1":"Svetlá bronzová","95A5A6":"Svetlá sivo-tyrkysová","DDD":"Svetlo sivá","D35400":"Tekvicová","C0392B":"Silno červená","BDC3C7":"Strieborná","7F8C8D":"Sivo tyrkysová","999":"Tmavo sivá"},"more":"Viac farieb...","panelTitle":"Farby","textColorTitle":"Farba textu"},"colordialog":{"clear":"Vyčistiť","highlight":"Zvýrazniť","options":"Možnosti farby","selected":"Vybraná farba","title":"Vybrať farbu"},"templates":{"button":"Šablóny","emptyListMsg":"(Žiadne šablóny nedefinované)","insertOption":"Nahradiť aktuálny obsah","options":"Možnosti šablóny","selectPromptMsg":"Prosím vyberte šablónu na otvorenie v editore","title":"Šablóny obsahu"},"contextmenu":{"options":"Možnosti kontextového menu"},"copyformatting":{"label":"Kopírovať formátovanie","notification":{"copied":"Formátovanie skopírované","applied":"Formátovanie aplikované","canceled":"Formátovanie zrušené","failed":"Formátovanie zlyhalo. Nemôžete aplikovať štýly bez toho, aby ste ich najprv skopírovali."}},"div":{"IdInputLabel":"Id","advisoryTitleInputLabel":"Pomocný titulok","cssClassInputLabel":"Triedy štýlu","edit":"Upraviť Div","inlineStyleInputLabel":"Inline štýl","langDirLTRLabel":"Zľava doprava (LTR)","langDirLabel":"Smer jazyka","langDirRTLLabel":"Zprava doľava (RTL)","languageCodeInputLabel":"Kód jazyka","remove":"Odstrániť Div","styleSelectLabel":"Štýl","title":"Vytvoriť Div kontajner","toolbar":"Vytvoriť Div kontajner"},"elementspath":{"eleLabel":"Cesta prvkov","eleTitle":"%1 prvok"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Počas čítania súboru nastala chyba.","networkError":"Počas nahrávania súboru nastala chyba siete.","httpError404":"Počas nahrávania súboru nastala HTTP chyba (404: Súbor nebol nájdený).","httpError403":"Počas nahrávania súboru nastala HTTP chyba (403: Zakázaný).","httpError":"Počas nahrávania súboru nastala HTTP chyba (error status: %1).","noUrlError":"URL nahrávania nie je definovaný.","responseError":"Nesprávna odpoveď servera."},"find":{"find":"Vyhľadať","findOptions":"Možnosti vyhľadávania","findWhat":"Čo hľadať:","matchCase":"Rozlišovať malé a veľké písmená","matchCyclic":"Po dosiahnutí konca pokračovať od začiatku","matchWord":"Len celé slová","notFoundMsg":"Hľadaný text nebol nájdený.","replace":"Nahradiť","replaceAll":"Nahradiť všetko","replaceSuccessMsg":"%1 výskyt(ov) nahradených.","replaceWith":"Čím nahradiť:","title":"Vyhľadať a nahradiť"},"font":{"fontSize":{"label":"Veľkosť","voiceLabel":"Veľkosť písma","panelTitle":"Veľkosť písma"},"label":"Písmo","panelTitle":"Názov písma","voiceLabel":"Písmo"},"fakeobjects":{"anchor":"Kotva","hiddenfield":"Skryté pole","iframe":"IFrame","unknown":"Neznámy objekt"},"forms":{"button":{"title":"Vlastnosti tlačidla","text":"Text (Hodnota)","type":"Typ","typeBtn":"Tlačidlo","typeSbm":"Odoslať","typeRst":"Resetovať"},"checkboxAndRadio":{"checkboxTitle":"Vlastnosti zaškrtávacieho políčka","radioTitle":"Vlastnosti prepínača (radio button)","value":"Hodnota","selected":"Vybrané (selected)","required":"Povinný"},"form":{"title":"Vlastnosti formulára","menu":"Vlastnosti formulára","action":"Akcia (action)","method":"Metóda (method)","encoding":"Kódovanie (encoding)"},"hidden":{"title":"Vlastnosti skrytého poľa","name":"Názov (name)","value":"Hodnota"},"select":{"title":"Vlastnosti rozbaľovacieho zoznamu","selectInfo":"Informácie o výbere","opAvail":"Dostupné možnosti","value":"Hodnota","size":"Veľkosť","lines":"riadkov","chkMulti":"Povoliť viacnásobný výber","required":"Povinný","opText":"Text","opValue":"Hodnota","btnAdd":"Pridať","btnModify":"Upraviť","btnUp":"Hore","btnDown":"Dole","btnSetValue":"Nastaviť ako vybranú hodnotu","btnDelete":"Vymazať"},"textarea":{"title":"Vlastnosti textovej oblasti (textarea)","cols":"Stĺpcov","rows":"Riadkov"},"textfield":{"title":"Vlastnosti textového poľa","name":"Názov (name)","value":"Hodnota","charWidth":"Šírka poľa (podľa znakov)","maxChars":"Maximálny počet znakov","required":"Povinný","type":"Typ","typeText":"Text","typePass":"Heslo","typeEmail":"Email","typeSearch":"Hľadať","typeTel":"Telefónne číslo","typeUrl":"URL"}},"format":{"label":"Formát","panelTitle":"Odsek","tag_address":"Adresa","tag_div":"Normálny (DIV)","tag_h1":"Nadpis 1","tag_h2":"Nadpis 2","tag_h3":"Nadpis 3","tag_h4":"Nadpis 4","tag_h5":"Nadpis 5","tag_h6":"Nadpis 6","tag_p":"Normálny","tag_pre":"Formátovaný"},"horizontalrule":{"toolbar":"Vložiť vodorovnú čiaru"},"iframe":{"border":"Zobraziť rám frame-u","noUrl":"Prosím, vložte URL iframe","scrolling":"Povoliť skrolovanie","title":"Vlastnosti IFrame","toolbar":"IFrame","tabindex":"Odstrániť z tabindexu"},"image":{"alt":"Alternatívny text","border":"Rám (border)","btnUpload":"Odoslať to na server","button2Img":"Chcete zmeniť vybrané obrázkové tlačidlo na jednoduchý obrázok?","hSpace":"H-medzera","img2Button":"Chcete zmeniť vybraný obrázok na obrázkové tlačidlo?","infoTab":"Informácie o obrázku","linkTab":"Odkaz","lockRatio":"Pomer zámky","menu":"Vlastnosti obrázka","resetSize":"Pôvodná veľkosť","title":"Vlastnosti obrázka","titleButton":"Vlastnosti obrázkového tlačidla","upload":"Nahrať","urlMissing":"Chýba URL zdroja obrázka.","vSpace":"V-medzera","validateBorder":"Rám (border) musí byť celé číslo.","validateHSpace":"H-medzera musí byť celé číslo.","validateVSpace":"V-medzera musí byť celé číslo."},"indent":{"indent":"Zväčšiť odsadenie","outdent":"Zmenšiť odsadenie"},"smiley":{"options":"Možnosti smajlíkov","title":"Vložiť smajlíka","toolbar":"Smajlíky"},"language":{"button":"Nastaviť jazyk","remove":"Odstrániť jazyk"},"link":{"acccessKey":"Prístupový kľúč","advanced":"Rozšírené","advisoryContentType":"Pomocný typ obsahu","advisoryTitle":"Pomocný titulok","anchor":{"toolbar":"Kotva","menu":"Upraviť kotvu","title":"Vlastnosti kotvy","name":"Názov kotvy","errorName":"Zadajte prosím názov kotvy","errorWhitespace":"Anchor name cannot contain space characters","remove":"Odstrániť kotvu"},"anchorId":"Podľa Id objektu","anchorName":"Podľa mena kotvy","charset":"Priradená znaková sada","cssClasses":"Triedy štýlu","download":"Vynútené sťahovanie.","displayText":"Zobraziť text","emailAddress":"E-Mailová adresa","emailBody":"Telo správy","emailSubject":"Predmet správy","id":"Id","info":"Informácie o odkaze","langCode":"Orientácia jazyka","langDir":"Orientácia jazyka","langDirLTR":"Zľava doprava (LTR)","langDirRTL":"Sprava doľava (RTL)","menu":"Upraviť odkaz","name":"Názov","noAnchors":"(V dokumente nie sú dostupné žiadne kotvy)","noEmail":"Zadajte prosím e-mailovú adresu","noUrl":"Zadajte prosím URL odkazu","noTel":"Zadajte prosím telefónne číslo","other":"<iný>","phoneNumber":"Telefónne číslo","popupDependent":"Závislosť (Netscape)","popupFeatures":"Vlastnosti vyskakovacieho okna","popupFullScreen":"Celá obrazovka (IE)","popupLeft":"Ľavý okraj","popupLocationBar":"Panel umiestnenia (location bar)","popupMenuBar":"Panel ponuky (menu bar)","popupResizable":"Meniteľná veľkosť (resizable)","popupScrollBars":"Posuvníky (scroll bars)","popupStatusBar":"Stavový riadok (status bar)","popupToolbar":"Panel nástrojov (toolbar)","popupTop":"Horný okraj","rel":"Vzťah (rel)","selectAnchor":"Vybrať kotvu","styles":"Štýl","tabIndex":"Poradie prvku (tab index)","target":"Cieľ","targetFrame":"<rámec>","targetFrameName":"Názov rámu cieľa","targetPopup":"<vyskakovacie okno>","targetPopupName":"Názov vyskakovacieho okna","title":"Odkaz","toAnchor":"Odkaz na kotvu v texte","toEmail":"E-mail","toUrl":"URL","toPhone":"Telefón","toolbar":"Odkaz","type":"Typ odkazu","unlink":"Odstrániť odkaz","upload":"Nahrať"},"list":{"bulletedlist":"Vložiť/odstrániť zoznam s odrážkami","numberedlist":"Vložiť/odstrániť číslovaný zoznam"},"liststyle":{"bulletedTitle":"Vlastnosti odrážkového zoznamu","circle":"Kruh","decimal":"Číselné (1, 2, 3, atď.)","disc":"Disk","lowerAlpha":"Malé latinské (a, b, c, d, e, atď.)","lowerRoman":"Malé rímske (i, ii, iii, iv, v, atď.)","none":"Nič","notset":"<nenastavené>","numberedTitle":"Vlastnosti číselného zoznamu","square":"Štvorec","start":"Začiatok","type":"Typ","upperAlpha":"Veľké latinské (A, B, C, D, E, atď.)","upperRoman":"Veľké rímske (I, II, III, IV, V, atď.)","validateStartNumber":"Začiatočné číslo číselného zoznamu musí byť celé číslo."},"magicline":{"title":"Odsek vložiť sem"},"maximize":{"maximize":"Maximalizovať","minimize":"Minimalizovať"},"newpage":{"toolbar":"Nová stránka"},"pagebreak":{"alt":"Zalomenie strany","toolbar":"Vložiť oddeľovač stránky pre tlač"},"pastetext":{"button":"Vložiť ako čistý text","pasteNotification":"Stlačte %1 na vloženie. Váš prehliadač nepodporuje vloženie prostredníctvom tlačidla v nástrojovej lište alebo voľby v kontextovom menu.","title":"Vložiť ako čistý text"},"pastefromword":{"confirmCleanup":"Zdá sa, že vkladaný text pochádza z programu MS Word. Chcete ho pred vkladaním automaticky vyčistiť?","error":"Kvôli internej chybe nebolo možné vložené dáta vyčistiť","title":"Vložiť z Wordu","toolbar":"Vložiť z Wordu"},"preview":{"preview":"Náhľad"},"print":{"toolbar":"Tlač"},"removeformat":{"toolbar":"Odstrániť formátovanie"},"save":{"toolbar":"Uložiť"},"selectall":{"toolbar":"Vybrať všetko"},"showblocks":{"toolbar":"Ukázať bloky"},"sourcearea":{"toolbar":"Zdroj"},"specialchar":{"options":"Možnosti špeciálneho znaku","title":"Výber špeciálneho znaku","toolbar":"Vložiť špeciálny znak"},"scayt":{"btn_about":"O KPPP (Kontrola pravopisu počas písania)","btn_dictionaries":"Slovníky","btn_disable":"Zakázať  KPPP (Kontrola pravopisu počas písania)","btn_enable":"Povoliť KPPP (Kontrola pravopisu počas písania)","btn_langs":"Jazyky","btn_options":"Možnosti","text_title":"Kontrola pravopisu počas písania"},"stylescombo":{"label":"Štýly","panelTitle":"Formátovanie štýlov","panelTitle1":"Štýly bloku","panelTitle2":"Znakové štýly","panelTitle3":"Štýly objektu"},"table":{"border":"Šírka orámovania","caption":"Popis","cell":{"menu":"Bunka","insertBefore":"Vložiť bunku pred","insertAfter":"Vložiť bunku za","deleteCell":"Vymazať bunky","merge":"Zlúčiť bunky","mergeRight":"Zlúčiť doprava","mergeDown":"Zlúčiť dole","splitHorizontal":"Rozdeliť bunky horizontálne","splitVertical":"Rozdeliť bunky vertikálne","title":"Vlastnosti bunky","cellType":"Typ bunky","rowSpan":"Rozsah riadkov","colSpan":"Rozsah stĺpcov","wordWrap":"Zalamovanie riadkov","hAlign":"Horizontálne zarovnanie","vAlign":"Vertikálne zarovnanie","alignBaseline":"Základná čiara (baseline)","bgColor":"Farba pozadia","borderColor":"Farba orámovania","data":"Dáta","header":"Hlavička","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Áno","no":"Nie","invalidWidth":"Šírka bunky musí byť číslo.","invalidHeight":"Výška bunky musí byť číslo.","invalidRowSpan":"Rozsah riadkov musí byť celé číslo.","invalidColSpan":"Rozsah stĺpcov musí byť celé číslo.","chooseColor":"Vybrať"},"cellPad":"Odsadenie obsahu (cell padding)","cellSpace":"Vzdialenosť buniek (cell spacing)","column":{"menu":"Stĺpec","insertBefore":"Vložiť stĺpec pred","insertAfter":"Vložiť stĺpec po","deleteColumn":"Zmazať stĺpce"},"columns":"Stĺpce","deleteTable":"Vymazať tabuľku","headers":"Hlavička","headersBoth":"Obe","headersColumn":"Prvý stĺpec","headersNone":"Žiadne","headersRow":"Prvý riadok","heightUnit":"jednotka výšky","invalidBorder":"Šírka orámovania musí byť číslo.","invalidCellPadding":"Odsadenie v bunkách (cell padding) musí byť kladné číslo.","invalidCellSpacing":"Medzera mädzi bunkami (cell spacing) musí byť kladné číslo.","invalidCols":"Počet stĺpcov musí byť číslo väčšie ako 0.","invalidHeight":"Výška tabuľky musí byť číslo.","invalidRows":"Počet riadkov musí byť číslo väčšie ako 0.","invalidWidth":"Širka tabuľky musí byť číslo.","menu":"Vlastnosti tabuľky","row":{"menu":"Riadok","insertBefore":"Vložiť riadok pred","insertAfter":"Vložiť riadok po","deleteRow":"Vymazať riadky"},"rows":"Riadky","summary":"Prehľad","title":"Vlastnosti tabuľky","toolbar":"Tabuľka","widthPc":"percent","widthPx":"pixelov","widthUnit":"jednotka šírky"},"undo":{"redo":"Znovu","undo":"Späť"},"widget":{"move":"Kliknite a potiahnite pre presunutie","label":"%1 widget"},"uploadwidget":{"abort":"Nahrávanie zrušené používateľom.","doneOne":"Súbor úspešne nahraný.","doneMany":"Úspešne nahraných %1 súborov.","uploadOne":"Nahrávanie súboru ({percentage}%)...","uploadMany":"Nahrávanie súborov, {current} z {max} hotovo ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Zdroj","searchCode":"Search Source (CTRL + F)","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Format Selection (CTRL + ALT + K)","commentSelectedRange":"Comment Selection (CTRL + K)","uncommentSelectedRange":"Uncomment Selection (CTRL + SHIFT + K)","autoCompleteToggle":"Enable/Disable HTML Tag Autocomplete"},"emoji":{"searchPlaceholder":"Nájsť emodži...","searchLabel":"Vstupné pole na hľadanie a filtrovanie emodži v paneli.","navigationLabel":"Emodži podľa skupín.","title":"Zoznam emodži","groups":{"people":"Ľudia","nature":"Príroda a zvieratá","food":"Jedlá a nápoje","travel":"Cestovanie a miesta","activities":"Činnosti","objects":"Objekty","symbols":"Symboly","flags":"Vlajky"}},"html5video":{"button":"Insert HTML5 video","title":"HTML5 video","infoLabel":"Video info","allowed":"Allowed file extensions: MP4, WebM, Ogv","urlMissing":"Video source URL is missing.","videoProperties":"Video properties","upload":"Upload","btnUpload":"Send it to the server","advanced":"Advanced","autoplay":"Autoplay?","allowdownload":"Allow download?","advisorytitle":"Advisory title","yes":"Yes","no":"No","loop":"Loop?","responsive":"Responsive width","controls":"Show controls","poster":"Thumbnail"},"sourcedialog":{"toolbar":"Zdroj","title":"Zdroj"}};