﻿/*
Copyright (c) 2003-2024, CKSource Holding sp. z o.o. All rights reserved.
For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license/
*/
CKEDITOR.lang['ru']={"application":"Rich Text Editor","editor":"Визуальный текстовый редактор","editorPanel":"Визуальный редактор текста","common":{"editorHelp":"Нажмите ALT-0 для открытия справки","browseServer":"Выбор на сервере","url":"Ссылка","protocol":"Протокол","upload":"Загрузка файла","uploadSubmit":"Загрузить на сервер","image":"Изображение","form":"Форма","checkbox":"Чекбокс","radio":"Радиокнопка","textField":"Текстовое поле","textarea":"Многострочное текстовое поле","hiddenField":"Скрытое поле","button":"Кнопка","select":"Выпадающий список","imageButton":"Кнопка-изображение","notSet":"<не указано>","id":"Идентификатор","name":"Имя","langDir":"Направление текста","langDirLtr":"Слева направо (LTR)","langDirRtl":"Справа налево (RTL)","langCode":"Код языка","longDescr":"Длинное описание ссылки","cssClass":"Класс CSS","advisoryTitle":"Заголовок","cssStyle":"Стиль","ok":"ОК","cancel":"Отмена","close":"Закрыть","preview":"Предпросмотр","resize":"Перетащите для изменения размера","generalTab":"Основное","advancedTab":"Дополнительно","validateNumberFailed":"Это значение не является числом.","confirmNewPage":"Несохранённые изменения будут потеряны! Вы действительно желаете перейти на другую страницу?","confirmCancel":"Некоторые параметры были изменены. Вы уверены, что желаете закрыть без сохранения?","options":"Параметры","target":"Цель","targetNew":"Новое окно (_blank)","targetTop":"Главное окно (_top)","targetSelf":"Текущее окно (_self)","targetParent":"Родительское окно (_parent)","langDirLTR":"Слева направо (LTR)","langDirRTL":"Справа налево (RTL)","styles":"Стиль","cssClasses":"CSS классы","width":"Ширина","height":"Высота","align":"Выравнивание","left":"По левому краю","right":"По правому краю","center":"По центру","justify":"По ширине","alignLeft":"По левому краю","alignRight":"По правому краю","alignCenter":"По центру","alignTop":"Поверху","alignMiddle":"Посередине","alignBottom":"Понизу","alignNone":"Нет","invalidValue":"Недопустимое значение.","invalidHeight":"Высота задается числом.","invalidWidth":"Ширина задается числом.","invalidLength":"Указанное значение для поля \"%1\" должно быть положительным числом без или с корректным символом единицы измерения (%2)","invalidCssLength":"Значение, указанное в поле \"%1\", должно быть положительным целым числом. Допускается указание единиц меры CSS (px, %, in, cm, mm, em, ex, pt или pc).","invalidHtmlLength":"Значение, указанное в поле \"%1\", должно быть положительным целым числом. Допускается указание единиц меры HTML (px или %).","invalidInlineStyle":"Значение, указанное для стиля элемента, должно состоять из одной или нескольких пар данных в формате \"параметр : значение\", разделённых точкой с запятой.","cssLengthTooltip":"Введите значение в пикселях, либо число с корректной единицей меры CSS (px, %, in, cm, mm, em, ex, pt или pc).","unavailable":"%1<span class=\"cke_accessibility\">, недоступно</span>","keyboard":{"8":"Backspace","13":"Ввод","16":"Shift","17":"Ctrl","18":"Alt","32":"Пробел","35":"End","36":"Home","46":"Delete","112":"F1","113":"F2","114":"F3","115":"F4","116":"F5","117":"F6","118":"F7","119":"F8","120":"F9","121":"F10","122":"F11","123":"F12","124":"F13","125":"F14","126":"F15","127":"F16","128":"F17","129":"F18","130":"F19","131":"F20","132":"F21","133":"F22","134":"F23","135":"F24","224":"Command"},"keyboardShortcut":"Комбинация клавиш","optionDefault":"По умолчанию"},"versionCheck":{"notificationMessage":"This CKEditor %current version is not secure. Consider <a target=\"_blank\" href=\"%link\">upgrading to the latest one</a>, %latest.","consoleMessage":"This CKEditor %current version is not secure. Consider upgrading to the latest one, %latest: %link","aboutDialogInsecureMessage":"This CKEditor %current version is not secure.<br>Consider upgrading to the latest one, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>","aboutDialogUpgradeMessage":"Consider upgrading to the latest editor version, %latest:<br><a target=\"_blank\" href=\"%link\">%link</a>"},"about":{"copy":"Copyright &copy; $1. Все права защищены.","dlgTitle":"О CKEditor 4","moreInfo":"Для получения информации о лицензии, пожалуйста, перейдите на наш сайт:"},"basicstyles":{"bold":"Полужирный","italic":"Курсив","strike":"Зачеркнутый","subscript":"Подстрочный индекс","superscript":"Надстрочный индекс","underline":"Подчеркнутый"},"bidi":{"ltr":"Направление текста слева направо","rtl":"Направление текста справа налево"},"blockquote":{"toolbar":"Цитата"},"notification":{"closed":"Уведомление закрыто"},"toolbar":{"toolbarCollapse":"Свернуть панель инструментов","toolbarExpand":"Развернуть панель инструментов","toolbarGroups":{"document":"Документ","clipboard":"Буфер обмена / Отмена действий","editing":"Корректировка","forms":"Формы","basicstyles":"Простые стили","paragraph":"Абзац","links":"Ссылки","insert":"Вставка","styles":"Стили","colors":"Цвета","tools":"Инструменты"},"toolbars":"Панели инструментов редактора"},"clipboard":{"copy":"Копировать","copyError":"Настройки безопасности вашего браузера не разрешают редактору выполнять операции по копированию текста. Пожалуйста, используйте для этого клавиатуру (Ctrl/Cmd+C).","cut":"Вырезать","cutError":"Настройки безопасности вашего браузера не разрешают редактору выполнять операции по вырезке текста. Пожалуйста, используйте для этого клавиатуру (Ctrl/Cmd+X).","paste":"Вставить","pasteNotification":"Для вставки нажмите %1. Ваш браузер не поддерживает возможность вставки через панель инструментов или контекстное меню","pasteArea":"Область вставки","pasteMsg":"Вставьте контент в эту область и нажмите OK","fileFormatNotSupportedNotification":"The ${formats} file format(s) are not supported.","fileWithoutFormatNotSupportedNotification":"The file format is not supported."},"colorbutton":{"auto":"Автоматически","bgColorTitle":"Цвет фона","colors":{"000":"Чёрный","800000":"Бордовый","8B4513":"Кожано-коричневый","2F4F4F":"Темный синевато-серый","008080":"Сине-зелёный","000080":"Тёмно-синий","4B0082":"Индиго","696969":"Тёмно-серый","B22222":"Кирпичный","A52A2A":"Коричневый","DAA520":"Золотисто-берёзовый","006400":"Темно-зелёный","40E0D0":"Бирюзовый","0000CD":"Умеренно синий","800080":"Пурпурный","808080":"Серый","F00":"Красный","FF8C00":"Темно-оранжевый","FFD700":"Золотистый","008000":"Зелёный","0FF":"Васильковый","00F":"Синий","EE82EE":"Фиолетовый","A9A9A9":"Тускло-серый","FFA07A":"Светло-лососевый","FFA500":"Оранжевый","FFFF00":"Жёлтый","00FF00":"Лайма","AFEEEE":"Бледно-синий","ADD8E6":"Свелто-голубой","DDA0DD":"Сливовый","D3D3D3":"Светло-серый","FFF0F5":"Розово-лавандовый","FAEBD7":"Античный белый","FFFFE0":"Светло-жёлтый","F0FFF0":"Медвяной росы","F0FFFF":"Лазурный","F0F8FF":"Бледно-голубой","E6E6FA":"Лавандовый","FFF":"Белый","1ABC9C":"Насыщенный голубой","2ECC71":"Изумрудный","3498DB":"Светло-синий","9B59B6":"Аметист","4E5F70":"Сине-серый","F1C40F":"Ярко-желтый","16A085":"Тёмно-голубой","27AE60":"Тёмно-изумрудный","2980B9":"Насыщенный синий","8E44AD":"Тёмно-фиолетовый","2C3E50":"Ненасыщенный синий","F39C12":"Оранжевый","E67E22":"Морковный","E74C3C":"Бледно-красный","ECF0F1":"Яркий серебристый","95A5A6":"Светлый серо-голубой","DDD":"Светло-серый","D35400":"Цвет тыквы","C0392B":"Насыщенный красный","BDC3C7":"Серебристый","7F8C8D":"Серо-голубой","999":"Тёмно-серый"},"more":"Ещё цвета...","panelTitle":"Цвета","textColorTitle":"Цвет текста"},"colordialog":{"clear":"Очистить","highlight":"Под курсором","options":"Настройки цвета","selected":"Выбранный цвет","title":"Выберите цвет"},"templates":{"button":"Шаблоны","emptyListMsg":"(не определено ни одного шаблона)","insertOption":"Заменить текущее содержимое","options":"Параметры шаблона","selectPromptMsg":"Пожалуйста, выберите, какой шаблон следует открыть в редакторе","title":"Шаблоны содержимого"},"contextmenu":{"options":"Параметры контекстного меню"},"copyformatting":{"label":"Копировать форматирование","notification":{"copied":"Форматирование скопировано","applied":"Форматирование применено","canceled":"Форматирование отменен","failed":"Форматирование не выполнено. Стили необходимо скопировать перед применением."}},"div":{"IdInputLabel":"Идентификатор","advisoryTitleInputLabel":"Заголовок","cssClassInputLabel":"Классы CSS","edit":"Редактировать контейнер","inlineStyleInputLabel":"Стиль элемента","langDirLTRLabel":"Слева направо (LTR)","langDirLabel":"Направление текста","langDirRTLLabel":"Справа налево (RTL)","languageCodeInputLabel":"Код языка","remove":"Удалить контейнер","styleSelectLabel":"Стиль","title":"Создать Div-контейнер","toolbar":"Создать Div-контейнер"},"elementspath":{"eleLabel":"Путь элементов","eleTitle":"Элемент %1"},"exportpdf":{"documentReady":"Document is ready!","error":"Error occurred.","processingDocument":"Processing PDF document...","toolbar":"Export to PDF"},"filetools":{"loadError":"Ошибка при чтении файла","networkError":"Сетевая ошибка при загрузке файла","httpError404":"HTTP ошибка при загрузке файла (404: Файл не найден)","httpError403":"HTTP ошибка при загрузке файла (403: Запрещено)","httpError":"HTTP ошибка при загрузке файла (%1)","noUrlError":"Не определен URL для загрузки файлов","responseError":"Некорректный ответ сервера"},"find":{"find":"Найти","findOptions":"Опции поиска","findWhat":"Найти:","matchCase":"Учитывать регистр","matchCyclic":"По всему тексту","matchWord":"Только слово целиком","notFoundMsg":"Искомый текст не найден.","replace":"Заменить","replaceAll":"Заменить всё","replaceSuccessMsg":"Успешно заменено %1 раз(а).","replaceWith":"Заменить на:","title":"Поиск и замена"},"font":{"fontSize":{"label":"Размер","voiceLabel":"Размер шрифта","panelTitle":"Размер шрифта"},"label":"Шрифт","panelTitle":"Шрифт","voiceLabel":"Шрифт"},"fakeobjects":{"anchor":"Якорь","hiddenfield":"Скрытое поле","iframe":"iFrame","unknown":"Неизвестный объект"},"forms":{"button":{"title":"Свойства кнопки","text":"Текст (Значение)","type":"Тип","typeBtn":"Кнопка","typeSbm":"Отправка","typeRst":"Сброс"},"checkboxAndRadio":{"checkboxTitle":"Свойства флаговой кнопки","radioTitle":"Свойства кнопки выбора","value":"Значение","selected":"Выбрано","required":"Обязательное поле"},"form":{"title":"Свойства формы","menu":"Свойства формы","action":"Действие","method":"Метод","encoding":"Кодировка"},"hidden":{"title":"Свойства скрытого поля","name":"Имя","value":"Значение"},"select":{"title":"Свойства списка выбора","selectInfo":"Информация о списке выбора","opAvail":"Доступные варианты","value":"Значение","size":"Размер","lines":"строк(и)","chkMulti":"Разрешить выбор нескольких вариантов","required":"Обязательное поле","opText":"Текст","opValue":"Значение","btnAdd":"Добавить","btnModify":"Изменить","btnUp":"Поднять","btnDown":"Опустить","btnSetValue":"Пометить как выбранное","btnDelete":"Удалить"},"textarea":{"title":"Свойства многострочного текстового поля","cols":"Колонок","rows":"Строк"},"textfield":{"title":"Свойства текстового поля","name":"Имя","value":"Значение","charWidth":"Ширина поля (в символах)","maxChars":"Макс. количество символов","required":"Обязательное поле","type":"Тип содержимого","typeText":"Текст","typePass":"Пароль","typeEmail":"Email","typeSearch":"Поиск","typeTel":"Номер телефона","typeUrl":"Ссылка"}},"format":{"label":"Форматирование","panelTitle":"Форматирование","tag_address":"Адрес","tag_div":"Обычное (div)","tag_h1":"Заголовок 1","tag_h2":"Заголовок 2","tag_h3":"Заголовок 3","tag_h4":"Заголовок 4","tag_h5":"Заголовок 5","tag_h6":"Заголовок 6","tag_p":"Обычное","tag_pre":"Моноширинное"},"horizontalrule":{"toolbar":"Вставить горизонтальную линию"},"iframe":{"border":"Показать границы фрейма","noUrl":"Пожалуйста, введите ссылку фрейма","scrolling":"Отображать полосы прокрутки","title":"Свойства iFrame","toolbar":"iFrame","tabindex":"Remove from tabindex"},"image":{"alt":"Альтернативный текст","border":"Граница","btnUpload":"Загрузить на сервер","button2Img":"Вы желаете преобразовать это изображение-кнопку в обычное изображение?","hSpace":"Гориз. отступ","img2Button":"Вы желаете преобразовать это обычное изображение в изображение-кнопку?","infoTab":"Данные об изображении","linkTab":"Ссылка","lockRatio":"Сохранять пропорции","menu":"Свойства изображения","resetSize":"Вернуть обычные размеры","title":"Свойства изображения","titleButton":"Свойства изображения-кнопки","upload":"Загрузить","urlMissing":"Не указана ссылка на изображение.","vSpace":"Вертик. отступ","validateBorder":"Размер границ должен быть задан числом.","validateHSpace":"Горизонтальный отступ должен быть задан числом.","validateVSpace":"Вертикальный отступ должен быть задан числом."},"indent":{"indent":"Увеличить отступ","outdent":"Уменьшить отступ"},"smiley":{"options":"Выбор смайла","title":"Вставить смайл","toolbar":"Смайлы"},"language":{"button":"Установка языка","remove":"Удалить язык"},"link":{"acccessKey":"Клавиша доступа","advanced":"Дополнительно","advisoryContentType":"Тип содержимого","advisoryTitle":"Заголовок","anchor":{"toolbar":"Вставить / редактировать якорь","menu":"Изменить якорь","title":"Свойства якоря","name":"Имя якоря","errorName":"Пожалуйста, введите имя якоря","errorWhitespace":"Anchor name cannot contain space characters","remove":"Удалить якорь"},"anchorId":"По идентификатору","anchorName":"По имени","charset":"Кодировка ресурса","cssClasses":"Классы CSS","download":"Скачать как файл","displayText":"Отображаемый текст","emailAddress":"Email адрес","emailBody":"Текст сообщения","emailSubject":"Тема сообщения","id":"Идентификатор","info":"Информация о ссылке","langCode":"Код языка","langDir":"Направление текста","langDirLTR":"Слева направо (LTR)","langDirRTL":"Справа налево (RTL)","menu":"Редактировать ссылку","name":"Имя","noAnchors":"(В документе нет ни одного якоря)","noEmail":"Пожалуйста, введите email адрес","noUrl":"Пожалуйста, введите ссылку","noTel":"Please type the phone number","other":"<другой>","phoneNumber":"Phone number","popupDependent":"Зависимое (Netscape)","popupFeatures":"Параметры всплывающего окна","popupFullScreen":"Полноэкранное (IE)","popupLeft":"Отступ слева","popupLocationBar":"Панель адреса","popupMenuBar":"Панель меню","popupResizable":"Изменяемый размер","popupScrollBars":"Полосы прокрутки","popupStatusBar":"Строка состояния","popupToolbar":"Панель инструментов","popupTop":"Отступ сверху","rel":"Отношение","selectAnchor":"Выберите якорь","styles":"Стиль","tabIndex":"Последовательность перехода","target":"Цель","targetFrame":"<фрейм>","targetFrameName":"Имя целевого фрейма","targetPopup":"<всплывающее окно>","targetPopupName":"Имя всплывающего окна","title":"Ссылка","toAnchor":"Ссылка на якорь в тексте","toEmail":"Email","toUrl":"Ссылка","toPhone":"Phone","toolbar":"Вставить/Редактировать ссылку","type":"Тип ссылки","unlink":"Убрать ссылку","upload":"Загрузка"},"list":{"bulletedlist":"Вставить / удалить маркированный список","numberedlist":"Вставить / удалить нумерованный список"},"liststyle":{"bulletedTitle":"Свойства маркированного списка","circle":"Окружность","decimal":"Десятичные (1, 2, 3, и т.д.)","disc":"Круг","lowerAlpha":"Строчные латинские (a, b, c, d, e, и т.д.)","lowerRoman":"Строчные римские (i, ii, iii, iv, v, и т.д.)","none":"Нет","notset":"<не указано>","numberedTitle":"Свойства нумерованного списка","square":"Квадрат","start":"Начиная с","type":"Тип","upperAlpha":"Заглавные латинские (A, B, C, D, E, и т.д.)","upperRoman":"Заглавные римские (I, II, III, IV, V, и т.д.)","validateStartNumber":"Первый номер списка должен быть задан обычным целым числом."},"magicline":{"title":"Вставить здесь параграф"},"maximize":{"maximize":"Развернуть","minimize":"Свернуть"},"newpage":{"toolbar":"Новая страница"},"pagebreak":{"alt":"Разрыв страницы","toolbar":"Вставить разрыв страницы для печати"},"pastetext":{"button":"Вставить только текст","pasteNotification":"Для вставки нажмите %1. Ваш браузер не поддерживает возможность вставки через панель инструментов или контекстное меню","title":"Вставить только текст"},"pastefromword":{"confirmCleanup":"Текст, который вы желаете вставить, по всей видимости, был скопирован из Word. Следует ли очистить его перед вставкой?","error":"Невозможно очистить вставленные данные из-за внутренней ошибки","title":"Вставить из Word","toolbar":"Вставить из Word"},"preview":{"preview":"Предварительный просмотр"},"print":{"toolbar":"Печать"},"removeformat":{"toolbar":"Убрать форматирование"},"save":{"toolbar":"Сохранить"},"selectall":{"toolbar":"Выделить все"},"showblocks":{"toolbar":"Отображать блоки"},"sourcearea":{"toolbar":"Источник"},"specialchar":{"options":"Выбор специального символа","title":"Выберите специальный символ","toolbar":"Вставить специальный символ"},"scayt":{"btn_about":"О SCAYT","btn_dictionaries":"Словари","btn_disable":"Отключить SCAYT","btn_enable":"Включить SCAYT","btn_langs":"Языки","btn_options":"Настройки","text_title":"Проверка орфографии по мере ввода (SCAYT)"},"stylescombo":{"label":"Стили","panelTitle":"Стили форматирования","panelTitle1":"Стили блока","panelTitle2":"Стили элемента","panelTitle3":"Стили объекта"},"table":{"border":"Размер границ","caption":"Заголовок","cell":{"menu":"Ячейка","insertBefore":"Вставить ячейку слева","insertAfter":"Вставить ячейку справа","deleteCell":"Удалить ячейки","merge":"Объединить ячейки","mergeRight":"Объединить с правой","mergeDown":"Объединить с нижней","splitHorizontal":"Разделить ячейку по вертикали","splitVertical":"Разделить ячейку по горизонтали","title":"Свойства ячейки","cellType":"Тип ячейки","rowSpan":"Объединяет строк","colSpan":"Объединяет колонок","wordWrap":"Перенос по словам","hAlign":"Горизонтальное выравнивание","vAlign":"Вертикальное выравнивание","alignBaseline":"По базовой линии","bgColor":"Цвет фона","borderColor":"Цвет границ","data":"Данные","header":"Заголовок","columnHeader":"Column Header","rowHeader":"Row Header","yes":"Да","no":"Нет","invalidWidth":"Ширина ячейки должна быть числом.","invalidHeight":"Высота ячейки должна быть числом.","invalidRowSpan":"Количество объединяемых строк должно быть задано числом.","invalidColSpan":"Количество объединяемых колонок должно быть задано числом.","chooseColor":"Выберите"},"cellPad":"Внутренний отступ ячеек","cellSpace":"Внешний отступ ячеек","column":{"menu":"Колонка","insertBefore":"Вставить колонку слева","insertAfter":"Вставить колонку справа","deleteColumn":"Удалить колонки"},"columns":"Колонки","deleteTable":"Удалить таблицу","headers":"Заголовки","headersBoth":"Сверху и слева","headersColumn":"Левая колонка","headersNone":"Без заголовков","headersRow":"Верхняя строка","heightUnit":"height unit","invalidBorder":"Размер границ должен быть числом.","invalidCellPadding":"Внутренний отступ ячеек (cellpadding) должен быть числом.","invalidCellSpacing":"Внешний отступ ячеек (cellspacing) должен быть числом.","invalidCols":"Количество столбцов должно быть больше 0.","invalidHeight":"Высота таблицы должна быть числом.","invalidRows":"Количество строк должно быть больше 0.","invalidWidth":"Ширина таблицы должна быть числом.","menu":"Свойства таблицы","row":{"menu":"Строка","insertBefore":"Вставить строку сверху","insertAfter":"Вставить строку снизу","deleteRow":"Удалить строки"},"rows":"Строки","summary":"Итоги","title":"Свойства таблицы","toolbar":"Таблица","widthPc":"процентов","widthPx":"пикселей","widthUnit":"единица измерения"},"undo":{"redo":"Повторить","undo":"Отменить"},"widget":{"move":"Нажмите и перетащите, чтобы переместить","label":"%1 виджет"},"uploadwidget":{"abort":"Загрузка отменена пользователем","doneOne":"Файл успешно загружен","doneMany":"Успешно загружено файлов: %1","uploadOne":"Загрузка файла ({percentage}%)","uploadMany":"Загрузка файлов, {current} из {max} загружено ({percentage}%)..."},"a11yfirsthelp":{"label":"A11yFirst Help","panelTitle":"Learn about A11yFirst features","keyboardShortcutsLabel":"Keyboard Shortcuts","versionLabel":"Version","a11yFirstHelpLabel":"A11yFirst Help: Content Accessibility","a11yFirstHelpTitle":"Information to help authors understand how the A11yFirst features help them make content more accessible to people with disabilites","headingHelp":{"menu":"Heading / Paragraph","label":"Heading / Paragraph","title":"Heading / Paragraph Help","content":"## Heading / Paragraph\n\n### Menu items\n* **H1 – Document title** — Typically should be the first heading in the\n  document and used only once.\n* **H2 – Section title** — Describes a main or top-level section in the\n  document.\n* **H3 to H6 – Subsection title** — Describes a subsection within a top-level\n  section or other subsection of the document.\n* **Normal** — The default paragraph format, typically with significant top\n  and bottom margins.\n* **Preformatted text** — Use this for computer code blocks to maintain spacing\n  and indentation.\n* **Address line** — Use this to type a series of address lines styled in\n  italics and with minimal top and bottom margins. When you press enter at the\n  end of a line, the next line is also an address line.\n\n### About headings\n* The Heading / Paragraph menu only enables the **allowed** heading levels.\n\n* The cursor position relative to other headings in the document determines\nwhich heading levels are allowed.\n\n### About paragraph formats\n* Visual styling for paragraph formats is predetermined by your organization,\nthus freeing up your time and energy for concentrating on the structure and\nmeaning of the content within your document.\n\n### Why headings and paragraph formats are important\n* The purpose of a heading is to label the content that follows it.\n\n* The proper nesting of heading levels improves the ability of all users to\nfind and comprehend information on a page.\n\n* Headings used consistently and in meaningful ways improve Search Engine\nOptimization (SEO).\n\n* Properly nested headings enable people using assistive technologies to easily\nnavigate to each section of a document.\n\n* When paragraph formats are used properly (e.g. *Preformatted* or *Address*),\nthey help users of assistive technologies understand the intended role of the\ncontent.\n\n* Thinking in terms of blocks such as headings and paragraph formats within\nyour document is a higher-level approach to providing structure and semantics\nthat are important for all users.\n\n### More information\n* Documents are easier to read and understand when headings identify the topics\nthey contain.\n\n* Headings make it easier to scan and find topics of interest within a document.\n\n* Heading levels identify the structural relationships between sections of\ncontent in a document.\n\n* Higher-level headings (Levels 1 and 2) identify the main topics of a document\nand lower-level headings (Levels 3, 4, 5 and 6) identify subsections of the\ndocument.\n\n* A subsection is identified by using the next lower-level heading. For\nexample, subsections of Level 2 headings use Level 3 headings, subsections of\nLevel 3 headings use Level 4 headings, and so on to Level 6 headings.\n\n* Break content into subsections when there are two or more ideas or concepts\nthat correspond to the topics covered in the section. Use headings of the same\nlevel to label each subsection.\n\n* Heading levels should **never** be used for inline visual styling of content\n(e.g. larger or smaller font size, bold or italic). Instead, use the `Inline\nStyle` options.\n"},"listHelp":{"menu":"List","label":"List","title":"List Help","content":"## List\n\n### Working with lists\n\n<img style=\"padding: 8px 0 3px 5px\" alt=\"list toolbar buttons\"\nsrc=\"basePath/plugins/a11yfirsthelp/images/list-buttons.png\"/>\n\nUse the toolbar buttons shown above to:\n\n* Insert/Remove Numbered List\n* Insert/Remove Bulleted List\n* Increase Indent\n* Decrease Indent\n\n### List properties via context menu\n\nThe context menu allows further configuration of list properties such as\nnumbering and bullet types by selecting:\n\n* Numbered List Properties\n* Bulleted List Properties\n\nThe context menu can be invoked by positioning the cursor in a list item and:\n\n* right-clicking, using the mouse, or\n* using Mouse Keys on Windows or Mac.\n\n### About lists\n\n* Use a numbered list when the order or sequence of the items is significant.\n* Use a bulleted list when the order of the items is not significant.\n\n### Why lists are important\n\n* Lists convey grouping semantics for related items.\n* Lists may also convey hierarchical structure.\n* When related items are grouped as a list, information about the list is\n  conveyed to screen reader users, including the type of list, the number of\n  items it contains and the sequence number of the current list item.\n"},"imageHelp":{"menu":"Image","label":"Image","title":"Image Help","content":"## Image\n\n### Accessible image descriptions\n\n* People with visual impairments or visual processing disorders need\n  accessible text descriptions of informative images.\n\n* There are two types of accessible descriptions for images: *alternative\n  text* and *long descriptions*.\n\n### Alternative text\n\n* Succinctly describes the content and function of the image for people\n  with visual impairments, in no more than 100 characters\n\n* Is required for informative images (but not for images that are purely\n  decorative)\n\n* Is not visible in the document; it is communicated to screen reader users\n  via the *img* element's *alt* attribute\n\n* For a purely decorative image, select the **‘Image does not require\n  alternative text’** checkbox and leave the alternative text field blank.\n\n### Long descriptions for complex images\n\n* A complex image has informational content that cannot be described adequately\n  by alternative text of 100 characters or less.\n\n* Examples of complex images include charts, graphs, diagrams, scientific\n  photographs and works of art.\n\n* A complex image needs both a concise alternative text description and a\n  longer, more detailed description.\n\n* Accessibility requirements mandate that the long description of a complex\n  image be placed in the document adjacent to the image.\n\n### Adding a long description in the document\n\nFollow these steps when adding a long description of a complex image:\n\n1. Add an adequately detailed description of the image within the document,\n   either just before or after the image (or both).\n\n1. In answer to the question **‘Is a long description needed, and if so,\n   where will it be located’**, select one of the following:\n       * Yes; in the document before the image\n       * Yes; in the document after the image\n       * Yes; in the document before and after the image\n\nBy specifying the location of the long description relative to the image,\nscreen reader users will be informed of its existence and location in the\ndocument. (This information is appended to the alternative text.)\n\n### Insert a caption text box below the image\n\n* A **caption** is an optional visual label supported by CKEditor for an image.\n  It provides an additional way to describe an image that is immediately below\n  and proximate to the image.\n\n* The caption content is specified and is editable in the text box just below\n  the image, once it has been inserted in the document.\n\n* From an accessibility perspective the *caption* and the *alternative text*\n  should not be the same, but instead should complement each other.\n\n* Using the caption creates a *figcaption* element contained in a *figure*\n  element. The *figure* element also contains the *img* element.\n\n### Writing effective alternative text\n\nThe following are based on <a href=\"https://webaim.org\" target=\"_resource\">\nWebAIM</a>'s guidelines for alternative text:\n\n* **Be accurate and equivalent** in presenting the same *content* and\n  *function* of the image.\n\n* When **images are used as links**, the alternative text should describe the\n  target of the link.\n\n* **Be succinct.** This means the correct content and function of the image\n  should be presented as succinctly as is appropriate. Typically no more than\n  a few words are necessary, though rarely a short sentence or two may be\n  appropriate. The length should not exceed 100 characters.\n\n* **Do NOT be redundant** or provide the same information as text that is\n  already part of the document.\n\n* **Do NOT use the phrases “image of ...” or “graphic of ...”** to describe\n  the image. Assistive technologies notify the user of the image.  It is your\n  job to describe the purpose or the content of the image.  If the image is a\n  photograph or illustration, etc. of important content, it may be useful to\n  include this in the alternative text.\n\n* **Do NOT include file names or sizes** as part of the alternative text.\n\n### Why image descriptions are important\n\nAdding text descriptions of images is an important part of making documents\naccessible to the visually impaired who use assistive devices such as screen\nreaders and magnifiers, and to people with visual processing disorders, which\nmake especially complex images more difficult to understand.\n\nWhen the user cannot see all or part of an image, assistive technologies will\nread or display its alternative text description. This is especially important\nwhen the image conveys information that is required for the user to fully\nunderstand the information in the document.\n\nFor people with visual processing disorders, a detailed description of a\ncomplex image helps them to more quickly or completely understand the\ninformation being conveyed by the image.\n\n### More information\n\n* <a href=\"https://accessibility.psu.edu/images/alttext/\"\ntarget=\"_resource\">Penn State: Image ALT Text</a>\n\n* <a href=\"https://webaim.org/techniques/alttext/\"\ntarget=\"_resource\">WebAIM: Alternative Text</a>\n\n* <a href=\"https://www.w3.org/WAI/tutorials/images/\"\ntarget=\"_resource\">W3C Web Accessibility Image Tutorial</a>\n\n* <a href=\"http://diagramcenter.org/\" target=\"_resource\">Diagram Center</a>\n"},"inlineStyleHelp":{"menu":"Character Style","label":"Character Style","title":"Character Style Help","content":"## Character Style\n\n### Working with character styles\n\n* To apply a character style to existing text, select a range of text and then\nchoose an option from the menu.\n\n* To apply a character style to text you are about to type, choose an option\nfrom the menu and begin typing. The style will continue to be applied until\nyou choose another option or move the cursor to a different point in the\ndocument.\n\n* Multiple character styles can be applied to selected text.\n\n### About character styles\n\n* Character styles have a different purpose than paragraph formats. They are\nused at a lower level to highlight words or phrases within blocks of text.\n\n* Character styles, when used properly, help screen reader users better\nunderstand the types and meanings of lower-level stylistic changes within\nblocks of text.\n\n### Character styles vs. headings, lists and paragraph formats\n\n* Thinking in terms of headings, lists and paragraph formats first, and then\nusing character styles to emphasize key words or phrases within text blocks,\nresults in documents that are easier to read and understand.\n\n* When headings, lists and paragraph formats are considered as primary, and\ncharacter styles secondary, many visual styling decisions can be avoided, as\nthey are already made by default.\n\n* When character styles are used to change the styling of blocks of text\nwithout regard to whether the block is a heading, list item or other type of\nparagraph format, it makes the document more difficult to read and understand\nwithin the context of the website.\n\n* Using headings, lists, paragraph formats and character styles properly will\nmake it easier for you to maintain stylistic consistency.\n"},"linkHelp":{"menu":"Link","label":"Link","title":"Link Help","content":"## Link\n\n### Display Text\n\nProviding accessible *Display Text* is straightforward if you keep the\nfollowing guidelines in mind:\n\n1. The *Display Text* for a link should describe the target of the link.\n\n1. Do not use ambiguous text, such as “Click Here” or “More”.\n\n1. Do not begin the *Display Text* with redundant words or phrases such as\n   “Link” or “Link to”.\n\n1. Be consistent: Links to the same URL or e-mail address should have the same\n   *Display Text*.\n\n1. In most cases, it is best not to use the link URL or e-mail address as the\n   *Display Text*.\n\n### About links\n\n* Screen reader users often use the “List of Links” feature to identify and\n  navigate to links on a page. When links are presented as a list,  using\n  descriptive *Display Text* becomes even more important since understanding\n  the target of each link no longer benefits from its original context within\n  the document.\n\n* Screen reader users often use the “Search” feature to find links on a page\n  based on keywords they would expect to find in the *Display Text* of the\n  links. Thus the more descriptive the link *Display Text*, the more effective\n  the search feature will be in finding relevant links.\n\n* Usable and accessible *Display Text* should be descriptive, unique and start\n  with keywords (NNG).\n\n* The *Display Text* for links is like a sign post. It should tell you what\n  you’ll find when you follow it (NOMENSA).\n\n### Why links are important\n\n* Descriptive link text makes it easier for everyone to find and follow links\n  on a page that are of interest to them.\n\n* Descriptive link text is especially important for people using screen\n  readers, who typically only hear the display text spoken to them through\n  speech synthesis and do not \"see\" the link in the context of other content\n  on the page.\n\n* When URLs, e-mail addresses or other ambiguous text are used as the display\n  text for a link, it is impossible in many cases, and much more difficult in\n  the remaining cases, for screen reader users to find and follow links of\n  interest to them.\n\n### More information\n\n* <a href=\"https://www.nngroup.com/articles/writing-links/\"\ntarget=\"_resource\">NNG: Writing Hyperlinks: Salient, Descriptive, Start with\nKeyword</a>\n\n* <a href=\"https://www.nomensa.com/blog/2011/writing-good-link-text\"\ntarget=\"_resource\">Nomensa: How to write good link text</a>\n\n* <a href=\"https://accessibility.umn.edu/core-skills/hyperlinks\"\ntarget=\"_resource\">Accessible U: Hyperlinks (Good and Bad Examples)</a>\n"},"gettingStarted":{"menu":"Getting Started","label":"Getting Started","title":"Getting Started with A11yFirst","content":"## Getting Started with A11yFirst\n\n### What is A11yFirst?\n\nBefore you begin using the A11yFirst editor, it is important to know what\nmakes it different from other editors. The name *A11yFirst* hints at some\nof these differences.\n\n*A11y* is shorthand for *accessibility* (*a* + 11 letters + *y*), and\naccessibility in the context of document authoring is about making the\ninformation that documents contain perceivable and understandable by everyone,\nincluding people with disabilities.</p>\n\n### Commitment to accessibility\n\nYour organization, by hosting the A11yFirst editor within its content\nmanagement system, has made a commitment to accessibility because (1) it\nremoves barriers that people with visual, auditory, learning and other\ndisabilities may experience in their use of web information and communication\ntechnologies and (2) it is required by law.\n\nBy following accessibility guidelines when creating public-facing documents,\nyou are fulfilling your role in this commitment.\n\n### Document accessibility\n\nSome of the main components within a document that are important for\naccessibility are:\n\n* **Headings** — These provide titles for the sections and subsections of\ncontent within your document, as well as a title for the document itself.\n\n* **Lists** — By using the list feature, the items in a list are grouped\ntogether and information about the grouping can be conveyed to users of\nassistive technologies.\n\n* **Links** — The text component of a link should describe its target, i.e.,\nthe web site, page or section that will be displayed if you activate the link.\n\n* **Images** — When an image with informational content is included within a\ndocument, a short text description (also known as ‘alt text’) allows screen\nreader users to obtain a concise description of the image.\n\n* **Tables** — By using the table feature to organize tabular data and provide row\nand column headers, users of assistive technologies gain the ability to easily\nnavigate and understand structural relationships within the data.\n\n### A different way of thinking\n\nThe way you think about the process or workflow of creating and editing\ndocuments can make a significant difference in whether the end result, your\nfinished document, is accessible.\n\nFor example, rather than thinking about stylistic considerations such as font\nsizes and colors first, if you make the structure of your document a primary\nconsideration, by breaking it down into sections and subsections and giving\neach of these a meaningful title, you will end up with a document that will\nbe easier for all users to navigate and understand, including people with\ndisabilities.\n"},"aboutA11yFirst":{"menu":"About A11yFirst","label":"About A11yFirst","title":"Description of A11yFirst Project","content":"## About A11yFirst\n\n### Project Description & Goals\n\nThe A11yFirst Project is a collection of modifications to CKEditor, an\nHTML-embedded WYSIWYG editor typically used within content management\nsystems. Its goal is to make the process of creating and editing web documents\none that proactively results in accessible content.\n\nIn the past, authors have had to rely upon remediation tools used at the end\nof the authoring process that ‘fix’ accessibility problems without offering\nmuch guidance on how to prevent them. The A11yFirst editor takes a different\napproach.\n\nFor example, by prompting the author to provide information regarding links\nand images as they are added to the document, accessibility problems are not\nonly avoided, but authors learn on a feature-by-feature basis some of the\nimportant requirements for accessible content.\n\nOther design features in A11yFirst promote the use of blocks such as headings\nand lists that carry with them semantics that are communicated to screen\nreader users and that result in documents that are more easily navigated and\nunderstood by all readers.\n\n### Project Information\n\n* Version: %version\n\n* GitHub Repositories: <a href=\"https://github.com/a11yfirst\"\ntarget=\"_resource\">https://github.com/a11yfirst</a>\n\n### Contributors\n\n* Lucy Chang     (UX, Usability Testing)\n* Jon Gunderson  (Requirements, Development, Usability Testing,\n  Project Management)\n* Nicholas Hoyt  (UX, UI Design, Development, Usability Testing,\n  Project Management)\n* JaEun Jemma Ku (Requirements, Usability Testing, UI Design,\n  Project Management)\n* Eileen Lopez   (UX, Usability Testing)\n* Mark McCarthy  (UX, Usability Testing)\n* Robert Slater  (Requirements)\n* Dena Strong    (UX, Usability Testing)\n\n### Sponsors\n\n* Disability Resources and Educational Services (DRES), College of Applied\n  Health Sciences (AHS), University of Illinois at Urbana-Champaign\n* Illinois Extension, College of Agricultural, Consumer and Environmental\n  Sciences (ACES), University of Illinois at Urbana-Champaign\n* The University Library, Innovation Fund (Jemma Ku, P.I.), University of\n  Illinois at Urbana-Champaign\n* Administrative Information Technology Services (AITS), University of\n  Illinois at Urbana-Champaign\n* School of Information Sciences (iSchool), University of Illinois at\n  Urbana-Champaign\n\n### Acknowledgements\n\nMany of the ideas and motivations for the A11yFirst Project were the result\nof work done previously by a group of software developers at the Illinois\nDepartment of Human Services (DHS), led by Mike Scott, who created the OneNet\ncontent management system, which includes as its centerpiece an accessible\nWYSIWYG editor.\n\nThe OneNet CMS has been in use by the Illinois DHS since 2006 to promote\naccessible authoring for their intranet and main website.\n\nMr. Scott also participated in the requirements gathering phase of the\nA11yFirst Project.\n"}},"codemirror":{"copyright":"Copyright CodeMirror © Marijn Haverbeke. All rights reserved.","dlgTitle":"About CodeMirror Source Plugin","moreInfoShortcuts":"Available Shortcuts","moreInfoShortcuts1":"<strong>CTRL + K</strong> to comment the currently selected text","moreInfoShortcuts2":"<strong>CTRL + SHIFT + K</strong> to uncomment currently selected text","moreInfoShortcuts3":"<strong>CTRL + ALT + K</strong> to auto format currently selected text","moreInfoShortcuts4":"<strong>CTRL + Q</strong> Expand / Collapse Code Block","moreInfoShortcuts5":"<strong>CTRL + F</strong> to perform a search","moreInfoShortcuts6":"<strong>CTRL + G</strong> to find next","moreInfoShortcuts7":"<strong>CTRL + SHIFT + G</strong> to find previous","moreInfoShortcuts8":"<strong>CTRL + SHIFT</strong> to find and replace","moreInfoShortcuts9":"<strong>CTRL + SHIFT + R</strong> to find and replace all","toolbar":"Источник","searchCode":"Найти в источнике","replaceCode":"Replace Code (CTRL + SHIFT + F)","autoFormat":"Форматировать выбранное значение","commentSelectedRange":"Закомментировать выбранное значение","uncommentSelectedRange":"Раскомментировать выбранное значение","autoCompleteToggle":"Включить/отключить автозаполнение тегов HTML"},"emoji":{"searchPlaceholder":"Search emoji…","searchLabel":"Input field responsible for searching and filtering emoji inside panel.","navigationLabel":"Groups navigation for emoji sections.","title":"Emoji List","groups":{"people":"People","nature":"Nature and animals","food":"Food and drinks","travel":"Travel and places","activities":"Activities","objects":"Objects","symbols":"Symbols","flags":"Flags"}},"html5video":{"button":"Вставить HTML5 видео","title":"HTML5 видео","infoLabel":"Видео","allowed":"Допустимые расширения файлов: MP4, WebM, Ogv","urlMissing":"Не выбран источник видео","videoProperties":"Свойства видео","upload":"Загрузить","btnUpload":"Загрузить на сервер","advanced":"Дополнительно","autoplay":"Автовоспроизведение","allowdownload":"Разрешить загрузку","advisorytitle":"Пояснительный текст","yes":"Да","no":"Нет","responsive":"Адаптивная ширина","controls":"Показать элементы управления","loop":"Зациклить","poster":"Постер"},"sourcedialog":{"toolbar":"Исходник","title":"Источник"}};