<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ml;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetStats extends AbstractEndpoint
{
    protected $node_id;
    protected $stat;

    public function getURI(): string
    {
        $node_id = $this->node_id ?? null;
        $stat = $this->stat ?? null;
        if (isset($node_id) && isset($stat)) {
            return '/_plugins/_ml/' . rawurlencode($node_id) . '/stats/' . rawurlencode($stat);
        }
        if (isset($node_id)) {
            return '/_plugins/_ml/' . rawurlencode($node_id) . '/stats';
        }
        if (isset($stat)) {
            return '/_plugins/_ml/stats/' . rawurlencode($stat);
        }
        return '/_plugins/_ml/stats';
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setNodeId($node_id): static
    {
        if (is_null($node_id)) {
            return $this;
        }
        $this->node_id = $node_id;

        return $this;
    }

    public function setStat($stat): static
    {
        if (isset($stat) !== true) {
            return $this;
        }
        if (is_array($stat) === true) {
            $stat = implode(",", $stat);
        }
        $this->stat = $stat;

        return $this;
    }
}
