<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Security;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class GetNodeCertificates extends AbstractEndpoint
{
    protected $node_id;

    public function getURI(): string
    {
        $node_id = $this->node_id ?? null;
        if (isset($node_id)) {
            return '/_plugins/_security/api/certificates/' . rawurlencode($node_id);
        }
        throw new RuntimeException('Missing parameter for the endpoint security.get_node_certificates');
    }

    public function getParamWhitelist(): array
    {
        return [
            'cert_type',
            'timeout',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function setNodeId($node_id): static
    {
        if (is_null($node_id)) {
            return $this;
        }
        $this->node_id = $node_id;

        return $this;
    }
}
