<?php
/**
 * Copyright 2019 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\AdobeStockImageApi\Api;

use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NotFoundException;

/**
 * Download the image from Adobe Stock API that is already licensed
 *
 * @api
 */
interface SaveLicensedImageInterface
{
    /**
     * Save licensed version of already licensed image
     *
     * @param int $mediaId
     * @param string $destinationPath
     * @throws CouldNotSaveException
     * @throws LocalizedException
     * @throws NotFoundException
     */
    public function execute(int $mediaId, ?string $destinationPath = null): void;
}
