<?php

/* System - Initialisation
----------------------------------------------------------*/

if (!defined('PARENT')) {
  include(PATH . 'control/system/headers/403.php');
}

use Detection\MobileDetect;

//---------------------------------
// Additional options.
//---------------------------------

include(PATH . 'control/' . (file_exists(PATH . 'control/user-options.php') ? 'user-' : '') . 'options.php');

//-------------------------
// Database connection.
//-------------------------

include(PATH . 'control/functions.php');
if(file_exists(PATH . 'control/_cfg.php')){include(PATH . 'control/_cfg.php');}else{die('File "control/_cfg.php" is missing, please see installation instructions.');}
include(PATH . 'control/db.php');
mswSQL_connect();

//------------------------
// Other include files.
//------------------------

mswfileController();
include(PATH . 'control/system/core/mm.php');
include(PATH . 'control/classes/system/class.tags.php');
include(PATH . 'control/classes/system/class.parser.php');
include(PATH . 'control/classes/system/class.mail.php');
include(PATH . 'control/classes/system/class.datetime.php');
include(PATH . 'control/classes/class.system.php');
include(PATH . 'control/classes/class.imap.php');
include(PATH . 'control/classes/class.tickets.php');
include(PATH . 'control/classes/class.accounts.php');
include(PATH . 'control/classes/class.fields.php');
include(PATH . 'control/classes/class.faq.php');
include(PATH . 'control/classes/system/class.page.php');
include(PATH . 'control/classes/system/class.json.php');
include(PATH . 'control/classes/class.social.php');
include(PATH . 'control/classes/system/class.captcha.php');
include(PATH . 'control/timezones.php');

//--------------------------
// Login credentials.
//--------------------------

define('MS_PERMISSIONS', (!defined('CRON_RUN') ? mswIsUserLoggedIn($SSN) : 'guest'));

//----------------------
// Load settings.
//----------------------

if (!in_array(DB_PREFIX . 'settings', mswSQL_tablestatus())) {
  header("Location: install/index.php");
  exit;
}

$SETTINGS = mswSQL_fetchobj(mswSQL_query("SELECT * FROM `" . DB_PREFIX . "settings` LIMIT 1", __file__, __line__));
$mswLangSetLoader = ($SETTINGS->langSets ? unserialize($SETTINGS->langSets) : []);

//-----------------------
// Security Tokens
//-----------------------

include(PATH . 'control/tokens.php');

//--------------------------
// For search.
//--------------------------

if (isset($_GET['keys'])) {
  $_GET['p'] = 'search';
}

//----------------------
// Default vars.
//----------------------

$cmd               = (isset($_GET['p']) ? $_GET['p'] : 'home');
$page              = (isset($_GET['next']) && $_GET['next'] > 0 ? (int) $_GET['next'] : '1');
$title             = '';
$eString           = [];
$eFields           = [];
$ticketAttachments = [];
$attachString      = '';
$ticketSystemMsg   = '';
$limit             = (isset($_GET['limit']) ? (int) $_GET['limit'] : 25);
$limitvalue        = $page * $limit - ($limit);
$ms_js_css_loader  = [];
$mswUploadDropzone = [];
$cssJsBlockParams  = [];
$jsHTML            = '';

//------------------------
// Initiate classes.
//------------------------

$MSPARSER           = new msDataParser();
$MSDT               = new msDateTime();
$MSYS               = new msSystem();
$MSTICKET           = new tickets();
$MSFIELDS           = new customFieldManager();
$MSMAIL             = new msMail();
$FAQ                = new msFAQ();
$MSACC              = new accountSystem();
$MSJSON             = new jsonHandler();
$SOCIAL             = new social();
$CPHA               = new captcha();
$SANTAGS            = new tags();
$DETECT             = new MobileDetect();
$MSPARSER->settings = $SETTINGS;
$MSDT->settings     = $SETTINGS;
$MSTICKET->parser   = $MSPARSER;
$MSTICKET->settings = $SETTINGS;
$MSTICKET->datetime = $MSDT;
$MSTICKET->fields   = $MSFIELDS;
$MSTICKET->system   = $MSYS;
$MSYS->settings     = $SETTINGS;
$MSYS->datetime     = $MSDT;
$MSFIELDS->parser   = $MSPARSER;
$MSFIELDS->dt       = $MSDT;
$MSACC->settings    = $SETTINGS;
$MSACC->ssn         = $SSN;
$FAQ->settings      = $SETTINGS;
$FAQ->dt            = $MSDT;
$FAQ->ssn           = $SSN;
$SOCIAL->json       = $MSJSON;
$SOCIAL->settings   = $SETTINGS;
$SOCIAL->ssn        = $SSN;

//---------------------------------
// Loaders
//---------------------------------

if ($SETTINGS->language == '' || !is_dir(PATH . 'content/language/' . $SETTINGS->language)) {
  if (is_dir(PATH . 'content/language/english')) {
    $SETTINGS->language = 'english';
    mswSQL_query("UPDATE `" . DB_PREFIX . "settings` SET `language` = 'english'", __file__, __line__);
  } else {
    die('Error: Language folder <b>' . PATH . 'content/language/' . $SETTINGS->language . '</b> does NOT exist');
  }
}

if (MS_PERMISSIONS != 'guest') {
  $LI_ACC = $MSACC->ms_user();
  define('LANG_PATH', PATH . 'content/language/' . ($LI_ACC->language && is_dir(PATH . 'content/language/' . $LI_ACC->language) ? $LI_ACC->language : $SETTINGS->language) . '/');
  define('MSTZ_SET', (in_array($LI_ACC->timezone, array_keys($timezones)) ? $LI_ACC->timezone : $SETTINGS->timezone));
  date_default_timezone_set(MSTZ_SET);
  define('MS_TEMPLATE_SET', (isset($mswLangSetLoader[$LI_ACC->language]) && is_dir(PATH . 'content/' . $mswLangSetLoader[$LI_ACC->language]) ? $mswLangSetLoader[$LI_ACC->language] : '_default_set'));
  define('MSW_LOGGED_IN', 'yes');
  // Force password update for password reset.
  if (!isset($_GET['lo']) && !isset($_GET['ajax'])) {
    if ($LI_ACC->system2 == 'forcepasschange' && $cmd != 'profile') {
      header("Location: index.php?p=profile");
      exit;
    }
  }
} else {
  define('LANG_PATH', PATH . 'content/language/' . $SETTINGS->language . '/');
  define('MSTZ_SET', $SETTINGS->timezone);
  date_default_timezone_set($SETTINGS->timezone);
  define('MS_TEMPLATE_SET', (isset($mswLangSetLoader[$SETTINGS->language]) && is_dir(PATH . 'content/' . $mswLangSetLoader[$SETTINGS->language]) ? $mswLangSetLoader[$SETTINGS->language] : '_default_set'));
  define('MSW_LOGGED_IN', 'no');
}

//-------------------------
// Load language files.
//-------------------------

include_once(LANG_PATH . 'lang1.php');
include_once(LANG_PATH . 'lang2.php');
include_once(LANG_PATH . 'lang3.php');
include_once(LANG_PATH . 'lang4.php');
include_once(LANG_PATH . 'lang5.php');
include_once(LANG_PATH . 'lang6.php');
include_once(LANG_PATH . 'lang7.php');
include_once(LANG_PATH . 'lang8.php');
include_once(LANG_PATH . 'lang9.php');
include_once(LANG_PATH . 'lang10.php');

/* CHECK FOR UPGRADE RUN
---------------------------------------*/

if ($SETTINGS->offlineReason == 'msw-offline-run') {
  echo $mspubliclang4_4[3];
  exit;
}

//----------------------------------------------
// If all we want is the captcha, create it
//----------------------------------------------

if ($SETTINGS->en_cap == 'yes' && isset($_GET['load_c']) && $SSN->active('csrf_token') == 'yes' 
  && $_GET['load_c'] == $SSN->get('csrf_token')) {
  $code = $CPHA->code();
  $CPHA->show($code);
}

//----------------------------
// Status and levels
//----------------------------

include(PATH . 'control/system/loader.php');

//----------------------------
// Callback parameters.
//----------------------------

$cmd = $MSYS->callback($cmd);
if ($SETTINGS->tawk_home == 'yes' && $cmd != 'home') {
  define('KILL_TAWK', 1);
}

//-------------------------------------------------
// Tickets by Email - Incoming from cronjob/tab
//-------------------------------------------------

if (isset($argv[1])) {
  parse_str($argv[1], $cronp);
  $cronid = ($argv[1] ? $argv[1] : (isset($cronp['pipe']) ? $cronp['pipe'] : '0'));
  if (strpos($cronid, '=') !== false) {
    $chopcron = explode('=', $cronid);
    $cronid = (isset($chopcron[1]) ? trim($chopcron[1]) : '');
  }
  define('IMAP_CRON_ID', (int) $cronid);
  if (isset($argv[2])) {
    parse_str($argv[2], $cronp2);
    $cronlg = (isset($lang[0]) ? $lang[0] : (isset($cronp2[1]) ? $cronp2[1] : ''));
    if ($cronlg) {
      if (is_dir(PATH . 'content/language/' . $cronlg)) {
        define('IMAP_CRON_LANG', $cronlg);
      } else {
        echo str_replace('{file}', PATH . 'content/language/' . $cronlg, $imap_cron_output_err2);
        exit;
      }
    }
  }
  if (IMAP_CRON_ID > 0) {
    define('CRON_RUN', 1);
    $cmd = $SETTINGS->imap_param;
  } else {
    echo $imap_cron_output_err;
    exit;
  }
}

/* LATTE CFG
---------------------------------------*/

if (!defined('CRON_RUN')) {
  $latte->setTempDirectory(PATH . 'content/' . MS_TEMPLATE_SET . '/cache/');
  $latte->setLoader(new \Latte\Loaders\FileLoader(PATH . 'content/' . MS_TEMPLATE_SET));
}

//-----------------------------------------
// Is system disabled or account disabled
//-----------------------------------------

if ($SETTINGS->sysstatus == 'no') {
  include(PATH . 'control/system/disabled.php');
  exit;
} else {
  if (isset($LI_ACC->enabled) && $LI_ACC->enabled == 'no' && !isset($_GET['lo'])) {
    include(PATH . 'control/system/accounts/account-suspended.php');
    exit;
  }
}

//---------------------------------
// Check licence for email digest
//---------------------------------

if (isset($_SERVER['PHP_SELF']) && !defined('LIC_DEV') && basename($_SERVER['PHP_SELF']) == 'email-digest.php') {
  if (LICENCE_VER == 'locked') {
    die('Fatal Error: Email Digest Only available with a commercial licence. <a href="https://www.' . SCRIPT_URL . '/purchase.html">Purchase Licence</a>');
  }
}

/* PLATFORM DETECTION
---------------------------------------*/
define('MSW_PFDTCT', ($DETECT->isMobile() ? ($DETECT->isTablet() ? 'tablet' : 'mobile') : 'pc'));

?>