<?php

/* Admin - System Module
----------------------------------------------------------*/

if (!defined('PARENT')) {
  include(PATH . 'control/system/header/403.php');
}

// Access..
if (!in_array($cmd, $userAccess) && USER_ADMINISTRATOR != 'yes') {
  include(PATH . 'control/system/header/403.php');
}

// Department check for filter..
if (isset($_GET['dept'])) {
  // Are we viewing assigned department?
  if (substr($_GET['dept'], 0, 1) == 'u') {
    if (USER_ADMINISTRATOR == 'no' && $MSTEAM->id != substr($_GET['dept'], 1)) {
      include(PATH . 'control/system/header/403.php');
    }
  } else{
    if (mswDeptPerms($_GET['dept'], $userDeptAccess) == 'fail') {
      include(PATH . 'control/system/header/403.php');
    }
  }
}

if (isset($_POST['re-open'])) {
  $_POST['ticket'] = $_POST['id'];
  $rows            = $MSTICKET->reOpenTicket();
  // If rows were affected, write log for each ticket..
  if ($rows > 0) {
    foreach ($_POST['ticket'] AS $tID) {
      $MSTICKET->historyLog($tID, str_replace(array(
        '{user}'
      ), array(
        $MSTEAM->name
      ), $msg_ticket_history['ticket-status-reopen']));
    }
  }
  $OK2 = true;
}

// Call relevant classes..
include_once(BASE_PATH . 'control/classes/class.tickets.php');
$MSPTICKETS           = new tickets();
$MSPTICKETS->settings = $SETTINGS;
$MSPTICKETS->datetime = $MSDT;
$MSPTICKETS->parser   = $MSPARSER;
$title                = (isset($ticketStatusSel['close'][0]) ? $ticketStatusSel['close'][0] : $msg_adheader6);

include(PATH . 'content/header.php');
include(PATH . 'content/system/tickets/tickets-closed.php');
include(PATH . 'content/footer.php');

?>