/**
 * Bootbox.js — alert, confirm, prompt, and flexible dialogs for the Bootstrap framework 
 * @version: 6.0.0
 * @project: https://github.com/makeusabrew/bootbox
 * @license: MIT http://bootboxjs.com/license.txt
 */
!function(e,t){'use strict';'function'==typeof define&&define.amd?define(['jquery'],t):'object'==typeof exports?module.exports=t(require('jquery')):e.bootbox=t(e.jQuery)}(this,function t(s,c){'use strict';let r={};r.VERSION='6.0.0';let i={en:{OK:'OK',CANCEL:'Cancel',CONFIRM:'OK'}},d={dialog:'<div class="bootbox modal" tabindex="-1" role="dialog" aria-hidden="true"><div class="modal-dialog"><div class="modal-content"><div class="modal-body"><div class="bootbox-body"></div></div></div></div></div>',header:'<div class="modal-header"><h5 class="modal-title"></h5></div>',footer:'<div class="modal-footer"></div>',closeButton:'<button type="button" class="bootbox-close-button close btn-close" aria-hidden="true" aria-label="Close"></button>',form:'<form class="bootbox-form"></form>',button:'<button type="button" class="btn"></button>',option:'<option value=""></option>',promptMessage:'<div class="bootbox-prompt-message"></div>',inputs:{text:'<input class="bootbox-input bootbox-input-text form-control" autocomplete="off" type="text" />',textarea:'<textarea class="bootbox-input bootbox-input-textarea form-control"></textarea>',email:'<input class="bootbox-input bootbox-input-email form-control" autocomplete="off" type="email" />',select:'<select class="bootbox-input bootbox-input-select form-select"></select>',checkbox:'<div class="form-check checkbox"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-checkbox" type="checkbox" /></label></div>',radio:'<div class="form-check radio"><label class="form-check-label"><input class="form-check-input bootbox-input bootbox-input-radio" type="radio" name="bootbox-radio" /></label></div>',date:'<input class="bootbox-input bootbox-input-date form-control" autocomplete="off" type="date" />',time:'<input class="bootbox-input bootbox-input-time form-control" autocomplete="off" type="time" />',number:'<input class="bootbox-input bootbox-input-number form-control" autocomplete="off" type="number" />',password:'<input class="bootbox-input bootbox-input-password form-control" autocomplete="off" type="password" />',range:'<input class="bootbox-input bootbox-input-range form-control-range" autocomplete="off" type="range" />'}},u={locale:'en',backdrop:'static',animate:!0,className:null,closeButton:!0,show:!0,container:'body',value:'',inputType:'text',errorMessage:null,swapButtonOrder:!1,centerVertical:!1,multiple:!1,scrollable:!1,reusable:!1,relatedTarget:null,size:null,id:null};function l(e,t,o){return s.extend(!0,{},e,function(e,t){var o=e.length;let a={};if(o<1||2<o)throw new Error('Invalid argument length');return 2===o||'string'==typeof e[0]?(a[t[0]]=e[0],a[t[1]]=e[1]):a=e[0],a}(t,o))}function p(e,t,a,r){let o;r&&r[0]&&(o=r[0].locale||u.locale,(r[0].swapButtonOrder||u.swapButtonOrder)&&(t=t.reverse()));e={className:'bootbox-'+e,buttons:function(o,a){let r={};for(let t=0,e=o.length;t<e;t++){let e=o[t];var n=e.toLowerCase(),l=e.toUpperCase();r[n]={label:function(e,t){t=i[t];return(t||i.en)[e]}(l,a)}}return r}(t,o)};{e=l(e,r,a);var n=t;let o={};return f(n,function(e,t){o[t]=!0}),f(e.buttons,function(e){if(o[e]===c)throw new Error('button key "'+e+'" is not allowed (options are '+n.join(' ')+')')}),e}}function b(e){return Object.keys(e).length}function f(e,o){let a=0;s.each(e,function(e,t){o(e,t,a++)})}function m(e){e.data.dialog.find('.bootbox-accept').first().trigger('focus')}function h(e){e.target===e.data.dialog[0]&&e.data.dialog.remove()}function C(e){e.target===e.data.dialog[0]&&(e.data.dialog.off('escape.close.bb'),e.data.dialog.off('click'))}function O(e,t,o){e.stopPropagation(),e.preventDefault(),s.isFunction(o)&&!1===o.call(t,e)||t.modal('hide')}function w(e){return/([01][0-9]|2[0-3]):[0-5][0-9]?:[0-5][0-9]/.test(e)}function g(e){return/(\d{4})-(\d{2})-(\d{2})/.test(e)}return r.locales=function(e){return e?i[e]:i},r.addLocale=function(e,o){return s.each(['OK','CANCEL','CONFIRM'],function(e,t){if(!o[t])throw new Error('Please supply a translation for "'+t+'"')}),i[e]={OK:o.OK,CANCEL:o.CANCEL,CONFIRM:o.CONFIRM},r},r.removeLocale=function(e){if('en'===e)throw new Error('"en" is used as the default and fallback locale and cannot be removed.');return delete i[e],r},r.setLocale=function(e){return r.setDefaults('locale',e)},r.setDefaults=function(){let e={};return 2===arguments.length?e[arguments[0]]=arguments[1]:e=arguments[0],s.extend(u,e),r},r.hideAll=function(){return s('.bootbox').modal('hide'),r},r.init=function(e){return t(e||s)},r.dialog=function(t){if(s.fn.modal===c)throw new Error('"$.fn.modal" is not defined; please double check you have included the Bootstrap JavaScript library. See https://getbootstrap.com/docs/5.1/getting-started/introduction/ for more details.');t=function(a){let r,n;if('object'!=typeof a)throw new Error('Please supply an object of options');if(!a.message)throw new Error('"message" option must not be null or an empty string.');(a=s.extend({},u,a)).backdrop?a.backdrop='string'!=typeof a.backdrop||'static'!==a.backdrop.toLowerCase()||'static':a.backdrop=!1!==a.backdrop&&0!==a.backdrop&&'static';a.buttons||(a.buttons={});return r=a.buttons,n=b(r),f(r,function(e,t,o){if(s.isFunction(t)&&(t=r[e]={callback:t}),'object'!==s.type(t))throw new Error('button with key "'+e+'" must be an object');if(t.label||(t.label=e),!t.className){let e=!1;e=a.swapButtonOrder?0===o:o===n-1,n<=2&&e?t.className='btn-primary':t.className='btn-secondary btn-default'}}),a}(t),s.fn.modal.Constructor.VERSION?(t.fullBootstrapVersion=s.fn.modal.Constructor.VERSION,l=t.fullBootstrapVersion.indexOf('.'),t.bootstrap=t.fullBootstrapVersion.substring(0,l)):(t.bootstrap='2',t.fullBootstrapVersion='2.3.2',console.warn('Bootbox will *mostly* work with Bootstrap 2, but we do not officially support it. Please upgrade, if possible.'));let o=s(d.dialog),e=o.find('.modal-dialog'),a=o.find('.modal-body'),r=s(d.header),n=s(d.footer);var l=t.buttons;let i={onEscape:t.onEscape};if(a.find('.bootbox-body').html(t.message),0<b(t.buttons)&&(f(l,function(e,t){let o=s(d.button);switch(o.data('bb-handler',e),o.addClass(t.className),e){case'ok':case'confirm':o.addClass('bootbox-accept');break;case'cancel':o.addClass('bootbox-cancel')}o.html(t.label),t.id&&o.attr({id:t.id}),!0===t.disabled&&o.prop({disabled:!0}),n.append(o),i[e]=t.callback}),a.after(n)),!0===t.animate&&o.addClass('fade'),t.className&&o.addClass(t.className),t.id&&o.attr({id:t.id}),t.size)switch(t.fullBootstrapVersion.substring(0,3)<'3.1'&&console.warn('"size" requires Bootstrap 3.1.0 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.'),t.size){case'small':case'sm':e.addClass('modal-sm');break;case'large':case'lg':e.addClass('modal-lg');break;case'extra-large':case'xl':e.addClass('modal-xl'),t.fullBootstrapVersion.substring(0,3)<'4.2'&&console.warn('Using size "xl"/"extra-large" requires Bootstrap 4.2.0 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.')}if(t.scrollable&&(e.addClass('modal-dialog-scrollable'),t.fullBootstrapVersion.substring(0,3)<'4.3'&&console.warn('Using "scrollable" requires Bootstrap 4.3.0 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.')),t.title||t.closeButton){if(t.title?r.find('.modal-title').html(t.title):r.addClass('border-0'),t.closeButton){let e=s(d.closeButton);t.bootstrap<5&&e.html('<i class="fa fa-times fa-fw bootbutton"></i>'),t.bootstrap<4?r.prepend(e):r.append(e)}a.before(r)}if(t.centerVertical&&(e.addClass('modal-dialog-centered'),t.fullBootstrapVersion<'4.0.0'&&console.warn('"centerVertical" requires Bootstrap 4.0.0-beta.3 or higher. You appear to be using '+t.fullBootstrapVersion+'. Please upgrade to use this option.')),t.reusable||(o.one('hide.bs.modal',{dialog:o},C),o.one('hidden.bs.modal',{dialog:o},h)),t.onHide){if(!s.isFunction(t.onHide))throw new Error('Argument supplied to "onHide" must be a function');o.on('hide.bs.modal',t.onHide)}if(t.onHidden){if(!s.isFunction(t.onHidden))throw new Error('Argument supplied to "onHidden" must be a function');o.on('hidden.bs.modal',t.onHidden)}if(t.onShow){if(!s.isFunction(t.onShow))throw new Error('Argument supplied to "onShow" must be a function');o.on('show.bs.modal',t.onShow)}if(o.one('shown.bs.modal',{dialog:o},m),t.onShown){if(!s.isFunction(t.onShown))throw new Error('Argument supplied to "onShown" must be a function');o.on('shown.bs.modal',t.onShown)}if(!0===t.backdrop){let t=!1;o.on('mousedown','.modal-content',function(e){e.stopPropagation(),t=!0}),o.on('click.dismiss.bs.modal',function(e){t||e.target!==e.currentTarget||o.trigger('escape.close.bb')})}return o.on('escape.close.bb',function(e){i.onEscape&&O(e,o,i.onEscape)}),o.on('click','.modal-footer button:not(.disabled)',function(e){var t=s(this).data('bb-handler');t!==c&&O(e,o,i[t])}),o.on('click','.bootbox-close-button',function(e){O(e,o,i.onEscape)}),o.on('keyup',function(e){27===e.which&&o.trigger('escape.close.bb')}),s(t.container).append(o),o.modal({backdrop:t.backdrop,keyboard:!1,show:!1}),t.show&&o.modal('show',t.relatedTarget),o},r.alert=function(){let e;if((e=p('alert',['ok'],['message','callback'],arguments)).callback&&!s.isFunction(e.callback))throw new Error('alert requires the "callback" property to be a function when provided');return e.buttons.ok.callback=e.onEscape=function(){return!s.isFunction(e.callback)||e.callback.call(this)},r.dialog(e)},r.confirm=function(){let e;if(e=p('confirm',['cancel','confirm'],['message','callback'],arguments),s.isFunction(e.callback))return e.buttons.cancel.callback=e.onEscape=function(){return e.callback.call(this,!1)},e.buttons.confirm.callback=function(){return e.callback.call(this,!0)},r.dialog(e);throw new Error('confirm requires a callback')},r.prompt=function(){let n,t,e,l;var o,a;let i;if(e=s(d.form),(n=p('prompt',['cancel','confirm'],['title','callback'],arguments)).value||(n.value=u.value),n.inputType||(n.inputType=u.inputType),o=(n.show===c?u:n).show,n.show=!1,n.buttons.cancel.callback=n.onEscape=function(){return n.callback.call(this,null)},n.buttons.confirm.callback=function(){let t;if('checkbox'===n.inputType)t=l.find('input:checked').map(function(){return s(this).val()}).get();else if('radio'===n.inputType)t=l.find('input:checked').val();else{let e=l[0];if(n.errorMessage&&e.setCustomValidity(''),e.checkValidity&&!e.checkValidity())return n.errorMessage&&e.setCustomValidity(n.errorMessage),e.reportValidity&&e.reportValidity(),!1;t='select'===n.inputType&&!0===n.multiple?l.find('option:selected').map(function(){return s(this).val()}).get():l.val()}return n.callback.call(this,t)},!n.title)throw new Error('prompt requires a title');if(!s.isFunction(n.callback))throw new Error('prompt requires a callback');if(!d.inputs[n.inputType])throw new Error('Invalid prompt type');switch(l=s(d.inputs[n.inputType]),n.inputType){case'text':case'textarea':case'email':case'password':l.val(n.value),n.placeholder&&l.attr('placeholder',n.placeholder),n.pattern&&l.attr('pattern',n.pattern),n.maxlength&&l.attr('maxlength',n.maxlength),n.required&&l.prop({required:!0}),n.rows&&!isNaN(parseInt(n.rows))&&'textarea'===n.inputType&&l.attr({rows:n.rows});break;case'date':case'time':case'number':case'range':if(l.val(n.value),n.placeholder&&l.attr('placeholder',n.placeholder),n.pattern?l.attr('pattern',n.pattern):'date'===n.inputType?l.attr('pattern','d{4}-d{2}-d{2}'):'time'===n.inputType&&l.attr('pattern','d{2}:d{2}'),n.required&&l.prop({required:!0}),'date'!==n.inputType&&n.step){if(!('any'===n.step||!isNaN(n.step)&&0<parseFloat(n.step)))throw new Error('"step" must be a valid positive number or the value "any". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-step for more information.');l.attr('step',n.step)}!function(e,t,o){let a=!1,r=!0,n=!0;if('date'===e)t===c||(r=g(t))?o===c||(n=g(o))||console.warn('Browsers which natively support the "date" input type expect date values to be of the form "YYYY-MM-DD" (see ISO-8601 https://www.iso.org/iso-8601-date-and-time-format.html). Bootbox does not enforce this rule, but your max value may not be enforced by this browser.'):console.warn('Browsers which natively support the "date" input type expect date values to be of the form "YYYY-MM-DD" (see ISO-8601 https://www.iso.org/iso-8601-date-and-time-format.html). Bootbox does not enforce this rule, but your min value may not be enforced by this browser.');else if('time'===e){if(t!==c&&!(r=w(t)))throw new Error('"min" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.');if(o!==c&&!(n=w(o)))throw new Error('"max" is not a valid time. See https://www.w3.org/TR/2012/WD-html-markup-20120315/datatypes.html#form.data.time for more information.')}else{if(t!==c&&isNaN(t))throw r=!1,new Error('"min" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-min for more information.');if(o!==c&&isNaN(o))throw n=!1,new Error('"max" must be a valid number. See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.')}if(r&&n){if(o<=t)throw new Error('"max" must be greater than "min". See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-max for more information.');a=!0}return a}(n.inputType,n.min,n.max)||(n.min!==c&&l.attr('min',n.min),n.max!==c&&l.attr('max',n.max));break;case'select':let r={};if(i=n.inputOptions||[],!s.isArray(i))throw new Error('Please pass an array of input options');if(!i.length)throw new Error('prompt with "inputType" set to "select" requires at least one option');n.required&&l.prop({required:!0}),n.multiple&&l.prop({multiple:!0}),f(i,function(e,t){let o=l;if(t.value===c||t.text===c)throw new Error('each option needs a "value" property and a "text" property');t.group&&(r[t.group]||(r[t.group]=s('<optgroup />').attr('label',t.group)),o=r[t.group]);let a=s(d.option);a.attr('value',t.value).text(t.text),o.append(a)}),f(r,function(e,t){l.append(t)}),l.val(n.value),n.bootstrap<5&&l.removeClass('form-select').addClass('form-control');break;case'checkbox':let t=s.isArray(n.value)?n.value:[n.value];if(!(i=n.inputOptions||[]).length)throw new Error('prompt with "inputType" set to "checkbox" requires at least one option');l=s('<div class="bootbox-checkbox-list"></div>'),f(i,function(e,o){if(o.value===c||o.text===c)throw new Error('each option needs a "value" property and a "text" property');let a=s(d.inputs[n.inputType]);a.find('input').attr('value',o.value),a.find('label').append('\n'+o.text),f(t,function(e,t){t===o.value&&a.find('input').prop('checked',!0)}),l.append(a)});break;case'radio':if(n.value!==c&&s.isArray(n.value))throw new Error('prompt with "inputType" set to "radio" requires a single, non-array value for "value"');if(!(i=n.inputOptions||[]).length)throw new Error('prompt with "inputType" set to "radio" requires at least one option');l=s('<div class="bootbox-radiobutton-list"></div>');let a=!0;f(i,function(e,t){if(t.value===c||t.text===c)throw new Error('each option needs a "value" property and a "text" property');let o=s(d.inputs[n.inputType]);o.find('input').attr('value',t.value),o.find('label').append('\n'+t.text),n.value!==c&&t.value===n.value&&(o.find('input').prop('checked',!0),a=!1),l.append(o)}),a&&l.find('input[type="radio"]').first().prop('checked',!0)}return e.append(l),e.on('submit',function(e){e.preventDefault(),e.stopPropagation(),t.find('.bootbox-accept').trigger('click')}),''!==s.trim(n.message)&&(a=s(d.promptMessage).html(n.message),e.prepend(a)),n.message=e,(t=r.dialog(n)).off('shown.bs.modal',m),t.on('shown.bs.modal',function(){l.focus()}),!0===o&&t.modal('show'),t},r}),function(e,t){'use strict';'function'==typeof define&&define.amd?define(['bootbox'],t):'object'==typeof module&&module.exports?t(require('./bootbox')):t(e.bootbox)}(this,function(e){'use strict';e.addLocale('ar',{OK:'موافق',CANCEL:'الغاء',CONFIRM:'تأكيد'}),e.addLocale('az',{OK:'OK',CANCEL:'İmtina et',CONFIRM:'Təsdiq et'}),e.addLocale('bg-BG',{OK:'Ок',CANCEL:'Отказ',CONFIRM:'Потвърждавам'}),e.addLocale('cs',{OK:'OK',CANCEL:'Zrušit',CONFIRM:'Potvrdit'}),e.addLocale('da',{OK:'OK',CANCEL:'Annuller',CONFIRM:'Accepter'}),e.addLocale('de',{OK:'OK',CANCEL:'Abbrechen',CONFIRM:'Akzeptieren'}),e.addLocale('el',{OK:'Εντάξει',CANCEL:'Ακύρωση',CONFIRM:'Επιβεβαίωση'}),e.addLocale('en',{OK:'OK',CANCEL:'Cancel',CONFIRM:'OK'}),e.addLocale('es',{OK:'OK',CANCEL:'Cancelar',CONFIRM:'Aceptar'}),e.addLocale('et',{OK:'OK',CANCEL:'Katkesta',CONFIRM:'OK'}),e.addLocale('eu',{OK:'OK',CANCEL:'Ezeztatu',CONFIRM:'Onartu'}),e.addLocale('fa',{OK:'قبول',CANCEL:'لغو',CONFIRM:'تایید'}),e.addLocale('fi',{OK:'OK',CANCEL:'Peruuta',CONFIRM:'OK'}),e.addLocale('fr',{OK:'OK',CANCEL:'Annuler',CONFIRM:'Confirmer'}),e.addLocale('he',{OK:'אישור',CANCEL:'ביטול',CONFIRM:'אישור'}),e.addLocale('hr',{OK:'OK',CANCEL:'Odustani',CONFIRM:'Potvrdi'}),e.addLocale('hu',{OK:'OK',CANCEL:'Mégsem',CONFIRM:'Megerősít'}),e.addLocale('id',{OK:'OK',CANCEL:'Batal',CONFIRM:'OK'}),e.addLocale('it',{OK:'OK',CANCEL:'Annulla',CONFIRM:'Conferma'}),e.addLocale('ja',{OK:'OK',CANCEL:'キャンセル',CONFIRM:'確認'}),e.addLocale('ka',{OK:'OK',CANCEL:'გაუქმება',CONFIRM:'დადასტურება'}),e.addLocale('ko',{OK:'OK',CANCEL:'취소',CONFIRM:'확인'}),e.addLocale('lt',{OK:'Gerai',CANCEL:'Atšaukti',CONFIRM:'Patvirtinti'}),e.addLocale('lv',{OK:'Labi',CANCEL:'Atcelt',CONFIRM:'Apstiprināt'}),e.addLocale('nl',{OK:'OK',CANCEL:'Annuleren',CONFIRM:'Accepteren'}),e.addLocale('no',{OK:'OK',CANCEL:'Avbryt',CONFIRM:'OK'}),e.addLocale('pl',{OK:'OK',CANCEL:'Anuluj',CONFIRM:'Potwierdź'}),e.addLocale('pt-BR',{OK:'OK',CANCEL:'Cancelar',CONFIRM:'Sim'}),e.addLocale('pt',{OK:'OK',CANCEL:'Cancelar',CONFIRM:'Confirmar'}),e.addLocale('ru',{OK:'OK',CANCEL:'Отмена',CONFIRM:'Применить'}),e.addLocale('sk',{OK:'OK',CANCEL:'Zrušiť',CONFIRM:'Potvrdiť'}),e.addLocale('sl',{OK:'OK',CANCEL:'Prekliči',CONFIRM:'Potrdi'}),e.addLocale('sq',{OK:'OK',CANCEL:'Anulo',CONFIRM:'Prano'}),e.addLocale('sv',{OK:'OK',CANCEL:'Avbryt',CONFIRM:'OK'}),e.addLocale('sw',{OK:'Sawa',CANCEL:'Ghairi',CONFIRM:'Thibitisha'}),e.addLocale('ta',{OK:'சரி',CANCEL:'ரத்து செய்',CONFIRM:'உறுதி செய்'}),e.addLocale('th',{OK:'ตกลง',CANCEL:'ยกเลิก',CONFIRM:'ยืนยัน'}),e.addLocale('tr',{OK:'Tamam',CANCEL:'İptal',CONFIRM:'Onayla'}),e.addLocale('uk',{OK:'OK',CANCEL:'Відміна',CONFIRM:'Прийняти'}),e.addLocale('vi',{OK:'OK',CANCEL:'Hủy bỏ',CONFIRM:'Xác nhận'}),e.addLocale('zh-CN',{OK:'OK',CANCEL:'取消',CONFIRM:'确认'}),e.addLocale('zh-TW',{OK:'OK',CANCEL:'取消',CONFIRM:'確認'})});