<?php

/* CLASS FILE
----------------------------------*/

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

define('INSTALL_PATH', __dir__ . '/../../../');

class msMail extends PHPMailer {

  // Send protocol.
  // smtp or mail
  public $sendProtocol = 'smtp';

  // Host.
  public $smtp_host = 'localhost';

  // Port.
  public $smtp_port = '';

  // User/Pass.
  public $smtp_user = '';
  public $smtp_pass = '';

  // Security.
  public $smtp_sec = '';

  // Debug.
  public $debug = 'no';

  // Mail switch.
  public $mailSwitch = 'yes';

  // Charset.
  public $charset = 'utf-8';

  // Mail tags array.
  public $vars = [];

  // Custom mail headers.
  public $xheaders = [];

  // Attachments.
  public $attachments = [];

  // Settings.
  public $config = [];

  // Mail debug log.
  private $debug_log_file = 'mail-debug-log.log';

  // Allow insecure connections.
  // Use at your own risk.
  // yes or no value
  public $allowInsecure = 'no';
  
  // Converts entities.
  private function convertChar($data, $type = 'html') {
    $f_s = array(
      '&#039;' => '\'',
      '&quot;' => '"',
      '&amp;' => '&',
      '&lt;' => '<',
      '&gt;' => '>'
    );
    $data = strtr(mswCD($data), $f_s);
    // Script tags remain sanitized.
    return preg_replace('#<script(.*?)>(.*?)</script>#is', '', $data);
  }

  // Loads tags into array.
  public function addTag($placeholder, $data) {
    $this->vars[$placeholder] = mswSH($data);
  }

  // Clears data vars.
  public function clearVars() {
    $this->vars = [];
  }

  // Converts tags.
  private function convertTags($data) {
    if (!empty($this->vars)) {
      foreach ($this->vars AS $tags => $value) {
        $data = str_replace($tags, $value, $data);
      }
    }
    return $data;
  }

  // Cleans spam/form injection input.
  private function mailRep($data) {
    $find    = array(
      "\r",
      "\n",
      "%0a",
      "%0d",
      "content-type:",
      "Content-Type:",
      "BCC:",
      "CC:",
      "boundary=",
      "TO:",
      "bcc:",
      "to:",
      "cc:"
    );
    $replace = [];
    return str_replace($find, $replace, $data);
  }

  // Loads email template.
  public function template($file) {
    // Is this a template or just text?
    if (substr(strtolower($file), -4) == '.txt') {
      return (file_exists($file) ? trim(mswTmp($file)) : 'An error occurred opening the "' . $file . '" file. Check that this file exists in the correct "content/language/*/mail-templates/" folder.');
    }
    return $file;
  }

  // HTML mail wrapper.
  public function htmlWrap($tmp) {
    global $MSPARSER;
    $msg   = msMail::convertTags(msMail::template($tmp['template']));
    if (isset($tmp['dep']['message']) && $tmp['dep']['message']) {
      $msg = msMail::convertTags($tmp['dep']['message']);
    }
    $parse = explode('<-{separater}->', $msg);
    // Check for 3 slots, eg: 2 separators.
    if (count($parse) == 3) {
      $head = trim($parse[0]);
      $cont = trim($parse[1]);
      $foot = trim($parse[2]);
    } else {
      $head = mswCD($this->config['website']);
      $cont = str_replace('<-{separater}->', '', trim($msg));
      $foot = mswCD($this->config['scriptpath']);
    }
    // Auto parse hyperlinks.
    $head = msMail::convertChar($MSPARSER->_links($head));
    $cont = msMail::convertChar($MSPARSER->_links($cont));
    $foot = msMail::convertChar($MSPARSER->_links($foot));
    // Auto parse line breaks.
    $head = mswNL2BR($head);
    $cont = mswNL2BR($cont);
    $foot = mswNL2BR($foot);
    // Parse html message with wrapper.
    $find = array(
      '{CHARSET}',
      '{TITLE}',
      '{HEADER}',
      '{CONTENT}',
      '{FOOTER}'
    );
    $repl = array(
      $this->charset,
      mswSH($this->config['website']),
      $head,
      $cont,
      $foot . mswNL2BR(msMail::appendFT('html'))
    );
    // Language override.
    if (isset($tmp['language'])) {
      $this->config['language'] = $tmp['language'];
    }
    $html = str_replace($find, $repl, mswTmp(INSTALL_PATH . 'content/language/' . $this->config['language'] . '/mail-templates/html-wrapper.html'));
    return $html;
  }

  // Plain text separator.
  private function plainTxtSep() {
    return str_repeat('-', 50);
  }

  // Plain text mail wrapper.
  public function plainWrap($tmp) {
    $msg   = msMail::convertChar(msMail::convertTags(msMail::template($tmp['template']), 'plain'));
    if (isset($tmp['dep']['message']) && $tmp['dep']['message']) {
      $msg = msMail::convertTags($tmp['dep']['message']);
    }
    $parse = explode('<-{separater}->', $msg);
    // Check for 3 slots, eg: 2 separators.
    if (count($parse) == 3) {
      $head = trim((string) strip_tags((string) $parse[0]));
      $cont = trim((string) strip_tags((string) $parse[1]));
      $foot = trim((string) strip_tags((string) $parse[2]));
    } else {
      $head = mswCD(strip_tags((string) $this->config['website']));
      $cont = trim(strip_tags((string) $msg));
      $foot = mswCD(strip_tags($this->config['scriptpath']));
    }
    return $head . mswNL() . msMail::plainTxtSep() . mswNL(2) . $cont . mswNL(2) . msMail::plainTxtSep() . mswNL() . $foot . msMail::appendFT();
  }

  // Footer for free version.
  // Please don`t remove the footer unless you have purchased a licence.
  // https://www.maiansupport.com/purchase.html
  private function appendFT($type = 'plain') {
    $string = '';
    if (!defined('LICENCE_VER') || LICENCE_VER == 'unlocked') {
      return '';
    }
    switch($type) {
      case 'plain':
        $string  = mswNL(2);
        $string .= 'Free ' . SCRIPT_DESC . ' Powered by ' . SCRIPT_NAME . mswNL();
        $string .= 'https://www.' . SCRIPT_URL;
        break;
      case 'html':
        $string  = mswNL(2);
        $string .= 'Free ' . SCRIPT_DESC . ' Powered by ' . SCRIPT_NAME . mswNL();
        $string .= '<a href="https://www.' . SCRIPT_URL . '">https://www.' . SCRIPT_URL . '</a>';
        break;
    }
    return $string;
  }

  // Sends mail.
  public function sendMSMail($mail = []) {
    try {
      if ($this->mailSwitch == 'yes') {
        switch($this->sendProtocol) {
          case 'smtp':
          default:
            $this->isSMTP();
            $this->Port       = $this->smtp_port;
            $this->Host       = $this->smtp_host;
            $this->SMTPAuth   = ($this->smtp_user && $this->smtp_pass ? true : false);
            $this->SMTPSecure = (in_array($this->smtp_sec, array(
              '',
              'tls',
              'ssl'
            )) ? $this->smtp_sec : '');
            // Allow insecure connections?
            if ($this->allowInsecure == 'yes') {
              $this->SMTPOptions = array(
                'ssl' => array(
                  'verify_peer' => false,
                  'verify_peer_name' => false,
                  'allow_self_signed' => true
                )
              );
            }
            // Keep connection alive.
            if (isset($mail['alive'])) {
              $this->SMTPKeepAlive = true;
            }
            $this->Username = $this->smtp_user;
            $this->Password = $this->smtp_pass;
            $this->CharSet  = ($this->charset ? $this->charset : 'utf-8');
            // Enable debug.
            if ($this->debug == 'yes') {
              $this->SMTPDebug = 2;
              $this->Debugoutput = function($str, $level) {
                mswFPC(INSTALL_PATH . 'logs/' . $this->debug_log_file, $str . (function_exists('mswNL') ? mswNL() : PHP_EOL));
              };
            }
            // Custom mail headers.
            if (!empty($this->xheaders)) {
              foreach ($this->xheaders AS $k => $v) {
                $this->addCustomHeader($k . ':' . $v);
              }
            }
            // From/to headers.
            $this->From     = msMail::mailRep($mail['from_email']);
            $this->FromName = msMail::mailRep(msMail::convertChar($mail['from_name']));
            $this->addAddress(msMail::mailRep($mail['to_email']), msMail::mailRep(msMail::convertChar($mail['to_name'])));
            // Reply to.
            if (!empty($mail['replyto'])) {
              $this->addReplyTo($mail['replyto']['email'], $mail['replyto']['name']);
            }
            // Additional standard addresses.
            if (isset($mail['add-emails']) && $mail['add-emails']) {
              $addEmails = array_map('trim', explode(',', $mail['add-emails']));
              if (!empty($addEmails)) {
                foreach ($addEmails AS $aAddresses) {
                  $this->addAddress(msMail::mailRep($aAddresses), msMail::mailRep(msMail::convertChar($mail['to_name'])));
                }
              }
            }
            // Carbon copy addresses.
            if (!empty($mail['cc'])) {
              foreach ($mail['cc'] AS $cc_email => $cc_name) {
                $this->addCC($cc_email, $cc_name);
              }
            }
            // Blind carbon copy addresses.
            if (!empty($mail['bcc'])) {
              foreach ($mail['bcc'] AS $bcc_email => $bcc_name) {
                $this->addBCC($bcc_email, $bcc_name);
              }
            }
            $this->WordWrap = 1000;
            // Subject.
            $this->Subject  = (isset($mail['dep']['subject']) && $mail['dep']['subject'] ? msMail::convertTags($mail['dep']['subject']) : msMail::convertChar($mail['subject']));
            // Message body.
            switch($this->config['smtp_html']) {
              case 'yes':
                $this->MsgHTML(msMail::htmlWrap($mail));
                $this->AltBody = msMail::plainWrap($mail);
                break;
              default:
                $this->Body = msMail::plainWrap($mail);
                break;
            }
            // Attachments.
            if (!empty($this->attachments)) {
              foreach ($this->attachments AS $f => $n) {
                $this->addAttachment($f, $n);
              }
            }
            break;
          case 'mail':
            $this->isMail();
            $this->Port     = $this->smtp_port;
            $this->Host     = $this->smtp_host;
            $this->CharSet  = ($this->charset ? $this->charset : 'utf-8');
            // Custom mail headers.
            if (!empty($this->xheaders)) {
              foreach ($this->xheaders AS $k => $v) {
                $this->addCustomHeader($k . ':' . $v);
              }
            }
            $this->setFrom(msMail::mailRep($mail['from_email']), msMail::mailRep(msMail::convertChar($mail['from_name'])));
            $this->addAddress(msMail::mailRep($mail['to_email']), msMail::mailRep(msMail::convertChar($mail['to_name'])));
            // Additional standard addresses.
            if (isset($mail['add-emails']) && $mail['add-emails']) {
              $addEmails = array_map('trim', explode(',', $mail['add-emails']));
              if (!empty($addEmails)) {
                foreach ($addEmails AS $aAddresses) {
                  $this->addAddress(msMail::mailRep($aAddresses), msMail::mailRep(msMail::convertChar($mail['to_name'])));
                }
              }
            }
            // Reply to.
            if (!empty($mail['replyto'])) {
              $this->addReplyTo($mail['replyto']['email'], $mail['replyto']['name']);
            }
            // Attachments.
            if (!empty($this->attachments)) {
              foreach ($this->attachments AS $f => $n) {
                $this->addAttachment($f, $n);
              }
            }
            // Carbon copy addresses.
            if (!empty($mail['cc'])) {
              foreach ($mail['cc'] AS $cc_email => $cc_name) {
                $this->addCC($cc_email, $cc_name);
              }
            }
            // Blind carbon copy addresses.
            if (!empty($mail['bcc'])) {
              foreach ($mail['bcc'] AS $bcc_email => $bcc_name) {
                $this->addBCC($bcc_email, $bcc_name);
              }
            }
            $this->Subject  = (isset($mail['dep']['subject']) && $mail['dep']['subject'] ? msMail::convertTags($mail['dep']['subject']) : msMail::convertChar($mail['subject']));
            $this->Body     = msMail::plainWrap($mail);
            break;
        }
        // Send mail.
        $this->Send();
        // Clear all recipient data.
        $this->ClearReplyTos();
        $this->ClearAllRecipients();
      }
    } catch(Exception $e) {
      mswFPC(INSTALL_PATH . 'logs/' . $this->debug_log_file, $e->getMessage() . (function_exists('mswNL') ? mswNL() : PHP_EOL));
    } catch(Error $e) {
      mswFPC(INSTALL_PATH . 'logs/' . $this->debug_log_file, $e->getMessage() . (function_exists('mswNL') ? mswNL() : PHP_EOL));
    }
  }

}

//---------------------------------------------------
// Check licence ver - please do not alter or change
//---------------------------------------------------

if (!defined('LICENCE_VER') || !class_exists('mswLic')) {
  die(@base64_decode('U3lzdGVtIGVycm9yLCBwbGVhc2UgY29udGFjdCBNYWlhbk1lZGlhIEAgPGEgaHJlZj0iaHR0cHM6Ly93d3cubWFpYW5tZWRpYS5jb20vY29udGFjdCI+aHR0cHM6Ly93d3cubWFpYW5tZWRpYS5jb20vY29udGFjdDwvYT48YnI+PGJyPlNvcnJ5IGZvciB0aGUgaW5jb252ZW5pZW5jZS4='));
}

?>