<?php

/* System - Accounts
----------------------------------------------------------*/

if (!defined('PARENT') || !defined('MS_PERMISSIONS')) {
  include(PATH . 'control/system/headers/403.php');
}

define('HISTORY_VIEW', 1);

// Check log in.
if (MS_PERMISSIONS == 'guest' || !isset($LI_ACC->id)) {
  header("Location:index.php?p=login");
  exit;
}

// Variables.
$pageNumbers = '';
$title       = (isset($_GET['qt']) ? $msg_portal17 : $msg_header11);
$dataCount   = $MSTICKET->ticketList(MS_PERMISSIONS, array(
  $limitvalue,
  $limit
), true);

// Pagination.
if ($dataCount > $limit) {
  define('PER_PAGE', $limit);
  $PTION       = new pagination(array($dataCount, $msg_script42, $page), $SETTINGS->scriptpath . '/?p=' . $_GET['p'] . '&amp;next=');
  $pageNumbers = $PTION->display();
}

include(PATH . 'control/header.php');

// Filters.
include(PATH . 'control/system/accounts/account-history-filters.php');

// Show.
$templateParams = [
  'TXT' => array(
    $msg_header11,
    $msg_header3,
    str_replace('{count}', $dataCount, $msg_public_history),
    $msg_header4,
    $msg_viewticket25,
    $msg_open36,
    $msg_open37,
    $msg_public_history2,
    $msg_public_history3,
    $msg_script45,
    $msg_search20,
    $msg_viewticket107,
    $msg_response6,
    $msg_public_history13,
    $msg_portal12
  ),
  'TICKETS' => $MSTICKET->ticketList(MS_PERMISSIONS, array(
    $limitvalue,
    $limit
  )),
  'PAGES' => $pageNumbers,
  'IS_DISPUTED' => 'no',
  'DD_ORDER' => $orderBy,
  'DD_FILTERS' => $filterBy,
  'DD_DEPT' => $deptFilter
];


// Global vars.
include(PATH . 'control/global.php');

// Load template.
$latte->render('account-history.tpl', $templateParams);

include(PATH . 'control/footer.php');

?>