<?php if (!defined('PARENT')) { exit; }
if (SHOW_ADMIN_DASHBOARD_GRAPH) {
  $curYearEnd = date('Y', $MSDT->mswTimeStamp());
  $curYear = $curYearEnd;
  $lastYear = strtotime(date('Y-m-d H:i:s', strtotime('last year')));
  // Check for variable tampering
  if (isset($_GET['y1'], $_GET['y2']) && strlen($_GET['y1']) == 4 && strlen($_GET['y2']) == 4) {
    $lYear = preg_replace('/[^0-9]/', '', $_GET['y1']);
    $cYear = preg_replace('/[^0-9]/', '', $_GET['y2']);
    if (checkdate(01,01,$cYear) && checkdate(01,01,$lYear)) {
      $lastYear = strtotime('01-01-' . $lYear);
      $curYear = $cYear;
    }
  }
  include(PATH . 'control/classes/class.graphs.php');
  $tz               = ($MSTEAM->timezone ? $MSTEAM->timezone : $SETTINGS->timezone);
  $graph            = new graphs();
  $graph->settings  = $SETTINGS;
  $graph->datetime  = $MSDT;
  $graph->team      = $MSTEAM;
  $graph->years     = array(date('Y', $lastYear), $curYear);
  $gdata            = $graph->home($ticketFilterAccess);
  $firstYear        = $graph->firstYear($ticketFilterAccess);
  define('JS_LOADER', 'home-graph.php');
}
define('LOADED_HOME', 1);
define('LOAD_DATE_PICKERS', 1);
?>
  <div class="container margin-top-container min-height-container push" id="mscontainer">
    <div class="row">
      <?php
      if (SHOW_ADMIN_DASHBOARD_GRAPH) {
        include(PATH . 'content/system/home/graph.php');
      }
      ?>
      <div class="col-lg-<?php echo (SHOW_ADMIN_DASHBOARD_GRAPH ? '4' : '12'); ?>">
        <?php
        include(PATH . 'content/system/home/panel.php');
        ?>
      </div>
    </div>

    <div class="row">
      <div class="col-lg-12">
        <?php
        include(PATH . 'content/system/home/tickets.php');
        ?>
      </div>
    </div>
  </div>