<?php

/* MODULES
--------------------------------------------------*/

$modules = array(
  array(
    'MySQLi',
    'mysqli_connect',
    'function',
    'https://php.net/manual/en/book.mysqli.php'
  ),
  array(
    'Curl',
    'curl_init',
    'function',
    'https://php.net/manual/en/book.curl.php'
  ),
  array(
    'Imap',
    'imap_open',
    'function',
    'https://php.net/manual/en/book.imap.php'
  ),
  array(
    'Json',
    'json_encode',
    'function',
    'https://php.net/manual/en/book.json.php'
  ),
  array(
    'SimpleXML',
    'simplexml_load_string',
    'function',
    'https://php.net/manual/en/book.simplexml.php'
  ),
  array(
    'Password Hash Api',
    'password_hash',
    'function',
    'https://php.net/manual/en/book.password.php'
  )
);

$modules[] = array(
  'OpenSSL',
  'openssl_encrypt',
  'function',
  'https://www.php.net/manual/en/ref.openssl.php'
);

/* PERMISSIONS
---------------------------------------------------*/

$permissions = array(
  'content/_default_set/cache',
  'content/attachments',
  'content/attachments-faq',
  'logs'
);

/* CHARACTER SETS
---------------------------------------------------*/

$cSets = mswSQL_charsets();

/* UPGRADE OPS
---------------------------------------------------*/

$ops   = [];
$ops[] = 'Add New Database Tables';
$ops[] = 'Updating Imap Settings';
$ops[] = 'Updating Settings';
$ops[] = 'Updating Tickets and Replies';
$ops[] = 'Updating Accounts';
$ops[] = 'Updating Staff';
$ops[] = 'Updating F.A.Q';
$ops[] = 'Updating Departments, Categories and Standard Responses';
$ops[] = 'Updating Indexes';
$ops[] = 'Clean up and Finish';

?>
