<?php
/*
The functionality to log and block brute-forced login attempts.
This file is part of miniBB. miniBB is a free discussion forums/message board software, supplied with no warranties.
Check COPYING file for more details.
Copyright (C) 2020 Paul Puzyrev. www.minibb.com
Latest File Update: 2021-03-16
*/

if (!defined('INCLUDED776')) die ('Fatal error.');

//clean-up expired records
$delres=db_delete($GLOBALS['Tl'], 'blocked_until', '<', "'".date('Y-m-d H:i:s')."'");
if($delres>0){
addToLog($fla_logFile, $fla_logLang['delete'].' '.$delres);
}

//check for currently available records. If they meet the current configuration, we will just display an error message.
$thisIp=getIP();
$forcedAccount=array();
$forcedAttempts=0;
$lockedFromLogins=FALSE;

if($row=db_simpleSelect(0, $GLOBALS['Tl'], 'forced_amount, forced_id', 'forced_ip', '=', $thisIp)){
do{
$forcedAccount[$row[1]]=$row[0];
}
while($row=db_simpleSelect(1));

foreach($forcedAccount as $key=>$val) $forcedAttempts+=$val;

if($fla_mode==1){
//strict mode
if($forcedAttempts>=$fla_attempts) $lockedFromLogins=TRUE;
}
else{
if(sizeof($forcedAccount)>=$fla_manyAttemptsLimit and $forcedAttempts>=($fla_attempts*$fla_manyAttemptsLimit)) {
$lockedFromLogins=TRUE;
}
}

if($lockedFromLogins){

$user_id=0;
if(!defined('PAGE1_OFFSET')) define('PAGE1_OFFSET', 0);
include($pathToFiles.'lang/'.$lang.'.php');

$blocked_until=date('Y-m-d H:i:s', time()+$fla_blockPeriod);
$blocked_until_lng=convert_date($blocked_until);
updateArray(array('blocked_until'), $Tl, 'forced_ip', $thisIp);

addToLog($fla_logFile, $fla_logLang['update'].': '.$thisIp.' -- '.$blocked_until);

//if($fla_mode==1){
$errorMSG=str_replace(array('{LOCKED_IP}', '{LOCKED_DATE}'), array($thisIp, $blocked_until_lng), $l_flaBlockedGeneral);
//}
//else{
//$errorMSG=str_replace(array('{LOCKED_IP}', '{LOCKED_DATE}', '{LOCKED_ACCOUNT}'), array($thisIp, $blocked_until_lng, $uname), $l_flaBlockedAccount);
//}

/* auto ban */
if($fla_mode==2 and $fla_autoBanned){
if($row=db_simpleSelect(0, $Tb, 'id', 'banip', '=', $thisIp)) {}
else{
$banip=$thisIp;
$banreason=$l_flaBannedReason;
$banwhen=date('Y-m-d H:i:s');
insertArray(array('banip', 'banreason', 'banwhen'), $Tb);
addToLog($fla_logFile, $fla_logLang['autoban'].': '.$banip);
}
}

$correctErr='';
$title=$l_forbidden; $loginError=1;
echo load_header(); echo ParseTpl(makeUp('main_warning')); display_footer(); exit;

}

}

?>