<?php
/*
This file is part of miniBB. miniBB is free discussion forums/message board software, supplied with no warranties.
See COPYING file for more details.
Copyright (C) 2019 Paul Puzyrev www.minibb.com
Latest File Update: 2025-12-07
*/
if (!defined('INCLUDED776')) die ('Fatal error.');

$version='3.7';

if($DB=='mysql' or $DB=='mysqli' or $DB=='pgsql') $caseComp='lower'; elseif($DB=='mssql') $caseComp='lcase';

//--------------->
function makeUp($name,$addDir='') {
if($addDir=='') {
if(isset($GLOBALS['is_mobile']) and $GLOBALS['is_mobile'] and substr($name,0,5)=='email') $addDir=$GLOBALS['pathToFiles'].'templates/';
elseif(isset($GLOBALS['pathToTpl'])) $addDir=$GLOBALS['pathToTpl'];
else $addDir=$GLOBALS['pathToFiles'].'templates/';
}
if(isset($GLOBALS['forumClone']) and $GLOBALS['forumClone']!='' and ($name=='main_header' or $name=='main_footer') ) $addDir=$GLOBALS['pathToFiles'].$GLOBALS['forumClone'].'/templates/';
if (substr($name,0,5)=='email') $ext='txt'; else $ext='html';
$fload=$addDir.$name.'.'.$ext;
if(!file_exists($fload)) {
//an attempt to look up in the original folder
$fload=$GLOBALS['pathToFiles'].'templates/'.$name.'.'.$ext;
}
if(file_exists($fload)) {
$fd=fopen($fload, 'r');
$tpl=fread($fd, filesize($fload));
fclose($fd);
//parsing for standards compatible email templates
if($ext=='txt' and substr_count($tpl, "\r\n")>0) $tpl=str_replace("\r\n", "\n", $tpl);
return $tpl;
}
else die ("TEMPLATE NOT FOUND: $fload");
}

//--------------->
function ParseTpl($tpl){
$qs=array();
$qv=array();
$ex=explode ('{$',$tpl);
$exs=sizeof($ex);
for ($i=0; $i<$exs; $i++) {
if (substr_count($ex[$i],'}')>0) {
$xx=explode('}',$ex[$i]);
if (substr_count($xx[0],'[')>0) {
$clr=explode ('[',$xx[0]); $sp=str_replace('$','',substr($clr[1],0,strlen($clr[1])-1)); if(!is_integer($sp) and isset($GLOBALS[$sp])) $sp=$GLOBALS[$sp]; $clr=$clr[0];
if (!in_array($clr,$qs)) $qs[]=$clr;
if(isset($GLOBALS[$clr][$sp])) $to=$GLOBALS[$clr][$sp]; else $to='';
}
else {
if(!in_array($xx[0], $qv)) $qv[]=$xx[0];
if(isset($GLOBALS[$xx[0]])) $to=$GLOBALS[$xx[0]]; else $to='';
}
$tpl=str_replace('{$'.$xx[0].'}', $to, $tpl);
}
}
return $tpl;
}

//--------------->
function load_header() {
//we need to load this template separately, because we load page title
if(!isset($GLOBALS['forum'])) $GLOBALS['forum']=0;
if(!isset($GLOBALS['topic'])) $GLOBALS['topic']=0;
if(!isset($GLOBALS['page'])) $GLOBALS['page']=0;
if(!isset($GLOBALS['user_id'])) $GLOBALS['user_id']=0;
if(isset($GLOBALS['is_mobile']) and $GLOBALS['is_mobile'] and isset($GLOBALS['pathToTpl'])) $isMobileHd=TRUE; else $isMobileHd=FALSE;
foreach($GLOBALS['l_menu'] as $key=>$val) $GLOBALS['l_menu'.$key]=$val;

define('HEADER_CALLED', 1);

if(!isset($GLOBALS['adminPanel'])) $GLOBALS['adminPanel']=0;

if(!($GLOBALS['action']=='' and $GLOBALS['page']==PAGE1_OFFSET+1) or (isset($GLOBALS['adminPanel']) and $GLOBALS['adminPanel']==1) or (isset($_POST['mode']) and $_POST['mode']=='login') ) {
if(!$isMobileHd) $GLOBALS['l_menu'][0]="<a href=\"{$GLOBALS['main_url']}/{$GLOBALS['startIndex']}\" class=\"mnblnk\">{$GLOBALS['l_menu'][0]}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][0]="<option value=\"{$GLOBALS['main_url']}/{$GLOBALS['startIndex']}\">{$GLOBALS['l_menu'][0]}</option>";
}
else $GLOBALS['l_menu'][0]='';

if($GLOBALS['action']!='stats') {
if(!$isMobileHd) $GLOBALS['l_menu'][3]="<a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=stats\" class=\"mnblnk\">{$GLOBALS['l_menu'][3]}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][3]="<option value=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=stats\">{$GLOBALS['l_menu'][3]}</option>";
}
else $GLOBALS['l_menu'][3]='';


if($GLOBALS['viewTopicsIfOnlyOneForum']==1 and $GLOBALS['action']=='vtopic') {
$GLOBALS['l_menu'][7]="<a href=\"#newtopic\" class=\"mnblnk\">{$GLOBALS['l_menu'][7]}</a> ".$GLOBALS['l_sepr'].' ';
}
elseif(isset($GLOBALS['nTop']) and $GLOBALS['nTop']==1 and (!isset($_GET['showSep']) or $_GET['showSep']!=1)){
if($GLOBALS['action']=='vtopic' and isset($_GET['showSep'])) $GLOBALS['l_menu'][7]=(isset($GLOBALS['newTopicLink'])?$GLOBALS['newTopicLink'].' '.$GLOBALS['l_sepr'].' ':'');
elseif($GLOBALS['action']=='vtopic') $GLOBALS['l_menu'][7]="<a href=\"#newtopic\" class=\"mnblnk\">{$GLOBALS['l_menu'][7]}</a> {$GLOBALS['l_sepr']} ";
elseif($GLOBALS['action']=='vthread') $GLOBALS['l_menu'][7]="<a href=\"#newreply\" class=\"mnblnk\">{$GLOBALS['l_reply']}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][7]='';
}
elseif(isset($GLOBALS['mTop']) and $GLOBALS['mTop']==1 and $GLOBALS['action']=='') $GLOBALS['l_menu'][7]="<a href=\"#newtopic\" class=\"mnblnk\">{$GLOBALS['l_menu'][7]}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][7]='';
if($isMobileHd){
if($GLOBALS['l_menu'][7]!='') {
$GLOBALS['l_menu'][7]=preg_replace("#<a href=\"(.+?)\"(.+?)>(.+?)</a>#", '<a href="\\1"><img src="'.$GLOBALS['main_url'].'/img/mobi/button_newtopic.svg" alt="" title="" style="width:20px;height:auto"></a>', $GLOBALS['l_menu'][7]);
}
}


if($GLOBALS['action']!='search') {
if(!$isMobileHd) $GLOBALS['l_menu'][1]="<a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=search\" class=\"mnblnk\">{$GLOBALS['l_menu'][1]}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][1]="<option value=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=search\">{$GLOBALS['l_menu'][1]}</option>";
}
else $GLOBALS['l_menu'][1]='';

if($GLOBALS['action']!='registernew' and isset($GLOBALS['user_id']) and $GLOBALS['user_id']==0 and $GLOBALS['adminPanel']!=1 and $GLOBALS['enableNewRegistrations']) {
if(!$isMobileHd) $GLOBALS['l_menu'][2]="<a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=registernew\" class=\"mnblnk\" rel=\"nofollow\">{$GLOBALS['l_menu'][2]}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][2]="<option value=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=registernew\">{$GLOBALS['l_menu'][2]}</option>";
}
else $GLOBALS['l_menu'][2]='';

if($GLOBALS['action']!='manual') {
if(isset($GLOBALS['mod_rewrite']) and $GLOBALS['mod_rewrite']) $urlp=$GLOBALS['manualIndex']; else $urlp="{$GLOBALS['indexphp']}action=manual";
if(!$isMobileHd) $GLOBALS['l_menu'][4]="<a href=\"{$GLOBALS['main_url']}/{$urlp}\" class=\"mnblnk\">{$GLOBALS['l_menu'][4]}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][4]="<option value=\"{$GLOBALS['main_url']}/{$urlp}\">{$GLOBALS['l_menu'][4]}</option>";
}
else $GLOBALS['l_menu'][4]='';

if( ($GLOBALS['action']=='prefs' and isset($GLOBALS['adminUser']) and $GLOBALS['adminUser']==0) or (isset($GLOBALS['user_id']) and $GLOBALS['user_id']==0) or !$GLOBALS['enableProfileUpdate']) {
$GLOBALS['l_menu'][5]='';
}
else {
if(!$isMobileHd) $GLOBALS['l_menu'][5]="<b><a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=prefs\" class=\"mnblnk\" title=\"{$GLOBALS['l_menu'][5]}\">{$GLOBALS['user_usr']}</a></b> <span class=\"txtSm\">&raquo;</span> ";
else $GLOBALS['l_menu'][5]="<option value=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=prefs\">{$GLOBALS['l_menu'][5]}</option>";
}

if(isset($GLOBALS['user_id']) and $GLOBALS['user_id']!=0) {
if(!$isMobileHd) $GLOBALS['l_menu'][6]="{$GLOBALS['l_menu'][5]} <a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}mode=logout\" class=\"mnblnk\">{$GLOBALS['l_logout']}</a> {$GLOBALS['l_sepr']} ";
else $GLOBALS['l_menu'][6]="<option value=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}mode=logout\">{$GLOBALS['l_logout']}</option>";
}
else $GLOBALS['l_menu'][6]='';

$menuLogin='<a href="javascript:showTopLogin();" rel="nofollow" class="mnblnk">'.$GLOBALS['l_enterforums'].'</a> '.$GLOBALS['l_sepr'].' ';
$displayTopLogin=FALSE;

if($GLOBALS['user_id']==0){
if($GLOBALS['action']=='registernew' or $GLOBALS['action']=='register'){
$menuLogin='';
}
else{
if($GLOBALS['signInEachPage']==1){
$displayTopLogin=TRUE;
if($GLOBALS['action']=='' and sizeof($_GET)==0 and sizeof($_POST)==0) {
$GLOBALS['topLoginDisplay']='block';
$menuLogin='';
}
else{
$GLOBALS['topLoginDisplay']='none';
}
}
elseif($GLOBALS['signInEachPage']==2){
$displayTopLogin=TRUE;
$GLOBALS['topLoginDisplay']='none';
}
elseif($GLOBALS['signInEachPage']==3){
$displayTopLogin=TRUE;
$GLOBALS['topLoginDisplay']='block';
$menuLogin='';
if(!$isMobileHd) $GLOBALS['l_menu'][2]='';
}
else{
if($GLOBALS['action']=='' and sizeof($_GET)==0 and sizeof($_POST)==0) {
$GLOBALS['topLoginDisplay']='block';
$displayTopLogin=TRUE;
}
$menuLogin='';
}
}
}
else{
$menuLogin='';
}
$GLOBALS['l_menuLogin']=$menuLogin;

if (!isset($GLOBALS['title']) or $GLOBALS['title']=='') $GLOBALS['title']=$GLOBALS['sitename'];

/* Canonical URLs */
$canonicalUrl=''; if(!isset($GLOBALS['canonicalMeta'])) $GLOBALS['canonicalMeta']='';
if(sizeof($_GET)==0 and sizeof($_POST)==0){
$canonicalUrl=$GLOBALS['main_url'].'/';
}
if($GLOBALS['action']=='' and $GLOBALS['page']>PAGE1_OFFSET+1){
if($GLOBALS['sortingTopics']==1) { $urlp=$GLOBALS['main_url'].'/'.$GLOBALS['indexphp'].'sortBy=1'; $urlType='Gen'; }
else{
if(isset($GLOBALS['mod_rewrite']) and $GLOBALS['mod_rewrite']) { $urlp=$GLOBALS['main_url']; $urlType='Extranavmr'; }
else { $urlp="{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}";  $urlType='Extranav'; }
}
$canonicalUrl=str_replace('&amp;', '%26', call_user_func('add'.$urlType.'URLPage', $urlp, $GLOBALS['page']));
}
if($GLOBALS['action']=='userinfo' and isset($GLOBALS['user']) and (int)$GLOBALS['user']>0){
$canonicalUrl="{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=userinfo%26user=".(int)$GLOBALS['user'];
}
if($GLOBALS['action']=='vthread'){
if(isset($GLOBALS['mod_rewrite']) and $GLOBALS['mod_rewrite']) {
$origUrl=addTopicURLPage(genTopicURL($GLOBALS['main_url'], $GLOBALS['forum'], $GLOBALS['forumName'], $GLOBALS['topic'], $GLOBALS['topicData'][0]), $GLOBALS['page']);
}
else{
$origUrl=addGenURLPage("{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=vthread%26forum={$GLOBALS['forum']}%26topic={$GLOBALS['topic']}", $GLOBALS['page'], '%26');
}
$canonicalUrl=$origUrl;
}
if($GLOBALS['action']=='vtopic'){
if(isset($GLOBALS['mod_rewrite']) and $GLOBALS['mod_rewrite']) {
$origUrl=addForumURLPage(genForumURL($GLOBALS['main_url'], $GLOBALS['forum'], $GLOBALS['forumName']), $GLOBALS['page']);
}
else{
$origUrl=addGenURLPage("{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=vtopic%26forum={$GLOBALS['forum']}", $GLOBALS['page'], '%26');
}
$canonicalUrl=$origUrl;
}
if($canonicalUrl!='') $GLOBALS['canonicalMeta']="\n<link rel=\"canonical\" href=\"{$canonicalUrl}\">";
/* --Canonical URLs */

if(isset($GLOBALS['includeHeader']) and $GLOBALS['includeHeader']!='') { include($GLOBALS['includeHeader']); return; }

$tplMenu=makeUp('main_header');

if(!$displayTopLogin) $tplMenu=preg_replace("#<!--toplogin-->(.+?)<!--/toplogin-->#is", '', $tplMenu);

if((isset($GLOBALS['is_mobile_test']) and $GLOBALS['is_mobile_test']) or (isset($GLOBALS['is_mobile_browser']) and $GLOBALS['is_mobile_browser'])){
}
else $tplMenu=preg_replace("#<!--mobileMenuSwitch-->(.+?)<!--/mobileMenuSwitch-->#is", '', $tplMenu);

if(isset($GLOBALS['removeBlocks']) and is_array($GLOBALS['removeBlocks'])){
$rmbl=array(); $rmrpl=array();
foreach($GLOBALS['removeBlocks'] as $r=>$w){
$rmbl[]="#<!--{$r}-->(.+?)<!--/{$r}-->#is";
$rmrpl[]=$w;
}
$tplMenu=preg_replace($rmbl, $rmrpl, $tplMenu);
}

return ParseTpl($tplMenu);
}

//--------------->
function getAccess($clForums, $clForumsUsers, $user_id){
$forb=array();
$acc='n';
if(sizeof($clForums)>0){
foreach($clForums as $f){
if (isset($clForumsUsers[$f]) and !in_array($user_id, $clForumsUsers[$f])){
$forb[]=$f; $acc='m';
}
}
}
if ($acc=='m') return $forb; else return $acc;
}

//--------------->
function getIP(){
$iPv4RegExp='/^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/';
//$iPv6RegExp='/^[0-9a-fA-F:]+$/';
$iPv6RegExp='(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))';
$ip1=trim($_SERVER['REMOTE_ADDR']);
if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) $ip2=trim($_SERVER['HTTP_X_FORWARDED_FOR']); else $ip2='';
if($ip2!='' and ( (preg_match($iPv4RegExp, $ip2) and $long=ip2long($ip2) and !($long == -1 || $long === FALSE) ) or preg_match($iPv6RegExp, $ip2) ) ) $finalIP=$ip2;
elseif($ip1!='' and ( (preg_match($iPv4RegExp, $ip1) and $long=ip2long($ip1) and !($long == -1 || $long === FALSE) ) or preg_match($iPv6RegExp, $ip1) ) ) $finalIP=$ip1;
else $finalIP='0.0.0.0';
if($finalIP=='::1') $finalIP='127.0.0.1';
if($finalIP!='') $finalIP=substr($finalIP,0,45);
return $finalIP;
}

//--------------->
if(!isset($timeDiff)) $currentTime=time(); else $currentTime=time()+$timeDiff;
$GLOBALS['today']=date('Y-m-d', $currentTime);
$GLOBALS['yesterday']=date('Y-m-d', $currentTime-86400);

function convert_date($dateR){

if(isset($GLOBALS['disableDates']) and $GLOBALS['disableDates'] and $GLOBALS['user_id']==0) return '';

else{

if(!isset($GLOBALS['engMon'])) $GLOBALS['engMon']=array('January','February','March','April','May','June','July','August','September','October','November','December',' ');
if(!isset($GLOBALS['months'])) {
$GLOBALS['months']=explode (':', $GLOBALS['l_months']);
$GLOBALS['months'][]='&nbsp;';
}

$dfval=strtotime($dateR);
$execDateConv=TRUE;

if(function_exists('convert_date_back') and !defined('DISABLE_CONVERT_DATE_BACK')) {
$dateR=convert_date_back($dfval);
if($dateR!='') $execDateConv=FALSE;
}
if($execDateConv) {

if(isset($GLOBALS['timeDiff']) and $GLOBALS['timeDiff']!=0) {
$dfval=$dfval+$GLOBALS['timeDiff'];
$dateRF=date('Y-m-d H:i:s', $dfval);
}
else $dateRF=$dateR;

if(isset($GLOBALS['dateOnlyFormat']) and isset($GLOBALS['l_today']) and isset($GLOBALS['l_yesterday'])) {
if(isset($GLOBALS['today']) and substr($dateRF, 0, 10)==$GLOBALS['today']) $dateR=$GLOBALS['l_today'].' '.date($GLOBALS['timeOnlyFormat'], $dfval);
elseif(isset($GLOBALS['yesterday']) and substr($dateRF, 0, 10)==$GLOBALS['yesterday']) $dateR=$GLOBALS['l_yesterday'].' '.date($GLOBALS['timeOnlyFormat'], $dfval);
else {
$dateR=date($GLOBALS['dateFormat'], $dfval);
$dateR=str_replace($GLOBALS['engMon'],$GLOBALS['months'],$dateR);
}
}
else {
$dateR=date($GLOBALS['dateFormat'], $dfval);
$dateR=str_replace($GLOBALS['engMon'],$GLOBALS['months'],$dateR);
}

}
return $dateR;
}

}

//--------------->
function pageChk($page,$numRows,$viewMax){
if($numRows>0 and ($page>PAGE1_OFFSET+1 or $page<PAGE1_OFFSET+1)){
$max=ceil($numRows/$viewMax)+PAGE1_OFFSET;
if ($page<PAGE1_OFFSET+1) return PAGE1_OFFSET+1;
elseif($page>$max) return $max;
else return $page;
}
else return PAGE1_OFFSET+1;
}

//--------------->
function pgRng($rng, $pars){
if(isset($GLOBALS['l_pageN'])) $l_page=$GLOBALS['l_pageN']; else $l_page=$GLOBALS['l_page'];
$c='';
foreach($rng as $r) {
if($r+PAGE1_OFFSET==$pars[0]) $c.=(!$pars[6]||$pars[0]>PAGE1_OFFSET+1?$pars[5]:'').'<span class="navCellSel"><strong>'.$r.'</strong></span>';
else $c.=$pars[2].'<a href="'.call_user_func('add'.$pars[3].'URLPage', $pars[1], $r+PAGE1_OFFSET).'" class="navCell mnblnk mnblnkn" title="'.$l_page.' #'.$r.'">'.$r.'</a>';
}
return $c;
}

//--------------->
function pageNav($page, $numRows, $url, $viewMax, $navCell=FALSE, $pageType='Gen'){
//$htmlExt replaced with $pageType
if(isset($GLOBALS['is_mobile']) and $GLOBALS['is_mobile']) $isMobileHd=TRUE; else $isMobileHd=FALSE;
if(isset($GLOBALS['l_pageN'])) $l_page=$GLOBALS['l_pageN']; else $l_page=$GLOBALS['l_page'];
if(!$navCell){
if($isMobileHd) {
$sLim=6;$bLim=4;$cLim=1;
$nbspLim=' ';
if(isset($GLOBALS['l_mobilePreviousPage'])) $prevNav=$GLOBALS['l_mobilePreviousPage']; else $prevNav='&lt;&lt;';
if(isset($GLOBALS['l_mobileNextPage'])) $nextNav=$GLOBALS['l_mobileNextPage']; else $nextNav='&gt;&gt;';
}
else {
$sLim=11;$bLim=5;$cLim=3;
//$prevNav='&laquo;&laquo;';
$prevNav=$GLOBALS['l_previousPage'];
//$nextNav='&raquo;&raquo;';
$nextNav=$GLOBALS['l_nextPage'];
}
$stp=1;
}
else{
$sLim=6;$bLim=4;$cLim=1;
$stp=2;
}
$nbspLim='&nbsp;&nbsp;';
$pageNav='';
$frn=$nbspLim;
$spl=$nbspLim.'...';

if((integer)($numRows/$viewMax)<($numRows/$viewMax)) $pages=(integer)($numRows/$viewMax)+1;
else $pages=(integer)($numRows/$viewMax);

if($page>=$pages+PAGE1_OFFSET) $page=$pages+PAGE1_OFFSET;

if($pages>1){
if($page==-1) $spage=$pages; else $spage=$page-PAGE1_OFFSET;
//$spage -   ,   1

$pars=array($page, $url, $frn, $pageType, $navCell, $nbspLim, $isMobileHd);

if($spage-1>=1 and !$navCell) {
if(!$isMobileHd) $nbspLim_s=$nbspLim; else $nbspLim_s='';
$pageNav.=$nbspLim_s.'<a href="'.call_user_func('add'.$pageType.'URLPage', $url, $page-1).'" title="'.$l_page.' #'.($spage-1).'" class="mnblnk mnblnkn">'.$prevNav.'</a>';
}

if($pages>$sLim){
if($spage>0 and $spage<$bLim){
$pageNav.=pgRng(range($stp,$bLim), $pars).$spl.pgRng(range($pages-$cLim,$pages), $pars);
}
elseif($spage==$bLim){
$pageNav.=pgRng(range($stp,$bLim+1), $pars).$spl.pgRng(range($pages,$pages), $pars);
}
elseif($spage>$bLim and $spage<=$pages-$bLim-1){
$pageNav.=pgRng(range($stp,1), $pars).$spl.pgRng(range($spage-1,$spage+1), $pars).$nbspLim.'...'.pgRng(range($pages-1,$pages), $pars);
}
elseif($spage==$pages-$bLim){
$pageNav.=pgRng(range($stp,1), $pars).$spl.pgRng(range($spage-1,$spage+1), $pars).$nbspLim.'...'.pgRng(range($pages,$pages), $pars);
}
elseif($spage>$pages-$bLim and $spage<=$pages){
if($spage==$pages-1) { $al=1; $bl=2; }
elseif($spage==$pages) { $al=3; $bl=2; }
else { $al=1; $bl=1; }
$pageNav.=pgRng(range($stp,$al), $pars).$spl.pgRng(range($spage-$bl,$pages), $pars);
}
}
else {
$pageNav.=pgRng(range($stp,$pages), $pars);
}

if($spage+1<=$pages and !$navCell) $pageNav.=$nbspLim.'<a href="'.call_user_func('add'.$pageType.'URLPage', $url, $page+1).'" title="'.$l_page.' #'.($spage+1).'" class="mnblnk mnblnkn">'.$nextNav.'</a>';

//$pageNav=$pN.'&nbsp;'.$GLOBALS['l_page'].' '.($page-PAGE1_OFFSET).' '.$GLOBALS['l_pageOf'].' '.$pages.':'.$pageNav;

if(!$navCell) {
if(!$isMobileHd) { $mtag=':'; $msp='&nbsp;'; } else { $mtag=$GLOBALS['brtag']; $msp=''; }

if(!defined('NO_PAGE_ICON')) $pN=(defined('CUSTOM_PAGE_ICON')?CUSTOM_PAGE_ICON.$msp:'<img src="'.$GLOBALS['main_url'].'/img/page.svg" class="pageIcon" alt="'.$l_page.'">'.$msp); else $pN='';
$pageNav=$pN.'&nbsp;'.'<span class="noWrap txtNr">'.$l_page.' '.($page-PAGE1_OFFSET).' '.$GLOBALS['l_pageOf'].' '.$pages.'</span>&nbsp;'.$mtag.$pageNav;
}
}
return $pageNav;
}

//---------------------->
function emailCheckBox() {

$checkEmail='';
if($GLOBALS['user_id']>0 and ((isset($GLOBALS['purgeEmailSettings']) and $GLOBALS['purgeEmailSettings']>0) or $GLOBALS['genEmailDisable']!=1)){

if(isset($GLOBALS['sendid']) and is_array($GLOBALS['sendid']) and $GLOBALS['sendid'][2]==$GLOBALS['user_id']) $isInDb=TRUE; else $isInDb=FALSE;

$true0=TRUE;
if(isset($GLOBALS['purgeEmailSettings']) and $GLOBALS['purgeEmailSettings']==1) $true0=FALSE;
elseif($GLOBALS['emailusers']==0) $true0=FALSE;

$true2=($GLOBALS['action']=='vtopic' or $GLOBALS['action'] == 'vthread' or $GLOBALS['action']=='ptopic' or $GLOBALS['action']=='pthread');
$true3a=($GLOBALS['user_id']==1 and (!isset($GLOBALS['emailadmposts']) or $GLOBALS['emailadmposts']==0) and !$isInDb);
$true3b=($GLOBALS['user_id']!=1 and !$isInDb);
$true3=($true3a or $true3b);
$true4=(!isset($GLOBALS['purgeEmailSettings']) or $GLOBALS['purgeEmailSettings']==0);

if(isset($GLOBALS['enchecked'])) $chk="checked=\"checked\""; else $chk='';
$emTitle='';
//$GLOBALS['watchLink']='';
$GLOBALS['watchLinkTitle']='';

if($isInDb) {
if(!$true4) {
//$GLOBALS['watchLink']="<a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=unsubscribe&amp;topic={$GLOBALS['topic']}&amp;usrid={$GLOBALS['user_id']}\" class=\"mnblnk\">{$GLOBALS['l_unsubscribe']}</a>";
if(!isset($GLOBALS['is_mobile']) or !$GLOBALS['is_mobile']) $GLOBALS['watchLinkTitle']=$GLOBALS['l_unsubscribe'];
else $GLOBALS['watchLinkTitle']="<img src=\"{$GLOBALS['main_url']}/img/mobi/icon_unsubscribe.svg\" alt=\"{$GLOBALS['l_unsubscribe']}\" title=\"{$GLOBALS['l_unsubscribe']}\" class=\"watchIcon\">";
}
if(!isset($GLOBALS['eliminateCheckBox']) or !$GLOBALS['eliminateCheckBox']) $checkEmail="<!--U--><a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=unsubscribe&amp;topic={$GLOBALS['topic']}&amp;usrid={$GLOBALS['user_id']}\" class=\"mnblnk\">{$GLOBALS['l_unsubscribe']}</a>"; else $checkEmail='';
}
else{
if(!$true4){
if(isset($GLOBALS['is_mobile']) and $GLOBALS['is_mobile']){
$alt=$GLOBALS['l_subsWatch'];
if($GLOBALS['purgeEmailSettings']==2) $alt=$GLOBALS['l_subsWatchEmail'];
$GLOBALS['watchLinkTitle']="<img src=\"{$GLOBALS['main_url']}/img/mobi/icon_subscribe.svg\" alt=\"{$alt}\" title=\"{$alt}\" class=\"watchIcon\">";
}
else{
if($GLOBALS['purgeEmailSettings']==1) {
$emTitle="{$GLOBALS['l_emailNotify']}";
$GLOBALS['watchLinkTitle']=$GLOBALS['l_subsWatch'];
}
elseif($GLOBALS['purgeEmailSettings']==2) {
$emTitle="{$GLOBALS['l_emailNotify']} / {$GLOBALS['l_emailNotifyEmail']}";
$GLOBALS['watchLinkTitle']=$GLOBALS['l_subsWatchEmail'];
}
}
}
elseif ($true0 and $true2 and $true3) {
$emTitle="{$GLOBALS['l_emailNotify']} / {$GLOBALS['l_emailNotifyEmail']}";
}
if($emTitle!='') {
if(!isset($GLOBALS['eliminateCheckBox']) or !$GLOBALS['eliminateCheckBox']) $checkEmail="<input type=\"checkbox\" name=\"CheckSendMail\" {$chk}> {$emTitle}"; else $checkEmail='';
//if(!$true4) $GLOBALS['watchLink']="<a href=\"{$GLOBALS['main_url']}/{$GLOBALS['indexphp']}action=subscriptions&amp;step=setup&amp;topic={$GLOBALS['topic']}\" class=\"mnblnk\">{$watchLinkTitle}</a>";
}
}
}
return $checkEmail;
}

//---------------------->
function makeValuedDropDown($listArray,$selectName, $additional=''){
$out='';
if(isset($GLOBALS[$selectName])) $curVal=$GLOBALS[$selectName]; else $curVal='';
foreach($listArray as $key=>$val){
if($curVal==$key) $sel=' selected="selected"'; else $sel='';
$out.="<option value=\"$key\"{$sel}>$val</option>";
}
return "<select name=\"$selectName\" id=\"$selectName\" class=\"selectTxt\"{$additional}>$out</select>";
}

//---------------------->
function setCSRFCheckCookie(){
setGenCookie('', (time()-2592000), $GLOBALS['cookiename'].'_csrfchk', 0);
setGenCookie(substr(preg_replace("[^0-9A-Za-z]", 'A', md5(uniqid(rand()))),0,20), 0, $GLOBALS['cookiename'].'_csrfchk', 0);
}

//--------------->
function addGenURLPage($full_url, $currPageNum, $amp='&amp;'){
if($currPageNum!=PAGE1_OFFSET+1) $full_url.=$amp.'page='.$currPageNum;
return $full_url;
}

if(!function_exists('addForumURLPage')){
function addForumURLPage($full_url, $currPageNum){
//if($currPageNum!=PAGE1_OFFSET+1) $full_url.='_'.$currPageNum.'.html';
//else $full_url.='.html';
$full_url.='_'.$currPageNum.'.html';
return $full_url;
}
}

if(!function_exists('addTopicURLPage')){
function addTopicURLPage($full_url, $currPageNum){
//if($currPageNum!=PAGE1_OFFSET+1) $full_url.='_'.$currPageNum.'.html';
//else $full_url.='.html';
$full_url.='_'.$currPageNum.'.html';
return $full_url;
}
}

if(!function_exists('addExtranavURLPage')){
function addExtranavURLPage($full_url, $currPageNum){
if($currPageNum==PAGE1_OFFSET+1) $full_url=substr($full_url, 0, strlen($full_url) - strlen($GLOBALS['indexphp'])).$GLOBALS['startIndex'];
elseif($currPageNum!=PAGE1_OFFSET+1) $full_url.='page='.$currPageNum;
return $full_url;
}
}

if(!function_exists('addExtranavmrURLPage')){
function addExtranavmrURLPage($full_url, $currPageNum){
if($currPageNum>PAGE1_OFFSET+1) $full_url.='/'.$currPageNum.'/';
else $full_url.='/'.$GLOBALS['startIndex'];
return $full_url;
}
}

if(!function_exists('genForumURL')){
function genForumURL($main_url, $forum_id, $forum_name){
//if($forum_name=='#GET#') $forum_name=getForumTitleById($forum_id);
$full_url=$main_url.'/'.$forum_id;
return $full_url;
}
}

if(!function_exists('genTopicURL')){
function genTopicURL($main_url, $forum_id, $forum_name, $topic_id, $topicTitle){
//if($topicTitle=='#GET#') $topicTitle=getTopicTitleById($topic_id);
$full_url=$main_url.'/'.$forum_id.'_'.$topic_id;
return $full_url;
}
}

if(!function_exists('parseRequestForumURL')){
function parseRequestForumURL($main_url){
$url=explode('/', $_SERVER['REQUEST_URI']);
$urll=sizeof($url);
$url=$url[$urll-1];
return $main_url.'/'.$url;
}
}

if(!function_exists('parseRequestTopicURL')){
function parseRequestTopicURL($main_url){
$url=explode('/', $_SERVER['REQUEST_URI']);
$urll=sizeof($url);
$url=$url[$urll-1];
return $main_url.'/'.$url;
}
}

if(!function_exists('getForumTitleById')){
function getForumTitleById($forum_id){
$fName='';
if($fn=db_simpleSelect(0, $GLOBALS['Tf'], 'forum_name', 'forum_id', '=', $forum_id)) $fName=$fn[0];
return $fName;
}
}

function getTopicTitleById($topic_id){
$tName='';
if($tn=db_simpleSelect(0, $GLOBALS['Tt'], 'topic_title', 'topic_id', '=', $topic_id)) $tName=$tn[0];
return $tName;
}

//--------------->
function convertBBJS($mpf){
$mpfs='';
$mpf1=explode('<!--BBJSBUTTONS-->', $mpf);
if(sizeof($mpf1)>0) {
$mpfs=$mpf1[0];
for($i=1;$i<=sizeof($mpf1)-1;$i++){
$mpfa=explode('<!--/BBJSBUTTONS-->', trim($mpf1[$i]));
$mpfb=str_replace(array(chr(13), chr(10), "'", 'a href', '</a>', '</t', '</d', '</s', '\r', '\n'), array('', '', chr(92)."'", "a'+' h'+'re'+'f", "</'+'a'+'>", "</'+'t", "</'+'d", "</'+'s", '\\\r', '\\\n'), trim($mpfa[0]));
$mpfs.="<script>\r\n<!--\r\ndocument.write('{$mpfb}');\r\n//-->\r\n</script>".$mpfa[1];
}
}
return $mpfs;
}

//--------------->
if(!function_exists('parseStatsNum')){
function parseStatsNum($n, $precision=1){

if ($n<900) {
$n_format = number_format($n, $precision);
$suffix = '';
}
else if($n<900000) {
$n_format=number_format($n / 1000, $precision);
$suffix='K';
}
else if($n<900000000) {
$n_format=number_format($n / 1000000, $precision);
$suffix='M';
}
else if($n<900000000000) {
$n_format=number_format($n / 1000000000, $precision);
$suffix='B';
}
else {
$n_format=number_format($n / 1000000000000, $precision);
$suffix='T';
}

if ($precision > 0) {
$dotzero = '.' . str_repeat( '0', $precision );
$n_format = str_replace( $dotzero, '', $n_format );
}

return $n_format.$suffix;

}
}

if(!function_exists('parseNumClean')){
function parseNumClean($num){
if((int)$num<1000) return $num;
else return number_format($num,  0,  '.',  ',');
}
}

//--------------->
function checkModerator($mods,$userId){
if(is_array($mods)){
foreach($mods as $key=>$val) if(is_array($val) and in_array($userId, $val)) return TRUE;
return FALSE;
}
else return FALSE;
}

//--------------->
function operate_string($str, $backMode=FALSE){
$searchArr=array('&', '"', "'", '<', '>');
$replaceArr=array('&amp;', '&quot;', '&#039;', '&lt;', '&gt;');
if($backMode){ $s=$replaceArr; $replaceArr=$searchArr; $searchArr=$s; }
if(!is_array($str)) $str=(string)$str; else $str='';
return str_replace($searchArr, $replaceArr, trim($str));
}

//--------------->
if(!function_exists('display_footer')){
function display_footer(){
global $l_loadingtime;

$freeWareKeys=array(
'Web Forum Software',
'Chat Forum Software',
'Discussion Forum Software',
'Light Forum Script',
'PHP Forum Software',
'Forum Script',
'Forum Software',
'Free Forum Software',
'Open Source Forum Script',
'Simple Bulletin Board',
'Bulletin Board Script',
'Bulletin Board Software',
'Community Script',
'Online Community Software',
'Easy Forum Software',
'Online Community Script'
);

$rndNum=strlen($GLOBALS['sitename']);
$tk=sizeof($freeWareKeys)-1;
while($rndNum>$tk) $rndNum=$rndNum-$tk;
$software=$freeWareKeys[$rndNum];

$GLOBALS['violating_the_copyright_may_result_in_your_criminal_responsibility']=<<<out
<a href="https://www.minibb.com/" target="_blank" class="mnblnk mnblnkn"><img src="{$GLOBALS['main_url']}/img/minibb.svg" alt="{$GLOBALS['sitename']} {$GLOBALS['l_poweredBy']} {$software} miniBB &reg;" title="{$GLOBALS['sitename']} {$GLOBALS['l_poweredBy']} {$software} miniBB &reg;" class="vmiddle" style="width:32px;height:auto"></a>
out;

if(!isset($GLOBALS['minibb_copyright_txt'])) $GLOBALS['minibb_copyright_txt']=<<<out
{$GLOBALS['l_poweredBy']} <a href="https://www.minibb.com/" target="_blank" title="{$GLOBALS['sitename']} {$GLOBALS['l_poweredBy']} {$software} miniBB &reg;" class="mnblnk">{$software} miniBB</a>&reg;
out;

//Loading footer
$endtime=get_microtime();
$GLOBALS['totaltime']=sprintf ("%01.3f", ($endtime-$GLOBALS['starttime']));
if(isset($GLOBALS['includeFooter']) and $GLOBALS['includeFooter']!='') include($GLOBALS['includeFooter']);
else {
$mkf=makeUp('main_footer');
if(isset($GLOBALS['is_mobile_samsung']) and $GLOBALS['is_mobile_samsung']){
$mkf=preg_replace('#<!--scrollTop-->(.+?)<!--/scrollTop-->#is', '', $mkf);
}
echo ParseTpl($mkf);
}
}
}

//--------------->
function scanFilePHP($fileName, $bufferLength=1024){

if(!function_exists('checkTags')){
function checkTags($str){

$scanTags=array('php', 'Php', 'PHp', 'PhP', 'PHP', 'pHp', 'pHP', 'phP');

$ret=FALSE;

foreach($scanTags as $s){
if(substr_count($str, '<?'.$s)>0) { $ret=TRUE; break; }
}

return $ret;
}
}

$ret=FALSE;

$handle = fopen($fileName, "r");
if ($handle) {
while (($buffer = fgets($handle, $bufferLength)) !== false) {
$chk=checkTags($buffer);
if($chk) { $ret=TRUE; break; }
}
//if (!feof($handle)) {
// echo "Error: unexpected fgets() fail\n";
//}
fclose($handle);
}

return $ret;
}

//--------------->
if(!function_exists('registerButton')){
function registerButton($user_id, $enableNewRegistrations, $l_menu, $main_url, $indexphp){
$addCancelBtn='';
if(isset($GLOBALS['is_mobile']) and $GLOBALS['is_mobile'] and isset($GLOBALS['pathToTpl']) and (!isset($_POST['mode']) or $_POST['mode']!='login')){
$addCancelBtn='&nbsp;<input type="button" class="inputButton" value="'.$GLOBALS['l_mobileCancel'].'" onclick="javascript:display_hide(\'mnbl_headtblogin\',\'mnbl_headtb\');">';
}
if($user_id==0 and $enableNewRegistrations) return "<input type=\"button\" value=\"{$l_menu[2]}\" onclick=\"JavaScript:document.location='{$main_url}/{$indexphp}action=registernew'\" class=\"inputButton\">{$addCancelBtn}";
else return $addCancelBtn;
}
}

//--------------->
function special_substr($text, $limit){
/* analogue of default substr() with exception it cuts text off not by every symbol, but by actual symbols, even if they are encoded as unicode (something like &#...; is one symbol) */

$total=0;
$returned='';
$foundUni=0;
for($i=0;$i<strlen($text);$i++){
if($text[$i]=='&') $foundUni=1;
if($foundUni==1)  { if($text[$i]==';') { $total++; $foundUni=0; } }  else $total++;
$returned.=$text[$i];
if($total>=$limit) break;
}

return $returned;
}

//--------------->
/*
function substr_unicode_old($str, $s, $l = null) {
if(!isset($GLOBALS['splitExpression'])) $splitExpression='//u'; else $splitExpression=$GLOBALS['splitExpression'];
return join('', array_slice(preg_split($splitExpression, $str, -1, PREG_SPLIT_NO_EMPTY), $s, $l));
}
*/

function substr_unicode($str, $s, $l = null){
if(function_exists('mb_substr')){
return mb_substr($str, $s, $l, 'UTF-8');
}
else{
if(strlen($str) == strlen(utf8_decode($str))){
return substr($str, $s, $l);
}
else{
$r = '/^.{'.(int)$s.'}(.';
$r .= ($l === null) ? '*)$' : '{'.(int)$l.'})';
$r .= '/su';
preg_match($r, $str, $o);
if(isset($o[1])) return $o[1]; else return $str;
}
}
}

//--------------->
function strlen_unicode($str){
$strln=0;
if(strlen($str)!=0) {
if(function_exists('mb_strlen')) {
if(defined('TEXT_ENCODING')) $detEnc=TEXT_ENCODING;
else{
$detEnc=mb_detect_encoding($str, 'auto');
if((string)$detEnc=='') $detEnc='UTF-8';
}
$strln=mb_strlen($str, $detEnc);
}
else {
if (preg_match('/[^\x20-\x7e]/', $str)) {
// this is utf-8
$strln=strlen(utf8_decode($str));
}
else {
// not utf-8 and hopefully a single byte
$strln=strlen($str);
}
}
}
return $strln;
}

//--------------->
function strtolower_unicode($str){
if((string)$str===NULL) return '';
if(function_exists('mb_strtolower')){
if(isset($GLOBALS['lowerCharset'])) $lc=$GLOBALS['lowerCharset']; else $lc='UTF-8';
return mb_strtolower($str, $lc);
}
else{
return strtolower($str);
}
}

//--------------->
function fixWrongLogin($uid, $uname, $fla_logFile){

if($row=db_simpleSelect(0, $GLOBALS['Tl'], 'forced_amount', 'forced_ip', '=', $GLOBALS['thisIp'], '', '', 'forced_id', '=', $uid) and $row[0]>0){

if($row[0]<$GLOBALS['fla_attempts']){
$newforced_amount=$row[0]+1;
$left_amount=$GLOBALS['fla_attempts']-$newforced_amount;
$GLOBALS['forced_amount']=$newforced_amount;
updateArray(array('forced_amount'), $GLOBALS['Tl'], 'forced_ip', $GLOBALS['thisIp'], 'forced_id', $uid);
//mysqli_query($GLOBALS['mysqlink'], "update {$GLOBALS['Tl']} set forced_amount='{$newforced_amount}' where forced_ip='{$GLOBALS['thisIp']}' and forced_id='{$uid}'");
}

if($row[0]>=$GLOBALS['fla_attempts'] or $left_amount==0){
$left_amount=0;
$blocked_until=date('Y-m-d H:i:s', time()+$GLOBALS['fla_blockPeriod']);
$blocked_until_lng=convert_date($blocked_until);
$GLOBALS['blocked_until']=$blocked_until;
updateArray(array('blocked_until'), $GLOBALS['Tl'], 'forced_ip', $GLOBALS['thisIp'], 'forced_id', $uid);
//mysqli_query($GLOBALS['mysqlink'], "update {$GLOBALS['Tl']} set blocked_until='{$blocked_until}' where forced_ip='{$GLOBALS['thisIp']}' and forced_id='{$uid}'");
}

}
else{
$GLOBALS['forced_id']=$uid;
$GLOBALS['forced_username']=$uname;
$GLOBALS['forced_ip']=$GLOBALS['thisIp'];
$GLOBALS['forced_amount']=1;
$GLOBALS['blocked_until']=date('Y-m-d H:i:s', time()+$GLOBALS['fla_blockPeriod']);
$blocked_until_lng=convert_date($GLOBALS['blocked_until']);
$left_amount=$GLOBALS['fla_attempts']-1;
insertArray(array('forced_id', 'forced_username', 'forced_ip', 'forced_amount', 'blocked_until'), $GLOBALS['Tl']);
addToLog($GLOBALS['fla_logFile'], $GLOBALS['fla_logLang']['new'].': '.$uid.' -- '.$uname.' -- '.$GLOBALS['thisIp'].' -- '.$GLOBALS['blocked_until']);
}

if($left_amount>0){
if($GLOBALS['fla_mode']==1) $addWarn=str_replace('{NUM_ATTEMPTS_LEFT}', $left_amount, $GLOBALS['l_flaAttemptsStrict']);
else $addWarn=str_replace(array('{NUM_ATTEMPTS_LEFT}', '{LOCKED_ACCOUNT}'), array($left_amount, $uname), $GLOBALS['l_flaAttemptsMint']);
}
else{

if($GLOBALS['fla_mode']==1){
$addWarn=str_replace('{LOCKED_DATE}', $blocked_until_lng, $GLOBALS['l_flaBlockedGeneral']);
}
else{
$addWarn=str_replace(array('{LOCKED_IP}', '{LOCKED_ACCOUNT}', '{LOCKED_DATE}'), array($GLOBALS['thisIp'], $uname, $blocked_until_lng), $GLOBALS['l_flaBlockedAccount']);
}

}

if($left_amount>0){
$GLOBALS['errorMSG'].=$GLOBALS['brtag'].$addWarn;
}
else{
$GLOBALS['errorMSG']=$addWarn;
}

}

//--------------->
function addToLog($logName, $string){
if(trim($logName)!=''){
$f=fopen($GLOBALS['fla_logFile'], 'a');
fwrite($f, date('Y-m-d H:i:s').' -- '.$string."\r\n");
fclose($f);
}
}

?>