<?php
/*
msg.php : message locator script for miniBB.
This file is part of miniBB. miniBB is free discussion forums/message board software, supplied with no warranties.
Check COPYING file for more details.
Copyright (C) 2016 Paul Puzyrev. www.minibb.com
Latest File Update: 2023-02-28
*/
define ('INCLUDED776',1);
define ('GO_POST',1);

function get_microtime() {
$mtime=explode(' ',microtime());
return $mtime[1]+$mtime[0];
}

$starttime=get_microtime();

if(isset($_SERVER['SERVER_PROTOCOL']) and ($_SERVER['SERVER_PROTOCOL']=='HTTP/1.0' or $_SERVER['SERVER_PROTOCOL']=='HTTP/1.1') ) $proto=$_SERVER['SERVER_PROTOCOL']; else $proto='HTTP/1.1';

if(defined('CLONE_PATH')) $clonePath=CLONE_PATH; else $clonePath='./';
if(file_exists($clonePath.'setup_options.php')) include ($clonePath.'setup_options.php'); else die('OFFLINE');

if(!isset($brtag)) $brtag='<br>';

include ($pathToFiles.'setup_'.$DB.'.php');
include ($pathToFiles.'bb_cookie.php');
include ($pathToFiles.'bb_functions.php');
include ($pathToFiles.'bb_specials.php');

if(!defined('PAGE1_OFFSET')) define('PAGE1_OFFSET', 0);

$id=0;
$user_id=0;
$forum=0;
$topic=0;
$logged_admin=0;
user_logged_in();
$action='';

include ($pathToFiles."lang/{$lang}.php");

$title=$l_msgError;

if(!isset($rheader)) $rheader='Location:';

if(isset($_GET['subid'])){
//subscription URL
if(@$subt=base64_decode($_GET['subid']) and $subt and substr_count($subt, ',')==2){

$sx=explode(',', $subt);
$subUser=(int)$sx[0];
$topic=(int)$sx[1];
$id=(int)$sx[2];

//Subscription update
if($subUser>0 and $topic>0 and $sendid=db_simpleSelect(0,$Ts,'id,active,user_id,post_id','user_id','=',$subUser,'','','topic_id','=',$topic) and ($sendid[1]==0 or $sendid[3]>0)){
$active=1; $post_id=0; updateArray(array('active', 'post_id'),$Ts,'id',$sendid[0]);
}

}
}
elseif(isset($_GET['id'])){
$id=(int)$_GET['id']+0;
}

if($id>0){

$found=0;

if($row=db_simpleSelect(0, $Tp, 'topic_id, forum_id', 'post_id', '=', $id)){

$found=1;
$foundFolder='';
$Tp_found=$Tp;
$topic=$row[0];
$forum=$row[1];

}
elseif(isset($archives)){
//try in Archives, if they are set

foreach($archives as $key=>$val){

$arcName=str_replace('-', '_', $key);

if($row=db_simpleSelect(0, $arcName.'_'.$Tp, 'topic_id, forum_id', 'post_id', '=', $id)){

$found=1;
$foundFolder='/'.$archivesFolder.'/'.$key;
$Tp_found=$arcName.'_'.$Tp;
$topic=$row[0];
$forum=$row[1];

break;

}

}

}

//closed forums access
$userAccess=TRUE;

if($logged_admin==0 and isset($clForums) and sizeof($clForums)>0 and in_array($forum, $clForums) and isset($clForumsUsers) and !in_array($user_id, $clForumsUsers[$forum])) $userAccess=FALSE;

if(!$userAccess) {
$found=-1;
}

if($found>0){

//$locURL="{$main_url}{$foundFolder}/index.php?action=search&loc=1&forum={$row[1]}&topic={$row[0]}&page={$id}";

if(isset($themeDesc) and in_array($topic,$themeDesc)) $vv=TRUE; else $vv=FALSE;
if(!$vv) $sg='<='; else $sg='>=';
//$anchor=$page;

if(isset($_GET['name'])) $msgAnchor='#'.operate_string($_GET['name']);
else $msgAnchor="#msg{$id}";

if($row=db_simpleSelect(0, $Tp_found, 'count(*)', 'post_id', $sg, $id, '', '', 'topic_id', '=', $topic)) $pt=$row[0]; else $pt=0;

if($pt<=$viewmaxreplys) $page=PAGE1_OFFSET+1;
else $page=ceil($pt/$viewmaxreplys)+PAGE1_OFFSET;

if(isset($mod_rewrite) and $mod_rewrite) $furl=addTopicURLPage(genTopicURL($main_url, $forum, '#GET#', $topic, '#GET#'), $page).$msgAnchor;
else {
if($page==PAGE1_OFFSET+1) $pageReq=''; else $pageReq="&page={$page}";
$furl=addGenURLPage("{$main_url}/{$indexphp}action=vthread&forum={$forum}&topic={$topic}", $page, '&').$msgAnchor;
}

if(!isset($metaLocation) or !$metaLocation) {
header($proto.' 301 Moved Permanently');
header("{$rheader}{$furl}");
exit;
}
else{
$meta_relocate=$furl;
echo ParseTpl(makeUp($metaLocation));
exit;
}

}
else{
header($proto.' 410 Gone');
$metaRobots='NOINDEX,NOFOLLOW';
$errorMSG=$l_msgNotFound;
$correctErr='';

//Subscriptions update
if($sendid=db_simpleSelect(0,$Ts,'id,active,user_id,post_id','post_id','=',$id)){
do{
$active=1; $post_id=0; updateArray(array('active', 'post_id'),$Ts,'id',$sendid[0]);
}
while($sendid=db_simpleSelect(1));
}

if($found==0){
$errorMSG=preg_replace("#{MOVED_EXT}(.+?){/MOVED_EXT}#is", '', $errorMSG);

if($row=db_simpleSelect(0, $Tp, 'post_id', 'topic_id', '=', $topic, 'post_id asc', 1, 'post_id', '>', $id)){
$nextId=$row[0];
$l_msgNewLoc=str_replace(array('{NEXT_MSG_LNK}', '{/NEXT_MSG_LNK}'), array("<a href=\"{$main_url}/msg.php?id={$nextId}\" class=\"mnblnk\" rel=\"nofollow\">", '</a>'), $l_msgNewLoc); 
$correctErr=$l_msgNewLoc;
}
else{

if($row=db_simpleSelect(0, $Tp, 'post_id', 'topic_id', '=', $topic, 'post_id desc', 1)){
$pevId=$row[0];

$correctErr="<a href=\"{$main_url}/msg.php?id={$pevId}\" class=\"mnblnk\" rel=\"nofollow\">{$l_msgGetBackTopic}</a>";
}

}

if($correctErr!='') $correctErr.=$brtag;

}
else{
$errorMSG=str_replace(array('{MOVED_EXT}', '{/MOVED_EXT}'), '', $errorMSG);
}
echo load_header();
echo ParseTpl(makeUp('main_warning'));
display_footer();
exit;
}

}
else{
header($proto.' 410 Gone');
$metaRobots='NOINDEX,NOFOLLOW';
$errorMSG=$l_accessDenied; $correctErr='';
echo load_header();
echo ParseTpl(makeUp('main_warning'));
display_footer();
exit;
}

?>