<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'no', version '4.2'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresse';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Sett inn / endre anker';
$string['advanced:backcolor_desc'] = 'Velg bakgrunnsfarge';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Innrykk';
$string['advanced:blockquote_desc'] = 'Innrykk';
$string['advanced:bold_desc'] = 'Fet';
$string['advanced:bullist_desc'] = 'Sett inn/fjern punktliste';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Sett inn spesialtegn';
$string['advanced:cleanup_desc'] = 'Rens ukurant kode';
$string['advanced:clipboard_msg'] = 'Kopier/klipp ut/lim inn fungerer ikke i Mozilla og Firefox.
Vil du vite mer om dette?';
$string['advanced:code'] = 'Kode';
$string['advanced:code_desc'] = 'Rediger HTML-koden';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopier';
$string['advanced:custom1_desc'] = 'Beskrivelse av spesialfunksjon';
$string['advanced:cut_desc'] = 'Klipp ut';
$string['advanced:dd'] = 'Definisjonsbeskrivelse';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Definisjonsuttrykk';
$string['advanced:font_size'] = 'Skriftstørrelse';
$string['advanced:fontdefault'] = 'Skriftfamilie';
$string['advanced:forecolor_desc'] = 'Velg skriftfarge';
$string['advanced:h1'] = 'Overskrift 1';
$string['advanced:h2'] = 'Overskrift 2';
$string['advanced:h3'] = 'Overskrift 3';
$string['advanced:h4'] = 'Overskrift 4';
$string['advanced:h5'] = 'Overskrift 5';
$string['advanced:h6'] = 'Overskrift 6';
$string['advanced:help_desc'] = 'Hjelp';
$string['advanced:help_shortcut'] = 'Trykk ALT-F10 for verktøylinjen. Trykk ALT-0 for hjelp';
$string['advanced:hr_desc'] = 'Sett inn horisontal linje';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Sett inn / endre bilde';
$string['advanced:image_props_desc'] = 'Bildeegenskaper';
$string['advanced:indent_desc'] = 'Øk innrykk';
$string['advanced:italic_desc'] = 'Kursiv';
$string['advanced:justifycenter_desc'] = 'Midtstill';
$string['advanced:justifyfull_desc'] = 'Blokkjuster';
$string['advanced:justifyleft_desc'] = 'Venstrejuster';
$string['advanced:justifyright_desc'] = 'Høyrejuster';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Sett inn / endre lenke';
$string['advanced:more_colors'] = 'Flere farger...';
$string['advanced:newdocument'] = 'Er du sikker på at du vil slette alt innhold?';
$string['advanced:newdocument_desc'] = 'Nytt dokument';
$string['advanced:numlist_desc'] = 'Sett inn/fjern nummerliste';
$string['advanced:outdent_desc'] = 'Reduser innrykk';
$string['advanced:paragraph'] = 'Avsnitt';
$string['advanced:paste_desc'] = 'Lim inn';
$string['advanced:path'] = 'Sti';
$string['advanced:pre'] = 'Pre-formatert';
$string['advanced:redo_desc'] = 'Gjør om';
$string['advanced:removeformat_desc'] = 'Fjern formatering';
$string['advanced:rich_text_area'] = 'Rik tekstområde';
$string['advanced:samp'] = 'Kodeeksempel';
$string['advanced:shortcuts_desc'] = 'Tilgjengelighetshjelp';
$string['advanced:striketrough_desc'] = 'Gjennomstreking';
$string['advanced:style_select'] = 'Stiler';
$string['advanced:sub_desc'] = 'Senket skrift';
$string['advanced:sup_desc'] = 'Hevet skrift';
$string['advanced:toolbar'] = 'Verktøylinje';
$string['advanced:toolbar_focus'] = 'Skift til verktøyknapper - Alt+Q, skift til editor - Alt-Z, skift til elementsti - Alt-X';
$string['advanced:underline_desc'] = 'Understreking';
$string['advanced:undo_desc'] = 'Angre';
$string['advanced:unlink_desc'] = 'Fjern lenke';
$string['advanced:visualaid_desc'] = 'Vis/skjul retninglinjer/usynlige elementer';
$string['advanced_dlg:'] = 'Avansert undersøkelse';
$string['advanced_dlg:about_author'] = 'Utvikler';
$string['advanced_dlg:about_general'] = 'Om';
$string['advanced_dlg:about_help'] = 'Hjelp';
$string['advanced_dlg:about_license'] = 'Lisens';
$string['advanced_dlg:about_loaded'] = 'Lastede programtillegg';
$string['advanced_dlg:about_plugin'] = 'Programtillegg';
$string['advanced_dlg:about_plugins'] = 'Programtillegg';
$string['advanced_dlg:about_title'] = 'Om TinyMCE';
$string['advanced_dlg:about_version'] = 'Versjon';
$string['advanced_dlg:accessibility_help'] = 'Tilgjengelighetshjelp';
$string['advanced_dlg:accessibility_usage_title'] = 'Generell bruk';
$string['advanced_dlg:anchor_invalid'] = 'Vennligst angi et gyldig ankernavn';
$string['advanced_dlg:anchor_name'] = 'Ankernavn';
$string['advanced_dlg:anchor_title'] = 'Sett inn / endre anker';
$string['advanced_dlg:charmap_title'] = 'Velg spesialtegn';
$string['advanced_dlg:charmap_usage'] = 'Bruk venstre og høyre piltast for å navigere';
$string['advanced_dlg:code_title'] = 'HTML-editor';
$string['advanced_dlg:code_wordwrap'] = 'Tekstbryting';
$string['advanced_dlg:colorpicker_color'] = 'Farge:';
$string['advanced_dlg:colorpicker_name'] = 'Navn:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Navnevalg';
$string['advanced_dlg:colorpicker_named_title'] = 'Fargenavn';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palett';
$string['advanced_dlg:colorpicker_palette_title'] = 'Palettfarger';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Velg farge';
$string['advanced_dlg:colorpicker_picker_title'] = 'Fargevalg';
$string['advanced_dlg:colorpicker_title'] = 'Velg en farge';
$string['advanced_dlg:image_align'] = 'Justering';
$string['advanced_dlg:image_align_baseline'] = 'Bunnlinje';
$string['advanced_dlg:image_align_bottom'] = 'Bunn';
$string['advanced_dlg:image_align_left'] = 'Venstre';
$string['advanced_dlg:image_align_middle'] = 'Midtstilt';
$string['advanced_dlg:image_align_right'] = 'Høyre';
$string['advanced_dlg:image_align_textbottom'] = 'Tekstbunn';
$string['advanced_dlg:image_align_texttop'] = 'Teksttopp';
$string['advanced_dlg:image_align_top'] = 'Topp';
$string['advanced_dlg:image_alt'] = 'Bildebeskrivelse';
$string['advanced_dlg:image_border'] = 'Ramme';
$string['advanced_dlg:image_dimensions'] = 'Dimensjoner';
$string['advanced_dlg:image_hspace'] = 'Horisontal avstand';
$string['advanced_dlg:image_list'] = 'Bildeliste';
$string['advanced_dlg:image_src'] = 'Bildets URL';
$string['advanced_dlg:image_title'] = 'Sett inn / endre bilde';
$string['advanced_dlg:image_vspace'] = 'Vertikal avstand';
$string['advanced_dlg:invalid_color_value'] = 'Ugyldig fargeverdi';
$string['advanced_dlg:link_is_email'] = 'Nettadressen du skrev inn ser ut til å være en e-postadresse. Ønsker du å legge til det påkrevde prefikset mailto:?';
$string['advanced_dlg:link_is_external'] = 'Nettadressen du skrev inn ser ut til å være en ekstern nettadresse. Ønsker du å legge til det påkrevde prefikset http://?';
$string['advanced_dlg:link_list'] = 'Lenkeliste';
$string['advanced_dlg:link_target'] = 'Målside';
$string['advanced_dlg:link_target_blank'] = 'Åpne i nytt vindu';
$string['advanced_dlg:link_target_same'] = 'Åpne i dette vinduet';
$string['advanced_dlg:link_title'] = 'Sett inn /endre lenke';
$string['advanced_dlg:link_titlefield'] = 'Tittel';
$string['advanced_dlg:link_url'] = 'Lenkens URL';
$string['advhr:advhr_desc'] = 'Sett inn horisontal linje';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Ingen skygge';
$string['advhr_dlg:size'] = 'Størrelse';
$string['advhr_dlg:width'] = 'Bredde';
$string['advhr_dlg:widthunits'] = 'Enheter';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Sett inn / endre bilde';
$string['advimage_dlg:align'] = 'Justering';
$string['advimage_dlg:align_baseline'] = 'Grunnlinje';
$string['advimage_dlg:align_bottom'] = 'Bunn';
$string['advimage_dlg:align_left'] = 'Venstre';
$string['advimage_dlg:align_middle'] = 'Midtstilt';
$string['advimage_dlg:align_right'] = 'Høyre';
$string['advimage_dlg:align_textbottom'] = 'Tekst bunn';
$string['advimage_dlg:align_texttop'] = 'Tekst topp';
$string['advimage_dlg:align_top'] = 'Topp';
$string['advimage_dlg:alt'] = 'Bildebeskrivelse';
$string['advimage_dlg:alt_image'] = 'Alternativt bilde';
$string['advimage_dlg:border'] = 'Ramme';
$string['advimage_dlg:classes'] = 'Klasser';
$string['advimage_dlg:constrain_proportions'] = 'Behold størrelsesforhold';
$string['advimage_dlg:dialog_title'] = 'Sett inn / endre bilde';
$string['advimage_dlg:dimensions'] = 'Dimensjoner';
$string['advimage_dlg:example_img'] = 'Utseende Forhåndsvisning bilde';
$string['advimage_dlg:general'] = 'Generelt';
$string['advimage_dlg:height'] = 'Høyde';
$string['advimage_dlg:hspace'] = 'Horisontal avstand';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Bildeliste';
$string['advimage_dlg:langcode'] = 'Språkkode';
$string['advimage_dlg:langdir'] = 'Skriftretning';
$string['advimage_dlg:list'] = 'Bildeliste';
$string['advimage_dlg:long_desc'] = 'Lang beskrivelse';
$string['advimage_dlg:ltr'] = 'Venstre mot høyre';
$string['advimage_dlg:map'] = 'Bildekart';
$string['advimage_dlg:misc'] = 'Annet';
$string['advimage_dlg:missing_alt'] = 'Er du sikker på at du vil fortsette uten å sette inn en beskrivelse av bildet? Uten beskrivelse vil bildet ikke gi mening for enkelte funksjonshemmede, de som bruker en tekstnettleser eller for personer som bruker en nettleser med bildevisning avslått.';
$string['advimage_dlg:mouseout'] = 'for musepeker utenfor';
$string['advimage_dlg:mouseover'] = 'for musepeker på';
$string['advimage_dlg:preview'] = 'Forhåndsvisning';
$string['advimage_dlg:rtl'] = 'Høyre  mot venstre';
$string['advimage_dlg:src'] = 'Bildets URL';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Bytt bilde';
$string['advimage_dlg:tab_advanced'] = 'Avansert';
$string['advimage_dlg:tab_appearance'] = 'Utseende';
$string['advimage_dlg:tab_general'] = 'Generelt';
$string['advimage_dlg:title'] = 'Tittel';
$string['advimage_dlg:vspace'] = 'Vertikal avstand';
$string['advimage_dlg:width'] = 'Bredde';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Sett inn / endre lenke';
$string['advlink_dlg:accesskey'] = 'Hurtigtast';
$string['advlink_dlg:advanced_props'] = 'Generelle egenskaper';
$string['advlink_dlg:advanced_tab'] = 'Avansert';
$string['advlink_dlg:anchor_names'] = 'Anker';
$string['advlink_dlg:classes'] = 'Klasser';
$string['advlink_dlg:encoding'] = 'Tegnkonvertering';
$string['advlink_dlg:event_props'] = 'Hendelser';
$string['advlink_dlg:events_tab'] = 'Hendelser';
$string['advlink_dlg:general_props'] = 'Generelle egenskaper';
$string['advlink_dlg:general_tab'] = 'Generelt';
$string['advlink_dlg:height'] = 'Høyde';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'URL-en du oppga synes å være en email adresse, ønsker du å legge til den nødvendige prefikset mailto:?';
$string['advlink_dlg:is_external'] = 'URL-en du oppga synes å være en ekstern lenke, ønsker du å legge til den nødvendige prefikset http://?';
$string['advlink_dlg:langcode'] = 'Språkkode';
$string['advlink_dlg:langdir'] = 'Skriftretning';
$string['advlink_dlg:link_list'] = 'Lenkeliste';
$string['advlink_dlg:list'] = 'Lenkeliste';
$string['advlink_dlg:ltr'] = 'Venstre mot høyre';
$string['advlink_dlg:mime'] = 'Målets MIME-type';
$string['advlink_dlg:popup'] = 'JavaScript-popup';
$string['advlink_dlg:popup_dependent'] = 'Avhengig vindu (bare i Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Vis plasseringslinje';
$string['advlink_dlg:popup_menubar'] = 'Vis menylinje';
$string['advlink_dlg:popup_name'] = 'Vindunavn';
$string['advlink_dlg:popup_opts'] = 'Innstillinger';
$string['advlink_dlg:popup_position'] = 'Posisjon (X/Y)';
$string['advlink_dlg:popup_props'] = 'Popup-egenskaper';
$string['advlink_dlg:popup_resizable'] = 'Gjør vinduet skalerbart';
$string['advlink_dlg:popup_return'] = 'Sett inn \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Vis rullefelt';
$string['advlink_dlg:popup_size'] = 'Størrelse';
$string['advlink_dlg:popup_statusbar'] = 'Vis statuslinje';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Vis verktøylinjer';
$string['advlink_dlg:popup_url'] = 'Popup URL';
$string['advlink_dlg:rel'] = 'Sidens forhold til målet';
$string['advlink_dlg:rev'] = 'Målets forhold til siden';
$string['advlink_dlg:rtl'] = 'Høyre  mot venstre';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'Tabulatorindeks';
$string['advlink_dlg:target'] = 'Mål';
$string['advlink_dlg:target_blank'] = 'Åpne i nytt vindu';
$string['advlink_dlg:target_langcode'] = 'Målspråk';
$string['advlink_dlg:target_name'] = 'Målnavn';
$string['advlink_dlg:target_parent'] = 'Åpne i overordnet vindu/ramme';
$string['advlink_dlg:target_same'] = 'Åpne i dette vinduet/rammen';
$string['advlink_dlg:target_top'] = 'Åpne i toppvindu (erstatter alle rammer)';
$string['advlink_dlg:title'] = 'Sett inn / rediger lenke';
$string['advlink_dlg:titlefield'] = 'Tittel';
$string['advlink_dlg:url'] = 'Lenkens URL';
$string['advlink_dlg:width'] = 'Bredde';
$string['advlist:circle'] = 'Sirkel';
$string['advlist:def'] = 'Standard';
$string['advlist:disc'] = 'Disk';
$string['advlist:lower_alpha'] = 'Lavere alpha';
$string['advlist:lower_greek'] = 'Lavere gresk';
$string['advlist:lower_roman'] = 'Lavere romansk';
$string['advlist:square'] = 'Kvadrat';
$string['advlist:types'] = 'Typer';
$string['advlist:upper_alpha'] = 'Øvre alpha';
$string['advlist:upper_roman'] = 'Øvre romansk';
$string['aria:rich_text_area'] = 'Rik tekstområde';
$string['autosave:restore_content'] = 'Gjenopprett autolagret innhold';
$string['autosave:unload_msg'] = 'Endringene du gjorde går tapt dersom du velger å forlate denne siden!';
$string['autosave:warning_message'] = 'Dersom du gjenoppretter autolagret innhold vil du miste alt du evt. har skrevet inn i tekstredigeringsverktøyet.

Er du sikker på at du vil gjenopprette det lagrede innholdet?';
$string['availablebuttons'] = 'Tilgjengelige knapper';
$string['colors:000000'] = 'Svart';
$string['colors:000080'] = 'Marineblå';
$string['colors:0000FF'] = 'Blå';
$string['colors:003300'] = 'Mørkegrønn';
$string['colors:003366'] = 'Mørk asurblå';
$string['colors:008000'] = 'Grønn';
$string['colors:008080'] = 'Blågrønn';
$string['colors:00CCFF'] = 'Himmelblå';
$string['colors:00FF00'] = 'Limegrønn';
$string['colors:00FFFF'] = 'Turkis';
$string['colors:333300'] = 'Mørk olivengrønn';
$string['colors:333333'] = 'Veldig mørk grå';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Kongeblå';
$string['colors:339966'] = 'Sjøgrønn';
$string['colors:33CCCC'] = 'Turkis';
$string['colors:666699'] = 'Gråblå';
$string['colors:800000'] = 'Rødbrun';
$string['colors:800080'] = 'Lilla';
$string['colors:808000'] = 'Olivengrønn';
$string['colors:808080'] = 'Grå';
$string['colors:993300'] = 'Brent oransje';
$string['colors:993366'] = 'Brun';
$string['colors:999999'] = 'Mellomgrå';
$string['colors:99CC00'] = 'Gulgrønn';
$string['colors:99CCFF'] = 'Lys himmelblå';
$string['colors:C0C0C0'] = 'Sølvgrå';
$string['colors:CC99FF'] = 'Plommefarget';
$string['colors:CCFFCC'] = 'Lysegrønn';
$string['colors:CCFFFF'] = 'Lys blågrønn';
$string['colors:FF0000'] = 'Rød';
$string['colors:FF00FF'] = 'Magentafarget';
$string['colors:FF6600'] = 'Oransje';
$string['colors:FF9900'] = 'Ravgul';
$string['colors:FF99CC'] = 'Rosa';
$string['colors:FFCC00'] = 'Gullfarget';
$string['colors:FFCC99'] = 'Ferskenfarget';
$string['colors:FFFF00'] = 'Gul';
$string['colors:FFFF99'] = 'Lysegul';
$string['colors:FFFFFF'] = 'Hvit';
$string['common:apply'] = 'Legg til';
$string['common:browse'] = 'Bla gjennom';
$string['common:cancel'] = 'Avbryt';
$string['common:class_name'] = 'Klasse';
$string['common:clipboard_msg'] = 'Kopier/klipp ut/lim inn fungerer ikke i Mozilla og Firefox. Vil du vite mer om dette?';
$string['common:clipboard_no_support'] = 'For tiden ikke støttet av din nettleser, benytt tastatursnarveier i stedet.';
$string['common:close'] = 'Stop';
$string['common:edit_confirm'] = 'Vil du benytte WYSIWYG-editoren for dette tekstfeltet?';
$string['common:insert'] = 'Sett inn';
$string['common:invalid_data'] = 'Feil: Ugyldige verdier er skrevet inn, disse er merket med rødt.';
$string['common:invalid_data_min'] = '{#field} må være et tall større enn {#min}';
$string['common:invalid_data_number'] = '{#field} må være et tall';
$string['common:invalid_data_size'] = '{#field} må være et tall eller en prosentandel';
$string['common:more_colors'] = 'Flere farger...';
$string['common:not_set'] = '--ikke satt--';
$string['common:popup_blocked'] = 'Beklager, det er registrert at du har en popup-sperre aktivert i nettleseren. Du må oppheve popup-sperren for nettstedet for å få tilgang til dette verktøyet';
$string['common:update'] = 'Oppdater';
$string['common:value'] = '(verdi)';
$string['contextmenu:align'] = 'Justering';
$string['contextmenu:center'] = 'Midtstill';
$string['contextmenu:full'] = 'Full';
$string['contextmenu:left'] = 'Venstre';
$string['contextmenu:right'] = 'Høyre';
$string['customconfig'] = 'Egendefinerte innstillinger';
$string['customconfig_desc'] = 'Egentilpassede avanserte TinyMCE-innstillinger i JSON-format, for eksempel: {"option1" : "value2", "option2" : "value2"}. Alle valgene angitt her overstyrer standard- og modulinnstillingene.';
$string['customtoolbar'] = 'Verktøylinje for editor';
$string['customtoolbar_desc'] = 'Hver linje består av en liste over kommaseparerte navn på knapper. Bruk  "|" som gruppedeler, tomme linjer ignoreres. Se <a href="{$a}" target="_blank">{$a}</a> for listen over standard TinyMCE knapper.<br />Første rad vil alltid vises, mens visningen av andre og tredje knapperad kan slås av og på.';
$string['directionality:ltr_desc'] = 'Retning venstre mot høyre';
$string['directionality:rtl_desc'] = 'Retning høyre mot venstre';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Humørfjes';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Gråter';
$string['emotions_dlg:desc'] = 'Humørfjes';
$string['emotions_dlg:embarassed'] = 'Flau';
$string['emotions_dlg:foot_in_mouth'] = 'Fot i munnen';
$string['emotions_dlg:frown'] = 'Skuffet';
$string['emotions_dlg:innocent'] = 'Uskyldig';
$string['emotions_dlg:kiss'] = 'Kyss';
$string['emotions_dlg:laughing'] = 'Ler';
$string['emotions_dlg:money_mouth'] = 'Penger i munnen';
$string['emotions_dlg:sealed'] = 'Hemmelig';
$string['emotions_dlg:smile'] = 'Glad';
$string['emotions_dlg:surprised'] = 'Overrasket';
$string['emotions_dlg:title'] = 'Sett inn humørfjes';
$string['emotions_dlg:tongue_out'] = 'Rekke tunge';
$string['emotions_dlg:undecided'] = 'Skeptisk';
$string['emotions_dlg:usage'] = 'Bruk venstre- og høyrepilene for å navigere.';
$string['emotions_dlg:wink'] = 'Blunke';
$string['emotions_dlg:yell'] = 'Skri';
$string['fontselectlist'] = 'Liste over tilgjengelige skrifttyper';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Dokumentegenskaper';
$string['fullpage_dlg:active_color'] = 'Aktive farge';
$string['fullpage_dlg:add'] = 'Legg til nytt element';
$string['fullpage_dlg:add_base'] = 'Basiselement';
$string['fullpage_dlg:add_comment'] = 'Kommentarnode';
$string['fullpage_dlg:add_link'] = 'Lenkeelement';
$string['fullpage_dlg:add_meta'] = 'Metaelement';
$string['fullpage_dlg:add_script'] = 'Skriptelement';
$string['fullpage_dlg:add_style'] = 'Stilelement';
$string['fullpage_dlg:add_title'] = 'Tittelelement';
$string['fullpage_dlg:advanced_props'] = 'Avasert';
$string['fullpage_dlg:advanced_tab'] = 'Avansert';
$string['fullpage_dlg:appearance_bgprops'] = 'Bakgrunnsegenskaper';
$string['fullpage_dlg:appearance_linkprops'] = 'Lenkefarger';
$string['fullpage_dlg:appearance_marginprops'] = 'Body-marg';
$string['fullpage_dlg:appearance_style'] = 'Stilark og stilegenskaper';
$string['fullpage_dlg:appearance_tab'] = 'Utseende';
$string['fullpage_dlg:appearance_textprops'] = 'Tekstegenskaper';
$string['fullpage_dlg:author'] = 'Forfatter';
$string['fullpage_dlg:base_element'] = 'Basiselement';
$string['fullpage_dlg:bgcolor'] = 'Bakgrunn';
$string['fullpage_dlg:bgimage'] = 'Bakgrunnsbilde';
$string['fullpage_dlg:bottom_margin'] = 'Bunnmarg';
$string['fullpage_dlg:charset'] = 'Tegnsett';
$string['fullpage_dlg:comment_element'] = 'Kommentar';
$string['fullpage_dlg:content'] = 'Innhold';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Tegnkonvertering';
$string['fullpage_dlg:font_face'] = 'Skrifttype';
$string['fullpage_dlg:font_size'] = 'Skriftstørrelse';
$string['fullpage_dlg:fontface'] = 'Skrifttype';
$string['fullpage_dlg:fontsize'] = 'Skriftstørrelse';
$string['fullpage_dlg:general_props'] = 'Generelt';
$string['fullpage_dlg:head_elements'] = 'Overskriftselementer';
$string['fullpage_dlg:hover_color'] = 'Mus over-farge';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Informasjon';
$string['fullpage_dlg:langcode'] = 'Språkkode';
$string['fullpage_dlg:langdir'] = 'Skriftretning';
$string['fullpage_dlg:langprops'] = 'Språk og koding';
$string['fullpage_dlg:language'] = 'Språk';
$string['fullpage_dlg:left_margin'] = 'Venstre marg';
$string['fullpage_dlg:link_color'] = 'Lenkefarge';
$string['fullpage_dlg:link_element'] = 'Lenkeelement';
$string['fullpage_dlg:ltr'] = 'Venstre mot høyre';
$string['fullpage_dlg:media'] = 'Objekt';
$string['fullpage_dlg:meta_description'] = 'Beskrivelse';
$string['fullpage_dlg:meta_element'] = 'Metaelement';
$string['fullpage_dlg:meta_index_follow'] = 'Indekser, og følg lenkene';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indekser, men ikke følg lenkene';
$string['fullpage_dlg:meta_keywords'] = 'Nøkkelord';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ikke indekser, men følg lenkene';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Ikke indekser, og ikke følg lenkene';
$string['fullpage_dlg:meta_props'] = 'Metainformasjon';
$string['fullpage_dlg:meta_robots'] = 'Roboter';
$string['fullpage_dlg:meta_tab'] = 'Generelt';
$string['fullpage_dlg:meta_title'] = 'Tittel';
$string['fullpage_dlg:movedown'] = 'Flytt markert element ned';
$string['fullpage_dlg:moveup'] = 'Flytt markert element opp';
$string['fullpage_dlg:name'] = 'Navn';
$string['fullpage_dlg:properties'] = 'Egenskaper';
$string['fullpage_dlg:rel'] = 'Sidens forhold til målet';
$string['fullpage_dlg:remove'] = 'Fjern';
$string['fullpage_dlg:rev'] = 'Målets forhold til siden';
$string['fullpage_dlg:right_margin'] = 'Høyre marg';
$string['fullpage_dlg:rtl'] = 'Høyre mot venstre';
$string['fullpage_dlg:script_element'] = 'Skriptelement';
$string['fullpage_dlg:src'] = 'Kilde';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Stilelement';
$string['fullpage_dlg:stylesheet'] = 'Stilark';
$string['fullpage_dlg:target'] = 'Mål';
$string['fullpage_dlg:text_color'] = 'Farge';
$string['fullpage_dlg:textcolor'] = 'Farge';
$string['fullpage_dlg:title'] = 'Dokumentegenskaper';
$string['fullpage_dlg:title_element'] = 'Tittelelement';
$string['fullpage_dlg:top_margin'] = 'Toppmarg';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Verdi';
$string['fullpage_dlg:visited_color'] = 'Besøkt-farge';
$string['fullpage_dlg:xml_pi'] = 'XML-deklarasjon';
$string['fullscreen:desc'] = 'Skift til/fra fullskjermmodus';
$string['iespell:download'] = 'ieSpell ikke funnet. Ønsker du å installere ieSpell nå?';
$string['iespell:iespell_desc'] = 'Sjekk rettskrivning';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'søndag,mandag,tirsdag,onsdag,torsdag,fredag,lørdag,søndag';
$string['insertdatetime:day_short'] = 'søn,man,tir,ons,tor,fre,lør,søn';
$string['insertdatetime:insertdate_desc'] = 'Sett inn dato';
$string['insertdatetime:inserttime_desc'] = 'Sett inn tidspunkt';
$string['insertdatetime:months_long'] = 'januar,februar,mars,april,mai,juni,juli,august,september,oktober,november,desember';
$string['insertdatetime:months_short'] = 'jan,feb,mar,apr,mai,jun,jul,aug,sep,oct,nov,des';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Slå på/av absolutt plassering';
$string['layer:backward_desc'] = 'Flytt bakover';
$string['layer:content'] = 'Nytt lag...';
$string['layer:forward_desc'] = 'Flytt framover';
$string['layer:insertlayer_desc'] = 'Sett inn nytt lag';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Sett inn/rediger innebygd objekt';
$string['media:edit'] = 'Endre innebygd objekt';
$string['media_dlg:advanced'] = 'Avansert';
$string['media_dlg:align'] = 'Justering';
$string['media_dlg:align_bottom'] = 'Bunn';
$string['media_dlg:align_bottom_left'] = 'Bunn venstre';
$string['media_dlg:align_bottom_right'] = 'Bunn høyre';
$string['media_dlg:align_center'] = 'Midt';
$string['media_dlg:align_left'] = 'Venstre';
$string['media_dlg:align_right'] = 'Høyre';
$string['media_dlg:align_top'] = 'Topp';
$string['media_dlg:align_top_left'] = 'Topp venstre';
$string['media_dlg:align_top_right'] = 'Topp høyre';
$string['media_dlg:altsource1'] = 'Alternativ kilde 1';
$string['media_dlg:altsource2'] = 'Alternativ kilde 2';
$string['media_dlg:audio'] = 'Alternativ kilde 3';
$string['media_dlg:autogotourl'] = 'Auto-gå-til-URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Autostart';
$string['media_dlg:balance'] = 'Balanse';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'Bakgrunn';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Fang opp ID';
$string['media_dlg:center'] = 'Midtstill';
$string['media_dlg:class_name'] = 'Klasse';
$string['media_dlg:console'] = 'Konsoll';
$string['media_dlg:constrain_proportions'] = 'Behold størrelsesforhold';
$string['media_dlg:controller'] = 'Kontroller';
$string['media_dlg:controls'] = 'Kontroller';
$string['media_dlg:correction'] = 'Ingen korreksjon';
$string['media_dlg:currentmarker'] = 'Aktiv markør';
$string['media_dlg:currentposition'] = 'Aktiv posisjon';
$string['media_dlg:defaultframe'] = 'Standardramme';
$string['media_dlg:embedded_audio_options'] = 'Valg for innebygd audio';
$string['media_dlg:embeddedaudio'] = 'Innebygd audio';
$string['media_dlg:enabled'] = 'Kjørbar';
$string['media_dlg:enablejavascript'] = 'Tillat Javaskript';
$string['media_dlg:endtime'] = 'Stopptid';
$string['media_dlg:file'] = 'Fil/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash-egenskaper';
$string['media_dlg:flashvars'] = 'Flash-variabler';
$string['media_dlg:fullscreen'] = 'Fullskjerm';
$string['media_dlg:general'] = 'Generelt';
$string['media_dlg:hidden'] = 'Skjult';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Horisontal avstand';
$string['media_dlg:html5_audio_options'] = 'Valg for audio';
$string['media_dlg:html5_video_options'] = 'HTML5 video-valg';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Bildestatus';
$string['media_dlg:invokeurls'] = 'Aktiviser URL-er';
$string['media_dlg:kioskmode'] = 'Kiosk-modus';
$string['media_dlg:list'] = 'Liste';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Løkke';
$string['media_dlg:maintainaspect'] = 'Behold størrelsesforhold';
$string['media_dlg:menu'] = 'Vis meny';
$string['media_dlg:mute'] = 'Demp';
$string['media_dlg:name'] = 'Navn';
$string['media_dlg:nojava'] = 'Ingen Java';
$string['media_dlg:numloop'] = 'Antall gjennomløp';
$string['media_dlg:play'] = 'Autostart';
$string['media_dlg:playcount'] = 'Teller';
$string['media_dlg:playeveryframe'] = 'Spill hver ramme';
$string['media_dlg:poster'] = 'Plakat';
$string['media_dlg:prefetch'] = 'Forhåndsregistrer';
$string['media_dlg:preload'] = 'Forhåndslasting';
$string['media_dlg:preload_auto'] = 'La brukerens nettleser bestemme';
$string['media_dlg:preload_metadata'] = 'Forhåndslast metadata til video';
$string['media_dlg:preload_none'] = 'Ikke forhåndslast';
$string['media_dlg:preview'] = 'Forhåndsvisning';
$string['media_dlg:progress'] = 'Framdrift';
$string['media_dlg:qt_options'] = 'QuickTime-innstillinger';
$string['media_dlg:qt_stream_warn'] = 'Streamede RTSP-ressurser bør legges til QT-kildefeltet i avansert-fanen. Du bør også legge til en ikke-streamet versjon i kildefeltet';
$string['media_dlg:qtsrc'] = 'QT kilde';
$string['media_dlg:qtsrcchokespeed'] = 'Choke-fart';
$string['media_dlg:quality'] = 'Kvalitet';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real Media Player-innstillinger';
$string['media_dlg:salign'] = 'S-justering';
$string['media_dlg:scale'] = 'Skalering';
$string['media_dlg:scriptcallbacks'] = 'Skript-referanser';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave-innstillinger';
$string['media_dlg:shuffle'] = 'Miks';
$string['media_dlg:size'] = 'Størrelse';
$string['media_dlg:sound'] = 'Lyd';
$string['media_dlg:source'] = 'Kilde';
$string['media_dlg:starttime'] = 'Starttid';
$string['media_dlg:stretchtofit'] = 'Strekk for å passe inn';
$string['media_dlg:swstretchhalign'] = 'Strekk H-justering';
$string['media_dlg:swstretchstyle'] = 'Strekkstil';
$string['media_dlg:swstretchvalign'] = 'Strekk V-justering';
$string['media_dlg:target'] = 'Mål';
$string['media_dlg:targetcache'] = 'Mål-cache';
$string['media_dlg:title'] = 'Sett inn/rediger innebygd objekt';
$string['media_dlg:type'] = 'Type';
$string['media_dlg:uimode'] = 'UI-modus';
$string['media_dlg:video'] = 'HTML5-video';
$string['media_dlg:volume'] = 'Volum';
$string['media_dlg:vspace'] = 'Vertikal avstand';
$string['media_dlg:windowlessvideo'] = 'Video uten vindu';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'W-modus';
$string['media_dlg:wmp_options'] = 'Windows Media Player-innstillinger';
$string['nonbreaking:nonbreaking_desc'] = 'Sett inn hardt mellomrom';
$string['pagebreak:desc'] = 'Sett inn sideskift for utskrift';
$string['paste:paste_text_desc'] = 'Lim inn som ren tekst';
$string['paste:paste_word_desc'] = 'Lim inn fra Word';
$string['paste:plaintext_mode'] = 'Lim inn er nå i ren tekst-modus. Klikk igjen for å gå tilbake til vanlig lim inn-modus. Etter at du har limt inn noe vil du bli returnert til vanlig innlimingsmodus.';
$string['paste:plaintext_mode_stick'] = 'Lim inn er nå i ren tekst-modus. Klikk igjen for å gå tilbake til vanlig lim inn-modus.';
$string['paste:selectall_desc'] = 'Marker alt';
$string['paste_dlg:text_linebreaks'] = 'Behold tekstbryting';
$string['paste_dlg:text_title'] = 'Bruk Ctrl+V på tastaturet for å lime inn teksten i vinduet.';
$string['paste_dlg:word_title'] = 'Bruk Ctrl+V på tastaturet for å lime inn teksten i vinduet.';
$string['pluginname'] = 'TinyMCE tekstredigeringsverktøy (arv)';
$string['preview:preview_desc'] = 'Forhåndsvisning';
$string['print:print_desc'] = 'Skriv ut';
$string['privacy:metadata'] = 'Modulen "TinyMCE HTML editor" lagrer ikke noen persondata.';
$string['save:cancel_desc'] = 'Kanseller alle endringer';
$string['save:save_desc'] = 'Lagre';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Søk/erstatt';
$string['searchreplace:search_desc'] = 'Søk';
$string['searchreplace_dlg:allreplaced'] = 'Alle forekomster av søkestrengen er erstattet.';
$string['searchreplace_dlg:direction'] = 'Retning';
$string['searchreplace_dlg:down'] = 'Nedover';
$string['searchreplace_dlg:findnext'] = 'Finn neste';
$string['searchreplace_dlg:findwhat'] = 'Finn hva';
$string['searchreplace_dlg:mcase'] = 'Skill mellom store og små tegn';
$string['searchreplace_dlg:notfound'] = 'Søket er avsluttet. Fant ikke søkestrengen.';
$string['searchreplace_dlg:replace'] = 'Erstatt';
$string['searchreplace_dlg:replace_title'] = 'Søk/erstatt';
$string['searchreplace_dlg:replaceall'] = 'Erstatt alt';
$string['searchreplace_dlg:replacewith'] = 'Erstatt med';
$string['searchreplace_dlg:search_title'] = 'Søk';
$string['searchreplace_dlg:searchnext_desc'] = 'Søk igjen';
$string['searchreplace_dlg:up'] = 'Oppover';
$string['settings'] = 'Generelle innstillinger';
$string['simple:bold_desc'] = 'Fet';
$string['simple:bullist_desc'] = 'Sett inn/fjern punktliste';
$string['simple:cleanup_desc'] = 'Rens ukurant kode';
$string['simple:italic_desc'] = 'Kursiv';
$string['simple:numlist_desc'] = 'Sett inn/fjern nummerert liste';
$string['simple:redo_desc'] = 'Gjør om (Ctrl + Y)';
$string['simple:striketrough_desc'] = 'Gjennomstreking';
$string['simple:underline_desc'] = 'Understreking';
$string['simple:undo_desc'] = 'Angre (Ctrl+Z)';
$string['spellchecker:desc'] = 'Stavekontroll på/av';
$string['spellchecker:ignore_word'] = 'Ignorer ord';
$string['spellchecker:ignore_words'] = 'Ignorer alt';
$string['spellchecker:langs'] = 'Språk';
$string['spellchecker:learn_word'] = 'Lær ord';
$string['spellchecker:menu'] = 'Innstillinger for stavekontroll';
$string['spellchecker:no_mpell'] = 'Ingen stavefeil funnet';
$string['spellchecker:no_sug'] = 'Ingen forslag';
$string['spellchecker:sug'] = 'Forslag';
$string['spellchecker:wait'] = 'Vennligst vent...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Rediger CSS-stil';
$string['style_dlg:apply'] = 'Legg til';
$string['style_dlg:background'] = 'Bakgrunn';
$string['style_dlg:background_attachment'] = 'Vedlegg';
$string['style_dlg:background_color'] = 'Bakgrunnsfarge';
$string['style_dlg:background_hpos'] = 'Horisontal posisjon';
$string['style_dlg:background_image'] = 'Bakgrunnsbilde';
$string['style_dlg:background_repeat'] = 'Gjenta';
$string['style_dlg:background_tab'] = 'Bakgrunn';
$string['style_dlg:background_vpos'] = 'Vertikal posisjon';
$string['style_dlg:block'] = 'Blokk';
$string['style_dlg:block_display'] = 'Framvising';
$string['style_dlg:block_letterspacing'] = 'Bokstavmellomrom';
$string['style_dlg:block_tab'] = 'Blokk';
$string['style_dlg:block_text_align'] = 'Justering';
$string['style_dlg:block_text_indent'] = 'Innrykk';
$string['style_dlg:block_vertical_alignment'] = 'Vertikal justering';
$string['style_dlg:block_whitespace'] = 'Mellomrom';
$string['style_dlg:block_wordspacing'] = 'Ordmellomrom';
$string['style_dlg:border'] = 'Ramme';
$string['style_dlg:border_tab'] = 'Ramme';
$string['style_dlg:bottom'] = 'Bunn';
$string['style_dlg:box'] = 'Boks';
$string['style_dlg:box_clear'] = 'Slett';
$string['style_dlg:box_float'] = 'Flyt';
$string['style_dlg:box_height'] = 'Høyde';
$string['style_dlg:box_tab'] = 'Boks';
$string['style_dlg:box_width'] = 'Bredde';
$string['style_dlg:bullet_image'] = 'Kulepunktbilde';
$string['style_dlg:clip'] = 'Klip';
$string['style_dlg:color'] = 'Farge';
$string['style_dlg:height'] = 'Høyde';
$string['style_dlg:left'] = 'Venstre';
$string['style_dlg:list'] = 'Liste';
$string['style_dlg:list_tab'] = 'Liste';
$string['style_dlg:list_type'] = 'Type';
$string['style_dlg:margin'] = 'Marg';
$string['style_dlg:overflow'] = 'Overfylt';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Plassering';
$string['style_dlg:position'] = 'Posisjon';
$string['style_dlg:positioning_tab'] = 'Posisjon';
$string['style_dlg:positioning_type'] = 'Type';
$string['style_dlg:right'] = 'Høyre';
$string['style_dlg:same'] = 'Likt i alle';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Tekst';
$string['style_dlg:text_blink'] = 'Blink';
$string['style_dlg:text_case'] = 'Kapiteler/minuskler';
$string['style_dlg:text_color'] = 'Farge';
$string['style_dlg:text_decoration'] = 'Dekorasjon';
$string['style_dlg:text_font'] = 'Skrifttype';
$string['style_dlg:text_lineheight'] = 'Linjehøyde';
$string['style_dlg:text_none'] = 'Ingen';
$string['style_dlg:text_overline'] = 'Hevet skrift';
$string['style_dlg:text_props'] = 'Skriftegenskaper';
$string['style_dlg:text_size'] = 'Skriftstørrelse';
$string['style_dlg:text_striketrough'] = 'Gjennomstreking';
$string['style_dlg:text_style'] = 'Skriftstil';
$string['style_dlg:text_tab'] = 'Tekst';
$string['style_dlg:text_underline'] = 'Understreking';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Skriftvekt';
$string['style_dlg:title'] = 'Rediger CSS-stil';
$string['style_dlg:toggle_insert_span'] = 'Sett inn spenn ved valg';
$string['style_dlg:top'] = 'Topp';
$string['style_dlg:visibility'] = 'Synlighet';
$string['style_dlg:width'] = 'Bredde';
$string['style_dlg:zindex'] = 'Z-indeks';
$string['subplugintype_tinymce'] = 'Modul';
$string['subplugintype_tinymce_plural'] = 'Moduler';
$string['table:cell'] = 'Celle';
$string['table:cell_desc'] = 'Celleegenskaper';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Kolonne';
$string['table:col_after_desc'] = 'Sett inn kolonne etter';
$string['table:col_before_desc'] = 'Sett inn kolonne foran';
$string['table:copy_row_desc'] = 'Kopier rad';
$string['table:cut_row_desc'] = 'Fjern rad';
$string['table:del'] = 'Slett tabell';
$string['table:delete_col_desc'] = 'Slett kolonne';
$string['table:delete_row_desc'] = 'Fjern rad';
$string['table:desc'] = 'Sett inn/rediger tabell';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Slå sammen celler';
$string['table:paste_row_after_desc'] = 'Lim inn rad etter';
$string['table:paste_row_before_desc'] = 'Lim inn rad foran';
$string['table:props_desc'] = 'Tabellegenskaper';
$string['table:row'] = 'Rad';
$string['table:row_after_desc'] = 'Sett inn rad etter etter';
$string['table:row_before_desc'] = 'Sett inn rad foran';
$string['table:row_desc'] = 'Radegenskaper';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Del celler';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Generelle egenskaper';
$string['table_dlg:advanced_tab'] = 'Avansert';
$string['table_dlg:align'] = 'Justering';
$string['table_dlg:align_bottom'] = 'Bunn';
$string['table_dlg:align_default'] = 'Standard';
$string['table_dlg:align_left'] = 'Venstre';
$string['table_dlg:align_middle'] = 'Midtstilt';
$string['table_dlg:align_right'] = 'Høyre';
$string['table_dlg:align_top'] = 'Topp';
$string['table_dlg:bgcolor'] = 'Bakgrunn';
$string['table_dlg:bgimage'] = 'Bakgrunnsbilde';
$string['table_dlg:border'] = 'Ramme';
$string['table_dlg:bordercolor'] = 'Rammefarge';
$string['table_dlg:caption'] = 'Tabelloverskrift';
$string['table_dlg:cell_all'] = 'Oppdater alle celler i tabellen';
$string['table_dlg:cell_cell'] = 'Oppdater aktuell celle';
$string['table_dlg:cell_col'] = 'Oppdater alle cellene i kolonnen';
$string['table_dlg:cell_limit'] = 'Du har overskredet maksimalt antall celler på {$cells}.';
$string['table_dlg:cell_row'] = 'Oppdater alle celler i raden';
$string['table_dlg:cell_title'] = 'Celleegenskaper';
$string['table_dlg:cell_type'] = 'Celletype';
$string['table_dlg:cellpadding'] = 'Cell padding';
$string['table_dlg:cellspacing'] = 'Celleavstand';
$string['table_dlg:col_limit'] = 'Du har overskredet maksimalt antall kolonner på {$cols}.';
$string['table_dlg:colgroup'] = 'Kolonnegruppe';
$string['table_dlg:cols'] = 'Kolonner';
$string['table_dlg:frame'] = 'Ramme';
$string['table_dlg:frame_all'] = 'alle';
$string['table_dlg:frame_cols'] = 'kolonner';
$string['table_dlg:frame_groups'] = 'grupper';
$string['table_dlg:frame_none'] = 'ingen';
$string['table_dlg:frame_rows'] = 'rader';
$string['table_dlg:general_props'] = 'Generelt';
$string['table_dlg:general_tab'] = 'Generelt';
$string['table_dlg:height'] = 'Høyde';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Språkkode';
$string['table_dlg:langdir'] = 'Skriftretning';
$string['table_dlg:ltr'] = 'Venstre mot høyre';
$string['table_dlg:merge_cells_title'] = 'Slå sammen celler';
$string['table_dlg:mime'] = 'Målets MIME-type';
$string['table_dlg:missing_scope'] = 'Er du sikker på at du vil fortsette uten å angi et område for denne overskriftscellen? Uten dette kan det bli vanskelig for enkelte funksjonshemmede brukere å forstå innholdet eller dataene som blir presentert i tabellen.';
$string['table_dlg:row_all'] = 'Oppdater alle rader';
$string['table_dlg:row_even'] = 'Oppdater partallsrader';
$string['table_dlg:row_limit'] = 'Du har overskredet maksimalt antall rader på {$rows}.';
$string['table_dlg:row_odd'] = 'Oppdater oddetallsrader';
$string['table_dlg:row_row'] = 'Oppdater aktuell rad';
$string['table_dlg:row_title'] = 'Radegenskaper';
$string['table_dlg:rowgroup'] = 'Radgruppe';
$string['table_dlg:rows'] = 'Rader';
$string['table_dlg:rowtype'] = 'Radtype';
$string['table_dlg:rtl'] = 'Høyre  mot venstre';
$string['table_dlg:rules'] = 'Streker';
$string['table_dlg:rules_above'] = 'over';
$string['table_dlg:rules_below'] = 'under';
$string['table_dlg:rules_border'] = 'ramme';
$string['table_dlg:rules_box'] = 'boks';
$string['table_dlg:rules_hsides'] = 'hsider';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'ingen';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Område';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Sammendrag';
$string['table_dlg:tbody'] = 'Tabellens hoveddel';
$string['table_dlg:td'] = 'Data';
$string['table_dlg:tfoot'] = 'Bunntekst';
$string['table_dlg:th'] = 'Topptekst';
$string['table_dlg:thead'] = 'Topptekst';
$string['table_dlg:title'] = 'Sett inn/rediger tabell';
$string['table_dlg:valign'] = 'Vertikal justering';
$string['table_dlg:width'] = 'Bredde';
$string['template:desc'] = 'Sett inn forhåndsdefinert malinnhold';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'søndag,mandag,tirsdag,onsdag,torsdag,fredag,lørdag,søndag';
$string['template_dlg:day_short'] = 'søn,man,tir,ons,tor,fre,lør,søn';
$string['template_dlg:desc'] = 'Sett inn forhåndsdefinert malinnhold';
$string['template_dlg:desc_label'] = 'Beskrivelse';
$string['template_dlg:label'] = 'Mal';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'januar,februar,mars,april,mai,juni,juli,august,september,oktober,november,desember';
$string['template_dlg:months_short'] = 'jan,feb,mar,apr,mai,jun,jul,aug,sep,okt,nov,des';
$string['template_dlg:preview'] = 'Forhåndsvisning';
$string['template_dlg:select'] = 'Velg en mal';
$string['template_dlg:title'] = 'Maler';
$string['template_dlg:warning'] = 'Advarsel: Utskifting av en mal med en annen kan føre til at data går tapt.';
$string['visualblocks:desc'] = 'Vis/skjul blokkelementer';
$string['visualchars:desc'] = 'Vis/skjul visuelle kontrolltegn';
$string['wordcount:words'] = 'Ord:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Forkortelse';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Sett inn/rediger egenskaper';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Sitat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Sletting';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Innsetting';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attributter';
$string['xhtmlxtras_dlg:attribs_title'] = 'Sett inn/rediger egenskaper';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attributter';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Hendelser';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Tilgangsnøkkel';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Sted';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasse';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Dato/tid';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Språk';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Tekstretning';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tabuleringsindeks';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Tittel';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Venstre til høyre';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Høyre til venstre';
$string['xhtmlxtras_dlg:events_tab'] = 'Hendelser';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elementegenskaper';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elementhendelser';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Generelle innstillinger';
$string['xhtmlxtras_dlg:general_tab'] = 'Generelt';
$string['xhtmlxtras_dlg:insert_date'] = 'Sett inn dato/tid';
$string['xhtmlxtras_dlg:option_ltr'] = 'Venstre mot høyre';
$string['xhtmlxtras_dlg:option_rtl'] = 'Høyre mot venstre';
$string['xhtmlxtras_dlg:remove'] = 'Fjern';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Forkortelseselement';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronymelement';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Sitatelement';
$string['xhtmlxtras_dlg:title_del_element'] = 'Sletteelement';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Innsettingselement';
