<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'ru', version '4.2'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Содержимое страницы «О нас».';
$string['aboutuscontentsetting_desc'] = 'В этом параметре вы можете добавить форматированный текстовый контент, который будет отображаться на странице «О нас».';
$string['aboutusdisabled'] = 'Страница «О нас» на этом сайте отключена. Здесь не на что смотреть.';
$string['aboutusheading'] = 'О нас';
$string['aboutuslinkpositionboth'] = 'Добавить ссылку на страницу «О нас» в сноску и к значку нижнего колонтитула (вопросительный знак).';
$string['aboutuslinkpositionfooter'] = 'Добавить ссылку на страницу «О нас» к значку нижнего нижнего колонтитула (вопросительный знак).';
$string['aboutuslinkpositionfootnote'] = 'Добавить ссылку на страницу «О нас» в сноску';
$string['aboutuslinkpositionnone'] = 'Не показывать автоматически ссылку на страницу «О нас»';
$string['aboutuslinkpositionsetting'] = 'Расположение ссылки «О нас».';
$string['aboutuslinkpositionsetting_desc'] = 'В этом параметре вы можете настроить, должна ли ссылка на страницу «О нас» автоматически добавляться на страницу Moodle. Если вы не хотите, чтобы ссылка отображалась автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места Moodle.';
$string['aboutuspagetitledefault'] = 'О нас';
$string['aboutuspagetitlesetting'] = 'Заголовок страницы «О нас»';
$string['aboutuspagetitlesetting_desc'] = 'В этой настройке вы можете задать заголовок страницы «О нас». Этот текст также будет использоваться в качестве текста ссылки на страницу «О нас», если вы соответствующим образом настроите «Расположение ссылки о нас».';
$string['activitybrandingtab'] = 'Фирменный стиль элементов курсов';
$string['activityiconcoloradministrationsetting'] = 'Цвет для «Управление»';
$string['activityiconcoloradministrationsetting_desc'] = 'Цвет значка действия «Управление»';
$string['activityiconcolorassessmentsetting'] = 'Цвет для «Оценка»';
$string['activityiconcolorassessmentsetting_desc'] = 'Цвет значка действия «Оценка»';
$string['activityiconcolorcollaborationsetting'] = 'Цвет для «Сотрудничество»';
$string['activityiconcolorcollaborationsetting_desc'] = 'Цвет значка действия «Сотрудничество»';
$string['activityiconcolorcommunicationsetting'] = 'Цвет для «Коммуникация»';
$string['activityiconcolorcommunicationsetting_desc'] = 'Цвет значка действия «Коммуникация»';
$string['activityiconcolorcontentsetting'] = 'Цвет для «Контент»';
$string['activityiconcolorcontentsetting_desc'] = 'Цвет значка действия «Контент»';
$string['activityiconcolorinterfacesetting'] = 'Цвет для «Интерфейс»';
$string['activityiconcolorinterfacesetting_desc'] = 'Цвет значка действия «Интерфейс»';
$string['activityiconcolorsheading'] = 'Цвета значков для действий';
$string['activitynavigationsetting'] = 'Навигация по элементам курса';
$string['activitynavigationsetting_desc'] = 'При включении отображаются элементы для перехода к предыдущему и следующему элементу(ресурсу) курса, а также раскрывающееся меню для перехода к конкретному элементу или ресурсу. Подобные элементы пользовательского интерфейса уже существовали в Boost в ядре Moodle до версии 3.11, но были удалены в версии 4.0. С помощью Boost Union вы можете вернуть их.';
$string['activitypurposeadministration'] = 'Управление';
$string['activitypurposeassessment'] = 'Оценивание';
$string['activitypurposecollaboration'] = 'Сотрудничество';
$string['activitypurposecommunication'] = 'Коммуникация';
$string['activitypurposecontent'] = 'Контент';
$string['activitypurposeheading'] = 'Назначение значка активного элемента';
$string['activitypurposeheading_desc'] = 'Здесь вы можете переопределить цвет фона иконки элементов курсов, который определяется назначением элемента. (Назначение является жестко закодированным свойством каждого элемента).';
$string['activitypurposeheadingtechnote'] = 'Техническое примечание: Из-за того, как ядро Moodle реализует назначения элементов курсов и их цвета, назначения могут быть переопределены с помощью CSS только в Boost Union. В настоящее время все области в ядре Moodle, которые показывают цветные иконки, должны быть покрыты. Если вы обнаружили какую-то область или сторонний плагин, который продолжает показывать неизменные цвета назначений, пожалуйста, сообщите об этом на {$a}.';
$string['activitypurposeinterface'] = 'Интерфейс';
$string['activitypurposeother'] = 'Прочее';
$string['additionalresourcesfileurlpersistent'] = 'URL (постоянный)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (обновляемый)';
$string['additionalresourcesheading'] = 'Дополнительные ресурсы';
$string['additionalresourceslistsetting'] = 'Список дополнительных ресурсов';
$string['additionalresourceslistsetting_desc'] = 'Это список файлов, которые вы загрузили в файловую область дополнительных ресурсов. Указанные URL-адреса можно использовать для ссылки на эти файлы в своем пользовательском CSS, из сноски или в любом другом месте, где вам нужно использовать загруженные файлы, но вы не можете загружать файлы на месте.';
$string['additionalresourcessetting'] = 'Дополнительные ресурсы';
$string['additionalresourcessetting_desc'] = 'С помощью этой настройки вы можете загружать в тему дополнительные ресурсы. Преимущество загрузки файлов в эту файловую область заключается в том, что эти файлы могут быть доставлены без проверки, вошел ли пользователь в систему. По этой же причине следует добавлять только те файлы, которые некритичны, к которым должен быть разрешен доступ всем и которые не нужно защищать действующим логином. Как только вы загрузите хотя бы один файл в эту область файлов и сохраните настройки, под ним появится список, в котором будет указан URL, который вы можете использовать для ссылки на конкретный файл.';
$string['administrationtab'] = 'Администрирование';
$string['backgroundimagepositionsetting'] = 'Положение фонового рисунка';
$string['backgroundimagepositionsetting_desc'] = 'Здесь вы можете задать позиционирование фонового изображения в окне браузера. Первое значение - горизонтальное положение, второе - вертикальное.';
$string['backgroundimagesetting'] = 'Фоновый рисунок';
$string['backgroundimagesetting_desc'] = 'Здесь вы можете загрузить пользовательское изображение для отображения в качестве фона сайта. Загруженное здесь фоновое изображение будет заменять фоновое изображение в файлах предустановок вашей темы.';
$string['backgroundimagesheading'] = 'Общие фоновые изображения';
$string['backtotop'] = 'Вернуться к началу';
$string['backtotopbuttonsetting'] = 'Кнопка возврата к началу';
$string['backtotopbuttonsetting_desc'] = 'При включенном параметре кнопка «Вернуться к началу» появится в правом нижнем углу страницы, как только пользователь прокрутит страницу вниз. Подобная кнопка уже существовала в Boost до версии Moodle 3.11, но была удалена в версии 4.0. С помощью Boost Union вы можете вернуть её обратно.';
$string['blockregionfooterwidth'] = 'Ширина блока для области «Нижний колонтитул»';
$string['blockregionfooterwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Нижний колонтитул». Вы можете выбрать между полной шириной, шириной контента курса и шириной блока.';
$string['blockregionoutsidebottomwidth'] = 'Ширина блока для области «Внешняя (снизу)»';
$string['blockregionoutsidebottomwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (снизу)», который отображается под основным контентом. Вы можете выбрать между полной шириной, шириной контента курса и шириной блока.';
$string['blockregionoutsideleftwidth'] = 'Ширина блока для области «Внешняя (слева)»';
$string['blockregionoutsideleftwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (слева)», который отображается слева от области основного контента. По умолчанию Boost Union использует ширину 300px. Вы можете ввести другие значения, основанные на пикселях, например, 200px, а также значение в процентах, например, 10% или значение viewport-width, например, 10vw.';
$string['blockregionoutsiderightwidth'] = 'Ширина блока для области «Внешняя (справа)»';
$string['blockregionoutsiderightwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (справа)», который отображается справа от области основного контента. По умолчанию Boost Union использует ширину 300px. Вы можете ввести другие значения, основанные на пикселях, например, 200px, а также значение в процентах, например, 10% или значение viewport-width, например, 10vw.';
$string['blockregionoutsidetopwidth'] = 'Ширина блока для области «Внешняя (сверху)»';
$string['blockregionoutsidetopwidth_desc'] = 'С помощью этого параметра можно задать ширину блока области «Внешняя (сверху)», который отображается в самом верху страницы. Вы можете выбрать между полной шириной, шириной еонтента курса и шириной блока.';
$string['blockregionsforlayout'] = 'Дополнительные области для макета «{$a}»';
$string['blockregionsforlayout_desc'] = 'С помощью этого параметра можно включить дополнительные области для макета «{$a}».';
$string['blockregionsheading'] = 'Дополнительные области блоков';
$string['blockregionsheading_desc'] = '<p>Boost Union предоставляет большое количество дополнительных областей, которые можно использовать для добавления и отображения блоков на всей странице Moodle:</p>
<ul><li><em>Внешние области</em> размещаются на всех четырех сторонах страницы Moodle. Они могут быть использованы для показа блоков, которые сопровождают отображаемую страницу Moodle, но не относятся непосредственно к основному содержимому.</li>
<li><em>Область заголовка</em> расположена между внешней (верхней) областью и основным содержимым. Её можно использовать для отображения блока в качестве заголовка курса.</li>
<li><em>Область блоков контента</em> размещается непосредственно над и под основным содержимым в области основного контента. Их можно использовать для добавления блоков в текущие материалы курса.</li>
<li><em>Область колонтитула</em> размещаются в нижней части страницы между внешней (нижней) областью и подвалом. В вашем распоряжении три области колонтитулов, из которых при необходимости можно построить колонки.</li>
<li><em>Область вне страницы</em> является особенной, поскольку она нависает над всей страницей Moodle в виде выпадающей панели. Панель открывается значком с 9 точками в самом правом углу навигационной панели. В вашем распоряжении три области вне страницы, из которых при необходимости можно построить колонки.</li></ul>
<p>Обратите внимание:</p>
<ul><li>По умолчанию все дополнительные области блоков отключены. Включите те или иные области блоков на конкретных макетах страниц в соответствии с вашими потребностями. Старайтесь быть как можно более сфокусированными - слишком большое количество областей может ошеломить часть пользователей.</li>
<li>Как только дополнительная область блока включена, она становится видимой для всех аутентифицированных пользователей и может редактироваться преподавателями и управляющими (конечно, в зависимости от того, разрешено ли данному пользователю редактировать конкретную страницу Moodle). Но существуют также разрешения theme/boost_union:viewregion* и theme/boost_union:editregion*, которые позволяют вам тонко настроить использование каждой области в соответствии со своими потребностями.</li>
<li>Блоки областей «Внешняя (слева)», «Внешняя (справа)», «Содержимое (вверху)», «Содержимое (внизу» и «Заголовок» доступны не для всех макетов страниц.</li></ul>';
$string['blockregionsheading_experimental'] = 'Пожалуйста, обратите внимание: <em>блоки областей «Внешняя (слева)» и «Внешняя (справа)»</em> полностью работоспособны в текущем состоянии реализации, но должны рассматриваться как экспериментальные, поскольку они еще не отображаются должным образом на экранах средней ширины. Поэтому используйте их с осторожностью. Эта проблема будет исправлена в одном из ближайших выпусков.';
$string['blocksgeneralheading'] = 'Основные блоки';
$string['blockstab'] = 'Блоки';
$string['boost_union:configure'] = 'Возможность настраивать тему не в роли администратора';
$string['boost_union:editregioncontentlower'] = 'Возможность редактировать область блоков Контент (снизу)';
$string['boost_union:editregioncontentupper'] = 'Возможность редактировать область блоков Контент (сверху)';
$string['boost_union:editregionfootercenter'] = 'Возможность редактировать область блоков «Нижний колонтитул (по центру)»';
$string['boost_union:editregionfooterleft'] = 'Возможность редактировать область блоков «Нижний колонтитул (слева)»';
$string['boost_union:editregionfooterright'] = 'Возможность редактировать область блоков «Нижний колонтитул (справа)»';
$string['boost_union:editregionheader'] = 'Возможность редактировать область блоков «Заголовок»';
$string['boost_union:editregionoffcanvascenter'] = 'Возможность редактировать область блоков «Вне страницы (по центру)»';
$string['boost_union:editregionoffcanvasleft'] = 'Возможность редактировать область блоков «Вне страницы (слева)»';
$string['boost_union:editregionoffcanvasright'] = 'Возможность редактировать область блоков «Вне страницы (справа)»';
$string['boost_union:editregionoutsidebottom'] = 'Возможность редактировать область блоков «Внешняя (снизу)»';
$string['boost_union:editregionoutsideleft'] = 'Возможность редактировать область блоков «Внешняя (слева)»';
$string['boost_union:editregionoutsideright'] = 'Возможность редактировать область блоков «Внешняя (справа)»';
$string['boost_union:editregionoutsidetop'] = 'Возможность редактировать область блоков «Внешняя (сверху)»';
$string['boost_union:viewhintcourseselfenrol'] = 'Возможность видеть подсказку о разрешенной самостоятельной записи на видимый курс.';
$string['boost_union:viewhintinhiddencourse'] = 'Возможность видеть подсказку о скрытом курсе.';
$string['boost_union:viewregioncontentlower'] = 'Возможность видеть область блоков Контент (снизу)';
$string['boost_union:viewregioncontentupper'] = 'Возможность видеть область блоков Контент (сверху)';
$string['boost_union:viewregionfootercenter'] = 'Возможность видеть область блоков «Нижний колонтитул (по центру)»';
$string['boost_union:viewregionfooterleft'] = 'Возможность видеть область блоков «Нижний колонтитул (слева)»';
$string['boost_union:viewregionfooterright'] = 'Возможность видеть область блоков «Нижний колонтитул (справа)»';
$string['boost_union:viewregionheader'] = 'Возможность видеть область блоков «Заголовок»';
$string['boost_union:viewregionoffcanvascenter'] = 'Возможность видеть область блоков «Вне страницы (по центру)»';
$string['boost_union:viewregionoffcanvasleft'] = 'Возможность видеть область блоков «Вне страницы (слева)»';
$string['boost_union:viewregionoffcanvasright'] = 'Возможность видеть область блоков «Вне страницы (справа)»';
$string['boost_union:viewregionoutsidebottom'] = 'Возможность видеть область блоков «Внешняя (снизу)»';
$string['boost_union:viewregionoutsideleft'] = 'Возможность видеть область блоков «Внешняя (слева)»';
$string['boost_union:viewregionoutsideright'] = 'Возможность видеть область блоков «Внешняя (справа)»';
$string['boost_union:viewregionoutsidetop'] = 'Возможность видеть область блоков «Внешняя (сверху)»';
$string['bootstrapcolordangersetting'] = 'Цвет «Опасности»';
$string['bootstrapcolordangersetting_desc'] = 'Цвет Bootstrap для «Опасности»';
$string['bootstrapcolorinfosetting'] = 'Цвет «Информации»';
$string['bootstrapcolorinfosetting_desc'] = 'Цвет Bootstrap для «Информации»';
$string['bootstrapcolorsheading'] = 'Цвета Bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Цвет «Успеха»';
$string['bootstrapcolorsuccesssetting_desc'] = 'Цвет Bootstrap для «Успеха»';
$string['bootstrapcolorwarningsetting'] = 'Цвет «Предупреждения»';
$string['bootstrapcolorwarningsetting_desc'] = 'Цвет Bootstrap для «Предупреждения»';
$string['bootstrapdangercolor'] = 'Цвет опасности';
$string['bootstrapdarkcolor'] = 'Тёмный цвет';
$string['bootstrapinfocolor'] = 'Цвет информации';
$string['bootstraplightcolor'] = 'Светлый цвет';
$string['bootstrapnone'] = 'Без цвета Bootstrap';
$string['bootstrapprimarycolor'] = 'Основной цвет';
$string['bootstrapsecondarycolor'] = 'Вторичный цвет';
$string['bootstrapsuccesscolor'] = 'Цвет завершения';
$string['bootstrapwarningcolor'] = 'Цвет предупреждения';
$string['brandcolorsheading'] = 'Корпоративные цвета';
$string['breadcrumbsheading'] = 'Навигационная цепочка';
$string['cachedef_flavours'] = 'Стили, которые применяются к данному идентификатору категории страницы для текущего пользователя';
$string['cachedef_smartmenu_items'] = 'Элементы умного меню';
$string['cachedef_smartmenus'] = 'Умные меню';
$string['categorybreadcrumbs'] = 'Отображать категории в заголовке курса';
$string['categorybreadcrumbs_desc'] = 'По умолчанию категории курса не отображаются в навигационной цепочке на страницах курса. С помощью этой настройки вы можете показать категории курса в навигационной цепочке в заголовке курса над его названием.';
$string['choosereadme'] = '<p>Тема Boost Union - это усовершенствованная дочерняя тема Boost, которая призвана сделать Boost более настраиваемой и предоставить полезные дополнительные функции для ежедневной работы в Moodle администраторам, преподавателям и студентам.</p><p>Boost Union поддерживается<br />Moodle an Hochschulen e.V.,</p><p>в сотрудничестве с<br />lern.link GmbH</p><p>вместе с<br />bdecent GmbH</p>';
$string['closeoffcanvas'] = 'Закрыть панель «Вне страницы»';
$string['configtitle'] = 'Boost Union';
$string['configtitlecontent'] = 'Содержимое';
$string['configtitlefeel'] = 'Восприятие';
$string['configtitleflavours'] = 'Стили';
$string['configtitlefunctionality'] = 'Функциональные особенности';
$string['configtitlelook'] = 'Вид';
$string['contactcontentsetting'] = 'Содержимое страницы контактов';
$string['contactcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице контактов (это не то же самое, что встроенная страница Moodle «Контакты поддержки сайта»).';
$string['contactdisabled'] = 'Страница контактов отключена для этого сайта. Здесь не на что смотреть.';
$string['contactheading'] = 'Контакты';
$string['contactlinkpositionboth'] = 'Добавить ссылку на страницу контактов в сноске и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['contactlinkpositionfooter'] = 'Добавить ссылку на страницу контактов на иконку «Знак вопроса» в нижнем колонтитуле';
$string['contactlinkpositionfootnote'] = 'Добавить ссылку на страницу контактов в колонтитул';
$string['contactlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу контактов';
$string['contactlinkpositionsetting'] = 'Расположение ссылки на страницу контактов';
$string['contactlinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу контактов автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['contactpagetitledefault'] = 'Контакты';
$string['contactpagetitlesetting'] = 'Заголовок страницы контактов';
$string['contactpagetitlesetting_desc'] = 'Этот параметр определяет заголовок страницы контактов. Этот текст будет использоваться в качестве текста ссылки на страницу контактов, если вы соответствующим образом настроите «Расположение ссылки на страницу контактов».';
$string['contentwidthheading'] = 'Ширина контента';
$string['coursecontentmaxwidthsetting'] = 'Максимальная ширина контента курса';
$string['coursecontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину контента курса без ручного изменения SCSS. Эта ширина используется в качестве ширины страниц курса и в некоторых видах элементов курса. По умолчанию Moodle использует максимальную ширину контента курса 830px. Вы можете ввести другие значения, основанные на пикселях, например 1200px, но вы также можете ввести значение, основанное на процентах, например 100%, или значение viewport-width, например 90vw.';
$string['courseheaderheading'] = 'Заголовок курса';
$string['courseheaderimageenabled'] = 'Отображать изображение курса в заголовке курса';
$string['courseheaderimageenabled_desc'] = 'Если эта функция включена, изображение курса (которое можно загрузить в настройках курса) отображается в заголовке курса. Изображения курсов отображаются там в дополнение к странице «Мои курсы», где они отображаются всегда.';
$string['courseheaderimagefallback'] = 'Резервное изображение заголовка курса';
$string['courseheaderimagefallback_desc'] = 'Загруженное в этом параметре изображение используется в качестве резервного и будет отображено в заголовке курса, если в настройках курса не загружено изображение. Если вы не загрузите изображение здесь, то изображение в заголовке курса будет отображаться в конкретном курсе только в том случае, если в настройках этого конкретного курса загружено изображение.';
$string['courseheaderimageheight'] = 'Высота изображения заголовка курса';
$string['courseheaderimageheight_desc'] = 'С помощью этого параметра вы управляете высотой  изображения, представленного в заголовке курса.';
$string['courseheaderimagelayout'] = 'Расположение изображения в заголовке курса';
$string['courseheaderimagelayout_desc'] = 'Этот параметр позволяет управлять взаимным расположением изображения и названия курса в его заголовке.';
$string['courseheaderimagelayoutheadingabove'] = 'Название курса над изображением курса';
$string['courseheaderimagelayoutstackeddark'] = 'Название курса накладывается на изображение курса (белый цвет шрифта для темных фоновых изображений)';
$string['courseheaderimagelayoutstackedlight'] = 'Название курса накладывается на изображение курса (черный цвет шрифта для светлых фоновых изображений)';
$string['courseheaderimageposition'] = 'Позиция изображения заголовка курса';
$string['courseheaderimageposition_desc'] = 'С помощью этого параметра вы управляете расположением изображения заголовка курса в контейнере изображения заголовка курса. Первое значение — горизонтальное положение, второе значение — вертикальное положение.';
$string['coursemanagementheading'] = 'Управление курсами';
$string['courserelatedhintsheading'] = 'Подсказки, связанные с курсом';
$string['coursestab'] = 'Курсы';
$string['coursetab'] = 'Курс';
$string['cssh5pheading'] = 'Сырой CSS для H5P';
$string['cssh5psetting'] = 'Сырой CSS для H5P';
$string['cssh5psetting_desc'] = 'Используйте это поле для указания кода CSS, который будет применяться к представлению содержимого H5P с помощью mod_h5p и mod_hvp. Пожалуйста, ознакомьтесь с типами содержимого H5P, чтобы найти необходимые селекторы CSS.';
$string['customfontsfileurlpersistent'] = 'URL (постоянный)';
$string['customfontsfileurlrevisioned'] = 'URL (обновляемый)';
$string['customfontsheading'] = 'Пользовательские шрифты';
$string['customfontslistsetting'] = 'Список пользовательских шрифтов';
$string['customfontslistsetting_desc'] = 'Это список шрифтов, которые вы загрузили в область файлов пользовательских шрифтов. Приведенные фрагменты CSS можно использовать для добавления этих шрифтов в ваш пользовательский SCSS. Обратите внимание, что вам придется самостоятельно позаботиться о значении формата шрифта, а также о свойствах font-family, font-style и font-weight CSS, поскольку Boost Union еще не умеет анализировать файлы шрифтов.';
$string['customfontssetting'] = 'Пользовательские шрифты';
$string['customfontssetting_desc'] = 'С помощью этой настройки вы можете загрузить в тему пользовательские шрифты. Преимущество загрузки шрифтов в эту область файлов заключается в том, что эти шрифты могут быть доставлены без проверки входа пользователя в систему, и могут быть использованы как локально установленные шрифты везде на сайте. Как только вы загрузите хотя бы один шрифт в эту область файлов и сохраните настройки, под ними появится список, в котором будут приведены фрагменты кода CSS, которые вы можете использовать в качестве шаблона для ссылок на определенные шрифты в своем пользовательском SCSS.';
$string['dontchange'] = 'Ничего не менять';
$string['emailbrandinghtmldemobody'] = '<p>Тело электронного письма начинается здесь.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>Тело электронного письма заканчивается здесь.</p>';
$string['emailbrandinghtmlheading'] = 'Предварительный просмотр письма HTML';
$string['emailbrandinghtmlintro'] = 'Это предварительный просмотр электронного письма HTML, основанного на префиксах и суффиксах фирменного стиля, которые в настоящее время установлены в языковом пакете.';
$string['emailbrandinghtmlnopreview'] = 'До сих пор электронная почта HTML не была настроена с учетом этой функции. Электронная почта будет составляться и рассылаться в обычном режиме.';
$string['emailbrandinginstruction'] = 'Как это сделать';
$string['emailbrandinginstruction0'] = 'С помощью этой функции Boost Union вы можете применить брендирование ко всем электронным письмам, которые рассылает Moodle.';
$string['emailbrandinginstructionli1'] = 'Перейдите на страницу <a href="{$a->url}" target="_blank">настроек языковых параметров</a>, чтобы открыть языковой пакет <em>{$a->lang}</em> для редактирования.';
$string['emailbrandinginstructionli2'] = 'Найдите и измените эти строки в пакете <code>theme_boost_union language</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Этот фрагмент будет добавлен <em>в начало / перед телом</em> всех <em>электронных писем HTML</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Этот фрагмент будет добавлен <em>в конце / после тела</em> всех <em>электронных писем HTML</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Этот фрагмент будет добавлен <em>в начало / перед телом</em> всех <em>электронных писем с простым текстом</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Этот фрагмент будет добавлен <em>в конце / после тела</em> всех <em>электронных писем с простым текстом</em>, которые рассылает Moodle.';
$string['emailbrandinginstructionli3'] = 'Сохраните изменения в языковом пакете.';
$string['emailbrandinginstructionli4'] = 'Вернитесь на эту страницу и ниже посмотрите предварительный текст электронного письма.';
$string['emailbrandingintroheading'] = 'Вводная часть';
$string['emailbrandingintronote'] = 'Обратите внимание: это расширенная функциональность, которая использует некоторые обходные пути для обеспечения возможностей фирменного стиля электронной почты. Пожалуйста, внимательно следуйте инструкциям.';
$string['emailbrandingpitfalls'] = 'Подводные камни';
$string['emailbrandingpitfalls0'] = 'При использовании этой функции есть некоторые подводные камни, о которых вы должны знать:';
$string['emailbrandingpitfallsli1'] = 'Обязательным условием является изменение строк языкового пакета <em>текущего языка по умолчанию</em> этого сайта. Даже если у вас установлено несколько языковых пакетов, эффект будет иметь только изменение языка по умолчанию.';
$string['emailbrandingpitfallsli2'] = 'Учесть язык получателя невозможно. Поэтому в фрагментах брендинга электронной почты следует использовать термины, не зависящие от языка.';
$string['emailbrandingpitfallsli3'] = 'Если в будущем вы измените язык сайта по умолчанию, вам придется перенести измененные строки языкового пакета в новый языковой пакет по умолчанию.';
$string['emailbrandingpitfallsli4'] = 'В обычной электронной почте после префикса и перед суффиксным фрагментом автоматически добавляется разрыв строки и пустая строка. Это делается для того, чтобы суффикс и префикс не приклеивались непосредственно к телу электронной почты.';
$string['emailbrandingpitfallsli5'] = 'В электронной почте HTML префикс и суффикс добавляются непосредственно перед и над телом электронной почты. Это делается для того, чтобы вы могли легко работать с HTML-тегами, однако вам придется самостоятельно обрабатывать все интервалы вокруг тела письма.';
$string['emailbrandingpitfallsli6'] = 'В HTML-почте вы можете без проблем открыть HTML-тег в префиксном фрагменте и закрыть его в суффиксном фрагменте. Только не забудьте создать правильный HTML в результирующем письме.';
$string['emailbrandingtab'] = 'Брендирование почты';
$string['emailbrandingtextdemobody'] = 'Тело электронного письма начинается здесь.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Тело электронного письма заканчивается здесь.';
$string['emailbrandingtextheading'] = 'Предварительный просмотр электронного письма с простым текстом';
$string['emailbrandingtextintro'] = 'Это предварительный просмотр электронной почты, основанной на префиксах и суффиксах брендинга, которые в настоящее время установлены в языковом пакете.';
$string['emailbrandingtextnopreview'] = 'До сих пор обычные текстовые электронные письма не были настроены с учетом этой функции. Электронная почта будет составляться и отправляться в обычном режиме.';
$string['enableaboutussetting'] = 'Включить страницу «О нас»';
$string['enablecontactsetting'] = 'Включить страницу контактов';
$string['enablefooterbutton'] = 'Включить кнопку нижнего колонтитула';
$string['enablefooterbutton_desc'] = 'Под «кнопкой в нижнем колонтитуле» подразумевается круг, содержащий вопросительный знак в нижней части страницы.<br />После нажатия на него на странице появляется наложенное поле. В зависимости от конфигурации сайта Moodle в этой накладке отображается несколько ссылок (например, «Справка и документация» или «Сводка о сохранении данных»).<br /> С помощью этой настройки вы можете управлять тем, показывать или не показывать кнопку нижнего колонтитула внизу страницы.';
$string['enablefooterbuttonboth'] = 'Включить на компьютере, планшете и мобильном';
$string['enablefooterbuttondesktop'] = 'Включить только на компьютере и планшете, скрыть на мобильном (без изменений, как задано в ядре Moodle)';
$string['enablefooterbuttonhidden'] = 'Скрыть на всех устройствах';
$string['enablefooterbuttonmobile'] = 'Включить только на мобильном, скрыть на компьютере и планшете';
$string['enablehelpsetting'] = 'Включить страницу справки';
$string['enableimprintsetting'] = 'Включить выходные данные';
$string['enablemaintenancesetting'] = 'Включить страницу с информацией о техническом обслуживании';
$string['enableofferssetting'] = 'Включить страницу предложений';
$string['enablepage1setting'] = 'Включить общую страницу 1';
$string['enablepage2setting'] = 'Включить общую страницу 2';
$string['enablepage3setting'] = 'Включить общую страницу 3';
$string['error:infobannerdismissnonotdismissible'] = 'Данный информационный баннер не может быть закрыт';
$string['error:infobannerdismissnonotvalid'] = 'Номер информационного баннера не действителен';
$string['error:smartmenusmenuitemnotfound'] = 'Элемент умного меню не найден';
$string['error:smartmenusmenunotfound'] = 'Умное меню не найдено';
$string['faviconheading'] = 'Фавикон';
$string['faviconheading_desc'] = 'Обратите внимание: Boost Union имеет свой собственный загружаемый фавикон, а не использует из <a href="{$a}">настройки фавикон ядра Moodle</a>.<br />Boost Union позволяет вам переопределять загруженный фавикон с учетом своих стилей.';
$string['faviconsetting'] = 'Фавикон';
$string['faviconsetting_desc'] = 'Здесь вы можете загрузить пользовательское изображение (в формате .ico или .png), которое будет отображаться в браузере в качестве фавикон вашего сайта Moodle. Если пользовательский favicon не загружен, будет использоваться стандартный фавикон Moodle.';
$string['flavoursappliesto'] = 'Применить к';
$string['flavoursapplytocategories'] = 'Применить к категории курсов';
$string['flavoursapplytocategories_help'] = 'Здесь вы определяете, следует ли применять этот стиль к категориям курсов.';
$string['flavoursapplytocategories_ids'] = 'Категории курсов';
$string['flavoursapplytocategories_ids_help'] = 'Здесь вы определяете одну или несколько конкретных категорий курсов, к которым будет применяться данный стиль. Когда отображаемая страница Moodle будет находиться в одной из указанных категорий курса, стиль будет применен.';
$string['flavoursapplytocohorts'] = 'Применить к глобальной группе';
$string['flavoursapplytocohorts_help'] = 'Здесь вы определяете, следует ли применять этот стиль к глобальным группам.';
$string['flavoursapplytocohorts_ids'] = 'Глобальные группы';
$string['flavoursapplytocohorts_ids_help'] = 'Здесь вы определяете одну или несколько конкретных глобальных групп, к которым следует применить этот стиль. Как только пользователь становится членом одной из настроенных глобальных групп, стиль применяется.<br /><br />Обратите внимание, что если вы указываете более одной глобальной группы, пользователю не нужно быть членом всех их одновременно.<br /><br />Пожалуйста, обратите внимание, что на текущем этапе внедрения группы категорий обрабатываются так же, как если бы они были системными глобальными группами.';
$string['flavoursbackgroundimage'] = 'Фоновое изображение';
$string['flavoursbackgroundimage_help'] = 'С помощью этого параметра стиль будет переопределять фоновое изображение, которое задано в настройках внешнего вида Boost Union.';
$string['flavoursbacktooverview'] = 'Вернуться к списку стилей';
$string['flavourscreateflavour'] = 'Создать стиль';
$string['flavourscustomcss'] = 'Пользовательский CSS';
$string['flavourscustomcss_help'] = 'С помощью этого параметра вы можете написать собственный CSS для стиля. Он будет добавлен в стек кода CSS, который будет обработан браузером при применении стиля. Обратите внимание, что в текущем состоянии реализации этот параметр позволяет использовать только пользовательский CSS, но не SCSS.';
$string['flavoursdelete'] = 'Удалить';
$string['flavoursdeleteconfirmation'] = 'Вы действительно хотите удалить стиль <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Удалить стиль';
$string['flavoursdescription'] = 'Описание';
$string['flavoursdescription_help'] = 'Описание стиля используется только для того, чтобы вы могли узнать конкретный стиль в списке стилей.';
$string['flavoursedit'] = 'Редактировать';
$string['flavourseditflavour'] = 'Редактировать стиль';
$string['flavoursfavicon'] = 'Фавикон';
$string['flavoursfavicon_help'] = 'С помощью этой настройки стиль будет переопределять фавикон, который определен в настройках внешнего вида Boost Union.';
$string['flavoursflavours'] = 'Стили';
$string['flavoursgeneralsettings'] = 'Общее';
$string['flavoursincludesubcategories'] = 'Включить подкатегории';
$string['flavoursincludesubcategories_help'] = 'При включенном параметре стиль будет также применен к подкатегориям выбранных категорий.';
$string['flavourslogo'] = 'Логотип';
$string['flavourslogo_help'] = 'С помощью этой настройки стиль будет переопределять логотип, который задан в настройках внешнего вида Boost Union.';
$string['flavourslogocompact'] = 'Компактный логотип';
$string['flavourslogocompact_help'] = 'С помощью этой настройки стиль будет переопределять компактный логотип, который задан в настройках внешнего вида Boost Union.';
$string['flavoursnothingtodisplay'] = 'Еще не создано ни одного стиля. Пожалуйста, создайте свой первый стиль, чтобы начать работу.';
$string['flavoursnotificationcreated'] = 'Стиль создан';
$string['flavoursnotificationdeleted'] = 'Стиль удален';
$string['flavoursnotificationedited'] = 'Стиль изменен';
$string['flavoursoverview_desc'] = '<p>Стили Boost Union дают возможность переопределять определенные настройки внешнего вида и настроек Moodle в определенных контекстах. На этой странице вы можете создавать стили и управлять ими.</p><p>В рамках каждого стиля вы определяете, должен ли он применяться к определенным категориям курсов или определенным глобальным группам. Затем, во время отображения каждой страницы Moodle, Boost Union проверяет, применяется ли какой-либо стиль. Обратите внимание, что при каждом отображении страницы Moodle применяется только первый подходящий стиль в списке, а остальные стили игнорируются. Таким образом, порядок расположения стилей на этой странице является ключевым.</p><p>Обратите внимание, что после каждого изменения, которое вы вносите в набор стилей, кэш темы очищается. Это необходимо для того, чтобы убедиться, что все объекты поставляются в браузер правильно и в актуальном состоянии.</p>';
$string['flavourspreview'] = 'Предварительный просмотр';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Предварительный просмотр стиля';
$string['flavourstitle'] = 'Название';
$string['flavourstitle_help'] = 'Название стиля используется только для того, чтобы вы могли найти конкретный стиль в списке стилей.';
$string['footerheading'] = 'Нижний колонтитул';
$string['footertab'] = 'Нижний колонтитул';
$string['footnoteheading'] = 'Колонтитул';
$string['footnotesetting'] = 'Колонтитул';
$string['footnotesetting_desc'] = 'Все, что вы добавите в эту текстовую область, будет отображаться в конце страницы, в нижнем колонтитуле (не в плавающем колонтитуле) на каждой странице, которая использует макеты "drawers", "columns2" или "login". Содержание в этой области может быть, например, авторским правом, условиями использования или названием вашей организации.<br/>Если вы захотите снова удалить текст колонтитула, просто очистите текстовую область.';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Проблемы на Github</a>';
$string['h5pcontentmaxwidthsetting'] = 'Максимальная ширина банка контента H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете изменить ширину банка контента H5P в Moodle без ручной правки SCSS. Эта ширина используется для редактора H5P внутри банка контента. Она <em>не</em> используется для ширины элемента H5P. По умолчанию Moodle использует максимальную ширину банка контента H5P, равную 960px. Вы можете ввести другие значения, основанные на пикселях, например 1200px, но вы также можете ввести значение, основанное на процентах, например 100% или значение viewport-width, например 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Содержание страницы справки';
$string['helpcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице справки.';
$string['helpdisabled'] = 'Страница справки отключена для этого сайта. Здесь не на что смотреть.';
$string['helpheading'] = 'Справка';
$string['helplinkpositionboth'] = 'Добавить ссылку на страницу справки в сноске и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['helplinkpositionfooter'] = 'Добавить ссылку на страницу справки на иконку «Знак вопроса» в нижнем колонтитуле';
$string['helplinkpositionfootnote'] = 'Добавить ссылку на страницу справки в колонтитул';
$string['helplinkpositionnone'] = 'Не показывать автоматически ссылку на страницу справки';
$string['helplinkpositionsetting'] = 'Расположение ссылки на страницу справки';
$string['helplinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу справки автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['helppagetitledefault'] = 'Справка';
$string['helppagetitlesetting'] = 'Заголовок страницы справки';
$string['helppagetitlesetting_desc'] = 'Этот параметр позволяет задать заголовок страницы справки. Этот текст также будет использоваться в качестве текста ссылки на страницу справки, если параметр «Расположение ссылки на страницу справки» настроен соответствующим образом.';
$string['hidenodesprimarynavigationsetting'] = 'Скрыть узлы в основной навигации';
$string['hidenodesprimarynavigationsetting_desc'] = 'С помощью этого параметра можно скрыть один или несколько узлов из основной навигации.<br /><br />
Обратите внимание: здесь вы можете просто удалить узлы навигации. Но если вы хотите добавить собственные узлы навигации, рассмотрите возможность использования <a href="{$a->url}">функций умного меню Boost Union</a>.';
$string['imprintcontentsetting'] = 'Выходные данные';
$string['imprintcontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице выходных данных.';
$string['imprintdisabled'] = 'Страница выходных данных отключена на этом сайте. Здесь не на что смотреть.';
$string['imprintheading'] = 'Выходные данные';
$string['imprintlinkpositionboth'] = 'Добавьте ссылку на страницу выходных данных в колонтитул и на значок нижнего колонтитула (знак вопроса)';
$string['imprintlinkpositionfooter'] = 'Добавьте ссылку на страницу выходных данных на значок нижнего колонтитула (знак вопроса)';
$string['imprintlinkpositionfootnote'] = 'Добавить ссылку на страницу выходных данных в колонтитул';
$string['imprintlinkpositionnone'] = 'Не показывать автоматически ссылку на страницу выходных данных';
$string['imprintlinkpositionsetting'] = 'Позиция ссылки на выходные данные';
$string['imprintlinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу выходных данных автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['imprintpagetitledefault'] = 'Выходные данные';
$string['imprintpagetitlesetting'] = 'Заголовок страницы выходных данных';
$string['imprintpagetitlesetting_desc'] = 'В этом параметре вы можете определить название страницы выходных данных. Этот текст также будет использоваться в качестве текста ссылки на страницу выходных данных, если вы соответствующим образом настроите «Позиция ссылки на выходные данные».';
$string['infobannerbsclasssetting'] = 'Класс Bootstrap информационного баннера {$a->no}';
$string['infobannerbsclasssetting_desc'] = 'С помощью этой настройки вы можете выбрать класс Bootstrap,который будет применен к информационному баннеру {$a->no}. Если вы выберете опцию «Без цвета Bootstrap», то информационный баннер будет выводиться без какого-либо определенного цвета Bootstrap, что даст вам свободу стилизовать баннер самостоятельно в текстовом редакторе.';
$string['infobannerclose'] = 'Закрыть';
$string['infobannercontentsetting'] = 'Содержимое информационного банера {$a->no}';
$string['infobannercontentsetting_desc'] = 'Здесь можно ввести информацию, которая должна отображаться в информационном баннере {$a->no}.';
$string['infobannerdismissconfirm'] = 'Вы действительно хотите сбросить видимость информационного баннера {$a->no} и снова показать его всем пользователям, которые его закрыли?';
$string['infobannerdismissfail'] = 'Сброс видимости информационного баннера {$a->no} не удался по крайней мере для одного пользователя';
$string['infobannerdismissiblesetting'] = 'Информационный баннер {$a->no} можно закрыть';
$string['infobannerdismissiblesetting_desc'] = 'С помощью этой настройки вы можете сделать информационный баннер {$a->no} неудаляемым. Если пользователь нажмет на кнопку Х в информационном баннере, то он будет скрыт для этого пользователя навсегда. Видимость не сбрасывается автоматически, даже если вы меняете содержимое информационного баннера. Если вы хотите сбросить видимость информационного баннера, нажмите ниже кнопку «Сбросить видимость».';
$string['infobannerdismissreset'] = 'Сделать видимым закрытый информационный баннер';
$string['infobannerdismissresetbutton'] = 'Сбросить видимость информационного баннера {$a->no}';
$string['infobannerdismisssuccess'] = 'Видимость информационного баннера {$a->no} была сброшена.';
$string['infobannerenabledsetting'] = 'Включить информационный банер {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Этот параметр включает информационный баннер {$a->no}.';
$string['infobannerendsetting'] = 'Время окончания показа информационного баннера {$a->no}';
$string['infobannerendsetting_desc'] = 'С помощью этого параметра вы можете определить, до какого момента должен отображаться информационный баннер {$a->no}. Настроенное время интерпретируется как время сервера, а не как время пользователя.';
$string['infobannerheading'] = 'Информационный баннер {$a->no}';
$string['infobannermodeperpetual'] = 'Постоянный';
$string['infobannermodesetting'] = 'Режим отображения информационного баннера {$a->no}';
$string['infobannermodesetting_desc'] = 'С помощью этого параметра вы можете определить, должен ли информационный баннер {$a->no} быть постоянным баннером (отображается всегда) или баннером, управляемым по времени (отображается только в течение заданного интервала времени).';
$string['infobannermodetimebased'] = 'Управление по времени';
$string['infobannerordersetting'] = 'Порядок размещения информационного баннера {$a->no}';
$string['infobannerordersetting_desc'] = 'С помощью этого параметра вы определяете порядковый номер информационного баннера {$a->no}. По умолчанию информационные баннеры упорядочены сверху вниз, как вы видите их на этой странице настроек. Однако с помощью этой настройки вы можете назначить другую позицию. Если вы назначите одну и ту же позицию двум или более информационным баннерам, они будут снова упорядочены в соответствии с порядком на этой странице.';
$string['infobannerpageloginpage'] = 'Страница авторизации';
$string['infobannerpagessetting'] = 'Макеты страниц для отображения информационного баннера {$a->no}';
$string['infobannerpagessetting_desc'] = 'Этот параметр позволяет выбрать макеты страниц, на которых должен отображаться информационный баннер {$a->no}.';
$string['infobannerstartsetting'] = 'Время начала показа информационного баннера {$a->no}';
$string['infobannerstartsetting_desc'] = 'С помощью этого параметра вы можете определить, с какого момента должен отображаться информационный баннер {$a->no}. Заданное время интерпретируется как время сервера, а не как время пользователя.';
$string['infobannertab'] = 'Информационный баннер';
$string['javascriptdisabledhint'] = 'Подсказка о выключенном JavaScript';
$string['javascriptdisabledhint_desc'] = 'С помощью этой настройки в верхней части страницы Moodle появится подсказка, если JavaScript не включен. Это особенно полезно, поскольку некоторые функции Moodle не работают без JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript отключен в вашем браузере.<br />Многие функции Moodle будут недоступны или будут выглядеть нерабочими.<br />Пожалуйста, включите JavaScript для полноценной работы с Moodle.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Ссылки';
$string['loginbackgroundimage'] = 'Фоновые изображения страницы авторизации';
$string['loginbackgroundimage_desc'] = 'Изображения для отображения в качестве фона страницы входа в систему. Одно из этих изображений будет выбрано случайным образом и показано при посещении пользователем страницы входа в систему. Пожалуйста, убедитесь, что в имени файла не используются символы, отличные от ASCII, если вы хотите отобразить текст для фоновых изображений входа в систему.';
$string['loginbackgroundimagepositionsetting'] = 'Положение фонового изображения страницы авторизации';
$string['loginbackgroundimagepositionsetting_desc'] = 'Здесь вы можете задать позиционирование фонового изображения страницы авторизации в окне браузера. Первое значение - горизонтальное положение, второе - вертикальное.';
$string['loginbackgroundimagesheading'] = 'Фоновые изображения страницы авторизации';
$string['loginbackgroundimagetextsetting'] = 'Отображение текста для фоновых изображений страницы авторизации';
$string['loginbackgroundimagetextsetting_desc'] = 'С помощью этого необязательного параметра к загруженным фоновым изображениям можно добавить текст, например, уведомление об авторских правах. Этот текст появится в верхней части нижнего колонтитула на странице входа в систему. Однако из соображений экономии площади экрана он отображается только на экранах больших размеров.<br/>
Каждая строка состоит из идентификатора файла (имя файла), текста, который должен быть отображен, и цвета текста, разделенных символами вертикальной черты. Каждое описание должно быть записано с новой строки. <br/>
Например:<br/>
background-image-1.jpg|Copyright: CC0|dark<br/>
В качестве цвета текста можно использовать значения "dark" или "light".<br />
Вы можете объявить тексты для произвольного количества загруженных фоновых изображений. Тексты будут добавлены только к тем изображениям, имя файла которых совпадает с идентификатором, объявленным в этом параметре.';
$string['loginformheading'] = 'Форма входа';
$string['loginformpositionsetting'] = 'Расположение формы входа';
$string['loginformpositionsetting_center'] = 'По центру';
$string['loginformpositionsetting_desc'] = 'С помощью этой настройки вы можете переместить форму входа в систему, чтобы она подходила к большему числу фоновых изображений. По умолчанию форма входа отображается по центру страницы входа. В качестве альтернативы вы можете переместить ее влево или вправо, чтобы другие части фонового изображения были видны. Конечно, вы также можете изменить этот параметр даже если фоновые изображения вообще не загружены.';
$string['loginformpositionsetting_left'] = 'Выравнивание по левому краю';
$string['loginformpositionsetting_right'] = 'Выравнивание по правому краю';
$string['loginformtransparencysetting'] = 'Прозрачность формы входа';
$string['loginformtransparencysetting_desc'] = 'С помощью этой настройки можно сделать форму входа в систему слегка прозрачной, чтобы лучше показать фоновое изображение.';
$string['loginpagetab'] = 'Страница авторизации';
$string['logocompactsetting'] = 'Компактный логотип';
$string['logocompactsetting_desc'] = 'Здесь вы можете загрузить компактную версию того же логотипа, что и выше, например, эмблему, щит или значок. Это изображение особенно часто используется в навигационной панели в верхней части каждой страницы Moodle. Изображение должно быть четким даже при небольших размерах.';
$string['logosetting'] = 'Логотип';
$string['logosetting_desc'] = 'Здесь вы можете загрузить полный логотип для использования в качестве украшения. Это изображение особенно часто используется на странице входа в систему. Это изображение должно быть с высоким разрешением, поскольку оно будет уменьшено при использовании.';
$string['logosheading'] = 'Логотипы';
$string['logosheading_desc'] = 'Обратите внимание: Boost Union имеет свою собственную загрузку логотипа и не использует логотип из <a href="{$a}">настроек логотипа ядра Moodle</a>.<br />Boost Union позволяет загружать больше форматов изображений, чем позволяет ядро Moodle, и позволяет переопределять загруженные логотипы с учетом своих стилей.';
$string['maintenancecontentsetting'] = 'Содержимое страницы с информацией о техническом обслуживании';
$string['maintenancecontentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на странице информации о техническом обслуживании (отличается от встроенной в  Moodle страницы режима обслуживания).';
$string['maintenancedisabled'] = 'Страница  с информацией о техническом обслуживании отключена для этого сайта. Здесь не на что смотреть.';
$string['maintenanceheading'] = 'Обслуживание';
$string['maintenancelinkpositionboth'] = 'Добавить ссылку на страницу с информацией о техническом обслуживании в сноску и на иконку «Знак вопроса» в нижнем колонтитуле';
$string['maintenancelinkpositionfooter'] = 'Добавить ссылку на страницу с информацией о техническом обслуживании на иконку «Знак вопроса» в нижнем колонтитуле';
$string['maintenancelinkpositionfootnote'] = 'Добавьте ссылку на страницу с информацией о техническом обслуживании в колонтитул';
$string['maintenancelinkpositionnone'] = 'Не показывать автоматически ссылку на страницу с информацией о техническом обслуживании';
$string['maintenancelinkpositionsetting'] = 'Расположение ссылки на страницу с информацией о техническом обслуживании';
$string['maintenancelinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу с информацией о техническом обслуживании автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете добавить ссылку на {$a->url} из любого места в Moodle вручную.';
$string['maintenancepagetitledefault'] = 'Информация о техническом обслуживании';
$string['maintenancepagetitlesetting'] = 'Заголовок страницы с информацией о техническом обслуживании';
$string['maintenancepagetitlesetting_desc'] = 'Этот параметр позволяет задать заголовок страницы с информацией о техобслуживании. Этот текст также будет использоваться в качестве текста ссылки на такую страницу, если параметр «Расположение ссылки на страницу с информацией о техобслуживании» настроен соответствующим образом.';
$string['markexternallinkssetting'] = 'Отмечать внешние ссылки';
$string['markexternallinkssetting_desc'] = 'Добавляет значок "внешняя ссылка" после внешних ссылок (которые ведут пользователя к цели за пределы Moodle).';
$string['mediumcontentmaxwidthsetting'] = 'Максимальная ширина среднего контента';
$string['mediumcontentmaxwidthsetting_desc'] = 'С помощью этой настройки вы можете переопределить ширину контента в средней колонке Moodle без ручных изменений SCSS. Эта ширина страницы используется некоторыми элементами курса, например, - Базой данных. По умолчанию Moodle использует максимальную ширину средней колонки 1120 пикселей. Вы можете ввести другие значения в пикселях, например 1200 пикселей, но вы также можете ввести значение в процентах, например 100%, или значение ширины области просмотра, например 90vw.';
$string['misctab'] = 'Разное';
$string['mobileappearanceheading'] = 'Мобильный вид';
$string['mobilecss'] = 'Дополнительный CSS для мобильного приложения';
$string['mobilecss_desc'] = 'С помощью этого параметра вы можете написать собственный код CSS для настройки интерфейса вашего мобильного приложения. Код CSS будет добавлен только к стилям этого экземпляра Moodle в мобильном приложении и не будет отображаться в версии для веб-браузера. Подробнее об этой функции читайте в <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Документации разработчика Moodle</a>.';
$string['mobilecss_donotchange'] = 'Этот шаг необходим для отправки кода CSS в мобильное приложение. Не изменяйте URL-адрес, если только вы действительно не хотите снова удалить CSS-код из мобильного приложения.';
$string['mobilecss_overwrite'] = 'Как только вы добавите какой-либо код CSS в этот параметр и сохраните его, <a href="{$a->url}">основной параметр Moodle <em>mobilecssurl</em></a> будет автоматически перезаписан URL-адресом темы Boost Union. Текущее значение <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Как только вы добавите какой-либо код CSS в этот параметр и сохраните его, <a href="{$a->url}">параметр ядра Moodle <em>mobilecssurl</em></a> будет автоматически установлен в значение URL-адреса темы Boost Union.';
$string['mobiletab'] = 'Мобильное приложение';
$string['modiconactivity'] = 'Элемент курса';
$string['modiconactivityunknown'] = 'Неизвестно';
$string['modicongtmoodle4'] = 'Иконки Moodle 4';
$string['modiconlistsetting'] = 'Список пользовательских иконок элементов курса';
$string['modiconlistsetting_desc'] = 'Это список файлов пользовательских иконок, которые вы выше загрузили в раздел файлов пользовательских иконок. Здесь перечислены все допустимые файлы иконок. Кроме того, другие файлы, которые вы могли загрузить, но которые не являются действительными файлами иконок, также показаны как неработающие файлы.';
$string['modiconltmoodle311'] = 'Иконка, оставшаяся от Moodle 3';
$string['modiconnamefail'] = 'Этот файл был загружен в правильную папку для модуля <em>{$a}</em>, но имя файла не соответствует требованиям. Измените имя файла либо на <em>monologo.svg</em> / <em>monologo.png</em> (для иконок Moodle 4) либо на <em>icon.svg</em> / <em>icon.png</em> (для иконок, оставшихся от Moodle 3).';
$string['modiconnotexist'] = 'Этот файл был загружен в неподходящее место, так как по пути к файлу <em>{$a}</em> невозможно определить конкретный плагин.';
$string['modiconsenablesetting'] = 'Разрешить пользовательские иконки для элементов и ресурсов курсов';
$string['modiconsenablesetting_desc'] = 'Эта настройка позволяет изменить иконки для элементов и ресурсов курсов , которые используются на страницах курса и в средстве их выбора.';
$string['modiconserrorcreatingpath'] = 'Каталог pix_plugins/mod не может быть создан в каталоге moodledata.<br /> Сообщение об исключении: {$a}.';
$string['modiconsfiles'] = 'Файлы пользовательских иконок';
$string['modiconsfiles_desc'] = 'Здесь вы можете загрузить пользовательские иконки для всех или только некоторых элементов курса, установленных в данном экземпляре Moodle.';
$string['modiconsfileshowto'] = 'Чтобы загрузить иконку конкретного элемента, создайте папку с внутренним именем элемента, например <em>assign</em> для задания. В эту папку вы загружаете иконку в виде SVG-файла monologo.svg и, если возможно, в виде резервного PNG-файла monologo.png. Если вы хотите настроить цветные иконки, которые использовались до Moodle 3 и которые все еще могут использоваться старыми плагинами, вы также можете загрузить их в виде файлов icon.svg и icon.png. Однако, пожалуйста, придерживайтесь однотонных SVG-иконок, если это возможно, для достижения наилучших результатов. Затем сохраните страницу настроек. Как только вы сохраните настройки хотя бы с одним файлом, ниже появится список файлов, который поможет вам проверить, правильно ли были загружены пользовательские иконки.';
$string['modiconsfilestech'] = 'Техническое примечание: После сохранения настроек загруженная структура папок и файлы иконок будут скопированы в папку pix_plugins/mod в вашем каталоге moodledata. Это место, где ядро Moodle ищет пользовательские иконки элементов курса. Все файлы иконок, которые могут уже существовать в этом месте, будут перезаписаны при сохранении этой настройки.';
$string['modiconsheading'] = 'Иконки элементов курса';
$string['modiconsuccess3x'] = 'Эта иконка используется модулем <em>{$a}</em> как устаревшая иконка Moodle 3.';
$string['modiconsuccess4x'] = 'Эта иконка используется модулем <em>{$a}</em> как иконка Moodle 4.';
$string['modiconversion'] = 'Версия иконки';
$string['navbarcolorsetting'] = 'Цвет панели навигации';
$string['navbarcolorsetting_dark'] = 'Темная панель навигации со светлым цветом шрифта';
$string['navbarcolorsetting_desc'] = 'С помощью этого параметра можно изменить цвет навигационной панели со светлого по умолчанию на темный или корпоративный.';
$string['navbarcolorsetting_light'] = 'Светлая панель навигации с темным цветом шрифта (без изменений, как представлено в ядре Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Навигационная панель основного цвета со светлым цветом шрифта';
$string['navbarcolorsetting_primarylight'] = 'Навигационная панель основного цвета с темным цветом шрифта';
$string['navbarheading'] = 'Панель навигации';
$string['navigationheading'] = 'Навигация';
$string['navigationtab'] = 'Навигация';
$string['offerscontentsetting'] = 'Содержимое страницы предложений';
$string['offerscontentsetting_desc'] = 'Этот параметр позволяет добавить форматированный текстовый контент, который будет отображаться на странице предложений.';
$string['offersdisabled'] = 'Страница предложений отключена для этого сайта. Здесь не на что смотреть.';
$string['offersheading'] = 'Предложения';
$string['offerslinkpositionboth'] = 'Добавить ссылку на страницу предложений в сноску и в значок нижнего колонтитула (знак вопроса)';
$string['offerslinkpositionfooter'] = 'Добавить ссылку на страницу предложений в значок нижнего колонтитула (знак вопроса)';
$string['offerslinkpositionfootnote'] = 'Добавить ссылку на страницу предложений в сноску';
$string['offerslinkpositionnone'] = 'Не показывать автоматически ссылку на страницу предложений';
$string['offerslinkpositionsetting'] = 'Расположение ссылки на предложения';
$string['offerslinkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на страницу предложений автоматически добавляться на страницу Moodle. Если вы не хотите, чтобы ссылка отображалась автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места Moodle.';
$string['offerspagetitledefault'] = 'Предложения';
$string['offerspagetitlesetting'] = 'Заголовок страницы предложений';
$string['offerspagetitlesetting_desc'] = 'В этой настройке вы можете определить заголовок страницы предложений. Этот текст также будет использоваться в качестве текста ссылки на страницу предложений, если вы соответствующим образом настроите «Расположение ссылки на предложения».';
$string['openoffcanvas'] = 'Открыть панель «Вне страницы»';
$string['outsideregionsheading'] = 'Внешние области';
$string['outsideregionsheading_desc'] = 'Внешние области можно не только включить с помощью указанных выше настроек макета, но и настроить их внешний вид.';
$string['outsideregionsplacement'] = 'Горизонтальное размещение внешних областей';
$string['outsideregionsplacement_desc'] = 'С помощью этой настройки вы можете контролировать, должны ли на больших экранах области «Внешняя (слева)» и «Внешняя (справа)» располагаться рядом с областью основного контента или ближе к краям окна.';
$string['outsideregionsplacementnearwindowedges'] = 'Отображать области «Внешняя (слева)» и «Внешняя (справа)» у краев окна';
$string['outsideregionsplacementnextmaincontent'] = 'Отображать области «Внешняя (слева)» и «Внешняя (справа)» рядом с областью основного контента';
$string['outsideregionswidthcoursecontentwidth'] = 'Ширина колонки контента курса';
$string['outsideregionswidthfullwidth'] = 'Полная ширина';
$string['outsideregionswidthherowidth'] = 'Ширина блока';
$string['page1contentsetting'] = 'Содержимое общей страницы 1';
$string['page1contentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на общей странице 1.';
$string['page1disabled'] = 'Общая страница 1 отключена для этого сайта. Здесь не на что смотреть.';
$string['page1heading'] = 'Общая страница 1';
$string['page1linkpositionboth'] = 'Добавить ссылку на общую страницу 1 в колонтитул и в значок нижнего колонтитула (знак вопроса)';
$string['page1linkpositionfooter'] = 'Добавить ссылку на общую страницу 1 в значок нижнего колонтитула (знак вопроса)';
$string['page1linkpositionfootnote'] = 'Добавить ссылку на общую страницу 1 в колонтитул';
$string['page1linkpositionnone'] = 'Не показывать автоматически ссылку на общую страницу 1';
$string['page1linkpositionsetting'] = 'Расположение ссылки на общую страницу 1';
$string['page1linkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на общую страницу 1 автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места в Moodle.';
$string['page1pagetitledefault'] = 'Общая страница 1';
$string['page1pagetitlesetting'] = 'Заголовок общей страницы 1';
$string['page1pagetitlesetting_desc'] = 'Этот параметр определяет заголовок общей страницы 1. Этот текст будет использоваться в качестве текста ссылки на общую страницу 1, если вы соответствующим образом настроите «Расположение ссылки на общую страницу 1».';
$string['page2contentsetting'] = 'Содержимое общей страницы 2';
$string['page2contentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на общей странице 2.';
$string['page2disabled'] = 'Общая страница 2 отключена для этого сайта. Здесь не на что смотреть.';
$string['page2heading'] = 'Общая страница 2';
$string['page2linkpositionboth'] = 'Добавить ссылку на общую страницу 2 в колонтитул и в значок нижнего колонтитула (знак вопроса)';
$string['page2linkpositionfooter'] = 'Добавить ссылку на общую страницу 2 в значок нижнего колонтитула (знак вопроса)';
$string['page2linkpositionfootnote'] = 'Добавить ссылку на общую страницу 2 в колонтитул';
$string['page2linkpositionnone'] = 'Не показывать автоматически ссылку на общую страницу 2';
$string['page2linkpositionsetting'] = 'Расположение ссылки на общую страницу 2';
$string['page2linkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на общую страницу 2 автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места в Moodle.';
$string['page2pagetitledefault'] = 'Общая страница 2';
$string['page2pagetitlesetting'] = 'Заголовок общей страницы 2';
$string['page2pagetitlesetting_desc'] = 'Этот параметр определяет заголовок общей страницы 2. Этот текст будет использоваться в качестве текста ссылки на общую страницу 2, если вы соответствующим образом настроите «Расположение ссылки на общую страницу 2».';
$string['page3contentsetting'] = 'Содержимое общей страницы 3';
$string['page3contentsetting_desc'] = 'В этом параметре вы можете добавить расширенный текстовый контент, который будет отображаться на общей странице 3.';
$string['page3disabled'] = 'Общая страница 3 отключена для этого сайта. Здесь не на что смотреть.';
$string['page3heading'] = 'Общая страница 3';
$string['page3linkpositionboth'] = 'Добавить ссылку на общую страницу 3 в колонтитул и в значок нижнего колонтитула (знак вопроса)';
$string['page3linkpositionfooter'] = 'Добавить ссылку на общую страницу 3 в значок нижнего колонтитула (знак вопроса)';
$string['page3linkpositionfootnote'] = 'Добавить ссылку на общую страницу 3 в колонтитул';
$string['page3linkpositionnone'] = 'Не показывать автоматически ссылку на общую страницу 3';
$string['page3linkpositionsetting'] = 'Расположение ссылки на общую страницу 3';
$string['page3linkpositionsetting_desc'] = 'В этом параметре вы можете указать, должна ли ссылка на общую страницу 3 автоматически добавляться на страницы Moodle. Если вы не хотите показывать ссылку автоматически, вы можете вручную добавить ссылку на {$a->url} из любого места в Moodle.';
$string['page3pagetitledefault'] = 'Общая страница 3';
$string['page3pagetitlesetting'] = 'Заголовок общей страницы 3';
$string['page3pagetitlesetting_desc'] = 'Этот параметр определяет заголовок общей страницы 3. Этот текст будет использоваться в качестве текста ссылки на общую страницу 3, если вы соответствующим образом настроите «Расположение ссылки на общую страницу 3».';
$string['pagetab'] = 'Страница';
$string['pagewidthheading'] = 'Ширина страницы';
$string['pluginname'] = 'Boost Union';
$string['presetheading'] = 'Предустановки тем';
$string['primarynavigationheading'] = 'Основная навигация';
$string['privacy:metadata'] = 'Тема Boost Union не хранит никаких личных данных ни о каком пользователе.';
$string['region-content-lower'] = 'Контент (снизу)';
$string['region-content-upper'] = 'Контент (сверху)';
$string['region-footer-center'] = 'Нижний колонтитул (по центру)';
$string['region-footer-left'] = 'Нижний колонтитул (слева)';
$string['region-footer-right'] = 'Нижний колонтитул (справа)';
$string['region-header'] = 'Заголовок';
$string['region-none'] = 'Нет';
$string['region-offcanvas-center'] = 'Вне страницы (по центру)';
$string['region-offcanvas-left'] = 'Вне страницы (слева)';
$string['region-offcanvas-right'] = 'Вне страницы (справа)';
$string['region-outside-bottom'] = 'Внешняя (снизу)';
$string['region-outside-left'] = 'Внешняя (слева)';
$string['region-outside-right'] = 'Внешняя (справа)';
$string['region-outside-top'] = 'Внешняя (сверху)';
$string['resourcescachecontrolnote'] = 'Обратите внимание, что файлы отправляются в браузер с заголовком \'Cache-Control\', который указывает браузеру кэшировать файл. Если вы уверены, что не будете изменять файл в ближайшем будущем, вы можете использовать постоянный URL для ссылки на файл. Однако, если вы планируете изменять файл, но время от времени сохранять то же имя файла, вам лучше использовать обновляемый URL.  При этом каждый раз при обновлении файла заново ссылаться на файл там, где вы его использовали, чтобы браузеры не показывали кэшированные устаревшие версии файла.';
$string['resourcestab'] = 'Ресурсы';
$string['scrollspysetting'] = 'Отслеживание прокрутки';
$string['scrollspysetting_desc'] = 'С этой настройкой при включении и выключении режима редактирования сохраняется позиция прокрутки, в которой находился пользователь в момент переключения.';
$string['scssheading'] = 'Необработанный SCSS';
$string['scsstab'] = 'SCSS';
$string['showhintcourseguestaccessgeneral'] = 'В настоящее время вы просматриваете этот курс как <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Чтобы получить полный доступ к курсу, вы можете <a href="{$a->url}">самостоятельно записаться на этот курс</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'При включенном параметре в заголовке курса появляется подсказка, если пользователь получает доступ к курсу с помощью гостевого доступа. Если в курсе разрешена самостоятельная запись, пользователю также будет представлена ссылка на соответствующую страницу.';
$string['showhintcoursehiddengeneral'] = 'В настоящее время этот курс <strong>скрыт</strong>. Только зарегистрированные преподаватели могут получить доступ к этому курсу, когда он скрыт.';
$string['showhintcoursehiddensetting'] = 'Отображать подсказку о скрытых курсах';
$string['showhintcoursehiddensetting_desc'] = 'При включенном параметре в заголовке скрытого курса будет появляться подсказка. Это помогает определить состояние видимости курса с первого взгляда без необходимости просматривать настройки курса.';
$string['showhintcoursehiddensettingslink'] = 'Вы можете изменить видимость в <a href="{$a->url}">настройках курса</a>.';
$string['showhintcourseselfenrolfrom'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись после {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись с {$a->from} по {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Если вы не хотите, чтобы любой пользователь Moodle имел свободный доступ к этому курсу, ограничьте настройки самостоятельной записи.';
$string['showhintcourseselfenrolsetting'] = 'Отображать подсказку для самостоятельной записи без ключа';
$string['showhintcourseselfenrolsetting_desc'] = 'При включенном параметре в заголовке видимого курса появится подсказка о возможности записи без ключа.';
$string['showhintcourseselfenrolsince'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись в текущий момент.';
$string['showhintcourseselfenrolsinceuntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись до {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'В настоящее время этот курс доступен для всех и возможна <strong>самостоятельная запись без регистрационного ключа</strong>.';
$string['showhintcourseselfenrolstartfuture'] = 'В настоящее время этот курс доступен для всех и планируется разрешить <strong>самостоятельную запись без регистрационного ключа</strong>.';
$string['showhintcourseselfenrolunlimited'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись в любой момент.';
$string['showhintcourseselfenroluntil'] = 'Способ зачисления на курс <strong>{$a->name}</strong> позволяет неограниченную самостоятельную запись до {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Отображать подсказку о гостевом входе';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Показывать правую боковую панель на домашней странице сайта при первом входе в систему';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, которые входят в систему в первый раз, и не переписывает состояние переключения для каждого отдельного пользователя.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Показывать правую боковую панель на домашней странице сайта при входе гостем';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, которые вошли в систему как гость.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Показывать правую боковую панель  при посещении домашней страницы сайта';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'С помощью этой настройки правая боковая панель главной страницы сайта по умолчанию будет отображаться в развернутом состоянии. Это относится только к пользователям, не вошедшим в систему, и не перезаписывает состояние переключения для каждого отдельного пользователя.';
$string['showswitchedroleincoursesetting'] = 'Отображать подсказку о переключенной роли';
$string['showswitchedroleincoursesetting_desc'] = 'При включенном параметре в заголовке курса появится подсказка, если пользователь сменил роль в курсе. По умолчанию эта информация отображается только рядом с аватаром пользователя в меню пользователя. Включив эту опцию, вы сможете показывать эту информацию (вместе со ссылкой для переключения обратно) также и на странице курса.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'По умолчанию <a href="{$a}">на странице управления курсами</a> Moodle требует, чтобы вы открыли сведения о курсе либо настройки курса, прежде чем вы сможете щелкнуть дополнительный элемент пользовательского интерфейса для просмотра курса. Включив этот параметр, вы можете добавить значок «Просмотреть курс» непосредственно в списке категорий на странице управления курсами.';
$string['showviewcourseiconincoursemgntsetting'] = 'Показать значок просмотра курса';
$string['sitebrandingtab'] = 'Фирменный стиль сайта';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Правая боковая панель на домашней странице сайта';
$string['smartmenus'] = 'Умные меню';
$string['smartmenus_desc'] = '<p>Умные меню позволяют администраторам сайта создавать настраиваемые меню, которые можно размещать в разных местах сайта, например в главном меню сайта, нижнем мобильном меню и меню пользователя. Меню можно настроить на отображение различных типов контента, включая ссылки на другие страницы или ресурсы, ссылки на категории или профили пользователей.</p><p>Администраторы сайта могут создать новое меню, указать пункты меню и настройки отображения. Администратор также может выбрать, где будет отображаться меню на сайте и должно ли оно быть видно всем пользователям или только  пользователям с определенными ролями.</p> <p>';
$string['smartmenusbycohort'] = 'По глобальной группе';
$string['smartmenusbycohort_help'] = 'Ограничить видимость на основе глобальных групп пользователей.';
$string['smartmenusbydate'] = 'По дате';
$string['smartmenusbydate_help'] = 'Ограничить видимость на основе даты.';
$string['smartmenusbydatefrom'] = 'С';
$string['smartmenusbydatefrom_help'] = 'Ограничить видимость до достижения заданной даты';
$string['smartmenusbydateuntil'] = 'По';
$string['smartmenusbydateuntil_help'] = 'Ограничить видимость после достижения заданной даты';
$string['smartmenusbylanguage'] = 'По языку';
$string['smartmenusbylanguage_help'] = 'Ограничить видимость на основе языка пользователя';
$string['smartmenusbyrole'] = 'По роли';
$string['smartmenusbyrole_help'] = 'Ограничить видимость на основе ролей пользователей.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Статус завершения';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы пользователя, соответствующие выбранному статусу завершения. Например, если в качестве статуса завершения выбрать "В процессе", список пунктов меню будет содержать только те курсы, над которыми пользователь в данный момент работает.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Завершен';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Зачислен';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'В процессе';
$string['smartmenusdynamiccoursescoursecategory'] = 'Категория курса';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы из выбранных категорий курсов.';
$string['smartmenusdynamiccoursesdaterange'] = 'Диапазон дат';
$string['smartmenusdynamiccoursesdaterange_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы, которые попадают в выбранный диапазон дат.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Будущее';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Прошлое';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Настоящее время';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Роль при зачислении';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'Список пунктов меню динамических курсов будет содержать все курсы, на которые зачислен пользователь с выбранной ролью.';
$string['smartmenusexperimental'] = 'Обратите внимание: функционал умных меню полностью готов к использованию в текущей реализации, но она должна рассматриваться как <em>экспериментальная</em> из-за большого числа комбинаций настроек, могущих вызвать неожиданные проблемы. В связи с этим тщательно протестируйте свои индивидуальные настройки умных меню. Если вы столкнулись с какими-либо проблемами, сообщите о них на <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> с четким описанием проблемы.';
$string['smartmenusgeneralsectionheader'] = 'Общие настройки';
$string['smartmenusmenuaddnewitem'] = 'Добавить элемент меню';
$string['smartmenusmenucardform'] = 'Форма карточки';
$string['smartmenusmenucardform_help'] = 'Выберите форму карточки для меню, выбрав квадратную, книжную, альбомную или во всю ширину.';
$string['smartmenusmenucardformfullwidth'] = 'Во всю ширину';
$string['smartmenusmenucardformlandscape'] = 'Альбомная';
$string['smartmenusmenucardformportrait'] = 'Книжная';
$string['smartmenusmenucardformsquare'] = 'Квадратная';
$string['smartmenusmenucardoverflowbehavior'] = 'Поведение карточки при переполнении';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Выберите, как себя должно вести меню при переполнении контейнера, выбирая между отображением полосы прокрутки или переносом «лишних» пунктов на другую строку.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Не переносить';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Перенести';
$string['smartmenusmenucardsize'] = 'Размер карточки';
$string['smartmenusmenucardsize_help'] = 'Выберите размер карточки для карточного меню, выбирая между крошечным, маленьким, средним или большим.';
$string['smartmenusmenucardsizelarge'] = 'Большой';
$string['smartmenusmenucardsizemedium'] = 'Средний';
$string['smartmenusmenucardsizesmall'] = 'Маленький';
$string['smartmenusmenucardsizetiny'] = 'Крошечный';
$string['smartmenusmenucreate'] = 'Создать меню';
$string['smartmenusmenucreatesuccess'] = 'Умное меню успешно создано';
$string['smartmenusmenucssclass'] = 'Класс CSS';
$string['smartmenusmenucssclass_help'] = 'Введите CSS-класс для меню. С его помощью можно применить к меню пользовательский стиль.';
$string['smartmenusmenudeleteconfirm'] = 'Вы уверены, что хотите удалить это меню из умных меню?';
$string['smartmenusmenudeletesuccess'] = 'Умное меню успешно удалено';
$string['smartmenusmenudescription'] = 'Описание';
$string['smartmenusmenudescription_help'] = 'Описание меню. Оно будет использоваться в основном как внутренняя документация, но вы также можете показать его в меню с помощью опции "Показать описание".';
$string['smartmenusmenuduplicate'] = 'Дублировать меню и его элементы';
$string['smartmenusmenuduplicatesuccess'] = 'Меню и его элементы успешно продублированы';
$string['smartmenusmenuedit'] = 'Редактировать меню';
$string['smartmenusmenueditsuccess'] = 'Умное меню успешно обновлено';
$string['smartmenusmenuitemcardappearanceheader'] = 'Внешний вид карточки';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Цвет фона карточки';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Выберите цвет фона для карточки пункта меню';
$string['smartmenusmenuitemcardimage'] = 'Изображение карточки';
$string['smartmenusmenuitemcardimage_help'] = 'Выберите изображение, которое будет отображаться рядом с названием пункта меню на карточке.';
$string['smartmenusmenuitemcardtextcolor'] = 'Цвет текста на карточке';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Выберите цвет пункта меню карточки.';
$string['smartmenusmenuitemcreate'] = 'Создать пункт меню';
$string['smartmenusmenuitemcreatesuccess'] = 'Пункт умного меню создан';
$string['smartmenusmenuitemcssclass'] = 'Класс CSS';
$string['smartmenusmenuitemcssclass_help'] = 'Введите класс CSS для пункта меню. Это можно использовать для применения индивидуального стиля к пункту меню.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Вы уверены, что хотите удалить этот пункт из умного меню?';
$string['smartmenusmenuitemdeletesuccess'] = 'Пункт умного меню удален';
$string['smartmenusmenuitemdisplayfield'] = 'Представление названия курса';
$string['smartmenusmenuitemdisplayfield_help'] = 'Название курса, которое будет использоваться в качестве заголовка пунктов меню динамических курсов. Выберите  полное или краткое название курса.';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Полное название курса';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Короткое название курса';
$string['smartmenusmenuitemdisplayoptions'] = 'Представление заголовка';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Выберите, как будет отображаться заголовок пункта меню.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Скрыть текст заголовка и показать только иконку (на всех устройствах)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Скрыть текст заголовка и показать только иконку (на мобильных устройствах)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Показать текст и значок заголовка';
$string['smartmenusmenuitemduplicate'] = 'Дублировать пункт меню';
$string['smartmenusmenuitemduplicatesuccess'] = 'Пункт меню успешно продублирован';
$string['smartmenusmenuitemedit'] = 'Редактировать элемент меню';
$string['smartmenusmenuitemeditsuccess'] = 'Элемент умного меню успешно обновлен';
$string['smartmenusmenuitemicon'] = 'Иконка';
$string['smartmenusmenuitemicon_help'] = 'Значок, который будет отображаться рядом с заголовком пункта меню.';
$string['smartmenusmenuitemlinktarget'] = 'Цель ссылки';
$string['smartmenusmenuitemlinktarget_help'] = 'Цель для ссылки пункта меню. При нажатии на ссылку пункта меню она будет открываться в этой цели (т. е. в том же окне или в новой вкладке).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Новая вкладка';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'То же окно';
$string['smartmenusmenuitemmode'] = 'Режим пункта меню';
$string['smartmenusmenuitemmode_help'] = '<p>Выберите режим отображения пункта в меню.</p><ul><li>Линейный: пункт меню отображается как обычный пункт внутри меню. Это опция по умолчанию.</li><li>Подменю: пункт меню отображается как элемент подменю, который можно развернуть или свернуть, щелкнув родительский элемент. Этот режим полезен для построения третьего уровня навигации, а также для  пунктов меню динамических курсов, где списки курсов могут отображаться как пункты подменю этого пункта меню. Название такого пункта меню используется в качестве текста пункта подменю.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'В это умное меню пока не добавлено ни одного пункта. Добавьте пункт в это меню.';
$string['smartmenusmenuitemorder'] = 'Порядок';
$string['smartmenusmenuitemorder_help'] = 'При необходимости измените положение элемента. Все пункты в меню будут отсортированы в этом порядке.';
$string['smartmenusmenuitempresentationheader'] = 'Представление пункта меню';
$string['smartmenusmenuitemresponsive'] = 'Скрыть пункт меню';
$string['smartmenusmenuitemresponsive_help'] = 'При установке любого из этих флажков пункт меню будет скрыт на устройствах с указанным размером дисплея.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Компьютер';
$string['smartmenusmenuitemresponsivemobile'] = 'Мобильный';
$string['smartmenusmenuitemresponsivetablet'] = 'Планшет';
$string['smartmenusmenuitemrestriction'] = 'Правила доступа';
$string['smartmenusmenuitems'] = 'Пункты меню';
$string['smartmenusmenuitemstructureheader'] = 'Структура пунктов меню';
$string['smartmenusmenuitemtextcount'] = 'Количество слов';
$string['smartmenusmenuitemtextcount_help'] = 'Укажите максимальное количество слов, которые будут отображаться в качестве заголовка в пунктах меню динамических курсов. Если вы оставите это поле пустым, заголовок будет отображаться полностью.';
$string['smartmenusmenuitemtextposition'] = 'Положение текста карточки';
$string['smartmenusmenuitemtextposition_help'] = '';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Ниже изображения';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Нижнее наложение';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Верхнее наложение';
$string['smartmenusmenuitemtitle'] = 'Заголовок';
$string['smartmenusmenuitemtitle_help'] = 'Заголовок меню. Он будет использоваться в качестве метки этого пункта меню. Если вы хотите отобразить разделитель в меню, выберите тип "Заголовок", а в качестве заголовка используйте хэш-знаки (###).';
$string['smartmenusmenuitemtooltip'] = 'Всплывающая подсказка';
$string['smartmenusmenuitemtooltip_help'] = 'Подсказка, которая будет отображаться при наведении курсора на пункт меню.';
$string['smartmenusmenuitemtype'] = 'Тип пункта меню';
$string['smartmenusmenuitemtype_help'] = '<p>Выберите тип пункта меню, который вы хотите создать, выбрав между статическим, заголовочным или динамическими курсами.</p><ul><li>Статический: статический пункт меню — это просто ссылка на фиксированный URL-адрес, который не изменяется.</li><li>Заголовок: пункт меню заголовка используется для группирования связанных пунктов меню под общим заголовком. Он не имеет ссылки и не доступен для кликов.</li><li>Динамические курсы: пункт меню динамических курсов используется для отображения списка курсов на основе определенных критериев, таких как категория курса, роль участника в курсе, состояние завершения курса или диапазон дат. Содержимое, отображаемое в пункте меню динамических курсов, будет обновляться автоматически при изменении критериев.</li></ul>';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Динамические курсы';
$string['smartmenusmenuitemtypeheading'] = 'Заголовок';
$string['smartmenusmenuitemtypestatic'] = 'Статический';
$string['smartmenusmenuitemurl'] = 'URL-адрес пункта меню';
$string['smartmenusmenuitemurl_help'] = 'Статический URL-адрес пункта меню. Это ссылка, по которой будет переход при выборе пункта меню.';
$string['smartmenusmenulocation'] = 'Положение(я) меню';
$string['smartmenusmenulocation_help'] = '<p>Выберите место(а) отображения меню на странице:</p><ul><li>Основная навигация находится в верхней части страницы, где отображаются  элементы навигации по администрированию сайта и «В начало», «Личный кабинет», «Мои курсы».</li><li>Строка меню расположена над основной навигацией в верхней части страницы.</li><li>Доступ к меню пользователя можно получить, щелкнув пользователя или его аватар на панели навигации.</li><li>Нижняя панель расположена в нижней части экрана и может использоваться для навигации с помощью большого пальца для быстрого доступа к важным областям, таким как «В начало», «Личный кабинет», «Мои курсы».</li></ul><p>Обратите внимание, что после включения нижней панели значок гамбургера будет заменен логотипом вашего сайта, поскольку пользователи смогут перейти к основной навигации, используя нижнюю панель.</li></ul><p>Обратите внимание, что при включении нижней панели значок «гамбургера» будет заменен логотипом вашего сайта, поскольку пользователи смогут перейти к основной навигации, используя нижнюю панель.</ р>';
$string['smartmenusmenulocationbottom'] = 'Нижняя панель';
$string['smartmenusmenulocationmain'] = 'Панель навигации';
$string['smartmenusmenulocationmenu'] = 'Строка меню';
$string['smartmenusmenulocationuser'] = 'Меню пользователя';
$string['smartmenusmenumode'] = 'Режим меню';
$string['smartmenusmenumode_help'] = '<p>Выберите режим отображения пунктов меню.</p><ul><li>
Подменю: Элементы меню отображаются в виде подменю с заголовком меню в качестве родительского узла. Это вариант по умолчанию.</li><li>
Линейный: Элементы меню отображаются непосредственно в навигации, один за другим. Обратите внимание, что эта опция не поддерживается для меню типа карточки.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Дополнительное поведение меню';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Выберите, что должно произойти, если меню слишком большое, чтобы поместиться в заданном расположении.</p><ul><li>Ничего не менять: Никакого особого поведения не будет, лишние меню будут перемещены в меню «Дополнительно» автоматически.</li><li>Переместить в меню «Дополнительно»: Этот режим перемещает меню непосредственно в меню «Дополнительно», даже если еще есть свободное место.</li><li>Держать вне меню «Дополнительно»: Этот режим позволяет удерживать меню вне меню «Дополнительно» как можно дольше.</li></ul>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Переместить в меню «Дополнительно»';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Держать вне меню «Дополнительно»';
$string['smartmenusmenunothingtodisplay'] = 'Еще не создано ни одного умного меню. Пожалуйста, создайте свое первое умное меню, чтобы начать работу.';
$string['smartmenusmenupresentationheader'] = 'Представление меню';
$string['smartmenusmenushowdescription'] = 'Показать описание';
$string['smartmenusmenushowdescription_help'] = '<p>Выберите, должно ли в меню отображаться описание. Варианты: «Никогда», «Выше», «Ниже» и «Помощь».</p><ul><li>Никогда: Не показывать описание в меню и использовать его только для внутренних целей. Это вариант по умолчанию.</li><li>Выше: Показывать описание выше списка пунктов меню.</li><li>Ниже: Показывать описание ниже списка пунктов меню.</li><li>Помощь: Показать описание в виде значка помощи рядом со списком пунктов меню.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Выше';
$string['smartmenusmenushowdescriptionbelow'] = 'Ниже';
$string['smartmenusmenushowdescriptionhelp'] = 'Помощь';
$string['smartmenusmenushowdescriptionnever'] = 'Никогда';
$string['smartmenusmenustructureheader'] = 'Структура меню';
$string['smartmenusmenutitle'] = 'Заголовок';
$string['smartmenusmenutitle_help'] = 'Заголовок меню. Он будет использоваться в качестве метки родительского узла этого меню.';
$string['smartmenusmenutype'] = 'Тип представления';
$string['smartmenusmenutype_help'] = '<p>Выберите тип представления меню, выбирая между списком и карточкой.</p><ul><li>Список: Меню состоит из простых текстовых ссылок. Это вариант по умолчанию.</li><li>Карточки: Меню состоит из карточек.</li></ul>';
$string['smartmenusmenutypecard'] = 'Карточки';
$string['smartmenusmenutypelist'] = 'Список';
$string['smartmenusmodeinline'] = 'Линейный';
$string['smartmenusmodesubmenu'] = 'Подменю';
$string['smartmenusnorestrict'] = 'Без ограничений';
$string['smartmenusoperator'] = 'Оператор';
$string['smartmenusoperator_help'] = 'Выберите оператор для условия глобальной группы (Любой или Все)';
$string['smartmenusrestrictbycohortsheader'] = 'Ограничить видимость по глобальным группам';
$string['smartmenusrestrictbydateheader'] = 'Ограничить видимость по дате';
$string['smartmenusrestrictbylanguageheader'] = 'Ограничить видимость по языку';
$string['smartmenusrestrictbyrolesheader'] = 'Ограничить видимость по ролям';
$string['smartmenusrolecontext'] = 'Контекст';
$string['smartmenusrolecontext_help'] = 'Выберите контекст, для которого необходимо проверить роль пользователя (Любой контекст или только уровень системы).';
$string['smartmenussavechangesandconfigure'] = 'Сохранить и настроить элементы';
$string['smartmenussettings'] = 'Настройки умного меню';
$string['speciallinksmarkupheading'] = 'Разметка специальных ссылок';
$string['staticpagestab'] = 'Статические страницы';
$string['switchedroleto'] = 'В настоящий момент вы просматриваете этот курс с ролью: <strong>{$a->role}</strong>';
$string['tilebackgroundimagepositionsetting'] = 'Расположение фонового рисунка рекламной плитки {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Этот параметр управляет позиционированием фонового изображения внутри контейнера рекламной плитки {$a->no}. Первое значение - положение по горизонтали, второе - по вертикали.';
$string['tilebackgroundimagesetting'] = 'Фоновое изображение рекламной плитки {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Здесь вы можете загрузить файл изображения, который будет использоваться в качестве фонового изображения за содержимым рекламной плитки {$a->no}. Проверьте, что содержимое читаемо на фоновом изображении. Это необязательная настройка, рекламная плитка будет работать, даже если вы не загрузите никакого фонового изображения.';
$string['tilecolumnssetting'] = 'Количество колонок рекламных плиток в ряду';
$string['tilecolumnssetting_desc'] = 'Здесь вы определяете количество колонок в ряду в представленной сетке рекламных плиток. Обратите внимание, что это количество столбцов относится к настольному компьютеру / большим экранам. На маленьких и мобильных экранах колонки рекламных плиток автоматически сворачиваются.';
$string['tilecontentsetting'] = 'Содержимое рекламной плитки {$a->no}';
$string['tilecontentsetting_desc'] = 'Здесь вы вводите содержимое, которое должно отображаться в рекламной плитке {$a->no}. Содержимое отображается в центре плитки. Это необязательный параметр, рекламная плитка будет отображаться, даже если вы не зададите никакого содержимого.';
$string['tileenabledsetting'] = 'Включить рекламную плитку {$a->no}';
$string['tileenabledsetting_desc'] = 'Эта настройка включает рекламную плитку {$a->no}';
$string['tilefrontpagepositionsetting'] = 'Размещение рекламных плиток на главной странице';
$string['tilefrontpagepositionsetting_after'] = 'После содержимого главной страницы';
$string['tilefrontpagepositionsetting_before'] = 'До содержимого главной страницы';
$string['tilefrontpagepositionsetting_desc'] = 'Рекламные плитки отображаются только на главной странице. Этот параметр определяет, будут ли рекламные плитки отображаться перед содержимым главной страницы сайта или после него. Если вы хотите показывать на главной странице сайта только рекламные плитки и ничего больше, всё остальное содержимое главной страницы сайта можно удалить, изменив <a href="{$a->url}">настройки главной страницы</a>.';
$string['tileheading'] = 'Рекламная плитка {$a->no}';
$string['tileheightsetting'] = 'Высота рекламной плитки';
$string['tileheightsetting_desc'] = 'С помощью этой настройки вы контролируете высоту рекламных плиток. Настроенная высота - это минимальная высота каждой плитки. Если содержимое плитки больше этой настроенной высоты, весь ряд плиток будет автоматически увеличен по мере необходимости.';
$string['tilelinksetting'] = 'URL ссылки рекламной плитки {$a->no}';
$string['tilelinksetting_desc'] = 'Здесь вы можете задать внутренний или внешний URL-адрес, который будет добавлен в качестве кнопки ссылки в конце рекламной плитки {$a->no}. Это необязательный параметр, рекламная плитка будет работать, даже если вы не зададите URL ссылки.';
$string['tilelinktargetsetting'] = 'Цель ссылки рекламной плитки {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Здесь вы можете задать цель ссылки, которая устанавливается для кнопки ссылки, как только вы зададите URL ссылки в рекламной плитке {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Новая вкладка';
$string['tilelinktargetsetting_samewindow'] = 'То же окно';
$string['tilelinktitlefallback'] = 'Ссылка';
$string['tilelinktitlesetting'] = 'Заголовок ссылки рекламной плитки {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Здесь вы можете задать заголовок ссылки, который будет использоваться в качестве текста кнопки ссылки, если вы зададите URL ссылки в рекламной плитке {$a->no}. Обратите внимание, что если вы зададите URL ссылки, но не зададите заголовок ссылки, то кнопка ссылки будет обозначена как «Ссылка».';
$string['tileordersetting'] = 'Порядок сортировки рекламной плитки {$a->no}';
$string['tileordersetting_desc'] = 'С помощью этой настройки вы определяете порядок расположения рекламной плитки {$a->no}. По умолчанию рекламные плитки упорядочены сверху вниз и слева направо, как вы видите на этой странице настроек. Однако вы можете назначить другую позицию с помощью этой настройки. Если вы назначите одинаковое положение для двух или более рекламных плиток, они будут упорядочены в соответствии с порядком, указанным на этой странице настроек.';
$string['tilesgeneralheading'] = 'Общие настройка рекламных плиток';
$string['tilestab'] = 'Рекламные плитки';
$string['tiletitlesetting'] = 'Заголовок рекламной плитки {$a->no}';
$string['tiletitlesetting_desc'] = 'Здесь вы вводите заголовок, который должен отображаться в рекламной плитке {$a->no}. Это необязательный параметр, рекламная плитка будет показана, даже если вы не зададите заголовок.';
$string['upgradenotice_2022080922'] = 'Начиная с этого выпуска, Boost Union имеет настройки своего логотипа (и компактного логотипа) и больше не использует эти файлы из ядра Moodle';
$string['upgradenotice_2022080922_copied'] = 'Во время этого обновления значение параметра <strong>{$a}</strong> из настроек ядра Moodle было скопировано в параметр {$a} Boost Union. Пожалуйста, перепроверьте результат.';
$string['upgradenotice_2022080922_logo'] = 'логотип';
$string['upgradenotice_2022080922_logocompact'] = 'компактный логотип';
$string['upgradenotice_2022080922_notcopied'] = 'Параметр <strong>{$a}</strong> в Boost Union сейчас пуст. Если вы хотите использовать {$a} в Boost Union, просто задайте {$a} в настройках Boost Union позже.';
