<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'uk', version '4.2'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Додавання нової ролі';
$string['addrole'] = 'Додати нову роль';
$string['advancedoverride'] = 'Розширене перевизначення ролі';
$string['allow'] = 'Дозволити';
$string['allowassign'] = 'Дозволити призначення ролей';
$string['allowed'] = 'Дозволено';
$string['allowoverride'] = 'Дозволити перевизначення ролей';
$string['allowroletoassign'] = 'Дозволити користувачам з роллю {$a->fromrole} призначати роль {$a->targetrole}';
$string['allowroletooverride'] = 'Дозволити користувачам з роллю {$a->fromrole} робити поправки для ролі {$a->targetrole}';
$string['allowroletoswitch'] = 'Дозволити користувачам з роллю {$a->fromrole} перемикати на роль {$a->targetrole}';
$string['allowroletoview'] = 'Дозволити користувачам з роллю {$a->fromrole} переглядати роль {$a->targetrole}';
$string['allowswitch'] = 'Дозволити перемикання ролей';
$string['allowview'] = 'Дозволити перегляд ролі';
$string['allsiteusers'] = 'Всі користувачі сайту';
$string['analytics:listinsights'] = 'Перерахуйте інсайти';
$string['analytics:listowninsights'] = 'Перерахуйте власні ідеї';
$string['analytics:managemodels'] = 'Керуйте моделями';
$string['archetype'] = 'Оригінальна роль';
$string['archetype_help'] = 'Оригінальна роль визначає права, які ролі надані типово. Це також визначає будь-які нові права, які роль отримує з оновленням сайту.';
$string['archetypecoursecreator'] = 'ОРИГІНАЛ: Творець курсів';
$string['archetypeeditingteacher'] = 'ОРИГІНАЛ: Викладач';
$string['archetypefrontpage'] = 'АРХЕТИП: автентифікований користувач на дому сайту';
$string['archetypeguest'] = 'ОРИГІНАЛ: Гість';
$string['archetypemanager'] = 'ОРИГІНАЛ: Менеджер';
$string['archetypestudent'] = 'ОРИГІНАЛ: Студент';
$string['archetypeteacher'] = 'ОРИГІНАЛ: Асистент';
$string['archetypeuser'] = 'ОРИГІНАЛ: Користувач';
$string['assignanotherrole'] = 'Призначити іншу роль';
$string['assignedroles'] = 'Призначені ролі';
$string['assignerror'] = 'Помилка в процесі призначення користувача {$a->user} на роль {$a->role}';
$string['assignglobalroles'] = 'Призначити системні ролі';
$string['assignmentcontext'] = 'Контекст завдання';
$string['assignmentoptions'] = 'Параметри завдання';
$string['assignrole'] = 'Призначити роль';
$string['assignrolenameincontext'] = 'Призначення ролі \'{$a->role}\' в {$a->context}';
$string['assignroles'] = 'Призначити ролі';
$string['assignroles_help'] = 'Призначаючи права користувачу в контексті, ви надаєте йому права, що містяться в цій ролі, для поточного контексту і всіх нижчих в ієрархії контекстів. Наприклад, якщо користувачеві призначена роль студента в курсі, він також буде мати роль студента для всіх видів діяльностей і блоків у рамках курсу.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Призначити ролі у {$a}';
$string['assignrolesrelativetothisuser'] = 'Призначення ролей для цього користувача';
$string['backtoallroles'] = 'Повернутися до списку всіх ролей';
$string['backup:anonymise'] = 'Анонімність даних користувача в резервній копії';
$string['backup:backupactivity'] = 'Резервне копіювання діяльності';
$string['backup:backupcourse'] = 'Резервне копіювання курсів';
$string['backup:backupsection'] = 'Резервне копіювання секцій';
$string['backup:backuptargetimport'] = 'Резервне копіювання для імпорту';
$string['backup:configure'] = 'Налаштування опцій резервних копій';
$string['backup:downloadfile'] = 'Завантажувати файли із зони резервних копій';
$string['backup:userinfo'] = 'Включати дані користувачів в резервну копію';
$string['badges:awardbadge'] = 'Нагороджувати відзнакою користувачів';
$string['badges:configurecriteria'] = 'Встановлювати/редагувати критерії присудження відзнак';
$string['badges:configuredetails'] = 'Встановлювати/редагувати деталі відзнаки';
$string['badges:configuremessages'] = 'Налаштовувати повідомлення відзнаки';
$string['badges:createbadge'] = 'Створювати/дублювати відзнаки';
$string['badges:deletebadge'] = 'Видаляти відзнаки';
$string['badges:earnbadge'] = 'Отримувати відзнаки';
$string['badges:manageglobalsettings'] = 'Управляти глобальними налаштуваннями відзнак';
$string['badges:manageownbadges'] = 'Переглядати власні відзнаки та управляти ними';
$string['badges:revokebadge'] = 'Відкликати значок у користувача';
$string['badges:viewawarded'] = 'Переглядати користувачів нагороджених відзнакою без права нагородження нею';
$string['badges:viewbadges'] = 'Переглядати доступні відзнаки не отримуючи їх';
$string['badges:viewotherbadges'] = 'Переглядати загальнодоступні відзнаки у профілях користувачів';
$string['block:edit'] = 'Редагувати налаштування блоку';
$string['block:view'] = 'Переглядати блок';
$string['blog:create'] = 'Створювати нові записи блогу';
$string['blog:manageentries'] = 'Редагувати та управляти записами';
$string['blog:manageexternal'] = 'Редагувати та керувати зовнішніми блогами';
$string['blog:search'] = 'Шукати записи блога';
$string['blog:view'] = 'Переглядати записи блога';
$string['blog:viewdrafts'] = 'Переглядати чорнові записи блога';
$string['calendar:manageentries'] = 'Управляти будь-якими записами календаря';
$string['calendar:managegroupentries'] = 'Управляти записами календаря групи';
$string['calendar:manageownentries'] = 'Управляти власними записами календаря';
$string['capabilities'] = 'Можливості';
$string['capability'] = 'Можливість';
$string['category:create'] = 'Створювати категорії';
$string['category:delete'] = 'Видаляти категорії';
$string['category:manage'] = 'Управляти категоріями';
$string['category:update'] = 'Оновлювати категорії';
$string['category:viewcourselist'] = 'Переглянути категорію курсу та курси в ньому';
$string['category:viewhiddencategories'] = 'Бачити сховані категорії';
$string['category:visibility'] = 'Бачити сховані категорії';
$string['checkglobalpermissions'] = 'Перевірити системні права';
$string['checkpermissions'] = 'Перевірити права';
$string['checkpermissionsin'] = 'Перевірити права у {$a}';
$string['checksystempermissionsfor'] = 'Перевірити системні права для {$a->fullname}';
$string['checkuserspermissionshere'] = 'Перевірити права для {$a->fullname} в контексті {$a->contextlevel}';
$string['chooseroletoassign'] = 'Будь ласка, виберіть призначення ролі';
$string['cohort:assign'] = 'Додавати та видаляти членів гурту';
$string['cohort:configurecustomfields'] = 'Налаштуйте спеціальні поля когорти';
$string['cohort:manage'] = 'Створювати, видаляти та переміщувати гурти';
$string['cohort:view'] = 'Переглядати гурти';
$string['comment:delete'] = 'Видаляти коментарі';
$string['comment:post'] = 'Писати коментарі';
$string['comment:view'] = 'Переглянути коментарі';
$string['competency:competencygrade'] = 'Встановлювати рейтинг компетенцій';
$string['competency:competencymanage'] = 'Керувати структурою компетенцій';
$string['competency:competencyview'] = 'Переглядати структуру компетенцій';
$string['competency:coursecompetencyconfigure'] = 'Налаштовувати параметри компетенцій курсу';
$string['competency:coursecompetencygradable'] = 'Отримувати оцінки компетенцій';
$string['competency:coursecompetencymanage'] = 'Керувати компетенціями курсу';
$string['competency:coursecompetencyview'] = 'Переглядати компетентності курсу';
$string['competency:evidencedelete'] = 'Видаляти докази';
$string['competency:plancomment'] = 'Коментувати навчальний план';
$string['competency:plancommentown'] = 'Коментувати власний навчальний план';
$string['competency:planmanage'] = 'Керувати навчальними планами';
$string['competency:planmanagedraft'] = 'Керувати чернетками навчальних планів';
$string['competency:planmanageown'] = 'Керувати власними навчальними планами';
$string['competency:planmanageowndraft'] = 'Керувати власними чернетками навчальних планів';
$string['competency:planrequestreview'] = 'Запитувати перегляд навчального плану';
$string['competency:planrequestreviewown'] = 'Запитувати перегляд власного навчального плану';
$string['competency:planreview'] = 'Переглядати навчальний план';
$string['competency:planview'] = 'Бачити всі навчальні плани';
$string['competency:planviewdraft'] = 'Бачити чернетки навчальних планів';
$string['competency:planviewown'] = 'Бачити власні навчальні плани';
$string['competency:planviewowndraft'] = 'Бачити власні чернетки навчальних планів';
$string['competency:templatemanage'] = 'Керувати шаблонами навчальних планів';
$string['competency:templateview'] = 'Бачити шаблони навчальних планів';
$string['competency:usercompetencycomment'] = 'Коментувати компетенції користувача';
$string['competency:usercompetencycommentown'] = 'Коментувати власні компетенції користувача';
$string['competency:usercompetencyrequestreview'] = 'Запитувати перегляд компетенції користувача';
$string['competency:usercompetencyrequestreviewown'] = 'Запитувати перегляд власної компетенції користувача';
$string['competency:usercompetencyreview'] = 'Переглядати компетенцію користувача';
$string['competency:usercompetencyview'] = 'Бачити компетенцію користувача';
$string['competency:userevidencemanage'] = 'Керувати доказами попереднього навчання';
$string['competency:userevidencemanageown'] = 'Керувати власними доказами попереднього навчання';
$string['competency:userevidenceview'] = 'Бачити докази попереднього навчання користувача';
$string['confirmaddadmin'] = 'Ви дійсно хочете додати користувача <strong>{$a}</strong> як нового адміністратора сайту?';
$string['confirmaddadmins'] = 'Ви впевнені, що хочете додати наступних користувачів до списку адміністраторів сайту?';
$string['confirmdeladmin'] = 'Ви дійсно хочете видалити користувача <strong>{$a}</strong> зі списку адміністраторів сайту?';
$string['confirmremoveadmins'] = 'Ви впевнені, що бажаєте видалити наступних користувачів зі списку адміністраторів сайту?';
$string['confirmroleprevent'] = 'Ви дійсно хочете видалити <strong>"{$a->role}"</strong> зі списку дозволених ролей для можливості "{$a->cap}" в контексті "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Ви дійсно хочете видалити <strong>"{$a->role}"</strong> зі списку заборонених ролей для можливості "{$a->cap}" в контексті "{$a->context}"?';
$string['confirmunassign'] = 'Ви впевнені, що хочете зняти цю роль з цього користувача?';
$string['confirmunassignno'] = 'Скасувати';
$string['confirmunassigntitle'] = 'Підтвердіть зміну ролі';
$string['confirmunassignyes'] = 'Вилучити';
$string['contentbank:access'] = 'Доступ до банку вмісту';
$string['contentbank:deleteanycontent'] = 'Видаліть будь-який вміст із банку вмісту';
$string['contentbank:deleteowncontent'] = 'Видалити вміст із власного банку вмісту';
$string['contentbank:downloadcontent'] = 'Завантажте контент із банку вмісту';
$string['contentbank:manageanycontent'] = 'Керуйте будь-яким вмістом із банку вмісту';
$string['contentbank:manageowncontent'] = 'Керуйте вмістом із власного банку контенту';
$string['contentbank:upload'] = 'Завантажте новий контент до банку вмісту';
$string['contentbank:useeditor'] = 'Створюйте або редагуйте вміст за допомогою редактора типів вмісту';
$string['contentbank:viewunlistedcontent'] = 'Переглядайте вміст із банку вмісту';
$string['context'] = 'Контекст';
$string['contextrolenotallowed'] = 'Роль {$a} не дозволена в цьому контексті.';
$string['course:activityvisibility'] = 'Ховати/Показувати ресурси';
$string['course:bulkmessaging'] = 'Відсилати повідомлення до багатьох людей';
$string['course:changecategory'] = 'Змінювати категорію курсу';
$string['course:changefullname'] = 'Змінювати повну назву курсу';
$string['course:changeidnumber'] = 'Змінювати Код курсу';
$string['course:changelockedcustomfields'] = 'Змінити заблоковані спеціальні поля';
$string['course:changeshortname'] = 'Змінювати коротку назву курсу';
$string['course:changesummary'] = 'Змінювати опис курсу';
$string['course:configurecustomfields'] = 'Налаштуйте спеціальні поля';
$string['course:configuredownloadcontent'] = 'Налаштувати завантаження вмісту курсу';
$string['course:create'] = 'Створювати курси';
$string['course:creategroupconversations'] = 'Створюйте групові бесіди';
$string['course:delete'] = 'Видаляти курси';
$string['course:downloadcoursecontent'] = 'Завантажити зміст курсу';
$string['course:enrolconfig'] = 'Налаштовувати зарахування на курсах';
$string['course:enrolreview'] = 'Переглядати зарахування на курсах';
$string['course:ignoreavailabilityrestrictions'] = 'Ігноруйте обмеження доступності';
$string['course:ignorefilesizelimits'] = 'Використовувати файли більше, ніж будь-які обмеження розміру файлу';
$string['course:isincompletionreports'] = 'Показувати у звіті проходження';
$string['course:manageactivities'] = 'Управляти ресурсами';
$string['course:managefiles'] = 'Управляти файлами';
$string['course:managegrades'] = 'Управляти оцінюванням';
$string['course:managegroups'] = 'Управляти групами';
$string['course:managescales'] = 'Управляти шкалами';
$string['course:markcomplete'] = 'Відмічати процес проходження користувачами курсу';
$string['course:movesections'] = 'Переміщувати секції';
$string['course:overridecompletion'] = 'Замінити статус завершення діяльності';
$string['course:recommendactivity'] = 'Рекомендовані види діяльностей у селекторі діяльностей';
$string['course:renameroles'] = 'Перейменовувати ролі';
$string['course:request'] = 'Запитувати на нові курси';
$string['course:reset'] = 'Перевстановлювати курс';
$string['course:reviewotherusers'] = 'Переглядати інших користувачів';
$string['course:sectionvisibility'] = 'Контролювати видимість секцій';
$string['course:setcurrentsection'] = 'Встановлювати поточну секцію';
$string['course:setforcedlanguage'] = 'Примусовий курс або мову діяльності';
$string['course:tag'] = 'Змінити мітки курсу';
$string['course:togglecompletion'] = 'Позначте дії вручну як завершені';
$string['course:update'] = 'Оновлювати установки курсу';
$string['course:useremail'] = 'Дозволяти/Забороняти email адреси';
$string['course:view'] = 'Переглядати курси без учасників';
$string['course:viewcoursegrades'] = 'Переглядати оцінки курсу';
$string['course:viewhiddenactivities'] = 'Переглядати сховані ресурси';
$string['course:viewhiddencourses'] = 'Переглядати сховані курси';
$string['course:viewhiddengroups'] = 'Переглянути приховані групи';
$string['course:viewhiddensections'] = 'Переглядати сховані секції';
$string['course:viewhiddenuserfields'] = 'Переглядати сховані поля користувачів';
$string['course:viewparticipants'] = 'Переглядати список учасників';
$string['course:viewscales'] = 'Переглядати шкали';
$string['course:viewsuspendedusers'] = 'Переглядати заблокованих користувачів';
$string['course:visibility'] = 'Ховати/Показувати курси';
$string['createrolebycopying'] = 'Створити нову роль копіюванням {$a}';
$string['createthisrole'] = 'Створити цю роль';
$string['currentcontext'] = 'Поточний контекст';
$string['currentrole'] = 'Поточна роль';
$string['customroledescription'] = 'Опис';
$string['customroledescription_help'] = 'Опис стандартних ролей створюється автоматично, якщо не надано іншого опису.';
$string['customrolename'] = 'Повна назва';
$string['customrolename_help'] = 'Стандартні назви ролей застосовуються автоматично, якщо залишити поле назви порожнім. Вам потрібно вказати повні назви для всіх специфічних ролей.';
$string['defaultrole'] = 'Типова роль';
$string['defaultx'] = 'Типово: {$a}';
$string['defineroles'] = 'Визначити ролі';
$string['deletecourseoverrides'] = 'Видалити всі перевизначення ролей на курсі';
$string['deletelocalroles'] = 'Видалити всі локальні призначення ролей';
$string['deleterolesure'] = 'Ви впевнені, що хочете видалити роль "{$a->name} ({$a->shortname})"? Наразі ця роль призначена користувачам {$a->count}.';
$string['deletexrole'] = 'Видалити роль {$a}';
$string['duplicaterole'] = 'Здублювати роль';
$string['duplicaterolesure'] = 'Ви впевнені, що хочете дублювати роль "{$a->name} ({$a->shortname})"?';
$string['editingrolex'] = 'Редагування ролі \'{$a}\'';
$string['editrole'] = 'Редагувати роль';
$string['editxrole'] = 'Редагувати роль {$a}';
$string['errorbadrolename'] = 'Некоректна назва ролі';
$string['errorbadroleshortname'] = 'Некоректна скорочена назва ролі';
$string['errorexistsrolename'] = 'Роль з такою назвою вже існує';
$string['errorexistsroleshortname'] = 'Роль з такою назвою вже існує';
$string['errorroleshortnametoolong'] = 'Коротка назва не повинна перевищувати 100 символів';
$string['eventcapabilityassigned'] = 'Можливість призначена';
$string['eventcapabilityunassigned'] = 'Можливість не призначена';
$string['eventroleallowassignupdated'] = 'Дозволено призначення ролей';
$string['eventroleallowoverrideupdated'] = 'Дозволено перевизначення ролей';
$string['eventroleallowswitchupdated'] = 'Дозволено перемикання ролі';
$string['eventroleallowviewupdated'] = 'Дозволити перегляд ролі';
$string['eventroleassigned'] = 'Призначено роль';
$string['eventrolecapabilitiesupdated'] = 'Оновлено права ролі';
$string['eventrolecreated'] = 'Роль створено';
$string['eventroledeleted'] = 'Вилучено роль';
$string['eventroleunassigned'] = 'Знято роль';
$string['eventroleupdated'] = 'Роль оновлена';
$string['existingadmins'] = 'Поточні адміністратори сайту';
$string['existingusers'] = '{$a} існуючих користувачів';
$string['explanation'] = 'Пояснення';
$string['export'] = 'Експорт';
$string['extusers'] = 'Існуючі користувачі';
$string['extusersmatching'] = 'Існуючі користувачі відповідаючі \'{$a}\'';
$string['filter:manage'] = 'Управляти налаштуваннями локальних фільтрів';
$string['frontpageuser'] = 'Аутентифікований користувач на домашній сторінці сайту';
$string['frontpageuserdescription'] = 'Усі авторизовані користувачі на домашньому курсі сайту.';
$string['globalrole'] = 'Глобальна роль';
$string['globalroleswarning'] = 'Попередження: будь-які ролі, які ви призначите на цій сторінці, застосовуватимуться до користувачів усієї системи, включаючи домашню сторінку сайту та всі курси.';
$string['gotoassignroles'] = 'Перейти до призначення ролей для цього {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Перейти до Системи призначення ролей';
$string['grade:edit'] = 'Редагувати оцінки';
$string['grade:export'] = 'Експортувати оцінки';
$string['grade:hide'] = 'Ховати оцінки та елементи';
$string['grade:import'] = 'Імпортувати оцінки';
$string['grade:lock'] = 'Закривати оцінки та елементи';
$string['grade:manage'] = 'Управляти елементами оцінювання';
$string['grade:managegradingforms'] = 'Управляти розширеними методами оцінювання';
$string['grade:manageletters'] = 'Управляти буквеними оцінками';
$string['grade:manageoutcomes'] = 'Управляти результатами оцінювання';
$string['grade:managesharedforms'] = 'Управляти шаблонами форм розширеного оцінювання';
$string['grade:override'] = 'Відміняти оцінки';
$string['grade:sharegradingforms'] = 'Ділитися формами розширеного оцінювання як шаблонами';
$string['grade:unlock'] = 'Розблоковувати оцінки або елементи';
$string['grade:view'] = 'Переглядати власні оцінки';
$string['grade:viewall'] = 'Переглядати оцінки інших користувачів';
$string['grade:viewhidden'] = 'Переглядати сховані оцінки';
$string['h5p:deploy'] = 'Розгортайте вміст H5P';
$string['h5p:setdisplayoptions'] = 'Встановити параметри відображення H5P';
$string['h5p:updatelibraries'] = 'Керуйте типами вмісту H5P';
$string['highlightedcellsshowdefault'] = 'Виділені клітинки в таблиці нижче показують типові права для цього типу ролі, заснованій на \'Спадковості типу ролі\'.';
$string['highlightedcellsshowinherit'] = 'Виділені клітинки в таблиці нижче показують права (якщо такі є), що будуть передаватися у спадок. Крім можливостей, дозвіл на які ви дійсно хочете змінити, ви залишаєте безліч успадкованих.';
$string['inactiveformorethan'] = 'неактивний більш ніж {$a->timeperiod}';
$string['ingroup'] = 'в групі "{$a->group}"';
$string['inherit'] = 'Успадковано';
$string['invalidpresetfile'] = 'Неправильний файл визначення ролі';
$string['legacy:admin'] = 'ТИПОВА РОЛЬ: Адміністратор';
$string['legacy:coursecreator'] = 'ТИПОВА РОЛЬ: Автор курсу';
$string['legacy:editingteacher'] = 'ТИПОВА РОЛЬ: Викладач (редактор)';
$string['legacy:guest'] = 'ТИПОВА РОЛЬ: Гість';
$string['legacy:student'] = 'ТИПОВА РОЛЬ: Студент';
$string['legacy:teacher'] = 'ТИПОВА РОЛЬ: Асистент(не редактор)';
$string['legacy:user'] = 'ТИПОВА РОЛЬ: Автентифікований користувач';
$string['legacytype'] = 'Вид типової ролі';
$string['listallroles'] = 'Список усіх ролей';
$string['localroles'] = 'Призначені локальні ролі';
$string['mainadmin'] = 'Головний адміністратор';
$string['mainadminset'] = 'Призначити головного адміністратора';
$string['manageadmins'] = 'Управління адміністраторами сайту';
$string['manager'] = 'Менеджер';
$string['managerdescription'] = 'Менеджери можуть отримати доступ до курсів і змінити їх, але зазвичай не беруть у них участі.';
$string['manageroles'] = 'Керування ролями';
$string['maybeassignedin'] = 'Типи контексту, де ця роль може бути надана';
$string['moodlenet:shareactivity'] = 'Поділіться діяльністю з MoodleNet';
$string['morethan'] = 'Більше ніж {$a}';
$string['multipleroles'] = 'Множинні ролі';
$string['my:configsyspages'] = 'Налаштовувати систему шаблонів для Інформаційної панелі';
$string['my:manageblocks'] = 'Управляти блоками Інформаційної панелі';
$string['neededroles'] = 'Ролі з правом';
$string['nocapabilitiesincontext'] = 'Немає можливостей у цьому контексті';
$string['noneinthisx'] = 'Немає в цьому {$a}';
$string['noneinthisxmatching'] = 'Немає користувачів, які відповідають \'{$a->search}\' в цьому {$a->contexttype}';
$string['norole'] = 'Без ролі';
$string['noroleassignments'] = 'Цей користувач не має ніякої ролі будь-де на цьому сайті.';
$string['noroles'] = 'Немає ролей';
$string['notabletoassignroleshere'] = 'Призначення ролі в цьому контексті не дозволено адміністратором';
$string['notabletooverrideroleshere'] = 'Ви не можете перевизначати тут жодну роль';
$string['notes:manage'] = 'Керування нотатками';
$string['notes:view'] = 'Перегляд нотаток';
$string['notset'] = 'Не встановлено';
$string['novisibleroles'] = 'Жодних ролей';
$string['overrideanotherrole'] = 'Перевизначити іншу роль';
$string['overridecontext'] = 'Перевизначити контекст';
$string['overridepermissions'] = 'Перевизначити права';
$string['overridepermissions_help'] = 'Перевизначення прав дозволяє вибрати можливості, які будуть дозволені або попереджені в конкретному контексті.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Перевизначити права для ролі \'{$a->role}\' в {$a->context}';
$string['overridepermissionsin'] = 'Перевизначити права для {$a}';
$string['overrideroles'] = 'Перевизначити права';
$string['overriderolesin'] = 'Перевизначити права для {$a}';
$string['overrides'] = 'Перевизначення';
$string['overridesbycontext'] = 'Перевизначення (за контекстом)';
$string['payment:manageaccounts'] = 'Керуйте обліковими записами';
$string['payment:viewpayments'] = 'Переглянути платежі';
$string['permission'] = 'Права';
$string['permission_help'] = 'Права - це налаштування можливостей. Є 4 опції:

* Не встановлено
* Дозволити - надається така можливість
* Запобігти - можливість заборонена навіть, якщо є дозвіл у вищих контекстах
* Заборонити - можливість повністю заборонена і не може бути змінена в нижчих (конкретних) контекстах';
$string['permissions'] = 'Права';
$string['permissionsforuser'] = 'Права для користувача {$a}';
$string['permissionsincontext'] = 'Права у {$a}';
$string['portfolio:export'] = 'Експортувати до портфоліо';
$string['potentialusers'] = '{$a} потенційних користувачів';
$string['potusers'] = 'Потенційні користувачі';
$string['potusersmatching'] = 'Потенційні користувачі, що відповідають \'{$a}';
$string['prevent'] = 'Запобігти';
$string['privacy:metadata:preference:showadvanced'] = 'Обробіть кнопку перемикання розширеного режиму.';
$string['privacy:metadata:role_assignments'] = 'Рольові завдання';
$string['privacy:metadata:role_assignments:component'] = 'Плагін, який відповідає за призначення ролі, порожній, якщо призначено вручну.';
$string['privacy:metadata:role_assignments:itemid'] = 'Ідентифікатор екземпляра реєстрації/аутентифікації, відповідального за це призначення ролі';
$string['privacy:metadata:role_assignments:modifierid'] = 'Ідентифікатор користувача, який створив або змінив призначення ролі';
$string['privacy:metadata:role_assignments:roleid'] = 'Ідентифікатор ролі';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'У цій таблиці зберігаються призначені ролі в кожному контексті.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Дата, коли було створено або змінено призначення ролі.';
$string['privacy:metadata:role_assignments:userid'] = 'Ідентифікатор користувача';
$string['privacy:metadata:role_capabilities'] = 'Рольові можливості';
$string['privacy:metadata:role_capabilities:capability'] = 'Назва можливості.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Ідентифікатор користувача, який створив або змінив можливість';
$string['privacy:metadata:role_capabilities:permission'] = 'Дозвіл на можливість: успадкувати, дозволити, запобігти чи заборонити.';
$string['privacy:metadata:role_capabilities:roleid'] = 'Ідентифікатор ролі';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Можливості та можливості заміни для певної ролі в певному контексті';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Дата створення або зміни можливості.';
$string['privacy:metadata:role_cohortroles'] = 'Ролі для когорти';
$string['prohibit'] = 'Заборонити';
$string['prohibitedroles'] = 'Заборонено';
$string['question:add'] = 'Додавати нові питання';
$string['question:commentall'] = 'Коментуйте всі питання';
$string['question:commentmine'] = 'Прокоментуйте власні запитання';
$string['question:config'] = 'Налаштувати типи питань';
$string['question:editall'] = 'Редагувати всі питання';
$string['question:editmine'] = 'Редагувати свої власні питання';
$string['question:flag'] = 'Відмічати питання під час спроби';
$string['question:managecategory'] = 'Управляти категоріями питань';
$string['question:moveall'] = 'Переміщувати всі питання';
$string['question:movemine'] = 'Переміщувати свої власні питання';
$string['question:tagall'] = 'Позначте всі запитання';
$string['question:tagmine'] = 'Позначте власні запитання';
$string['question:useall'] = 'Використовувати всі питання';
$string['question:usemine'] = 'Використовувати свої власні питання';
$string['question:viewall'] = 'Переглядати всі питання';
$string['question:viewmine'] = 'Переглядати свої власні питання';
$string['rating:rate'] = 'Додавати оцінення елементів';
$string['rating:view'] = 'Переглядати вашу загальну оцінку';
$string['rating:viewall'] = 'Переглядати всі рядки оцінок вказаних осіб';
$string['rating:viewany'] = 'Переглядати загальні оцінки отримані будь-ким';
$string['reportbuilder:edit'] = 'Редагуйте власні власні звіти';
$string['reportbuilder:editall'] = 'Редагувати всі спеціальні звіти';
$string['reportbuilder:scheduleviewas'] = 'Заплануйте перегляд звітів іншим користувачам';
$string['reportbuilder:view'] = 'Перегляд спеціальних звітів';
$string['resetrole'] = 'Повернути до типового';
$string['resettingrole'] = 'Скидання ролі \'{$a}\'';
$string['restore:configure'] = 'Налаштовувати параметри відновлення';
$string['restore:createuser'] = 'Створювати користувачів при відновленні курсу';
$string['restore:restoreactivity'] = 'Відновлювати діяльності';
$string['restore:restorecourse'] = 'Відновлювати курси';
$string['restore:restoresection'] = 'Відновлювати секції';
$string['restore:restoretargetimport'] = 'Відновлювати з файлів позначених як для імпорту';
$string['restore:rolldates'] = 'Змінювати дату в налаштуваннях діяльностей при відновленні курса';
$string['restore:uploadfile'] = 'Завантажувати файли в область резервних копій';
$string['restore:userinfo'] = 'Відновлювати дані користувачів';
$string['restore:viewautomatedfilearea'] = 'Відновлення курсів із автоматизованих резервних копій';
$string['risks'] = 'Ризики';
$string['role:assign'] = 'Призначати на ролі користувачів';
$string['role:manage'] = 'Створювати та управляти ролями';
$string['role:override'] = 'Забирати права у інших';
$string['role:review'] = 'Переглядати права інших';
$string['role:safeoverride'] = 'Перевизначати права інших';
$string['role:switchroles'] = 'Перемкнути на інші ролі';
$string['roleallowheader'] = 'Дозволити роль:';
$string['roleallowinfo'] = 'Виберіть роль, яку потрібно додати до списку дозволених ролей у контексті "{$a->context}", можливість "{$a->cap}":';
$string['roleassignments'] = 'Призначення ролей';
$string['roledefinitions'] = 'Визначення ролей';
$string['rolefullname'] = 'Назва';
$string['roleincontext'] = '{$a->role} в {$a->context}';
$string['roleprohibitheader'] = 'Заборонити роль';
$string['roleprohibitinfo'] = 'Виберіть роль, яку потрібно додати до списку заборонених ролей у контексті "{$a->context}", можливість "{$a->cap}":';
$string['rolerepreset'] = 'Використати шаблон ролі';
$string['roleresetdefaults'] = 'Типове';
$string['roleresetrole'] = 'Використати роль або прототип';
$string['rolerisks'] = 'Ризики';
$string['roles'] = 'Ролі';
$string['roles_help'] = 'Роль - це набір визначених прав у межах всієї системи, на які ви можете призначати користувачів у визначених контекстах.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Виберіть роль';
$string['rolesforuser'] = 'Ролі користувача {$a}';
$string['roleshortname'] = 'Коротка назва';
$string['roleshortname_help'] = 'Коротка назва ролі — це ідентифікатор ролі низького рівня, у якому дозволені лише буквено-цифрові символи ASCII.';
$string['roletoassign'] = 'Роль для призначення';
$string['roletooverride'] = 'Роль для перевизначення';
$string['safeoverridenotice'] = 'Зверніть увагу: Зміна прав з високим ступенем ризику закрита, дозволяється змінювати тільки безпечні права.';
$string['search:query'] = 'Виконувати пошук по всьому сайту';
$string['selectanotheruser'] = 'Виберіть іншого користувача';
$string['selectauser'] = 'Виберіть користувача';
$string['selectrole'] = 'Виберіть роль';
$string['showallroles'] = 'Показати усі ролі';
$string['showthisuserspermissions'] = 'Показати права цього користувача';
$string['site:accessallgroups'] = 'Доступ до усіх груп';
$string['site:approvecourse'] = 'Схвалювати створення курсу';
$string['site:backup'] = 'Робити резервні копії курсів';
$string['site:config'] = 'Змінювати конфігурацію сайту';
$string['site:configview'] = 'Переглянути дерево адміністрування сайту (але не всі сторінки в ньому)';
$string['site:deleteanymessage'] = 'Видаляти будь-які повідомлення на сайті';
$string['site:deleteownmessage'] = 'Видаляти будь-які повідомлення на сайті';
$string['site:doanything'] = 'Дозволено робити все';
$string['site:doclinks'] = 'Показувати посилання на позасайтові документи';
$string['site:forcelanguage'] = 'Перевизначати мову курсу';
$string['site:import'] = 'Імпортувати інші курси в курс';
$string['site:maintenanceaccess'] = 'Доступ до сайту в режимі обслуговування';
$string['site:manageallmessaging'] = 'Додавання, видалення, блокування та розблокування контактів для будь-якого користувача';
$string['site:manageblocks'] = 'Управляти блоками на сторінці';
$string['site:managecontextlocks'] = 'Керуйте заморожуванням контекстів';
$string['site:messageanyuser'] = 'Обійти налаштування конфіденційності користувача для обміну повідомленнями будь-якому користувачу';
$string['site:mnetloginfromremote'] = 'Заходити із зовнішнього Moodle по Мудл Мережі';
$string['site:mnetlogintoremote'] = 'Переходити до зовнішнього Moodle по Мудл Мережі';
$string['site:readallmessages'] = 'Читати усі повідомлення на сайті';
$string['site:restore'] = 'Відновлювати курси';
$string['site:senderrormessage'] = 'Надішліть повідомлення користувачу служби підтримки зі сторінки помилки';
$string['site:sendmessage'] = 'Надсилати повідомлення до будь-якого користувача';
$string['site:trustcontent'] = 'Довіряти відправляти вміст';
$string['site:uploadusers'] = 'Завантажувати нових користувачів з файлу';
$string['site:viewanonymousevents'] = 'Перегляд анонімних подій у звітах';
$string['site:viewfullnames'] = 'Завжди бачити повні імена користувачів';
$string['site:viewparticipants'] = 'Переглядати учасників';
$string['site:viewreports'] = 'Переглядати звіти';
$string['site:viewuseridentity'] = 'Бачити всі ідентифікатори користувачів у списку';
$string['siteadministrators'] = 'Адміністратори сайту';
$string['tag:edit'] = 'Редагувати існуючі мітки';
$string['tag:editblocks'] = 'Редагувати блоки на сторінках міток';
$string['tag:flag'] = 'Відмічати мітки як порушення';
$string['tag:manage'] = 'Керування усіма мітками';
$string['thisnewrole'] = 'Ця нова роль';
$string['thisusersroles'] = 'Ролі цього користувача';
$string['unassignarole'] = 'Відрахувати з ролі {$a}';
$string['unassignconfirm'] = 'Ви дійсно хочете відрахувати з ролі "{$a->role}"  користувача "{$a->user}"?';
$string['unassignerror'] = 'Виникла помилка в процесі відрахування з ролі "{$a->role}"  користувача "{$a->user}"?';
$string['user:changeownpassword'] = 'Змінювати власний пароль';
$string['user:create'] = 'Створювати користувачів';
$string['user:delete'] = 'Видаляти користувачів';
$string['user:editmessageprofile'] = 'Редагувати профіль повідомлень користувача';
$string['user:editownmessageprofile'] = 'Редагувати власний профіль повідомлень';
$string['user:editownprofile'] = 'Редагувати дані власного облікового запису';
$string['user:editprofile'] = 'Редагувати облікові записи користувачів';
$string['user:ignoreuserquota'] = 'Ігнорувати квоти на приватні файли';
$string['user:loginas'] = 'Заходити під іншим ім\'ям';
$string['user:manageblocks'] = 'Управляти блоками на сторінці профайлу інших користувачів';
$string['user:manageownblocks'] = 'Управляти блоками на власній сторінці профайлу';
$string['user:manageownfiles'] = 'Управляти файлами у власній файловій зоні';
$string['user:managesyspages'] = 'Налаштовувати типову сторінку для профайлів публічних користувачів';
$string['user:readuserblogs'] = 'Бачити блоги усіх користувачів';
$string['user:readuserposts'] = 'Бачити всі повідомлення користувачів';
$string['user:update'] = 'Оновлювати облікові записи користувачів';
$string['user:viewalldetails'] = 'Переглядати повну інформацію про користувачів';
$string['user:viewdetails'] = 'Переглядати облікові записи користувачів';
$string['user:viewhiddendetails'] = 'Переглядати сховані деталі про користувачів';
$string['user:viewlastip'] = 'Бачити останню ІР-адресу користувача';
$string['user:viewuseractivitiesreport'] = 'Бачити звіти діяльності користувачів';
$string['user:viewusergrades'] = 'Переглядати оцінки користувачів';
$string['usersfrom'] = 'Користувачі з {$a}';
$string['usersfrommatching'] = 'Користувачі з {$a->contextname}, які відповідають \'{$a->search}\'';
$string['usersinthisx'] = 'Користувачі в цьому {$a}';
$string['usersinthisxmatching'] = 'Користувачі в цьому {$a->contexttype}, які відповідають \'{$a->search}\'';
$string['userswithrole'] = 'Всі користувачі з роллю';
$string['userswiththisrole'] = 'Користувачі з роллю';
$string['useshowadvancedtochange'] = 'Використайте "Показати додаткове" для зміни';
$string['viewingdefinitionofrolex'] = 'Перегляд визначення ролі \'{$a}\'';
$string['viewrole'] = 'Переглядати деталі ролі';
$string['webservice:createmobiletoken'] = 'Створювати маркери web-служби для мобільного доступу';
$string['webservice:createtoken'] = 'Створювати маркери web-служби';
$string['webservice:managealltokens'] = 'Керуйте маркерами веб-служб усіх користувачів';
$string['whydoesuserhavecap'] = 'Чому {$a->fullname} має можливість {$a->capability} в контексті {$a->context}?';
$string['whydoesusernothavecap'] = 'Чому {$a->fullname} не має можливості {$a->capability} в контексті {$a->context}?';
$string['xroleassignments'] = 'Призначені ролі для {$a}';
$string['xuserswiththerole'] = 'Користувачі з роллю "{$a->role}"';
