<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'sk', version '4.2'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcia';
$string['activityoverview'] = 'Máte jeden alebo viac povinných dotazníkov';
$string['additionalinfo'] = 'Ďalšie informácie';
$string['additionalinfo_help'] = 'Text, ktorý sa zobrazí v hornej časti prvej stránky tohto dotazníka  (napríklad pre pokyny, informácie o pozadí atď.).';
$string['addnewquestion'] = 'Pridanie otázky {$a}';
$string['addnewsection'] = 'Pridajte novú sekciu';
$string['addquestion'] = 'Pridajte otázku...';
$string['addquestions'] = 'Pridajte otázky';
$string['addquestiontosection'] = 'Pridajte otázku do sekcie';
$string['addselqtype'] = 'Pridajte vybraný typ otázky';
$string['alignment'] = 'Orientácia tlačidiel';
$string['alignment_help'] = 'Vyberte orientáciu tlačidiel: vertikálne (predvolené) alebo horizontálne.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Všetko';
$string['allnameddegrees'] = 'Pomenované stupne';
$string['allnameddegrees_help'] = 'Zadajte text, ktorý sa má zobrazovať pre hodnoty hodnotenia  namiesto čísla. Nechajte  prázdne, ako nepoužijete.';
$string['alreadyfilled'] = 'Tento dotazník {$a} ste už vyplnili. Ďakujeme.';
$string['andaveragevalues'] = 'a priemerné hodnoty';
$string['anonymous'] = 'Anonymný';
$string['answer'] = 'Odpoveď';
$string['answergiven'] = 'Táto odpoveď je daná';
$string['answernotgiven'] = 'Táto odpoveď nie je daná';
$string['answerquestions'] = 'Zodpovedajte otázky...';
$string['answers'] = 'Odpovede';
$string['attempted'] = 'Tento dotazník bol odoslaný.';
$string['attemptstillinprogress'] = 'Spracováva sa. Uložené na:';
$string['autonumbering'] = 'Automatické číslovanie';
$string['autonumbering_help'] = 'Automatické číslovanie otázok a stránok. Možno budete chcieť deaktivovať automatické číslovanie pre dotazníky s podmieneným vetvením.';
$string['autonumberno'] = 'Nečíslujte otázky ani stránky';
$string['autonumberpages'] = 'Automatické číslovanie strán';
$string['autonumberpagesandquestions'] = 'Automatické číslovanie strán a otázok';
$string['autonumberquestions'] = 'Automatické číslovanie otázok';
$string['average'] = 'Priemerný';
$string['averageposition'] = 'Priemerné umiestnenie';
$string['averagerank'] = 'Priemerný rozsah';
$string['bodytext'] = 'Textové pole';
$string['boxesnbexact'] = 'presne {$a} pole/polia.';
$string['boxesnbmax'] = 'maximálne z {$a} poľa/polí.';
$string['boxesnbmin'] = 'minimálne z {$a} poľa/polí.';
$string['boxesnbreq'] = 'Túto otázku si musíte zaškrtnúť';
$string['by'] = 'od';
$string['cannotviewpublicresponses'] = 'Vo verejnom dotazníku si nemôžete prezerať odpovede.';
$string['chart:bipolar'] = 'Bipolárne stĺpce';
$string['chart:hbar'] = 'Horizontálne stĺpce';
$string['chart:radar'] = 'Lúčový graf';
$string['chart:rose'] = 'Ružicový graf';
$string['chart:type'] = 'Typ grafu';
$string['chart:type_help'] = 'Vyberte si typ grafu, ktorý chcete použiť v tejto spätnej väzbe';
$string['chart:vprogress'] = 'Vertikálny ukazovateľ priebehu';
$string['checkallradiobuttons'] = 'Skontrolujte si prosím všetky  <strong>{$a}</strong>  prepínače !';
$string['checkboxes'] = 'Zaškrtávacie políčka';
$string['checkboxes_help'] = 'Vpíšte pod sebe možnosti pre účastníka, ktorý bude následne vyberať jednu alebo viac z týchto ponúkaných možností.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Oddelenie novej stránky pridané na pozíciu/pozície:';
$string['checkbreaksok'] = 'Všetky požadované Nové stránky už existujú !';
$string['checkbreaksremoved'] = 'Odstránené  {$a} zlomy strán.';
$string['checknotstarted'] = 'Vybrané nezačali';
$string['checkstarted'] = 'Vybrané začali';
$string['clicktoswitch'] = '(kliknutím prepnete)';
$string['closed'] = 'Dotazník bol uzavretý {$a}. Vďaka.';
$string['closedate'] = 'Použiť dátum na ukončenie';
$string['closeson'] = 'Dotazník sa uzavrie {$a}';
$string['completionsubmit'] = 'Pre dokončenie študent musí kliknúť na odoslanie vyplneného dotazníka';
$string['condition'] = 'Podmienka';
$string['confalts'] = '- alebo - <br />Potvrdzovacia stránka';
$string['configmaxsections'] = 'Maximálny počet sekcií pre spätnú väzbu';
$string['configusergraph'] = 'Zobrazenie grafov spätnej väzby na "Test osobnosti"';
$string['configusergraphlong'] = 'Použite <a href="http://www.rgraph.net/">Rgraph</a> knižnicu pre zobrazenie grafov spätnej väzby na "Test osobnosti".';
$string['confirmdelallresp'] = 'Naozaj chcete odstrániť VŠETKY odpovede v tomto dotazníku?';
$string['confirmdelchildren'] = 'Ak túto otázku odstránite,  od nej odvodená (é) otázka (-y) sa tiež vymaže(ú):';
$string['confirmdeletesection'] = 'Naozaj chcete odstrániť sekciu spätnej väzby „{$a}“ ?';
$string['confirmdelgroupresp'] = 'Naozaj chcete odstrániť VŠETKY odpovede {$a}?';
$string['confirmdelquestion'] = 'Naozaj chcete vymazať otázku na pozícií {$a}?';
$string['confirmdelquestionresps'] = 'To tiež odstráni odpoveď(e)  {$a}  danej otázky.';
$string['confirmdelresp'] = 'Naozaj chcete odstrániť odpoveď &nbsp;{$a}&nbsp; ?';
$string['confirmremovequestion'] = 'Naozaj chcete odstrániť otázku „{$a-> qname}“  z časti  „{$a->sname}“  ?';
$string['confpage'] = 'Text nadpisu';
$string['confpage_help'] = 'Nadpis (tučným písmom) a text tela pre stránku "Potvrdenie" zobrazené po vyplnení dotazníka používateľom. (Adresa URL, ak je k dispozícii, má prednosť pred textom s potvrdením.) Ak toto pole ponecháte prázdne, po vyplnení dotazníka sa zobrazí predvolená správa (Ďakujeme za vyplnenie tohto dotazníka).';
$string['confpagedesc'] = 'Nadpis (tučným písmom) a text tela pre &quot;Potvrdenie&quot; stránku, ktorá sa zobrazí po vyplnení tohto dotazníka používateľom. (Adresa URL, ak existuje, má prednosť pred textom potvrdenia.)';
$string['contentoptions'] = 'Obsahové možnosti';
$string['couldnotcreatenewsurvey'] = 'Nepodarilo sa vytvoriť nový prieskum!';
$string['couldnotdelresp'] = 'Nepodarilo sa odstrániť odpoveď';
$string['createcontent'] = 'Definujte nový obsah';
$string['createcontent_help'] = 'Vyberte jednu z možností prepínača. Predvolené je \'Vytvoriť nový\'.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Vytvorte nový';
$string['crontask'] = 'Úloha čistenia dotazníka';
$string['date'] = 'Dátum';
$string['date_help'] = 'Tento typ otázky použite, ak očakávate, že odpoveď bude správne naformátovaná.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Použite formát deň / mesiac / rok, napr. 14. marca 1945: &nbsp; <Strong>14/3/1945</ strong>';
$string['deleteallresponses'] = 'Vymazanie VŠETKÝCH odpovedí';
$string['deletecurrentquestion'] = 'Odstrániť otázku {$a}';
$string['deletedallgroupresp'] = 'Odstránené VŠETKY odpovede v skupine {$a}';
$string['deletedallresp'] = 'Odpovede na dotazník boli vymazané';
$string['deletedisabled'] = 'Túto položku nemožno odstrániť';
$string['deletedresp'] = 'Odstránená odpoveď';
$string['deleteresp'] = 'Odstrániť túto odpoveď';
$string['deletesection'] = 'Odstrániť túto časť';
$string['deletingresp'] = 'Vymazanie odpovede';
$string['dependencies'] = 'Závislosti';
$string['dependquestion'] = 'Otázka rodiča';
$string['dependquestion_help'] = 'Môžete si vybrať rodičovskú otázku a možnosť výberu pre túto otázku. Odvodená otázka sa zobrazí iba študentovi, ak bola predtým vybraná príslušná rodičovská otázka a výber rodiča.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Nereagoval na otázku';
$string['directwarnings'] = 'Priame závislosti na tejto otázke budú odstránené. Toto ovplyvní:';
$string['displaymethod'] = 'Spôsob zobrazenia nie je definovaný pre otázku.';
$string['download'] = 'Stiahnuť';
$string['downloadtextformat'] = 'Stiahnuť vo formáte CSV';
$string['downloadtextformat_help'] = 'Táto funkcia umožňuje uložiť všetky odpovede dotazníka do textového súboru (CSV). Tento súbor možno potom importovať do tabuľky (napr. MS Excel alebo Open Office Calc) alebo štatistického balíka na ďalšie spracovanie údajov.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['dropdown'] = 'Rozbaľovacie políčko';
$string['dropdown_help'] = 'Neexistuje žiadna reálna výhoda použitia Rozbaľovacieho políčka namiesto  zaškrtávacích políčok, okrem snáď pre dlhé zoznamy možností a pre šetrenie miesta na obrazovke.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Editovanie';
$string['editingfeedback'] = 'Úprava nastavení spätnej väzby';
$string['editingquestionnaire'] = 'Úprava nastavení dotazníka';
$string['editquestion'] = 'Úprava otázky {$a}';
$string['email'] = 'Ímejl';
$string['errnewname'] = 'Ľutujeme, meno sa už používa. Vyberte nový názov.';
$string['erroropening'] = 'Chyba pri otváraní dotazníka.';
$string['errortable'] = 'Chyba systémovej tabuľky.';
$string['essaybox'] = 'Textové políčko';
$string['essaybox_help'] = 'Táto otázka zobrazí textové pole s x textovými stĺpcami (textová šírka) a x textovými riadkami (počet riadkov textu).

Ak ponecháte obe hodnoty x a y na ich predvolenej hodnote 0 (alebo ak ju nastavíte na hodnotu 0), zobrazí sa editor HTML moodle  so štandardnou výškou a šírkou (ak je k dispozícii v kontexte kurzu / používateľa a užívateľskom profile).';
$string['event_all_responses_deleted'] = 'Všetky odpovede boli odstránené';
$string['event_all_responses_saved_as_text'] = 'Všetky odpovede boli uložené ako text';
$string['event_all_responses_viewed'] = 'Zobrazí sa prehľad všetkých odpovedí';
$string['event_individual_responses_viewed'] = 'Prehľad jednotlivých odpovedí';
$string['event_non_respondents_viewed'] = 'Zobrazení nerespondenti';
$string['event_previewed'] = 'Prehliadka dotazníka';
$string['event_question_created'] = 'Vytvorená otázka';
$string['event_question_deleted'] = 'Otázka bola odstránená';
$string['event_response_deleted'] = 'Individuálna odpoveď bola odstránená';
$string['event_resumed'] = 'Pokus sa obnovil';
$string['event_saved'] = 'Odpovede sa uložili';
$string['event_submitted'] = 'Odpovede boli odoslané';
$string['feedback'] = 'Spätná väzba';
$string['feedback_help'] = 'Pomocník pre spätnú väzbu';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Pridať/nepridať ďalšie polia spätnej väzby';
$string['feedbackbysection'] = 'Sekcia Spätná väzba';
$string['feedbackdefaultlabel'] = '[Nová sekcia]';
$string['feedbackeditingglobal'] = 'Úprava globálnej spätnej väzby dotazníka';
$string['feedbackeditingmessages'] = 'Úprava správ o spätnej väzbe dotazníka';
$string['feedbackeditingsections'] = 'Úprava sekcií spätnej väzby dotazníka';
$string['feedbackeditmessages'] = 'Uloženie nastavenia sekcií a úprava správ spätnej väzby';
$string['feedbackeditsections'] = 'Uložte nastavenia a upravte sekcie spätnej väzby';
$string['feedbackerrorboundaryformat'] = 'Hranice pre skóre spätnej väzby musia byť buď percento alebo číslo. Hodnota, ktorú ste zadali na hranici {$a}, sa nerozpozná.';
$string['feedbackerrorboundaryoutofrange'] = 'Hranice pre skóre spätnej väzby musia byť medzi 0% a 100%. Hodnota, ktorú ste zadali na hranici {$a}, je mimo rozsahu.';
$string['feedbackerrorjunkinboundary'] = 'Musíte vyplniť ohraničujúce okienka spätnej väzby bez zanechania akýchkoľvek medzier.';
$string['feedbackerrorjunkinfeedback'] = 'Musíte vyplniť rámčeky pre spätnú väzbu bez zanechania akýchkoľvek medzier.';
$string['feedbackerrororder'] = 'Hranice pre skóre spätnej väzby musia byť v správnom poradí, najskôr tie prvé. Hodnota zadaná na hranici {$a} je mimo poradia.';
$string['feedbackglobal'] = 'Globálna spätná väzba';
$string['feedbackglobalheading'] = 'Nadpis globálnej spätnej väzby';
$string['feedbackglobalmessages'] = 'Správy globálnej spätnej väzby';
$string['feedbackhdr'] = 'Ohlasy';
$string['feedbackheading'] = 'Nadpis spätnej väzby';
$string['feedbackheading_help'] = 'V poli spätnej väzby môžete použiť 2 premenné: $scorepercent a $oppositescorepercent.';
$string['feedbackmessages'] = 'Správy sekcie {$a}';
$string['feedbacknextsection'] = 'Nasledujúca sekcia {$a}';
$string['feedbacknone'] = 'Žiadne správy spätnej väzby';
$string['feedbacknotes'] = 'Poznámky k spätnej väzbe';
$string['feedbacknotes_help'] = 'Tu zadaný text bude zobrazený respondentom na konci správy o spätnej väzbe';
$string['feedbackoptions'] = 'Možnosti spätnej väzby';
$string['feedbackoptions_help'] = 'Možnosti spätnej väzby sú k dispozícii, ak dotazník obsahuje nasledujúce typy otázok a nastavenia otázok:
Prepínače; Rozbaľovacie pole; Áno nie; alebo Hodnotenie (normálna alebo Osgoodova stupnica). Tieto otázky musia byť nastavené ako povinné, ich pole Názov otázky nesmie byť prázdne a možnosti Možné odpovede musia obsahovať hodnotu.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Táto otázka je súčasťou sekcie spätnej väzby [{$a}]';
$string['feedbackremovesection'] = 'Odstránenie tejto otázky úplne odstráni sekciu spätnej väzby [{$a}]';
$string['feedbackreport'] = 'Prehľad spätnej väzby';
$string['feedbackscore'] = 'Skóre spätnej väzby';
$string['feedbackscoreboundary'] = 'Hranica pre skóre spätnej väzby';
$string['feedbackscores'] = 'Zobraziť skóre';
$string['feedbackscores_help'] = 'Zobraziť tabuľku pre skóre spätnej väzby';
$string['feedbacksection'] = 'Sekcia';
$string['feedbacksectionheading'] = 'Nadpis sekcie {$a}';
$string['feedbacksectionheadingmissing'] = 'Musíte zadať nadpis tejto časti Spätnej väzby !';
$string['feedbacksectionheadingtext'] = 'Nadpis';
$string['feedbacksectionlabel'] = 'Štítok';
$string['feedbacksectionlabel_help'] = 'Tento štítok sa použije v tabuľkách / diagramoch. Udržujte ho čo najkratší !';
$string['feedbacksectionquestions'] = '{$a}  sekčné otázky';
$string['feedbacksections'] = 'Sekcie spätnej väzby';
$string['feedbacksectionsselect'] = 'Sekcie';
$string['feedbacksectionsselect_help'] = 'Uložte svoje otázky do týchto sekcií';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Nastavenia spätnej väzby boli uložené';
$string['feedbacktype'] = 'Typ spätnej väzby';
$string['field'] = 'Otázka  {$a}';
$string['fieldlength'] = 'Dĺžka vstupného poľa';
$string['fieldlength_help'] = 'Pre typ otázky ** Textové pole ** zadajte ** Dĺžku vstupného poľa ** a ** Maximálnu dĺžku textu ** textu, ktorý má zadať respondent. Predvolené hodnoty sú 20 znakov pre šírku vstupného poľa a 25 znakov pre zadanú maximálnu dĺžku textu.';
$string['finished'] = 'Odpovedali ste na všetky otázky v tomto dotazníku!';
$string['firstrespondent'] = 'Prvý respondent';
$string['formateditor'] = 'Editor HTML kódu';
$string['formatplain'] = 'Obyčajný text';
$string['grade'] = 'Známka za odoslanie';
$string['gradesdeleted'] = 'Známky dotazníka boli vymazané';
$string['headingtext'] = 'Text nadpisu';
$string['horizontal'] = 'horizontálne';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Zahrnúť výberové kódy';
$string['includechoicetext'] = 'Zahrnúť výberový text';
$string['includeincomplete'] = 'Zahrňte neúplné odpovede';
$string['incorrectcourseid'] = 'Identifikátor kurzu je nesprávny';
$string['incorrectmodule'] = 'Identifikátor  modulu kurzu bol nesprávny';
$string['incorrectquestionnaire'] = 'Dotazník je nesprávny';
$string['indirectwarnings'] = 'Tento zoznam zobrazuje nepriame závislé otázky a zostávajúce závislosti pre priame závislé otázky:';
$string['invalidresponse'] = 'Zadaná neplatná odpoveď.';
$string['invalidresponserecord'] = 'Zadaný bol neplatný záznam odpovede.';
$string['invalidsectionid'] = 'Zadaná je neplatná sekcia spätnej väzby.';
$string['invalidsurveyid'] = 'Neplatný identifikátor dotazníka.';
$string['kindofratescale'] = 'Typ stupnice známkovania';
$string['kindofratescale_help'] = 'Kliknite pravým tlačidlom myši na odkaz "Viac pomoci" nižšie.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Posledný respondent';
$string['length'] = 'Dĺžka';
$string['managequestions'] = 'Spravovať otázky';
$string['managequestions_help'] = 'V časti "Spravovať otázky" na stránke "Upraviť otázky" môžete v dotazníku vykonať zmeny na otázkach dotazníka';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Povinné - Všetky tieto závislosti musia byť splnené.';
$string['maxdigitsallowed'] = 'Max. počet číslic je povolený';
$string['maxdigitsallowed_help'] = 'Použite ** Max. počet číslic ** pre nastavenie limitu počtu znakov zadaných pre číselnú otázku. Všimnite si, že desatinná čiarka sa počíta aj ako jeden znak!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Max. nútených odoziev';
$string['maxforcedresponses_help'] = 'Pomocou týchto parametrov prinútite respondenta, aby začiarkol políčka minimálne ** Min. ** a maximálne ** Max. **. Na určenie presného počtu začiarkavacích políčok, ktoré sa majú zaškrtnúť, nastavte ** Min. ** a ** Max. ** na rovnakú hodnotu. Ak je požadovaná iba minimálna alebo maximálna hodnota, nechajte ostatné jeho predvolená hodnota ** 0 **. Ak nastavíte ** Min. ** alebo ** Max. ** na iné hodnoty ako ich predvolená hodnota ** 0 **, zobrazí sa varovná správa, ak respondent nespĺňa vaše požiadavky. Je zrejmé, že by ste mali respondentovi objasniť akékoľvek požiadavky, a to buď vo všeobecných pokynoch váš dotazník alebo v texte relevantných otázok.';
$string['maxtextlength'] = 'Max. dĺžka textu';
$string['maxtextlength_help'] = 'Pre typ otázky Textové pole zadajte dĺžku vstupného poľa a maximálnu dĺžku textu, ktorú má respondent zadať. Predvolené hodnoty sú 20 znakov pre šírku vstupného poľa a 25 znakov pre zadanú maximálnu dĺžku textu.';
$string['messageprovider:message'] = 'Pripomienka k dotazníku';
$string['messageprovider:notification'] = 'Predloženie dotazníka';
$string['minforcedresponses'] = 'Min. počet vynútených odpovedí';
$string['minforcedresponses_help'] = 'Pomocou týchto parametrov prinútite respondenta, aby začiarklo políčka minimálne ** Min. ** a maximálne ** Max. **. Na určenie presného počtu začiarkavacích políčok, ktoré sa majú zaškrtnúť, nastavte ** Min. ** a ** Max. ** na rovnakú hodnotu. Ak je požadovaná iba minimálna alebo maximálna hodnota, nechajte pre ostatné jeho predvolenú hodnota ** 0 **. Ak nastavíte ** Min. ** alebo ** Max. ** na iné hodnoty ako ich predvolená hodnota ** 0 **, zobrazí sa varovná správa, ak respondent nespĺňa vaše požiadavky. Je zrejmé, že by ste mali respondentovi objasniť akékoľvek požiadavky, a to buď vo všeobecných pokynoch váš dotazník alebo v texte relevantných otázok.';
$string['misconfigured'] = 'Kurz je nesprávne nakonfigurovaný';
$string['missingname'] = 'Otázka {$a} sa nedá v tejto časti so spätnou väzbou použiť, pretože nemá meno.';
$string['missingnameandrequired'] = 'Otázka {$a} sa nedá v tejto časti so spätnou väzbou použiť, pretože nemá meno a nevyžaduje sa.';
$string['missingquestion'] = 'Prosím odpovedzte na požadovanú otázku';
$string['missingquestions'] = 'Prosím odpovedzte na požadované otázky:';
$string['missingrequired'] = 'Otázka {$a} sa nedá použiť v tejto sekcii spätnej väzby, pretože sa nevyžaduje.';
$string['modulename'] = 'Dotazník';
$string['modulename_help'] = 'Modul dotazníka umožňuje zostaviť prieskumy s použitím rôznych typov otázok na účely zhromažďovania údajov od používateľov.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Dotazníky';
$string['movedisabled'] = 'Túto položku nie je možné presunúť';
$string['myresponses'] = 'Všetky vaše odpovede';
$string['myresponsetitle'] = 'Vaša {$a} odpoveď (odpovede)';
$string['myresults'] = 'Vaše výsledky';
$string['name'] = 'Názov';
$string['navigate'] = 'Povoliť vetvené otázky';
$string['navigate_help'] = 'Povoľte pre otázky typu "Áno / Nie" a "Rádiové tlačidlá", aby boli od nich odvodené otázky závislé od odpovedí na rodičovské otázky v dotazníku.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Prejdite do sekcie spätnej väzby';
$string['next'] = 'Ďalší';
$string['nextpage'] = 'Ďalšia strana';
$string['nlines'] = '{$a} riadkov';
$string['noanswer'] = 'Žiadna odpoveď';
$string['noattempts'] = 'V tomto dotazníku sa neuskutočnili žiadne pokusy';
$string['nodata'] = 'Žiadne údaje nezverejnené.';
$string['noduplicates'] = 'Žiadne duplicitné možnosti';
$string['noduplicateschoiceserror'] = 'Pre možnosť „Žiadne duplicitné možnosti“ musíte zadať najmenej 2 možné odpovede!';
$string['non_respondents'] = 'Používatelia, ktorí ešte neodpovedali na tento dotazník';
$string['noneinuse'] = 'Tento dotazník neobsahuje žiadne otázky.';
$string['nopublicsurveys'] = 'Žiadne verejné dotazníky.';
$string['noresponsedata'] = 'Pre túto otázku nie sú žiadne odpovede.';
$string['noresponses'] = 'Žiadne odpovede';
$string['normal'] = 'normálne';
$string['not_started'] = 'nezačal';
$string['notanumber'] = '<strong>{$a}</strong> nie je akceptovaný formát čísla';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/A stĺpce';
$string['notavail'] = 'Tento dotazník už nie je k dispozícii. Požiadajte svojho učiteľa, aby ho odstránil.';
$string['noteligible'] = 'Nemáte nárok na tento dotazník.';
$string['notemplatesurveys'] = 'Žiadne šablóny dotazníkov.';
$string['notenoughscaleitems'] = 'Musíte zadať minimálne hodnoty 2 položiek mierky!';
$string['notificationfull'] = 'Úplné odoslanie';
$string['notifications'] = 'Odoslať oznámenia o odoslaní';
$string['notifications_help'] = 'Upozornite na úlohy pomocou možnosti „mod / dotazník: predloženie oznámenia“, keď sa predkladá.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Iba oznámenie';
$string['notopen'] = 'Tento dotazník sa otvorí až po {$a}.';
$string['notrequired'] = 'Odpoveď sa nevyžaduje';
$string['notset'] = 'nie je nastavené';
$string['nousersselected'] = 'Nie sú vybratí žiadni používatelia';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} pokusov vykonaných v tomto dotazníku';
$string['numberfloat'] = 'Číslo, ktoré ste zadali <strong>{$a->number}</strong>, bolo preformátované / zaokrúhlené na <strong>{$a->precision} </strong> desatinné miesta.';
$string['numberofdecimaldigits'] = 'Počet desatinných miest';
$string['numberofdecimaldigits_help'] = 'Použite **Počet desatinných číslic ** na určenie formátu priemernej hodnoty, ktorá sa má spočítať a zobraziť na stránke Správa o dotazníku.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Počet položiek mierky';
$string['numberscaleitems_help'] = 'Počet položiek mierky je *počet položiek*, ktoré sa majú použiť v mierke sadzieb. Normálne by ste použili hodnotu 3 až 5. Predvolená hodnota: **5**.';
$string['numeric'] = 'Číselný';
$string['numeric_help'] = 'Tento typ otázky použite, ak očakávate, že odpoveď bude správne naformátované číslo.';
$string['of'] = 'z';
$string['opendate'] = 'Použite dátum otvorenia.';
$string['option'] = 'možnosť {$a}';
$string['optional'] = 'Nepovinné - Aspoň jedna z týchto závislostí musí byť splnená.';
$string['optionalname'] = 'Názov otázky';
$string['optionalname_help'] = 'Názov otázky sa používa iba pri exportovaní odpovedí do formátu CSV / Excel.   Ak nikdy nezapisujete do formátu CSV, nemusíte sa vôbec obávať názvov otázok. Ak plánujete pravidelne exportovať svoje dotazníkové údaje do CSV, máte na výber mena otázok dve možnosti.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- alebo -';
$string['order_ascending'] = 'Vzostupné poradie';
$string['order_default'] = 'Zobraziť predvolené poradie';
$string['order_descending'] = 'Zostupne';
$string['orderresponses'] = 'Poradie odpovedí';
$string['orderresponses_help'] = 'Pri zobrazovaní všetkých odpovedí môžete zoradiť výber podľa počtu odpovedí (stĺpec Priemer) pre nasledujúce   4 typy otázok.

* prepínač s jedným výberom
* rozbaľovací zoznam s jedným výberom
* viac možností (začiarkavacie políčka)
* hodnotiť otázky (vrátane Likertovej stupnice).

Keď sa dostanete na stránku Všetky odpovede, predvolene sú všetky odpovede zoradené v poradí, v ktorom tvorca dotazníka zadal výber otázok.  Môžete si ich objednať vzostupne alebo zostupne.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Iné:';
$string['otherempty'] = 'Ak začiarknete túto voľbu, musíte do textového poľa zadať text !';
$string['overviewnumresplog'] = 'odpovede';
$string['overviewnumresplog1'] = 'odpoveď';
$string['overviewnumrespvw'] = 'odpovede';
$string['overviewnumrespvw1'] = 'odpoveď';
$string['owner'] = 'Vlastník';
$string['page'] = 'Strana';
$string['pageof'] = 'Strana {$a->page} z {$a->totpages}';
$string['parent'] = 'Rodič';
$string['participant'] = 'Účastník';
$string['pleasecomplete'] = 'Prosím vyplňte túto voľbu.';
$string['pluginadministration'] = 'Správa dotazníka';
$string['pluginname'] = 'Dotazník';
$string['position'] = 'pozícia';
$string['possibleanswers'] = 'Možné odpovede';
$string['posteddata'] = 'Dosiahnutá stránka s odoslanými údajmi:';
$string['preview_label'] = 'Náhľad';
$string['preview_questionnaire'] = 'Náhľad dotazníka';
$string['previewing'] = 'Náhľady dotazníka';
$string['previous'] = 'Predchádzajúci';
$string['previouspage'] = 'Predchádzajúca strana';
$string['print'] = 'Vytlačte túto odpoveď';
$string['printblank'] = 'Tlačte prázdne';
$string['printblanktooltip'] = 'Otvorí okno vhodné pre tlač s prázdnym dotazníkom';
$string['printtooltip'] = 'Otvorí okno vhodné pre tlač s aktuálnou odpoveďou';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Odpoveď na otázku s možnosťou výberu z viacerých možností';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID záznamu voľby pre túto odpoveď.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID záznamu otázky pre túto odpoveď.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID záznamu odpovede pre túto odpoveď.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Odpoveď na jednu otázku.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID záznamu o výbere pre túto odpoveď.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID záznamu otázky pre túto odpoveď.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID záznamu odpovede pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response'] = 'Prebieha alebo odoslaná odpoveď';
$string['privacy:metadata:questionnaire_response:complete'] = 'Stav dokončenia odpovede.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Známka pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'ID záznamu z dotazníka pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Časová pečiatka posledného uloženia pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID používateľa pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Boolovská (áno / nie) odpoveď na otázku.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Konkrétna boolovská odpoveď.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID záznamu otázky pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID záznamu odpovede pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_date'] = 'Odpoveď na dátumovú otázku.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID záznamu otázky pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Odpoveď na konkrétny dátum.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID záznamu odpovede pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_other'] = '„Iná“ možnosť pre text odpovede.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID záznamu o výbere pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID záznamu otázky pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Odpoveď na konkrétny text.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID záznamu odpovede pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Odpoveď na hodnotiacu otázku.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID záznamu o výbere pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID záznamu otázky pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Odpoveď na špecifickú hodnotenie';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID záznamu odpovede pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_text'] = 'Odpoveď na textovú otázku.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID záznamu otázky pre túto odpoveď.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Odpoveď na konkrétny text.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID záznamu odpovede pre túto odpoveď.';
$string['private'] = 'Súkromné';
$string['public'] = 'Verejné';
$string['publiccopy'] = 'Kopírované:';
$string['publicoriginal'] = 'Pôvodný:';
$string['qtype'] = 'Typ';
$string['qtype_help'] = 'Vyberte, či používatelia budú mať možnosť odpovedať raz, denne, týždenne, mesačne alebo neobmedzene (viackrát).';
$string['qtypedaily'] = 'denne odpovedať';
$string['qtypemonthly'] = 'odpovedať mesačne';
$string['qtypeonce'] = 'odpovedať raz';
$string['qtypeunlimited'] = 'odpovedať veľakrát';
$string['qtypeweekly'] = 'odpovedať týždenne';
$string['questionnaire:addinstance'] = 'Pridajte nový dotazník';
$string['questionnaire:copysurveys'] = 'Skopírujte šablónové a privátne dotazníky';
$string['questionnaire:createpublic'] = 'Vytvorte verejné dotazníky';
$string['questionnaire:createtemplates'] = 'Vytvorte šablóny dotazníkov';
$string['questionnaire:deleteresponses'] = 'Vymažte akúkoľvek odpoveď';
$string['questionnaire:downloadresponses'] = 'Stiahnite si odpovede do súboru CSV';
$string['questionnaire:editquestions'] = 'Vytvárajte a upravujte otázky';
$string['questionnaire:manage'] = 'Vytvárajte a upravujte dotazníky';
$string['questionnaire:message'] = 'Poslať správu neodpovedajúcim';
$string['questionnaire:preview'] = 'Ukážka dotazníkov';
$string['questionnaire:printblank'] = 'Tlač prázdneho dotazníka';
$string['questionnaire:readallresponseanytime'] = 'Prečítajte si všetky odpovede kedykoľvek';
$string['questionnaire:readallresponses'] = 'Prečítajte si zhrnutia odpovedí v časoch, keď sú otvorené';
$string['questionnaire:readownresponses'] = 'Prečítajte si vlastné odpovede';
$string['questionnaire:submissionnotification'] = 'Dostávať oznámenia pre každé odoslanie';
$string['questionnaire:submit'] = 'Vyplňte a odošlite dotazník';
$string['questionnaire:view'] = 'Zobraziť dotazník';
$string['questionnaire:viewsingleresponse'] = 'Zobraziť úplné individuálne odpovede';
$string['questionnaireadministration'] = 'Správa dotazníka';
$string['questionnairecloses'] = 'Dotazník sa uzavrie';
$string['questionnaireopens'] = 'Dotazník sa otvorí';
$string['questionnairereport'] = 'Správa z dotazníka';
$string['questionnum'] = 'Otázka č.';
$string['questions'] = 'Otázky';
$string['questionsinsection'] = 'Otázky v tejto časti:';
$string['questiontypes'] = 'Typy otázok';
$string['questiontypes_help'] = 'Pozrite si dokumentáciu k Moodle nižšie';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Prepínače';
$string['radiobuttons_help'] = 'Pri tomto type otázky si respondent musí vybrať jednu z ponúkaných možností.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Hodnotenie';
$string['ratescale'] = 'Hodnotenie (škála 1..5)';
$string['ratescale_help'] = 'Pozrite si dokumentáciu Moodle nižšie';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Typ dotazníka';
$string['realm_help'] = '* ** Existujú tri typy dotazníkov: **
  * Súkromné - patrí iba do kurzu, v ktorom je definovaný.
  * Šablóna - je možné kopírovať a upravovať.
  * Verejné - je možné zdieľať ich medzi kurzami.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'Adresa URL, na ktorú je používateľ presmerovaný po vyplnení tohto dotazníka.';
$string['remove'] = 'Zmazať';
$string['removeallquestionnaireattempts'] = 'Vymazať všetky odpovede na dotazník';
$string['removenotinuse'] = 'Tento dotazník závisel od verejného dotazníka, ktorý bol vymazaný. Už sa nemôže používať a mal by sa vymazať.';
$string['required'] = 'Vyžaduje sa odpoveď';
$string['required_help'] = 'Ak vyberiete možnosť *** Áno ***, bude požadovaná odpoveď na túto otázku, t.j. respondent nebude môcť vyplniť dotazník, kým nebude zodpovedaná táto otázka.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Chýba požadovaný parameter.';
$string['reset'] = 'Reset';
$string['respeligiblerepl'] = '(nahradené nahradením rolí)';
$string['respondent'] = 'Respondent';
$string['respondenteligibleall'] = 'všetko';
$string['respondenteligiblestudents'] = 'iba študenti';
$string['respondenteligibleteachers'] = 'iba učitelia';
$string['respondents'] = 'Respondenti';
$string['respondenttype'] = 'Typ respondenta';
$string['respondenttype_help'] = 'Všetky mená používateľov môžete zobraziť s každou odpoveďou nastavením na hodnotu „celé meno“. Identity používateľov môžete skryť z odpovedí nastavením na hodnotu „anonymné“.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonymné';
$string['respondenttypefullname'] = 'celé meno';
$string['response'] = 'Odpoveď';
$string['responsefieldlines'] = 'Veľkosť vstupného poľa';
$string['responseformat'] = 'Formát odpovede';
$string['responseoptions'] = 'Možností odpovede';
$string['responses'] = 'Odpovede';
$string['responseview'] = 'Študenti si môžu prezrieť VŠETKY odpovede';
$string['responseview_help'] = 'Môžete určiť, kto môže vidieť odpovede všetkých respondentov na odoslané dotazníky (všeobecné štatistické tabuľky).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Vždy';
$string['responseviewstudentsnever'] = 'Nikdy';
$string['responseviewstudentswhenanswered'] = 'Po odpovedaní na dotazník';
$string['responseviewstudentswhenclosed'] = 'Po uzavretí dotazníka';
$string['restrictedtoteacher'] = 'Tieto funkcie sú obmedzené len pre učiteľov !';
$string['resume'] = 'Uložiť / Obnoviť odpovede';
$string['resume_help'] = 'Nastavenie tejto možnosti umožňuje používateľom uložiť ich odpovede do dotazníka pred ich odoslaním.  Užívatelia môžu teda nechať dotazník nedokončený a neskôr pokračovať od miesta uloženia.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Pokračovať v dotazníku';
$string['return'] = 'Návrat';
$string['save'] = 'Uložiť';
$string['saveasnew'] = 'Uložiť ako novú otázku';
$string['savedbutnotsubmitted'] = 'Tento dotazník bol uložený, ale nebol ešte odoslaný.';
$string['savedprogress'] = 'Váš pokrok bol uložený. Môžete sa kedykoľvek vrátiť a tento dotazník vyplniť.';
$string['saveeditedquestion'] = 'Uložiť otázku {$a}';
$string['savesettings'] = 'Uložiť nastavenia';
$string['search:activity'] = 'Dotazník - informácie o činnosti';
$string['search:question'] = 'Dotazník - otázky';
$string['section'] = 'Popis';
$string['sectionbreak'] = '----- Zlom strany -----';
$string['sectionbreak_help'] = '----- Zlom strany -----';
$string['sectionsnotset'] = 'Musíte vybrať aspoň jednu otázku na jednu sekciu! <br /> Sekci(a/e) nie je(sú) vybratá(é): {$a}';
$string['sectiontext'] = 'štítok';
$string['sectiontext_help'] = 'Toto nie je otázka, ale (krátky) text, ktorý sa zobrazí na predstavenie série otázok.';
$string['selecttheme'] = 'Vyberte tému (css), ktorú chcete použiť v tomto dotazníku.';
$string['send'] = 'Odoslať';
$string['send_message'] = 'Odoslať správu vybraným používateľom';
$string['send_message_to'] = 'Poslať správu na:';
$string['sendemail'] = 'Poslať email';
$string['sendemail_help'] = 'Odosiela kópiu každého odoslania na určenú adresu alebo adresy.
Oddelením čiarky ich môžete zadať viac ako jednu adresu.
Nechajte prázdne pre žiadnu zálohu e-mailu.';
$string['set'] = 'Nastavte';
$string['settings'] = 'Nastavenie';
$string['settingssaved'] = 'Nastavenia boli uložené';
$string['show_nonrespondents'] = 'Neodpovedajúci';
$string['started'] = 'začaté';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Použite formát rok-mesiac-deň, napr. pre 4.marec 1945:&nbsp; <strong>1945-03-04</strong>';
$string['subject'] = 'Predmet';
$string['submissionnotificationhtmlanon'] = 'Je nové <a href="{$a->submissionurl}">odoslanie </a>  dotazníka "{$a->name}" .';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> má nové <a href="{$a->submissionurl}">odoslanie</a> to the "{$a->name}" dotazníka v kurze "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nové odoslanie dotazníka';
$string['submissionnotificationtextanon'] = 'Je nové odoslanie ({$a-> submissionurl}) dotazníka „{$a-> name}“.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) novo odoslal ({$a->submissionurl}) to the "{$a->name}" dotazník v kurze  "{$a->coursename}".';
$string['submitoptions'] = 'Možnosti odoslania';
$string['submitpreview'] = 'Odoslať náhľad';
$string['submitpreviewcorrect'] = 'Tento príspevok bude prijatý ako správne vyplnený.';
$string['submitsurvey'] = 'Odošlite dotazník';
$string['submitted'] = 'Vložené dňa:';
$string['subtitle'] = 'podtitul';
$string['subtitle_help'] = 'Podnadpis tohto dotazníka. Zobrazí sa iba pod nadpisom na prvej stránke.';
$string['summary'] = 'Zhrnutie';
$string['surveynotexists'] = 'dotazník neexistuje.';
$string['surveyowner'] = 'Na vykonanie tejto operácie musíte byť vlastníkom dotazníka.';
$string['surveyresponse'] = 'Odpoveď z dotazníka';
$string['template'] = 'Šablóna';
$string['templatenotviewable'] = 'Šablóny dotazníkov nie je možné zobraziť.';
$string['text'] = 'Text otázky';
$string['textareacolumns'] = 'Stĺpce textového poľa';
$string['textareacolumns_help'] = 'V tejto otázke sa zobrazí obyčajné textové pole s **x**  *stĺpcami text.poľa*  (alebo s *šírkou* ) a ** y ** *riadkami text.poľa* (počet *riadkov* textu).

Ak ponecháte obe hodnoty x a y na predvolenú hodnotu **0** (alebo ak ju nastavíte na **0**), zobrazí sa editor HTML so štandardnou výškou a šírkou (ak je dostupný v užívateľskom profile kontextu / kurzu).';
$string['textarearows'] = 'Riadky textového poľa';
$string['textbox'] = 'Textové pole';
$string['textbox_help'] = 'Pre typ otázky Textové pole zadajte dĺžku vstupného poľa a maximálnu dĺžku textu, ktorú má respondent zadať. Predvolené hodnoty sú 20 znakov pre šírku vstupného poľa a 25 znakov pre zadanú maximálnu dĺžku textu.';
$string['textdownloadoptions'] = 'Možnosti stiahnutia súboru CSV';
$string['thank_head'] = 'Ďakujeme vám za vyplnenie tohto dotazníka.';
$string['theme'] = 'Téma';
$string['thismonth'] = 'tento mesiac';
$string['thisresponse'] = 'Táto odpoveď';
$string['thisweek'] = 'tento týždeň';
$string['thousands'] = 'Nepoužívajte oddeľovače tisícov.';
$string['title'] = 'Názov';
$string['title_help'] = 'Názov tohto dotazníka, ktorý sa zobrazí v hornej časti každej stránky. Názov je v predvolenom nastavení nastavený na názov dotazníka, ale môžete ho upraviť podľa svojich predstáv.';
$string['today'] = 'dnes';
$string['total'] = 'Celkovo';
$string['totalofnumbers'] = 'Celkový počet zadaných čísel';
$string['totalresponses'] = 'Celkový počet odpovedí na otázku';
$string['type'] = 'Typ otázky';
$string['undefinedquestiontype'] = 'Nedefinovaný typ otázky!';
$string['unknown'] = 'Neznámy';
$string['unknownaction'] = 'Špecifikovaná neznáma akcia dotazníka ...';
$string['url'] = 'Potvrdzovacia adresa URL';
$string['url_help'] = 'Adresa URL, na ktorú je používateľ presmerovaný po vyplnení tohto dotazníka.';
$string['useprivate'] = 'Kopírovať existujúce';
$string['usepublic'] = 'Použitie verejného';
$string['usetemplate'] = 'Použítie šablóny';
$string['vertical'] = 'Vertikálne';
$string['view'] = 'Náhľad';
$string['viewallresponses'] = 'Zobraziť všetky odpovede';
$string['viewallresponses_help'] = 'Ak je dotazník nastavený na **Skupinový režim**: *Viditeľné skupiny* alebo je nastavený na *Oddelené skupiny* a aktuálny používateľ má právomoc *moodle/site:accessallgroups* (v aktuálnom kontexte) a skupiny boli definované v aktuálnom kurze,   potom má užívateľ prístup k rozbaľovaciemu zoznamu skupín. Tento rozbaľovací zoznam umožňuje užívateľovi „filtrovať“ odpovede na dotazník podľa skupín.  Ak je nastavenie ** Skupinový režim **: * Oddelené skupiny *, používatelia, ktorí nemajú právomoc *moodle/site:accessallgroups*  (zvyčajne študenti alebo učitelia bez úpravy atď.) si budú môcť zobraziť iba odpovede skupín, do ktorých patria.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Zoznam odpovedí';
$string['viewindividualresponse'] = 'Individuálne odpovede';
$string['viewindividualresponse_help'] = 'Kliknutím na mená respondentov v zozname nižšie zobrazíte ich individuálne odpovede.';
$string['viewresponses'] = 'Všetky odpovede  ({$a})';
$string['viewyourresponses'] = 'Náhľad Vašich odpovedí - {$a}';
$string['warning'] = 'Upozornenie, vyskytla sa chyba.';
$string['wronganswers'] = 'S vašimi odpoveďami niečo nie je v poriadku (pozri nižšie)';
$string['wrongdateformat'] = 'Vložený dátum: <strong>{$a}</strong> nekorešponduje s formátom v príklade.';
$string['wrongdaterange'] = 'CHYBA! Rok musí byť stanovený v rozmedzí rokov 1902 až 2037.';
$string['wrongformat'] = 'S vašou odpoveďou na otázku je niečo nesprávne :&nbsp;';
$string['wrongformats'] = 'S vašou odpoveďou na otázky je niečo nesprávne:&nbsp;';
$string['yesno'] = 'Áno nie';
$string['yesno_help'] = 'Jednoduchá áno / nie otázka.';
$string['yourresponse'] = 'Vaša odpoveď';
$string['yourresponses'] = 'Vaše odpovede';
