<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'da', version '4.2'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Gennemse alle kurser';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Du er ikke tilmeldt nogen kurser endnu.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Gennemse alle tilgængelige kurser herunder og start din læring';
$string['addon.block_myoverview.noresult'] = 'Din søgning matchede ingen kurser.';
$string['addon.block_myoverview.noresultdescription'] = 'Prøv at justere dine filtre eller søg blandt alle kurser nedenfor.';
$string['addon.blog.errorloadentries'] = 'Fejl under indlæsning af blogindlæg';
$string['addon.blog.showonlyyourentries'] = 'Vis kun dine indlæg';
$string['addon.calendar.calendarevent'] = 'Kalenderbegivenhed';
$string['addon.calendar.calendarevents'] = 'Kalenderbegivenheder';
$string['addon.calendar.calendarreminders'] = 'Kalenderpåmindelser';
$string['addon.calendar.currentmonth'] = 'Denne måned';
$string['addon.calendar.defaultnotificationtime'] = 'Standard notifikationstidspunkt';
$string['addon.calendar.errorloadevent'] = 'Fejl ved indlæsning af begivenhed.';
$string['addon.calendar.errorloadevents'] = 'Fejl ved indlæsning af begivenheder.';
$string['addon.calendar.noevents'] = 'Der er ingen begivenheder';
$string['addon.calendar.reminders'] = 'Påmindelser';
$string['addon.calendar.setnewreminder'] = 'Opret en ny påmindelse';
$string['addon.calendar.timebefore'] = '{{value}} {{units}} før';
$string['addon.competency.errornocompetenciesfound'] = 'Ingen kompetencer fundet';
$string['addon.competency.nocompetencies'] = 'Ingen kompetencer';
$string['addon.coursecompletion.complete'] = 'Fuldfør';
$string['addon.coursecompletion.couldnotloadreport'] = 'Kunne ikke indlæse rapporten over  kursusfuldførelse, prøv igen senere.';
$string['addon.enrol_self.confirmselfenrol'] = 'Er du sikker på du vil tilmelde dig i dette kursus?';
$string['addon.enrol_self.errorselfenrol'] = 'Der opstod en fejl da du tilmeldte dig kurset.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurer enheder';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Dine brugere modtager ikke nogen meddelelse fra dette websted på deres mobile enheder. Aktiver mobilmeddelelser på siden Meddelelsesindstillinger.';
$string['addon.messages.contactlistempty'] = 'Kontaktlisten er tom';
$string['addon.messages.contactname'] = 'Kontaktnavn';
$string['addon.messages.deletemessage'] = 'Slet besked';
$string['addon.messages.deletemessageconfirmation'] = 'Er du sikker på, at du vil slette denne besked? Den vil kun blive slettet fra din beskedhistorik og vil stadig kunne ses af den bruger, der sendte eller modtog beskeden.';
$string['addon.messages.errordeletemessage'] = 'Fejl under sletning af beskeden.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Fejl ved hentning af kontakter fra serveren';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Fejl ved hentning af samtaler fra serveren';
$string['addon.messages.errorwhileretrievingmessages'] = 'Fejl ved hentning af beskeder fra serveren.';
$string['addon.messages.errorwhileretrievingusers'] = 'Fejl under hentning af brugere fra serveren.';
$string['addon.messages.messagenotsent'] = 'Beskeden blev ikke sendt, prøv igen senere.';
$string['addon.messages.newmessages'] = 'Nye beskeder';
$string['addon.messages.nousersfound'] = 'Ingen brugere fundet';
$string['addon.messages.showdeletemessages'] = 'Vis slet beskeder';
$string['addon.messages.type_blocked'] = 'Blokeret';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Søgeresultat';
$string['addon.messages.type_strangers'] = 'Andre';
$string['addon.messages.useentertosenddescdesktop'] = 'Er indstillingen deaktiveret, kan du bruge Ctrl+Enter til at sende beskeden.';
$string['addon.messages.useentertosenddescmac'] = 'Er indstillingen deaktivereret, kan du bruge Cmd+Enter til at sende beskeden.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Kunne ikke sende besked(er) til samtalen {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Kunne ikke sende besked(er) til brugeren {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Du skal acceptere afleveringserklæringen.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Opgaveoplysningerne og indsendelsesformularen vil være tilgængelige fra <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Opgaven vil kunne besvares fra <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Du kan ikke tilføje eller redigere en opgaveaflevering i appen, da vi kunne ikke modtage afleveringserklæringen fra websiden.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Nogle karaktergivningsmetoder understøttes endnu ikke i appen og kan ikke ændres.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Du kan ikke aflevere til bedømmelse i appen da vi ikke kunne modtage afleveringserklæringen fra websiden.';
$string['addon.mod_assign.duedateno'] = 'Ingen forfaldsdato';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Du kan ikke tilføje eller redigere en opgaveaflevering i appen, nogle plugins understøtter ikke redigering.';
$string['addon.mod_assign.errorshowinginformation'] = 'Vi kan ikke vise information om aflevering';
$string['addon.mod_assign.feedbacknotsupported'] = 'Denne Feedback understøttes ikke af appen og indeholder måske ikke alle informationer';
$string['addon.mod_assign.gradenotsynced'] = 'Karakterer er ikke synkroniseret';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Deltagere uden afleveringer vises ikke';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Der er {{count}} kladder.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Der er {{count}} deltagere.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Der er {{count}} afleveringer, der skal bedømmes.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Der er {{count}} afleverede opgaver.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Der er {{count}} hold.';
$string['addon.mod_assign.submissionnotsupported'] = 'Denne aflevering understøttes ikke af appen og indeholder måske ikke alle informationer';
$string['addon.mod_assign.syncblockedusercomponent'] = 'brugerkarakter';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Karakter for opgaven er ændret på websiden.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Opgavebesvarelsen er ændret på websiden.';
$string['addon.mod_chat.confirmloss'] = 'Er du sikker? Chathistorik kan gå tabt.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Fejl ved tilkobling til chatten.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Fejl ved hentning af chatdata.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Fejl ved hentning af chatbrugere.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Fejl ved hentning af beskeder fra serveren.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Fejl ved afsendelse af besked.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Du skal være online for at sende beskeder';
$string['addon.mod_chat.nosessionsfound'] = 'Ingen sessioner fundet';
$string['addon.mod_chat.showincompletesessions'] = 'Vis ufuldstændige sessioner';
$string['addon.mod_choice.errorgetchoice'] = 'Fejl ved hentning af valgdata';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% af brugerne vælger denne mulighed: {{test}}';
$string['addon.mod_choice.resultsnotsynced'] = 'Dit sidste svar skal være synkroniseret, før det kommer med i resultaterne.';
$string['addon.mod_data.edittagsnotsupported'] = 'Beklager, redigering af tags understøttes ikke af appen.';
$string['addon.mod_data.errorapproving'] = 'Fejl under godkendelse eller afvisning af opslag.';
$string['addon.mod_data.errordeleting'] = 'Fejl under sletning af opslag.';
$string['addon.mod_data.gettinglocation'] = 'Henter lokation';
$string['addon.mod_data.locationnotenabled'] = 'Lokation, er ikke slået til';
$string['addon.mod_data.locationpermissiondenied'] = 'Tilladelse til at få adgang til din lokation er blevet nægtet.';
$string['addon.mod_data.mylocation'] = 'Min lokation';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Beklager, søgning efter tags understøttes ikke af appen.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Feedback med CAPTCHA kan ikke bruges offline hvis den ikke er konfigureret eller hvis serveren nede.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Der er {{count}} indsendte svar.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Denne feedback er gemt til aflevering senere.';
$string['addon.mod_feedback.questionscountdescription'] = 'Der er {{count}} spørgsmål.';
$string['addon.mod_folder.emptyfilelist'] = 'Der er ingen filer at vise.';
$string['addon.mod_forum.errorgetforum'] = 'Fejl ved hentning af forumdata.';
$string['addon.mod_forum.errorgetgroups'] = 'Fejl ved hentning af gruppeindstillinger.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum ikke tilgængeligt i denne sorteringsrækkefølge';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Prøv at ændre sorteringsrækkefølgen eller gå online for at se dette forum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Kunne ikke oprette ny diskussion i alle grupper.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Der er endnu ingen indlæg i dette forum.';
$string['addon.mod_forum.group'] = 'Gruppe';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} samtaler';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} svar';
$string['addon.mod_forum.postingroup'] = 'Slå op i gruppen "{{gruppenavn}}".';
$string['addon.mod_forum.refreshposts'] = 'Genindlæs indlæg';
$string['addon.mod_glossary.browsemode'] = 'Gennemse indlæg';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetisk';
$string['addon.mod_glossary.byauthor'] = 'Gruppér efter forfatter';
$string['addon.mod_glossary.bycategory'] = 'Gruppér efter kategori';
$string['addon.mod_glossary.bynewestfirst'] = 'Nyeste først';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Senest opdateret';
$string['addon.mod_glossary.bysearch'] = 'Søg';
$string['addon.mod_glossary.cannoteditentry'] = 'Kan ikke redigere opslaget';
$string['addon.mod_glossary.entriestobesynced'] = 'Opslag der skal synkroniseres';
$string['addon.mod_glossary.entrypendingapproval'] = 'Dette opslag afventer godkendelse';
$string['addon.mod_glossary.errordeleting'] = 'Fejl ved sletning af post.';
$string['addon.mod_glossary.errorloadingentries'] = 'Der opstod en fejl under indlæsning af opslag';
$string['addon.mod_glossary.errorloadingentry'] = 'Der opstod en fejl under indlæsning af opslaget';
$string['addon.mod_glossary.errorloadingglossary'] = 'Der opstod en fejl under indlæsning af ordbogen.';
$string['addon.mod_glossary.noentriesfound'] = 'Ingen opslag fundet';
$string['addon.mod_glossary.searchquery'] = 'Søgeord';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Download H5P-fil';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Fejl ved hentning af H5P-aktivitetsdata.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P-pakken er ikke downloadet. Du skal downloade den for at kunne bruge den.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P-pakken er blevet ændret siden sidste download. Du skal downloade den igen for at kunne bruge den.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Du skal være online for at se H5P-pakken.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Se forsøg {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Vis beskrivelse';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Denne lektion har et spring til en tilfældig indholdsside, den kan ikke bruges i appen før den er startet i en webbrowser.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Dette forsøg kan ikke længere gennemses da et nyt forsøg er fuldført.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Dette forsøg blev afsluttet offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Et offline forsøg er synkroniseret. Vil du gennemse det?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Dette forsøg blev afsluttet på websiden.';
$string['addon.mod_lti.errorgetlti'] = 'Fejl ved hentning af moduldata.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Start-URL\'en er ikke gyldig.';
$string['addon.mod_lti.launchactivity'] = 'Start aktiviteten';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Fejl ved indlæsning af siden.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Du kan prøve denne quiz i appen, men du skal indsende forsøget i browseren af følgende årsager:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Denne quizbesvarelse kan ikke afleveres af følgende årsager:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Denne besvarelse er ikke synkroniseret siden {{$a}}. Hvis du har arbejdet videre på besvarelsen på en anden enhed siden da, kan du miste data.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Der opstod en fejl under forsøg på at gemme svarene. Er du sikker på at du vil forlade quizzen?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Quizzen kan ikke afvikles i appen, som ikke understøtter quizzens opførsel:';
$string['addon.mod_quiz.errordownloading'] = 'Fejl under download af de krævede data.';
$string['addon.mod_quiz.errorgetattempt'] = 'Kunne ikke hente forsøgsdata';
$string['addon.mod_quiz.errorgetquestions'] = 'Kunne ikke hente spørgsmål.';
$string['addon.mod_quiz.errorgetquiz'] = 'Kunne ikke hente quizdata.';
$string['addon.mod_quiz.errorparsequestions'] = 'Der opstod en fejl ved læsning af spørgsmålene. Kør quizzen i en webbrowser i stedet.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Denne quiz kan ikke tages i appen, quizzen indeholder kun spørgsmål som ikke supporteres af appen:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Denne quiz virker ikke i appen, quizzen indeholder regler som appen ikke supporterer:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Der opstod en fejl da dine forsøgsdata skulle gemmes.';
$string['addon.mod_quiz.finishnotsynced'] = 'Afsluttet, men ikke synkroniseret';
$string['addon.mod_quiz.opentoc'] = 'Åben navigations-popover';
$string['addon.mod_quiz.warningattemptfinished'] = 'Offline-forsøget blev ignoreret da det blev afsluttet på websiden eller ikke blev fundet.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Nogle offline-svar blev ignoreret da spørgsmålene var ændret online';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Forsøget er ikke færdigt da nogle offline svar blev frasorteret. Gennemse dine svar og aflever igen.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Denne quiz indeholder spørgsmål, der ikke understøttes af appen:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Fejl under indlæsning af indhold.';
$string['addon.mod_resource.openthefile'] = 'Åbn';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Filen er ændret siden du sidste åbnede den';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Der er en nyere version af denne fil. For at se den skal du tilslutte din enhed til internettet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Karaktererne kunne ikke beregnes.';
$string['addon.mod_scorm.dataattemptshown'] = 'Disse data tilhører forsøg nummer {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'En fejl opstod ved oprettelse af et nyt offline forsøg. Prøv igen.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Fejl ved hentning af SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Fejl ved hentning af SCORM-data.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Beklager, programmet understøtter kun SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Download af SCORM-pakker er deaktiveret på dit Moodlewebsted.';
$string['addon.mod_scorm.errornovalidsco'] = 'Denne SCORM har ikke en synlig SCO at indlæse.';
$string['addon.mod_scorm.errorpackagefile'] = 'Beklager, programmet understøtter kun zip-pakker.';
$string['addon.mod_scorm.errorsyncscorm'] = 'En fejl opstod under synkronisering. Prøv igen.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Dette forsøg har data, der ikke er synkroniseret.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Dette forsøg kan ikke sendes da du har overskredet det tilladte antal forsøg.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Denne SCORM er ikke downloadet. Den bliver automatisk downloadet når du åbner den.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Denne SCORM er ændret efter den sidste download. Den bliver automatisk downloadet når du åbner den.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Nogle af forsøgets offlinedata {{number}} er blevet slettet fordi de ikke kunne oprettes i et nyt forsøg.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Nogle forsøg kunne ikke synkroniseres med webstedet, fordi det sidste onlineforsøg ikke er afsluttet. Afslut først onlineforsøget.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Beklager, kunne ikke sende din undersøgelse. Prøv igen.';
$string['addon.mod_survey.errorgetsurvey'] = 'Fejl ved hentning af undersøgelsesdata.';
$string['addon.mod_survey.results'] = 'Resultater';
$string['addon.mod_url.accessurl'] = 'Gå til URL\'en';
$string['addon.mod_url.pointingtourl'] = 'URL\'en, ressourcen peger på.';
$string['addon.mod_wiki.errorloadingpage'] = 'Der opstod en fejl mens siden blev indlæst.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Denne wiki har endnu intet indhold.';
$string['addon.mod_wiki.gowikihome'] = 'Gå til wiki-forsiden';
$string['addon.mod_wiki.subwiki'] = 'Underwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Titlen må ikke være tom';
$string['addon.mod_wiki.viewpage'] = 'Se side';
$string['addon.mod_wiki.wikipage'] = 'Wikiside';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Bedømmelsesstrategien {{$a}} er ikke understøttet';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Du skal angive en titel.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Afleveringen er blevet ændret på sitet';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Bedømmelsen er blevet ændret på sitet.';
$string['addon.notes.warningnotenotsent'] = 'Kunne ikke tilføje note(r) til kurset {{course}}. {{error}}';
$string['addon.notifications.allownotifications'] = 'Tillad notifikationer';
$string['addon.notifications.errorgetnotifications'] = 'Fejl ved hentning af notifikationer.';
$string['addon.notifications.notifications'] = 'Notifikationer';
$string['addon.notifications.playsound'] = 'Afspil lyd';
$string['addon.notifications.therearentnotificationsyet'] = 'Der er ingen notifikationer.';
$string['addon.notifications.typeofnotification'] = 'Type notifikationer';
$string['addon.privatefiles.couldnotloadfiles'] = 'Listen med filer kunne ikke hentes';
$string['addon.privatefiles.emptyfilelist'] = 'Der er ingen filer at vise.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Det er desværre ikke muligt at uploade filer til din side.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Vil du slette alle downloadede data?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Slet alle downloadede data fra alle kurser?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Slet alle downloadede data fra \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Kursusdownloads';
$string['addon.storagemanager.courseinfo'] = 'Download kursusindhold for at arbejde offline. Din aktivitet synkroniseres automatisk, når din enhed er online igen.';
$string['addon.storagemanager.deleteallsitedata'] = 'Vil du slette alle downloadede data?';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Dette vil slette alle downloadede data fra \'{{name}}\', inklusive alle downloadede kurser og data, der giver dig mulighed for at arbejde offline.';
$string['addon.storagemanager.deletecourses'] = 'Slet downloadede data fra alle kurser';
$string['addon.storagemanager.deletedata'] = 'Slet downloadede data';
$string['addon.storagemanager.deletedatafrom'] = 'Slet downloadede data fra  \'{{name}}\'';
$string['addon.storagemanager.downloadedcourses'] = 'Downloadede kurser';
$string['addon.storagemanager.downloads'] = 'Downloads';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Fejl ved sletning af downloadede data.';
$string['addon.storagemanager.managedownloads'] = 'Administrer downloads';
$string['addon.storagemanager.totaldownloads'] = 'Total downloads';
$string['addon.storagemanager.totalspaceusage'] = 'Samlet brugt plads';
$string['appstoredescription'] = 'BEMÆRK: Denne officielle Moodle Mobil App virker KUN på Moodlewebsteder, som er sat op til adgang via app. Kontakt din Moodleadministrator, hvis du har problemer med at komme på.

Hvis dit Moodlewebsted er konfigureret til det, kan du bruge denne app til at:

- arbejde med dit kursusindhold, selv når du er offline
- få øjeblikkelig underretning om meddelelser og andre begivenheder
- hurtigt finde og kontakte andre deltagere på dine kurser
- uploade billeder, lyd og videoer samt andre filer fra din telefon eller tablet
- se dine kursusbedømmelser
- med mere!

Se de nyeste oplysninger på http://docs.moodle.org/da/Mobile_app.

Vi vil virkelig sætte pris på gode anmeldelser om funktionaliteten som den er nu, og dine forslag til hvad du ellers ønsker at denne app skal kunne!

Denne app kræver følgende tilladelser:
Optage lyd - Til optagelse af lyd for upload til Moodle
Læse og ændre indholdet af dit SD-kort - Indholdet hentes til SD-kortet, så du kan se det offline
Adgang til netværk - For at kunne  forbinde til dit Moodlewebsted og kontrollere om du er forbundet eller ej for at skifte til offline tilstand
Kør ved opstart - Så du modtager lokale meddelelser, selv når app\'en kører i baggrunden
Forhindre telefonen i at sove - Så du når som helst kan modtage beskeder';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynote præsentation';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbers regneark';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pages dokumenter';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive audio';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive-fil';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive-mappe';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive-video';
$string['core.ajaxendpointnotfound'] = 'AJAX-endpoint blev ikke fundet. Dette kan ske, hvis Moodle-webstedet er for gammelt, eller det blokerer adgangen til dette slutpunkt. Moodle-appen understøtter kun Moodle-systemer {{$a}} og fremefter.';
$string['core.browser'] = 'Browser';
$string['core.calculating'] = 'Beregner';
$string['core.cannotconnect'] = 'Kan ikke oprette forbindelse til webstedet';
$string['core.cannotdownloadfiles'] = 'Din skole eller uddannelsesinstitution har deaktiveret download af filer.';
$string['core.cannotinstallapk'] = 'Kan ikke installere apk-filer';
$string['core.cannotinstallapkinfo'] = 'Af sikkerhedsmæssige årsager kan du ikke installere ukendte apps på din enhed fra denne app. Hvis du stadig vil fortsætte med installationen, skal du åbne den i en browser.';
$string['core.cannotlogoutpageblocks'] = 'Gem eller kasser dine ændringer før du fortsætter.';
$string['core.cannotopeninapp'] = 'Denne fil fungerer måske ikke som forventet på denne enhed. Vil du gerne åbne den alligevel?';
$string['core.cannotopeninappdownload'] = 'Denne fil fungerer måske ikke som forventet på denne enhed. Vil du gerne downloade den alligevel?';
$string['core.captureaudio'] = 'Optag lyd';
$string['core.capturedimage'] = 'Billede taget';
$string['core.captureimage'] = 'Tag et billede';
$string['core.capturevideo'] = 'Optag video';
$string['core.certificaterror'] = 'Certifikatet fra dette websted kan din enhed ikke stole på: {{details}}';
$string['core.clearsearch'] = 'Ryd søgning';
$string['core.clearstoreddata'] = 'Ryd lagerplads {{$a}}';
$string['core.clicktoseefull'] = 'Klik for at se alt indhold.';
$string['core.comments.commentsnotworking'] = 'Kommentarerne kan ikke hentes';
$string['core.comments.warningcommentsnotsent'] = 'Kunne ikke synkronisere kommentarer. {{fejl}}';
$string['core.confirmcanceledit'] = 'Er du sikker på at du vil forlade denne side? Alle ændringer vil gå tabt.';
$string['core.confirmleaveunknownchanges'] = 'Er du sikker på du vil forlade denne side? Hvis du har ændringer, der ikke er gemt, vil de gå tabt.';
$string['core.confirmloss'] = 'Er du sikker? Alle ændringer vil gå tabt.';
$string['core.confirmopeninbrowser'] = 'Vil du åbne den i en browser?';
$string['core.connectionlost'] = 'Forbindelsen til sitet blev tabt.';
$string['core.contactsupport'] = 'Kontakt support';
$string['core.contenteditingsynced'] = 'Det indhold du redigerer, er blevet synkroniseret.';
$string['core.contentlinks.chooseaccount'] = 'Vælg konto';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Vælg en konto at åbne linket med.';
$string['core.contentlinks.confirmurlothersite'] = 'Linket tilhører et andet site. Vil du åbne det?';
$string['core.contentlinks.errornoactions'] = 'Kunne ikke finde nogen handling af udføre med dette link';
$string['core.contentlinks.errornosites'] = 'Kunne ikke finde noget site til at håndtere dette link.';
$string['core.contentlinks.errorredirectothersite'] = 'Omdirigerings-URL\'en kan ikke pege på et andet websted.';
$string['core.copiedtoclipboard'] = 'Teksten er kopieret til udklipsholderen';
$string['core.copytoclipboard'] = 'Kopier til udklipsholder';
$string['core.course.activitydisabled'] = 'Din organisation har deaktiveret denne aktivitet i mobilappen.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Din organisation har installeret et plugin, der endnu ikke er understøttet.';
$string['core.course.allsections'] = 'Alle sektioner';
$string['core.course.aria:sectionprogress'] = 'Sektionsfremgang:';
$string['core.course.availablespace'] = 'Du har {{available}} ledig plads.';
$string['core.course.cannotdeletewhiledownloading'] = 'Filer kan ikke slettes mens aktiviteten er ved at blive downloaded. Vent på at downloaden er færdig.';
$string['core.course.confirmdownload'] = 'Du er ved at hente {{size}}.{{availableSpace}} Er du sikker på at du vil fortsætte?';
$string['core.course.confirmdownloadunknownsize'] = 'Vi kunne ikke beregne størrelsen af din download.{{availableSpace}} Er du sikker på du vil fortsætte?';
$string['core.course.confirmdownloadzerosize'] = 'Du er ved at starte en download {{availableSpace}} Vil du forsætte?';
$string['core.course.confirmlimiteddownload'] = 'Du er ikke forbundet til WiFi';
$string['core.course.confirmpartialdownloadsize'] = 'Du er ved at downloade <strong>mindst</strong> {{size}}.{{availableSpace}} Er du sikker på at du vil fortsætte?';
$string['core.course.couldnotloadsectioncontent'] = 'Kunne ikke indlæse sektionens indhold, prøv igen senere.';
$string['core.course.couldnotloadsections'] = 'Kunne ikke indlæse sektionerne, prøv igen senere.';
$string['core.course.downloadcoursesprogressdescription'] = 'Downloader kurser. Downloadet  {{count}} ud af {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Downloader sektioner: Downloadet {{count}} ud af {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Fejl i forbindelse med download af kurset.';
$string['core.course.errordownloadingsection'] = 'Fejl ved download af sektion.';
$string['core.course.errorgetmodule'] = 'Fejl under indhentning af aktivitetsdata.';
$string['core.course.insufficientavailablequota'] = 'Din enhed kunne ikke reservere nok plads til at gemme denne download. Enheden kan have reserveret plads til app- og systemopdateringer. Prøv at frigøre plads på enheden.';
$string['core.course.insufficientavailablespace'] = 'Du er ved at downloade {{size}}. Det betyder at din enhed ikke har nok plads til kunne fungere normalt. Prøv at frigøre plads på enheden.';
$string['core.course.lastaccessedactivity'] = 'Sidste tilgåede aktivitet';
$string['core.course.manualcompletionnotsynced'] = 'Manuel registrering af gennemførsel er ikke synkroniseret';
$string['core.course.modulenotfound'] = 'Ressourcen eller aktiviteten blev ikke fundet. Tjek at du er online og at aktivteten stadig er tilgængelig.';
$string['core.course.nextactivity'] = 'Næste aktivitet';
$string['core.course.nextactivitynotfound'] = 'Næste aktivitet blev ikke fundet. Det er muligt, at den er skjult eller slettet.';
$string['core.course.nocontentavailable'] = 'Intet indhold tilgængeligt lige nu.';
$string['core.course.previousactivity'] = 'Forrige aktivitet';
$string['core.course.previousactivitynotfound'] = 'Forrige aktivitet blev ikke fundet. Det er muligt,  at den er skjult eller slettet.';
$string['core.course.refreshcourse'] = 'Genindlæs kurset';
$string['core.course.useactivityonbrowser'] = 'Du kan stadig bruge den med din browser.';
$string['core.course.warningmanualcompletionmodified'] = 'Den manuelle gennemførselsmarkering er ændret på websitet';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Nogle offline manuelle gennemførselsmarkeringer \'{{name}}\' er blevet slettet. {{error}}';
$string['core.coursenogroups'] = 'Du er ikke et medlem af nogen grupper i dette kursus.';
$string['core.courses.browserenrolinstructions'] = 'Du bliver sendt til din enheds browser. Vend tilbage til denne app, når du har færdiggjort din tilmelding.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorier dybere end niveau  {{$a}} kan ikke hentes';
$string['core.courses.completeenrolmentbrowser'] = 'Færdiggør tilmelding i browseren';
$string['core.courses.confirmselfenrol'] = 'Er du sikker på at du vil tilmelde dig dette kursus?';
$string['core.courses.downloadcourses'] = 'Download kurser';
$string['core.courses.enrolme'] = 'Tilmeld mig';
$string['core.courses.errorloadcategories'] = 'Der skete en fejl i forbindelse med indlæsning af kategorier.';
$string['core.courses.errorloadcourses'] = 'En fejl opstod ved indlæsning af kurset.';
$string['core.courses.errorloadplugins'] = 'De plugins som kræves af kurset, kunne ikke indlæses korrekt. Genstart app\'en og prøv igen.';
$string['core.courses.errorsearching'] = 'En fejl opstod under søgning.';
$string['core.courses.errorselfenrol'] = 'En fejl opstod under selvtilmelding.';
$string['core.courses.filtermycourses'] = 'Filtrer mine kurser';
$string['core.courses.notenrollable'] = 'Du kan ikke selv tilmelde dig dette kursus.';
$string['core.courses.otherenrolments'] = 'Andre tilmeldinger';
$string['core.courses.password'] = 'Tilmeldingsnøgle';
$string['core.courses.refreshcourses'] = 'Genindlæs kurser';
$string['core.courses.searchcoursesadvice'] = 'Du kan bruge knappen kursussøgning for at få adgang som gæst eller tilmelde dig kurser der tillader det.';
$string['core.courses.selfenrolment'] = 'Selvtilmelding';
$string['core.courses.showonlyenrolled'] = 'Vis kun mine kurser';
$string['core.courses.totalcoursesearchresults'] = 'Kurser i alt: {{$a}}';
$string['core.currentdevice'] = 'Aktuelle enhed';
$string['core.datastoredoffline'] = 'Der blev gemt data på enheden da det ikke kunne sendes. Det vil blive sendt senere.';
$string['core.deletedoffline'] = 'Slettet offline';
$string['core.deleting'] = 'Sletter';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['core.dfdayweekmonth'] = 'ddd D. MMM';
$string['core.dffulldate'] = 'dddd D. MMMM YYYY h[:]mm';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm G';
$string['core.discard'] = 'Kasser';
$string['core.dismiss'] = 'Forkast';
$string['core.dontshowagain'] = 'Vis ikke igen';
$string['core.downloaded'] = 'Downloadet';
$string['core.downloading'] = 'Downloader';
$string['core.editor.hidetoolbar'] = 'Skjul værktøjslinje';
$string['core.editor.toggle'] = 'Slå editor til eller fra';
$string['core.emptysplit'] = 'Denne side vil være tom, hvis det venstre panel er tomt eller er ved at blive indlæst.';
$string['core.endingtime'] = 'Sluttid: {{$a}}';
$string['core.errorchangecompletion'] = 'En fejl opstod under ændring af gennemførelsesstatus. Prøv igen.';
$string['core.errorcode'] = 'Fejlkode: {{errorCode}}';
$string['core.errordeletefile'] = 'Fejl ved sletning af filen. Prøv igen.';
$string['core.errordetailshide'] = 'Skjul fejloplysninger.';
$string['core.errordetailsshow'] = 'Vis fejloplysninger';
$string['core.errordownloading'] = 'Fejl ved download af fil.';
$string['core.errordownloadingsomefiles'] = 'Fejl ved download af filer. Nogle filer mangler måske.';
$string['core.errorfileexistssamename'] = 'Der er allerede en fil med dette navn.';
$string['core.errorinvalidform'] = 'Tjek at alle krævede felter er udfyldt og at værdierne er angivet i det korrekte format.';
$string['core.errorinvalidresponse'] = 'Uventet svar for {{method}} webservice.';
$string['core.errorloadingcontent'] = 'Fejl under indlæsning af indhold.';
$string['core.errorofflinedisabled'] = 'Offline gennemsyn er deaktiveret på dit site. Du skal være forbundet til internettet for at bruge app\'en.';
$string['core.erroropenfiledownloading'] = 'Fejl ved åbning af fil: Du skal vente på at downloaden er færdig.';
$string['core.erroropenfilenoapp'] = 'Fejl ved åbning af fil: intet program fundet der kan åbne denne type fil.';
$string['core.erroropenfilenoextension'] = 'Fejl ved åbning af fil: filen har ingen filendelse.';
$string['core.erroropenpopup'] = 'Denne aktivitet forsøger at åbne en popup. Det understøttes ikke i denne app.';
$string['core.errorrenamefile'] = 'Fejl under omdøbning af filen. Prøv igen.';
$string['core.errorsitesupport'] = 'Hvis problemet bliver ved, så kontakt support.';
$string['core.errorsomedatanotdownloaded'] = 'Hvis du downloader denne aktivitet, vær da opmærksom på. at nogle data ikke downloades af hensyn til ydeevne og dataforbrug.';
$string['core.errorsomethingwrong'] = 'Noget gik galt. Prøv igen.';
$string['core.errorsync'] = 'Der skete en fejl under synkronisering. Prøv igen.';
$string['core.errorsyncblocked'] = '{{$a}} kan ikke synkroniseres lige nu grundet en igangværende proces. Prøv igen senere. Fortsætter problemet, kan du prøve at genstarte appen.';
$string['core.errorurlschemeinvalidscheme'] = 'Denne URL er beregnet til at blive brugt i en anden app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'URL\'en til denne side kan ikke åbnes i denne app.';
$string['core.filenameexist'] = 'Filnavnet eksisterer allerede: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Du er ved at oploade {{size}}. Er du sikker på at du vil fortsætte?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Det var ikke muligt at beregne hvor stor denne upload er. Er du sikker på at du vil fortsætte?';
$string['core.fileuploader.discardrecording'] = 'Fortryd optagelse';
$string['core.fileuploader.errorcapturingaudio'] = 'Fejl ved optagelse af lyd.';
$string['core.fileuploader.errorcapturingimage'] = 'Fejl ved optagelse af billede.';
$string['core.fileuploader.errorcapturingvideo'] = 'Fejl ved optagelse af video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Fejl ved indhentning af billede fra album';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Du skal være online for at uploade filer.';
$string['core.fileuploader.errornoapp'] = 'Du har ikke installeret en app som kan udføre denne handling.';
$string['core.fileuploader.errorreadingfile'] = 'Fejl ved læsning af fil.';
$string['core.fileuploader.errorwhileuploading'] = 'En fejl opstod under upload af filen.';
$string['core.fileuploader.file'] = 'Fil';
$string['core.fileuploader.fileuploaded'] = 'Filen er uploadet.';
$string['core.fileuploader.maxbytesfile'] = 'Filen {{$a.file}} er for stor. Den må ikke fylde mere end {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Tilladelse til at få adgang til mikrofonen er blevet nægtet';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Adgang til mikrofonen er begrænset.';
$string['core.fileuploader.pauserecording'] = 'Sæt optagelse på pause';
$string['core.fileuploader.photoalbums'] = 'Fotoalbum';
$string['core.fileuploader.readingfile'] = 'Læser fil';
$string['core.fileuploader.readingfileperc'] = 'Læser fil: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Genoptag optagelse';
$string['core.fileuploader.selectafile'] = 'Vælg en fil';
$string['core.fileuploader.startrecordinginstructions'] = 'Tryk for at starte optagelse';
$string['core.fileuploader.uploadafile'] = 'Upload en fil';
$string['core.fileuploader.uploading'] = 'Uploader';
$string['core.fileuploader.uploadingperc'] = 'Uploader: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Gå til {{$a}}';
$string['core.h5p.errorgetemail'] = 'Fejl ved indhentning af brugerens e-mail. Kontroller din forbindelse og prøv igen.';
$string['core.h5p.offlinedisabled'] = 'Dette site tillader ikke download af H5P-pakker';
$string['core.h5p.play'] = 'Afspil H5P';
$string['core.hasdatatosync'] = 'Denne {{$a}} har data offline der skal synkroniseres.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Fungerer dette indhold ikke?';
$string['core.image'] = 'Billede';
$string['core.imageviewer'] = 'Billedfremviser';
$string['core.ioscookieshelp'] = 'Indlejret indhold kan kræve cookies for at fungere. Gå til appens iOS-indstillinger, aktiver \'Tillad tværgående webstedssporing\' og prøv igen.';
$string['core.lastdownloaded'] = 'Senest downloadet';
$string['core.lastsync'] = 'Senest synkroniseret';
$string['core.loadmore'] = 'Indlæs mere';
$string['core.login.authenticating'] = 'Godkender';
$string['core.login.changepasswordbutton'] = 'Skift kodeord';
$string['core.login.changepasswordhelp'] = 'Hvis du har problemer med at skifte dit kodeord, så prøv igen senere eller kontakt din skole eller uddannelsesudbyder';
$string['core.login.changepasswordinstructions'] = 'Du kan ikke ændre din adgangskode i appen. Klik venligst på knappen nedenfor for at åbne siden i en webbrowser og ændre din adgangskode. Bemærk, at du efter ændring af adgangskoden skal lukke browseren, da du ikke vil blive omdirigeret tilbage til appen.';
$string['core.login.changepasswordlogoutinstructions'] = 'Hvis du foretrækker at skifte websted eller logge ud, skal du klikke på følgende knap:';
$string['core.login.changepasswordreconnectinstructions'] = 'Hvis du ikke ændrede din adgangskode korrekt, vil du blive bedt om at gøre det igen.';
$string['core.login.changepasswordsupportsubject'] = 'Jeg har brug for hjælp til at skifte min adgangskode';
$string['core.login.confirmdeletesite'] = 'Er du sikker på, at du vil fjerne kontoen på {{sitename}}?';
$string['core.login.connect'] = 'Tilslut!';
$string['core.login.connecttomoodle'] = 'Tilslut til Moodle';
$string['core.login.connecttomoodleapp'] = 'Du forsøger at forbinde til en almindelig Moodle-side. Download den officielle Moodle-app for at få adgang til denne side.';
$string['core.login.connecttoworkplaceapp'] = 'Du forsøger at forbinde til en Moodle Workplace-side. Download Moodle Workplace-appen for at få adgang til denne side';
$string['core.login.contactyouradministrator'] = 'Kontakt administrator for yderligere hjælp';
$string['core.login.contactyouradministratorissue'] = 'Bed administrator om at tjekke følgende: {{$a}}';
$string['core.login.credentialsdescription'] = 'Skriv dit brugernavn og adgangskode for at logge på';
$string['core.login.credentialshelp'] = 'Hvis du har problemer med at logge ind, så prøv igen senere eller kontakt din skole eller uddannelsesudbyder';
$string['core.login.credentialssupportsubject'] = 'Jeg har brug for hjælp til at logge ind';
$string['core.login.emailconfirmsentnoemail'] = '<p>Du har fået tilsendt en mail.</p><p>Den indeholder nemme instruktioner til at gennemføre din registrering..</p>';
$string['core.login.emailnotmatch'] = 'Mailadresserne matcher ikke';
$string['core.login.erroraccesscontrolalloworigin'] = 'Det Cross-Origin opkald du forsøger at udføre er blevet afvist. Kontroller https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'En fejl opstod ved sletning af denne konto. Prøv igen.';
$string['core.login.errorexampleurl'] = 'URL\'en https://campus.example.edu er kun et eksempel på en URL, det er ikke en rigtig side. <strong>Brug URL\'en fra din skole eller organisations side.</strong>';
$string['core.login.errorqrnoscheme'] = 'Denne URL er ikke en gyldig login-URL.';
$string['core.login.errorupdatesite'] = 'En fejl opstod under opdatering af webstedets token.';
$string['core.login.exceededloginattempts'] = 'Har du brug for hjælp til at logge ind? Prøv {{recoverPassword}} eller kontakt sidens support.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'gendannelse af din adgangskode';
$string['core.login.exceededloginattemptssupportsubject'] = 'Jeg kan ikke logge ind';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Har du brug for hjælp til at logge ind? Prøv at kontakte sidens support.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Har du brug for hjælp til at logge ind? Prøv {{recoverPassword}}';
$string['core.login.exceededpasswordresetattempts'] = 'Det ser ud til, at du har problemer med at få adgang til din konto. Du kan kontakte din skole eller uddannelsesudbyder eller prøve igen senere.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Jeg kan ikke nulstille mit kodeord';
$string['core.login.faqcannotconnectanswer'] = 'Kontakt sidens administrator';
$string['core.login.faqcannotconnectquestion'] = 'Jeg indtastede min webadresse korrekt, men jeg kan stadig ikke oprette forbindelse.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Hvis du har forsøgt at søge efter webadressen (URL) og stadig ikke kan finde din Moodle-side, bedes du kontakte den person, der tager sig af Moodle på din skole eller uddannelsesorganisation.';
$string['core.login.faqcannotfindmysitequestion'] = 'Jeg kan ikke finde min side via webadressen (URL).';
$string['core.login.faqcantloginanswer'] = 'Når du først har forbindelse til din Moodle-side, bør du kunne logge ind med dit sædvanlige brugernavn og adgangskode.</p><br><p>Hvis du har glemt dit brugernavn eller adgangskode, skal du vælge muligheden <strong>Har du glemt dit brugernavn eller adgangskode?</strong>. Hvis du stadig har problemer med at logge ind eller ikke kan se nogen muligheder for at gendanne dit brugernavn eller adgangskode, bedes du kontakte den person, der tager sig af Moodle på din skole eller uddannelsesorganisation.</p>';
$string['core.login.faqcantloginquestion'] = 'Jeg kan ikke logge ind.';
$string['core.login.faqmore'] = 'Tjek <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">vores ofte stillede spørgsmål (FAQ)</a> for flere svar.';
$string['core.login.faqsetupsiteanswer'] = 'Besøg {{$link}} for at se de forskellige muligheder du har for at oprette din egen Moodle side.';
$string['core.login.faqsetupsitelinktitle'] = 'Kom i gang.';
$string['core.login.faqsetupsitequestion'] = 'Jeg vil opsætte min egen Moodle-side.';
$string['core.login.faqtestappanswer'] = 'For at teste appen på en Moodle demo-side skal du indtaste "teacher" eller "student" i <strong>Din side</strong>-feltet og trykke på <strong>Opret forbindelse til din side</strong>.';
$string['core.login.faqtestappquestion'] = 'Kan jeg teste appen på en demo side?';
$string['core.login.faqwhatisurlanswer'] = '<p>Hvis du ikke kan finde din side ved hjælp af navn, skal du prøve at søge ved hjælp af din Moodle-sides webadresse (URL) i stedet.</p><p>For at finde din webadresse:</p><ol><li>Åbn en webbrowser og gå til din Moodle-sides login-side.</li><li>Øverst på siden, i adressefeltet, vil du se webadressen til din Moodle-side, f.eks. "campus.example.edu".<br>{{$image}}</li><li>Kopier webadressen (kopier ikke /login eller det der kommer efter), indsæt den i <strong>Din side</strong> i appen, og tryk derefter på <strong>Opret forbindelse til din side</strong></li><li>Nu kan du logge ind på din side med dit brugernavn og adgangskode.</li></ol><p>Hvis du har forsøgt at søge via webadresse og stadig ikke kan finde din Moodle-side, bedes du kontakte den person, der tager sig af Moodle på din skole eller uddannelsesorganisation.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Hvordan kan jeg finde min side?';
$string['core.login.faqwhereisqrcode'] = 'Hvor kan jeg finde min QR kode?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Hvis din skole eller uddannelsesudbyder har aktiveret det, vil du finde en QR-kode på hjemmesiden nederst på din brugerprofilside.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Find dit site';
$string['core.login.helpmelogin'] = '<p>Der er mange tusinde Moodlesites rundt omkring i verden. Denne app kan kun anvendes på sites, der specifikt har aktiveret app-adgang.</p><p>Hvis du ikke kan tilgå dit Moodlesite, kan du kontakte din siteadministrator og gøre opmærksom på siden <a href="https://docs.moodle.org/en/Mobile_app" target="_blank">https://docs.moodle.org/en/Mobile_app</a></p><p>App\'en kan testes på et Moodle-demosite ved at skrive <i>teacher</i> elller<i>student</i> i feltet <i>Site address</i> og klikke på knappen <b>Forbind</b>.</p>';
$string['core.login.invalidaccount'] = 'Kontroller dine loginoplysninger og prøv igen.';
$string['core.login.invalidmoodleversion'] = 'Versionen af dette Moodle-site er for gammel. Moodle-appen fungerer med sider, der bruger {{$a}} eller nyere.';
$string['core.login.invalidsite'] = 'Denne webadresse er ugyldig.';
$string['core.login.invalidtime'] = 'Ugyldigt klokkeslæt';
$string['core.login.invalidvaluemax'] = 'Højeste værdi er {{$a}}';
$string['core.login.invalidvaluemin'] = 'Mindste værdi er {{$a}}';
$string['core.login.loggedoutssodescription'] = 'Du skal godkende dig igen. Du skal logge ind på siden i et browser-vindue.';
$string['core.login.loginbutton'] = 'Login';
$string['core.login.logininsiterequired'] = 'Du skal logge på websiden via en browser';
$string['core.login.mobileservicesnotenabled'] = 'Mobiltjenester er ikke aktiveret på webstedet.';
$string['core.login.notloggedin'] = 'Du skal være logget på.';
$string['core.login.onboardingcreatemanagecourses'] = 'Opret og administrer dine kurser.';
$string['core.login.onboardingenrolmanagestudents'] = 'Tilmeld og administrer dine studerende.';
$string['core.login.onboardinggetstarted'] = 'Kom i gang med Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Jeg har allerede en Moodle side';
$string['core.login.onboardingimalearner'] = 'Jeg er kursist';
$string['core.login.onboardingimaneducator'] = 'Jeg er underviser';
$string['core.login.onboardingineedasite'] = 'Jeg har brug for en Moodle side';
$string['core.login.onboardingprovidefeedback'] = 'Giv rettidig feedback.';
$string['core.login.onboardingtoconnect'] = 'For at forbinde til Moodle-appen skal du have en Moodle-side';
$string['core.login.onboardingwelcome'] = 'Velkommen til Moodle-appen!';
$string['core.login.or'] = 'ELLER';
$string['core.login.passwordrequired'] = 'Adgangskode kræves';
$string['core.login.policyacceptmandatory'] = 'Jeg forstår og accepterer de obligatoriske webstedsregler.';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA-billede';
$string['core.login.recaptchaexpired'] = 'Verifikationen udløb. Besvar sikkerhedsspørgsmålet igen.';
$string['core.login.recaptchaincorrect'] = 'Svaret på sikkerhedsspørgsmålet er forkert.';
$string['core.login.reconnect'] = 'Genopret forbindelse';
$string['core.login.reconnecthelp'] = 'Hvis du har problemer med at genoprette forbindelsen, så prøv igen senere eller kontakt din skole eller uddannelsesudbyder.';
$string['core.login.reconnectssodescription'] = 'Din session er udløbet. Log ind igen via en browser og fortsæt.';
$string['core.login.reconnectsupportsubject'] = 'Brug for hjælp til at genoprette forbindelsen';
$string['core.login.reconnecttosite'] = 'Genopret forbindelsen';
$string['core.login.removeaccount'] = 'Fjern konto';
$string['core.login.searchby'] = 'Søg efter:';
$string['core.login.selectsite'] = 'Vælg din konto:';
$string['core.login.signupplugindisabled'] = '{{$a}} er ikke aktiveret.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Tilmeldingsformularen indeholder et påkrævet brugerdefineret felt, som ikke understøttes i appen. Opret din konto ved hjælp af en webbrowser.';
$string['core.login.siteaddress'] = 'Dit websted';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Der er  {{count}} ulæste notifikationer.';
$string['core.login.sitehasredirect'] = 'Din side indeholder mindst en HTTP-omdirigering. Appen kan ikke følge omdirigeringer, og det kan være årsagen til, at appen ikke kan oprette forbindelse til din side.';
$string['core.login.siteinmaintenance'] = 'Dit websted er i vedligeholdelsestilstand';
$string['core.login.sitenotallowed'] = 'Denne side er ikke længere tilgængelig.';
$string['core.login.sitepolicynotagreederror'] = 'Webstedsregler ikke accepteret.';
$string['core.login.siteurl'] = 'Webadresse';
$string['core.login.siteurlrequired'] = 'Webside-URL kræves, f.eks.  <i>http://www.dinmoodle.dk eller https://www.dinmoodle.dk</i>';
$string['core.login.stillcantconnect'] = 'Stadig ingen forbindelse?';
$string['core.login.toggleremove'] = 'Rediger kontoliste';
$string['core.login.usernamerequired'] = 'Brugernavn kræves';
$string['core.login.visitchangepassword'] = 'Vil du besøge siden for at ændre adgangskoden?';
$string['core.login.webservicesnotenabled'] = 'Web Services er ikke aktiveret på sitet.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Du kan stadig oprette forbindelse til siden ved at indtaste dit brugernavn og adgangskode.';
$string['core.login.yourenteredsite'] = 'Opret forbindelse til din side.';
$string['core.lostconnection'] = 'Din session er udløbet. Log ind igen for at fortsætte.';
$string['core.mainmenu.switchaccount'] = 'Skift konto';
$string['core.mainmenu.usermenutourdescription'] = 'Stedet, hvor du kan tjekke dine karakterer, ændre dine præferencer eller skifte konti.';
$string['core.mainmenu.usermenutourtitle'] = 'Udforsk dit personlige område.';
$string['core.needhelp'] = 'Brug for hjælp?';
$string['core.networkerroriframemsg'] = 'Dette indhold er ikke tilgængeligt offline. Forbind til internettet og prøv igen.';
$string['core.networkerrormsg'] = 'Der var problemer med at tilslutte til webstedet. Tjek din forbindelse og prøv igen.';
$string['core.nooptionavailable'] = 'Ingen tilgængelig mulighed.';
$string['core.nopasswordchangeforced'] = 'Du kan ikke fortsætte uden at ændre din adgangskode.';
$string['core.nopermissionerror'] = 'Beklager, men du har i øjeblikket ikke tilladelse til at gøre det.';
$string['core.notapplicable'] = 'n/a';
$string['core.notdownloadable'] = 'Kan ikke downloades';
$string['core.notsent'] = 'Ikke sendt';
$string['core.nummore'] = '{{$a}} flere';
$string['core.openfile'] = 'Åbn fil';
$string['core.openfullimage'] = 'Klik her for at vise billedet i fuld størrelse.';
$string['core.openinbrowser'] = 'Åbn i browser';
$string['core.openinbrowserdescription'] = 'Du vil blive taget til en ny browser';
$string['core.openmodinbrowser'] = 'Åbn {{$a}} i browseren';
$string['core.opensecurityquestion'] = 'Åben sikkerhedsspørgsmål';
$string['core.opensettings'] = 'Åben indstillinger';
$string['core.openwith'] = 'Åben med...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Play';
$string['core.pulltorefresh'] = 'Træk for at opdatere';
$string['core.qrscanner'] = 'QR-scanner';
$string['core.question.cannotdeterminestatus'] = 'Kan ikke bestemme status';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Dit site understøtter endnu ikke vedhæftning af filer til svar.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Dit site understøtter endnu ikke redigering af indlejrede filer.';
$string['core.question.errorquestionnotsupported'] = 'Appen understøtter ikke denne type spørgsmål: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tryk for at vælge, og tryk derefter for at slippe.';
$string['core.question.questionmessage'] = 'Spørgsmål {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Du bliver videresendt til siden';
$string['core.reminders.atthetime'] = 'På tidspunktet for eventet';
$string['core.reminders.custom'] = 'Brugerdefinerede...';
$string['core.reminders.customreminder'] = 'Brugerdefineret påmindelse';
$string['core.reminders.delete'] = 'Slet påmindelse';
$string['core.reminders.reminderset'] = 'Påmindelse sat til {{a}}';
$string['core.reminders.reminderunset'] = 'Påmindelse slettet';
$string['core.reminders.setareminder'] = 'Indstil en påmindelse';
$string['core.reminders.setareminderfor'] = 'Indstil en påmindelse for "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Indstil påmindelse';
$string['core.reminders.timebefore'] = '{{value}} {{units}} før';
$string['core.reminders.value'] = 'Værdi';
$string['core.removefiles'] = 'Fjern filer  {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Der kan være anvendt filtre på denne visning. For at redigere filtre eller ændre sorteringsrækkefølgen skal du <a href="{{$a}}">åbne denne rapport i din browser.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Skjul kolonner';
$string['core.reportbuilder.showcolumns'] = 'Vis kolonner';
$string['core.requireduserdatamissing'] = 'Denne bruger mangler nogle krævede profildata. Udfyld de manglende data i din Moodle og prøv igen.<br>{{$a}}';
$string['core.resume'] = 'Resume';
$string['core.retry'] = 'Prøv igen';
$string['core.scanqr'] = 'Scan QR-kode';
$string['core.scrollbackward'] = 'Scroll tilbage';
$string['core.scrollforward'] = 'Scroll fremad';
$string['core.search.allcategories'] = 'Alle kategorier';
$string['core.search.empty'] = 'Hvad søger du efter?';
$string['core.search.filtercategories'] = 'Filtrer resultater efter';
$string['core.search.filtercourses'] = 'Søg i';
$string['core.search.noresults'] = 'Ingen resultater for "{{$a}}"';
$string['core.search.noresultshelp'] = 'Tjek for stavefejl eller prøv andre nøgleord';
$string['core.search.resultby'] = 'Af {{$a}}';
$string['core.searching'] = 'Søger';
$string['core.serverconnection'] = 'Fejl ved forbindelse til serveren: {{details}}';
$string['core.settings.about'] = 'Om';
$string['core.settings.appsettings'] = 'App-indstillinger';
$string['core.settings.appversion'] = 'App-version';
$string['core.settings.cannotsyncloggedout'] = 'Dette websted kan ikke synkroniseres, fordi du er logget ud. Prøv igen, når du er logget ind på siden.';
$string['core.settings.cannotsyncoffline'] = 'Site-synkronisering mislykkedes, fordi din enhed ikke er forbundet til internettet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Din enhed er ikke forbundet til Wi-Fi. Opret forbindelse til et Wi-Fi-netværk, eller slå Data Saver fra i appens indstillinger.';
$string['core.settings.changelanguage'] = 'Skift til {{$a}}';
$string['core.settings.changelanguagealert'] = 'Ændring af sproget genstarter appen.';
$string['core.settings.colorscheme'] = 'Farveskema';
$string['core.settings.colorscheme-dark'] = 'Mørk';
$string['core.settings.colorscheme-light'] = 'Lyst';
$string['core.settings.colorscheme-system'] = 'System standard';
$string['core.settings.colorscheme-system-notice'] = 'Systemets standardtilstand afhænger af din enhedsunderstøttelse.';
$string['core.settings.compilationinfo'] = 'Oplysninger om kompilering';
$string['core.settings.connecttosync'] = 'Din enhed er offline. Opret forbindelse til internettet for at synkronisere.';
$string['core.settings.connectwifitosync'] = 'Opret forbindelse til et Wi-Fi-netværk, eller deaktiver Datasparefunktion for at synkronisere.';
$string['core.settings.copyinfo'] = 'Kopier enhedsoplysninger på udklipsholderen';
$string['core.settings.cordovadevicemodel'] = 'Cordova Device model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova Device OS version';
$string['core.settings.cordovadeviceplatform'] = 'Cordova Device platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['core.settings.cordovaversion'] = 'Cordova version';
$string['core.settings.debugdisplaydescription'] = 'Hvis det er aktiveret, vil fejlmodaler vise flere data om fejlen, hvis det er muligt.';
$string['core.settings.developeroptions'] = 'Udviklermuligheder';
$string['core.settings.deviceinfo'] = 'Enhedsinfo';
$string['core.settings.deviceos'] = 'Enheds operativsystem';
$string['core.settings.displayformat'] = 'Vis format';
$string['core.settings.enableanalytics'] = 'Aktiver analyser';
$string['core.settings.enableanalyticsdescription'] = 'Hvis aktiveret, vil appen indsamle anonym brugsdata.';
$string['core.settings.enabledownloadsection'] = 'Aktiver download af sektioner';
$string['core.settings.enablefirebaseanalytics'] = 'Aktiver Firebase-analyse';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Hvis aktiveret, vil appen indsamle anonymt dataforbrug.';
$string['core.settings.enablerichtexteditor'] = 'Aktiver teksteditor';
$string['core.settings.enablerichtexteditordescription'] = 'Hvis den er aktiveret, vil en teksteditor være tilgængelig, når du indtaster indhold.';
$string['core.settings.enablesyncwifi'] = 'Tillad kun synkronisering når tilsluttet Wi-Fi';
$string['core.settings.encryptedpushsupported'] = 'Krypterede push-meddelelser understøttes';
$string['core.settings.entriesincache'] = '{{$a}} poster i cachen';
$string['core.settings.errorsyncsite'] = 'Fejl ved synkronisering. Kontroller din Internetforbindelse og prøv igen.';
$string['core.settings.estimatedfreespace'] = 'Beregnet ledig plads';
$string['core.settings.filesystemroot'] = 'Filsystemets rod';
$string['core.settings.fontsize'] = 'Tekststørrelse';
$string['core.settings.forcedsetting'] = 'Denne indstilling er blevet tvunget af din webstedskonfiguration.';
$string['core.settings.helpusimprove'] = 'Hjælp os med at forbedre denne App';
$string['core.settings.ioscookies'] = 'Sporing på tværs af websteder';
$string['core.settings.ioscookiesdescription'] = 'Indlejret indhold fra webstedet kræver muligvis cookies på tværs af websteder for at fungere. For at aktivere det skal du gå til appens iOS-indstillinger og aktivere \'Tillad sporing på tværs af websteder\'.';
$string['core.settings.legaldisclaimer'] = 'Juridisk ansvarsfraskrivelse';
$string['core.settings.localnotifavailable'] = 'Lokale meddelelser tilgængelige';
$string['core.settings.locationhref'] = 'URL til webvisning';
$string['core.settings.logintosync'] = 'Log ind for at synkronisere';
$string['core.settings.navigatorlanguage'] = 'Navigatorsprog';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Status for internetforbindelse';
$string['core.settings.opensourcelicenses'] = 'Open Source-licenser';
$string['core.settings.privacypolicy'] = 'Privatlivspolitik';
$string['core.settings.publisher'] = 'Udgiver';
$string['core.settings.pushid'] = 'Push-meddelelses-id';
$string['core.settings.reportinbackground'] = 'Anmeld fejl automatisk';
$string['core.settings.screen'] = 'Skærminformationer';
$string['core.settings.showdownloadoptions'] = 'Vis downloadmuligheder';
$string['core.settings.siteinfo'] = 'Webstedsinformationer';
$string['core.settings.sitesyncfailed'] = 'Synkronisering af websted mislykkedes';
$string['core.settings.spaceusage'] = 'Pladsforbrug';
$string['core.settings.syncdatasaver'] = 'Databesparelse: Synkroniser kun, når du er på Wi-Fi';
$string['core.settings.synchronization'] = 'Synkronisering';
$string['core.settings.synchronizenow'] = 'Synkroniser nu';
$string['core.settings.synchronizenowhelp'] = 'Synkronisering af et websted vil sende afventende ændringer og al offline aktivitet, der er gemt på enheden, og vil synkronisere nogle data som meddelelser og meddelelser.';
$string['core.settings.syncsettings'] = 'Indstilling for synkronisering';
$string['core.settings.wificonnection'] = 'WiFi-forbindelse';
$string['core.settings.youradev'] = 'Du er nu udvikler';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Vælg den konto filen skal gemmes under.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Der er allerede en fil med dette navn. Vil du erstatte den eller omdøbe den til "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Der er ingen websteder gemt. Tilføj et websted, før du deler en fil med appen.';
$string['core.sharedfiles.nosharedfiles'] = 'Der er ikke gemt nogen delte filer på dette websted.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Du har ingen filer at uploade her. Hvis du vil uploade en fil fra en anden app, skal du finde filen og klikke på knappen \'Åbn i\'.';
$string['core.sharedfiles.rename'] = 'Omdøb';
$string['core.sharedfiles.replace'] = 'Erstat';
$string['core.sharedfiles.sharedfiles'] = 'Delte filer';
$string['core.sharedfiles.successstorefile'] = 'Filen er gemt. Vælg den fil, du vil uploade til dine private filer eller bruge i en aktivitet.';
$string['core.sitenotfound'] = 'Siden blev ikke fundet';
$string['core.sitenotfoundhelp'] = 'Vi kan ikke finde det websted, du indtastede. Tjek for tastefejl, eller prøv igen senere. Hvis du bliver ved med at se denne meddelelse, skal du kontakte din skole eller uddannelsesudbyder.';
$string['core.siteunavailablehelp'] = 'Siden "{{site}}" er ikke tilgængelig lige nu. Prøv igen senere, eller kontakt din skole eller uddannelsesudbyder.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Beklager...';
$string['core.start'] = 'Start';
$string['core.startingtime'] = 'Starttidspunkt: {{$a}}';
$string['core.storingfiles'] = 'Gemmer filer';
$string['core.swipenavigationtourdescription'] = 'Stryg til venstre og højre for at navigere rundt.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Dette tagområde understøttes ikke af appen.';
$string['core.tag.tagareabadgedescription'] = 'Der er {{count}} elementer.';
$string['core.tag.warningareasnotsupported'] = 'Nogle af tagområderne vises ikke, fordi de ikke understøttes af appen.';
$string['core.thereisdatatosync'] = 'Der er {{$a}} offline der skal synkroniseres.';
$string['core.toggledelete'] = 'Skift sletteknapper';
$string['core.tryagain'] = 'Prøv igen';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Uh oh!';
$string['core.unexpectederror'] = 'Uventet fejl. Luk og åben programmet igen i et nyt forsøg.';
$string['core.unicodenotsupported'] = 'Nogle smilies supporteres ikke på dette websted, og de vil blive fjernet når beskeden sendes.';
$string['core.unicodenotsupportedcleanerror'] = 'Der blev fundet tom tekst ved rensning af Unicode-tegn.';
$string['core.unknown'] = 'Ukendt';
$string['core.unzipping'] = 'Udpakker';
$string['core.updaterequired'] = 'App-opdatering påkrævet';
$string['core.updaterequireddesc'] = 'Opdater din App til version {{$a}}';
$string['core.user.completeprofile'] = 'Udfyld profil';
$string['core.user.completeprofilehelp'] = 'Hvis du har problemer med at udfylde din profil, kan du prøve igen senere eller kontakte din skole eller uddannelsesudbyder.';
$string['core.user.completeprofilenotice'] = 'Inden du fortsætter, skal du udfylde de påkrævede felter i din brugerprofil.';
$string['core.user.completeprofilereconnectinstructions'] = 'Hvis du ikke udfyldte din profil korrekt, bliver du bedt om at gøre det igen.';
$string['core.user.completeprofilesupportsubject'] = 'Har brug for hjælp til at udfylde min profil';
$string['core.user.completeyourprofile'] = 'Udfyld din profil';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Denne brugers data er ikke tilgængelige for dig.';
$string['core.user.errorloaduser'] = 'Fejl ved indlæsning af bruger.';
$string['core.user.sendemail'] = 'E-mail';
$string['core.user.support'] = 'Kontakt webstedssupport';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Bruger med ID {{id}}';
$string['core.usernologin'] = 'Godkendelse er blevet tilbagekaldt for denne konto';
$string['core.viewcode'] = 'Vis kode';
$string['core.vieweditor'] = 'Vis editor';
$string['core.viewembeddedcontent'] = 'Se indlejret indhold';
$string['core.wanttochangesite'] = 'Vil du skifte websted eller logge ud?';
$string['core.warningofflinedatadeleted'] = 'Offline ændringer til {{component}} \'{{name}}\' er blevet kasseret. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Nyere ændringer til denne aktivitet er foretaget fra en anden enhed.';
$string['core.warnopeninbrowser'] = '<p>Du er ved at forlade appen for at åbne følgende URL i din enheds browser. Vil du fortsætte?</p>
<p><b>{{url}}</b></p>';
$string['core.whoissiteadmin'] = '"Webstedsadministratorer" er de personer, der administrerer Moodle på din skole/universitet/virksomhed eller læringsorganisation. Hvis du ikke ved, hvordan du kan kontakte dem, bedes du kontakte dine lærere/trænere.';
$string['core.whyisthishappening'] = 'Hvorfor sker dette?';
$string['core.wsfunctionnotavailable'] = 'Denne webservicefunktion er ikke tilgængelig.';
$string['core.youreoffline'] = 'Din enhed er offline';
$string['core.youreonline'] = 'Din enhed er online igen';
$string['core.zoomin'] = 'Zoom ind';
$string['core.zoomout'] = 'Zoom ud';
$string['freemium.autologoutclosingtheapp'] = 'Umiddelbart efter at have forladt appen';
$string['freemium.autologoutcustomtime'] = 'Brugerdefineret tid efter at have forladt appen';
$string['freemium.autologoutdefault'] = 'Standard';
$string['freemium.autologouttitle'] = 'Automatisk logud på denne enhed';
$string['freemium.biometriclogin'] = 'Biometrisk login';
$string['freemium.biometriclogindescription'] = 'Placér din finger på fingeraftrykslæseren.';
$string['freemium.biometricloginenablefaceid'] = 'Aktiver FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Aktiver fingeraftryk';
$string['freemium.biometricloginenabletouchid'] = 'Aktiver TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Login med FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Login med fingeraftryk';
$string['freemium.biometricloginloginwithtouchid'] = 'Login med TouchID';
$string['freemium.biometricloginskip'] = 'Spring over for nu';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} aktiveret.';
$string['freemium.biometricloginturnoff'] = 'Du kan til enhver tid slå denne funktion til og fra under indstillinger.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Fingeraftryk';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Brug biometrisk login med dit fingeraftryk eller dit ansigt.';
$string['freemium.change'] = 'Ændre';
$string['freemium.coursesbatchdownloaddisabled'] = 'Download af kurser i batch er ikke aktiveret på dette websted.';
$string['freemium.coursesdownloadlimitreached'] = 'Kursernes downloadgrænse er nået! Du kan kun have {{limit}} kurser downloadet. Kontakt din administrator for at øge denne grænse eller fjern nogle downloadede kurser fra din enhed.';
$string['freemium.downloadmainapplicationrequired'] = 'Du kan kun forbinde til dette websted ved hjælp af den dedikerede app.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Det websted, du forsøger at forbinde til, har en dedikeret app, som du måske ønsker at prøve.';
$string['freemium.feature_autologout'] = 'Automatisk logud';
$string['freemium.feature_biometriclogin'] = 'Biomestrisk';
$string['freemium.feature_coursesdownload'] = 'Biometrisk login';
$string['freemium.feature_multimediapushnotifications'] = 'Multimedie-pushnotifikationer';
$string['freemium.feature_pushnotificationsdevices'] = 'Enheder til pushnotifikationer';
$string['freemium.feature_qrlogin'] = 'Godkend ved hjælp af en QR-kode';
$string['freemium.feature_remotethemes'] = 'Fjernbetjente temaer';
$string['freemium.feature_sitelogo'] = 'Webstedets logo';
$string['freemium.notallowed'] = 'Ikke tilladt';
$string['freemium.nottoday'] = 'Ikke i dag';
$string['freemium.qrlogindisabled'] = 'Godkendelse i appen ved brug af en QR-kode er ikke aktiveret for webstedet:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'QR-koden er udløbet. Opdater siden med QR-koden og scan den igen.';
$string['freemium.qrloginipmismatch'] = 'Den enhed, du bruger til at forbinde, ser ikke ud til at være på det samme netværk som enheden, der viser QR-koden. Sørg for, at begge enheder er forbundet til det samme netværk (f.eks. det samme WiFi-netværk).<br><br>Hvis fejlen fortsætter, bedes du kontakte din webstedsadministrator.';
$string['freemium.ratetheapp'] = 'Er du tilfreds vores app?';
$string['freemium.ratetheapp_feedbackko'] = 'Fortæl os hvad der er galt';
$string['freemium.ratetheapp_feedbackmessage'] = 'Din feedback vil være anonym';
$string['freemium.ratetheapp_feedbackok'] = 'Send feedback';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Skriv noget her';
$string['freemium.ratetheapp_feedbacksent'] = 'Tak! Din feedback er blevet sendt';
$string['freemium.ratetheapp_sendtostore'] = 'Kan du tage et øjeblik til at bedømme vores app? Det vil hjælpe os med at forbedre appen.';
$string['freemium.remindmelater'] = 'Påmind mig senere';
$string['freemium.settingsoptions_autologout'] = 'log ud automatisk';
$string['freemium.settingsoptionsfacial'] = 'Aktivér ansigtslogin';
$string['freemium.settingsoptionsfingerprint'] = 'Aktivér fingeraftrykslogin';
$string['freemium.subscription'] = 'Websted abonnement';
$string['freemium.subscriptiondetails'] = 'Abonnementsdetaljer';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} brugerdefinerede sprogstrenge ignoreres';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} brugerdefinerede menupunkter ignoreres';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} konfigurerede deaktiverede funktioner er stadig aktiverede.';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Dit brugerdefinerede tema bliver ikke anvendt';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Dit webstedlogo bliver ikke anvendt';
$string['freemium.subscriptionfeature_limited'] = 'Begrænset til {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Ubegrænset';
$string['freemium.subscriptionplan'] = 'Abonnementsplan';
$string['freemium.subscriptionplan_bma'] = 'Brandet Moodle-app';
$string['freemium.subscriptionplan_expired'] = 'udløbet';
$string['freemium.subscriptionplan_free'] = 'Gratis';
$string['freemium.subscriptionplan_premium'] = 'Premium';
$string['freemium.subscriptionplan_pro'] = 'Pro';
$string['freemium.subscriptionplan_upgrade'] = 'Opgrader dit abonnement';
$string['freemium.subscriptionplan_validuntil'] = 'gyldig indtil {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Abonnementsplanerne angiver, hvilke begrænsninger der gælder for dette websted.';
$string['freemium.subscriptionplanlearnmore'] = 'Lær mere';
$string['freemium.upsell_renewexpired'] = 'Dit abonnement er udløbet';
$string['freemium.upsell_renewexpiring'] = 'Dit abonnement vil udløbe om {{ days }} dage';
$string['freemium.upsell_renewtitle'] = 'Forny dit abonnement';
$string['freemium.upsell_upgradefreeaccept'] = 'Opgrader';
$string['freemium.upsell_upgradefreemessage'] = 'Du er i øjeblikket på den gratis plan. Opgradér for at låse op for flere funktioner.';
$string['freemium.upsell_upgradefreepostpone'] = 'Senere';
$string['freemium.upsell_upgradefreetitle'] = 'Opgrader din plan';
$string['pluginname'] = 'Moodle App-sprogstrenge';
$string['privacy_metadata'] = 'Dette plugin gemmer ikke nogen brugerdata.';
$string['workplace.teams.isoverdue'] = 'Har forfaldne eller udløbne emner';
