<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'lo', version '4.2'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'ສຳເລັດຂະບວນການສຳຮອງຂໍ້ມູນແລ້ວ';
$string['asyncbackupcompletebutton'] = 'ສືບຕໍ່';
$string['asyncbackupcompletedetail'] = 'ຂະບວນການສໍາຮອງຂໍ້ມູນໄດ້ສໍາເລັດສົມບູນ. <br/> ທ່ານສາມາດເຂົ້າເຖິງການສໍາຮອງຂໍ້ມູນໃນ <a href="{$a}">ໜ້າການຟື້ນຟູ.</a>';
$string['asyncbackuperror'] = 'ຂະບວນການສຳຮອງຂໍ້ມູນລົ້ມເຫຼວ';
$string['asyncbackuperrordetail'] = 'ຂະບວນການສຳຮອງຂໍ້ມູນລົ້ມເຫຼວ. ກະລຸນາຕິດຕໍ່ຜູ້ຄວບຄຸມລະບົບຂອງທ່ານ.';
$string['asyncbackuppending'] = 'ຂະບວນການສຳຮອງຂໍ້ມູນຍັງລໍຖ້າ';
$string['asyncbackupprocessing'] = 'ກຳລັງດຳເນີນການສຳຮອງຂໍ້ມູນ';
$string['asyncbadexecution'] = 'ການປະຕິບັດຕົວຄວບຄຸມການສຳຮອງຂໍ້ມູນບໍ່ດີ. ມັນແມ່ນ {$a} ແລະ ຄວນເປັນ 2.';
$string['asynccheckprogress'] = 'ທ່ານສາມາດກວດສອບຂະບວນການໃນເວລາໃດກໍ່ໄດ້ເທິງ <a href="{$a}">ໜ້າກູ້ຄືນ</a>.';
$string['asyncemailenable'] = 'ເປີດໃຊ້ງານການແຈ້ງການຂໍ້ຄວາມ';
$string['asyncemailenabledetail'] = 'ຖ້າເປີດໃຊ້ງານ, ຜູ້ໃຊ້ຈະໄດ້ຮັບຂໍ້ຄວາມເມື່ອສຳເລັດການສໍາຮອງຂໍ້ມູນ ຫຼື ການກູ້ຂໍ້ມູນແບບຕ່າງເວລາ.';
$string['asyncgeneralsettings'] = 'ການສຳຮອງຂໍ້ມູນ/ການກູ້ຄືນປະສານຕ່າງເວລາ';
$string['asyncmessagebody'] = 'ຂໍ້ຄວາມ';
$string['asyncmessagebodydefault'] = 'ສະບາຍດີ {user_firstname},<br/> {operation} (ລະຫັດປະຈຳຕົວ: {backupid}) ຂອງທ່ານສຳເລັດສົມບູນແລ້ວ. <br/><br/>ທ່ານສາມາດເຂົ້າຫາມັນທີ່ນີ້: {link}.';
$string['asyncmessagebodydetail'] = 'ຂໍ້ຄວາມທີ່ຈະສົ່ງເມື່ອການສໍາຮອງຂໍ້ມູນປະສານຕ່າງເວລາ ຫຼື ການກູ້ຄືນສໍາເລັດ.';
$string['asyncmessagesubject'] = 'ວິຊາ';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} ໄດ້ສຳເລັດຢ່າງສົມບູນ';
$string['asyncmessagesubjectdetail'] = 'ວິຊາຂໍ້ຄວາມ';
$string['asyncnowait'] = 'ທ່ານບໍ່ຈຳເປັນຕ້ອງລໍຖ້າທີ່ນີ້, ເພາະວ່າ ຂະບວນການຈະສືບຕໍ່ຢູ່ໃນພື້ນຫຼັງ.';
$string['asyncprocesspending'] = 'ຂະບວນການລໍຖ້າ';
$string['asyncrestorecomplete'] = 'ສຳເລັດຂະບວນການກູ້ຄືນແລ້ວ';
$string['asyncrestorecompletebutton'] = 'ສືບຕໍ່';
$string['asyncrestorecompletedetail'] = 'ຂະບວນການກູ້ຄືນໄດ້ສໍາເລັດສົມບູນ. ການຄລິກສືບຕໍ່ຈະພາທ່ານໄປຫາ <a href="{$a}">ລາຍວິຊາສໍາລັບລາຍການທີ່ກູ້ຄືນ.</a>';
$string['asyncrestoreerror'] = 'ລົ້ມເຫຼວໃນການກູ້ຄືນຂະບວນການ';
$string['asyncrestoreerrordetail'] = 'ຂະບວນການກູ້ຄືນລົ້ມເຫຼວ. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບຂອງທ່ານ.';
$string['asyncrestoreinprogress'] = 'ກຳລັງດຳເນີນການກູ້ຄືນ';
$string['asyncrestoreinprogress_help'] = 'ການກູ້ຄືນລາຍວິຊາທີ່ປະສານໃນເວລາຕ່າງກັນທີ່ກໍາລັງດໍາເນີນແມ່ນສະແດງຢູ່ທີ່ນີ້.';
$string['asyncrestorepending'] = 'ກຳລັງດຳເນີນການກູ້ຄືນແມ່ນລໍຖ້າ';
$string['asyncrestoreprocessing'] = 'ກຳລັງດຳເນີນການກູ້ຄືນ';
$string['asyncreturn'] = 'ກັບຄືນສູ່ລາຍວິຊາ';
$string['autoactivedescription'] = 'ເລືອກວ່າຈະເຮັດການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດຫຼືບໍ່. ຖ້າຫາກວ່າ ໄດ້ເລືອກເຮັດດ້ວຍຕົວເອງ ການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດຈະເປັນໄປໄດ້ພຽງແຕ່ໂດຍຜ່ານການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດສະຄຣິບ CLI. ສິ່ງນີ້ສາມາດເຮັດໄດ້ບໍ່ວ່າຈະດ້ວຍຕົນເອງໃນເສັ້ນຄໍາສັ່ງ ຫຼື ຜ່ານ cron.';
$string['autoactivedisabled'] = 'ປິດໃຊ້ງານ';
$string['autoactiveenabled'] = 'ເປີດໃຊ້ງານ';
$string['autoactivemanual'] = 'ດ້ວຍຕົວເອງ';
$string['automatedbackupschedule'] = 'ຕາຕະລາງ';
$string['automatedbackupschedulehelp'] = 'ເລືອກມື້ຂອງອາທິດເພື່ອປະຕິບັດການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ.';
$string['automatedbackupsinactive'] = 'ຜູ້ເບິ່ງແຍງເວັບໄຊທ໌ບໍ່ໄດ້ເປີດໃຊ້ການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['automatedbackupstatus'] = 'ການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['automateddeletedays'] = 'ລຶບການສຳຮອງຂໍ້ມູນເກົ່າກວ່າ';
$string['automatedmaxkept'] = 'ຈຳນວນສູງສຸດຂອງການຮັກສາການສຳຮອງຂໍ້ມູນ';
$string['automatedmaxkepthelp'] = 'ສິ່ງນີ້ກໍານົດຈໍານວນສູງສຸດຂອງການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດ ທີ່ຜ່ານມາທີ່ຈະເກັບຮັກສາໄວ້ສໍາລັບແຕ່ລະລາຍວິຊາ. ການສຳຮອງຂໍ້ມູນທີ່ເກົ່າກວ່າຈະຖືກລຶບໂດຍອັດຕະໂນມັດ.';
$string['automatedminkept'] = 'ຈຳນວນຕ່ຳສຸດຂອງການຮັກສາການສຳຮອງຂໍ້ມູນ';
$string['automatedminkepthelp'] = 'ຖ້າການສຳຮອງຂໍ້ມູນເກົ່າກວ່າຈຳນວນມື້ທີ່ກຳນົດໄວ້ແມ່ນຈະຖືກລຶບ, ມັນອາດເກີດຂຶ້ນໄດ້ວ່າຫຼັກສູດທີ່ບໍ່ມີການເຄື່ອນໄຫວ ຈົບລົງດ້ວຍການບໍ່ມີການສຳຮອງຂໍ້ມູນ. ເພື່ອປ້ອງກັນສິ່ງນີ້, ຈໍານວນການສໍາຮອງຂໍ້ມູນຕ່ຳສຸດທີ່ເກັບຮັກສາໄວ້ຄວນໄດ້ຮັບການລະບຸໄວ້.';
$string['automatedsettings'] = 'ການຕັ້ງຄ່າການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['automatedsetup'] = 'ຕັ້ງຄ່າການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['automatedstorage'] = 'ບ່ອນຈັດເກັບການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['automatedstoragehelp'] = 'ເລືອກສະຖານທີ່ທີ່ທ່ານຕ້ອງການການສໍາຮອງຂໍ້ມູນ ທີ່ຈະຖືກເກັບໄວ້ໃນເວລາທີ່ພວກມັນຖືກສ້າງຂື້ນໂດຍອັດຕະໂນມັດ.';
$string['backupactivity'] = 'ກິດຈະກຳການສຳຮອງຂໍ້ມູນ: {$a}';
$string['backupcourse'] = 'ລາຍວິຊາການສຳຮອງຂໍ້ມູນ: {$a}';
$string['backupcoursedetails'] = 'ລາຍລະອຽດລາຍວິຊາ';
$string['backupcoursesection'] = 'ພາກສ່ວນ: {$a}';
$string['backupcoursesections'] = 'ພາກສ່ວນລາຍວິຊາ';
$string['backupdate'] = 'ວັນທີປະຕິບັດ';
$string['backupdetails'] = 'ລາຍລະອຽດການສຳຮອງຂໍ້ມູນ';
$string['backupdetailsnonstandardinfo'] = 'ໄຟລ໌ທີ່ເລືອກບໍ່ແມ່ນໄຟລ໌ສຳຮອງຂໍ້ມູນ Moodle ມາດຕະຖານ. ຂະບວນການກູ້ຄືນຈະພະຍາຍາມປ່ຽນໄຟລ໌ສໍາຮອງຂໍ້ມູນເຂົ້າໄປໃນຮູບແບບມາດຕະຖານ ແລະ ຫຼັງຈາກນັ້ນກໍ່ກູ້ມັນຄືນ.';
$string['backupformat'] = 'ຮູບແບບ';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'ຮູບແບບບໍ່ຮູ້ຈັກ';
$string['backuplog'] = 'ຂໍ້ມູນທາງເຕັກນິກ ແລະ ການເຕືອນ';
$string['backupmode'] = 'ໂໝດ';
$string['backupmode10'] = 'ທົ່ວໄປ';
$string['backupmode20'] = 'ນຳເຂົ້າ';
$string['backupmode30'] = 'ສູນກາງ';
$string['backupmode40'] = 'ເວັບໄຊທ໌ດຽວກັນ';
$string['backupmode50'] = 'ອັດຕະໂນມັດ';
$string['backupmode60'] = 'ປ່ຽນແລ້ວ';
$string['backupmode70'] = 'ການປະສານໃນເວລາຕ່າງກັນ';
$string['backupsection'] = 'ການສຳຮອງຂໍ້ມູນພາກສ່ວນລາຍວິຊາ: {$a}';
$string['backupsettings'] = 'ການຕັ້ງຄ່າການສຳຮອງຂໍ້ມູນ';
$string['backupsitedetails'] = 'ລາຍລະອຽດເວັບໄຊທ໌';
$string['backupstage16action'] = 'ສືບຕໍ່';
$string['backupstage1action'] = 'ຕໍ່ໄປ';
$string['backupstage2action'] = 'ຕໍ່ໄປ';
$string['backupstage4action'] = 'ປະຕິບັດການສຳຮອງຂໍ້ມູນ';
$string['backupstage8action'] = 'ສືບຕໍ່';
$string['backuptype'] = 'ປະເພດ';
$string['backuptypeactivity'] = 'ກິດຈະກຳ';
$string['backuptypecourse'] = 'ລາຍວິຊາ';
$string['backuptypesection'] = 'ພາກສ່ວນ';
$string['backupversion'] = 'ສະບັບການສຳຮອງຂໍ້ມູນ';
$string['cannotfindassignablerole'] = 'ໜ້າທີ່ {$a} ໃນໄຟລ໌ສຳຮອງຂໍ້ມູນ ບໍ່ສາມາດຖືກຕັ້ງກັບໜ້າທີ່ໃດໜຶ່ງທີ່ທ່ານໄດ້ຮັບອະນຸຍາດໃຫ້ມອບໝາຍໄດ້.';
$string['choosefilefromactivitybackup'] = 'ເຂດການສຳຮອງຂໍ້ມູນກິດຈະກຳ';
$string['choosefilefromactivitybackup_help'] = 'ການສຳຮອງຂໍ້ມູນກິດຈະກຳທີ່ສ້າງຂຶ້ນໂດຍໃຊ້ການຕັ້ງຄ່າເລີ່ມຕົ້ນຖືກເກັບໄວ້ທີ່ນີ້.';
$string['choosefilefromautomatedbackup'] = 'ການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['choosefilefromautomatedbackup_help'] = 'ປະກອບດ້ວຍການສໍາຮອງຂໍ້ມູນທີ່ສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດ.';
$string['choosefilefromcoursebackup'] = 'ເຂດການສຳຮອງຂໍ້ມູນລາຍວິຊາ';
$string['choosefilefromcoursebackup_help'] = 'ການສຳຮອງຂໍ້ມູນລາຍວິຊາທີ່ສ້າງຂຶ້ນໂດຍໃຊ້ການຕັ້ງຄ່າເລີ່ມຕົ້ນຖືກເກັບໄວ້ທີ່ນີ້.';
$string['choosefilefromuserbackup'] = 'ເຂດການສຳຮອງຂໍ້ມູນສ່ວນຕົວຂອງຜູ້ໃຊ້';
$string['choosefilefromuserbackup_help'] = 'ໄຟລ໌ສໍາຮອງຂໍ້ມູນຜູ້ໃຊ້ທີ່ບໍ່ລະບຸຊື່ແມ່ນຖືກເກັບຮັກສາໄວ້ຢູ່ທີ່ນີ້.';
$string['config_keep_groups_and_groupings'] = 'ຮັກສາກຸ່ມ ແລະ ການຈັດກຸ່ມປະຈຸບັນໂດຍມາດຕະຖານ';
$string['config_keep_roles_and_enrolments'] = 'ຮັກສາໜ້າທີ່ ແລະ ການລົງທະບຽນເຂົ້າຮຽນປະຈຸບັນໂດຍມາດຕະຖານ';
$string['config_overwrite_conf'] = 'ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ຂຽນທັບການກຳນົດຄ່າລາຍວິຊາໃນປະຈຸບັນ';
$string['config_overwrite_course_fullname'] = 'ໂດຍຄ່າເລີ່ມຕົ້ນຂຽນທັບວັນທີເລີ່ມຕົ້ນລາຍວິຊາດ້ວຍອັນໜຶ່ງຈາກໄຟລ໌ສຳຮອງຂໍ້ມູນ. ສິ່ງນີ້ຮຽກຮ້ອງໃຫ້ "ຂຽນທັບການກຳນົດຄ່າລາຍວິຊາ" ເພື່ອກວດສອບ ແລະ ຜູ້ໃຊ້ປະຈຸບັນມີຄວາມສາມາດໃນການປ່ຽນຊື່ເຕັມລາຍວິຊາ (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'ໂດຍຄ່າເລີ່ມຕົ້ນຂຽນທັບວັນທີເລີ່ມຕົ້ນລາຍວິຊາດ້ວຍອັນໜຶ່ງຈາກໄຟລ໌ສຳຮອງຂໍ້ມູນ. ສິ່ງນີ້ຮຽກຮ້ອງໃຫ້ "ຂຽນທັບການກຳນົດຄ່າລາຍວິຊາ" ເພື່ອກວດສອບ ແລະ ຜູ້ໃຊ້ປະຈຸບັນມີຄວາມສາມາດໃນການປ່ຽນຊື່ສັ້ນລາຍວິຊາ (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'ໂດຍຄ່າເລີ່ມຕົ້ນຂຽນທັບວັນທີເລີ່ມຕົ້ນລາຍວິຊາດ້ວຍອັນໜຶ່ງຈາກໄຟລ໌ສຳຮອງຂໍ້ມູນ. ສິ່ງນີ້ຮຽກຮ້ອງໃຫ້ "ຂຽນທັບການກຳນົດຄ່າລາຍວິຊາ" ເພື່ອກວດສອບ ແລະ ຜູ້ໃຊ້ປະຈຸບັນມີຄວາມສາມາດໃນການມ້ວນວັນທີລາຍວິຊາໃນການກູ້ຄືນ (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'ຕັ້ງເປັນຄ່າມາດຕະຖານສຳລັບການລວມມີກິດຈະກຳໃນການສຳຮອງຂໍ້ມູນ.';
$string['configgeneralanonymize'] = 'ຖ້າເປີດໃຊ້ງານ ຂໍ້ມູນທັງໝົດກ່ຽວກັບຜູ້ໃຊ້ ຈະຖືກບໍ່ເປີດເຜີຍຊື່ໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['configgeneralbadges'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາປ້າຍໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralblocks'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາບລັອກໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralcalendarevents'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົານັດໝາຍປະຕິທິນໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralcomments'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາຄຳເຫັນໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralcompetencies'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາຄວາມສາມາດໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralcontentbankcontent'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາເນື້ອຫາທະນາຄານເນື້ອຫາໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralfiles'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາໄຟລ໌ໃນການສໍາຮອງຂໍ້ມູນ. ກະລຸນາບັນທຶກ: ການປິດການຕັ້ງຄ່ານີ້ ຈະເຮັດໃຫ້ມີການສໍາຮອງຂໍ້ມູນທີ່ມີພຽງແຕ່ການອ້າງອີງເຖິງໄຟລ໌. ນີ້ບໍ່ແມ່ນບັນຫາຖ້າວ່າການສໍາຮອງຂໍ້ມູນໄດ້ຖືກກູ້ຄືນຢູ່ໃນເວັບໄຊທ໌ດຽວກັນ ແລະ ໄຟລ໌ບໍ່ໄດ້ຖືກລຶບຖິ້ມຕາມການຕັ້ງຄ່າ \'ທຳຄວາມສະອາດໄຟລ໌ອ່າງຂີ້ເຫຍື້ອ\' (filescleanupperiod).';
$string['configgeneralfilters'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາຕົວກັ່ນຕອງໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralgroups'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາກຸ່ມ ແລະ ການຈັດກຸ່ມໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgeneralhistories'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາປະຫັວດຜູ້ໃຊ້ພາຍໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configgenerallogs'] = 'ຖ້າບັນທຶກທີ່ເປີດໃຊ້ງານຈະຖືກລວມເຂົ້າໃນການສໍາຮອງຂໍ້ມູນໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['configgeneralpermissions'] = 'ຖ້າເປີດໃຊ້ງານການອະນຸຍາດໜ້າທີ່ຈະຖືກນຳເຂົ້າ. ສິ່ງນີ້ອາດຈະລົບລ້າງການອະນຸຍາດທີ່ມີຢູ່ແລ້ວສໍາລັບຜູ້ໃຊ້ທີ່ລົງທະບຽນຮຽນ.';
$string['configgeneralquestionbank'] = 'ຖ້າເປີດໃຊ້ງານ, ທະນາຄານຄໍາຖາມຈະຖືກລວມເຂົ້າໃນການສໍາຮອງໂດຍຄ່າເລີ່ມຕົ້ນ. ກະລຸນາສັງເກດ: ການປິດໃຊ້ງານການຕັ້ງຄ່ານີ້ ຈະປິດການທໍາງານການສໍາຮອງຂອງກິດຈະກໍາທີ່ໃຊ້ທະນາຄານຄໍາຖາມ, ເຊັ່ນ: ແບບທົດສອບ.';
$string['configgeneralroleassignments'] = 'ຖ້າເປີດໃຊ້ງານຕາມການມອບໝາຍໜ້າທີ່ເລີ່ມຕົ້ນຈະຖືກສຳຮອງຂໍ້ມູນໄວ້.';
$string['configgeneralusers'] = 'ກຳນົດຄ່າເລີ່ມຕົ້ນສຳລັບບໍ່ວ່າຈະລວມເອົາຜູ້ໃຊ້ເຂົ້າໃນການສຳຮອງຂໍ້ມູນຫຼືບໍ່.';
$string['configgeneraluserscompletion'] = 'ຖ້າເປີດໃຊ້ຂໍ້ມູນການສໍາເລັດຂອງຜູ້ໃຊ້ ຈະຖືກລວມເຂົ້າໃນການສໍາຮອງຂໍ້ມູນໂດຍຄ່າເລີ່ມຕົ້ນ.';
$string['configlegacyfiles'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບການລວມເອົາໄຟລ໌ລາຍວິຊາເດີມໃນການສໍາຮອງຂໍ້ມູນ. ໄຟລ໌ລາຍວິຊາເດີມແມ່ນມາຈາກສະບັບ Moodle ກ່ອນໜ້າ ໄປຫາ 2.0.';
$string['configloglifetime'] = 'ສິ່ງນີ້ກໍານົດໄລຍະເວລາທີ່ທ່ານຕ້ອງການທີ່ຈະຮັກສາຂໍ້ມູນບັນທຶກສໍາຮອງຂໍ້ມູນ. ບັນທຶກທີ່ເກົ່າກວ່າອາຍຸນີ້ຈະຖືກລຶບໂດຍອັດຕະໂນມັດ. ແນະນຳໃຫ້ເກັບຄ່ານີ້ໃຫ້ນ້ອຍລົງ, ເພາະວ່າຂໍ້ມູນບັນທຶກຂໍ້ມູນສຳຮອງສາມາດມີຂະໜາດໃຫຍ່ໄດ້.';
$string['configrestoreactivities'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບກິດຈະກຳການກູ້ຄືນ.';
$string['configrestorebadges'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບປ້າຍການກູ້ຄືນ.';
$string['configrestoreblocks'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບບລັອກການກູ້ຄືນ.';
$string['configrestorecalendarevents'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບນັດໝາຍປະຕິທິນການກູ້ຄືນ.';
$string['configrestorecomments'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຄຳເຫັນການກູ້ຄືນ.';
$string['configrestorecompetencies'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຄວາມສາມາດການກູ້ຄືນ.';
$string['configrestorecontentbankcontent'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບເນື້ອຫາທະນາຄານເນື້ອຫາການກູ້ຄືນ.';
$string['configrestoreenrolments'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບວິທີການລົງທະບຽນເຂົ້າຮຽນການກູ້ຄືນ.';
$string['configrestorefilters'] = 'ກໍານົດຄ່າເລີ່ມຕົ້ນສໍາລັບຕົວກັ່ນຕອງການກູ້ຄືນ.';
$string['configrestoregroups'] = 'ກຳນົດຄ່າເລີ່ມຕົ້ນສຳລັບການກູ້ຄືນກຸ່ມ ແລະ ການຈັດກຸ່ມ ຖ້າພວກມັນຖືກລວມເຂົ້າໃນການສຳຮອງຂໍ້ມູນ.';
$string['configrestorehistories'] = 'ກຳນົດຄ່າເລີ່ມຕົ້ນສຳລັບການກູ້ຄືນປະຫວັດຜູ້ໃຊ້ ຖ້າພວກມັນຖືກລວມເຂົ້າໃນການສຳຮອງຂໍ້ມູນ.';
$string['configrestorelogs'] = 'ຖ້າບັນທຶກທີ່ຖືກເປີດໃຊ້ຈະຖືກກູ້ຄືນໂດຍຄ່າເລີ່ມຕົ້ນ ຖ້າພວກມັນຖືກລວມເຂົ້າໃນການສໍາຮອງຂໍ້ມູນ.';
$string['configrestorepermissions'] = 'ຖ້າເປີດໃຊ້ການອະນຸຍາດບົດບາດຈະຖືກກູ້ຄືນ. ອັນນີ້ອາດຈະລົບລ້າງການອະນຸຍາດທີ່ມີຢູ່ແລ້ວສໍາລັບຜູ້ໃຊ້ທີ່ລົງທະບຽນຮຽນ.';
$string['configrestoreroleassignments'] = 'ຖ້າເປີດໃຊ້ໂດຍການມອບໝາຍໜ້າທີ່ເລີ່ມຕົ້ນຈະຖືກກູ້ຄືນມາ ຖ້າພວກມັນຖືກລວມເຂົ້າໃນການສຳຮອງຂໍ້ມູນ.';
$string['configrestoreusers'] = 'ກຳນົດຄ່າເລີ່ມຕົ້ນສຳລັບການກູ້ຄືນຜູ້ໃຊ້ ຖ້າພວກມັນຖືກລວມເຂົ້າໃນການສຳຮອງຂໍ້ມູນ.';
$string['configrestoreuserscompletion'] = 'ຖ້າເປີດໃຊ້ຂໍ້ມູນການສໍາເລັດຂອງຜູ້ໃຊ້ ຈະຖືກກູ້ຄືນໂດຍຄ່າເລີ່ມຕົ້ນ ຖ້າມັນຖືກລວມຢູ່ໃນການສໍາຮອງຂໍ້ມູນ.';
$string['confirmcancel'] = 'ຍົກເລີກການສຳຮອງຂໍ້ມູນ';
$string['confirmcancelimport'] = 'ຍົກເລີກການນຳເຂົ້າ';
$string['confirmcancelno'] = 'ຢ່າຍົກເລີກ';
$string['confirmcancelquestion'] = 'ທ່ານແນ່ໃຈວ່າທ່ານຕ້ອງການຍົກເລີກ?
ຂໍ້ມູນໃດໜຶ່ງທີ່ທ່ານໄດ້ຕື່ມໃສ່ຈະສູນເສຍໄປ.';
$string['confirmcancelrestore'] = 'ຍົກເລີກການກູ້ຄືນ';
$string['confirmcancelyes'] = 'ຍົກເລີກການສຳຮອງຂໍ້ມູນ';
$string['confirmnewcoursecontinue'] = 'ການເຕືອນລາຍວິຊາໃໝ່';
$string['confirmnewcoursecontinuequestion'] = 'ຫຼັກສູດຊົ່ວຄາວ (ເຊື່ອງໄວ້) ຈະຖືກສ້າງຂື້ນໂດຍຂະບວນການກູ້ຄືນລາຍວິຊາ. ເພື່ອຍົກເລີກການກູ້ຄືນ, ໃຫ້ຄລິກໃສ່ຍົກເລີກ. ຢ່າປິດຕົວທ່ອງເວັບໃນຂະນະທີ່ກຳລັງກູ້ຄືນ.';
$string['copiesinprogress'] = 'ລາຍວິຊານີ້ມີສຳເນົາກຳລັງດຳເນີນການ. <a href="{$a}">ເບິ່ງສຳເນົາກຳລັງດຳເນີນການ.</a>';
$string['copycoursedesc'] = 'ລາຍວິຊານີ້ຈະຖືກຊ້ຳກັນ ແລະ ເອົາເຂົ້າໄປໃນປະເພດລາຍວິຊາທີ່ເລືອກ.';
$string['copycourseheading'] = 'ສຳເນົາລາຍວິຊາ';
$string['copycoursetitle'] = 'ສຳເນົາລາຍວິຊາ: {$a}';
$string['copydest'] = 'ຈຸດໝາຍປາຍທາງ';
$string['copyfieldnotfound'] = 'ບໍ່ພົບຊ່ອງຂໍ້ມູນທີ່ຈຳເປັນສຳລັບຂະແໜງ: {$a}';
$string['copyformfail'] = 'ການສົ່ງ AJAX ຂອງແບບຟອມສໍາເນົາລາຍວິຊາລົ້ມເຫຼວ.';
$string['copyingcourse'] = 'ກຳລັງດຳເນີນການສຳເນົາລາຍວິຊາ';
$string['copyingcourseshortname'] = 'ກຳລັງສຳເນົາ';
$string['copyop'] = 'ການປະຕິບັດໃນປະຈຸບັນ';
$string['copyprogressheading'] = 'ກຳລັງດຳເນີນສຳເນົາລາຍວິຊາ';
$string['copyprogressheading_help'] = 'ຕາຕະລາງນີ້ສະແດງສະຖານະຂອງສໍາເນົາລາຍວິຊາທີ່ຍັງບໍ່ໄດ້ສໍາເລັດທັງໝົດຂອງທ່ານ.';
$string['copyprogresstitle'] = 'ຄວາມຄືບໜ້າສຳເນົາລາຍວິຊາ';
$string['copyreturn'] = 'ສຳເນົາ ແລະ ສົ່ງກັບຄືນ';
$string['copysource'] = 'ແຫຼ່ງຂໍ້ມູນ';
$string['copyview'] = 'ສຳເນົາ ແລະ ເບິ່ງ';
$string['coursecategory'] = 'ປະເພດລາຍວິຊາຈະຖືກກູ້ຄືນໃນ';
$string['courseid'] = 'ລະຫັດປະຈຳຕົວຕົ້ນສະບັບ';
$string['coursesettings'] = 'ການຕັ້ງຄ່າລາຍວິຊາ';
$string['coursetitle'] = 'ຫົວຂໍ້';
$string['currentstage1'] = 'ການຕັ້ງຄ່າເບື້ອງຕົ້ນ';
$string['currentstage16'] = 'ສຳເລັດ';
$string['currentstage2'] = 'ການຕັ້ງຄ່າຮູບແບບ';
$string['currentstage4'] = 'ການຢືນຢັນ ແລະ ເບິ່ງ';
$string['currentstage8'] = 'ປະຕິບັດການສຳຮອງຂໍ້ມູນ';
$string['enableasyncbackup'] = 'ເປີດໃຊ້ງານການສຳຮອງຂໍ້ມູນແບບເວລາຕ່າງກັນ';
$string['enableasyncbackup_help'] = 'ຖ້າເປີດໃຊ້ງານ, ການສຳຮອງຂໍ້ມູນ ແລະ ການກູ້ຂໍ້ມູນທັງໝົດຈະຖືກເຮັດແບບເວລາຕ່າງກັນ. ສິ່ງນີ້ບໍ່ມີຜົນກະທົບຕໍ່ການນໍາເຂົ້າ ແລະ ການສົ່ງອອກ. ການສຳຮອງຂໍ້ມູນ ແລະ ການກູ້ຄືນແບບເວລາຕ່າງກັນເຮັດໃຫ້ຜູ້ໃຊ້ສາມາດດຳເນີນການອື່ນໆໄດ້ ໃນຂະນະທີ່ການສຳຮອງຂໍ້ມູນ ຫຼື ການກູ້ຂໍ້ມູນກຳລັງດຳເນີນຢູ່.';
$string['enterasearch'] = 'ໃສ່ການຄົ້ນຫາ';
$string['error_block_for_module_not_found'] = 'ພົບເຫັນຕົວຢ່າງບລັອກກຳພ້າ (id: {$a->bid}) ສຳລັບຊຸດລາຍວິຊາ (id: {$a->mid}) ແລ້ວ. ບລັອກນີ້ຈະບໍ່ຖືກສຳຮອງຂໍ້ມູນ';
$string['error_course_module_not_found'] = 'ພົບຊຸດລາຍວິຊາກຳພ້າ (id: {$a}). ຊຸດນີ້ຈະບໍ່ຖືກສຳຮອງຂໍ້ມູນ.';
$string['errorcopyingbackupfile'] = 'ສຳເນົາໄຟລ໌ສຳຮອງຂໍ້ມູນໄປໃສ່ໂຟນເດີຊົ່ວຄາວກ່ອນການກູ້ຂໍ້ມູນບໍ່ສຳເລັດ.';
$string['errorfilenamemustbezip'] = 'ຊື່ໄຟລ໌ທີ່ທ່ານໃສ່ຕ້ອງເປັນໄຟລ໌ ZIP ແລະ ມີສ່ວນຂະຫຍາຍ .mbz';
$string['errorfilenamerequired'] = 'ທ່ານຕ້ອງໃສ່ຊື່ໄຟລ໌ທີ່ຖືກຕ້ອງເພື່ອການສຳຮອງຂໍ້ມູນນີ້';
$string['errorfilenametoolong'] = 'ຊື່ໄຟລ໌ຕ້ອງໜ້ອຍກວ່າຄວາມຍາວ 255 ຕົວອັກສອນ';
$string['errorinvalidformat'] = 'ຮູບແບບການສຳຮອງຂໍ້ມູນບໍ່ຮູ້ຈັກ';
$string['errorinvalidformatinfo'] = 'ໄຟລ໌ທີ່ເລືອກບໍ່ແມ່ນໄຟລ໌ສຳຮອງຂໍ້ມູນ Moodle ທີ່ຖືກຕ້ອງ ແລະບໍ່ສາມາດກູ້ຄືນມາໄດ້.';
$string['errorminbackup20version'] = 'ໄຟລ໌ສໍາຮອງຂໍ້ມູນນີ້ ໄດ້ຖືກສ້າງຂື້ນມາດ້ວຍການສຳຮອງຂໍ້ມູນ Moodle ເວີຊັນພັດທະນາ ({$a->backup}). ຕ້ອງການຕ່ຳສຸດແມ່ນ {$a->min}. ບໍ່ສາມາດກູ້ຄືນໄດ້.';
$string['errorrestorefrontpagebackup'] = 'ທ່ານພຽງແຕ່ສາມາດກູ້ຄືນການສໍາຮອງຂໍ້ມູນໜ້າຫຼັກເວັບໄຊທ໌ໃນໜ້າຫຼັກເວັບໄຊທ໌';
$string['executionsuccess'] = 'ໄຟລ໌ສໍາຮອງຂໍ້ມູນໄດ້ຖືກສ້າງຂື້ນຢ່າງສໍາເລັດຜົນ.';
$string['extractingbackupfileto'] = 'ກຳລັງສະກັດເອົາໄຟລ໌ສຳຮອງຂໍ້ມູນໄປຫາ: {$a}';
$string['failed'] = 'ການສຳຮອງຂໍ້ມູນລົ້ມເຫຼວ';
$string['filealiasesrestorefailures'] = 'ນາມແຝງກູ້ຄືນຄວາມລົ້ມເຫຼວ';
$string['filealiasesrestorefailures_help'] = 'ນາມແຝງແມ່ນການເຊື່ອມຕໍ່ສັນຍາລັກກັບໄຟລ໌ອື່ນໆ, ລວມທັງສິ່ງທີ່ເກັບໄວ້ໃນບ່ອນເກັບຂໍ້ມູນພາຍນອກ. ໃນບາງກໍລະນີ, Moodle ບໍ່ສາມາດກູ້ຄືນພວກມັນໄດ້ - ຕົວຢ່າງເມື່ອຟື້ນຟູການສໍາຮອງຂໍ້ມູນຢູ່ບ່ອນອື່ນ ຫຼື ເມື່ອໄຟລ໌ອ້າງອີງບໍ່ມີ.

ລາຍລະອຽດເພີ່ມເຕີມ ແລະ ເຫດຜົນທີ່ແທ້ຈິງຂອງຄວາມລົ້ມເຫຼວສາມາດພົບເຫັນຢູ່ໃນໄຟລ໌ບັນທຶກການກູ້ຄືນ.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'ນາມແຝງບາງອັນທີ່ຮວມຢູ່ໃນໄຟລ໌ສຳຮອງນັ້ນບໍ່ສາມາດກູ້ຄືນມາໄດ້. ບັນຊີລາຍຊື່ຕໍ່ໄປນີ້ ປະກອບມີສະຖານທີ່ທີ່ຄາດໄວ້ຂອງພວກເຂົາ ແລະ ໄຟລ໌ແຫຼ່ງທີ່ເຂົາເຈົ້າໄດ້ອ້າງເຖິງຢູ່ໃນເວັບໄຊທ໌ຕົ້ນສະບັບ.';
$string['filename'] = 'ຊື່ໄຟລ໌';
$string['filereferencesincluded'] = 'ການອ້າງອີງໄຟລ໌ຕໍ່ກັບເນື້ອຫາພາຍນອກແມ່ນລວມຢູ່ໃນໄຟລ໌ສຳຮອງ. ສິ່ງເຫຼົ່ານີ້ຈະບໍ່ເຮັດວຽກຖ້າການສໍາຮອງຂໍ້ມູນຖືກກູ້ຄືນຢູ່ໃນເວັບໄຊທ໌ອື່ນ.';
$string['filereferencesnotsamesite'] = 'ໄຟລ໌ສໍາຮອງຂໍ້ມູນແມ່ນມາຈາກເວັບໄຊທ໌ອື່ນ, ແລະ ດັ່ງນັ້ນການອ້າງອິງໄຟລ໌ບໍ່ສາມາດກູ້ຄືນໄດ້.';
$string['filereferencessamesite'] = 'ໄຟລ໌ສໍາຮອງຂໍ້ມູນແມ່ນມາຈາກເວັບໄຊທ໌ນີ້, ແລະ ດັ່ງນັ້ນ ການອ້າງອິງໄຟລ໌ສາມາດໄດ້ຮັບການກູ້ຄືນໄດ້.';
$string['generalactivities'] = 'ລວມທັງກິດຈະກຳ ແລະ ແຫຼ່ງຂໍ້ມູນ';
$string['generalanonymize'] = 'ຂໍ້ມູນປິດບັງຊື່';
$string['generalbackdefaults'] = 'ຄ່າເລີ່ມຕົ້ນການສຳຮອງຂໍ້ມູນທົ່ວໄປ';
$string['generalbadges'] = 'ລວມທັງປ້າຍ';
$string['generalblocks'] = 'ລວມທັງບລັອກ';
$string['generalcalendarevents'] = 'ລວມທັງນັດໝາຍປະຕິທິນ';
$string['generalcomments'] = 'ລວມທັງຄຳເຫັນ';
$string['generalcompetencies'] = 'ລວມທັງຄວາມສາມາດ';
$string['generalcontentbankcontent'] = 'ລວມທັງເນື້ອຫາທະນາຄານເນື້ອຫາ';
$string['generalenrolments'] = 'ລວມທັງວິທີການລົງທະບຽນຮຽນ';
$string['generalfiles'] = 'ລວມທັງໄຟລ໌';
$string['generalfilters'] = 'ລວມທັງຕົວກັ່ນຕອງ';
$string['generalgradehistories'] = 'ລວມທັງປະຫວັດ';
$string['generalgroups'] = 'ລວມທັງກຸ່ມ ແລະ ການຈັດກຸ່ມ';
$string['generalhistories'] = 'ລວມທັງປະຫວັດ';
$string['generallegacyfiles'] = 'ລວມທັງໄຟລ໌ລາຍວິຊາເກົ່າ';
$string['generallogs'] = 'ລວມທັງບັນທຶກ';
$string['generalpermissions'] = 'ລວມທັງການລົບລ້າງການອະນຸຍາດ';
$string['generalquestionbank'] = 'ລວມທັງທະນາຄານຄຳຖາມ';
$string['generalrestoredefaults'] = 'ຄ່າເລີ່ມຕົ້ນການກູ້ຄືນທົ່ວໄປ';
$string['generalrestoresettings'] = 'ຄ່າເລີ່ມຕົ້ນການກູ້ຄືນທົ່ວໄປ';
$string['generalroleassignments'] = 'ລວມທັງການມອບໝາຍໜ້າທີ່';
$string['generalsettings'] = 'ການຕັ້ງຄ່າການສຳຮອງຂໍ້ມູນທົ່ວໄປ';
$string['generalusers'] = 'ລວມທັງຜູ້ໃຊ້';
$string['generaluserscompletion'] = 'ລວມທັງຂໍ້ມູນການສຳເລັດຜູ້ໃຊ້';
$string['hidetypes'] = 'ເຊື່ອງທາງເລືອກປະເພດ';
$string['importbackupstage16action'] = 'ສືບຕໍ່';
$string['importbackupstage1action'] = 'ຕໍ່ໄປ';
$string['importbackupstage2action'] = 'ຕໍ່ໄປ';
$string['importbackupstage4action'] = 'ປະຕິບັດການນຳເຂົ້າ';
$string['importbackupstage8action'] = 'ສືບຕໍ່';
$string['importcurrentstage0'] = 'ການເລືອກລາຍວິຊາ';
$string['importcurrentstage1'] = 'ການຕັ້ງຄ່າເບື້ອງຕົ້ນ';
$string['importcurrentstage16'] = 'ສຳເລັດ';
$string['importcurrentstage2'] = 'ການຕັ້ງຄ່າ Schema';
$string['importcurrentstage4'] = 'ການຢືນຢັນ ແລະ ການທົບທວນຄືນ';
$string['importcurrentstage8'] = 'ນຳເຂົ້າການປະຕິບັດ';
$string['importfile'] = 'ນຳເຂົ້າໄຟລ໌ສຳຮອງຂໍ້ມູນ';
$string['importgeneralduplicateadminallowed'] = 'ອະນຸຍາດແກ້ໄຂຂໍ້ຄັດແຍ້ງຜູ້ບໍລິຫານ';
$string['importgeneralduplicateadminallowed_desc'] = 'ຖ້າເວັບໄຊທ໌ມີບັນຊີທີ່ມີຊື່ຜູ້ໃຊ້ \'ຜູ້ບໍລິຫານ\', ຫຼັງຈາກນັ້ນການພະຍາຍາມກູ້ຄືນໄຟລ໌ສໍາຮອງຂໍ້ມູນທີ່ມີບັນຊີທີ່ມີຊື່ຜູ້ໃຊ້ \'ຜູ້ບໍລິຫານ\' ສາມາດເຮັດໃຫ້ເກີດຄວາມຂັດແຍ້ງ. ຖ້າການຕັ້ງຄ່ານີ້ຖືກເປີດໃຊ້, ຂໍ້ຂັດແຍ່ງຈະຖືກແກ້ໄຂໂດຍການປ່ຽນຊື່ຜູ້ໃຊ້ໃນໄຟລ໌ສໍາຮອງຂໍ້ມູນເປັນ \'admin_xyz\'.';
$string['importgeneralmaxresults'] = 'ຈຳນວນສູງສຸດຂອງລາຍວິຊາທີ່ລະບຸໄວ້ສໍາລັບການນໍາເຂົ້າ';
$string['importgeneralmaxresults_desc'] = 'ສິ່ງນີ້ຄວບຄຸມຈໍານວນຂອງລາຍວິຊາ ທີ່ໄດ້ລະບຸໄວ້ໃນລະຫວ່າງຂັ້ນຕອນທໍາອິດຂອງຂະບວນການນໍາເຂົ້າ';
$string['importgeneralsettings'] = 'ຄ່າເລີ່ມຕົ້ນນຳເຂົ້າທົ່ວໄປ';
$string['importrootsettings'] = 'ການຕັ້ງຄ່ານຳເຂົ້າ';
$string['importsettings'] = 'ການຕັ້ງຄ່ານຳເຂົ້າທົ່ວໄປ';
$string['importsuccess'] = 'ສຳເລັດນຳເຂົ້າ. ຄລິກສືບຕໍ່ເພື່ອກັບຄືນສູ່ລາຍວິຊາ.';
$string['includeactivities'] = 'ລວມທັງ:';
$string['includeditems'] = 'ລາຍການລວມທັງ:';
$string['includefilereferences'] = 'ໄຟລ໌ອ້າງອີງໄປຫາເນື້ອຫາພາຍນອກ';
$string['includesection'] = 'ພາກສ່ວນ {$a}';
$string['includeuserinfo'] = 'ຂໍ້ມູນຜູ້ໃຊ້';
$string['inprogress'] = 'ກຳລັງດຳເນີນການສຳຮອງຂໍ້ມູນ';
$string['jumptofinalstep'] = 'ກະໂດດໄປຫາຂັ້ນຕອນສຸດທ້າຍ';
$string['keep'] = 'ຮັກສາ';
$string['keptroles'] = 'ລວມທັງໜ້າທີ່ການລົງທະບຽນຮຽນ';
$string['keptroles_help'] = 'ຜູ້ໃຊ້ທີ່ມີບົດບາດທີ່ເລືອກຈະຖືກລົງທະບຽນເຂົ້າລາຍວິຊາໃໝ່. ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້ຈະຖືກຄັດລອກເວັ້ນເສຍແຕ່ວ່າ \'ລວມທັງຂໍ້ມູນຜູ້ໃຊ້\' ຖືກເປີດໃຊ້.';
$string['locked'] = 'ລັອກແລ້ວ';
$string['lockedbyconfig'] = 'ການຕັ້ງຄ່ານີ້ຖືກລັອກໂດຍການຕັ້ງຄ່າການສຳຮອງຂໍ້ມູນເລີ່ມຕົ້ນ';
$string['lockedbyhierarchy'] = 'ຖືກລັອກໂດຍການຂື້ນກັບ';
$string['lockedbypermission'] = 'ທ່ານບໍ່ມີການອະນຸຍາດທີ່ພຽງພໍເພື່ອປ່ຽນແປງການຕັ້ງຄ່ານີ້';
$string['loglifetime'] = 'ຮັກສາບັນທຶກສຳລັບ';
$string['managefiles'] = 'ຈັດການໄຟລ໌ສຳຮອງຂໍ້ມູນ';
$string['mergerestoredefaults'] = 'ກູ້ຄືນຄ່າເລີ່ມຕົ້ນເມື່ອລວມເຂົ້າກັບລາຍວິຊາອື່ນ';
$string['missingfilesinpool'] = 'ບາງໄຟລ໌ບໍ່ສາມາດຖືກບັນທຶກໄວ້ໃນລະຫວ່າງການສໍາຮອງຂໍ້ມູນ ແລະ ດັ່ງນັ້ນມັນຈະບໍ່ສາມາດກູ້ຄືນພວກມັນໄດ້.';
$string['module'] = 'ຊຸດ';
$string['moodleversion'] = 'ສະບັບ Moodle';
$string['morecoursesearchresults'] = 'ພົບຫຼາຍກວ່າ {$a} ລາຍວິຊາ, ສະແດງຜົນໄດ້ຮັບ {$a} ກ່ອນ';
$string['moreresults'] = 'ມີຜົນໄດ້ຮັບຫຼາຍເກີນໄປ, ໃສ່ການຄົ້ນຫາສະເພາະເພີ່ມເຕີມ.';
$string['nomatchingcourses'] = 'ບໍ່ມີລາຍວິຊາໃຫ້ສະແດງ';
$string['norestoreoptions'] = 'ບໍ່ມີປະເພດ ຫຼື ລາຍວິຊາທີ່ມີຢູ່ໃຫ້ທ່ານສາມາດກູ້ຄືນຫາ.';
$string['originalwwwroot'] = 'ການສຳຮອງຂໍ້ມູນຂອງ URL';
$string['overwrite'] = 'ຂຽນທັບ';
$string['pendingasyncdeletedetail'] = 'ລາຍວິຊານີ້ມີການສໍາຮອງຂໍ້ມູນແບບເວລາຕ່າງກັນທີ່ລໍຖ້າ. <br/> ບໍ່ສາມາດລຶບລາຍວິຊາໄດ້ຈົນກວ່າການສຳຮອງຂໍ້ມູນນີ້ຈະສຳເລັດ.';
$string['pendingasyncdetail'] = 'ການສຳຮອງຂໍ້ມູນແບບເວລາຕ່າງກັນ ພຽງແຕ່ອະນຸຍາດໃຫ້ຜູ້ໃຊ້ສາມາດມີການສຳຮອງຂໍ້ມູນລໍຖ້າສຳລັບແຫຼ່ງຂໍ້ມູນຢູ່ເທື່ອລະອັນເທົ່ານັ້ນ. <br/> ການສຳຮອງຂໍ້ມູນແບບເວລາຕ່າງກັນຂອງແຫຼ່ງຂໍ້ມູນດຽວກັນບໍ່ສາມາດຖືກຈັດເຂົ້າຄິວໄດ້, ເພາະວ່າ ສິ່ງນີ້ອາດຈະເຮັດໃຫ້ການສຳຮອງຂໍ້ມູນຫຼາຍອັນທີ່ມີເນື້ອໃນດຽວກັນ.';
$string['pendingasyncedit'] = 'ມີການຮ້ອງຂໍການສໍາຮອງຂໍ້ມູນ ຫຼື ສໍາເນົາທີ່ລໍຖ້າສໍາລັບລາຍວິຊານີ້. ກະລຸນາຢ່າແກ້ໄຂລາຍວິຊາຈົນກວ່າສິ່ງນີ້ຈະສໍາເລັດ.';
$string['pendingasyncerror'] = 'ລໍຖ້າການສຳຮອງຂໍ້ມູນສຳລັບແຫຼ່ງຂໍ້ມູນນີ້';
$string['preparingdata'] = 'ຂໍ້ມູນການກະກຽມ';
$string['preparingui'] = 'ການກະກຽມສຳລັບໜ້າສະແດງ';
$string['previousstage'] = 'ກ່ອນໜ້າ';
$string['privacy:metadata:backup:detailsofarchive'] = 'ແຟ້ມຈັດເກັບນີ້ສາມາດບັນຈຸຂໍ້ມູນຜູ້ໃຊ້ຕ່າງໆທີ່ກ່ຽວຂ້ອງກັບຫຼັກສູດ, ເຊັ່ນ: ຊັ້ນຮຽນ, ການລົງທະບຽນຂອງຜູ້ໃຊ້ ແລະ ຂໍ້ມູນກິດຈະກຳ.';
$string['privacy:metadata:backup:externalpurpose'] = 'ຈຸດປະສົງຂອງການເກັບຂໍ້ມູນນີ້ ແມ່ນເພື່ອເກັບຮັກສາຂໍ້ມູນທີ່ກ່ຽວຂ້ອງກັບລາຍວິຊາ, ເຊິ່ງອາດຈະໄດ້ຮັບການກູ້ຄືນໃນອະນາຄົດ.';
$string['privacy:metadata:backup_controllers'] = 'ລາຍການປະຕິບັດການສຳຮອງຂໍ້ມູນ';
$string['privacy:metadata:backup_controllers:itemid'] = 'ລະຫັດປະຈຳຕົວລາຍວິຊາ';
$string['privacy:metadata:backup_controllers:operation'] = 'ການດໍາເນີນງານທີ່ໄດ້ປະຕິບັດ, ເຊັ່ນ: ກູ້ຄືນ.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'ເວລາເມື່ອການປະຕິບັດຖືກສ້າງ';
$string['privacy:metadata:backup_controllers:timemodified'] = 'ເວລາເມື່ອການປະຕິບັດຖືກດັດແປງ';
$string['privacy:metadata:backup_controllers:type'] = 'ປະເພດຂຶງລາຍການທີ່ຖືກປະຕິບັດເທິງ, ເຊັ່ນ: ກິດຈະກຳ.';
$string['qcategory2coursefallback'] = 'ປະເພດຄຳຖາມ "{$a->name}", ເດີມຢູ່ໃນບໍລິບົດໝວດໝູ່ຂອງລະບົບ/ລາຍວິຊາໃນໄຟລ໌ສຳຮອງຂໍ້ມູນ, ຈະຖືກສ້າງຂື້ນໃນບໍລິບົດລາຍວິຊາໂດຍການຟື້ນຟູ';
$string['qcategorycannotberestored'] = 'ປະເພດຄຳຖາມ "{$a->name}" ບໍ່ສາມາດຖືກສ້າງໂດຍການກູ້ຄືນ';
$string['question2coursefallback'] = 'ປະເພດຄຳຖາມ "{$a->name}", ເດີມຢູ່ໃນບໍລິບົດປະເພດຂອງລະບົບ/ລາຍວິຊາໃນໄຟລ໌ສຳຮອງຂໍ້ມູນ, ຈະຖືກສ້າງຂື້ນໃນບໍລິບົດລາຍວິຊາໂດຍການກູ້ຄືນ';
$string['questioncannotberestored'] = 'ຄຳຖາມ "{$a->name}" ບໍ່ສາມາດຖືກສ້າງໂດຍການກູ້ຄືນ';
$string['recyclebin_desc'] = 'ກະລຸນາສັງເກດວ່າການຕັ້ງຄ່າເຫຼົ່ານີ້ຈະຍັງຖືກນຳໃຊ້ສຳລັບຖັງຂີ້ເຫຍື້ອກັບມາໃຊ້ຄືນໃໝ່.';
$string['replacerestoredefaults'] = 'ກູ້ຄືນຄ່າເລີ່ມຕົ້ນເມື່ອການຟື້ນຟູເຂົ້າໄປໃນລາຍວິຊາອື່ນທີ່ລຶບເນື້ອຫາ';
$string['restoreactivity'] = 'ກູ້ຄືນກິດຈະກຳ';
$string['restorecourse'] = 'ກູ້ຄືນລາຍວິຊາ';
$string['restorecoursesettings'] = 'ການຕັ້ງຄ່າລາຍວິຊາ';
$string['restoredcourseid'] = 'ກູ້ຄືນລະຫັດປະຈຳຕົວລາຍວິຊາ: {$a}';
$string['restoreexecutionsuccess'] = 'ລາຍວິຊາໄດ້ຖືກຟື້ນຟູຢ່າງສໍາເລັດຜົນ, ການຄລິກໃສ່ປຸ່ມສືບຕໍ່ຂ້າງລຸ່ມນີ້ ຈະນໍາທ່ານເຂົ້າໄປເບິ່ງລາຍວິຊາທີ່ທ່ານໄດ້ກູ້ຄືນ.';
$string['restorefileweremissing'] = 'ບໍ່ສາມາດກູ້ຄືນບາງໄຟລ໌ໄດ້ເນື່ອງຈາກມັນຂາດຢູ່ໃນການສຳຮອງຂໍ້ມູນ.';
$string['restorenewcoursefullname'] = 'ຊື່ລາຍວິຊາໃໝ່';
$string['restorenewcourseshortname'] = 'ຊື່ສັ້ນລາຍວິຊາໃໝ່';
$string['restorenewcoursestartdate'] = 'ວັນທີ່ເລີ່ມຕົ້ນໃໝ່';
$string['restorerolemappings'] = 'ກູ້ຄືນການສ້າງແຜນທີ່ໜ້າທີ່';
$string['restorerootsettings'] = 'ການຕັ້ງຄ່າກູ້ຄືນ';
$string['restoresection'] = 'ພາກສ່ວນການກູ້ຄືນ';
$string['restorestage1'] = 'ຢືນຢັນ';
$string['restorestage16'] = 'ການທົບທວນຄືນ';
$string['restorestage16action'] = 'ກູ້ຄືນການປະຕິບັດ';
$string['restorestage1action'] = 'ຕໍ່ໄປ';
$string['restorestage2'] = 'ຈຸດໝາຍປາຍທາງ';
$string['restorestage2action'] = 'ຕໍ່ໄປ';
$string['restorestage32'] = 'ຂັ້ນຕອນ';
$string['restorestage32action'] = 'ສືບຕໍ່';
$string['restorestage4'] = 'ການຄັ້ງຄ່າ';
$string['restorestage4action'] = 'ຕໍ່ໄປ';
$string['restorestage64'] = 'ສຳເລັດ';
$string['restorestage64action'] = 'ສືບຕໍ່';
$string['restorestage8'] = 'Schema';
$string['restorestage8action'] = 'ຕໍ່ໄປ';
$string['restoretarget'] = 'ເປົ້າໝາຍກູ້ຄືນ';
$string['restoretocourse'] = 'ກູ້ຄືນຫາລາຍວິຊາ';
$string['restoretocurrentcourse'] = 'ກູ້ຄືນໄປໃນລາຍວິຊານີ້';
$string['restoretocurrentcourseadding'] = 'ຮວບລາຍວິຊາສຳຮອງເຂົ້າໃນລາຍວິຊານີ້';
$string['restoretocurrentcoursedeleting'] = 'ລຶບເນື້ອຫາຂອງລາຍວິຊານີ້ ແລະ ຫຼັງຈາກນັ້ນກູ້ຄືນ';
$string['restoretoexistingcourse'] = 'ກູ້ຄືນເຂົ້າໃນລາຍວິຊາທີ່ມີຢູ່ແລ້ວ';
$string['restoretoexistingcourseadding'] = 'ຮວບລາຍວິຊາສຳຮອງເຂົ້າໃນລາຍວິຊາທີ່ມີຢູ່ແລ້ວ';
$string['restoretoexistingcoursedeleting'] = 'ລຶບເນື້ອໃນຂອງລາຍວິຊາທີ່ມີຢູ່ແລ້ວ ແລະ ຫຼັງຈາກນັ້ນກູ້ຄືນ';
$string['restoretonewcourse'] = 'ກູ້ຄືນເປັນລາຍວິຊາໃໝ່';
$string['restoringcourse'] = 'ກຳລັງດຳເນີນການກູ້ຄືນລາຍວິຊາ';
$string['restoringcourseshortname'] = 'ການກູ້ຄືນ';
$string['rootenrolmanual'] = 'ກູ້ຄືນເປັນການລົງທະບຽນຮຽນດ້ວຕົວເອງ';
$string['rootsettingactivities'] = 'ລວມທັງກິດຈະກຳ ແລະ ແຫຼ່ງຂໍ້ມູນ';
$string['rootsettinganonymize'] = 'ເຮັດໃຫ້ຂໍ້ມູນຜູ້ໃຊ້ບໍ່ເປີດເຜີຍ';
$string['rootsettingbadges'] = 'ລວມທັງປ້າຍ';
$string['rootsettingblocks'] = 'ລວມທັງບລັອກ';
$string['rootsettingcalendarevents'] = 'ລວມທັງນັດໝາຍປະຕິທິນ';
$string['rootsettingcomments'] = 'ລວມທັງຄຳເຫັນ';
$string['rootsettingcompetencies'] = 'ລວມທັງຄວາມສາມາດ';
$string['rootsettingcontentbankcontent'] = 'ລວມທັງເນື້ອຫາທະນາຄານເນື້ອຫາ';
$string['rootsettingcustomfield'] = 'ລວມທັງຊ່ອງຂໍ້ມູນປັບແຕ່ງເອງ';
$string['rootsettingenrolments'] = 'ລວມທັງວິທີການລົງທະບຽນຮຽນ';
$string['rootsettingenrolments_always'] = 'ແມ່ນແລ້ວ, ສະເໝີ';
$string['rootsettingenrolments_never'] = 'ບໍ່, ກູ້ຄືນຜູ້ໃຊ້ເປັນການລົງທະບຽນຮຽນດ້ວຍຕົນເອງ';
$string['rootsettingenrolments_withusers'] = 'ແມ່ນແລ້ວ, ແຕ່ວ່າພຽງແຕ່ຖ້າຜູ້ໃຊ້ຖືກລວມເຂົ້າ';
$string['rootsettingfiles'] = 'ລວມທັງໄຟລ໌';
$string['rootsettingfilters'] = 'ລວມທັງໄຟລ໌';
$string['rootsettinggradehistories'] = 'ລວມທັງປະຫວັດຄະແນນ';
$string['rootsettinggroups'] = 'ລວມທັງກຸ່ມ ແລະ ການຈັດກຸ່ມ';
$string['rootsettingimscc1'] = 'ປ່ຽນເປັນ IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'ປ່ຽນເປັນ IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'ລວມທັງໄຟລ໌ລາຍວິຊາເກົ່າ';
$string['rootsettinglogs'] = 'ລວມທັງບັນທຶກລາຍວິຊາ';
$string['rootsettingpermissions'] = 'ລວມທັງການລົບລ້າງການອະນຸຍາດ';
$string['rootsettingquestionbank'] = 'ລວມທັງທະນາຄານຄຳຖາມ';
$string['rootsettingroleassignments'] = 'ລວມທັງການແຕ່ງຕັ້ງໜ້າທີ່ຜູ້ໃຊ້';
$string['rootsettings'] = 'ການຕັ້ງຄ່າການສຳຮອງຂໍ້ມູນ';
$string['rootsettingusers'] = 'ລວມທັງຜູ້ໃຊ້ທີ່ລົງທະບຽນຮຽນ';
$string['rootsettinguserscompletion'] = 'ລວມທັງລາຍລະອຽດການສໍາເລັດຂອງຜູ້ໃຊ້';
$string['samesitenotification'] = 'ການສຳຮອງຂໍ້ມູນນີ້ຖືກສ້າງຂື້ນດ້ວຍການອ້າງອີງເຖິງໄຟລ໌ເທົ່ານັ້ນ, ບໍ່ແມ່ນໄຟລ໌ເອງ. ການຟື້ນຟູຈະເຮັດວຽກຢູ່ໃນເວັບໄຊທ໌ນີ້ເທົ່ານັ້ນ.';
$string['sectionactivities'] = 'ກິດຈະກຳ';
$string['sectioninc'] = 'ລວມທັງໃນການສຳຮອງຂໍ້ມູນ (ບໍ່ມີຂໍ້ມູນຜູ້ໃຊ້)';
$string['sectionincanduser'] = 'ລວມຢູ່ໃນການສໍາຮອງຂໍ້ມູນພ້ອມກັບຂໍ້ມູນຜູ້ໃຊ້';
$string['selectacategory'] = 'ເລືອກປະເພດ';
$string['selectacourse'] = 'ເລືອກລາຍວິຊາ';
$string['setting_course_fullname'] = 'ຊື່ລາຍວິຊາ';
$string['setting_course_shortname'] = 'ຊື່ສັ້ນລາຍວິຊາ';
$string['setting_course_startdate'] = 'ວັນທີ່ເລີ່ມຕົ້ນລາຍວິຊາ';
$string['setting_keep_groups_and_groupings'] = 'ຮັກສາກຸ່ມ ແລະ ການຈັດກຸ່ມປະຈຸບັນ';
$string['setting_keep_roles_and_enrolments'] = 'ຮັກສາໜ້າທີ່ ແລະ ການລົງທະບຽນຮຽນປະຈຸບັນ';
$string['setting_overwrite_conf'] = 'ຂຽນທັບການກຳນົດຄ່າລາຍວິຊາ';
$string['setting_overwrite_course_fullname'] = 'ຂຽນທັບຊື່ເຕັມລາຍວິຊາ';
$string['setting_overwrite_course_shortname'] = 'ຂຽນທັບຊື່ສັ້ນລາຍວິຊາ';
$string['setting_overwrite_course_startdate'] = 'ຂຽນທັບວັນທີ່ເລີ່ມຕົ້ນລາຍວິຊາ';
$string['showtypes'] = 'ສະແດງປະເພດທາງເລືອກ';
$string['sitecourseformatwarning'] = 'ນີ້ແມ່ນການສໍາຮອງຂໍ້ມູນໜ້າຫຼັກເວັບໄຊທ໌. ມັນພຽງແຕ່ສາມາດໄດ້ຮັບການຟື້ນຟູຢູ່ໃນໜ້າຫຼັກເວັບໄຊທ໌.';
$string['skiphidden'] = 'ຂ້າມລາຍວິຊາທີ່ເຊື່ອງໄວ້';
$string['skiphiddenhelp'] = 'ເລືອກບໍ່ວ່າຈະ ຫຼື ບໍ່ຂ້າມລາຍວິຊາທີ່ເຊື່ອງໄວ້';
$string['skipmodifdays'] = 'ຂ້າມລາຍວິຊາທີ່ບໍ່ໄດ້ແກ້ໄຂຕັ້ງແຕ່ນັ້ນມາ';
$string['skipmodifdayshelp'] = 'ເລືອກທີ່ຈະຂ້າມລາຍວິຊາທີ່ບໍ່ໄດ້ຮັບການດັດແກ້ນັບຕັ້ງແຕ່ຈໍານວນມື້';
$string['skipmodifprev'] = 'ຂ້າມລາຍວິຊາທີ່ບໍ່ໄດ້ດັດແກ້ນັບຕັ້ງແຕ່ການສໍາຮອງຂໍ້ມູນທີ່ຜ່ານມາ';
$string['skipmodifprevhelp'] = 'ເລືອກວ່າຈະຂ້າມລາຍວິຊາທີ່ບໍ່ໄດ້ແກ້ໄຂຕັ້ງແຕ່ການສຳຮອງຂໍ້ມູນອັດຕະໂນມັດຄັ້ງສຸດທ້າຍຫຼືບໍ່. ສິ່ງນີ້ຮຽກຮ້ອງໃຫ້ມີການເຂົ້າສູ່ລະບົບເພື່ອເປີດໃຊ້ງານ.';
$string['status'] = 'ສະຖານະ';
$string['storagecourseandexternal'] = 'filearea ສຳຮອງຂອງລາຍວິຊາ ແລະ ລາຍການທີ່ລະບຸໄວ້';
$string['storagecourseonly'] = 'filearea ສຳຮອງຂອງລາຍວິຊາ';
$string['storageexternalonly'] = 'ລາຍການທີ່ລະບຸໄວ້ສໍາລັບການສໍາຮອງຂໍ້ມູນອັດຕະໂນມັດ';
$string['successful'] = 'ການສຳຮອງຂໍ້ມູນສຳເລັດ';
$string['successfulcopy'] = 'ການສຳເນົາສຳເລັດ';
$string['successfulrestore'] = 'ການກູ້ຄືນສຳເລັດ';
$string['timetaken'] = 'ເວລາປະຕິບັດ';
$string['title'] = 'ຫົວຂໍ້';
$string['totalcategorysearchresults'] = 'ລວມທັງໝົດລາຍການ: {$a}';
$string['totalcoursesearchresults'] = 'ລວມທັງໝົດລາຍວິຊາ: {$a}';
$string['undefinedrolemapping'] = 'ການສ້າງແຜນທີ່ບົດບາດບໍ່ໄດ້ກໍານົດສໍາລັບ \'{$a}\' archetype.';
$string['unnamedsection'] = 'ພາກສ່ວນບໍ່ໄດ້ຕັ້ງຊື່';
$string['userdata'] = 'ລວມທັງຂໍ້ມູນຜູ້ໃຊ້';
$string['userdata_help'] = 'ຖ້າເປີດໃຊ້, ຂໍ້ມູນເຊັ່ນ: ກະດານສົນທະນາ, ການສົ່ງມອບວຽກ ແລະ ອື່ນໆ ຈະຖືກຄັດລອກໃສ່ໃນລາຍວິຊາໃໝ່ສຳລັບຜູ້ໃຊ້ທີ່ມີໜ້າທີ່ເລືອກໃນ \'ຮວມໜ້າທີ່ການລົງທະບຽນຮຽນ\'.';
$string['userinfo'] = 'Userinfo';
